<?php
function displayIndex()
{
    global $neConfig, $neDb, $neTheme, $neSession, $neModuleName;

    $strQuery = 'SELECT * FROM '.$neConfig['db']['prefix'].'_gallery_albums';
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);

    $neTheme->drawTitle(neTranslate('gallery') );
    $tpl = $neTheme->getTemplate('gallery','gallery_index.tpl');
    $keywords = '';
    while($album = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
        $keywords .= strtolower($album['album_title']).',';
        $tpl->setCurrentBlock('album');
        $tpl->setVariable(array(
        'ALBUM_LINK' => MODULE_LOADER.'?mod=gallery&amp;op=show_album&amp;name='.$album['album_name'],
        'ALBUM_NAME' => $album['album_name'],
        'ALBUM_TITLE' => $album['album_title'],
        'ALBUM_DESCRIPTION' => $album['album_description'],
        'ALBUM_IMAGE' => $neTheme->getImageSrc($album['album_name'],DATA_PATH.'gallery/albums/')
        ));
        
        //SHOW THE ADMIN_LINKS
        if ($neSession->isAdmin($neModuleName) ) {
             $tpl->setVariable(array(
            'EDIT_LINK' => getEditAlbumLink($album['album_name']),
            'ADD_LINK' => getAddImagesLink($album['album_name'])
            ));
        }  
        $tpl->parse('album');
    }

	//Show the waiting Images
    if ($neSession->isAdmin('gallery') ) {
		$numWaiting = $result->numRows();
        $tpl->setCurrentBlock('admin');
        $tpl->setVariable(array(
		   'LABEL_IMAGES_WAITING' => neTranslate('images_waiting'),
			'IMAGES_WAITING' => '<a href="'.MODULE_LOADER.'?mod=news">'
                                  .$numWaiting.'</a>',
			'ADD_ALBUM_LINK' => '<a href="'.MODULE_LOADER.'?mod=gallery&amp;op=add_album">'
			                 .neTranslate('add_album').'</a>'
		));
	}
    $tpl->show();
    $neTheme->drawSite('gallery', array('keywords' => $keywords));
}
?>