<?php

function adminNews()
{
    global $neConfig, $neDb, $neTheme, $neSession, $neModuleName;
    $tpl = $neTheme->getTemplate($neModuleName,'news_admin.tpl');

    /* Build the database Query for the waiting News*/
    $strQuery  = 'SELECT article_id, topic_title,user_name,';
    $strQuery .= 'article_created,article_title ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_news, ';
    $strQuery .= $neConfig['db']['prefix']."_topics, ";
    $strQuery .= $neConfig['db']['prefix']."_users ";
    $strQuery .= 'WHERE topic_id = article_topic ';
    $strQuery .= "AND user_id = article_author ";
    $strQuery .= "AND article_waiting = '1' ";
    $strQuery .='ORDER BY article_id DESC';

    /* Fetch the waiting news */
    $newsWaiting = $neDb->query($strQuery);
    neGetDbError($newsWaiting,__LINE__,__FILE__,$strQuery);
    $tpl->setCurrentBlock('waitingevents');
    $tpl->setVariable(array(
        'LABEL_WAITING_NEWS' => neTranslate('news_waiting'),
        'TEXT_NEWS_WAITING' => neTranslate('text-news_waiting'),
        'LABEL_TITLE' => neTranslate('title'),
        'LABEL_TOPIC' => neTranslate('topic'),
        'LABEL_CREATED' => neTranslate('created'),
        'LABEL_AUTHOR' => neTranslate('author'),
        'LABEL_FUNCTIONS' => neTranslate('functions'),
        'LABEL_NEW_ARTICLE' => neTranslate('new_article'),
        'LINK_NEW_ARTICLE' => 'admin.php?mod=news&amp;op=new'
    ));
    if ( $newsWaiting->numRows() > 0 ) {
	    $tpl->setCurrentBlock('waitingnewsitem');
        while ($newsWaiting->fetchInto($news,DB_FETCHMODE_ASSOC)) {
            $news['edit']  = '<a href="admin.php?mod=news&amp;op=edit_article&amp;id=';
            $news['edit'] .= $news['article_id'].'">';
            $news['edit'] .= $neTheme->getImage('edit',neTranslate('edit'));
            $news['edit'] .= '</a>';
            $news['edit_links']  = '<a href="admin.php?mod=news&amp;op=edit_links&amp;id=';
            $news['edit_links'] .= $news['article_id'].'">';
            $news['edit_links'] .= $neTheme->getImage('link',neTranslate('edit_links'));
            $news['edit_links'] .= '</a>';
            $news['delete']  = '<a href="admin.php?mod=news&amp;op=delete_article&amp;';
            $news['delete'] .= 'id='.$news['article_id'].'">';
            $news['delete'] .= $neTheme->getImage('delete','delete');
            $news['delete'] .= '</a>';
            $tpl->setVariable(array(
                'TITLE' =>  $news['article_title'],
                'TOPIC_TITLE' =>  $news['topic_title'],
                'CREATED' => neFormatTimestamp($news['article_created'],'date'),     
				'AUTHOR' => $news['user_name'],
				'EDIT_LINK' => 'admin.php?mod=news&amp;op=edit_article&amp;id='.$news['article_id'],
                'EDIT' => $news['edit'],
                'EDIT_LINKS' => $news['edit_links'],
                'DELETE' => $news['delete'],
            ));
	        $tpl->parse('waitingnewsitem');
        }
    } else {
        $tpl->setVariable(array(
	    'LABEL_WAITING_NEWS' => neTranslate('news_waiting'),
	    'TEXT_NEWS_WAITING' => neTranslate('text-news_waiting'),
	    'TEXT_NO_NEWS_WAITING' => neTranslate('text-no_news_waiting')
	));
    }
    $newsWaiting->free();

    /* Build the database Query for the last News*/
    $strQuery  = 'SELECT article_id, topic_title,user_name,';
    $strQuery .= 'article_created,article_title ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_news, ';
    $strQuery .= $neConfig['db']['prefix']."_topics, ";
    $strQuery .= $neConfig['db']['prefix']."_users ";
    $strQuery .= 'WHERE topic_id = article_topic ';
    $strQuery .= "AND user_id = article_author ";
    $strQuery .= "AND article_waiting = '0' ";
    $strQuery .='ORDER BY article_created DESC LIMIT 10';

    /* Fetch the last news */
    $newsWaiting = $neDb->query($strQuery);
    neGetDbError($newsWaiting,__LINE__,__FILE__,$strQuery);
    $tpl->setCurrentBlock('lastnews');
    $tpl->setVariable(array(
        'LABEL_LAST_NEWS' => neTranslate('last_news'),
        'TEXT_LAST_NEWS' => neTranslate('text-last_news'),
        'LABEL_TITLE' => neTranslate('title'),
        'LABEL_TOPIC' => neTranslate('topic'),
        'LABEL_CREATED' => neTranslate('created'),
        'LABEL_AUTHOR' => neTranslate('author'),
        'LABEL_FUNCTIONS' => neTranslate('functions'),
        'LABEL_NEW_ARTICLE' => neTranslate('new_article'),
        'LINK_NEW_ARTICLE' => 'admin.php?mod=news&amp;op=new'
    ));
    $tpl->setCurrentBlock('lastnewsitem');
    while ($newsWaiting->fetchInto($news,DB_FETCHMODE_ASSOC) ) {
        $news['edit']  = '<a href="admin.php?mod=news&amp;op=edit_article&amp;';
		$news['edit'] .= 'id='.$news['article_id'].'">';
        $news['edit'] .= $neTheme->getImage('edit',neTranslate('edit'));
        $news['edit'] .= '</a>';
        $news['edit_links']  = '<a href="admin.php?mod=news&amp;op=edit_links&amp;';
		$news['edit_links'] .= 'id='.$news['article_id'].'">';
        $news['edit_links'] .= $neTheme->getImage('link',neTranslate('edit'));
        $news['edit_links'] .= '</a>';
        $news['delete']  = '<a href="admin.php?mod=news&amp;op=delete&amp;';
		$news['delete'] .= 'id='.$news['article_id'].'" ';
        $news['delete'] .= $neTheme->getImage('delete',neTranslate('delete'));
        $news['delete'] .= '</a>';
		$tpl->setVariable(array(
	        'ARTICLE_ID' => $news['article_id'],
	        'TITLE' => $news['article_title'],
        	'TOPIC_TITLE' => $news['topic_title'],
        	'AUTHOR' => $news['user_name'],
	    	'CREATED' => neFormatTimestamp($news['article_created'],'date'),
			'EDIT_LINK' => 'admin.php?mod=news&amp;op=edit_article&amp;id='.$news['article_id'],
        	'EDIT' => $news['edit'],
        	'EDIT_LINKS' => $news['edit_links'],
			'DELETE' => $news['delete']
	    ));
        $tpl->parse('lastnewsitem');
    }
    $tpl->touchBlock('lastnews');
    $newsWaiting->free();
    $tpl->show();
    $neTheme->drawSite(neTranslate('admin news',1));
}

/**
* deletes an Article
*/
function deleteArticle($intId)
{
    global $neConfig, $neDb, $neTheme;
    echo "$intId will gelöscht werden";
    $strQuery  = 'DELETE FROM '.$neConfig['db']['prefix'].'_news ';
    $strQuery .= 'WHERE article_id='.$neDb->quote($intId);
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
}

/**
* deletes an Article
*/
function showDeleteQuestion($intId)
{
    global $neConfig, $neDb, $neTheme,$neModuleName;
    $strMessage = '<form method="post" action="admin.php">';
    $strMessage .= '<input type="hidden" name="mod" value="'.$neModuleName.'" />';
    $strMessage .= '<input type="hidden" name="op" value="delete_article" />';
    $strMessage .= '<input type="hidden" name="article_id" value="'.$intId.'" />';
    $strMessage .= '<input type="hidden" name="confirm" value="1" />';
    $strMessage .= '<p>'.neTranslate('text-really_delete').': ';
    $strMessage .= $intId.'</p>';
    $strMessage .= '<div style="text-align:right">';
	$strMessage .= '<input type="button" value="'.neTranslate('back').'" onclick="history.back()"/>';
	$strMessage .= '<input type="submit" value="'.neTranslate('delete').'" />';
	$strMessage .= '</div></form>';
    $neTheme->drawTitle(neTranslate('delete_article'));
    $neTheme->drawDialogbox(neTranslate('delete_article'),$strMessage);
    $neTheme->drawSite(neTranslate('delete'));
}


/**
* Activates an waiting Article
*/
function activateArticle($intId)
{
    global $neConfig, $neDbWrite;
    $intId = $neDbWrite->quote((int)$intId);
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_news ';
    $strQuery .= 'SET article_waiting=\'0\' ';
    $strQuery .= "WHERE article_id=$intId";
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
}

/**
* Deactivates an Article
*/
function deactivateArticle($intId)
{
    global $neConfig, $neDb;
    $intId = $neDb->quote($intId);
    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_news ';
    $strQuery .= 'SET article_waiting=\'1\' ';
    $strQuery .= "WHERE article_id=$intId";
    $result = $neDb->query($strQuery);
     neGetDbError($result,__LINE__,__FILE__,$strQuery);
}

/**
* Saves the changes of the Article to the Database.
*/
function submitEditArticle($arrFormdata) {
    global $neDb,$neConfig;
    $arrSubmitdata['article_id'] = (int) $arrFormdata['article_id'];
    $arrSubmitdata['article_title'] = $neDb->quote(neCheckText($arrFormdata['article_title'],'plain'));
    $arrSubmitdata['article_author'] = $neDb->quote($arrFormdata['article_author']);
    $arrSubmitdata['article_topic'] = $neDb->quote($arrFormdata['article_topic']);
    $arrSubmitdata['article_summary'] = $neDb->quote($arrFormdata['article_summary']);
    $arrSubmitdata['article_detail'] = $neDb->quote($arrFormdata['article_detail']);
    $arrSubmitdata['article_top'] = $neDb->quote($arrFormdata['article_top']);

    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_news ';
    $strQuery .= 'SET ';
    $strQuery .= "article_title=$arrSubmitdata[article_title], ";
    $strQuery .= "article_author=$arrSubmitdata[article_author],";
    $strQuery .= "article_topic=$arrSubmitdata[article_topic],";
    $strQuery .= "article_summary=$arrSubmitdata[article_summary],";
    $strQuery .= "article_top=$arrSubmitdata[article_top],";
    $strQuery .= "article_detail=$arrSubmitdata[article_detail] ";
    $strQuery .= "WHERE article_id=$arrSubmitdata[article_id]";
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    if (isset($_FILES['small_image']['name'])) {
        uploadSmallImage($arrFormdata['article_id'],$_FILES['small_image']);
    }
    if (isset($_FILES['big_image']['name'])) {
        uploadBigImage($arrFormdata['article_id'],$_FILES['big_image']);
    }
}

?>
