<?php
/**
* Draws a selectbox with the submitmodes for an article.
*/
function getOpSelect($strMode) {
    $strOp = '<option value="preview">'.neTranslate('preview').'</option>';
    if ($strMode == 'edit') {
       $strOp .= '<option value="submit_edit">'.neTranslate('edit').'</option>';
       $strOp .= '<option value="activate_article">'.neTranslate('activate').'</option>';
       $strOp .= '<option value="deactivate_article">'.neTranslate('deactivate').'</option>';
    } else {
        $strOp .= '<option value="submit_add">'.neTranslate('submit').'</option>';
    }
    return $strOp;
}

/**
 * Display the Article Text
 */
function drawArticle($arrData){
    global $neModuleName, $neTheme ,$neConfig, $neDb, $neSession;
    $tpl = $neTheme->getTemplate($neModuleName,'news_article.tpl');

    /* set the article data */
    $tpl->setVariable( array(
    'ARTICLE_ID'  => (int) $arrData['article_id'],
    'AUTHOR'      => neFormatText($arrData['user_name'],'plain'),
    'CREATED'     => neFormatTimestamp($arrData['article_created'],'date'),
    'TITLE'       => neFormatText($arrData['article_title'],'plain'),
    'ABSTRACT'    => neFormatText($arrData['article_summary'],'plain'),
    'TEXT'        => neFormatText($arrData['article_detail'],'html'),
    'TOPIC_ID'    => (int) $arrData['topic_id'],
    'TOPIC_NAME'  => neFormatText($arrData['topic_name'],'plain'),
    'TOPIC_TITLE' => neFormatText($arrData['topic_title'],'plain'),
    'IMAGE'       => getSmallImage($arrData['article_id'],$arrData['topic_name']),
    'BIG_IMAGE'   => getBigImage($arrData['article_id'],$arrData['topic_name'])
    ));

   
    // Parse Topiclinks  
    $strQuery  = 'SELECT link_title, link_url ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_news_links ';
    $strQuery .= "WHERE article_id = '$arrData[article_id]' ";
    $newslinks = $neDb->query($strQuery);
    negetDbError($newslinks,__LINE__,__FILE__,$strQuery);
    if ( $newslinks->numRows() > 0) {    
        $tpl->setVariable( 'LABEL_RELATED_LINKS',neTranslate('related_links'));
        $tpl->setCurrentBlock('news_link');
        while ($newslinks->fetchInto($link,DB_FETCHMODE_ASSOC) ){
            $tpl->setVariable('LINK_URL',$link['link_url']);
            $tpl->setVariable('LINK_NAME',$link['link_title']);
            $tpl->parse('news_link');
        }
    }

    /* Parse Topiclinks */  
    $strQuery  = 'SELECT link_title, link_url ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_topics_links ';
    $strQuery .= "WHERE topic_id = '$arrData[topic_id]' ";
    $topiclinks = $neDb->query($strQuery);
    negetDbError($topiclinks,__LINE__,__FILE__,$strQuery);
    if ( $topiclinks->numRows() > 0) {    
        $tpl->setVariable( 'LABEL_RELATED_LINKS',neTranslate('related_links'));
        $tpl->setCurrentBlock('topic_link');
        while ($topiclinks->fetchInto($link,DB_FETCHMODE_ASSOC) ){
            $tpl->setVariable('LINK_URL',$link['link_url']);
            $tpl->setVariable('LINK_NAME',$link['link_title']);
            $tpl->parse('topic_link');
        }
    }

    //show comments if activated
    if ($neConfig['news']['allow_user_comments']) {
        include_once('modules/comments/comments_functions.php');
        $tpl->setVariable('COMMENTS',showComments(
            $neConfig['db']['prefix'].'_news_comments',
            $arrData['article_id'],
             MODULE_LOADER.'?mod=news&op=show_article&id='.$arrData['article_id']
         ));
    }
    
    /* Show the Admin Functions. */ 
    if ( $neSession->isAdmin('news') ) {
        $tpl->setVariable(array(
		'DELETE_LINK' => '<a href="'.MODULE_LOADER.'?mod=news&amp;op=delete_article&amp;id='.$arrData['article_id'].'">'.$neTheme->getImage('delete',neTranslate('delete')).'</a>',
		'EDIT_LINK' => '<a href="'.MODULE_LOADER.'?mod=news&amp;op=edit_article&amp;id='.$arrData['article_id'].'">'.
                      $neTheme->getImage('edit',neTranslate('edit')).'</a> ',
		'EDIT_LINKS_LINK' => '<a href="'.MODULE_LOADER.'?mod=news&amp;op=edit_links&amp;id='.$arrData['article_id'].'">'.$neTheme->getImage('link',neTranslate('edit_links')).'</a> '
        ));
    }   
    unset($article,$arrData);
    $tpl->show();
    return true;
}

function showArticle($intStoryId){
    global $neDb, $neConfig, $neTheme, $neModuleName, $neSession;
    $strQuery  = 'SELECT  * ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_news,';
    $strQuery .= $neConfig['db']['prefix'].'_topics, ';
    $strQuery .= $neConfig['db']['prefix'].'_users ';
    $strQuery .= "WHERE article_id = '$intStoryId' ";
    $strQuery .= 'AND user_id = article_author ';
    $strQuery .= 'AND topic_id = article_topic ';
    if (!$neSession->isAdmin($neModuleName)) {
        $strQuery .= 'AND article_waiting = 0 ';
    }
    $strQuery .= 'LIMIT 1';
    $arrData = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($arrData,__LINE__,__FILE__,$strQuery);
    if (is_array($arrData)) {
        drawArticle($arrData);
    } else {
        $neTheme->drawErrorpage(neTranslate('article_not_found'),neTranslate('text-article_not_found'));
    }        
    $neTheme->drawSite();
}

function submitNewArticle($arrFormdata) {
    global $neDb, $neDbWrite,$neConfig,$neTheme,$neSession;
    if (empty($arrFormdata['article_id'])) {
        $arrFormdata['article_id'] = time();
    }
    $arrSubmitdata['article_id'] = time();
    $arrSubmitdata['article_topic'] = (int) $arrFormdata['article_topic'];
    $arrSubmitdata['article_title'] = $neDb->quote(neCheckText($arrFormdata['article_title']));
    $arrSubmitdata['article_author'] = $neDb->quote($arrFormdata['article_author']);
    $arrSubmitdata['article_summary'] = $neDb->quote(neChecktext($arrFormdata['article_summary'],'plain'));
    $arrSubmitdata['article_detail'] = $neDb->quote(neChecktext($arrFormdata['article_detail'],'html'));
    $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_news ';
    $strQuery .= '(article_id,article_title,article_author,article_topic,article_summary,article_detail,article_created) ';
    $strQuery .= 'VALUES(';
    $strQuery .= "$arrSubmitdata[article_id],";
    $strQuery .= "$arrSubmitdata[article_title],";
    $strQuery .= "$arrSubmitdata[article_author],";
    $strQuery .= "$arrSubmitdata[article_topic],";
    $strQuery .= "$arrSubmitdata[article_summary],";
    $strQuery .= "$arrSubmitdata[article_detail],";
    $strQuery .= 'NOW()';
    $strQuery .= ')';
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    if ($neSession->isAdmin('news')) {
        activateArticle($arrSubmitdata['article_id']);
    } 
	neRedirect('admin.php?mod=news&op=show_article&id='.$arrSubmitdata['article_id']);
}


function editArticle($intId){
    global $neConfig,$neDb, $neTheme;
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_news, ';
    $strQuery .= $neConfig['db']['prefix'].'_users, ';
    $strQuery .= $neConfig['db']['prefix']."_topics ";
    $strQuery .= 'WHERE article_id = '.$intId.' ';
    $strQuery .= 'AND topic_id = article_topic ';
    $strQuery .= 'AND user_id = article_author ';
    $arrFormdata = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($arrFormdata,__LINE__,__FILE__,$strQuery);
    drawEditForm($arrFormdata,'edit');
    $neTheme->drawSite( neTranslate('edit_article') );
}

function newArticle() {
    global $neSession,$neOp, $neTheme;
    $arrFormdata=array(
        'article_author' => $neSession->getId(),
        'op' => $neOp,
        'article_id' => time(),
        'article_title' => '',
        'article_summary' => '',
        'article_detail' => '',
        'article_topic' => 0,
        'article_top' => 0
    );
    $neTheme->drawTitle(neTranslate('new_article'));
    drawEditForm($arrFormdata);
    $neTheme->drawSite(neTranslate('new_article'));
}

function previewArticle($arrFormdata) {
    global $neSession,$neOp, $neTheme;
    if (isset($_FILES['small_image']['name']) and $arrFormdata['article_id'] != null) {
        uploadSmallImage($arrFormdata['article_id'],$_FILES['small_image']);
    }
    if (isset($_FILES['big_image']['name'])  and $arrFormdata['article_id'] != null) {
        uploadBigImage($arrFormdata['article_id'],$_FILES['big_image']);
    }
    $neTheme->drawTitle(neTranslate('preview'));
    drawArticle($arrFormdata);
    drawEditForm($arrFormdata,$arrFormdata['mode']);
    $neTheme->drawSite();
}
/**
* Draws the Form to edit oder add an Article
*/
function drawEditForm($arrFormdata,$strMode='add')
{
    global $neModuleName, $neSession, $neTheme, $neOp;
    $tpl=$neTheme->getTemplate('news','edit_form.tpl');
    $tpl->setVariable(array(
    'LABEL_EDIT_ARTICLE' => neTranslate('edit_article'),
    'LABEL_TITLE' => $neTheme->getHelpLink(
                   neTranslate('title'),
                   'news',
                   'news_submit',
                   'title'
                   ),
    'LABEL_TOP_ARTICLE' => $neTheme->getHelpLink(
                   neTranslate('top_article'),
                   'news',
                   'news_submit',
                   'top_article'
                   ),
    'LABEL_AUTHOR' => $neTheme->getHelpLink(
                   neTranslate('author'),
                   'news',
                   'news_submit',
                   'author'
                ),
    'LABEL_TOPIC' => $neTheme->getHelpLink(
                   neTranslate('topic'),
                   'news',
                   'news_submit',
                   'topic'
                   ),
    'LABEL_ABSTRACT' => $neTheme->getHelpLink(
                      neTranslate('abstract'),
                      $neModuleName,
                      'news_submit',
                      'abstract'
                  ),
    'LABEL_SMALL_IMAGE' => $neTheme->getHelpLink(
                      neTranslate('small_image'),
                      $neModuleName,
                      'news_submit',
                      'small_image'
                  ),
    'LABEL_BIG_IMAGE' => $neTheme->getHelpLink(
                                      neTranslate('big_image'),
                      $neModuleName,
                      'news_submit',
                      'big_image'
                  ),
    'LABEL_TEXT' => $neTheme->getHelpLink(
                                  neTranslate('text'),
                  $neModuleName,
                  'news_submit',
                  'text'
                              ),
    'MODULE' => neCheckText($neModuleName,'plain'),
    'MODE' => $strMode,
    'OP'   => getOpSelect($strMode),
    'ARTICLE_ID' => $arrFormdata['article_id'],
    'TITLE' => $arrFormdata['article_title'],
    'AUTHOR'=> $arrFormdata['article_author'],
    'AUTHOR_NAME' => $neTheme->getUserInfo($arrFormdata['article_author']),
    'TOPIC' => getTopicSelect($arrFormdata['article_topic']),
    'TOP_ARTICLE' => getTopArticleSelect($arrFormdata['article_top']),
    'EDIT_TOPICS_LINK' => '<a href="'.MODULE_LOADER.'?mod=topics">'
                          .$neTheme->getImage('edit',neTranslate('edit')).'</a>',
    'ABSTRACT' => neCheckText($arrFormdata['article_summary'],'plain'),
    'DETAIL' => $neTheme->getHtmlBox('article_detail',$arrFormdata['article_detail']),
    'SMALL_IMAGE'=> getSmallImage($arrFormdata['article_id'],$arrFormdata['topic_name']),
    'BIG_IMAGE' => getBigImage($arrFormdata['article_id'],$arrFormdata['topic_name'])
    ));
    $tpl->parse('form');
    $tpl->show();
}
?>
