<?php
/*==NukeEvent Portal System====================================================
Copyright 2002 by Christian Berg

Code based on PHP-NUKE Web Portal System Copyright (c) 2002 by
Francisco Burzi (fbc@mandrakesoft.com) http://phpnuke.org

This program is free software. You can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 or any higher Version
of the License.
==============================================================================*/

/**
* This is the config file to change some options related to the topics module
*
* @package nukeevent.modules.topics
* @author Christian Berg
* @version $Revision: 1.3 $
*/

/**
* Draw all Topics.
* Searches all active Topics from the Database and creates a Site 
* to display them.
*/
function drawTopics() {
    global $neConfig, $neDb, $neTheme;
    $strQuery  = "SELECT * ";
    $strQuery .= "FROM ".$neConfig['db']['prefix']."_topics ";
    $strQuery .= "ORDER BY topic_name";
    $result = $neDb->query($strQuery);
    neGetDbError($result, __LINE__, __FILE__, $strQuery);
    if ($result->numRows() == 0) {
        $neTheme->drawErrorPage(neTranslate('title-no_topics'), neTranslate('message-no_topics'));
    }
    //if there are some Topics:
    $neTheme->drawTitle(neTranslate('active_topics'));
    $tpl= $neTheme->getTemplate('topics', 'show_topics.tpl');
    while ($topic = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
        $tpl->setCurrentBlock('topic');
        $tpl->setVariable(array(
        'TOPIC_NAME' => $topic['topic_name'],
        'TOPIC_TITLE' => $topic['topic_title'],
        'TOPIC_DESCRIPTION'=> $topic['topic_description'],
	'TOPIC_LINK'=> 'index.php?mod=news&amp;topic='.$topic['topic_id'],
        'TOPIC_IMAGE_SRC' => $neTheme->getImageSrc('topics/'.$topic['topic_name'])
        ));
        $tpl->parse('topic');
    }
    $tpl->show();
    $neTheme -> drawSite(neTranslate('active_topics'));
}

//==Admin Functions============================================================

/**
* removes a Topic completly from the Database
*/
function deleteTopic($intTopicId) {
    global $neConfig, $neDbWrite;
    $strQuery= 'DELETE FROM '.$neConfig['db']['prefix'].'_topics ';
    $strQuery.= 'WHERE topic_id='.$neDbWrite->quote($intTopicId).' LIMIT 1';
    $result= $neDbWrite->query($strQuery);
    neGetDbError($result, __FILE__, __LINE__);
    neRedirect('admin.php?mod=topics&op=admin_topics');
}

/**
* submits the Changes of a Topic to the Database.
*/
function submitEdit($intId, $strName, $strTitle, $strDescription) {
    global $neConfig, $neDbWrite;
    submitImage($intId, $strName);
    $intId= $neDbWrite->quote($intId);
    $strName= $neDbWrite->quote($strName);
    $strTitle= $neDbWrite->quote($strTitle);
    $strDescription= $neDbWrite->quote($strDescription);
    $strTopicsTable= $neConfig['db']['prefix'].'_topics';
    $strQuery= 'UPDATE '.$strTopicsTable.' ';
    $strQuery.= 'SET topic_name='.$strName.', ';
    $strQuery.= 'topic_title='.$strTitle.', ';
    $strQuery.= 'topic_description='.$strDescription.' ';
    $strQuery.= 'WHERE topic_id='.$intId;
    $result= $neDbWrite->query($strQuery);
    neGetDbError($result, __LINE__, __FILE__, $strQuery);
    neRedirect('admin.php?mod=topics&op=admin_topics');
}

/**
* adds a new Topic to the Database.
*/
function addTopic($intId, $strName, $strTitle, $strDescription) {
    global $neConfig, $neDbWrite;
    submitImage($intId, $strName);
    $intId = $neDbWrite->quote($intId);
    $strName = $neDbWrite->quote($strName);
    $strTitle = $neDbWrite->quote($strTitle);
    $strDescription= $neDbWrite->quote($strDescription);

    $strQuery= 'INSERT INTO '.$neConfig['db']['prefix'].'_topics ';
    $strQuery.= '(topic_id, topic_name, topic_title, topic_description) ';
    $strQuery.= "VALUES($intId,$strName,$strTitle,$strDescription)";
    $result= $neDbWrite->query($strQuery);
    neGetDbError($result, __LINE__, __FILE__, $strQuery);
    neRedirect('admin.php?mod=topics&op=admin_topics');
}

/**
* Uploads a new topicimage.
* Stores the Uploaded Image to /images/topics and trys to delete the old 
* topic image 
*/
function submitImage($intId, $strName) {
    global $neConfig, $neDb;
    if (empty($_FILES['topic_image'])) {
        return false;
    }
    $tmpfile= $_FILES['topic_image'];

    switch ($tmpfile['type']) {
        case 'image/jpeg' :
            $filename= "$strName.jpg";
            break;
        case 'image/gif' :
            $filename= "$strName.gif";
            break;
        case 'image/png' :
            $filename= "$strName.png";
            break;
        default :
            return (false);
            break;
    }
    @unlink(IMAGE_PATH.'topics/'.$strName.'.jpg');
    @unlink(IMAGE_PATH.'topics/'.$strName.'.png');
    @unlink(IMAGE_PATH.'topics/'.$strName.'.gif');
    neResizeImage($tmpfile['tmp_name'], IMAGE_PATH.'topics/'.$filename, $neConfig['topics']['image_width'], $neConfig['topics']['image_height']);
    return true;
}

/**
*Show the edit Topic Form.
*/
function editTopic($intTopicId) {
    global $neConfig, $neDb, $neModuleName, $neTheme;

    $strQuery= 'SELECT * ';
    $strQuery.= 'FROM '.$neConfig['db']['prefix'].'_topics ';
    $strQuery.= 'WHERE topic_id='.$intTopicId;
    $result= $neDb -> getRow($strQuery, DB_FETCHMODE_ASSOC);
    neGetDbError($result, __LINE__, __FILE__, $strQuery);

    $tpl= $neTheme->getTemplate($neModuleName,'edit_topic.tpl') or die('x_X');
    $neTheme -> drawTitle(neTranslate('edit_topic'));
    $tpl->setVariable(array(
        'MODULE' => $neModuleName, 
        'OP' => 'post_edit', 
        'TOPIC_ID' => $result['topic_id'], 
        'TOPIC_NAME' => $result['topic_name'], 
        'TOPIC_TITLE' => $result['topic_title'], 
        'TOPIC_DESCRIPTION' => $result['topic_description'], 
        'TOPIC_IMAGE' => $neTheme->getImageSrc('topics/'.$result['topic_name']),
        'LABEL_EDIT_TOPIC' => neTranslate('edit_topic'), 
        'LABEL_TOPIC_ID' => neTranslate('topic_id'), 
        'LABEL_TOPIC_NAME' => neTranslate('topic_name'), 
        'LABEL_TOPIC_TITLE' => neTranslate('topic_title'), 
        'LABEL_TOPIC_DESCRIPTION' => neTranslate('topic_description'), 
        'LABEL_TOPIC_IMAGE' => neTranslate('topic_image'), 
        'LABEL_BACKTO_TOPICS' => neTranslate('back_to_topics')
    ));
    $tpl->show();
    $neTheme -> drawSite();
}

/**
*/
function drawAddTopicForm() {
    global $neConfig, $neDb, $neModuleName, $neTheme;
    $strQuery= 'SELECT topic_id ';
    $strQuery.= 'FROM '.$neConfig['db']['prefix'].'_topics ';
    $strQuery.= 'ORDER BY topic_id DESC LIMIT 1';
    $result= $neDb -> getOne($strQuery);
    neGetDbError($result, __LINE__, __FILE__, $strQuery);
    $intId= (int) $result +1;

    $tpl= $neTheme->getTemplate($neModuleName,'add_topic.tpl');
    $neTheme -> drawTitle(neTranslate('add_topic'));
    $tpl -> setVariable('MODULE', $neModuleName);
    $tpl -> setVariable('OP', 'post_add');
    $tpl -> setVariable('TOPIC_ID', $intId);

    $tpl -> setVariable('LABEL_ADD_TOPIC', neTranslate('add_topic'));
    $tpl -> setVariable('LABEL_TOPIC_ID', neTranslate('topic_id'));
    $tpl -> setVariable('LABEL_TOPIC_NAME', neTranslate('topic_name'));
    $tpl -> setVariable('LABEL_TOPIC_TITLE', neTranslate('topic_title'));
    $tpl -> setVariable('LABEL_TOPIC_DESCRIPTION', neTranslate('topic_description'));
    $tpl -> setVariable('LABEL_BACKTO_TOPICS', neTranslate('back_to_topics'));
    $tpl -> show();

    $neTheme -> drawSite();
}

/**
*/
function drawTopicsAdmin() {
    global $neConfig, $neDb, $neTheme;
    $strTopicsTable= $count= 0;
    $strQuery= 'SELECT topic_id,topic_name, topic_title ';
    $strQuery.= 'FROM '.$neConfig['db']['prefix'].'_topics ';
    $strQuery.= 'ORDER BY topic_name';
    $result= $neDb -> query($strQuery);
    negetDbError($result, __LINE__, __FILE__, $strQuery);
    $neTheme -> drawTitle(neTranslate('topics_admin'));
    echo neTranslate('text-topics_admin');
    echo '<br/>';
    ?>    
    				    <table align="center" class="tableview">
    				     <tr class="tableview">
    				      <th class="tableview">
    				       <?php echo neTranslate('topic_name') ?>    
    				      </th>
    				      <th class="tableview">
    				       <?php echo neTranslate('topic_title') ?>    
    				      </th>
    				      <th class="tableview">
    				       <?php echo neTranslate('functions') ?>    
    				      </th>
    				     </tr>
    				     <tr class="tableview">
    				      <?php while (
        $topic= $result -> fetchRow(DB_FETCHMODE_ASSOC)) {
        ?>    
        							      <td class="tableview">
        							        <?php echo $topic['topic_name'] ?>    
        							      </td>
        							      <td class="tableview">
        							        <?php echo $topic['topic_title'] ?>    
        							      </td>
        							      <td class="tableview" align="right">
        							       <a href="admin.php?mod=topics&amp;op=delete_topic&amp;topic_id=<?php echo $topic['topic_id'] ?>    "
        							          onclick="return confirmBox(this,'<?php echo neTranslate('message-really_delete') ?>    ')" 
        							       >
        							        <?php $neTheme -> getImage(
            'delete',
            neTranslate('delete')) ?>    
        							       </a>
        							       <a href="admin.php?mod=topics&amp;op=edit_topic&amp;topic_id=<?php echo $topic['topic_id'] ?>    "><?php echo $neTheme -> getImage(
            'edit',
            neTranslate('edit')) ?>    </a>
        							       <a href="admin.php?mod=topics&amp;op=edit_links&amp;topic_id=<?php echo $topic['topic_id'] ?>    "><?php $neTheme -> drawImage(
            'link',
            'edit_links') ?>    </a>
        							      </td>
        							     </tr>
        							      <?php }
    ?>    
    				    </table>
    				    <?php $neTheme -> drawSite();
}
?>
