<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Editior Functions for the NukeEvent Wiki
*
* @package nukeevent.modules.wiki
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/

function getPermissionOptions($default) {
	global $neSession;
	$strReturn = '';
    if ($neSession->isAdmin('wiki')) {
        if ($default == 2) {
            $strReturn .= '<option value="2" selected="selected">';
        } else {
            $strReturn .= '<option value="2">';
        }
        $strReturn .= neTranslate('all_users').'</option>';
        
        if ( $default == 1 ) {
            $strReturn .= '<option value="1" selected="selected">';
        } else {
            $strReturn .= '<option value="1">';
        }
        $strReturn .= neTranslate('registed_only').'</option>';
        
        if ( $default == 0 ) {
            $strReturn .= '<option value="0" selected="selected">';
        } else {
            $strReturn .= '<option value="0">';
        }
        $strReturn .= neTranslate('admin_only').'</option>';
    } else {
    	return '<option value="'.$default.'">'.neTranslate('text-change_permissions').'</option>';
    }
    return $strReturn;
}


/**
* Submits changes to a Page in the Database, or add the Page if it does not exist.
*/
function submitPage($strName, $strTitle, $strContent,$intVisible,$intEditable)
{
    global $neConfig, $neDb, $neDbWrite, $neSession;
  
    // Look if the Page exist
    $strQuery  = 'SELECT * FROM '.$neConfig['db']['prefix'].'_wiki ';
    $strQuery .= 'WHERE page_name='.$neDb->quote($strName);
    $result = $neDb->query($strQuery);
    neGetDbError($result, __FILE__, __LINE__,$strQuery);

    //If a File Exists we save a Copy to the archive table.
    if ( $result->numRows() > 0 ) {
    	$original = $result->fetchRow(DB_FETCHMODE_ASSOC);
    	//Save a copy in the history       
        $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_wiki_archive';
        $strQuery .= '(page_name, title, content, author, changed) ';
        $strQuery .= 'VALUES(';
        $strQuery .= $neDb->quote(neCheckText($original['page_name'],'plain')).', ';
        $strQuery .= $neDb->quote(neCheckText($original['title'],'plain')).', ';
        $strQuery .= $neDb->quote(neCheckText($original['content'],'wiki')).', ';
        $strQuery .= $neDb->quote( (int) $original['author']).', ';
        $strQuery .= $neDb->quote( (int) $original['changed']);
        $strQuery .= ')';
        $result = $neDbWrite->query($strQuery);
        //neGetDbError($result, __FILE__, __LINE__,$strQuery);

        $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_wiki SET ';
        $strQuery .= 'title='.$neDb->quote(neCheckText($strTitle,'plain'));
        $strQuery .= ', content='.$neDb->quote(neCheckText($strContent,'wiki'));
        $strQuery .= ', author='.$neSession->getId();       
        $strQuery .= ', visible='.(int) $intVisible;       
        $strQuery .= ', editable='.(int) $intEditable;       
        $strQuery .= ' WHERE page_name='.$neDb->quote(neCheckText($strName,'plain'));
    } else {
        $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_wiki';
        $strQuery .= '(page_name,title,content,author,visible,editable) ';
        $strQuery .= 'VALUES(';
        $strQuery .= $neDb->quote(neCheckText($strName,'plain')).', ';
        $strQuery .= $neDb->quote(neCheckText($strTitle,'plain')).', ';
        $strQuery .= $neDb->quote(neCheckText($strContent,'wiki')).', ';
        $strQuery .= $neDb->quote((int) $original['author']).', ';
        $strQuery .= $neDb->quote((int) $intVisible).', ';
        $strQuery .= $neDb->quote((int) $intEditable);
        $strQuery .= ')';
    }
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result, __FILE__, __LINE__,$strQuery);
    return true;
}

function addPage() {
    global $neConfig, $neDb, $neTheme, $neModuleName,$neSession;
    $strQuery  = 'SELECT page_name ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_content ';
    $strQuery .= "WHERE page_name=".$neDb->quote('index');
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__, $strQuery);
    if ($result->numRows() > 0 ) {
    	$strName=null;
    } else {
    	$strName='index';
    }
    showEditForm(
        $strName,
        null,
        null,
        neGetUserName($neSession->getId())
    );
}

/**
 * 
 */
function editPage($strName) {
    global $neConfig, $neDb, $neTheme, $neModuleName, $neSession;
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_wiki ';
    $strQuery .= 'WHERE page_name='.$neDb->quote($strName);
    $page = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($page,__LINE__,__FILE__, $strQuery);
    if ($neSession->getPermission('wiki') <= $page['editable']) {
        showEditForm(
        $strName,
        neFormatText($page['title'],'plain'),
        neFormatText($page['content'],'html'),
        (int) $page['visible'],
        (int) $page['editable']        
        );
    } else {
    	neRedirect(MODULE_LOADER.'?mod=wiki&op=show&name='.urlencode($strName));
    }
}
/**
*Show the edit Topic Form.
*/
function showEditForm($strName,$strTitle,$strContent,$intVisible,$intEditable)
{
    global $neConfig, $neDb, $neTheme, $neModuleName;
    $tpl = $neTheme->getTemplate($neModuleName,"edit_page.tpl");
    $neTheme->drawTitle(neTranslate('edit_page'));
    $tpl->setVariable(array(
    'MODULE_LOADER' => MODULE_LOADER,
    'LABEL_EDIT_PAGE' => neTranslate('edit_page'),
    'LABEL_PAGE_NAME'=> neTranslate('page_name'),
    'LABEL_PAGE_TITLE' => neTranslate('page_title'),
    'LABEL_PAGE_VISIBLE' => neTranslate('visible'),
    'LABEL_PAGE_EDITABLE' => neTranslate('editable'),
    'LABEL_PAGE_CONTENT' => neTranslate('page_content'),
    'LABEL_BACKTO_CONTENT' => neTranslate('back_to_content'),
    'PAGE_VISIBLE' => getPermissionOptions($intVisible),
    'PAGE_EDITABLE' => getPermissionOptions($intEditable),
    'PAGE_NAME' => $strName,
    'PAGE_TITLE' => $strTitle,
    'PAGE_CONTENT' => $neTheme->getHtmlBox('content',$strContent)
    ));
    $tpl->show();
    $neTheme->drawSite($strTitle);
}
?>
