<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Setup for NukeEvent. 
*
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/
error_reporting(E_ALL);

/*
 * Check if the Configfile exists.
 * Else show the Create Menu.
 */
if (!file_exists('config.inc.php')) {
    require('setup/create_config.inc.php');
    die;	
}

require_once('setup/functions.inc.php');
require_once('includes/mainfile.inc.php');

/*
 * Check if the Data dir exists
 *  Else create it.
 */
if (file_exists('config.inc.php')) {
    require('config.inc.php');
} else {
    require('setup/create_config.inc.php');
    die;	
}

/**
 * Load the Language File
 */
$strLangfile = 'includes/language/lang-'.$neConfig['default']['lang'].'.inc.php';
if (file_exists($strLangfile)) {
    include($strLangfile);
} else {
    die("$strLangfile not found.");
}
  
//Try to Connect to the Database
$neDb = DB::connect($neConfig['db']['uri']);
if (DB::isError($neDb)) {
    echo '<h1>'.$neDb->getMessage().'</h1>';
    echo '<p>'.neTranslate(DB::errorMessage($neDb)).'</p>';
    echo '<tt>'.$neDb->getDebugInfo().'</tt>';
	die('Could not connect to the Database'.$neConfig['db']['uri']
	   .'Check the conifig.inc.php');
} 

$neDbWrite = DB::connect($neConfig['db']['uri_write']);
if (DB::isError($neDbWrite)) {
    echo '<h1>'.$neDbWrite->getMessage().'</h1>';
    echo '<p>'.neTranslate(DB::errorMessage($neDbWrite)).'</p>';
    echo '<tt>'.$neDbWrite->getDebugInfo().'</tt>';
	die('Could not connect to the Database'.$neConfig['db']['write_uri']
	   .'Check the conifig.inc.php');
} else {
	include('setup/create_database.inc.php');
	createTables();
	createAdmin();
}
$neSession->login('admin','root',0);
neRedirect('admin.php?mod=module-admin&op=install_module&mod_name=module-admin');    			

?>