/* numcosmomath-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Ncm", gir_namespace = "NumCosmoMath", gir_version = "1.0", lower_case_cprefix = "ncm_")]
namespace Ncm {
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_bootstrap_get_type ()")]
	public class Bootstrap : GLib.Object {
		[CCode (has_construct_function = false)]
		public Bootstrap ();
		public static void clear (Ncm.Bootstrap bstrap);
		public void free ();
		[CCode (cname = "ncm_bootstrap_full_new", has_construct_function = false)]
		public Bootstrap.full_new (uint fsize, uint bsize);
		public uint @get (uint i);
		public uint get_bsize ();
		public uint get_fsize ();
		public bool is_init ();
		public Ncm.Bootstrap @ref ();
		public void remix (Ncm.RNG rng);
		public void resample (Ncm.RNG rng);
		public void set_bsize (uint bsize);
		public void set_fsize (uint fsize);
		[CCode (cname = "ncm_bootstrap_sized_new", has_construct_function = false)]
		public Bootstrap.sized_new (uint fsize);
		[NoAccessorMethod]
		public uint bootstrap_size { get; set construct; }
		[NoAccessorMethod]
		public uint full_size { get; set construct; }
		[NoAccessorMethod]
		public bool init { get; }
		[NoAccessorMethod]
		public GLib.Variant realization { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_c_get_type ()")]
	public class C : GLib.Object {
		[CCode (has_construct_function = false)]
		protected C ();
		public static double AR ();
		public static double AU ();
		public static double G ();
		public static double H_Lyman_2p ();
		public static double H_Lyman_2p_wl ();
		public static double H_Lyman_2p_wl3_8pi ();
		public static double H_Lyman_2s ();
		public static double H_Lyman_2s_wl ();
		public static double H_Lyman_2s_wl3_8pi ();
		public static double H_Lyman_series (double n, double j);
		public static double H_Lyman_series_wl (double n, double j);
		public static double H_bind (double n, double j);
		public static double H_bind_1s ();
		public static double H_bind_2p ();
		public static double H_bind_2s ();
		public static double H_reduced_energy ();
		public static double H_reduced_mass ();
		public static double HeII_bind_1s ();
		public static double HeI_2s_m_2p ();
		public static double HeI_2s_m_2p_kb ();
		public static double HeI_Lyman_2p ();
		public static double HeI_Lyman_2p_wl ();
		public static double HeI_Lyman_2p_wl3_8pi ();
		public static double HeI_Lyman_2s ();
		public static double HeI_Lyman_2s_wl ();
		public static double HeI_Lyman_2s_wl3_8pi ();
		public static double HeI_bind_1s ();
		public static double HeI_bind_2p ();
		public static double HeI_bind_2s ();
		public static double Mpc ();
		public static double bao_eisenstein_A ();
		public static double bao_eisenstein_DV ();
		public static double bao_eisenstein_sigma_A ();
		public static double bao_eisenstein_sigma_DV ();
		public static double bao_eisenstein_z ();
		public static double bao_percival2007_DV_DV ();
		public static double bao_percival2007_sigma_DV_DV ();
		public static double bao_percival2010_DV_DV ();
		public static double bao_percival2010_sigma_DV_DV ();
		public static double blackbody_energy_density ();
		public static double boltzmann_factor_H_1s (double T);
		public static double boltzmann_factor_H_2p (double T);
		public static double boltzmann_factor_H_2s (double T);
		public static double boltzmann_factor_HeI_1s (double T);
		public static double boltzmann_factor_HeI_2p (double T);
		public static double boltzmann_factor_HeI_2s (double T);
		public static double c ();
		public static double c2 ();
		public static double crit_density ();
		public static double crit_mass_density ();
		public static double crit_mass_density_solar_Mpc ();
		public static double crit_number_density_n ();
		public static double crit_number_density_p ();
		public static double decay_H_rate_2s_1s ();
		public static double decay_He_rate_2s_1s ();
		public static double degree_to_radian (double d);
		public static double fine_struct ();
		public static double fine_struct_square ();
		public static double h ();
		public static double hbar ();
		public static double hc ();
		public static double hubble_cte_hst ();
		public static double hubble_cte_msa ();
		public static double hubble_cte_wmap ();
		public static double hubble_radius ();
		public static double hubble_radius_planck ();
		public static double kb ();
		public static double kpc ();
		public static double mass_e ();
		public static double mass_n ();
		public static double mass_p ();
		public static double mass_ratio_alpha_p ();
		public static double mass_solar ();
		public static double neutrino_n_eff ();
		public static double pc ();
		public static double planck_length ();
		public static double planck_length2 ();
		public static double prim_H_Yp ();
		public static double prim_He_Yp ();
		public static double prim_XHe ();
		public static double radian_0_2pi (double r);
		public static double radian_to_degree (double r);
		public static double radiation_h2Omega_r_to_temp (double omr);
		public static double radiation_temp_to_h2omega_r (double T);
		public static double rest_energy_e ();
		public static double rest_energy_n ();
		public static double rest_energy_p ();
		public static double sign_sin (double r);
		public static double stefan_boltzmann ();
		public static double thermal_wl_e ();
		public static double thermal_wl_n ();
		public static double thermal_wl_p ();
		public static double thermal_wn_e ();
		public static double thermal_wn_n ();
		public static double thermal_wn_p ();
		public static double thomson_cs ();
		public static double wmap3_cmb_R ();
		public static double wmap3_cmb_sigma_R ();
		public static double wmap3_cmb_z ();
		public static double wmap5_cmb_R ();
		public static double wmap5_cmb_sigma_R ();
		public static double wmap5_cmb_z ();
		public static double wmap5_coadded_I_K ();
		public static double wmap5_coadded_I_Ka ();
		public static double wmap5_coadded_I_Q ();
		public static double wmap5_coadded_I_V ();
		public static double wmap5_coadded_I_W ();
		public static double wmap7_cmb_R ();
		public static double wmap7_cmb_sigma_R ();
		public static double wmap7_cmb_z ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_get_type ()")]
	public abstract class Data : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Data ();
		[NoWrapper]
		public virtual void begin ();
		public void bootstrap_create ();
		public bool bootstrap_enabled ();
		public void bootstrap_remove ();
		public void bootstrap_resample (Ncm.RNG rng);
		public void bootstrap_set (Ncm.Bootstrap bstrap);
		public static void clear (Ncm.Data data);
		public Ncm.Data dup (Ncm.Serialize ser_obj);
		public void free ();
		public string get_desc ();
		public virtual uint get_dof ();
		public virtual uint get_length ();
		public virtual void leastsquares_J (Ncm.MSet mset, Ncm.Matrix J);
		public virtual void leastsquares_f (Ncm.MSet mset, Ncm.Vector f);
		public virtual void leastsquares_f_J (Ncm.MSet mset, Ncm.Vector f, Ncm.Matrix J);
		public virtual void m2lnL_grad (Ncm.MSet mset, Ncm.Vector grad);
		public virtual void m2lnL_val (Ncm.MSet mset, out double m2lnL);
		public virtual void m2lnL_val_grad (Ncm.MSet mset, out double m2lnL, Ncm.Vector grad);
		public unowned string peek_desc ();
		public virtual void prepare (Ncm.MSet mset);
		public Ncm.Data @ref ();
		public virtual void resample (Ncm.MSet mset, Ncm.RNG rng);
		public void set_desc (string desc);
		public void set_init (bool state);
		public void take_desc (string desc);
		[NoAccessorMethod]
		public Ncm.Bootstrap bootstrap { owned get; set; }
		public string desc { owned get; set; }
		[NoAccessorMethod]
		public bool init { get; set; }
		[NoAccessorMethod]
		public string name { owned get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_dist1d_get_type ()")]
	public abstract class DataDist1d : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataDist1d ();
		public virtual uint get_size ();
		public virtual void set_size (uint np);
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant vector { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_gauss_get_type ()")]
	public abstract class DataGauss : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataGauss ();
		public virtual uint get_size ();
		[NoWrapper]
		public virtual bool inv_cov_func (Ncm.MSet mset, Ncm.Matrix inv_cov);
		[NoWrapper]
		public virtual void mean_func (Ncm.MSet mset, Ncm.Vector vp);
		public virtual void set_size (uint np);
		[NoAccessorMethod]
		public GLib.Variant inv_cov { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant mean { owned get; set; }
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_gauss_cov_get_type ()")]
	public abstract class DataGaussCov : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataGaussCov ();
		[NoWrapper]
		public virtual bool cov_func (Ncm.MSet mset, Ncm.Matrix cov);
		public virtual uint get_size ();
		[NoWrapper]
		public virtual void mean_func (Ncm.MSet mset, Ncm.Vector vp);
		public virtual void set_size (uint np);
		[NoAccessorMethod]
		public GLib.Variant cov { owned get; set; }
		[NoAccessorMethod]
		public GLib.Variant mean { owned get; set; }
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
		[NoAccessorMethod]
		public bool use_det { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_gauss_diag_get_type ()")]
	public abstract class DataGaussDiag : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataGaussDiag ();
		public virtual uint get_size ();
		[NoWrapper]
		public virtual void mean_func (Ncm.MSet mset, Ncm.Vector vp);
		public virtual void set_size (uint np);
		[NoWrapper]
		public virtual bool sigma_func (Ncm.MSet mset, Ncm.Vector @var);
		[NoAccessorMethod]
		public GLib.Variant mean { owned get; set; }
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
		[NoAccessorMethod]
		public GLib.Variant sigma { owned get; set; }
		[NoAccessorMethod]
		public bool w_mean { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_poisson_get_type ()")]
	public abstract class DataPoisson : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataPoisson ();
		public virtual uint get_size ();
		[NoWrapper]
		public virtual double mean_func (Ncm.MSet mset, uint n);
		public virtual void set_size (uint np);
		[NoAccessorMethod]
		public GLib.Variant mean { owned get; set; }
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_dataset_get_type ()")]
	public class Dataset : GLib.Object {
		[CCode (has_construct_function = false)]
		public Dataset ();
		public bool all_init ();
		public void append_data (Ncm.Data data);
		public void bootstrap_resample (Ncm.RNG rng);
		public void bootstrap_set (Ncm.DatasetBStrapType bstype);
		public static void clear (Ncm.Dataset dset);
		public Ncm.Dataset copy ();
		public Ncm.Dataset dup (Ncm.Serialize ser);
		public void free ();
		public Ncm.Data get_data (uint n);
		public Ncm.ObjArray get_data_array ();
		public uint get_dof ();
		public uint get_length ();
		public uint get_n ();
		public uint get_ndata ();
		public bool has_leastsquares_J ();
		public bool has_leastsquares_f ();
		public bool has_leastsquares_f_J ();
		public bool has_m2lnL_grad ();
		public bool has_m2lnL_val ();
		public bool has_m2lnL_val_grad ();
		public void leastsquares_J (Ncm.MSet mset, Ncm.Matrix J);
		public void leastsquares_f (Ncm.MSet mset, Ncm.Vector f);
		public void leastsquares_f_J (Ncm.MSet mset, Ncm.Vector f, Ncm.Matrix J);
		public void log_info ();
		public void m2lnL_grad (Ncm.MSet mset, Ncm.Vector grad);
		public void m2lnL_val (Ncm.MSet mset, out double m2lnL);
		public void m2lnL_val_grad (Ncm.MSet mset, out double m2lnL, Ncm.Vector grad);
		public unowned Ncm.Data peek_data (uint n);
		public unowned Ncm.ObjArray peek_data_array ();
		public Ncm.Dataset @ref ();
		public void resample (Ncm.MSet mset, Ncm.RNG rng);
		public void set_data_array (Ncm.ObjArray oa);
		[NoAccessorMethod]
		public Ncm.DatasetBStrapType bootstrap_type { get; set; }
		public Ncm.ObjArray data_array { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fftlog_get_type ()")]
	public class Fftlog : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Fftlog ();
		public double get_length ();
		public uint get_size ();
		public unowned string peek_name ();
		public void set_length (double L);
		public void set_name (string name);
		public void set_size (uint n);
		[NoAccessorMethod]
		public double L { get; construct; }
		[NoAccessorMethod]
		public uint N { get; construct; }
		[NoAccessorMethod]
		public double k0 { get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		[NoAccessorMethod]
		public double r0 { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_get_type ()")]
	public abstract class Fit : GLib.Object {
		[CCode (has_construct_function = false)]
		public Fit (Ncm.FitType ftype, string algo_name, Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public void add_equality_constraint (Ncm.MSetFunc func, double tot);
		public void add_inequality_constraint (Ncm.MSetFunc func, double tot);
		public double chisq_test (ulong bins);
		public static void clear (Ncm.Fit fit);
		public virtual Ncm.Fit copy_new (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public double covar_cor (Ncm.ModelID mid1, uint pid1, Ncm.ModelID mid2, uint pid2);
		public double covar_cov (Ncm.ModelID mid1, uint pid1, Ncm.ModelID mid2, uint pid2);
		public double covar_fparam_cor (uint fpi1, uint fpi2);
		public double covar_fparam_cov (uint fpi1, uint fpi2);
		public double covar_fparam_sd (uint fpi);
		public double covar_fparam_var (uint fpi);
		public double covar_sd (Ncm.ModelID mid, uint pid);
		public double covar_var (Ncm.ModelID mid, uint pid);
		public void data_m2lnL_val (out double data_m2lnL);
		public void dprob (Ncm.ModelID mid, uint pid, double a, double b, double step, double norm);
		public Ncm.Fit dup (Ncm.Serialize ser);
		public void fishermatrix_print (int @out, string header);
		public void free ();
		public double function_cov (Ncm.MSetFunc func1, double z1, Ncm.MSetFunc func2, double z2, bool pretty_print);
		public void function_error (Ncm.MSetFunc func, double x, bool pretty_print, out double f, out double sigma_f);
		public virtual unowned string get_desc ();
		public double get_m2lnL_abstol ();
		public double get_m2lnL_reltol ();
		public uint get_maxiter ();
		public double get_params_reltol ();
		public uint has_equality_constraints ();
		public uint has_inequality_constraints ();
		public bool is_least_squares ();
		public void log_covar ();
		public void log_end ();
		public void log_info ();
		public void log_start ();
		public void log_state ();
		public void log_step ();
		public double lr_test (Ncm.ModelID mid, uint pid, double val, int dof);
		public void lr_test_range (Ncm.ModelID mid, uint pid, double start, double stop, double step);
		public void ls_J (Ncm.Matrix J);
		public void ls_J_an (Ncm.Matrix J);
		public void ls_J_nd_ce (Ncm.Matrix J);
		public void ls_J_nd_fo (Ncm.Matrix J);
		public void ls_covar ();
		public void ls_f (Ncm.Vector f);
		public void ls_f_J (Ncm.Vector f, Ncm.Matrix J);
		public void ls_f_J_an (Ncm.Vector f, Ncm.Matrix J);
		public void ls_f_J_nd_ce (Ncm.Vector f, Ncm.Matrix J);
		public void ls_f_J_nd_fo (Ncm.Vector f, Ncm.Matrix J);
		public void m2lnL_grad (Ncm.Vector df);
		public void m2lnL_grad_an (Ncm.Vector df);
		public void m2lnL_grad_nd_ac (Ncm.Vector grad);
		public void m2lnL_grad_nd_ce (Ncm.Vector grad);
		public void m2lnL_grad_nd_fo (Ncm.Vector grad);
		public void m2lnL_val (out double m2lnL);
		public void m2lnL_val_grad (out double result, Ncm.Vector df);
		public void m2lnL_val_grad_an (out double result, Ncm.Vector df);
		public void m2lnL_val_grad_nd_ac (out double m2lnL, Ncm.Vector grad);
		public void m2lnL_val_grad_nd_ce (double m2lnL, Ncm.Vector grad);
		public void m2lnL_val_grad_nd_fo (out double m2lnL, Ncm.Vector grad);
		public void numdiff_m2lnL_covar ();
		public void numdiff_m2lnL_hessian (Ncm.Matrix H);
		public void priors_m2lnL_val (out double priors_m2lnL);
		public double prob (Ncm.ModelID mid, uint pid, double a, double b);
		public Ncm.Fit @ref ();
		public void remove_equality_constraints ();
		public void remove_inequality_constraints ();
		public virtual void reset ();
		public virtual bool run (Ncm.FitRunMsgs mtype);
		public void set_grad_type (Ncm.FitGradType gtype);
		public void set_m2lnL_abstol (double tol);
		public void set_m2lnL_reltol (double tol);
		public void set_maxiter (uint maxiter);
		public void set_params (Ncm.Vector @params);
		public void set_params_reltol (double tol);
		public double type_constrain_error (double p, int nu, double dir, Ncm.MSetFunc func, double z, bool walk);
		[NoAccessorMethod]
		public int equality_constraints { get; set; }
		[NoAccessorMethod]
		public Ncm.FitGradType grad_type { get; set construct; }
		[NoAccessorMethod]
		public int inequality_constraints { get; set; }
		[NoAccessorMethod]
		public Ncm.Likelihood likelihood { owned get; construct; }
		public double m2lnL_abstol { get; set construct; }
		public double m2lnL_reltol { get; set construct; }
		public uint maxiter { get; set construct; }
		[NoAccessorMethod]
		public Ncm.MSet mset { owned get; construct; }
		public double params_reltol { get; set construct; }
		[NoAccessorMethod]
		public Ncm.FitState state { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_catalog_get_type ()")]
	public class FitCatalog : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitCatalog (Ncm.Fit fit);
		public void add_from_fit (Ncm.Fit fit);
		public void add_from_vector (Ncm.Vector vals);
		public static void clear (Ncm.FitCatalog fcat);
		public void erase_data ();
		public void free ();
		public bool get_prng (out string prng_algo, out ulong seed);
		public bool is_empty ();
		public double largest_error ();
		public uint len ();
		public void log_current_stats ();
		public void param_pdf (uint i);
		public double param_pdf_pvalue (double pval, bool both);
		public unowned string peek_filename ();
		public void reset ();
		public void set_file (string filename);
		public void set_first_id (int first_id);
		public void set_fit_mean_covar ();
		public void set_flush_interval (double interval);
		public void set_flush_mode (Ncm.FitCatalogFlush fmode);
		public void set_prng (Ncm.RNG rng);
		public void set_run_type (string rtype_str);
		public void sync (bool check);
		[NoAccessorMethod]
		public string filename { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Fit fit { owned get; construct; }
		[NoAccessorMethod]
		public double flush_interval { get; set construct; }
		[NoAccessorMethod]
		public Ncm.FitCatalogFlush fmode { get; set construct; }
		[NoAccessorMethod]
		public string run_type_string { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ncm_fit_constraint_get_type ()")]
	[Compact]
	public class FitConstraint {
		[CCode (has_construct_function = false)]
		public FitConstraint (Ncm.Fit fit, Ncm.MSetFunc func, double tot);
		public Ncm.FitConstraint dup ();
		public void free ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", lower_case_csuffix = "fit_gsl_ls", type_id = "ncm_fit_gsl_ls_get_type ()")]
	public class FitGSLLS : Ncm.Fit {
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLLS (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", lower_case_csuffix = "fit_gsl_mm", type_id = "ncm_fit_gsl_mm_get_type ()")]
	public class FitGSLMM : Ncm.Fit {
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMM (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, Ncm.FitGSLMMAlgos algo);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMM.by_name (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, string algo_name);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMM.@default (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public void set_algo (Ncm.FitGSLMMAlgos algo);
		[NoAccessorMethod]
		public Ncm.FitGSLMMAlgos algorithm { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", lower_case_csuffix = "fit_gsl_mms", type_id = "ncm_fit_gsl_mms_get_type ()")]
	public class FitGSLMMS : Ncm.Fit {
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMMS (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, Ncm.FitGSLMMSAlgos algo);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMMS.by_name (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, string algo_name);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMMS.@default (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public void set_algo (Ncm.FitGSLMMSAlgos algo);
		[NoAccessorMethod]
		public Ncm.FitGSLMMSAlgos algorithm { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_levmar_get_type ()")]
	public class FitLevmar : Ncm.Fit {
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitLevmar (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, Ncm.FitLevmarAlgos algo);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitLevmar.by_name (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, string algo_name);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitLevmar.@default (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public void set_algo (Ncm.FitLevmarAlgos algo);
		[NoAccessorMethod]
		public Ncm.FitLevmarAlgos algorithm { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_mc_get_type ()")]
	public class FitMC : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitMC (Ncm.Fit fit, Ncm.FitMCResampleType rtype, Ncm.FitRunMsgs mtype);
		public static void clear (Ncm.FitMC mc);
		public void end_run ();
		public void free ();
		public void mean_covar ();
		public void reset ();
		public void run (uint n);
		public void run_lre (uint prerun, double lre);
		public void set_data_file (string filename);
		public void set_fiducial (Ncm.MSet fiduc);
		public void set_first_sample_id (int first_sample_id);
		public void set_mtype (Ncm.FitRunMsgs mtype);
		public void set_nthreads (uint nthreads);
		public void set_rng (Ncm.RNG rng);
		public void set_rtype (Ncm.FitMCResampleType rtype);
		public void start_run ();
		[NoAccessorMethod]
		public Ncm.MSet fiducial { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.Fit fit { owned get; construct; }
		[NoAccessorMethod]
		public Ncm.FitRunMsgs mtype { get; set; }
		[NoAccessorMethod]
		public uint nthreads { get; set; }
		[NoAccessorMethod]
		public Ncm.FitMCResampleType rtype { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_mcbs_get_type ()")]
	public class FitMCBS : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitMCBS (Ncm.Fit fit);
		public static void clear (Ncm.FitMCBS mcbs);
		public void free ();
		public void run (Ncm.MSet fiduc, uint ni, uint nf, uint nbstraps, Ncm.FitMCResampleType rtype, Ncm.FitRunMsgs mtype, uint bsmt);
		public void set_filename (string filename);
		public void set_rng (Ncm.RNG rng);
		[NoAccessorMethod]
		public string filename { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Fit fit { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", lower_case_csuffix = "fit_nlopt", type_id = "ncm_fit_nlopt_get_type ()")]
	public class FitNLOpt : Ncm.Fit {
		[CCode (has_construct_function = false)]
		protected FitNLOpt ();
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitNLOpt.by_name (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, string algo_name);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitNLOpt.@default (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		[NoAccessorMethod]
		public Ncm.FitNloptAlgorithm algorithm { get; set construct; }
		[NoAccessorMethod]
		public Ncm.FitNloptAlgorithm local_algorithm { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_state_get_type ()")]
	public class FitState : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitState (uint data_len, uint fparam_len, int dof, bool is_least_squares);
		public static void clear (Ncm.FitState fstate);
		public void free ();
		public double get_m2lnL_prec ();
		public uint get_niter ();
		public double get_params_prec ();
		public void realloc ();
		public Ncm.FitState @ref ();
		public void reset ();
		public void set_all (uint data_len, uint fparam_len, int dof, bool is_least_squares);
		public void set_ls (Ncm.Vector f, Ncm.Matrix J);
		public void set_m2lnL_prec (double prec);
		public void set_niter (uint niter);
		public void set_params_prec (double prec);
		[NoAccessorMethod]
		public uint data_len { get; set construct; }
		[NoAccessorMethod]
		public int dof { get; set construct; }
		[NoAccessorMethod]
		public uint fparam_len { get; set construct; }
		[NoAccessorMethod]
		public uint func_eval { get; }
		[NoAccessorMethod]
		public uint grad_eval { get; }
		[NoAccessorMethod]
		public bool is_best_fit { get; }
		[NoAccessorMethod]
		public bool is_least_squares { get; set construct; }
		[NoAccessorMethod]
		public uint niters { get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_lh_ratio1d_get_type ()")]
	public class LHRatio1d : GLib.Object {
		[CCode (has_construct_function = false)]
		public LHRatio1d (Ncm.Fit fit, Ncm.MSetPIndex pi);
		public static void clear (Ncm.LHRatio1d lhr1d);
		public void find_bounds (double clevel, Ncm.FitRunMsgs mtype, out double lb, out double ub);
		public void free ();
		public void set_pindex (Ncm.MSetPIndex pi);
		[NoAccessorMethod]
		public Ncm.MSetFunc constraint { owned get; set construct; }
		public Ncm.Fit fit { construct; }
		[NoAccessorMethod]
		public Ncm.MSetPIndex pi { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_lh_ratio2d_get_type ()")]
	public class LHRatio2d : GLib.Object {
		[CCode (has_construct_function = false)]
		public LHRatio2d (Ncm.Fit fit, Ncm.MSetPIndex pi1, Ncm.MSetPIndex pi2);
		public static void clear (Ncm.LHRatio2d lhr2d);
		public Ncm.LHRatio2dRegion conf_region (double clevel, double expected_np, Ncm.FitRunMsgs mtype);
		public Ncm.LHRatio2dRegion fisher_border (double clevel, double expected_np, Ncm.FitRunMsgs mtype);
		public void free ();
		public void set_pindex (Ncm.MSetPIndex pi1, Ncm.MSetPIndex pi2);
		public Ncm.Fit fit { construct; }
		[NoAccessorMethod]
		public Ncm.MSetPIndex pi1 { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.MSetPIndex pi2 { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ncm_lh_ratio2d_region_get_type ()")]
	[Compact]
	public class LHRatio2dRegion {
		public double clevel;
		public uint np;
		public weak Ncm.Vector p1;
		public weak Ncm.Vector p2;
		public static void clear (Ncm.LHRatio2dRegion rg);
		public Ncm.LHRatio2dRegion dup ();
		public void free ();
		public void print (int @out);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_likelihood_get_type ()")]
	public class Likelihood : GLib.Object {
		[CCode (has_construct_function = false)]
		public Likelihood (Ncm.Dataset dset);
		public static void clear (Ncm.Likelihood lh);
		public Ncm.Likelihood copy ();
		public Ncm.Likelihood dup (Ncm.Serialize ser);
		public void free ();
		public bool has_leastsquares_J ();
		public bool has_m2lnL_grad ();
		public void leastsquares_J (Ncm.MSet mset, Ncm.Matrix J);
		public void leastsquares_f (Ncm.MSet mset, Ncm.Vector f);
		public void leastsquares_f_J (Ncm.MSet mset, Ncm.Vector f, Ncm.Matrix J);
		public void m2lnL_grad (Ncm.MSet mset, Ncm.Vector grad);
		public void m2lnL_val (Ncm.MSet mset, out double m2lnL);
		public void m2lnL_val_grad (Ncm.MSet mset, out double m2lnL, Ncm.Vector grad);
		public void priors_add (Ncm.MSetFunc prior, bool is_m2lnL);
		public void priors_leastsquares_f (Ncm.MSet mset, Ncm.Vector priors_f);
		public uint priors_length_f ();
		public uint priors_length_m2lnL ();
		public void priors_m2lnL_val (Ncm.MSet mset, out double priors_m2lnL);
		public unowned Ncm.MSetFunc priors_peek_f (uint i);
		public unowned Ncm.MSetFunc priors_peek_m2lnL (uint i);
		public Ncm.Likelihood @ref ();
		[NoAccessorMethod]
		public Ncm.Dataset dataset { owned get; set construct; }
		[NoAccessorMethod]
		public int priors_f_ptr { get; set; }
		[NoAccessorMethod]
		public int priors_m2lnL_ptr { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_get_type ()")]
	public class MSet : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MSet ();
		[CCode (has_construct_function = false)]
		public MSet.array (Ncm.Model model);
		public static void clear (Ncm.MSet mset);
		public bool cmp (Ncm.MSet mset1, bool cmp_model);
		public Ncm.MSet dup (Ncm.Serialize ser);
		[CCode (cname = "ncm_mset_empty_new", has_construct_function = false)]
		public MSet.empty_new ();
		public bool exists (Ncm.Model model);
		public unowned string fparam_full_name (uint n);
		public double fparam_get (uint n);
		public double fparam_get_abstol (uint n);
		public int fparam_get_fpi (Ncm.ModelID mid, uint pid);
		public double fparam_get_lower_bound (uint n);
		public Ncm.MSetPIndex fparam_get_pi (uint n);
		public double fparam_get_scale (uint n);
		public double fparam_get_upper_bound (uint n);
		public uint fparam_len ();
		public unowned string fparam_name (uint n);
		public void fparam_set (uint n, double x);
		public void fparams_get_vector (Ncm.Vector x);
		public void fparams_get_vector_offset (Ncm.Vector x, uint offset);
		public uint fparams_len ();
		public void fparams_set_array (double x);
		public void fparams_set_vector (Ncm.Vector x);
		public void free ();
		public Ncm.Model @get (Ncm.ModelID mid);
		public static int get_id_by_ns (string ns);
		public static Ncm.MSet load (string filename);
		public uint max_fparam_name ();
		public uint max_model_nick ();
		public uint max_param_name ();
		public double orig_param_get (Ncm.ModelID mid, uint pid);
		public double param_get (Ncm.ModelID mid, uint pid);
		public double param_get_abstol (Ncm.ModelID mid, uint pid);
		public Ncm.ParamType param_get_ftype (Ncm.ModelID mid, uint pid);
		public double param_get_lower_bound (Ncm.ModelID mid, uint pid);
		public void param_get_pi (Ncm.MSetPIndex pi, double x, uint n);
		public double param_get_scale (Ncm.ModelID mid, uint pid);
		public double param_get_upper_bound (Ncm.ModelID mid, uint pid);
		public void param_get_vector (Ncm.Vector @params);
		public uint param_len ();
		public unowned string param_name (Ncm.ModelID mid, uint pid);
		public void param_set (Ncm.ModelID mid, uint pid, double x);
		public void param_set_all_ftype (Ncm.ParamType ftype);
		public void param_set_ftype (Ncm.ModelID mid, uint pid, Ncm.ParamType ftype);
		public void param_set_pi (Ncm.MSetPIndex pi, double x, uint n);
		public void param_set_vector (Ncm.Vector @params);
		public void params_log_vals ();
		public void params_pretty_print (int @out, string header);
		public void params_print_vals (int @out);
		public bool params_valid ();
		public unowned Ncm.Model peek (Ncm.ModelID mid);
		public void prepare_fparam_map ();
		public void pretty_log ();
		public Ncm.MSet @ref ();
		public void remove (Ncm.ModelID mid);
		public void save (string filename, bool save_comment);
		public void @set (Ncm.Model model);
		public uint total_len ();
		[NoAccessorMethod]
		public Ncm.Model model_type_0 { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.Model model_type_1 { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.Model model_type_2 { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.Model model_type_3 { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.Model model_type_4 { owned get; set construct; }
		[NoAccessorMethod]
		public bool valid_map { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_func_get_type ()")]
	public class MSetFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		public MSetFunc ([CCode (destroy_notify_pos = 4.1)] owned Ncm.MSetFuncN func, uint np, uint dim, void* obj);
		public static GLib.GenericArray<Ncm.MSetFunc> array_new ();
		public double eval (Ncm.MSet mset, double x);
		public double eval0 (Ncm.MSet mset);
		public double eval1 (Ncm.MSet mset, double x);
		public void free ();
		public bool has_params (uint np);
		public bool is_const ();
		public bool is_scalar ();
		public bool is_vector (uint dim);
		public Ncm.Vector numdiff_fparams (Ncm.MSet mset, double x, out Ncm.Vector @out);
		public Ncm.MSetFunc @ref ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ncm_mset_pindex_get_type ()")]
	[Compact]
	public class MSetPIndex {
		[CCode (has_construct_function = false)]
		public MSetPIndex (Ncm.ModelID mid, uint pid);
		public Ncm.MSetPIndex dup ();
		public void free ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_matrix_get_type ()")]
	public class Matrix : GLib.Object {
		[CCode (has_construct_function = false)]
		public Matrix (uint nrows, uint ncols);
		public void add_mul (double alpha, Ncm.Matrix b);
		[CCode (has_construct_function = false)]
		public Matrix.array (GLib.Array<double> a, uint ncols);
		public static void clear (Ncm.Matrix cm);
		public uint col_len ();
		public void const_free ();
		[CCode (cname = "ncm_matrix_const_new_data", has_construct_function = false, type = "const NcmMatrix*")]
		public Matrix.const_new_data (double d, uint nrows, uint ncols);
		[CCode (cname = "ncm_matrix_const_new_variant", has_construct_function = false, type = "const NcmMatrix*")]
		public Matrix.const_new_variant (GLib.Variant @var);
		public double data ();
		public Ncm.Matrix dup ();
		public double fast_get (uint ij);
		public void fast_set (uint ij, double val);
		public void free ();
		[CCode (has_construct_function = false)]
		public Matrix.full (double d, uint nrows, uint ncols, uint tda, void* pdata, GLib.DestroyNotify? pfree);
		public double @get (uint i, uint j);
		public GLib.Array<weak double> get_array ();
		public Ncm.Vector get_col (uint col);
		public Ncm.Vector get_row (uint row);
		public Ncm.Matrix get_submatrix (uint k1, uint k2, uint nrows, uint ncols);
		public GLib.Variant get_variant ();
		public void memcpy (Ncm.Matrix cm2);
		public uint ncols ();
		public uint nrows ();
		public GLib.Variant peek_variant ();
		public double ptr (uint i, uint j);
		public Ncm.Matrix @ref ();
		public uint row_len ();
		public void scale (double val);
		public void @set (uint i, uint j, double val);
		public void set_col (uint n, Ncm.Vector cv);
		public void set_from_variant (GLib.Variant @var);
		public void set_identity ();
		public void set_zero ();
		public void transpose ();
		[CCode (has_construct_function = false)]
		public Matrix.variant (GLib.Variant @var);
		[NoAccessorMethod]
		public GLib.Variant values { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_model_get_type ()")]
	public abstract class Model : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Model ();
		[CCode (cname = "ncm_model_class_check_params_info")]
		public class void check_params_info ();
		public static void clear (Ncm.Model model);
		public Ncm.Model dup (Ncm.Serialize ser);
		public void free ();
		public Ncm.ModelID id ();
		public static Ncm.ModelID id_by_type (GLib.Type model_type);
		public uint64 impl ();
		public bool is_equal (Ncm.Model model2);
		public uint len ();
		public double orig_param_get (uint n);
		public double orig_param_get_abstol (uint n);
		public double orig_param_get_lower_bound (uint n);
		public double orig_param_get_scale (uint n);
		public double orig_param_get_upper_bound (uint n);
		public bool orig_param_index_from_name (string param_name, out uint i);
		public unowned string orig_param_name (uint n);
		public void orig_param_set (uint n, double val);
		public unowned string orig_param_symbol (uint n);
		public void orig_params_update ();
		public double orig_vparam_get (uint n, uint i);
		public Ncm.Vector orig_vparam_get_vector (uint n);
		public void orig_vparam_set (uint n, uint i, double val);
		public void orig_vparam_set_vector (uint n, Ncm.Vector val);
		public bool param_finite (uint i);
		public double param_get (uint n);
		public double param_get_abstol (uint n);
		public Ncm.ParamType param_get_ftype (uint n);
		public double param_get_lower_bound (uint n);
		public double param_get_scale (uint n);
		public double param_get_upper_bound (uint n);
		public bool param_index_from_name (string param_name, out uint i);
		public unowned string param_name (uint n);
		public unowned Ncm.SParam param_peek_desc (uint n);
		public void param_set (uint n, double val);
		public void param_set_abstol (uint n, double abstol);
		public void param_set_default (uint n);
		public void param_set_ftype (uint n, Ncm.ParamType ptype);
		public void param_set_lower_bound (uint n, double lb);
		public void param_set_scale (uint n, double scale);
		public void param_set_upper_bound (uint n, double ub);
		public unowned string param_symbol (uint n);
		public void params_copyto (Ncm.Model model_dest);
		public bool params_finite ();
		public Ncm.Vector params_get_all ();
		public void params_log_all ();
		public void params_save_as_default ();
		public void params_set_all_data (double data);
		public void params_set_default ();
		public void params_set_model (Ncm.Model model_src);
		public void params_set_vector (Ncm.Vector v);
		public void params_update ();
		public bool params_valid ();
		public unowned Ncm.Reparam peek_reparam ();
		public Ncm.Model @ref ();
		public void reparam_J (Ncm.Matrix fJ, Ncm.Matrix J);
		public void reparam_df (Ncm.Vector fv, Ncm.Vector v);
		[CCode (cname = "ncm_model_class_set_name_nick")]
		public class void set_name_nick (string name, string nick);
		public void set_reparam (Ncm.Reparam reparam);
		[CCode (cname = "ncm_model_class_set_sparam")]
		public class void set_sparam (uint sparam_id, string symbol, string name, double lower_bound, double upper_bound, double scale, double abstol, double default_value, Ncm.ParamType ppt);
		[CCode (cname = "ncm_model_class_set_vparam")]
		public class void set_vparam (uint vparam_id, uint default_length, string symbol, string name, double lower_bound, double upper_bound, double scale, double abstol, double default_value, Ncm.ParamType ppt);
		public uint sparam_len ();
		[NoWrapper]
		public virtual bool valid ();
		public uint vparam_array_len ();
		public uint vparam_index (uint n, uint i);
		public uint vparam_len (uint n);
		[NoAccessorMethod]
		public uint64 implementation { get; }
		[NoAccessorMethod]
		public string name { owned get; }
		[NoAccessorMethod]
		public string nick { owned get; }
		[NoAccessorMethod]
		public GLib.Array<weak void*> params_types { owned get; }
		[NoAccessorMethod]
		public Ncm.Reparam reparam { owned get; set; }
		[NoAccessorMethod]
		public uint scalar_params_len { get; }
		[NoAccessorMethod]
		public uint vector_params_len { get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_model_ctrl_get_type ()")]
	public class ModelCtrl : GLib.Object {
		[CCode (has_construct_function = false)]
		public ModelCtrl (Ncm.Model? model);
		public static void clear (Ncm.ModelCtrl ctrl);
		public Ncm.ModelCtrl copy ();
		public void force_update ();
		public void free ();
		public Ncm.Model get_model ();
		public bool model_update (Ncm.Model model);
		public bool set_model (Ncm.Model model);
		public bool update (Ncm.Model model);
		[NoAccessorMethod]
		public Ncm.Model model { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", ref_function = "ncm_obj_array_ref", type_id = "ncm_obj_array_get_type ()", unref_function = "ncm_obj_array_unref")]
	[Compact]
	public class ObjArray {
		[CCode (has_construct_function = false)]
		public ObjArray ();
		public void add (GLib.Object obj);
		public static void clear (Ncm.ObjArray oa);
		[CCode (has_construct_function = false)]
		public ObjArray.from_variant (Ncm.Serialize ser, GLib.Variant @var);
		public GLib.Object @get (uint i);
		public unowned GLib.Object peek (uint i);
		public Ncm.ObjArray @ref ();
		public GLib.Variant ser (Ncm.Serialize ser);
		public void @set (uint i, GLib.Object obj);
		[CCode (cname = "ncm_obj_array_sized_new", has_construct_function = false)]
		public ObjArray.sized_new (uint n);
		public void unref ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_rng_get_type ()")]
	public class RNG : GLib.Object {
		[CCode (has_construct_function = false)]
		public RNG (string? algo);
		public bool check_seed (ulong seed);
		public static void clear (Ncm.RNG rng);
		public void free ();
		public unowned string get_algo ();
		public ulong get_seed ();
		public string get_state ();
		public void @lock ();
		public static Ncm.RNG pool_get (string name);
		public Ncm.RNG @ref ();
		[CCode (cname = "ncm_rng_seeded_new", has_construct_function = false)]
		public RNG.seeded_new (string? algo, ulong seed);
		public void set_algo (string algo);
		public void set_random_seed (bool allow_colisions);
		public void set_seed (ulong seed);
		public void set_state (string state);
		public void unlock ();
		[NoAccessorMethod]
		public string algorithm { owned get; set construct; }
		public ulong seed { get; set construct; }
		public string state { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_reparam_get_type ()")]
	public abstract class Reparam : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Reparam ();
		public void M_old2new (void* model, Ncm.Matrix jac, Ncm.Matrix old_M, Ncm.Matrix new_M);
		public static void clear (Ncm.Reparam reparam);
		public virtual void copyto (Ncm.Reparam reparam_dest);
		public void free ();
		public Ncm.SParam get_param_desc (uint i);
		public GLib.Variant get_params_desc_dict ();
		public void grad_old2new (void* model, Ncm.Matrix jac, Ncm.Vector old_grad, Ncm.Vector new_grad);
		public bool index_from_name (string param_name, out uint i);
		public virtual bool jac (void* model, Ncm.Matrix jac);
		public virtual bool new2old (void* model, Ncm.Vector src, Ncm.Vector dest);
		public virtual bool old2new (void* model, Ncm.Vector src, Ncm.Vector dest);
		public unowned Ncm.SParam peek_param_desc (uint i);
		public Ncm.Reparam @ref ();
		public void set_param_desc (uint i, Ncm.SParam sp);
		public void set_param_desc_full (uint i, string name, string symbol, double lower_bound, double upper_bound, double scale, double abstol, double default_val, Ncm.ParamType ftype);
		public void set_params_desc_dict (GLib.Variant pdesc_dict);
		[NoAccessorMethod]
		public uint length { get; construct; }
		[NoAccessorMethod]
		public GLib.Variant params_desc { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_reparam_linear_get_type ()")]
	public class ReparamLinear : Ncm.Reparam {
		[CCode (has_construct_function = false)]
		public ReparamLinear (uint size, Ncm.Matrix T, Ncm.Vector v);
		[NoAccessorMethod]
		public GLib.Variant matrix { owned get; construct; }
		[NoAccessorMethod]
		public GLib.Variant vector { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_sparam_get_type ()")]
	public class SParam : GLib.Object {
		[CCode (has_construct_function = false)]
		public SParam (string name, string symbol, double lower_bound, double upper_bound, double scale, double abstol, double default_val, Ncm.ParamType ftype);
		public static void clear (Ncm.SParam sparam);
		public Ncm.SParam copy ();
		public void free ();
		public double get_absolute_tolerance ();
		public double get_default_value ();
		public Ncm.ParamType get_fit_type ();
		public double get_lower_bound ();
		public double get_scale ();
		public double get_upper_bound ();
		public Ncm.SParam @ref ();
		public void set_absolute_tolerance (double abstol);
		public void set_default_value (double default_val);
		public void set_fit_type (Ncm.ParamType ftype);
		public void set_lower_bound (double lb);
		public void set_scale (double scale);
		public void set_upper_bound (double ub);
		public void take_name (string name);
		public void take_symbol (string symbol);
		public double absolute_tolerance { get; set; }
		public double default_value { get; set; }
		public Ncm.ParamType fit_type { get; set; }
		public double lower_bound { get; set; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		public double scale { get; set; }
		[NoAccessorMethod]
		public string symbol { owned get; construct; }
		public double upper_bound { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_serialize_get_type ()")]
	public class Serialize : GLib.Object {
		[CCode (has_construct_function = false)]
		public Serialize (Ncm.SerializeOpt sopt);
		public static void clear (Ncm.Serialize ser);
		public bool contain_instance (GLib.Object obj);
		public bool contain_name (string name);
		public uint count_instances ();
		public GLib.Object dup_obj (GLib.Object obj);
		public void free ();
		public GLib.Object from_name_params (string obj_name, GLib.Variant @params);
		public GLib.Object from_string (string obj_ser);
		public GLib.Object from_variant (GLib.Variant var_obj);
		public GLib.Object get_by_name (string name);
		public static Ncm.Serialize global ();
		public static bool global_contain_instance (GLib.Object obj);
		public static bool global_contain_name (string name);
		public static uint global_count_instances ();
		public static GLib.Object global_dup_obj (GLib.Object obj);
		public static GLib.Object global_from_name_params (string obj_name, GLib.Variant @params);
		public static GLib.Object global_from_string (string obj_ser);
		public static GLib.Object global_from_variant (GLib.Variant var_obj);
		public static GLib.Object global_get_by_name (string name);
		public static string global_global_peek_name (void* obj);
		public static GLib.Variant global_gvalue_to_gvariant (GLib.Value val);
		public static bool global_is_named (string serobj, out string name);
		public static void global_reset ();
		public static void global_set (GLib.Object obj, string name, bool overwrite);
		public static void global_set_property (GLib.Object obj, string prop_str);
		public static string global_to_string (GLib.Object obj, bool valid_variant);
		public static GLib.Variant global_to_variant (GLib.Object obj);
		public GLib.Variant gvalue_to_gvariant (GLib.Value val);
		public bool is_named (string serobj, out string name);
		public unowned string peek_name (GLib.Object obj);
		public Ncm.Serialize @ref ();
		public void reset ();
		public void @set (GLib.Object obj, string name, bool overwrite);
		public void set_property (GLib.Object obj, string prop_str);
		public string to_string (GLib.Object obj, bool valid_variant);
		public GLib.Variant to_variant (GLib.Object obj);
		public void unref ();
		[NoAccessorMethod]
		public Ncm.SerializeOpt options { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline_get_type ()")]
	public abstract class Spline : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Spline ();
		public static void clear (Ncm.Spline s);
		public Ncm.Spline copy ();
		public virtual Ncm.Spline copy_empty ();
		[NoWrapper]
		public virtual double deriv (double x);
		[NoWrapper]
		public virtual double deriv2 (double x);
		[NoWrapper]
		public virtual double deriv_nmax (double x);
		public virtual double eval (double x);
		public double eval_deriv (double x);
		public double eval_deriv2 (double x);
		public double eval_deriv_nmax (double x);
		public double eval_integ (double x0, double x1);
		public void free ();
		public uint get_index (double x);
		public Ncm.Vector get_xv ();
		public Ncm.Vector get_yv ();
		[NoWrapper]
		public virtual double integ (double xi, double xf);
		public bool is_empty ();
		public virtual size_t min_size ();
		[NoWrapper]
		public virtual unowned string name ();
		public Ncm.Spline @new (Ncm.Vector xv, Ncm.Vector yv, bool init);
		public Ncm.Spline new_array (GLib.Array<double> x, GLib.Array<double> y, bool init);
		public Ncm.Spline new_data (double x, double y, size_t len, bool init);
		public virtual void prepare ();
		public virtual void prepare_base ();
		public Ncm.Spline @ref ();
		[NoWrapper]
		public virtual void reset ();
		public unowned Ncm.Spline @set (Ncm.Vector xv, Ncm.Vector yv, bool init);
		public void set_array (GLib.Array<double> x, GLib.Array<double> y, bool init);
		public void set_data_static (double x, double y, size_t len, bool init);
		public void set_xv (Ncm.Vector xv, bool init);
		public void set_yv (Ncm.Vector yv, bool init);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline2d_get_type ()")]
	public abstract class Spline2d : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Spline2d ();
		public static void clear (Ncm.Spline2d s2d);
		public Ncm.Spline2d copy ();
		public virtual Ncm.Spline2d copy_empty ();
		[NoWrapper]
		public virtual double d2zdx2 (double x, double y);
		[NoWrapper]
		public virtual double d2zdxy (double x, double y);
		[NoWrapper]
		public virtual double d2zdy2 (double x, double y);
		[NoWrapper]
		public virtual double dzdx (double x, double y);
		[NoWrapper]
		public virtual double dzdy (double x, double y);
		public virtual double eval (double x, double y);
		public void free ();
		[NoWrapper]
		public virtual double int_dx (double xl, double xu, double y);
		[NoWrapper]
		public virtual double int_dxdy (double xl, double xu, double yl, double yu);
		[NoWrapper]
		public virtual double int_dy (double x, double yl, double yu);
		public double integ_dx (double xl, double xu, double y);
		public Ncm.Spline integ_dx_spline (double xl, double xu);
		public double integ_dx_spline_val (double xl, double xu, double y);
		public double integ_dxdy (double xl, double xu, double yl, double yu);
		public double integ_dxdy_spline_x (double xl, double xu, double yl, double yu);
		public double integ_dxdy_spline_y (double xl, double xu, double yl, double yu);
		public double integ_dy (double x, double yl, double yu);
		public Ncm.Spline integ_dy_spline (double yl, double yu);
		public double integ_dy_spline_val (double x, double yl, double yu);
		[CCode (cname = "ncm_spline2dim_integ_total")]
		public double m_integ_total ();
		public uint min_size ();
		public Ncm.Spline2d @new (Ncm.Vector xv, Ncm.Vector yv, Ncm.Matrix zm, bool init);
		public virtual void prepare ();
		[NoWrapper]
		public virtual void reset ();
		public void @set (Ncm.Vector xv, Ncm.Vector yv, Ncm.Matrix zm, bool init);
		[NoAccessorMethod]
		public Ncm.Spline spline { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline2d_bicubic_get_type ()")]
	public class Spline2dBicubic : Ncm.Spline2d {
		[CCode (has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dBicubic (Ncm.Spline s);
		public static double bi (Ncm.SplineCubic sc, Ncm.Vector xv, Ncm.Vector yv, size_t i);
		public static void bi_bip1 (Ncm.SplineCubic sc, Ncm.Vector xv, Ncm.Vector yv, size_t i, double b_i, double b_ip1);
		public static double eval_poly (Ncm.Spline2dBicubicCoeffs sa, double x, double y);
		public static void fij_to_aij (Ncm.Spline2dBicubicCoeffs sf, double dx, double dy, Ncm.Spline2dBicubicCoeffs sa);
		public static void integ_dx_coeffs (Ncm.Spline2dBicubicCoeffs aij, double dy, double coeffs);
		public static void integ_dy_coeffs (Ncm.Spline2dBicubicCoeffs aij, double dx, double coeffs);
		public static double integ_eval2d (Ncm.Spline2dBicubicCoeffs aij, double x0, double xl, double xu, double y0, double yl, double yu);
		[CCode (cname = "ncm_spline2d_bicubic_notaknot_new", has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dBicubic.notaknot_new ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline2d_gsl_get_type ()")]
	public class Spline2dGsl : Ncm.Spline2d {
		[CCode (has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dGsl (Ncm.Spline s);
		[CCode (cname = "ncm_spline2d_gsl_natural_new", has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dGsl.natural_new ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline2d_spline_get_type ()")]
	public class Spline2dSpline : Ncm.Spline2d {
		[CCode (has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dSpline (Ncm.Spline s);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline_cubic_get_type ()")]
	public abstract class SplineCubic : Ncm.Spline {
		[CCode (has_construct_function = false)]
		protected SplineCubic ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline_cubic_notaknot_get_type ()")]
	public class SplineCubicNotaknot : Ncm.SplineCubic {
		[CCode (has_construct_function = false, type = "NcmSpline*")]
		public SplineCubicNotaknot ();
		[CCode (has_construct_function = false, type = "NcmSpline*")]
		public SplineCubicNotaknot.full (Ncm.Vector xv, Ncm.Vector yv, bool init);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline_gsl_get_type ()")]
	public class SplineGsl : Ncm.Spline {
		[CCode (has_construct_function = false)]
		protected SplineGsl ();
		public void set_type_by_id (Ncm.SplineGslType type_id);
		[NoAccessorMethod]
		public Ncm.SplineGslType type { get; set; }
		[NoAccessorMethod]
		public string type_name { set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_stats_vec_get_type ()")]
	public class StatsVec : GLib.Object {
		[CCode (has_construct_function = false)]
		public StatsVec (uint len, Ncm.StatsVecType t, bool save_x);
		public void append_data (GLib.GenericArray<Ncm.Vector> data, bool dup);
		public static void clear (Ncm.StatsVec svec);
		public void free ();
		public double @get (uint i);
		public double get_cor (uint i, uint j);
		public double get_cov (uint i, uint j);
		public void get_cov_matrix (Ncm.Matrix m, uint offset);
		public double get_mean (uint i);
		public void get_mean_vector (Ncm.Vector mean, uint offset);
		public double get_sd (uint i);
		public double get_var (uint i);
		public double get_weight ();
		public unowned Ncm.Vector peek_row (uint i);
		public unowned Ncm.Vector peek_x ();
		public void prepend_data (GLib.GenericArray<Ncm.Vector> data, bool dup);
		public Ncm.StatsVec @ref ();
		public void reset ();
		public void @set (uint i, double x_i);
		public void update ();
		public void update_weight (double w);
		[NoAccessorMethod]
		public uint length { get; construct; }
		[NoAccessorMethod]
		public bool save_x { get; construct; }
		[NoAccessorMethod]
		public Ncm.StatsVecType type { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_timer_get_type ()")]
	public class Timer : GLib.Object {
		[CCode (has_construct_function = false)]
		public Timer ();
		public static void clear (Ncm.Timer nt);
		public void @continue ();
		public double elapsed ();
		public void elapsed_dhms (out uint elap_day, out uint elap_hour, out uint elap_min, out double elap_sec);
		public unowned string elapsed_dhms_str ();
		public void free ();
		public Ncm.Timer @ref ();
		public void set_name (string name);
		public void start ();
		public void stop ();
		public void task_accumulate (uint nitens);
		public void task_add_tasks (uint ptasks);
		public void task_continue ();
		public unowned string task_elapsed_str ();
		public bool task_end ();
		public unowned string task_end_datetime_str ();
		public void task_increment ();
		public bool task_is_running ();
		public void task_log_elapsed ();
		public void task_log_end_datetime ();
		public void task_log_mean_time ();
		public void task_log_start_datetime ();
		public void task_log_time_left ();
		public double task_mean_time ();
		public unowned string task_mean_time_str ();
		public void task_pause ();
		public void task_start (uint task_len);
		public unowned string task_start_datetime_str ();
		public double task_time_left ();
		public unowned string task_time_left_str ();
		[NoAccessorMethod]
		public string name { owned get; set construct; }
		[NoAccessorMethod]
		public uint task_len { get; }
		[NoAccessorMethod]
		public uint task_pos { get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_vparam_get_type ()")]
	public class VParam : GLib.Object {
		[CCode (has_construct_function = false)]
		public VParam (uint len, Ncm.SParam default_param);
		public static void clear (Ncm.VParam vparam);
		public Ncm.VParam copy ();
		public void free ();
		[CCode (cname = "ncm_vparam_full_new", has_construct_function = false)]
		public VParam.full_new (uint len, string name, string symbol, double lower_bound, double upper_bound, double scale, double abstol, double default_val, Ncm.ParamType ftype);
		public double get_absolute_tolerance (uint n);
		public double get_default_value (uint n);
		public Ncm.ParamType get_fit_type (uint n);
		public uint get_len ();
		public double get_lower_bound (uint n);
		public double get_scale (uint n);
		public Ncm.SParam get_sparam (uint n);
		public double get_upper_bound (uint n);
		public unowned Ncm.SParam peek_sparam (uint n);
		public void set_absolute_tolerance (uint n, double abstol);
		public void set_default_value (uint n, double default_val);
		public void set_fit_type (uint n, Ncm.ParamType ftype);
		public void set_len (uint len);
		public void set_lower_bound (uint n, double lb);
		public void set_scale (uint n, double scale);
		public void set_sparam (uint n, Ncm.SParam spn);
		public void set_sparam_full (uint n, string name, string symbol, double lower_bound, double upper_bound, double scale, double abstol, double default_val, Ncm.ParamType ftype);
		public void set_upper_bound (uint n, double ub);
		[NoAccessorMethod]
		public Ncm.SParam default_sparam { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_vector_get_type ()")]
	public class Vector : GLib.Object {
		[CCode (has_construct_function = false)]
		public Vector (size_t n);
		public void add (Ncm.Vector cv2);
		public void addto (uint i, double val);
		[CCode (has_construct_function = false)]
		public Vector.array (owned GLib.Array<double> a);
		public static void clear (Ncm.Vector cv);
		public double const_data ();
		public void const_free ();
		[CCode (cname = "ncm_vector_const_new_data", has_construct_function = false, type = "const NcmVector*")]
		public Vector.const_new_data (double d, size_t size, size_t stride);
		[CCode (cname = "ncm_vector_const_new_variant", has_construct_function = false, type = "const NcmVector*")]
		public Vector.const_new_variant (GLib.Variant @var);
		public double const_ptr (uint i);
		public Ncm.Vector const_ref ();
		public double data ();
		[CCode (has_construct_function = false)]
		public Vector.data_malloc (double d, size_t size, size_t stride);
		[CCode (has_construct_function = false)]
		public Vector.data_slice (double d, size_t size, size_t stride);
		[CCode (has_construct_function = false)]
		public Vector.data_static (double d, size_t size, size_t stride);
		public void div (Ncm.Vector cv2);
		public Ncm.Vector dup ();
		public GLib.Array<double> dup_array ();
		public void fast_addto (uint i, double val);
		public double fast_get (uint i);
		public void fast_set (uint i, double val);
		public void fast_subfrom (uint i, double val);
		public void free ();
		[CCode (has_construct_function = false)]
		public Vector.full (double d, size_t size, size_t stride, void* pdata, GLib.DestroyNotify? pfree);
		public double @get (uint i);
		public GLib.Array<weak double> get_array ();
		public Ncm.Vector get_subvector (size_t k, size_t size);
		public GLib.Variant get_variant ();
		public uint len ();
		public void log_vals (string prestr, string format);
		public void log_vals_avpb (string prestr, string format, double a, double b);
		public void log_vals_func (string prestr, string format, Ncm.VectorCompFunc f);
		public void memcpy (Ncm.Vector cv2);
		public void memcpy2 (Ncm.Vector cv2, uint cv1_start, uint cv2_start, uint size);
		public GLib.Variant peek_variant ();
		public double ptr (uint i);
		public Ncm.Vector @ref ();
		public void scale (double val);
		public void @set (uint i, double val);
		public void set_all (double val);
		public void set_from_variant (GLib.Variant @var);
		public void set_zero ();
		public uint stride ();
		public void sub (Ncm.Vector cv2);
		public void subfrom (uint i, double val);
		[CCode (has_construct_function = false)]
		public Vector.variant (GLib.Variant @var);
		[NoAccessorMethod]
		public GLib.Variant values { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct BinSplit {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct CVode {
		public void* cvode;
		public uint n;
		public int spline_index;
		public int linear_step;
		public int linear_J;
		public double ti;
		public double tf;
		public double t;
		public double sabstol;
		public double reltol;
		public static bool util_check_flag (void* flagvalue, string funcname, int opt);
		public static bool util_print_stats (void* cvode);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public struct DoubleInt64 {
		public int64 i;
		public double x;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct FitGrad {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct FunctionCache {
		public static void clear (Ncm.FunctionCache cache);
		public void free ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct Grid {
		public void free (bool free_data);
		public double get_double_array ();
		public static string get_name (Ncm.GridSection secs);
		public double get_node_d (ulong i);
		public void set_nodes_d (Ncm.GridNodesEndPoints incl, uint32 start, uint32 end, double start_val, double end_val);
		public void set_nodes_si (Ncm.GridNodesEndPoints incl, uint32 start, uint32 end, long start_val_num, long start_val_den, long end_val_num, long end_val_den);
		public void set_sections (Ncm.GridSection secs);
		public void write (int f);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct GridSection {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct IntegralFixed {
		public void free ();
		public double nodes_eval ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct Integrand2dim {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct LHRatio2dPoint {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MIOde {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MIOdeFunction {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MSetModelDesc {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MemoryPool {
		public void add (void* p);
		public void free (bool free_slices);
		public void* @get ();
		public static void @return (void* p);
		public void set_min_size (size_t n);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MemoryPoolSlice {
		public void* p;
		public bool in_use;
		public Ncm.MemoryPool mp;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	[SimpleType]
	public struct ModelID : int {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MpsfSBesselIntSpline {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MpsfSBesselIntegRecur {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MpsfSBesselRecur {
		public void free ();
		public void write (int f);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct OdeSpline {
		public static void clear (Ncm.OdeSpline os);
		public void free ();
		public void prepare (void* userdata);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct PriorGauss {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct Q {
		[CCode (cname = "ncm_quaternion_conjugate")]
		public void aternion_conjugate ();
		[CCode (cname = "ncm_quaternion_conjugate_q_mul")]
		public void aternion_conjugate_q_mul (Ncm.Q u, Ncm.Q res);
		[CCode (cname = "ncm_quaternion_conjugate_u_mul")]
		public void aternion_conjugate_u_mul (Ncm.Q u, Ncm.Q res);
		[CCode (cname = "ncm_quaternion_free")]
		public void aternion_free ();
		[CCode (cname = "ncm_quaternion_inv_rotate")]
		public void aternion_inv_rotate (Ncm.TriVector v);
		[CCode (cname = "ncm_quaternion_lmul")]
		public void aternion_lmul (Ncm.Q u);
		[CCode (cname = "ncm_quaternion_mul")]
		public void aternion_mul (Ncm.Q u, Ncm.Q res);
		[CCode (cname = "ncm_quaternion_normalize")]
		public void aternion_normalize ();
		[CCode (cname = "ncm_quaternion_rmul")]
		public void aternion_rmul (Ncm.Q u);
		[CCode (cname = "ncm_quaternion_rotate")]
		public void aternion_rotate (Ncm.TriVector v);
		[CCode (cname = "ncm_quaternion_set_from_data")]
		public void aternion_set_from_data (double x, double y, double z, double theta);
		[CCode (cname = "ncm_quaternion_set_random")]
		public void aternion_set_random ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct QuadFilon {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct QuadFilonError {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SFSBesselRecur {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SFSphericalBesselIntSpline {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SFSphericalBesselIntegRecur {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SphereMap {
		public bool copy (Ncm.SphereMap orig);
		public double homogenize_noise (double base_sigma);
		public bool init_coord ();
		public double rotate_avg (long n);
		public bool set_order (Ncm.SphereMapOrder order, bool init_coord);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SphereMapAlm {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SphereMapSHT {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct Spline2dBicubicCoeffs {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct TriVector {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmSpline2dBicubicOptimizeInt", has_type_id = false)]
	public struct _Spline2dBicubicOptimizeInt {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_DATA_POISSON_", type_id = "ncm_data_poisson_type_get_type ()")]
	public enum DataPoissonType {
		INT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_DATASET_BSTRAP_", type_id = "ncm_dataset_bstrap_type_get_type ()")]
	public enum DatasetBStrapType {
		DISABLE,
		PARTIAL,
		TOTAL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_CATALOG_FLUSH_", type_id = "ncm_fit_catalog_flush_get_type ()")]
	public enum FitCatalogFlush {
		DISABLE,
		AUTO,
		TIMED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_GSL_MM_", type_id = "ncm_fit_gslmm_algos_get_type ()")]
	public enum FitGSLMMAlgos {
		CONJUGATE_FR,
		CONJUGATE_PR,
		VECTOR_BFGS,
		VECTOR_BFGS2,
		STEEPEST_DESCENT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_GSL_MMS_", type_id = "ncm_fit_gslmms_algos_get_type ()")]
	public enum FitGSLMMSAlgos {
		NMSIMPLEX2,
		NMSIMPLEX,
		NMSIMPLES2RAND
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_GRAD_", type_id = "ncm_fit_grad_type_get_type ()")]
	public enum FitGradType {
		ANALYTICAL,
		NUMDIFF_FORWARD,
		NUMDIFF_CENTRAL,
		NUMDIFF_ACCURATE
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_LEVMAR_", type_id = "ncm_fit_levmar_algos_get_type ()")]
	public enum FitLevmarAlgos {
		DER,
		DIF
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_MC_RESAMPLE_", type_id = "ncm_fit_mc_resample_type_get_type ()")]
	public enum FitMCResampleType {
		FROM_MODEL,
		BOOTSTRAP_NOMIX,
		BOOTSTRAP_MIX
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NLOPT_", type_id = "ncm_fit_nlopt_algorithm_get_type ()")]
	public enum FitNloptAlgorithm {
		GN_DIRECT,
		GN_DIRECT_L,
		GN_DIRECT_L_RAND,
		GN_DIRECT_NOSCAL,
		GN_DIRECT_L_NOSCAL,
		GN_DIRECT_L_RAND_NOSCAL,
		GN_ORIG_DIRECT,
		GN_ORIG_DIRECT_L,
		GD_STOGO,
		GD_STOGO_RAND,
		LD_LBFGS_NOCEDAL,
		LD_LBFGS,
		LN_PRAXIS,
		LD_VAR1,
		LD_VAR2,
		LD_TNEWTON,
		LD_TNEWTON_RESTART,
		LD_TNEWTON_PRECOND,
		LD_TNEWTON_PRECOND_RESTART,
		GN_CRS2_LM,
		GN_MLSL,
		GD_MLSL,
		GN_MLSL_LDS,
		GD_MLSL_LDS,
		LD_MMA,
		LN_COBYLA,
		LN_NEWUOA,
		LN_NEWUOA_BOUND,
		LN_NELDERMEAD,
		LN_SBPLX,
		LN_AUGLAG,
		LD_AUGLAG,
		LN_AUGLAG_EQ,
		LD_AUGLAG_EQ,
		LN_BOBYQA,
		GN_ISRES,
		AUGLAG,
		AUGLAG_EQ,
		G_MLSL,
		G_MLSL_LDS,
		LD_SLSQP,
		LD_CCSAQ,
		GN_ESCH,
		NUM_ALGORITHMS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NLOPT_", type_id = "ncm_fit_nlopt_result_get_type ()")]
	public enum FitNloptResult {
		FAILURE,
		INVALID_ARGS,
		OUT_OF_MEMORY,
		ROUNDOFF_LIMITED,
		FORCED_STOP,
		SUCCESS,
		STOPVAL_REACHED,
		FTOL_REACHED,
		XTOL_REACHED,
		MAXEVAL_REACHED,
		MAXTIME_REACHED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_RUN_MSGS_", type_id = "ncm_fit_run_msgs_get_type ()")]
	public enum FitRunMsgs {
		NONE,
		SIMPLE,
		FULL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_TYPE_", type_id = "ncm_fit_type_get_type ()")]
	public enum FitType {
		GSL_LS,
		GSL_MM,
		GSL_MMS,
		LEVMAR,
		NLOPT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NC_FUNCTION_CACHE_SEARCH_", type_id = "ncm_function_cache_search_type_get_type ()")]
	public enum FunctionCacheSearchType {
		BOTH,
		GT,
		LT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_GRID_NODES_", type_id = "ncm_grid_nodes_end_points_get_type ()")]
	public enum GridNodesEndPoints {
		START,
		END,
		BOTH,
		NONE
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_LH_RATIO1D_ROOT_", type_id = "ncm_lh_ratio1d_root_get_type ()")]
	public enum LHRatio1dRoot {
		BRACKET,
		NUMDIFF
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_LH_RATIO2D_ROOT_", type_id = "ncm_lh_ratio2d_root_get_type ()")]
	public enum LHRatio2dRoot {
		BRACKET,
		NUMDIFF
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_MATRIX_", type_id = "ncm_matrix_internal_get_type ()")]
	public enum MatrixInternal {
		SLICE,
		GSL_MATRIX,
		MALLOC,
		GARRAY,
		DERIVED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_PARAM_TYPE_", type_id = "ncm_param_type_get_type ()")]
	public enum ParamType {
		FREE,
		FIXED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_SERIALIZE_OPT_", type_id = "ncm_serialize_opt_get_type ()")]
	[Flags]
	public enum SerializeOpt {
		NONE,
		AUTOSAVE_SER,
		AUTONAME_SER
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NC_SPHERE_MAP_ORDER_", type_id = "ncm_sphere_map_order_get_type ()")]
	public enum SphereMapOrder {
		NEST,
		RING
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NC_SPHERE_MAP_TYPE_", type_id = "ncm_sphere_map_type_get_type ()")]
	[Flags]
	public enum SphereMapType {
		TEMPERATURE,
		Q_POLARIZATION,
		U_POLARISATION,
		SPUR_SIGNAL,
		N_OBS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_SPLINE_FUNCTION_", type_id = "ncm_spline_func_type_get_type ()")]
	public enum SplineFuncType {
		@4POINTS,
		[CCode (cname = "NCM_SPLINE_FUNCTION_2x2POINTS")]
		@2X2POINTS,
		SPLINE,
		SPLINE_LNKNOT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_SPLINE_GSL_", type_id = "ncm_spline_gsl_type_get_type ()")]
	public enum SplineGslType {
		LINEAR,
		POLYNOMIAL,
		CSPLINE,
		CSPLINE_PERIODIC,
		AKIMA,
		AKIMA_PERIODIC
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_STATS_VEC_", type_id = "ncm_stats_vec_type_get_type ()")]
	public enum StatsVecType {
		MEAN,
		VAR,
		COV
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_VECTOR_", type_id = "ncm_vector_internal_get_type ()")]
	public enum VectorInternal {
		SLICE,
		GSL_VECTOR,
		MALLOC,
		ARRAY,
		DERIVED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void BinSplitEval (Ncm.BinSplit bs, ulong n1, ulong n2);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void FitMCResample (Ncm.Dataset dset, Ncm.MSet mset, Ncm.RNG rng);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void LoopFunc (long i, long f, void* data);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void MSetFuncN (Ncm.MSet mset, void* obj, double x, double f);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double ModelFunc0 (Ncm.Model model);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double ModelFunc1 (Ncm.Model model, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double OdeSplineDydx (double y, double x, void* userdata);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate bool ReparamJ (Ncm.Reparam reparam, void* model, Ncm.Matrix jac);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate bool ReparamV (Ncm.Reparam reparam, void* model, Ncm.Vector src, Ncm.Vector dest);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", instance_pos = 1.9)]
	public delegate double VectorCompFunc (double v_i);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmFitLSFJ", has_target = false)]
	public delegate void _FitLSFJ (Ncm.Fit fit, Ncm.Vector f, Ncm.Matrix J);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmFitLSJ", has_target = false)]
	public delegate void _FitLSJ (Ncm.Fit fit, Ncm.Matrix J);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmFitM2lnLGrad", has_target = false)]
	public delegate void _FitM2lnLGrad (Ncm.Fit fit, Ncm.Vector grad);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmFitM2lnLValGrad", has_target = false)]
	public delegate void _FitM2lnLValGrad (Ncm.Fit fit, double m2lnL, Ncm.Vector grad);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmIntegrand2dimFunc", has_target = false)]
	public delegate double _Integrand2dimFunc (double x, double y, void* userdata);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_BOOTSTRAP_RNG_NAME")]
	public const string BOOTSTRAP_RNG_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_CFG_DEFAULT_SQLITE3_FILENAME")]
	public const string CFG_DEFAULT_SQLITE3_FILENAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_DATA_RESAMPLE_RNG_NAME")]
	public const string DATA_RESAMPLE_RNG_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_DEFAULT_PRECISION")]
	public const double DEFAULT_PRECISION;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_EXTNAME")]
	public const string FIT_CATALOG_EXTNAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_FIRST_ID_LABEL")]
	public const string FIT_CATALOG_FIRST_ID_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_M2LNL_COLNAME")]
	public const string FIT_CATALOG_M2LNL_COLNAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_NROWS_LABEL")]
	public const string FIT_CATALOG_NROWS_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_PRNG_ALGO_LABEL")]
	public const string FIT_CATALOG_PRNG_ALGO_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_PRNG_SEED_LABEL")]
	public const string FIT_CATALOG_PRNG_SEED_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_RTYPE_BSTRAP_MEAN")]
	public const string FIT_CATALOG_RTYPE_BSTRAP_MEAN;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_RTYPE_LABEL")]
	public const string FIT_CATALOG_RTYPE_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_CATALOG_RTYPE_UNDEFINED")]
	public const string FIT_CATALOG_RTYPE_UNDEFINED;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_DEFAULT_M2LNL_ABSTOL")]
	public const double FIT_DEFAULT_M2LNL_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_DEFAULT_M2LNL_RELTOL")]
	public const double FIT_DEFAULT_M2LNL_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_DEFAULT_MAXITER")]
	public const int FIT_DEFAULT_MAXITER;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_DEFAULT_PARAMS_RELTOL")]
	public const double FIT_DEFAULT_PARAMS_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_MC_MIN_FLUSH_INTERVAL")]
	public const double FIT_MC_MIN_FLUSH_INTERVAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_HEALPIX_NULLVAL")]
	public const double HEALPIX_NULLVAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL_ABS_ERROR")]
	public const double INTEGRAL_ABS_ERROR;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL_ALG")]
	public const int INTEGRAL_ALG;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL_ERROR")]
	public const double INTEGRAL_ERROR;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL_PARTITION")]
	public const int INTEGRAL_PARTITION;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MODEL_MAX_ID")]
	public const int MODEL_MAX_ID;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_OBJ_ARRAY_TYPE")]
	public const string OBJ_ARRAY_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_QUATERNION_RNG_NAME")]
	public const string QUATERNION_RNG_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_REPARAM_PARAMS_DESC_DICT_TYPE")]
	public const string REPARAM_PARAMS_DESC_DICT_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_AUTOSAVE_NAME")]
	public const string SERIALIZE_AUTOSAVE_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_AUTOSAVE_NFORMAT")]
	public const string SERIALIZE_AUTOSAVE_NFORMAT;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_MATRIX_TYPE")]
	public const string SERIALIZE_MATRIX_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_OBJECT_FORMAT")]
	public const string SERIALIZE_OBJECT_FORMAT;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_OBJECT_TYPE")]
	public const string SERIALIZE_OBJECT_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_OPT_CLEAN_DUP")]
	public const int SERIALIZE_OPT_CLEAN_DUP;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_PROPERTIES_TYPE")]
	public const string SERIALIZE_PROPERTIES_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_PROPERTY_TYPE")]
	public const string SERIALIZE_PROPERTY_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_VECTOR_TYPE")]
	public const string SERIALIZE_VECTOR_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPHERE_MAP_RNG_NAME")]
	public const string SPHERE_MAP_RNG_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_00")]
	public const int SPLINE2D_BICUBIC_00;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_01")]
	public const int SPLINE2D_BICUBIC_01;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_10")]
	public const int SPLINE2D_BICUBIC_10;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_11")]
	public const int SPLINE2D_BICUBIC_11;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_F")]
	public const int SPLINE2D_BICUBIC_F;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_FX")]
	public const int SPLINE2D_BICUBIC_FX;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_FXY")]
	public const int SPLINE2D_BICUBIC_FXY;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_FY")]
	public const int SPLINE2D_BICUBIC_FY;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE_FUNC_DEFAULT_MAX_NODES")]
	public const int SPLINE_FUNC_DEFAULT_MAX_NODES;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE_KNOT_DIFF_TOL")]
	public const int SPLINE_KNOT_DIFF_TOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_THREAD_POOL_MAX")]
	public const int THREAD_POOL_MAX;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_TIMER_SEC_FORMAT")]
	public const string TIMER_SEC_FORMAT;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_ZERO_LIMIT")]
	public const double ZERO_LIMIT;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void binsplit_join (Ncm.BinSplit bs, Ncm.BinSplit bs_l, Ncm.BinSplit bs_r);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string cfg_command_line (string argv, int argc);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_enable_gsl_err_handler ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_entries_to_keyfile (GLib.KeyFile kfile, string group_name, GLib.OptionEntry entries);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static unowned GLib.EnumValue? cfg_enum_get_value (GLib.Type enum_type, uint n);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_enum_print_all (GLib.Type enum_type, string header);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static unowned GLib.EnumValue? cfg_get_enum_by_id_name_nick (GLib.Type enum_type, string id_name_nick);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_init ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_keyfile_to_arg (GLib.KeyFile kfile, string group_name, GLib.OptionEntry entries, string argv, int argc);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_logfile (bool on);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_logfile_flush (bool on);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_msg_sepa ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_register_obj (GLib.Type obj);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_set_logfile (string filename);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string cfg_string_to_comment (string str);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static int cmp (double x, double y, double reltol);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void func_eval_set_max_threads (int mt);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void func_eval_threaded_loop ([CCode (delegate_target_pos = 3.1)] Ncm.LoopFunc lfunc, long i, long f);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void func_eval_threaded_loop_nw ([CCode (delegate_target_pos = 3.5)] Ncm.LoopFunc lfunc, long i, long f, uint nworkers);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool integrate_2dim (Ncm.Integrand2dim integ, double xi, double yi, double xf, double yf, double epsrel, double epsabs, double result, double error);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double interp_dd_eval (double vx, double dd, double x, int np, int nf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double interp_dd_eval_2_4 (double vx, double dd, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void interp_dd_init (double vx, double dd, int np, int nf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void interp_dd_init_2_4 (double vx, double dd);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static int lapack_dptsv (double d, double e, double b, uint size);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void message_ww (string msg, string first, string rest, uint ncols);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static GLib.HashTable<void*,void*> mpq_hash_new ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double mpsf_sbessel_integrate (Ncm.MpsfSBesselIntSpline int_jlspline, Ncm.Spline s, uint l, uint ki, uint xi, int diff);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void mpsf_sbessel_jl_xj_integrate_spline_save (Ncm.MpsfSBesselIntSpline int_jlspline, string filename);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_gaussian (Ncm.Likelihood lh, Ncm.PriorGauss gp);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_gaussian_const_func (Ncm.Likelihood lh, Ncm.MSetFunc func, double mean, double sigma);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_gaussian_data (Ncm.Likelihood lh, Ncm.ModelID mid, uint pid, double mean, double sigma);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_gaussian_func (Ncm.Likelihood lh, Ncm.MSetFunc func, double z, double mean, double sigma);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_oneside_a_inf (Ncm.Likelihood lh, Ncm.PriorGauss gp);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_oneside_a_inf_const_func (Ncm.Likelihood lh, Ncm.MSetFunc func, double mean, double s);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_oneside_a_inf_func (Ncm.Likelihood lh, Ncm.MSetFunc func, double z, double mean, double s);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_oneside_a_inf_param (Ncm.Likelihood lh, Ncm.ModelID mid, uint pid, double a, double s);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_positive (Ncm.Likelihood lh, Ncm.ModelID mid, uint pid);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void prior_add_twoside_a_b (Ncm.Likelihood lh, Ncm.ModelID mid, uint pid, double a, double b, double s);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool quadrature_filon_calc_inter_point (Ncm.QuadFilon quadf, double g);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool quadrature_filon_calc_mu_dxnm (Ncm.QuadFilon quadf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool quadrature_filon_calc_vandermonde (Ncm.QuadFilon quadf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool quadrature_filon_solve_vandermonde (Ncm.QuadFilon quadf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_conjugate (Ncm.Q q);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_conjugate_q_mul (Ncm.Q q, Ncm.Q u, Ncm.Q res);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_conjugate_u_mul (Ncm.Q q, Ncm.Q u, Ncm.Q res);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_free (Ncm.Q q);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_inv_rotate (Ncm.Q q, Ncm.TriVector v);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_lmul (Ncm.Q q, Ncm.Q u);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_mul (Ncm.Q q, Ncm.Q u, Ncm.Q res);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_normalize (Ncm.Q q);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_rmul (Ncm.Q q, Ncm.Q u);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_rotate (Ncm.Q q, Ncm.TriVector v);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_set_from_data (Ncm.Q q, double x, double y, double z, double theta);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void quaternion_set_random (Ncm.Q q);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static ulong random_seed ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_0F1 (double b, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_sbessel (ulong l, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_deriv (ulong l, double x, double jl, double jlp1, double djl);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_sbessel_jl_xj_integral (int l, int j, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integral_a_b (Ncm.SFSphericalBesselIntSpline int_jlspline, double x0, double x1, double w, double xnjl_rules, double xndjl_rules, double xnd2jl_rules);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integral_recur_free (Ncm.SFSphericalBesselIntegRecur xnjlrec, bool free_grid);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sf_sbessel_jl_xj_integral_recur_goto (Ncm.SFSphericalBesselIntegRecur xnjlrec, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sf_sbessel_jl_xj_integral_recur_next (Ncm.SFSphericalBesselIntegRecur xnjlrec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sf_sbessel_jl_xj_integral_recur_previous (Ncm.SFSphericalBesselIntegRecur xnjlrec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integral_recur_save (Ncm.SFSphericalBesselIntegRecur xnjlrec, string filename);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integral_recur_set (Ncm.SFSphericalBesselIntegRecur xnjlrec, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_sbessel_jl_xj_integral_spline (Ncm.SFSphericalBesselIntSpline int_jlspline, Ncm.Spline s0, Ncm.Spline s1, Ncm.Spline s2, double w);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_sbessel_jl_xj_integrate_spline_eval (Ncm.SFSphericalBesselIntSpline int_jlspline, int d, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_goto (Ncm.SFSphericalBesselIntSpline int_jlspline, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_next (Ncm.SFSphericalBesselIntSpline int_jlspline);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_previous (Ncm.SFSphericalBesselIntSpline int_jlspline);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_reset (Ncm.SFSphericalBesselIntSpline int_jlspline);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_set (Ncm.SFSphericalBesselIntSpline int_jlspline, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_free (Ncm.SFSBesselRecur jlrec, bool free_grid);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_goto (Ncm.SFSBesselRecur jlrec, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_next (Ncm.SFSBesselRecur jlrec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_previous (Ncm.SFSBesselRecur jlrec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_set (Ncm.SFSBesselRecur jlrec, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static Ncm.Spline sf_sbessel_spline (ulong l, double xi, double xf, double reltol);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_taylor (ulong l, double x, double djl);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_taylor_coeff_jl_jlp1 (Ncm.SFSBesselRecur jlrec, uint n, double djl, double djlp1);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double smoothd (double @in, ulong N, ulong points, ulong pass);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sphPlm_test_theta (double theta, int lmax, int lmin_data);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sphPlm_x (int l, int m, int order);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sphere_healpix_nest2ring (int nside, long nest_index);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_pix2ang_nest (int nside, long nest_index, double theta, double phi);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_pix2ang_ring (int nside, long ring_index, double theta, double phi);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_pix2vec_nest (int nside, long nest_index, Ncm.TriVector vec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_pix2vec_ring (int nside, long ring_index, Ncm.TriVector v);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sphere_healpix_ring2nest (int nside, long ring_index);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_vec2pix_ring (int nside, Ncm.TriVector v, long i);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_healpix_write_map (Ncm.SphereMap map, string filename, bool overwrite);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapalm_init (Ncm.SphereMapAlm mapalm, int lmax);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapsht_alm2map (Ncm.SphereMapSHT mapsht);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapsht_alm2map_circle (Ncm.SphereMapSHT mapsht, int ring, int ring_size, double theta, double phi);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapsht_map2alm (Ncm.SphereMapSHT mapsht, double cut);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapsht_map2alm_circle (Ncm.SphereMapSHT mapsht, int ring, int ring_size, double norma, double theta, double phi, int start_m, int end_m);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double spline2dim_integ_total (Ncm.Spline2d s2d);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sqrt1px_m1 (double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string string_ww (string msg, string first, string rest, uint ncols);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sum (double d, ulong n);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double topology_comoving_a0_lss (uint n, double alpha);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double topology_sigma_comoving_a0_lss (uint n, double alpha, double sigma_alpha);
}
