/* numcosmomath-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Ncm", gir_namespace = "NumCosmoMath", gir_version = "1.0", lower_case_cprefix = "ncm_")]
namespace Ncm {
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_abc_get_type ()")]
	public abstract class ABC : GLib.Object {
		[CCode (has_construct_function = false)]
		protected ABC ();
		public static void clear (Ncm.ABC abc);
		public virtual bool data_summary ();
		public virtual double distance_prob (double distance);
		public void end_run ();
		public void end_update ();
		public void free ();
		public double get_accept_ratio ();
		public double get_depsilon ();
		public virtual unowned string get_desc ();
		public double get_dist_quantile (double p);
		public double get_epsilon ();
		public virtual unowned string log_info ();
		public void mean_covar (Ncm.Fit fit);
		public virtual double mock_distance (Ncm.Dataset dset, Ncm.Vector theta, Ncm.Vector thetastar, Ncm.RNG rng);
		public void reset ();
		public void run (uint nparticles);
		public void set_data_file (string filename);
		public void set_mtype (Ncm.FitRunMsgs mtype);
		public void set_nthreads (uint nthreads);
		public void set_rng (Ncm.RNG rng);
		public void set_trans_kern (Ncm.MSetTransKern tkern);
		public void start_run ();
		public void start_update ();
		public void update ();
		public void update_epsilon (double epsilon);
		public virtual void update_tkern ();
		[NoAccessorMethod]
		public Ncm.Dataset data_set { owned get; construct; }
		[NoAccessorMethod]
		public double epsilon { get; set construct; }
		[NoAccessorMethod]
		public Ncm.MSet mset { owned get; construct; }
		[NoAccessorMethod]
		public uint nparticles { get; }
		[NoAccessorMethod]
		public Ncm.MSetTransKern prior { owned get; construct; }
		[NoAccessorMethod]
		public Ncm.MSetTransKern trans_kernel { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_bootstrap_get_type ()")]
	public class Bootstrap : GLib.Object {
		[CCode (has_construct_function = false)]
		public Bootstrap ();
		public static void clear (Ncm.Bootstrap bstrap);
		public void free ();
		[CCode (cname = "ncm_bootstrap_full_new", has_construct_function = false)]
		public Bootstrap.full_new (uint fsize, uint bsize);
		public uint @get (uint i);
		public uint get_bsize ();
		public uint get_fsize ();
		public bool is_init ();
		public Ncm.Bootstrap @ref ();
		public void remix (Ncm.RNG rng);
		public void resample (Ncm.RNG rng);
		public void set_bsize (uint bsize);
		public void set_fsize (uint fsize);
		[CCode (cname = "ncm_bootstrap_sized_new", has_construct_function = false)]
		public Bootstrap.sized_new (uint fsize);
		[NoAccessorMethod]
		public uint bootstrap_size { get; set construct; }
		[NoAccessorMethod]
		public uint full_size { get; set construct; }
		[NoAccessorMethod]
		public bool init { get; }
		[NoAccessorMethod]
		public GLib.Variant realization { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_c_get_type ()")]
	public class C : GLib.Object {
		[CCode (has_construct_function = false)]
		protected C ();
		public static double AR ();
		public static double G ();
		public static double G_mass_solar ();
		public static double HI_Lyman_wl3_8pi_2p_2P0_5 ();
		public static double HI_Lyman_wl3_8pi_2p_2P3_5 ();
		public static double HI_Lyman_wl3_8pi_2p_2Pmean ();
		public static double HI_Lyman_wl3_8pi_2s_2S0_5 ();
		public static double HI_Lyman_wl_2p_2P0_5 ();
		public static double HI_Lyman_wl_2p_2P3_5 ();
		public static double HI_Lyman_wl_2p_2Pmean ();
		public static double HI_Lyman_wl_2s_2S0_5 ();
		public static double HI_Lyman_wn_2p_2P0_5 ();
		public static double HI_Lyman_wn_2p_2P3_5 ();
		public static double HI_Lyman_wn_2p_2Pmean ();
		public static double HI_Lyman_wn_2s_2S0_5 ();
		public static double HI_ion_E_1s_2S0_5 ();
		public static double HI_ion_E_2p_2P0_5 ();
		public static double HI_ion_E_2p_2P3_5 ();
		public static double HI_ion_E_2p_2Pmean ();
		public static double HI_ion_E_2s_2S0_5 ();
		public static double HI_ion_wn_1s_2S0_5 ();
		public static double HI_ion_wn_2p_2P0_5 ();
		public static double HI_ion_wn_2p_2P3_5 ();
		public static double HI_ion_wn_2p_2Pmean ();
		public static double HI_ion_wn_2s_2S0_5 ();
		public static double H_bind (double n, double j);
		public static double H_reduced_energy ();
		public static double H_reduced_mass ();
		public static double HeII_ion_E_1s_2S0_5 ();
		public static double HeII_ion_wn_1s_2S0_5 ();
		public static double HeI_Balmer_E_kb_2p_1P1_2s_1S0 ();
		public static double HeI_Balmer_E_kb_2p_3Pmean_2s_3S1 ();
		public static double HeI_Balmer_wn_2p_1P1_2s_1S0 ();
		public static double HeI_Balmer_wn_2p_3Pmean_2s_3S1 ();
		public static double HeI_Lyman_wl3_8pi_2p_1P1 ();
		public static double HeI_Lyman_wl3_8pi_2p_3P0 ();
		public static double HeI_Lyman_wl3_8pi_2p_3P1 ();
		public static double HeI_Lyman_wl3_8pi_2p_3P2 ();
		public static double HeI_Lyman_wl3_8pi_2p_3Pmean ();
		public static double HeI_Lyman_wl3_8pi_2s_1S0 ();
		public static double HeI_Lyman_wl3_8pi_2s_3S1 ();
		public static double HeI_Lyman_wl_2p_1P1 ();
		public static double HeI_Lyman_wl_2p_3P0 ();
		public static double HeI_Lyman_wl_2p_3P1 ();
		public static double HeI_Lyman_wl_2p_3P2 ();
		public static double HeI_Lyman_wl_2p_3Pmean ();
		public static double HeI_Lyman_wl_2s_1S0 ();
		public static double HeI_Lyman_wl_2s_3S1 ();
		public static double HeI_Lyman_wn_2p_1P1 ();
		public static double HeI_Lyman_wn_2p_3P0 ();
		public static double HeI_Lyman_wn_2p_3P1 ();
		public static double HeI_Lyman_wn_2p_3P2 ();
		public static double HeI_Lyman_wn_2p_3Pmean ();
		public static double HeI_Lyman_wn_2s_1S0 ();
		public static double HeI_Lyman_wn_2s_3S1 ();
		public static double HeI_ion_E_1s_1S0 ();
		public static double HeI_ion_E_2p_1P1 ();
		public static double HeI_ion_E_2p_3P0 ();
		public static double HeI_ion_E_2p_3P1 ();
		public static double HeI_ion_E_2p_3P2 ();
		public static double HeI_ion_E_2p_3Pmean ();
		public static double HeI_ion_E_2s_1S0 ();
		public static double HeI_ion_E_2s_3S1 ();
		public static double HeI_ion_wn_1s_1S0 ();
		public static double HeI_ion_wn_2p_1P1 ();
		public static double HeI_ion_wn_2p_3P0 ();
		public static double HeI_ion_wn_2p_3P1 ();
		public static double HeI_ion_wn_2p_3P2 ();
		public static double HeI_ion_wn_2p_3Pmean ();
		public static double HeI_ion_wn_2s_1S0 ();
		public static double HeI_ion_wn_2s_3S1 ();
		public static double Mpc ();
		public static double Rinf ();
		public static double Ry ();
		public static double au ();
		public static double blackbody_energy_density ();
		public static double boltzmann_factor_HI_1s_2S0_5 (double T);
		public static double boltzmann_factor_HI_2p_2P0_5 (double T);
		public static double boltzmann_factor_HI_2p_2P3_5 (double T);
		public static double boltzmann_factor_HI_2p_2Pmean (double T);
		public static double boltzmann_factor_HI_2s_2S0_5 (double T);
		public static double boltzmann_factor_HeI_1s_1S0 (double T);
		public static double boltzmann_factor_HeI_2p_1P1 (double T);
		public static double boltzmann_factor_HeI_2p_3P0 (double T);
		public static double boltzmann_factor_HeI_2p_3P1 (double T);
		public static double boltzmann_factor_HeI_2p_3P2 (double T);
		public static double boltzmann_factor_HeI_2p_3Pmean (double T);
		public static double boltzmann_factor_HeI_2s_1S0 (double T);
		public static double boltzmann_factor_HeI_2s_3S1 (double T);
		public static double c ();
		public static double c2 ();
		public static double crit_density_h2 ();
		public static double crit_mass_density_h2 ();
		public static double crit_mass_density_h2_solar_mass_Mpc3 ();
		public static double crit_number_density_n ();
		public static double crit_number_density_p ();
		public static double decay_H_rate_2s_1s ();
		public static double decay_He_rate_2s_1s ();
		public static double degree_to_radian (double d);
		public static double eV ();
		public static double fine_struct ();
		public static double fine_struct_square ();
		public static double h ();
		public static double hbar ();
		public static double hc ();
		public static double hubble_cte_hst ();
		public static double hubble_cte_msa ();
		public static double hubble_cte_wmap ();
		public static double hubble_radius_hm1_Mpc ();
		public static double hubble_radius_hm1_planck ();
		public static double kb ();
		public static double kpc ();
		public static double mass_1H ();
		public static double mass_1H_u ();
		public static double mass_2H ();
		public static double mass_2H_u ();
		public static double mass_3H ();
		public static double mass_3H_u ();
		public static double mass_3He ();
		public static double mass_3He_u ();
		public static double mass_4He ();
		public static double mass_4He_u ();
		public static double mass_atomic ();
		public static double mass_e ();
		public static double mass_n ();
		public static double mass_p ();
		public static double mass_ratio_4He_1H ();
		public static double mass_ratio_alpha_p ();
		public static double mass_ratio_e_p ();
		public static double mass_solar ();
		public static double pc ();
		public static double planck_length ();
		public static double planck_length2 ();
		public static double radian_0_2pi (double r);
		public static double radian_to_degree (double r);
		public static double radiation_h2Omega_r0_to_temp (double omr);
		public static double radiation_temp_to_h2omega_r (double T);
		public static double rest_energy_1H ();
		public static double rest_energy_2H ();
		public static double rest_energy_3H ();
		public static double rest_energy_3He ();
		public static double rest_energy_4He ();
		public static double rest_energy_atomic ();
		public static double rest_energy_e ();
		public static double rest_energy_n ();
		public static double rest_energy_p ();
		public static double sign_sin (double r);
		public static double stefan_boltzmann ();
		public static double thermal_wl_e ();
		public static double thermal_wl_n ();
		public static double thermal_wl_p ();
		public static double thermal_wn_e ();
		public static double thermal_wn_n ();
		public static double thermal_wn_p ();
		public static double thomson_cs ();
		public static double wmap5_coadded_I_K ();
		public static double wmap5_coadded_I_Ka ();
		public static double wmap5_coadded_I_Q ();
		public static double wmap5_coadded_I_V ();
		public static double wmap5_coadded_I_W ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_calc_get_type ()")]
	public class Calc : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Calc ();
		[CCode (cname = "ncm_calc_class_check")]
		public class void check ();
		public double get_abstol ();
		public double get_reltol ();
		[NoWrapper]
		public virtual void prepare ();
		public void prepare_array ([CCode (array_length = false, array_null_terminated = true)] Ncm.Model[] ma);
		public void prepare_if_needed_array ([CCode (array_length = false, array_null_terminated = true)] Ncm.Model[] ma);
		public void set_abstol (double abstol);
		[CCode (cname = "ncm_calc_class_set_dep")]
		public class void set_dep (uint p, GLib.Type dep_model);
		[CCode (cname = "ncm_calc_class_set_num_dep")]
		public class void set_num_dep (uint ndep);
		public void set_reltol (double reltol);
		public double abstol { get; set construct; }
		public double reltol { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ncm_complex_get_type ()")]
	[Compact]
	public class Complex {
		[CCode (has_construct_function = false)]
		public Complex ();
		public double Im ();
		public double Re ();
		public static void clear (Ncm.Complex c);
		public Ncm.Complex dup ();
		public void free ();
		public Ncm.Complex @ref ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_get_type ()")]
	public abstract class Data : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Data ();
		[NoWrapper]
		public virtual void begin ();
		public void bootstrap_create ();
		public bool bootstrap_enabled ();
		public void bootstrap_remove ();
		public void bootstrap_resample (Ncm.RNG rng);
		public void bootstrap_set (Ncm.Bootstrap bstrap);
		public static void clear (Ncm.Data data);
		public Ncm.Data dup (Ncm.Serialize ser_obj);
		public void free ();
		[CCode (has_construct_function = false)]
		public Data.from_file (string filename);
		public string get_desc ();
		public virtual uint get_dof ();
		public virtual uint get_length ();
		public virtual void leastsquares_J (Ncm.MSet mset, Ncm.Matrix J);
		public virtual void leastsquares_f (Ncm.MSet mset, Ncm.Vector f);
		public virtual void leastsquares_f_J (Ncm.MSet mset, Ncm.Vector f, Ncm.Matrix J);
		public virtual void m2lnL_grad (Ncm.MSet mset, Ncm.Vector grad);
		public virtual void m2lnL_val (Ncm.MSet mset, out double m2lnL);
		public virtual void m2lnL_val_grad (Ncm.MSet mset, out double m2lnL, Ncm.Vector grad);
		public unowned string peek_desc ();
		public virtual void prepare (Ncm.MSet mset);
		public Ncm.Data @ref ();
		public virtual void resample (Ncm.MSet mset, Ncm.RNG rng);
		public void set_desc (string desc);
		public void set_init (bool state);
		public void take_desc (string desc);
		[NoAccessorMethod]
		public Ncm.Bootstrap bootstrap { owned get; set; }
		public string desc { owned get; set; }
		[NoAccessorMethod]
		public bool init { get; set; }
		[NoAccessorMethod]
		public string long_desc { owned get; set; }
		[NoAccessorMethod]
		public string name { owned get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_dist1d_get_type ()")]
	public abstract class DataDist1d : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataDist1d ();
		public Ncm.Vector get_data ();
		public virtual uint get_size ();
		[NoWrapper]
		public virtual double inv_pdf (Ncm.MSet mset, double u);
		[NoWrapper]
		public virtual double m2lnL_val (Ncm.MSet mset, double x);
		public virtual void set_size (uint np);
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
		[NoAccessorMethod]
		public Ncm.Vector vector { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_gauss_get_type ()")]
	public abstract class DataGauss : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataGauss ();
		public virtual uint get_size ();
		[NoWrapper]
		public virtual bool inv_cov_func (Ncm.MSet mset, Ncm.Matrix inv_cov);
		[NoWrapper]
		public virtual void mean_func (Ncm.MSet mset, Ncm.Vector vp);
		public virtual void set_size (uint np);
		[NoAccessorMethod]
		public Ncm.Matrix inv_cov { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Vector mean { owned get; set; }
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_gauss_cov_get_type ()")]
	public abstract class DataGaussCov : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataGaussCov ();
		[NoWrapper]
		public virtual bool cov_func (Ncm.MSet mset, Ncm.Matrix cov);
		public virtual uint get_size ();
		[NoWrapper]
		public virtual void lnNorma2 (Ncm.MSet mset, double m2lnL);
		[NoWrapper]
		public virtual void lnNorma2_bs (Ncm.MSet mset, Ncm.Bootstrap bstrap, double m2lnL);
		[NoWrapper]
		public virtual void mean_func (Ncm.MSet mset, Ncm.Vector vp);
		public virtual void set_size (uint np);
		[NoAccessorMethod]
		public Ncm.Matrix cov { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Vector mean { owned get; set; }
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
		[NoAccessorMethod]
		public bool use_norma { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_gauss_diag_get_type ()")]
	public abstract class DataGaussDiag : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataGaussDiag ();
		public virtual uint get_size ();
		[NoWrapper]
		public virtual void mean_func (Ncm.MSet mset, Ncm.Vector vp);
		public virtual void set_size (uint np);
		[NoWrapper]
		public virtual bool sigma_func (Ncm.MSet mset, Ncm.Vector @var);
		[NoAccessorMethod]
		public Ncm.Vector mean { owned get; set; }
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
		[NoAccessorMethod]
		public Ncm.Vector sigma { owned get; set; }
		[NoAccessorMethod]
		public bool w_mean { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_data_poisson_get_type ()")]
	public abstract class DataPoisson : Ncm.Data {
		[CCode (has_construct_function = false)]
		protected DataPoisson ();
		public virtual uint get_size ();
		[NoWrapper]
		public virtual double mean_func (Ncm.MSet mset, uint n);
		public virtual void set_size (uint np);
		[NoAccessorMethod]
		public Ncm.Vector mean { owned get; set; }
		[NoAccessorMethod]
		public uint n_points { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_dataset_get_type ()")]
	public class Dataset : GLib.Object {
		[CCode (has_construct_function = false)]
		public Dataset ();
		public bool all_init ();
		public void append_data (Ncm.Data data);
		public void bootstrap_resample (Ncm.RNG rng);
		public void bootstrap_set (Ncm.DatasetBStrapType bstype);
		public static void clear (Ncm.Dataset dset);
		public Ncm.Dataset copy ();
		public Ncm.Dataset dup (Ncm.Serialize ser);
		public void free ();
		public Ncm.Data get_data (uint n);
		public Ncm.ObjArray get_data_array ();
		public uint get_dof ();
		public string get_info ();
		public uint get_length ();
		public uint get_n ();
		public uint get_ndata ();
		public bool has_leastsquares_J ();
		public bool has_leastsquares_f ();
		public bool has_leastsquares_f_J ();
		public bool has_m2lnL_grad ();
		public bool has_m2lnL_val ();
		public bool has_m2lnL_val_grad ();
		public void leastsquares_J (Ncm.MSet mset, Ncm.Matrix J);
		public void leastsquares_f (Ncm.MSet mset, Ncm.Vector f);
		public void leastsquares_f_J (Ncm.MSet mset, Ncm.Vector f, Ncm.Matrix J);
		public void log_info ();
		public void m2lnL_grad (Ncm.MSet mset, Ncm.Vector grad);
		public void m2lnL_i_val (Ncm.MSet mset, uint i, out double m2lnL_i);
		public void m2lnL_val (Ncm.MSet mset, out double m2lnL);
		public void m2lnL_val_grad (Ncm.MSet mset, out double m2lnL, Ncm.Vector grad);
		public void m2lnL_vec (Ncm.MSet mset, Ncm.Vector m2lnL_v);
		public unowned Ncm.Data peek_data (uint n);
		public unowned Ncm.ObjArray peek_data_array ();
		public Ncm.Dataset @ref ();
		public void resample (Ncm.MSet mset, Ncm.RNG rng);
		public void set_data_array (Ncm.ObjArray oa);
		[NoAccessorMethod]
		public Ncm.DatasetBStrapType bootstrap_type { get; set; }
		public Ncm.ObjArray data_array { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fftlog_get_type ()")]
	public abstract class Fftlog : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Fftlog ();
		public static void clear (Ncm.Fftlog fftlog);
		public void eval_by_vector (Ncm.Vector Fk);
		public double eval_output (uint nderiv, double lnr);
		public void free ();
		[NoWrapper]
		public virtual void get_Ym (void* Ym_0);
		public double get_full_length ();
		public int get_full_size ();
		public double get_length ();
		public double get_lnk0 ();
		public double get_lnr0 ();
		public int get_mode_index (int i);
		public uint get_nderivs ();
		public double get_norma ();
		public double get_padding ();
		public uint get_size ();
		public Ncm.Vector get_vector_Gr (uint nderiv);
		public Ncm.Vector get_vector_lnr ();
		public unowned string peek_name ();
		public unowned Ncm.Vector peek_output_vector (uint nderiv);
		public unowned Ncm.Spline peek_spline_Gr (uint nderiv);
		public void prepare_splines ();
		public Ncm.Fftlog @ref ();
		public void set_length (double Lk);
		public void set_lnk0 (double lnk0);
		public void set_lnr0 (double lnr0);
		public void set_name (string name);
		public void set_nderivs (uint nderivs);
		public void set_padding (double pad_p);
		public void set_size (uint n);
		[NoAccessorMethod]
		public double Lk { get; construct; }
		[NoAccessorMethod]
		public uint N { get; set; }
		public double lnk0 { get; construct; }
		public double lnr0 { get; construct; }
		[NoAccessorMethod]
		public string name { owned get; }
		public uint nderivs { get; set construct; }
		public double padding { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fftlog_gausswin2_get_type ()")]
	public class FftlogGausswin2 : Ncm.Fftlog {
		[CCode (has_construct_function = false)]
		public FftlogGausswin2 (double lnr0, double lnk0, double Lk, uint N);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fftlog_tophatwin2_get_type ()")]
	public class FftlogTophatwin2 : Ncm.Fftlog {
		[CCode (has_construct_function = false)]
		public FftlogTophatwin2 (double lnr0, double lnk0, double Lk, uint N);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_get_type ()")]
	public abstract class Fit : GLib.Object {
		[CCode (has_construct_function = false)]
		public Fit (Ncm.FitType ftype, string algo_name, Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public void add_equality_constraint (Ncm.MSetFunc func, double tot);
		public void add_inequality_constraint (Ncm.MSetFunc func, double tot);
		public double chisq_test (size_t bins);
		public static void clear (Ncm.Fit fit);
		public virtual Ncm.Fit copy_new (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public double covar_cor (Ncm.ModelID mid1, uint pid1, Ncm.ModelID mid2, uint pid2);
		public double covar_cov (Ncm.ModelID mid1, uint pid1, Ncm.ModelID mid2, uint pid2);
		public double covar_fparam_cor (uint fpi1, uint fpi2);
		public double covar_fparam_cov (uint fpi1, uint fpi2);
		public double covar_fparam_sd (uint fpi);
		public double covar_fparam_var (uint fpi);
		public double covar_sd (Ncm.ModelID mid, uint pid);
		public double covar_var (Ncm.ModelID mid, uint pid);
		public void data_m2lnL_val (out double data_m2lnL);
		public void dprob (Ncm.ModelID mid, uint pid, double a, double b, double step, double norm);
		public Ncm.Fit dup (Ncm.Serialize ser);
		public void fishermatrix_print (int @out, string header);
		public void free ();
		public double function_cov (Ncm.MSetFunc func1, double z1, Ncm.MSetFunc func2, double z2, bool pretty_print);
		public void function_error (Ncm.MSetFunc func, double x, bool pretty_print, out double f, out double sigma_f);
		public Ncm.Matrix get_covar ();
		public virtual unowned string get_desc ();
		public double get_m2lnL_abstol ();
		public double get_m2lnL_reltol ();
		public uint get_maxiter ();
		public double get_params_reltol ();
		public Ncm.Fit get_sub_fit ();
		public uint has_equality_constraints ();
		public uint has_inequality_constraints ();
		public bool is_least_squares ();
		public void log_covar ();
		public void log_end ();
		public void log_info ();
		public void log_start ();
		public void log_state ();
		public void log_step ();
		public double lr_test (Ncm.ModelID mid, uint pid, double val, int dof);
		public void lr_test_range (Ncm.ModelID mid, uint pid, double start, double stop, double step);
		public void ls_J (Ncm.Matrix J);
		public void ls_J_an (Ncm.Matrix J);
		public void ls_J_nd_ce (Ncm.Matrix J);
		public void ls_J_nd_fo (Ncm.Matrix J);
		public void ls_covar ();
		public void ls_f (Ncm.Vector f);
		public void ls_f_J (Ncm.Vector f, Ncm.Matrix J);
		public void ls_f_J_an (Ncm.Vector f, Ncm.Matrix J);
		public void ls_f_J_nd_ce (Ncm.Vector f, Ncm.Matrix J);
		public void ls_f_J_nd_fo (Ncm.Vector f, Ncm.Matrix J);
		public void m2lnL_grad (Ncm.Vector df);
		public void m2lnL_grad_an (Ncm.Vector df);
		public void m2lnL_grad_nd_ac (Ncm.Vector grad);
		public void m2lnL_grad_nd_ce (Ncm.Vector grad);
		public void m2lnL_grad_nd_fo (Ncm.Vector grad);
		public void m2lnL_hessian_nd_ce (Ncm.Matrix hessian);
		public void m2lnL_val (out double m2lnL);
		public void m2lnL_val_grad (out double result, Ncm.Vector df);
		public void m2lnL_val_grad_an (out double result, Ncm.Vector df);
		public void m2lnL_val_grad_nd_ac (out double m2lnL, Ncm.Vector grad);
		public void m2lnL_val_grad_nd_ce (double m2lnL, Ncm.Vector grad);
		public void m2lnL_val_grad_nd_fo (out double m2lnL, Ncm.Vector grad);
		public void numdiff_m2lnL_covar ();
		public void numdiff_m2lnL_hessian (Ncm.Matrix H, double reltol);
		public double numdiff_m2lnL_lndet_covar ();
		public void params_set (uint i, double x);
		public void params_set_array (double x);
		public void params_set_vector (Ncm.Vector x);
		public void params_set_vector_offset (Ncm.Vector x, uint offset);
		public void params_update ();
		public void priors_m2lnL_val (out double priors_m2lnL);
		public double prob (Ncm.ModelID mid, uint pid, double a, double b);
		public Ncm.Fit @ref ();
		public void remove_equality_constraints ();
		public void remove_inequality_constraints ();
		public virtual void reset ();
		public double residual_ks_test (out double o_mean, out double o_sd, out double o_skew, out double o_kurtosis, out double o_max);
		public virtual bool run (Ncm.FitRunMsgs mtype);
		public void set_grad_type (Ncm.FitGradType gtype);
		public void set_m2lnL_abstol (double tol);
		public void set_m2lnL_reltol (double tol);
		public void set_maxiter (uint maxiter);
		public void set_params_reltol (double tol);
		public void set_sub_fit (Ncm.Fit sub_fit);
		public double type_constrain_error (double p, int nu, double dir, Ncm.MSetFunc func, double z, bool walk);
		[NoAccessorMethod]
		public int64 equality_constraints { get; set; }
		[NoAccessorMethod]
		public Ncm.FitGradType grad_type { get; set construct; }
		[NoAccessorMethod]
		public int64 inequality_constraints { get; set; }
		[NoAccessorMethod]
		public Ncm.Likelihood likelihood { owned get; construct; }
		public double m2lnL_abstol { get; set construct; }
		public double m2lnL_reltol { get; set construct; }
		public uint maxiter { get; set construct; }
		[NoAccessorMethod]
		public Ncm.MSet mset { owned get; construct; }
		public double params_reltol { get; set construct; }
		[NoAccessorMethod]
		public Ncm.FitState state { owned get; construct; }
		public Ncm.Fit sub_fit { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ncm_fit_constraint_get_type ()")]
	[Compact]
	public class FitConstraint {
		[CCode (has_construct_function = false)]
		public FitConstraint (Ncm.Fit fit, Ncm.MSetFunc func, double tot);
		public Ncm.FitConstraint dup ();
		public void free ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_esmcmc_get_type ()")]
	public class FitESMCMC : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitESMCMC (Ncm.Fit fit, int nwalkers, Ncm.MSetTransKern sampler, Ncm.FitESMCMCWalker? walker, Ncm.FitRunMsgs mtype);
		public static void clear (Ncm.FitESMCMC esmcmc);
		public void end_run ();
		public void free ();
		[CCode (has_construct_function = false)]
		public FitESMCMC.funcs_array (Ncm.Fit fit, int nwalkers, Ncm.MSetTransKern sampler, Ncm.FitESMCMCWalker? walker, Ncm.FitRunMsgs mtype, Ncm.ObjArray funcs_array);
		public double get_accept_ratio ();
		public Ncm.MSetCatalog get_catalog ();
		public double get_offboard_ratio ();
		public void mean_covar ();
		public void reset ();
		public void run (uint n);
		public void run_lre (uint prerun, double lre);
		public void set_data_file (string filename);
		public void set_mtype (Ncm.FitRunMsgs mtype);
		public void set_nthreads (uint nthreads);
		public void set_rng (Ncm.RNG rng);
		public void set_sampler (Ncm.MSetTransKern sampler);
		public void start_run ();
		public bool validate (ulong pi, ulong pf);
		[NoAccessorMethod]
		public string data_file { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Fit fit { owned get; construct; }
		[NoAccessorMethod]
		public Ncm.ObjArray functions_array { owned get; construct; }
		[NoAccessorMethod]
		public Ncm.FitRunMsgs mtype { get; set; }
		[NoAccessorMethod]
		public uint nthreads { get; set; }
		[NoAccessorMethod]
		public int nwalkers { get; construct; }
		[NoAccessorMethod]
		public Ncm.MSetTransKern sampler { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.FitESMCMCWalker walker { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_esmcmc_walker_get_type ()")]
	public abstract class FitESMCMCWalker : GLib.Object {
		[CCode (has_construct_function = false)]
		protected FitESMCMCWalker ();
		public virtual void clean (uint ki, uint kf);
		public static void clear (Ncm.FitESMCMCWalker walker);
		public virtual unowned string desc ();
		public void free ();
		[CCode (has_construct_function = false)]
		public FitESMCMCWalker.from_name (string walker_name);
		public virtual uint get_nparams ();
		public virtual uint get_size ();
		public virtual double prob (GLib.GenericArray<Ncm.Vector> theta, Ncm.Vector thetastar, uint k, double m2lnL_cur, double m2lnL_star);
		public Ncm.FitESMCMCWalker @ref ();
		public virtual void set_nparams (uint nparams);
		public virtual void set_size (uint size);
		public virtual void setup (GLib.GenericArray<Ncm.Vector> theta, uint ki, uint kf, Ncm.RNG rng);
		public virtual void step (GLib.GenericArray<Ncm.Vector> theta, Ncm.Vector thetastar, uint k);
		public uint nparams { get; set construct; }
		public uint size { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_esmcmc_walker_stretch_get_type ()")]
	public class FitESMCMCWalkerStretch : Ncm.FitESMCMCWalker {
		[CCode (has_construct_function = false)]
		public FitESMCMCWalkerStretch (uint nwalkers, uint nparams);
		public double get_scale ();
		public void multi (bool multi);
		public void set_box (uint n, double lb, double ub);
		public void set_box_mset (Ncm.MSet mset);
		public void set_scale (double a);
		[NoAccessorMethod]
		public bool multi_stretch { get; set construct; }
		public double scale { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_esmcmc_walker_walk_get_type ()")]
	public class FitESMCMCWalkerWalk : Ncm.FitESMCMCWalker {
		[CCode (has_construct_function = false)]
		public FitESMCMCWalkerWalk (uint nwalkers);
		public double get_scale ();
		public void set_scale (double a);
		public double scale { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", lower_case_csuffix = "fit_gsl_ls", type_id = "ncm_fit_gsl_ls_get_type ()")]
	public class FitGSLLS : Ncm.Fit {
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLLS (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", lower_case_csuffix = "fit_gsl_mm", type_id = "ncm_fit_gsl_mm_get_type ()")]
	public class FitGSLMM : Ncm.Fit {
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMM (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, Ncm.FitGSLMMAlgos algo);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMM.by_name (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, string algo_name);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMM.@default (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public void set_algo (Ncm.FitGSLMMAlgos algo);
		[NoAccessorMethod]
		public Ncm.FitGSLMMAlgos algorithm { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", lower_case_csuffix = "fit_gsl_mms", type_id = "ncm_fit_gsl_mms_get_type ()")]
	public class FitGSLMMS : Ncm.Fit {
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMMS (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, Ncm.FitGSLMMSAlgos algo);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMMS.by_name (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, string algo_name);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitGSLMMS.@default (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public void set_algo (Ncm.FitGSLMMSAlgos algo);
		[NoAccessorMethod]
		public Ncm.FitGSLMMSAlgos algorithm { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_levmar_get_type ()")]
	public class FitLevmar : Ncm.Fit {
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitLevmar (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, Ncm.FitLevmarAlgos algo);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitLevmar.by_name (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, string algo_name);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitLevmar.@default (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		public void set_algo (Ncm.FitLevmarAlgos algo);
		[NoAccessorMethod]
		public Ncm.FitLevmarAlgos algorithm { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_mc_get_type ()")]
	public class FitMC : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitMC (Ncm.Fit fit, Ncm.FitMCResampleType rtype, Ncm.FitRunMsgs mtype);
		public static void clear (Ncm.FitMC mc);
		public void end_run ();
		public void free ();
		public Ncm.MSetCatalog get_catalog ();
		public void mean_covar ();
		public void reset ();
		public void run (uint n);
		public void run_lre (uint prerun, double lre);
		public void set_data_file (string filename);
		public void set_fiducial (Ncm.MSet fiduc);
		public void set_first_sample_id (int first_sample_id);
		public void set_mtype (Ncm.FitRunMsgs mtype);
		public void set_nthreads (uint nthreads);
		public void set_rng (Ncm.RNG rng);
		public void set_rtype (Ncm.FitMCResampleType rtype);
		public void start_run ();
		[NoAccessorMethod]
		public Ncm.MSet fiducial { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.Fit fit { owned get; construct; }
		[NoAccessorMethod]
		public bool keep_order { get; set construct; }
		[NoAccessorMethod]
		public Ncm.FitRunMsgs mtype { get; set; }
		[NoAccessorMethod]
		public uint nthreads { get; set; }
		[NoAccessorMethod]
		public Ncm.FitMCResampleType rtype { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_mcbs_get_type ()")]
	public class FitMCBS : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitMCBS (Ncm.Fit fit);
		public static void clear (Ncm.FitMCBS mcbs);
		public void free ();
		public Ncm.MSetCatalog get_catalog ();
		public void run (Ncm.MSet fiduc, uint ni, uint nf, uint nbstraps, Ncm.FitMCResampleType rtype, Ncm.FitRunMsgs mtype, uint bsmt);
		public void set_filename (string filename);
		public void set_rng (Ncm.RNG rng);
		[NoAccessorMethod]
		public string filename { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Fit fit { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_mcmc_get_type ()")]
	public class FitMCMC : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitMCMC (Ncm.Fit fit, Ncm.MSetTransKern tkern, Ncm.FitRunMsgs mtype);
		public static void clear (Ncm.FitMCMC mcmc);
		public void end_run ();
		public void free ();
		public double get_accept_ratio ();
		public Ncm.MSetCatalog get_catalog ();
		public void mean_covar ();
		public void reset ();
		public void run (uint n);
		public void run_lre (uint prerun, double lre);
		public void set_data_file (string filename);
		public void set_fiducial (Ncm.MSet fiduc);
		public void set_first_sample_id (int first_sample_id);
		public void set_mtype (Ncm.FitRunMsgs mtype);
		public void set_nthreads (uint nthreads);
		public void set_rng (Ncm.RNG rng);
		public void set_trans_kern (Ncm.MSetTransKern tkern);
		public void start_run ();
		[NoAccessorMethod]
		public Ncm.Fit fit { owned get; construct; }
		[NoAccessorMethod]
		public Ncm.FitRunMsgs mtype { get; set; }
		[NoAccessorMethod]
		public uint nthreads { get; set; }
		[NoAccessorMethod]
		public Ncm.MSetTransKern sampler { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", lower_case_csuffix = "fit_nlopt", type_id = "ncm_fit_nlopt_get_type ()")]
	public class FitNLOpt : Ncm.Fit {
		[CCode (has_construct_function = false)]
		protected FitNLOpt ();
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitNLOpt.by_name (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype, string algo_name);
		[CCode (has_construct_function = false, type = "NcmFit*")]
		public FitNLOpt.@default (Ncm.Likelihood lh, Ncm.MSet mset, Ncm.FitGradType gtype);
		[NoAccessorMethod]
		public Ncm.FitNloptAlgorithm algorithm { get; set construct; }
		[NoAccessorMethod]
		public Ncm.FitNloptAlgorithm local_algorithm { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_fit_state_get_type ()")]
	public class FitState : GLib.Object {
		[CCode (has_construct_function = false)]
		public FitState (uint data_len, uint fparam_len, int dof, bool is_least_squares);
		public static void clear (Ncm.FitState fstate);
		public void free ();
		public double get_m2lnL_prec ();
		public uint get_niter ();
		public double get_params_prec ();
		public void realloc ();
		public Ncm.FitState @ref ();
		public void reset ();
		public void set_all (uint data_len, uint fparam_len, int dof, bool is_least_squares);
		public void set_ls (Ncm.Vector f, Ncm.Matrix J);
		public void set_m2lnL_prec (double prec);
		public void set_niter (uint niter);
		public void set_params_prec (double prec);
		[NoAccessorMethod]
		public uint data_len { get; set construct; }
		[NoAccessorMethod]
		public int dof { get; set construct; }
		[NoAccessorMethod]
		public uint fparam_len { get; set construct; }
		[NoAccessorMethod]
		public uint func_eval { get; }
		[NoAccessorMethod]
		public uint grad_eval { get; }
		[NoAccessorMethod]
		public bool is_best_fit { get; }
		[NoAccessorMethod]
		public bool is_least_squares { get; set construct; }
		[NoAccessorMethod]
		public uint niters { get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_integral1d_get_type ()")]
	public class Integral1d : GLib.Object {
		[CCode (has_construct_function = false)]
		public Integral1d (Ncm.Integral1dF F);
		public static void clear (Ncm.Integral1d int1d);
		public double eval (double xi, double xf, void* userdata, out double err);
		public double eval_gauss_hermite (void* userdata, out double err);
		public double eval_gauss_hermite_mur (double r, double mu, void* userdata, out double err);
		public double eval_gauss_hermite_p (void* userdata, out double err);
		public double eval_gauss_hermite_r_p (double r, void* userdata, out double err);
		public double eval_gauss_laguerre (void* userdata, out double err);
		public double eval_gauss_laguerre_r (double r, void* userdata, out double err);
		public void free ();
		[CCode (has_construct_function = false)]
		public Integral1d.full (Ncm.Integral1dF F, double reltol, double abstol, uint partition, uint rule);
		public double get_abstol ();
		public uint get_partition ();
		public double get_reltol ();
		public uint get_rule ();
		public Ncm.Integral1d @ref ();
		public void set_abstol (double abstol);
		public void set_partition (uint partition);
		public void set_reltol (double reltol);
		public void set_rule (uint rule);
		public double abstol { get; set construct; }
		[NoAccessorMethod]
		public void* integrand { get; construct; }
		public uint partition { get; set construct; }
		public double reltol { get; set construct; }
		public uint rule { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_lh_ratio1d_get_type ()")]
	public class LHRatio1d : GLib.Object {
		[CCode (has_construct_function = false)]
		public LHRatio1d (Ncm.Fit fit, Ncm.MSetPIndex pi);
		public static void clear (Ncm.LHRatio1d lhr1d);
		public void find_bounds (double clevel, Ncm.FitRunMsgs mtype, out double lb, out double ub);
		public void free ();
		public void set_pindex (Ncm.MSetPIndex pi);
		[NoAccessorMethod]
		public Ncm.MSetFunc constraint { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Fit fit { owned get; construct; }
		[NoAccessorMethod]
		public Ncm.MSetPIndex pi { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_lh_ratio2d_get_type ()")]
	public class LHRatio2d : GLib.Object {
		[CCode (has_construct_function = false)]
		public LHRatio2d (Ncm.Fit fit, Ncm.MSetPIndex pi1, Ncm.MSetPIndex pi2, double border_prec);
		public static void clear (Ncm.LHRatio2d lhr2d);
		public Ncm.LHRatio2dRegion conf_region (double clevel, double expected_np, Ncm.FitRunMsgs mtype);
		public Ncm.LHRatio2dRegion fisher_border (double clevel, double expected_np, Ncm.FitRunMsgs mtype);
		public void free ();
		public void set_pindex (Ncm.MSetPIndex pi1, Ncm.MSetPIndex pi2);
		[NoAccessorMethod]
		public double border_prec { get; set construct; }
		public Ncm.Fit fit { construct; }
		[NoAccessorMethod]
		public Ncm.MSetPIndex pi1 { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.MSetPIndex pi2 { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ncm_lh_ratio2d_region_get_type ()")]
	[Compact]
	public class LHRatio2dRegion {
		public double clevel;
		public uint np;
		public weak Ncm.Vector p1;
		public weak Ncm.Vector p2;
		public static void clear (Ncm.LHRatio2dRegion rg);
		public Ncm.LHRatio2dRegion dup ();
		public void free ();
		public void print (int @out);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_likelihood_get_type ()")]
	public class Likelihood : GLib.Object {
		[CCode (has_construct_function = false)]
		public Likelihood (Ncm.Dataset dset);
		public static void clear (Ncm.Likelihood lh);
		public Ncm.Likelihood dup (Ncm.Serialize ser);
		public void free ();
		public bool has_leastsquares_J ();
		public bool has_m2lnL_grad ();
		public void leastsquares_J (Ncm.MSet mset, Ncm.Matrix J);
		public void leastsquares_f (Ncm.MSet mset, Ncm.Vector f);
		public void leastsquares_f_J (Ncm.MSet mset, Ncm.Vector f, Ncm.Matrix J);
		public void m2lnL_grad (Ncm.MSet mset, Ncm.Vector grad);
		public void m2lnL_val (Ncm.MSet mset, out double m2lnL);
		public void m2lnL_val_grad (Ncm.MSet mset, out double m2lnL, Ncm.Vector grad);
		public void priors_add (Ncm.Prior prior);
		public void priors_add_flat_func (Ncm.MSetFunc mean_func, double x_low, double x_upp, double scale, double variable);
		public void priors_add_flat_param (Ncm.ModelID mid, uint pid, double x_low, double x_upp, double scale);
		public void priors_add_flat_param_name (Ncm.MSet mset, string name, double x_low, double x_upp, double scale);
		public void priors_add_flat_param_pindex (Ncm.MSetPIndex pi, double x_low, double x_upp, double scale);
		public void priors_add_gauss_func (Ncm.MSetFunc mean_func, double mu, double sigma, double @var);
		public void priors_add_gauss_param (Ncm.ModelID mid, uint pid, double mu, double sigma);
		public void priors_add_gauss_param_name (Ncm.MSet mset, string name, double mu, double sigma);
		public void priors_add_gauss_param_pindex (Ncm.MSetPIndex pi, double mu, double sigma);
		public void priors_leastsquares_f (Ncm.MSet mset, Ncm.Vector priors_f);
		public uint priors_length_f ();
		public uint priors_length_m2lnL ();
		public void priors_m2lnL_val (Ncm.MSet mset, out double priors_m2lnL);
		public void priors_m2lnL_vec (Ncm.MSet mset, Ncm.Vector priors_m2lnL_v);
		public unowned Ncm.Prior priors_peek_f (uint i);
		public unowned Ncm.Prior priors_peek_m2lnL (uint i);
		public Ncm.Likelihood @ref ();
		[NoAccessorMethod]
		public Ncm.Dataset dataset { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.Vector m2lnL_v { owned get; set; }
		[NoAccessorMethod]
		public Ncm.ObjArray priors_f { owned get; set; }
		[NoAccessorMethod]
		public Ncm.ObjArray priors_m2lnL { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_get_type ()")]
	public class MSet : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MSet ();
		[CCode (has_construct_function = false)]
		public MSet.array (GLib.GenericArray<Ncm.Model> model_array);
		public static void clear (Ncm.MSet mset);
		public bool cmp (Ncm.MSet mset1, bool cmp_model);
		public Ncm.MSet dup (Ncm.Serialize ser);
		[CCode (cname = "ncm_mset_empty_new", has_construct_function = false)]
		public MSet.empty_new ();
		public bool exists (Ncm.Model model);
		public bool exists_pos (Ncm.Model model, uint stackpos_id);
		public unowned string fparam_full_name (uint n);
		public double fparam_get (uint n);
		public double fparam_get_abstol (uint n);
		public int fparam_get_fpi (Ncm.ModelID mid, uint pid);
		public double fparam_get_lower_bound (uint n);
		public unowned Ncm.MSetPIndex fparam_get_pi (uint n);
		public unowned Ncm.MSetPIndex fparam_get_pi_by_name (string name);
		public double fparam_get_scale (uint n);
		public double fparam_get_upper_bound (uint n);
		public uint fparam_len ();
		public unowned string fparam_name (uint n);
		public void fparam_set (uint n, double x);
		public void fparam_set_scale (uint n, double scale);
		public unowned string fparam_symbol (uint n);
		public bool fparam_valid_bounds (Ncm.Vector theta);
		public bool fparam_valid_bounds_offset (Ncm.Vector theta, uint offset);
		public void fparams_get_vector (Ncm.Vector x);
		public void fparams_get_vector_offset (Ncm.Vector x, uint offset);
		public uint fparams_len ();
		public void fparams_log_covar (Ncm.Matrix covar);
		public void fparams_set_array ([CCode (array_length = false)] double[] x);
		public void fparams_set_vector (Ncm.Vector x);
		public void fparams_set_vector_offset (Ncm.Vector x, uint offset);
		public void free ();
		public Ncm.Model @get (Ncm.ModelID mid);
		[CCode (array_length = false, array_null_terminated = true)]
		public string[] get_fmap ();
		public static int get_id_by_ns (string ns);
		public static int get_id_by_type (GLib.Type model_type);
		public Ncm.ModelID get_mid_array_pos (uint i);
		public static unowned string get_ns_by_id (int id);
		public static GLib.Type get_type_by_id (int id);
		public bool is_subset (Ncm.MSet sub_mset);
		public static Ncm.MSet load (string filename, Ncm.Serialize ser);
		public uint max_fparam_name ();
		public uint max_model_nick ();
		public uint max_param_name ();
		public uint nmodels ();
		public double orig_param_get (Ncm.ModelID mid, uint pid);
		public double param_get (Ncm.ModelID mid, uint pid);
		public double param_get_abstol (Ncm.ModelID mid, uint pid);
		public Ncm.MSetPIndex param_get_by_full_name (string fullname);
		public Ncm.ParamType param_get_ftype (Ncm.ModelID mid, uint pid);
		public double param_get_lower_bound (Ncm.ModelID mid, uint pid);
		public void param_get_pi (Ncm.MSetPIndex pi, double x, uint n);
		public double param_get_scale (Ncm.ModelID mid, uint pid);
		public double param_get_upper_bound (Ncm.ModelID mid, uint pid);
		public void param_get_vector (Ncm.Vector @params);
		public unowned string param_name (Ncm.ModelID mid, uint pid);
		public void param_set (Ncm.ModelID mid, uint pid, double x);
		public void param_set_all_but_mid_ftype (Ncm.ModelID mid, Ncm.ParamType ftype);
		public void param_set_all_ftype (Ncm.ParamType ftype);
		public void param_set_ftype (Ncm.ModelID mid, uint pid, Ncm.ParamType ftype);
		public void param_set_ftype_from_fmap ();
		public void param_set_mid_ftype (Ncm.ModelID mid, Ncm.ParamType ftype);
		public void param_set_pi (Ncm.MSetPIndex pi, double x, uint n);
		public void param_set_scale (Ncm.ModelID mid, uint pid, double scale);
		public void param_set_vector (Ncm.Vector @params);
		public unowned string param_symbol (Ncm.ModelID mid, uint pid);
		public void params_log_vals ();
		public void params_pretty_print (int @out, string header);
		public void params_print_vals (int @out);
		public bool params_valid ();
		public bool params_valid_bounds ();
		public unowned Ncm.Model peek (Ncm.ModelID mid);
		public unowned Ncm.Model peek_array_pos (uint i);
		public unowned Ncm.Model peek_pos (Ncm.ModelID base_mid, uint stackpos_id);
		public void prepare_fparam_map ();
		public void pretty_log ();
		public void push (Ncm.Model model);
		public Ncm.MSet @ref ();
		public void remove (Ncm.ModelID mid);
		public void save (Ncm.Serialize ser, string filename, bool save_comment);
		public void @set (Ncm.Model model);
		public void set_fmap ([CCode (array_length = false, array_null_terminated = true)] string[] fmap, bool update_models);
		public void set_pos (Ncm.Model model, uint stackpos_id);
		public Ncm.MSet shallow_copy ();
		public uint total_len ();
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] fmap { owned get; set; }
		[NoAccessorMethod]
		public Ncm.ObjArray model_array { owned get; set construct; }
		[NoAccessorMethod]
		public bool valid_map { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_catalog_get_type ()")]
	public class MSetCatalog : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MSetCatalog ();
		public void add_from_mset_array (Ncm.MSet mset, [CCode (array_length = false)] double[] ax);
		public void add_from_vector (Ncm.Vector vals);
		[CCode (has_construct_function = false)]
		public MSetCatalog.array (Ncm.MSet mset, uint nadd_vals, uint nchains, bool weighted, [CCode (array_length = false, array_null_terminated = true)] string[] names, [CCode (array_length = false, array_null_terminated = true)] string[] symbols);
		public Ncm.StatsDist1d calc_add_param_distrib (uint add_param, Ncm.FitRunMsgs mtype);
		public void calc_add_param_ensemble_evol (uint add_param, uint nsteps, Ncm.FitRunMsgs mtype, out Ncm.Vector pval, out Ncm.Matrix t_evol);
		public Ncm.Matrix calc_ci_direct (Ncm.MSetFunc func, Ncm.Vector x_v, GLib.Array<double> p_val);
		public Ncm.Matrix calc_ci_interp (Ncm.MSetFunc func, Ncm.Vector x_v, GLib.Array<double> p_val, uint nodes, Ncm.FitRunMsgs mtype);
		public Ncm.StatsDist1d calc_distrib (Ncm.MSetFunc func, Ncm.FitRunMsgs mtype);
		public Ncm.StatsDist1d calc_param_distrib (Ncm.MSetPIndex pi, Ncm.FitRunMsgs mtype);
		public void calc_param_ensemble_evol (Ncm.MSetPIndex pi, uint nsteps, Ncm.FitRunMsgs mtype, out Ncm.Vector pval, out Ncm.Matrix t_evol);
		public static void clear (Ncm.MSetCatalog mcat);
		public void erase_data ();
		public void estimate_autocorrelation_tau ();
		public void free ();
		[CCode (has_construct_function = false)]
		public MSetCatalog.from_file (string filename, long burnin);
		[CCode (has_construct_function = false)]
		public MSetCatalog.from_file_ro (string filename, long burnin);
		public long get_burnin ();
		public void get_covar (ref Ncm.Matrix? cov);
		public void get_full_covar (ref Ncm.Matrix? cov);
		public void get_mean (ref Ncm.Vector? mean);
		public Ncm.MSet get_mset ();
		public double get_param_shrink_factor (uint p);
		public Ncm.RNG? get_rng ();
		public unowned string get_run_type ();
		public double get_shrink_factor ();
		public bool is_empty ();
		public double largest_error ();
		public uint len ();
		public void log_current_chain_stats ();
		public void log_current_stats ();
		public void log_full_covar ();
		public uint max_time ();
		public void param_pdf (uint i);
		public double param_pdf_pvalue (double pval, bool both);
		public unowned Ncm.Vector peek_autocorrelation_tau ();
		public unowned Ncm.Vector peek_current_e_mean ();
		public unowned Ncm.Vector peek_current_e_var ();
		public unowned Ncm.Vector peek_current_row ();
		public unowned Ncm.Vector peek_e_mean_t (uint t);
		public unowned Ncm.Vector peek_e_var_t (uint t);
		public unowned string peek_filename ();
		public unowned Ncm.Vector peek_row (uint i);
		public Ncm.MSetCatalog @ref ();
		public void reset ();
		public void reset_stats ();
		public void set_burnin (long burnin);
		public void set_file (string filename);
		public void set_first_id (int first_id);
		public void set_rng (Ncm.RNG rng);
		public void set_run_type (string rtype_str);
		public void set_sync_interval (double interval);
		public void set_sync_mode (Ncm.MSetCatalogSync smode);
		public void sync (bool check);
		public void timed_sync (bool check);
		public long burnin { get; set construct; }
		[NoAccessorMethod]
		public string filename { owned get; set construct; }
		public Ncm.MSet mset { owned get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] nadd_val_names { owned get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] nadd_val_symbols { owned get; construct; }
		[NoAccessorMethod]
		public uint nadd_vals { get; construct; }
		[NoAccessorMethod]
		public uint nchains { get; construct; }
		[NoAccessorMethod]
		public bool read_only { get; construct; }
		public Ncm.RNG rng { owned get; set; }
		[NoAccessorMethod]
		public string run_type_string { owned get; set construct; }
		[NoAccessorMethod]
		public Ncm.MSetCatalogSync smode { get; set construct; }
		[NoAccessorMethod]
		public double sync_interval { get; set construct; }
		[NoAccessorMethod]
		public bool weighted { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_func_get_type ()")]
	public class MSetFunc : GLib.Object {
		[CCode (has_construct_function = false)]
		public MSetFunc ([CCode (destroy_notify_pos = 4.1)] owned Ncm.MSetFuncN func, uint nvar, uint dim, void* obj);
		public static GLib.GenericArray<Ncm.MSetFunc> array_new ();
		public static void clear (Ncm.MSetFunc func);
		public virtual void eval (Ncm.MSet mset, [CCode (array_length = false)] double[] x, [CCode (array_length = false)] out unowned double[] res);
		public double eval0 (Ncm.MSet mset);
		public double eval1 (Ncm.MSet mset, double x);
		public double eval_nvar (Ncm.MSet mset, double x);
		public void eval_vector (Ncm.MSet mset, Ncm.Vector x_v, Ncm.Vector res_v);
		public void free ();
		public uint get_dim ();
		public uint get_nvar ();
		public bool has_nvar (uint nvar);
		public bool is_const ();
		public bool is_scalar ();
		public bool is_vector (uint dim);
		public Ncm.Vector numdiff_fparams (Ncm.MSet mset, double x, out Ncm.Vector @out);
		public unowned string peek_desc ();
		public unowned string peek_name ();
		public unowned string peek_ns ();
		public unowned string peek_symbol ();
		public unowned string peek_uname ();
		public unowned string peek_usymbol ();
		public Ncm.MSetFunc @ref ();
		public void set_eval_x ([CCode (array_length_cname = "len", array_length_pos = 1.1, array_length_type = "guint")] double[] x);
		[NoAccessorMethod]
		public uint dimension { get; construct; }
		[NoAccessorMethod]
		public Ncm.Vector eval_x { owned get; set; }
		[NoAccessorMethod]
		public uint nvariables { get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_func_list_get_type ()")]
	public class MSetFuncList : Ncm.MSetFunc {
		[CCode (has_construct_function = false)]
		public MSetFuncList (string full_name, GLib.Object? obj);
		public static bool has_full_name (string full_name);
		public static bool has_ns_name (string ns, string name);
		[CCode (has_construct_function = false)]
		public MSetFuncList.ns_name (string ns, string name, GLib.Object? obj);
		public static void register (string name, string symbol, string ns, string desc, GLib.Type obj_type, Ncm.MSetFuncListN func, uint nvar, uint dim);
		public static GLib.Array<Ncm.MSetFuncListStruct> select (string? ns, int nvar, int dim);
		[NoAccessorMethod]
		public string full_name { owned get; construct; }
		[NoAccessorMethod]
		public GLib.Object object { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ncm_mset_pindex_get_type ()")]
	[Compact]
	public class MSetPIndex {
		[CCode (has_construct_function = false)]
		public MSetPIndex (Ncm.ModelID mid, uint pid);
		public Ncm.MSetPIndex dup ();
		public void free ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_trans_kern_get_type ()")]
	public abstract class MSetTransKern : GLib.Object {
		[CCode (has_construct_function = false)]
		protected MSetTransKern ();
		public static void clear (Ncm.MSetTransKern tkern);
		public void free ();
		public virtual void generate (Ncm.Vector theta, Ncm.Vector thetastar, Ncm.RNG rng);
		public virtual unowned string get_name ();
		public virtual double pdf (Ncm.Vector theta, Ncm.Vector thetastar);
		public double prior_pdf (Ncm.Vector thetastar);
		public void prior_sample (Ncm.Vector thetastar, Ncm.RNG rng);
		public Ncm.MSetTransKern @ref ();
		public virtual void set_mset (Ncm.MSet mset);
		public void set_prior (Ncm.Vector theta);
		public void set_prior_from_mset ();
		[NoAccessorMethod]
		public Ncm.MSet mset { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_trans_kern_cat_get_type ()")]
	public class MSetTransKernCat : Ncm.MSetTransKern {
		[CCode (has_construct_function = false)]
		public MSetTransKernCat (Ncm.MSetCatalog mcat);
		[NoAccessorMethod]
		public Ncm.MSetCatalog catalog { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_trans_kern_flat_get_type ()")]
	public class MSetTransKernFlat : Ncm.MSetTransKern {
		[CCode (has_construct_function = false)]
		public MSetTransKernFlat ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_mset_trans_kern_gauss_get_type ()")]
	public class MSetTransKernGauss : Ncm.MSetTransKern {
		[CCode (has_construct_function = false)]
		public MSetTransKernGauss (uint len);
		public Ncm.Matrix get_cov ();
		public uint get_size ();
		public void set_cov (Ncm.Matrix cov);
		public void set_cov_from_rescale (double epsilon);
		public void set_cov_from_scale ();
		public void set_cov_variant (GLib.Variant cov);
		public void set_size (uint len);
		public Ncm.Matrix cov { owned get; set; }
		[NoAccessorMethod]
		public uint length { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_matrix_get_type ()")]
	public class Matrix : GLib.Object {
		[CCode (has_construct_function = false)]
		public Matrix (uint nrows, uint ncols);
		public void add_mul (double alpha, Ncm.Matrix b);
		public void addto (uint i, uint j, double val);
		[CCode (has_construct_function = false)]
		public Matrix.array (GLib.Array<double> a, uint ncols);
		public int cholesky_decomp (char UL);
		public int cholesky_inverse (char UL);
		public static void clear (Ncm.Matrix cm);
		public uint col_len ();
		public double const_data ();
		public void const_free ();
		[CCode (cname = "ncm_matrix_const_new_data", has_construct_function = false, type = "const NcmMatrix*")]
		public Matrix.const_new_data (double d, uint nrows, uint ncols);
		[CCode (cname = "ncm_matrix_const_new_variant", has_construct_function = false, type = "const NcmMatrix*")]
		public Matrix.const_new_variant (GLib.Variant @var);
		public double const_ptr (uint i, uint j);
		public void copy_triangle (char UL);
		public double data ();
		public void dsymm (char UL, double alpha, Ncm.Matrix b, double beta, Ncm.Matrix c);
		public Ncm.Matrix dup ();
		public double fast_get (uint ij);
		public void fast_set (uint ij, double val);
		public void free ();
		[CCode (has_construct_function = false)]
		public Matrix.full (double d, uint nrows, uint ncols, uint tda, void* pdata, GLib.DestroyNotify? pfree);
		public double @get (uint i, uint j);
		public GLib.Array<weak double> get_array ();
		public Ncm.Vector get_col (uint col);
		public Ncm.Vector get_row (uint row);
		public Ncm.Matrix get_submatrix (uint k1, uint k2, uint nrows, uint ncols);
		public GLib.Variant get_variant ();
		public void log_vals (string prefix, string format);
		public void memcpy (Ncm.Matrix cm2);
		public uint ncols ();
		public static Ncm.Matrix new0 (uint nrows, uint ncols);
		public uint nrows ();
		public GLib.Variant peek_variant ();
		public double ptr (uint i, uint j);
		public Ncm.Matrix @ref ();
		public uint row_len ();
		public void scale (double val);
		public void @set (uint i, uint j, double val);
		public void set_all (double val);
		public void set_col (uint n, Ncm.Vector cv);
		public void set_colmajor (uint i, uint j, double val);
		public void set_from_array (GLib.Array<double> a);
		public void set_from_data ([CCode (array_length = false)] double[] data);
		public void set_from_variant (GLib.Variant @var);
		public void set_identity ();
		public void set_zero ();
		public uint size ();
		public static void substitute (Ncm.Matrix cm, Ncm.Matrix? nm, bool check_size);
		public uint tda ();
		public void transpose ();
		[CCode (has_construct_function = false)]
		public Matrix.variant (GLib.Variant @var);
		[NoAccessorMethod]
		public GLib.Variant values { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_model_get_type ()")]
	public abstract class Model : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Model ();
		[CCode (cname = "ncm_model_class_add_params")]
		public class void add_params (uint sparam_len, uint vparam_len, uint nonparam_prop_len);
		public virtual void add_submodel (Ncm.Model submodel);
		public bool check_impl (uint64 impl);
		[CCode (cname = "ncm_model_class_check_params_info")]
		public class void check_params_info ();
		public static void clear (Ncm.Model model);
		public Ncm.Model dup (Ncm.Serialize ser);
		public void free ();
		public uint get_submodel_len ();
		public Ncm.ModelID id ();
		public static Ncm.ModelID id_by_type (GLib.Type model_type);
		public uint64 impl ();
		public bool is_equal (Ncm.Model model2);
		public bool is_submodel ();
		public uint len ();
		public Ncm.ModelID main_model ();
		public double orig_param_get (uint n);
		public double orig_param_get_abstol (uint n);
		public double orig_param_get_by_name (string param_name);
		public double orig_param_get_lower_bound (uint n);
		public double orig_param_get_scale (uint n);
		public double orig_param_get_upper_bound (uint n);
		public bool orig_param_index_from_name (string param_name, out uint i);
		public unowned string orig_param_name (uint n);
		public void orig_param_set (uint n, double val);
		public void orig_param_set_by_name (string param_name, double val);
		public unowned string orig_param_symbol (uint n);
		public void orig_params_log_all ();
		public unowned Ncm.Vector orig_params_peek_vector ();
		public void orig_params_update ();
		public double orig_vparam_get (uint n, uint i);
		public Ncm.Vector orig_vparam_get_vector (uint n);
		public void orig_vparam_set (uint n, uint i, double val);
		public void orig_vparam_set_vector (uint n, Ncm.Vector val);
		public bool param_finite (uint i);
		public double param_get (uint n);
		public double param_get_abstol (uint n);
		public double param_get_by_name (string param_name);
		public Ncm.ParamType param_get_ftype (uint n);
		public double param_get_lower_bound (uint n);
		public double param_get_scale (uint n);
		public double param_get_upper_bound (uint n);
		public bool param_index_from_name (string param_name, out uint i);
		public unowned string param_name (uint n);
		public unowned Ncm.SParam param_peek_desc (uint n);
		public void param_set (uint n, double val);
		public void param_set_abstol (uint n, double abstol);
		public void param_set_by_name (string param_name, double val);
		public void param_set_default (uint n);
		public void param_set_ftype (uint n, Ncm.ParamType ptype);
		public void param_set_lower_bound (uint n, double lb);
		public void param_set_scale (uint n, double scale);
		public void param_set_upper_bound (uint n, double ub);
		public unowned string param_symbol (uint n);
		public void params_copyto (Ncm.Model model_dest);
		public bool params_finite ();
		public Ncm.Vector params_get_all ();
		public void params_log_all ();
		public void params_save_as_default ();
		public void params_set_all_data (double data);
		public void params_set_default ();
		public void params_set_model (Ncm.Model model_src);
		public void params_set_vector (Ncm.Vector v);
		public void params_update ();
		public bool params_valid ();
		public bool params_valid_bounds ();
		public unowned Ncm.Reparam peek_reparam ();
		public unowned Ncm.Model peek_submodel (uint i);
		public unowned Ncm.Model peek_submodel_by_mid (Ncm.ModelID mid);
		public int peek_submodel_pos_by_mid (Ncm.ModelID mid);
		public Ncm.Model @ref ();
		public void reparam_J (Ncm.Matrix fJ, Ncm.Matrix J);
		public void reparam_df (Ncm.Vector fv, Ncm.Vector v);
		[CCode (cname = "ncm_model_class_set_name_nick")]
		public class void set_name_nick (string name, string nick);
		public void set_reparam (Ncm.Reparam reparam);
		[CCode (cname = "ncm_model_class_set_sparam")]
		public class void set_sparam (uint sparam_id, string symbol, string name, double lower_bound, double upper_bound, double scale, double abstol, double default_value, Ncm.ParamType ppt);
		[CCode (cname = "ncm_model_class_set_sparam_obj")]
		public class void set_sparam_obj (uint sparam_id, Ncm.SParam sparam);
		[CCode (cname = "ncm_model_class_set_vparam")]
		public class void set_vparam (uint vparam_id, uint default_length, string symbol, string name, double lower_bound, double upper_bound, double scale, double abstol, double default_value, Ncm.ParamType ppt);
		[CCode (cname = "ncm_model_class_set_vparam_obj")]
		public class void set_vparam_obj (uint vparam_id, Ncm.VParam vparam);
		public uint sparam_len ();
		public bool state_is_update ();
		public void state_set_update ();
		public static bool type_is_submodel (GLib.Type model_type);
		public static Ncm.ModelID type_main_model (GLib.Type model_type);
		[NoWrapper]
		public virtual bool valid ();
		public uint vparam_array_len ();
		public uint vparam_index (uint n, uint i);
		public uint vparam_len (uint n);
		[NoAccessorMethod]
		public uint64 implementation { get; }
		[NoAccessorMethod]
		public string name { owned get; }
		[NoAccessorMethod]
		public string nick { owned get; }
		[NoAccessorMethod]
		public GLib.Array<void*> params_types { owned get; }
		[NoAccessorMethod]
		public Ncm.Reparam reparam { owned get; set; }
		[NoAccessorMethod]
		public uint scalar_params_len { get; }
		[NoAccessorMethod]
		public Ncm.ObjArray submodel_array { owned get; set; }
		[NoAccessorMethod]
		public uint vector_params_len { get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_model_builder_get_type ()")]
	public class ModelBuilder : GLib.Object {
		[CCode (has_construct_function = false)]
		public ModelBuilder (GLib.Type ptype, string name, string desc);
		public void add_sparam (string symbol, string name, double lower_bound, double upper_bound, double scale, double abstol, double default_value, Ncm.ParamType ppt);
		public void add_sparam_obj (Ncm.SParam sparam);
		public void add_vparam (uint default_length, string symbol, string name, double lower_bound, double upper_bound, double scale, double abstol, double default_value, Ncm.ParamType ppt);
		public void add_vparam_obj (Ncm.VParam vparam);
		public GLib.Type create ();
		public Ncm.ModelBuilder @ref ();
		[NoAccessorMethod]
		public string description { owned get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		[NoAccessorMethod]
		public GLib.Type parent_type { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_model_ctrl_get_type ()")]
	public class ModelCtrl : GLib.Object {
		[CCode (has_construct_function = false)]
		public ModelCtrl (Ncm.Model? model);
		public static void clear (Ncm.ModelCtrl ctrl);
		public void force_update ();
		public void free ();
		public Ncm.Model get_model ();
		public bool model_has_submodel (Ncm.ModelID mid);
		public bool model_last_update ();
		public bool model_update (Ncm.Model model);
		public bool set_model (Ncm.Model model);
		public bool submodel_last_update (Ncm.ModelID mid);
		public bool update (Ncm.Model model);
		[NoAccessorMethod]
		public Ncm.Model model { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", ref_function = "ncm_obj_array_ref", type_id = "ncm_obj_array_get_type ()", unref_function = "ncm_obj_array_unref")]
	[Compact]
	public class ObjArray {
		[CCode (has_construct_function = false)]
		public ObjArray ();
		public void add (GLib.Object obj);
		public static void clear (Ncm.ObjArray oa);
		public Ncm.ObjArray dup (Ncm.Serialize ser);
		[CCode (has_construct_function = false)]
		public ObjArray.from_variant (Ncm.Serialize ser, GLib.Variant @var);
		public GLib.Object @get (uint i);
		public static Ncm.ObjArray load (string filename, Ncm.Serialize ser);
		public unowned GLib.Object peek (uint i);
		public Ncm.ObjArray @ref ();
		public void save (Ncm.Serialize ser, string filename, bool save_comment);
		public GLib.Variant ser (Ncm.Serialize ser);
		public void @set (uint i, GLib.Object obj);
		[CCode (cname = "ncm_obj_array_sized_new", has_construct_function = false)]
		public ObjArray.sized_new (uint n);
		public void unref ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_ode_spline_get_type ()")]
	public class OdeSpline : GLib.Object {
		[CCode (has_construct_function = false)]
		public OdeSpline (Ncm.Spline s, Ncm.OdeSplineDydx dydx);
		public static void clear (Ncm.OdeSpline os);
		public void free ();
		[CCode (has_construct_function = false)]
		public OdeSpline.full (Ncm.Spline s, Ncm.OdeSplineDydx dydx, double yi, double xi, double xf);
		public void prepare (void* userdata);
		public void set_abstol (double abstol);
		public void set_interval (double yi, double xi, double xf);
		public void set_reltol (double reltol);
		public void set_xf (double xf);
		public void set_xi (double xi);
		public void set_yi (double yi);
		[NoAccessorMethod]
		public double abs { get; set construct; }
		[NoAccessorMethod]
		public void* dydx { get; construct; }
		[NoAccessorMethod]
		public double reltol { get; set construct; }
		[NoAccessorMethod]
		public Ncm.Spline spline { owned get; set; }
		[NoAccessorMethod]
		public bool stop_hnil { get; set construct; }
		[NoAccessorMethod]
		public double xf { get; set; }
		[NoAccessorMethod]
		public double xi { get; set; }
		[NoAccessorMethod]
		public double yi { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_powspec_get_type ()")]
	public abstract class Powspec : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Powspec ();
		public static void clear (Ncm.Powspec powspec);
		public virtual double eval (Ncm.Model model, double z, double k);
		public virtual void eval_vec (Ncm.Model model, double z, Ncm.Vector k, out unowned Ncm.Vector Pk);
		public void free ();
		public double get_kmax ();
		public double get_kmin ();
		public virtual void get_nknots (out uint Nz, out uint Nk);
		public double get_zf ();
		public double get_zi ();
		public virtual void prepare (Ncm.Model model);
		public void prepare_if_needed (Ncm.Model model);
		public Ncm.Powspec @ref ();
		public void require_kmax (double kmax);
		public void require_kmin (double kmin);
		public void require_zf (double zf);
		public void require_zi (double zi);
		public void set_kmax (double kmax);
		public void set_kmin (double kmin);
		public void set_zf (double zf);
		public void set_zi (double zi);
		public double kmax { get; set construct; }
		public double kmin { get; set construct; }
		public double zf { get; set construct; }
		public double zi { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_powspec_filter_get_type ()")]
	public class PowspecFilter : GLib.Object {
		[CCode (has_construct_function = false)]
		public PowspecFilter (Ncm.Powspec ps, Ncm.PowspecFilterType type);
		public static void clear (Ncm.PowspecFilter psf);
		public double eval_dlnvar_dlnr (double z, double lnr);
		public double eval_dlnvar_dr (double z, double lnr);
		public double eval_dnlnvar_dlnrn (double z, double lnr, uint n);
		public double eval_dnvar_dlnrn (double z, double lnr, uint n);
		public double eval_dvar_dlnr (double z, double lnr);
		public double eval_lnvar_lnr (double z, double lnr);
		public double eval_sigma (double z, double r);
		public double eval_sigma_lnr (double z, double lnr);
		public double eval_var (double z, double r);
		public double eval_var_lnr (double z, double lnr);
		public void free ();
		public double get_r_max ();
		public double get_r_min ();
		public void prepare (Ncm.Model model);
		public void prepare_if_needed (Ncm.Model model);
		public Ncm.PowspecFilter @ref ();
		public void set_best_lnr0 ();
		public void set_lnr0 (double lnr0);
		public void set_type (Ncm.PowspecFilterType type);
		public void set_zf (double zf);
		public void set_zi (double zi);
		public double volume_rm3 ();
		[NoAccessorMethod]
		public double lnr0 { get; set; }
		[NoAccessorMethod]
		public Ncm.Powspec powerspectrum { owned get; construct; }
		[NoAccessorMethod]
		public double reltol { get; set construct; }
		[NoAccessorMethod]
		public Ncm.PowspecFilterType type { get; set construct; }
		[NoAccessorMethod]
		public double zf { get; set; }
		[NoAccessorMethod]
		public double zi { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_prior_get_type ()")]
	public class Prior : Ncm.MSetFunc {
		[CCode (has_construct_function = false)]
		protected Prior ();
		public static void clear (Ncm.Prior prior);
		public void free ();
		public bool is_m2lnL ();
		public Ncm.Prior @ref ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_prior_flat_get_type ()")]
	public class PriorFlat : Ncm.Prior {
		[CCode (has_construct_function = false)]
		protected PriorFlat ();
		public static void clear (Ncm.PriorFlat pf);
		public void free ();
		[NoWrapper]
		public virtual double mean (Ncm.MSet mset);
		public Ncm.PriorFlat @ref ();
		[NoAccessorMethod]
		public double scale { get; set construct; }
		[NoAccessorMethod]
		public double variable { get; set construct; }
		[NoAccessorMethod]
		public double x_low { get; set construct; }
		[NoAccessorMethod]
		public double x_upp { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_prior_flat_func_get_type ()")]
	public class PriorFlatFunc : Ncm.PriorFlat {
		[CCode (has_construct_function = false)]
		public PriorFlatFunc (Ncm.MSetFunc mean_func, double x_low, double x_upp, double scale, double variable);
		public static void clear (Ncm.PriorFlatFunc pff);
		public void free ();
		public Ncm.PriorFlatFunc @ref ();
		[NoAccessorMethod]
		public Ncm.MSetFunc mean_func { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_prior_flat_param_get_type ()")]
	public class PriorFlatParam : Ncm.PriorFlat {
		[CCode (has_construct_function = false)]
		public PriorFlatParam (Ncm.ModelID mid, uint pid, double x_low, double x_upp, double scale);
		public static void clear (Ncm.PriorFlatParam pfp);
		public void free ();
		[CCode (has_construct_function = false)]
		public PriorFlatParam.name (Ncm.MSet mset, string name, double x_low, double x_upp, double scale);
		[CCode (has_construct_function = false)]
		public PriorFlatParam.pindex (Ncm.MSetPIndex pi, double x_low, double x_upp, double scale);
		public Ncm.PriorFlatParam @ref ();
		[NoAccessorMethod]
		public int mid { get; set construct; }
		[NoAccessorMethod]
		public uint pid { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_prior_gauss_get_type ()")]
	public class PriorGauss : Ncm.Prior {
		[CCode (has_construct_function = false)]
		protected PriorGauss ();
		public static void clear (Ncm.PriorGauss pg);
		public void free ();
		[NoWrapper]
		public virtual double mean (Ncm.MSet mset);
		public Ncm.PriorGauss @ref ();
		[NoAccessorMethod]
		public double mu { get; set construct; }
		[NoAccessorMethod]
		public double sigma { get; set construct; }
		[NoAccessorMethod]
		public double variable { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_prior_gauss_func_get_type ()")]
	public class PriorGaussFunc : Ncm.PriorGauss {
		[CCode (has_construct_function = false)]
		public PriorGaussFunc (Ncm.MSetFunc mean_func, double mu, double sigma, double @var);
		public static void clear (Ncm.PriorGaussFunc pgf);
		public void free ();
		public Ncm.PriorGaussFunc @ref ();
		[NoAccessorMethod]
		public Ncm.MSetFunc mean_func { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_prior_gauss_param_get_type ()")]
	public class PriorGaussParam : Ncm.PriorGauss {
		[CCode (has_construct_function = false)]
		public PriorGaussParam (Ncm.ModelID mid, uint pid, double mu, double sigma);
		public static void clear (Ncm.PriorGaussParam pgp);
		public void free ();
		[CCode (has_construct_function = false)]
		public PriorGaussParam.name (Ncm.MSet mset, string name, double mu, double sigma);
		[CCode (has_construct_function = false)]
		public PriorGaussParam.pindex (Ncm.MSetPIndex pi, double mu, double sigma);
		public Ncm.PriorGaussParam @ref ();
		[NoAccessorMethod]
		public int mid { get; set construct; }
		[NoAccessorMethod]
		public uint pid { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "ncm_quaternion_get_type ()")]
	[Compact]
	public class Quaternion {
		[CCode (has_construct_function = false)]
		public Quaternion ();
		public void conjugate ();
		public void conjugate_q_mul (Ncm.Quaternion u, Ncm.Quaternion res);
		public void conjugate_u_mul (Ncm.Quaternion u, Ncm.Quaternion res);
		public Ncm.Quaternion dup ();
		public void free ();
		[CCode (has_construct_function = false)]
		public Quaternion.from_data (double x, double y, double z, double theta);
		[CCode (has_construct_function = false)]
		public Quaternion.from_vector (Ncm.TriVec v);
		public void inv_rotate (Ncm.TriVec v);
		public void lmul (Ncm.Quaternion u);
		public void memcpy (Ncm.Quaternion orig);
		public void mul (Ncm.Quaternion u, Ncm.Quaternion res);
		public double norm ();
		public void normalize ();
		public void rmul (Ncm.Quaternion u);
		public void rotate (Ncm.TriVec v);
		public void set_0 ();
		public void set_I ();
		public void set_from_data (double x, double y, double z, double theta);
		public void set_random (Ncm.RNG rng);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_rng_get_type ()")]
	public class RNG : GLib.Object {
		[CCode (has_construct_function = false)]
		public RNG (string? algo);
		public bool check_seed (ulong seed);
		public static void clear (Ncm.RNG rng);
		public double exponential_gen (double mu);
		public double exppow_gen (double a, double b);
		public void free ();
		public double gaussian_gen (double mu, double sigma);
		public double gaussian_tail_gen (double a, double sigma);
		public unowned string get_algo ();
		public ulong get_seed ();
		public string get_state ();
		public double laplace_gen (double a);
		public void @lock ();
		public static Ncm.RNG pool_get (string name);
		public Ncm.RNG @ref ();
		[CCode (cname = "ncm_rng_seeded_new", has_construct_function = false)]
		public RNG.seeded_new (string? algo, ulong seed);
		public void set_algo (string algo);
		public void set_random_seed (bool allow_colisions);
		public void set_seed (ulong seed);
		public void set_state (string state);
		public double uniform_gen (double xl, double xu);
		public void unlock ();
		[NoAccessorMethod]
		public string algorithm { owned get; set construct; }
		public ulong seed { get; set; }
		public string state { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_reparam_get_type ()")]
	public abstract class Reparam : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Reparam ();
		public void M_old2new (void* model, Ncm.Matrix jac, Ncm.Matrix old_M, Ncm.Matrix new_M);
		public static void clear (Ncm.Reparam reparam);
		public void free ();
		public GLib.Type get_compat_type ();
		public Ncm.SParam get_param_desc (uint i);
		public GLib.Variant get_params_desc_dict ();
		public void grad_old2new (void* model, Ncm.Matrix jac, Ncm.Vector old_grad, Ncm.Vector new_grad);
		public bool index_from_name (string param_name, out uint i);
		public virtual bool jac (void* model, Ncm.Matrix jac);
		public virtual bool new2old (void* model);
		public virtual bool old2new (void* model);
		public unowned Ncm.SParam peek_param_desc (uint i);
		public Ncm.Reparam @ref ();
		public void set_param_desc (uint i, Ncm.SParam sp);
		public void set_param_desc_full (uint i, string name, string symbol, double lower_bound, double upper_bound, double scale, double abstol, double default_val, Ncm.ParamType ftype);
		public void set_params_desc_dict (GLib.Variant pdesc_dict);
		public string compat_type { get; construct; }
		[NoAccessorMethod]
		public uint length { get; construct; }
		[NoAccessorMethod]
		public GLib.Variant params_desc { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_reparam_linear_get_type ()")]
	public class ReparamLinear : Ncm.Reparam {
		[CCode (has_construct_function = false)]
		public ReparamLinear (uint size, Ncm.Matrix T, Ncm.Vector v);
		public void set_compat_type (GLib.Type compat_type);
		[NoAccessorMethod]
		public Ncm.Matrix matrix { owned get; construct; }
		[NoAccessorMethod]
		public Ncm.Vector vector { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_sparam_get_type ()")]
	public class SParam : GLib.Object {
		[CCode (has_construct_function = false)]
		public SParam (string name, string symbol, double lower_bound, double upper_bound, double scale, double abstol, double default_val, Ncm.ParamType ftype);
		public static void clear (Ncm.SParam sparam);
		public Ncm.SParam copy ();
		public void free ();
		public double get_absolute_tolerance ();
		public double get_default_value ();
		public Ncm.ParamType get_fit_type ();
		public double get_lower_bound ();
		public double get_scale ();
		public double get_upper_bound ();
		public Ncm.SParam @ref ();
		public void set_absolute_tolerance (double abstol);
		public void set_default_value (double default_val);
		public void set_fit_type (Ncm.ParamType ftype);
		public void set_lower_bound (double lb);
		public void set_scale (double scale);
		public void set_upper_bound (double ub);
		public void take_name (string name);
		public void take_symbol (string symbol);
		public double absolute_tolerance { get; set; }
		public double default_value { get; set; }
		public Ncm.ParamType fit_type { get; set; }
		public double lower_bound { get; set; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		public double scale { get; set; }
		[NoAccessorMethod]
		public string symbol { owned get; construct; }
		public double upper_bound { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_serialize_get_type ()")]
	public class Serialize : GLib.Object {
		[CCode (has_construct_function = false)]
		public Serialize (Ncm.SerializeOpt sopt);
		public static void clear (Ncm.Serialize ser);
		public void clear_instances ();
		public bool contain_instance (GLib.Object obj);
		public bool contain_name (string name);
		public uint count_instances ();
		public GLib.Object dup_obj (GLib.Object obj);
		public void free ();
		public GLib.Object from_file (string filename);
		public GLib.Object from_name_params (string obj_name, GLib.Variant @params);
		public GLib.Object from_string (string obj_ser);
		public GLib.Object from_variant (GLib.Variant var_obj);
		public GLib.Object get_by_name (string name);
		public static Ncm.Serialize global ();
		public static void global_clear_instances ();
		public static bool global_contain_instance (GLib.Object obj);
		public static bool global_contain_name (string name);
		public static uint global_count_instances ();
		public static GLib.Object global_dup_obj (GLib.Object obj);
		public static GLib.Object global_from_file (string filename);
		public static GLib.Object global_from_name_params (string obj_name, GLib.Variant @params);
		public static GLib.Object global_from_string (string obj_ser);
		public static GLib.Object global_from_variant (GLib.Variant var_obj);
		public static GLib.Object global_get_by_name (string name);
		public static string global_global_peek_name (void* obj);
		public static GLib.Variant global_gvalue_to_gvariant (GLib.Value val);
		public static bool global_is_named (string serobj, out string name);
		public static void global_log_stats ();
		public static void global_remove_ser (GLib.Object obj);
		public static void global_reset ();
		public static void global_set (GLib.Object obj, string name, bool overwrite);
		public static void global_set_property (GLib.Object obj, string prop_str);
		public static void global_set_property_from_key_file (GLib.Object obj, string prop_file);
		public static void global_to_file (GLib.Object obj, string filename);
		public static string global_to_string (GLib.Object obj, bool valid_variant);
		public static GLib.Variant global_to_variant (GLib.Object obj);
		public static void global_unset (GLib.Object obj);
		public GLib.Variant gvalue_to_gvariant (GLib.Value val);
		public bool is_named (string serobj, out string name);
		public void log_stats ();
		public unowned GLib.Object peek_by_name (string name);
		public unowned string peek_name (GLib.Object obj);
		public Ncm.Serialize @ref ();
		public void remove_ser (GLib.Object obj);
		public void reset ();
		public void @set (GLib.Object obj, string name, bool overwrite);
		public void set_property (GLib.Object obj, string prop_str);
		public void set_property_from_key_file (GLib.Object obj, string prop_file);
		public void to_file (GLib.Object obj, string filename);
		public string to_string (GLib.Object obj, bool valid_variant);
		public GLib.Variant to_variant (GLib.Object obj);
		public void unref ();
		public void unset (GLib.Object obj);
		[NoAccessorMethod]
		public Ncm.SerializeOpt options { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_sphere_map_get_type ()")]
	public class SphereMap : GLib.Object {
		[CCode (has_construct_function = false)]
		public SphereMap (uint nside);
		public Ncm.SphereMap clone ();
		public bool copy (Ncm.SphereMap orig);
		public double homogenize_noise (double base_sigma);
		public bool init_coord ();
		public double rotate_avg (long n);
		public bool set_order (Ncm.SphereMapOrder order, bool init_coord);
		[NoAccessorMethod]
		public uint nside { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_sphere_map_pix_get_type ()")]
	public class SphereMapPix : GLib.Object {
		[CCode (has_construct_function = false)]
		public SphereMapPix (int64 nside);
		public void add_noise (double sd, Ncm.RNG rng);
		public void add_to_ang (double theta, double phi, double s);
		public void add_to_vec (Ncm.TriVec vec, double s);
		public void alm2map ();
		public void ang2pix_nest (double theta, double phi, out int64 nest_index);
		public void ang2pix_ring (double theta, double phi, out int64 ring_index);
		public static void clear (Ncm.SphereMapPix pix);
		public void clear_pixels ();
		public void free ();
		public double get_Cl (uint l);
		public void get_alm (uint l, uint m, out double Re_alm, out double Im_alm);
		public int64 get_cap_size ();
		public Ncm.SphereMapPixCoordSys get_coordsys ();
		public uint get_lmax ();
		public int64 get_middle_size ();
		public int64 get_npix ();
		public int64 get_nrings ();
		public int64 get_nrings_cap ();
		public int64 get_nrings_middle ();
		public int64 get_nside ();
		public Ncm.SphereMapPixOrder get_order ();
		public int64 get_ring_first_index (int64 r_i);
		public int64 get_ring_size (int64 r_i);
		public void load_fits (string fits_file, string? signal_name);
		public void load_from_fits_catalog (string fits_file, string RA, string DEC, string? S);
		public int64 nest2ring (int64 nest_index);
		public void pix2ang_nest (int64 nest_index, out double theta, out double phi);
		public void pix2ang_ring (int64 ring_index, out double theta, out double phi);
		public void pix2vec_nest (int64 nest_index, Ncm.TriVec vec);
		public void pix2vec_ring (int64 ring_index, Ncm.TriVec vec);
		public void prepare_Cl ();
		public void prepare_alm ();
		public Ncm.SphereMapPix @ref ();
		public int64 ring2nest (int64 ring_index);
		public void save_fits (string fits_file, string? signal_name, bool overwrite);
		public void set_coordsys (Ncm.SphereMapPixCoordSys coordsys);
		public void set_lmax (uint lmax);
		public void set_nside (int64 nside);
		public void set_order (Ncm.SphereMapPixOrder order);
		public void vec2pix_nest (Ncm.TriVec vec, out int64 nest_index);
		public void vec2pix_ring (Ncm.TriVec vec, out int64 ring_index);
		public Ncm.SphereMapPixCoordSys coordsys { get; set construct; }
		public uint lmax { get; set construct; }
		public int64 nside { get; set construct; }
		public Ncm.SphereMapPixOrder order { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline_get_type ()")]
	public abstract class Spline : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Spline ();
		public void acc (bool enable);
		public static void clear (Ncm.Spline s);
		public Ncm.Spline copy ();
		public virtual Ncm.Spline copy_empty ();
		[NoWrapper]
		public virtual double deriv (double x);
		[NoWrapper]
		public virtual double deriv2 (double x);
		[NoWrapper]
		public virtual double deriv_nmax (double x);
		public virtual double eval (double x);
		public double eval_deriv (double x);
		public double eval_deriv2 (double x);
		public double eval_deriv_nmax (double x);
		public double eval_integ (double x0, double x1);
		public void free ();
		public void get_bounds (out double lb, out double ub);
		public uint get_index (double x);
		public uint get_len ();
		public Ncm.Vector get_xv ();
		public Ncm.Vector get_yv ();
		[NoWrapper]
		public virtual double integ (double xi, double xf);
		public bool is_empty ();
		public virtual size_t min_size ();
		[NoWrapper]
		public virtual unowned string name ();
		public Ncm.Spline @new (Ncm.Vector xv, Ncm.Vector yv, bool init);
		public Ncm.Spline new_array (GLib.Array<double> x, GLib.Array<double> y, bool init);
		public Ncm.Spline new_data (double x, double y, size_t len, bool init);
		public virtual void prepare ();
		public virtual void prepare_base ();
		public Ncm.Spline @ref ();
		[NoWrapper]
		public virtual void reset ();
		public unowned Ncm.Spline @set (Ncm.Vector xv, Ncm.Vector yv, bool init);
		public void set_array (GLib.Array<double> x, GLib.Array<double> y, bool init);
		public void set_data_static (double x, double y, size_t len, bool init);
		public void set_len (uint len);
		public void set_xv (Ncm.Vector xv, bool init);
		public void set_yv (Ncm.Vector yv, bool init);
		[NoAccessorMethod]
		public uint length { get; construct; }
		[NoAccessorMethod]
		public Ncm.Vector x { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Vector y { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline2d_get_type ()")]
	public abstract class Spline2d : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Spline2d ();
		public static void clear (Ncm.Spline2d s2d);
		public Ncm.Spline2d copy ();
		public virtual Ncm.Spline2d copy_empty ();
		[CCode (vfunc_name = "d2zdx2")]
		public virtual double deriv_d2zdx2 (double x, double y);
		[CCode (vfunc_name = "d2zdxy")]
		public virtual double deriv_d2zdxy (double x, double y);
		[CCode (vfunc_name = "d2zdy2")]
		public virtual double deriv_d2zdy2 (double x, double y);
		[CCode (vfunc_name = "dzdx")]
		public virtual double deriv_dzdx (double x, double y);
		[CCode (vfunc_name = "dzdy")]
		public virtual double deriv_dzdy (double x, double y);
		public virtual double eval (double x, double y);
		public void free ();
		[CCode (vfunc_name = "int_dx")]
		public virtual double integ_dx (double xl, double xu, double y);
		public Ncm.Spline integ_dx_spline (double xl, double xu);
		public double integ_dx_spline_val (double xl, double xu, double y);
		[CCode (vfunc_name = "int_dxdy")]
		public virtual double integ_dxdy (double xl, double xu, double yl, double yu);
		public double integ_dxdy_spline_x (double xl, double xu, double yl, double yu);
		public double integ_dxdy_spline_y (double xl, double xu, double yl, double yu);
		[CCode (vfunc_name = "int_dy")]
		public virtual double integ_dy (double x, double yl, double yu);
		public Ncm.Spline integ_dy_spline (double yl, double yu);
		public double integ_dy_spline_val (double x, double yl, double yu);
		[CCode (cname = "ncm_spline2dim_integ_total")]
		public double m_integ_total ();
		public uint min_size ();
		public Ncm.Spline2d @new (Ncm.Vector xv, Ncm.Vector yv, Ncm.Matrix zm, bool init);
		public virtual void prepare ();
		[NoWrapper]
		public virtual void reset ();
		public void @set (Ncm.Vector xv, Ncm.Vector yv, Ncm.Matrix zm, bool init);
		[NoAccessorMethod]
		public bool init { get; set; }
		[NoAccessorMethod]
		public Ncm.Spline spline { owned get; construct; }
		[NoAccessorMethod]
		public bool use_acc { get; set; }
		[NoAccessorMethod]
		public Ncm.Vector x_vector { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Vector y_vector { owned get; set; }
		[NoAccessorMethod]
		public Ncm.Matrix z_matrix { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline2d_bicubic_get_type ()")]
	public class Spline2dBicubic : Ncm.Spline2d {
		[CCode (has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dBicubic (Ncm.Spline s);
		public static double bi (Ncm.SplineCubic sc, Ncm.Vector xv, Ncm.Vector yv, size_t i);
		public static void bi_bip1 (Ncm.SplineCubic sc, Ncm.Vector xv, Ncm.Vector yv, size_t i, double b_i, double b_ip1);
		public static double eval_poly (Ncm.Spline2dBicubicCoeffs sa, double x, double y);
		public static void fij_to_aij (Ncm.Spline2dBicubicCoeffs sf, double dx, double dy, Ncm.Spline2dBicubicCoeffs sa);
		public static void integ_dx_coeffs (Ncm.Spline2dBicubicCoeffs aij, double dy, double coeffs);
		public static void integ_dy_coeffs (Ncm.Spline2dBicubicCoeffs aij, double dx, double coeffs);
		public static double integ_eval2d (Ncm.Spline2dBicubicCoeffs aij, double x0, double xl, double xu, double y0, double yl, double yu);
		[CCode (cname = "ncm_spline2d_bicubic_notaknot_new", has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dBicubic.notaknot_new ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline2d_gsl_get_type ()")]
	public class Spline2dGsl : Ncm.Spline2d {
		[CCode (has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dGsl (Ncm.Spline s);
		[CCode (cname = "ncm_spline2d_gsl_natural_new", has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dGsl.natural_new ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline2d_spline_get_type ()")]
	public class Spline2dSpline : Ncm.Spline2d {
		[CCode (has_construct_function = false, type = "NcmSpline2d*")]
		public Spline2dSpline (Ncm.Spline s);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline_cubic_get_type ()")]
	public abstract class SplineCubic : Ncm.Spline {
		[CCode (has_construct_function = false)]
		protected SplineCubic ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline_cubic_notaknot_get_type ()")]
	public class SplineCubicNotaknot : Ncm.SplineCubic {
		[CCode (has_construct_function = false, type = "NcmSpline*")]
		public SplineCubicNotaknot ();
		[CCode (has_construct_function = false, type = "NcmSpline*")]
		public SplineCubicNotaknot.full (Ncm.Vector xv, Ncm.Vector yv, bool init);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_spline_gsl_get_type ()")]
	public class SplineGsl : Ncm.Spline {
		[CCode (has_construct_function = false)]
		protected SplineGsl ();
		public void set_type_by_id (Ncm.SplineGslType type_id);
		[NoAccessorMethod]
		public string type_name { owned get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_stats_dist1d_get_type ()")]
	public abstract class StatsDist1d : GLib.Object {
		[CCode (has_construct_function = false)]
		protected StatsDist1d ();
		public static void clear (Ncm.StatsDist1d sd1);
		public double eval_inv_pdf (double u);
		public double eval_inv_pdf_tail (double v);
		public double eval_m2lnp (double x);
		public double eval_mode ();
		public double eval_norma ();
		public double eval_p (double x);
		public double eval_pdf (double x);
		public void free ();
		public double gen (Ncm.RNG rng);
		[NoWrapper]
		public virtual double m2lnp (double x);
		[NoWrapper]
		public virtual double p (double x);
		public virtual void prepare ();
		public Ncm.StatsDist1d @ref ();
		[NoAccessorMethod]
		public double abstol { get; set construct; }
		[NoAccessorMethod]
		public double max_prob { get; set construct; }
		[NoAccessorMethod]
		public double norma { get; }
		[NoAccessorMethod]
		public double reltol { get; set construct; }
		[NoAccessorMethod]
		public double xf { get; set; }
		[NoAccessorMethod]
		public double xi { get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_stats_dist1d_epdf_get_type ()")]
	public class StatsDist1dEPDF : Ncm.StatsDist1d {
		[CCode (has_construct_function = false)]
		public StatsDist1dEPDF (double sd_min_scale);
		public void add_obs (double x);
		[CCode (has_construct_function = false)]
		public StatsDist1dEPDF.full (uint max_obs, Ncm.StatsDist1dEPDFBw bw, double h_fixed, double sd_min_scale);
		public double get_obs_mean ();
		public void reset ();
		[NoAccessorMethod]
		public Ncm.StatsDist1dEPDFBw bandwidth { get; construct; }
		[NoAccessorMethod]
		public double h_fixed { get; set construct; }
		[NoAccessorMethod]
		public uint max_obs { get; construct; }
		[NoAccessorMethod]
		public uint n_obs { get; }
		[NoAccessorMethod]
		public double outliers_threshold { get; construct; }
		[NoAccessorMethod]
		public double sd_min_scale { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_stats_dist1d_spline_get_type ()")]
	public class StatsDist1dSpline : Ncm.StatsDist1d {
		[CCode (has_construct_function = false)]
		public StatsDist1dSpline (Ncm.Spline m2lnp);
		[NoAccessorMethod]
		public Ncm.Spline m2lnp { owned get; set construct; }
		[NoAccessorMethod]
		public double tail_sigma { get; set construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_stats_vec_get_type ()")]
	public class StatsVec : GLib.Object {
		[CCode (has_construct_function = false)]
		public StatsVec (uint len, Ncm.StatsVecType t, bool save_x);
		public void append (Ncm.Vector x, bool dup);
		public void append_data (GLib.GenericArray<Ncm.Vector> data, bool dup);
		public void append_weight (Ncm.Vector x, double w, bool dup);
		public static void clear (Ncm.StatsVec svec);
		public void disable_quantile ();
		public void enable_quantile (double p);
		public void free ();
		public double @get (uint i);
		public Ncm.Vector get_autocorr (uint p);
		public double get_autocorr_tau (uint p, uint max_lag, double min_rho);
		public double get_cor (uint i, uint j);
		public double get_cov (uint i, uint j);
		public void get_cov_matrix (Ncm.Matrix m, uint offset);
		public double get_mean (uint i);
		public void get_mean_vector (Ncm.Vector mean, uint offset);
		public double get_param_at (uint i, uint p);
		public double get_quantile (uint i);
		public double get_quantile_spread (uint i);
		public double get_sd (uint i);
		public Ncm.Vector get_subsample_autocorr (uint p, uint subsample);
		public double get_subsample_autocorr_tau (uint p, uint subsample, uint max_lag, double min_rho);
		public double get_var (uint i);
		public double get_weight ();
		public uint nrows ();
		public unowned Ncm.Matrix peek_cov_matrix (uint offset);
		public unowned Ncm.Vector peek_mean ();
		public unowned Ncm.Vector peek_row (uint i);
		public unowned Ncm.Vector peek_x ();
		public void prepend (Ncm.Vector x, bool dup);
		public void prepend_data (GLib.GenericArray<Ncm.Vector> data, bool dup);
		public void prepend_weight (Ncm.Vector x, double w, bool dup);
		public Ncm.StatsVec @ref ();
		public void reset (bool rm_saved);
		public void @set (uint i, double x_i);
		public void update ();
		public void update_weight (double w);
		[NoAccessorMethod]
		public uint length { get; construct; }
		[NoAccessorMethod]
		public bool save_x { get; construct; }
		[NoAccessorMethod]
		public Ncm.StatsVecType type { get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_timer_get_type ()")]
	public class Timer : GLib.Object {
		[CCode (has_construct_function = false)]
		public Timer ();
		public static void clear (Ncm.Timer nt);
		public void @continue ();
		public double elapsed ();
		public void elapsed_dhms (out uint elap_day, out uint elap_hour, out uint elap_min, out double elap_sec);
		public unowned string elapsed_dhms_str ();
		public void free ();
		public Ncm.Timer @ref ();
		public void set_name (string name);
		public void start ();
		public void stop ();
		public void task_accumulate (uint nitens);
		public void task_add_tasks (uint ptasks);
		public void task_continue ();
		public unowned string task_elapsed_str ();
		public bool task_end ();
		public unowned string task_end_datetime_str ();
		public void task_increment ();
		public bool task_is_running ();
		public void task_log_elapsed ();
		public void task_log_end_datetime ();
		public void task_log_mean_time ();
		public void task_log_start_datetime ();
		public void task_log_time_left ();
		public double task_mean_time ();
		public unowned string task_mean_time_str ();
		public void task_pause ();
		public void task_start (uint task_len);
		public unowned string task_start_datetime_str ();
		public double task_time_left ();
		public unowned string task_time_left_str ();
		[NoAccessorMethod]
		public string name { owned get; set construct; }
		[NoAccessorMethod]
		public uint task_len { get; }
		[NoAccessorMethod]
		public uint task_pos { get; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", lower_case_csuffix = "trivec", type_id = "ncm_trivec_get_type ()")]
	[Compact]
	public class TriVec {
		[CCode (has_construct_function = false)]
		public TriVec ();
		public double dot (Ncm.TriVec v2);
		public Ncm.TriVec dup ();
		public void free ();
		[CCode (has_construct_function = false)]
		public TriVec.full (double c);
		[CCode (has_construct_function = false)]
		public TriVec.full_c (double x, double y, double z);
		public double get_phi ();
		public void get_spherical_coord (out double theta, out double phi);
		public void memcpy (Ncm.TriVec orig);
		public double norm ();
		public void normalize ();
		public void scale (double scale);
		public void set_0 ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_vparam_get_type ()")]
	public class VParam : GLib.Object {
		[CCode (has_construct_function = false)]
		public VParam (uint len, Ncm.SParam default_param);
		public static void clear (Ncm.VParam vparam);
		public Ncm.VParam copy ();
		public void free ();
		[CCode (cname = "ncm_vparam_full_new", has_construct_function = false)]
		public VParam.full_new (uint len, string name, string symbol, double lower_bound, double upper_bound, double scale, double abstol, double default_val, Ncm.ParamType ftype);
		public double get_absolute_tolerance (uint n);
		public double get_default_value (uint n);
		public Ncm.ParamType get_fit_type (uint n);
		public uint get_len ();
		public double get_lower_bound (uint n);
		public double get_scale (uint n);
		public Ncm.SParam get_sparam (uint n);
		public double get_upper_bound (uint n);
		public uint len ();
		public unowned string name ();
		public unowned Ncm.SParam peek_sparam (uint n);
		public Ncm.VParam @ref ();
		public void set_absolute_tolerance (uint n, double abstol);
		public void set_default_value (uint n, double default_val);
		public void set_fit_type (uint n, Ncm.ParamType ftype);
		public void set_len (uint len);
		public void set_lower_bound (uint n, double lb);
		public void set_scale (uint n, double scale);
		public void set_sparam (uint n, Ncm.SParam spn);
		public void set_sparam_full (uint n, string name, string symbol, double lower_bound, double upper_bound, double scale, double abstol, double default_val, Ncm.ParamType ftype);
		public void set_upper_bound (uint n, double ub);
		public unowned string symbol ();
		[NoAccessorMethod]
		public Ncm.SParam default_sparam { owned get; construct; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", type_id = "ncm_vector_get_type ()")]
	public class Vector : GLib.Object {
		[CCode (has_construct_function = false)]
		public Vector (size_t n);
		public void add (Ncm.Vector cv2);
		public void add_constant (double val);
		public void addto (uint i, double val);
		[CCode (has_construct_function = false)]
		public Vector.array (GLib.Array<double> a);
		public static void clear (Ncm.Vector cv);
		public double const_data ();
		public void const_free ();
		[CCode (cname = "ncm_vector_const_new_data", has_construct_function = false, type = "const NcmVector*")]
		public Vector.const_new_data ([CCode (array_length = false)] double[] d, size_t size, size_t stride);
		[CCode (cname = "ncm_vector_const_new_variant", has_construct_function = false, type = "const NcmVector*")]
		public Vector.const_new_variant (GLib.Variant @var);
		public double const_ptr (uint i);
		public Ncm.Vector const_ref ();
		public double data ();
		[CCode (has_construct_function = false)]
		public Vector.data_dup ([CCode (array_length = false)] double[] d, size_t size, size_t stride);
		[CCode (has_construct_function = false)]
		public Vector.data_malloc ([CCode (array_length = false)] double[] d, size_t size, size_t stride);
		[CCode (has_construct_function = false)]
		public Vector.data_slice ([CCode (array_length = false)] double[] d, size_t size, size_t stride);
		[CCode (has_construct_function = false)]
		public Vector.data_static ([CCode (array_length = false)] double[] d, size_t size, size_t stride);
		public void div (Ncm.Vector cv2);
		public double dnrm2 ();
		public Ncm.Vector dup ();
		public GLib.Array<double> dup_array ();
		public void fast_addto (uint i, double val);
		public double fast_get (uint i);
		public void fast_mulby (uint i, double val);
		public double fast_ptr (uint i);
		public void fast_set (uint i, double val);
		public void fast_subfrom (uint i, double val);
		[CCode (has_construct_function = false)]
		public Vector.fftw (uint size);
		public void free ();
		[CCode (has_construct_function = false)]
		public Vector.full ([CCode (array_length = false)] double[] d, size_t size, size_t stride, void* pdata, GLib.DestroyNotify? pfree);
		public double @get (uint i);
		public void get_absminmax (out double absmin, out double absmax);
		public GLib.Array<weak double> get_array ();
		public void get_minmax (out double min, out double max);
		public Ncm.Vector get_subvector (size_t k, size_t size);
		public GLib.Variant get_variant ();
		public uint len ();
		public void log_vals (string prestr, string format);
		public void log_vals_avpb (string prestr, string format, double a, double b);
		public void log_vals_func (string prestr, string format, Ncm.VectorCompFunc f);
		public void memcpy (Ncm.Vector cv2);
		public void memcpy2 (Ncm.Vector cv2, uint cv1_start, uint cv2_start, uint size);
		public void mulby (uint i, double val);
		public GLib.Variant peek_variant ();
		public double ptr (uint i);
		public Ncm.Vector @ref ();
		public void scale (double val);
		public void @set (uint i, double val);
		public void set_all (double val);
		public void set_array (double array);
		public void set_from_variant (GLib.Variant @var);
		public void set_zero ();
		public uint stride ();
		public void sub (Ncm.Vector cv2);
		public void subfrom (uint i, double val);
		public static void substitute (Ncm.Vector cv, Ncm.Vector nv, bool check_size);
		public double sum_cpts ();
		[CCode (has_construct_function = false)]
		public Vector.variant (GLib.Variant @var);
		[NoAccessorMethod]
		public GLib.Variant values { owned get; set; }
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct BinSplit {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public struct DoubleInt64 {
		public int64 i;
		public double x;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct FitGrad {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct FunctionCache {
		public static void clear (Ncm.FunctionCache cache);
		public void free ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct Grid {
		public void free (bool free_data);
		public double get_double_array ();
		public static string get_name (Ncm.GridSection secs);
		public double get_node_d (ulong i);
		public void set_nodes_d (Ncm.GridNodesEndPoints incl, uint32 start, uint32 end, double start_val, double end_val);
		public void set_nodes_si (Ncm.GridNodesEndPoints incl, uint32 start, uint32 end, long start_val_num, long start_val_den, long end_val_num, long end_val_den);
		public void set_sections (Ncm.GridSection secs);
		public void write (int f);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct GridSection {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct IntegralFixed {
		public void free ();
		public double nodes_eval ();
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct Integrand2dim {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct Integrand3dim {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct LHRatio2dPoint {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MIOde {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MIOdeFunction {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MSetFuncListStruct {
		public weak string name;
		public weak string symbol;
		public weak string ns;
		public weak string desc;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MSetModelDesc {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MemoryPool {
		public void add (void* p);
		public void free (bool free_slices);
		public void* @get ();
		public static void @return (void* p);
		public void set_min_size (size_t n);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MemoryPoolSlice {
		public void* p;
		public bool in_use;
		public Ncm.MemoryPool mp;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	[SimpleType]
	public struct ModelID : int {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MpsfSBesselIntSpline {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MpsfSBesselIntegRecur {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct MpsfSBesselRecur {
		public void free ();
		public void write (int f);
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct QuadFilon {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct QuadFilonError {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SFSBesselRecur {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SFSphericalBesselIntSpline {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SFSphericalBesselIntegRecur {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SphereMapAlm {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct SphereMapSHT {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct Spline2dBicubicCoeffs {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_type_id = false)]
	public struct StatsDist1dSplineTail {
		public double xb;
		public double a;
		public double b;
		public double c;
		public double sigma;
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmSpline2dBicubicOptimizeInt", has_type_id = false)]
	public struct _Spline2dBicubicOptimizeInt {
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_DATA_POISSON_", type_id = "ncm_data_poisson_type_get_type ()")]
	public enum DataPoissonType {
		INT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_DATASET_BSTRAP_", type_id = "ncm_dataset_bstrap_type_get_type ()")]
	public enum DatasetBStrapType {
		DISABLE,
		PARTIAL,
		TOTAL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_GSL_MM_", type_id = "ncm_fit_gslmm_algos_get_type ()")]
	public enum FitGSLMMAlgos {
		CONJUGATE_FR,
		CONJUGATE_PR,
		VECTOR_BFGS,
		VECTOR_BFGS2,
		STEEPEST_DESCENT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_GSL_MMS_", type_id = "ncm_fit_gslmms_algos_get_type ()")]
	public enum FitGSLMMSAlgos {
		NMSIMPLEX2,
		NMSIMPLEX,
		NMSIMPLES2RAND
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_GRAD_", type_id = "ncm_fit_grad_type_get_type ()")]
	public enum FitGradType {
		ANALYTICAL,
		NUMDIFF_FORWARD,
		NUMDIFF_CENTRAL,
		NUMDIFF_ACCURATE
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_LEVMAR_", type_id = "ncm_fit_levmar_algos_get_type ()")]
	public enum FitLevmarAlgos {
		DER,
		DIF,
		BC_DER,
		BC_DIF
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_MC_RESAMPLE_", type_id = "ncm_fit_mc_resample_type_get_type ()")]
	public enum FitMCResampleType {
		FROM_MODEL,
		BOOTSTRAP_NOMIX,
		BOOTSTRAP_MIX
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NLOPT_", type_id = "ncm_fit_nlopt_algorithm_get_type ()")]
	public enum FitNloptAlgorithm {
		GN_DIRECT,
		GN_DIRECT_L,
		GN_DIRECT_L_RAND,
		GN_DIRECT_NOSCAL,
		GN_DIRECT_L_NOSCAL,
		GN_DIRECT_L_RAND_NOSCAL,
		GN_ORIG_DIRECT,
		GN_ORIG_DIRECT_L,
		GD_STOGO,
		GD_STOGO_RAND,
		LD_LBFGS_NOCEDAL,
		LD_LBFGS,
		LN_PRAXIS,
		LD_VAR1,
		LD_VAR2,
		LD_TNEWTON,
		LD_TNEWTON_RESTART,
		LD_TNEWTON_PRECOND,
		LD_TNEWTON_PRECOND_RESTART,
		GN_CRS2_LM,
		GN_MLSL,
		GD_MLSL,
		GN_MLSL_LDS,
		GD_MLSL_LDS,
		LD_MMA,
		LN_COBYLA,
		LN_NEWUOA,
		LN_NEWUOA_BOUND,
		LN_NELDERMEAD,
		LN_SBPLX,
		LN_AUGLAG,
		LD_AUGLAG,
		LN_AUGLAG_EQ,
		LD_AUGLAG_EQ,
		LN_BOBYQA,
		GN_ISRES,
		AUGLAG,
		AUGLAG_EQ,
		G_MLSL,
		G_MLSL_LDS,
		LD_SLSQP,
		LD_CCSAQ,
		GN_ESCH,
		NUM_ALGORITHMS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NLOPT_", type_id = "ncm_fit_nlopt_result_get_type ()")]
	public enum FitNloptResult {
		FAILURE,
		INVALID_ARGS,
		OUT_OF_MEMORY,
		ROUNDOFF_LIMITED,
		FORCED_STOP,
		SUCCESS,
		STOPVAL_REACHED,
		FTOL_REACHED,
		XTOL_REACHED,
		MAXEVAL_REACHED,
		MAXTIME_REACHED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_RUN_MSGS_", type_id = "ncm_fit_run_msgs_get_type ()")]
	public enum FitRunMsgs {
		NONE,
		SIMPLE,
		FULL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_FIT_TYPE_", type_id = "ncm_fit_type_get_type ()")]
	public enum FitType {
		GSL_LS,
		GSL_MM,
		GSL_MMS,
		LEVMAR,
		NLOPT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NC_FUNCTION_CACHE_SEARCH_", type_id = "ncm_function_cache_search_type_get_type ()")]
	public enum FunctionCacheSearchType {
		BOTH,
		GT,
		LT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_GRID_NODES_", type_id = "ncm_grid_nodes_end_points_get_type ()")]
	public enum GridNodesEndPoints {
		START,
		END,
		BOTH,
		NONE
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_LH_RATIO1D_ROOT_", type_id = "ncm_lh_ratio1d_root_get_type ()")]
	public enum LHRatio1dRoot {
		BRACKET,
		NUMDIFF
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_LH_RATIO2D_ROOT_", type_id = "ncm_lh_ratio2d_root_get_type ()")]
	public enum LHRatio2dRoot {
		BRACKET,
		NUMDIFF
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_MSET_CATALOG_SYNC_", type_id = "ncm_mset_catalog_sync_get_type ()")]
	public enum MSetCatalogSync {
		DISABLE,
		AUTO,
		TIMED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_MATRIX_", type_id = "ncm_matrix_internal_get_type ()")]
	public enum MatrixInternal {
		SLICE,
		GSL_MATRIX,
		MALLOC,
		GARRAY,
		DERIVED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_PARAM_TYPE_", type_id = "ncm_param_type_get_type ()")]
	public enum ParamType {
		FREE,
		FIXED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_POWSPEC_FILTER_TYPE_", type_id = "ncm_powspec_filter_type_get_type ()")]
	public enum PowspecFilterType {
		TOPHAT,
		GAUSS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_SERIALIZE_OPT_", type_id = "ncm_serialize_opt_get_type ()")]
	[Flags]
	public enum SerializeOpt {
		NONE,
		AUTOSAVE_SER,
		AUTONAME_SER,
		CLEAN_DUP
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NC_SPHERE_MAP_ORDER_", type_id = "ncm_sphere_map_order_get_type ()")]
	public enum SphereMapOrder {
		NEST,
		RING
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_SPHERE_MAP_PIX_COORD_SYS_", type_id = "ncm_sphere_map_pix_coord_sys_get_type ()")]
	public enum SphereMapPixCoordSys {
		GALACTIC,
		ECLIPTIC,
		CELESTIAL
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_SPHERE_MAP_PIX_ORDER_", type_id = "ncm_sphere_map_pix_order_get_type ()")]
	public enum SphereMapPixOrder {
		NEST,
		RING
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NC_SPHERE_MAP_TYPE_", type_id = "ncm_sphere_map_type_get_type ()")]
	[Flags]
	public enum SphereMapType {
		TEMPERATURE,
		Q_POLARIZATION,
		U_POLARISATION,
		SPUR_SIGNAL,
		N_OBS
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_SPLINE_FUNCTION_", type_id = "ncm_spline_func_type_get_type ()")]
	public enum SplineFuncType {
		@4POINTS,
		[CCode (cname = "NCM_SPLINE_FUNCTION_2x2POINTS")]
		@2X2POINTS,
		SPLINE,
		SPLINE_LNKNOT
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_SPLINE_GSL_", type_id = "ncm_spline_gsl_type_get_type ()")]
	public enum SplineGslType {
		LINEAR,
		POLYNOMIAL,
		CSPLINE,
		CSPLINE_PERIODIC,
		AKIMA,
		AKIMA_PERIODIC
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_STATS_DIST1D_EPDF_BW_", type_id = "ncm_stats_dist1d_epdf_bw_get_type ()")]
	public enum StatsDist1dEPDFBw {
		FIXED,
		[CCode (cname = "NCM_STATS_DIST1D_EPDF_BW_RoT")]
		ROT,
		AUTO
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_STATS_VEC_", type_id = "ncm_stats_vec_type_get_type ()")]
	public enum StatsVecType {
		MEAN,
		VAR,
		COV
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cprefix = "NCM_VECTOR_", type_id = "ncm_vector_internal_get_type ()")]
	public enum VectorInternal {
		SLICE,
		GSL_VECTOR,
		MALLOC,
		ARRAY,
		DERIVED
	}
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void BinSplitEval (Ncm.BinSplit bs, ulong n1, ulong n2);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void CalcPrepare0 (Ncm.Calc calc);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void CalcPrepare1 (Ncm.Calc calc, Ncm.Model m1);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void CalcPrepare2 (Ncm.Calc calc, Ncm.Model m1, Ncm.Model m2);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void CalcPrepare3 (Ncm.Calc calc, Ncm.Model m1, Ncm.Model m2, Ncm.Model m3);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void CalcPrepare4 (Ncm.Calc calc, Ncm.Model m1, Ncm.Model m2, Ncm.Model m3, Ncm.Model m4);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void CalcPrepare5 (Ncm.Calc calc, Ncm.Model m1, Ncm.Model m2, Ncm.Model m3, Ncm.Model m4, Ncm.Model m5);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void CalcPrepare6 (Ncm.Calc calc, Ncm.Model m1, Ncm.Model m2, Ncm.Model m3, Ncm.Model m4, Ncm.Model m5, Ncm.Model m6);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void FitMCResample (Ncm.Dataset dset, Ncm.MSet mset, Ncm.RNG rng);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void FuncEvalLoop (long i, long f, void* data);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double Integral1dF (double x, void* userdata);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void IntegralPeakfinder (int ndim, double b, int n, double x, void* userdata);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void MSetFuncListN (Ncm.MSetFuncList flist, Ncm.MSet mset, double x, double res);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void MSetFuncN (Ncm.MSetFunc func, Ncm.MSet mset, [CCode (array_length = false)] double[] x, [CCode (array_length = false)] out unowned double[] res);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void* MemoryPoolAlloc (void* userdata);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void ModelAddSubmodel (Ncm.Model model, Ncm.Model submodel);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double ModelFunc0 (Ncm.Model model);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double ModelFunc1 (Ncm.Model model, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double ModelFunc2 (Ncm.Model model, double x, double y);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double OdeSplineDydx (double y, double x, void* userdata);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double PriorFlatMean (Ncm.PriorFlat pf, Ncm.MSet mset);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate double PriorGaussMean (Ncm.PriorGauss pg, Ncm.MSet mset);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate bool ReparamJ (Ncm.Reparam reparam, void* model, Ncm.Matrix jac);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate bool ReparamV (Ncm.Reparam reparam, void* model);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", has_target = false)]
	public delegate void StatsVecUpdateFunc (Ncm.StatsVec svec, double w, Ncm.Vector x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", instance_pos = 2.9)]
	public delegate double VectorCompFunc (double v_i, uint i);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmFitLSFJ", has_target = false)]
	public delegate void _FitLSFJ (Ncm.Fit fit, Ncm.Vector f, Ncm.Matrix J);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmFitLSJ", has_target = false)]
	public delegate void _FitLSJ (Ncm.Fit fit, Ncm.Matrix J);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmFitM2lnLGrad", has_target = false)]
	public delegate void _FitM2lnLGrad (Ncm.Fit fit, Ncm.Vector grad);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmFitM2lnLValGrad", has_target = false)]
	public delegate void _FitM2lnLValGrad (Ncm.Fit fit, double m2lnL, Ncm.Vector grad);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmIntegrand2dimFunc", has_target = false)]
	public delegate double _Integrand2dimFunc (double x, double y, void* userdata);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "_NcmIntegrand3dimFunc", has_target = false)]
	public delegate double _Integrand3dimFunc (double x, double y, double z, void* userdata);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_ABC_MIN_SYNC_INTERVAL")]
	public const double ABC_MIN_SYNC_INTERVAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_BOOTSTRAP_RNG_NAME")]
	public const string BOOTSTRAP_RNG_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_CALC_DEFAULT_ABSTOL")]
	public const double CALC_DEFAULT_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_CALC_DEFAULT_RELTOL")]
	public const double CALC_DEFAULT_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_CALC_MAX_DEPS")]
	public const int CALC_MAX_DEPS;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_CFG_DATA_DIR_ENV")]
	public const string CFG_DATA_DIR_ENV;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_DATA_RESAMPLE_RNG_NAME")]
	public const string DATA_RESAMPLE_RNG_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_DEFAULT_PRECISION")]
	public const double DEFAULT_PRECISION;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_DEFAULT_M2LNL_ABSTOL")]
	public const double FIT_DEFAULT_M2LNL_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_DEFAULT_M2LNL_RELTOL")]
	public const double FIT_DEFAULT_M2LNL_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_DEFAULT_MAXITER")]
	public const int FIT_DEFAULT_MAXITER;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_DEFAULT_PARAMS_RELTOL")]
	public const double FIT_DEFAULT_PARAMS_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_ESMCMC_M2LNL_ID")]
	public const int FIT_ESMCMC_M2LNL_ID;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_ESMCMC_MIN_SYNC_INTERVAL")]
	public const double FIT_ESMCMC_MIN_SYNC_INTERVAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_MCMC_MIN_SYNC_INTERVAL")]
	public const double FIT_MCMC_MIN_SYNC_INTERVAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_FIT_MC_MIN_SYNC_INTERVAL")]
	public const double FIT_MC_MIN_SYNC_INTERVAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_HEALPIX_NULLVAL")]
	public const double HEALPIX_NULLVAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL1D_DEFAULT_ABSTOL")]
	public const double INTEGRAL1D_DEFAULT_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL1D_DEFAULT_ALG")]
	public const int INTEGRAL1D_DEFAULT_ALG;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL1D_DEFAULT_PARTITION")]
	public const int INTEGRAL1D_DEFAULT_PARTITION;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL1D_DEFAULT_RELTOL")]
	public const double INTEGRAL1D_DEFAULT_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL_ABS_ERROR")]
	public const double INTEGRAL_ABS_ERROR;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL_ALG")]
	public const int INTEGRAL_ALG;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL_ERROR")]
	public const double INTEGRAL_ERROR;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_INTEGRAL_PARTITION")]
	public const int INTEGRAL_PARTITION;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_ASYMB_LABEL")]
	public const string MSET_CATALOG_ASYMB_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_DIST_EST_SD_SCALE")]
	public const double MSET_CATALOG_DIST_EST_SD_SCALE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_EXTNAME")]
	public const string MSET_CATALOG_EXTNAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_FIRST_ID_LABEL")]
	public const string MSET_CATALOG_FIRST_ID_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_FSYMB_LABEL")]
	public const string MSET_CATALOG_FSYMB_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_M2LNL_COLNAME")]
	public const string MSET_CATALOG_M2LNL_COLNAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_M2LNL_SYMBOL")]
	public const string MSET_CATALOG_M2LNL_SYMBOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_NADDVAL_LABEL")]
	public const string MSET_CATALOG_NADDVAL_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_NCHAINS_LABEL")]
	public const string MSET_CATALOG_NCHAINS_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_NROWS_LABEL")]
	public const string MSET_CATALOG_NROWS_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_RNG_ALGO_LABEL")]
	public const string MSET_CATALOG_RNG_ALGO_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_RNG_INIS_LABEL")]
	public const string MSET_CATALOG_RNG_INIS_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_RNG_SEED_LABEL")]
	public const string MSET_CATALOG_RNG_SEED_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_RNG_STAT_LABEL")]
	public const string MSET_CATALOG_RNG_STAT_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_RTYPE_BSTRAP_MEAN")]
	public const string MSET_CATALOG_RTYPE_BSTRAP_MEAN;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_RTYPE_LABEL")]
	public const string MSET_CATALOG_RTYPE_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_RTYPE_UNDEFINED")]
	public const string MSET_CATALOG_RTYPE_UNDEFINED;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_CATALOG_WEIGHTED_LABEL")]
	public const string MSET_CATALOG_WEIGHTED_LABEL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_INIT_MARRAY")]
	public const int MSET_INIT_MARRAY;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_MSET_MAX_STACKSIZE")]
	public const int MSET_MAX_STACKSIZE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_OBJ_ARRAY_OBJ_NAME_STR")]
	public const string OBJ_ARRAY_OBJ_NAME_STR;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_OBJ_ARRAY_POS_STR")]
	public const string OBJ_ARRAY_POS_STR;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_OBJ_ARRAY_TYPE")]
	public const string OBJ_ARRAY_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_ODE_SPLINE_DEFAULT_ABSTOL")]
	public const double ODE_SPLINE_DEFAULT_ABSTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_ODE_SPLINE_DEFAULT_RELTOL")]
	public const double ODE_SPLINE_DEFAULT_RELTOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_ODE_SPLINE_MIN_STEP")]
	public const double ODE_SPLINE_MIN_STEP;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_POWSPEC_FILTER_DEFAULT_SIZE")]
	public const int POWSPEC_FILTER_DEFAULT_SIZE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_REPARAM_PARAMS_DESC_DICT_TYPE")]
	public const string REPARAM_PARAMS_DESC_DICT_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_AUTOSAVE_NAME")]
	public const string SERIALIZE_AUTOSAVE_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_AUTOSAVE_NFORMAT")]
	public const string SERIALIZE_AUTOSAVE_NFORMAT;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_MATRIX_TYPE")]
	public const string SERIALIZE_MATRIX_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_OBJECT_FORMAT")]
	public const string SERIALIZE_OBJECT_FORMAT;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_OBJECT_TYPE")]
	public const string SERIALIZE_OBJECT_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_PROPERTIES_TYPE")]
	public const string SERIALIZE_PROPERTIES_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_PROPERTY_TYPE")]
	public const string SERIALIZE_PROPERTY_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_STRV_TYPE")]
	public const string SERIALIZE_STRV_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SERIALIZE_VECTOR_TYPE")]
	public const string SERIALIZE_VECTOR_TYPE;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPHERE_MAP_PIX_DEFAULT_SIGNAL")]
	public const string SPHERE_MAP_PIX_DEFAULT_SIGNAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPHERE_MAP_PIX_HEALPIX_NULLVAL")]
	public const double SPHERE_MAP_PIX_HEALPIX_NULLVAL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPHERE_MAP_RNG_NAME")]
	public const string SPHERE_MAP_RNG_NAME;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_00")]
	public const int SPLINE2D_BICUBIC_00;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_01")]
	public const int SPLINE2D_BICUBIC_01;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_10")]
	public const int SPLINE2D_BICUBIC_10;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_11")]
	public const int SPLINE2D_BICUBIC_11;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_F")]
	public const int SPLINE2D_BICUBIC_F;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_FX")]
	public const int SPLINE2D_BICUBIC_FX;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_FXY")]
	public const int SPLINE2D_BICUBIC_FXY;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE2D_BICUBIC_FY")]
	public const int SPLINE2D_BICUBIC_FY;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE_FUNC_DEFAULT_MAX_NODES")]
	public const int SPLINE_FUNC_DEFAULT_MAX_NODES;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_SPLINE_KNOT_DIFF_TOL")]
	public const int SPLINE_KNOT_DIFF_TOL;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_THREAD_POOL_MAX")]
	public const int THREAD_POOL_MAX;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_TIMER_SEC_FORMAT")]
	public const string TIMER_SEC_FORMAT;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h", cname = "NCM_ZERO_LIMIT")]
	public const double ZERO_LIMIT;
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void binsplit_join (Ncm.BinSplit bs, Ncm.BinSplit bs_l, Ncm.BinSplit bs_r);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string cfg_command_line (string argv, int argc);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_enable_gsl_err_handler ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_entries_to_keyfile (GLib.KeyFile kfile, string group_name, GLib.OptionEntry entries);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static unowned GLib.EnumValue? cfg_enum_get_value (GLib.Type enum_type, uint n);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_enum_print_all (GLib.Type enum_type, string header);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string cfg_get_data_filename (string filename, bool must_exist);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static unowned GLib.EnumValue? cfg_get_enum_by_id_name_nick (GLib.Type enum_type, string id_name_nick);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_init ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_keyfile_to_arg (GLib.KeyFile kfile, string group_name, GLib.OptionEntry entries, string argv, int argc);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_lock_plan_fftw ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_logfile (bool on);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_logfile_flush (bool on);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_logfile_flush_now ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_msg_sepa ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_register_obj (GLib.Type obj);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_set_fftw_default_flag (uint flag);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_set_logfile (string filename);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string cfg_string_to_comment (string str);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void cfg_unlock_plan_fftw ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static int cmp (double x, double y, double reltol);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double cmpdbl (double x, double y);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double d1exprel (double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double d2exprel (double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double d3exprel (double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double exprel (double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void func_eval_log_pool_stats ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void func_eval_set_max_threads (int mt);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void func_eval_threaded_loop ([CCode (delegate_target_pos = 3.1)] Ncm.FuncEvalLoop lfunc, long i, long f);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void func_eval_threaded_loop_full ([CCode (delegate_target_pos = 3.1)] Ncm.FuncEvalLoop lfunc, long i, long f);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void func_eval_threaded_loop_nw ([CCode (delegate_target_pos = 3.5)] Ncm.FuncEvalLoop lfunc, long i, long f, uint nworkers);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool integrate_2dim (Ncm.Integrand2dim integ, double xi, double yi, double xf, double yf, double epsrel, double epsabs, double result, double error);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool integrate_2dim_divonne (Ncm.Integrand2dim integ, double xi, double yi, double xf, double yf, double epsrel, double epsabs, int ngiven, int ldxgiven, double xgiven, double result, double error);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool integrate_2dim_divonne_peakfinder (Ncm.Integrand2dim integ, double xi, double yi, double xf, double yf, double epsrel, double epsabs, int ngiven, int ldxgiven, double xgiven, int nextra, Ncm.IntegralPeakfinder peakfinder, double result, double error);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool integrate_2dim_vegas (Ncm.Integrand2dim integ, double xi, double yi, double xf, double yf, double epsrel, double epsabs, int nstart, double result, double error);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool integrate_3dim (Ncm.Integrand3dim integ, double xi, double yi, double zi, double xf, double yf, double zf, double epsrel, double epsabs, double result, double error);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool integrate_3dim_divonne (Ncm.Integrand3dim integ, double xi, double yi, double zi, double xf, double yf, double zf, double epsrel, double epsabs, int ngiven, int ldxgiven, double xgiven, double result, double error);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool integrate_3dim_vegas (Ncm.Integrand3dim integ, double xi, double yi, double zi, double xf, double yf, double zf, double epsrel, double epsabs, int nstart, double result, double error);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double interp_dd_eval (double vx, double dd, double x, int np, int nf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double interp_dd_eval_2_4 (double vx, double dd, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void interp_dd_init (double vx, double dd, int np, int nf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void interp_dd_init_2_4 (double vx, double dd);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static GLib.Array<double> lapack_dggglm_alloc (Ncm.Matrix L, Ncm.Matrix X, Ncm.Vector p, Ncm.Vector d, Ncm.Vector y);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static int lapack_dggglm_run (GLib.Array<double> ws, Ncm.Matrix L, Ncm.Matrix X, Ncm.Vector p, Ncm.Vector d, Ncm.Vector y);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static int lapack_dpotrf (char uplo, uint size, double a, uint lda);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static int lapack_dpotri (char uplo, uint size, double a, uint lda);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static int lapack_dptsv (double d, double e, double b, double x, uint size);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void lapack_dtrsv (char uplo, char trans, char diag, Ncm.Matrix A, Ncm.Vector v);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void message_ww (string msg, string first, string rest, uint ncols);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static GLib.HashTable<void*,void*> mpq_hash_new ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double mpsf_sbessel_integrate (Ncm.MpsfSBesselIntSpline int_jlspline, Ncm.Spline s, uint l, uint ki, uint xi, int diff);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void mpsf_sbessel_jl_xj_integrate_spline_save (Ncm.MpsfSBesselIntSpline int_jlspline, string filename);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool quadrature_filon_calc_inter_point (Ncm.QuadFilon quadf, double g);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool quadrature_filon_calc_mu_dxnm (Ncm.QuadFilon quadf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool quadrature_filon_calc_vandermonde (Ncm.QuadFilon quadf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool quadrature_filon_solve_vandermonde (Ncm.QuadFilon quadf);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static ulong random_seed ();
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_0F1 (double b, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_sbessel (ulong l, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_deriv (ulong l, double x, double jl, double jlp1, double djl);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_sbessel_jl_xj_integral (int l, int j, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integral_a_b (Ncm.SFSphericalBesselIntSpline int_jlspline, double x0, double x1, double w, double xnjl_rules, double xndjl_rules, double xnd2jl_rules);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integral_recur_free (Ncm.SFSphericalBesselIntegRecur xnjlrec, bool free_grid);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sf_sbessel_jl_xj_integral_recur_goto (Ncm.SFSphericalBesselIntegRecur xnjlrec, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sf_sbessel_jl_xj_integral_recur_next (Ncm.SFSphericalBesselIntegRecur xnjlrec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sf_sbessel_jl_xj_integral_recur_previous (Ncm.SFSphericalBesselIntegRecur xnjlrec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integral_recur_save (Ncm.SFSphericalBesselIntegRecur xnjlrec, string filename);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integral_recur_set (Ncm.SFSphericalBesselIntegRecur xnjlrec, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_sbessel_jl_xj_integral_spline (Ncm.SFSphericalBesselIntSpline int_jlspline, Ncm.Spline s0, Ncm.Spline s1, Ncm.Spline s2, double w);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sf_sbessel_jl_xj_integrate_spline_eval (Ncm.SFSphericalBesselIntSpline int_jlspline, int d, double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_goto (Ncm.SFSphericalBesselIntSpline int_jlspline, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_next (Ncm.SFSphericalBesselIntSpline int_jlspline);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_previous (Ncm.SFSphericalBesselIntSpline int_jlspline);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_reset (Ncm.SFSphericalBesselIntSpline int_jlspline);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_jl_xj_integrate_spline_set (Ncm.SFSphericalBesselIntSpline int_jlspline, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_free (Ncm.SFSBesselRecur jlrec, bool free_grid);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_goto (Ncm.SFSBesselRecur jlrec, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_next (Ncm.SFSBesselRecur jlrec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_previous (Ncm.SFSBesselRecur jlrec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_recur_set (Ncm.SFSBesselRecur jlrec, long l);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static Ncm.Spline sf_sbessel_spline (ulong l, double xi, double xf, double reltol);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_taylor (ulong l, double x, double djl);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sf_sbessel_taylor_coeff_jl_jlp1 (Ncm.SFSBesselRecur jlrec, uint n, double djl, double djlp1);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double smoothd (double @in, size_t N, size_t points, size_t pass);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sphPlm_test_theta (double theta, int lmax, int lmin_data);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sphPlm_x (int l, int m, int order);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sphere_healpix_nest2ring (int nside, long nest_index);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_pix2ang_nest (int nside, long nest_index, double theta, double phi);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_pix2ang_ring (int nside, long ring_index, double theta, double phi);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_pix2vec_nest (int nside, long nest_index, Ncm.TriVec vec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_pix2vec_ring (int nside, long ring_index, Ncm.TriVec vec);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static long sphere_healpix_ring2nest (int nside, long ring_index);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void sphere_healpix_vec2pix_ring (int nside, Ncm.TriVec vec, long i);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_healpix_write_map (Ncm.SphereMap map, string filename, bool overwrite);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapalm_init (Ncm.SphereMapAlm mapalm, int lmax);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapsht_alm2map (Ncm.SphereMapSHT mapsht);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapsht_alm2map_circle (Ncm.SphereMapSHT mapsht, int ring, int ring_size, double theta, double phi);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapsht_map2alm (Ncm.SphereMapSHT mapsht, double cut);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool sphere_mapsht_map2alm_circle (Ncm.SphereMapSHT mapsht, int ring, int ring_size, double norma, double theta, double phi, int start_m, int end_m);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double spline2dim_integ_total (Ncm.Spline2d s2d);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sqrt1px_m1 (double x);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string string_ww (string msg, string first, string rest, uint ncols);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double sum (double d, ulong n);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double topology_comoving_a0_lss (uint n, double alpha);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double topology_sigma_comoving_a0_lss (uint n, double alpha, double sigma_alpha);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string util_basename_fits (string fits_filename);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool util_cvode_check_flag (void* flagvalue, string funcname, int opt);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static bool util_cvode_print_stats (void* cvode);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static string util_function_params (string func, [CCode (array_length = false)] out double[] x, out uint len);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static double util_smooth_trans (double f0, double f1, double z0, double dz, double z);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void util_smooth_trans_get_theta (double z0, double dz, double z, double theta0, double theta1);
	[CCode (cheader_filename = "numcosmo/numcosmo-math.h")]
	public static void util_swilk (double x, int n, double w, double pw, int ifault);
}
