/***************************************************************************
 *            test_nc_hiqg_1d.c
 *
 *  Fri May 11 14:42:31 2018
 *  Copyright  2018  Sandro Dias Pinto Vitenti
 *  <sandro@isoftware.com.br>
 ****************************************************************************/
/*
 * numcosmo
 * Copyright (C) Sandro Dias Pinto Vitenti 2016 <sandro@isoftware.com.br>
 * numcosmo is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * numcosmo is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#undef GSL_RANGE_CHECK_OFF
#endif /* HAVE_CONFIG_H */
#include <numcosmo/numcosmo.h>

#include <math.h>
#include <glib.h>
#include <glib-object.h>

typedef struct _TestNcHIQG1D
{
  NcHIQG1D *p;
} TestNcHIQG1D;

void test_nc_hiqg_1d_new (TestNcHIQG1D *test, gconstpointer pdata);
void test_nc_hiqg_1d_free (TestNcHIQG1D *test, gconstpointer pdata);
void test_nc_hiqg_1d_basis1 (TestNcHIQG1D *test, gconstpointer pdata);
void test_nc_hiqg_1d_basis2 (TestNcHIQG1D *test, gconstpointer pdata);
void test_nc_hiqg_1d_basis3 (TestNcHIQG1D *test, gconstpointer pdata);

void test_nc_hiqg_1d_traps (TestNcHIQG1D *test, gconstpointer pdata);
void test_nc_hiqg_1d_invalid_not_reached (TestNcHIQG1D *test, gconstpointer pdata);

gint
main (gint argc, gchar *argv[])
{
  g_test_init (&argc, &argv, NULL);
  ncm_cfg_init ();
  ncm_cfg_enable_gsl_err_handler ();

  g_test_add ("/nc/hiqg_1d/basis1", TestNcHIQG1D, NULL,
              &test_nc_hiqg_1d_new,
              &test_nc_hiqg_1d_basis1,
              &test_nc_hiqg_1d_free);
  
  g_test_add ("/nc/hiqg_1d/basis2", TestNcHIQG1D, NULL,
              &test_nc_hiqg_1d_new,
              &test_nc_hiqg_1d_basis2,
              &test_nc_hiqg_1d_free);
  
  g_test_add ("/nc/hiqg_1d/basis3", TestNcHIQG1D, NULL,
              &test_nc_hiqg_1d_new,
              &test_nc_hiqg_1d_basis3,
              &test_nc_hiqg_1d_free);
  
  g_test_add ("/nc/hiqg_1d/traps", TestNcHIQG1D, NULL,
              &test_nc_hiqg_1d_new,
              &test_nc_hiqg_1d_traps,
              &test_nc_hiqg_1d_free);

#if GLIB_CHECK_VERSION(2,38,0)
  g_test_add ("/nc/hiqg_1d/invalid/not_reached/subprocess", TestNcHIQG1D, NULL,
              &test_nc_hiqg_1d_new,
              &test_nc_hiqg_1d_invalid_not_reached,
              &test_nc_hiqg_1d_free);
#endif
  g_test_run ();
}

void
test_nc_hiqg_1d_new (TestNcHIQG1D *test, gconstpointer pdata)
{
  test->p   = nc_hiqg_1d_new ();

	g_assert (test->p != NULL);
  g_assert (NC_IS_HIQG_1D (test->p));
}

void
test_nc_hiqg_1d_free (TestNcHIQG1D *test, gconstpointer pdata)
{
  NCM_TEST_FREE (nc_hiqg_1d_free, test->p);
}

void 
test_nc_hiqg_1d_basis1 (TestNcHIQG1D *test, gconstpointer pdata)
{
	const gint np          = 50;
	gdouble xv[50]         = {0.2, 0.4, 0.6, 0.8, 1., 1.2, 1.4, 1.6, 1.8, 2., 2.2, 2.4, 2.6, 2.8, 3., 3.2, 3.4, 3.6, 3.8, 4., 4.2, 4.4, 4.6, 4.8, 5., 5.2, 5.4, 5.6, 5.8, 6., 6.2, 6.4, 6.6, 6.8, 7., 7.2, 7.4, 7.6, 7.8, 8., 8.2, 8.4, 8.6, 8.8, 9., 9.2, 9.4, 9.6, 9.8, 10.};
	gdouble h              = M_PI;
	gdouble a              = 0.1;
	gdouble IM[50][50]     = {{0.39570016976699043858881172312844482949, 0.50619694076155564317856867410263002744, 0.33291391907007949615808467322818804961, 0.13490081005972486068604278040222316537, 0.03548298098468914323369718810278436438, 0.00618076178053481315679861066060089455, 0.00071918088003658630432615363251775184, 0.0000561230731293122516795092012315344, 2.94300564896639230191818679035819e-6, 1.0380407387888484326968729349728e-7, 2.46400950798117120518739158659e-9, 3.9373963946378132381294200642277705317570502939e-11, 4.236417716876020454746935038187120444985144645e-13, 3.0695035707011509711622445533770702135567414e-15, 1.49781530230175881344715710272255764514158e-17, 4.9226651572244855686812421301247561324e-20, 1.089729808077187416708614822454752913e-22, 1.62492686291963615228252346378409e-25, 1.632156415616297670893850250753e-28, 1.1043750542076698308583981944372796697948289883e-31, 5.033963492053053739523310320546785741176088e-35, 1.545796560200630522919852481976913765567e-38, 3.19780657457049137517779538618839705e-42, 4.4567397851703514362497500346929e-46, 4.184603458801688003221178852423883813235116721e-50, 2.647093056701408957336549913959520322886111e-54, 1.12815098321725813165889038221575515732e-58, 3.239313935313370132121125764276356e-63, 6.26658353201572181031866127284392980849459267385e-68, 8.167786303474627861853113361253769337098112e-73, 7.1726068925064904047087084480582892372e-78, 4.24377047625331788481489877725397e-83, 1.69173262021835676963614267730868230019801572843e-88, 4.54379858833684624670585587977626119014237e-94, 8.22273410447443234587443889052872384e-100, 1.00259460923138700235925228889e-105, 8.236607499129537606856269167200041667915238e-112, 4.559183292467557352016793224636158236e-118, 1.700368530009993960445962810084e-124, 4.272852615424315535362317908573927633325311e-131, 7.23457504608184957324811500828980335e-138, 8.25333943837259670850003142157120860959064264697e-145, 6.3440876075169108395846502038111696909833e-152, 3.285735142837465507259729599776641e-159, 1.1466236796324287617683991759794275582921662788e-166, 2.69609517305978709878823212464571679242e-174, 4.271460680550645763197458284189e-182, 4.5597953692038751909635391324792685487529e-190, 3.279765932961348685630253626301401e-198, 1.58953343254301766320349254686761330764766926e-206}, {0.50619694076155564317856867410263002744, 0.79717048177994181769108926378820699922, 0.7054611072534048647845176442220815461, 0.40441262093590200105127305008578002073, 0.15435034667140990109246127937528905598, 0.03948844864091950379980423879754229349, 0.00678663613598982260617140105044991834, 0.00078427789594840564515280291468620185, 0.00006097397694410823306005123035216948, 3.19026004025574857168461019851466e-6, 1.1236172352719690052976700633827e-7, 2.66438917687376479032811242605e-9, 4.25423706339627686255315225617263560313762777646e-11, 4.574413080422271469070197223401714734955888696e-13, 3.3126407297291086494043528115850141407867412e-15, 1.61572429564186563153451542215913442314483e-17, 5.30808178884960791722808788929871769831e-20, 1.174640124485161695313948275520222078e-22, 1.750996264659875449507636577242756e-25, 1.758298267249714926368771676406e-28, 1.1894291501740741406933806616507468663059068954e-31, 5.420426091241200426021909858030705742294702e-35, 1.664124689736799740561975051854895191535e-38, 3.44194191336542213467111843867279075e-42, 4.7961544101440325103354623533811e-46, 4.5025717724761786986506192103334789533859131268e-50, 2.847811573102062816782229652616653961967865e-54, 1.21352758478089195260075580746511221526e-58, 3.484015156546436611369088228025099e-63, 6.7391660664065770481225835134095112144042267019e-68, 8.782767985408293945689613458055031185147847e-73, 7.711855034795797856783316407251853049e-78, 4.56237819371433988723543672561462e-83, 1.8185750178580187085246840127329750723484859013e-88, 4.88405993282901675594570437520881313893289e-94, 8.83776994035204916178869160174527108e-100, 1.077502501444304325974037790301e-105, 8.851350892919271479402239700938169240786887e-112, 4.899120854904302101601822224169491993e-118, 1.827029654982319000829579678273e-124, 4.590852071430190082718862917990615486104552e-131, 7.77253289924000503452840564530660778e-138, 8.86654909129107384004010240131201772174699880993e-145, 6.8150742735110168410464643827861509712687e-152, 3.52948658955468921394293131683769e-159, 1.2316248354416096948735058446230808922888016888e-166, 2.89582438627132821306968137463565422011e-174, 4.587686687954438762205962181334e-182, 4.89715485244838774487937802103997253065163e-190, 3.522274855845639348107168499496823e-198}, {0.33291391907007949615808467322818804961, 0.7054611072534048647845176442220815461, 0.90214002206501952676787471322513995971, 0.7627188700603047938569989078564384158, 0.43142650845104119856776258053258285274, 0.16375565488470941151937385149813428329, 0.04176449050192609882166299566306270621, 0.00716258445391070105790024724017849316, 0.000826410391992946516088292858216524, 0.00006416965276180030786438219874353959, 3.3540886635711708011574014525702e-6, 1.1803379934050463593654381268447e-7, 2.79693903354355909475994906236e-9, 4.46323014495890386881969837023225407707383265339e-11, 4.796680903406885384649194513324312920945063983e-13, 3.472052917275103782688046509567357126052041e-15, 1.69281412940733708794718262547732883133519e-17, 5.55941494578918744319544551288503159075e-20, 1.229878097301829642670840894868264225e-22, 1.83282915665787520416099336259338e-25, 1.840011782120162829546260048066e-28, 1.2444230373234472376076444525109750781587294166e-31, 5.669869570577743855380717189769138887708382e-35, 1.740376981127537168919356157455307452805e-38, 3.59903060233657105297408862148642382e-42, 5.0142457654616822228504261653181e-46, 4.7066164879197191220730735921547851475361000754e-50, 2.976458305026678022822207109406925781303781e-54, 1.26818547668385591985044214729331438989e-58, 3.640503787707798267844666871546996e-63, 7.04108080160996442451668478663903985966808492356e-68, 9.175280804820150555395373297110718715813571e-73, 8.055720308893307527734303837835585486e-78, 4.76537307266640198230604823359208e-83, 1.89932488946174539700160666483417779839814994331e-88, 5.10050944511071239729428872030169534128867e-94, 9.22872575123072499478201359276994704e-100, 1.125085688192628946222434782187e-105, 9.241591860497987685216177168565688693637214e-112, 5.11477834043943482260027718125765622e-118, 1.90733557424456292092497522413e-124, 4.792354853439200822103439449226083958340756e-131, 8.1132267035519826475887873138879339e-138, 9.25469628604315044336965974162438225842735064204e-145, 7.1130474030963557165107481483798827809641e-152, 3.683623151250505025235478437326942e-159, 1.2853504866098412910161277202455377703681389977e-166, 3.02200852345772485923623708815944475565e-174, 4.787385065468359343145446957871e-182, 5.11011125331039247107692389059221454884661e-190}, {0.13490081005972486068604278040222316537, 0.40441262093590200105127305008578002073, 0.7627188700603047938569989078564384158, 0.95634937992977090125805342257979561582, 0.80275430613656939428957469903479988398, 0.4521910292128508302595628930640504872, 0.17115325018478913663900468607796974804, 0.04356124497789318594914303635596843378, 0.00745897040888373946799498989104361199, 0.00085953861586596985944617798157146064, 0.00006667497037854635451882165725562106, 3.48214834272444521425804343321141e-6, 1.2245498542729033104956086898697e-7, 2.89998226470391660963536343541e-9, 4.62529543163056715039726003644152282167967541765e-11, 4.968640491019513848008307574515431292275644618e-13, 3.5951176162546904829519306156196037076654273e-15, 1.75220738868053552152946930702193676281444e-17, 5.75269135200255998213799440579314048748e-20, 1.272282578649652327364267190744521392e-22, 1.89554800979011767506172416247425e-25, 1.902544467617033049568924343789e-28, 1.2864485788876552944121624685204024448874256385e-31, 5.860238384654555050085252730183680098806107e-35, 1.79849850387170906772246120771713494446e-38, 3.71862810256453274395796886788515203e-42, 5.1801046274990066107267300263038e-46, 4.8616323392595418874008776966982938996403834298e-50, 3.074097753429037969881933711573062641601244e-54, 1.30963108456713141335477973265090541667e-58, 3.759061273077754815312263395532078e-63, 7.26962536382480146934462874335608536554518394182e-68, 9.47217328114521305217712222746392409853937e-73, 8.31562221285223949913632121060772752e-78, 4.91869272718979742401199856693441e-83, 1.96027309287651872823711007854412073046020201499e-88, 5.26377542455109568621848157631562280396263e-94, 9.52343893094183143657646810628962831e-100, 1.160934118843649930406432951242e-105, 9.53542812234957104387457533750805964180563e-112, 5.277072703538894414803328975325341374e-118, 1.967739148309911084712275012809e-124, 4.943844000082602693924357681522610533718675e-131, 8.36923778579189339493430991537300553e-138, 9.54623295894831338080305812854350232889347458768e-145, 7.3367565492061896799192000661448709028788e-152, 3.799295472482415161091831558796693e-159, 1.325652752529273274655706443173360397849533065e-166, 3.11662853650493961175667059193419927557e-174, 4.937073886242983334078573889401e-182}, {0.03548298098468914323369718810278436438, 0.15435034667140990109246127937528905598, 0.43142650845104119856776258053258285274, 0.80275430613656939428957469903479988398, 0.99999999732471200892576031875887601096, 0.83597218967143824612410394191267170639, 0.46957787392830146735939475878307661259, 0.17736803182349320297253403054364425094, 0.04507196962101966568859616937775272424, 0.00770806972643115956473004745977401072, 0.00088735144836560942369764430280629933, 0.00006877533093381672386359102267030768, 3.58933902185105341468385868183761e-6, 1.2614961824704964057610386377745e-7, 2.98595092405256818897208094626e-9, 4.76028934556280305836468025909482536550195618284e-11, 5.11165423536069734518741553220669339401043351e-13, 3.6973150858901092322112938817048515230277305e-15, 1.80145997849298736577434319517530707823276e-17, 5.91275268952465317874824450142091492269e-20, 1.307354938129111515857585337533266896e-22, 1.947359477139676499162141616693358e-25, 1.954142962806776758333384074443e-28, 1.3210880782353028471093064082641350565811611741e-31, 6.016988213201489399336663900770550668687112e-35, 1.846309124999847515651831051866220777897e-38, 3.8169176483456189648895638009945996e-42, 5.3162936273950185643089323753015e-46, 4.9888116789281200229246986079706933860555621326e-50, 3.154140250280811894152401167447434488014345e-54, 1.34358151403946087692773814979967907478e-58, 3.85610840536860385992539065746979e-63, 7.45657564058486868836065195196416833672328717395e-68, 9.71487312905981476087897171195334785375292e-73, 8.5279503792015998892303098188013202257e-78, 5.04387296375798985372592284939629e-83, 2.01000668751425230624952841311236243040762077471e-88, 5.39692696185044688179852795233777729339731e-94, 9.76366575526994860928293726144411406e-100, 1.19014017208367038560523982923e-105, 9.774703320080845468136187036487157644502996e-112, 5.409169894849109835579713897172460924e-118, 2.016881785389714340945750252064e-124, 5.06703823945732000585995923833966224322456e-131, 8.57734526588594001728060978522181188e-138, 9.78312407312268138771290265691344081738758558267e-145, 7.5184637880569603228983444324579307962471e-152, 3.89321519147496880584121517446356e-159, 1.3583643137037251114188135026517326135495684358e-166, 3.19340085014982542026195465839546865258e-174}, {0.00618076178053481315679861066060089455, 0.03948844864091950379980423879754229349, 0.16375565488470941151937385149813428329, 0.4521910292128508302595628930640504872, 0.83597218967143824612410394191267170639, 1.03713728933617901837052760672446353239, 0.86457890234729200083896167074201184044, 0.48464634796292884076438075973125702086, 0.18277160421393025498460101467223108241, 0.04638744053043817956112045279730554553, 0.00792506855463675383596598429872123169, 0.000911575497636360232101657142927564, 0.00007060362897418785207344282549378438, 3.68257053017189799154813545166423e-6, 1.2936011337878660112003110490641e-7, 3.06057948258027105385843364003e-9, 4.87735503126905083395827433311201103453863211241e-11, 5.235545670855532089889643221455421326430287302e-13, 3.7857566770340715303362942496173716511270563e-15, 1.84404019094439769397451683360217681914181e-17, 6.05099464817692007424842781467532861098e-20, 1.337617601212996184878444345270720627e-22, 1.992024926890877244427812380799448e-25, 1.998585803593827515204361030265e-28, 1.350898671903242170400846145380643521960704629e-31, 6.151777499173792559616362266011832785561549e-35, 1.887389707275083927009984334611485817627e-38, 3.90130892514183849651950621053210798e-42, 5.4331423142241058266272673659593e-46, 5.0978559621291104973593286601285956200078577021e-50, 3.222724413416035563244520722919053538820505e-54, 1.37265366167932457732930787544688895842e-58, 3.939161216075136400195497443370577e-63, 7.6164755115976383237669159117238600868797482168e-68, 9.922341510683137034094440460443338167054884e-73, 8.7093598502341556738488171451296525733e-78, 5.15077034616350352637902151821923e-83, 2.05245580446567674290127905231561376093623623242e-88, 5.51052232646171874088623200739169307585556e-94, 9.96851729302221184285146073810740354e-100, 1.215034545370383978190421405149e-105, 9.978568721521135107056651632748054003667849e-112, 5.52167274266973525466277543350150274e-118, 2.05871861072321406006462700584e-124, 5.171878219375900564892562376039727564886693e-131, 8.75438311524416111006443521589998272e-138, 9.98457741629974251637402491961532418327889351275e-145, 7.6729359843790744384526710674862574731411e-152, 3.973031590177111457175682944235396e-159, 1.3861549510460991595085716668092718349686890613e-166}, {0.00071918088003658630432615363251775184, 0.00678663613598982260617140105044991834, 0.04176449050192609882166299566306270621, 0.17115325018478913663900468607796974804, 0.46957787392830146735939475878307661259, 0.86457890234729200083896167074201184044, 1.06961037572506885162280964042298600066, 0.88981250994194645667990959322229501851, 0.49800634457170388665045039934769920125, 0.18757681255955833934151771096261163728, 0.04755918000178128893303787843812047714, 0.00811851435181528885835895469067569235, 0.00093317593979890223141161233169019543, 0.00007223375159463525376173041257495805, 3.76566840648846041538519245850142e-6, 1.3222023930769451444142252659772e-7, 3.12702415027799819504018657287e-9, 4.98151459583535491933299133819005578054087966642e-11, 5.345701949583852749890272069932148421592087913e-13, 3.8643371976013933612467301795871402736987304e-15, 1.88184561393398371052560763733345497798644e-17, 6.17364689837556641989297300634820696015e-20, 1.364448566328642844410895966018104312e-22, 2.031598053856533754076304068697857e-25, 2.037935121056597978221401573683e-28, 1.3772753909401755392520078725449083708411332504e-31, 6.270964465698601699300168909667594027598129e-35, 1.923692660467192962988806384455561475461e-38, 3.97584108177197803076035011385584469e-42, 5.5362804966851082705900208717332e-46, 5.1940518819800600166245658112765644318356477312e-50, 3.283194990516663650929909244337112180919947e-54, 1.39827324578112398763227571060361675137e-58, 4.012314174057564279059425329395896e-63, 7.75724738687559882775095730105270100371673854706e-68, 1.0104906404397428501706547056836187613400051e-72, 8.8689220171408968220759598510387545382e-78, 5.24475315571310891567945413848075e-83, 2.08976087634220489055831171634392691049231193976e-88, 5.61031161054762083932633608648901161071408e-94, 1.014840129608978930432631731213485083e-99, 1.236886496259686287814851685674e-105, 1.0157453623045842453072949180892978297088601e-111, 5.620355214196624317413076653415569889e-118, 2.095403443289840742055514522722e-124, 5.263777227634837538435447096465819717537051e-131, 8.90951842239901554470874841629075505e-138, 1.016105274099173168816603194311890415113721504305e-144, 7.8082145494644737011621725269264217212173e-152, 4.04291014965619579430409178904402e-159}, {0.0000561230731293122516795092012315344, 0.00078427789594840564515280291468620185, 0.00716258445391070105790024724017849316, 0.04356124497789318594914303635596843378, 0.17736803182349320297253403054364425094, 0.48464634796292884076438075973125702086, 0.88981250994194645667990959322229501851, 1.09856054330611775221944727008753045522, 0.91245814907287642828282764455478309709, 0.51004655602499921539407727509207960304, 0.19191884219151303523007852465000971043, 0.04861971501011204606537418486866139893, 0.00829376962939201219439184824479949957, 0.00095275491055156634973107373727268162, 0.00007371157457201618285526862981601902, 3.84099853700666272363447572203105e-6, 1.3481245808936981476431313711635e-7, 3.1872254780378671273343332153e-9, 5.0758492046548648455184766647484300107841316368e-11, 5.445422420083521647361794591589473363820837637e-13, 3.9354385912589988157768309306061559139915734e-15, 1.91603538136817852732201968430570194174498e-17, 6.28451108505156592333227724873319616445e-20, 1.388688070124280458677030550722738152e-22, 2.067330250347243559135865146148441e-25, 2.073446731542908051973926654878e-28, 1.4010673867462065281541499883041309321119449394e-31, 6.378417773878165613635170418151477228732085e-35, 1.956405519329785133614599473504673801714e-38, 4.04297017244764616656872848512264434e-42, 5.6291305934619391880669349938452e-46, 5.2806125862634490729567750468851607945537324862e-50, 3.337584480412958095678899133806489151721996e-54, 1.42130649437012563557942596679003486951e-58, 4.078054630966162324967507747689704e-63, 7.88370349425079664006166017161442810254729907244e-68, 1.0268840595260135917819253749935583284391207e-72, 9.0121459866687583366668147419397200309e-78, 5.3290813347379233363035741399797e-83, 2.12322161781631158430627769997671254754165628393e-88, 5.69978619259344025312782354109231789277019e-94, 1.030963690571286965856554008730038526e-99, 1.256466631490311948483705573296e-105, 1.0317689756307551358146814576781074635893861e-111, 5.70872263581112821589867985790863733e-118, 2.128243813929066768877312682746e-124, 5.346021465393911366597209287471539373812899e-131, 9.04831607276248951436859276567944424e-138, 1.0318899543693201985667040782094071700211254891e-144, 7.9291808831375823362691628276355249500294e-152}, {2.94300564896639230191818679035819e-6, 0.00006097397694410823306005123035216948, 0.000826410391992946516088292858216524, 0.00745897040888373946799498989104361199, 0.04507196962101966568859616937775272424, 0.18277160421393025498460101467223108241, 0.49800634457170388665045039934769920125, 0.91245814907287642828282764455478309709, 1.1247461131420947862185145348171302759, 0.93304793378832572643439902212957265194, 0.52103193185366808084768139389380235734, 0.19588975510167698002314881729846336809, 0.04959111485154284151273032998201746702, 0.00845445639729211668699284647827892096, 0.00097071730173507899283759555437773203, 0.00007506782155895613363046902402372502, 3.91013982497999406390218841779237e-6, 1.3719163694438240884380967390205e-7, 3.24247137119466921360376297163e-9, 5.16239941799602662907472400496738715395992310594e-11, 5.536888236581182759081710282752378181655471301e-13, 4.0006331648725157189608114599500608847812124e-15, 1.94737366335682856321080252869541389598573e-17, 6.38609080297397016720986260232802523176e-20, 1.410888954654755890144160319571040772e-22, 2.100044249302050383722040295529674e-25, 2.10594573520692529217962577001e-28, 1.4228322582614397154911895409468499181440830199e-31, 6.476676573389666211765986914864757732113896e-35, 1.986307385001326054243044170979434353555e-38, 4.10430695387296149226107032970293123e-42, 5.7139364373540216538249351404343e-46, 5.3596441370987681788601600575872747573609899512e-50, 3.387224775329544513933368291198892087031918e-54, 1.44232092895600017818315545107594467166e-58, 4.138011919572061804411127687364374e-63, 7.99899557782208669619390247126095944396744635838e-68, 1.041825184922174601699754430179021295303087e-72, 9.1426389921570381928025972262960992686e-78, 5.40588919096009590731091248427162e-83, 2.15368888223038415809893654686115666955912636528e-88, 5.78123150298151990694747651063751142067622e-94, 1.045636028559648967836855207613348741e-99, 1.27427931584246437166399022943e-105, 1.0463421028310277216692755750655741516583316e-111, 5.789069012641046834024863033764575416e-118, 2.158095377901859759128833237144e-124, 5.420761357334727846841265504053277510535272e-131, 9.17441749256790103563808228972683011e-138, 1.046227254234909852962090970010969638832694447484e-144}, {1.0380407387888484326968729349728e-7, 3.19026004025574857168461019851466e-6, 0.00006416965276180030786438219874353959, 0.00085953861586596985944617798157146064, 0.00770806972643115956473004745977401072, 0.04638744053043817956112045279730554553, 0.18757681255955833934151771096261163728, 0.51004655602499921539407727509207960304, 0.93304793378832572643439902212957265194, 1.1486983549970350067986269467779275306, 0.95196059778428794968836128244894848141, 0.53115215193752438648593394916024960573, 0.19955549126253055574066481486264302467, 0.05048915346837115232142578068636429951, 0.00860315524873899531218005179057054906, 0.00098735059410168693047669054025472652, 0.00007632423427281813556168940634888441, 3.97420618855957811638745604450224e-6, 1.393963803286682065223614149082e-7, 3.2936658642997944456300829047e-9, 5.24259467563023429577270341688992604807134202882e-11, 5.621624650982579275708003773355841723076922878e-13, 4.0610187575180167135514877168356682261973264e-15, 1.97639334050456431491341185817138840876087e-17, 6.48012995066586236062151771704271297139e-20, 1.43143593801527792753228907087485919e-22, 2.130312110989420317002019092300114e-25, 2.136005428664551337157419898655e-28, 1.4429571968821803394605886043456193498407195833e-31, 6.567503076729802733580901765623381202764398e-35, 2.013938713160978218950780995617116211803e-38, 4.16096833614496281206528641867338391e-42, 5.7922533596483125316038642147576e-46, 5.4326059091334958438859366749758072399048243891e-50, 3.433038540953753737399519808374506736616654e-54, 1.46170960292053143039935870293815197531e-58, 4.193314237837756108587346971477212e-63, 8.10530558137458389650858127012268970846702310876e-68, 1.0555983480155768939259148035642398156153762e-72, 9.2628975136159533688964622972061159538e-78, 5.47665363040967961247427992405887e-83, 2.18175137612963228758011480733057754826907786684e-88, 5.85622866625542270864294992979029271774389e-94, 1.059143267831653637517123666615789346e-99, 1.290673420393111845441470621034e-105, 1.0597513578731483476925607433240029193400108e-111, 5.862980889420029878730499035697015798e-118, 2.18554987451640477267001461614e-124, 5.489483976242562259537867517608470873358959e-131, 9.2903406970095109541811755542228159e-138}, {2.46400950798117120518739158659e-9, 1.1236172352719690052976700633827e-7, 3.3540886635711708011574014525702e-6, 0.00006667497037854635451882165725562106, 0.00088735144836560942369764430280629933, 0.00792506855463675383596598429872123169, 0.04755918000178128893303787843812047714, 0.19191884219151303523007852465000971043, 0.52103193185366808084768139389380235734, 0.95196059778428794968836128244894848141, 1.17080491296489233756755644642353529766, 0.96947607890006708449624110844433469582, 0.54054819872573811635049281773282945796, 0.20296512465238904672989623338031992447, 0.05132555804085994396971202577872493568, 0.00874178056992849859385635640223901766, 0.00100286749281147889113425716716075025, 0.00007749685582058419074100421644792448, 4.0340174581713377489896597442139e-6, 1.4145503310438560021986593784135e-7, 3.34147131456215180127688462849e-9, 5.31748029516206417580742620126918908692113664999e-11, 5.700745183090902515317176601796391228163453626e-13, 4.1173956802872034704570086551954787470382336e-15, 2.00348237892287177235200408099044624604874e-17, 6.56789676120315343581302050854845302815e-20, 1.450608529172674866312907378021684358e-22, 2.158549098558746399231643440509487e-25, 2.164041660823739274923907510206e-28, 1.4617228728552500220372626459115603196301851924e-31, 6.652173951991795798164959739142014091784313e-35, 2.039690847927826411858927621936072469233e-38, 4.21376271112665311692477997054496941e-42, 5.8652066237766449390477638361013e-46, 5.5005533710465037632647804573568703809908671446e-50, 3.47569287176548900840322463942479783553706e-54, 1.47975661804168996379824789078710845058e-58, 4.244776853620128465623670579547097e-63, 8.20420989144017732089651572078322677145682926144e-68, 1.0684089288687421625802311000618959344868963e-72, 9.3747245059299320813848752049015117312e-78, 5.54244110394177077161111893373309e-83, 2.2078341348967745618625331677670999135002093013e-88, 5.9259190795263776111461375197987839840731e-94, 1.071691934692418095371113871824198564e-99, 1.305900736375295010118581314465e-105, 1.0722035797125293926364080687339560114586184e-111, 5.931603121420979484557805661256627941e-118, 2.211034271936911512321400491568e-124, 5.553262241941718471312596142145202199947482e-131}, {3.9373963946378132381294200642277705317570502939e-11, 2.66438917687376479032811242605e-9, 1.1803379934050463593654381268447e-7, 3.48214834272444521425804343321141e-6, 0.00006877533093381672386359102267030768, 0.000911575497636360232101657142927564, 0.00811851435181528885835895469067569235, 0.04861971501011204606537418486866139893, 0.19588975510167698002314881729846336809, 0.53115215193752438648593394916024960573, 0.96947607890006708449624110844433469582, 1.19135789816709161041134164783773082884, 0.98580760540457731934024247799404616148, 0.54932801611298858333465865334972755275, 0.20615629390409295521311065629246476414, 0.05210932030391557342529715643901276537, 0.00887179812248304659739547082568553916, 0.00101743053779343033175978380409426393, 0.0000785979191609393550490541030929607, 4.09019740600668495540890129672271e-6, 1.433891171101990420235185712829e-7, 3.38638967952463901675923516033e-9, 5.38784707906527649713685317109660233140129745743e-11, 5.775090915987153431657891202500505903987426031e-13, 4.1703675950156362572662055393129599615959755e-15, 2.028933052380677177667745857114490716275e-17, 6.65034560551332080985113464826110620241e-20, 1.468616859280554082693115531397843086e-22, 2.185067131873782829355095090523009e-25, 2.190366552585365473089509324934e-28, 1.479339804023157205582743016612403124493866148e-31, 6.731646192343169062320946261652569502087777e-35, 2.063856984584670794366187304466207107533e-38, 4.26329543773739867205015693419096976e-42, 5.9336385175043474005531104413643e-46, 5.5642762674109229195279001327791458785378736207e-50, 3.515686745369653976592788690338001386237105e-54, 1.4966744138899970254181295893391518466e-58, 4.293009223969244545547746145721424e-63, 8.29688665326009243952160824564005500630330082784e-68, 1.0804103886084490905225411631740622397228966e-72, 9.4794668785660757826084993862627139212e-78, 5.60404816745503324104313095287252e-83, 2.23225457530146442373154545940521048312873773722e-88, 5.99115501362640328510279106070070328142972e-94, 1.083436219884935027521792854649592837e-99, 1.320149226184671286275813410453e-105, 1.0838531568552293779386506030717428295845483e-111, 5.995790164858290364503903710246985317e-118, 2.2348672064366613493046039045e-124}, {4.236417716876020454746935038187120444985144645e-13, 4.25423706339627686255315225617263560313762777646e-11, 2.79693903354355909475994906236e-9, 1.2245498542729033104956086898697e-7, 3.58933902185105341468385868183761e-6, 0.00007060362897418785207344282549378438, 0.00093317593979890223141161233169019543, 0.00829376962939201219439184824479949957, 0.04959111485154284151273032998201746702, 0.19955549126253055574066481486264302467, 0.54054819872573811635049281773282945796, 0.98580760540457731934024247799404616148, 1.21058327510759474241721726257375408674, 1.00112162675240055679916040258672136003, 0.55757626950522320314650355619460536889, 0.20915857833373526515331350694132268377, 0.05284750796891705867640056363660163336, 0.00899435903989243587616196570797848689, 0.00103116719674110052562717833246923792, 0.00007963700131701771263522357033367955, 4.14323349987141682172705722204989e-6, 1.4521542155056052431268497491038e-7, 3.42881187698180160010835948087e-9, 5.45430992782326199373425963535470831649659406406e-11, 5.845314905562667391241794983176866436452573172e-13, 4.2204025997854957613223944940084097940868784e-15, 2.05297173131147306860453605419219356916187e-17, 6.72821487277505986075279671486862381806e-20, 1.485623350091267574492640971498060084e-22, 2.210107104610941699899551175285379e-25, 2.215220968312902940525174686553e-28, 1.4959703360162579924922360882221981587301251208e-31, 6.806657351166388828076640561042815631130262e-35, 2.086662963760271923242287728406404268969e-38, 4.31003257724753996128930474838901536e-42, 5.9981972233533602380054091220849e-46, 5.6243821028620516873500002425599852158942155422e-50, 3.553403857835331634687021837503188393228637e-54, 1.51262629581003193025307608590311957829e-58, 4.338479709582961534668891383217151e-63, 8.38424101718073468664183664213024393395332727681e-68, 1.0917206006081490345865906015014715531131531e-72, 9.5781589658084348269251050670897733941e-78, 5.66208640011677416722361801583721e-83, 2.25525635947051471622061082375873658649152212455e-88, 6.05259059929305244577963114182396778330627e-94, 1.094494449447888097059700591107465003e-99, 1.333563112575633015484120574271e-105, 1.0948185362035706898497902203376477346101744e-111, 6.056197484158104380928174099316937997e-118}, {3.0695035707011509711622445533770702135567414e-15, 4.574413080422271469070197223401714734955888696e-13, 4.46323014495890386881969837023225407707383265339e-11, 2.89998226470391660963536343541e-9, 1.2614961824704964057610386377745e-7, 3.68257053017189799154813545166423e-6, 0.00007223375159463525376173041257495805, 0.00095275491055156634973107373727268162, 0.00845445639729211668699284647827892096, 0.05048915346837115232142578068636429951, 0.20296512465238904672989623338031992447, 0.54932801611298858333465865334972755275, 1.00112162675240055679916040258672136003, 1.22865967908314715399640937717024413793, 1.01555075649137974869952460807156450425, 0.56536070851585641469612413653552009599, 0.21199569580650007804491266398275771078, 0.05354579113563044573545008027609430403, 0.00911038641391865192097927389222826014, 0.0010441795819479010209089323483891573, 0.00008062176410218090529632237325453398, 4.19351515088330573478095359075748e-6, 1.4694733822828666513635202933267e-7, 3.46904926115431910334954451525e-9, 5.51735790474734712364853221736578573345059277679e-11, 5.91193588125624458875198809777148994557402384e-13, 4.2678720595024223194052826324123426536888012e-15, 2.07577780685170158525564599207903668771846e-17, 6.80208911948416456974248900708889843476e-20, 1.501756466826160877373830387219833557e-22, 2.233859389385428139052067243088001e-25, 2.238795113810555127114771585076e-28, 1.5117425824662756741243270035232383136810344572e-31, 6.877789103139860331010342219054934881475312e-35, 2.108286796275884840838619268853112736579e-38, 4.35434130041610885562359611700022944e-42, 6.0593931568894683928348949237474e-46, 5.6813490628687720715723267720764847214219710322e-50, 3.589146114694659664900733053035913083912551e-54, 1.52774071439386556324825716025732183693e-58, 4.381556593455532353575396399692575e-63, 8.46698452366632715767548200820899837608069411033e-68, 1.1024322015909288474639791814541308984638417e-72, 9.6716134612258317287060329724180186572e-78, 5.71703622724720004561475300060075e-83, 2.2770308585866445682388935525187153124848128747e-88, 6.11073949635421367993432191370845415678466e-94, 1.104959524392783768996748926758834699e-99, 1.346255611831689920748715791546e-105, 1.1051926869746927408003984951373474710858595e-111}, {1.49781530230175881344715710272255764514158e-17, 3.3126407297291086494043528115850141407867412e-15, 4.796680903406885384649194513324312920945063983e-13, 4.62529543163056715039726003644152282167967541765e-11, 2.98595092405256818897208094626e-9, 1.2936011337878660112003110490641e-7, 3.76566840648846041538519245850142e-6, 0.00007371157457201618285526862981601902, 0.00097071730173507899283759555437773203, 0.00860315524873899531218005179057054906, 0.05132555804085994396971202577872493568, 0.20615629390409295521311065629246476414, 0.55757626950522320314650355619460536889, 1.01555075649137974869952460807156450425, 1.24573093961551732596668033664030508094, 1.02920249107883861653339718588339788993, 0.57273647042470625010200330199622915764, 0.21468698856826847696333640556613033269, 0.05420879725072447383019679558816797562, 0.00922063348967827749069895416420847336, 0.00105655095994240212701831974368765535, 0.00008155844891887712287292919693600917, 4.24135919946950314220095029086656e-6, 1.4859574944044210874592393813779e-7, 3.50735451852332135461029129203e-9, 5.57738742710290217791021900885632777376504152248e-11, 5.97537380883687004878274994442110182059652894e-13, 4.3130762985241505123574607638017062112956531e-15, 2.09749620330046940469546374478873649746901e-17, 6.8724401388006010589839091844765577808e-20, 1.517119802215791129390166285002496461e-22, 2.256477376835017432896645086029484e-25, 2.261242132710938132425977623652e-28, 1.5267596245312752245291903652767936326257317408e-31, 6.945509181913766722777111043425310774998678e-35, 2.128871543684281172348890570821043086779e-38, 4.39651654078887592867217950130206229e-42, 6.1176361248334946893222274522171e-46, 5.7355609150618581673631872211405443141528452467e-50, 3.623155716927504906479037632556790207901455e-54, 1.54212068176437032706968937698170071591e-58, 4.422535128684851244951865783155438e-63, 8.54568744845543633686767426341555298925385257385e-68, 1.1126194168245363260914040373716036692070586e-72, 9.7604813760714514576537018186117270197e-78, 5.76928240849565810119160882163369e-83, 2.29773130490256538512578823887089236445632773214e-88, 6.16601291756337381051865731322412874806224e-94, 1.11490580403692407133024868174167042e-99, 1.358317329309302998983002897928e-105}, {4.9226651572244855686812421301247561324e-20, 1.61572429564186563153451542215913442314483e-17, 3.472052917275103782688046509567357126052041e-15, 4.968640491019513848008307574515431292275644618e-13, 4.76028934556280305836468025909482536550195618284e-11, 3.06057948258027105385843364003e-9, 1.3222023930769451444142252659772e-7, 3.84099853700666272363447572203105e-6, 0.00007506782155895613363046902402372502, 0.00098735059410168693047669054025472652, 0.00874178056992849859385635640223901766, 0.05210932030391557342529715643901276537, 0.20915857833373526515331350694132268377, 0.56536070851585641469612413653552009599, 1.02920249107883861653339718588339788993, 1.26191468896038649886872027324468772935, 1.04216526679170402157959603186761393806, 0.5797490818426061899676715697195887319, 0.21724845976690813358604015437093539943, 0.05484035827264440336602680170808768567, 0.00932572408095004223558837736143486639, 0.00106835025967737937772086297811475409, 0.00008245221853023239032410196000384135, 4.28702747858345974134251507053784e-6, 1.5016963864838188719531117433833e-7, 3.54393601565700543608625893055e-9, 5.63472502515632075887034848555491029610035930481e-11, 6.035974248271670877570478872330357652147295055e-13, 4.3562621819990321404156457827720155065975269e-15, 2.11824593388624796090511209261209188473009e-17, 6.93965502565586745578153099605485768506e-20, 1.5317982810383851750599239931430629e-22, 2.278086719218450875702921759919703e-25, 2.282687386073330277129132279523e-28, 1.5411057878849270105376482870730901735203863235e-31, 7.010199988429814914109549615728871564276362e-35, 2.148534103269917923995818734335292045954e-38, 4.43679917047530682452552693424187271e-42, 6.173260661286553453233581678234e-46, 5.7873308042687449847535437183364647400019704128e-50, 3.655630217508834113500236445559053822033956e-54, 1.55585019045312177799639237618375740633e-58, 4.461655975385462373702358462101934e-63, 8.62081448165523675606641754928628347099993396456e-68, 1.1223427120967433397424686721884170119703184e-72, 9.845292905138566843972777807143347149e-78, 5.81913822501522626138946541925685e-83, 2.31748243697629918049279356585493866568113474417e-88, 6.21874554325678979560718887245625332687459e-94, 1.124393797213106309823856549037885792e-99}, {1.089729808077187416708614822454752913e-22, 5.30808178884960791722808788929871769831e-20, 1.69281412940733708794718262547732883133519e-17, 3.5951176162546904829519306156196037076654273e-15, 5.11165423536069734518741553220669339401043351e-13, 4.87735503126905083395827433311201103453863211241e-11, 3.12702415027799819504018657287e-9, 1.3481245808936981476431313711635e-7, 3.91013982497999406390218841779237e-6, 0.00007632423427281813556168940634888441, 0.00100286749281147889113425716716075025, 0.00887179812248304659739547082568553916, 0.05284750796891705867640056363660163336, 0.21199569580650007804491266398275771078, 0.57273647042470625010200330199622915764, 1.04216526679170402157959603186761393806, 1.27730844458753968447167236185824488637, 1.05451277929924465867708415251685402859, 0.58643660784167819480484352122397232119, 0.21969351601701302385356904846265924125, 0.05544368751703172538036338408595128123, 0.0094261814257641033708616986904309436, 0.00107963528357556570567306559073072882, 0.00008330739992410116515043696758258364, 4.33073926754260052310775715871242e-6, 1.5167652268422826554090565729604e-7, 3.57896793768299405100365042133e-9, 5.68964340235277947134094259591805767662277062358e-11, 6.094025522573564469099516194327237536027905187e-13, 4.3976354964682299055605643944772827484002376e-15, 2.13812612090393276933399271324765301707726e-17, 7.0040559114319598397739225634771389038e-20, 1.545862520629478603328516687908928447e-22, 2.298791823834920173909067108490352e-25, 2.303234968659682321153484785467e-28, 1.5548510491491156073402187058575235039109870011e-31, 7.072178668731780814270405703943758232398162e-35, 2.16737137219513158155347184596018799028e-38, 4.47538875122896798182947841334860902e-42, 6.2265437995456350503641643588725e-46, 5.8369179412316860451196916578834422737801054146e-50, 3.686733080288508827833984097457224107992894e-54, 1.56899871446200276988161616754600731916e-58, 4.499118128165895879691275654634197e-63, 8.69274974354507008864549073758626404997902878139e-68, 1.1316520552167695630715035062583201119588776e-72, 9.9264860767228544588272401623720484565e-78, 5.86686243591753858780576776677084e-83, 2.3363872613085831667487404057835593387298829771e-88, 6.26921368804769698307982223330985215166348e-94}, {1.62492686291963615228252346378409e-25, 1.174640124485161695313948275520222078e-22, 5.55941494578918744319544551288503159075e-20, 1.75220738868053552152946930702193676281444e-17, 3.6973150858901092322112938817048515230277305e-15, 5.235545670855532089889643221455421326430287302e-13, 4.98151459583535491933299133819005578054087966642e-11, 3.1872254780378671273343332153e-9, 1.3719163694438240884380967390205e-7, 3.97420618855957811638745604450224e-6, 0.00007749685582058419074100421644792448, 0.00101743053779343033175978380409426393, 0.00899435903989243587616196570797848689, 0.05354579113563044573545008027609430403, 0.21468698856826847696333640556613033269, 0.5797490818426061899676715697195887319, 1.05451277929924465867708415251685402859, 1.2919940099556332976045472389552122398, 1.06630713480314650662105882769712253778, 0.5928312257154483812615025254530611862, 0.22203351165063238144496832468558059643, 0.05602150916776841757042496831826697807, 0.00952244928294341488347636499266932278, 0.00109045505038102771000617151094056426, 0.00008412766114477947129372025948049981, 4.37268034207801765714161615725978e-6, 1.5312276527727116048937425671755e-7, 3.61259763147794592424664226309e-9, 5.74237305206243130017380102758756653191500852453e-11, 6.149771122389378534497231426798640736570836992e-13, 4.4373698863243772770768607115514644774858938e-15, 2.1572203375957256113551219943500911946198e-17, 7.06591418742253791522082331344566729521e-20, 1.559371971849750669060052199164234908e-22, 2.318680528120497351750532444413861e-25, 2.322972398590121367124533261066e-28, 1.5680542060528786385420879456006964940625698546e-31, 7.131711554598340466463875352913780050667315e-35, 2.185464679895655409022918346300756681038e-38, 4.51245270139666880542481752323128035e-42, 6.2777178463652089483730036378722e-46, 5.8845395966302359206199306468734955484483681661e-50, 3.716601267644108648663230301754035336818015e-54, 1.58162444341653813447929394522196122568e-58, 4.535088204135085350406185666540119e-63, 8.76181475640226995177219334833279625413138484337e-68, 1.1405892589995902868528661156151123231683666e-72, 1.00044273330411977946197970687209729175e-77, 5.91267145827018534543145736991962e-83, 2.35453190913033813550078713206194324854806440034e-88}, {1.632156415616297670893850250753e-28, 1.750996264659875449507636577242756e-25, 1.229878097301829642670840894868264225e-22, 5.75269135200255998213799440579314048748e-20, 1.80145997849298736577434319517530707823276e-17, 3.7857566770340715303362942496173716511270563e-15, 5.345701949583852749890272069932148421592087913e-13, 5.0758492046548648455184766647484300107841316368e-11, 3.24247137119466921360376297163e-9, 1.393963803286682065223614149082e-7, 4.0340174581713377489896597442139e-6, 0.0000785979191609393550490541030929607, 0.00103116719674110052562717833246923792, 0.00911038641391865192097927389222826014, 0.05420879725072447383019679558816797562, 0.21724845976690813358604015437093539943, 0.58643660784167819480484352122397232119, 1.06630713480314650662105882769712253778, 1.30604072496980040724152445648810287257, 1.07760119468127585521433832442536611059, 0.59896040021006690721805260505301077958, 0.22427815559530380221203106537519848059, 0.05657615505472351759976222402020130079, 0.00961490767587997413938676453951562676, 0.00110085154057173804647851474605128013, 0.00008491614279137725734839860062111487, 4.413009692338773232690564616432e-6, 1.5451380940860410968400201623253e-7, 3.64495103972488164666696595773e-9, 5.7931108430468423404451465604542811977175739908e-11, 6.203418863482573937721895125339844350947145393e-13, 4.4756134446645036547067220115201585531535349e-15, 2.17559980776028137303282373138781376021518e-17, 7.1254609790098743409316924500668338253e-20, 1.572377230719546254592420882163869861e-22, 2.337827538601202494902976010341833e-25, 2.341974065521698902719872276775e-28, 1.5807652075143240364115193304410441314212271439e-31, 7.189024774183437394833612988860076830406018e-35, 2.202883044042760645332972010381931990395e-38, 4.54813302829351735857913582316268196e-42, 6.3269797618201440506346214132362e-46, 5.9303799066034204018425078239734730784971765953e-50, 3.745350810257675144944090827410030688030746e-54, 1.59377665634315822470076472574748807201e-58, 4.56970725935639758081602749431481e-63, 8.82828163287909972371836302984939471528855297987e-68, 1.1491897005088140439519035363608695430641521e-72, 1.00794266308774734170868449012325327077e-77, 5.95674830356749975153967351883575e-83}, {1.1043750542076698308583981944372796697948289883e-31, 1.758298267249714926368771676406e-28, 1.83282915665787520416099336259338e-25, 1.272282578649652327364267190744521392e-22, 5.91275268952465317874824450142091492269e-20, 1.84404019094439769397451683360217681914181e-17, 3.8643371976013933612467301795871402736987304e-15, 5.445422420083521647361794591589473363820837637e-13, 5.16239941799602662907472400496738715395992310594e-11, 3.2936658642997944456300829047e-9, 1.4145503310438560021986593784135e-7, 4.09019740600668495540890129672271e-6, 0.00007963700131701771263522357033367955, 0.0010441795819479010209089323483891573, 0.00922063348967827749069895416420847336, 0.05484035827264440336602680170808768567, 0.21969351601701302385356904846265924125, 0.5928312257154483812615025254530611862, 1.07760119468127585521433832442536611059, 1.31950791077289425937400197122964013303, 1.08844035066611797503805380561755047331, 0.60484777639012605472543673132748401196, 0.22643582087983341061928281838538312539, 0.0571096382584185048439117239761446169, 0.00970388485448550142007983431294052313, 0.00111086102060592448206895624952885705, 0.00008567555762655166206157965575423203, 4.45186460357299631187873617645047e-6, 1.5585435276980104610806943764287e-7, 3.6761367986694097425762469771e-9, 5.8420264856421645773594243366242357433036497737e-11, 6.255147776213914638477231497290803346460531198e-13, 4.5124936670937187698464276098891667978043732e-15, 2.19332580865469740572240491846091154478093e-17, 7.18289500616431351677404997724608574431e-20, 1.584921772157684716475450627308573998e-22, 2.35629700877202847912555822372095e-25, 2.360303814277991354023161919334e-28, 1.5930268988347790697788014413473761907999843653e-31, 7.244312196581836582987561672448618205649283e-35, 2.219685607705250350367799385120218011156e-38, 4.58255136630996179321466093291323068e-42, 6.3744981771647037480586968331676e-46, 5.9745964597121200382757993352700748268101331491e-50, 3.77308097293860390041153630476758188542778e-54, 1.60549749686140746635417410423040520634e-58, 4.603095885845478195880037630096301e-63, 8.89238293663572645673961491770705777041377116644e-68, 1.1574836063853314810166076910494467333119377e-72, 1.01517487302105795527959099799438093224e-77}, {5.033963492053053739523310320546785741176088e-35, 1.1894291501740741406933806616507468663059068954e-31, 1.840011782120162829546260048066e-28, 1.89554800979011767506172416247425e-25, 1.307354938129111515857585337533266896e-22, 6.05099464817692007424842781467532861098e-20, 1.88184561393398371052560763733345497798644e-17, 3.9354385912589988157768309306061559139915734e-15, 5.536888236581182759081710282752378181655471301e-13, 5.24259467563023429577270341688992604807134202882e-11, 3.34147131456215180127688462849e-9, 1.433891171101990420235185712829e-7, 4.14323349987141682172705722204989e-6, 0.00008062176410218090529632237325453398, 0.00105655095994240212701831974368765535, 0.00932572408095004223558837736143486639, 0.05544368751703172538036338408595128123, 0.22203351165063238144496832468558059643, 0.59896040021006690721805260505301077958, 1.08844035066611797503805380561755047331, 1.33244673837449656566795995691173953301, 1.09886388978197599514784812236496962568, 0.61051386841145607148088853948790831231, 0.22851378371214501171529693634422948054, 0.0576237099686977360114570216818142891, 0.00978966652874027353923064920721571601, 0.00112051506390706895587680245564670048, 0.00008640826726757865159452672854112152, 4.48936456224729368672476269897305e-6, 1.571484824710359584296240624652e-7, 3.70624938008464257241312005909e-9, 5.88926748387334857407435062852593321165507784789e-11, 6.305113376271683494810600834468014579615055776e-13, 4.5481212380498780517133733853679524899416902e-15, 2.21045150609396019805977003766831496141699e-17, 7.23838858223157108865789913541482323118e-20, 1.597043272273109096530811963521528675e-22, 2.374144504140309741052386939136721e-25, 2.378016913357173334274029730174e-28, 1.6048763508528275031543964436348259148231976515e-31, 7.29774148036140543382379576377557682919114e-35, 2.235923494302903485338236359647935221263e-38, 4.6158128104736855734405005521492516e-42, 6.4204187336059852233391148507063e-46, 6.0173253069307709882673306056990040827782173511e-50, 3.7998774225786338994639750663979967969359e-54, 1.61682332295409268210368966046965094826e-58, 4.635358086587571252691435343292761e-63, 8.95431917810819296228991068980018848212780666096e-68, 1.1654970298237004267026313997948226253706014e-72}, {1.545796560200630522919852481976913765567e-38, 5.420426091241200426021909858030705742294702e-35, 1.2444230373234472376076444525109750781587294166e-31, 1.902544467617033049568924343789e-28, 1.947359477139676499162141616693358e-25, 1.337617601212996184878444345270720627e-22, 6.17364689837556641989297300634820696015e-20, 1.91603538136817852732201968430570194174498e-17, 4.0006331648725157189608114599500608847812124e-15, 5.621624650982579275708003773355841723076922878e-13, 5.31748029516206417580742620126918908692113664999e-11, 3.38638967952463901675923516033e-9, 1.4521542155056052431268497491038e-7, 4.19351515088330573478095359075748e-6, 0.00008155844891887712287292919693600917, 0.00106835025967737937772086297811475409, 0.0094261814257641033708616986904309436, 0.05602150916776841757042496831826697807, 0.22427815559530380221203106537519848059, 0.60484777639012605472543673132748401196, 1.09886388978197599514784812236496962568, 1.34490167754521857230888171629857606668, 1.10890605842861037814726875801669641561, 0.61597659813961917260887566653051663716, 0.23051841069765271782724968404154198185, 0.05811990401970111773050464734975407195, 0.00987250309708503316484262710633188845, 0.00112984134935251519877226395974508614, 0.00008711634209265890301053353814446261, 4.52561430335479348360713898838217e-6, 1.5839977999821075475402485111294e-7, 3.73537153635786358834300362341e-9, 5.93496298489902607436109322786408240547551977765e-11, 6.353451757634617074174901725101239820883089039e-13, 4.582592968388345916799224745524763451805904e-15, 2.22702337704832973584505748025721631100132e-17, 7.29209226097891380225098041183633374285e-20, 1.608774632057344158508309592318819323e-22, 2.391418522692198456794296610271886e-25, 2.395161577351487955084087477435e-28, 1.6163458874666595130314355501982532228369115947e-31, 7.349458747770418048344052101911884539742986e-35, 2.251641240629751095179190889058430420303e-38, 4.64800887720580487302825268764072456e-42, 6.464868204579221180824887943522e-46, 6.0586848292446365251100859785280583533435534561e-50, 3.825814673291366357671824454370075908532797e-54, 1.62778574860097768559477543354660283122e-58, 4.666584265517291645709162121018591e-63, 9.01426459757035080949555476651646604645614139982e-68}, {3.19780657457049137517779538618839705e-42, 1.664124689736799740561975051854895191535e-38, 5.669869570577743855380717189769138887708382e-35, 1.2864485788876552944121624685204024448874256385e-31, 1.954142962806776758333384074443e-28, 1.992024926890877244427812380799448e-25, 1.364448566328642844410895966018104312e-22, 6.28451108505156592333227724873319616445e-20, 1.94737366335682856321080252869541389598573e-17, 4.0610187575180167135514877168356682261973264e-15, 5.700745183090902515317176601796391228163453626e-13, 5.38784707906527649713685317109660233140129745743e-11, 3.42881187698180160010835948087e-9, 1.4694733822828666513635202933267e-7, 4.24135919946950314220095029086656e-6, 0.00008245221853023239032410196000384135, 0.00107963528357556570567306559073072882, 0.00952244928294341488347636499266932278, 0.05657615505472351759976222402020130079, 0.22643582087983341061928281838538312539, 0.61051386841145607148088853948790831231, 1.10890605842861037814726875801669641561, 1.3569116348286069385805970076656867958, 1.11859690228069193210128646871291976656, 0.62125172153401178831298507027544365671, 0.23245530725617402830403527571033510326, 0.0585995722073277425344088175001230403, 0.00995261537670437377141725161300948704, 0.00113886429377191383254815090667901434, 0.00008780160864488968875439007500683725, 4.56070621900917479564009625689308e-6, 1.5961140407511527376738065687682e-7, 3.76357622868806533820508579898e-9, 5.97922681149178153123452490936328749081375127942e-11, 6.400282813766304155282234265306448653769403862e-13, 4.6159941052543355324382871908719759518644816e-15, 2.24308232737372203192582784257294590929799e-17, 7.34413848519942808257521236176612024409e-20, 1.620144780630526341588386400324999233e-22, 2.408161687278430489965118849178715e-25, 2.411780160285364478087138935301e-28, 1.6274638907066926527425491834443347820942019796e-31, 7.3995922456456628523121810910458053912605e-35, 2.266877918849361846887947865917890042066e-38, 4.67921982179470673018334232787615817e-42, 6.5079577215589721982762225878427e-46, 6.0987787634930647483780545385183087504393604735e-50, 3.850957999011015415847418645008598142736752e-54, 1.6384124584092261413355898445497137685e-58, 4.696853565539222029108570877516428e-63}, {4.4567397851703514362497500346929e-46, 3.44194191336542213467111843867279075e-42, 1.740376981127537168919356157455307452805e-38, 5.860238384654555050085252730183680098806107e-35, 1.3210880782353028471093064082641350565811611741e-31, 1.998585803593827515204361030265e-28, 2.031598053856533754076304068697857e-25, 1.388688070124280458677030550722738152e-22, 6.38609080297397016720986260232802523176e-20, 1.97639334050456431491341185817138840876087e-17, 4.1173956802872034704570086551954787470382336e-15, 5.775090915987153431657891202500505903987426031e-13, 5.45430992782326199373425963535470831649659406406e-11, 3.46904926115431910334954451525e-9, 1.4859574944044210874592393813779e-7, 4.28702747858345974134251507053784e-6, 0.00008330739992410116515043696758258364, 0.00109045505038102771000617151094056426, 0.00961490767587997413938676453951562676, 0.0571096382584185048439117239761446169, 0.22851378371214501171529693634422948054, 0.61597659813961917260887566653051663716, 1.11859690228069193210128646871291976656, 1.36851085783726327994534150732482429292, 1.12796293671401141029944458423433771487, 0.62635316993712940432450311747605067616, 0.23432943658796964842033541270992062764, 0.05906391261146113903367591762524738738, 0.01003019919788069118719002399623210663, 0.00114760555874332770379133032279469952, 0.00008846568758168853296553061081181045, 4.59472228470962903447392173617586e-6, 1.6078615686263645220092993704806e-7, 3.79092816594312708859193846681e-9, 6.02215987981266446624788965697157065583795375092e-11, 6.445712803485950222728220489282088143948084512e-13, 4.6484001704776023723464050785479795177036226e-15, 2.2586645807154669505336029997456776544246e-17, 7.39464448635564636089359963875498706538e-20, 1.631179313208323134464382979290804684e-22, 2.424411692128886296820370971612917e-25, 2.427910102422885967656078205623e-28, 1.638255439212179705795945949755340990296965495e-31, 7.448255247644711831195738266724312185963591e-35, 2.28166802566948552343525958989959922881e-38, 4.7095164744300246249006988448198187e-42, 6.5497853290528314387092537833391e-46, 6.1376985984188211326175134870736958886455570798e-50, 3.875364947693259786845043077292401354921862e-54, 1.64872785243711773676385325215515475402e-58}, {4.184603458801688003221178852423883813235116721e-50, 4.7961544101440325103354623533811e-46, 3.59903060233657105297408862148642382e-42, 1.79849850387170906772246120771713494446e-38, 6.016988213201489399336663900770550668687112e-35, 1.350898671903242170400846145380643521960704629e-31, 2.037935121056597978221401573683e-28, 2.067330250347243559135865146148441e-25, 1.410888954654755890144160319571040772e-22, 6.48012995066586236062151771704271297139e-20, 2.00348237892287177235200408099044624604874e-17, 4.1703675950156362572662055393129599615959755e-15, 5.845314905562667391241794983176866436452573172e-13, 5.51735790474734712364853221736578573345059277679e-11, 3.50735451852332135461029129203e-9, 1.5016963864838188719531117433833e-7, 4.33073926754260052310775715871242e-6, 0.00008412766114477947129372025948049981, 0.00110085154057173804647851474605128013, 0.00970388485448550142007983431294052313, 0.0576237099686977360114570216818142891, 0.23051841069765271782724968404154198185, 0.62125172153401178831298507027544365671, 1.12796293671401141029944458423433771487, 1.37972966146121483239006346421601769286, 1.13702768743770804043615922035936436923, 0.63129332600859680580193994603139449158, 0.23614521599457929830463925309767310182, 0.05951399253934197290891914793749740155, 0.01010542912549594192919669421728135019, 0.00115608446090325962679935313569792104, 0.00008911002437622622938657115373284919, 4.62773561632231131076323335110221e-6, 1.6192653741623973908514976870973e-7, 3.81748504614113572562396008318e-9, 6.06385214816469724214902143212255227979681305719e-11, 6.489836417287099422199798563441294505750020893e-13, 4.679878439850478812390616586334443426841481e-15, 2.27380239324075908373223405542705480657966e-17, 7.44371461449689370705461599849073141398e-20, 1.641901003408208476022665333349489051e-22, 2.44020206251620635215893016329447e-25, 2.443584689794627922420945689327e-28, 1.6487428201919486898759019204636807332071960296e-31, 7.495548380486984080997022930828224579793088e-35, 2.296042194799804261794637066825576656165e-38, 4.73896171088517453199751284546295981e-42, 6.5904380306179092731406730807777e-46, 6.1755254929365742120094250806993503168452667451e-50, 3.899086553317044281672321754116626932350947e-54}, {2.647093056701408957336549913959520322886111e-54, 4.5025717724761786986506192103334789533859131268e-50, 5.0142457654616822228504261653181e-46, 3.71862810256453274395796886788515203e-42, 1.846309124999847515651831051866220777897e-38, 6.151777499173792559616362266011832785561549e-35, 1.3772753909401755392520078725449083708411332504e-31, 2.073446731542908051973926654878e-28, 2.100044249302050383722040295529674e-25, 1.43143593801527792753228907087485919e-22, 6.56789676120315343581302050854845302815e-20, 2.028933052380677177667745857114490716275e-17, 4.2204025997854957613223944940084097940868784e-15, 5.91193588125624458875198809777148994557402384e-13, 5.57738742710290217791021900885632777376504152248e-11, 3.54393601565700543608625893055e-9, 1.5167652268422826554090565729604e-7, 4.37268034207801765714161615725978e-6, 0.00008491614279137725734839860062111487, 0.00111086102060592448206895624952885705, 0.00978966652874027353923064920721571601, 0.05811990401970111773050464734975407195, 0.23245530725617402830403527571033510326, 0.62635316993712940432450311747605067616, 1.13702768743770804043615922035936436923, 1.3905950167030171574409162502499781305, 1.14581213053610393185608797978397178017, 0.63608324887251901971003483416841743797, 0.23790659558133334324824073633042351766, 0.0599507672834717670682748694719500717, 0.01017846150169139886459066100961001938, 0.00116431830728540678459536883109436272, 0.00008973591439331076122218956006453638, 4.65981174077810951380707731583564e-6, 1.6303478527695863215609558189787e-7, 3.84329856791086765132762264729e-9, 6.10438420331918819942254460149696257275657596389e-11, 6.53273845798236997603960776424399382995555858e-13, 4.7104891453735296115565629954383238999249378e-15, 2.28852463410418312241988709123663135359353e-17, 7.49144222924703866835702823466356415108e-20, 1.652330218795050723593121583793781685e-22, 2.455562770606799205188951374758926e-25, 2.458833669637862752951560054653e-28, 1.6589459440815859866824181665084178946280633399e-31, 7.541561507328117645589126820069341542033649e-35, 2.310027773570061389317139629551709067789e-38, 4.76761164242012777307851859400253149e-42, 6.6299934437905465584766919359224e-46, 6.2123318273433800609975881380200672290925210221e-50}, {1.12815098321725813165889038221575515732e-58, 2.847811573102062816782229652616653961967865e-54, 4.7066164879197191220730735921547851475361000754e-50, 5.1801046274990066107267300263038e-46, 3.8169176483456189648895638009945996e-42, 1.887389707275083927009984334611485817627e-38, 6.270964465698601699300168909667594027598129e-35, 1.4010673867462065281541499883041309321119449394e-31, 2.10594573520692529217962577001e-28, 2.130312110989420317002019092300114e-25, 1.450608529172674866312907378021684358e-22, 6.65034560551332080985113464826110620241e-20, 2.05297173131147306860453605419219356916187e-17, 4.2678720595024223194052826324123426536888012e-15, 5.97537380883687004878274994442110182059652894e-13, 5.63472502515632075887034848555491029610035930481e-11, 3.57896793768299405100365042133e-9, 1.5312276527727116048937425671755e-7, 4.413009692338773232690564616432e-6, 0.00008567555762655166206157965575423203, 0.00112051506390706895587680245564670048, 0.00987250309708503316484262710633188845, 0.0585995722073277425344088175001230403, 0.23432943658796964842033541270992062764, 0.63129332600859680580193994603139449158, 1.14581213053610393185608797978397178017, 1.40113103235340269841563384987468316236, 1.15433505370357618243005835090087546718, 0.64073285937420338282707556430874062623, 0.23961712310459636912206002014762149013, 0.06037509558716024726791574606448970686, 0.01024943695474287167088126555186000439, 0.00117232267175378605005659025322986675, 0.00009034452354956501363360378927376558, 4.691009642295337633961113249131e-6, 1.6411291633435299389404746678977e-7, 3.86841526197082518496514243108e-9, 6.14382856352829220652013282815936909867282589406e-11, 6.574495220123160998096882851570343440326951081e-13, 4.7402864612970142445301339162878389768438392e-15, 2.30285726119951337023615027593258950928564e-17, 7.53791124868190132750599521519775826741e-20, 1.662485261049533682507073935861618064e-22, 2.470520739332787743431820674952068e-25, 2.473683753689479723102716078197e-28, 1.668882683492565628703636319018637071162114667e-31, 7.58637526666154952508242390363858239576035e-35, 2.323649293916416476080161061298576726182e-38, 4.79551658739336387794948483332255636e-42, 6.6685211510271509668000968168736e-46}, {3.239313935313370132121125764276356e-63, 1.21352758478089195260075580746511221526e-58, 2.976458305026678022822207109406925781303781e-54, 4.8616323392595418874008776966982938996403834298e-50, 5.3162936273950185643089323753015e-46, 3.90130892514183849651950621053210798e-42, 1.923692660467192962988806384455561475461e-38, 6.378417773878165613635170418151477228732085e-35, 1.4228322582614397154911895409468499181440830199e-31, 2.136005428664551337157419898655e-28, 2.158549098558746399231643440509487e-25, 1.468616859280554082693115531397843086e-22, 6.72821487277505986075279671486862381806e-20, 2.07577780685170158525564599207903668771846e-17, 4.3130762985241505123574607638017062112956531e-15, 6.035974248271670877570478872330357652147295055e-13, 5.68964340235277947134094259591805767662277062358e-11, 3.61259763147794592424664226309e-9, 1.5451380940860410968400201623253e-7, 4.45186460357299631187873617645047e-6, 0.00008640826726757865159452672854112152, 0.00112984134935251519877226395974508614, 0.00995261537670437377141725161300948704, 0.05906391261146113903367591762524738738, 0.23614521599457929830463925309767310182, 0.63608324887251901971003483416841743797, 1.15433505370357618243005835090087546718, 1.41135935221399607642332439878463972042, 1.16261335512152383580394482495131451759, 0.64525109369527692422685389662687866906, 0.2412799978153727612609972538819906222, 0.06078775249443307955696024402854979253, 0.01031848248397690380530723744603178837, 0.00118011162468015686346687604291582245, 0.00009093690547171376923944408177864393, 4.72138263075370804853131363714017e-6, 1.6516275257270626193186779531174e-7, 3.89287718028953778357412862088e-9, 6.18225075771274265277530590182217662263090225483e-11, 6.615175631642665737879106864661678519974434087e-13, 4.7693193196271423484579469727960381676600103e-15, 2.31682371437245819320620007572658551142956e-17, 7.58319742870537221904203887054147956189e-20, 1.672382646788893985442139850204025512e-22, 2.485100258139186317072326034514809e-25, 2.488159033257853187633583186996e-28, 1.6785691526266725655967089757546272025116040125e-31, 7.630062340420817008937192097196777340830625e-35, 2.336928860350422397285061160609278904187e-38, 4.82272187135687327840428765272543906e-42}, {6.26658353201572181031866127284392980849459267385e-68, 3.484015156546436611369088228025099e-63, 1.26818547668385591985044214729331438989e-58, 3.074097753429037969881933711573062641601244e-54, 4.9888116789281200229246986079706933860555621326e-50, 5.4331423142241058266272673659593e-46, 3.97584108177197803076035011385584469e-42, 1.956405519329785133614599473504673801714e-38, 6.476676573389666211765986914864757732113896e-35, 1.4429571968821803394605886043456193498407195833e-31, 2.164041660823739274923907510206e-28, 2.185067131873782829355095090523009e-25, 1.485623350091267574492640971498060084e-22, 6.80208911948416456974248900708889843476e-20, 2.09749620330046940469546374478873649746901e-17, 4.3562621819990321404156457827720155065975269e-15, 6.094025522573564469099516194327237536027905187e-13, 5.74237305206243130017380102758756653191500852453e-11, 3.64495103972488164666696595773e-9, 1.5585435276980104610806943764287e-7, 4.48936456224729368672476269897305e-6, 0.00008711634209265890301053353814446261, 0.00113886429377191383254815090667901434, 0.01003019919788069118719002399623210663, 0.05951399253934197290891914793749740155, 0.23790659558133334324824073633042351766, 0.64073285937420338282707556430874062623, 1.16261335512152383580394482495131451759, 1.42129948513082202223937060974020895345, 1.17066229253912218807836958129738865947, 0.64964603164236622664501203460020829572, 0.24289811548459681530847918430788618156, 0.06118944010289860014939711879740023209, 0.01038571320483920746380086619041095613, 0.00118769792516177999943604804301015563, 0.00009151401585135423946857112893806787, 4.750979067811716240763265973999e-6, 1.6618594692904395553860877738672e-7, 3.91672247161506083190379676781e-9, 6.21971022609593302346479036974349097216038818749e-11, 6.654842205967148255100540429597995328314694209e-13, 4.7976320897983882048924637468378358992300483e-15, 2.33044524293333824083454726356702952933196e-17, 7.62736942803326381804776301151044062613e-20, 1.68203734120066367594914002685073697e-22, 2.499323328696416229513825458805287e-25, 2.502281324212521664288249795466e-28, 1.6880199394136831916296625494469776976696574878e-31, 7.672688507107845810634265958116354393610861e-35, 2.349886472043136190182146958510406711248e-38}, {8.167786303474627861853113361253769337098112e-73, 6.7391660664065770481225835134095112144042267019e-68, 3.640503787707798267844666871546996e-63, 1.30963108456713141335477973265090541667e-58, 3.154140250280811894152401167447434488014345e-54, 5.0978559621291104973593286601285956200078577021e-50, 5.5362804966851082705900208717332e-46, 4.04297017244764616656872848512264434e-42, 1.986307385001326054243044170979434353555e-38, 6.567503076729802733580901765623381202764398e-35, 1.4617228728552500220372626459115603196301851924e-31, 2.190366552585365473089509324934e-28, 2.210107104610941699899551175285379e-25, 1.501756466826160877373830387219833557e-22, 6.8724401388006010589839091844765577808e-20, 2.11824593388624796090511209261209188473009e-17, 4.3976354964682299055605643944772827484002376e-15, 6.149771122389378534497231426798640736570836992e-13, 5.7931108430468423404451465604542811977175739908e-11, 3.6761367986694097425762469771e-9, 1.571484824710359584296240624652e-7, 4.52561430335479348360713898838217e-6, 0.00008780160864488968875439007500683725, 0.00114760555874332770379133032279469952, 0.01010542912549594192919669421728135019, 0.0599507672834717670682748694719500717, 0.23961712310459636912206002014762149013, 0.64525109369527692422685389662687866906, 1.17066229253912218807836958129738865947, 1.43096908110525550104522441314311690497, 1.17849569225105243645163586408364568332, 0.6539250044940133002235582994929072132, 0.24447410630218677922769085731652658695, 0.06158079662116417558256807204372047026, 0.01045123381921654374042699295587081501, 0.00119509318296839391315941247438949982, 0.00009207672453572703219652889302235533, 4.77984297823385705075371200046272e-6, 1.6718400421007021187538994756858e-7, 3.93998586546699730913576215224e-9, 6.25626107711764346821702056222853658545781860899e-11, 6.693551841687297074515542349763578915320188135e-13, 4.825265149172278562769336455260003559538994e-15, 2.3437411803989267396293358585854057695824e-17, 7.67048970107613360320763692225375183703e-20, 1.691462953817432446033741005069104335e-22, 2.513209954449034148294064423840757e-25, 2.516070455795335894074785588408e-28, 1.6972482997655343249381706789424955796440234622e-31, 7.714313522715673875671248265368600612895657e-35}, {7.1726068925064904047087084480582892372e-78, 8.782767985408293945689613458055031185147847e-73, 7.04108080160996442451668478663903985966808492356e-68, 3.759061273077754815312263395532078e-63, 1.34358151403946087692773814979967907478e-58, 3.222724413416035563244520722919053538820505e-54, 5.1940518819800600166245658112765644318356477312e-50, 5.6291305934619391880669349938452e-46, 4.10430695387296149226107032970293123e-42, 2.013938713160978218950780995617116211803e-38, 6.652173951991795798164959739142014091784313e-35, 1.479339804023157205582743016612403124493866148e-31, 2.215220968312902940525174686553e-28, 2.233859389385428139052067243088001e-25, 1.517119802215791129390166285002496461e-22, 6.93965502565586745578153099605485768506e-20, 2.13812612090393276933399271324765301707726e-17, 4.4373698863243772770768607115514644774858938e-15, 6.203418863482573937721895125339844350947145393e-13, 5.8420264856421645773594243366242357433036497737e-11, 3.70624938008464257241312005909e-9, 1.5839977999821075475402485111294e-7, 4.56070621900917479564009625689308e-6, 0.00008846568758168853296553061081181045, 0.00115608446090325962679935313569792104, 0.01017846150169139886459066100961001938, 0.06037509558716024726791574606448970686, 0.2412799978153727612609972538819906222, 0.64964603164236622664501203460020829572, 1.17849569225105243645163586408364568332, 1.44038416377868346623289448643829112081, 1.18612612552414757488133692706387293109, 0.65809468622015453525552700290078849978, 0.24601036697257929196264731506163339564, 0.06196240404479102038070626927862651001, 0.01051513986189255923236911330942834143, 0.0012023079958327931165604226963012529, 0.00009262582577545042170394774054917642, 4.80801456783727228418792530692931e-6, 1.6815829880553767940454312228105e-7, 3.9626990817792271984569557349e-9, 6.29195272770364744537825739383765484047002044701e-11, 6.73135649859902245025049065210677631653953502e-13, 4.852255365055604411222474273080655110787595e-15, 2.35672917649261149446368240899570710917054e-17, 7.71261525150890647554410560816500993849e-20, 1.700671903661200035583363878269117405e-22, 2.526778384745399535791765979853774e-25, 2.529544514019535740609287727655e-28, 1.7062663212186175053297061605535591632720462403e-31}, {4.24377047625331788481489877725397e-83, 7.711855034795797856783316407251853049e-78, 9.175280804820150555395373297110718715813571e-73, 7.26962536382480146934462874335608536554518394182e-68, 3.85610840536860385992539065746979e-63, 1.37265366167932457732930787544688895842e-58, 3.283194990516663650929909244337112180919947e-54, 5.2806125862634490729567750468851607945537324862e-50, 5.7139364373540216538249351404343e-46, 4.16096833614496281206528641867338391e-42, 2.039690847927826411858927621936072469233e-38, 6.731646192343169062320946261652569502087777e-35, 1.4959703360162579924922360882221981587301251208e-31, 2.238795113810555127114771585076e-28, 2.256477376835017432896645086029484e-25, 1.5317982810383851750599239931430629e-22, 7.0040559114319598397739225634771389038e-20, 2.1572203375957256113551219943500911946198e-17, 4.4756134446645036547067220115201585531535349e-15, 6.255147776213914638477231497290803346460531198e-13, 5.88926748387334857407435062852593321165507784789e-11, 3.73537153635786358834300362341e-9, 1.5961140407511527376738065687682e-7, 4.59472228470962903447392173617586e-6, 0.00008911002437622622938657115373284919, 0.00116431830728540678459536883109436272, 0.01024943695474287167088126555186000439, 0.06078775249443307955696024402854979253, 0.24289811548459681530847918430788618156, 0.6539250044940133002235582994929072132, 1.18612612552414757488133692706387293109, 1.44955932735539106294122800176314818143, 1.19356505840935286344799774082394085541, 0.66216117107907947305422862132511635547, 0.24750908804990161648655289032730970288, 0.06233479469848012202362451274759919837, 0.01057751876326351674319691119621005431, 0.00120935206650986527792046947682655097, 0.00009316204696071519616193945580618446, 4.83553066490190667246698195119149e-6, 1.6911008977775622902750727533318e-7, 3.98489117969164604768814600512e-9, 6.3268304481371731196038403487749354090622934684e-11, 6.768303772702515654175967411853460649628714118e-13, 4.8786365044519621276481895290838210263828113e-15, 2.36942539425647645660760250597750220072092e-17, 7.75379827218910682730811426589168146189e-20, 1.709675559412241231821202965389303607e-22, 2.540045321950526536589747398347468e-25, 2.542720048073071887290144976241e-28}, {1.69173262021835676963614267730868230019801572843e-88, 4.56237819371433988723543672561462e-83, 8.055720308893307527734303837835585486e-78, 9.47217328114521305217712222746392409853937e-73, 7.45657564058486868836065195196416833672328717395e-68, 3.939161216075136400195497443370577e-63, 1.39827324578112398763227571060361675137e-58, 3.337584480412958095678899133806489151721996e-54, 5.3596441370987681788601600575872747573609899512e-50, 5.7922533596483125316038642147576e-46, 4.21376271112665311692477997054496941e-42, 2.063856984584670794366187304466207107533e-38, 6.806657351166388828076640561042815631130262e-35, 1.5117425824662756741243270035232383136810344572e-31, 2.261242132710938132425977623652e-28, 2.278086719218450875702921759919703e-25, 1.545862520629478603328516687908928447e-22, 7.06591418742253791522082331344566729521e-20, 2.17559980776028137303282373138781376021518e-17, 4.5124936670937187698464276098891667978043732e-15, 6.305113376271683494810600834468014579615055776e-13, 5.93496298489902607436109322786408240547551977765e-11, 3.76357622868806533820508579898e-9, 1.6078615686263645220092993704806e-7, 4.62773561632231131076323335110221e-6, 0.00008973591439331076122218956006453638, 0.00117232267175378605005659025322986675, 0.01031848248397690380530723744603178837, 0.06118944010289860014939711879740023209, 0.24447410630218677922769085731652658695, 0.65809468622015453525552700290078849978, 1.19356505840935286344799774082394085541, 1.45850790433421931496873950587629838439, 1.20082297964433745323760222798852713271, 0.666130039978643643922590697698243141, 0.24897227734224829551149270644322553189, 0.06269845684150638714447284349527682627, 0.01063845076022403797309861280782521759, 0.0012162343031210373039166851513826926, 0.00009368605610922385924470764043983568, 4.86242509841094728129546926024531e-6, 1.7004053378687334593856054619427e-7, 4.0065888561843173908327990692e-9, 6.36093582834996297480482589543315851296087831002e-11, 6.804437388027170048618269483965577266563543124e-13, 4.9044395843632042801944556272757780666338252e-15, 2.38184467847964187950291117276190154699213e-17, 7.79408669168586512248494846094253683001e-20, 1.718484359065456676119911095045182792e-22, 2.55302609817064776790089709901149e-25}, {4.54379858833684624670585587977626119014237e-94, 1.8185750178580187085246840127329750723484859013e-88, 4.76537307266640198230604823359208e-83, 8.31562221285223949913632121060772752e-78, 9.71487312905981476087897171195334785375292e-73, 7.6164755115976383237669159117238600868797482168e-68, 4.012314174057564279059425329395896e-63, 1.42130649437012563557942596679003486951e-58, 3.387224775329544513933368291198892087031918e-54, 5.4326059091334958438859366749758072399048243891e-50, 5.8652066237766449390477638361013e-46, 4.26329543773739867205015693419096976e-42, 2.086662963760271923242287728406404268969e-38, 6.877789103139860331010342219054934881475312e-35, 1.5267596245312752245291903652767936326257317408e-31, 2.282687386073330277129132279523e-28, 2.298791823834920173909067108490352e-25, 1.559371971849750669060052199164234908e-22, 7.1254609790098743409316924500668338253e-20, 2.19332580865469740572240491846091154478093e-17, 4.5481212380498780517133733853679524899416902e-15, 6.353451757634617074174901725101239820883089039e-13, 5.97922681149178153123452490936328749081375127942e-11, 3.79092816594312708859193846681e-9, 1.6192653741623973908514976870973e-7, 4.65981174077810951380707731583564e-6, 0.00009034452354956501363360378927376558, 0.00118011162468015686346687604291582245, 0.01038571320483920746380086619041095613, 0.06158079662116417558256807204372047026, 0.24601036697257929196264731506163339564, 0.66216117107907947305422862132511635547, 1.20082297964433745323760222798852713271, 1.46724210912152827819557064172092076957, 1.20790951040530099392730694389039610979, 0.67000641751209154411848048664377778923, 0.2504017800496786185608960807395773603, 0.0630538394943217733754097110219988043, 0.01069800968079746082327109742096386951, 0.00122296290560151999866539055162994047, 0.00009419846831664811277306173090857986, 4.88872902381420183543217832380815e-6, 1.7095069621930986718786217286978e-7, 4.02781670309443725255101662148e-9, 6.39430717905437247978265726886056258332966133146e-11, 6.839797619531549011398213814052109027943117961e-13, 4.929693172855248923816516520945492199738163e-15, 2.39400070038465971008356312877580994038629e-17, 7.83352464355023769200182663001559702384e-20, 1.727107912625503694062181037209465562e-22}, {8.22273410447443234587443889052872384e-100, 4.88405993282901675594570437520881313893289e-94, 1.89932488946174539700160666483417779839814994331e-88, 4.91869272718979742401199856693441e-83, 8.5279503792015998892303098188013202257e-78, 9.922341510683137034094440460443338167054884e-73, 7.75724738687559882775095730105270100371673854706e-68, 4.078054630966162324967507747689704e-63, 1.44232092895600017818315545107594467166e-58, 3.433038540953753737399519808374506736616654e-54, 5.5005533710465037632647804573568703809908671446e-50, 5.9336385175043474005531104413643e-46, 4.31003257724753996128930474838901536e-42, 2.108286796275884840838619268853112736579e-38, 6.945509181913766722777111043425310774998678e-35, 1.5411057878849270105376482870730901735203863235e-31, 2.303234968659682321153484785467e-28, 2.318680528120497351750532444413861e-25, 1.572377230719546254592420882163869861e-22, 7.18289500616431351677404997724608574431e-20, 2.21045150609396019805977003766831496141699e-17, 4.582592968388345916799224745524763451805904e-15, 6.400282813766304155282234265306448653769403862e-13, 6.02215987981266446624788965697157065583795375092e-11, 3.81748504614113572562396008318e-9, 1.6303478527695863215609558189787e-7, 4.691009642295337633961113249131e-6, 0.00009093690547171376923944408177864393, 0.00118769792516177999943604804301015563, 0.01045123381921654374042699295587081501, 0.06196240404479102038070626927862651001, 0.24750908804990161648655289032730970288, 0.666130039978643643922590697698243141, 1.20790951040530099392730694389039610979, 1.47577316159455206927691669563224410655, 1.21483349893204356307178072521447512167, 0.67379502120850437983685789268831953702, 0.25179929617228407909453742917020770698, 0.06340135661382339952574114361742755138, 0.01075626362315700678331699495773966504, 0.00122954544052393496334378553752095214, 0.00009469985133959532650529364340910159, 4.91447120493206795844757349753126e-6, 1.7184156081521876034439946600012e-7, 4.0485974293888345715567989915e-9, 6.4269798785093141530162430074456190563914224959e-11, 6.874421658529015336383140566687226316300861336e-13, 4.9544236490913923794152949917424143530153653e-15, 2.40590608253841266641594039854744995135434e-17, 7.87215287126707559113268339447581872838e-20}, {1.00259460923138700235925228889e-105, 8.83776994035204916178869160174527108e-100, 5.10050944511071239729428872030169534128867e-94, 1.96027309287651872823711007854412073046020201499e-88, 5.04387296375798985372592284939629e-83, 8.7093598502341556738488171451296525733e-78, 1.0104906404397428501706547056836187613400051e-72, 7.88370349425079664006166017161442810254729907244e-68, 4.138011919572061804411127687364374e-63, 1.46170960292053143039935870293815197531e-58, 3.47569287176548900840322463942479783553706e-54, 5.5642762674109229195279001327791458785378736207e-50, 5.9981972233533602380054091220849e-46, 4.35434130041610885562359611700022944e-42, 2.128871543684281172348890570821043086779e-38, 7.010199988429814914109549615728871564276362e-35, 1.5548510491491156073402187058575235039109870011e-31, 2.322972398590121367124533261066e-28, 2.337827538601202494902976010341833e-25, 1.584921772157684716475450627308573998e-22, 7.23838858223157108865789913541482323118e-20, 2.22702337704832973584505748025721631100132e-17, 4.6159941052543355324382871908719759518644816e-15, 6.445712803485950222728220489282088143948084512e-13, 6.06385214816469724214902143212255227979681305719e-11, 3.84329856791086765132762264729e-9, 1.6411291633435299389404746678977e-7, 4.72138263075370804853131363714017e-6, 0.00009151401585135423946857112893806787, 0.00119509318296839391315941247438949982, 0.01051513986189255923236911330942834143, 0.06233479469848012202362451274759919837, 0.24897227734224829551149270644322553189, 0.67000641751209154411848048664377778923, 1.21483349893204356307178072521447512167, 1.48411139390205883848583569234028532329, 1.2216031024759777664972839399370294135, 0.67750020424769147441444442333766442814, 0.25316639562406959614417719127978182764, 0.06374139072091416383309508641270286411, 0.01081327554581874390182535070841924324, 0.00123598890614567983511977549969576987, 0.00009519073044913469425990039405976966, 4.93967825899407594656936774621478e-6, 1.7271403803492250780047918917322e-7, 4.06895205426199755526414029071e-9, 6.45898667366101383245655293052233527117635796837e-11, 6.908343929906654253562864029817065004898327324e-13, 4.9786554289683438069097628498335930046681222e-15, 2.41757250719403454950123735931912609820648e-17}, {8.236607499129537606856269167200041667915238e-112, 1.077502501444304325974037790301e-105, 9.22872575123072499478201359276994704e-100, 5.26377542455109568621848157631562280396263e-94, 2.01000668751425230624952841311236243040762077471e-88, 5.15077034616350352637902151821923e-83, 8.8689220171408968220759598510387545382e-78, 1.0268840595260135917819253749935583284391207e-72, 7.99899557782208669619390247126095944396744635838e-68, 4.193314237837756108587346971477212e-63, 1.47975661804168996379824789078710845058e-58, 3.515686745369653976592788690338001386237105e-54, 5.6243821028620516873500002425599852158942155422e-50, 6.0593931568894683928348949237474e-46, 4.39651654078887592867217950130206229e-42, 2.148534103269917923995818734335292045954e-38, 7.072178668731780814270405703943758232398162e-35, 1.5680542060528786385420879456006964940625698546e-31, 2.341974065521698902719872276775e-28, 2.35629700877202847912555822372095e-25, 1.597043272273109096530811963521528675e-22, 7.29209226097891380225098041183633374285e-20, 2.24308232737372203192582784257294590929799e-17, 4.6484001704776023723464050785479795177036226e-15, 6.489836417287099422199798563441294505750020893e-13, 6.10438420331918819942254460149696257275657596389e-11, 3.86841526197082518496514243108e-9, 1.6516275257270626193186779531174e-7, 4.750979067811716240763265973999e-6, 0.00009207672453572703219652889302235533, 0.0012023079958327931165604226963012529, 0.01057751876326351674319691119621005431, 0.06269845684150638714447284349527682627, 0.2504017800496786185608960807395773603, 0.67379502120850437983685789268831953702, 1.2216031024759777664972839399370294135, 1.49226634317478942790615051080455696097, 1.22822585856815141371145125263940139197, 0.68112599266023763414479789874832675334, 0.25450453140888859929919252848180626774, 0.06407429606511633956611971635017895989, 0.01086910378273273228943411963600557261, 0.00124229978919073101974317310058219462, 0.00009567159266772403349441472283187421, 4.96437487052547751608922465458099e-6, 1.7356897236022542019115735607497e-7, 4.08890007560385998900110311502e-9, 6.49035794278514348628232215024455881876606922233e-11, 6.941596368688689243365899986577376834644026002e-13, 5.0024111617581149509487938675534694353127843e-15}, {4.559183292467557352016793224636158236e-118, 8.851350892919271479402239700938169240786887e-112, 1.125085688192628946222434782187e-105, 9.52343893094183143657646810628962831e-100, 5.39692696185044688179852795233777729339731e-94, 2.05245580446567674290127905231561376093623623242e-88, 5.24475315571310891567945413848075e-83, 9.0121459866687583366668147419397200309e-78, 1.041825184922174601699754430179021295303087e-72, 8.10530558137458389650858127012268970846702310876e-68, 4.244776853620128465623670579547097e-63, 1.4966744138899970254181295893391518466e-58, 3.553403857835331634687021837503188393228637e-54, 5.6813490628687720715723267720764847214219710322e-50, 6.1176361248334946893222274522171e-46, 4.43679917047530682452552693424187271e-42, 2.16737137219513158155347184596018799028e-38, 7.131711554598340466463875352913780050667315e-35, 1.5807652075143240364115193304410441314212271439e-31, 2.360303814277991354023161919334e-28, 2.374144504140309741052386939136721e-25, 1.608774632057344158508309592318819323e-22, 7.34413848519942808257521236176612024409e-20, 2.2586645807154669505336029997456776544246e-17, 4.679878439850478812390616586334443426841481e-15, 6.53273845798236997603960776424399382995555858e-13, 6.14382856352829220652013282815936909867282589406e-11, 3.89287718028953778357412862088e-9, 1.6618594692904395553860877738672e-7, 4.77984297823385705075371200046272e-6, 0.00009262582577545042170394774054917642, 0.00120935206650986527792046947682655097, 0.01063845076022403797309861280782521759, 0.0630538394943217733754097110219988043, 0.25179929617228407909453742917020770698, 0.67750020424769147441444442333766442814, 1.22822585856815141371145125263940139197, 1.50024683233194475060641743902174692458, 1.23470874724515149130404660585984241854, 0.68467611785126207681383771857166838128, 0.25581505115139966925269045599774482832, 0.06440040139597881304972090798545565983, 0.01092380249456741003801914519126822728, 0.00124848411460874452090107989798401728, 0.00009614289048233482370822901069201927, 4.98858397877802104440532584228882e-6, 1.7440714869152017745949223751995e-7, 4.10845961756788355932148425297e-9, 6.52112192547715238718008368401828102290202504847e-11, 6.974208662135856676100435939450798353942932986e-13}, {1.700368530009993960445962810084e-124, 4.899120854904302101601822224169491993e-118, 9.241591860497987685216177168565688693637214e-112, 1.160934118843649930406432951242e-105, 9.76366575526994860928293726144411406e-100, 5.51052232646171874088623200739169307585556e-94, 2.08976087634220489055831171634392691049231193976e-88, 5.3290813347379233363035741399797e-83, 9.1426389921570381928025972262960992686e-78, 1.0555983480155768939259148035642398156153762e-72, 8.20420989144017732089651572078322677145682926144e-68, 4.293009223969244545547746145721424e-63, 1.51262629581003193025307608590311957829e-58, 3.589146114694659664900733053035913083912551e-54, 5.7355609150618581673631872211405443141528452467e-50, 6.173260661286553453233581678234e-46, 4.47538875122896798182947841334860902e-42, 2.185464679895655409022918346300756681038e-38, 7.189024774183437394833612988860076830406018e-35, 1.5930268988347790697788014413473761907999843653e-31, 2.378016913357173334274029730174e-28, 2.391418522692198456794296610271886e-25, 1.620144780630526341588386400324999233e-22, 7.39464448635564636089359963875498706538e-20, 2.27380239324075908373223405542705480657966e-17, 4.7104891453735296115565629954383238999249378e-15, 6.574495220123160998096882851570343440326951081e-13, 6.18225075771274265277530590182217662263090225483e-11, 3.91672247161506083190379676781e-9, 1.6718400421007021187538994756858e-7, 4.80801456783727228418792530692931e-6, 0.00009316204696071519616193945580618446, 0.0012162343031210373039166851513826926, 0.01069800968079746082327109742096386951, 0.06340135661382339952574114361742755138, 0.25316639562406959614417719127978182764, 0.68112599266023763414479789874832675334, 1.23470874724515149130404660585984241854, 1.50806104078261430485707604122185458233, 1.2410582455837793990305642838055140223, 0.68815404514065235984967717321734245965, 0.25709920722532249869961797783568760199, 0.06472001239898156731735458643394922003, 0.01097742206553398269294338819024636249, 0.00125454748933977556972905072405717458, 0.00009660504511052771965491313113323001, 5.01232694258720612784281831849512e-6, 1.7522929797364709844735675439785e-7, 4.12764756031996386984612850572e-9, 6.55130492481601660538272503496574631774264720285e-11}, {4.272852615424315535362317908573927633325311e-131, 1.827029654982319000829579678273e-124, 5.11477834043943482260027718125765622e-118, 9.53542812234957104387457533750805964180563e-112, 1.19014017208367038560523982923e-105, 9.96851729302221184285146073810740354e-100, 5.61031161054762083932633608648901161071408e-94, 2.12322161781631158430627769997671254754165628393e-88, 5.40588919096009590731091248427162e-83, 9.2628975136159533688964622972061159538e-78, 1.0684089288687421625802311000618959344868963e-72, 8.29688665326009243952160824564005500630330082784e-68, 4.338479709582961534668891383217151e-63, 1.52774071439386556324825716025732183693e-58, 3.623155716927504906479037632556790207901455e-54, 5.7873308042687449847535437183364647400019704128e-50, 6.2265437995456350503641643588725e-46, 4.51245270139666880542481752323128035e-42, 2.202883044042760645332972010381931990395e-38, 7.244312196581836582987561672448618205649283e-35, 1.6048763508528275031543964436348259148231976515e-31, 2.395161577351487955084087477435e-28, 2.408161687278430489965118849178715e-25, 1.631179313208323134464382979290804684e-22, 7.44371461449689370705461599849073141398e-20, 2.28852463410418312241988709123663135359353e-17, 4.7402864612970142445301339162878389768438392e-15, 6.615175631642665737879106864661678519974434087e-13, 6.21971022609593302346479036974349097216038818749e-11, 3.93998586546699730913576215224e-9, 1.6815829880553767940454312228105e-7, 4.83553066490190667246698195119149e-6, 0.00009368605610922385924470764043983568, 0.00122296290560151999866539055162994047, 0.01075626362315700678331699495773966504, 0.06374139072091416383309508641270286411, 0.25450453140888859929919252848180626774, 0.68467611785126207681383771857166838128, 1.2410582455837793990305642838055140223, 1.51571656651039808234725980130644523868, 1.24728037566465040871249890312499519305, 0.69156299889511707287706995189111067668, 0.25835816568040665589607501484165246536, 0.06503341384393356693291306183186209848, 0.01103000945352643463219676042099833223, 0.00126049514093998825409271556252333794, 0.00009705844938330281862579455293809715, 5.03562368588299851565170425199458e-6, 1.7603610216096581310110013475919e-7, 4.14647965452601038119993880149e-9}, {7.23457504608184957324811500828980335e-138, 4.590852071430190082718862917990615486104552e-131, 1.90733557424456292092497522413e-124, 5.277072703538894414803328975325341374e-118, 9.774703320080845468136187036487157644502996e-112, 1.215034545370383978190421405149e-105, 1.014840129608978930432631731213485083e-99, 5.69978619259344025312782354109231789277019e-94, 2.15368888223038415809893654686115666955912636528e-88, 5.47665363040967961247427992405887e-83, 9.3747245059299320813848752049015117312e-78, 1.0804103886084490905225411631740622397228966e-72, 8.38424101718073468664183664213024393395332727681e-68, 4.381556593455532353575396399692575e-63, 1.54212068176437032706968937698170071591e-58, 3.655630217508834113500236445559053822033956e-54, 5.8369179412316860451196916578834422737801054146e-50, 6.2777178463652089483730036378722e-46, 4.54813302829351735857913582316268196e-42, 2.219685607705250350367799385120218011156e-38, 7.29774148036140543382379576377557682919114e-35, 1.6163458874666595130314355501982532228369115947e-31, 2.411780160285364478087138935301e-28, 2.424411692128886296820370971612917e-25, 1.641901003408208476022665333349489051e-22, 7.49144222924703866835702823466356415108e-20, 2.30285726119951337023615027593258950928564e-17, 4.7693193196271423484579469727960381676600103e-15, 6.654842205967148255100540429597995328314694209e-13, 6.25626107711764346821702056222853658545781860899e-11, 3.9626990817792271984569557349e-9, 1.6911008977775622902750727533318e-7, 4.86242509841094728129546926024531e-6, 0.00009419846831664811277306173090857986, 0.00122954544052393496334378553752095214, 0.01081327554581874390182535070841924324, 0.06407429606511633956611971635017895989, 0.25581505115139966925269045599774482832, 0.68815404514065235984967717321734245965, 1.24728037566465040871249890312499519305, 1.5232204807788450180265444138525372408, 1.2533807468982428239538499408393203454, 0.69490598473227161663358682227810950708, 0.25959301413638837312778276711555193217, 0.06534087148598494742801986048184077802, 0.01108160850007818528964161128285531589, 0.00126633195178346161783806547689366295, 0.00009750347029806919231357160316583248, 5.05849282655008287467227119760341e-6, 1.768281986138830720044424119677e-7}, {8.25333943837259670850003142157120860959064264697e-145, 7.77253289924000503452840564530660778e-138, 4.792354853439200822103439449226083958340756e-131, 1.967739148309911084712275012809e-124, 5.409169894849109835579713897172460924e-118, 9.978568721521135107056651632748054003667849e-112, 1.236886496259686287814851685674e-105, 1.030963690571286965856554008730038526e-99, 5.78123150298151990694747651063751142067622e-94, 2.18175137612963228758011480733057754826907786684e-88, 5.54244110394177077161111893373309e-83, 9.4794668785660757826084993862627139212e-78, 1.0917206006081490345865906015014715531131531e-72, 8.46698452366632715767548200820899837608069411033e-68, 4.422535128684851244951865783155438e-63, 1.55585019045312177799639237618375740633e-58, 3.686733080288508827833984097457224107992894e-54, 5.8845395966302359206199306468734955484483681661e-50, 6.3269797618201440506346214132362e-46, 4.58255136630996179321466093291323068e-42, 2.235923494302903485338236359647935221263e-38, 7.349458747770418048344052101911884539742986e-35, 1.6274638907066926527425491834443347820942019796e-31, 2.427910102422885967656078205623e-28, 2.44020206251620635215893016329447e-25, 1.652330218795050723593121583793781685e-22, 7.53791124868190132750599521519775826741e-20, 2.31682371437245819320620007572658551142956e-17, 4.7976320897983882048924637468378358992300483e-15, 6.693551841687297074515542349763578915320188135e-13, 6.29195272770364744537825739383765484047002044701e-11, 3.98489117969164604768814600512e-9, 1.7004053378687334593856054619427e-7, 4.88872902381420183543217832380815e-6, 0.00009469985133959532650529364340910159, 0.00123598890614567983511977549969576987, 0.01086910378273273228943411963600557261, 0.06440040139597881304972090798545565983, 0.25709920722532249869961797783568760199, 0.69156299889511707287706995189111067668, 1.2533807468982428239538499408393203454, 1.53057937649194888341546299705239225026, 1.25936459349511639166922031631853171158, 0.69818580919946839223314165748202819939, 0.26080476878518716214964765501670629167, 0.0656426337529496372499522184185478834, 0.01113226020559654069034737528692582811, 0.00127206248944079227493479945044166339, 0.00009794045128653406035500640909519769, 5.08095179090111923744310887349824e-6}, {6.3440876075169108395846502038111696909833e-152, 8.86654909129107384004010240131201772174699880993e-145, 8.1132267035519826475887873138879339e-138, 4.943844000082602693924357681522610533718675e-131, 2.016881785389714340945750252064e-124, 5.52167274266973525466277543350150274e-118, 1.0157453623045842453072949180892978297088601e-111, 1.256466631490311948483705573296e-105, 1.045636028559648967836855207613348741e-99, 5.85622866625542270864294992979029271774389e-94, 2.2078341348967745618625331677670999135002093013e-88, 5.60404816745503324104313095287252e-83, 9.5781589658084348269251050670897733941e-78, 1.1024322015909288474639791814541308984638417e-72, 8.54568744845543633686767426341555298925385257385e-68, 4.461655975385462373702358462101934e-63, 1.56899871446200276988161616754600731916e-58, 3.716601267644108648663230301754035336818015e-54, 5.9303799066034204018425078239734730784971765953e-50, 6.3744981771647037480586968331676e-46, 4.6158128104736855734405005521492516e-42, 2.251641240629751095179190889058430420303e-38, 7.3995922456456628523121810910458053912605e-35, 1.638255439212179705795945949755340990296965495e-31, 2.443584689794627922420945689327e-28, 2.455562770606799205188951374758926e-25, 1.662485261049533682507073935861618064e-22, 7.58319742870537221904203887054147956189e-20, 2.33044524293333824083454726356702952933196e-17, 4.825265149172278562769336455260003559538994e-15, 6.73135649859902245025049065210677631653953502e-13, 6.3268304481371731196038403487749354090622934684e-11, 4.0065888561843173908327990692e-9, 1.7095069621930986718786217286978e-7, 4.91447120493206795844757349753126e-6, 0.00009519073044913469425990039405976966, 0.00124229978919073101974317310058219462, 0.01092380249456741003801914519126822728, 0.06472001239898156731735458643394922003, 0.25835816568040665589607501484165246536, 0.69490598473227161663358682227810950708, 1.25936459349511639166922031631853171158, 1.53779941107799519503844976247743095514, 1.26523680773787472283901324786783404207, 0.70140509726660454293033231071221991879, 0.26199438062044027066875938512435997008, 0.06593893324736520093125594258191124499, 0.01118200297448317137642673702935096991, 0.00127769103374137436848924777003882413, 0.00009836971423530801876679817404926012}, {3.285735142837465507259729599776641e-159, 6.8150742735110168410464643827861509712687e-152, 9.25469628604315044336965974162438225842735064204e-145, 8.36923778579189339493430991537300553e-138, 5.06703823945732000585995923833966224322456e-131, 2.05871861072321406006462700584e-124, 5.620355214196624317413076653415569889e-118, 1.0317689756307551358146814576781074635893861e-111, 1.27427931584246437166399022943e-105, 1.059143267831653637517123666615789346e-99, 5.9259190795263776111461375197987839840731e-94, 2.23225457530146442373154545940521048312873773722e-88, 5.66208640011677416722361801583721e-83, 9.6716134612258317287060329724180186572e-78, 1.1126194168245363260914040373716036692070586e-72, 8.62081448165523675606641754928628347099993396456e-68, 4.499118128165895879691275654634197e-63, 1.58162444341653813447929394522196122568e-58, 3.745350810257675144944090827410030688030746e-54, 5.9745964597121200382757993352700748268101331491e-50, 6.4204187336059852233391148507063e-46, 4.64800887720580487302825268764072456e-42, 2.266877918849361846887947865917890042066e-38, 7.448255247644711831195738266724312185963591e-35, 1.6487428201919486898759019204636807332071960296e-31, 2.458833669637862752951560054653e-28, 2.470520739332787743431820674952068e-25, 1.672382646788893985442139850204025512e-22, 7.62736942803326381804776301151044062613e-20, 2.3437411803989267396293358585854057695824e-17, 4.852255365055604411222474273080655110787595e-15, 6.768303772702515654175967411853460649628714118e-13, 6.36093582834996297480482589543315851296087831002e-11, 4.02781670309443725255101662148e-9, 1.7184156081521876034439946600012e-7, 4.93967825899407594656936774621478e-6, 0.00009567159266772403349441472283187421, 0.00124848411460874452090107989798401728, 0.01097742206553398269294338819024636249, 0.06503341384393356693291306183186209848, 0.25959301413638837312778276711555193217, 0.69818580919946839223314165748202819939, 1.26523680773787472283901324786783404207, 1.54488634462894538779622419206061742155, 1.27100196961040502540143855618870511774, 0.70456630791988685910998500532784315746, 0.26316274099521996383221693857227639964, 0.06622998808737319218170045868023705725, 0.01123087283404571873218501662148198914, 0.00128322160094890738088055248593866889}, {1.1466236796324287617683991759794275582921662788e-166, 3.52948658955468921394293131683769e-159, 7.1130474030963557165107481483798827809641e-152, 9.54623295894831338080305812854350232889347458768e-145, 8.57734526588594001728060978522181188e-138, 5.171878219375900564892562376039727564886693e-131, 2.095403443289840742055514522722e-124, 5.70872263581112821589867985790863733e-118, 1.0463421028310277216692755750655741516583316e-111, 1.290673420393111845441470621034e-105, 1.071691934692418095371113871824198564e-99, 5.99115501362640328510279106070070328142972e-94, 2.25525635947051471622061082375873658649152212455e-88, 5.71703622724720004561475300060075e-83, 9.7604813760714514576537018186117270197e-78, 1.1223427120967433397424686721884170119703184e-72, 8.69274974354507008864549073758626404997902878139e-68, 4.535088204135085350406185666540119e-63, 1.59377665634315822470076472574748807201e-58, 3.77308097293860390041153630476758188542778e-54, 6.0173253069307709882673306056990040827782173511e-50, 6.464868204579221180824887943522e-46, 4.67921982179470673018334232787615817e-42, 2.28166802566948552343525958989959922881e-38, 7.495548380486984080997022930828224579793088e-35, 1.6589459440815859866824181665084178946280633399e-31, 2.473683753689479723102716078197e-28, 2.485100258139186317072326034514809e-25, 1.68203734120066367594914002685073697e-22, 7.67048970107613360320763692225375183703e-20, 2.35672917649261149446368240899570710917054e-17, 4.8786365044519621276481895290838210263828113e-15, 6.804437388027170048618269483965577266563543124e-13, 6.39430717905437247978265726886056258332966133146e-11, 4.0485974293888345715567989915e-9, 1.7271403803492250780047918917322e-7, 4.96437487052547751608922465458099e-6, 0.00009614289048233482370822901069201927, 0.00125454748933977556972905072405717458, 0.01103000945352643463219676042099833223, 0.06534087148598494742801986048184077802, 0.26080476878518716214964765501670629167, 0.70140509726660454293033231071221991879, 1.27100196961040502540143855618870511774, 1.55184557391535967427334513551669932326, 1.27666437325564862086968684519745637222, 0.70767174810031357559411188919597471485, 0.26431068659366764292476165907226483221, 0.0665160031069058215523478898491834253, 0.01127890363052319388943455830581795073}, {2.69609517305978709878823212464571679242e-174, 1.2316248354416096948735058446230808922888016888e-166, 3.683623151250505025235478437326942e-159, 7.3367565492061896799192000661448709028788e-152, 9.78312407312268138771290265691344081738758558267e-145, 8.75438311524416111006443521589998272e-138, 5.263777227634837538435447096465819717537051e-131, 2.128243813929066768877312682746e-124, 5.789069012641046834024863033764575416e-118, 1.0597513578731483476925607433240029193400108e-111, 1.305900736375295010118581314465e-105, 1.083436219884935027521792854649592837e-99, 6.05259059929305244577963114182396778330627e-94, 2.2770308585866445682388935525187153124848128747e-88, 5.76928240849565810119160882163369e-83, 9.845292905138566843972777807143347149e-78, 1.1316520552167695630715035062583201119588776e-72, 8.76181475640226995177219334833279625413138484337e-68, 4.56970725935639758081602749431481e-63, 1.60549749686140746635417410423040520634e-58, 3.7998774225786338994639750663979967969359e-54, 6.0586848292446365251100859785280583533435534561e-50, 6.5079577215589721982762225878427e-46, 4.7095164744300246249006988448198187e-42, 2.296042194799804261794637066825576656165e-38, 7.541561507328117645589126820069341542033649e-35, 1.668882683492565628703636319018637071162114667e-31, 2.488159033257853187633583186996e-28, 2.499323328696416229513825458805287e-25, 1.691462953817432446033741005069104335e-22, 7.71261525150890647554410560816500993849e-20, 2.36942539425647645660760250597750220072092e-17, 4.9044395843632042801944556272757780666338252e-15, 6.839797619531549011398213814052109027943117961e-13, 6.4269798785093141530162430074456190563914224959e-11, 4.06895205426199755526414029071e-9, 1.7356897236022542019115735607497e-7, 4.98858397877802104440532584228882e-6, 0.00009660504511052771965491313113323001, 0.00126049514093998825409271556252333794, 0.01108160850007818528964161128285531589, 0.0656426337529496372499522184185478834, 0.26199438062044027066875938512435997008, 0.70456630791988685910998500532784315746, 1.27666437325564862086968684519745637222, 1.5586821628039582635169870029928635636, 1.28222805066322498285298236375896865603, 0.71072358519472176825816421038229804086, 0.2654390038897121651226614035009318267, 0.06679717093267157310479150047005637029}, {4.271460680550645763197458284189e-182, 2.89582438627132821306968137463565422011e-174, 1.2853504866098412910161277202455377703681389977e-166, 3.799295472482415161091831558796693e-159, 7.5184637880569603228983444324579307962471e-152, 9.98457741629974251637402491961532418327889351275e-145, 8.90951842239901554470874841629075505e-138, 5.346021465393911366597209287471539373812899e-131, 2.158095377901859759128833237144e-124, 5.862980889420029878730499035697015798e-118, 1.0722035797125293926364080687339560114586184e-111, 1.320149226184671286275813410453e-105, 1.094494449447888097059700591107465003e-99, 6.11073949635421367993432191370845415678466e-94, 2.29773130490256538512578823887089236445632773214e-88, 5.81913822501522626138946541925685e-83, 9.9264860767228544588272401623720484565e-78, 1.1405892589995902868528661156151123231683666e-72, 8.82828163287909972371836302984939471528855297987e-68, 4.603095885845478195880037630096301e-63, 1.61682332295409268210368966046965094826e-58, 3.825814673291366357671824454370075908532797e-54, 6.0987787634930647483780545385183087504393604735e-50, 6.5497853290528314387092537833391e-46, 4.73896171088517453199751284546295981e-42, 2.310027773570061389317139629551709067789e-38, 7.58637526666154952508242390363858239576035e-35, 1.6785691526266725655967089757546272025116040125e-31, 2.502281324212521664288249795466e-28, 2.513209954449034148294064423840757e-25, 1.700671903661200035583363878269117405e-22, 7.75379827218910682730811426589168146189e-20, 2.38184467847964187950291117276190154699213e-17, 4.929693172855248923816516520945492199738163e-15, 6.874421658529015336383140566687226316300861336e-13, 6.45898667366101383245655293052233527117635796837e-11, 4.08890007560385998900110311502e-9, 1.7440714869152017745949223751995e-7, 5.01232694258720612784281831849512e-6, 0.00009705844938330281862579455293809715, 0.00126633195178346161783806547689366295, 0.01113226020559654069034737528692582811, 0.06593893324736520093125594258191124499, 0.26316274099521996383221693857227639964, 0.70767174810031357559411188919597471485, 1.28222805066322498285298236375896865603, 1.56540086952764296337075739723921611093, 1.28769679292995255728707802233735172769, 0.71372385825728125359933556923198502819, 0.26654843315554375680912951617959450111}, {4.5597953692038751909635391324792685487529e-190, 4.587686687954438762205962181334e-182, 3.02200852345772485923623708815944475565e-174, 1.325652752529273274655706443173360397849533065e-166, 3.89321519147496880584121517446356e-159, 7.6729359843790744384526710674862574731411e-152, 1.016105274099173168816603194311890415113721504305e-144, 9.04831607276248951436859276567944424e-138, 5.420761357334727846841265504053277510535272e-131, 2.18554987451640477267001461614e-124, 5.931603121420979484557805661256627941e-118, 1.0838531568552293779386506030717428295845483e-111, 1.333563112575633015484120574271e-105, 1.104959524392783768996748926758834699e-99, 6.16601291756337381051865731322412874806224e-94, 2.31748243697629918049279356585493866568113474417e-88, 5.86686243591753858780576776677084e-83, 1.00044273330411977946197970687209729175e-77, 1.1491897005088140439519035363608695430641521e-72, 8.89238293663572645673961491770705777041377116644e-68, 4.635358086587571252691435343292761e-63, 1.62778574860097768559477543354660283122e-58, 3.850957999011015415847418645008598142736752e-54, 6.1376985984188211326175134870736958886455570798e-50, 6.5904380306179092731406730807777e-46, 4.76761164242012777307851859400253149e-42, 2.323649293916416476080161061298576726182e-38, 7.630062340420817008937192097196777340830625e-35, 1.6880199394136831916296625494469776976696574878e-31, 2.516070455795335894074785588408e-28, 2.526778384745399535791765979853774e-25, 1.709675559412241231821202965389303607e-22, 7.79408669168586512248494846094253683001e-20, 2.39400070038465971008356312877580994038629e-17, 4.9544236490913923794152949917424143530153653e-15, 6.908343929906654253562864029817065004898327324e-13, 6.49035794278514348628232215024455881876606922233e-11, 4.10845961756788355932148425297e-9, 1.7522929797364709844735675439785e-7, 5.03562368588299851565170425199458e-6, 0.00009750347029806919231357160316583248, 0.00127206248944079227493479945044166339, 0.01118200297448317137642673702935096991, 0.06622998808737319218170045868023705725, 0.26431068659366764292476165907226483221, 0.71072358519472176825816421038229804086, 1.28769679292995255728707802233735172769, 1.57200617119324556198562558880280394907, 1.2930741693875367146561312826095517428, 0.71667448811420407462300914278134062287}, {3.279765932961348685630253626301401e-198, 4.89715485244838774487937802103997253065163e-190, 4.787385065468359343145446957871e-182, 3.11662853650493961175667059193419927557e-174, 1.3583643137037251114188135026517326135495684358e-166, 3.973031590177111457175682944235396e-159, 7.8082145494644737011621725269264217212173e-152, 1.0318899543693201985667040782094071700211254891e-144, 9.17441749256790103563808228972683011e-138, 5.489483976242562259537867517608470873358959e-131, 2.211034271936911512321400491568e-124, 5.995790164858290364503903710246985317e-118, 1.0948185362035706898497902203376477346101744e-111, 1.346255611831689920748715791546e-105, 1.11490580403692407133024868174167042e-99, 6.21874554325678979560718887245625332687459e-94, 2.3363872613085831667487404057835593387298829771e-88, 5.91267145827018534543145736991962e-83, 1.00794266308774734170868449012325327077e-77, 1.1574836063853314810166076910494467333119377e-72, 8.95431917810819296228991068980018848212780666096e-68, 4.666584265517291645709162121018591e-63, 1.6384124584092261413355898445497137685e-58, 3.875364947693259786845043077292401354921862e-54, 6.1755254929365742120094250806993503168452667451e-50, 6.6299934437905465584766919359224e-46, 4.79551658739336387794948483332255636e-42, 2.336928860350422397285061160609278904187e-38, 7.672688507107845810634265958116354393610861e-35, 1.6972482997655343249381706789424955796440234622e-31, 2.529544514019535740609287727655e-28, 2.540045321950526536589747398347468e-25, 1.718484359065456676119911095045182792e-22, 7.83352464355023769200182663001559702384e-20, 2.40590608253841266641594039854744995135434e-17, 4.9786554289683438069097628498335930046681222e-15, 6.941596368688689243365899986577376834644026002e-13, 6.52112192547715238718008368401828102290202504847e-11, 4.12764756031996386984612850572e-9, 1.7603610216096581310110013475919e-7, 5.05849282655008287467227119760341e-6, 0.00009794045128653406035500640909519769, 0.00127769103374137436848924777003882413, 0.01123087283404571873218501662148198914, 0.0665160031069058215523478898491834253, 0.2654390038897121651226614035009318267, 0.71372385825728125359933556923198502819, 1.2930741693875367146561312826095517428, 1.57850228585812161319178832237677459135, 1.29836354485071486436555789213022391358}, {1.58953343254301766320349254686761330764766926e-206, 3.522274855845639348107168499496823e-198, 5.11011125331039247107692389059221454884661e-190, 4.937073886242983334078573889401e-182, 3.19340085014982542026195465839546865258e-174, 1.3861549510460991595085716668092718349686890613e-166, 4.04291014965619579430409178904402e-159, 7.9291808831375823362691628276355249500294e-152, 1.046227254234909852962090970010969638832694447484e-144, 9.2903406970095109541811755542228159e-138, 5.553262241941718471312596142145202199947482e-131, 2.2348672064366613493046039045e-124, 6.056197484158104380928174099316937997e-118, 1.1051926869746927408003984951373474710858595e-111, 1.358317329309302998983002897928e-105, 1.124393797213106309823856549037885792e-99, 6.26921368804769698307982223330985215166348e-94, 2.35453190913033813550078713206194324854806440034e-88, 5.95674830356749975153967351883575e-83, 1.01517487302105795527959099799438093224e-77, 1.1654970298237004267026313997948226253706014e-72, 9.01426459757035080949555476651646604645614139982e-68, 4.696853565539222029108570877516428e-63, 1.64872785243711773676385325215515475402e-58, 3.899086553317044281672321754116626932350947e-54, 6.2123318273433800609975881380200672290925210221e-50, 6.6685211510271509668000968168736e-46, 4.82272187135687327840428765272543906e-42, 2.349886472043136190182146958510406711248e-38, 7.714313522715673875671248265368600612895657e-35, 1.7062663212186175053297061605535591632720462403e-31, 2.542720048073071887290144976241e-28, 2.55302609817064776790089709901149e-25, 1.727107912625503694062181037209465562e-22, 7.87215287126707559113268339447581872838e-20, 2.41757250719403454950123735931912609820648e-17, 5.0024111617581149509487938675534694353127843e-15, 6.974208662135856676100435939450798353942932986e-13, 6.55130492481601660538272503496574631774264720285e-11, 4.14647965452601038119993880149e-9, 1.768281986138830720044424119677e-7, 5.08095179090111923744310887349824e-6, 0.00009836971423530801876679817404926012, 0.00128322160094890738088055248593866889, 0.01127890363052319388943455830581795073, 0.06679717093267157310479150047005637029, 0.26654843315554375680912951617959450111, 0.71667448811420407462300914278134062287, 1.29836354485071486436555789213022391358, 1.58489319246111348520210137339150701327}};
	gdouble HM[50][50]     = {{9.71360471807871757756491815446306426298, 7.61503942454231078944080358062854732691, -0.35232795652049170600552698938888178343, -3.24480573046270703738889462404004043254, -1.92399333731030696465990756830296553861, -0.5673439882394091404364080156820426774, -0.09846856142259960659447552029914391019, -0.01064661431370759794094199198959143801, -0.00073634905366152621715474930828595465, -0.00003305721595969659844253297270542304, -9.7201312204575450294250140529735e-7, -1.883228367380652902073747026379e-8, -2.414285897121966664225637599160968574900327700713e-10, -2.0543396822702647791326991968691060391124764742e-12, -1.16298064969893454582802028951674006116048261e-14, -4.38816424526820405811930288858143034609752e-17, -1.105184278660982304278139263556639702101e-19, -1.860112280662093272240742533944508303e-22, -2.094191699295096404344284096479662e-25, -1.578397272356760279656814362915e-28, -7.969540718752433036476231918140712664374153036e-32, -2.697228099315767062667767383206251104921706e-35, -6.12187020620418555543491337214328439065e-39, -9.3221935405439735544172611796228158e-43, -9.527546805902891788964948596844e-47, -6.537540792266221094834482391246246311103802688e-51, -3.0126077970357603898019904433264845679253e-55, -9.325581051706974751586224925895671398e-60, -1.93960114760519204259107280387978e-64, -2.7110646358165068495979169524419484161021822081e-69, -2.54704671670026556742914782740340521357876e-74, -1.608697703310282667594269613999187736e-79, -6.831507691808601115162799875793e-85, -1.950838934334608191010600533018241183032598192e-90, -3.746639519918825397821609095070770806661e-96, -4.839787948440518028537322095801525e-102, -4.205511983190891939780245688940232441322211934e-108, -2.4584426135291960653141576397009318975877e-114, -9.669126069849964981780350327400846e-121, -2.5587902721308723855997040632875565228749282688e-127, -4.556530015316429812736175414234777259076e-134, -5.46028427888406873517535435785672e-141, -4.40357111830180987442750952262741154332806069e-148, -2.390170364067039642714300366014608032e-155, -8.73193252518154610994909743782e-163, -2.14719532584831379322668399257780564647574e-170, -3.5541270456050774248067062215214498e-178, -3.96016949282185965577964773317664446799069635e-186, -2.9705169433665305986936626317000068681e-194, -1.500046137122044321967264819771926329042264005844e-202}, {7.9940267350240828260594773293271198165, 10.93035844613868194388532176089180436481, 4.94561721748382532150987489102220174316, -2.51886398775389839685284774579480554128, -4.1449508109662795883415732741578906747, -2.17804886382698859238006210302770537822, -0.61908410555671816895550424190733466495, -0.10593279761825677240532847921148766951, -0.01138449759896407059127070790938531213, -0.00078526117145247553702952208549140765, -0.00003521062311085394425972251934849006, -1.0348124195489574395738645474803e-6, -2.004583573874562100618707320802e-8, -2.569906572900623441646873652863441430809492299208e-10, -2.1869932745292116531618104090361444888044511675e-12, -1.23826705087031976894705191194253348899350881e-14, -4.67305803112428154498278404036157126368089e-17, -1.177154858467534086902259589875835159524e-19, -1.981616157510934773846585866649786516e-22, -2.231399192113171292271330256696763e-25, -1.682114395811156066488315593081e-28, -8.494702385628576887649978598829290800592842575e-32, -2.875445928414828068333842950286764301796863e-35, -6.52741404490067919513497516271954354251e-39, -9.9412619168804153198763218021626941e-43, -1.0161732229747908900722362516839e-46, -6.973668815286277501239203803457393364223133908e-51, -3.21400740719597201498826223521177377335799e-55, -9.950268625118655582715417416633196553e-60, -2.06977607091803316535192090247561e-64, -2.8933459637466829702374998763552786504959414836e-69, -2.71859585065068133626970921889732182093896e-74, -1.71722514659980270621199855825276233e-79, -7.293103224983396002256446686583e-85, -2.082851361568189882531104308278752455746976657e-90, -4.000534477004705078549427627862356917314e-96, -5.168207853824418919211213837566268e-102, -4.49126240816113251384246141589600833412166619e-108, -2.6256935013324503235137000719926034313142e-114, -1.0327712632273266320175690510520892e-120, -2.7332743978905202948159789667306939782533993732e-127, -4.867580315240410972455147124313764374529e-134, -5.83342062082513581762279639201539e-141, -4.70479892641068790407390403172265126845046557e-148, -2.5538292235976308925554960972233755295e-155, -9.33037920919385171200079194101e-163, -2.294486178551733156167847588261330657192062e-170, -3.7981394049881475343615709634960251e-178, -4.232285190048410701805952828678071513787192364e-186, -3.1747941028301354126961673492223708355e-194}, {0.28237433621661019283793659958872999494, 5.63666429627346919117160579961715570393, 9.50589029176933142229611167267416855848, 4.48842960823370754934687869389448331918, -2.79331813578650751408251464282513953912, -4.35849600232881582202803297118912871409, -2.27819167955850879441261443475198556698, -0.64659369548270010349144059739422093261, -0.11056691129533459618984141023110946462, -0.01187796147125985466072392848230594746, -0.00081908824781715524480410390071207049, -0.00003672055784518139884286728674164271, -1.07903374012294541048916231982921e-6, -2.090008163636098727503695252265e-8, -2.67917119094359541064547684393537523080179509906e-10, -2.2797983895817807749121439039514089442200436422e-12, -1.29072632803282861247460059617503012593086117e-14, -4.87074944509278238593735969895284257426512e-17, -1.226891350960304996182089093964644461951e-19, -2.065249276367273681511487155033359374e-22, -2.325480831347542140487093109491228e-25, -1.752973452456786726938147642364e-28, -8.852252654104493181096558352930473672958747727e-32, -2.996387298687064487644967708128970064687678e-35, -6.8017728888953018086618630812454961138e-39, -1.03588531061680183765431480792519687e-42, -1.058834174858157179757131841199e-46, -7.266283172542136647422219869669670470715954181e-51, -3.34880097561702722126997009356109455550263e-55, -1.0367387451165954647809519353802468899e-59, -2.15650504848861394452931008110733e-64, -3.0145365794150431234008524679192668469939086263e-69, -2.8324245517327206274855385904110308574057e-74, -1.789100935648691400758704502854385371e-79, -7.598261309213063173849774944392e-85, -2.169975007088200580862969580950068524479064123e-90, -4.167823885803485733531633255786532631109e-96, -5.384265623496744661916324175671264e-102, -4.6789709837818718394324174587410992214332709556e-108, -2.7354047795966975523379818259643306791857e-114, -1.0759140616715576188305932044460717e-120, -2.8474279127632224372767844636234465180979528071e-127, -5.070828034872956723218313899998026135134e-134, -6.07694735251479229132799247076633e-141, -4.90117076532637075276262918542157477320630273e-148, -2.660402549289991358673375551913044595e-155, -9.71967345042079459384867778642e-163, -2.390203253635136231022077069260422714019961e-170, -3.9565569321059246166536842157609889e-178, -4.408782662396839365524957353054160960982969102e-186}, {-2.78994681281385675866248288481284439205, -1.69624973854995775962879226222051318164, 5.18141696446581591070682581381786847993, 9.73841490469419556496642103933458844019, 4.64979623320714503333135092154573055363, -2.88964014838122692453027200748985350078, -4.51255966040380353909468435082217575299, -2.35812852426415352980924137463647937014, -0.66902778394291182906282139830188837125, -0.11435978031167716719664929574218342111, -0.01228113453226252115578193077117051416, -0.00084662520924822527920792373492665779, -0.00003794447395904043162655611087855284, -1.11472146235902405963925260878932e-6, -2.158653955903724006075397858173e-8, -2.766618635916031875022882774137684181476647098646e-10, -2.3537903504377481394655323822072000449469310508e-12, -1.33240284069451689513516548339476344252148024e-14, -5.02728800736066422785745447881093487639962e-17, -1.266153575279149734145347673697538729061e-19, -2.131081510835782274201409361484046417e-22, -2.3993413677895783044145287026756e-25, -1.808465348293158395181118425767e-28, -9.1316165841731305603957912242635515517633784e-32, -3.090678935826078876845364825813432239444904e-35, -7.01524569747966624753741660965436352207e-39, -1.0683159287874338392247044001290619e-42, -1.0919065208466747122962151779419e-46, -7.492751074410997400672390594104906704044320645e-51, -3.4529604869564835920469138953399067029539e-55, -1.0689232639519178834234174436407440364e-59, -2.22333090725380787396181840693938e-64, -3.1077922473769620455736408220669663231753944841e-69, -2.91990565597528423370624362821960515908808e-74, -1.844274286232621209441860938532203455e-79, -7.832242976195217619897853077934e-85, -2.23670595514632574784404807770667534216579721e-90, -4.295825778475220391021020329468680341421e-96, -5.549422004533501439668479172832326e-102, -4.8223238992582041389705411641611166130385862713e-108, -2.8191169821937429685665394387544415643631e-114, -1.1088051190215391225028731334740166e-120, -2.9343853453963633375690151334098980056513400663e-127, -5.225533578240694919421617173854808727675e-134, -6.26217404393556375471761480860526e-141, -5.05042476989883941907808740808862131339614694e-148, -2.7413489430501126879503833901529903476e-155, -1.001516209554610466894128598424e-162, -2.462810009634084001906255165446511638587284e-170, -4.0766522272012287577817203953647112e-178}, {-1.74488685558792377218781806101887237724, -3.66672374672269327807169114546316558779, -2.03832592816943677774194343904358546273, 5.27254464044264106553608675147205064239, 10.06960540597813909627313994875362357781, 4.83062902315857422065268224753826249062, -2.96088502092460992692608170399597555969, -4.64385351606515289651568282123649433331, -2.42718643670962999293068283822299993558, -0.68843397261637391315258611777863471076, -0.11763457695136854764877824525725292489, -0.01262823075620484123688714638036629914, -0.00087025657389517650153413879482339306, -0.00003899144776543472637907515548001071, -1.14515577872271109739787847706753e-6, -2.217023943169625012169553141714e-8, -2.84077204070146619912384494403164991216555059255e-10, -2.4163730471578776159472336960496960502586502443e-12, -1.36756870084499043715181323975065294514855179e-14, -5.15907762243430809982486835429603490191999e-17, -1.299139564937347558739609712222773367606e-19, -2.186282606169704335858625897071065613e-22, -2.461161633628544694311075790795558e-25, -1.854832193754055043004284551517e-28, -9.364669185451513199870673491998016851041268284e-32, -3.169221423372565381050613834804117705976315e-35, -7.19281202759035107186230744786803658732e-39, -1.09525579450648089750137424132952757e-42, -1.1193450010832167309330558464978e-46, -7.680417541290314768783097571051306570707856071e-51, -3.53917724892082850411126054410978372128513e-55, -1.0955353067999744612460250076212828884e-59, -2.27853075876635959132520200701968e-64, -3.1847500706564863765677056466904163673660141288e-69, -2.99203241228028805802988103193475668618724e-74, -1.889724413454806343196245793630904017e-79, -8.024830814048391898258176469996e-85, -2.29158822837896153767252715466160693057787385e-90, -4.401020598055401595940909774619674588704e-96, -5.685053602958064522620971421662252e-102, -4.939968795288766692375683924531985341127590297e-108, -2.8877714813547692790786156226028464841916e-114, -1.1357628667072716313899134264874776e-120, -3.0056130846862774606451682716190549702667730947e-127, -5.352180750712254905372062656270666012334e-134, -6.41372205602265068746836678897853e-141, -5.17247512211467093180192075935518550925487728e-148, -2.8075074532468771516302395281664341261e-155, -1.025654832368774904921889079235e-162, -2.522094360604274972593758482418473455215711e-170}, {-0.52496265593841641096376459115703191558, -2.01403414258509655032606584894946694725, -3.94186581339108759958594094555539453485, -2.22432109795647787894434876438840232805, 5.38459425269266611535055855673962540876, 10.38018160136871553747490381755701503276, 4.99998328461898520542434380173691245328, -3.02173843013851291233920514994636337239, -4.760421668550658294210747362657130433, -2.48865242485062486158691846527443406882, -0.70569194408525174461275862243674204482, -0.12054174716969916928952946099157573411, -0.01293573092479567216953897216403907503, -0.00089114772562112618260535921889051171, -0.00003991507755187344223169350445772417, -1.17195017543738307084488270160184e-6, -2.268313271271025785920445231103e-8, -2.905810112544592568828507006836855038818718131743e-10, -2.4711670215021984016177851648081860885272609301e-12, -1.39830727083619032676896330101967420980972917e-14, -5.27409611914607896787002585563472070858629e-17, -1.327885614424651244103644660004628694607e-19, -2.234321641614364970224786007272547605e-22, -2.514890645341855340372234090417251e-25, -1.895080549922578311455779238765e-28, -9.566731920705490368291003171718840570565936635e-32, -3.237244400546434652665745152516916740496333e-35, -7.34643475083212107709918181282624252366e-39, -1.11853979043768096705680684918576105e-42, -1.1430375157086577063617194033127e-46, -7.842317624309951887163755862123849705017150095e-51, -3.61349289985589197837561647772819634120921e-55, -1.1184552007481117992639151048885756842e-59, -2.32603523909832989099620685661949e-64, -3.250930121567941464321488114881398714739597894e-69, -3.05401401206638767870722082374495054629792e-74, -1.92875517547698188613506670909846501e-79, -8.190110310630208336446058745218e-85, -2.338659105150376977950743216615044303765060649e-90, -4.491189292631641192729182983219111623538e-96, -5.801245018250742460502224027417668e-102, -5.0406962530546755146512845232876349451807439922e-108, -2.9465224090952103017062621487025035894814e-114, -1.1588201995796164766343845122353987e-120, -3.0665054261750976645732731831320658850204845691e-127, -5.460400099593577784551779454236597913368e-134, -6.54316041592151519740945865612401e-141, -5.27667379206709558399232918108674219139731356e-148, -2.8639655082043678375003634765187407805e-155, -1.046245767721314392810680160061e-162}, {-0.0921788814547614064063247914312702014, -0.58381404368295876222671683346411546053, -2.14010428161089951174142777417273504328, -4.15040835671855614021589289897844198324, -2.37128935224878763734768648386802874665, 5.49636175475629763515388859595738034472, 10.66577518759730796762356982733920030999, 5.15494447738662827821740398370359751656, -3.07657699311244541234929648479146407187, -4.86604144889704823597574751414789305447, -2.54432709136993089650347434924655091233, -0.72130880517331290726198848222393901236, -0.12316931190956603466516818059670409617, -0.01321329357313078405976708484595477957, -0.0009099795597929878845736389890380004, -0.00004074653698058852294267635625299362, -1.19603859972863568792600844511465e-6, -2.314363017088331235855657366273e-8, -2.964130701862133195102277350462831131349843381447e-10, -2.5202421321608744826113191062005903530510456394e-12, -1.42580567832720916120503522727301791229390353e-14, -5.37687605773794671184060889714277753744299e-17, -1.35354562094973960652640873360975369919e-19, -2.277159860256559025551225378505204396e-22, -2.56275634221149778433201529627291e-25, -1.930903482625698342573060965178e-28, -9.746418165334837961488018835352291820806345776e-32, -3.297683378084808173828227412630850867916271e-35, -7.48281960798536825523920472970248966582e-39, -1.13919515679867363570701338501569971e-42, -1.1640397676418344661459672336373e-46, -7.985732734164030587426273845766913858275983657e-51, -3.67927902382925801853289002185902010143873e-55, -1.1387313324971561556422355634506407386e-59, -2.36803406849562710907046935813667e-64, -3.3094051987953171565161021946266701411988634606e-69, -3.10874810862139397208449342300869345169308e-74, -1.963203132584889819609818531470068773e-79, -8.335906429115255924666914483588e-85, -2.380160106800537413322731337505774005937457747e-90, -4.570649498757388633321591733823833699103e-96, -5.903589263423735137603489203122973e-102, -5.129379216164010239542218102399290969927996251e-108, -2.9982255660077173185817800041851669508994e-114, -1.1791030096942874167707718373505731e-120, -3.1200486885894210306574723031405783397916122233e-127, -5.555521061183060058204038751457380681563e-134, -6.65688889758310776577469526375745e-141, -5.36819227773188480775096815922095154208557772e-148, -2.9135354257714039013279409323706965661e-155}, {-0.01004727567862287976155978705662954989, -0.10104645097007812703627694519581834311, -0.61761288904490920930834596203360872124, -2.23935851450787807953455436990966657224, -4.32411254498157535059295822668884430632, -2.49313952528007722357545511347741885323, 5.60413339184813267571053779566168723456, 10.92818301552296715990094592411809275971, 5.29647797638805449239478266840924758146, -3.12720019059795633412231067721597746171, -4.96297590888679552210936751770764576156, -2.59537140394471979147934997086622731725, -0.7356164130108098413221845655276177381, -0.12557481440663974820390388018718920902, -0.01346719827295118325248340461367920162, -0.00092719194408800696023211742568280701, -0.00004150584208195536844188852188123961, -1.21801745399987842930839826858586e-6, -2.356343266230276698160518654255e-8, -3.017251474657616542489561401084464255409040553573e-10, -2.5649037919067129322279083200512873200812338725e-12, -1.45081031415705415349132818297027833360935951e-14, -5.47025961014852424022103957954565660604864e-17, -1.376841456250766770272126561516622992509e-19, -2.316021696072780349210259439043250688e-22, -2.606147153625367626932091113903924e-25, -1.963354408623632979901142481726e-28, -9.909079497462447017053004095704312587513178602e-32, -3.35235989924325554140084137148356639193202e-35, -7.60612289044765150005790941156581643228e-39, -1.15785793169831795681277566008847693e-42, -1.1830048075142803394831644456408e-46, -8.115163273939122499295330246490320204337932826e-51, -3.73861787071437166949594436159058138181924e-55, -1.1570107130612946556800256582673989042e-59, -2.40587774881950782764717259690482e-64, -3.3620692993328303102527670774756987892203185935e-69, -3.15801975049483947130994544051028384384315e-74, -1.994199082558399157564671570379659399e-79, -8.467034810376633346369628759908e-85, -2.417470095935195800120092252740566970107922956e-90, -4.642056087462068732302895978990598970698e-96, -5.995524086883200790637431012962533e-102, -5.2090117492051102656678637975302874774636562583e-108, -3.0446350298167358259295949834628815650419e-114, -1.1973026147814155483707583526149887e-120, -3.1680759676623154965114912805297311628859251224e-127, -5.640814071862033618898713081423482362864e-134, -6.75883369088838813609001816022759e-141, -5.45020242089975567301337582022046003677812961e-148}, {-0.00069915978221902222344950049878680622, -0.01094208660297619631129388989735388146, -0.10662496524545969408389125181564402117, -0.64431433377694159933256464099666891562, -2.32270225230777568777124329910319500647, -4.47387717756539274566628910716235546245, -2.5973384869690467484431105746128049326, 5.70678125055692136384060286553957121487, 11.1702279607915470901385608862775098433, 5.42627518938190921983504413392671847236, -3.17452816828784321341373953513525118514, -5.05276341877200321538161136128702913941, -2.64260059840742487408722114642305216073, -0.74884824165116799255532317122404464447, -0.1277985298113202070026730843034095482, -0.01370181098838469783574121716124441035, -0.00094308872252442167773767698970567922, -0.00004220673862660245989991431396679879, -1.23829422911041061894424335595791e-6, -2.395049975864369958068732549122e-8, -3.066200947628577737530567785972365515422420011563e-10, -2.6060338135517333155979484676654889401525135629e-12, -1.47382396364989228321165214522304980995566984e-14, -5.55615670700549647899264373560469288486002e-17, -1.398257198216969687708659591293420615056e-19, -2.351726733643874460752995550544714307e-22, -2.645990940013076285730548337550654e-25, -1.993136306233842260979958708962e-28, -1.0058282698993048507600941969947193555511699811e-31, -3.402486646530138704560722787962455298247262e-35, -7.71910885292644370702741099571149215689e-39, -1.17495074881135303740135351518893389e-42, -1.2003662213071064405510454795466e-46, -8.233595043901808549056088983575315847275038748e-51, -3.79288999155874333774163784266621494723341e-55, -1.1737220561096014256923253536775546552e-59, -2.44046063429724726664644392533885e-64, -3.4101760620606199317102717673383513744453529096e-69, -3.20300991024998254862379186160489771416317e-74, -2.02249082839811793612610653956479067e-79, -8.586678794331276652137852628518e-85, -2.451500221343922789050722268158141962006039715e-90, -4.707162788054654238163971564874677538937e-96, -6.079319637609163109013992015809458e-102, -5.2815704208167073160457501009385079152157184423e-108, -3.0869084537658118856349563982783478697221e-114, -1.2138751504393414874067440339093552e-120, -3.2117964547580104578244230554320533236097528114e-127, -5.71843596012673092935909539620238734091e-134, -6.8515835277717724225436866325699e-141}, {-0.00003154101474873237697945305777580055, -0.00075886233476667713009291092572129134, -0.01152618314936801202591038288021276385, -0.1110224206337978939825438124527430705, -0.66676750340657200048213618988525098941, -2.39510627295868509818981915331594234075, -4.60604094027861437503319882136618727666, -2.68848905391672722302963376937335199954, 5.80414862544990422511935588876193061541, 11.39463325775269489385071166313832583899, 5.54597838411944682739596891677248127731, -3.219118972007053489414324350063816383, -5.13652734120191615719788674098077673719, -2.68661783846554912144915862266293973964, -0.76117661002604726271406001350156211316, -0.12987001429439817904993085215323839918, -0.01392031598697368965291652006313259103, -0.0009578902214312361602957024974395166, -0.0000428591427674135757645209027505578, -1.25716156546343616135384100882949e-6, -2.431052537531065946170942238808e-8, -3.111712399052579641827456200138051300381376639254e-10, -2.6442590549875658362180426846546210486950976174e-12, -1.49520314361830034689578465206501643818633815e-14, -5.63591868463515115533073668607220503479344e-17, -1.418134693445816621745149100582877204968e-19, -2.384852780463867910911099524320877625e-22, -2.682940881796504280355857738681306e-25, -2.020743404612968772736422577408e-28, -1.019653251156023845987755249764218613998893349e-31, -3.448914343448516301867879598883882137424898e-35, -7.8237149062954283426207852186191936876e-39, -1.19076958051467742539372448545655406e-42, -1.2164274270584659925421628095911e-46, -8.343116075901576586134879035110024449268354975e-51, -3.84306025077281611506596932212799205761116e-55, -1.189164824210214166509948244936891857e-59, -2.47240713124748640456758416363241e-64, -3.4546003324967652421910154921524715431350499783e-69, -3.24454237786256740816111961395859409847211e-74, -2.048599800616325041301889565512081935e-79, -8.697057282270368403319828230651e-85, -2.482885377889210923275948461645066883217641076e-90, -4.767191240472968941792625900373285355999e-96, -6.156556845917652615900298128123725e-102, -5.3484313519355141106807294078730834403525349449e-108, -3.1258516194380324051266658041636335027114e-114, -1.2291380364858148948469852921202467e-120, -3.2520514341617261675819643309060650229047539086e-127, -5.789887021776039943349803291793803909337e-134}, {-9.3115420950951123402923414948252e-7, -0.00003416689584194249680475423495486112, -0.00079834275799124952496175357033445456, -0.01198514331455643541486952332722238978, -0.11471810875320244246081102974947469975, -0.68631828776952124472137964366096295587, -2.45943273291913194289550617417168724607, -4.72465882452738243008590445529002580665, -2.76961460646432922752744841725368686702, 5.89645386831773398712738812828580791796, 11.60376169011967927740947379935052582844, 5.65700510915401678729065662313263156889, -3.26135569468655240977259322457624850384, -5.21512557623488583691326297290028296116, -2.72788570928500752833581158582366023116, -0.77273319965489952943701536365209265624, -0.13181173697353081233369802883057482879, -0.01412512121628452674262585665745973429, -0.00097176223160327098190228157435734583, -0.00004347048319232555096606361488258849, -1.27483783836819008415719423004957e-6, -2.464774391042126253320267046718e-8, -3.15432951729799168887071606371224549503143601106e-10, -2.680043087525108315735996816262077374506040004e-12, -1.5152109033746264166319057440678862912619202e-14, -5.71054061345653709511832419311187930225978e-17, -1.436725223656238271223971332728436615903e-19, -2.415823911970451255067874632588589046e-22, -2.717475721123486823539668263325926e-25, -2.046537507278062671927184768431e-28, -1.0325660580596830701602091207124041382162370467e-31, -3.492264504500483052255229679886945918172409e-35, -7.92135525631576715880043422793198626945e-39, -1.20553030467018333085802588236841132e-42, -1.2314095801921164599522768586612e-46, -8.445247343584553633938239759645329261533199415e-51, -3.88983108119494781374237033053655370641868e-55, -1.2035569175293532401996539936701893634e-59, -2.50217136815515214111915317298629e-64, -3.4959781103937677828655599933900131815818777936e-69, -3.28321580187123821006161411742062676306597e-74, -2.072904786800456429104572500994305652e-79, -8.79978163834612515794355354165e-85, -2.512086485184499197452608795941339582582381965e-90, -4.823028078685854319313094254923218458419e-96, -6.228382810394438302569155474544793e-102, -5.4105927934711754527994694169217234010884721663e-108, -3.1620489171174773153484283431882421529195e-114, -1.2433214324583048709300671556383815e-120, -3.2894507981577401101861157403897138894048709479e-127}, {-1.81014678261776218742239605922e-8, -1.00737118047475959006079108495874e-6, -0.00003590832360325086424726860993688923, -0.00082926317848550693896580823895655585, -0.01237034628421543978021667023472362012, -0.11793763608768384386216550210492334107, -0.70373147530566082690734581389873755084, -2.51750540909033720460126595234911317996, -4.83249563929645440104083408081670182516, -2.84280127801376065711537363829519518003, 5.98404881683679453057938700837729139987, 11.79959774870885263538745557140133955467, 5.76053674924812928526127685019605719312, -3.30152441524936540075575802434895696091, -5.28923377505293740161705484355164489545, -2.76676860618917128067418547661214727095, -0.78362136609002470397664142214187088757, -0.13364125611096299357478070039516994931, -0.01431810006384223334402970623158885312, -0.00098483320633969699022506047424367305, -0.00004404649396957445668437213075984843, -1.29149104056533747736001183636746e-6, -2.496540308413993391206619698857e-8, -3.194468200799558112438226947387393481352527311058e-10, -2.7137396957934799974002741161708428284100373538e-12, -1.53404758119425791286586664797298257978518689e-14, -5.78077895948455227528132299540799388376678e-17, -1.454219508984786195863949048283609535868e-19, -2.444961537327122696243279554158271747e-22, -2.749957838993976689928490078212025e-25, -2.070792169676394473604994382222e-28, -1.0447050393832396543919454968824546245176205286e-31, -3.533006150738201177113511702338151888681606e-35, -8.01309625589120362813906850524257464849e-39, -1.21939558059005678802106249764136341e-42, -1.2454792066202237598714003672795e-46, -8.541133428076884237252981838389879193999212828e-51, -3.93373079965789311257719844429827086722905e-55, -1.2170621433802506915804053266794191586e-59, -2.53009458467655633505138282956126e-64, -3.5347871005319045908637206046915624477177348353e-69, -3.31947966344420928681864836051208635745952e-74, -2.095690092740223881494544686077148849e-79, -8.896060917725060762552726058171e-85, -2.539449284245119297401481883805004765474495032e-90, -4.875338197799191084687602281404325550877e-96, -6.295657536839151142401387854284677e-102, -5.4688029841505438996555752907013836404436609705e-108, -3.1959382826614548340364845462222459952255e-114, -1.2565977831559941791050572143519788e-120}, {-2.327267778729942071967653954946811064637575061083e-10, -1.956483504462552979575944822027e-8, -1.05785485014702289274520214428379e-6, -0.00003726791403551735595163075566124625, -0.00085517209041023234837179469812117357, -0.01270581126062538908552049623223457854, -0.12080789379633482394321010273907423996, -0.71949032509848491971747890475361579753, -2.57056871838492072840670545419277630022, -4.93152752394317847939420870239121311425, -2.90954621007894560905384235643552764724, 6.06731716889180789945752268802277987043, 11.98379409311512221514197159817076508376, 5.85754911381281888872049782205659436109, -3.33985090938447515326903247004705864006, -5.35939632830401685192469118979463697289, -2.80355968116289224556678748620038574331, -0.79392398807533119836139965527932691268, -0.13537260022101984241376610127409051214, -0.0145007438962076708075241916657893315, -0.00099720505384349516182487753291865846, -0.00004459170978132229366516557925324261, -1.30725364239924271654048303478873e-6, -2.526605721160535540664707739956e-8, -3.232454787832171166924953988402899828416427534652e-10, -2.7456259006074746680536936378957656206529805975e-12, -1.55186975397227196409854505054499251759619903e-14, -5.8472239656424879742323640579106544670752e-17, -1.47076614064222032941215225562430086708e-19, -2.472515736370454362541635927402909289e-22, -2.780668859810776745425549867686344e-25, -2.093719759331801114186847872962e-28, -1.0561774959429145157884405967108152219434991616e-31, -3.571502733760196046243169447889487094004329e-35, -8.09976359769329930478054564490097786204e-39, -1.23249126953567976167629997457434577e-42, -1.2587650777318399581771578880178e-46, -8.631658903124924840206827034020455424457089555e-51, -3.97516749477949190641341297984407425252315e-55, -1.2298069713418583673619200348157393623e-59, -2.55644012457922590914051753571841e-64, -3.5713958135277700121048767521429522128664795199e-69, -3.35368057427983216342947745317009426084452e-74, -2.117174883674231667486812920837809343e-79, -8.986826867385140733722216577304e-85, -2.565240141316438151872778573204818195676150829e-90, -4.924633712601822257935657371567821916952e-96, -6.35904325706171455553221255964448e-102, -5.5236379619222014037539934256343154276382152569e-108, -3.2278567943241038905913255821986295480003e-114}, {-1.9852136074872506613021198283119953005850555284e-12, -2.51359112133447958577383638239282961024737737923e-10, -2.053148120551328716619819382698e-8, -1.09715407771267933951333892493027e-6, -0.00003840516527945381449330731944818354, -0.00087771934041048739952911552868576373, -0.0130049461005713850969662749883435507, -0.12340844795521010666305107374342099706, -0.7339229450092389294380066179784839826, -2.61951492861185730257876824979677786597, -5.02321941354026946013090978157342380836, -2.97095886979838139279956089595757330447, 6.14663181499319600123785080139508954219, 12.15772833528035249412746349822840403362, 5.94884916193301871862366372778197242616, -3.37651996126174303928742512909775350778, -5.42605977067970418170939582990677830389, -2.83849885551107728312866615322144014123, -0.80370870687425430835586046577621097881, -0.13701718478151943483886313948794484614, -0.01467426270347087743571863321964213918, -0.00100896022013663912428420035112428715, -0.00004510978948063169640970145713839956, -1.32223226452270046895300521339094e-6, -2.555175751443314665738929604278e-8, -3.268550802058312005573995745145860536147117280653e-10, -2.775923289429581696968501731054018293539656913e-12, -1.56880245599716728288636245230438927921063849e-14, -5.91034625482567668520771357344210475645398e-17, -1.486483434100948546537073597012895676911e-19, -2.498685389532536984626895888840926137e-22, -2.809832501765366615335981550269868e-25, -2.115488808808940895148355174397e-28, -1.0670685034247283173932519777715435239297618127e-31, -3.608042187712160271242694930096771786623744e-35, -8.18201092764302300063184395247462696458e-39, -1.2449169403643767818578980603908177e-42, -1.271369002187987673453681232256e-46, -8.717522736336721121666584950089149621236197683e-51, -4.01446346366289426259336421455404982572209e-55, -1.2418912371343350104245013241213327935e-59, -2.58141578424437485275942498336909e-64, -3.6060949161302915613566635503578848950776788947e-69, -3.3860918300825073134768887724818840682356e-74, -2.13753190956787508126610990682415819e-79, -9.072813683734193926983086764698e-85, -2.589668888341529275020875340683808327789577261e-90, -4.971317940633675959187304277356879540076e-96, -6.419061388538370357187430376065555e-102, -5.5755511774122026457141039837460026312956781234e-108}, {-1.12628437806633342510036418416674689455988035e-14, -2.1428906330039275039001676617606218922799925157e-12, -2.636281731522055274203514508065318684989363537112e-10, -2.128193857199826281313546916351e-8, -1.12996919877242743083393803251035e-6, -0.00003939394164448291725815999342403724, -0.00089782078592995392419737809074955265, -0.01327610535970753480617134494052719191, -0.12579301870942498596084015558252802322, -0.74726396340969955637761113273807164987, -2.66500839922703308649293525865453516297, -5.10868943282020892056376392953663584211, -3.02788363583083592416130830690975644201, 6.22233808971418502110361531450507019149, 12.32255447397172556281075028543717173562, 6.03510781705457755410759893073504630507, -3.4116865685308195538914482027659402473, -5.4895957454654426795004068343497320622, -2.87178532967351611451834751513722169425, -0.81303155280828232784733219552340083455, -0.13858444312618679675326072979921788149, -0.01483965397107383338033630666282311103, -0.00102016651172801952529474351128834906, -0.00004560373546690525327925011584406487, -1.33651421307533728415844797502657e-6, -2.582418032746835867039909160116e-8, -3.30296958270558781465157012214322004442244572534e-10, -2.8048123227885687913599025913967773456451529597e-12, -1.58494736043741453830339091745986751660248138e-14, -5.97052799071136383845437165398931125808616e-17, -1.501467345225670670287827342443544438818e-19, -2.523631607960417068965256881184554169e-22, -2.837629808729974142681693532449685e-25, -2.13623557438786175785454919717e-28, -1.07744678536823960915427735629463014441809574e-31, -3.642856922226977222178181365572684113212075e-35, -8.26036546905212165352520169571505631237e-39, -1.25675285209624807951966454564930518e-42, -1.2833729958418540099434859852935e-46, -8.799287702869375141091788212606965014016850736e-51, -4.05187807581149400721722562189624255160815e-55, -1.2533952473147895198920542910808015007e-59, -2.6051886426215994393968838335501e-64, -3.6391180296286406139945971212053999819779866991e-69, -3.41693301267537079143449010796344578909711e-74, -2.156899922671430707552081315987205163e-79, -9.154610893718828906115279378123e-85, -2.612903964146287221628248904297336865706537952e-90, -5.015714554449340164066880225773461197425e-96, -6.476130282138927211181963574094528e-102}, {-4.25781649966638066733592252623504092415472e-17, -1.21513931772392627820665831967986379516709725e-14, -2.2463922284104948122687387833178313506473382888e-12, -2.731295405266687508943323725650492324205024398446e-10, -2.190750821917398867058027634342e-8, -1.15847073747627486311274637067509e-6, -0.00004027507673421597632730821338581751, -0.00091604426177640907054376507796996549, -0.01352490127800614013809757793396720408, -0.12799986947786419538368331677963935155, -0.75968787569821342631931634659793245873, -2.70755872010867525050836888978243190808, -5.18881164940508914977081609363378523532, -3.08097773392549572794715611412180158898, 6.29474864882544160640140939143117770347, 12.47924553923149720639418926772422546595, 6.11688685404397836826144362032901493656, -3.44548301271971422792318417962782129818, -5.55031737266938294502466737956935513808, -2.9035865387988189114771796644974322328, -0.82193953094264886881503045327443677043, -0.14008227383063926241254805424116780695, -0.01499775126447681931809892056172934479, -0.00103088048206347419883029853782405968, -0.00004607604712728879455080991739023172, -1.3501720356858026825139963300125e-6, -2.608471623336177595874955595338e-8, -3.335887820139028138060124893503492639225925183461e-10, -2.8324422390273540381377215421096974454692155861e-12, -1.60038843455060858909701765220854663825714379e-14, -6.02808438766204965185307687349861035633829e-17, -1.515796928422709692422070027164201305708e-19, -2.547486984512107199992098505864384001e-22, -2.864209633583999671279337747703019e-25, -2.156071985566758661919697317845e-28, -1.0873687497970096147319127060238865163706417875e-31, -3.676137556514251983884757354170821505866305e-35, -8.33525934899554614183729431008388248583e-39, -1.26806474625078684842319671559322435e-42, -1.2948442008226762164465412649255e-46, -8.87741427551412529152990993029212248101578372e-51, -4.08762344954282900399756165497629855211683e-55, -1.2643846492379544029094992175900558323e-59, -2.627895224066216232159228063671e-64, -3.6706559797013096317532300942187631803235134719e-69, -3.44638341754665358727195084775120353137893e-74, -2.175392182065403309365097103055414983e-79, -9.2326995660467424720642496074e-85, -2.635082781032782483671395193437605328256247881e-90, -5.05808753824811987695618015992007497102e-96}, {-1.074172810907691695461389260782595860781e-19, -4.59177323800781437276895662335711832688807e-17, -1.27329210614443120471844183432697038512803271e-14, -2.3263613545412423406497172168519653240387167162e-12, -2.810367578491168701866673078323224728128298641012e-10, -2.245026290809311898477095210474e-8, -1.18385484706879055805412940731995e-6, -0.00004107378784113063685543542526700316, -0.0009327695783809014003666896618758596, -0.01375531546348230230252834945332103691, -0.13005737995314796506923974622407308022, -0.77132850667158444146511492266285486326, -2.74756629412000351120122587803696023711, -5.2642831292411464868367575390311794219, -3.13076262162257408366140740775509100517, 6.36414351920216039641382008691789093486, 12.62862780826687027972680350518952586621, 6.19466024578478748022796025058300568374, -3.47802363866850022025953341058928435777, -5.60849124903827516475206920210493034284, -2.93404472526195872545526597675065381251, -0.83047251088382514479803021276281494591, -0.14151736608168483673860870914645256212, -0.01514925939725676473163121284892300802, -0.00104114987258950818236788535278173648, -0.0000465288310449844978711872917811952, -1.36326678381783509122211886188226e-6, -2.633453372378653686827716586828e-8, -3.367453776922665977155809835854774675302288048697e-10, -2.8589381002734452181457017734152280594833066266e-12, -1.61519595646454838166887640237608314781125729e-14, -6.08327896888881135853198417830201697437011e-17, -1.52953820412008417001872473246994503476e-19, -2.570362142531757128440545060249193323e-22, -2.889696053326985941853571881508792e-25, -2.175091263998782768632546053065e-28, -1.0968813406911687367035929171270101810157304144e-31, -3.708042615973939970847233025442934807284455e-35, -8.40705170526940066088083751659275220077e-39, -1.2789072274104187803511154352083057e-42, -1.3058383542580676680440374238885e-46, -8.952284514857454337435634654954653958979493729e-51, -4.12187549962401471705436468111844907652968e-55, -1.2749138621867261605801850445574212358e-59, -2.64964865692376032701087558186973e-64, -3.7008668317672884611051084304804648051130824619e-69, -3.47459150832820708494858415326964807134879e-74, -2.193102440781655365875473429899480019e-79, -9.307477799591775919992595349049e-85, -2.656319020594083302105447455467778154217528498e-90}, {-1.810655367555274613765769510091983305e-22, -1.157994838852147171890987820477330395954e-19, -4.80973811825851597576559603184616186577851e-17, -1.31812773505343783185308613335771544657518051e-14, -2.3928091858747485584248454918524785255798965933e-12, -2.878897668423565100728034504886637310376976613081e-10, -2.293333294513487538616727789615e-8, -1.20685792291562461444299951126249e-6, -0.00004180688193614213191643733517077998, -0.00094826522272354198990342762190001714, -0.01397029201870363007894177126509240408, -0.13198727631937761171229956240227312498, -0.7822910619091883002990119144010414582, -2.78535206761031809874856349634559550778, -5.3356692824921874643577550954105710588, -3.17765893764933863784527455534325581627, 6.43077232663159992917153039029694338214, 12.77140794600518900438545669996936099927, 6.26883093489744425631472736787357132501, -3.50940826612102686852461568742444927239, -5.66434644823302708860181693141518102525, -2.96328186409463719125690395150352496885, -0.8386646374141106264896876051964829091, -0.14289544148014459589279620268707797945, -0.0152947804573762697759277251097554387, -0.00105101541248444674568025082373542431, -0.00004696388198664516593148550153250097, -1.37585040337820102331081565805401e-6, -2.657462573757396023097495644294e-8, -3.39779328537831061383252818979845783675033884429e-10, -2.8844059238139954834365590847524478698238113605e-12, -1.62942943616897817370466263431745491269114915e-14, -6.13633464820262613887403747847936623355366e-17, -1.542746964637428263974303278999561737668e-19, -2.592350482631133894203858475304000422e-22, -2.914193739548400299717355725709332e-25, -2.193371990272319883428074156083e-28, -1.1060241005499686464503932411609551786927123382e-31, -3.738705542431436512366264967270933053299114e-35, -8.47604466151169342718957817178974166818e-39, -1.28932620513714194109558338812994099e-42, -1.3164022929884238775655670184839e-46, -9.024219314636509138570105396852749173868859694e-51, -4.15478190990498986312783197825278369237511e-55, -1.2850285528668463373821728220829378002e-59, -2.67054383716334368210170812289653e-64, -3.7298831282433586650278423331516832317553392171e-69, -3.50168173391133980535909537810664273694835e-74, -2.210109262089183564167860379454301075e-79, -9.379279095982377326448716531376e-85}, {-2.041286198770858557582743702056949e-25, -1.951309357989231491580819717963682649e-22, -1.212565580776220137364774777096717895743e-19, -4.97745869934627630051300109206080424264442e-17, -1.35532724544284190331284276006325745657336409e-14, -2.4503363968300195336681093000294687991283903738e-12, -2.939848594680120992076292756869980722226539970244e-10, -2.33709228113947241787954590809e-8, -1.22796931452074452790286166803754e-6, -0.0000424862024774693100924827698227798, -0.000962729132620892339605945702519043, -0.01417207958823962835988090898303727642, -0.1338066197469150115191467824866086305, -0.79265995075688568511869598932104627484, -2.82117765614880617845239393315868387081, -5.40343546123977813986887382433052206176, -3.22201092060795511512430068991121471863, 6.49485729572527291523728458355744666395, 12.90819449388091193336513497683977169918, 6.33974399790994026425308096604482278375, -3.53972472949871203585250149947086872111, -5.7180813999869880979685818344582902021, -2.99140342077670531368818652417963848534, -0.84654540282474936066144807250474230422, -0.14422143714052551275478810426778431949, -0.01543483344193632754083562765749605599, -0.00106051217184137929657541333226590652, -0.00004738274361392153329547081466679507, -1.38796752217005344742140922972151e-6, -2.680584437931952672874097530692e-8, -3.427014213310503688617700055983467791969251280786e-10, -2.90893649656998906138594313091898795380419283e-12, -1.64313978380418496189617628526040764098674088e-14, -6.1874419461607665352913787458658242272822e-17, -1.555470852323293359642929719957443994414e-19, -2.613531695182460422693416153051437721e-22, -2.937791929345723220698708558386089e-25, -2.210981108856706523317549606575e-28, -1.1148306935265758364754434212203144129200648148e-31, -3.768239868315879811749421868910420298940088e-35, -8.54249511297556079504767289891937141127e-39, -1.29936069480536225214935619662955428e-42, -1.3265758000679735358568613149077e-46, -9.093491111271781067487851583160867169138811843e-51, -4.18646800740347483395295585620254158089936e-55, -1.2947674588589012100611640932290620166e-59, -2.69066123108426573426736829436502e-64, -3.7578172173051399345080452721486471255224583286e-69, -3.52775954697312545765279228867206488406658e-74, -2.226479196488505946769779117536402712e-79}, {-1.540415348747607591151320857598e-28, -2.199214743751477845739338160053581e-25, -2.042668218436516857977566012337138963e-22, -1.254480611344581500248738155322416069319e-19, -5.11641886608827987802727003119670232466824e-17, -1.38749903573516308054821770153366506547770211e-14, -2.5014639233911490451935327188381411386945458982e-12, -2.995036281169054787182449414245158106126376506052e-10, -2.377244870318924305206442843108e-8, -1.24753292420034409240259548859523e-6, -0.00004312045720314809251104345077839574, -0.00097631212514719448504189312939808232, -0.01436244094537750711980416382010069761, -0.1355290908873397275374620408192204526, -0.80250406395453323425591351809933238034, -2.85525939734507268463465798612006800785, -5.46796954816157678394561408811904754837, -3.26410387512813811562446147557842923371, 6.55659636867311427420348335240772167907, 13.03951493232104307651531100355426024828, 6.40769701476361677512956085103309707013, -3.56905083039896329432527429452165780202, -5.76986923334810765104285895637170269203, -3.01850126320712900788682309576894195885, -0.85414047517925488155919643228262069846, -0.1454996466349012193283826027727463391, -0.01556986932193408237196737019860356873, -0.00106967059677440323284087620489180177, -0.00004778675479898395338237020563153572, -1.39965681025571718891736315197105e-6, -2.702892728742271520044467712544e-8, -3.455209849500510888665640764374956475154141171625e-10, -2.9326082623489387955830389216264503285117573996e-12, -1.65637094866263137093193602013730316086064433e-14, -6.23676519336010119072759755953734955032261e-17, -1.567750926987052462083302041225603004742e-19, -2.633974407287100951154760592968637166e-22, -2.960567415476698769572059378821244e-25, -2.227976189363987151071347518769e-28, -1.1233300509436131667577065997697418007348739775e-31, -3.796743106070904436698250041026033644929319e-35, -8.60662358190796705192123917712630849731e-39, -1.30904417014830299541416450820795258e-42, -1.3363929911308520096665609138482e-46, -9.160333423346676087216511935500661003095714265e-51, -4.21704117005441212676784552211795476453105e-55, -1.3041637565533090131874510743056006355e-59, -2.71006972744775928386558211711579e-64, -3.7847652488220551271704101780781989039699101786e-69, -3.55291516661328003240209952652496625225556e-74}, {-7.786457050595703127898056634576409929944450075e-32, -1.659158990507008975522652192168e-28, -2.301576797093005646041263199091868e-25, -2.112721351170860627226354842144065296e-22, -1.289162061616577124421360463546793018983e-19, -5.23647590749539999963977079258240072309346e-17, -1.41607072900327511130436761904317466567939184e-14, -2.5477343181933135730530728002927040792250551335e-12, -3.045662089006019589186787734019167889026037009561e-10, -2.414451287987392477100815543005e-8, -1.26580099157403129640607941273863e-6, -0.00004371626562124827423714825829719313, -0.00098913220172728277175799154558902044, -0.01454278781586739191483389739730205801, -0.13716585294285875481406756837378556228, -0.81188045005379259659873236763602592495, -2.88777842443488367628034838571185951674, -5.52959846642210737118843003671706058618, -3.30417692579503029658637165432001393126, 6.61616615282314337382734252660504830506, 13.16582929915535435671145025872366136521, 6.47294828455052357869585479226724335689, -3.59745587605915977616533268221564986304, -5.819861985145198985848451157050048072, -3.04465594941173227100883871479649067948, -0.86147234713210807776966868952272540392, -0.14673383007315699205047695926803116989, -0.01570028277433142417009686737826352855, -0.0010785173133724939011643486308033253, -0.00004817708550945756309669157928614478, -1.41095203165658041118600679291852e-6, -2.724451797994522424102561177467e-8, -3.482461511561981872332941216317120250689466692597e-10, -2.9554895426082389891210927173056868538253890344e-12, -1.66916117821649147285901504799853315318574333e-14, -6.28444729023867762324823347173510473587632e-17, -1.579622867413123959415968168814482138366e-19, -2.653738210072403399299255612740431077e-22, -2.982586834787726953047812068974546e-25, -2.244407156011000793469087585582e-28, -1.1315472469066937231966423841305388961594505699e-31, -3.824299719662104312354726021212995365208407e-35, -8.66862098005800293696176732822614935006e-39, -1.31840559574142067706986616845789429e-42, -1.3458833723251943452644070163826e-46, -9.224948128938156664412772462581687953186470905e-51, -4.24659418830806584884241407828519524660174e-55, -1.313246104160728036212689343830460124e-59, -2.7288288116708140983095306721908e-64, -3.8108102198837407513375067119071362829373452308e-69}, {-2.637951641516541545302979139350930247192145e-35, -8.384700188565190188043022325840218505680634848e-32, -1.735973359748917233089312013995e-28, -2.379943974311160131027260909898538e-25, -2.17061227442655982368171064367387799e-22, -1.319096383949105077929178244034596353318e-19, -5.34301993023258510319617469704274462581116e-17, -1.44191473939718196234953963701095120649358699e-14, -2.5901663861727969066457139535137804214398332494e-12, -3.092566720944578865047404834958928241528220626105e-10, -2.449194760908006900386681340069e-8, -1.28296485911158611323040763884785e-6, -0.00004427879690790122577643284474113222, -0.00100128371986041759333606070945930378, -0.01471427113615868766289346898644023899, -0.13872615091083370673047747869753798326, -0.82083694675438167700845000019400452785, -2.91888805221580762286779143483677177863, -5.58860048253813062916415643961698234551, -3.34243250235664564478039206997822972822, 6.67372458355353861843229552687916275519, 13.28754112810408555674680314027337018656, 6.535723379700856143896407523520850533, -3.62500191499415718963551093138921403667, -5.86819395550283145481006438938395464032, -3.06993854688838988131595199498349563399, -0.86856085059670803968817895187800350242, -0.14792730119703352567582138627477235814, -0.01582642144086525914902868313409921941, -0.00108707576065555702220053549113703059, -0.00004855476499856005935855724781776502, -1.42188286888837895436399298680302e-6, -2.745318177731066719757742614251e-8, -3.508840583614758006538868087579990639923708035536e-10, -2.9776402692397124074638028184921026053304226205e-12, -1.68154399928218757746695285721326422704661049e-14, -6.33061341239027920869185092118492989755635e-17, -1.591117905803175832096617631613344129417e-19, -2.672875234047914325967962378661702873e-22, -3.00390844518695455441093759920375e-25, -2.260317629689374420988882272622e-28, -1.1395041773996302925109865646235193992276036241e-31, -3.850983428023970059444567105443455494278876e-35, -8.72865384851276481740654239787003570858e-39, -1.32747022669569432057422531695243744e-42, -1.3550726594352201475866426804092e-46, -9.287511098470688271610921640742611432484955195e-51, -4.27520786638616913653335329788784543548898e-55, -1.3220394486119822312542096713112454281e-59, -2.74699024747059576559528875705222e-64}, {-5.99292245965172696389391171749522022998e-39, -2.840020214049574800322455091297857666322336e-35, -8.771004434014261444280561319160121318202371982e-32, -1.794695580574276581997045766472e-28, -2.44462885212167778726744004581955e-25, -2.220532200186901542838467257956256007e-22, -1.345642199326939352515277621355165967829e-19, -5.43934127266931735662037265145603732293405e-17, -1.46560646732634924022747162375912785887961094e-14, -2.6294718974397569756832538497434584075027842153e-12, -3.136364362924156746826214263400883509287295818504e-10, -2.481841150803394343433990414837e-8, -1.29917367071983993260940728137803e-6, -0.00004481217783712577487099344972756193, -0.00101284351431592902411664231110391348, -0.01487784352118391646189608841414177777, -0.1402177393493218690184563392939856035, -0.8294141084549789443765298189220292723, -2.94871929965112551115921903059369487497, -5.64521453218194078559877013532879450466, -3.37904351026271284318357179606329960074, 6.72941327375881202377756850089431509551, 13.40500629474073792968161484122997556673, 6.59622041291719440502548433333291746909, -3.65174474454406235315872716449415617577, -5.91498441255886855051689797090680864953, -3.09441209540554952290899394484921052589, -0.87542356962222713217802917287800699239, -0.14908299709156967956992686646159668241, -0.01594859332251562087745029233639630699, -0.0010953666950057375036896491847164607, -0.00004892070422648594935432952958956663, -1.43247557757013496167678229767271e-6, -2.765541842265360870171935157977e-8, -3.534410128952707988864480865472455070747429709086e-10, -2.9991133541271870033547181697058167749257985452e-12, -1.69354899260274931466218751141746193478500115e-14, -6.37537393269395062601571786018584489543772e-17, -1.602263564030614090392983810814782709294e-19, -2.69143138933490471617255199876894527e-22, -3.024583523599107586345869581828573e-25, -2.275745983111868030521261445813e-28, -1.1472200938960252344495373713589059570705646588e-31, -3.876859014139693201994210550174854894901823e-35, -8.78686847115025347264534738236762707655e-39, -1.33626023619991125780900348103670446e-42, -1.3639834204470155596108955686615e-46, -9.34817661208109746081602546107216664447172575e-51, -4.30295306166174961489734199662893749496892e-55, -1.3305656580100172491141043319336004365e-59}, {-9.1336710608922591257440454665975766e-43, -6.45072331893986004274478994656497381331e-39, -2.970285556456445359397211102269569049456918e-35, -9.065919098232079027275391570503825704975921299e-32, -1.843111147244813561282184188494e-28, -2.500356939436036688934297575269788e-25, -2.264769871956457971903705272986004934e-22, -1.369628131915029105954722941164133154621e-19, -5.52760755495703990971705576817398022718029e-17, -1.48754733966314843478307557306065167729507485e-14, -2.6661700128712324451522064179588427375576618505e-12, -3.177519234975826549083908277323772401635752739681e-10, -2.51267514504389777711613615251e-8, -1.31454630533993528814728235186963e-6, -0.00004531976435479345025435354629422605, -0.0010238751217436828566575582350233493, -0.01503430373340317714757190237956042106, -0.14164719507201875541100620538077804461, -0.83764664693273246924004944724125236985, -2.97738509091037273380851463296833249739, -5.69964739748507777539490797806659900469, -3.41415883156554440598540700841649796347, 6.78335956054605857894026386240712777227, 13.51854021997906460452121653486597088827, 6.65461430094365120625518752658349844337, -3.67773474254868904096333167746758480474, -5.96033979401616975324615025963842453098, -3.11813279481707834564405507795435282944, -0.88207617499642868323389394275852464192, -0.15020353457013679005763743068553598097, -0.01606707274877957418657843636733790747, -0.00110340859660705614841055247893413052, -0.00004927571389385393556717030467523617, -1.44275351204808152865892050179266e-6, -2.78516721999831357716518324116e-8, -3.559226181185691926320067574922714487212901736952e-10, -3.0199557842826310321503528275786228835780951899e-12, -1.7052024115345018953146889280478422903143603e-14, -6.41882675300108626400460438146910441153857e-17, -1.613084240607944503125946963176033466318e-19, -2.709447353641608518524227790264929445e-22, -3.044657478807132771685701126554382e-25, -2.290726180239778485069676433285e-28, -1.1547120276426333195267780057751760990613630884e-31, -3.901983762764621896112198832531564741865261e-35, -8.84339414228153766294156146740243118671e-39, -1.34479521383336499617659567083605736e-42, -1.3726355856138134235936047579644e-46, -9.407080865011476241478042277999516262736681024e-51, -4.32989230255651712079918073791731990926864e-55}, {-9.342264844742789494320878382601e-47, -9.8296357523179545933474503224972329e-43, -6.7453943818406379086817316974615569467e-39, -3.069606507684025028980189406246629470271262e-35, -9.308814565572144318636891973251687911484782124e-32, -1.884786647420303678548019442846e-28, -2.549707486903741413831627539448839e-25, -2.304720174101942517816483792422487458e-22, -1.391599532602822882870800093195829266094e-19, -5.60932919607917556088109663176692625056765e-17, -1.50802974872271939577014359896113529948576466e-14, -2.7006525362858125095503626075247806423872026386e-12, -3.216391996702346002340247218244775575895386108193e-10, -2.541923318077906692586262066609e-8, -1.32917930577770950828762205893788e-6, -0.00004580432856699261306308006013072195, -0.00103443178044237723040120023856155845, -0.01518432911262233645711533316377830594, -0.14302015047571643666296027259711984558, -0.84556452724102556355170542170400213545, -3.00498350015465366598508628805980821078, -5.75207930642069031877549164889480894667, -3.44790760126068756655736318672816774356, 6.83567827625342837642604492558757223757, 13.62842377636282645613572222558447276029, 6.71106024129835642916863562452922409518, -3.70301756083192306570359418313155011463, -6.00435551505122902355090237064317221726, -3.14115097829265314958126463972150317687, -0.88853269792907419608040734589139106923, -0.15129125621552690984060315900255400713, -0.01618210524356278975452218551447862551, -0.00111121800020170307045049869675048448, -0.00004962051909349814353830734062882732, -1.45273755180616203150404145111619e-6, -2.804234013096214540287411942575e-8, -3.583338788852296985709535124592137081053653667708e-10, -3.0402095068401204919643173420141020449580372563e-12, -1.71652768148689185470241731527564024172023113e-14, -6.46105918461771580655102192198342141217713e-17, -1.623601683666319738208596688195182218579e-19, -2.726959367768344665697854090388784916e-22, -3.064170746887315512299213560062695e-25, -2.305288451307300806726058812935e-28, -1.1619951306607883480406810027199369211147103208e-31, -3.926408615380255602735688537259919771247116e-35, -8.89834579047890350238177440453170183197e-39, -1.35309256554221978584125838638834099e-42, -1.3810468567235068133307738383398e-46, -9.464344779399965575268388234216494132266021047e-51}, {-6.415103686854931136429245524020157298152209726e-51, -1.0052470446547833251568854159291e-46, -1.02769634775049027113504876363947881e-42, -6.96979773282853398462212532416377940231e-39, -3.151326654028858868416994245245591077982306e-35, -9.517722896293876499619558539261595015701659472e-32, -1.921667995121222670323640271895e-28, -2.594251470333650667365963397325331e-25, -2.341300379672242395795365269488924583e-22, -1.411936017002013520947248798332894692471e-19, -5.68560503556042786772275484221973462953751e-17, -1.52727406449684569242626959106930407318758631e-14, -2.7332234373721927288860529008674880694006380687e-12, -3.253269282364161505874447025408055552830017861993e-10, -2.569769429526024535749464016408e-8, -1.34315232740658074039730799719831e-6, -0.00004626819122278367984571407487693223, -0.00104455861303462305571518016295667967, -0.01532849972586120959202778118550978811, -0.14434147080316083814197971899317521222, -0.85319381438580282806276841881487965162, -3.03160029201341589982017787286682075469, -5.80266835497695910827053849878994246314, -3.48040257187541816272107361293700863051, 6.88647327616978270855955958300483036872, 13.73490816308490268436726285110213054182, 6.76569656716315066901835613860412433489, -3.72763470842839961433469802340321524565, -6.0471174649718528055824783173938827314, -3.16351191630184961227679654012549587726, -0.89480575580134917151196927050201122258, -0.15234826830135148638165969231464685307, -0.01629391152695010735597168606994380247, -0.00111880976670316877012344703360455696, -0.00004995577132490724748087804611365267, -1.46244645063870327170894871562993e-6, -2.82277786782679676066978930563e-8, -3.606792868683627011448569261912542101014037949708e-10, -3.0599121511438028106428624096038757839923034933e-12, -1.72754580701903492919493942060601328083015311e-14, -6.50214947970526690757523884736364613993072e-17, -1.633835375818170368659362064415583592952e-19, -2.743999882430810203159162667141219632e-22, -3.08315951880236946966857810066887e-25, -2.319459840991365324362226411579e-28, -1.1690829525168508625497319468794548257595321061e-31, -3.950179107151801070727121498328635518463273e-35, -8.95182610624314299062231669866745143144e-39, -1.36116783785582587638584441733670815e-42, -1.3892330387311389358828133607053e-46}, {-2.95819751018165165905622417877489971210855e-55, -6.901737155268313088423948115619357362202417298e-51, -1.0508342133659686580203306416274e-46, -1.0617237836203677382411138093891236e-42, -7.15425928691495832388645980265308882356e-39, -3.221556483927891565926017442871194074448299e-35, -9.702479050871168275365341156878792290313400945e-32, -1.954939806328194573684686790149e-28, -2.635021238566257827236792724868344e-25, -2.375148434899246258136647935200846585e-22, -1.430913469477740513374280681093652649959e-19, -5.75726227137408952312681377418764844475533e-17, -1.54545103851070404334451390912165993034953831e-14, -2.7641239829809665486332578211503610688891589547e-12, -3.288383268826577699592177298980859698391814164145e-10, -2.596364920459838616745121438586e-8, -1.35653199143502116232193070807492e-6, -0.00004671331791454001951171889816119935, -0.00105429424858908872033437604741151608, -0.0154673166832401851381197912486565208, -0.14561539096406483343001375572886295755, -0.86055733655507438693759159968906099975, -3.05731093503500785930289820200562329517, -5.85155403854610745572662717409307910047, -3.51174278985016251857411104311802036916, 6.93583875521614378246233655850546141924, 13.83821895562894848138326286210402844667, 6.81864710744102017952812245914413851171, -3.7516240457185332365054437734804571147, -6.0887032553851570463040294402287941829, -3.18525648580583973516336558207567074617, -0.90090673982040302759324369963512962544, -0.15337647227405458893441076660273314046, -0.01640269083309603795029638338059674404, -0.00112619730809464219539993182320856056, -0.00005028205842933576192484072792250996, -1.47189712502899258869161640280544e-6, -2.840830927523667848469717822711e-8, -3.629628908680985600211639498987110207625832808922e-10, -3.0790976231242507197260000852406697821632420043e-12, -1.73827570661768625087690801557011581247600663e-14, -6.54216808954582191845087539976705637562071e-17, -1.643802850128208231673792293505554609112e-19, -2.760598088921357658794349573323677137e-22, -3.101656336942465070216778326482063e-25, -2.333264657585185964805409098224e-28, -1.1759876669905568002434113532528108642709413725e-31, -3.973336133911127711787206096136924900394612e-35, -9.00392728294614444908273807699301529188e-39, -1.36903498307163271638252729579482048e-42}, {-9.162949141277303940643537324952754336e-60, -3.18215197373769891649246193863970708085992e-55, -7.213711203832086450333599140904808155035411627e-51, -1.0854749045529118271061278714465e-46, -1.08966951364683573959143575330101862e-42, -7.31266448867375768200221267158287493847e-39, -3.283627840645086158763634267506919951184252e-35, -9.869067694009285234265073089440235020930913847e-32, -1.985380075138949774404285276257e-28, -2.67273422704978138960815973375697e-25, -2.406727543887124118354471760603486546e-22, -1.448739358382833701007960334583977379025e-19, -5.82494112464427971755924852008797269539883e-17, -1.56269603940032181478500527712408219280032981e-14, -2.7935493708923182821544523383364151936993837669e-12, -3.321925084283160358717235217014405321802509515158e-10, -2.621836324748824381010597880617e-8, -1.36937467795793091390601820740328e-6, -0.00004714139043884125770137719647220083, -0.001063672050690431393904790823877708, -0.01560121625502823067159243137128410373, -0.14684562263827679734288929138537518008, -0.86767521111474800730581158589654816875, -3.08218221511319445325550486353691812435, -5.89886010055048885685628462308403714133, -3.54201574591413674190636561144448023674, 6.98386038334013940058944066326388192638, 13.9385594904067568670345490008255844317, 6.87002315027482418477265938588295637038, -3.77502020580542449250526947713748436599, -6.12918326822622784869676055426655818668, -3.20642173113459305918967337809893979376, -0.90684597212013565660462356644337669654, -0.15437759107993461924862709799649518874, -0.01650862368165539273007129750556611259, -0.00113339277506622546470649948922931186, -0.00005059991286915635881739724022363436, -1.48110489419255820864919698358417e-6, -2.858422292363394382056671526791e-8, -3.651883552103199869631119469348128373125278786458e-10, -3.0977965985192153564810244569058563628660752191e-12, -1.7487344902512822876616723368245329595850904e-14, -6.581178706871495271579100765380358398088e-17, -1.653519951662060878035980062415783109201e-19, -2.776780358068032674274349939798627607e-22, -3.119690588271100565871654396316892e-25, -2.346724844108455994809629573616e-28, -1.1827202592536830172500570644184515579726502266e-31, -3.995916585222870155523516584704731257346152e-35, -9.0547324531961570337675097025257804584e-39}, {-1.9069011217289979688242803664925e-64, -9.855358249307004609830920388104812768e-60, -3.3255583998708010955192638084396075781252e-55, -7.450537235944643875281809727694486243328222387e-51, -1.1139000348031537869247989332172e-46, -1.11365035540004949477204308139208406e-42, -7.452582887112769008819605865972736191e-39, -3.339567445618485835158442890066809538664641e-35, -1.0021417245457921851240967666243269654563304834e-31, -2.013529118637246964629751421915e-28, -2.70791094348209419560568597266662e-25, -2.436385723446294768145071886930359176e-22, -1.465574094450855124037226248553990965227e-19, -5.88914860598160757801500303530011759196367e-17, -1.57911846765932712163652931378066081622722925e-14, -2.8216601161303712752788700754308780375762270562e-12, -3.354054263905668579818646679275345266960432750626e-10, -2.646290633108889651016765303872e-8, -1.38172859438732383767591381400512e-6, -0.00004755386073030025402703948171040701, -0.00107272106249933319094945834226754151, -0.01573058090935131278298215890807739798, -0.14803543917817880309952120334688031319, -0.87456526644155652523662623260063062912, -3.10627354135264359227177620076414737403, -5.94469685158785286038898297913739918625, -3.57129911879460846881367833847482580849, 7.03061628598864042881313247747797272155, 14.03611371010517917822020824118935372607, 6.91992508661668658692055065056739668054, -3.797854955930567082751658533565399911, -6.1686215412803780711401374844763429961, -3.22704133710808020933379980793206669938, -0.91263283814922865254386794795400531875, -0.15535319132958622711439538837302412597, -0.01661187420868697549833630711809942867, -0.00114040721466269635582248280278211813, -0.00005090981867663140593267313810403579, -1.49008368133342554584736417496966e-6, -2.875578404461854563091038941552e-8, -3.673590086127981879262266933915300726707048704184e-10, -3.1160369352108751403580504918436238201864257699e-12, -1.75893769121170500377430811676332197391486557e-14, -6.61923913584383614701998593262617848408721e-17, -1.663001055630181399792668088324619959045e-19, -2.792570606104887621134801344212765441e-22, -3.137288915111195750044240868256677e-25, -2.359860287268202123673551615907e-28, -1.1892906816238278020179056209025846120236898433e-31, -4.017953870926108039284418838231373244464809e-35}, {-2.666830041395205383914684001615311404903851632e-69, -2.05074953564534069761541045758422e-64, -1.0298247670482614072421024938984946592e-59, -3.43431884095385369854132074884387150401775e-55, -7.644712377093851791338746308463877197587216107e-51, -1.1382753602440509813180605820485e-46, -1.13482005903105964786014040770746768e-42, -7.57861753358910608888600631722218174419e-39, -3.390705088403338244408305290362613780397135e-35, -1.0162254450041732034353886007642567326417494078e-31, -2.039778671977463761714992923112e-28, -2.740942143110787674452985111501901e-25, -2.46439181125279266360757905415155767e-22, -1.481544588488661670948373263549431129271e-19, -5.95029405174830497602241574880709923325922e-17, -1.59480819492177308753038988667799395719709711e-14, -2.8485900719421413632324363648344192948535724284e-12, -3.384905584789683433081413365688497686444942702315e-10, -2.66981925977690161613982950446e-8, -1.39363533632896003451062350646235e-6, -0.00004795199230240106002548087468853514, -0.00108146674465746276106756410852952728, -0.01585574805343639560354380851659188359, -0.1491877436789119645942939582320937809, -0.88124338365255337700572982400023888508, -3.12963801268135562326363821859350288558, -5.98916307354414787152188756789333956097, -3.5996622011922892050084959655743127152, 7.0761778925066697419388744224829283478, 14.13104856892758758858919568923442462338, 6.96844379393691601506259806596676542437, -3.82015750908320798555817535275051394493, -6.20707652076693840854018593624178457537, -3.24714603051563128146070842420215708634, -0.91827589891461409323966627738031869003, -0.15630470207421765251831335329296579501, -0.01671259213952276153469298318668193595, -0.00114725070359324986275968541633458877, -0.00005121221732436776117105266625056977, -1.49884618350862669696036129754346e-6, -2.892323372602987706424112750498e-8, -3.694778853543833446527134626010880326300885136154e-10, -3.13384402032144471904659659749808826250387094e-12, -1.76889946111772823183939289028232045605550278e-14, -6.65640202325483007495226071260579352177176e-17, -1.672259250607283379497124306644925187631e-19, -2.807990601771640623857093775039301633e-22, -3.154475559743961962941040089828795e-25, -2.37268907649986045086549500547e-28, -1.1957079840884917860959616331962616486501615696e-31}, {-2.50678466839490186818509906369740399842884e-74, -2.8676795303390013623256884223405769682050829784e-69, -2.14266523723530435519941907841188e-64, -1.0633839525092533090671611227301022401e-59, -3.52342357020681888316518213655910593704003e-55, -7.811112447769276120355805089642542163661603221e-51, -1.1597811189831429067723050128825e-46, -1.15388003767084414084024334020089842e-42, -7.69378748909071006003639227265770867607e-39, -3.437963332234246195399705408642955642186804e-35, -1.02935550271706034300941882753872232835256501e-31, -2.064422608985395210001585885206e-28, -2.772129435642829358472148934316755e-25, -2.490958314927768187293617139096399715e-22, -1.496753207708089134080877188278373434341e-19, -6.00871341286660428562140925571877385761104e-17, -1.60984009610305361472252049177061199912921273e-14, -2.8744522215265170669104357244686782544877441798e-12, -3.414594114069273031832116720995645557200626742386e-10, -2.692501031718574599439455283079e-8, -1.4051310851815758268150197920687e-6, -0.00004833689255969936439366701208490985, -0.00108993155897209828624046033905063043, -0.01597701703632586820800187638369584565, -0.15030512411555909861454000810515220009, -0.88772377599763154294620059093398722623, -3.15232329634859019154487514896867908184, -6.03234759516715290110624716437979010193, -3.62716707508056504296716058317662747073, 7.12061067200786185961500773796217690259, 14.22351607649002330933612673988453053187, 7.01566180753681264285540609269012889273, -3.84195479394974379263262573691330294752, -6.24460170441790446918573082275122812382, -3.26676392269493788898336322082864101865, -0.92378298668524870327497510917200251495, -0.15723343080377696761469253117133800481, -0.01681091446844551127269935912164275635, -0.00115393246163740998475996390829056075, -0.00005150751271505162913734535528113277, -1.50740401588481728854860222259913e-6, -2.908679247779051407434293229378e-8, -3.715477601792449996587254975342712002766945124417e-10, -3.1512410642565758416484340772642558664733228144e-12, -1.77863273498912764256597816415147066652599774e-14, -6.69271547706641005932547861381841057237637e-17, -1.681306493419920210262866268248552740353e-19, -2.823060225766986265772351829201607991e-22, -3.17127265537913549194027019677435e-25, -2.385227722580989581777936357461e-28}, {-1.58403771921157108857215136289488726e-79, -2.69529506148836978646433573095157366121804e-74, -2.9958929334346045437153866047934796266279061334e-69, -2.21225417200326823468195475636096e-64, -1.0908580203246226572392299477258000103e-59, -3.59973415833208873149982340949674769317017e-55, -7.957843026554378117965360788156333563497865307e-51, -1.1791346670843586164270641091439e-46, -1.17129018713022936873823604534458296e-42, -7.80018638064867810379004212413594959219e-39, -3.482010284126295741933614249500728797454605e-35, -1.0416800198274910233492292841655247446931161588e-31, -2.087687597306219775855240293686e-28, -2.801711045525208775560321639591872e-25, -2.516256500320997020768725584595057684e-22, -1.511283893957256822476678453360130331722e-19, -6.06468633769122976623361972405957854465008e-17, -1.6242773190203022317556677860559094863961904e-14, -2.8993429511267899963093193667993353836532747982e-12, -3.443219008499753410645698982541291629205054665506e-10, -2.714404479146384501406270570952e-8, -1.41624754069016351114305681178116e-6, -0.00004870953832502210365613963181123102, -0.00109813543553202720152138334470149675, -0.01609465481751261297562431788410096937, -0.15138989842245728899244344874553754307, -0.89401921921330529744080845554160640394, -3.17437235706099120289106706539366719748, -6.07433060519896160524376843207000711839, -3.65386958744514275119820959944905353834, 7.16397477331237131228310830281629961798, 14.313655043310000440716461158096942689, 7.06165431720700083648389922407093526859, -3.86327168979997529897627522542676997463, -6.28124619377219844600788219522460954609, -3.28592080336743405767554378195104295627, -0.92916128702458612003031875262904476462, -0.15814057715134747737184705723896339141, -0.01690696689658836311618933970372537019, -0.00116046094865706160586221389955426038, -0.00005179607544662966740316766644205943, -1.51576783495160665923123315785046e-6, -2.924666258353563344911359035461e-8, -3.735711780635421645026243647916981253512580319657e-10, -3.1682493512833135681697680275045792090909469894e-12, -1.78814937182040592569825376781424356769528876e-14, -6.72822359279468647859909147345682311988367e-17, -1.690153740875014124198977401601121757975e-19, -2.837797691278911294006337235648663762e-22, -3.187700473339558699664332026444136e-25}, {-6.729861350542419372650116988118e-85, -1.70298840315708971777744825074033981e-79, -2.81552146086523214144273923435070847339813e-74, -3.0928852484457216700919768648008598235527868124e-69, -2.26918514151836266754319355361641e-64, -1.1143729012008205525231901513900974523e-59, -3.66698894718214173611645378254120020208462e-55, -8.089829793769424967140484550076217073286866615e-51, -1.1968062219658045451337425722077e-46, -1.18736931207140760839821610775846388e-42, -7.89932967393954538794964661957504795047e-39, -3.523346552612946628143915521955020777601634e-35, -1.0533131710740892040919472562913847551148210158e-31, -2.109752541356697444128568888561e-28, -2.82987881719886751921253257127361e-25, -2.540426693989616363479809676444887429e-22, -1.525206464274677847572962743507677960293e-19, -6.1184484869356619432113902943126881190086e-17, -1.6381736945255082724621411057093140552516493e-14, -2.9233452629243561614737216198796124692646618049e-12, -3.470866422568365045483274234880676298586620592239e-10, -2.735589616932325113263824510948e-8, -1.42701265678291956300017845129702e-6, -0.00004907079624584150845861797013419835, -0.0011060961504992790680602067607932864, -0.01620890059922721136572713168866639585, -0.15244415166415994186498359906244792602, -0.90014124291521396801798412062084872129, -3.19582406645287138857097419894891095883, -6.11518475410083153154583092989966913581, -3.67982016582410930892095585495726688762, 7.20632558298728492561527856622288994627, 14.40159257849248409752495338179777916184, 7.10649001943528791087014959386023951004, -3.88413123169630942600361157194934518668, -6.3170551707530366264104847290341451692, -3.30464039388769310066445003934530135452, -0.93441740945181062939251046798164274819, -0.15902724469166128913574617767533279352, -0.01700086506915159112434439371733012317, -0.00116684394801581156085774691352593738, -0.00005207824647738805746810568145389202, -1.52394744432434404554419576675608e-6, -2.940303011850760555283118741187e-8, -3.755504797396746216660850619076772642450286129166e-10, -3.1848884542471810708682804975361152725013000187e-12, -1.79746027495686389495943667548077318647798931e-14, -6.76296690397880404319861943476790726935469e-17, -1.698811062423209193672488803620784073074e-19, -2.852219732491835571215996115803085862e-22}, {-1.922640311729831605959876906966787502568918041e-90, -7.234554443735179565164944032439e-85, -1.778785950377632100893529085067148985e-79, -2.90640280953344756599744139992275858616247e-74, -3.1721822261087983175430058476438590058905477656e-69, -2.3178835926612682505910101264105e-64, -1.1350867450426918963760643096225145246e-59, -3.72745931846135762913545508619260395767627e-55, -8.210300683060446250204579485091235281273174381e-51, -1.213121636769864470589766136646e-46, -1.20234808316293920119441785824464543e-42, -7.99235233541362095853667002441347802039e-39, -3.562357792871140679596773290536349708632177e-35, -1.064345014516513283746729520912428327903861777e-31, -2.130761414011644983122033817752e-28, -2.85678982229611591463943652169091e-25, -2.563585521374875395881880002280197841e-22, -1.538579709205667112493676239931094612971e-19, -6.17020060446294326316941644905192100599919e-17, -1.65157554703517501591561928251757011834733303e-14, -2.9465312316129045461465024164223852831838459485e-12, -3.497611767732004131458495900482014200144731413236e-10, -2.756109348635832398673222009944e-8, -1.43745122914283713952906693923027e-6, -0.00004942143928208312073988232496927342, -0.00111382963459904702130753231483035182, -0.01631996964463031550586966978819767016, -0.15346976692536733266101530006987101831, -0.90610029075298622743752942424368042986, -3.2167137158813756241888725598756877535, -6.15497608414931789952910880421470257797, -3.70506450424126385674922297077219257798, 7.24771421333753782397172629465118302905, 14.48744538054359272395049300083098396054, 7.15023184948601352212280932265807843038, -3.90455479045560762014439442227844852654, -6.35207031073981378949177789189974465264, -3.32294456650513782835743895107359669349, -0.93955744858949494012365231989839657565, -0.15989445114652796608126261084162279205, -0.01709271564503158380739848151272167409, -0.00117308863865838112283742843936931242, -0.00005235434029087749870676798714773472, -1.53195188605017418272125822362086e-6, -2.955606668982857842058365645624e-8, -3.774878236945379361779757175402723428358924800318e-10, -3.2011764195089110376158318390409248502692402575e-12, -1.80657549571055395655875705450432748124086531e-14, -6.79698276969921008030117624714480293512571e-17, -1.707287737023169564342984044886067790308e-19}, {-3.693985312219938381722773240257039206803e-96, -2.0666436567609567879367677666094384733494399e-90, -7.555890391245737511742571909402e-85, -1.836041477518097711728571990955033209e-79, -2.98065651953022092023174268536591847811196e-74, -3.2399745222083745208269956815104051391068984332e-69, -2.36076020541459900946641630387878e-64, -1.1537031340317914655978526922585316693e-59, -3.7826334562369952129539873624690725228196e-55, -8.321491958952404940469641020574865367476370307e-51, -1.2283165961872461387004654823601e-46, -1.21639917871888402967110827432215731e-42, -8.08012826336301743579962628666103535236e-39, -3.599348023496187299107469364649131762170752e-35, -1.0748479781508243490160849616705991984340793579e-31, -2.150832012479977241974714831094e-28, -2.8825745112002642378631440453565e-25, -2.585831118815227869835316700548747077e-22, -1.551453673458846643049794020160767959098e-19, -6.22011532616988993980119703392811179783967e-17, -1.6645230776324782024165816196497914955345436e-14, -2.9689639109710822469338350600361314339149857601e-12, -3.523521491177690007774100166198411612290035432214e-10, -2.776010586437936620453023703005e-8, -1.44758536946863027631515297514724e-6, -0.00004976216015758444215997135896400129, -0.00112135022723136735190227351007793685, -0.01642805644994507834257621862162698048, -0.15446845116605283346432114706652533605, -0.91190585530899291169696124855247846223, -3.2370734505157564737866304448452394151, -6.19376481918510117978108076128061238432, -3.72964414351991551810690560675518296796, 7.28818793034582401154290941138818503836, 14.5713208546080240547239556944964555347, 7.19293761305323875420137434841560536077, -3.92456223103066229510114469279958328693, -6.3863301420954703644233612418745127997, -3.34085353501035801362579495321526065172, -0.94458703730816671912161398538224679385, -0.16074313725118621544629898866721304574, -0.01718261722570177743297565433166459454, -0.00117920165767457883125325871655432834, -0.00005262464764153466595287384892315162, -1.53978951977164954336525003708063e-6, -2.970593094443940370973936879854e-8, -3.793852052194277560226286032091663487962334208406e-10, -3.217129926999086793414319755555077427369970917e-12, -1.81550432298304709981673893222222946878917498e-14, -6.83030570957339817073263797469439741502204e-17}, {-4.773606499244779179930170081478257e-102, -3.970331600090435815180067404646245007186e-96, -2.158258698440204721162482742857113183481646957e-90, -7.79845311885289649712054909543e-85, -1.882793157181117374980871658829665698e-79, -3.0441031894024428872992314526369494091187e-74, -3.2996341662209967579787907245828604718537342851e-69, -2.39927930350946256353704225918331e-64, -1.1706829623888520414700301322645017907e-59, -3.83354209213344555089964664796300025022111e-55, -8.425020556152459360524338696153426106474569309e-51, -1.2425674626837289448500288950855e-46, -1.22965549589551975728182606862545475e-42, -8.16334600676933720783323304377872084142e-39, -3.634561606328286165740982247466141281202843e-35, -1.0848812850731801082235605210077159651708756745e-31, -2.170062105388427401702163293188e-28, -2.907342580220393361613685473957285e-25, -2.60724696800184919875150817368720244e-22, -1.563871366729514864442498493906943224428e-19, -6.26834237744084795907536789578760953672342e-17, -1.67705143657463466690290883611054007158721045e-14, -2.9906988335384620936908258966590253787786358036e-12, -3.548654493259054663433456045345398952710686777564e-10, -2.795335154208591125634631440793e-8, -1.45743489204079030206452253689449e-6, -0.00005009358243182333125297721763701936, -0.00112867088747174035332916679933932445, -0.01653333739906217011712307103631089198, -0.15544175700630330505030860261983371134, -0.91756659241805142908684365911900018209, -3.25693263888939787849697164310093294499, -6.23160603881677886012480829218056960769, -3.75359696493909915791395732199144167342, 7.32779053000489001697922679943429911685, 14.65331808336502253799472717904973230041, 7.23466053353928306687363577781103885791, -3.94417205236488086206944308458446175361, -6.41987036032403174316597523087110401995, -3.3583860211672271852832980833305531662, -0.94951139310374459632199306878552977707, -0.1615741744891786572505741015752594508, -0.01727066116525548318756430422543445079, -0.00118518915483550684922124873261900588, -0.00005288943794684562053058931799432979, -1.54746809166314269661438491020874e-6, -2.985276988150967721150004970172e-8, -3.812444729805877915752208876644432474280382053417e-10, -3.232764429364196849679015488858004851212240819e-12, -1.82425536113781817273301658785128506078036878e-14}, {-4.1495150976949060707834618539787061493038409483e-108, -5.130318027716058550125501883350197e-102, -4.146013570592908124268169851613440621735e-96, -2.227369847446772055077554118596425382319052003e-90, -7.996401438753888541920120489882e-85, -1.922719925030633073078479590239148357e-79, -3.09991311130481030277118414178326610389251e-74, -3.3532092228357165877185656391647542876528499139e-69, -2.43439996408498657880263842139658e-64, -1.18634537917459612187956438747845754e-59, -3.88093028491758545287854845878895730555941e-55, -8.522095999924076661676729895786493229757026107e-51, -1.2560099127187659430527199198715e-46, -1.24222169561905640216661384046034489e-42, -8.24255871217077257021281369117523174444e-39, -3.668198238124089404757454780272319006104693e-35, -1.0944940593260059604245490663512600756887596978e-31, -2.188533855611488977124538285886e-28, -2.931187286065642100500096446558668e-25, -2.627904770761778049509919453075569094e-22, -1.57587006876138643230579167276018514924e-19, -6.31501260036837352143335858291716069464914e-17, -1.6891915661941078665154848843515377324815682e-14, -3.0117852045751282482790364115271878976767476726e-12, -3.573063269390864796021383368304756464605190905134e-10, -2.814120522917516680106043874059e-8, -1.46701763163402315631065826752681e-6, -0.00005041626968699671230398965169533488, -0.00113580337056811223445907813897874307, -0.01663597299999253558376291592413080165, -0.15639110119467283645191712402171065148, -0.9230904185978242023784571405878601256, -3.27631818917825477599452000110093391667, -6.26855025689630084199165433278646005625, -3.77695761233664414924028658692047097015, 7.3665626701820658328804088282753979469, 14.73352867397765569607765724839383977452, 7.2754497281074211547885625392243715299, -3.96340151127672841790325315069029827094, -6.45272410360540315773836825555079461326, -3.37555940055744246106646009467513833164, -0.95433535872518182326758107687252168209, -0.1623883718664486322645056577844244937, -0.0173569322796065812639772317898323458, -0.00119105684032256869325295299340117056, -0.0000531489613800171605401188134634495, -1.5549947947081467031480782706064e-6, -2.999671999942321495908844866273e-8, -3.830673434936680988279447974655997842278432442297e-10, -3.2480942734486045891839890121691985141384584776e-12}, {-2.4265463343475802039566365196099681174185e-114, -4.4592611732850775144652899182793862642843778594e-108, -5.356931589065059376259948046958343e-102, -4.278459378247565564791272270542245874756e-96, -2.283738109451874956675949974970605630964125743e-90, -8.165369185523165965860928506776e-85, -1.957825490351384676530345893164063375e-79, -3.15001164814825291114169320886684641026626e-74, -3.4020409083892576183011771823896486223272457767e-69, -2.46678617551579101571554146973641e-64, -1.2009210208117708087629236582329824363e-59, -3.92535519052489858109806715523151496728654e-55, -8.61364843780703218540314540028376760390214789e-51, -1.2687507504057166020742972144352e-46, -1.25418181723493085520514816954165522e-42, -8.31821818520916880674826491509038387697e-39, -3.700423470229422086417320263270493314849605e-35, -1.1037275598789895973873432135818169946066510677e-31, -2.206317071373168623039435777494e-28, -2.954188678958949147853337782273064e-25, -2.647866640760752277208488882633708312e-22, -1.587482339893201957369969513358581503759e-19, -6.36024111643589337355854019535728613519194e-17, -1.70097087142016431115727901954778798730904256e-14, -3.0322668630907637442940966488305620735135573531e-12, -3.596794839134866224953153390122856702494896140396e-10, -2.832400414928415104679517254317e-8, -1.47634970711550313214528237293205e-6, -0.00005073073320818837183185375324139369, -0.00114275837658131253388515755619384888, -0.01673610978076240072002461259402757255, -0.15731778035450048467461776450513545635, -0.92848459452489034465263965482951829041, -3.29525482122857246852272008835264573212, -6.30464392021346135840707247951436649403, -3.79975785477729873107861347611649858273, 7.40454216406465060193883877621917546298, 14.81203749960349533995147136044323526836, 7.31535062333620988924063683628547592608, -3.98226673252502220602408011401815202075, -6.48492219530617747455855105899774298955, -3.39238983084224738523464399297773136753, -0.95906343789438522130463718746875196195, -0.16318648186581566189072184830600367217, -0.01744150946971496799956047198286880375, -0.00119681002665660914140062448846896921, -0.00005340345070764981396676866884873029, -1.56237632160907025616946363812743e-6, -3.013790830211267406240722070017e-8, -3.848554138172247682749017934040450926310943746817e-10}, {-9.54680905934480973002993632856801e-121, -2.6074964430825213759774245334855854718797e-114, -4.6559068694647889875693523801343593658957083245e-108, -5.527672992228120109306185567300201e-102, -4.386427038807437419399063249847786153459e-96, -2.331830904516545472148640094135824141076007898e-90, -8.313870920073966224635801872099e-85, -1.98932663967573197146065920451376842e-79, -3.1956595065641435509805614776814858957033e-74, -3.4470576123638554590866314257863280372481021269e-69, -2.49691766711368397924271076445767e-64, -1.2145823090636375981165217685097682393e-59, -3.96724512888569135088857126830106524937116e-55, -8.700409796344258156550264053950034500835774358e-51, -1.2808756987573850172773612620215e-46, -1.26560447068120600505730424093644233e-42, -8.39069878716936967598414636469213029039e-39, -3.731376273275993834684366682519146216819188e-35, -1.1126168222285410246681855742743598297652589137e-31, -2.223471641509484018976169782407e-28, -2.976416066307270085352027058590351e-25, -2.667186799615453493301705483414058675e-22, -1.598736814141574608480837726303843482057e-19, -6.40412984055901132368830359075005144426626e-17, -1.71241375906146956848384689602642449985853176e-14, -3.0521830631304178052912582623597301714706419189e-12, -3.619891509014346663423880781852945760526579624118e-10, -2.850205304664409513293541196646e-8, -1.48544574165712311163740679212875e-6, -0.00005103743844799649698452577030168417, -0.0011495456763536746776476648117278488, -0.01683388190589405734474178635769058947, -0.15822298448091718366678074297019888253, -0.93375579690911937824077260485300913764, -3.313765301613446445252098271184630103, -6.33992984032982606054395390101015435191, -3.8220268995739789853369768735318108403, 7.44176424032133687189193792420977926, 14.88892335083678872901124774176672971273, 7.35440531943605989280290489268998472203, -4.00078280687338165457886179869368157907, -6.51649335813591612693546092827892838169, -3.40889236494374778265584963696536297431, -0.96369982681907602822307828613642092167, -0.16396920569918302629134319078791981335, -0.01752446627118566898221983112490743163, -0.00120245366566314081892767939818551326, -0.00005365312290930253293887194829435259, -1.56961891139944416449555619409157e-6, -3.027645318524718947582823813892e-8}, {-2.5272093568719117250695837350483991021674250133e-127, -1.0258042790778622669722943341267548e-120, -2.7223014998204358775128502961254757154538e-114, -4.8039849426999420408513361457498626562373115323e-108, -5.666787626832954867448637953638303e-102, -4.478501742112493198230561091065080147419e-96, -2.374081224255194522856817707619027662719285643e-90, -8.447076908871229150244079775505e-85, -2.018020025000019775966468516303425626e-79, -3.23772921263962070615340930638669819399469e-74, -3.4889299571283425695980602587036407189455963187e-69, -2.52515298986596967428810836345266e-64, -1.2274617551041371989896566682069160539e-59, -4.00693702393063366162358730652265192228827e-55, -8.782967301341504624652856240634464865200902932e-51, -1.2924547117080693952913033997039e-46, -1.27654647859205554869602925463087965e-42, -8.46031461532364111378494050037055913373e-39, -3.761174594413126304059671450362878655449067e-35, -1.1211918876201499798326508730794110417025794109e-31, -2.240049390375069907465576986329e-28, -2.997929918319571493882016065331345e-25, -2.685912907235818809023605547826333574e-22, -1.609658829215803991135914009914339885752e-19, -6.4467695016151215933930034380717426655627e-17, -1.72354207589307954150414552349609493446832088e-14, -3.0715691147416481366994987751862281100222412408e-12, -3.642391504033936416454468624702853562940670697565e-10, -2.86756283657186277643771900223e-8, -1.49431904798205580820431540537064e-6, -0.00005133681050264470514454672450468222, -0.00115617421888743584678478889866015421, -0.01692941256206268005831149917297453404, -0.15910780856740448054361821874400091823, -0.93891018066575993550565480558568363195, -3.33187064763065794598453571296943595401, -6.37444756908648249030016883710191943265, -3.84379166361842132411153341577072368689, 7.47826177434967724008079415372546947381, 14.96425950990542145873173702052807028084, 7.39265291047920555361343252128679510819, -4.01896387869745781159603622346111401268, -6.54746440386200606087146918656443993818, -3.42508105124005908208569288253872811791, -0.96824844208450448868524647465319917044, -0.16473719795553580441584963367882430064, -0.01760587134055182880166716032103225432, -0.00120799238117101687592414300911821888, -0.00005389818060969684407220126932797651, -1.57672839064956156583924116215607e-6}, {-4.501630018562812965012482066798111279492e-134, -2.7153140372000160272210587271139296190274059315e-127, -1.0709016020307605120596520260468676e-120, -2.8087050086211846383781824950470032691007e-114, -4.9245751980135975249954307849415158147576605116e-108, -5.785372197694223900961011519870927e-102, -4.559358936193524642287673847651729412169e-96, -2.411966360365133591863679502712178031123750304e-90, -8.568371894914710101919340508856e-85, -2.044456927973401850516528435262519893e-79, -3.27685092169057427400998857407113837160783e-74, -3.528159054055032094202138491345642741981201693e-69, -2.55176762559014821971270671271863e-64, -1.239663561423547583466740818480226041e-59, -4.04470109279022776531141951344583399390006e-55, -8.861799964479613300116068911873570260685832213e-51, -1.3035456998060060616514748595796e-46, -1.2870554943094175573933561418752986e-42, -8.52733212110632959240579463661295862461e-39, -3.789919517293595750822456822285217708442593e-35, -1.1294787389861465837112108163379676489652164064e-31, -2.256095511959324228629181185549e-28, -3.018783361909128728850124756217349e-25, -2.704087118017279277156967218067919696e-22, -1.620270932533510504771512132654891598344e-19, -6.48824128268537097690377698873487642049276e-17, -1.73437546780259258438403591686863354945093327e-14, -3.0904569142305420430337672849768146707695075363e-12, -3.664329494509135330723689919468699221187549283557e-10, -2.884498176491297213654246975612e-8, -1.50298178519962130372039879733321e-6, -0.00005162923877811892529008995689646507, -0.00116265222337372814855569698906087711, -0.01702281515184891393581745897396075247, -0.15997326266775480587884088164601499595, -0.94395343292908535220803031574085651255, -3.34959030507404830862243956739841051513, -6.40823372642596697636930514953622564068, -3.86507700952733693238736666787885590384, 7.51406549433774334981913305630469226806, 15.03811425836865299837577084281539800932, 7.43012976686741149411514260177327507364, -4.03682322445067393748123491050180455891, -6.57786040187725878365232599792936641471, -3.4409690225350459158118737413656826023, -0.97271294541627707289970333926663622386, -0.16549107072705737265418666955787374786, -0.01768578888689152898189782967942613831, -0.00121343049802916316057840243585619542, -0.00005413881334931674142048811247869534}, {-5.39602335435641709719381838418559e-141, -4.836403771172608836525639662492295072001e-134, -2.8345167447825104842908237000337508732018488101e-127, -1.1048246756727315013784909923295764e-120, -2.879036332282790524058876207322058516326e-114, -5.0273255666458987150659777711570954889453504685e-108, -5.889469793275756998106435368135701e-102, -4.631837372111578438545596621976492957484e-96, -2.446453348575365162773417438504041472027077349e-90, -8.680097828476986031298857523472e-85, -2.069035430370842958757768762705083389e-79, -3.31349541067731224250989804070058404102541e-74, -3.5651298220025437805775059410744602505377828352e-69, -2.57697814174410064402303757865761e-64, -1.2512712722058537766411371932258055087e-59, -4.08075767609345168309616711284494027953562e-55, -8.937304171196490259422023974066128250561624798e-51, -1.3141972079088846110494557419212e-46, -1.29717192430830456409921354237405194e-42, -8.59197955330467687304671918414299607677e-39, -3.817698428509026530335214843036929918176468e-35, -1.1375000242869577037962159424446490188827034382e-31, -2.271649693651762061877981553505e-28, -3.039023366129543005497318460134104e-25, -2.721746928664913414802968127975401109e-22, -1.630593291739590261643383270336339179412e-19, -6.5286181648341034079113093794772196206334e-17, -1.74493167669743124285640881730670304524683558e-14, -3.108875386209720425553768832896958205250575476e-12, -3.685737038666482687763764044052772094110258803858e-10, -2.901034308961843636588336141984e-8, -1.51144509237783225294277410435996e-6, -0.00005191508098796293873092231159743339, -0.0011689872584659658138011023086082845, -0.01711419432699099329693371833975633828, -0.16082028064202281720265139197711821971, -0.94889082017036100236545786519090007903, -3.3669423037512271061348589302834153701, -6.44132228765516775948447416665598771135, -3.88590595195445616874994366280877291036, 7.54920416532877146364556214930641513853, 15.11055132735903928610164793286825234852, 7.46686978525969552198189509992678386835, -4.05437332311422615670897071211332332509, -6.60770482940533556977550136592867678018, -3.45656857528954005266121858033879473015, -0.97709676572971744839202572046648718366, -0.16623139728279880983151034131741275317, -0.01776427905606888362824509921446575967, -0.00121877206793375359720483884912126231}, {-4.35292284310493210986875064433871543196285563e-148, -5.79697893309903215377340994431333e-141, -5.048433663819934325698276565012005364701e-134, -2.9241386190907956710287815167588078070765086403e-127, -1.1324251496026309566983957428097768e-120, -2.9389384923923749031785733880790883574192e-114, -5.1174900778266094533262416083445449715401662869e-108, -5.982749386086073106236786947929722e-102, -4.6977951598379376755708246196015735422e-96, -2.478211221611015691397126190797191294955313799e-90, -8.783945591416911930315041375573e-85, -2.092052876741565385060852840379834737e-79, -3.34802421692750555126740902741184613641726e-74, -3.6001447819210448534174444382834819277066997746e-69, -2.60095811878161073623384583714977e-64, -1.2623529881934540855508518471518294752e-59, -4.11528903993218312264563881134141384626248e-55, -9.009812068660884089476316222178119158868078166e-51, -1.3244503811021476575224840287222e-46, -1.30693036658661792445099892542564424e-42, -8.65445414391843793528554105548506231718e-39, -3.844587463962530092760738232716278154885289e-35, -1.1452756230943134896171494997951299796473622091e-31, -2.286747007562645167325990391224e-28, -3.058691693255822086739273075801999e-25, -2.738925865623102561748023953212289799e-22, -1.640644030820601446581912889141994665348e-19, -6.56796603730044874896181705915157631650445e-17, -1.75522678785909303639278658153536631671707001e-14, -3.1268508547317030941026723812954062296950042879e-12, -3.706642956911606670363594791093214836800673292349e-10, -2.917192290292126096497907874182e-8, -1.51971920293474422988963819068069e-6, -0.00005219466659599277303496004872580753, -0.00117518631088907343367657600999821519, -0.01720364688665024145308204673241041757, -0.16164972778980693202295037556813337321, -0.95372722945912900891951128711481845031, -3.38394339403201201615481197835482378284, -6.47374483605887940709166469233025690423, -3.90629983849202158183808031124576608959, 7.58370475402343061031448276579065062218, 15.18163029801007653957386280094410552509, 7.50290461035996353262766879243276537546, -4.07162591959800277074910216702454258002, -6.637019705708320347104340208901119562, -3.47189124037488429721779045663315300136, -0.9814031188178230222887612007597490709, -0.16695871534871315823439834770528335666, -0.01784139827377083872195017205453024352}, {-2.3632896861582918767012764118426838522e-155, -4.67611487965605645111155591862135041600666203e-148, -6.05079054420479902122981785431233e-141, -5.207770904662745851753773728517637515125e-134, -2.9970250744680300677276584305128096130207344042e-127, -1.1559235943288969384848067292281639e-120, -2.9914845054235995891231415834000996146162e-114, -5.1982585211013040396147993554368209657047543919e-108, -6.067612352411594634116869463630271e-102, -4.758517687334003774544922610020260832006e-96, -2.507722956222030660944360595302501626084759132e-90, -8.881177966940898437610398140753e-85, -2.113737569216066156996670269156405782e-79, -3.38072141713821208082997792662792032100476e-74, -3.633446340038382042887650916599830879846934852e-69, -2.62384900650918074582247614619338e-64, -1.2729650232571954941155744662589539579e-59, -4.14844785609781015801683100103861523595158e-55, -9.079605063965861806937718190870955139338462643e-51, -1.3343404353551008458617747180632e-46, -1.31636070495914511727693981319868983e-42, -8.71492765831700718993267849990115112276e-39, -3.870653424418590471013808273944394068084722e-35, -1.1528230957994094509027339038945045463088644674e-31, -2.301418625306511209315414989816e-28, -3.077825669542542641431111501185225e-25, -2.755654047598133998669513633374030614e-22, -1.650439507627694379512893062120218659874e-19, -6.60634462183093515688927161327585734387111e-17, -1.765275437486832981157410186046370989203231e-14, -3.1444073569337348422312986395320688829335713421e-12, -3.727073650233785189299470746565886645830349513401e-10, -2.932991465183912903352728173602e-8, -1.52781354310939120185395019356545e-6, -0.00005246829979518270124084238391393498, -0.0011812558450826826691041981783759759, -0.01729126256155235527014326665585866604, -0.16246240753818348513939336785143898124, -0.95846720472746991673363063397625407312, -3.40060916715717220818833278851811640225, -6.50553078578910348134452145670330100703, -3.92627850883758415042524469527353200288, 7.61759257667106719772879399780602443185, 15.25140695855167073572256012641800812841, 7.53826383228643304944105924700862384881, -4.08859208192529928910151318673603958513, -6.66582571231138920223880201428910710501, -3.48694784642221517109438877670533953744, -0.98563502497738384578363426528140109079, -0.16767353004407247802855768584486525786}, {-8.63586260991882025578218239983e-163, -2.538624915694345054035901595863594058e-155, -4.88059689308405457637686543742907138703073475e-148, -6.24143855733915642742707390066221e-141, -5.337300401161503859518315949310398102997e-134, -3.0590554403834503745194941827783653937979525157e-127, -1.1765292538630305052940959586752002e-120, -3.0385399808970717383462573861714093161173e-114, -5.2717185229564325012008300832204914932907203023e-108, -6.145719752991702569436719122292752e-102, -4.814932771049388497392710117974845710447e-96, -2.535349194586816824748181379358789834189080339e-90, -8.972764345865894058308544631954e-85, -2.134268856314884696696961024967779651e-79, -3.4118145811747947568766588191646583832518e-74, -3.6652319759097719165424134631005886635147323771e-69, -2.64576773591330741855234935964549e-64, -1.2831545315719366116074085276660623199e-59, -4.18036342646949143896359600306623789417199e-55, -9.146923920179234207105184505531271893505581375e-51, -1.3438977761342587062479815228836e-46, -1.32548895404740968790354955662184551e-42, -8.77355073979285144645286788359977451443e-39, -3.895955293684360592010976971764647674310746e-35, -1.1601580437032775652151013496817844987933094502e-31, -2.315692396999035324498798719808e-28, -3.096458815615606739291345734920638e-25, -2.771958649768827529554997420807153296e-22, -1.659994544806242588113041323617989568838e-19, -6.6438082477870507211095707999596032774829e-17, -1.77509098798958766076578496513280027852737235e-14, -3.1615669097167864839651751048662476272593460014e-12, -3.747053372612651323420042421540919315241613270173e-10, -2.948449653124627963816790445898e-8, -1.53573681713738161038534802439828e-6, -0.00005273626209676125762177407502965625, -0.00118720185526606792276571690111831817, -0.01737712470116677525139486273309868155, -0.16325906732275515071776338061834823625, -0.96311497875227045747776951450664289167, -3.41695416158723260991382589469001367913, -6.53670757915423493660521768970910214837, -3.94586043529535302475144690950848029498, 7.65089143207703947148078154688185017954, 15.31993362359253309804371051425150389032, 7.57297516268326974836921132364730664211, -4.10528225292126152870516027707761744797, -6.69414230096815480303945192642473881508, -3.50174857668477783806375600913535828147, -0.98979532482913929955173055064458831025}, {-2.124073664299602565642931863268852574630586e-170, -9.27610554175169483758756498829e-163, -2.6495046016745587759130402660431216713e-155, -5.03412373838892939808030135826495653901989146e-148, -6.39635908635155240809808764642375e-141, -5.447496664552494006938362905963129661208e-134, -3.1134313716112852407057731072719209174014537577e-127, -1.1949762330811185534184275059693678e-120, -3.081325845192356515571512792416710239569e-114, -5.3393140081658636758068261633737610534728659893e-108, -6.218270444892006870005161169867962e-102, -4.86773312391535676123505123005547318648e-96, -2.561366741742507256345616410112943584105161051e-90, -9.059466106256477452419379214594e-85, -2.153790378546160850131368380828023917e-79, -3.44148905361398739986835047051464760301334e-74, -3.6956648908452862527678491885512716048988564212e-69, -2.66681218770686276720699146513461e-64, -1.2929614357307116634048211581655327242e-59, -4.2111463379392189645246429429714411990257e-55, -9.211976434268530074461624960099039500687516324e-51, -1.3531488619833509848088804100595e-46, -1.33433792054636675564492877714240834e-42, -8.83045635179056581344925584232261308227e-39, -3.920545455161563670007501017582060531363838e-35, -1.1672944005816759983437366028562707910427452879e-31, -2.329593324594235583606850824894e-28, -3.114621366432047254155401565422157e-25, -2.787864289855953119937111489383540135e-22, -1.66932262333678365555306718063915039139e-19, -6.68040650643444813937797910284460938041678e-17, -1.78468567694652161770638230495757207845014942e-14, -3.1783497377787217684303141850717098586541113392e-12, -3.76660446529710423104536853359547635328449782844e-10, -2.963583309549062233033777446014e-8, -1.54349708125942821544082196055477e-6, -0.00005299881458998419394863240582669227, -0.00119302991106589811318743919252686901, -0.01746131087812300505083583583528811367, -0.16404040377700156766491418052100708416, -0.96767450145319258057726903460511587588, -3.43299195730437984969155697601412316297, -6.56730086177721445495445940794177872103, -3.96506284718657864903453838883195689734, 7.6836237214782822269351191247412108365, 15.38725942030546626201904555392610990406, 7.60706459226797425624915838680451208973, -4.12170629702927880676133239219521001949, -6.72198779084624825708244949476841241694, -3.51630302019997679622365333919998628769}, {-3.5166515790259219384098841981335438e-178, -2.281438923768882135374807618319691139575207e-170, -9.68079741644390916579339730988e-163, -2.7327187140017205929211138550353040057e-155, -5.15883126952284561878529111149547469022398713e-148, -6.52810989865409704118340762928316e-141, -5.54406368492433001077285956394005581237e-134, -3.1620964762764813431361734431111679588717710736e-127, -1.2117449368533386083543786654292492e-120, -3.1206865042163141444029346610861279212526e-114, -5.4020870182882207928190324561448516255923090333e-108, -6.286159391134108301978187795411626e-102, -4.917450345527283645656739903808151352081e-96, -2.585992966144465582360604081995025620589085788e-90, -9.141892908236529370592793089605e-85, -2.172419096047997600431589936618326638e-79, -3.4698979662129653765867724303347867742336e-74, -3.7248816575588228731266689269179640430031629454e-69, -2.68706520540440395172757090185512e-64, -1.3024198685195848499654474503271001749e-59, -4.2408920018872844288652670401037477980418e-55, -9.274943363403993859335930971606873866700559199e-51, -1.3621168801818512586758209911344e-46, -1.34292772700789132319133009739023075e-42, -8.88576253535667943218676247508368954177e-39, -3.944470676527095209390031899693737368978838e-35, -1.1742446709452437654348433919930000522327300941e-31, -2.343143952126265383198601147309e-28, -3.13234070350361480965196469064767e-25, -2.803393351518400564545850232013422306e-22, -1.678436045821205304714537653106217070353e-19, -6.71618480665049841315446061893043360488862e-17, -1.79407074441427600120104988508263609309508657e-14, -3.194774469634076228715634183022802217157199658e-12, -3.785747559282609654689025419741893238673798218783e-10, -2.978407665821307905989970829729e-8, -1.55110180829975031916469968076279e-6, -0.00005325619992227256227524524567594146, -0.00119874519765044006660835000660919496, -0.01754389342167405440628587675120974616, -0.16480706732623936675656592459551753688, -0.9721494650083153204288777823394794935, -3.44873525967995736029881316315544101664, -6.59733463855327017181243658536273285893, -3.98390184133783789688192937192999104344, 7.71581055680546209767904921813855225425, 15.45343054555906060295891933949003418194, 7.64055653211823521756258324224399854691, -4.13787354279815550252541556949425256541, -6.7493794562075272600761606434475373294}, {-3.91926391098818464676952486587453866932570724e-186, -3.7770158491344158821704393392720288e-178, -2.380863440556068345069236618596078853234901e-170, -9.98439074254039336182297504665e-163, -2.8002870208903345144251442845915779313e-155, -5.26485140275394603848217288635133792338806037e-148, -6.64352942656996004603531497884465e-141, -5.630464079872105067582334110635299031917e-134, -3.2063226189394707086793249679364404735879230378e-127, -1.2271675978612031141745493471688032e-120, -3.1572312904822770419225031219816829779894e-114, -5.4608153644135522223797755594214089353197857721e-108, -6.350073306138831246543648481632716e-102, -4.964501819087343281779773618307205890883e-96, -2.609401888036585325989022755037490010788580717e-90, -9.220541061525133626384990534672e-85, -2.190251617460141636362219541022377189e-79, -3.49716943032438523513553633926137148643838e-74, -3.7529978334194180683607738074013078520267350715e-69, -2.70659759585237969872582433353744e-64, -1.3115592690587483035724537291255757782e-59, -4.26968338571854185182096730413307350971834e-55, -9.335983060713824877210966854757192289051933598e-51, -1.3708222817983530042981075844395e-46, -1.3512762313062823664279375652676968e-42, -8.93957464029841550191607547141082703432e-39, -3.96777291409472042023940956041831112492505e-35, -1.1810201263922060913537135663876663667892170138e-31, -2.35636468995865484470854907498e-28, -3.149641716782243651710895309116807e-25, -2.818566257059323371083514761193039076e-22, -1.687346075095852708865471646638438154436e-19, -6.75118484961097916609610380330331783017668e-17, -1.80325654230781189358591592469755114795045822e-14, -3.2108583069482070565546666076981665309506982771e-12, -3.804501751108450450813830134892068895533529893675e-10, -2.992936851340754412931442983584e-8, -1.55855794424073392201335100835355e-6, -0.00005350864404078389570796731128374641, -0.0012043525511548005338522937109249969, -0.01762493989008010051969052645864244147, -0.16555966626709507452416466666406988282, -0.97654332621091257248901501530341809194, -3.4641959742724720901719945761387854027, -6.62683141289312743439148946760993939771, -4.00239248048195776104081240594471799748, 7.74747185865081979188582610784995115765, 15.51849049747416790668001030703738215856, 7.6734739406752228617433172029710685556, -4.15379282151343687521278749887271240881}, {-2.9404467631340065158991661577677618734e-194, -4.209252609352633625860561448387501972075773726e-186, -3.941444889376233616098944770522329e-178, -2.455420802251903465354844426505236102563577e-170, -1.023081399413871371727563866382e-162, -2.8577112243175459489372057808319098869e-155, -5.35770155176602205202795824962315740584277111e-148, -6.74676888507427635891259226430596e-141, -5.708963649532781937885810619297255574077e-134, -3.2469893318839226810562389755800034426663218117e-127, -1.2414839401906070864505132267852202e-120, -3.1914149818294706451124868084599571822388e-114, -5.5160957934949025996613496064370516394476959439e-108, -6.410551278776740303536410862273632e-102, -5.00922163259712317374059561128981322933e-96, -2.631735144290548254985227130865043322378704998e-90, -9.295820422478835015805630599008e-85, -2.207368746046744310779742982841544849e-79, -3.52341181429925831100528231554493398857301e-74, -3.7801121570499833756744299678270968509415286545e-69, -2.72547041018844418897521107305881e-64, -1.3204052286106712899643705840707383835e-59, -4.29759314918307817879073795885413550059553e-55, -9.395235145549826195504866236971929601610596523e-51, -1.379283210073481138836122520691e-46, -1.3593993659450602614380450473441931e-42, -8.99198714715979905485245181028713787819e-39, -3.990489975452927326447942608517748345025995e-35, -1.1876309686902650188167804212819830791168547609e-31, -2.369274086147795293773372152235e-28, -3.166547109681047608423855730118314e-25, -2.833401698814067641459722893864040267e-22, -1.696063052577346869490641670043274414488e-19, -6.78544503643828831967447203053665354222804e-17, -1.81225262884678324527030567516253722343702497e-14, -3.2266171714962571196078390043049162528303814045e-12, -3.822884756149051284152532779550052852296108313154e-10, -3.007184000483495745073138351323e-8, -1.56587195797206361759976633395027e-6, -0.00005375635772954539148870938185526892, -0.00120985649005288894211292820092159356, -0.01770451349020562426117951658844241402, -0.16629877040075998730648167233432610654, -0.98085932642611594121307764158078938269, -3.47938527371614293839517411998310736797, -6.65581231136853632368738915774627429965, -4.02054888112979222356265095124441501975, 7.77862644509051952009329132957925286338, 15.58248028440681272143549803664562567057, 7.70583843816540465764182992347378319813}, {-1.485158794996588681805067430177687165095699691492e-202, -3.1578797637901299747419479810028532036e-194, -4.3923144650041264301813926798103816092916892e-186, -4.0647017449522046968178427421509409e-178, -2.51591710453026185829650210779470927067113e-170, -1.044017443063929029284065883399e-162, -2.9079873219317669696272368169864775813e-155, -5.44073097218290451614096076095784729394607824e-148, -6.840544582133562869321026994322e-141, -5.781129184618026422711301997731139042079e-134, -3.2847312012342333600787087652185246921957637751e-127, -1.2548728663617951890158090409521075e-120, -3.2235864494697590573278775574123287520067e-114, -5.5683967021876831681537122563148207993108266209e-108, -6.468024743821009728054718360334868e-102, -5.051881652651969789261971671771837221908e-96, -2.653109674999119757821315124979535465315287094e-90, -9.368073713949647291350672969557e-85, -2.223838815215490735735068512553496373e-79, -3.54871768870369628846866445754292572254307e-74, -3.8063097382060447960755437626500728232389947404e-69, -2.74373670366179656173387540028961e-64, -1.3289801519792924777852586533103880705e-59, -4.32468533544612974261676794505497457600969e-55, -9.45282344137723160602013059491092271044871906e-51, -1.3875158468499860055584862430882e-46, -1.36731141505443525328795212729011269e-42, -9.0430851676752598973487709988666830404e-39, -4.012656069619566229811800816340466143747005e-35, -1.194086466204691625935419967048691432483265502e-31, -2.381889055067857450686399755596e-28, -3.183077657764403860258098235800273e-25, -2.847916836614162815234769518597003388e-22, -1.704596499847403341533070068737585062621e-19, -6.81900082003003747914883791010142540793918e-17, -1.82106785048663261271909732671986032037356131e-14, -3.2420658332577797560513815571591778496896724786e-12, -3.840913042822750689230150574742470229454504120841e-10, -3.021161346617372123511507079651e-8, -1.57304988519291254202192053920647e-6, -0.00005399953797065775762137822934395623, -0.00121526124302670522614892475983894705, -0.01778267345132782279583764825945467882, -0.16702491427788054775802533718157549441, -0.98510050945261338880550675056405365051, -3.49431365768967562467407113397428178932, -6.68429719556942352326484917201707868498, -4.03838429224121291355773842685664027406, 7.80929211236445247804964227519832069267, 15.64543861395569176856002451667234798848}};
	gdouble SM[50][50][50] = {{{0., 12.80186298875139, 21.44420682348356, 15.372169153918888, 6.054914989333632, 1.4332510798550255, 0.21278130792685807, 0.02028316500434507, 0.0012590331133791528, 0.000051348442664013386, 1.3842084388876273e-6, 2.4766195670878593e-8, 2.9497806471988616e-10, 2.3439192632547905e-12, 1.2446168057921163e-14, 4.4220415854322087e-17, 1.0523016383753017e-19, 1.6785607890509507e-22, 1.7959615161611373e-25, 1.2895961663183528e-28, 6.217300301527391e-32, 2.0132849025548245e-35, 4.380293115935215e-39, 6.404939010706317e-43, 6.295696256914161e-47, 4.1608214280703616e-51, 1.8492657310515994e-55, 5.528069303333036e-60, 1.1116359037008205e-64, 1.5039064252843714e-69, 1.3689785709845997e-74, 8.385587274927484e-80, 3.4567692148849066e-85, 9.590530855969622e-91, 1.7909450017797888e-96, 2.251221706239357e-102, 1.9049220629957704e-108, 1.0851338733580622e-114, 4.161585414419147e-121, 1.0745437601656318e-127, 1.8680909173096027e-134, 2.1867436819734838e-141, 1.7236130767915832e-148, 9.148261987042918e-156, 3.269701763506538e-163, 7.869756281949072e-171, 1.275586750125182e-178, 1.3924046810752462e-186, 1.0236185865425901e-194, 5.0680145413249795e-203}, {-12.80186298875139, 0., 16.661790961586867, 15.300380878511763, 6.597750980776302, 1.6335147060106565, 0.24893189227455623, 0.02413139268318999, 0.0015153967600517757, 0.00006232885639762356, 1.6910231941803679e-6, 3.040815574635879e-8, 3.6364298281763756e-10, 2.899137993727882e-12, 1.5437102126834198e-14, 5.497608552619198e-17, 1.3108948088438756e-19, 2.0947179419259404e-22, 2.2446681863198356e-25, 1.6139785243258587e-28, 7.790581144629538e-32, 2.525471705940804e-35, 5.5000054576036244e-39, 8.049291368141632e-43, 7.9183475380289615e-47, 5.2370646101422293e-51, 2.3291630679320815e-55, 6.966948025599731e-60, 1.401779280616047e-64, 1.8974380122072447e-69, 1.7280520549995694e-74, 1.0589913214675067e-79, 4.367318501009121e-85, 1.2121623034478883e-90, 2.264452527177144e-96, 2.847424762332571e-102, 2.4102120784270955e-108, 1.3734005809133884e-114, 5.268670776090294e-121, 1.3607795949442155e-127, 2.36633788685451e-134, 2.7706764710797607e-141, 2.184396466151355e-148, 1.1596554792262366e-155, 4.145649246522529e-163, 9.980110738332435e-171, 1.6179670722075227e-178, 1.7664728390605318e-186, 1.298846765484776e-194, 6.431800291703183e-203}, {-21.44420682348356, -16.661790961586867, 0., 5.622358482618737, 3.1712422476966573, 0.8708808496605208, 0.1400444069165295, 0.014023327733861493, 0.0008997702134032361, 0.000037575458369902735, 1.0310420815235462e-6, 1.8702715844878265e-8, 2.2521507091327805e-10, 1.8056607833127924e-12, 9.659606607090364e-15, 3.4536162709951623e-17, 8.262757917991169e-20, 1.3241616329540024e-22, 1.4225424452836617e-25, 1.025124823455425e-28, 4.957987398152692e-32, 1.6100629583892724e-35, 3.5119674655520606e-39, 5.1471347584884e-43, 5.069973594655437e-47, 3.357164486340777e-51, 1.4947024138565225e-55, 4.4753751298902853e-60, 9.012906771213691e-65, 1.221015933256813e-69, 1.112890436418334e-74, 6.825052496657836e-80, 2.8165990505044116e-85, 7.822546698308346e-91, 1.4622119536696263e-96, 1.839683807029883e-102, 1.5580289450077808e-108, 8.882466837335786e-115, 3.4091131581263615e-121, 8.808886311399698e-128, 1.532472165632431e-134, 1.7950428926924713e-141, 1.4157446331367933e-148, 7.518631514785573e-156, 2.688754956994524e-163, 6.4749423406916315e-171, 1.0500394167520807e-178, 1.146759123400157e-186, 8.434256613422517e-195, 4.1777245133602185e-203}, {-15.372169153918888, -15.300380878511763, -5.622358482618737, 0., 0.6857782024246825, 0.24850890551516633, 0.04460195373458378, 0.004734599980543025, 0.0003148955086458229, 0.000013472960426799816, 3.76177924895888e-7, 6.913609932657047e-9, 8.410531369019181e-11, 6.798371589749309e-13, 3.661235354341728e-15, 1.316312173467984e-17, 3.1641339091641303e-20, 5.0912426875264573e-23, 5.488672875415058e-26, 3.967421278491175e-29, 1.9240221938606712e-32, 6.263113765673806e-36, 1.3690867668110822e-39, 2.010415369655318e-43, 1.9837446448384286e-47, 1.315659326690044e-51, 5.866192009117973e-56, 1.7587703986567707e-60, 3.5463084530950932e-65, 4.809766340761278e-70, 4.388435457075097e-75, 2.6939249463313993e-80, 1.1127500085116855e-85, 3.093054879386451e-91, 5.78619427156589e-97, 7.285303365918888e-103, 6.174222193776954e-109, 3.522287719607726e-115, 1.352698158269066e-121, 3.4973076320652154e-128, 6.087585633729129e-135, 7.13434925398966e-142, 5.629630172685851e-149, 2.9911512976528953e-156, 1.070151988160379e-163, 2.578193653424366e-171, 4.182750904029866e-179, 4.569801548031139e-187, 3.3622746465955766e-195, 1.6660207414278917e-203}, {-6.054914989333632, -6.597750980776302, -3.1712422476966573, -0.6857782024246825, 0., 0.033944978265311045, 0.00807564983955406, 0.0009600367916042234, 0.00006786602851173837, 3.016099215879063e-6, 8.642016411642398e-8, 1.6183274471212751e-9, 1.996861955482578e-11, 1.6321362587662055e-13, 8.868727589541085e-16, 3.212050642189277e-18, 7.768654153845711e-21, 1.2565459997137588e-23, 1.3607146040152798e-26, 9.874097148060755e-30, 4.804853318192051e-33, 1.5688060782953436e-36, 3.4385481931650157e-40, 5.061437014650126e-44, 5.0051192163746645e-48, 3.3260138418243474e-52, 1.4856350076029595e-56, 4.461423596913771e-61, 9.009294233539282e-66, 1.2235920431312878e-70, 1.1178283832967877e-75, 6.870099765532709e-81, 2.840867598978037e-86, 7.904679697221192e-92, 1.4801427019608392e-97, 1.8652868385326517e-103, 1.5821352200754747e-109, 9.032909409562704e-116, 3.4715645764604136e-122, 8.981760077400834e-129, 1.5644410980218203e-135, 1.8345925315335586e-142, 1.4485118605753701e-149, 7.700597129924984e-157, 2.75653297443379e-164, 6.644368780163204e-172, 1.0784753338377698e-179, 1.1788155541132058e-187, 8.677066899209104e-196, 4.301331836512372e-204}, {-1.4332510798550255, -1.6335147060106565, -0.8708808496605208, -0.24850890551516633, -0.033944978265311045, 0., 0.0007186850662471771, 0.00011353787365373965, 9.006106126513944e-6, 4.260680277866257e-7, 1.2696275390131107e-8, 2.442282988263598e-10, 3.0730442256062055e-12, 2.5493639028758838e-14, 1.4015497108504148e-16, 5.124124784368418e-19, 1.2489682091361263e-21, 2.0333213895367546e-24, 2.214080514138967e-27, 1.614313170969348e-30, 7.887971968582167e-34, 2.584815618329844e-37, 5.683669169407979e-41, 8.39013416492887e-45, 8.318068551721983e-49, 5.540330470205014e-53, 2.479894649370316e-57, 7.461439627836675e-62, 1.5093746231028841e-66, 2.053230986919867e-71, 1.8785222601455698e-76, 1.1561008110105734e-81, 4.786651836386471e-87, 1.3334435102039469e-92, 2.4995895681330595e-98, 3.1532195910970105e-104, 2.6771170780272313e-110, 1.5298220713580272e-116, 5.884433422860537e-123, 1.523651593422952e-129, 2.65588177552488e-136, 3.1167110730288943e-143, 2.462464141419085e-150, 1.3099298045984551e-157, 4.691897928055108e-165, 1.1315867657520027e-172, 1.837727356527713e-180, 2.0097510892723697e-188, 1.4800776644820176e-196, 7.340403742728238e-205}, {-0.21278130792685807, -0.24893189227455623, -0.1400444069165295, -0.04460195373458378, -0.00807564983955406, -0.0007186850662471771, 0., 6.685171638870212e-6, 7.057261345540048e-7, 3.7506305807923576e-8, 1.1908033237850114e-9, 2.3839592630249115e-11, 3.083130694041334e-13, 2.6094730629768684e-15, 1.456652169193363e-17, 5.389931041943258e-20, 1.3265626972317068e-22, 2.1769886093157404e-25, 2.3864756171437375e-28, 1.7499677539089693e-31, 8.5929459378583e-35, 2.8278971797620157e-38, 6.241568190270474e-42, 9.244369937663274e-46, 9.192159254097244e-50, 6.138817920993315e-54, 2.754376160043215e-58, 8.305319384795397e-63, 1.6834112148057745e-67, 2.294124669471845e-72, 2.1024088676498198e-77, 1.2958698012555521e-82, 5.372939940115923e-88, 1.4987335026729797e-93, 2.812859522865639e-99, 3.5524427912319755e-105, 3.0192656088963277e-111, 1.727056715686094e-117, 6.649292120510176e-124, 1.7232062616156998e-130, 3.0062080502505687e-137, 3.530573692684207e-144, 2.7915056093783954e-151, 1.4860019112236177e-158, 5.326070258510985e-166, 1.2853417764014622e-173, 2.088674621919286e-181, 2.2854852505660903e-189, 1.68405191181232e-197, 8.356317251633845e-206}, {-0.02028316500434507, -0.02413139268318999, -0.014023327733861493, -0.004734599980543025, -0.0009600367916042234, -0.00011353787365373965, -6.685171638870212e-6, 0., 2.7716284059612765e-8, 1.961983601263639e-9, 7.002301777014724e-11, 1.4943799582402486e-12, 2.012200182939795e-14, 1.7510405632551384e-16, 9.97504881285879e-19, 3.7485789738804695e-21, 9.339200516140922e-24, 1.5478216820421515e-26, 1.710628066142997e-29, 1.2629733903783119e-32, 6.237785733064054e-36, 2.0631299999340205e-39, 4.573510104279953e-43, 6.7997967299599e-47, 6.784349350979176e-51, 4.544518142121676e-55, 2.0445784333266994e-59, 6.18015147347635e-64, 1.2554406627241174e-68, 1.7143534356950837e-73, 1.5739939555068789e-78, 9.718161892096579e-84, 4.0356520355564545e-89, 1.1273370146074049e-94, 2.118650343062498e-100, 2.679040765145075e-106, 2.279595518045436e-112, 1.305371717666119e-118, 5.030882529116958e-125, 1.3050285168955184e-131, 2.27872015515858e-138, 2.6784519974892064e-145, 2.119449310074077e-152, 1.1290959736137076e-159, 4.049746907786464e-167, 9.779868537508653e-175, 1.590243802973182e-182, 1.7411496587477362e-190, 1.2837047166185474e-198, 6.373304868165985e-207}, {-0.0012590331133791528, -0.0015153967600517757, -0.0008997702134032361, -0.0003148955086458229, -0.00006786602851173837, -9.006106126513944e-6, -7.057261345540048e-7, -2.7716284059612765e-8, 0., 5.16198679436358e-11, 2.455049977198443e-12, 5.891816868070649e-14, 8.45951348020932e-16, 7.666312089575348e-18, 4.491065111160417e-20, 1.72259085228133e-22, 4.359168595164725e-25, 7.314065997948777e-28, 8.16422675738469e-31, 6.077439999429528e-34, 3.0223952614732226e-37, 1.0055340101826103e-40, 2.2403536045941974e-44, 3.3456110798096796e-48, 3.350950123445921e-52, 2.252347569073968e-56, 1.016431216223998e-60, 3.0808012252244742e-65, 6.273859139840189e-70, 8.586434939417776e-75, 7.89955867562697e-80, 4.886473305334816e-85, 2.0326865018726593e-90, 5.6871832063441445e-96, 1.0703790720422463e-101, 1.3553338603262405e-107, 1.1547076759145015e-113, 6.620009405611122e-120, 2.5541432304698472e-126, 6.63235010647999e-133, 1.159197169589706e-139, 1.363779107595619e-146, 1.0800757014945033e-153, 5.758536159558337e-161, 2.066997743268481e-168, 4.9952629804784616e-176, 8.128042930403525e-184, 8.905130134567841e-192, 6.569574869627904e-200, 3.263561955349364e-208}, {-0.000051348442664013386, -0.00006232885639762356, -0.000037575458369902735, -0.000013472960426799816, -3.016099215879063e-6, -4.260680277866257e-7, -3.7506305807923576e-8, -1.961983601263639e-9, -5.16198679436358e-11, 0., 4.337482119357915e-14, 1.3875158943868445e-15, 2.240731815827316e-17, 2.1656331437100603e-19, 1.3213492356753717e-21, 5.212399630035085e-24, 1.3464049933270468e-26, 2.2947673830029014e-29, 2.5933633498736564e-32, 1.949895462954241e-35, 9.777476575518378e-39, 3.275533816391242e-42, 7.341161436544946e-46, 1.1018749756579847e-49, 1.1085313631634886e-53, 7.480060194116553e-58, 3.3872242351731635e-62, 1.0298261654336897e-66, 2.102966117095326e-71, 2.88529830742278e-76, 2.660482390137707e-81, 1.6490948599024808e-86, 6.872852535600079e-92, 1.9262543977921253e-97, 3.631156597478209e-103, 4.604605366031162e-109, 3.928352465978508e-115, 2.2550058702851894e-121, 8.71059125508359e-128, 2.26438081049095e-134, 3.9617630563557515e-141, 4.665484225914759e-148, 3.698309186247094e-155, 1.9734878583325223e-162, 7.089484528534287e-170, 1.7146125423428474e-177, 2.791957757543851e-185, 3.060990328799809e-193, 2.2596576629702705e-201, 1.1232254204116606e-209}, {-1.3842084388876273e-6, -1.6910231941803679e-6, -1.0310420815235462e-6, -3.76177924895888e-7, -8.642016411642398e-8, -1.2696275390131107e-8, -1.1908033237850114e-9, -7.002301777014724e-11, -2.455049977198443e-12, -4.337482119357915e-14, 0., 1.6483107516415527e-17, 3.548652525549522e-19, 3.857988248371831e-21, 2.5106359254503585e-23, 1.0315784956949981e-25, 2.7406307316260777e-28, 4.76813610878252e-31, 5.4738959778160605e-34, 4.167023598964357e-37, 2.1105455464179864e-40, 7.129257741784744e-44, 1.6089588848817169e-47, 2.4293074742731014e-51, 2.4564791117097936e-55, 1.6649411639246208e-59, 7.568892969011902e-64, 2.3091548442106927e-68, 4.7299844638256165e-73, 6.507573296470802e-78, 6.015508958682269e-83, 3.7371487301112723e-88, 1.5607275697561453e-93, 4.382508826146338e-99, 8.275729880962191e-105, 1.0511068954848365e-110, 8.980607505089603e-117, 5.162227208046544e-123, 1.9965929167020602e-129, 5.196445020889014e-136, 9.101784821294612e-143, 1.0729646682842182e-149, 8.513630537338831e-157, 4.547195978082751e-164, 1.6349272894618315e-171, 3.9573388666586836e-179, 6.448818786270418e-187, 7.075376418994853e-195, 5.226730033517404e-203, 2.5997942915337364e-211}, {-2.4766195670878593e-8, -3.040815574635879e-8, -1.8702715844878265e-8, -6.913609932657047e-9, -1.6183274471212751e-9, -2.442282988263598e-10, -2.3839592630249115e-11, -1.4943799582402486e-12, -5.891816868070649e-14, -1.3875158943868445e-15, -1.6483107516415527e-17, 0., 2.836644406650952e-21, 4.111564200174698e-23, 3.009933099014589e-25, 1.3191204208704637e-27, 3.6504470350318674e-30, 6.532303326324683e-33, 7.655245346398412e-36, 5.919973267955907e-39, 3.035824653364131e-42, 1.035822327643095e-45, 2.357138232538294e-49, 3.5838081190637134e-53, 3.645432081980405e-57, 2.483436091339946e-61, 1.1340130142342162e-65, 3.473248918798038e-70, 7.139134819241994e-75, 9.852474415629638e-80, 9.132746731339851e-85, 5.687936933854465e-90, 2.3808158939675834e-95, 6.699128064005096e-101, 1.2674247721817682e-106, 1.6125610475111474e-112, 1.3799688123066388e-118, 7.944060138523371e-125, 3.07673495343638e-131, 8.017893167851618e-138, 1.4060356441286054e-144, 1.6593468985814942e-151, 1.3180077145206316e-158, 7.046450810062669e-166, 2.5358496307990875e-173, 6.143325125487839e-181, 1.0019233408910131e-188, 1.1001161132625168e-196, 8.132720502819158e-205, 4.048042888341682e-213}, {-2.9497806471988616e-10, -3.6364298281763756e-10, -2.2521507091327805e-10, -8.410531369019181e-11, -1.996861955482578e-11, -3.0730442256062055e-12, -3.083130694041334e-13, -2.012200182939795e-14, -8.45951348020932e-16, -2.240731815827316e-17, -3.548652525549522e-19, -2.836644406650952e-21, 0., 2.212429842860676e-25, 2.1594382824614186e-27, 1.0646527916193085e-29, 3.1425950777358237e-32, 5.857735298925568e-35, 7.060749505241221e-38, 5.573927061376459e-41, 2.9037119361691177e-44, 1.0031218977877241e-47, 2.305766868808106e-51, 3.534896722638898e-55, 3.6208063474734884e-59, 2.481331698802179e-63, 1.1388582854234545e-67, 3.503649035160492e-72, 7.229841109643085e-77, 1.0012272752086031e-81, 9.3095824906113e-87, 5.814164418846352e-92, 2.439745782120776e-97, 6.880534245881831e-103, 1.304438394779018e-108, 1.66279467342814e-114, 1.4254295216284986e-120, 8.218902973623082e-127, 3.1878935013944396e-133, 8.318971482199492e-140, 1.4606949792478308e-146, 1.7259041323113988e-153, 1.372397260753797e-160, 7.344869536316638e-168, 2.6458250311555855e-175, 6.41563676629111e-183, 1.047240162926106e-190, 1.150812810902589e-198, 8.514064852934804e-207, 4.240951335640137e-215}, {-2.3439192632547905e-12, -2.899137993727882e-12, -1.8056607833127924e-12, -6.798371589749309e-13, -1.6321362587662055e-13, -2.5493639028758838e-14, -2.6094730629768684e-15, -1.7510405632551384e-16, -7.666312089575348e-18, -2.1656331437100603e-19, -3.857988248371831e-21, -4.111564200174698e-23, -2.212429842860676e-25, 0., 7.824044903821486e-30, 5.143143478810994e-32, 1.7078712600769031e-34, 3.3956289709062725e-37, 4.26349936742248e-40, 3.4618485877019774e-43, 1.8409952870136138e-46, 6.460858645092174e-50, 1.5036447756102451e-53, 2.3284662564428224e-57, 2.4049242865080626e-61, 1.6596110704598515e-65, 7.662450448279616e-70, 2.3694046273658228e-74, 4.9111270064021443e-79, 6.827853974678492e-84, 6.370690887054749e-89, 3.9910356176984793e-94, 1.6793727370109108e-99, 4.7480069768049316e-105, 9.021905635230473e-111, 1.1524210996962769e-116, 9.897824351380363e-123, 5.716920834027009e-129, 2.220993420950482e-135, 5.804378993876493e-142, 1.0205671031824087e-148, 1.2074044378755152e-155, 9.61241330994439e-163, 5.1501430872997106e-170, 1.8571556115692295e-177, 4.507659323671929e-185, 7.364723115551268e-193, 8.10010246412371e-201, 5.997597253755415e-209, 2.9897765032053834e-217}, {-1.2446168057921163e-14, -1.5437102126834198e-14, -9.659606607090364e-15, -3.661235354341728e-15, -8.868727589541085e-16, -1.4015497108504148e-16, -1.456652169193363e-17, -9.97504881285879e-19, -4.491065111160417e-20, -1.3213492356753717e-21, -2.5106359254503585e-23, -3.009933099014589e-25, -2.1594382824614186e-27, -7.824044903821486e-30, 0., 1.254914220528677e-34, 5.556162986225597e-37, 1.2427660928246846e-39, 1.664415097627018e-42, 1.4077656819426956e-45, 7.70030493157006e-49, 2.7586658818498042e-52, 6.522176259746345e-56, 1.0226132648016887e-59, 1.0668588806356642e-63, 7.423614455289268e-68, 3.451458809361791e-72, 1.073621533721067e-76, 2.236733306906654e-81, 3.1235711822069002e-86, 2.9258575877040596e-91, 1.8393201319043635e-96, 7.763562442641195e-102, 2.201049292755828e-107, 4.19279457126514e-113, 5.367872906610036e-119, 4.619860044818207e-125, 2.6734547688858705e-131, 1.0404289362540909e-137, 2.723429889404772e-144, 4.79562036741835e-151, 5.681356299404282e-158, 4.528828575807299e-165, 2.42934584060495e-172, 8.77002968130371e-180, 2.130864898806745e-187, 3.484861226452132e-195, 3.8363522675681175e-203, 2.8430273441217527e-211, 1.418394566794831e-219}, {-4.4220415854322087e-17, -5.497608552619198e-17, -3.4536162709951623e-17, -1.316312173467984e-17, -3.212050642189277e-18, -5.124124784368418e-19, -5.389931041943258e-20, -3.7485789738804695e-21, -1.72259085228133e-22, -5.212399630035085e-24, -1.0315784956949981e-25, -1.3191204208704637e-27, -1.0646527916193085e-29, -5.143143478810994e-32, -1.254914220528677e-34, 0., 9.13060214582944e-40, 2.7230176576934768e-42, 4.1027367678240407e-45, 3.701433082699539e-48, 2.1089937034493033e-51, 7.771416351320473e-55, 1.8756329191609205e-58, 2.9874845501429725e-62, 3.1557009688341846e-66, 2.2180367264741744e-70, 1.0398240214774018e-74, 3.2571260264061566e-79, 6.826133116249406e-84, 9.581493715853449e-89, 9.015074517181318e-94, 5.689486762006187e-99, 2.4098057320161072e-104, 6.853195384394928e-110, 1.3090960628657977e-115, 1.6801851773416172e-121, 1.4493376087534158e-127, 8.404497020489481e-134, 3.276973870328636e-140, 8.592733065289354e-147, 1.5154976814966635e-153, 1.7980649120530277e-160, 1.4352756327590806e-167, 7.708910792329607e-175, 2.7862584335117778e-182, 6.777336003479003e-190, 1.1095342153758536e-197, 1.2226382254943623e-205, 9.069001455748311e-214, 4.528468023983726e-222}, {-1.0523016383753017e-19, -1.3108948088438756e-19, -8.262757917991169e-20, -3.1641339091641303e-20, -7.768654153845711e-21, -1.2489682091361263e-21, -1.3265626972317068e-22, -9.339200516140922e-24, -4.359168595164725e-25, -1.3464049933270468e-26, -2.7406307316260777e-28, -3.6504470350318674e-30, -3.1425950777358237e-32, -1.7078712600769031e-34, -5.556162986225597e-37, -9.13060214582944e-40, 0., 3.014012515542811e-45, 6.054885653033343e-48, 6.145453615519717e-51, 3.734972959458381e-54, 1.433641835195044e-57, 3.558954447129346e-61, 5.786751070853225e-65, 6.209607641963517e-69, 4.419080175743857e-73, 2.0926067903785544e-77, 6.609465295797988e-82, 1.3948671504008717e-86, 1.969557328584273e-91, 1.8626278513203167e-96, 1.1807671928527178e-101, 5.020800082862827e-107, 1.4328122864891527e-112, 2.745428430570821e-118, 3.5334618349603162e-124, 3.0556236511688627e-130, 1.7759383907635308e-136, 6.9388473767835315e-143, 1.8229190682073014e-149, 3.2206679116333876e-156, 3.827290527714619e-163, 3.05959729495615e-170, 1.6455765761079376e-177, 5.955260266696706e-185, 1.4502906678800165e-192, 2.3769471661173577e-200, 2.6219773236840304e-208, 1.946770404057805e-216, 9.72983630611095e-225}, {-1.6785607890509507e-22, -2.0947179419259404e-22, -1.3241616329540024e-22, -5.0912426875264573e-23, -1.2565459997137588e-23, -2.0333213895367546e-24, -2.1769886093157404e-25, -1.5478216820421515e-26, -7.314065997948777e-28, -2.2947673830029014e-29, -4.76813610878252e-31, -6.532303326324683e-33, -5.857735298925568e-35, -3.3956289709062725e-37, -1.2427660928246846e-39, -2.7230176576934768e-42, -3.014012515542811e-45, 0., 4.514335984081952e-51, 6.109140431054314e-54, 4.177012470045798e-57, 1.7102020134784216e-60, 4.422396951540825e-64, 7.396127237427451e-68, 8.101929010691987e-72, 5.857272949111859e-76, 2.80831711333119e-80, 8.959619496528433e-85, 1.906602421571528e-89, 2.7109550348631497e-94, 2.5790344918258525e-99, 1.6432995995540977e-104, 7.018751384308437e-110, 2.0108328683515178e-115, 3.8663585604430153e-121, 4.9915435407811916e-127, 4.3285156906920685e-133, 2.522052368054294e-139, 9.876417270971954e-146, 2.6000260149424122e-152, 4.60233240537905e-159, 5.478707164662313e-166, 4.3867848749020705e-173, 2.362887658932435e-180, 8.562919451928487e-188, 2.0879997981772784e-195, 3.4261914419359e-203, 3.7835879624000555e-211, 2.8121713722759914e-219, 1.406879476547151e-227}, {-1.7959615161611373e-25, -2.2446681863198356e-25, -1.4225424452836617e-25, -5.488672875415058e-26, -1.3607146040152798e-26, -2.214080514138967e-27, -2.3864756171437375e-28, -1.710628066142997e-29, -8.16422675738469e-31, -2.5933633498736564e-32, -5.4738959778160605e-34, -7.655245346398412e-36, -7.060749505241221e-38, -4.26349936742248e-40, -1.664415097627018e-42, -4.1027367678240407e-45, -6.054885653033343e-48, -4.514335984081952e-51, 0., 3.0681705220603775e-57, 2.7970720106473593e-60, 1.2883611764278357e-63, 3.5536653123649906e-67, 6.1908721385885306e-71, 6.975418448055453e-75, 5.147923312050232e-79, 2.5073913347622077e-83, 8.099543183685018e-88, 1.7409883506733013e-92, 2.496100857801572e-97, 2.3912412346993672e-102, 1.5327113997153106e-107, 6.579985475785614e-113, 1.8935445664096492e-118, 3.6551184059292222e-124, 4.7352130716203614e-130, 4.118946317640566e-136, 2.4066111468312783e-142, 9.447966353644613e-149, 2.4928864863581157e-155, 4.4218195302202173e-162, 5.2737903295746736e-169, 4.230052320891488e-176, 2.282116944850957e-183, 8.282464751658038e-191, 2.02238731282552e-198, 3.322766322439925e-206, 3.673742504940426e-214, 2.733565426684125e-222, 1.3689788350991434e-230}, {-1.2895961663183528e-28, -1.6139785243258587e-28, -1.025124823455425e-28, -3.967421278491175e-29, -9.874097148060755e-30, -1.614313170969348e-30, -1.7499677539089693e-31, -1.2629733903783119e-32, -6.077439999429528e-34, -1.949895462954241e-35, -4.167023598964357e-37, -5.919973267955907e-39, -5.573927061376459e-41, -3.4618485877019774e-43, -1.4077656819426956e-45, -3.701433082699539e-48, -6.145453615519717e-51, -6.109140431054314e-54, -3.0681705220603775e-57, 0., 9.463006725698535e-64, 5.811680737641713e-67, 1.8034042001622518e-70, 3.3511745185560558e-74, 3.933183344065517e-78, 2.985660413184205e-82, 1.4845173287015433e-86, 4.871504111776211e-91, 1.0602137264073096e-95, 1.535410383770148e-100, 1.4831662790980128e-105, 9.573115085167956e-111, 4.134235748662793e-116, 1.1958240494782264e-121, 2.3186099368752553e-127, 3.0155431323872798e-133, 2.6321915953713677e-139, 1.5426939316729796e-145, 6.073190166748839e-152, 1.606453412810759e-158, 2.8559628475700614e-165, 3.413285577330273e-172, 2.742945953269942e-179, 1.482395341796272e-186, 5.3886647612692054e-194, 1.3177372464464173e-201, 2.168005778212023e-209, 2.400068549297256e-217, 1.787973644440732e-225, 8.964192800441425e-234}, {-6.217300301527391e-32, -7.790581144629538e-32, -4.957987398152692e-32, -1.9240221938606712e-32, -4.804853318192051e-33, -7.887971968582167e-34, -8.5929459378583e-35, -6.237785733064054e-36, -3.0223952614732226e-37, -9.777476575518378e-39, -2.1105455464179864e-40, -3.035824653364131e-42, -2.9037119361691177e-44, -1.8409952870136138e-46, -7.70030493157006e-49, -2.1089937034493033e-51, -3.734972959458381e-54, -4.177012470045798e-57, -2.7970720106473593e-60, -9.463006725698535e-64, 0., 1.3245414553039555e-70, 5.4801893339665094e-74, 1.145650137381223e-77, 1.4342598769979332e-81, 1.1341038112013168e-85, 5.800054951821071e-90, 1.942963924498506e-94, 4.295705479154791e-99, 6.298839894541412e-104, 6.145974235036848e-109, 3.9999843187095825e-114, 1.739509058702054e-119, 5.061464056688854e-125, 9.864112605309056e-131, 1.2886363224066627e-136, 1.1292292076013573e-142, 6.641248443548465e-149, 2.6225834770347742e-155, 6.956411657549057e-162, 1.2398147109511237e-168, 1.4851241754868307e-175, 1.1959296166760783e-182, 6.475512704302558e-190, 2.3580115125476565e-197, 5.775492210613176e-205, 9.516199489070576e-213, 1.054928184834796e-220, 7.868911514194937e-229, 3.9498576657144024e-237}, {-2.0132849025548245e-35, -2.525471705940804e-35, -1.6100629583892724e-35, -6.263113765673806e-36, -1.5688060782953436e-36, -2.584815618329844e-37, -2.8278971797620157e-38, -2.0631299999340205e-39, -1.0055340101826103e-40, -3.275533816391242e-42, -7.129257741784744e-44, -1.035822327643095e-45, -1.0031218977877241e-47, -6.460858645092174e-50, -2.7586658818498042e-52, -7.771416351320473e-55, -1.433641835195044e-57, -1.7102020134784216e-60, -1.2883611764278357e-63, -5.811680737641713e-67, -1.3245414553039555e-70, 0., 8.414106408038326e-78, 2.345325672951412e-81, 3.303174350396232e-85, 2.786026008163612e-89, 1.4842027082996033e-93, 5.1139949579315324e-98, 1.1542101557464475e-102, 1.7192949253998687e-107, 1.6985391983727114e-112, 1.1166264946760646e-117, 4.8964401998419866e-123, 1.434684375508433e-128, 2.812649741568168e-134, 3.6932563876986725e-140, 3.2508407073969493e-146, 1.919389420961842e-152, 7.605855034416612e-159, 2.0237016389784713e-165, 3.6167850099592424e-172, 4.343259427847877e-179, 3.5054561284827458e-186, 1.9020034686738925e-193, 6.939126655951137e-201, 1.7025604225666874e-208, 2.8097811563608788e-216, 3.119426634526013e-224, 2.330036317405211e-232, 1.1710724779093816e-240}, {-4.380293115935215e-39, -5.5000054576036244e-39, -3.5119674655520606e-39, -1.3690867668110822e-39, -3.4385481931650157e-40, -5.683669169407979e-41, -6.241568190270474e-42, -4.573510104279953e-43, -2.2403536045941974e-44, -7.341161436544946e-46, -1.6089588848817169e-47, -2.357138232538294e-49, -2.305766868808106e-51, -1.5036447756102451e-53, -6.522176259746345e-56, -1.8756329191609205e-58, -3.558954447129346e-61, -4.422396951540825e-64, -3.5536653123649906e-67, -1.8034042001622518e-70, -5.4801893339665094e-74, -8.414106408038326e-78, 0., 2.4259011014037687e-85, 4.5555430502157666e-89, 4.32261281514058e-93, 2.4563096041504213e-97, 8.81614944397871e-102, 2.0466236627793998e-106, 3.1121342285102888e-111, 3.123366401416703e-116, 2.0789800321542605e-121, 9.208473612563726e-127, 2.7206187337478493e-132, 5.3709785958331816e-138, 7.09454663562846e-144, 6.276713972210436e-150, 3.722496041264482e-156, 1.480876956853756e-162, 3.9538734900410935e-169, 7.088289832710472e-176, 8.535702000244733e-183, 6.906453699980581e-190, 3.7558460765516653e-197, 1.3730916489025363e-204, 3.375351408135384e-212, 5.580120715857011e-220, 6.204993084716825e-228, 4.641647318920922e-236, 2.3360889315751697e-244}, {-6.404939010706317e-43, -8.049291368141632e-43, -5.1471347584884e-43, -2.010415369655318e-43, -5.061437014650126e-44, -8.39013416492887e-45, -9.244369937663274e-46, -6.7997967299599e-47, -3.3456110798096796e-48, -1.1018749756579847e-49, -2.4293074742731014e-51, -3.5838081190637134e-53, -3.534896722638898e-55, -2.3284662564428224e-57, -1.0226132648016887e-59, -2.9874845501429725e-62, -5.786751070853225e-65, -7.396127237427451e-68, -6.1908721385885306e-71, -3.3511745185560558e-74, -1.145650137381223e-77, -2.345325672951412e-81, -2.4259011014037687e-85, 0., 3.1744996386066104e-93, 4.0162449628708485e-97, 2.567494259992723e-101, 9.829559106382156e-106, 2.37695987443061e-110, 3.7177196233721747e-115, 3.8088694624837764e-120, 2.575507956023907e-125, 1.155035297533488e-130, 3.446990583679693e-136, 6.861672058522111e-142, 9.126991330260819e-148, 8.122930750799667e-154, 4.842126335377998e-160, 1.9348858404323055e-166, 5.1863154056572906e-173, 9.330028647220092e-180, 1.1269982513031978e-186, 9.144159718797315e-194, 4.985211398626235e-201, 1.826674778289888e-208, 4.499652042437515e-216, 7.452899769792741e-224, 8.301902465785434e-232, 6.220193445791526e-240, 3.135191312789557e-248}, {-6.295696256914161e-47, -7.9183475380289615e-47, -5.069973594655437e-47, -1.9837446448384286e-47, -5.0051192163746645e-48, -8.318068551721983e-49, -9.192159254097244e-50, -6.784349350979176e-51, -3.350950123445921e-52, -1.1085313631634886e-53, -2.4564791117097936e-55, -3.645432081980405e-57, -3.6208063474734884e-59, -2.4049242865080626e-61, -1.0668588806356642e-63, -3.1557009688341846e-66, -6.209607641963517e-69, -8.101929010691987e-72, -6.975418448055453e-75, -3.933183344065517e-78, -1.4342598769979332e-81, -3.303174350396232e-85, -4.5555430502157666e-89, -3.1744996386066104e-93, 0., 1.885503084368728e-101, 1.6071457651926545e-105, 6.922011965052965e-110, 1.7854548795253026e-114, 2.908924360156008e-119, 3.0653942537725766e-124, 2.1159626029790504e-129, 9.640060782194022e-135, 2.9128602177901286e-140, 5.856987673323527e-146, 7.855541259304253e-152, 7.040243513178422e-158, 4.2217107003096844e-164, 1.6956224541094914e-170, 4.565278086080562e-177, 8.245007860503921e-184, 9.993938987964611e-191, 8.133917112684553e-198, 4.446765419229423e-205, 1.633461745713816e-212, 4.032854743896242e-220, 6.69355999095283e-228, 7.470183251123254e-236, 5.606762484525374e-244, 2.8305298691128107e-252}, {-4.1608214280703616e-51, -5.2370646101422293e-51, -3.357164486340777e-51, -1.315659326690044e-51, -3.3260138418243474e-52, -5.540330470205014e-53, -6.138817920993315e-54, -4.544518142121676e-55, -2.252347569073968e-56, -7.480060194116553e-58, -1.6649411639246208e-59, -2.483436091339946e-61, -2.481331698802179e-63, -1.6596110704598515e-65, -7.423614455289268e-68, -2.2180367264741744e-70, -4.419080175743857e-73, -5.857272949111859e-76, -5.147923312050232e-79, -2.985660413184205e-82, -1.1341038112013168e-85, -2.786026008163612e-89, -4.32261281514058e-93, -4.0162449628708485e-97, -1.885503084368728e-101, 0., 5.08323490768209e-110, 2.919147182065817e-114, 8.470812089452209e-119, 1.4721000233642175e-123, 1.6159205214803372e-128, 1.1472976423261016e-133, 5.335839132477907e-139, 1.637879789525088e-144, 3.334507675344507e-150, 4.517501761438554e-156, 4.0823855844346534e-162, 2.4651381589047433e-168, 9.960000882530505e-175, 2.695373254855861e-181, 4.889644121619914e-188, 5.9500779590067346e-195, 4.859494104477796e-202, 2.6648822525687105e-209, 9.816292122902814e-217, 2.4296190343705677e-224, 4.041742811328424e-232, 4.520026707256871e-240, 3.398941215130917e-248, 1.7189129185486924e-256}, {-1.8492657310515994e-55, -2.3291630679320815e-55, -1.4947024138565225e-55, -5.866192009117973e-56, -1.4856350076029595e-56, -2.479894649370316e-57, -2.754376160043215e-58, -2.0445784333266994e-59, -1.016431216223998e-60, -3.3872242351731635e-62, -7.568892969011902e-64, -1.1340130142342162e-65, -1.1388582854234545e-67, -7.662450448279616e-70, -3.451458809361791e-72, -1.0398240214774018e-74, -2.0926067903785544e-77, -2.80831711333119e-80, -2.5073913347622077e-83, -1.4845173287015433e-86, -5.800054951821071e-90, -1.4842027082996033e-93, -2.4563096041504213e-97, -2.567494259992723e-101, -1.6071457651926545e-105, -5.08323490768209e-110, 0., 6.220481717264317e-119, 2.4067545925711588e-123, 4.705400594195623e-128, 5.509446915990277e-133, 4.07467405897051e-138, 1.9491890243812608e-143, 6.1078462461838334e-149, 1.2632148362353774e-154, 1.7327617745249898e-160, 1.5816826661034448e-166, 9.630541830227794e-173, 3.918278390495745e-179, 1.0666753270172566e-185, 1.9449661454813947e-192, 2.37734357406151e-199, 1.949216769317332e-206, 1.0726362227616993e-213, 3.9633679790788775e-221, 9.836935066922116e-229, 1.6405043771075938e-236, 1.83880481712242e-244, 1.3855956660335783e-252, 7.020507179029922e-261}, {-5.528069303333036e-60, -6.966948025599731e-60, -4.4753751298902853e-60, -1.7587703986567707e-60, -4.461423596913771e-61, -7.461439627836675e-62, -8.305319384795397e-63, -6.18015147347635e-64, -3.0808012252244742e-65, -1.0298261654336897e-66, -2.3091548442106927e-68, -3.473248918798038e-70, -3.503649035160492e-72, -2.3694046273658228e-74, -1.073621533721067e-76, -3.2571260264061566e-79, -6.609465295797988e-82, -8.959619496528433e-85, -8.099543183685018e-88, -4.871504111776211e-91, -1.942963924498506e-94, -5.1139949579315324e-98, -8.81614944397871e-102, -9.829559106382156e-106, -6.922011965052965e-110, -2.919147182065817e-114, -6.220481717264317e-119, 0., 3.4553148643430885e-128, 9.007228048414704e-133, 1.1864654080847277e-137, 9.359845403839514e-143, 4.663999822768407e-148, 1.5032358352499677e-153, 3.17373809352453e-159, 4.422543873439261e-165, 4.087405060620593e-171, 2.5138759922676487e-177, 1.0313178670674094e-183, 2.8271962556093387e-190, 5.185769110463714e-197, 6.371101744874548e-204, 5.2470744803697525e-211, 2.898740468895342e-218, 1.074797446637187e-225, 2.6758669911151184e-233, 4.474935832273441e-241, 5.028426970796292e-249, 3.797685037906295e-257, 1.928186979933573e-265}, {-1.1116359037008205e-64, -1.401779280616047e-64, -9.012906771213691e-65, -3.5463084530950932e-65, -9.009294233539282e-66, -1.5093746231028841e-66, -1.6834112148057745e-67, -1.2554406627241174e-68, -6.273859139840189e-70, -2.102966117095326e-71, -4.7299844638256165e-73, -7.139134819241994e-75, -7.229841109643085e-77, -4.9111270064021443e-79, -2.236733306906654e-81, -6.826133116249406e-84, -1.3948671504008717e-86, -1.906602421571528e-89, -1.7409883506733013e-92, -1.0602137264073096e-95, -4.295705479154791e-99, -1.1542101557464475e-102, -2.0466236627793998e-106, -2.37695987443061e-110, -1.7854548795253026e-114, -8.470812089452209e-119, -2.4067545925711588e-123, -3.4553148643430885e-128, 0., 8.712423092577381e-138, 1.5301768107121791e-142, 1.3580249009795234e-147, 7.218156708632879e-153, 2.423391991757595e-158, 5.262620935963562e-164, 7.486140903591704e-170, 7.028666706553698e-176, 4.376875103131912e-182, 1.8137509403852693e-188, 5.013548148146564e-195, 9.260381191232885e-202, 1.1444785337687015e-208, 9.473965512972544e-216, 5.257247268436038e-223, 1.956930856820992e-230, 4.888985311063618e-238, 8.201315329625623e-246, 9.241310158004955e-254, 6.996928538869981e-262, 3.560603002900814e-270}, {-1.5039064252843714e-69, -1.8974380122072447e-69, -1.221015933256813e-69, -4.809766340761278e-70, -1.2235920431312878e-70, -2.053230986919867e-71, -2.294124669471845e-72, -1.7143534356950837e-73, -8.586434939417776e-75, -2.88529830742278e-76, -6.507573296470802e-78, -9.852474415629638e-80, -1.0012272752086031e-81, -6.827853974678492e-84, -3.1235711822069002e-86, -9.581493715853449e-89, -1.969557328584273e-91, -2.7109550348631497e-94, -2.496100857801572e-97, -1.535410383770148e-100, -6.298839894541412e-104, -1.7192949253998687e-107, -3.1121342285102888e-111, -3.7177196233721747e-115, -2.908924360156008e-119, -1.4721000233642175e-123, -4.705400594195623e-128, -9.007228048414704e-133, -8.712423092577381e-138, 0., 9.972066233662748e-148, 1.1800217388834028e-152, 7.05604113123906e-158, 2.52689495997664e-163, 5.716028385889149e-169, 8.363436064406533e-175, 8.015941455635283e-181, 5.07090138940503e-187, 2.1276181855712454e-193, 5.940541560847488e-200, 1.1064042541655425e-206, 1.376952879908967e-213, 1.1466230020240225e-220, 6.395414751100409e-228, 2.3912241670664783e-235, 5.997404308907331e-243, 1.0095630805740828e-250, 1.1411059873721075e-258, 8.663723377106442e-267, 4.419852622930496e-275}, {-1.3689785709845997e-74, -1.7280520549995694e-74, -1.112890436418334e-74, -4.388435457075097e-75, -1.1178283832967877e-75, -1.8785222601455698e-76, -2.1024088676498198e-77, -1.5739939555068789e-78, -7.89955867562697e-80, -2.660482390137707e-81, -6.015508958682269e-83, -9.132746731339851e-85, -9.3095824906113e-87, -6.370690887054749e-89, -2.9258575877040596e-91, -9.015074517181318e-94, -1.8626278513203167e-96, -2.5790344918258525e-99, -2.3912412346993672e-102, -1.4831662790980128e-105, -6.145974235036848e-109, -1.6985391983727114e-112, -3.123366401416703e-116, -3.8088694624837764e-120, -3.0653942537725766e-124, -1.6159205214803372e-128, -5.509446915990277e-133, -1.1864654080847277e-137, -1.5301768107121791e-142, -9.972066233662748e-148, 0., 5.181227658779768e-158, 4.130879317804388e-163, 1.6642597705150348e-168, 4.0156608496572283e-174, 6.120348580932524e-180, 6.0336541079010766e-186, 3.896421049475686e-192, 1.660786607062713e-198, 4.695060692206569e-205, 8.832706802010622e-212, 1.1084170062036096e-218, 9.294610739327594e-226, 5.215028588467764e-233, 1.9598811256339052e-240, 4.9375017931431185e-248, 8.344055498901987e-256, 9.464007221247593e-264, 7.20769073903404e-272, 3.68726249697403e-280}, {-8.385587274927484e-80, -1.0589913214675067e-79, -6.825052496657836e-80, -2.6939249463313993e-80, -6.870099765532709e-81, -1.1561008110105734e-81, -1.2958698012555521e-82, -9.718161892096579e-84, -4.886473305334816e-85, -1.6490948599024808e-86, -3.7371487301112723e-88, -5.687936933854465e-90, -5.814164418846352e-92, -3.9910356176984793e-94, -1.8393201319043635e-96, -5.689486762006187e-99, -1.1807671928527178e-101, -1.6432995995540977e-104, -1.5327113997153106e-107, -9.573115085167956e-111, -3.9999843187095825e-114, -1.1166264946760646e-117, -2.0789800321542605e-121, -2.575507956023907e-125, -2.1159626029790504e-129, -1.1472976423261016e-133, -4.07467405897051e-138, -9.359845403839514e-143, -1.3580249009795234e-147, -1.1800217388834028e-152, -5.181227658779768e-158, 0., 1.222045481941273e-168, 6.564546276285464e-174, 1.781940291818472e-179, 2.896950021610065e-185, 2.9749113018346766e-191, 1.9760318901606537e-197, 8.597986223212544e-204, 2.4692413790325514e-210, 4.703392061565751e-217, 5.961909142152474e-224, 5.0410093523209056e-231, 2.8481931998462173e-238, 1.07676245768992e-245, 2.7265841194342143e-253, 4.628319361959712e-261, 5.270125800919185e-269, 4.027610072125904e-277, 2.0667969800237258e-285}, {-3.4567692148849066e-85, -4.367318501009121e-85, -2.8165990505044116e-85, -1.1127500085116855e-85, -2.840867598978037e-86, -4.786651836386471e-87, -5.372939940115923e-88, -4.0356520355564545e-89, -2.0326865018726593e-90, -6.872852535600079e-92, -1.5607275697561453e-93, -2.3808158939675834e-95, -2.439745782120776e-97, -1.6793727370109108e-99, -7.763562442641195e-102, -2.4098057320161072e-104, -5.020800082862827e-107, -7.018751384308437e-110, -6.579985475785614e-113, -4.134235748662793e-116, -1.739509058702054e-119, -4.8964401998419866e-123, -9.208473612563726e-127, -1.155035297533488e-130, -9.640060782194022e-135, -5.335839132477907e-139, -1.9491890243812608e-143, -4.663999822768407e-148, -7.218156708632879e-153, -7.05604113123906e-158, -4.130879317804388e-163, -1.222045481941273e-168, 0., 1.3084422373613392e-179, 4.735673203908268e-185, 8.66128047885199e-191, 9.487326461258324e-197, 6.564362253742246e-203, 2.937851175511746e-209, 8.612940273719276e-216, 1.666627316656444e-222, 2.1389848032998198e-229, 1.8268574240167616e-236, 1.0407842721379728e-243, 3.9622113273827945e-251, 1.0092855464430154e-258, 1.7220269003029763e-266, 1.9695730586488998e-274, 1.5111177813219169e-282, 7.781334249789502e-291}, {-9.590530855969622e-91, -1.2121623034478883e-90, -7.822546698308346e-91, -3.093054879386451e-91, -7.904679697221192e-92, -1.3334435102039469e-92, -1.4987335026729797e-93, -1.1273370146074049e-94, -5.6871832063441445e-96, -1.9262543977921253e-97, -4.382508826146338e-99, -6.699128064005096e-101, -6.880534245881831e-103, -4.7480069768049316e-105, -2.201049292755828e-107, -6.853195384394928e-110, -1.4328122864891527e-112, -2.0108328683515178e-115, -1.8935445664096492e-118, -1.1958240494782264e-121, -5.061464056688854e-125, -1.434684375508433e-128, -2.7206187337478493e-132, -3.446990583679693e-136, -2.9128602177901286e-140, -1.637879789525088e-144, -6.1078462461838334e-149, -1.5032358352499677e-153, -2.423391991757595e-158, -2.52689495997664e-163, -1.6642597705150348e-168, -6.564546276285464e-174, -1.3084422373613392e-179, 0., 6.359735859717839e-191, 1.5508799891155005e-196, 1.91113980134491e-202, 1.4104895578043005e-208, 6.575607686073406e-215, 1.9828597391935651e-221, 3.91682256022617e-228, 5.1067256340708955e-235, 4.416055395950333e-242, 2.5412967693332656e-249, 9.755205512993148e-257, 2.502299542212774e-264, 4.2947965623378905e-272, 4.937376213126367e-280, 3.805019976038434e-288, 1.9670367823514745e-296}, {-1.7909450017797888e-96, -2.264452527177144e-96, -1.4622119536696263e-96, -5.78619427156589e-97, -1.4801427019608392e-97, -2.4995895681330595e-98, -2.812859522865639e-99, -2.118650343062498e-100, -1.0703790720422463e-101, -3.631156597478209e-103, -8.275729880962191e-105, -1.2674247721817682e-106, -1.304438394779018e-108, -9.021905635230473e-111, -4.19279457126514e-113, -1.3090960628657977e-115, -2.745428430570821e-118, -3.8663585604430153e-121, -3.6551184059292222e-124, -2.3186099368752553e-127, -9.864112605309056e-131, -2.812649741568168e-134, -5.3709785958331816e-138, -6.861672058522111e-142, -5.856987673323527e-146, -3.334507675344507e-150, -1.2632148362353774e-154, -3.17373809352453e-159, -5.262620935963562e-164, -5.716028385889149e-169, -4.0156608496572283e-174, -1.781940291818472e-179, -4.735673203908268e-185, -6.359735859717839e-191, 0., 1.4032833466089422e-202, 2.3056764977138826e-208, 1.9143807266627008e-214, 9.51969547547935e-221, 2.9902529211069496e-227, 6.075531579011401e-234, 8.086260964320845e-241, 7.103610897038432e-248, 4.1389965879467532e-255, 1.6048738938839564e-262, 4.150953899771195e-270, 7.174269141735873e-278, 8.296763518262298e-286, 6.42674239536063e-294, 3.3371899883068894e-302}, {-2.251221706239357e-102, -2.847424762332571e-102, -1.839683807029883e-102, -7.285303365918888e-103, -1.8652868385326517e-103, -3.1532195910970105e-104, -3.5524427912319755e-105, -2.679040765145075e-106, -1.3553338603262405e-107, -4.604605366031162e-109, -1.0511068954848365e-110, -1.6125610475111474e-112, -1.66279467342814e-114, -1.1524210996962769e-116, -5.367872906610036e-119, -1.6801851773416172e-121, -3.5334618349603162e-124, -4.9915435407811916e-127, -4.7352130716203614e-130, -3.0155431323872798e-133, -1.2886363224066627e-136, -3.6932563876986725e-140, -7.09454663562846e-144, -9.126991330260819e-148, -7.855541259304253e-152, -4.517501761438554e-156, -1.7327617745249898e-160, -4.422543873439261e-165, -7.486140903591704e-170, -8.363436064406533e-175, -6.120348580932524e-180, -2.896950021610065e-185, -8.66128047885199e-191, -1.5508799891155005e-196, -1.4032833466089422e-202, 0., 1.4056509659022215e-214, 1.5561310647591828e-220, 8.705494344130447e-227, 2.916802533917753e-233, 6.173225689462329e-240, 8.451038528786929e-247, 7.578728271356062e-254, 4.4859214454765925e-261, 1.7611345626154525e-268, 4.601128297821408e-276, 8.018593960396272e-284, 9.338039865285606e-292, 7.276379259061305e-300, 3.7977539746561753e-308}, {-1.9049220629957704e-108, -2.4102120784270955e-108, -1.5580289450077808e-108, -6.174222193776954e-109, -1.5821352200754747e-109, -2.6771170780272313e-110, -3.0192656088963277e-111, -2.279595518045436e-112, -1.1547076759145015e-113, -3.928352465978508e-115, -8.980607505089603e-117, -1.3799688123066388e-118, -1.4254295216284986e-120, -9.897824351380363e-123, -4.619860044818207e-125, -1.4493376087534158e-127, -3.0556236511688627e-130, -4.3285156906920685e-133, -4.118946317640566e-136, -2.6321915953713677e-139, -1.1292292076013573e-142, -3.2508407073969493e-146, -6.276713972210436e-150, -8.122930750799667e-154, -7.040243513178422e-158, -4.0823855844346534e-162, -1.5816826661034448e-166, -4.087405060620593e-171, -7.028666706553698e-176, -8.015941455635283e-181, -6.0336541079010766e-186, -2.9749113018346766e-191, -9.487326461258324e-197, -1.91113980134491e-202, -2.3056764977138826e-208, -1.4056509659022215e-214, 0., 6.392035564358984e-227, 4.767878551547196e-233, 1.7971788450100815e-239, 4.0571881428139285e-246, 5.785645786849079e-253, 5.336697080533922e-260, 3.2246510347662104e-267, 1.2860653093375233e-274, 3.401965135665857e-282, 5.988644638861052e-290, 7.032183074532424e-298, 5.5179305085737675e-306, 2.897111095e-314}, {-1.0851338733580622e-114, -1.3734005809133884e-114, -8.882466837335786e-115, -3.522287719607726e-115, -9.032909409562704e-116, -1.5298220713580272e-116, -1.727056715686094e-117, -1.305371717666119e-118, -6.620009405611122e-120, -2.2550058702851894e-121, -5.162227208046544e-123, -7.944060138523371e-125, -8.218902973623082e-127, -5.716920834027009e-129, -2.6734547688858705e-131, -8.404497020489481e-134, -1.7759383907635308e-136, -2.522052368054294e-139, -2.4066111468312783e-142, -1.5426939316729796e-145, -6.641248443548465e-149, -1.919389420961842e-152, -3.722496041264482e-156, -4.842126335377998e-160, -4.2217107003096844e-164, -2.4651381589047433e-168, -9.630541830227794e-173, -2.5138759922676487e-177, -4.376875103131912e-182, -5.07090138940503e-187, -3.896421049475686e-192, -1.9760318901606537e-197, -6.564362253742246e-203, -1.4104895578043005e-208, -1.9143807266627008e-214, -1.5561310647591828e-220, -6.392035564358984e-227, 0., 1.3195743657247654e-239, 6.631911471340276e-246, 1.6843218883287758e-252, 2.5620081675965916e-259, 2.4616708769487582e-266, 1.5299407595017682e-273, 6.228877044318662e-281, 1.6738479994867363e-288, 2.983387969674841e-296, 3.538638228111096e-304, 2.799795733556e-312, 1.48e-320}, {-4.161585414419147e-121, -5.268670776090294e-121, -3.4091131581263615e-121, -1.352698158269066e-121, -3.4715645764604136e-122, -5.884433422860537e-123, -6.649292120510176e-124, -5.030882529116958e-125, -2.5541432304698472e-126, -8.71059125508359e-128, -1.9965929167020602e-129, -3.07673495343638e-131, -3.1878935013944396e-133, -2.220993420950482e-135, -1.0404289362540909e-137, -3.276973870328636e-140, -6.9388473767835315e-143, -9.876417270971954e-146, -9.447966353644613e-149, -6.073190166748839e-152, -2.6225834770347742e-155, -7.605855034416612e-159, -1.480876956853756e-162, -1.9348858404323055e-166, -1.6956224541094914e-170, -9.960000882530505e-175, -3.918278390495745e-179, -1.0313178670674094e-183, -1.8137509403852693e-188, -2.1276181855712454e-193, -1.660786607062713e-198, -8.597986223212544e-204, -2.937851175511746e-209, -6.575607686073406e-215, -9.51969547547935e-221, -8.705494344130447e-227, -4.767878551547196e-233, -1.3195743657247654e-239, 0., 1.2367010532699385e-252, 4.1878376741368463e-259, 7.16634611237862e-266, 7.344732460875182e-273, 4.754987449425712e-280, 1.9912187570269225e-287, 5.462356950354514e-295, 9.890385460198095e-303, 1.18777636839084e-310, 9.4927e-319, 0.}, {-1.0745437601656318e-127, -1.3607795949442155e-127, -8.808886311399698e-128, -3.4973076320652154e-128, -8.981760077400834e-129, -1.523651593422952e-129, -1.7232062616156998e-130, -1.3050285168955184e-131, -6.63235010647999e-133, -2.26438081049095e-134, -5.196445020889014e-136, -8.017893167851618e-138, -8.318971482199492e-140, -5.804378993876493e-142, -2.723429889404772e-144, -8.592733065289354e-147, -1.8229190682073014e-149, -2.6000260149424122e-152, -2.4928864863581157e-155, -1.606453412810759e-158, -6.956411657549057e-162, -2.0237016389784713e-165, -3.9538734900410935e-169, -5.1863154056572906e-173, -4.565278086080562e-177, -2.695373254855861e-181, -1.0666753270172566e-185, -2.8271962556093387e-190, -5.013548148146564e-195, -5.940541560847488e-200, -4.695060692206569e-205, -2.4692413790325514e-210, -8.612940273719276e-216, -1.9828597391935651e-221, -2.9902529211069496e-227, -2.916802533917753e-233, -1.7971788450100815e-239, -6.631911471340276e-246, -1.2367010532699385e-252, 0., 5.261804380374931e-266, 1.2005531032007023e-272, 1.3842422429831209e-279, 9.559038620633476e-287, 4.1697746320305574e-294, 1.1765439131802124e-301, 2.174683829175936e-309, 2.6531207e-317, 0., 0.}, {-1.8680909173096027e-134, -2.36633788685451e-134, -1.532472165632431e-134, -6.087585633729129e-135, -1.5644410980218203e-135, -2.65588177552488e-136, -3.0062080502505687e-137, -2.27872015515858e-138, -1.159197169589706e-139, -3.9617630563557515e-141, -9.101784821294612e-143, -1.4060356441286054e-144, -1.4606949792478308e-146, -1.0205671031824087e-148, -4.79562036741835e-151, -1.5154976814966635e-153, -3.2206679116333876e-156, -4.60233240537905e-159, -4.4218195302202173e-162, -2.8559628475700614e-165, -1.2398147109511237e-168, -3.6167850099592424e-172, -7.088289832710472e-176, -9.330028647220092e-180, -8.245007860503921e-184, -4.889644121619914e-188, -1.9449661454813947e-192, -5.185769110463714e-197, -9.260381191232885e-202, -1.1064042541655425e-206, -8.832706802010622e-212, -4.703392061565751e-217, -1.666627316656444e-222, -3.91682256022617e-228, -6.075531579011401e-234, -6.173225689462329e-240, -4.0571881428139285e-246, -1.6843218883287758e-252, -4.1878376741368463e-259, -5.261804380374931e-266, 0., 1.0163574903754694e-279, 1.5624853449066577e-286, 1.2138655687491567e-293, 5.648038950237771e-301, 1.660053208986545e-308, 3.1560542e-316, 5.e-324, 0., 0.}, {-2.1867436819734838e-141, -2.7706764710797607e-141, -1.7950428926924713e-141, -7.13434925398966e-142, -1.8345925315335586e-142, -3.1167110730288943e-143, -3.530573692684207e-144, -2.6784519974892064e-145, -1.363779107595619e-146, -4.665484225914759e-148, -1.0729646682842182e-149, -1.6593468985814942e-151, -1.7259041323113988e-153, -1.2074044378755152e-155, -5.681356299404282e-158, -1.7980649120530277e-160, -3.827290527714619e-163, -5.478707164662313e-166, -5.2737903295746736e-169, -3.413285577330273e-172, -1.4851241754868307e-175, -4.343259427847877e-179, -8.535702000244733e-183, -1.1269982513031978e-186, -9.993938987964611e-191, -5.9500779590067346e-195, -2.37734357406151e-199, -6.371101744874548e-204, -1.1444785337687015e-208, -1.376952879908967e-213, -1.1084170062036096e-218, -5.961909142152474e-224, -2.1389848032998198e-229, -5.1067256340708955e-235, -8.086260964320845e-241, -8.451038528786929e-247, -5.785645786849079e-253, -2.5620081675965916e-259, -7.16634611237862e-266, -1.2005531032007023e-272, -1.0163574903754694e-279, 0., 8.912563513998517e-294, 9.232004651392019e-301, 4.832541889524467e-308, 1.51505597e-315, 3.e-323, 0., 0., 0.}, {-1.7236130767915832e-148, -2.184396466151355e-148, -1.4157446331367933e-148, -5.629630172685851e-149, -1.4485118605753701e-149, -2.462464141419085e-150, -2.7915056093783954e-151, -2.119449310074077e-152, -1.0800757014945033e-153, -3.698309186247094e-155, -8.513630537338831e-157, -1.3180077145206316e-158, -1.372397260753797e-160, -9.61241330994439e-163, -4.528828575807299e-165, -1.4352756327590806e-167, -3.05959729495615e-170, -4.3867848749020705e-173, -4.230052320891488e-176, -2.742945953269942e-179, -1.1959296166760783e-182, -3.5054561284827458e-186, -6.906453699980581e-190, -9.144159718797315e-194, -8.133917112684553e-198, -4.859494104477796e-202, -1.949216769317332e-206, -5.2470744803697525e-211, -9.473965512972544e-216, -1.1466230020240225e-220, -9.294610739327594e-226, -5.0410093523209056e-231, -1.8268574240167616e-236, -4.416055395950333e-242, -7.103610897038432e-248, -7.578728271356062e-254, -5.336697080533922e-260, -2.4616708769487582e-266, -7.344732460875182e-273, -1.3842422429831209e-279, -1.5624853449066577e-286, -8.912563513998517e-294, 0., 3.548178694137534e-308, 2.47641732e-315, 9.e-323, 0., 0., 0., 0.}, {-9.148261987042918e-156, -1.1596554792262366e-155, -7.518631514785573e-156, -2.9911512976528953e-156, -7.700597129924984e-157, -1.3099298045984551e-157, -1.4860019112236177e-158, -1.1290959736137076e-159, -5.758536159558337e-161, -1.9734878583325223e-162, -4.547195978082751e-164, -7.046450810062669e-166, -7.344869536316638e-168, -5.1501430872997106e-170, -2.42934584060495e-172, -7.708910792329607e-175, -1.6455765761079376e-177, -2.362887658932435e-180, -2.282116944850957e-183, -1.482395341796272e-186, -6.475512704302558e-190, -1.9020034686738925e-193, -3.7558460765516653e-197, -4.985211398626235e-201, -4.446765419229423e-205, -2.6648822525687105e-209, -1.0726362227616993e-213, -2.898740468895342e-218, -5.257247268436038e-223, -6.395414751100409e-228, -5.215028588467764e-233, -2.8481931998462173e-238, -1.0407842721379728e-243, -2.5412967693332656e-249, -4.1389965879467532e-255, -4.4859214454765925e-261, -3.2246510347662104e-267, -1.5299407595017682e-273, -4.754987449425712e-280, -9.559038620633476e-287, -1.2138655687491567e-293, -9.232004651392019e-301, -3.548178694137534e-308, 0., 6.4e-323, 0., 0., 0., 0., 0.}, {-3.269701763506538e-163, -4.145649246522529e-163, -2.688754956994524e-163, -1.070151988160379e-163, -2.75653297443379e-164, -4.691897928055108e-165, -5.326070258510985e-166, -4.049746907786464e-167, -2.066997743268481e-168, -7.089484528534287e-170, -1.6349272894618315e-171, -2.5358496307990875e-173, -2.6458250311555855e-175, -1.8571556115692295e-177, -8.77002968130371e-180, -2.7862584335117778e-182, -5.955260266696706e-185, -8.562919451928487e-188, -8.282464751658038e-191, -5.3886647612692054e-194, -2.3580115125476565e-197, -6.939126655951137e-201, -1.3730916489025363e-204, -1.826674778289888e-208, -1.633461745713816e-212, -9.816292122902814e-217, -3.9633679790788775e-221, -1.074797446637187e-225, -1.956930856820992e-230, -2.3912241670664783e-235, -1.9598811256339052e-240, -1.07676245768992e-245, -3.9622113273827945e-251, -9.755205512993148e-257, -1.6048738938839564e-262, -1.7611345626154525e-268, -1.2860653093375233e-274, -6.228877044318662e-281, -1.9912187570269225e-287, -4.1697746320305574e-294, -5.648038950237771e-301, -4.832541889524467e-308, -2.47641732e-315, -6.4e-323, 0., 0., 0., 0., 0., 0.}, {-7.869756281949072e-171, -9.980110738332435e-171, -6.4749423406916315e-171, -2.578193653424366e-171, -6.644368780163204e-172, -1.1315867657520027e-172, -1.2853417764014622e-173, -9.779868537508653e-175, -4.9952629804784616e-176, -1.7146125423428474e-177, -3.9573388666586836e-179, -6.143325125487839e-181, -6.41563676629111e-183, -4.507659323671929e-185, -2.130864898806745e-187, -6.777336003479003e-190, -1.4502906678800165e-192, -2.0879997981772784e-195, -2.02238731282552e-198, -1.3177372464464173e-201, -5.775492210613176e-205, -1.7025604225666874e-208, -3.375351408135384e-212, -4.499652042437515e-216, -4.032854743896242e-220, -2.4296190343705677e-224, -9.836935066922116e-229, -2.6758669911151184e-233, -4.888985311063618e-238, -5.997404308907331e-243, -4.9375017931431185e-248, -2.7265841194342143e-253, -1.0092855464430154e-258, -2.502299542212774e-264, -4.150953899771195e-270, -4.601128297821408e-276, -3.401965135665857e-282, -1.6738479994867363e-288, -5.462356950354514e-295, -1.1765439131802124e-301, -1.660053208986545e-308, -1.51505597e-315, -9.e-323, 0., 0., 0., 0., 0., 0., 0.}, {-1.275586750125182e-178, -1.6179670722075227e-178, -1.0500394167520807e-178, -4.182750904029866e-179, -1.0784753338377698e-179, -1.837727356527713e-180, -2.088674621919286e-181, -1.590243802973182e-182, -8.128042930403525e-184, -2.791957757543851e-185, -6.448818786270418e-187, -1.0019233408910131e-188, -1.047240162926106e-190, -7.364723115551268e-193, -3.484861226452132e-195, -1.1095342153758536e-197, -2.3769471661173577e-200, -3.4261914419359e-203, -3.322766322439925e-206, -2.168005778212023e-209, -9.516199489070576e-213, -2.8097811563608788e-216, -5.580120715857011e-220, -7.452899769792741e-224, -6.69355999095283e-228, -4.041742811328424e-232, -1.6405043771075938e-236, -4.474935832273441e-241, -8.201315329625623e-246, -1.0095630805740828e-250, -8.344055498901987e-256, -4.628319361959712e-261, -1.7220269003029763e-266, -4.2947965623378905e-272, -7.174269141735873e-278, -8.018593960396272e-284, -5.988644638861052e-290, -2.983387969674841e-296, -9.890385460198095e-303, -2.174683829175936e-309, -3.1560542e-316, -3.e-323, 0., 0., 0., 0., 0., 0., 0., 0.}, {-1.3924046810752462e-186, -1.7664728390605318e-186, -1.146759123400157e-186, -4.569801548031139e-187, -1.1788155541132058e-187, -2.0097510892723697e-188, -2.2854852505660903e-189, -1.7411496587477362e-190, -8.905130134567841e-192, -3.060990328799809e-193, -7.075376418994853e-195, -1.1001161132625168e-196, -1.150812810902589e-198, -8.10010246412371e-201, -3.8363522675681175e-203, -1.2226382254943623e-205, -2.6219773236840304e-208, -3.7835879624000555e-211, -3.673742504940426e-214, -2.400068549297256e-217, -1.054928184834796e-220, -3.119426634526013e-224, -6.204993084716825e-228, -8.301902465785434e-232, -7.470183251123254e-236, -4.520026707256871e-240, -1.83880481712242e-244, -5.028426970796292e-249, -9.241310158004955e-254, -1.1411059873721075e-258, -9.464007221247593e-264, -5.270125800919185e-269, -1.9695730586488998e-274, -4.937376213126367e-280, -8.296763518262298e-286, -9.338039865285606e-292, -7.032183074532424e-298, -3.538638228111096e-304, -1.18777636839084e-310, -2.6531207e-317, -5.e-324, 0., 0., 0., 0., 0., 0., 0., 0., 0.}, {-1.0236185865425901e-194, -1.298846765484776e-194, -8.434256613422517e-195, -3.3622746465955766e-195, -8.677066899209104e-196, -1.4800776644820176e-196, -1.68405191181232e-197, -1.2837047166185474e-198, -6.569574869627904e-200, -2.2596576629702705e-201, -5.226730033517404e-203, -8.132720502819158e-205, -8.514064852934804e-207, -5.997597253755415e-209, -2.8430273441217527e-211, -9.069001455748311e-214, -1.946770404057805e-216, -2.8121713722759914e-219, -2.733565426684125e-222, -1.787973644440732e-225, -7.868911514194937e-229, -2.330036317405211e-232, -4.641647318920922e-236, -6.220193445791526e-240, -5.606762484525374e-244, -3.398941215130917e-248, -1.3855956660335783e-252, -3.797685037906295e-257, -6.996928538869981e-262, -8.663723377106442e-267, -7.20769073903404e-272, -4.027610072125904e-277, -1.5111177813219169e-282, -3.805019976038434e-288, -6.42674239536063e-294, -7.276379259061305e-300, -5.5179305085737675e-306, -2.799795733556e-312, -9.4927e-319, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}, {-5.0680145413249795e-203, -6.431800291703183e-203, -4.1777245133602185e-203, -1.6660207414278917e-203, -4.301331836512372e-204, -7.340403742728238e-205, -8.356317251633845e-206, -6.373304868165985e-207, -3.263561955349364e-208, -1.1232254204116606e-209, -2.5997942915337364e-211, -4.048042888341682e-213, -4.240951335640137e-215, -2.9897765032053834e-217, -1.418394566794831e-219, -4.528468023983726e-222, -9.72983630611095e-225, -1.406879476547151e-227, -1.3689788350991434e-230, -8.964192800441425e-234, -3.9498576657144024e-237, -1.1710724779093816e-240, -2.3360889315751697e-244, -3.135191312789557e-248, -2.8305298691128107e-252, -1.7189129185486924e-256, -7.020507179029922e-261, -1.928186979933573e-265, -3.560603002900814e-270, -4.419852622930496e-275, -3.68726249697403e-280, -2.0667969800237258e-285, -7.781334249789502e-291, -1.9670367823514745e-296, -3.3371899883068894e-302, -3.7977539746561753e-308, -2.897111095e-314, -1.48e-320, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}}, {{0., 4.919408776734851, 10.144441387784067, 9.46105706641167, 5.042621694720374, 1.6593004544231262, 0.34876213530507216, 0.04765599164066355, 0.004276714652912504, 0.00025367710093848625, 9.988093086201235e-6, 2.6182556509530583e-7, 4.579461667375587e-9, 5.35302078151641e-11, 4.1870831513010944e-13, 2.1937229951567647e-15, 7.704657293431296e-18, 1.8151216728980754e-20, 2.869917497662322e-23, 3.04674734840706e-26, 2.1725446251007732e-29, 1.040887700536731e-32, 3.3516605186885006e-36, 7.255029222443849e-40, 1.0559176735648517e-43, 1.0334998003363922e-47, 6.803753642645253e-52, 3.0130416716350175e-56, 8.977055226866636e-61, 1.799628783219106e-65, 2.427701878910668e-70, 2.2039918486854946e-75, 1.3466721808252088e-80, 5.538381385877773e-86, 1.5332105633637676e-91, 2.8572292258059285e-97, 3.584567902369295e-103, 3.0276041498594035e-109, 1.7216792363552868e-115, 6.591966307285829e-122, 1.6994351000711664e-128, 2.950102085002815e-135, 3.448475789279411e-142, 2.714493202667568e-149, 1.4389131520109328e-156, 5.1366099312920374e-164, 1.2348832905259975e-171, 1.999369114246182e-179, 2.180155816116692e-187, 1.6011009775453814e-195}, {-4.919408776734851, 0., 9.119766031923287, 10.969257172061912, 6.441201937730981, 2.22934085723357, 0.4832835253563645, 0.06742783984393676, 0.006142500107346495, 0.0003684923564511156, 0.000014637503967435921, 3.8643535078202627e-7, 6.798398163010211e-9, 7.985500802781767e-11, 6.271979339501582e-13, 3.297702928867621e-15, 1.1617610956537154e-17, 2.7443391242239305e-20, 4.349443216791942e-23, 4.6272092612556674e-26, 3.305779685186886e-29, 1.5865359771249344e-32, 5.116545608723877e-36, 1.109088478401426e-39, 1.6162724239797435e-43, 1.5838213906470263e-47, 1.0437945493701367e-51, 4.627071619521734e-56, 1.3798681758653142e-60, 2.7686027286937493e-65, 3.7378460795738233e-70, 3.3959499516658365e-75, 2.0764311737597954e-80, 8.545233426566271e-86, 2.3670698490679875e-91, 4.413741007835412e-97, 5.540343576276414e-103, 4.681919337458348e-109, 2.6637282441007805e-115, 1.0203621325891093e-121, 2.6316935410561927e-128, 4.570351670555626e-135, 5.344569887872295e-142, 4.208614368072984e-149, 2.2317323799358374e-156, 7.969556566903162e-164, 1.9165796661854994e-171, 3.104067226360578e-179, 3.385766719862968e-187, 2.4872195511772787e-195}, {-10.144441387784067, -9.119766031923287, 0., 5.080764929998883, 3.9343885331052206, 1.5211148490006154, 0.35004456836904924, 0.05069842469669736, 0.004738292008546001, 0.0002896025454088792, 0.000011668115339661347, 3.114973650040598e-7, 5.52959389459484e-9, 6.543499273064056e-11, 5.171456419561449e-13, 2.733481650302494e-15, 9.673825392898303e-18, 2.294239598661633e-20, 3.6487505892021917e-23, 3.8937260620733114e-26, 2.789398117792091e-29, 1.342004544606038e-32, 4.337541004452217e-36, 9.421185282635965e-40, 1.3754617774132353e-43, 1.3501026636453592e-47, 8.91133201153994e-52, 3.9559269487028935e-56, 1.1812654252170989e-60, 2.3729954532804475e-65, 3.20735439073265e-70, 2.917042656042299e-75, 1.785356640555001e-80, 7.354110798245691e-86, 2.0388790979405996e-91, 3.80486269090762e-97, 4.779694298585704e-103, 4.0420334474377804e-109, 2.3012365390783085e-115, 8.820744532573423e-122, 2.2764138714652827e-128, 3.955642789846296e-135, 4.6282764126318316e-142, 3.646474544250865e-149, 1.9346078902592746e-156, 6.911809986140221e-164, 1.662960687674082e-171, 2.694480192592439e-179, 2.9402315893413286e-187, 2.160785397026153e-195}, {-9.46105706641167, -10.969257172061912, -5.080764929998883, 0., 1.1437888522210626, 0.5875965571623101, 0.15178886173187642, 0.023414970733278712, 0.002277135663069949, 0.0001430411429501497, 5.879629024018909e-6, 1.5937991414429979e-7, 2.863502685120504e-9, 3.421674831893403e-11, 2.726011025221439e-13, 1.4506303956073176e-15, 5.1633263495082296e-18, 1.230597600243476e-20, 1.9655750976533415e-23, 2.105483838825937e-26, 1.5133870507438813e-29, 7.302793295122559e-33, 2.36668761074611e-36, 5.152898178868116e-40, 7.539550569211827e-44, 7.415320881652156e-48, 4.9034092561189254e-52, 2.180375765293571e-56, 6.520801499618372e-61, 1.3118075292988038e-65, 1.775393998308671e-70, 1.616682665535224e-75, 9.90615045964714e-81, 4.084842766255274e-86, 1.1336325576621578e-91, 2.1175254683774499e-97, 2.6624052127589833e-103, 2.2533881610825845e-109, 1.2839231098949114e-115, 4.92499628587605e-122, 1.2719134345821196e-128, 2.211633553592607e-135, 2.58934833400951e-142, 2.041295434214596e-149, 1.0836137496993513e-156, 3.873561846430825e-164, 9.324529452679726e-172, 1.5115969231301005e-179, 1.650247559508316e-187, 1.2133242021838497e-195}, {-5.042621694720374, -6.441201937730981, -3.9343885331052206, -1.1437888522210626, 0., 0.11258126625370087, 0.03873812008263481, 0.006718535463273669, 0.0006966531441487243, 0.00004557094704475228, 1.9262620676057453e-6, 5.329419816885885e-8, 9.725788031897745e-10, 1.1765584084147263e-11, 9.467338840864772e-14, 5.079585043673851e-16, 1.8205365662247104e-18, 4.36454636367505e-21, 7.006692743607728e-24, 7.538610940447305e-27, 5.4396734057528116e-30, 2.6339198933312842e-33, 8.562170480535198e-37, 1.86933600295722e-40, 2.7419380781434313e-44, 2.7028272071142068e-48, 1.790918309058282e-52, 7.978523550203266e-57, 2.3902275671670586e-61, 4.816114874028228e-66, 6.5276658872070874e-71, 5.952207809618014e-76, 3.6517994444191353e-81, 1.507609325681258e-86, 4.188549916577641e-92, 7.831908080918445e-98, 9.856735260949598e-104, 8.350065005104081e-110, 4.7617311459404915e-116, 1.8280278218050143e-122, 4.724613037548099e-129, 8.221213978288903e-136, 9.631879244956958e-143, 7.598171670250405e-150, 4.0359563984694375e-157, 1.4435712340770577e-164, 3.4769494428851735e-172, 5.63949175704757e-180, 6.159920805622182e-188, 4.531220417731682e-196}, {-1.6593004544231262, -2.22934085723357, -1.5211148490006154, -0.5875965571623101, -0.11258126625370087, 0., 0.004960534213544862, 0.0011468036695754702, 0.00013375560739303745, 9.331773578393811e-6, 4.108528226856722e-7, 1.1691226737355413e-8, 2.1779124497313007e-10, 2.6764134324917904e-12, 2.1804706114493108e-14, 1.1816941674291647e-16, 4.270431549009319e-19, 1.0309333350637315e-21, 1.6648520357885566e-24, 1.800403513180673e-27, 1.3049113543661841e-30, 6.343168526253686e-34, 2.0691362843379116e-37, 4.5313922815159817e-41, 6.665052060293233e-45, 6.586405747075945e-49, 4.374106362167196e-53, 1.9526841159052155e-57, 5.860954127888076e-62, 1.1829831956778725e-66, 1.6059545901096211e-71, 1.4665425327631392e-76, 9.009860662131985e-82, 3.7243699081050154e-87, 1.0359601075865512e-92, 1.9392261382057257e-98, 2.443120683891438e-104, 2.071690521481769e-110, 1.1824909204327366e-116, 4.5435006235784146e-123, 1.1752432294419119e-129, 2.046594496235319e-136, 2.399514504677444e-143, 1.8941811350429483e-150, 1.0068012130481347e-157, 3.603348544433653e-165, 8.684086989791324e-173, 1.4093256642118256e-180, 1.5402131744332968e-188, 1.133560415546804e-196}, {-0.34876213530507216, -0.4832835253563645, -0.35004456836904924, -0.15178886173187642, -0.03873812008263481, -0.004960534213544862, 0., 0.00009857317830951732, 0.00001532820763007864, 1.203034288133094e-6, 5.649587451381136e-8, 1.6745987866229303e-9, 3.208627058771875e-11, 4.025149481333244e-13, 3.331306832802195e-15, 1.8279377949693955e-17, 6.672526736663364e-20, 1.6242433910869258e-22, 2.6413185775262994e-25, 2.8733652653364636e-28, 2.093254720530313e-31, 1.0220699272385358e-34, 3.3470497795081795e-38, 7.355448122556852e-42, 1.0852321585441054e-45, 1.0754036833131177e-49, 7.15976509561819e-54, 3.203514574064185e-58, 9.635198835798637e-63, 1.9484629380075095e-67, 2.649726085299205e-72, 2.4235799758411275e-77, 1.4911566461574192e-82, 6.17239569580943e-88, 1.7190872448147669e-93, 3.221808407690634e-99, 4.063485112173983e-105, 3.449296170160824e-111, 1.9707315209273884e-117, 7.579123068812097e-124, 1.9621478301840195e-130, 3.419717278067328e-137, 4.0125161130342304e-144, 3.169801417624194e-151, 1.685989785249384e-158, 6.038136353643945e-166, 1.4561031632668956e-173, 2.364490638073898e-181, 2.5855513944426485e-189, 1.9039336028428995e-197}, {-0.04765599164066355, -0.06742783984393676, -0.05069842469669736, -0.023414970733278712, -0.006718535463273669, -0.0011468036695754702, -0.00009857317830951732, 0., 8.85737146765372e-7, 9.268791133697763e-8, 4.896772527528342e-9, 1.5482095731351801e-10, 3.0900457426833138e-12, 3.987131880417728e-14, 3.3685801661565964e-16, 1.8777257291162836e-18, 6.939934074348485e-21, 1.7063979203011523e-23, 2.7980378960145756e-26, 3.0651353252003963e-29, 2.246249195696118e-32, 1.1023959061525748e-35, 3.626213413573002e-39, 8.000181702046549e-43, 1.184454801206411e-46, 1.177360979747694e-50, 7.860341352912296e-55, 3.525788550972604e-59, 1.0628598436968253e-63, 2.1538009143739892e-68, 2.9345128037572685e-73, 2.6887282026134787e-78, 1.6569451529809592e-83, 6.868809077659462e-89, 1.9156742312399467e-94, 3.5948242443349855e-100, 4.539345628760968e-106, 3.8575166126392238e-112, 2.206260877038632e-118, 8.493224711160898e-125, 2.2008188650232387e-131, 3.839004025315587e-138, 4.508164635360609e-145, 3.5641027230057224e-152, 1.8971007498765653e-159, 6.798908336785415e-167, 1.6406426416587117e-174, 2.6658206224318783e-182, 2.916788164249011e-190, 2.149065940910853e-198}, {-0.004276714652912504, -0.006142500107346495, -0.004738292008546001, -0.002277135663069949, -0.0006966531441487243, -0.00013375560739303745, -0.00001532820763007864, -8.85737146765372e-7, 0., 3.6030834962466074e-9, 2.5380384149514724e-10, 9.027541195382963e-12, 1.921908301474902e-13, 2.583191653067359e-15, 2.2447966570653453e-17, 1.2773703754271362e-19, 4.7960006268386715e-22, 1.1939854994039116e-24, 1.977593332758807e-27, 2.1844245595906537e-30, 1.6120246599410274e-33, 7.958453266012224e-37, 2.631272455773754e-40, 5.831049668937545e-44, 8.666926349519676e-48, 8.644931408806338e-52, 5.789429356585064e-56, 2.6040856980315936e-60, 7.869770432036033e-65, 1.598370656875539e-69, 2.1822582667005002e-74, 2.0032666453049614e-79, 1.2366722078079367e-84, 5.134797422446017e-90, 1.4341891270885868e-95, 2.694998680357698e-101, 3.407441637426588e-107, 2.899076461165784e-113, 1.6599367034835346e-119, 6.396750564749575e-126, 1.65918727521648e-132, 2.8968675897703062e-139, 3.404753544915834e-146, 2.6939577655886126e-153, 1.4350472018103305e-160, 5.146741015923254e-168, 1.2428192593483701e-175, 2.0207403711206116e-183, 2.2123609910192554e-191, 1.6310199243450518e-199}, {-0.00025367710093848625, -0.0003684923564511156, -0.0002896025454088792, -0.0001430411429501497, -0.00004557094704475228, -9.331773578393811e-6, -1.203034288133094e-6, -9.268791133697763e-8, -3.6030834962466074e-9, 0., 6.639743743561485e-12, 3.1489150337398494e-13, 7.541824152657882e-15, 1.0812569902792981e-16, 9.787639347811635e-19, 5.7286483283226404e-21, 2.1956814422821505e-23, 5.553010894861958e-26, 9.312396362571083e-29, 1.0390256883525864e-31, 7.731522263577005e-35, 3.843690674644226e-38, 1.2783888702711722e-41, 2.8475105629348336e-45, 4.2512651501163006e-49, 4.257105460523418e-53, 2.860842562432859e-57, 1.2907910582492833e-61, 3.911717027421633e-66, 7.964709699476606e-71, 1.089894609969121e-75, 1.002571467182461e-80, 6.2008742437715946e-86, 2.5791480327255017e-91, 7.215306800417822e-97, 1.3578439169088971e-102, 1.719158282390289e-108, 1.464540558453514e-114, 8.395565741407311e-121, 3.2389233348851243e-127, 8.409860873601171e-134, 1.4697598078009712e-140, 1.729029422491669e-147, 1.3692518368846403e-154, 7.299841043804396e-162, 2.620081269009994e-169, 6.331516891798153e-177, 1.0301753945887935e-184, 1.1286057808404243e-192, 8.325629128847698e-201}, {-9.988093086201235e-6, -0.000014637503967435921, -0.000011668115339661347, -5.879629024018909e-6, -1.9262620676057453e-6, -4.108528226856722e-7, -5.649587451381136e-8, -4.896772527528342e-9, -2.5380384149514724e-10, -6.639743743561485e-12, 0., 5.545281717597031e-15, 1.770833455423477e-16, 2.8561611662573855e-18, 2.757785132503922e-20, 1.6813702959945632e-22, 6.628495660395283e-25, 1.7113112218067296e-27, 2.9154214038915e-30, 3.293526730962637e-33, 2.475510176212208e-36, 1.2409441979217037e-39, 4.156169516947577e-43, 9.3126446928906e-47, 1.3974855891826481e-50, 1.4056527629931634e-54, 9.483253971839823e-59, 4.293631055188679e-63, 1.3052048863084058e-67, 2.664930641304631e-72, 3.655843175453372e-77, 3.370577399118154e-82, 2.0890080649497083e-87, 8.70532942730063e-93, 2.4395986272889458e-98, 4.5984223281746774e-104, 5.83066097388976e-110, 4.97392780368044e-116, 2.854975199990582e-122, 1.1027314235204994e-128, 2.866425838407712e-135, 5.0147630753560176e-142, 5.9051476110927755e-149, 4.68069874474002e-156, 2.4975639120363972e-163, 8.971656550254283e-171, 2.1697059484759537e-178, 3.5328209942376755e-186, 3.873054353863989e-194, 2.858999029606498e-202}, {-2.6182556509530583e-7, -3.8643535078202627e-7, -3.114973650040598e-7, -1.5937991414429979e-7, -5.329419816885885e-8, -1.1691226737355413e-8, -1.6745987866229303e-9, -1.5482095731351801e-10, -9.027541195382963e-12, -3.1489150337398494e-13, -5.545281717597031e-15, 0., 2.0995541164939176e-18, 4.515135419042515e-20, 4.904570772536725e-22, 3.1895738750994416e-24, 1.309824266181521e-26, 3.4782557033242237e-29, 6.049071039311317e-32, 6.942053581339931e-35, 5.283071816907574e-38, 2.6750928150954203e-41, 9.034080946587534e-45, 2.0384037599550676e-48, 3.077102323163445e-52, 3.1109577257372683e-56, 2.1081812164649787e-60, 9.582416985050217e-65, 2.9230375025118e-69, 5.9866531082394695e-74, 8.235508918116734e-79, 7.611921200748945e-84, 4.728419597003023e-89, 1.974509978212443e-94, 5.54388549800533e-100, 1.0467895179883653e-105, 1.3294246502941975e-111, 1.1357646236855133e-117, 6.52810827366179e-124, 2.524695812188364e-130, 6.570474417632892e-137, 1.150771918657803e-143, 1.3565060928784306e-150, 1.0762818180726029e-157, 5.748187263825062e-165, 2.0666302735392142e-172, 5.00202315292177e-180, 8.150827152001396e-188, 8.942336192210287e-196, 6.605599998432656e-204}, {-4.579461667375587e-9, -6.798398163010211e-9, -5.52959389459484e-9, -2.863502685120504e-9, -9.725788031897745e-10, -2.1779124497313007e-10, -3.208627058771875e-11, -3.0900457426833138e-12, -1.921908301474902e-13, -7.541824152657882e-15, -1.770833455423477e-16, -2.0995541164939176e-18, 0., 3.604664331983503e-22, 5.220760690947186e-24, 3.819600713059264e-26, 1.6731198585295503e-28, 4.628116615740884e-31, 8.278772106785285e-34, 9.6988456120032e-37, 7.498217316356113e-40, 3.844194871981964e-43, 1.3113400421103016e-46, 2.9834975173560643e-50, 4.535277459626684e-54, 4.61246895017753e-58, 3.141729177166378e-62, 1.43440031172382e-66, 4.392679097364488e-71, 9.027854249635582e-76, 1.2457571099478261e-80, 1.1546275545813258e-85, 7.190361706684609e-91, 3.0094004038387378e-96, 8.467069504310191e-102, 1.6017693809353377e-107, 2.0377879426010975e-113, 1.743729142748934e-119, 1.003739373661755e-125, 3.88721731217134e-132, 1.0129331626687886e-138, 1.776192477624695e-145, 2.096067852655796e-152, 1.6647987715732016e-159, 8.900019824847662e-167, 3.2027411313526933e-174, 7.758550615453711e-182, 1.2652934343416452e-189, 1.3892352596449548e-197, 1.026962123607876e-205}, {-5.35302078151641e-11, -7.985500802781767e-11, -6.543499273064056e-11, -3.421674831893403e-11, -1.1765584084147263e-11, -2.6764134324917904e-12, -4.025149481333244e-13, -3.987131880417728e-14, -2.583191653067359e-15, -1.0812569902792981e-16, -2.8561611662573855e-18, -4.515135419042515e-20, -3.604664331983503e-22, 0., 2.806838907505568e-26, 2.7380438728278052e-28, 1.3492797817518826e-30, 3.981144814622851e-33, 7.418197238229033e-36, 8.938959116970544e-39, 7.054719822024791e-42, 3.674231927753178e-45, 1.2690289397963513e-48, 2.9163973138133777e-52, 4.470221000374936e-56, 4.578097558141513e-60, 3.136878919564343e-64, 1.4395304016152791e-68, 4.428069692325367e-73, 9.136277747051674e-78, 1.2650960051452532e-82, 1.1761819631472533e-87, 7.344936350277083e-93, 3.081799421607793e-98, 8.690473351367954e-104, 1.6474359004321009e-109, 2.099854851335349e-115, 1.7999645521999414e-121, 1.0377704844334965e-127, 4.0249648999323744e-134, 1.0502681997193725e-140, 1.8440120437530775e-147, 2.1786916741941688e-154, 1.7323474492830484e-161, 9.270782298473123e-169, 3.339424038032905e-176, 8.097096475686691e-184, 1.3216480527844183e-191, 1.452295642481923e-199, 1.074407165800494e-207}, {-4.1870831513010944e-13, -6.271979339501582e-13, -5.171456419561449e-13, -2.726011025221439e-13, -9.467338840864772e-14, -2.1804706114493108e-14, -3.331306832802195e-15, -3.3685801661565964e-16, -2.2447966570653453e-17, -9.787639347811635e-19, -2.757785132503922e-20, -4.904570772536725e-22, -5.220760690947186e-24, -2.806838907505568e-26, 0., 9.91401029241189e-31, 6.514029361860202e-33, 2.1622614062729773e-35, 4.2976131635585627e-38, 5.394418831642974e-41, 4.378969684344209e-44, 2.328164042532807e-47, 8.168794323708102e-51, 1.9007638193066942e-54, 2.9428983870888296e-58, 3.0390331672904823e-62, 2.0968849712692054e-66, 9.67999460957271e-71, 2.9928860482444407e-75, 6.20268216539131e-80, 8.622505959447074e-85, 8.044330200165412e-90, 5.0390178681853235e-95, 2.120151679074893e-100, 5.993673627137889e-106, 1.1387911862272863e-111, 1.4545313236205785e-117, 1.2491641280582288e-123, 7.214587503451444e-130, 2.802642578572171e-136, 7.324007111953823e-143, 1.2876814623372776e-149, 1.5233326998021361e-156, 1.2126925279211913e-163, 6.497030435940009e-171, 2.342730016520112e-178, 5.6859666726547036e-186, 9.289445706806621e-194, 1.021656410772371e-201, 7.564381038235726e-210}, {-2.1937229951567647e-15, -3.297702928867621e-15, -2.733481650302494e-15, -1.4506303956073176e-15, -5.079585043673851e-16, -1.1816941674291647e-16, -1.8279377949693955e-17, -1.8777257291162836e-18, -1.2773703754271362e-19, -5.7286483283226404e-21, -1.6813702959945632e-22, -3.1895738750994416e-24, -3.819600713059264e-26, -2.7380438728278052e-28, -9.91401029241189e-31, 0., 1.5885929634604326e-35, 7.030882758698282e-38, 1.5721048334379627e-40, 2.104881097643024e-43, 1.7798508520011543e-46, 9.733290961031781e-50, 3.486253254415006e-53, 8.240784408287463e-57, 1.2918458507611796e-60, 1.3475214063045084e-64, 9.375165960221952e-69, 4.3581876676934926e-73, 1.355496550147804e-77, 2.823639331418188e-82, 3.9427359957116242e-87, 3.69278368611004e-92, 2.3212142756953025e-97, 9.796676212898308e-103, 2.777215715704456e-108, 5.289903095657847e-114, 6.771932341830355e-120, 5.8278352667954035e-126, 3.3722597401865846e-132, 1.312296186889711e-138, 3.434854429957179e-145, 6.047988345384634e-152, 7.164624201975796e-159, 5.71088813536741e-166, 3.0632649565789154e-173, 1.105795252710964e-180, 2.686636703353224e-188, 4.393582213878126e-196, 4.836517967958133e-204, 3.5840758180273373e-212}, {-7.704657293431296e-18, -1.1617610956537154e-17, -9.673825392898303e-18, -5.1633263495082296e-18, -1.8205365662247104e-18, -4.270431549009319e-19, -6.672526736663364e-20, -6.939934074348485e-21, -4.7960006268386715e-22, -2.1956814422821505e-23, -6.628495660395283e-25, -1.309824266181521e-26, -1.6731198585295503e-28, -1.3492797817518826e-30, -6.514029361860202e-33, -1.5885929634604326e-35, 0., 1.1549155024629923e-40, 3.4431868769047955e-43, 5.186318476288197e-46, 4.677824760239801e-49, 2.6647029981820245e-52, 9.817083695173419e-56, 2.3689012440114023e-59, 3.772493695926296e-63, 3.9842679043267636e-67, 2.7999909635965208e-71, 1.3124649586766568e-75, 4.110613657524813e-80, 8.613802102036834e-85, 1.2089402163248656e-89, 1.1373535707557703e-94, 7.17722637865711e-100, 3.0396635894205522e-105, 8.643683750790259e-111, 1.650979467524252e-116, 2.1188180396511264e-122, 1.8275708889925773e-128, 1.0597080002209718e-134, 4.1316051654470393e-141, 1.083302935068856e-147, 1.910504024193573e-154, 2.2665919921845482e-161, 1.809171495700794e-168, 9.716613915322423e-176, 3.511735636887722e-183, 8.541592628893943e-191, 1.3983014997753842e-198, 1.5407748983136514e-206, 1.1428324451267053e-214}, {-1.8151216728980754e-20, -2.7443391242239305e-20, -2.294239598661633e-20, -1.230597600243476e-20, -4.36454636367505e-21, -1.0309333350637315e-21, -1.6242433910869258e-22, -1.7063979203011523e-23, -1.1939854994039116e-24, -5.553010894861958e-26, -1.7113112218067296e-27, -3.4782557033242237e-29, -4.628116615740884e-31, -3.981144814622851e-33, -2.1622614062729773e-35, -7.030882758698282e-38, -1.1549155024629923e-40, 0., 3.80976181480601e-46, 7.651298558243482e-49, 7.763766004373432e-52, 4.7174360698203796e-55, 1.8103747066892784e-58, 4.493320449086807e-62, 7.304723835829445e-66, 7.837241622314401e-70, 5.5765598165188764e-74, 2.640354606730942e-78, 8.338449939056892e-83, 1.7595435052772066e-87, 2.4842046329431228e-92, 2.349089144088168e-97, 1.489001539705915e-102, 6.33087601641243e-108, 1.8065189055759794e-113, 3.461208823122087e-119, 4.4543515824076303e-125, 3.851697381918212e-131, 2.2384636829744625e-137, 8.745424248013414e-144, 2.2973847818208178e-150, 4.0586949921276385e-157, 4.822888666195058e-164, 3.855285511867273e-171, 2.073422968799552e-178, 7.50324407674386e-186, 1.827186273140676e-193, 2.994522703737043e-201, 3.303072724823627e-209, 2.45236904599753e-217}, {-2.869917497662322e-23, -4.349443216791942e-23, -3.6487505892021917e-23, -1.9655750976533415e-23, -7.006692743607728e-24, -1.6648520357885566e-24, -2.6413185775262994e-25, -2.7980378960145756e-26, -1.977593332758807e-27, -9.312396362571083e-29, -2.9154214038915e-30, -6.049071039311317e-32, -8.278772106785285e-34, -7.418197238229033e-36, -4.2976131635585627e-38, -1.5721048334379627e-40, -3.4431868769047955e-43, -3.80976181480601e-46, 0., 5.7027658582753515e-52, 7.715455420504273e-55, 5.274091675953654e-58, 2.158931426215011e-61, 5.581700555404162e-65, 9.33334672416921e-69, 1.022237190343891e-72, 7.389145704080593e-77, 3.542298497776827e-81, 1.1299859105015663e-85, 2.4043176041261536e-90, 3.4182643758256816e-95, 3.2515856803347683e-100, 2.071630571017017e-105, 8.847396129328012e-111, 2.5345097134943257e-116, 4.872867541908105e-122, 6.290479985927689e-128, 5.454515139038243e-134, 3.1779066916429728e-140, 1.2443939301100429e-146, 3.275736595452664e-153, 5.798069245383411e-160, 6.901744175783405e-167, 5.525907295222857e-174, 2.9763080352910375e-181, 1.0785373630872128e-188, 2.6298031737754917e-196, 4.3150391574472005e-204, 4.764947110876846e-212, 3.54142402419798e-220}, {-3.04674734840706e-26, -4.6272092612556674e-26, -3.8937260620733114e-26, -2.105483838825937e-26, -7.538610940447305e-27, -1.800403513180673e-27, -2.8733652653364636e-28, -3.0651353252003963e-29, -2.1844245595906537e-30, -1.0390256883525864e-31, -3.293526730962637e-33, -6.942053581339931e-35, -9.6988456120032e-37, -8.938959116970544e-39, -5.394418831642974e-41, -2.104881097643024e-43, -5.186318476288197e-46, -7.651298558243482e-49, -5.7027658582753515e-52, 0., 3.8738152018745094e-58, 3.53072379129422e-61, 1.6259509496574668e-64, 4.4839818852659265e-68, 7.810223863204734e-72, 8.798572480187597e-76, 6.492464922053984e-80, 3.161840521653712e-84, 1.0212283587904578e-88, 2.1948582605526084e-93, 3.146475949794511e-98, 3.0139804053823687e-103, 1.9316789908179664e-108, 8.292005428369245e-114, 2.3860116777742562e-119, 4.6053537585641137e-125, 5.965784063914317e-131, 5.188984627963002e-137, 3.031601234717143e-143, 1.1900793335549627e-149, 3.1398790198364025e-156, 5.569107114540091e-163, 6.641753912110388e-170, 5.326993370313589e-177, 2.873769068850379e-184, 1.0429226680374686e-191, 2.5464567624919904e-199, 4.183618772568727e-207, 4.6253239581936964e-215, 3.441476580534321e-223}, {-2.1725446251007732e-29, -3.305779685186886e-29, -2.789398117792091e-29, -1.5133870507438813e-29, -5.4396734057528116e-30, -1.3049113543661841e-30, -2.093254720530313e-31, -2.246249195696118e-32, -1.6120246599410274e-33, -7.731522263577005e-35, -2.475510176212208e-36, -5.283071816907574e-38, -7.498217316356113e-40, -7.054719822024791e-42, -4.378969684344209e-44, -1.7798508520011543e-46, -4.677824760239801e-49, -7.763766004373432e-52, -7.715455420504273e-55, -3.8738152018745094e-58, 0., 1.1942074552425857e-64, 7.3326711866740975e-68, 2.2749462630411067e-71, 4.2266812657730233e-75, 4.959946587174239e-79, 3.764513439879258e-83, 1.8715181521630607e-87, 6.14067869070219e-92, 1.3362724628721495e-96, 1.9349857057897783e-101, 1.8689509059637337e-106, 1.206198766117198e-111, 5.2085990104718766e-117, 1.5064522529485462e-122, 2.920655287840597e-128, 3.7982593946899923e-134, 3.3151625684991708e-140, 1.9428398784605306e-146, 7.647958954858973e-153, 2.0228777875884927e-159, 3.596070643545917e-166, 4.2975768818712725e-173, 3.4533832668256562e-180, 1.8662470266990974e-187, 6.783671319322792e-195, 1.6587919535591963e-202, 2.72900207339788e-210, 3.0209825685884314e-218, 2.2504407923353746e-226}, {-1.040887700536731e-32, -1.5865359771249344e-32, -1.342004544606038e-32, -7.302793295122559e-33, -2.6339198933312842e-33, -6.343168526253686e-34, -1.0220699272385358e-34, -1.1023959061525748e-35, -7.958453266012224e-37, -3.843690674644226e-38, -1.2409441979217037e-39, -2.6750928150954203e-41, -3.844194871981964e-43, -3.674231927753178e-45, -2.328164042532807e-47, -9.733290961031781e-50, -2.6647029981820245e-52, -4.7174360698203796e-55, -5.274091675953654e-58, -3.53072379129422e-61, -1.1942074552425857e-64, 0., 1.6708099937237115e-71, 6.911538518879956e-75, 1.444626614099137e-78, 1.8082639987996256e-82, 1.4296260568472266e-86, 7.310416204324359e-91, 2.4486080667034847e-95, 5.412991506013635e-100, 7.936245974698148e-105, 7.742835943575583e-110, 5.038777347058036e-115, 2.1910569559453652e-120, 6.374784927389833e-126, 1.242258359694781e-131, 1.6227467437793614e-137, 1.4219055214843774e-143, 8.361963637724555e-150, 3.301864917551625e-156, 8.757660395956058e-163, 1.560751513956665e-169, 1.8694554403384505e-176, 1.5053395580048858e-183, 8.150430948291311e-191, 2.9677743687338974e-198, 7.268644522989954e-206, 1.1975903798141546e-213, 1.3275436246222447e-221, 9.901989787805409e-230}, {-3.3516605186885006e-36, -5.116545608723877e-36, -4.337541004452217e-36, -2.36668761074611e-36, -8.562170480535198e-37, -2.0691362843379116e-37, -3.3470497795081795e-38, -3.626213413573002e-39, -2.631272455773754e-40, -1.2783888702711722e-41, -4.156169516947577e-43, -9.034080946587534e-45, -1.3113400421103016e-46, -1.2690289397963513e-48, -8.168794323708102e-51, -3.486253254415006e-53, -9.817083695173419e-56, -1.8103747066892784e-58, -2.158931426215011e-61, -1.6259509496574668e-64, -7.3326711866740975e-68, -1.6708099937237115e-71, 0., 1.0609555134346882e-78, 2.956764868673241e-82, 4.163662665044676e-86, 3.5112752809375886e-90, 1.8703087009964944e-94, 6.4435458510346025e-99, 1.4541119233998163e-103, 2.165783468025043e-108, 2.139414839507881e-113, 1.4063224833049492e-118, 6.1661990945541025e-124, 1.8065744666610674e-129, 3.5414383144457697e-135, 4.649860886062828e-141, 4.092554334540914e-147, 2.416193840720068e-153, 9.573883867214038e-160, 2.5471788573015665e-166, 4.552079174108628e-173, 5.466108598181868e-180, 4.411471981392415e-187, 2.393469260166876e-194, 8.731722216208514e-202, 2.1422842750178787e-209, 3.5353091423448012e-217, 3.9247393727798016e-225, 2.9314375314711227e-233}, {-7.255029222443849e-40, -1.109088478401426e-39, -9.421185282635965e-40, -5.152898178868116e-40, -1.86933600295722e-40, -4.5313922815159817e-41, -7.355448122556852e-42, -8.000181702046549e-43, -5.831049668937545e-44, -2.8475105629348336e-45, -9.3126446928906e-47, -2.0384037599550676e-48, -2.9834975173560643e-50, -2.9163973138133777e-52, -1.9007638193066942e-54, -8.240784408287463e-57, -2.3689012440114023e-59, -4.493320449086807e-62, -5.581700555404162e-65, -4.4839818852659265e-68, -2.2749462630411067e-71, -6.911538518879956e-75, -1.0609555134346882e-78, 0., 3.0577675435674446e-86, 5.741190400101046e-90, 5.446829931085811e-94, 3.0947170959455166e-98, 1.1106094128717623e-102, 2.577915743286126e-107, 3.919591075334201e-112, 3.933327913917208e-117, 2.6178520732030756e-122, 1.1594246535073185e-127, 3.42519246316211e-133, 6.761378497064603e-139, 8.930441899616079e-145, 7.90039678201176e-151, 4.685120034018331e-157, 1.8637037934639464e-163, 4.975692470159442e-170, 8.919620645367546e-177, 1.0740377198274545e-183, 8.689842377246435e-191, 4.7254387773584754e-198, 1.7274776156787843e-205, 4.2463067793255346e-213, 7.019663632920736e-221, 7.805399849079725e-229, 5.838588942938803e-237}, {-1.0559176735648517e-43, -1.6162724239797435e-43, -1.3754617774132353e-43, -7.539550569211827e-44, -2.7419380781434313e-44, -6.665052060293233e-45, -1.0852321585441054e-45, -1.184454801206411e-46, -8.666926349519676e-48, -4.2512651501163006e-49, -1.3974855891826481e-50, -3.077102323163445e-52, -4.535277459626684e-54, -4.470221000374936e-56, -2.9428983870888296e-58, -1.2918458507611796e-60, -3.772493695926296e-63, -7.304723835829445e-66, -9.33334672416921e-69, -7.810223863204734e-72, -4.2266812657730233e-75, -1.444626614099137e-78, -2.956764868673241e-82, -3.0577675435674446e-86, 0., 4.000014577526347e-94, 5.059902820912449e-98, 3.2342369703200036e-102, 1.2380579027922396e-106, 2.9934850423464095e-111, 4.6814845045783114e-116, 4.795764261497166e-121, 3.242516535923535e-126, 1.4540343284702674e-131, 4.3389227126266275e-137, 8.636470759081349e-143, 1.148683711680989e-148, 1.0222422808356208e-154, 6.093223641444557e-161, 2.434656999198631e-167, 6.525506270435784e-174, 1.1738495020831337e-180, 1.4178427205042154e-187, 1.150337093002216e-194, 6.271081738532e-202, 2.297728241544779e-209, 5.659731539576774e-217, 9.37394748587283e-225, 1.0441334484229499e-232, 7.822835193634669e-241}, {-1.0334998003363922e-47, -1.5838213906470263e-47, -1.3501026636453592e-47, -7.415320881652156e-48, -2.7028272071142068e-48, -6.586405747075945e-49, -1.0754036833131177e-49, -1.177360979747694e-50, -8.644931408806338e-52, -4.257105460523418e-53, -1.4056527629931634e-54, -3.1109577257372683e-56, -4.61246895017753e-58, -4.578097558141513e-60, -3.0390331672904823e-62, -1.3475214063045084e-64, -3.9842679043267636e-67, -7.837241622314401e-70, -1.022237190343891e-72, -8.798572480187597e-76, -4.959946587174239e-79, -1.8082639987996256e-82, -4.163662665044676e-86, -5.741190400101046e-90, -4.000014577526347e-94, 0., 2.3750877958314945e-102, 2.024175042858195e-106, 8.717053428283999e-111, 2.248198052087958e-115, 3.662434209620231e-120, 3.8590332905516415e-125, 2.6635309053255326e-130, 1.2133598645401176e-135, 3.665995364694182e-141, 7.37074029965827e-147, 9.885061820321538e-153, 8.858480250992924e-159, 5.311655778596933e-165, 2.1332514510507257e-171, 5.74318724084917e-178, 1.037172442505394e-184, 1.2571061811992151e-191, 1.0230845255932943e-198, 5.592854930010316e-206, 2.0543614214714078e-213, 5.071774470508939e-221, 8.417533409325434e-229, 9.393773632592681e-237, 7.050223774099365e-245}, {-6.803753642645253e-52, -1.0437945493701367e-51, -8.91133201153994e-52, -4.9034092561189254e-52, -1.790918309058282e-52, -4.374106362167196e-53, -7.15976509561819e-54, -7.860341352912296e-55, -5.789429356585064e-56, -2.860842562432859e-57, -9.483253971839823e-59, -2.1081812164649787e-60, -3.141729177166378e-62, -3.136878919564343e-64, -2.0968849712692054e-66, -9.375165960221952e-69, -2.7999909635965208e-71, -5.5765598165188764e-74, -7.389145704080593e-77, -6.492464922053984e-80, -3.764513439879258e-83, -1.4296260568472266e-86, -3.5112752809375886e-90, -5.446829931085811e-94, -5.059902820912449e-98, -2.3750877958314945e-102, 0., 6.40130730205526e-111, 3.6756068740042163e-115, 1.0664645820582763e-119, 1.8531493652829417e-124, 2.0339856533027727e-129, 1.4439812598788725e-134, 6.715035060596653e-140, 2.061056965085064e-145, 4.195698043151377e-151, 5.683780671309252e-157, 5.135955671377715e-163, 3.1011189357821594e-169, 1.2528756613066953e-175, 3.390317398506495e-182, 6.149967939833008e-189, 7.4833081543653005e-196, 6.111369443836585e-203, 3.351220970238051e-210, 1.2343862131872438e-217, 3.055070526914359e-225, 5.08196967199047e-233, 5.683103187823556e-241, 4.2733661175798527e-249}, {-3.0130416716350175e-56, -4.627071619521734e-56, -3.9559269487028935e-56, -2.180375765293571e-56, -7.978523550203266e-57, -1.9526841159052155e-57, -3.203514574064185e-58, -3.525788550972604e-59, -2.6040856980315936e-60, -1.2907910582492833e-61, -4.293631055188679e-63, -9.582416985050217e-65, -1.43440031172382e-66, -1.4395304016152791e-68, -9.67999460957271e-71, -4.3581876676934926e-73, -1.3124649586766568e-75, -2.640354606730942e-78, -3.542298497776827e-81, -3.161840521653712e-84, -1.8715181521630607e-87, -7.310416204324359e-91, -1.8703087009964944e-94, -3.0947170959455166e-98, -3.2342369703200036e-102, -2.024175042858195e-106, -6.40130730205526e-111, 0., 7.831364923409775e-120, 3.0296578157142962e-124, 5.922568476959733e-129, 6.933879251408005e-134, 5.127654006677956e-139, 2.4526743941424244e-144, 7.684868677721817e-150, 1.5892422599135921e-155, 2.1798079009379507e-161, 1.9896055497161514e-167, 1.2113461521890091e-173, 4.928153975624287e-180, 1.3415105028222626e-186, 2.445952565915122e-193, 2.989532698275831e-200, 2.4510264722917623e-207, 1.3487078441478686e-214, 4.983200584107034e-222, 1.2367537842864013e-229, 2.062439283028503e-237, 2.31164189955395e-245, 1.7418203061104343e-253}, {-8.977055226866636e-61, -1.3798681758653142e-60, -1.1812654252170989e-60, -6.520801499618372e-61, -2.3902275671670586e-61, -5.860954127888076e-62, -9.635198835798637e-63, -1.0628598436968253e-63, -7.869770432036033e-65, -3.911717027421633e-66, -1.3052048863084058e-67, -2.9230375025118e-69, -4.392679097364488e-71, -4.428069692325367e-73, -2.9928860482444407e-75, -1.355496550147804e-77, -4.110613657524813e-80, -8.338449939056892e-83, -1.1299859105015663e-85, -1.0212283587904578e-88, -6.14067869070219e-92, -2.4486080667034847e-95, -6.4435458510346025e-99, -1.1106094128717623e-102, -1.2380579027922396e-106, -8.717053428283999e-111, -3.6756068740042163e-115, -7.831364923409775e-120, 0., 4.349045658901854e-129, 1.133572272999325e-133, 1.4930278908697085e-138, 1.1777119532074018e-143, 5.867985525856026e-149, 1.8911241633799828e-154, 3.992349384227174e-160, 5.562833775201438e-166, 5.1409085215070685e-172, 3.1615930037198256e-178, 1.2969585320390995e-184, 3.555186218919242e-191, 6.5206926451029966e-198, 8.010699994172023e-205, 6.597048260626433e-212, 3.6443436898155973e-219, 1.3511860970669856e-226, 3.3638183468874545e-234, 5.6251636312694004e-242, 6.320648531923533e-250, 4.773427667858268e-258}, {-1.799628783219106e-65, -2.7686027286937493e-65, -2.3729954532804475e-65, -1.3118075292988038e-65, -4.816114874028228e-66, -1.1829831956778725e-66, -1.9484629380075095e-67, -2.1538009143739892e-68, -1.598370656875539e-69, -7.964709699476606e-71, -2.664930641304631e-72, -5.9866531082394695e-74, -9.027854249635582e-76, -9.136277747051674e-78, -6.20268216539131e-80, -2.823639331418188e-82, -8.613802102036834e-85, -1.7595435052772066e-87, -2.4043176041261536e-90, -2.1948582605526084e-93, -1.3362724628721495e-96, -5.412991506013635e-100, -1.4541119233998163e-103, -2.577915743286126e-107, -2.9934850423464095e-111, -2.248198052087958e-115, -1.0664645820582763e-119, -3.0296578157142962e-124, -4.349045658901854e-129, 0., 1.0963402070255321e-138, 1.9253193889320007e-143, 1.7085451858921067e-148, 9.080403421255738e-154, 3.048350637736872e-159, 6.619236128391811e-165, 9.415215365208607e-171, 8.839210496300154e-177, 5.503951445727816e-183, 2.2806546563827787e-189, 6.303763563668277e-196, 1.1642808292815543e-202, 1.438838025466189e-209, 1.191002191252277e-216, 6.608710485205322e-224, 2.4598711099902875e-231, 6.145186587109181e-239, 1.030813712359677e-246, 1.1614790200549229e-254, 8.793609374799204e-263}, {-2.427701878910668e-70, -3.7378460795738233e-70, -3.20735439073265e-70, -1.775393998308671e-70, -6.5276658872070874e-71, -1.6059545901096211e-71, -2.649726085299205e-72, -2.9345128037572685e-73, -2.1822582667005002e-74, -1.089894609969121e-75, -3.655843175453372e-77, -8.235508918116734e-79, -1.2457571099478261e-80, -1.2650960051452532e-82, -8.622505959447074e-85, -3.9427359957116242e-87, -1.2089402163248656e-89, -2.4842046329431228e-92, -3.4182643758256816e-95, -3.146475949794511e-98, -1.9349857057897783e-101, -7.936245974698148e-105, -2.165783468025043e-108, -3.919591075334201e-112, -4.6814845045783114e-116, -3.662434209620231e-120, -1.8531493652829417e-124, -5.922568476959733e-129, -1.133572272999325e-133, -1.0963402070255321e-138, 0., 1.2545790773052058e-148, 1.4844325259646404e-153, 8.875476098631142e-159, 3.178192212579215e-164, 7.188725155734304e-170, 1.0517407974787025e-175, 1.0079680842322937e-181, 6.375985538130935e-188, 2.6750215759675445e-194, 7.468484469472512e-201, 1.3908952930210512e-207, 1.7309122530404744e-214, 1.441295825949169e-221, 8.038569206069908e-229, 3.0054456599535107e-236, 7.537570496694164e-244, 1.2687669438998759e-251, 1.4340210467224594e-259, 1.0887195630072425e-267}, {-2.2039918486854946e-75, -3.3959499516658365e-75, -2.917042656042299e-75, -1.616682665535224e-75, -5.952207809618014e-76, -1.4665425327631392e-76, -2.4235799758411275e-77, -2.6887282026134787e-78, -2.0032666453049614e-79, -1.002571467182461e-80, -3.370577399118154e-82, -7.611921200748945e-84, -1.1546275545813258e-85, -1.1761819631472533e-87, -8.044330200165412e-90, -3.69278368611004e-92, -1.1373535707557703e-94, -2.349089144088168e-97, -3.2515856803347683e-100, -3.0139804053823687e-103, -1.8689509059637337e-106, -7.742835943575583e-110, -2.139414839507881e-113, -3.933327913917208e-117, -4.795764261497166e-121, -3.8590332905516415e-125, -2.0339856533027727e-129, -6.933879251408005e-134, -1.4930278908697085e-138, -1.9253193889320007e-143, -1.2545790773052058e-148, 0., 6.517152945514633e-159, 5.1955059537156765e-164, 2.0929982714602364e-169, 5.049743441076276e-175, 7.695820362680362e-181, 7.58625503116512e-187, 4.898722330334632e-193, 2.0878640379116504e-199, 5.902043944289217e-206, 1.110271519098949e-212, 1.393201516417806e-219, 1.1682034103188833e-226, 6.554227604684243e-234, 2.463049295031275e-241, 6.204833190291723e-249, 1.0485287993947504e-256, 1.189212289895604e-264, 9.05654142612774e-273}, {-1.3466721808252088e-80, -2.0764311737597954e-80, -1.785356640555001e-80, -9.90615045964714e-81, -3.6517994444191353e-81, -9.009860662131985e-82, -1.4911566461574192e-82, -1.6569451529809592e-83, -1.2366722078079367e-84, -6.2008742437715946e-86, -2.0890080649497083e-87, -4.728419597003023e-89, -7.190361706684609e-91, -7.344936350277083e-93, -5.0390178681853235e-95, -2.3212142756953025e-97, -7.17722637865711e-100, -1.489001539705915e-102, -2.071630571017017e-105, -1.9316789908179664e-108, -1.206198766117198e-111, -5.038777347058036e-115, -1.4063224833049492e-118, -2.6178520732030756e-122, -3.242516535923535e-126, -2.6635309053255326e-130, -1.4439812598788725e-134, -5.127654006677956e-139, -1.1777119532074018e-143, -1.7085451858921067e-148, -1.4844325259646404e-153, -6.517152945514633e-159, 0., 1.5368457369591285e-169, 8.254866159617705e-175, 2.240593144139845e-180, 3.6423135909079367e-186, 3.740060418880778e-192, 2.4840964799710218e-198, 1.0807934213818015e-204, 3.103718621758087e-211, 5.911587666631938e-218, 7.492964567686249e-225, 6.335229240257409e-232, 3.579248388796481e-239, 1.353071810116532e-246, 3.4260943029841876e-254, 5.815459901009192e-262, 6.6215989854109864e-270, 5.060241218460667e-278}, {-5.538381385877773e-86, -8.545233426566271e-86, -7.354110798245691e-86, -4.084842766255274e-86, -1.507609325681258e-86, -3.7243699081050154e-87, -6.17239569580943e-88, -6.868809077659462e-89, -5.134797422446017e-90, -2.5791480327255017e-91, -8.70532942730063e-93, -1.974509978212443e-94, -3.0094004038387378e-96, -3.081799421607793e-98, -2.120151679074893e-100, -9.796676212898308e-103, -3.0396635894205522e-105, -6.33087601641243e-108, -8.847396129328012e-111, -8.292005428369245e-114, -5.2085990104718766e-117, -2.1910569559453652e-120, -6.1661990945541025e-124, -1.1594246535073185e-127, -1.4540343284702674e-131, -1.2133598645401176e-135, -6.715035060596653e-140, -2.4526743941424244e-144, -5.867985525856026e-149, -9.080403421255738e-154, -8.875476098631142e-159, -5.1955059537156765e-164, -1.5368457369591285e-169, 0., 1.6452048401341126e-180, 5.9540390911775405e-186, 1.0888762760980085e-191, 1.1926377260748481e-197, 8.251390701323627e-204, 3.692630401082384e-210, 1.0825060516235799e-216, 2.0945539443492246e-223, 2.688042471388429e-230, 2.2956706786682088e-237, 1.3078056678670596e-244, 4.9785019062799925e-252, 1.2681031090103957e-259, 2.1635193316592736e-267, 2.474423832919947e-275, 1.8983759317673543e-283}, {-1.5332105633637676e-91, -2.3670698490679875e-91, -2.0388790979405996e-91, -1.1336325576621578e-91, -4.188549916577641e-92, -1.0359601075865512e-92, -1.7190872448147669e-93, -1.9156742312399467e-94, -1.4341891270885868e-95, -7.215306800417822e-97, -2.4395986272889458e-98, -5.54388549800533e-100, -8.467069504310191e-102, -8.690473351367954e-104, -5.993673627137889e-106, -2.777215715704456e-108, -8.643683750790259e-111, -1.8065189055759794e-113, -2.5345097134943257e-116, -2.3860116777742562e-119, -1.5064522529485462e-122, -6.374784927389833e-126, -1.8065744666610674e-129, -3.42519246316211e-133, -4.3389227126266275e-137, -3.665995364694182e-141, -2.061056965085064e-145, -7.684868677721817e-150, -1.8911241633799828e-154, -3.048350637736872e-159, -3.178192212579215e-164, -2.0929982714602364e-169, -8.254866159617705e-175, -1.6452048401341126e-180, 0., 7.995238986063171e-192, 1.9495619517755675e-197, 2.4022575677809793e-203, 1.7728292237037208e-209, 8.26426735748809e-216, 2.4919154747279195e-222, 4.922087917327116e-229, 6.417019627800765e-236, 5.548835634217564e-243, 3.1930101113800546e-250, 1.2256314051718292e-257, 3.1437081779008196e-265, 5.39542749180115e-273, 6.202412274349579e-281, 4.779728840616091e-289}, {-2.8572292258059285e-97, -4.413741007835412e-97, -3.80486269090762e-97, -2.1175254683774499e-97, -7.831908080918445e-98, -1.9392261382057257e-98, -3.221808407690634e-99, -3.5948242443349855e-100, -2.694998680357698e-101, -1.3578439169088971e-102, -4.5984223281746774e-104, -1.0467895179883653e-105, -1.6017693809353377e-107, -1.6474359004321009e-109, -1.1387911862272863e-111, -5.289903095657847e-114, -1.650979467524252e-116, -3.461208823122087e-119, -4.872867541908105e-122, -4.6053537585641137e-125, -2.920655287840597e-128, -1.242258359694781e-131, -3.5414383144457697e-135, -6.761378497064603e-139, -8.636470759081349e-143, -7.37074029965827e-147, -4.195698043151377e-151, -1.5892422599135921e-155, -3.992349384227174e-160, -6.619236128391811e-165, -7.188725155734304e-170, -5.049743441076276e-175, -2.240593144139845e-180, -5.9540390911775405e-186, -7.995238986063171e-192, 0., 1.763878847845761e-203, 2.8979441985430985e-209, 2.4059681450639527e-215, 1.1963439373887445e-221, 3.757627871643125e-228, 7.634213205135683e-235, 1.0160220382027525e-241, 8.925057967981159e-249, 5.200013974587815e-256, 2.016178146041421e-263, 5.214532414254769e-271, 9.012088787075198e-279, 1.0421678094913512e-286, 8.072382707860226e-295}, {-3.584567902369295e-103, -5.540343576276414e-103, -4.779694298585704e-103, -2.6624052127589833e-103, -9.856735260949598e-104, -2.443120683891438e-104, -4.063485112173983e-105, -4.539345628760968e-106, -3.407441637426588e-107, -1.719158282390289e-108, -5.83066097388976e-110, -1.3294246502941975e-111, -2.0377879426010975e-113, -2.099854851335349e-115, -1.4545313236205785e-117, -6.771932341830355e-120, -2.1188180396511264e-122, -4.4543515824076303e-125, -6.290479985927689e-128, -5.965784063914317e-131, -3.7982593946899923e-134, -1.6227467437793614e-137, -4.649860886062828e-141, -8.930441899616079e-145, -1.148683711680989e-148, -9.885061820321538e-153, -5.683780671309252e-157, -2.1798079009379507e-161, -5.562833775201438e-166, -9.415215365208607e-171, -1.0517407974787025e-175, -7.695820362680362e-181, -3.6423135909079367e-186, -1.0888762760980085e-191, -1.9495619517755675e-197, -1.763878847845761e-203, 0., 1.7665893907913905e-215, 1.9555737945949541e-221, 1.0939385109232241e-227, 3.6650453302304625e-234, 7.756372064267949e-241, 1.0617736262248561e-247, 9.521265892949384e-255, 5.635436795561389e-262, 2.2123152213072767e-269, 5.779606638885259e-277, 1.0071925293876195e-284, 1.172873417229711e-292, 9.138873271644472e-301}, {-3.0276041498594035e-109, -4.681919337458348e-109, -4.0420334474377804e-109, -2.2533881610825845e-109, -8.350065005104081e-110, -2.071690521481769e-110, -3.449296170160824e-111, -3.8575166126392238e-112, -2.899076461165784e-113, -1.464540558453514e-114, -4.97392780368044e-116, -1.1357646236855133e-117, -1.743729142748934e-119, -1.7999645521999414e-121, -1.2491641280582288e-123, -5.8278352667954035e-126, -1.8275708889925773e-128, -3.851697381918212e-131, -5.454515139038243e-134, -5.188984627963002e-137, -3.3151625684991708e-140, -1.4219055214843774e-143, -4.092554334540914e-147, -7.90039678201176e-151, -1.0222422808356208e-154, -8.858480250992924e-159, -5.135955671377715e-163, -1.9896055497161514e-167, -5.1409085215070685e-172, -8.839210496300154e-177, -1.0079680842322937e-181, -7.58625503116512e-187, -3.740060418880778e-192, -1.1926377260748481e-197, -2.4022575677809793e-203, -2.8979441985430985e-209, -1.7665893907913905e-215, 0., 8.032217943696483e-228, 5.99091176276003e-234, 2.2580413186633693e-240, 5.097296439115203e-247, 7.268452526379354e-254, 6.704079791686063e-261, 4.0506704058534064e-268, 1.6154211167472115e-275, 4.2729918198539918e-283, 7.521614678714623e-291, 8.831894102688158e-299, 6.9298178520579315e-307}, {-1.7216792363552868e-115, -2.6637282441007805e-115, -2.3012365390783085e-115, -1.2839231098949114e-115, -4.7617311459404915e-116, -1.1824909204327366e-116, -1.9707315209273884e-117, -2.206260877038632e-118, -1.6599367034835346e-119, -8.395565741407311e-121, -2.854975199990582e-122, -6.52810827366179e-124, -1.003739373661755e-125, -1.0377704844334965e-127, -7.214587503451444e-130, -3.3722597401865846e-132, -1.0597080002209718e-134, -2.2384636829744625e-137, -3.1779066916429728e-140, -3.031601234717143e-143, -1.9428398784605306e-146, -8.361963637724555e-150, -2.416193840720068e-153, -4.685120034018331e-157, -6.093223641444557e-161, -5.311655778596933e-165, -3.1011189357821594e-169, -1.2113461521890091e-173, -3.1615930037198256e-178, -5.503951445727816e-183, -6.375985538130935e-188, -4.898722330334632e-193, -2.4840964799710218e-198, -8.251390701323627e-204, -1.7728292237037208e-209, -2.4059681450639527e-215, -1.9555737945949541e-221, -8.032217943696483e-228, 0., 1.6579503576289213e-240, 8.331999223868993e-247, 2.1159711882348564e-253, 3.2184038604414846e-260, 3.092192509908822e-267, 1.9217138169950424e-274, 7.823523726457454e-282, 2.102268264231568e-289, 3.74681444705472e-297, 4.443956132206067e-305, 3.5159432279e-313}, {-6.591966307285829e-122, -1.0203621325891093e-121, -8.820744532573423e-122, -4.92499628587605e-122, -1.8280278218050143e-122, -4.5435006235784146e-123, -7.579123068812097e-124, -8.493224711160898e-125, -6.396750564749575e-126, -3.2389233348851243e-127, -1.1027314235204994e-128, -2.524695812188364e-130, -3.88721731217134e-132, -4.0249648999323744e-134, -2.802642578572171e-136, -1.312296186889711e-138, -4.1316051654470393e-141, -8.745424248013414e-144, -1.2443939301100429e-146, -1.1900793335549627e-149, -7.647958954858973e-153, -3.301864917551625e-156, -9.573883867214038e-160, -1.8637037934639464e-163, -2.434656999198631e-167, -2.1332514510507257e-171, -1.2528756613066953e-175, -4.928153975624287e-180, -1.2969585320390995e-184, -2.2806546563827787e-189, -2.6750215759675445e-194, -2.0878640379116504e-199, -1.0807934213818015e-204, -3.692630401082384e-210, -8.26426735748809e-216, -1.1963439373887445e-221, -1.0939385109232241e-227, -5.99091176276003e-234, -1.6579503576289213e-240, 0., 1.553626672840639e-253, 5.26072904981612e-260, 9.001797672815876e-267, 9.225373419987586e-274, 5.972207796773146e-281, 2.500823592879052e-288, 6.859992340115518e-296, 1.2420443602438266e-303, 1.491556524426e-311, 1.192e-319}, {-1.6994351000711664e-128, -2.6316935410561927e-128, -2.2764138714652827e-128, -1.2719134345821196e-128, -4.724613037548099e-129, -1.1752432294419119e-129, -1.9621478301840195e-130, -2.2008188650232387e-131, -1.65918727521648e-132, -8.409860873601171e-134, -2.866425838407712e-135, -6.570474417632892e-137, -1.0129331626687886e-138, -1.0502681997193725e-140, -7.324007111953823e-143, -3.434854429957179e-145, -1.083302935068856e-147, -2.2973847818208178e-150, -3.275736595452664e-153, -3.1398790198364025e-156, -2.0228777875884927e-159, -8.757660395956058e-163, -2.5471788573015665e-166, -4.975692470159442e-170, -6.525506270435784e-174, -5.74318724084917e-178, -3.390317398506495e-182, -1.3415105028222626e-186, -3.555186218919242e-191, -6.303763563668277e-196, -7.468484469472512e-201, -5.902043944289217e-206, -3.103718621758087e-211, -1.0825060516235799e-216, -2.4919154747279195e-222, -3.757627871643125e-228, -3.6650453302304625e-234, -2.2580413186633693e-240, -8.331999223868993e-247, -1.553626672840639e-253, 0., 6.609424425520622e-267, 1.507945656680001e-273, 1.7385729574519503e-280, 1.2005288457167538e-287, 5.236601360183082e-295, 1.4774899774958656e-302, 2.7308186651068e-310, 3.33146e-318, 0.}, {-2.950102085002815e-135, -4.570351670555626e-135, -3.955642789846296e-135, -2.211633553592607e-135, -8.221213978288903e-136, -2.046594496235319e-136, -3.419717278067328e-137, -3.839004025315587e-138, -2.8968675897703062e-139, -1.4697598078009712e-140, -5.0147630753560176e-142, -1.150771918657803e-143, -1.776192477624695e-145, -1.8440120437530775e-147, -1.2876814623372776e-149, -6.047988345384634e-152, -1.910504024193573e-154, -4.0586949921276385e-157, -5.798069245383411e-160, -5.569107114540091e-163, -3.596070643545917e-166, -1.560751513956665e-169, -4.552079174108628e-173, -8.919620645367546e-177, -1.1738495020831337e-180, -1.037172442505394e-184, -6.149967939833008e-189, -2.445952565915122e-193, -6.5206926451029966e-198, -1.1642808292815543e-202, -1.3908952930210512e-207, -1.110271519098949e-212, -5.911587666631938e-218, -2.0945539443492246e-223, -4.922087917327116e-229, -7.634213205135683e-235, -7.756372064267949e-241, -5.097296439115203e-247, -2.1159711882348564e-253, -5.26072904981612e-260, -6.609424425520622e-267, 0., 1.276512186022155e-280, 1.9623249742851522e-287, 1.5244147172411221e-294, 7.092653950759631e-302, 2.08455120453025e-309, 3.9629203e-317, 0., 0.}, {-3.448475789279411e-142, -5.344569887872295e-142, -4.6282764126318316e-142, -2.58934833400951e-142, -9.631879244956958e-143, -2.399514504677444e-143, -4.0125161130342304e-144, -4.508164635360609e-145, -3.404753544915834e-146, -1.729029422491669e-147, -5.9051476110927755e-149, -1.3565060928784306e-150, -2.096067852655796e-152, -2.1786916741941688e-154, -1.5233326998021361e-156, -7.164624201975796e-159, -2.2665919921845482e-161, -4.822888666195058e-164, -6.901744175783405e-167, -6.641753912110388e-170, -4.2975768818712725e-173, -1.8694554403384505e-176, -5.466108598181868e-180, -1.0740377198274545e-183, -1.4178427205042154e-187, -1.2571061811992151e-191, -7.4833081543653005e-196, -2.989532698275831e-200, -8.010699994172023e-205, -1.438838025466189e-209, -1.7309122530404744e-214, -1.393201516417806e-219, -7.492964567686249e-225, -2.688042471388429e-230, -6.417019627800765e-236, -1.0160220382027525e-241, -1.0617736262248561e-247, -7.268452526379354e-254, -3.2184038604414846e-260, -9.001797672815876e-267, -1.507945656680001e-273, -1.276512186022155e-280, 0., 1.1192651702553146e-294, 1.159321600918248e-301, 6.068230774047185e-309, 1.90236835e-316, 5.e-324, 0., 0.}, {-2.714493202667568e-149, -4.208614368072984e-149, -3.646474544250865e-149, -2.041295434214596e-149, -7.598171670250405e-150, -1.8941811350429483e-150, -3.169801417624194e-151, -3.5641027230057224e-152, -2.6939577655886126e-153, -1.3692518368846403e-154, -4.68069874474002e-156, -1.0762818180726029e-157, -1.6647987715732016e-159, -1.7323474492830484e-161, -1.2126925279211913e-163, -5.71088813536741e-166, -1.809171495700794e-168, -3.855285511867273e-171, -5.525907295222857e-174, -5.326993370313589e-177, -3.4533832668256562e-180, -1.5053395580048858e-183, -4.411471981392415e-187, -8.689842377246435e-191, -1.150337093002216e-194, -1.0230845255932943e-198, -6.111369443836585e-203, -2.4510264722917623e-207, -6.597048260626433e-212, -1.191002191252277e-216, -1.441295825949169e-221, -1.1682034103188833e-226, -6.335229240257409e-232, -2.2956706786682088e-237, -5.548835634217564e-243, -8.925057967981159e-249, -9.521265892949384e-255, -6.704079791686063e-261, -3.092192509908822e-267, -9.225373419987586e-274, -1.7385729574519503e-280, -1.9623249742851522e-287, -1.1192651702553146e-294, 0., 4.45543284980171e-309, 3.1094731e-316, 1.e-323, 0., 0., 0.}, {-1.4389131520109328e-156, -2.2317323799358374e-156, -1.9346078902592746e-156, -1.0836137496993513e-156, -4.0359563984694375e-157, -1.0068012130481347e-157, -1.685989785249384e-158, -1.8971007498765653e-159, -1.4350472018103305e-160, -7.299841043804396e-162, -2.4975639120363972e-163, -5.748187263825062e-165, -8.900019824847662e-167, -9.270782298473123e-169, -6.497030435940009e-171, -3.0632649565789154e-173, -9.716613915322423e-176, -2.073422968799552e-178, -2.9763080352910375e-181, -2.873769068850379e-184, -1.8662470266990974e-187, -8.150430948291311e-191, -2.393469260166876e-194, -4.7254387773584754e-198, -6.271081738532e-202, -5.592854930010316e-206, -3.351220970238051e-210, -1.3487078441478686e-214, -3.6443436898155973e-219, -6.608710485205322e-224, -8.038569206069908e-229, -6.554227604684243e-234, -3.579248388796481e-239, -1.3078056678670596e-244, -3.1930101113800546e-250, -5.200013974587815e-256, -5.635436795561389e-262, -4.0506704058534064e-268, -1.9217138169950424e-274, -5.972207796773146e-281, -1.2005288457167538e-287, -1.5244147172411221e-294, -1.159321600918248e-301, -4.45543284980171e-309, 0., 1.e-323, 0., 0., 0., 0.}, {-5.1366099312920374e-164, -7.969556566903162e-164, -6.911809986140221e-164, -3.873561846430825e-164, -1.4435712340770577e-164, -3.603348544433653e-165, -6.038136353643945e-166, -6.798908336785415e-167, -5.146741015923254e-168, -2.620081269009994e-169, -8.971656550254283e-171, -2.0666302735392142e-172, -3.2027411313526933e-174, -3.339424038032905e-176, -2.342730016520112e-178, -1.105795252710964e-180, -3.511735636887722e-183, -7.50324407674386e-186, -1.0785373630872128e-188, -1.0429226680374686e-191, -6.783671319322792e-195, -2.9677743687338974e-198, -8.731722216208514e-202, -1.7274776156787843e-205, -2.297728241544779e-209, -2.0543614214714078e-213, -1.2343862131872438e-217, -4.983200584107034e-222, -1.3511860970669856e-226, -2.4598711099902875e-231, -3.0054456599535107e-236, -2.463049295031275e-241, -1.353071810116532e-246, -4.9785019062799925e-252, -1.2256314051718292e-257, -2.016178146041421e-263, -2.2123152213072767e-269, -1.6154211167472115e-275, -7.823523726457454e-282, -2.500823592879052e-288, -5.236601360183082e-295, -7.092653950759631e-302, -6.068230774047185e-309, -3.1094731e-316, -1.e-323, 0., 0., 0., 0., 0.}, {-1.2348832905259975e-171, -1.9165796661854994e-171, -1.662960687674082e-171, -9.324529452679726e-172, -3.4769494428851735e-172, -8.684086989791324e-173, -1.4561031632668956e-173, -1.6406426416587117e-174, -1.2428192593483701e-175, -6.331516891798153e-177, -2.1697059484759537e-178, -5.00202315292177e-180, -7.758550615453711e-182, -8.097096475686691e-184, -5.6859666726547036e-186, -2.686636703353224e-188, -8.541592628893943e-191, -1.827186273140676e-193, -2.6298031737754917e-196, -2.5464567624919904e-199, -1.6587919535591963e-202, -7.268644522989954e-206, -2.1422842750178787e-209, -4.2463067793255346e-213, -5.659731539576774e-217, -5.071774470508939e-221, -3.055070526914359e-225, -1.2367537842864013e-229, -3.3638183468874545e-234, -6.145186587109181e-239, -7.537570496694164e-244, -6.204833190291723e-249, -3.4260943029841876e-254, -1.2681031090103957e-259, -3.1437081779008196e-265, -5.214532414254769e-271, -5.779606638885259e-277, -4.2729918198539918e-283, -2.102268264231568e-289, -6.859992340115518e-296, -1.4774899774958656e-302, -2.08455120453025e-309, -1.90236835e-316, -1.e-323, 0., 0., 0., 0., 0., 0.}, {-1.999369114246182e-179, -3.104067226360578e-179, -2.694480192592439e-179, -1.5115969231301005e-179, -5.63949175704757e-180, -1.4093256642118256e-180, -2.364490638073898e-181, -2.6658206224318783e-182, -2.0207403711206116e-183, -1.0301753945887935e-184, -3.5328209942376755e-186, -8.150827152001396e-188, -1.2652934343416452e-189, -1.3216480527844183e-191, -9.289445706806621e-194, -4.393582213878126e-196, -1.3983014997753842e-198, -2.994522703737043e-201, -4.3150391574472005e-204, -4.183618772568727e-207, -2.72900207339788e-210, -1.1975903798141546e-213, -3.5353091423448012e-217, -7.019663632920736e-221, -9.37394748587283e-225, -8.417533409325434e-229, -5.08196967199047e-233, -2.062439283028503e-237, -5.6251636312694004e-242, -1.030813712359677e-246, -1.2687669438998759e-251, -1.0485287993947504e-256, -5.815459901009192e-262, -2.1635193316592736e-267, -5.39542749180115e-273, -9.012088787075198e-279, -1.0071925293876195e-284, -7.521614678714623e-291, -3.74681444705472e-297, -1.2420443602438266e-303, -2.7308186651068e-310, -3.9629203e-317, -5.e-324, 0., 0., 0., 0., 0., 0., 0.}, {-2.180155816116692e-187, -3.385766719862968e-187, -2.9402315893413286e-187, -1.650247559508316e-187, -6.159920805622182e-188, -1.5402131744332968e-188, -2.5855513944426485e-189, -2.916788164249011e-190, -2.2123609910192554e-191, -1.1286057808404243e-192, -3.873054353863989e-194, -8.942336192210287e-196, -1.3892352596449548e-197, -1.452295642481923e-199, -1.021656410772371e-201, -4.836517967958133e-204, -1.5407748983136514e-206, -3.303072724823627e-209, -4.764947110876846e-212, -4.6253239581936964e-215, -3.0209825685884314e-218, -1.3275436246222447e-221, -3.9247393727798016e-225, -7.805399849079725e-229, -1.0441334484229499e-232, -9.393773632592681e-237, -5.683103187823556e-241, -2.31164189955395e-245, -6.320648531923533e-250, -1.1614790200549229e-254, -1.4340210467224594e-259, -1.189212289895604e-264, -6.6215989854109864e-270, -2.474423832919947e-275, -6.202412274349579e-281, -1.0421678094913512e-286, -1.172873417229711e-292, -8.831894102688158e-299, -4.443956132206067e-305, -1.491556524426e-311, -3.33146e-318, 0., 0., 0., 0., 0., 0., 0., 0., 0.}, {-1.6011009775453814e-195, -2.4872195511772787e-195, -2.160785397026153e-195, -1.2133242021838497e-195, -4.531220417731682e-196, -1.133560415546804e-196, -1.9039336028428995e-197, -2.149065940910853e-198, -1.6310199243450518e-199, -8.325629128847698e-201, -2.858999029606498e-202, -6.605599998432656e-204, -1.026962123607876e-205, -1.074407165800494e-207, -7.564381038235726e-210, -3.5840758180273373e-212, -1.1428324451267053e-214, -2.45236904599753e-217, -3.54142402419798e-220, -3.441476580534321e-223, -2.2504407923353746e-226, -9.901989787805409e-230, -2.9314375314711227e-233, -5.838588942938803e-237, -7.822835193634669e-241, -7.050223774099365e-245, -4.2733661175798527e-249, -1.7418203061104343e-253, -4.773427667858268e-258, -8.793609374799204e-263, -1.0887195630072425e-267, -9.05654142612774e-273, -5.060241218460667e-278, -1.8983759317673543e-283, -4.779728840616091e-289, -8.072382707860226e-295, -9.138873271644472e-301, -6.9298178520579315e-307, -3.5159432279e-313, -1.192e-319, 0., 0., 0., 0., 0., 0., 0., 0., 0., 0.}}, {{0., 0.9851005039527122, 2.7334126276801713, 3.5904654967373117, 2.7573934087258016, 1.322495546368624, 0.4076554706645801, 0.08198015723885069, 0.010851106090327071, 0.0009506866249366184, 0.0000553424745444633, 2.1464211417348547e-6, 5.557405524597667e-8, 9.620222917121466e-10, 1.1147099457676925e-11, 8.65374147080545e-14, 4.50437325958465e-16, 1.572957828363624e-18, 3.686975675045035e-21, 5.803320048632028e-24, 6.136067241833546e-27, 4.3595592828124286e-30, 2.0818384929728714e-33, 6.6834601386148135e-37, 1.442749437035431e-40, 2.0945489993053403e-44, 2.0453431590972403e-48, 1.3436197166825296e-52, 5.938450666366733e-57, 1.7660504380322254e-61, 3.534337576809649e-66, 4.760204494694069e-71, 4.3150906835203096e-76, 2.6328850580158646e-81, 1.0813833294128164e-86, 2.989915566159811e-92, 5.56535881603823e-98, 6.974353831569742e-104, 5.88452189811621e-110, 3.342974604975202e-116, 1.2787526713243954e-122, 3.2937243652858834e-129, 5.712808667755637e-136, 6.6724804904293325e-143, 5.248228079296169e-150, 2.779953564233602e-157, 9.916827564166947e-165, 2.3824762490050897e-172, 3.8549128851671053e-180, 4.200874480207566e-188}, {-0.9851005039527122, 0., 3.122782343962879, 5.351470514027298, 4.566451714021756, 2.317876634543589, 0.7402600040291192, 0.1525257552619409, 0.020548663278756606, 0.001824672526464107, 0.00010734861743636342, 4.1991079374855824e-6, 1.094879679369818e-7, 1.9065048713975295e-9, 2.2201906934975724e-11, 1.731031837935921e-13, 9.04408247754179e-16, 3.1686711975249758e-18, 7.448960367038235e-21, 1.175518435995987e-23, 1.2458166810224679e-26, 8.869894508821509e-30, 4.2437461870279424e-33, 1.3647601693088537e-36, 2.950761414491726e-40, 4.290080450618886e-44, 4.194913660832307e-48, 2.7591226881151985e-52, 1.2208612300137993e-56, 3.6346250697488396e-61, 7.281089311777373e-66, 9.815610609673186e-71, 8.905520437284768e-76, 5.438205465250152e-81, 2.2353034200366463e-86, 6.184854052965921e-92, 1.1520191103615921e-97, 1.4446086069297055e-103, 1.2196132793883731e-109, 6.932581448035686e-116, 2.6533018070531997e-122, 6.837758337855736e-129, 1.1865652545175453e-135, 1.3865468371060298e-142, 1.0910778787112731e-149, 5.781860171804378e-157, 2.0633911107816323e-164, 4.95916336585031e-172, 8.027091704047326e-180, 8.750651936297247e-188}, {-2.7334126276801713, -3.122782343962879, 0., 3.4671942671598583, 3.9298095078998267, 2.2392106300279293, 0.7617666761487752, 0.1633433718214657, 0.022619350094078644, 0.002049329494933695, 0.00012242970499148984, 4.8473111099190965e-6, 1.2763176460568502e-7, 2.240459987888015e-9, 2.626839322280268e-11, 2.0599412640264078e-13, 1.0816187710280278e-15, 3.805988236758712e-18, 8.981276280135666e-21, 1.422115198375876e-23, 1.511694286308292e-26, 1.0791921086346259e-29, 5.175899217384363e-33, 1.6682090225364782e-36, 3.6141043767828223e-40, 5.264172968221932e-44, 5.1560916349067104e-48, 3.396596444048669e-52, 1.5050937520315955e-56, 4.4867898436397825e-61, 8.99934011813199e-66, 1.2146000729041486e-70, 1.103174039261659e-75, 6.743405866836657e-81, 2.7744192759137017e-86, 7.683381135652769e-92, 1.4323443679861844e-97, 1.797555173867352e-103, 1.5187264894835525e-109, 8.638939443845525e-116, 3.308598855711379e-122, 8.531952484239728e-129, 1.481459648227233e-135, 1.732142253479736e-142, 1.363778261963766e-149, 7.230754292668286e-157, 2.5817567905996327e-164, 6.207980786835229e-172, 1.0053085844883759e-179, 1.0964085191079025e-187}, {-3.5904654967373117, -5.351470514027298, -3.4671942671598583, 0., 1.664376165440909, 1.2637899947293123, 0.48352606665666675, 0.11057152746923773, 0.015947501961927076, 0.001485992852314795, 0.00009061804960156597, 3.644544593706978e-6, 9.715745023762609e-8, 1.7226729916091648e-9, 2.0365238538217674e-11, 1.6081464274996303e-13, 8.494001747888334e-16, 3.0041271474818337e-18, 7.120586727272451e-21, 1.1318934143027776e-23, 1.2073524600003188e-26, 8.645815531840907e-30, 4.158080251595964e-33, 1.343507903576248e-36, 2.9172414031672084e-40, 4.2579093294300074e-44, 4.1783545308506534e-48, 2.757275532954999e-52, 1.223749002081474e-56, 3.653463831004161e-61, 7.337928053715567e-66, 9.916264574171465e-71, 9.017235568050733e-76, 5.518099230020228e-81, 2.2726501445121598e-86, 6.29992580746107e-92, 1.175514074236887e-97, 1.4765117520808856e-103, 1.2484968298970136e-109, 7.10725904284235e-116, 2.7239671125555955e-122, 7.029198073855213e-129, 1.221326034620464e-135, 1.4288799087971231e-142, 1.125675696634338e-149, 5.971705324337606e-157, 2.133359541356556e-164, 5.132424093339838e-172, 8.315439014135139e-180, 9.073244710979587e-188}, {-2.7573934087258016, -4.566451714021756, -3.9298095078998267, -1.664376165440909, 0., 0.3575124552426371, 0.1823661975461084, 0.04691407881291297, 0.00721722976410608, 0.0007005127160598131, 0.000043938290803233665, 1.803941872461557e-6, 4.885304707284546e-8, 8.770228212375202e-10, 1.0472738951376254e-11, 8.338707773642364e-14, 4.4351722511471695e-16, 1.5779477290108752e-18, 3.7593299487772955e-21, 6.002521636818974e-24, 6.4277830009114345e-27, 4.6188908411702076e-30, 2.22826280268458e-33, 7.219678519426613e-37, 1.5715801881894659e-40, 2.2990371849086217e-44, 2.2607505477811292e-48, 1.4946821668735847e-52, 6.645310641663717e-57, 1.987114160290639e-61, 3.996999062822428e-66, 5.408845089879139e-71, 4.924746345834973e-76, 3.017285451841844e-81, 1.2440620564928782e-86, 3.452206880478604e-92, 6.447826070783532e-98, 8.106271866634638e-104, 6.860367082172036e-110, 3.9085578171960676e-116, 1.4991714859791205e-122, 3.871438987784162e-129, 6.7313001657590906e-136, 7.88040518892338e-143, 6.212086359530073e-150, 3.2974700516122485e-157, 1.1786712330659671e-164, 2.8371740910599064e-172, 4.5991004835779275e-180, 5.020705482151523e-188}, {-1.322495546368624, -2.317876634543589, -2.2392106300279293, -1.2637899947293123, -0.3575124552426371, 0., 0.0346111568811734, 0.011871622269363396, 0.002054602952835872, 0.0002127163414042205, 0.000013898114729461376, 5.869067485077471e-7, 1.6225294548110943e-8, 2.9590403061823116e-10, 3.5776264983845635e-12, 2.8773853987397196e-14, 1.543169716983821e-16, 5.528688158837755e-19, 1.3250040335271742e-21, 2.1264825374478215e-24, 2.2873028950489776e-27, 1.6500604553699976e-30, 7.987922342447616e-34, 2.596137505017985e-37, 5.666971209702528e-41, 8.310889100401609e-45, 8.191057790741901e-49, 5.426682026467886e-53, 2.4172552341184814e-57, 7.240768011590267e-62, 1.4587848589003034e-66, 1.976990707512762e-71, 1.8025198830074456e-76, 1.1057752445015643e-81, 4.564667906937585e-87, 1.2680802668509632e-92, 2.3709116541203505e-98, 2.9836475466966276e-104, 2.527392362239032e-110, 1.4411781918938974e-116, 5.532317591858902e-123, 1.4297609192002656e-129, 2.48775318590318e-136, 2.9144574937360776e-143, 2.2989645285192058e-150, 1.2210885188440883e-157, 4.367343867158672e-165, 1.0518575830281586e-172, 1.7059990502714688e-180, 1.8633524233174482e-188}, {-0.4076554706645801, -0.7402600040291192, -0.7617666761487752, -0.48352606665666675, -0.1823661975461084, -0.0346111568811734, 0., 0.0015138831173608107, 0.0003493401545352363, 0.00004068869381105017, 2.8356809541140377e-6, 1.2473813494681523e-7, 3.5469667583535423e-9, 6.603439433227732e-11, 8.110613369599636e-13, 6.604679295517285e-15, 3.577932712535792e-17, 1.2925420252588142e-19, 3.119365131676186e-22, 5.036029201438232e-25, 5.4446697704977685e-28, 3.945319760972843e-31, 1.9174142871709123e-34, 6.253384908722364e-38, 1.369244342373455e-41, 2.0136413881128114e-45, 1.9895814368502707e-49, 1.3211192222286843e-53, 5.896962562011421e-58, 1.7697512936482203e-62, 3.5716877626423414e-67, 4.848219675135116e-72, 4.426909506753577e-77, 2.719465717226664e-82, 1.124035969332385e-87, 3.126327513442772e-93, 5.8517520252347164e-99, 7.371743466460189e-105, 6.250570859509011e-111, 3.567497500622609e-117, 1.3706574994208996e-123, 3.5451934111350837e-130, 6.173323464919165e-137, 7.237470666183129e-144, 5.7129736549099744e-151, 3.0364261493437607e-158, 1.0866870206707899e-165, 2.6188007953028796e-173, 4.249820369552368e-181, 4.644315704165537e-189}, {-0.08198015723885069, -0.1525257552619409, -0.1633433718214657, -0.11057152746923773, -0.04691407881291297, -0.011871622269363396, -0.0015138831173608107, 0., 0.00002995582142905577, 4.652058469838275e-6, 3.6473822458276294e-7, 1.711401339966944e-8, 5.069189142335086e-10, 9.70702225124931e-12, 1.2170946749941965e-13, 1.0068431446362928e-15, 5.522519780660107e-18, 2.015183442229118e-20, 4.903884679103974e-23, 7.972393521442633e-26, 8.670606021274968e-29, 6.315119528963386e-32, 3.0828317616730696e-35, 1.0093663228099981e-38, 2.2177876378230684e-42, 3.2716257607775205e-46, 3.241514066753274e-50, 2.157820410794028e-54, 9.653561507535495e-59, 2.9031512740048934e-63, 5.870196813831934e-68, 7.982080519330925e-73, 7.300118102280014e-78, 4.491131307832484e-83, 1.858867875034802e-88, 5.176748733647825e-94, 9.701195054986718e-100, 1.2234672638898809e-105, 1.038470053282982e-111, 5.932835330127792e-118, 2.2815319114331714e-124, 5.906271190130481e-131, 1.0293122810495383e-137, 1.2076752625663576e-144, 9.539880307355511e-152, 5.073927872248437e-159, 1.8170700585982575e-166, 4.381685224931241e-174, 7.114882238730206e-182, 7.779741104417099e-190}, {-0.010851106090327071, -0.020548663278756606, -0.022619350094078644, -0.015947501961927076, -0.00721722976410608, -0.002054602952835872, -0.0003493401545352363, -0.00002995582142905577, 0., 2.683744696771594e-7, 2.805537294284579e-8, 1.4809457640341911e-9, 4.679015717581992e-11, 9.333204871179682e-13, 1.203659344483049e-14, 1.0164730975767445e-16, 5.6638373831363e-19, 2.092585025291853e-21, 5.143675717934714e-24, 8.431914296817627e-27, 9.234499529735262e-30, 6.765858460327647e-33, 3.3198053293905755e-36, 1.0918075751344482e-39, 2.408335767890797e-43, 3.56505349863291e-47, 3.5431768572354077e-51, 2.3651839206353953e-55, 1.0607774640112495e-59, 3.197365581830502e-64, 6.478485972057853e-69, 8.82589414229853e-74, 8.085877075113941e-79, 4.98251286634603e-84, 2.0653046418719017e-89, 5.759553729011251e-95, 1.080715263796109e-100, 1.3645677778224978e-106, 1.1595234954664178e-112, 6.63132060047375e-119, 2.5526343028406306e-125, 6.614155817250414e-132, 1.1536764891890796e-138, 1.3546956276032207e-145, 1.070951288030639e-152, 5.700178183991677e-160, 2.042756855670074e-167, 4.929147403925831e-175, 8.00884457931573e-183, 8.76245349133924e-191}, {-0.0009506866249366184, -0.001824672526464107, -0.002049329494933695, -0.001485992852314795, -0.0007005127160598131, -0.0002127163414042205, -0.00004068869381105017, -4.652058469838275e-6, -2.683744696771594e-7, 0., 1.0892309465498825e-9, 7.666229484646371e-11, 2.7248944720615805e-12, 5.797686210877017e-14, 7.788543787200947e-16, 6.7652370603346725e-18, 3.848156700741304e-20, 1.4443236099894738e-22, 3.5945953657443445e-25, 5.952061615115263e-28, 6.572925690340711e-31, 4.84947496604765e-34, 2.393656647459378e-37, 7.912556051951785e-41, 1.7531627393677948e-44, 2.605379744607394e-48, 2.5983830024862935e-52, 1.7398737734522204e-56, 7.824954296572287e-61, 2.3644869219701805e-65, 4.801799878524188e-70, 6.555223124868467e-75, 6.0169672640229765e-80, 3.7140999045585596e-85, 1.5420011637245079e-90, 4.3065781980446395e-96, 8.091908025457405e-102, 1.0230316383101843e-107, 8.703425496046879e-114, 4.9830300420734765e-120, 1.920145930475608e-126, 4.980172432124356e-133, 8.69466762433852e-140, 1.0218485226182702e-146, 8.084798134254908e-154, 4.306486875023461e-161, 1.5444317592063038e-168, 3.729277619924366e-176, 6.06329084498419e-184, 6.637977561992726e-192}, {-0.0000553424745444633, -0.00010734861743636342, -0.00012242970499148984, -0.00009061804960156597, -0.000043938290803233665, -0.000013898114729461376, -2.8356809541140377e-6, -3.6473822458276294e-7, -2.805537294284579e-8, -1.0892309465498825e-9, 0., 2.003533781997838e-12, 9.495181670747115e-14, 2.2727978992686646e-15, 3.256800098208357e-17, 2.946772599047289e-19, 1.7240537782184025e-21, 6.605678204558838e-24, 1.6700994661892982e-26, 2.799979020871431e-29, 3.123279760257117e-32, 2.323544585847624e-35, 1.1549005747806512e-38, 3.840404463258369e-42, 8.552712197020807e-46, 1.2766950025367428e-49, 1.278259642370981e-53, 8.588928898126725e-58, 3.8747667412543568e-62, 1.174100765271269e-66, 2.390339602367187e-71, 3.2706113696169196e-76, 3.008273673425599e-81, 1.8604372455163214e-86, 7.737502174395761e-92, 2.1644315095988631e-97, 4.0729152303999124e-103, 5.156317454144852e-109, 4.3923313891332e-115, 2.5177644562003984e-121, 9.712670298612706e-128, 2.521743702738174e-134, 4.4069068687494896e-141, 5.184016722035908e-148, 4.105110983158421e-155, 2.1884343408068146e-162, 7.854424148443687e-170, 1.897962782042571e-177, 3.087964082338993e-185, 3.3828695066432103e-193}, {-2.1464211417348547e-6, -4.1991079374855824e-6, -4.8473111099190965e-6, -3.644544593706978e-6, -1.803941872461557e-6, -5.869067485077471e-7, -1.2473813494681523e-7, -1.711401339966944e-8, -1.4809457640341911e-9, -7.666229484646371e-11, -2.003533781997838e-12, 0., 1.670725613558073e-15, 5.332138336224409e-17, 8.595758666161668e-19, 8.295994544024152e-21, 5.0559341678465106e-23, 1.9925190005948057e-25, 5.14259399244343e-28, 8.758588101079904e-31, 9.89202588656881e-34, 7.4334456977489235e-37, 3.725528452329993e-40, 1.2475176747596845e-43, 2.794801853389038e-47, 4.19329854018692e-51, 4.217180617092683e-55, 2.844735658976761e-59, 1.287816032641264e-63, 3.914318164493936e-68, 7.99125630293526e-73, 1.096153793021404e-77, 1.0105220742506293e-82, 6.262413181538356e-88, 2.6094514816051663e-93, 7.3121809263816216e-99, 1.3781734521482658e-104, 1.7473547263211068e-110, 1.490502400129519e-116, 8.554743246167108e-123, 3.304054769205012e-129, 8.588006288608354e-136, 1.5023718446970714e-142, 1.7690262614096793e-149, 1.4021412743181292e-156, 7.481285726114703e-164, 2.6872727082194763e-171, 6.498607635883109e-179, 1.0580890392489706e-186, 1.1599414894483648e-194}, {-5.557405524597667e-8, -1.094879679369818e-7, -1.2763176460568502e-7, -9.715745023762609e-8, -4.885304707284546e-8, -1.6225294548110943e-8, -3.5469667583535423e-9, -5.069189142335086e-10, -4.679015717581992e-11, -2.7248944720615805e-12, -9.495181670747115e-14, -1.670725613558073e-15, 0., 6.317540369043946e-19, 1.35790556437854e-20, 1.474369487295926e-22, 9.584467977216486e-25, 3.934575095571267e-27, 1.0445087001604852e-29, 1.8160122304883307e-32, 2.083575945766527e-35, 1.5852921017328648e-38, 8.02549470585279e-42, 2.7097845341589428e-45, 6.1131567177786056e-49, 9.226727889720292e-53, 9.326862872333049e-57, 6.319603142145114e-61, 2.8721128632605246e-65, 8.760101792297013e-70, 1.7939510034246698e-74, 2.467582658712994e-79, 2.2805159761115927e-84, 1.4164946718629014e-89, 5.914536065022429e-95, 1.6605048033380987e-100, 3.1351023681792624e-106, 3.9812949494803e-112, 3.4010958917097e-118, 1.9547414654071794e-124, 7.559340089918873e-131, 1.967187291976648e-137, 3.4451934288557136e-144, 4.0609029340527034e-151, 3.2218433847446513e-158, 1.7206315332547423e-165, 6.1858477606862644e-173, 1.497140205158881e-180, 2.439493164178362e-188, 2.6762755316903535e-196}, {-9.620222917121466e-10, -1.9065048713975295e-9, -2.240459987888015e-9, -1.7226729916091648e-9, -8.770228212375202e-10, -2.9590403061823116e-10, -6.603439433227732e-11, -9.70702225124931e-12, -9.333204871179682e-13, -5.797686210877017e-14, -2.2727978992686646e-15, -5.332138336224409e-17, -6.317540369043946e-19, 0., 1.0834424662567536e-22, 1.5684885659143319e-24, 1.1470848815334897e-26, 5.0228950902552816e-29, 1.3889835344159957e-31, 2.483923756912554e-34, 2.9092675963126726e-37, 2.2486561716739384e-40, 1.1526052775127222e-43, 3.931048086417854e-47, 8.942176762427241e-51, 1.359101489037854e-54, 1.382029107524656e-58, 9.412237228842291e-63, 4.29673985469905e-67, 1.3156685571875666e-71, 2.7036674680123232e-76, 3.7304128240182203e-81, 3.457188073155561e-86, 2.152741722225727e-91, 9.009145065496773e-97, 2.5345523323418866e-102, 4.794403725460588e-108, 6.099045422345774e-114, 5.218573675791943e-120, 3.003759734054013e-126, 1.1632040322074192e-132, 3.030902914997116e-139, 5.314429315901894e-146, 6.27116823311327e-153, 4.980608697187021e-160, 2.662503565024435e-167, 9.580772593716009e-175, 2.3208102173917453e-182, 3.784699744147871e-190, 4.1552569249966684e-198}, {-1.1147099457676925e-11, -2.2201906934975724e-11, -2.626839322280268e-11, -2.0365238538217674e-11, -1.0472738951376254e-11, -3.5776264983845635e-12, -8.110613369599636e-13, -1.2170946749941965e-13, -1.203659344483049e-14, -7.788543787200947e-16, -3.256800098208357e-17, -8.595758666161668e-19, -1.35790556437854e-20, -1.0834424662567536e-22, 0., 8.428356713613902e-27, 8.218562143164702e-29, 4.0486190791309954e-31, 1.1942043010629976e-33, 2.2245827318133652e-36, 2.679960707937419e-39, 2.1145728644604498e-42, 1.1010819108828257e-45, 3.802265266785084e-49, 8.73659315178638e-53, 1.3389207556671564e-56, 1.3710289659581688e-60, 9.39290063152248e-65, 4.309901883311907e-69, 1.3255903036816955e-73, 2.7347389943317847e-78, 3.78638576088276e-83, 3.5199253795687435e-88, 2.1978957021965086e-93, 9.221165728080202e-99, 2.600096239961854e-104, 4.928570730136551e-110, 6.281596104847448e-116, 5.384118363935886e-122, 3.104012049312496e-128, 1.2038074573120204e-134, 3.141009896637818e-141, 5.5145263358180034e-148, 6.515034821094417e-155, 5.180044970154887e-162, 2.7720014941206325e-169, 9.984541283240297e-177, 2.420840615989265e-184, 3.9512440064459686e-192, 4.3416516194788026e-200}, {-8.65374147080545e-14, -1.731031837935921e-13, -2.0599412640264078e-13, -1.6081464274996303e-13, -8.338707773642364e-14, -2.8773853987397196e-14, -6.604679295517285e-15, -1.0068431446362928e-15, -1.0164730975767445e-16, -6.7652370603346725e-18, -2.946772599047289e-19, -8.295994544024152e-21, -1.474369487295926e-22, -1.5684885659143319e-24, -8.428356713613902e-27, 0., 2.9744820678726433e-31, 1.9537147967807405e-33, 6.483140025611186e-36, 1.2882022580616497e-38, 1.6165631995601808e-41, 1.3119623513523453e-44, 6.973859415702858e-48, 2.4464446659667643e-51, 5.6915444065384095e-55, 8.810644862997372e-59, 9.097112737019481e-63, 6.276002805226178e-67, 2.8968646714860026e-71, 8.955536384665352e-76, 1.8558063953096534e-80, 2.5795350119095335e-85, 2.40633108010993e-90, 1.5072021026547977e-95, 6.34095892785202e-101, 1.79244414586833e-106, 3.4053606616881175e-112, 4.349209828574447e-118, 3.7348804111014898e-124, 2.15695030288155e-130, 8.378556399739368e-137, 2.189396381427466e-143, 3.849102313850875e-150, 4.5532582385182286e-157, 3.624564066697165e-164, 1.9417733142441124e-171, 7.001407249324985e-179, 1.6992126907882763e-186, 2.775967519418925e-194, 3.052891376599844e-202}, {-4.50437325958465e-16, -9.04408247754179e-16, -1.0816187710280278e-15, -8.494001747888334e-16, -4.4351722511471695e-16, -1.543169716983821e-16, -3.577932712535792e-17, -5.522519780660107e-18, -5.6638373831363e-19, -3.848156700741304e-20, -1.7240537782184025e-21, -5.0559341678465106e-23, -9.584467977216486e-25, -1.1470848815334897e-26, -8.218562143164702e-29, -2.9744820678726433e-31, 0., 4.762709687354364e-36, 2.107254948731972e-38, 4.7105135692156e-41, 6.305297967504637e-44, 5.33044008481182e-47, 2.9144012087401045e-50, 1.0436776660752758e-53, 2.4666103296090522e-57, 3.86610055254562e-61, 4.032123552615107e-65, 2.8049008098421423e-69, 1.3037341477248349e-73, 4.054430488339153e-78, 8.444858622424176e-83, 1.1790592858987472e-87, 1.1042041661694903e-92, 6.940181803519064e-98, 2.9288476664588076e-103, 8.302180600826396e-109, 1.581236225967076e-114, 2.024090443485697e-120, 1.7417847547176723e-126, 1.0078123427178932e-132, 3.921600688592161e-139, 1.0263937441385983e-145, 1.8071407488577386e-152, 2.1406760716575457e-159, 1.706234636023926e-166, 9.151624897670966e-174, 3.303450780657634e-181, 8.025690323872538e-189, 1.312421566700094e-196, 1.4446721966762401e-204}, {-1.572957828363624e-18, -3.1686711975249758e-18, -3.805988236758712e-18, -3.0041271474818337e-18, -1.5779477290108752e-18, -5.528688158837755e-19, -1.2925420252588142e-19, -2.015183442229118e-20, -2.092585025291853e-21, -1.4443236099894738e-22, -6.605678204558838e-24, -1.9925190005948057e-25, -3.934575095571267e-27, -5.0228950902552816e-29, -4.0486190791309954e-31, -1.9537147967807405e-33, -4.762709687354364e-36, 0., 3.4602454141466414e-41, 1.0313280150533882e-43, 1.553054488495673e-46, 1.4004669625725148e-49, 7.976050725451048e-53, 2.9379162769275754e-56, 7.088076789968713e-60, 1.1286010184851637e-63, 1.1917801722610006e-67, 8.374225236600549e-72, 3.924824979459997e-76, 1.2291009879013621e-80, 2.5752981446059426e-85, 3.6140340052606903e-90, 3.3996990414313194e-95, 2.1451700434463572e-100, 9.084332366240088e-106, 2.583038597138654e-111, 4.933330096326181e-117, 6.330826773208478e-123, 5.460229712375786e-129, 3.165879150019948e-135, 1.2342404611924108e-141, 3.2359741553488465e-148, 5.706613435202945e-155, 6.769870378106954e-162, 5.403364953010869e-169, 2.9018707142327767e-176, 1.0487317073292754e-183, 2.5507140482656432e-191, 4.175465396947738e-199, 4.600713275590781e-207}, {-3.686975675045035e-21, -7.448960367038235e-21, -8.981276280135666e-21, -7.120586727272451e-21, -3.7593299487772955e-21, -1.3250040335271742e-21, -3.119365131676186e-22, -4.903884679103974e-23, -5.143675717934714e-24, -3.5945953657443445e-25, -1.6700994661892982e-26, -5.14259399244343e-28, -1.0445087001604852e-29, -1.3889835344159957e-31, -1.1942043010629976e-33, -6.483140025611186e-36, -2.107254948731972e-38, -3.4602454141466414e-41, 0., 1.140774478264706e-46, 2.290490058087675e-49, 2.3236307148209997e-52, 1.411597470000771e-55, 5.416155770486443e-59, 1.34404745015924e-62, 2.1846479816980102e-66, 2.3435628787963106e-70, 1.6673244704195563e-74, 7.893335940513705e-79, 2.4924817315093018e-83, 5.258942056022032e-88, 7.42404384802467e-93, 7.019565429029995e-98, 4.449036584474014e-103, 1.8914595302766365e-108, 5.396849273152434e-114, 1.0339321904715997e-119, 1.3305065369287792e-125, 1.150415148591274e-131, 6.685346531221455e-138, 2.611725932391175e-144, 6.86048178674159e-151, 1.2119443114924795e-157, 1.440058022982977e-164, 1.1510835894182852e-171, 6.190372305412405e-179, 2.24004843614856e-186, 5.454707840059331e-194, 8.939174740547874e-202, 9.859839844237904e-210}, {-5.803320048632028e-24, -1.175518435995987e-23, -1.422115198375876e-23, -1.1318934143027776e-23, -6.002521636818974e-24, -2.1264825374478215e-24, -5.036029201438232e-25, -7.972393521442633e-26, -8.431914296817627e-27, -5.952061615115263e-28, -2.799979020871431e-29, -8.758588101079904e-31, -1.8160122304883307e-32, -2.483923756912554e-34, -2.2245827318133652e-36, -1.2882022580616497e-38, -4.7105135692156e-41, -1.0313280150533882e-43, -1.140774478264706e-46, 0., 1.7067044980750693e-52, 2.3085312995778063e-55, 1.5777277070129191e-58, 6.4571526136949495e-62, 1.6691419526237889e-65, 2.7905807622078965e-69, 3.055938296750319e-73, 2.2086531518482116e-77, 1.0586758686187687e-81, 3.376752393716176e-86, 7.18405655409888e-91, 1.0212647444666684e-95, 9.713717317481034e-101, 6.188176201924015e-106, 2.6425806320776604e-111, 7.56957101865022e-117, 1.4552191152853587e-122, 1.87843354164953e-128, 1.628688818561384e-134, 9.488434025380435e-141, 3.71521655166626e-147, 9.779336231035802e-154, 1.730848980416285e-160, 2.0602083442976973e-167, 1.6494282965810028e-174, 8.883544269995085e-182, 3.219015438773523e-189, 7.848586434559627e-197, 1.2877574993530202e-204, 1.4219664156127648e-212}, {-6.136067241833546e-27, -1.2458166810224679e-26, -1.511694286308292e-26, -1.2073524600003188e-26, -6.4277830009114345e-27, -2.2873028950489776e-27, -5.4446697704977685e-28, -8.670606021274968e-29, -9.234499529735262e-30, -6.572925690340711e-31, -3.123279760257117e-32, -9.89202588656881e-34, -2.083575945766527e-35, -2.9092675963126726e-37, -2.679960707937419e-39, -1.6165631995601808e-41, -6.305297967504637e-44, -1.553054488495673e-46, -2.290490058087675e-49, -1.7067044980750693e-52, 0., 1.1587890707615025e-58, 1.0559404147901511e-61, 4.861843033072935e-65, 1.3405464869226189e-68, 2.3345972458154127e-72, 2.6296406846651815e-76, 1.9401450109783046e-80, 9.447330536345604e-85, 3.0509869130208423e-89, 6.556554511240188e-94, 9.39828039082893e-99, 9.001646904063934e-104, 5.768682103924453e-109, 2.4760741330008967e-114, 7.124283008721602e-120, 1.3749853503943843e-125, 1.7810285024281455e-131, 1.5490150520959942e-137, 9.049337097400483e-144, 3.5521676333845374e-150, 9.371402929483729e-157, 1.6620827428907634e-163, 1.9821036216803693e-170, 1.5896565093963305e-177, 8.575343995668214e-185, 3.1119403397425654e-192, 7.597938906619537e-200, 1.24822460771104e-207, 1.3799542912672527e-215}, {-4.3595592828124286e-30, -8.869894508821509e-30, -1.0791921086346259e-29, -8.645815531840907e-30, -4.6188908411702076e-30, -1.6500604553699976e-30, -3.945319760972843e-31, -6.315119528963386e-32, -6.765858460327647e-33, -4.84947496604765e-34, -2.323544585847624e-35, -7.4334456977489235e-37, -1.5852921017328648e-38, -2.2486561716739384e-40, -2.1145728644604498e-42, -1.3119623513523453e-44, -5.33044008481182e-47, -1.4004669625725148e-49, -2.3236307148209997e-52, -2.3085312995778063e-55, -1.1587890707615025e-58, 0., 3.5707287066706588e-65, 2.192083598955764e-68, 6.799712971160934e-72, 1.2631339098131246e-75, 1.4820491367133765e-79, 1.1246951960714054e-83, 5.590679576358407e-88, 1.834151734137604e-92, 3.9908520166471883e-97, 5.77834078080868e-102, 5.580599437429126e-107, 3.601321875239839e-112, 1.554985695557241e-117, 4.4970257912695136e-123, 8.717998418406063e-129, 1.1336770877808746e-134, 9.894172837564518e-141, 5.798065390750448e-147, 2.2822567303393842e-153, 6.036187899815877e-160, 1.0729925156181485e-166, 1.2822379851111051e-173, 1.0303086014125318e-180, 5.567628151017182e-188, 2.0236964111518305e-195, 4.948263513948405e-203, 8.140403106277e-211, 9.010983059514597e-219}, {-2.0818384929728714e-33, -4.2437461870279424e-33, -5.175899217384363e-33, -4.158080251595964e-33, -2.22826280268458e-33, -7.987922342447616e-34, -1.9174142871709123e-34, -3.0828317616730696e-35, -3.3198053293905755e-36, -2.393656647459378e-37, -1.1549005747806512e-38, -3.725528452329993e-40, -8.02549470585279e-42, -1.1526052775127222e-43, -1.1010819108828257e-45, -6.973859415702858e-48, -2.9144012087401045e-50, -7.976050725451048e-53, -1.411597470000771e-55, -1.5777277070129191e-58, -1.0559404147901511e-61, -3.5707287066706588e-65, 0., 4.993811477732778e-72, 2.0654008327570272e-75, 4.3163403665876025e-79, 5.402037763894656e-83, 4.270302298817302e-87, 2.183347375206553e-91, 7.312204687747948e-96, 1.6162856900092288e-100, 2.3694671201846322e-105, 2.3114962434112098e-110, 1.5041058635237096e-115, 6.539873052188484e-121, 1.902592240136926e-126, 3.70730731982449e-132, 4.842455873688814e-138, 4.2428295024290194e-144, 2.494965539144032e-150, 9.851183906996628e-157, 2.6127110488579053e-163, 4.655994083235568e-170, 5.576610066577953e-177, 4.4902156214740873e-184, 2.431038532181122e-191, 8.851596750653083e-199, 2.1678264269607054e-206, 3.571581142679288e-214, 3.958976576120756e-222}, {-6.6834601386148135e-37, -1.3647601693088537e-36, -1.6682090225364782e-36, -1.343507903576248e-36, -7.219678519426613e-37, -2.596137505017985e-37, -6.253384908722364e-38, -1.0093663228099981e-38, -1.0918075751344482e-39, -7.912556051951785e-41, -3.840404463258369e-42, -1.2475176747596845e-43, -2.7097845341589428e-45, -3.931048086417854e-47, -3.802265266785084e-49, -2.4464446659667643e-51, -1.0436776660752758e-53, -2.9379162769275754e-56, -5.416155770486443e-59, -6.4571526136949495e-62, -4.861843033072935e-65, -2.192083598955764e-68, -4.993811477732778e-72, 0., 3.169893082536729e-79, 8.83272454296828e-83, 1.2436241334700497e-86, 1.0486217689216217e-90, 5.5848543873228205e-95, 1.923852678459307e-99, 4.341066541218267e-104, 6.464998465897793e-109, 6.385662533374911e-114, 4.197164405588841e-119, 1.840140649861234e-124, 5.3908081571653285e-130, 1.056681653959852e-135, 1.3873074247066703e-141, 1.2209478612602557e-147, 7.207852234228458e-154, 2.855848107046661e-160, 7.597672128825004e-167, 1.3577077187700327e-173, 1.6302388603787192e-180, 1.315630921915596e-187, 7.13767795809482e-195, 2.6038051221452405e-202, 6.38801608921457e-210, 1.0541379387421382e-217, 1.170207232639192e-225}, {-1.442749437035431e-40, -2.950761414491726e-40, -3.6141043767828223e-40, -2.9172414031672084e-40, -1.5715801881894659e-40, -5.666971209702528e-41, -1.369244342373455e-41, -2.2177876378230684e-42, -2.408335767890797e-43, -1.7531627393677948e-44, -8.552712197020807e-46, -2.794801853389038e-47, -6.1131567177786056e-49, -8.942176762427241e-51, -8.73659315178638e-53, -5.6915444065384095e-55, -2.4666103296090522e-57, -7.088076789968713e-60, -1.34404745015924e-62, -1.6691419526237889e-65, -1.3405464869226189e-68, -6.799712971160934e-72, -2.0654008327570272e-75, -3.169893082536729e-79, 0., 9.132862097370668e-87, 1.7145102709349972e-90, 1.6263811853194665e-94, 9.239405975846118e-99, 3.3153758923331912e-103, 7.694703010428976e-108, 1.1698190465770154e-112, 1.1738041750227096e-117, 7.811612640422845e-123, 3.4593981039062143e-128, 1.0218979428637574e-133, 2.01708532599658e-139, 2.663975559673298e-145, 2.3565469894768135e-151, 1.3973955633649742e-157, 5.558381806642382e-164, 1.4838813388310672e-170, 2.6599128045444237e-177, 3.202705868144195e-184, 2.5911167526730994e-191, 1.4089506188675233e-198, 5.150454213488925e-206, 1.2659740527962927e-213, 2.0927188488971238e-221, 2.3268674672953886e-229}, {-2.0945489993053403e-44, -4.290080450618886e-44, -5.264172968221932e-44, -4.2579093294300074e-44, -2.2990371849086217e-44, -8.310889100401609e-45, -2.0136413881128114e-45, -3.2716257607775205e-46, -3.56505349863291e-47, -2.605379744607394e-48, -1.2766950025367428e-49, -4.19329854018692e-51, -9.226727889720292e-53, -1.359101489037854e-54, -1.3389207556671564e-56, -8.810644862997372e-59, -3.86610055254562e-61, -1.1286010184851637e-63, -2.1846479816980102e-66, -2.7905807622078965e-69, -2.3345972458154127e-72, -1.2631339098131246e-75, -4.3163403665876025e-79, -8.83272454296828e-83, -9.132862097370668e-87, 0., 1.1943460358874167e-94, 1.5106058404023627e-98, 9.654402270091181e-103, 3.695241606059745e-107, 8.93368618980338e-112, 1.3969857478956469e-116, 1.430947762429207e-121, 9.674048358895455e-127, 4.3377361265188156e-132, 1.294299897263738e-137, 2.576058884364491e-143, 3.4260066912410463e-149, 3.048677584389258e-155, 1.8170890599300515e-161, 7.2600519546884935e-168, 1.9457646609488735e-174, 3.499966547109605e-181, 4.227231543446526e-188, 3.429498873015764e-195, 1.869504651458739e-202, 6.84955286017492e-210, 1.6870957302941449e-217, 2.794136105360207e-225, 3.112167460765016e-233}, {-2.0453431590972403e-48, -4.194913660832307e-48, -5.1560916349067104e-48, -4.1783545308506534e-48, -2.2607505477811292e-48, -8.191057790741901e-49, -1.9895814368502707e-49, -3.241514066753274e-50, -3.5431768572354077e-51, -2.5983830024862935e-52, -1.278259642370981e-53, -4.217180617092683e-55, -9.326862872333049e-57, -1.382029107524656e-58, -1.3710289659581688e-60, -9.097112737019481e-63, -4.032123552615107e-65, -1.1917801722610006e-67, -2.3435628787963106e-70, -3.055938296750319e-73, -2.6296406846651815e-76, -1.4820491367133765e-79, -5.402037763894656e-83, -1.2436241334700497e-86, -1.7145102709349972e-90, -1.1943460358874167e-94, 0., 7.089642877258283e-103, 6.04139632436982e-107, 2.6014009708686035e-111, 6.708476079645497e-116, 1.092732663092937e-120, 1.1512779469346896e-125, 7.945468358665106e-131, 3.6192101603253995e-136, 1.0934039074951626e-141, 2.1981954082100463e-147, 2.947832762966076e-153, 2.6415119928671236e-159, 1.5837795308422529e-165, 6.360330754140479e-172, 1.7122405710135522e-178, 3.0919904942476774e-185, 3.747448285804525e-192, 3.0496694137873735e-199, 1.6670681368544243e-206, 6.123167192891185e-214, 1.5116092320541705e-221, 2.508681906280884e-229, 2.799514668559109e-237}, {-1.3436197166825296e-52, -2.7591226881151985e-52, -3.396596444048669e-52, -2.757275532954999e-52, -1.4946821668735847e-52, -5.426682026467886e-53, -1.3211192222286843e-53, -2.157820410794028e-54, -2.3651839206353953e-55, -1.7398737734522204e-56, -8.588928898126725e-58, -2.844735658976761e-59, -6.319603142145114e-61, -9.412237228842291e-63, -9.39290063152248e-65, -6.276002805226178e-67, -2.8049008098421423e-69, -8.374225236600549e-72, -1.6673244704195563e-74, -2.2086531518482116e-77, -1.9401450109783046e-80, -1.1246951960714054e-83, -4.270302298817302e-87, -1.0486217689216217e-90, -1.6263811853194665e-94, -1.5106058404023627e-98, -7.089642877258283e-103, 0., 1.9102856914071685e-111, 1.0967484524987128e-115, 3.181823831288902e-120, 5.528342015687714e-125, 6.067222627519986e-130, 4.3068892503336734e-135, 2.0026859307770871e-140, 6.146375520628067e-146, 1.2511223925017856e-151, 1.6947324593097716e-157, 1.531281435063204e-163, 9.245355407169492e-170, 3.734960461331185e-176, 1.0106308503116453e-182, 1.8331601924031717e-189, 2.2304767520001487e-196, 1.821462236765502e-203, 9.987648423625324e-211, 3.67866901766265e-218, 9.10418822452879e-226, 1.5143742024898474e-233, 1.693435202813666e-241}, {-5.938450666366733e-57, -1.2208612300137993e-56, -1.5050937520315955e-56, -1.223749002081474e-56, -6.645310641663717e-57, -2.4172552341184814e-57, -5.896962562011421e-58, -9.653561507535495e-59, -1.0607774640112495e-59, -7.824954296572287e-61, -3.8747667412543568e-62, -1.287816032641264e-63, -2.8721128632605246e-65, -4.29673985469905e-67, -4.309901883311907e-69, -2.8968646714860026e-71, -1.3037341477248349e-73, -3.924824979459997e-76, -7.893335940513705e-79, -1.0586758686187687e-81, -9.447330536345604e-85, -5.590679576358407e-88, -2.183347375206553e-91, -5.5848543873228205e-95, -9.239405975846118e-99, -9.654402270091181e-103, -6.04139632436982e-107, -1.9102856914071685e-111, 0., 2.33646891119796e-120, 9.037906484120344e-125, 1.766603712186086e-129, 2.0680588354378566e-134, 1.5292040173312705e-139, 7.313900188445114e-145, 2.2914485772567695e-150, 4.73838393038438e-156, 6.498702096107112e-162, 5.931237359219794e-168, 3.6109212913064808e-174, 1.4689495297298738e-180, 3.998442362176854e-187, 7.289876427789767e-194, 8.909471634639026e-201, 7.304226047978372e-208, 4.019042832559289e-215, 1.484884216238206e-222, 3.685087508416518e-230, 6.145070585652708e-238, 6.887286821268343e-246}, {-1.7660504380322254e-61, -3.6346250697488396e-61, -4.4867898436397825e-61, -3.653463831004161e-61, -1.987114160290639e-61, -7.240768011590267e-62, -1.7697512936482203e-62, -2.9031512740048934e-63, -3.197365581830502e-64, -2.3644869219701805e-65, -1.174100765271269e-66, -3.914318164493936e-68, -8.760101792297013e-70, -1.3156685571875666e-71, -1.3255903036816955e-73, -8.955536384665352e-76, -4.054430488339153e-78, -1.2291009879013621e-80, -2.4924817315093018e-83, -3.376752393716176e-86, -3.0509869130208423e-89, -1.834151734137604e-92, -7.312204687747948e-96, -1.923852678459307e-99, -3.3153758923331912e-103, -3.695241606059745e-107, -2.6014009708686035e-111, -1.0967484524987128e-115, -2.33646891119796e-120, 0., 1.2972287332301317e-129, 3.380855363212437e-134, 4.452489104729118e-139, 3.511835213145422e-144, 1.7496311218197858e-149, 5.638220261409074e-155, 1.1901919587404767e-160, 1.658260739443021e-166, 1.5323801779883356e-172, 9.423322376593153e-179, 3.8654229919956675e-185, 1.0595158199510601e-191, 1.9431852046984662e-198, 2.387082550105033e-205, 1.965731483300417e-212, 1.0858564311550032e-219, 4.0257585047236176e-227, 1.0021792844699115e-234, 1.675827037637529e-242, 1.8829447735583844e-250}, {-3.534337576809649e-66, -7.281089311777373e-66, -8.99934011813199e-66, -7.337928053715567e-66, -3.996999062822428e-66, -1.4587848589003034e-66, -3.5716877626423414e-67, -5.870196813831934e-68, -6.478485972057853e-69, -4.801799878524188e-70, -2.390339602367187e-71, -7.99125630293526e-73, -1.7939510034246698e-74, -2.7036674680123232e-76, -2.7347389943317847e-78, -1.8558063953096534e-80, -8.444858622424176e-83, -2.5752981446059426e-85, -5.258942056022032e-88, -7.18405655409888e-91, -6.556554511240188e-94, -3.9908520166471883e-97, -1.6162856900092288e-100, -4.341066541218267e-104, -7.694703010428976e-108, -8.93368618980338e-112, -6.708476079645497e-116, -3.181823831288902e-120, -9.037906484120344e-125, -1.2972287332301317e-129, 0., 3.2694480186111333e-139, 5.741025122317867e-144, 5.094167649513396e-149, 2.707162485223245e-154, 9.087378824669912e-160, 1.973095304449918e-165, 2.8063298296742053e-171, 2.6344614265097844e-177, 1.64030420865156e-183, 6.796450862587685e-190, 1.878437396598229e-196, 3.4692047297171623e-203, 4.2870702055421286e-210, 3.5484509876332674e-217, 1.9688903265237122e-224, 7.328188320008195e-232, 1.8306262208228321e-239, 3.0706190370895743e-247, 3.4597046769574756e-255}, {-4.760204494694069e-71, -9.815610609673186e-71, -1.2146000729041486e-70, -9.916264574171465e-71, -5.408845089879139e-71, -1.976990707512762e-71, -4.848219675135116e-72, -7.982080519330925e-73, -8.82589414229853e-74, -6.555223124868467e-75, -3.2706113696169196e-76, -1.096153793021404e-77, -2.467582658712994e-79, -3.7304128240182203e-81, -3.78638576088276e-83, -2.5795350119095335e-85, -1.1790592858987472e-87, -3.6140340052606903e-90, -7.42404384802467e-93, -1.0212647444666684e-95, -9.39828039082893e-99, -5.77834078080868e-102, -2.3694671201846322e-105, -6.464998465897793e-109, -1.1698190465770154e-112, -1.3969857478956469e-116, -1.092732663092937e-120, -5.528342015687714e-125, -1.766603712186086e-129, -3.380855363212437e-134, -3.2694480186111333e-139, 0., 3.7405846551816993e-149, 4.425496593309814e-154, 2.6457915360648766e-159, 9.473460662693492e-165, 2.1426283813393906e-170, 3.134526596986123e-176, 3.00386169878159e-182, 1.8999926155610884e-188, 7.970851664353992e-195, 2.225276988225391e-201, 4.144015825077074e-208, 5.156779072042417e-215, 4.2937243885810594e-222, 2.3946295538288977e-229, 8.952574299473697e-237, 2.245177990739298e-244, 3.7790478476225933e-252, 4.271082586462624e-260}, {-4.3150906835203096e-76, -8.905520437284768e-76, -1.103174039261659e-75, -9.017235568050733e-76, -4.924746345834973e-76, -1.8025198830074456e-76, -4.426909506753577e-77, -7.300118102280014e-78, -8.085877075113941e-79, -6.0169672640229765e-80, -3.008273673425599e-81, -1.0105220742506293e-82, -2.2805159761115927e-84, -3.457188073155561e-86, -3.5199253795687435e-88, -2.40633108010993e-90, -1.1042041661694903e-92, -3.3996990414313194e-95, -7.019565429029995e-98, -9.713717317481034e-101, -9.001646904063934e-104, -5.580599437429126e-107, -2.3114962434112098e-110, -6.385662533374911e-114, -1.1738041750227096e-117, -1.430947762429207e-121, -1.1512779469346896e-125, -6.067222627519986e-130, -2.0680588354378566e-134, -4.452489104729118e-139, -5.741025122317867e-144, -3.7405846551816993e-149, 0., 1.9427505022481337e-159, 1.5486360990702219e-164, 6.2381373725262554e-170, 1.5049492507651056e-175, 2.2933784537727738e-181, 2.2605710346000772e-187, 1.459637393920059e-193, 6.220670807200421e-200, 1.7583754075176162e-206, 3.3076057242165045e-213, 4.1502568932309096e-220, 3.479822344439796e-227, 1.9522645558860055e-234, 7.336175723258732e-242, 1.8480217038266188e-249, 3.1227589860668895e-257, 3.5415991128703177e-265}, {-2.6328850580158646e-81, -5.438205465250152e-81, -6.743405866836657e-81, -5.518099230020228e-81, -3.017285451841844e-81, -1.1057752445015643e-81, -2.719465717226664e-82, -4.491131307832484e-83, -4.98251286634603e-84, -3.7140999045585596e-85, -1.8604372455163214e-86, -6.262413181538356e-88, -1.4164946718629014e-89, -2.152741722225727e-91, -2.1978957021965086e-93, -1.5072021026547977e-95, -6.940181803519064e-98, -2.1451700434463572e-100, -4.449036584474014e-103, -6.188176201924015e-106, -5.768682103924453e-109, -3.601321875239839e-112, -1.5041058635237096e-115, -4.197164405588841e-119, -7.811612640422845e-123, -9.674048358895455e-127, -7.945468358665106e-131, -4.3068892503336734e-135, -1.5292040173312705e-139, -3.511835213145422e-144, -5.094167649513396e-149, -4.425496593309814e-154, -1.9427505022481337e-159, 0., 4.5804896911088344e-170, 2.4601194942855418e-175, 6.676911896452201e-181, 1.085321089609029e-186, 1.114370071211004e-192, 7.401005354274789e-199, 3.219866010628527e-205, 9.245951390037117e-212, 1.7609570819135805e-218, 2.231900459356228e-225, 1.8869528078807553e-232, 1.0660291747146683e-239, 4.029745038280713e-247, 1.0203199331995018e-254, 1.7318180840004107e-262, 1.971800573652531e-270}, {-1.0813833294128164e-86, -2.2353034200366463e-86, -2.7744192759137017e-86, -2.2726501445121598e-86, -1.2440620564928782e-86, -4.564667906937585e-87, -1.124035969332385e-87, -1.858867875034802e-88, -2.0653046418719017e-89, -1.5420011637245079e-90, -7.737502174395761e-92, -2.6094514816051663e-93, -5.914536065022429e-95, -9.009145065496773e-97, -9.221165728080202e-99, -6.34095892785202e-101, -2.9288476664588076e-103, -9.084332366240088e-106, -1.8914595302766365e-108, -2.6425806320776604e-111, -2.4760741330008967e-114, -1.554985695557241e-117, -6.539873052188484e-121, -1.840140649861234e-124, -3.4593981039062143e-128, -4.3377361265188156e-132, -3.6192101603253995e-136, -2.0026859307770871e-140, -7.313900188445114e-145, -1.7496311218197858e-149, -2.707162485223245e-154, -2.6457915360648766e-159, -1.5486360990702219e-164, -4.5804896911088344e-170, 0., 4.902623693145706e-181, 1.7741353099110108e-186, 3.244306364557235e-192, 3.5532173956538165e-198, 2.458169497270929e-204, 1.100001716812987e-210, 3.224497257047232e-217, 6.238764639924395e-224, 8.006075549077643e-231, 6.837080708147141e-238, 3.894779563789956e-245, 1.4825789033345443e-252, 3.776191765089786e-260, 6.442306750700405e-268, 7.367779466354726e-276}, {-2.989915566159811e-92, -6.184854052965921e-92, -7.683381135652769e-92, -6.29992580746107e-92, -3.452206880478604e-92, -1.2680802668509632e-92, -3.126327513442772e-93, -5.176748733647825e-94, -5.759553729011251e-95, -4.3065781980446395e-96, -2.1644315095988631e-97, -7.3121809263816216e-99, -1.6605048033380987e-100, -2.5345523323418866e-102, -2.600096239961854e-104, -1.79244414586833e-106, -8.302180600826396e-109, -2.583038597138654e-111, -5.396849273152434e-114, -7.56957101865022e-117, -7.124283008721602e-120, -4.4970257912695136e-123, -1.902592240136926e-126, -5.3908081571653285e-130, -1.0218979428637574e-133, -1.294299897263738e-137, -1.0934039074951626e-141, -6.146375520628067e-146, -2.2914485772567695e-150, -5.638220261409074e-155, -9.087378824669912e-160, -9.473460662693492e-165, -6.2381373725262554e-170, -2.4601194942855418e-175, -4.902623693145706e-181, 0., 2.3821606180472763e-192, 5.8082445845433875e-198, 7.156445029870573e-204, 5.2809992889911856e-210, 2.4616506183207694e-216, 7.422146441862672e-223, 1.4659560552159166e-229, 1.9110914003840973e-236, 1.652446899955817e-243, 9.508335429152767e-251, 3.6495855780519753e-258, 9.360654832796379e-266, 1.6064640575461042e-273, 1.8466631855209243e-281}, {-5.56535881603823e-98, -1.1520191103615921e-97, -1.4323443679861844e-97, -1.175514074236887e-97, -6.447826070783532e-98, -2.3709116541203505e-98, -5.8517520252347164e-99, -9.701195054986718e-100, -1.080715263796109e-100, -8.091908025457405e-102, -4.0729152303999124e-103, -1.3781734521482658e-104, -3.1351023681792624e-106, -4.794403725460588e-108, -4.928570730136551e-110, -3.4053606616881175e-112, -1.581236225967076e-114, -4.933330096326181e-117, -1.0339321904715997e-119, -1.4552191152853587e-122, -1.3749853503943843e-125, -8.717998418406063e-129, -3.70730731982449e-132, -1.056681653959852e-135, -2.01708532599658e-139, -2.576058884364491e-143, -2.1981954082100463e-147, -1.2511223925017856e-151, -4.73838393038438e-156, -1.1901919587404767e-160, -1.973095304449918e-165, -2.1426283813393906e-170, -1.5049492507651056e-175, -6.676911896452201e-181, -1.7741353099110108e-186, -2.3821606180472763e-192, 0., 5.254641418045492e-204, 8.632453842134471e-210, 7.16647444559622e-216, 3.56323597810129e-222, 1.1191194842815147e-228, 2.2735386744966462e-235, 3.025643081989292e-242, 2.6576829754450994e-249, 1.5483715670682616e-256, 6.003148004215497e-264, 1.5525509258243758e-271, 2.683101432697501e-279, 3.1026386062452615e-287}, {-6.974353831569742e-104, -1.4446086069297055e-103, -1.797555173867352e-103, -1.4765117520808856e-103, -8.106271866634638e-104, -2.9836475466966276e-104, -7.371743466460189e-105, -1.2234672638898809e-105, -1.3645677778224978e-106, -1.0230316383101843e-107, -5.156317454144852e-109, -1.7473547263211068e-110, -3.9812949494803e-112, -6.099045422345774e-114, -6.281596104847448e-116, -4.349209828574447e-118, -2.024090443485697e-120, -6.330826773208478e-123, -1.3305065369287792e-125, -1.87843354164953e-128, -1.7810285024281455e-131, -1.1336770877808746e-134, -4.842455873688814e-138, -1.3873074247066703e-141, -2.663975559673298e-145, -3.4260066912410463e-149, -2.947832762966076e-153, -1.6947324593097716e-157, -6.498702096107112e-162, -1.658260739443021e-166, -2.8063298296742053e-171, -3.134526596986123e-176, -2.2933784537727738e-181, -1.085321089609029e-186, -3.244306364557235e-192, -5.8082445845433875e-198, -5.254641418045492e-204, 0., 5.261967108771088e-216, 5.824493399473024e-222, 3.257989708449349e-228, 1.0914662319224178e-234, 2.309749916709336e-241, 3.1616570950494815e-248, 2.8350132131180305e-255, 1.67790174295305e-262, 6.586662641340126e-270, 1.7206677911010406e-277, 2.9984194763146462e-285, 3.4915072307421305e-293}, {-5.88452189811621e-110, -1.2196132793883731e-109, -1.5187264894835525e-109, -1.2484968298970136e-109, -6.860367082172036e-110, -2.527392362239032e-110, -6.250570859509011e-111, -1.038470053282982e-111, -1.1595234954664178e-112, -8.703425496046879e-114, -4.3923313891332e-115, -1.490502400129519e-116, -3.4010958917097e-118, -5.218573675791943e-120, -5.384118363935886e-122, -3.7348804111014898e-124, -1.7417847547176723e-126, -5.460229712375786e-129, -1.150415148591274e-131, -1.628688818561384e-134, -1.5490150520959942e-137, -9.894172837564518e-141, -4.2428295024290194e-144, -1.2209478612602557e-147, -2.3565469894768135e-151, -3.048677584389258e-155, -2.6415119928671236e-159, -1.531281435063204e-163, -5.931237359219794e-168, -1.5323801779883356e-172, -2.6344614265097844e-177, -3.00386169878159e-182, -2.2605710346000772e-187, -1.114370071211004e-192, -3.5532173956538165e-198, -7.156445029870573e-204, -8.632453842134471e-210, -5.261967108771088e-216, 0., 2.392155164579704e-228, 1.784101808847391e-234, 6.72407814187013e-241, 1.5178055327918982e-247, 2.16418660240247e-254, 1.9960411124782368e-261, 1.2059679406186226e-268, 4.809213772614201e-276, 1.2720398684090336e-283, 2.239035036698769e-291, 2.628969631486785e-299}, {-3.342974604975202e-116, -6.932581448035686e-116, -8.638939443845525e-116, -7.10725904284235e-116, -3.9085578171960676e-116, -1.4411781918938974e-116, -3.567497500622609e-117, -5.932835330127792e-118, -6.63132060047375e-119, -4.9830300420734765e-120, -2.5177644562003984e-121, -8.554743246167108e-123, -1.9547414654071794e-124, -3.003759734054013e-126, -3.104012049312496e-128, -2.15695030288155e-130, -1.0078123427178932e-132, -3.165879150019948e-135, -6.685346531221455e-138, -9.488434025380435e-141, -9.049337097400483e-144, -5.798065390750448e-147, -2.494965539144032e-150, -7.207852234228458e-154, -1.3973955633649742e-157, -1.8170890599300515e-161, -1.5837795308422529e-165, -9.245355407169492e-170, -3.6109212913064808e-174, -9.423322376593153e-179, -1.64030420865156e-183, -1.8999926155610884e-188, -1.459637393920059e-193, -7.401005354274789e-199, -2.458169497270929e-204, -5.2809992889911856e-210, -7.16647444559622e-216, -5.824493399473024e-222, -2.392155164579704e-228, 0., 4.937074384358136e-241, 2.480970072299957e-247, 6.300244845240989e-254, 9.582188805330675e-261, 9.205942730466085e-268, 5.7209612447575224e-275, 2.328960741695379e-282, 6.257894445820063e-290, 1.1152787608299873e-297, 1.322735218207809e-305}, {-1.2787526713243954e-122, -2.6533018070531997e-122, -3.308598855711379e-122, -2.7239671125555955e-122, -1.4991714859791205e-122, -5.532317591858902e-123, -1.3706574994208996e-123, -2.2815319114331714e-124, -2.5526343028406306e-125, -1.920145930475608e-126, -9.712670298612706e-128, -3.304054769205012e-129, -7.559340089918873e-131, -1.1632040322074192e-132, -1.2038074573120204e-134, -8.378556399739368e-137, -3.921600688592161e-139, -1.2342404611924108e-141, -2.611725932391175e-144, -3.71521655166626e-147, -3.5521676333845374e-150, -2.2822567303393842e-153, -9.851183906996628e-157, -2.855848107046661e-160, -5.558381806642382e-164, -7.2600519546884935e-168, -6.360330754140479e-172, -3.734960461331185e-176, -1.4689495297298738e-180, -3.8654229919956675e-185, -6.796450862587685e-190, -7.970851664353992e-195, -6.220670807200421e-200, -3.219866010628527e-205, -1.100001716812987e-210, -2.4616506183207694e-216, -3.56323597810129e-222, -3.257989708449349e-228, -1.784101808847391e-234, -4.937074384358136e-241, 0., 4.625852932980925e-254, 1.5662693890721187e-260, 2.6799474538858985e-267, 2.7463668445530375e-274, 1.777821079545061e-281, 7.444159500157548e-289, 2.0419099155791126e-296, 3.696844649225113e-304, 4.43931250225e-312}, {-3.2937243652858834e-129, -6.837758337855736e-129, -8.531952484239728e-129, -7.029198073855213e-129, -3.871438987784162e-129, -1.4297609192002656e-129, -3.5451934111350837e-130, -5.906271190130481e-131, -6.614155817250414e-132, -4.980172432124356e-133, -2.521743702738174e-134, -8.588006288608354e-136, -1.967187291976648e-137, -3.030902914997116e-139, -3.141009896637818e-141, -2.189396381427466e-143, -1.0263937441385983e-145, -3.2359741553488465e-148, -6.86048178674159e-151, -9.779336231035802e-154, -9.371402929483729e-157, -6.036187899815877e-160, -2.6127110488579053e-163, -7.597672128825004e-167, -1.4838813388310672e-170, -1.9457646609488735e-174, -1.7122405710135522e-178, -1.0106308503116453e-182, -3.998442362176854e-187, -1.0595158199510601e-191, -1.878437396598229e-196, -2.225276988225391e-201, -1.7583754075176162e-206, -9.245951390037117e-212, -3.224497257047232e-217, -7.422146441862672e-223, -1.1191194842815147e-228, -1.0914662319224178e-234, -6.72407814187013e-241, -2.480970072299957e-247, -4.625852932980925e-254, 0., 1.9676974544675924e-267, 4.48907518286041e-274, 5.1753731702526216e-281, 3.5735502841355154e-288, 1.5586775601214168e-295, 4.3975587244841494e-303, 8.12757738167e-311, 9.9148e-319}, {-5.712808667755637e-136, -1.1865652545175453e-135, -1.481459648227233e-135, -1.221326034620464e-135, -6.7313001657590906e-136, -2.48775318590318e-136, -6.173323464919165e-137, -1.0293122810495383e-137, -1.1536764891890796e-138, -8.69466762433852e-140, -4.4069068687494896e-141, -1.5023718446970714e-142, -3.4451934288557136e-144, -5.314429315901894e-146, -5.5145263358180034e-148, -3.849102313850875e-150, -1.8071407488577386e-152, -5.706613435202945e-155, -1.2119443114924795e-157, -1.730848980416285e-160, -1.6620827428907634e-163, -1.0729925156181485e-166, -4.655994083235568e-170, -1.3577077187700327e-173, -2.6599128045444237e-177, -3.499966547109605e-181, -3.0919904942476774e-185, -1.8331601924031717e-189, -7.289876427789767e-194, -1.9431852046984662e-198, -3.4692047297171623e-203, -4.144015825077074e-208, -3.3076057242165045e-213, -1.7609570819135805e-218, -6.238764639924395e-224, -1.4659560552159166e-229, -2.2735386744966462e-235, -2.309749916709336e-241, -1.5178055327918982e-247, -6.300244845240989e-254, -1.5662693890721187e-260, -1.9676974544675924e-267, 0., 3.7998943903015007e-281, 5.841105551078151e-288, 4.537386808532249e-295, 2.111013026329481e-302, 6.20404650828363e-310, 1.179394e-317, 0.}, {-6.6724804904293325e-143, -1.3865468371060298e-142, -1.732142253479736e-142, -1.4288799087971231e-142, -7.88040518892338e-143, -2.9144574937360776e-143, -7.237470666183129e-144, -1.2076752625663576e-144, -1.3546956276032207e-145, -1.0218485226182702e-146, -5.184016722035908e-148, -1.7690262614096793e-149, -4.0609029340527034e-151, -6.27116823311327e-153, -6.515034821094417e-155, -4.5532582385182286e-157, -2.1406760716575457e-159, -6.769870378106954e-162, -1.440058022982977e-164, -2.0602083442976973e-167, -1.9821036216803693e-170, -1.2822379851111051e-173, -5.576610066577953e-177, -1.6302388603787192e-180, -3.202705868144195e-184, -4.227231543446526e-188, -3.747448285804525e-192, -2.2304767520001487e-196, -8.909471634639026e-201, -2.387082550105033e-205, -4.2870702055421286e-210, -5.156779072042417e-215, -4.1502568932309096e-220, -2.231900459356228e-225, -8.006075549077643e-231, -1.9110914003840973e-236, -3.025643081989292e-242, -3.1616570950494815e-248, -2.16418660240247e-254, -9.582188805330675e-261, -2.6799474538858985e-267, -4.48907518286041e-274, -3.7998943903015007e-281, 0., 3.331452443346768e-295, 3.4505085238881484e-302, 1.806012434547797e-309, 5.661527e-317, 0., 0.}, {-5.248228079296169e-150, -1.0910778787112731e-149, -1.363778261963766e-149, -1.125675696634338e-149, -6.212086359530073e-150, -2.2989645285192058e-150, -5.7129736549099744e-151, -9.539880307355511e-152, -1.070951288030639e-152, -8.084798134254908e-154, -4.105110983158421e-155, -1.4021412743181292e-156, -3.2218433847446513e-158, -4.980608697187021e-160, -5.180044970154887e-162, -3.624564066697165e-164, -1.706234636023926e-166, -5.403364953010869e-169, -1.1510835894182852e-171, -1.6494282965810028e-174, -1.5896565093963305e-177, -1.0303086014125318e-180, -4.4902156214740873e-184, -1.315630921915596e-187, -2.5911167526730994e-191, -3.429498873015764e-195, -3.0496694137873735e-199, -1.821462236765502e-203, -7.304226047978372e-208, -1.965731483300417e-212, -3.5484509876332674e-217, -4.2937243885810594e-222, -3.479822344439796e-227, -1.8869528078807553e-232, -6.837080708147141e-238, -1.652446899955817e-243, -2.6576829754450994e-249, -2.8350132131180305e-255, -1.9960411124782368e-261, -9.205942730466085e-268, -2.7463668445530375e-274, -5.1753731702526216e-281, -5.841105551078151e-288, -3.331452443346768e-295, 0., 1.326009516499113e-309, 9.253862e-317, 5.e-324, 0., 0.}, {-2.779953564233602e-157, -5.781860171804378e-157, -7.230754292668286e-157, -5.971705324337606e-157, -3.2974700516122485e-157, -1.2210885188440883e-157, -3.0364261493437607e-158, -5.073927872248437e-159, -5.700178183991677e-160, -4.306486875023461e-161, -2.1884343408068146e-162, -7.481285726114703e-164, -1.7206315332547423e-165, -2.662503565024435e-167, -2.7720014941206325e-169, -1.9417733142441124e-171, -9.151624897670966e-174, -2.9018707142327767e-176, -6.190372305412405e-179, -8.883544269995085e-182, -8.575343995668214e-185, -5.567628151017182e-188, -2.431038532181122e-191, -7.13767795809482e-195, -1.4089506188675233e-198, -1.869504651458739e-202, -1.6670681368544243e-206, -9.987648423625324e-211, -4.019042832559289e-215, -1.0858564311550032e-219, -1.9688903265237122e-224, -2.3946295538288977e-229, -1.9522645558860055e-234, -1.0660291747146683e-239, -3.894779563789956e-245, -9.508335429152767e-251, -1.5483715670682616e-256, -1.67790174295305e-262, -1.2059679406186226e-268, -5.7209612447575224e-275, -1.777821079545061e-281, -3.5735502841355154e-288, -4.537386808532249e-295, -3.4505085238881484e-302, -1.326009516499113e-309, 0., 0., 0., 0., 0.}, {-9.916827564166947e-165, -2.0633911107816323e-164, -2.5817567905996327e-164, -2.133359541356556e-164, -1.1786712330659671e-164, -4.367343867158672e-165, -1.0866870206707899e-165, -1.8170700585982575e-166, -2.042756855670074e-167, -1.5444317592063038e-168, -7.854424148443687e-170, -2.6872727082194763e-171, -6.1858477606862644e-173, -9.580772593716009e-175, -9.984541283240297e-177, -7.001407249324985e-179, -3.303450780657634e-181, -1.0487317073292754e-183, -2.24004843614856e-186, -3.219015438773523e-189, -3.1119403397425654e-192, -2.0236964111518305e-195, -8.851596750653083e-199, -2.6038051221452405e-202, -5.150454213488925e-206, -6.84955286017492e-210, -6.123167192891185e-214, -3.67866901766265e-218, -1.484884216238206e-222, -4.0257585047236176e-227, -7.328188320008195e-232, -8.952574299473697e-237, -7.336175723258732e-242, -4.029745038280713e-247, -1.4825789033345443e-252, -3.6495855780519753e-258, -6.003148004215497e-264, -6.586662641340126e-270, -4.809213772614201e-276, -2.328960741695379e-282, -7.444159500157548e-289, -1.5586775601214168e-295, -2.111013026329481e-302, -1.806012434547797e-309, -9.253862e-317, 0., 0., 0., 0., 0.}, {-2.3824762490050897e-172, -4.95916336585031e-172, -6.207980786835229e-172, -5.132424093339838e-172, -2.8371740910599064e-172, -1.0518575830281586e-172, -2.6188007953028796e-173, -4.381685224931241e-174, -4.929147403925831e-175, -3.729277619924366e-176, -1.897962782042571e-177, -6.498607635883109e-179, -1.497140205158881e-180, -2.3208102173917453e-182, -2.420840615989265e-184, -1.6992126907882763e-186, -8.025690323872538e-189, -2.5507140482656432e-191, -5.454707840059331e-194, -7.848586434559627e-197, -7.597938906619537e-200, -4.948263513948405e-203, -2.1678264269607054e-206, -6.38801608921457e-210, -1.2659740527962927e-213, -1.6870957302941449e-217, -1.5116092320541705e-221, -9.10418822452879e-226, -3.685087508416518e-230, -1.0021792844699115e-234, -1.8306262208228321e-239, -2.245177990739298e-244, -1.8480217038266188e-249, -1.0203199331995018e-254, -3.776191765089786e-260, -9.360654832796379e-266, -1.5525509258243758e-271, -1.7206677911010406e-277, -1.2720398684090336e-283, -6.257894445820063e-290, -2.0419099155791126e-296, -4.3975587244841494e-303, -6.20404650828363e-310, -5.661527e-317, -5.e-324, 0., 0., 0., 0., 0.}, {-3.8549128851671053e-180, -8.027091704047326e-180, -1.0053085844883759e-179, -8.315439014135139e-180, -4.5991004835779275e-180, -1.7059990502714688e-180, -4.249820369552368e-181, -7.114882238730206e-182, -8.00884457931573e-183, -6.06329084498419e-184, -3.087964082338993e-185, -1.0580890392489706e-186, -2.439493164178362e-188, -3.784699744147871e-190, -3.9512440064459686e-192, -2.775967519418925e-194, -1.312421566700094e-196, -4.175465396947738e-199, -8.939174740547874e-202, -1.2877574993530202e-204, -1.24822460771104e-207, -8.140403106277e-211, -3.571581142679288e-214, -1.0541379387421382e-217, -2.0927188488971238e-221, -2.794136105360207e-225, -2.508681906280884e-229, -1.5143742024898474e-233, -6.145070585652708e-238, -1.675827037637529e-242, -3.0706190370895743e-247, -3.7790478476225933e-252, -3.1227589860668895e-257, -1.7318180840004107e-262, -6.442306750700405e-268, -1.6064640575461042e-273, -2.683101432697501e-279, -2.9984194763146462e-285, -2.239035036698769e-291, -1.1152787608299873e-297, -3.696844649225113e-304, -8.12757738167e-311, -1.179394e-317, 0., 0., 0., 0., 0., 0., 0.}, {-4.200874480207566e-188, -8.750651936297247e-188, -1.0964085191079025e-187, -9.073244710979587e-188, -5.020705482151523e-188, -1.8633524233174482e-188, -4.644315704165537e-189, -7.779741104417099e-190, -8.76245349133924e-191, -6.637977561992726e-192, -3.3828695066432103e-193, -1.1599414894483648e-194, -2.6762755316903535e-196, -4.1552569249966684e-198, -4.3416516194788026e-200, -3.052891376599844e-202, -1.4446721966762401e-204, -4.600713275590781e-207, -9.859839844237904e-210, -1.4219664156127648e-212, -1.3799542912672527e-215, -9.010983059514597e-219, -3.958976576120756e-222, -1.170207232639192e-225, -2.3268674672953886e-229, -3.112167460765016e-233, -2.799514668559109e-237, -1.693435202813666e-241, -6.887286821268343e-246, -1.8829447735583844e-250, -3.4597046769574756e-255, -4.271082586462624e-260, -3.5415991128703177e-265, -1.971800573652531e-270, -7.367779466354726e-276, -1.8466631855209243e-281, -3.1026386062452615e-287, -3.4915072307421305e-293, -2.628969631486785e-299, -1.322735218207809e-305, -4.43931250225e-312, -9.9148e-319, 0., 0., 0., 0., 0., 0., 0., 0.}}, {{0., 0.10099842129133747, 0.39646811068833776, 0.7570476557841935, 0.8537336713687468, 0.6038631064304117, 0.2750991796955734, 0.08186191966525064, 0.016045350054324403, 0.0020827126358267563, 0.0001796870157585074, 0.000010331117291247657, 3.966061072832764e-7, 1.0180972812388115e-8, 1.7495700220877242e-10, 2.014546818638393e-12, 1.555403886564418e-14, 8.05725350138148e-17, 2.8017076100367015e-19, 6.542288378016405e-22, 1.026264260682874e-24, 1.0817844220760828e-27, 7.664529818108133e-31, 3.6508166079108776e-34, 1.1693333281764571e-37, 2.518861273659873e-41, 3.649664072872586e-45, 3.557476108584862e-49, 2.3330442790417812e-53, 1.0295368032005762e-57, 3.0573137553189526e-62, 6.110189089628215e-67, 8.219010065449528e-72, 7.441580745188795e-77, 4.5354415016810805e-82, 1.860835847314171e-87, 5.139891692003491e-93, 9.558255910668721e-99, 1.1967454513469461e-104, 1.0088845976480278e-110, 5.726833092332836e-117, 2.18895281000033e-123, 5.634060437193433e-130, 9.76524642211082e-137, 1.1398139487495783e-143, 8.959533440530102e-151, 4.742947694452686e-158, 1.6909584463639705e-165, 4.060211908942746e-173, 6.566055491433219e-181}, {-0.10099842129133747, 0., 0.6175152392257052, 1.5535106792941178, 1.9583555791687677, 1.4717426930017377, 0.6965664043741188, 0.21279617595851819, 0.04251714894082518, 0.005600138591718963, 0.0004887563700616618, 0.00002836411978503481, 1.0972858877027502e-6, 2.8349868814975043e-8, 4.89866179595761e-10, 5.667317149759422e-12, 4.393708545983905e-14, 2.284259690243992e-16, 7.968407622772863e-19, 1.866026939999498e-21, 2.9346709157139987e-24, 3.1005883097933038e-27, 2.2013976899972377e-30, 1.0505858562376279e-33, 3.3708367268931297e-37, 7.272763834757603e-41, 1.0553324132490904e-44, 1.0300801879974116e-48, 6.7639671640493755e-53, 2.9883483246120025e-57, 8.883937337881846e-62, 1.7773173597522671e-66, 2.3930204317367773e-71, 2.168617594080728e-76, 1.3228325048455335e-81, 5.431746874250437e-87, 1.5014541193650937e-92, 2.7941226542760342e-98, 3.500747794180109e-104, 2.953095925171875e-110, 1.677310891106809e-116, 6.414833890655436e-123, 1.6519938635046887e-129, 2.8648166883223976e-136, 3.345521806814762e-143, 2.6310059343523606e-150, 1.3934205604616318e-157, 4.969992792276969e-165, 1.1938575333564084e-172, 1.9314428449440784e-180}, {-0.39646811068833776, -0.6175152392257052, 0., 1.4696168295433545, 2.467681979897163, 2.0852244183036084, 1.0523771479959214, 0.33481627243330414, 0.06879756580673667, 0.009249348292346329, 0.0008199815704492842, 0.00004817745222869315, 1.8824902917703712e-6, 4.9039509748930485e-8, 8.532579275937093e-10, 9.929830086164724e-12, 7.737543944204708e-14, 4.040542774372956e-16, 1.4149947613741436e-18, 3.325041063196393e-21, 5.245325681602554e-24, 5.5571761997955434e-27, 3.955384465430056e-30, 1.8919137348385897e-33, 6.082749718379969e-37, 1.3148559136758264e-40, 1.91125096071427e-44, 1.8684883640429355e-48, 1.2287388954448946e-52, 5.436027038816676e-57, 1.6181045168078713e-61, 3.2410028175661707e-66, 4.368582073774047e-71, 3.963020053232638e-76, 2.419745540950477e-81, 9.944907204638893e-87, 2.7513552158419656e-92, 5.124274762213351e-98, 6.425113402538176e-104, 5.423913972738063e-110, 3.082816596055389e-116, 1.1797861190813933e-122, 3.0401571048141594e-129, 5.2752271276197235e-136, 6.163860967527675e-143, 4.850027378165895e-150, 2.56996659615386e-157, 9.170945754584535e-165, 2.204016310442696e-172, 3.5672989565058144e-180}, {-0.7570476557841935, -1.5535106792941178, -1.4696168295433545, 0., 1.5473917578025909, 1.7433101303160454, 0.9897625005342563, 0.33588128713317356, 0.07189107692019396, 0.009941298670139575, 0.0008996790754910015, 0.000053698753716207665, 2.124447918385527e-6, 5.590138604475903e-8, 9.807526721292713e-10, 1.1493339710427291e-11, 9.009152766041652e-14, 4.728692801111132e-16, 1.663374137161458e-18, 3.9240200912302395e-21, 6.211713415607789e-24, 6.601384957973302e-27, 4.711658480963246e-30, 2.259295718624364e-33, 7.280432899322113e-37, 1.5770057625850412e-40, 2.296646969855476e-44, 2.2491646511571655e-48, 1.481445218110273e-52, 6.563723143785174e-57, 1.95646064727727e-61, 3.9237201472436457e-66, 5.295117589582624e-71, 4.808880612521047e-76, 2.9392693685240263e-81, 1.2091900656800432e-86, 3.348415288226066e-92, 6.241669266391304e-98, 7.832558785544578e-104, 6.61714650873442e-110, 3.7637681512840486e-116, 1.4413823243434943e-122, 3.716699441830239e-129, 6.453183025475917e-136, 7.544734756151119e-143, 5.939932319235004e-150, 3.149195554601102e-157, 1.124373404523699e-164, 2.703495632928438e-172, 4.377796600332224e-180}, {-0.8537336713687468, -1.9583555791687677, -2.467681979897163, -1.5473917578025909, 0., 0.7316709323718682, 0.5538718294962488, 0.2114539334707232, 0.048276208681675856, 0.006953920278411864, 0.0006473041812620135, 0.00003944024948041991, 1.5851151381581372e-6, 4.223108265644754e-8, 7.484001198141707e-10, 8.8435092734919e-12, 6.980535336677917e-14, 3.6857276800109355e-16, 1.3031472656795885e-18, 3.087942680778987e-21, 4.907374077581623e-24, 5.233330144514157e-27, 3.746789841721344e-30, 1.8016203673770576e-33, 5.820154016042529e-37, 1.2635616724545276e-40, 1.8439774936697483e-44, 1.8092740447442606e-48, 1.1937773128100248e-52, 5.297651558818111e-57, 1.581419758111074e-61, 3.175924744986755e-66, 4.291430416571301e-71, 3.901999044470851e-76, 2.387620826181209e-81, 9.832697627321898e-87, 2.725472111959399e-92, 5.085131097545406e-98, 6.386764536750385e-104, 5.400110601594095e-110, 3.0739018232970585e-116, 1.1780498402608975e-122, 3.039784317298552e-129, 5.281349758046445e-136, 6.178548150054809e-143, 4.867235739343546e-150, 2.5819437531373152e-157, 9.223434126363823e-165, 2.2188714212533308e-172, 3.5948151063441263e-180}, {-0.6038631064304117, -1.4717426930017377, -2.0852244183036084, -1.7433101303160454, -0.7316709323718682, 0., 0.15599793552453212, 0.0794079515882819, 0.020395476587918585, 0.003133712180736563, 0.00030385512021708993, 0.0000190428630074314, 7.812827506361952e-7, 2.114555334546702e-8, 3.794160628026694e-10, 4.528676520791815e-12, 3.6044542276546114e-14, 1.9164631816776966e-16, 6.816291468622815e-19, 1.6234740205727596e-21, 2.5915510897954555e-24, 2.774524258272306e-27, 1.9933110784007233e-30, 9.614385141841231e-34, 3.114565076585838e-37, 6.778700881102112e-41, 9.914973420853729e-45, 9.748516274202549e-49, 6.4443517534737395e-53, 2.8647976018841065e-57, 8.565508326973057e-62, 1.7227374962513246e-66, 2.331026048690331e-71, 2.122200977692057e-76, 1.3001139524822748e-81, 5.360083580976242e-87, 1.4872801248704254e-92, 2.7776499150689095e-98, 3.491847297323309e-104, 2.9549684091586277e-110, 1.6834291785089798e-116, 6.456598119703477e-123, 1.667248022592613e-129, 2.898699745110388e-136, 3.3933633423000072e-143, 2.6748401184914935e-150, 1.4197786966462947e-157, 5.074728320722199e-165, 1.2214824375281449e-172, 1.979958246355256e-180}, {-0.2750991796955734, -0.6965664043741188, -1.0523771479959214, -0.9897625005342563, -0.5538718294962488, -0.15599793552453212, 0., 0.01502786274033405, 0.0051464270005900075, 0.0008895770798422314, 0.00009200676482382957, 6.006399438348699e-6, 2.5346888761342925e-7, 7.003099865102229e-9, 1.2765164102485546e-10, 1.5426841635649436e-12, 1.2402522990588586e-14, 6.649287788891311e-17, 2.3814927144264927e-19, 5.705896246845427e-22, 9.15502979211181e-25, 9.845165313775024e-28, 7.10083386683009e-31, 3.4368544623519308e-34, 1.1168105906125666e-37, 2.4374363619096753e-41, 3.574089841010696e-45, 3.5220729317896794e-49, 2.3331211578080985e-53, 1.0391392481909456e-57, 3.112343940756981e-62, 6.269731991459609e-67, 8.496105957688592e-72, 7.745606906642058e-77, 4.751214765200317e-82, 1.961153170452374e-87, 5.447729618667635e-93, 1.0184798303452285e-98, 1.2816058790744058e-104, 1.0855531063079163e-110, 6.18969048039925e-117, 2.3759238008673905e-123, 6.1399409855279764e-130, 1.0682786992952582e-136, 1.2514472915159755e-143, 9.871102308912808e-151, 5.242760264069612e-158, 1.8750401530756582e-165, 4.5157643531125e-173, 7.323775448011608e-181}, {-0.08186191966525064, -0.21279617595851819, -0.33481627243330414, -0.33588128713317356, -0.2114539334707232, -0.0794079515882819, -0.01502786274033405, 0., 0.0006549240737386191, 0.00015094108195189693, 0.000017562897086699663, 1.222979930600498e-6, 5.375991156929531e-8, 1.5277724093622505e-9, 2.8428214786807732e-11, 3.4901141507721595e-13, 2.8409767722176924e-15, 1.538500273213741e-17, 5.556173887494867e-20, 1.3405311089371315e-22, 2.16366595343899e-25, 2.3387021896009163e-28, 1.6943212626181067e-31, 8.23279565119109e-35, 2.684547375903411e-38, 5.877157407165785e-42, 8.641799839927827e-46, 8.537371467097423e-50, 5.668250547667145e-54, 2.5297856565333628e-58, 7.591355176373487e-63, 1.5319173765529048e-67, 2.0792260772414265e-72, 1.898366970480414e-77, 1.1660724303943276e-82, 4.819330168189032e-88, 1.340316674014778e-93, 2.5085752106754832e-99, 3.15995820974597e-105, 2.6791821774318503e-111, 1.5290408487452055e-117, 5.874332345245089e-124, 1.5193046713127186e-130, 2.645455608287877e-137, 3.1013145937571216e-144, 2.4479344002522562e-151, 1.301007342227182e-158, 4.6558806569459753e-166, 1.121969290417347e-173, 1.8206689574830656e-181}, {-0.016045350054324403, -0.04251714894082518, -0.06879756580673667, -0.07189107692019396, -0.048276208681675856, -0.020395476587918585, -0.0051464270005900075, -0.0006549240737386191, 0., 0.00001292278336423078, 2.004857448210328e-6, 1.5705768598901555e-7, 7.364226431929016e-9, 2.1799976100755814e-10, 4.172356407654244e-12, 5.2290920322581786e-14, 4.324080409329434e-16, 2.370929760196856e-18, 8.648917306505429e-21, 2.104102715394329e-23, 3.419847229901709e-26, 3.7185090238914574e-29, 2.7077660482515225e-32, 1.3215914278363684e-35, 4.326340874992376e-39, 9.504348221397731e-43, 1.401850523130696e-46, 1.388757394715917e-50, 9.243540330832217e-55, 4.134842205965937e-59, 1.2433481625464456e-63, 2.5137989330509632e-68, 3.417838576430586e-73, 3.12554265778997e-78, 1.922709676764511e-83, 7.957396785405711e-89, 2.2158790664681603e-94, 4.152240215356945e-100, 5.236239480511828e-106, 4.444189427603473e-112, 2.538830617705223e-118, 9.762749301046832e-125, 2.5271693556373187e-131, 4.403972746760288e-138, 5.166842228008561e-145, 4.081281059498895e-152, 2.1705877013831955e-159, 7.772935361142322e-167, 1.874285327542163e-174, 3.043295716358536e-182}, {-0.0020827126358267563, -0.005600138591718963, -0.009249348292346329, -0.009941298670139575, -0.006953920278411864, -0.003133712180736563, -0.0008895770798422314, -0.00015094108195189693, -0.00001292278336423078, 0., 1.1551543320223091e-7, 1.2065753370435458e-8, 6.364655556245071e-10, 2.0097059252324104e-11, 4.006698484002445e-13, 5.1649486050415965e-15, 4.3600184079252546e-17, 2.4285814531538053e-19, 8.969965293563968e-22, 2.204249546629021e-24, 3.6124733627893126e-27, 3.955425799797486e-30, 2.8974300738438406e-33, 1.4214137037632105e-36, 4.673890350656011e-40, 1.0308130532271723e-43, 1.5256841440772405e-47, 1.516113786916334e-51, 1.0119252999844043e-55, 4.537912839256682e-60, 1.3676528639593853e-64, 2.7708428220905754e-69, 3.774458459554468e-74, 3.457667056085461e-79, 2.1304280974716913e-84, 8.830130182363704e-90, 2.4622848671467507e-95, 4.6198620994121616e-101, 5.832876115261833e-107, 4.9560836880855476e-113, 2.8342095112718586e-119, 1.0909244718637735e-125, 2.826544830493961e-132, 4.929944202289145e-139, 5.788649478277684e-146, 4.5759765359774155e-153, 2.435465455086686e-160, 8.727514001674154e-168, 2.1058470736104196e-175, 3.421423214637008e-183}, {-0.0001796870157585074, -0.0004887563700616618, -0.0008199815704492842, -0.0008996790754910015, -0.0006473041812620135, -0.00030385512021708993, -0.00009200676482382957, -0.000017562897086699663, -2.004857448210328e-6, -1.1551543320223091e-7, 0., 4.679741745856685e-10, 3.291403184988982e-11, 1.1692064838134624e-12, 2.4864176925198748e-14, 3.338736899960123e-16, 2.898938299145881e-18, 1.648383147414661e-20, 6.184942678216252e-23, 1.5388656595994408e-25, 2.547471928134474e-28, 2.8125620971216875e-31, 2.074666507909332e-34, 1.0238427362416184e-37, 3.383862713494267e-41, 7.496328755743845e-45, 1.113866474935813e-48, 1.110722711155585e-52, 7.436435185687486e-57, 3.3440841240319245e-61, 1.0103783201316363e-65, 2.0516626082893045e-70, 2.800573232465487e-75, 2.5703792411717232e-80, 1.5864834757128772e-85, 6.586143756038663e-91, 1.8392692856133589e-96, 3.455669372052551e-102, 4.368579311154741e-108, 3.716317523112784e-114, 2.12759494967556e-120, 8.197923065306008e-127, 2.1261277464441086e-133, 3.7117136622199286e-140, 4.361999021547078e-147, 3.451014397759911e-154, 1.8381467863782816e-161, 6.591831848889362e-169, 1.5916341834350805e-176, 2.5876697695204904e-184}, {-0.000010331117291247657, -0.00002836411978503481, -0.00004817745222869315, -0.000053698753716207665, -0.00003944024948041991, -0.0000190428630074314, -6.006399438348699e-6, -1.222979930600498e-6, -1.5705768598901555e-7, -1.2065753370435458e-8, -4.679741745856685e-10, 0., 8.594795078855582e-13, 4.070843373256564e-14, 9.739121590350252e-16, 1.3949435114235866e-17, 1.261659502398937e-19, 7.37897116502843e-22, 2.8263644967078204e-24, 7.143854867311758e-27, 1.1973920036401413e-29, 1.3353461903180788e-32, 9.932170637306124e-36, 4.935777618552524e-39, 1.6410147653367022e-42, 3.654010897660858e-46, 5.45366988592161e-50, 5.459604089959535e-54, 3.667968948469447e-58, 1.6545524357917788e-62, 5.0129348604825056e-67, 1.0204719731762047e-71, 1.396136832154593e-76, 1.2840338918922978e-81, 7.940294024505601e-87, 3.302074565228116e-92, 9.236265668823132e-98, 1.7379056884189338e-103, 2.20003907599837e-109, 1.8739469133198962e-115, 1.074113391138348e-121, 4.1433138935141546e-128, 1.0756859787802253e-134, 1.8797276987059288e-141, 2.2110828893075528e-148, 1.7508223461631937e-155, 9.333191352417167e-163, 3.3495875541719456e-170, 8.093676137758474e-178, 1.3167771416964272e-185}, {-3.966061072832764e-7, -1.0972858877027502e-6, -1.8824902917703712e-6, -2.124447918385527e-6, -1.5851151381581372e-6, -7.812827506361952e-7, -2.5346888761342925e-7, -5.375991156929531e-8, -7.364226431929016e-9, -6.364655556245071e-10, -3.291403184988982e-11, -8.594795078855582e-13, 0., 7.157866593915552e-16, 2.2832724227324778e-17, 3.6791465472781975e-19, 3.549452367318404e-21, 2.1624385234523034e-23, 8.519430843721409e-26, 2.198213539097906e-28, 3.742941449422987e-31, 4.22635120516045e-34, 3.1752702144715455e-37, 1.5910954209646344e-40, 5.326961830113714e-44, 1.1932030568896528e-47, 1.7900073957151397e-51, 1.799954924033215e-55, 1.2140202032827054e-59, 5.495233539163397e-64, 1.6700911239822955e-68, 3.409211064257985e-73, 4.675928782468682e-78, 4.310248440338513e-83, 2.67091847180038e-88, 1.1128398594580833e-93, 3.118148912385689e-99, 5.876545023452338e-105, 7.450221432449359e-111, 6.354658535853739e-117, 3.6470302614801456e-123, 1.4084900453116953e-129, 3.6607854031825354e-136, 6.403771971539031e-143, 7.539981228299623e-150, 5.975941071309703e-157, 3.1883812398172823e-164, 1.1452125013945897e-171, 2.769336958056638e-179, 4.5087858531737e-187}, {-1.0180972812388115e-8, -2.8349868814975043e-8, -4.9039509748930485e-8, -5.590138604475903e-8, -4.223108265644754e-8, -2.114555334546702e-8, -7.003099865102229e-9, -1.5277724093622505e-9, -2.1799976100755814e-10, -2.0097059252324104e-11, -1.1692064838134624e-12, -4.070843373256564e-14, -7.157866593915552e-16, 0., 2.703625952143584e-19, 5.808643178347683e-21, 6.304366995788761e-23, 4.0968741907189946e-25, 1.6813115901294004e-27, 4.46212733730359e-30, 7.756038523353747e-33, 8.896761167004224e-36, 6.7677151305284e-39, 3.4254876940724546e-42, 1.1564048247333815e-45, 2.6083815643109236e-49, 3.9363074568027297e-53, 3.9784808946996246e-57, 2.695355547051098e-61, 1.2248307647570662e-65, 3.73538572800176e-70, 7.648771101379035e-75, 1.0519869785798008e-79, 9.721468544102584e-85, 6.03776376218211e-90, 2.5208464255237827e-95, 7.076724962804466e-101, 1.3360175769756755e-106, 1.6965033146694214e-112, 1.4491744673478901e-118, 8.328445932487778e-125, 3.2205695786925097e-131, 8.380499128042894e-138, 1.467622261872523e-144, 1.7298197492253922e-151, 1.3723383998587421e-158, 7.32865266027448e-166, 2.6346068937736464e-173, 6.376174823130017e-181, 1.038913181259185e-188}, {-1.7495700220877242e-10, -4.89866179595761e-10, -8.532579275937093e-10, -9.807526721292713e-10, -7.484001198141707e-10, -3.794160628026694e-10, -1.2765164102485546e-10, -2.8428214786807732e-11, -4.172356407654244e-12, -4.006698484002445e-13, -2.4864176925198748e-14, -9.739121590350252e-16, -2.2832724227324778e-17, -2.703625952143584e-19, 0., 4.6322163903865525e-23, 6.703388090759334e-25, 4.900698973817456e-27, 2.1452718277963717e-29, 5.930684887220432e-32, 1.060320855443422e-34, 1.2416069098951008e-37, 9.594750440541755e-41, 4.917100182923331e-44, 1.6767230921170514e-47, 3.8135258699726695e-51, 5.79523487830238e-55, 5.892189817446343e-59, 4.012333038534577e-63, 1.8314349527571075e-67, 5.607259457983507e-72, 1.1521584686866321e-76, 1.5895471110991716e-81, 1.4729893821557672e-86, 9.171301128083258e-92, 3.8378424139206746e-97, 1.0796209355492343e-102, 2.0420807054469586e-108, 2.5975868754536082e-114, 2.2224472930540648e-120, 1.2791388521350697e-126, 4.953162256045534e-133, 1.2905476799991594e-139, 2.2627426858056952e-146, 2.669958725660296e-153, 2.1203964425057352e-160, 1.1334550795607786e-167, 4.0784484978891184e-175, 9.879050934188224e-183, 1.6109755004832422e-190}, {-2.014546818638393e-12, -5.667317149759422e-12, -9.929830086164724e-12, -1.1493339710427291e-11, -8.8435092734919e-12, -4.528676520791815e-12, -1.5426841635649436e-12, -3.4901141507721595e-13, -5.2290920322581786e-14, -5.1649486050415965e-15, -3.338736899960123e-16, -1.3949435114235866e-17, -3.6791465472781975e-19, -5.808643178347683e-21, -4.6322163903865525e-23, 0., 3.600497091168846e-27, 3.509658531083724e-29, 1.728389779429963e-31, 5.0967453224466066e-34, 9.491921856134225e-37, 1.1432347788294263e-39, 9.018614694820637e-43, 4.695205778438146e-46, 1.6210706826796005e-49, 3.724192389669459e-53, 5.706641339027911e-57, 5.8426883226386134e-61, 4.0023068952989625e-65, 1.836227010998544e-69, 5.647029092197753e-74, 1.1648804971718816e-78, 1.6126789489651759e-83, 1.499051719917984e-88, 9.359500138578123e-94, 3.926412608526159e-99, 1.1070468693386759e-104, 2.0982916061006087e-110, 2.674143891088193e-116, 2.29192709995413e-122, 1.3212422337083476e-128, 5.123777181545806e-135, 1.3368352352291474e-141, 2.3468930548208854e-148, 2.7725500036560677e-155, 2.2043204228920674e-162, 1.1795439439721494e-169, 4.248436364074481e-177, 1.0300263714982207e-184, 1.681116865055309e-192}, {-1.555403886564418e-14, -4.393708545983905e-14, -7.737543944204708e-14, -9.009152766041652e-14, -6.980535336677917e-14, -3.6044542276546114e-14, -1.2402522990588586e-14, -2.8409767722176924e-15, -4.324080409329434e-16, -4.3600184079252546e-17, -2.898938299145881e-18, -1.261659502398937e-19, -3.549452367318404e-21, -6.304366995788761e-23, -6.703388090759334e-25, -3.600497091168846e-27, 0., 1.2697271250499195e-31, 8.337310182418689e-34, 2.7658570177410414e-36, 5.494392365682961e-39, 6.893340174093515e-42, 5.593305904818511e-45, 2.972611906003024e-48, 1.042617374851833e-51, 2.4252144468008298e-55, 3.7537333757535494e-59, 3.875249666427192e-63, 2.673152957440599e-67, 1.2337217383133589e-71, 3.813575340213574e-76, 7.901839051440741e-81, 1.0982330448726092e-85, 1.0243976233070776e-90, 6.415744910402939e-96, 2.6989514344929916e-101, 7.628729886542256e-107, 1.4492322373612368e-112, 1.850781483602692e-118, 1.5892525720693994e-124, 9.177601778186058e-131, 3.564777474076798e-137, 9.31457398286781e-144, 1.6374745599982986e-150, 1.9369345674098205e-157, 1.5417962905376294e-164, 8.259413609349531e-172, 2.9779428704544847e-179, 7.227030895213646e-187, 1.1806154350435831e-194}, {-8.05725350138148e-17, -2.284259690243992e-16, -4.040542774372956e-16, -4.728692801111132e-16, -3.6857276800109355e-16, -1.9164631816776966e-16, -6.649287788891311e-17, -1.538500273213741e-17, -2.370929760196856e-18, -2.4285814531538053e-19, -1.648383147414661e-20, -7.37897116502843e-22, -2.1624385234523034e-23, -4.0968741907189946e-25, -4.900698973817456e-27, -3.509658531083724e-29, -1.2697271250499195e-31, 0., 2.031741108733807e-36, 8.986919891221033e-39, 2.0084144512959893e-41, 2.6877699980938457e-44, 2.2717457812927627e-47, 1.2418348043933603e-50, 4.446368116252695e-54, 1.0506789426751492e-57, 1.646562936843712e-61, 1.7170360227626056e-65, 1.1942841072652358e-69, 5.550441313068723e-74, 1.7259175761156476e-78, 3.5944906671012945e-83, 5.0180870135645386e-88, 4.699071223745184e-93, 2.9532207320127766e-98, 1.2461960724452902e-103, 3.5322240842301758e-109, 6.726994788543575e-115, 8.610416589144744e-121, 7.409009846735806e-127, 4.286651802759567e-133, 1.6679232481308966e-139, 4.365179042083577e-146, 7.685224338661985e-153, 9.103179090189055e-160, 7.255367814178742e-167, 3.891332688941631e-174, 1.4045859729371328e-181, 3.412275052754849e-189, 5.579777732685328e-197}, {-2.8017076100367015e-19, -7.968407622772863e-19, -1.4149947613741436e-18, -1.663374137161458e-18, -1.3031472656795885e-18, -6.816291468622815e-19, -2.3814927144264927e-19, -5.556173887494867e-20, -8.648917306505429e-21, -8.969965293563968e-22, -6.184942678216252e-23, -2.8263644967078204e-24, -8.519430843721409e-26, -1.6813115901294004e-27, -2.1452718277963717e-29, -1.728389779429963e-31, -8.337310182418689e-34, -2.031741108733807e-36, 0., 1.475252777535024e-41, 4.3958983850299256e-44, 6.6181854345947385e-47, 5.966714850954833e-50, 3.3975679220392967e-53, 1.2512502919180244e-56, 3.0183086448652405e-60, 4.8051990134146466e-64, 5.073497868306149e-68, 3.564515717863323e-72, 1.6704155352145864e-76, 5.230503673092624e-81, 1.0958175287840083e-85, 1.5376607561495726e-90, 1.4463349147792202e-95, 9.125413148804878e-101, 3.8641000316976863e-106, 1.098633196922075e-111, 2.0981197057646134e-117, 2.692281277917093e-123, 2.3218938011841193e-129, 1.3461660048122287e-135, 5.247811447914462e-142, 1.3758112636699286e-148, 2.4261004387965606e-155, 2.8779830835099143e-162, 2.296945724099002e-169, 1.2335136564027553e-176, 4.457697936212525e-184, 1.0841494607048124e-191, 1.7746559974945483e-199}, {-6.542288378016405e-22, -1.866026939999498e-21, -3.325041063196393e-21, -3.9240200912302395e-21, -3.087942680778987e-21, -1.6234740205727596e-21, -5.705896246845427e-22, -1.3405311089371315e-22, -2.104102715394329e-23, -2.204249546629021e-24, -1.5388656595994408e-25, -7.143854867311758e-27, -2.198213539097906e-28, -4.46212733730359e-30, -5.930684887220432e-32, -5.0967453224466066e-34, -2.7658570177410414e-36, -8.986919891221033e-39, -1.475252777535024e-41, 0., 4.861050759172754e-47, 9.757985744390315e-50, 9.897124961341851e-53, 6.0113309927322845e-56, 2.3060857526327298e-59, 5.721756410607806e-63, 9.298907746694591e-67, 9.973956429072183e-71, 7.095051471557747e-75, 3.358492185368694e-79, 1.0603944778494031e-83, 2.237116720518294e-88, 3.1578271479260807e-93, 2.9855074124636346e-98, 1.8920661644141798e-103, 8.043256689546711e-109, 2.2947830899300525e-114, 4.3960403878437656e-120, 5.6566139903366145e-126, 4.8906384722291365e-132, 2.841893114415736e-138, 1.1101599974759215e-144, 2.9160029692276976e-151, 5.151011462504788e-158, 6.120225224138978e-165, 4.8918465321839365e-172, 2.630644738234213e-179, 9.518821364712932e-187, 2.3178130736889863e-194, 3.798273634673711e-202}, {-1.026264260682874e-24, -2.9346709157139987e-24, -5.245325681602554e-24, -6.211713415607789e-24, -4.907374077581623e-24, -2.5915510897954555e-24, -9.15502979211181e-25, -2.16366595343899e-25, -3.419847229901709e-26, -3.6124733627893126e-27, -2.547471928134474e-28, -1.1973920036401413e-29, -3.742941449422987e-31, -7.756038523353747e-33, -1.060320855443422e-34, -9.491921856134225e-37, -5.494392365682961e-39, -2.0084144512959893e-41, -4.3958983850299256e-44, -4.861050759172754e-47, 0., 7.269112525682408e-53, 9.830350499141066e-56, 6.717120094238773e-59, 2.7486323130811574e-62, 7.103940690690757e-66, 1.187507490300974e-69, 1.3002495969929396e-73, 9.396242922032447e-78, 4.5033744517395524e-82, 1.4362365689755578e-86, 3.0552819267832144e-91, 4.342876265887104e-96, 4.130329303713862e-101, 2.631020936986246e-106, 1.123451719714695e-111, 3.217836031462315e-117, 6.18570633580095e-123, 7.984112644487661e-129, 6.922139915530692e-135, 4.032456107191792e-141, 1.578822824948673e-147, 4.155602652497853e-154, 7.35462136026819e-161, 8.753663455158718e-168, 7.007945127889173e-175, 3.7741833435405876e-182, 1.3675402503732787e-189, 3.3341846653788295e-197, 5.470338490842776e-205}, {-1.0817844220760828e-27, -3.1005883097933038e-27, -5.5571761997955434e-27, -6.601384957973302e-27, -5.233330144514157e-27, -2.774524258272306e-27, -9.845165313775024e-28, -2.3387021896009163e-28, -3.7185090238914574e-29, -3.955425799797486e-30, -2.8125620971216875e-31, -1.3353461903180788e-32, -4.22635120516045e-34, -8.896761167004224e-36, -1.2416069098951008e-37, -1.1432347788294263e-39, -6.893340174093515e-42, -2.6877699980938457e-44, -6.6181854345947385e-47, -9.757985744390315e-50, -7.269112525682408e-53, 0., 4.933317135804966e-59, 4.494608633003599e-62, 2.0690831254697354e-65, 5.704129039010611e-69, 9.932421452165622e-73, 1.1186132669830025e-76, 8.252058854984201e-81, 4.017774562999983e-85, 1.2973839396010038e-89, 2.7877808695042473e-94, 3.995663649591961e-99, 3.826683994755481e-104, 2.4521083057297165e-109, 1.0524251492142639e-114, 3.0278559820191703e-120, 5.843329642968701e-126, 7.568382964729986e-132, 6.582021629579432e-138, 3.844972887587764e-144, 1.5091907159702033e-150, 3.98135273476923e-157, 7.060820828108225e-164, 8.419890965468648e-171, 6.752458960166004e-178, 3.642417148649311e-185, 1.3217512478555195e-192, 3.2269735834763966e-200, 5.301200878890416e-208}, {-7.664529818108133e-31, -2.2013976899972377e-30, -3.955384465430056e-30, -4.711658480963246e-30, -3.746789841721344e-30, -1.9933110784007233e-30, -7.10083386683009e-31, -1.6943212626181067e-31, -2.7077660482515225e-32, -2.8974300738438406e-33, -2.074666507909332e-34, -9.932170637306124e-36, -3.1752702144715455e-37, -6.7677151305284e-39, -9.594750440541755e-41, -9.018614694820637e-43, -5.593305904818511e-45, -2.2717457812927627e-47, -5.966714850954833e-50, -9.897124961341851e-53, -9.830350499141066e-56, -4.933317135804966e-59, 0., 1.5195657675811952e-65, 9.327049789257144e-69, 2.8927321361973423e-72, 5.3728255731360894e-76, 6.303131026759388e-80, 4.78270002586359e-84, 2.3771206963793655e-88, 7.797827260770531e-93, 1.6965191189903103e-97, 2.4561441562370808e-102, 2.3718742179950087e-107, 1.5305064263037748e-112, 6.6079104619694394e-118, 1.910863242365579e-123, 3.7041560869786144e-129, 4.816502345792104e-135, 4.2033285414161303e-141, 2.4630305650703624e-147, 9.694498450009751e-154, 2.56388754507298e-160, 4.5573189094168136e-167, 5.4457653930715055e-174, 4.375585384175206e-181, 2.3643868233189576e-188, 8.593577642328342e-196, 2.1011768602325834e-203, 3.4565083428751247e-211}, {-3.6508166079108776e-34, -1.0505858562376279e-33, -1.8919137348385897e-33, -2.259295718624364e-33, -1.8016203673770576e-33, -9.614385141841231e-34, -3.4368544623519308e-34, -8.23279565119109e-35, -1.3215914278363684e-35, -1.4214137037632105e-36, -1.0238427362416184e-37, -4.935777618552524e-39, -1.5910954209646344e-40, -3.4254876940724546e-42, -4.917100182923331e-44, -4.695205778438146e-46, -2.972611906003024e-48, -1.2418348043933603e-50, -3.3975679220392967e-53, -6.0113309927322845e-56, -6.717120094238773e-59, -4.494608633003599e-62, -1.5195657675811952e-65, 0., 2.1244041964681672e-72, 8.784960486968598e-76, 1.8356372249039213e-79, 2.297043254909496e-83, 1.8155773145430033e-87, 9.28169503357462e-92, 3.108168212695882e-96, 6.869562625229724e-101, 1.006976217235516e-105, 9.822495090875728e-111, 6.391009274188039e-116, 2.778592726609841e-121, 8.082910578041841e-127, 1.5748852178974087e-132, 2.0569602715141737e-138, 1.802134700663392e-144, 1.0596661678041102e-150, 4.183763251070477e-157, 1.1095462989774277e-163, 1.977165267038166e-170, 2.367981978359667e-177, 1.9065748461675466e-184, 1.0321860276432983e-191, 3.7580978992911997e-199, 9.203481025325092e-207, 1.5162473138029365e-214}, {-1.1693333281764571e-37, -3.3708367268931297e-37, -6.082749718379969e-37, -7.280432899322113e-37, -5.820154016042529e-37, -3.114565076585838e-37, -1.1168105906125666e-37, -2.684547375903411e-38, -4.326340874992376e-39, -4.673890350656011e-40, -3.383862713494267e-41, -1.6410147653367022e-42, -5.326961830113714e-44, -1.1564048247333815e-45, -1.6767230921170514e-47, -1.6210706826796005e-49, -1.042617374851833e-51, -4.446368116252695e-54, -1.2512502919180244e-56, -2.3060857526327298e-59, -2.7486323130811574e-62, -2.0690831254697354e-65, -9.327049789257144e-69, -2.1244041964681672e-72, 0., 1.3480456984273734e-79, 3.755695685561008e-83, 5.2871938641198135e-87, 4.457583967805075e-91, 2.3737820795523604e-95, 8.176219142434861e-100, 1.8447262945942147e-104, 2.747017898907499e-109, 2.7130583107911736e-114, 1.7830830053162448e-119, 7.816838364799027e-125, 2.2898153693810585e-130, 4.488063794039987e-136, 5.8919286431994985e-142, 5.1850544778053696e-148, 3.0607998270709203e-154, 1.2126579416615609e-160, 3.2259611387705357e-167, 5.764496449133134e-174, 6.921239726887998e-181, 5.5852841292372065e-188, 3.030034816723218e-195, 1.1052982484785351e-202, 2.7115533425893526e-210, 4.474365970193487e-218}, {-2.518861273659873e-41, -7.272763834757603e-41, -1.3148559136758264e-40, -1.5770057625850412e-40, -1.2635616724545276e-40, -6.778700881102112e-41, -2.4374363619096753e-41, -5.877157407165785e-42, -9.504348221397731e-43, -1.0308130532271723e-43, -7.496328755743845e-45, -3.654010897660858e-46, -1.1932030568896528e-47, -2.6083815643109236e-49, -3.8135258699726695e-51, -3.724192389669459e-53, -2.4252144468008298e-55, -1.0506789426751492e-57, -3.0183086448652405e-60, -5.721756410607806e-63, -7.103940690690757e-66, -5.704129039010611e-69, -2.8927321361973423e-72, -8.784960486968598e-76, -1.3480456984273734e-79, 0., 3.8826931162139466e-87, 7.287971102745742e-91, 6.912473228308344e-95, 3.926480997959018e-99, 1.4087824839410767e-103, 3.269322886770083e-108, 4.969837724770294e-113, 4.986309960069758e-118, 3.3180791102412115e-123, 1.4693021455989e-128, 4.339948453449469e-134, 8.565832570305669e-140, 1.1312157970687456e-145, 1.0006052253841145e-151, 5.933061781519465e-158, 2.3598371986818486e-164, 6.299530947744751e-171, 1.129153399323777e-177, 1.3595029783292113e-184, 1.0998377908321862e-191, 5.980216389498697e-199, 2.185984070033193e-206, 5.3728833642786865e-214, 8.881276732795387e-222}, {-3.649664072872586e-45, -1.0553324132490904e-44, -1.91125096071427e-44, -2.296646969855476e-44, -1.8439774936697483e-44, -9.914973420853729e-45, -3.574089841010696e-45, -8.641799839927827e-46, -1.401850523130696e-46, -1.5256841440772405e-47, -1.113866474935813e-48, -5.45366988592161e-50, -1.7900073957151397e-51, -3.9363074568027297e-53, -5.79523487830238e-55, -5.706641339027911e-57, -3.7537333757535494e-59, -1.646562936843712e-61, -4.8051990134146466e-64, -9.298907746694591e-67, -1.187507490300974e-69, -9.932421452165622e-73, -5.3728255731360894e-76, -1.8356372249039213e-79, -3.755695685561008e-83, -3.8826931162139466e-87, 0., 5.0761264360338257e-95, 6.419452473656204e-99, 4.102235117291106e-103, 1.5699640755513973e-107, 3.795179778546709e-112, 5.9340500281151665e-117, 6.077753881983365e-122, 4.108563452088311e-127, 1.842083900384093e-132, 5.496011981436374e-138, 1.0937971944488383e-143, 1.4545851170769782e-149, 1.294296771350885e-155, 7.713854306625863e-162, 3.0818330180874817e-168, 8.259144410173554e-175, 1.4855427263068038e-181, 1.7941338996996987e-188, 1.4554859854272725e-195, 7.933839023750179e-203, 2.9066945166391323e-210, 7.159093630122452e-218, 1.1856261827315118e-225}, {-3.557476108584862e-49, -1.0300801879974116e-48, -1.8684883640429355e-48, -2.2491646511571655e-48, -1.8092740447442606e-48, -9.748516274202549e-49, -3.5220729317896794e-49, -8.537371467097423e-50, -1.388757394715917e-50, -1.516113786916334e-51, -1.110722711155585e-52, -5.459604089959535e-54, -1.799954924033215e-55, -3.9784808946996246e-57, -5.892189817446343e-59, -5.8426883226386134e-61, -3.875249666427192e-63, -1.7170360227626056e-65, -5.073497868306149e-68, -9.973956429072183e-71, -1.3002495969929396e-73, -1.1186132669830025e-76, -6.303131026759388e-80, -2.297043254909496e-83, -5.2871938641198135e-87, -7.287971102745742e-91, -5.0761264360338257e-95, 0., 3.0123926050249116e-103, 2.5666867555269825e-107, 1.1050821368536896e-111, 2.849482019608506e-116, 4.641021046550637e-121, 4.889223610192894e-126, 3.373973227388092e-131, 1.5367402450943172e-136, 4.642305968041512e-142, 9.332278707785003e-148, 1.251394262165937e-153, 1.1212832693874385e-159, 6.722492543304297e-166, 2.699538098072741e-172, 7.26691226212631e-179, 1.3121992617179299e-185, 1.5902845840479929e-192, 1.2941079726003773e-199, 7.073764062448581e-207, 2.5980868982423432e-214, 6.413546337477266e-222, 1.0643542700403334e-229}, {-2.3330442790417812e-53, -6.7639671640493755e-53, -1.2287388954448946e-52, -1.481445218110273e-52, -1.1937773128100248e-52, -6.4443517534737395e-53, -2.3331211578080985e-53, -5.668250547667145e-54, -9.243540330832217e-55, -1.0119252999844043e-55, -7.436435185687486e-57, -3.667968948469447e-58, -1.2140202032827054e-59, -2.695355547051098e-61, -4.012333038534577e-63, -4.0023068952989625e-65, -2.673152957440599e-67, -1.1942841072652358e-69, -3.564515717863323e-72, -7.095051471557747e-75, -9.396242922032447e-78, -8.252058854984201e-81, -4.78270002586359e-84, -1.8155773145430033e-87, -4.457583967805075e-91, -6.912473228308344e-95, -6.419452473656204e-99, -3.0123926050249116e-103, 0., 8.114811485439579e-112, 4.658422353089597e-116, 1.3513341297188294e-120, 2.34768100542809e-125, 2.5762868427841917e-130, 1.8286492145598684e-135, 8.50244985575554e-141, 2.609256654047129e-146, 5.310871227442602e-152, 7.1934467900515235e-158, 6.49923652648651e-164, 3.923772184897192e-170, 1.5850404100809665e-176, 4.28866629431699e-183, 7.778692913084753e-190, 9.464146875659745e-197, 7.728273627743527e-204, 4.237454380854484e-211, 1.5606763146142824e-218, 3.8622866152017674e-226, 6.424190073997815e-234}, {-1.0295368032005762e-57, -2.9883483246120025e-57, -5.436027038816676e-57, -6.563723143785174e-57, -5.297651558818111e-57, -2.8647976018841065e-57, -1.0391392481909456e-57, -2.5297856565333628e-58, -4.134842205965937e-59, -4.537912839256682e-60, -3.3440841240319245e-61, -1.6545524357917788e-62, -5.495233539163397e-64, -1.2248307647570662e-65, -1.8314349527571075e-67, -1.836227010998544e-69, -1.2337217383133589e-71, -5.550441313068723e-74, -1.6704155352145864e-76, -3.358492185368694e-79, -4.5033744517395524e-82, -4.017774562999983e-85, -2.3771206963793655e-88, -9.28169503357462e-92, -2.3737820795523604e-95, -3.926480997959018e-99, -4.102235117291106e-103, -2.5666867555269825e-107, -8.114811485439579e-112, 0., 9.92293545617291e-121, 3.837980710366511e-125, 7.501215644314293e-130, 8.780424313593647e-135, 6.492029115115982e-140, 3.104763976538212e-145, 9.72649020578242e-151, 2.0111504009652342e-156, 2.758105320440889e-162, 2.5171028331650624e-168, 1.5323096069424384e-174, 6.233178065951685e-181, 1.6965586288901766e-187, 3.092962856040205e-194, 3.7799325397937696e-201, 3.098737962770995e-208, 1.7049543416077314e-215, 6.298875794002765e-223, 1.5631455027664394e-230, 2.6065159334545668e-238}, {-3.0573137553189526e-62, -8.883937337881846e-62, -1.6181045168078713e-61, -1.95646064727727e-61, -1.581419758111074e-61, -8.565508326973057e-62, -3.112343940756981e-62, -7.591355176373487e-63, -1.2433481625464456e-63, -1.3676528639593853e-64, -1.0103783201316363e-65, -5.0129348604825056e-67, -1.6700911239822955e-68, -3.73538572800176e-70, -5.607259457983507e-72, -5.647029092197753e-74, -3.813575340213574e-76, -1.7259175761156476e-78, -5.230503673092624e-81, -1.0603944778494031e-83, -1.4362365689755578e-86, -1.2973839396010038e-89, -7.797827260770531e-93, -3.108168212695882e-96, -8.176219142434861e-100, -1.4087824839410767e-103, -1.5699640755513973e-107, -1.1050821368536896e-111, -4.658422353089597e-116, -9.92293545617291e-121, 0., 5.508117829963843e-130, 1.435392992822194e-134, 1.890197555672499e-139, 1.4907364687906378e-144, 7.42639038058395e-150, 2.392983997208976e-155, 5.051065881247204e-161, 7.037019487949701e-167, 6.502403236152005e-173, 3.9983818688952444e-179, 1.640028529613701e-185, 4.495077628774107e-192, 8.243667208860854e-199, 1.0126310872161538e-205, 8.338473622839747e-213, 4.6058972419499516e-220, 1.7075360881869632e-227, 4.250585337464613e-235, 7.107459923364841e-243}, {-6.110189089628215e-67, -1.7773173597522671e-66, -3.2410028175661707e-66, -3.9237201472436457e-66, -3.175924744986755e-66, -1.7227374962513246e-66, -6.269731991459609e-67, -1.5319173765529048e-67, -2.5137989330509632e-68, -2.7708428220905754e-69, -2.0516626082893045e-70, -1.0204719731762047e-71, -3.409211064257985e-73, -7.648771101379035e-75, -1.1521584686866321e-76, -1.1648804971718816e-78, -7.901839051440741e-81, -3.5944906671012945e-83, -1.0958175287840083e-85, -2.237116720518294e-88, -3.0552819267832144e-91, -2.7877808695042473e-94, -1.6965191189903103e-97, -6.869562625229724e-101, -1.8447262945942147e-104, -3.269322886770083e-108, -3.795179778546709e-112, -2.849482019608506e-116, -1.3513341297188294e-120, -3.837980710366511e-125, -5.508117829963843e-130, 0., 1.387948818819476e-139, 2.4369609139333322e-144, 2.162194532830686e-149, 1.1489480367667505e-154, 3.8564808023409495e-160, 8.372764363344943e-166, 1.1907742434659328e-171, 1.117773993910972e-177, 6.959201386499762e-184, 2.8833100341164607e-190, 7.968585941519083e-197, 1.4716040369318204e-203, 1.818440929675404e-210, 1.505067443116695e-217, 8.350608947169624e-225, 3.1079468120800058e-232, 7.763504007826585e-240, 1.3021647934224147e-247}, {-8.219010065449528e-72, -2.3930204317367773e-71, -4.368582073774047e-71, -5.295117589582624e-71, -4.291430416571301e-71, -2.331026048690331e-71, -8.496105957688592e-72, -2.0792260772414265e-72, -3.417838576430586e-73, -3.774458459554468e-74, -2.800573232465487e-75, -1.396136832154593e-76, -4.675928782468682e-78, -1.0519869785798008e-79, -1.5895471110991716e-81, -1.6126789489651759e-83, -1.0982330448726092e-85, -5.0180870135645386e-88, -1.5376607561495726e-90, -3.1578271479260807e-93, -4.342876265887104e-96, -3.995663649591961e-99, -2.4561441562370808e-102, -1.006976217235516e-105, -2.747017898907499e-109, -4.969837724770294e-113, -5.9340500281151665e-117, -4.641021046550637e-121, -2.34768100542809e-125, -7.501215644314293e-130, -1.435392992822194e-134, -1.387948818819476e-139, 0., 1.5876551335796483e-149, 1.87819685861973e-154, 1.1227918583097713e-159, 4.0199325370422217e-165, 9.091284044069127e-171, 1.3299038602411585e-176, 1.2743820865444038e-182, 8.060175273568965e-189, 3.3812046439270442e-195, 9.43900420850872e-202, 1.7576808198005028e-208, 2.18713049376345e-215, 1.8209955396384932e-222, 1.0155294611832945e-229, 3.796491730908958e-237, 9.520646645626188e-245, 1.6024333296442722e-252}, {-7.441580745188795e-77, -2.168617594080728e-76, -3.963020053232638e-76, -4.808880612521047e-76, -3.901999044470851e-76, -2.122200977692057e-76, -7.745606906642058e-77, -1.898366970480414e-77, -3.12554265778997e-78, -3.457667056085461e-79, -2.5703792411717232e-80, -1.2840338918922978e-81, -4.310248440338513e-83, -9.721468544102584e-85, -1.4729893821557672e-86, -1.499051719917984e-88, -1.0243976233070776e-90, -4.699071223745184e-93, -1.4463349147792202e-95, -2.9855074124636346e-98, -4.130329303713862e-101, -3.826683994755481e-104, -2.3718742179950087e-107, -9.822495090875728e-111, -2.7130583107911736e-114, -4.986309960069758e-118, -6.077753881983365e-122, -4.889223610192894e-126, -2.5762868427841917e-130, -8.780424313593647e-135, -1.890197555672499e-139, -2.4369609139333322e-144, -1.5876551335796483e-149, 0., 8.244346389194866e-160, 6.57132750161678e-165, 2.646824491091409e-170, 6.38499159982176e-176, 9.729356499414898e-182, 9.589544633519013e-188, 6.191525348577164e-194, 2.6385422374639356e-200, 7.457852771522773e-207, 1.4027893008683193e-213, 1.7600753116678644e-220, 1.4756789834946523e-227, 8.278524913330493e-235, 3.1107445668473684e-242, 7.835790924495181e-250, 1.3240248830258756e-257}, {-4.5354415016810805e-82, -1.3228325048455335e-81, -2.419745540950477e-81, -2.9392693685240263e-81, -2.387620826181209e-81, -1.3001139524822748e-81, -4.751214765200317e-82, -1.1660724303943276e-82, -1.922709676764511e-83, -2.1304280974716913e-84, -1.5864834757128772e-85, -7.940294024505601e-87, -2.67091847180038e-88, -6.03776376218211e-90, -9.171301128083258e-92, -9.359500138578123e-94, -6.415744910402939e-96, -2.9532207320127766e-98, -9.125413148804878e-101, -1.8920661644141798e-103, -2.631020936986246e-106, -2.4521083057297165e-109, -1.5305064263037748e-112, -6.391009274188039e-116, -1.7830830053162448e-119, -3.3180791102412115e-123, -4.108563452088311e-127, -3.373973227388092e-131, -1.8286492145598684e-135, -6.492029115115982e-140, -1.4907364687906378e-144, -2.162194532830686e-149, -1.87819685861973e-154, -8.244346389194866e-160, 0., 1.943470973238109e-170, 1.0437315886683513e-175, 2.8325431586470954e-181, 4.603933543776943e-187, 4.726848478543114e-193, 3.1391047482916285e-199, 1.365611124327074e-205, 3.921175001704994e-212, 7.467752165516686e-219, 9.464409182018838e-226, 8.001257981453358e-233, 4.520076613624974e-240, 1.7085772134734777e-247, 4.325880900933353e-255, 7.342135000612525e-263}, {-1.860835847314171e-87, -5.431746874250437e-87, -9.944907204638893e-87, -1.2091900656800432e-86, -9.832697627321898e-87, -5.360083580976242e-87, -1.961153170452374e-87, -4.819330168189032e-88, -7.957396785405711e-89, -8.830130182363704e-90, -6.586143756038663e-91, -3.302074565228116e-92, -1.1128398594580833e-93, -2.5208464255237827e-95, -3.8378424139206746e-97, -3.926412608526159e-99, -2.6989514344929916e-101, -1.2461960724452902e-103, -3.8641000316976863e-106, -8.043256689546711e-109, -1.123451719714695e-111, -1.0524251492142639e-114, -6.6079104619694394e-118, -2.778592726609841e-121, -7.816838364799027e-125, -1.4693021455989e-128, -1.842083900384093e-132, -1.5367402450943172e-136, -8.50244985575554e-141, -3.104763976538212e-145, -7.42639038058395e-150, -1.1489480367667505e-154, -1.1227918583097713e-159, -6.57132750161678e-165, -1.943470973238109e-170, 0., 2.0798198453644558e-181, 7.525791162102422e-187, 1.3761228157283912e-192, 1.5070530973194225e-198, 1.042536929202983e-204, 4.664951599645258e-211, 1.3673861105585218e-217, 2.64547864352682e-224, 3.3947117495742245e-231, 2.8988949263442413e-238, 1.6512929282162055e-245, 6.285493617176946e-253, 1.6008725611287716e-260, 2.7310272163672817e-268}, {-5.139891692003491e-93, -1.5014541193650937e-92, -2.7513552158419656e-92, -3.348415288226066e-92, -2.725472111959399e-92, -1.4872801248704254e-92, -5.447729618667635e-93, -1.340316674014778e-93, -2.2158790664681603e-94, -2.4622848671467507e-95, -1.8392692856133589e-96, -9.236265668823132e-98, -3.118148912385689e-99, -7.076724962804466e-101, -1.0796209355492343e-102, -1.1070468693386759e-104, -7.628729886542256e-107, -3.5322240842301758e-109, -1.098633196922075e-111, -2.2947830899300525e-114, -3.217836031462315e-117, -3.0278559820191703e-120, -1.910863242365579e-123, -8.082910578041841e-127, -2.2898153693810585e-130, -4.339948453449469e-134, -5.496011981436374e-138, -4.642305968041512e-142, -2.609256654047129e-146, -9.72649020578242e-151, -2.392983997208976e-155, -3.8564808023409495e-160, -4.0199325370422217e-165, -2.646824491091409e-170, -1.0437315886683513e-175, -2.0798198453644558e-181, 0., 1.0104223414924443e-192, 2.463466777466824e-198, 3.0350831292298244e-204, 2.2395574523029202e-210, 1.0438706081380933e-216, 3.1472058361019885e-223, 6.215743525992665e-230, 8.102726024712566e-237, 7.005768091388626e-244, 4.030994533765202e-251, 1.5471470807158e-258, 3.968034395456839e-266, 6.809608094473429e-274}, {-9.558255910668721e-99, -2.7941226542760342e-98, -5.124274762213351e-98, -6.241669266391304e-98, -5.085131097545406e-98, -2.7776499150689095e-98, -1.0184798303452285e-98, -2.5085752106754832e-99, -4.152240215356945e-100, -4.6198620994121616e-101, -3.455669372052551e-102, -1.7379056884189338e-103, -5.876545023452338e-105, -1.3360175769756755e-106, -2.0420807054469586e-108, -2.0982916061006087e-110, -1.4492322373612368e-112, -6.726994788543575e-115, -2.0981197057646134e-117, -4.3960403878437656e-120, -6.18570633580095e-123, -5.843329642968701e-126, -3.7041560869786144e-129, -1.5748852178974087e-132, -4.488063794039987e-136, -8.565832570305669e-140, -1.0937971944488383e-143, -9.332278707785003e-148, -5.310871227442602e-152, -2.0111504009652342e-156, -5.051065881247204e-161, -8.372764363344943e-166, -9.091284044069127e-171, -6.38499159982176e-176, -2.8325431586470954e-181, -7.525791162102422e-187, -1.0104223414924443e-192, 0., 2.2285026925906644e-204, 3.6607981281188605e-210, 3.03892457064144e-216, 1.510890900404407e-222, 4.745045169706162e-229, 9.639238939318618e-236, 1.2827311951183506e-242, 1.1266776613352432e-249, 6.563736949110516e-257, 2.5446928301101763e-264, 6.580870068283087e-272, 1.1372513499701826e-279}, {-1.1967454513469461e-104, -3.500747794180109e-104, -6.425113402538176e-104, -7.832558785544578e-104, -6.386764536750385e-104, -3.491847297323309e-104, -1.2816058790744058e-104, -3.15995820974597e-105, -5.236239480511828e-106, -5.832876115261833e-107, -4.368579311154741e-108, -2.20003907599837e-109, -7.450221432449359e-111, -1.6965033146694214e-112, -2.5975868754536082e-114, -2.674143891088193e-116, -1.850781483602692e-118, -8.610416589144744e-121, -2.692281277917093e-123, -5.6566139903366145e-126, -7.984112644487661e-129, -7.568382964729986e-132, -4.816502345792104e-135, -2.0569602715141737e-138, -5.8919286431994985e-142, -1.1312157970687456e-145, -1.4545851170769782e-149, -1.251394262165937e-153, -7.1934467900515235e-158, -2.758105320440889e-162, -7.037019487949701e-167, -1.1907742434659328e-171, -1.3299038602411585e-176, -9.729356499414898e-182, -4.603933543776943e-187, -1.3761228157283912e-192, -2.463466777466824e-198, -2.2285026925906644e-204, 0., 2.231308186018813e-216, 2.4696899542506136e-222, 1.3813640289362448e-228, 4.6274753251734056e-235, 9.792087225955607e-242, 1.3403019229111702e-248, 1.2017704203643025e-255, 7.112338517016986e-263, 2.7918472254471577e-270, 7.292969625541857e-278, 1.270813073058243e-285}, {-1.0088845976480278e-110, -2.953095925171875e-110, -5.423913972738063e-110, -6.61714650873442e-110, -5.400110601594095e-110, -2.9549684091586277e-110, -1.0855531063079163e-110, -2.6791821774318503e-111, -4.444189427603473e-112, -4.9560836880855476e-113, -3.716317523112784e-114, -1.8739469133198962e-115, -6.354658535853739e-117, -1.4491744673478901e-118, -2.2224472930540648e-120, -2.29192709995413e-122, -1.5892525720693994e-124, -7.409009846735806e-127, -2.3218938011841193e-129, -4.8906384722291365e-132, -6.922139915530692e-135, -6.582021629579432e-138, -4.2033285414161303e-141, -1.802134700663392e-144, -5.1850544778053696e-148, -1.0006052253841145e-151, -1.294296771350885e-155, -1.1212832693874385e-159, -6.49923652648651e-164, -2.5171028331650624e-168, -6.502403236152005e-173, -1.117773993910972e-177, -1.2743820865444038e-182, -9.589544633519013e-188, -4.726848478543114e-193, -1.5070530973194225e-198, -3.0350831292298244e-204, -3.6607981281188605e-210, -2.231308186018813e-216, 0., 1.0142501051955512e-228, 7.563964911199074e-235, 2.8506112643425416e-241, 6.434249275325297e-248, 9.173900310622469e-255, 8.460720387842594e-262, 5.11155565667129e-269, 2.038317103804787e-276, 5.391126669521096e-284, 9.489025430940318e-292}, {-5.726833092332836e-117, -1.677310891106809e-116, -3.082816596055389e-116, -3.7637681512840486e-116, -3.0739018232970585e-116, -1.6834291785089798e-116, -6.18969048039925e-117, -1.5290408487452055e-117, -2.538830617705223e-118, -2.8342095112718586e-119, -2.12759494967556e-120, -1.074113391138348e-121, -3.6470302614801456e-123, -8.328445932487778e-125, -1.2791388521350697e-126, -1.3212422337083476e-128, -9.177601778186058e-131, -4.286651802759567e-133, -1.3461660048122287e-135, -2.841893114415736e-138, -4.032456107191792e-141, -3.844972887587764e-144, -2.4630305650703624e-147, -1.0596661678041102e-150, -3.0607998270709203e-154, -5.933061781519465e-158, -7.713854306625863e-162, -6.722492543304297e-166, -3.923772184897192e-170, -1.5323096069424384e-174, -3.9983818688952444e-179, -6.959201386499762e-184, -8.060175273568965e-189, -6.191525348577164e-194, -3.1391047482916285e-199, -1.042536929202983e-204, -2.2395574523029202e-210, -3.03892457064144e-216, -2.4696899542506136e-222, -1.0142501051955512e-228, 0., 2.093015240178815e-241, 1.0517187551131433e-247, 2.670619566021459e-254, 4.0615975113443827e-261, 3.9019255382908577e-268, 2.424706546905269e-275, 9.870352946061536e-283, 2.6520389272058795e-290, 4.7262533782506995e-298}, {-2.18895281000033e-123, -6.414833890655436e-123, -1.1797861190813933e-122, -1.4413823243434943e-122, -1.1780498402608975e-122, -6.456598119703477e-123, -2.3759238008673905e-123, -5.874332345245089e-124, -9.762749301046832e-125, -1.0909244718637735e-125, -8.197923065306008e-127, -4.1433138935141546e-128, -1.4084900453116953e-129, -3.2205695786925097e-131, -4.953162256045534e-133, -5.123777181545806e-135, -3.564777474076798e-137, -1.6679232481308966e-139, -5.247811447914462e-142, -1.1101599974759215e-144, -1.578822824948673e-147, -1.5091907159702033e-150, -9.694498450009751e-154, -4.183763251070477e-157, -1.2126579416615609e-160, -2.3598371986818486e-164, -3.0818330180874817e-168, -2.699538098072741e-172, -1.5850404100809665e-176, -6.233178065951685e-181, -1.640028529613701e-185, -2.8833100341164607e-190, -3.3812046439270442e-195, -2.6385422374639356e-200, -1.365611124327074e-205, -4.664951599645258e-211, -1.0438706081380933e-216, -1.510890900404407e-222, -1.3813640289362448e-228, -7.563964911199074e-235, -2.093015240178815e-241, 0., 1.960848640629917e-254, 6.638886071285573e-261, 1.1358803748891077e-267, 1.1639743572736703e-274, 7.534464439456492e-282, 3.1547165295275117e-289, 8.652914170302314e-297, 1.5665307592015066e-304}, {-5.634060437193433e-130, -1.6519938635046887e-129, -3.0401571048141594e-129, -3.716699441830239e-129, -3.039784317298552e-129, -1.667248022592613e-129, -6.1399409855279764e-130, -1.5193046713127186e-130, -2.5271693556373187e-131, -2.826544830493961e-132, -2.1261277464441086e-133, -1.0756859787802253e-134, -3.6607854031825354e-136, -8.380499128042894e-138, -1.2905476799991594e-139, -1.3368352352291474e-141, -9.31457398286781e-144, -4.365179042083577e-146, -1.3758112636699286e-148, -2.9160029692276976e-151, -4.155602652497853e-154, -3.98135273476923e-157, -2.56388754507298e-160, -1.1095462989774277e-163, -3.2259611387705357e-167, -6.299530947744751e-171, -8.259144410173554e-175, -7.26691226212631e-179, -4.28866629431699e-183, -1.6965586288901766e-187, -4.495077628774107e-192, -7.968585941519083e-197, -9.43900420850872e-202, -7.457852771522773e-207, -3.921175001704994e-212, -1.3673861105585218e-217, -3.1472058361019885e-223, -4.745045169706162e-229, -4.6274753251734056e-235, -2.8506112643425416e-241, -1.0517187551131433e-247, -1.960848640629917e-254, 0., 8.339930904700349e-268, 1.9025609097392606e-274, 2.193319544183478e-281, 1.5143965334972786e-288, 6.605053317094795e-296, 1.8634289512620774e-303, 3.443849881622e-311}, {-9.76524642211082e-137, -2.8648166883223976e-136, -5.2752271276197235e-136, -6.453183025475917e-136, -5.281349758046445e-136, -2.898699745110388e-136, -1.0682786992952582e-136, -2.645455608287877e-137, -4.403972746760288e-138, -4.929944202289145e-139, -3.7117136622199286e-140, -1.8797276987059288e-141, -6.403771971539031e-143, -1.467622261872523e-144, -2.2627426858056952e-146, -2.3468930548208854e-148, -1.6374745599982986e-150, -7.685224338661985e-153, -2.4261004387965606e-155, -5.151011462504788e-158, -7.35462136026819e-161, -7.060820828108225e-164, -4.5573189094168136e-167, -1.977165267038166e-170, -5.764496449133134e-174, -1.129153399323777e-177, -1.4855427263068038e-181, -1.3121992617179299e-185, -7.778692913084753e-190, -3.092962856040205e-194, -8.243667208860854e-199, -1.4716040369318204e-203, -1.7576808198005028e-208, -1.4027893008683193e-213, -7.467752165516686e-219, -2.64547864352682e-224, -6.215743525992665e-230, -9.639238939318618e-236, -9.792087225955607e-242, -6.434249275325297e-248, -2.670619566021459e-254, -6.638886071285573e-261, -8.339930904700349e-268, 0., 1.610385021786122e-281, 2.4753225499819594e-288, 1.922746453560112e-295, 8.945146618327962e-303, 2.62877091688515e-310, 4.99711e-318}, {-1.1398139487495783e-143, -3.345521806814762e-143, -6.163860967527675e-143, -7.544734756151119e-143, -6.178548150054809e-143, -3.3933633423000072e-143, -1.2514472915159755e-143, -3.1013145937571216e-144, -5.166842228008561e-145, -5.788649478277684e-146, -4.361999021547078e-147, -2.2110828893075528e-148, -7.539981228299623e-150, -1.7298197492253922e-151, -2.669958725660296e-153, -2.7725500036560677e-155, -1.9369345674098205e-157, -9.103179090189055e-160, -2.8779830835099143e-162, -6.120225224138978e-165, -8.753663455158718e-168, -8.419890965468648e-171, -5.4457653930715055e-174, -2.367981978359667e-177, -6.921239726887998e-181, -1.3595029783292113e-184, -1.7941338996996987e-188, -1.5902845840479929e-192, -9.464146875659745e-197, -3.7799325397937696e-201, -1.0126310872161538e-205, -1.818440929675404e-210, -2.18713049376345e-215, -1.7600753116678644e-220, -9.464409182018838e-226, -3.3947117495742245e-231, -8.102726024712566e-237, -1.2827311951183506e-242, -1.3403019229111702e-248, -9.173900310622469e-255, -4.0615975113443827e-261, -1.1358803748891077e-267, -1.9025609097392606e-274, -1.610385021786122e-281, 0., 1.4117179076200607e-295, 1.4620993401842016e-302, 7.65235039821736e-310, 2.398771e-317, 0.}, {-8.959533440530102e-151, -2.6310059343523606e-150, -4.850027378165895e-150, -5.939932319235004e-150, -4.867235739343546e-150, -2.6748401184914935e-150, -9.871102308912808e-151, -2.4479344002522562e-151, -4.081281059498895e-152, -4.5759765359774155e-153, -3.451014397759911e-154, -1.7508223461631937e-155, -5.975941071309703e-157, -1.3723383998587421e-158, -2.1203964425057352e-160, -2.2043204228920674e-162, -1.5417962905376294e-164, -7.255367814178742e-167, -2.296945724099002e-169, -4.8918465321839365e-172, -7.007945127889173e-175, -6.752458960166004e-178, -4.375585384175206e-181, -1.9065748461675466e-184, -5.5852841292372065e-188, -1.0998377908321862e-191, -1.4554859854272725e-195, -1.2941079726003773e-199, -7.728273627743527e-204, -3.098737962770995e-208, -8.338473622839747e-213, -1.505067443116695e-217, -1.8209955396384932e-222, -1.4756789834946523e-227, -8.001257981453358e-233, -2.8988949263442413e-238, -7.005768091388626e-244, -1.1266776613352432e-249, -1.2017704203643025e-255, -8.460720387842594e-262, -3.9019255382908577e-268, -1.1639743572736703e-274, -2.193319544183478e-281, -2.4753225499819594e-288, -1.4117179076200607e-295, 0., 5.61848163344437e-310, 3.9208086e-317, 0., 0.}, {-4.742947694452686e-158, -1.3934205604616318e-157, -2.56996659615386e-157, -3.149195554601102e-157, -2.5819437531373152e-157, -1.4197786966462947e-157, -5.242760264069612e-158, -1.301007342227182e-158, -2.1705877013831955e-159, -2.435465455086686e-160, -1.8381467863782816e-161, -9.333191352417167e-163, -3.1883812398172823e-164, -7.32865266027448e-166, -1.1334550795607786e-167, -1.1795439439721494e-169, -8.259413609349531e-172, -3.891332688941631e-174, -1.2335136564027553e-176, -2.630644738234213e-179, -3.7741833435405876e-182, -3.642417148649311e-185, -2.3643868233189576e-188, -1.0321860276432983e-191, -3.030034816723218e-195, -5.980216389498697e-199, -7.933839023750179e-203, -7.073764062448581e-207, -4.237454380854484e-211, -1.7049543416077314e-215, -4.6058972419499516e-220, -8.350608947169624e-225, -1.0155294611832945e-229, -8.278524913330493e-235, -4.520076613624974e-240, -1.6512929282162055e-245, -4.030994533765202e-251, -6.563736949110516e-257, -7.112338517016986e-263, -5.11155565667129e-269, -2.424706546905269e-275, -7.534464439456492e-282, -1.5143965334972786e-288, -1.922746453560112e-295, -1.4620993401842016e-302, -5.61848163344437e-310, 0., 0., 0., 0.}, {-1.6909584463639705e-165, -4.969992792276969e-165, -9.170945754584535e-165, -1.124373404523699e-164, -9.223434126363823e-165, -5.074728320722199e-165, -1.8750401530756582e-165, -4.6558806569459753e-166, -7.772935361142322e-167, -8.727514001674154e-168, -6.591831848889362e-169, -3.3495875541719456e-170, -1.1452125013945897e-171, -2.6346068937736464e-173, -4.0784484978891184e-175, -4.248436364074481e-177, -2.9779428704544847e-179, -1.4045859729371328e-181, -4.457697936212525e-184, -9.518821364712932e-187, -1.3675402503732787e-189, -1.3217512478555195e-192, -8.593577642328342e-196, -3.7580978992911997e-199, -1.1052982484785351e-202, -2.185984070033193e-206, -2.9066945166391323e-210, -2.5980868982423432e-214, -1.5606763146142824e-218, -6.298875794002765e-223, -1.7075360881869632e-227, -3.1079468120800058e-232, -3.796491730908958e-237, -3.1107445668473684e-242, -1.7085772134734777e-247, -6.285493617176946e-253, -1.5471470807158e-258, -2.5446928301101763e-264, -2.7918472254471577e-270, -2.038317103804787e-276, -9.870352946061536e-283, -3.1547165295275117e-289, -6.605053317094795e-296, -8.945146618327962e-303, -7.65235039821736e-310, -3.9208086e-317, 0., 0., 0., 0.}, {-4.060211908942746e-173, -1.1938575333564084e-172, -2.204016310442696e-172, -2.703495632928438e-172, -2.2188714212533308e-172, -1.2214824375281449e-172, -4.5157643531125e-173, -1.121969290417347e-173, -1.874285327542163e-174, -2.1058470736104196e-175, -1.5916341834350805e-176, -8.093676137758474e-178, -2.769336958056638e-179, -6.376174823130017e-181, -9.879050934188224e-183, -1.0300263714982207e-184, -7.227030895213646e-187, -3.412275052754849e-189, -1.0841494607048124e-191, -2.3178130736889863e-194, -3.3341846653788295e-197, -3.2269735834763966e-200, -2.1011768602325834e-203, -9.203481025325092e-207, -2.7115533425893526e-210, -5.3728833642786865e-214, -7.159093630122452e-218, -6.413546337477266e-222, -3.8622866152017674e-226, -1.5631455027664394e-230, -4.250585337464613e-235, -7.763504007826585e-240, -9.520646645626188e-245, -7.835790924495181e-250, -4.325880900933353e-255, -1.6008725611287716e-260, -3.968034395456839e-266, -6.580870068283087e-272, -7.292969625541857e-278, -5.391126669521096e-284, -2.6520389272058795e-290, -8.652914170302314e-297, -1.8634289512620774e-303, -2.62877091688515e-310, -2.398771e-317, 0., 0., 0., 0., 0.}, {-6.566055491433219e-181, -1.9314428449440784e-180, -3.5672989565058144e-180, -4.377796600332224e-180, -3.5948151063441263e-180, -1.979958246355256e-180, -7.323775448011608e-181, -1.8206689574830656e-181, -3.043295716358536e-182, -3.421423214637008e-183, -2.5876697695204904e-184, -1.3167771416964272e-185, -4.5087858531737e-187, -1.038913181259185e-188, -1.6109755004832422e-190, -1.681116865055309e-192, -1.1806154350435831e-194, -5.579777732685328e-197, -1.7746559974945483e-199, -3.798273634673711e-202, -5.470338490842776e-205, -5.301200878890416e-208, -3.4565083428751247e-211, -1.5162473138029365e-214, -4.474365970193487e-218, -8.881276732795387e-222, -1.1856261827315118e-225, -1.0643542700403334e-229, -6.424190073997815e-234, -2.6065159334545668e-238, -7.107459923364841e-243, -1.3021647934224147e-247, -1.6024333296442722e-252, -1.3240248830258756e-257, -7.342135000612525e-263, -2.7310272163672817e-268, -6.809608094473429e-274, -1.1372513499701826e-279, -1.270813073058243e-285, -9.489025430940318e-292, -4.7262533782506995e-298, -1.5665307592015066e-304, -3.443849881622e-311, -4.99711e-318, 0., 0., 0., 0., 0., 0.}}, {{0., 0.005200736095934221, 0.029623465304879113, 0.0832318280493238, 0.13870307753919267, 0.14522791063398674, 0.09802141064788646, 0.04323593604252438, 0.012565356197362836, 0.0024188275030921076, 0.00030953025197664845, 0.00002639907836552577, 1.5034501591681683e-6, 5.725751582289057e-8, 1.459849508390981e-9, 2.4940410731407606e-11, 2.8571420584623737e-13, 2.1960829937816657e-15, 1.1330953693501928e-17, 3.926112456151439e-20, 9.138775160816775e-23, 1.4294556254094292e-25, 1.5028697004531457e-28, 1.0622720601798807e-31, 5.048909248722457e-35, 1.6139129881030288e-38, 3.4701493235064504e-42, 5.019484651898218e-46, 4.884995713535688e-50, 3.198962287100757e-54, 1.4097271588751138e-58, 4.1809899239074404e-63, 8.345932123285024e-68, 1.1213797752793788e-72, 1.0142394001482238e-77, 6.1753767448679165e-83, 2.5313072080420735e-88, 6.985636156139775e-94, 1.297975112535957e-99, 1.6238433480190901e-105, 1.3679050445865093e-111, 7.759206055225181e-118, 2.9637561939649853e-124, 7.623332275302057e-131, 1.3204951852555415e-137, 1.540387436043182e-144, 1.2101385607688202e-151, 6.402687930834289e-159, 2.281503556153033e-166, 5.47545782320428e-174}, {-0.005200736095934221, 0., 0.06562742643232783, 0.24439739775976418, 0.45678608647731345, 0.5092105316206499, 0.35756545148801255, 0.162078755275349, 0.04805288672125788, 0.009392086514044018, 0.001216392191208907, 0.00010475513748495903, 6.013892923804373e-6, 2.305794585644175e-7, 5.912669373730322e-9, 1.0151320030886847e-10, 1.1679303458189654e-12, 9.011007601704131e-15, 4.66490527407677e-17, 1.6211889090924748e-19, 3.783732360689204e-22, 5.932682733157538e-25, 6.251038420907328e-28, 4.427233167402575e-31, 2.1080757712728692e-34, 6.749879972144972e-38, 1.4535643719403759e-41, 2.1055461949211932e-45, 2.0518436407930887e-49, 1.345312805475596e-53, 5.9353599095142546e-58, 1.7622043713885196e-62, 3.521174940116131e-67, 4.735591634823848e-72, 4.2869295888688944e-77, 2.6123500999281205e-82, 1.0716535651961923e-87, 2.959636818609009e-93, 5.503063110250994e-99, 6.889251465656533e-105, 5.807095314117788e-111, 3.295958927189253e-117, 1.2596673494777431e-123, 3.2418686899760583e-130, 5.618412917307732e-137, 6.557267277293798e-144, 5.153883543582953e-151, 2.7280952448591513e-158, 9.725405276841637e-166, 2.3350089398734924e-173}, {-0.029623465304879113, -0.06562742643232783, 0., 0.3417991469310731, 0.8515834462036488, 1.0678577787541266, 0.7997780994008006, 0.3776140791356417, 0.11514928312094445, 0.022974579515954874, 0.0030226640504822056, 0.00026356011575944075, 0.000015283371852348964, 5.908585105555605e-7, 1.5256992159197238e-8, 2.6350073750922534e-10, 3.047156356468027e-12, 2.3614733313117737e-14, 1.2272979318104394e-16, 4.2800033211538732e-19, 1.0020088290147166e-21, 1.5754525071896581e-24, 1.6641480644444106e-27, 1.1812906003559086e-30, 5.636474703046654e-34, 1.808164797009043e-37, 3.9005856906836443e-41, 5.659196724865996e-45, 5.523016106373145e-49, 3.6261907264068973e-53, 1.601872531233867e-57, 4.761602729801998e-62, 9.525036093767135e-67, 1.282344740383377e-71, 1.1619852883818743e-76, 7.087353322284712e-82, 2.909929319799615e-87, 8.043047281672449e-93, 1.4966541557258625e-98, 1.875019999302604e-104, 1.5815876322620357e-110, 8.982584697224363e-117, 3.435156588435671e-123, 8.845943344402287e-130, 1.5339397736815695e-136, 1.7912332952320635e-143, 1.4086008137618978e-150, 7.459798190841211e-158, 2.6606041232519614e-165, 6.390832981381884e-173}, {-0.0832318280493238, -0.24439739775976418, -0.3417991469310731, 0., 0.7922858836031076, 1.3246586330551409, 1.1161205607187612, 0.5621052053210548, 0.1785495805148259, 0.036642001989834486, 0.004921256744450409, 0.0004359182032737912, 0.000025594068363320148, 9.994665912197336e-7, 2.6023020041528802e-8, 4.5258165529081285e-10, 5.264864203815144e-12, 4.1010668947077846e-14, 2.140909130970136e-16, 7.495352395975131e-19, 1.7608598617341784e-21, 2.7771606055372253e-24, 2.941658799713593e-27, 2.0933610261008887e-30, 1.0011077462464305e-33, 3.218173573985482e-37, 6.955414146463928e-41, 1.0108869047362199e-44, 9.881422956491124e-49, 6.497356840392295e-53, 2.8741548015876806e-57, 8.554401657811291e-62, 1.7132462832702148e-66, 2.3090894724815564e-71, 2.0945403552355497e-76, 1.2787819345545229e-81, 5.255255276386611e-87, 1.4538106059315955e-92, 2.7074679445154407e-98, 3.3945561069849894e-104, 2.865416022316343e-110, 1.6285331204130572e-116, 6.231999757971644e-123, 1.605818845406874e-129, 2.7862438727853806e-136, 3.255436508665476e-143, 2.561414985260097e-150, 1.3571987911692073e-157, 4.842963052970991e-165, 1.1638409853377617e-172}, {-0.13870307753919267, -0.45678608647731345, -0.8515834462036488, -0.7922858836031076, 0., 0.8250714564677251, 0.9269095553633526, 0.5251656861611645, 0.17793700222883838, 0.038037799142658105, 0.005254684618573888, 0.00047514971312243373, 0.00002834028479505889, 1.1205421383735094e-6, 2.9470154223783763e-8, 5.16803896790172e-10, 6.0540005868865355e-12, 4.743834819255436e-14, 2.4891576150811074e-16, 8.753479456032688e-19, 2.064492159208142e-21, 3.2673434893508406e-24, 3.471591223046369e-27, 2.4773371650079914e-30, 1.1877058622401414e-33, 3.826691524720184e-37, 8.287722756305417e-41, 1.2068034399634245e-44, 1.1817023403826776e-48, 7.782529094807439e-53, 3.447760673517053e-57, 1.027573137427776e-61, 2.0606166417808397e-66, 2.7805766731232494e-71, 2.5250248888383016e-76, 1.5432119493905636e-81, 6.348150649488747e-87, 1.757762619008693e-92, 3.276359617962036e-98, 4.111174423967558e-104, 3.4730083647874426e-110, 1.9752955723036615e-116, 7.564213605750697e-123, 1.9503768468810834e-129, 3.386200172110208e-136, 3.9587781275742786e-143, 3.1165790479426693e-150, 1.652253227443061e-157, 5.898868080509924e-165, 1.418292134191128e-172}, {-0.14522791063398674, -0.5092105316206499, -1.0678577787541266, -1.3246586330551409, -0.8250714564677251, 0., 0.3874353112939407, 0.292682609036039, 0.11156279005419244, 0.025438833991885127, 0.0036606418645135524, 0.000340467384548951, 0.00002073022881698179, 8.32659618002882e-7, 2.2172606537880403e-8, 3.9275789764563956e-10, 4.639228138810134e-12, 3.6606590767923505e-14, 1.9322332262636162e-16, 6.829821059047378e-19, 1.6179919109290946e-21, 2.570737226071816e-24, 2.7409229656600638e-27, 1.9619857731518656e-30, 9.432446205797928e-34, 3.04667400538287e-37, 6.613382777337362e-41, 9.649908955292277e-45, 9.467090343825253e-49, 6.245738796256735e-53, 2.7713769714501903e-57, 8.272069181729153e-62, 1.6610961333064536e-66, 2.24433013076447e-71, 2.0404889063554068e-76, 1.2484667196747065e-81, 5.141037498053301e-87, 1.4249121654587107e-92, 2.6583883118391082e-98, 3.3386324257389945e-104, 2.8226901279616985e-110, 1.6066626522910285e-116, 6.157065068394347e-123, 1.588654121419695e-129, 2.7599999524170557e-136, 3.228710664091239e-143, 2.5433407191168084e-150, 1.3491159447628249e-157, 4.819214916467492e-165, 1.1593049452098254e-172}, {-0.09802141064788646, -0.35756545148801255, -0.7997780994008006, -1.1161205607187612, -0.9269095553633526, -0.3874353112939407, 0., 0.0822020630743844, 0.041777639990790705, 0.010717025396156266, 0.0016449890992989, 0.00015937128109620738, 9.980978070496023e-6, 4.0925250952074403e-7, 1.1070825951010823e-8, 1.985560988168198e-10, 2.369020615241743e-12, 1.8848922055055835e-14, 1.0018742966755491e-16, 3.5623815853272145e-19, 8.482598626916134e-22, 1.3537696020357543e-24, 1.4490510510657293e-27, 1.0408498054133004e-30, 5.019483562925109e-34, 1.6257935176953293e-37, 3.5379374970494446e-41, 5.1741096134811144e-45, 5.086595018227387e-49, 3.3621432014253826e-53, 1.4944542765045686e-57, 4.4678297309991155e-62, 8.985042719170036e-67, 1.2156491983873748e-71, 1.1066494349358764e-76, 6.779060475677028e-82, 2.794641652339843e-87, 7.753818038737419e-93, 1.4480056366616504e-98, 1.8202013204520444e-104, 1.5402452291104457e-110, 8.774169849484898e-117, 3.365040652038794e-123, 8.688869538264815e-130, 1.5105804486903948e-136, 1.7682739093840073e-143, 1.3937872077231573e-150, 7.397749760923588e-158, 2.644069852699363e-165, 6.3639866906415964e-173}, {-0.04323593604252438, -0.162078755275349, -0.3776140791356417, -0.5621052053210548, -0.5251656861611645, -0.292682609036039, -0.0822020630743844, 0., 0.007890084042351874, 0.0026986758491910406, 0.00046600653764930695, 0.000048157925706040786, 3.141662853546267e-6, 1.3249890318738967e-7, 3.6589442961224307e-9, 6.666508398585111e-11, 8.053396305156706e-13, 6.4723434551508104e-15, 3.4689049144371363e-17, 1.242069943717246e-19, 2.9751711647584974e-22, 4.772536476728037e-25, 5.131244209082605e-28, 3.70021405401996e-31, 1.7906189421370497e-34, 5.817709258420497e-38, 1.2695256593996063e-41, 1.8612900153543113e-45, 1.8339669172059895e-49, 1.2147272485260858e-53, 5.4096223553399185e-58, 1.6200766720750134e-62, 3.2632814234142163e-67, 4.4216623290119584e-72, 4.030728267925024e-77, 2.4722777675208885e-82, 1.0204003350250187e-87, 2.8342808839391358e-93, 5.298460361432431e-99, 6.666888398357651e-105, 5.646672719184041e-111, 3.21947184596555e-117, 1.2357299721774092e-123, 3.1932415736139776e-130, 5.555583872538382e-137, 6.507830759881628e-144, 5.132971011878171e-151, 2.726110734808631e-158, 9.749339913483961e-166, 2.3478903953378463e-173}, {-0.012565356197362836, -0.04805288672125788, -0.11514928312094445, -0.1785495805148259, -0.17793700222883838, -0.11156279005419244, -0.041777639990790705, -0.007890084042351874, 0., 0.00034288770823363466, 0.00007894632906201139, 9.178257246185382e-6, 6.386762315114153e-7, 2.8058356391715035e-8, 7.96966741804918e-10, 1.482305341689391e-11, 1.8191048791740535e-13, 1.4802506298875138e-15, 8.013659780242695e-18, 2.893268120451058e-20, 6.978804621538954e-23, 1.126148760323195e-25, 1.2170002039448523e-28, 8.815142044594892e-32, 4.282579420513268e-35, 1.3962385343571332e-38, 3.056269007071744e-42, 4.49333545945137e-46, 4.438471015723089e-50, 2.9465008964970784e-54, 1.3149007800325421e-58, 3.9453301639862375e-63, 7.96080437281055e-68, 1.080397136127804e-72, 9.863346608959723e-78, 6.058068591585497e-83, 2.5035819744957298e-88, 6.962269350278792e-94, 1.302988073643363e-99, 1.641217317375835e-105, 1.3914251381897851e-111, 7.940554748347867e-118, 3.0504621678716626e-124, 7.889119025814171e-131, 1.3736044061858696e-137, 1.6102213023312325e-144, 1.2709222743225738e-151, 6.754283705221359e-159, 2.4170327617826436e-166, 5.824297839990358e-174}, {-0.0024188275030921076, -0.009392086514044018, -0.022974579515954874, -0.036642001989834486, -0.038037799142658105, -0.025438833991885127, -0.010717025396156266, -0.0026986758491910406, -0.00034288770823363466, 0., 6.750579286554791e-6, 1.0464248980106084e-6, 8.191833471831058e-8, 3.8387631034528085e-9, 1.1357900241051558e-10, 2.1728511772884475e-12, 2.7221051011263946e-14, 2.2502036757271517e-16, 1.2334243207574579e-18, 4.4981620197886415e-21, 1.0940359087643653e-23, 1.777758461867825e-26, 1.9326137509082527e-29, 1.407035934443569e-32, 6.86618972803209e-36, 2.2473451589009198e-39, 4.936363032581056e-43, 7.279923988988499e-47, 7.211009888811947e-51, 4.7990621708348154e-55, 2.146489135265932e-59, 6.453826639609505e-64, 1.304705952410973e-68, 1.773755499577922e-73, 1.6219223311304553e-78, 9.976607068289416e-84, 4.128636488509476e-89, 1.1496084622963959e-94, 2.1540524872791762e-100, 2.716218790839635e-106, 2.305210868224822e-112, 1.316818685696822e-118, 5.063371160949143e-125, 1.310625093563288e-131, 2.2838433731368077e-138, 2.6793252825681356e-145, 2.1162950511778934e-152, 1.1254789738237138e-159, 4.030196768668731e-167, 9.717595287591514e-175}, {-0.00030953025197664845, -0.001216392191208907, -0.0030226640504822056, -0.004921256744450409, -0.005254684618573888, -0.0036606418645135524, -0.0016449890992989, -0.00046600653764930695, -0.00007894632906201139, -6.750579286554791e-6, 0., 6.023211269557794e-8, 6.286948227840985e-9, 3.314382316853838e-10, 1.046015366958081e-11, 2.0844849485450955e-13, 2.6860131077640825e-15, 2.2666262325526023e-17, 1.2621472143327593e-19, 4.660447624909593e-22, 1.144956322235511e-24, 1.876005993466274e-27, 2.0536810084822037e-30, 1.504078605035199e-33, 7.377387649242756e-37, 2.425443057370685e-40, 5.34845296005639e-44, 7.915043189446967e-48, 7.864389654372964e-52, 5.24843725246842e-56, 2.3533657219969402e-60, 7.09192178442985e-65, 1.4366716321958763e-69, 1.956862799396041e-74, 1.7924676002097256e-79, 1.1043317445742396e-84, 4.576845563100124e-90, 1.2761617183343682e-95, 2.394232616119333e-101, 3.022675462058296e-107, 2.5681491776790335e-113, 1.4685465725054488e-119, 5.6523081444143656e-126, 1.464412844870385e-132, 2.5540371916421698e-139, 2.9987551973972883e-146, 2.3704293782553443e-153, 1.2615531179789535e-160, 4.520591540488164e-168, 1.0907204391158094e-175}, {-0.00002639907836552577, -0.00010475513748495903, -0.00026356011575944075, -0.0004359182032737912, -0.00047514971312243373, -0.000340467384548951, -0.00015937128109620738, -0.000048157925706040786, -9.178257246185382e-6, -1.0464248980106084e-6, -6.023211269557794e-8, 0., 2.4363905965890913e-10, 1.712570151715078e-11, 6.080458860767993e-13, 1.292485789496842e-14, 1.7348578994949572e-16, 1.5058098975410955e-18, 8.55963197543791e-21, 3.2107917285083965e-23, 7.986719929335313e-26, 1.3218390041726854e-28, 1.4590878880450935e-31, 1.0760822150765377e-34, 5.309516163600719e-38, 1.7545465135575316e-41, 3.8863014372998874e-45, 5.773795219070494e-49, 5.756764529844898e-53, 3.853771315215486e-57, 1.732806446700643e-61, 5.234939469954636e-66, 1.0628969398556658e-70, 1.4507488946608362e-75, 1.3313889094016295e-80, 8.2168964822626e-86, 3.410907525541711e-91, 9.524722310356935e-97, 1.7894068763585177e-102, 2.2619790600605272e-108, 1.9241282535499664e-114, 1.1014995173428946e-120, 4.24399214951995e-127, 1.1006179572576202e-133, 1.9213180653465692e-140, 2.2578179045365348e-147, 1.7861979676134925e-154, 9.513566194484624e-162, 3.4115396388747575e-169, 8.237007613185146e-177}, {-1.5034501591681683e-6, -6.013892923804373e-6, -0.000015283371852348964, -0.000025594068363320148, -0.00002834028479505889, -0.00002073022881698179, -9.980978070496023e-6, -3.141662853546267e-6, -6.386762315114153e-7, -8.191833471831058e-8, -6.286948227840985e-9, -2.4363905965890913e-10, 0., 4.4688951617867393e-13, 2.1155675020274187e-14, 5.059048371457463e-16, 7.243286883799783e-18, 6.548935196370229e-20, 3.82904168585292e-22, 1.4662295913347614e-24, 3.7050811497829194e-27, 6.2087312826785575e-30, 6.92262105369554e-33, 5.1480017327628806e-36, 2.5578474089563425e-39, 8.502800594791136e-43, 1.8930193422793593e-46, 2.8249739317771083e-50, 2.827686892415749e-54, 1.8995212121849504e-58, 8.567433671053108e-63, 2.595476262831412e-67, 5.283036963052549e-72, 7.227209663170728e-77, 6.646324957786229e-82, 4.109662917298923e-87, 1.7089248692105046e-92, 4.77970150117635e-98, 8.992914768945642e-104, 1.1383507673747784e-109, 9.695625714102289e-116, 5.557031338976975e-122, 2.1434626702490305e-128, 5.564550670975122e-135, 9.723376363359179e-142, 1.143683161857269e-148, 9.055704765941931e-156, 4.827148723206232e-163, 1.7323394281890133e-170, 4.185712417254321e-178}, {-5.725751582289057e-8, -2.305794585644175e-7, -5.908585105555605e-7, -9.994665912197336e-7, -1.1205421383735094e-6, -8.32659618002882e-7, -4.0925250952074403e-7, -1.3249890318738967e-7, -2.8058356391715035e-8, -3.8387631034528085e-9, -3.314382316853838e-10, -1.712570151715078e-11, -4.4688951617867393e-13, 0., 3.7176487249035614e-16, 1.1853566294843769e-17, 1.9092746666222865e-19, 1.841332167103504e-21, 1.1214510154975585e-23, 4.4169923865422057e-26, 1.139402682645212e-28, 1.9396429911290075e-31, 2.189699546598102e-34, 1.6448165205846848e-37, 8.240575294194591e-41, 2.7584895822806174e-44, 6.177913571308055e-48, 9.266648320389507e-52, 9.316956230368675e-56, 6.283283699095128e-60, 2.843797232500752e-64, 8.641863965511379e-69, 1.7639193105362168e-73, 2.419094393676864e-78, 2.2297164884922666e-83, 1.3815687669457723e-88, 5.755870633703994e-94, 1.6126624300353896e-99, 3.039055268212511e-105, 3.8526286382214556e-111, 3.2858901066331594e-117, 1.8857075486767707e-123, 7.282225577880772e-130, 1.8926099653764225e-136, 3.3105509184742695e-143, 3.897743228723213e-150, 3.089077030576068e-157, 1.6480599757226538e-164, 5.919295127528317e-172, 1.4313360950082106e-179}, {-1.459849508390981e-9, -5.912669373730322e-9, -1.5256992159197238e-8, -2.6023020041528802e-8, -2.9470154223783763e-8, -2.2172606537880403e-8, -1.1070825951010823e-8, -3.6589442961224307e-9, -7.96966741804918e-10, -1.1357900241051558e-10, -1.046015366958081e-11, -6.080458860767993e-13, -2.1155675020274187e-14, -3.7176487249035614e-16, 0., 1.4028646191418387e-19, 3.0128247892150925e-21, 3.2688133913431495e-23, 2.123572147128835e-25, 8.712486728986011e-28, 2.3116771114822158e-30, 4.017228909926211e-33, 4.6071115837896964e-36, 3.5039402655397824e-39, 1.7732157155450955e-42, 5.985211644462054e-46, 1.3498218282970535e-49, 2.0367359211749604e-53, 2.0582947050130164e-57, 1.3942950017485731e-61, 6.335288742852292e-66, 1.9318818703039884e-70, 3.955435835132075e-75, 5.439677407285232e-80, 5.026400284651064e-85, 3.1215180133714656e-90, 1.3031745625541331e-95, 3.6581102272782735e-101, 6.905681691284132e-107, 8.768403651722589e-113, 7.489612412771097e-119, 4.304044940673109e-125, 1.6642588923688502e-131, 4.330465576034378e-138, 7.583270675063872e-145, 8.937615479806837e-152, 7.090249233456025e-159, 3.786210540190198e-166, 1.3610610050581812e-173, 3.293850561953712e-181}, {-2.4940410731407606e-11, -1.0151320030886847e-10, -2.6350073750922534e-10, -4.5258165529081285e-10, -5.16803896790172e-10, -3.9275789764563956e-10, -1.985560988168198e-10, -6.666508398585111e-11, -1.482305341689391e-11, -2.1728511772884475e-12, -2.0844849485450955e-13, -1.292485789496842e-14, -5.059048371457463e-16, -1.1853566294843769e-17, -1.4028646191418387e-19, 0., 2.4015662194278598e-23, 3.47415791601489e-25, 2.539095113322771e-27, 1.1111758713853333e-29, 3.0711187725626017e-32, 5.489470752966147e-35, 6.42669174777388e-38, 4.965407056887754e-41, 2.544220612967687e-44, 8.674361412295646e-48, 1.9725979244669787e-51, 2.9972523023464387e-55, 3.047007752679539e-59, 2.0746370663368372e-63, 9.468656804416723e-68, 2.898693615298994e-72, 5.955544113326597e-77, 8.215665243648097e-82, 7.6125711083790765e-87, 4.739442210723753e-92, 1.983124106702644e-97, 5.57830579764297e-103, 1.0550519300562306e-108, 1.3419689057470926e-114, 1.1480919980877312e-120, 6.607498404793355e-127, 2.5584521842916968e-133, 6.665693034536689e-140, 1.1686487174979284e-146, 1.3788972735256833e-153, 1.0950246682277182e-160, 5.853174668430926e-168, 2.1060239225046174e-175, 5.101118945562041e-183}, {-2.8571420584623737e-13, -1.1679303458189654e-12, -3.047156356468027e-12, -5.264864203815144e-12, -6.0540005868865355e-12, -4.639228138810134e-12, -2.369020615241743e-12, -8.053396305156706e-13, -1.8191048791740535e-13, -2.7221051011263946e-14, -2.6860131077640825e-15, -1.7348578994949572e-16, -7.243286883799783e-18, -1.9092746666222865e-19, -3.0128247892150925e-21, -2.4015662194278598e-23, 0., 1.865295650805636e-27, 1.8176733034233245e-29, 8.948952107016176e-32, 2.6382425338406577e-34, 4.912214781377355e-37, 5.915191350858417e-40, 4.665423023445584e-43, 2.4284566901782506e-46, 8.383167435859159e-50, 1.925635149709815e-53, 2.950277448998681e-57, 3.0202268980230147e-61, 2.068643093830998e-65, 9.489717200156427e-70, 2.918110332962394e-74, 6.018948470089723e-79, 8.331961787720378e-84, 7.744232528076956e-89, 4.834804921818808e-94, 2.0280969542567203e-99, 5.717774852068555e-105, 1.0836693725454851e-110, 1.3809792893253734e-116, 1.1835211985330342e-122, 6.822316224708355e-129, 2.6455441073354397e-135, 6.902066840829035e-142, 1.2116359156600825e-148, 1.4313201132933437e-155, 1.1379196102156983e-162, 6.088794518830479e-170, 2.192943571387206e-177, 5.3165339468430015e-185}, {-2.1960829937816657e-15, -9.011007601704131e-15, -2.3614733313117737e-14, -4.1010668947077846e-14, -4.743834819255436e-14, -3.6606590767923505e-14, -1.8848922055055835e-14, -6.4723434551508104e-15, -1.4802506298875138e-15, -2.2502036757271517e-16, -2.2666262325526023e-17, -1.5058098975410955e-18, -6.548935196370229e-20, -1.841332167103504e-21, -3.2688133913431495e-23, -3.47415791601489e-25, -1.865295650805636e-27, 0., 6.57371431686101e-32, 4.315249572150066e-34, 1.431202132148572e-36, 2.842446688303799e-39, 3.5654351817858346e-42, 2.8924724559226e-45, 1.5369629868889362e-48, 5.389898803531979e-52, 1.2535495565646314e-55, 1.9399706875686014e-59, 2.0025160405650914e-63, 1.3811741921463456e-67, 6.373728798976475e-72, 1.969987536116317e-76, 4.0814726911897884e-81, 5.672092754758908e-86, 5.290293833328994e-91, 3.3130108111332465e-96, 1.393597348997419e-101, 3.938789255351485e-107, 7.482012104966577e-113, 9.554478855896644e-119, 8.203848446729687e-125, 4.737269282198476e-131, 1.8399527086807514e-137, 4.807438508921856e-144, 8.450898089886794e-151, 9.99589765759654e-158, 7.956339721103393e-165, 4.262023816520675e-172, 1.5366118056272022e-179, 3.7289762994421576e-187}, {-1.1330953693501928e-17, -4.66490527407677e-17, -1.2272979318104394e-16, -2.140909130970136e-16, -2.4891576150811074e-16, -1.9322332262636162e-16, -1.0018742966755491e-16, -3.4689049144371363e-17, -8.013659780242695e-18, -1.2334243207574579e-18, -1.2621472143327593e-19, -8.55963197543791e-21, -3.82904168585292e-22, -1.1214510154975585e-23, -2.123572147128835e-25, -2.539095113322771e-27, -1.8176733034233245e-29, -6.57371431686101e-32, 0., 1.0512695321943115e-36, 4.648875021117805e-39, 1.0387038630114098e-41, 1.389762816895926e-44, 1.1744273090048358e-47, 6.418813756899624e-51, 2.2978772196820963e-54, 5.4290912423372105e-58, 8.506988246138908e-62, 8.869956169829104e-66, 6.16876248923576e-70, 2.866616719278496e-74, 8.912857242549064e-79, 1.8560592123312848e-83, 2.5909125578195424e-88, 2.4259900256887786e-93, 1.5245350895138247e-98, 6.432715897117555e-104, 1.8231588301999936e-109, 3.4719004396138325e-115, 4.443669728913605e-121, 3.823407863930887e-127, 2.2119882816140393e-133, 8.606291447735135e-140, 2.252260156695826e-146, 3.965067671254316e-153, 4.6964065945330465e-160, 3.7429282955165544e-167, 2.0073854448439425e-174, 7.245391909321838e-182, 1.7601087178498286e-189}, {-3.926112456151439e-20, -1.6211889090924748e-19, -4.2800033211538732e-19, -7.495352395975131e-19, -8.753479456032688e-19, -6.829821059047378e-19, -3.5623815853272145e-19, -1.242069943717246e-19, -2.893268120451058e-20, -4.4981620197886415e-21, -4.660447624909593e-22, -3.2107917285083965e-23, -1.4662295913347614e-24, -4.4169923865422057e-26, -8.712486728986011e-28, -1.1111758713853333e-29, -8.948952107016176e-32, -4.315249572150066e-34, -1.0512695321943115e-36, 0., 7.629269762454866e-42, 2.272822833687788e-44, 3.421110071070085e-47, 3.0837646410679114e-50, 1.7556527648764635e-53, 6.464651626893417e-57, 1.5591944838930493e-60, 2.481923587047223e-64, 2.620167644173633e-68, 1.8406468003590263e-72, 8.624743037599244e-77, 2.7003492685706766e-81, 5.656818437681195e-86, 7.936967988353773e-91, 7.464923877925439e-96, 4.709486780155444e-101, 1.99404926339745e-106, 5.669026739629147e-112, 1.082569941148432e-117, 1.3890490123446592e-123, 1.1978773111571019e-129, 6.944528471448008e-136, 2.7070591140307647e-142, 7.096674452766217e-149, 1.2513602651167786e-155, 1.4843638501767372e-162, 1.1846289348563207e-169, 6.361446811709398e-177, 2.2988134055872564e-184, 5.590673772260534e-192}, {-9.138775160816775e-23, -3.783732360689204e-22, -1.0020088290147166e-21, -1.7608598617341784e-21, -2.064492159208142e-21, -1.6179919109290946e-21, -8.482598626916134e-22, -2.9751711647584974e-22, -6.978804621538954e-23, -1.0940359087643653e-23, -1.144956322235511e-24, -7.986719929335313e-26, -3.7050811497829194e-27, -1.139402682645212e-28, -2.3116771114822158e-30, -3.0711187725626017e-32, -2.6382425338406577e-34, -1.431202132148572e-36, -4.648875021117805e-39, -7.629269762454866e-42, 0., 2.512692743245118e-47, 5.042891052781125e-50, 5.1138299831193265e-53, 3.105506260551272e-56, 1.1911533526897993e-59, 2.9549987218536596e-63, 4.8017578689146755e-67, 5.149681319843986e-71, 3.6628300372815715e-75, 1.7336334456563687e-79, 5.473122601752356e-84, 1.1545531508589804e-88, 1.6295727085492872e-93, 1.5405150922452055e-98, 9.76222146655251e-104, 4.1496430643690257e-109, 1.1838283035309299e-114, 2.2676637920077456e-120, 2.917729138864492e-126, 2.5224748063276508e-132, 1.4656935410628418e-138, 5.725275393871564e-145, 1.5037487344288847e-151, 2.6561793187837124e-158, 3.155809848332231e-165, 2.5222940611720428e-172, 1.3563301958750116e-179, 4.907581852566548e-187, 1.1949361269069532e-194}, {-1.4294556254094292e-25, -5.932682733157538e-25, -1.5754525071896581e-24, -2.7771606055372253e-24, -3.2673434893508406e-24, -2.570737226071816e-24, -1.3537696020357543e-24, -4.772536476728037e-25, -1.126148760323195e-25, -1.777758461867825e-26, -1.876005993466274e-27, -1.3218390041726854e-28, -6.2087312826785575e-30, -1.9396429911290075e-31, -4.017228909926211e-33, -5.489470752966147e-35, -4.912214781377355e-37, -2.842446688303799e-39, -1.0387038630114098e-41, -2.272822833687788e-44, -2.512692743245118e-47, 0., 3.7557978317156787e-53, 5.078174764260781e-56, 3.469335414253743e-59, 1.419417911653982e-62, 3.667994435500077e-66, 6.130643804030134e-70, 6.711831176236282e-74, 4.8497221906084955e-78, 2.324087116391533e-82, 7.411312203556544e-87, 1.5764419631293838e-91, 2.24059959550402e-96, 2.130756838094075e-101, 1.3571818695870217e-106, 5.794749081093585e-112, 1.6596342819980295e-117, 3.1901249873227014e-123, 4.1173377450300695e-129, 3.569464437583323e-135, 2.079248954567385e-141, 8.140397503762032e-148, 2.142509402301245e-154, 3.791635685753867e-161, 4.51268144211487e-168, 3.6125593841479476e-175, 1.945483855449839e-182, 7.04897388328938e-190, 1.7185308858048692e-197}, {-1.5028697004531457e-28, -6.251038420907328e-28, -1.6641480644444106e-27, -2.941658799713593e-27, -3.471591223046369e-27, -2.7409229656600638e-27, -1.4490510510657293e-27, -5.131244209082605e-28, -1.2170002039448523e-28, -1.9326137509082527e-29, -2.0536810084822037e-30, -1.4590878880450935e-31, -6.92262105369554e-33, -2.189699546598102e-34, -4.6071115837896964e-36, -6.42669174777388e-38, -5.915191350858417e-40, -3.5654351817858346e-42, -1.389762816895926e-44, -3.421110071070085e-47, -5.042891052781125e-50, -3.7557978317156787e-53, 0., 2.547932109088299e-59, 2.3209470618947303e-62, 1.0682717633423248e-65, 2.944617302718074e-69, 5.126666214668783e-73, 5.773038303357534e-77, 4.2582888657169545e-81, 2.0730514715545682e-85, 6.693416075451534e-90, 1.4381212586423703e-94, 2.0610375150570393e-99, 1.973703854014434e-104, 1.2646302632898362e-109, 5.427272358416236e-115, 1.5613270291794146e-120, 3.012929465049911e-126, 3.902142404306197e-132, 3.3933774395092276e-138, 1.9821672742909708e-144, 7.779765703577091e-151, 2.0522466477502544e-157, 3.639415592511949e-164, 4.3397176643000245e-171, 3.4801377341375323e-178, 1.877173853389094e-185, 6.811545937123578e-193, 1.6629273613777126e-200}, {-1.0622720601798807e-31, -4.427233167402575e-31, -1.1812906003559086e-30, -2.0933610261008887e-30, -2.4773371650079914e-30, -1.9619857731518656e-30, -1.0408498054133004e-30, -3.70021405401996e-31, -8.815142044594892e-32, -1.407035934443569e-32, -1.504078605035199e-33, -1.0760822150765377e-34, -5.1480017327628806e-36, -1.6448165205846848e-37, -3.5039402655397824e-39, -4.965407056887754e-41, -4.665423023445584e-43, -2.8924724559226e-45, -1.1744273090048358e-47, -3.0837646410679114e-50, -5.1138299831193265e-53, -5.078174764260781e-56, -2.547932109088299e-59, 0., 7.845320306760896e-66, 4.814663402244625e-69, 1.493019787047263e-72, 2.772684597267235e-76, 3.252360166289565e-80, 2.4675375466026005e-84, 1.2262911067249166e-88, 4.022265559548189e-93, 8.750108857994225e-98, 1.2666850712753174e-102, 1.2231194395898861e-107, 7.891815157717556e-113, 3.4070018821023277e-118, 9.851584690330519e-124, 1.9095704321852616e-129, 2.482845045819872e-135, 2.1666263709521958e-141, 1.2695056737224332e-147, 4.9964962247759755e-154, 1.3213433893033059e-160, 2.3485710637477713e-167, 2.806284910601557e-174, 2.2546984545549313e-181, 1.218291375738646e-188, 4.427797910131248e-196, 1.0825757719465779e-203}, {-5.048909248722457e-35, -2.1080757712728692e-34, -5.636474703046654e-34, -1.0011077462464305e-33, -1.1877058622401414e-33, -9.432446205797928e-34, -5.019483562925109e-34, -1.7906189421370497e-34, -4.282579420513268e-35, -6.86618972803209e-36, -7.377387649242756e-37, -5.309516163600719e-38, -2.5578474089563425e-39, -8.240575294194591e-41, -1.7732157155450955e-42, -2.544220612967687e-44, -2.4284566901782506e-46, -1.5369629868889362e-48, -6.418813756899624e-51, -1.7556527648764635e-53, -3.105506260551272e-56, -3.469335414253743e-59, -2.3209470618947303e-62, -7.845320306760896e-66, 0., 1.0964360900348159e-72, 4.533375484820074e-76, 9.471289697978097e-80, 1.1850481800905199e-83, 9.365477201548291e-88, 4.787338941077723e-92, 1.6029729019040424e-96, 3.5424874544396355e-101, 5.192285315672894e-106, 5.0643483494582744e-111, 3.294850631319468e-116, 1.432378041289575e-121, 4.1664751806563556e-127, 8.117454170715997e-133, 1.0601523487077688e-138, 9.287577985204973e-145, 5.4608273967843295e-151, 2.1559160966089987e-157, 5.717243493081413e-164, 1.0187363295631652e-170, 1.2200447552263548e-177, 9.82269590714483e-185, 5.317593703097917e-192, 1.9360047179015203e-199, 4.7410261567824145e-207}, {-1.6139129881030288e-38, -6.749879972144972e-38, -1.808164797009043e-37, -3.218173573985482e-37, -3.826691524720184e-37, -3.04667400538287e-37, -1.6257935176953293e-37, -5.817709258420497e-38, -1.3962385343571332e-38, -2.2473451589009198e-39, -2.425443057370685e-40, -1.7545465135575316e-41, -8.502800594791136e-43, -2.7584895822806174e-44, -5.985211644462054e-46, -8.674361412295646e-48, -8.383167435859159e-50, -5.389898803531979e-52, -2.2978772196820963e-54, -6.464651626893417e-57, -1.1911533526897993e-59, -1.419417911653982e-62, -1.0682717633423248e-65, -4.814663402244625e-69, -1.0964360900348159e-72, 0., 6.955317368172503e-80, 1.937506271163709e-83, 2.7272347779389626e-87, 2.2990327259419688e-91, 1.2241600030596184e-95, 4.216039260429071e-100, 9.511338306649539e-105, 1.4162218214674703e-109, 1.3985929529230164e-114, 9.191117142096915e-120, 4.0289729260617637e-125, 1.1801356997718875e-130, 2.312918966022825e-136, 3.0361995518184e-142, 2.6717696070948462e-148, 1.5770837846961335e-154, 6.2478921859470906e-161, 1.6619993453948604e-167, 2.9696868414314468e-174, 3.5654283927382917e-181, 2.8770841770295986e-188, 1.5607568571011328e-195, 5.693092772714077e-203, 1.3965897161786111e-210}, {-3.4701493235064504e-42, -1.4535643719403759e-41, -3.9005856906836443e-41, -6.955414146463928e-41, -8.287722756305417e-41, -6.613382777337362e-41, -3.5379374970494446e-41, -1.2695256593996063e-41, -3.056269007071744e-42, -4.936363032581056e-43, -5.34845296005639e-44, -3.8863014372998874e-45, -1.8930193422793593e-46, -6.177913571308055e-48, -1.3498218282970535e-49, -1.9725979244669787e-51, -1.925635149709815e-53, -1.2535495565646314e-55, -5.4290912423372105e-58, -1.5591944838930493e-60, -2.9549987218536596e-63, -3.667994435500077e-66, -2.944617302718074e-69, -1.493019787047263e-72, -4.533375484820074e-76, -6.955317368172503e-80, 0., 2.0027258112006796e-87, 3.758717112660475e-91, 3.564632731439039e-95, 2.024587478579448e-99, 7.263263069616914e-104, 1.6854008689381164e-108, 2.561814672442967e-113, 2.57008322535931e-118, 1.7100908551766002e-123, 7.571990104209615e-129, 2.2364117284949216e-134, 4.413739373443162e-140, 5.828462442490643e-146, 5.155183820003938e-152, 3.0565704957756966e-158, 1.2156623370616125e-164, 3.2450070040443995e-171, 5.816181258441242e-178, 7.002348118898368e-185, 5.664631242837292e-192, 3.0799256978450103e-199, 1.1257746877843138e-206, 2.766902195326973e-214}, {-5.019484651898218e-46, -2.1055461949211932e-45, -5.659196724865996e-45, -1.0108869047362199e-44, -1.2068034399634245e-44, -9.649908955292277e-45, -5.1741096134811144e-45, -1.8612900153543113e-45, -4.49333545945137e-46, -7.279923988988499e-47, -7.915043189446967e-48, -5.773795219070494e-49, -2.8249739317771083e-50, -9.266648320389507e-52, -2.0367359211749604e-53, -2.9972523023464387e-55, -2.950277448998681e-57, -1.9399706875686014e-59, -8.506988246138908e-62, -2.481923587047223e-64, -4.8017578689146755e-67, -6.130643804030134e-70, -5.126666214668783e-73, -2.772684597267235e-76, -9.471289697978097e-80, -1.937506271163709e-83, -2.0027258112006796e-87, 0., 2.6176152689433258e-95, 3.3099367989363363e-99, 2.1149201729190131e-103, 8.093156358840372e-108, 1.9562219930317638e-112, 3.0584197450329047e-117, 3.13221388046657e-122, 2.117204614527374e-127, 9.491803020597e-133, 2.8317521946923724e-138, 5.635264352989043e-144, 7.493557874203187e-150, 6.667386664150785e-156, 3.973446437439164e-162, 1.5873781864895262e-168, 4.253856835669677e-175, 7.650864643916534e-182, 9.23971917157939e-189, 7.495341389235066e-196, 4.085517829238479e-203, 1.4967327560288589e-210, 3.6862503135036226e-218}, {-4.884995713535688e-50, -2.0518436407930887e-49, -5.523016106373145e-49, -9.881422956491124e-49, -1.1817023403826776e-48, -9.467090343825253e-49, -5.086595018227387e-49, -1.8339669172059895e-49, -4.438471015723089e-50, -7.211009888811947e-51, -7.864389654372964e-52, -5.756764529844898e-53, -2.827686892415749e-54, -9.316956230368675e-56, -2.0582947050130164e-57, -3.047007752679539e-59, -3.0202268980230147e-61, -2.0025160405650914e-63, -8.869956169829104e-66, -2.620167644173633e-68, -5.149681319843986e-71, -6.711831176236282e-74, -5.773038303357534e-77, -3.252360166289565e-80, -1.1850481800905199e-83, -2.7272347779389626e-87, -3.758717112660475e-91, -2.6176152689433258e-95, 0., 1.5530228874076265e-103, 1.3230945213772936e-107, 5.695965430829402e-112, 1.4685754865191555e-116, 2.3916850743000423e-121, 2.5193747399908768e-126, 1.7384373149661665e-131, 7.917432052741749e-137, 2.3915854671989805e-142, 4.8073944656019425e-148, 6.445960730297583e-154, 5.775394916831628e-160, 3.462348905435576e-166, 1.3902897954768137e-172, 3.7423318556679286e-179, 6.7572460089217e-186, 8.188857965572123e-193, 6.66343971607637e-200, 3.64215870397908e-207, 1.3376519122330237e-214, 3.301943113616156e-222}, {-3.198962287100757e-54, -1.345312805475596e-53, -3.6261907264068973e-53, -6.497356840392295e-53, -7.782529094807439e-53, -6.245738796256735e-53, -3.3621432014253826e-53, -1.2147272485260858e-53, -2.9465008964970784e-54, -4.7990621708348154e-55, -5.24843725246842e-56, -3.853771315215486e-57, -1.8995212121849504e-58, -6.283283699095128e-60, -1.3942950017485731e-61, -2.0746370663368372e-63, -2.068643093830998e-65, -1.3811741921463456e-67, -6.16876248923576e-70, -1.8406468003590263e-72, -3.6628300372815715e-75, -4.8497221906084955e-78, -4.2582888657169545e-81, -2.4675375466026005e-84, -9.365477201548291e-88, -2.2990327259419688e-91, -3.564632731439039e-95, -3.3099367989363363e-99, -1.5530228874076265e-103, 0., 4.18258490536848e-112, 2.4008220775930607e-116, 6.9637220505400455e-121, 1.209700528999152e-125, 1.3273804438757866e-130, 9.420981177115576e-136, 4.380021963779362e-141, 1.3440557203348889e-146, 2.7354964714906204e-152, 3.704920220332538e-158, 3.3471641837286415e-164, 2.0206570676683207e-170, 8.162149441873505e-177, 2.2083248695634606e-183, 4.005206360279083e-190, 4.872796673430641e-197, 3.978861111061481e-204, 2.181532364170737e-211, 8.034347472579879e-219, 1.9882188096605873e-226}, {-1.4097271588751138e-58, -5.9353599095142546e-58, -1.601872531233867e-57, -2.8741548015876806e-57, -3.447760673517053e-57, -2.7713769714501903e-57, -1.4944542765045686e-57, -5.4096223553399185e-58, -1.3149007800325421e-58, -2.146489135265932e-59, -2.3533657219969402e-60, -1.732806446700643e-61, -8.567433671053108e-63, -2.843797232500752e-64, -6.335288742852292e-66, -9.468656804416723e-68, -9.489717200156427e-70, -6.373728798976475e-72, -2.866616719278496e-74, -8.624743037599244e-77, -1.7336334456563687e-79, -2.324087116391533e-82, -2.0730514715545682e-85, -1.2262911067249166e-88, -4.787338941077723e-92, -1.2241600030596184e-95, -2.024587478579448e-99, -2.1149201729190131e-103, -1.3230945213772936e-107, -4.18258490536848e-112, 0., 5.113438062344668e-121, 1.9775760267649445e-125, 3.864756651536773e-130, 4.5234357003122395e-135, 3.344243636745725e-140, 1.5992358545511737e-145, 5.009661086187123e-151, 1.0357779367716954e-156, 1.420379479551667e-162, 1.2961860702733643e-168, 7.890182938387342e-175, 3.209411874718995e-181, 8.734967618960476e-188, 1.5923725892546497e-194, 1.9459540712535034e-201, 1.595191622753586e-208, 8.776494721818423e-216, 3.24229505430796e-223, 8.045829085670159e-231}, {-4.1809899239074404e-63, -1.7622043713885196e-62, -4.761602729801998e-62, -8.554401657811291e-62, -1.027573137427776e-61, -8.272069181729153e-62, -4.4678297309991155e-62, -1.6200766720750134e-62, -3.9453301639862375e-63, -6.453826639609505e-64, -7.09192178442985e-65, -5.234939469954636e-66, -2.595476262831412e-67, -8.641863965511379e-69, -1.9318818703039884e-70, -2.898693615298994e-72, -2.918110332962394e-74, -1.969987536116317e-76, -8.912857242549064e-79, -2.7003492685706766e-81, -5.473122601752356e-84, -7.411312203556544e-87, -6.693416075451534e-90, -4.022265559548189e-93, -1.6029729019040424e-96, -4.216039260429071e-100, -7.263263069616914e-104, -8.093156358840372e-108, -5.695965430829402e-112, -2.4008220775930607e-116, -5.113438062344668e-121, 0., 2.8378432790940372e-130, 7.394624220399167e-135, 9.73676973234585e-140, 7.678442052084924e-145, 3.824868306874025e-150, 1.2323860424419206e-155, 2.601117215853535e-161, 3.623573555823327e-167, 3.348074198288218e-173, 2.0586361852250068e-179, 8.443492247389162e-186, 2.3141121778997032e-192, 4.243705371620223e-199, 5.212602129009894e-206, 4.292095250919187e-213, 2.3707042154974935e-220, 8.788488014901972e-228, 2.1876352951221563e-235}, {-8.345932123285024e-68, -3.521174940116131e-67, -9.525036093767135e-67, -1.7132462832702148e-66, -2.0606166417808397e-66, -1.6610961333064536e-66, -8.985042719170036e-67, -3.2632814234142163e-67, -7.96080437281055e-68, -1.304705952410973e-68, -1.4366716321958763e-69, -1.0628969398556658e-70, -5.283036963052549e-72, -1.7639193105362168e-73, -3.955435835132075e-75, -5.955544113326597e-77, -6.018948470089723e-79, -4.0814726911897884e-81, -1.8560592123312848e-83, -5.656818437681195e-86, -1.1545531508589804e-88, -1.5764419631293838e-91, -1.4381212586423703e-94, -8.750108857994225e-98, -3.5424874544396355e-101, -9.511338306649539e-105, -1.6854008689381164e-108, -1.9562219930317638e-112, -1.4685754865191555e-116, -6.9637220505400455e-121, -1.9775760267649445e-125, -2.8378432790940372e-130, 0., 7.14951046971884e-140, 1.2552026096761843e-144, 1.1135880649161747e-149, 5.9169332077438194e-155, 1.9858924200789782e-160, 4.3112511885305555e-166, 6.131056633879131e-172, 5.754833257988354e-178, 3.5827153534334336e-184, 1.4842929237743427e-190, 4.1019091766223574e-197, 7.574837340581469e-204, 9.35966030390698e-211, 7.746335829273386e-218, 4.297727165740017e-225, 1.5994674974753235e-232, 3.9952276540352646e-240}, {-1.1213797752793788e-72, -4.735591634823848e-72, -1.282344740383377e-71, -2.3090894724815564e-71, -2.7805766731232494e-71, -2.24433013076447e-71, -1.2156491983873748e-71, -4.4216623290119584e-72, -1.080397136127804e-72, -1.773755499577922e-73, -1.956862799396041e-74, -1.4507488946608362e-75, -7.227209663170728e-77, -2.419094393676864e-78, -5.439677407285232e-80, -8.215665243648097e-82, -8.331961787720378e-84, -5.672092754758908e-86, -2.5909125578195424e-88, -7.936967988353773e-91, -1.6295727085492872e-93, -2.24059959550402e-96, -2.0610375150570393e-99, -1.2666850712753174e-102, -5.192285315672894e-106, -1.4162218214674703e-109, -2.561814672442967e-113, -3.0584197450329047e-117, -2.3916850743000423e-121, -1.209700528999152e-125, -3.864756651536773e-130, -7.394624220399167e-135, -7.14951046971884e-140, 0., 8.176765510094424e-150, 9.672327969435317e-155, 5.781701098170924e-160, 2.0698716235395772e-165, 4.68079678292263e-171, 6.8467779561700565e-177, 6.560523619107606e-183, 4.149134257845822e-189, 1.7404431098519854e-195, 4.858375303844476e-202, 9.046538922206696e-209, 1.1256300697599492e-215, 9.371505045727488e-223, 5.2260471508057645e-230, 1.953639381660349e-237, 4.899032244858052e-245}, {-1.0142394001482238e-77, -4.2869295888688944e-77, -1.1619852883818743e-76, -2.0945403552355497e-76, -2.5250248888383016e-76, -2.0404889063554068e-76, -1.1066494349358764e-76, -4.030728267925024e-77, -9.863346608959723e-78, -1.6219223311304553e-78, -1.7924676002097256e-79, -1.3313889094016295e-80, -6.646324957786229e-82, -2.2297164884922666e-83, -5.026400284651064e-85, -7.6125711083790765e-87, -7.744232528076956e-89, -5.290293833328994e-91, -2.4259900256887786e-93, -7.464923877925439e-96, -1.5405150922452055e-98, -2.130756838094075e-101, -1.973703854014434e-104, -1.2231194395898861e-107, -5.0643483494582744e-111, -1.3985929529230164e-114, -2.57008322535931e-118, -3.13221388046657e-122, -2.5193747399908768e-126, -1.3273804438757866e-130, -4.5234357003122395e-135, -9.73676973234585e-140, -1.2552026096761843e-144, -8.176765510094424e-150, 0., 4.24530160501905e-160, 3.3835446205392203e-165, 1.3627374950524394e-170, 3.2871332168393485e-176, 5.008555944061718e-182, 4.936273850450842e-188, 3.1869340209393557e-194, 1.358047126431865e-200, 3.8383193138890223e-207, 7.219336784592199e-214, 9.057631683225931e-221, 7.593723303356525e-228, 4.259868292828823e-235, 1.600621732474942e-242, 4.031708327714158e-250}, {-6.1753767448679165e-83, -2.6123500999281205e-82, -7.087353322284712e-82, -1.2787819345545229e-81, -1.5432119493905636e-81, -1.2484667196747065e-81, -6.779060475677028e-82, -2.4722777675208885e-82, -6.058068591585497e-83, -9.976607068289416e-84, -1.1043317445742396e-84, -8.2168964822626e-86, -4.109662917298923e-87, -1.3815687669457723e-88, -3.1215180133714656e-90, -4.739442210723753e-92, -4.834804921818808e-94, -3.3130108111332465e-96, -1.5245350895138247e-98, -4.709486780155444e-101, -9.76222146655251e-104, -1.3571818695870217e-106, -1.2646302632898362e-109, -7.891815157717556e-113, -3.294850631319468e-116, -9.191117142096915e-120, -1.7100908551766002e-123, -2.117204614527374e-127, -1.7384373149661665e-131, -9.420981177115576e-136, -3.344243636745725e-140, -7.678442052084924e-145, -1.1135880649161747e-149, -9.672327969435317e-155, -4.24530160501905e-160, 0., 1.0006020482265236e-170, 5.37329174644173e-176, 1.4581360371000764e-181, 2.3698561825907235e-187, 2.432974035269259e-193, 1.6156443188807721e-199, 7.028171799722853e-206, 2.0179390933721607e-212, 3.8429017998964355e-219, 4.870140008204005e-226, 4.117045651557186e-233, 2.3256991843708077e-240, 8.790700846243645e-248, 2.2255910051661516e-255}, {-2.5313072080420735e-88, -1.0716535651961923e-87, -2.909929319799615e-87, -5.255255276386611e-87, -6.348150649488747e-87, -5.141037498053301e-87, -2.794641652339843e-87, -1.0204003350250187e-87, -2.5035819744957298e-88, -4.128636488509476e-89, -4.576845563100124e-90, -3.410907525541711e-91, -1.7089248692105046e-92, -5.755870633703994e-94, -1.3031745625541331e-95, -1.983124106702644e-97, -2.0280969542567203e-99, -1.393597348997419e-101, -6.432715897117555e-104, -1.99404926339745e-106, -4.1496430643690257e-109, -5.794749081093585e-112, -5.427272358416236e-115, -3.4070018821023277e-118, -1.432378041289575e-121, -4.0289729260617637e-125, -7.571990104209615e-129, -9.491803020597e-133, -7.917432052741749e-137, -4.380021963779362e-141, -1.5992358545511737e-145, -3.824868306874025e-150, -5.9169332077438194e-155, -5.781701098170924e-160, -3.3835446205392203e-165, -1.0006020482265236e-170, 0., 1.0706407974504277e-181, 3.873826332708974e-187, 7.082989812116488e-193, 7.756411180976585e-199, 5.365347734649015e-205, 2.4006505239038922e-211, 7.036382982068432e-218, 1.3612570027928793e-224, 1.7466959716000903e-231, 1.4915106545906462e-238, 8.495683842642715e-246, 3.23366299895965e-253, 8.2355770868063e-261}, {-6.985636156139775e-94, -2.959636818609009e-93, -8.043047281672449e-93, -1.4538106059315955e-92, -1.757762619008693e-92, -1.4249121654587107e-92, -7.753818038737419e-93, -2.8342808839391358e-93, -6.962269350278792e-94, -1.1496084622963959e-94, -1.2761617183343682e-95, -9.524722310356935e-97, -4.77970150117635e-98, -1.6126624300353896e-99, -3.6581102272782735e-101, -5.57830579764297e-103, -5.717774852068555e-105, -3.938789255351485e-107, -1.8231588301999936e-109, -5.669026739629147e-112, -1.1838283035309299e-114, -1.6596342819980295e-117, -1.5613270291794146e-120, -9.851584690330519e-124, -4.1664751806563556e-127, -1.1801356997718875e-130, -2.2364117284949216e-134, -2.8317521946923724e-138, -2.3915854671989805e-142, -1.3440557203348889e-146, -5.009661086187123e-151, -1.2323860424419206e-155, -1.9858924200789782e-160, -2.0698716235395772e-165, -1.3627374950524394e-170, -5.37329174644173e-176, -1.0706407974504277e-181, 0., 5.200668711798765e-193, 1.2678690382799187e-198, 1.5619643788939127e-204, 1.1524892938397317e-210, 5.371514275266745e-217, 1.6193909886280205e-223, 3.198138136934662e-230, 4.168826630983147e-237, 3.604274903205441e-244, 2.0737418652082594e-251, 7.958940073157402e-259, 2.0411784223533076e-266}, {-1.297975112535957e-99, -5.503063110250994e-99, -1.4966541557258625e-98, -2.7074679445154407e-98, -3.276359617962036e-98, -2.6583883118391082e-98, -1.4480056366616504e-98, -5.298460361432431e-99, -1.302988073643363e-99, -2.1540524872791762e-100, -2.394232616119333e-101, -1.7894068763585177e-102, -8.992914768945642e-104, -3.039055268212511e-105, -6.905681691284132e-107, -1.0550519300562306e-108, -1.0836693725454851e-110, -7.482012104966577e-113, -3.4719004396138325e-115, -1.082569941148432e-117, -2.2676637920077456e-120, -3.1901249873227014e-123, -3.012929465049911e-126, -1.9095704321852616e-129, -8.117454170715997e-133, -2.312918966022825e-136, -4.413739373443162e-140, -5.635264352989043e-144, -4.8073944656019425e-148, -2.7354964714906204e-152, -1.0357779367716954e-156, -2.601117215853535e-161, -4.3112511885305555e-166, -4.68079678292263e-171, -3.2871332168393485e-176, -1.4581360371000764e-181, -3.873826332708974e-187, -5.200668711798765e-193, 0., 1.1468609450086273e-204, 1.8838496086087536e-210, 1.5637399298414923e-216, 7.774153010272872e-223, 2.441388165868217e-229, 4.959259015722555e-236, 6.599153803871883e-243, 5.796044995196046e-250, 3.376475227468183e-257, 1.3089676468552376e-264, 3.3850007612299776e-272}, {-1.6238433480190901e-105, -6.889251465656533e-105, -1.875019999302604e-104, -3.3945561069849894e-104, -4.111174423967558e-104, -3.3386324257389945e-104, -1.8202013204520444e-104, -6.666888398357651e-105, -1.641217317375835e-105, -2.716218790839635e-106, -3.022675462058296e-107, -2.2619790600605272e-108, -1.1383507673747784e-109, -3.8526286382214556e-111, -8.768403651722589e-113, -1.3419689057470926e-114, -1.3809792893253734e-116, -9.554478855896644e-119, -4.443669728913605e-121, -1.3890490123446592e-123, -2.917729138864492e-126, -4.1173377450300695e-129, -3.902142404306197e-132, -2.482845045819872e-135, -1.0601523487077688e-138, -3.0361995518184e-142, -5.828462442490643e-146, -7.493557874203187e-150, -6.445960730297583e-154, -3.704920220332538e-158, -1.420379479551667e-162, -3.623573555823327e-167, -6.131056633879131e-172, -6.8467779561700565e-177, -5.008555944061718e-182, -2.3698561825907235e-187, -7.082989812116488e-193, -1.2678690382799187e-198, -1.1468609450086273e-204, 0., 1.1481574408460424e-216, 1.2707452001765804e-222, 7.107216720669426e-229, 2.3807403527972177e-235, 5.037566086277422e-242, 6.89487936244572e-249, 6.181943227860962e-256, 3.658442691942379e-263, 1.436007251349685e-270, 3.751036555934338e-278}, {-1.3679050445865093e-111, -5.807095314117788e-111, -1.5815876322620357e-110, -2.865416022316343e-110, -3.4730083647874426e-110, -2.8226901279616985e-110, -1.5402452291104457e-110, -5.646672719184041e-111, -1.3914251381897851e-111, -2.305210868224822e-112, -2.5681491776790335e-113, -1.9241282535499664e-114, -9.695625714102289e-116, -3.2858901066331594e-117, -7.489612412771097e-119, -1.1480919980877312e-120, -1.1835211985330342e-122, -8.203848446729687e-125, -3.823407863930887e-127, -1.1978773111571019e-129, -2.5224748063276508e-132, -3.569464437583323e-135, -3.3933774395092276e-138, -2.1666263709521958e-141, -9.287577985204973e-145, -2.6717696070948462e-148, -5.155183820003938e-152, -6.667386664150785e-156, -5.775394916831628e-160, -3.3471641837286415e-164, -1.2961860702733643e-168, -3.348074198288218e-173, -5.754833257988354e-178, -6.560523619107606e-183, -4.936273850450842e-188, -2.432974035269259e-193, -7.756411180976585e-199, -1.5619643788939127e-204, -1.8838496086087536e-210, -1.1481574408460424e-216, 0., 5.218358987662831e-229, 3.8914707418837566e-235, 1.4664888542075058e-241, 3.309910217547102e-248, 4.719009979979973e-255, 4.351947952589019e-262, 2.6291161890255103e-269, 1.0483579200107961e-276, 2.772676975650603e-284}, {-7.759206055225181e-118, -3.295958927189253e-117, -8.982584697224363e-117, -1.6285331204130572e-116, -1.9752955723036615e-116, -1.6066626522910285e-116, -8.774169849484898e-117, -3.21947184596555e-117, -7.940554748347867e-118, -1.316818685696822e-118, -1.4685465725054488e-119, -1.1014995173428946e-120, -5.557031338976975e-122, -1.8857075486767707e-123, -4.304044940673109e-125, -6.607498404793355e-127, -6.822316224708355e-129, -4.737269282198476e-131, -2.2119882816140393e-133, -6.944528471448008e-136, -1.4656935410628418e-138, -2.079248954567385e-141, -1.9821672742909708e-144, -1.2695056737224332e-147, -5.4608273967843295e-151, -1.5770837846961335e-154, -3.0565704957756966e-158, -3.973446437439164e-162, -3.462348905435576e-166, -2.0206570676683207e-170, -7.890182938387342e-175, -2.0586361852250068e-179, -3.5827153534334336e-184, -4.149134257845822e-189, -3.1869340209393557e-194, -1.6156443188807721e-199, -5.365347734649015e-205, -1.1524892938397317e-210, -1.5637399298414923e-216, -1.2707452001765804e-222, -5.218358987662831e-229, 0., 1.0767399119132369e-241, 5.410215261138925e-248, 1.3737399067622932e-254, 2.0891418087143785e-261, 2.006917335343743e-268, 1.247067690142692e-275, 5.076269504018421e-283, 1.363872558124998e-290}, {-2.9637561939649853e-124, -1.2596673494777431e-123, -3.435156588435671e-123, -6.231999757971644e-123, -7.564213605750697e-123, -6.157065068394347e-123, -3.365040652038794e-123, -1.2357299721774092e-123, -3.0504621678716626e-124, -5.063371160949143e-125, -5.6523081444143656e-126, -4.24399214951995e-127, -2.1434626702490305e-128, -7.282225577880772e-130, -1.6642588923688502e-131, -2.5584521842916968e-133, -2.6455441073354397e-135, -1.8399527086807514e-137, -8.606291447735135e-140, -2.7070591140307647e-142, -5.725275393871564e-145, -8.140397503762032e-148, -7.779765703577091e-151, -4.9964962247759755e-154, -2.1559160966089987e-157, -6.2478921859470906e-161, -1.2156623370616125e-164, -1.5873781864895262e-168, -1.3902897954768137e-172, -8.162149441873505e-177, -3.209411874718995e-181, -8.443492247389162e-186, -1.4842929237743427e-190, -1.7404431098519854e-195, -1.358047126431865e-200, -7.028171799722853e-206, -2.4006505239038922e-211, -5.371514275266745e-217, -7.774153010272872e-223, -7.107216720669426e-229, -3.8914707418837566e-235, -1.0767399119132369e-241, 0., 1.0086357821390763e-254, 3.414782735825706e-261, 5.842234774005501e-268, 5.986449081278957e-275, 3.8748830817089445e-282, 1.6223617670536115e-289, 4.449709570701008e-297}, {-7.623332275302057e-131, -3.2418686899760583e-130, -8.845943344402287e-130, -1.605818845406874e-129, -1.9503768468810834e-129, -1.588654121419695e-129, -8.688869538264815e-130, -3.1932415736139776e-130, -7.889119025814171e-131, -1.310625093563288e-131, -1.464412844870385e-132, -1.1006179572576202e-133, -5.564550670975122e-135, -1.8926099653764225e-136, -4.330465576034378e-138, -6.665693034536689e-140, -6.902066840829035e-142, -4.807438508921856e-144, -2.252260156695826e-146, -7.096674452766217e-149, -1.5037487344288847e-151, -2.142509402301245e-154, -2.0522466477502544e-157, -1.3213433893033059e-160, -5.717243493081413e-164, -1.6619993453948604e-167, -3.2450070040443995e-171, -4.253856835669677e-175, -3.7423318556679286e-179, -2.2083248695634606e-183, -8.734967618960476e-188, -2.3141121778997032e-192, -4.1019091766223574e-197, -4.858375303844476e-202, -3.8383193138890223e-207, -2.0179390933721607e-212, -7.036382982068432e-218, -1.6193909886280205e-223, -2.441388165868217e-229, -2.3807403527972177e-235, -1.4664888542075058e-241, -5.410215261138925e-248, -1.0086357821390763e-254, 0., 4.2895014539794105e-268, 9.785014741804554e-275, 1.1279875188945462e-281, 7.787935174257764e-289, 3.396567071772202e-296, 9.582054002888672e-304}, {-1.3204951852555415e-137, -5.618412917307732e-137, -1.5339397736815695e-136, -2.7862438727853806e-136, -3.386200172110208e-136, -2.7599999524170557e-136, -1.5105804486903948e-136, -5.555583872538382e-137, -1.3736044061858696e-137, -2.2838433731368077e-138, -2.5540371916421698e-139, -1.9213180653465692e-140, -9.723376363359179e-142, -3.3105509184742695e-143, -7.583270675063872e-145, -1.1686487174979284e-146, -1.2116359156600825e-148, -8.450898089886794e-151, -3.965067671254316e-153, -1.2513602651167786e-155, -2.6561793187837124e-158, -3.791635685753867e-161, -3.639415592511949e-164, -2.3485710637477713e-167, -1.0187363295631652e-170, -2.9696868414314468e-174, -5.816181258441242e-178, -7.650864643916534e-182, -6.7572460089217e-186, -4.005206360279083e-190, -1.5923725892546497e-194, -4.243705371620223e-199, -7.574837340581469e-204, -9.046538922206696e-209, -7.219336784592199e-214, -3.8429017998964355e-219, -1.3612570027928793e-224, -3.198138136934662e-230, -4.959259015722555e-236, -5.037566086277422e-242, -3.309910217547102e-248, -1.3737399067622932e-254, -3.414782735825706e-261, -4.2895014539794105e-268, 0., 8.281904132741485e-282, 1.272951172913031e-288, 9.88740449664053e-296, 4.599693488233799e-303, 1.35168681806947e-310}, {-1.540387436043182e-144, -6.557267277293798e-144, -1.7912332952320635e-143, -3.255436508665476e-143, -3.9587781275742786e-143, -3.228710664091239e-143, -1.7682739093840073e-143, -6.507830759881628e-144, -1.6102213023312325e-144, -2.6793252825681356e-145, -2.9987551973972883e-146, -2.2578179045365348e-147, -1.143683161857269e-148, -3.897743228723213e-150, -8.937615479806837e-152, -1.3788972735256833e-153, -1.4313201132933437e-155, -9.99589765759654e-158, -4.6964065945330465e-160, -1.4843638501767372e-162, -3.155809848332231e-165, -4.51268144211487e-168, -4.3397176643000245e-171, -2.806284910601557e-174, -1.2200447552263548e-177, -3.5654283927382917e-181, -7.002348118898368e-185, -9.23971917157939e-189, -8.188857965572123e-193, -4.872796673430641e-197, -1.9459540712535034e-201, -5.212602129009894e-206, -9.35966030390698e-211, -1.1256300697599492e-215, -9.057631683225931e-221, -4.870140008204005e-226, -1.7466959716000903e-231, -4.168826630983147e-237, -6.599153803871883e-243, -6.89487936244572e-249, -4.719009979979973e-255, -2.0891418087143785e-261, -5.842234774005501e-268, -9.785014741804554e-275, -8.281904132741485e-282, 0., 7.259495145406702e-296, 7.51823180353184e-303, 3.93472898946064e-310, 1.2333623e-317}, {-1.2101385607688202e-151, -5.153883543582953e-151, -1.4086008137618978e-150, -2.561414985260097e-150, -3.1165790479426693e-150, -2.5433407191168084e-150, -1.3937872077231573e-150, -5.132971011878171e-151, -1.2709222743225738e-151, -2.1162950511778934e-152, -2.3704293782553443e-153, -1.7861979676134925e-154, -9.055704765941931e-156, -3.089077030576068e-157, -7.090249233456025e-159, -1.0950246682277182e-160, -1.1379196102156983e-162, -7.956339721103393e-165, -3.7429282955165544e-167, -1.1846289348563207e-169, -2.5222940611720428e-172, -3.6125593841479476e-175, -3.4801377341375323e-178, -2.2546984545549313e-181, -9.82269590714483e-185, -2.8770841770295986e-188, -5.664631242837292e-192, -7.495341389235066e-196, -6.66343971607637e-200, -3.978861111061481e-204, -1.595191622753586e-208, -4.292095250919187e-213, -7.746335829273386e-218, -9.371505045727488e-223, -7.593723303356525e-228, -4.117045651557186e-233, -1.4915106545906462e-238, -3.604274903205441e-244, -5.796044995196046e-250, -6.181943227860962e-256, -4.351947952589019e-262, -2.006917335343743e-268, -5.986449081278957e-275, -1.1279875188945462e-281, -1.272951172913031e-288, -7.259495145406702e-296, 0., 2.8889316512077e-310, 2.0159286e-317, 0.}, {-6.402687930834289e-159, -2.7280952448591513e-158, -7.459798190841211e-158, -1.3571987911692073e-157, -1.652253227443061e-157, -1.3491159447628249e-157, -7.397749760923588e-158, -2.726110734808631e-158, -6.754283705221359e-159, -1.1254789738237138e-159, -1.2615531179789535e-160, -9.513566194484624e-162, -4.827148723206232e-163, -1.6480599757226538e-164, -3.786210540190198e-166, -5.853174668430926e-168, -6.088794518830479e-170, -4.262023816520675e-172, -2.0073854448439425e-174, -6.361446811709398e-177, -1.3563301958750116e-179, -1.945483855449839e-182, -1.877173853389094e-185, -1.218291375738646e-188, -5.317593703097917e-192, -1.5607568571011328e-195, -3.0799256978450103e-199, -4.085517829238479e-203, -3.64215870397908e-207, -2.181532364170737e-211, -8.776494721818423e-216, -2.3707042154974935e-220, -4.297727165740017e-225, -5.2260471508057645e-230, -4.259868292828823e-235, -2.3256991843708077e-240, -8.495683842642715e-246, -2.0737418652082594e-251, -3.376475227468183e-257, -3.658442691942379e-263, -2.6291161890255103e-269, -1.247067690142692e-275, -3.8748830817089445e-282, -7.787935174257764e-289, -9.88740449664053e-296, -7.51823180353184e-303, -2.8889316512077e-310, 0., 0., 0.}, {-2.281503556153033e-166, -9.725405276841637e-166, -2.6606041232519614e-165, -4.842963052970991e-165, -5.898868080509924e-165, -4.819214916467492e-165, -2.644069852699363e-165, -9.749339913483961e-166, -2.4170327617826436e-166, -4.030196768668731e-167, -4.520591540488164e-168, -3.4115396388747575e-169, -1.7323394281890133e-170, -5.919295127528317e-172, -1.3610610050581812e-173, -2.1060239225046174e-175, -2.192943571387206e-177, -1.5366118056272022e-179, -7.245391909321838e-182, -2.2988134055872564e-184, -4.907581852566548e-187, -7.04897388328938e-190, -6.811545937123578e-193, -4.427797910131248e-196, -1.9360047179015203e-199, -5.693092772714077e-203, -1.1257746877843138e-206, -1.4967327560288589e-210, -1.3376519122330237e-214, -8.034347472579879e-219, -3.24229505430796e-223, -8.788488014901972e-228, -1.5994674974753235e-232, -1.953639381660349e-237, -1.600621732474942e-242, -8.790700846243645e-248, -3.23366299895965e-253, -7.958940073157402e-259, -1.3089676468552376e-264, -1.436007251349685e-270, -1.0483579200107961e-276, -5.076269504018421e-283, -1.6223617670536115e-289, -3.396567071772202e-296, -4.599693488233799e-303, -3.93472898946064e-310, -2.0159286e-317, 0., 0., 0.}, {-5.47545782320428e-174, -2.3350089398734924e-173, -6.390832981381884e-173, -1.1638409853377617e-172, -1.418292134191128e-172, -1.1593049452098254e-172, -6.3639866906415964e-173, -2.3478903953378463e-173, -5.824297839990358e-174, -9.717595287591514e-175, -1.0907204391158094e-175, -8.237007613185146e-177, -4.185712417254321e-178, -1.4313360950082106e-179, -3.293850561953712e-181, -5.101118945562041e-183, -5.3165339468430015e-185, -3.7289762994421576e-187, -1.7601087178498286e-189, -5.590673772260534e-192, -1.1949361269069532e-194, -1.7185308858048692e-197, -1.6629273613777126e-200, -1.0825757719465779e-203, -4.7410261567824145e-207, -1.3965897161786111e-210, -2.766902195326973e-214, -3.6862503135036226e-218, -3.301943113616156e-222, -1.9882188096605873e-226, -8.045829085670159e-231, -2.1876352951221563e-235, -3.9952276540352646e-240, -4.899032244858052e-245, -4.031708327714158e-250, -2.2255910051661516e-255, -8.2355770868063e-261, -2.0411784223533076e-266, -3.3850007612299776e-272, -3.751036555934338e-278, -2.772676975650603e-284, -1.363872558124998e-290, -4.449709570701008e-297, -9.582054002888672e-304, -1.35168681806947e-310, -1.2333623e-317, 0., 0., 0., 0.}}, {{0., 0.0001320753182070418, 0.001104926184038433, 0.004590270920175964, 0.011331568322283748, 0.017588542342832518, 0.017605007686923038, 0.01151825296707982, 0.004965920441601048, 0.001418243553186662, 0.0002692752190747953, 0.00003407599921649017, 2.8795842659619676e-6, 1.6272910295420678e-7, 6.1566074840071295e-9, 1.5607903355354983e-10, 2.653297960348241e-12, 3.0263614756090665e-14, 2.317182514542335e-16, 1.1914655600380696e-18, 4.11561267615466e-21, 9.553165382100921e-24, 1.4904935710367624e-26, 1.563430126230051e-29, 1.1027467258446202e-32, 5.2311261484508185e-36, 1.6691728606504403e-39, 3.5830381600590628e-43, 5.174836133865397e-47, 5.029010109635046e-51, 3.288896477918161e-55, 1.4475604424989392e-59, 4.2882047841601065e-64, 8.550608996258112e-69, 1.1477016108820136e-73, 1.0370426972160365e-78, 6.308456922986608e-84, 2.583626670886023e-89, 7.124199075425269e-95, 1.3226959996920227e-100, 1.6535540947413274e-106, 1.391959446230492e-112, 7.890397586436123e-119, 3.011956063290101e-125, 7.742624763018906e-132, 1.3403838512865485e-138, 1.5627242631291488e-145, 1.2270374557989243e-152, 6.488809840381221e-160, 2.3110690275446552e-167}, {-0.0001320753182070418, 0., 0.0035600370026563884, 0.019664146220354926, 0.054532883278881936, 0.09020959442508557, 0.0940021519766721, 0.06323300168749552, 0.027821307895870683, 0.008069814613878065, 0.001551031256006702, 0.00019822988889280646, 0.00001688874645825113, 9.609726698257943e-7, 3.656986117933765e-8, 9.317770358794907e-10, 1.590950137704929e-11, 1.8216436758390346e-13, 1.3995344847592512e-15, 7.218140127230692e-18, 2.5001333951849668e-20, 5.817617088070888e-23, 9.096986352980909e-26, 9.561570851942898e-29, 6.756700097940508e-32, 3.2106734345402503e-35, 1.0260914927776655e-38, 2.205811468324043e-42, 3.1900664982448874e-46, 3.104063944827669e-50, 2.0323869547152753e-54, 8.955041702305055e-59, 2.6555285658660336e-63, 5.3001686776038915e-68, 7.120555890478664e-73, 6.439483873849101e-78, 3.9203627236549756e-83, 1.606802285740128e-88, 4.433847139411345e-94, 8.23759590900367e-100, 1.0304801813206347e-105, 8.67990036964791e-112, 4.923127663024993e-118, 1.8803250680821538e-124, 4.836191335285496e-131, 8.376546900423437e-138, 9.770776274740684e-145, 7.6754940210584e-152, 4.060755759877818e-159, 1.4469051746828828e-166}, {-0.001104926184038433, -0.0035600370026563884, 0., 0.040778972110016604, 0.15077766512946722, 0.28059051359163173, 0.3118747759737959, 0.21852979711057383, 0.09889532140683371, 0.029282912141265435, 0.0057175353689883045, 0.0007398625111038053, 0.0000636711821131764, 3.653084040679285e-6, 1.399901734919187e-7, 3.5880868300964334e-9, 6.157839207955195e-11, 7.082215848218116e-13, 5.462464585369136e-15, 2.827061555631654e-17, 9.822346279142885e-20, 2.2919310474771355e-22, 3.592863690623736e-25, 3.784931932980282e-28, 2.6801644360193198e-31, 1.275981692638046e-34, 4.0849694715013104e-38, 8.795617689964026e-42, 1.2739149249465516e-45, 1.2412730433830075e-49, 8.13761618010052e-54, 3.5898390263369354e-58, 1.065714846147954e-62, 2.1292749831606372e-67, 2.863387722164905e-72, 2.591887731149848e-77, 1.5793090223528073e-82, 6.478252521075772e-88, 1.7890038806305013e-93, 3.326199604024594e-99, 4.163784464970606e-105, 3.5095293514455204e-111, 1.9918043436231294e-117, 7.611966507497056e-124, 1.958906029601903e-130, 3.394767436207917e-137, 3.961853292263948e-144, 3.113795695393657e-151, 1.648146740911673e-158, 5.875240722389862e-166}, {-0.004590270920175964, -0.019664146220354926, -0.040778972110016604, 0., 0.2081773664173256, 0.5165447299625582, 0.6459034166597524, 0.4827548338282502, 0.22757283738864448, 0.06930959449219176, 0.013814741573943851, 0.001816035475459569, 0.00015823816266006264, 9.170494858757877e-6, 3.543519044653913e-7, 9.145903341781927e-9, 1.5789537932000704e-10, 1.825289211981818e-12, 1.4141180153925562e-14, 7.347372594979834e-17, 2.561635831268298e-19, 5.995786765843895e-22, 9.425189024679017e-25, 9.953927958569156e-28, 7.064538054168145e-31, 3.370272366671738e-34, 1.0810135006536762e-37, 2.33164958524629e-41, 3.382460932668305e-45, 3.300673816681396e-49, 2.166848924602947e-53, 9.571074658428612e-58, 2.844745721412259e-62, 5.690062077686345e-67, 7.659802363657434e-72, 6.940294717211943e-77, 4.232800758677488e-82, 1.7377785451147605e-87, 4.802888565744968e-93, 8.936650367735593e-99, 1.119520497834334e-104, 9.442642533549312e-111, 5.3626193420583395e-117, 2.0506837109924753e-123, 5.280485406743974e-130, 9.156226742111968e-137, 1.0691529636963255e-143, 8.407288511514243e-151, 4.452216060197427e-158, 1.5878567227937894e-165}, {-0.011331568322283748, -0.054532883278881936, -0.15077766512946722, -0.2081773664173256, 0., 0.47747192118931153, 0.7960607604650931, 0.6693569655153488, 0.33657379763887685, 0.1067780542936916, 0.02189101336257233, 0.002937665014860705, 0.0002600330793688017, 0.00001525826561583891, 5.955414246857461e-7, 1.5499151937972863e-8, 2.694493894457098e-10, 3.1334076017361955e-12, 2.440014014010899e-14, 1.2734245825403597e-16, 4.457161181433308e-19, 1.0468693486007437e-21, 1.65074070949707e-24, 1.7481874056560636e-27, 1.2438395401469018e-30, 5.947459618959967e-34, 1.911594847080848e-37, 4.1309483534312276e-41, 6.00307695455959e-45, 5.867311652961558e-49, 3.8575192770112956e-53, 1.7062250944815106e-57, 5.077774083662933e-62, 1.0168657881416783e-66, 1.3703989379766147e-71, 1.2429667660184528e-76, 7.588112360563729e-82, 3.118166792410573e-87, 8.625479977549767e-93, 1.6062391200402165e-98, 2.013736836764785e-104, 1.6997363598144085e-110, 9.659749138278682e-117, 3.6963508392770205e-123, 9.524010586381095e-130, 1.65242209461443e-136, 1.9305922883110645e-143, 1.5189434955255e-150, 8.04796877495546e-158, 2.8716789339747986e-165}, {-0.017588542342832518, -0.09020959442508557, -0.28059051359163173, -0.5165447299625582, -0.47747192118931153, 0., 0.4938108645628554, 0.5536189500939427, 0.3131742064826196, 0.10597816833649427, 0.022632318138211083, 0.0031239199803419567, 0.000282280625624403, 0.000016826626996234, 6.64965179337158e-7, 1.7480734219402766e-8, 3.064312566577958e-10, 3.588386430217594e-12, 2.8109431128124606e-14, 1.4745327579885002e-16, 5.184107934945006e-19, 1.2223848670274007e-21, 1.9341925101482326e-24, 2.0547136711551546e-27, 1.4659946416377965e-30, 7.0272697083708584e-34, 2.2637938946242673e-37, 4.902177466587777e-41, 7.137315982708365e-45, 6.988030783321522e-49, 4.6017093538957955e-53, 2.0384043063211282e-57, 6.074681699179731e-62, 1.218058337060263e-66, 1.6434942001410486e-71, 1.4923252831334644e-76, 9.119896041674673e-82, 3.7512827482931937e-87, 1.0386344261469728e-92, 1.9358223107723176e-98, 2.4289170160645563e-104, 2.051760953550796e-110, 1.1668859069957418e-116, 4.4682410527631936e-123, 1.1520435702528909e-129, 2.0000531972913273e-136, 2.3381348366005446e-143, 1.840631594877167e-150, 9.757677968324217e-158, 3.483537293048926e-165}, {-0.017605007686923038, -0.0940021519766721, -0.3118747759737959, -0.6459034166597524, -0.7960607604650931, -0.4938108645628554, 0., 0.2307540520978242, 0.1740456250544628, 0.0662591800010713, 0.015093411431425337, 0.002170136438217624, 0.00020169849887966725, 0.000012273643511015719, 4.927365361147621e-7, 1.3115068509382925e-8, 2.32224887635218e-10, 2.742073105323734e-12, 2.1630090406843325e-14, 1.1414006780496897e-16, 4.0334733898672164e-19, 9.553172625812172e-22, 1.5175364904889406e-24, 1.6176930184060637e-27, 1.157763013970725e-30, 5.56517226191857e-34, 1.7972809438142645e-37, 3.900803086964905e-41, 5.691125377880942e-45, 5.5826421224440745e-49, 3.6826360680497994e-53, 1.633899625421633e-57, 4.876424391458158e-62, 9.791341675965208e-67, 1.3228073325291506e-71, 1.2025651790618762e-76, 7.357289292274944e-82, 3.029422869750091e-87, 8.395897660890842e-93, 1.5662781811633503e-98, 1.966943723540346e-104, 1.6628791524110492e-110, 9.464497389292279e-117, 3.626795817478866e-123, 9.357423350359209e-130, 1.6256032063806185e-136, 1.901577681936394e-143, 1.4978551715146e-150, 7.945032905082505e-158, 2.837949268524104e-165}, {-0.01151825296707982, -0.06323300168749552, -0.21852979711057383, -0.4827548338282502, -0.6693569655153488, -0.5536189500939427, -0.2307540520978242, 0., 0.048781306328760154, 0.024761395032390745, 0.006345545827583677, 0.0009731893262794285, 0.00009421970299283186, 5.897215879310704e-6, 2.416813454811788e-7, 6.5348910592704616e-9, 1.1715790086209098e-10, 1.3973546835496475e-12, 1.1114503953558903e-14, 5.906039277198489e-17, 2.0994948982074006e-19, 4.998097375716697e-22, 7.975000705753809e-25, 8.534684737596996e-28, 6.129377906830678e-31, 2.9554106016609454e-34, 9.571056628286876e-38, 2.0825001408612167e-41, 3.0451947908722324e-45, 2.9933323813165865e-49, 1.9783162009785064e-53, 8.792591918201701e-58, 2.628381892063722e-62, 5.285329903155222e-67, 7.150273225399934e-72, 6.508620785514939e-77, 3.986712218132528e-82, 1.6433867135076196e-87, 4.559310426056608e-93, 8.513835357405433e-99, 1.0701564371651431e-104, 9.055071255242751e-111, 5.158024613999801e-117, 1.9780815573337082e-123, 5.1073393712227545e-130, 8.878791297711392e-137, 1.0392953835743616e-143, 8.191553437521014e-151, 4.347609984275376e-158, 1.5538381261305658e-165}, {-0.004965920441601048, -0.027821307895870683, -0.09889532140683371, -0.22757283738864448, -0.33657379763887685, -0.3131742064826196, -0.1740456250544628, -0.048781306328760154, 0., 0.004669053952090314, 0.0015953703085357048, 0.0002752595399443267, 0.000028425983337238984, 1.8533163601113225e-6, 7.812321719510521e-8, 2.1564042757685366e-9, 3.92737922577152e-11, 4.742779604499943e-13, 3.810493093051724e-15, 2.0416982155465103e-17, 7.30863875732294e-20, 1.7502650024849613e-22, 2.8070573525269207e-25, 3.0174670680757684e-28, 2.175560871062807e-31, 1.052635524141189e-34, 3.4194996938856384e-38, 7.460920699490173e-42, 1.0937285741321133e-45, 1.077544803840822e-49, 7.136320256338807e-54, 3.177732170700876e-58, 9.515759973056364e-63, 1.916560532429538e-67, 2.59666545552387e-72, 2.3668922131200543e-77, 1.4516392416778156e-82, 5.991013440205835e-88, 1.663958546897972e-93, 3.110432221455907e-99, 3.913515748998716e-105, 3.314443912744236e-111, 1.8896355995960157e-117, 7.252596509967236e-124, 1.8740417964345823e-130, 3.2602864153592103e-137, 3.818930607666477e-144, 3.011997892578802e-151, 1.5995966697687409e-158, 5.720369981911968e-166}, {-0.001418243553186662, -0.008069814613878065, -0.029282912141265435, -0.06930959449219176, -0.1067780542936916, -0.10597816833649427, -0.0662591800010713, -0.024761395032390745, -0.004669053952090314, 0., 0.00020245252436643655, 0.00004657392156919471, 5.4108867891972845e-6, 3.762974136316071e-7, 1.6523063065833742e-8, 4.691104219483173e-10, 8.721728803390936e-12, 1.0699712490237796e-13, 8.703929708075476e-16, 4.710755359604212e-18, 1.7003550774433663e-20, 4.100467645960357e-23, 6.615433216134897e-26, 7.14777712817722e-29, 5.176475971240607e-32, 2.5144370685746594e-35, 8.196542070437565e-39, 1.79391976562663e-42, 2.6370893846907047e-46, 2.6045801402832983e-50, 1.7288711706456427e-54, 7.714429639797713e-59, 2.3144710877139548e-63, 4.669662149067725e-68, 6.336863437251856e-73, 5.784685489296278e-78, 3.5526802322570326e-83, 1.468087747783865e-88, 4.0823565485240936e-94, 7.639624097568423e-100, 9.62211378413997e-106, 8.15714908027221e-112, 4.65484015267201e-118, 1.7881175931967915e-124, 4.624198868482241e-131, 8.050970178288848e-138, 9.437383018565186e-145, 7.448440281361186e-152, 3.9582825689988023e-159, 1.4164196413827982e-166}, {-0.0002692752190747953, -0.001551031256006702, -0.0057175353689883045, -0.013814741573943851, -0.02189101336257233, -0.022632318138211083, -0.015093411431425337, -0.006345545827583677, -0.0015953703085357048, -0.00020245252436643655, 0., 3.978463966468995e-6, 6.162824571395075e-7, 4.82164369147425e-8, 2.2583079563252984e-9, 6.678769459870488e-11, 1.2771985179874273e-12, 1.599494599758037e-14, 1.321799154492649e-16, 7.24328673189892e-19, 2.640885393638775e-21, 6.421662040339123e-24, 1.0432749997110861e-26, 1.1339370256599774e-29, 8.254173552750061e-33, 4.027306324104536e-36, 1.317966436886182e-39, 2.8945566149678297e-43, 4.2682158263571895e-47, 4.2273085419605906e-51, 2.8130402771642496e-55, 1.2580649222960959e-59, 3.782241206919912e-64, 7.645478508559786e-69, 1.0393173997925894e-73, 9.502743992410023e-79, 5.844782041064924e-84, 2.418579481504927e-89, 6.734007308606917e-95, 1.2616861923286852e-100, 1.590862578899454e-106, 1.3500589497543015e-112, 7.711581050015037e-119, 2.9650615711618026e-125, 7.674498276835785e-132, 1.3372616148679147e-138, 1.5687544659438974e-145, 1.2390421618078166e-152, 6.589134923937895e-160, 2.35938695171354e-167}, {-0.00003407599921649017, -0.00019822988889280646, -0.0007398625111038053, -0.001816035475459569, -0.002937665014860705, -0.0031239199803419567, -0.002170136438217624, -0.0009731893262794285, -0.0002752595399443267, -0.00004657392156919471, -3.978463966468995e-6, 0., 3.544373046608018e-8, 3.697374743767387e-9, 1.9482022630885703e-10, 6.1457664897224545e-12, 1.2242405923559598e-13, 1.5769778887866943e-15, 1.3303414973755847e-17, 7.405813491014435e-20, 2.7338940480818126e-22, 6.714974628487008e-25, 1.1000181602261618e-27, 1.2039721623115685e-30, 8.81614101746212e-34, 4.323555678799712e-37, 1.421232868077548e-40, 3.133593986976353e-44, 4.6367363655960014e-48, 4.606514757715801e-52, 3.073896010117767e-56, 1.3781718337913418e-60, 4.152746790929106e-65, 8.411803754636659e-70, 1.145656458988727e-74, 1.049324656702806e-79, 6.46434604334719e-85, 2.6789188827589725e-90, 7.469111311150092e-96, 1.4012028086922108e-101, 1.7688826611391705e-107, 1.502802498999684e-113, 8.592998944889588e-120, 3.307191705770407e-126, 8.567904779190478e-133, 1.4942279881954104e-139, 1.7543253309493009e-146, 1.386680718703117e-153, 7.379656436748949e-161, 2.6442820587995058e-168}, {-2.8795842659619676e-6, -0.00001688874645825113, -0.0000636711821131764, -0.00015823816266006264, -0.0002600330793688017, -0.000282280625624403, -0.00020169849887966725, -0.00009421970299283186, -0.000028425983337238984, -5.4108867891972845e-6, -6.162824571395075e-7, -3.544373046608018e-8, 0., 1.4318510933233807e-10, 1.0059517842565587e-11, 3.570028632796701e-13, 7.585621051198597e-15, 1.0178381828044795e-16, 8.831830580278654e-19, 5.018976987221258e-21, 1.8821903301945162e-23, 4.6808127316177204e-26, 7.745358971747893e-29, 8.547955752600651e-32, 6.303050734216798e-35, 3.1095013783651556e-38, 1.027392521404924e-41, 2.2753509012612936e-45, 3.380008914562263e-49, 3.369638130321492e-53, 2.255498051331483e-57, 1.0140546385305657e-61, 3.063236534264537e-66, 6.218993843653504e-71, 8.487575168701564e-76, 7.788626053329541e-81, 4.8065139876743204e-86, 1.9950813321455368e-91, 5.570740089980814e-97, 1.046504530552295e-102, 1.3227977246568975e-108, 1.1251567568980739e-114, 6.440783487068625e-121, 2.481449643752524e-127, 6.434948129650592e-134, 1.1232754587147482e-140, 1.3199436401125358e-147, 1.0441824782110088e-154, 5.561235687555555e-162, 1.994161313100448e-169}, {-1.6272910295420678e-7, -9.609726698257943e-7, -3.653084040679285e-6, -9.170494858757877e-6, -0.00001525826561583891, -0.000016826626996234, -0.000012273643511015719, -5.897215879310704e-6, -1.8533163601113225e-6, -3.762974136316071e-7, -4.82164369147425e-8, -3.697374743767387e-9, -1.4318510933233807e-10, 0., 2.62344050107635e-13, 1.2413792724274277e-14, 2.9674024843405926e-16, 4.247102819997912e-18, 3.8387827338515904e-20, 2.243842988156854e-22, 8.590048981897957e-25, 2.1701651913055454e-27, 3.6358680139302934e-30, 4.053158895023111e-33, 3.013604747066206e-36, 1.4971065027766992e-39, 4.975947230616518e-43, 1.107666977381343e-46, 1.652772855127762e-50, 1.6541632749553486e-54, 1.1110738387227111e-58, 5.010768163924231e-63, 1.5178476679357306e-67, 3.0892629591430377e-72, 4.2257548327645844e-77, 3.8857937659521776e-82, 2.4025412567544874e-87, 9.989779155504333e-93, 2.7938533516498585e-98, 5.2562346638183944e-104, 6.653087287759401e-110, 5.666268048207682e-116, 3.2474277141933405e-122, 1.2525327110396455e-128, 3.2514779665977127e-135, 5.68128215143923e-142, 6.682122913812317e-149, 5.290677913971e-156, 2.82007652878455e-163, 1.0120107195095772e-170}, {-6.1566074840071295e-9, -3.656986117933765e-8, -1.399901734919187e-7, -3.543519044653913e-7, -5.955414246857461e-7, -6.64965179337158e-7, -4.927365361147621e-7, -2.416813454811788e-7, -7.812321719510521e-8, -1.6523063065833742e-8, -2.2583079563252984e-9, -1.9482022630885703e-10, -1.0059517842565587e-11, -2.62344050107635e-13, 0., 2.1803379203682453e-16, 6.949195200648314e-18, 1.1189311199030487e-19, 1.0787798699174191e-21, 6.568414213522585e-24, 2.5864147288034544e-26, 6.670373623143276e-29, 1.13528500367709e-31, 1.281402164373909e-34, 9.623718703239033e-38, 4.820737124784493e-41, 1.613477724479253e-44, 3.613048897459946e-48, 5.418751839198208e-52, 5.447521652387242e-56, 3.673358348226829e-60, 1.6623789841479942e-64, 5.051221417684274e-69, 1.0309267214532516e-73, 1.4137229617933297e-78, 1.302943774815376e-83, 8.072629360318806e-89, 3.3629607286468616e-94, 9.421588969909234e-100, 1.7753775377775127e-105, 2.2505160748666463e-111, 1.9193410962068835e-117, 1.1014095563614968e-123, 4.253193426813347e-130, 1.1053242301413869e-136, 1.9333362231282268e-143, 2.2761444107971226e-150, 1.8038302276517076e-157, 9.623234765259357e-165, 3.456208790413128e-172}, {-1.5607903355354983e-10, -9.317770358794907e-10, -3.5880868300964334e-9, -9.145903341781927e-9, -1.5499151937972863e-8, -1.7480734219402766e-8, -1.3115068509382925e-8, -6.5348910592704616e-9, -2.1564042757685366e-9, -4.691104219483173e-10, -6.678769459870488e-11, -6.1457664897224545e-12, -3.570028632796701e-13, -1.2413792724274277e-14, -2.1803379203682453e-16, 0., 8.22068089460924e-20, 1.7648807598924194e-21, 1.9142443427028383e-23, 1.2432366206192587e-25, 5.099413081346667e-28, 1.3527160587762597e-30, 2.35026173144329e-33, 2.6948599848087973e-36, 2.0492205608006796e-39, 1.0368693570823898e-42, 3.499271889904946e-46, 7.890690476113389e-50, 1.1904683504493218e-53, 1.2029262905763222e-57, 8.147752883718216e-62, 3.701726910307479e-66, 1.1286936903646539e-70, 2.3107341126053994e-75, 3.1775412134459967e-80, 2.935889131141136e-85, 1.8231185165341259e-90, 7.610617854018216e-96, 2.1362103892681333e-101, 4.0324150675743904e-107, 5.119788906784601e-113, 4.3728544399267776e-119, 2.512799564385524e-125, 9.715797229796249e-132, 2.527957152280534e-138, 4.426599430932884e-145, 5.216927520555199e-152, 4.1384239021653636e-159, 2.2098326128867907e-166, 7.9435405726923945e-174}, {-2.653297960348241e-12, -1.590950137704929e-11, -6.157839207955195e-11, -1.5789537932000704e-10, -2.694493894457098e-10, -3.064312566577958e-10, -2.32224887635218e-10, -1.1715790086209098e-10, -3.92737922577152e-11, -8.721728803390936e-12, -1.2771985179874273e-12, -1.2242405923559598e-13, -7.585621051198597e-15, -2.9674024843405926e-16, -6.949195200648314e-18, -8.22068089460924e-20, 0., 1.406261478070513e-23, 2.0336996809699496e-25, 1.4859211518148112e-27, 6.501160499934329e-30, 1.7964126599506336e-32, 3.2103334714126717e-35, 3.757724756944647e-38, 2.9027984970494463e-41, 1.4871242533926505e-44, 5.069506802743677e-48, 1.1526757439289915e-51, 1.7512028480010713e-55, 1.780061637177857e-59, 1.2118680410245212e-63, 5.530397656248428e-68, 1.6928865940105646e-72, 3.477819989122699e-77, 4.7972329015356353e-82, 4.444715460321849e-87, 2.7669818489097572e-92, 1.1577032082045409e-97, 3.2562637535096747e-103, 6.158323947700793e-109, 7.832564778219565e-115, 6.700579882947272e-121, 3.856098679638648e-127, 1.4930174460935048e-133, 3.8896493290215107e-140, 6.819109656999429e-147, 8.045537644824367e-154, 6.388919212691625e-161, 3.414885325913514e-168, 1.2286547054254313e-175}, {-3.0263614756090665e-14, -1.8216436758390346e-13, -7.082215848218116e-13, -1.825289211981818e-12, -3.1334076017361955e-12, -3.588386430217594e-12, -2.742073105323734e-12, -1.3973546835496475e-12, -4.742779604499943e-13, -1.0699712490237796e-13, -1.599494599758037e-14, -1.5769778887866943e-15, -1.0178381828044795e-16, -4.247102819997912e-18, -1.1189311199030487e-19, -1.7648807598924194e-21, -1.406261478070513e-23, 0., 1.0915268103573023e-27, 1.0633643308365716e-29, 5.233951982081561e-32, 1.542672282756082e-34, 2.8717490320916746e-37, 3.4574488117359634e-40, 2.7264813113387367e-43, 1.418967069370488e-46, 4.897628079540123e-50, 1.12484336701078e-53, 1.7231594914914954e-57, 1.763804787061965e-61, 1.2079479796652661e-65, 5.540777607304392e-70, 1.7036356709410575e-74, 3.513627707463504e-79, 4.863453887152291e-84, 4.520020978487749e-89, 2.82167829902567e-94, 1.1835470310273133e-99, 3.336520299700653e-105, 6.323171452585588e-111, 8.057460260463825e-117, 6.904960599041744e-123, 3.98008532429309e-129, 1.5433060153513998e-135, 4.026185354334814e-142, 7.067491426987555e-149, 8.348518175420832e-156, 6.636888782561618e-163, 3.55112060653204e-170, 1.278920265788832e-177}, {-2.317182514542335e-16, -1.3995344847592512e-15, -5.462464585369136e-15, -1.4141180153925562e-14, -2.440014014010899e-14, -2.8109431128124606e-14, -2.1630090406843325e-14, -1.1114503953558903e-14, -3.810493093051724e-15, -8.703929708075476e-16, -1.321799154492649e-16, -1.3303414973755847e-17, -8.831830580278654e-19, -3.8387827338515904e-20, -1.0787798699174191e-21, -1.9142443427028383e-23, -2.0336996809699496e-25, -1.0915268103573023e-27, 0., 3.8445263098302754e-32, 2.5230695339285914e-34, 8.366150725362067e-37, 1.6612202443044535e-39, 2.083364490129335e-42, 1.689843478971134e-45, 8.977824558681794e-49, 3.147922446443343e-52, 7.320239760079148e-56, 1.1327225227878206e-59, 1.1691028000914973e-63, 8.062632598283022e-68, 3.7202898750709466e-72, 1.1497521914937877e-76, 2.381868407991606e-81, 3.309837013771908e-86, 3.086793743744617e-91, 1.932934541022121e-96, 8.130174558930292e-102, 2.2977100140251775e-107, 4.3643775825259566e-113, 5.572932227795412e-119, 4.784852379968363e-125, 2.762831253381059e-131, 1.0730240455617705e-137, 2.803458251967876e-144, 4.9278986554118606e-151, 5.828545284555849e-158, 4.639081772203467e-165, 2.484938975825709e-172, 8.958719303083034e-180}, {-1.1914655600380696e-18, -7.218140127230692e-18, -2.827061555631654e-17, -7.347372594979834e-17, -1.2734245825403597e-16, -1.4745327579885002e-16, -1.1414006780496897e-16, -5.906039277198489e-17, -2.0416982155465103e-17, -4.710755359604212e-18, -7.24328673189892e-19, -7.405813491014435e-20, -5.018976987221258e-21, -2.243842988156854e-22, -6.568414213522585e-24, -1.2432366206192587e-25, -1.4859211518148112e-27, -1.0633643308365716e-29, -3.8445263098302754e-32, 0., 6.144929563667515e-37, 2.71676523298602e-39, 6.068846649121911e-42, 8.118446440027874e-45, 6.859349304662205e-48, 3.7483661733365047e-51, 1.341682523173856e-54, 3.1694979017476845e-58, 4.965737187738667e-62, 5.176994466925195e-66, 3.6000289609364824e-70, 1.6727550870740342e-74, 5.200405967307725e-79, 1.08285978700665e-83, 1.5114562126122252e-88, 1.4151300653474442e-93, 8.892241488773221e-99, 3.751772188165398e-104, 1.0632527327407324e-109, 2.0246534720792915e-115, 2.591182851573649e-121, 2.2293644617346025e-127, 1.2896998215221933e-133, 5.017626987900404e-140, 1.3130414592048184e-146, 2.3114741283919743e-153, 2.73768573575764e-160, 2.1817739223630857e-167, 1.1700654523192759e-174, 4.2230203629779647e-182}, {-4.11561267615466e-21, -2.5001333951849668e-20, -9.822346279142885e-20, -2.561635831268298e-19, -4.457161181433308e-19, -5.184107934945006e-19, -4.0334733898672164e-19, -2.0994948982074006e-19, -7.30863875732294e-20, -1.7003550774433663e-20, -2.640885393638775e-21, -2.7338940480818126e-22, -1.8821903301945162e-23, -8.590048981897957e-25, -2.5864147288034544e-26, -5.099413081346667e-28, -6.501160499934329e-30, -5.233951982081561e-32, -2.5230695339285914e-34, -6.144929563667515e-37, 0., 4.4573681110313745e-42, 1.3276123725422062e-44, 1.997977438399587e-47, 1.8006499483606357e-50, 1.0249841519022913e-53, 3.7736303798639316e-57, 9.100283208674822e-61, 1.4483969273225164e-64, 1.5288912557413663e-68, 1.073914474359218e-72, 5.031531372540724e-77, 1.5751848575696766e-81, 3.299468064937115e-86, 4.6290165466516627e-91, 4.353354369970166e-96, 2.7462413135013007e-101, 1.1627042567705137e-106, 3.3053069612332515e-112, 6.3114725020205995e-118, 8.097764609891757e-124, 6.982871886755169e-130, 4.047994102118415e-136, 1.5778704882783218e-142, 4.136243128669121e-149, 7.293098583304905e-156, 8.650666381532949e-163, 6.90354032334074e-170, 3.7070340607604044e-177, 1.339541908195639e-184}, {-9.553165382100921e-24, -5.817617088070888e-23, -2.2919310474771355e-22, -5.995786765843895e-22, -1.0468693486007437e-21, -1.2223848670274007e-21, -9.553172625812172e-22, -4.998097375716697e-22, -1.7502650024849613e-22, -4.100467645960357e-23, -6.421662040339123e-24, -6.714974628487008e-25, -4.6808127316177204e-26, -2.1701651913055454e-27, -6.670373623143276e-29, -1.3527160587762597e-30, -1.7964126599506336e-32, -1.542672282756082e-34, -8.366150725362067e-37, -2.71676523298602e-39, -4.4573681110313745e-42, 0., 1.4673931976089547e-47, 2.944452324307749e-50, 2.9853534888798784e-53, 1.812643272407394e-56, 6.951576710476398e-60, 1.7243019706965254e-63, 2.801565972462047e-67, 3.0042030339024138e-71, 2.1365714034795547e-75, 1.0111432937563852e-79, 3.1918918906065213e-84, 6.732665362526838e-89, 9.501873753061264e-94, 8.981854251991057e-99, 5.691348486439108e-104, 2.41905381420435e-109, 6.90070434136729e-115, 1.321766694955258e-120, 1.7005678317923537e-126, 1.4701105057643397e-132, 8.5416484083818e-139, 3.3363484651463475e-145, 8.762496530896391e-152, 1.5477062029686956e-158, 1.8387446843531428e-165, 1.469557744215786e-172, 7.902008913969287e-180, 2.859048645380551e-187}, {-1.4904935710367624e-26, -9.096986352980909e-26, -3.592863690623736e-25, -9.425189024679017e-25, -1.65074070949707e-24, -1.9341925101482326e-24, -1.5175364904889406e-24, -7.975000705753809e-25, -2.8070573525269207e-25, -6.615433216134897e-26, -1.0432749997110861e-26, -1.1000181602261618e-27, -7.745358971747893e-29, -3.6358680139302934e-30, -1.13528500367709e-31, -2.35026173144329e-33, -3.2103334714126717e-35, -2.8717490320916746e-37, -1.6612202443044535e-39, -6.068846649121911e-42, -1.3276123725422062e-44, -1.4673931976089547e-47, 0., 2.192488503718797e-53, 2.9639255942986597e-56, 2.0245867983432776e-59, 8.282016669580605e-63, 2.139906866257157e-66, 3.576159314726741e-70, 3.914714794500627e-74, 2.828314386848128e-78, 1.3552456095039644e-82, 4.321338450923422e-87, 9.190968165993258e-92, 1.3062007937628144e-96, 1.2420643990199137e-101, 7.910696978099794e-107, 3.3773774542905066e-112, 9.672244707054631e-118, 1.859062602772069e-123, 2.3992508510767353e-129, 2.0798709075041384e-135, 1.2114770341940423e-141, 4.742756325197933e-148, 1.2482037919060257e-154, 2.2088585787240062e-161, 2.628787354782164e-168, 2.104340967657085e-175, 1.1332086810508334e-182, 4.1057270248325986e-190}, {-1.563430126230051e-29, -9.561570851942898e-29, -3.784931932980282e-28, -9.953927958569156e-28, -1.7481874056560636e-27, -2.0547136711551546e-27, -1.6176930184060637e-27, -8.534684737596996e-28, -3.0174670680757684e-28, -7.14777712817722e-29, -1.1339370256599774e-29, -1.2039721623115685e-30, -8.547955752600651e-32, -4.053158895023111e-33, -1.281402164373909e-34, -2.6948599848087973e-36, -3.757724756944647e-38, -3.4574488117359634e-40, -2.083364490129335e-42, -8.118446440027874e-45, -1.997977438399587e-47, -2.944452324307749e-50, -2.192488503718797e-53, 0., 1.4868437477133529e-59, 1.3541699466006094e-62, 6.231970563284759e-66, 1.7175638421712543e-69, 2.9899480428683e-73, 3.3665213039358747e-77, 2.4829259374116943e-81, 1.2086304070568657e-85, 3.902013979623018e-90, 8.382944797833013e-95, 1.201294287953954e-99, 1.1502971326483494e-104, 7.369840608847531e-110, 3.162601016136676e-115, 9.097594628830853e-121, 1.7554687609806588e-126, 2.2734222357629553e-132, 1.9768936843260072e-138, 1.1546937645073765e-144, 4.5317875549353914e-151, 1.1953914386130863e-157, 2.119779977252426e-164, 2.527551893537697e-171, 2.026820894669611e-178, 1.093212485544879e-185, 3.966684733278271e-193}, {-1.1027467258446202e-32, -6.756700097940508e-32, -2.6801644360193198e-31, -7.064538054168145e-31, -1.2438395401469018e-30, -1.4659946416377965e-30, -1.157763013970725e-30, -6.129377906830678e-31, -2.175560871062807e-31, -5.176475971240607e-32, -8.254173552750061e-33, -8.81614101746212e-34, -6.303050734216798e-35, -3.013604747066206e-36, -9.623718703239033e-38, -2.0492205608006796e-39, -2.9027984970494463e-41, -2.7264813113387367e-43, -1.689843478971134e-45, -6.859349304662205e-48, -1.8006499483606357e-50, -2.9853534888798784e-53, -2.9639255942986597e-56, -1.4868437477133529e-59, 0., 4.576602063080164e-66, 2.8082392867139655e-69, 8.7071119580878e-73, 1.6167899653474588e-76, 1.896269664881331e-80, 1.4385234707685222e-84, 7.14827983708106e-89, 2.344424628584641e-93, 5.099634990051725e-98, 7.381705309477987e-103, 7.127241141352509e-108, 4.5982858507226514e-113, 1.9849962895225057e-118, 5.739358257324735e-124, 1.112408652992317e-129, 1.446275872702508e-135, 1.2620010224065833e-141, 7.394106494337537e-148, 2.9100009063340323e-154, 7.695216067867876e-161, 1.3676890694821648e-167, 1.6341612280162572e-174, 1.3129008927846834e-181, 7.0937485920695716e-189, 2.5780677249617564e-196}, {-5.2311261484508185e-36, -3.2106734345402503e-35, -1.275981692638046e-34, -3.370272366671738e-34, -5.947459618959967e-34, -7.0272697083708584e-34, -5.56517226191857e-34, -2.9554106016609454e-34, -1.052635524141189e-34, -2.5144370685746594e-35, -4.027306324104536e-36, -4.323555678799712e-37, -3.1095013783651556e-38, -1.4971065027766992e-39, -4.820737124784493e-41, -1.0368693570823898e-42, -1.4871242533926505e-44, -1.418967069370488e-46, -8.977824558681794e-49, -3.7483661733365047e-51, -1.0249841519022913e-53, -1.812643272407394e-56, -2.0245867983432776e-59, -1.3541699466006094e-62, -4.576602063080164e-66, 0., 6.394137330805e-73, 2.6433867834605493e-76, 5.5219530912531286e-80, 6.908248145864391e-84, 5.459005736677134e-88, 2.790182436593331e-92, 9.341619476186932e-97, 2.0642600819596613e-101, 3.0253599781810897e-106, 2.9505746868884405e-111, 1.9194873273094518e-116, 8.344021944323533e-122, 2.4269257853458347e-127, 4.7280164575740124e-133, 6.174478207778623e-139, 5.408895769588472e-145, 3.180094034089174e-151, 1.2554223989393353e-157, 3.3290649506191716e-164, 5.93165552080582e-171, 7.103450537107145e-178, 5.718796372368797e-185, 3.0957810075673867e-192, 1.1270505610494653e-199}, {-1.6691728606504403e-39, -1.0260914927776655e-38, -4.0849694715013104e-38, -1.0810135006536762e-37, -1.911594847080848e-37, -2.2637938946242673e-37, -1.7972809438142645e-37, -9.571056628286876e-38, -3.4194996938856384e-38, -8.196542070437565e-39, -1.317966436886182e-39, -1.421232868077548e-40, -1.027392521404924e-41, -4.975947230616518e-43, -1.613477724479253e-44, -3.499271889904946e-46, -5.069506802743677e-48, -4.897628079540123e-50, -3.147922446443343e-52, -1.341682523173856e-54, -3.7736303798639316e-57, -6.951576710476398e-60, -8.282016669580605e-63, -6.231970563284759e-66, -2.8082392867139655e-69, -6.394137330805e-73, 0., 4.0550076852750995e-80, 1.1294380558992055e-83, 1.5896084238528331e-87, 1.3398756688770135e-91, 7.13365854144491e-96, 2.4566107393007664e-100, 5.541577744495228e-105, 8.250599345763205e-110, 8.147232024881933e-115, 5.353693783175791e-120, 2.3466474054070304e-125, 6.873142572128883e-131, 1.3469617380349628e-136, 1.7680640829645453e-142, 1.5557537340756534e-148, 9.18273362575542e-155, 3.6377031177034e-161, 9.676139827097814e-168, 1.728862641674738e-174, 2.0755873956250546e-181, 1.6747971376482217e-188, 9.085023173121582e-196, 3.313759279475752e-203}, {-3.5830381600590628e-43, -2.205811468324043e-42, -8.795617689964026e-42, -2.33164958524629e-41, -4.1309483534312276e-41, -4.902177466587777e-41, -3.900803086964905e-41, -2.0825001408612167e-41, -7.460920699490173e-42, -1.79391976562663e-42, -2.8945566149678297e-43, -3.133593986976353e-44, -2.2753509012612936e-45, -1.107666977381343e-46, -3.613048897459946e-48, -7.890690476113389e-50, -1.1526757439289915e-51, -1.12484336701078e-53, -7.320239760079148e-56, -3.1694979017476845e-58, -9.100283208674822e-61, -1.7243019706965254e-63, -2.139906866257157e-66, -1.7175638421712543e-69, -8.7071119580878e-73, -2.6433867834605493e-76, -4.0550076852750995e-80, 0., 1.1672964917870584e-87, 2.1905221825866554e-91, 2.077181868729092e-95, 1.179644272907845e-99, 4.231592697351241e-104, 9.818279695557309e-109, 1.492252482285898e-113, 1.4969466450048225e-118, 9.959666481407984e-124, 4.4096479008628935e-129, 1.302313524721795e-134, 2.57005200854015e-140, 3.3936111447828344e-146, 3.001417342533122e-152, 1.7794755360374902e-158, 7.07696540348657e-165, 1.8889797871772125e-171, 3.385541587706172e-178, 4.0758049173622756e-185, 3.2970206699072793e-192, 1.7925505525864217e-199, 6.551859272718086e-207}, {-5.174836133865397e-47, -3.1900664982448874e-46, -1.2739149249465516e-45, -3.382460932668305e-45, -6.00307695455959e-45, -7.137315982708365e-45, -5.691125377880942e-45, -3.0451947908722324e-45, -1.0937285741321133e-45, -2.6370893846907047e-46, -4.2682158263571895e-47, -4.6367363655960014e-48, -3.380008914562263e-49, -1.652772855127762e-50, -5.418751839198208e-52, -1.1904683504493218e-53, -1.7512028480010713e-55, -1.7231594914914954e-57, -1.1327225227878206e-59, -4.965737187738667e-62, -1.4483969273225164e-64, -2.801565972462047e-67, -3.576159314726741e-70, -2.9899480428683e-73, -1.6167899653474588e-76, -5.5219530912531286e-80, -1.1294380558992055e-83, -1.1672964917870584e-87, 0., 1.5253109903396594e-95, 1.928519363095695e-99, 1.2321201687395326e-103, 4.714488553803491e-108, 1.1394490048165988e-112, 1.7812966865184766e-117, 1.8241271777686363e-122, 1.2329146489949144e-127, 5.526970705126353e-133, 1.6487833962954275e-138, 3.280908289118488e-144, 4.3625529464863935e-150, 3.8813467558566843e-156, 2.312967540634425e-162, 9.239725915014144e-169, 2.4759342742724834e-175, 4.452924267278278e-182, 5.377408542769692e-189, 4.362003551487226e-196, 2.3775127404473816e-203, 8.709674289323672e-211}, {-5.029010109635046e-51, -3.104063944827669e-50, -1.2412730433830075e-49, -3.300673816681396e-49, -5.867311652961558e-49, -6.988030783321522e-49, -5.5826421224440745e-49, -2.9933323813165865e-49, -1.077544803840822e-49, -2.6045801402832983e-50, -4.2273085419605906e-51, -4.606514757715801e-52, -3.369638130321492e-53, -1.6541632749553486e-54, -5.447521652387242e-56, -1.2029262905763222e-57, -1.780061637177857e-59, -1.763804787061965e-61, -1.1691028000914973e-63, -5.176994466925195e-66, -1.5288912557413663e-68, -3.0042030339024138e-71, -3.914714794500627e-74, -3.3665213039358747e-77, -1.896269664881331e-80, -6.908248145864391e-84, -1.5896084238528331e-87, -2.1905221825866554e-91, -1.5253109903396594e-95, 0., 9.047539494318224e-104, 7.707229426359873e-108, 3.317663452254257e-112, 8.55305687471345e-117, 1.3928087726071053e-121, 1.4670496221244948e-126, 1.0122261325651551e-131, 4.609683626422736e-137, 1.3923313255669832e-142, 2.798581024581377e-148, 3.75222289857598e-154, 3.3616834587119065e-160, 2.015214754567421e-166, 8.091561600778533e-173, 2.1779447967135404e-179, 3.9323561967053825e-186, 4.765252617455485e-193, 3.8774070758482167e-200, 2.1192536396178573e-207, 7.783036993560838e-215}, {-3.288896477918161e-55, -2.0323869547152753e-54, -8.13761618010052e-54, -2.166848924602947e-53, -3.8575192770112956e-53, -4.6017093538957955e-53, -3.6826360680497994e-53, -1.9783162009785064e-53, -7.136320256338807e-54, -1.7288711706456427e-54, -2.8130402771642496e-55, -3.073896010117767e-56, -2.255498051331483e-57, -1.1110738387227111e-58, -3.673358348226829e-60, -8.147752883718216e-62, -1.2118680410245212e-63, -1.2079479796652661e-65, -8.062632598283022e-68, -3.6000289609364824e-70, -1.073914474359218e-72, -2.1365714034795547e-75, -2.828314386848128e-78, -2.4829259374116943e-81, -1.4385234707685222e-84, -5.459005736677134e-88, -1.3398756688770135e-91, -2.077181868729092e-95, -1.928519363095695e-99, -9.047539494318224e-104, 0., 2.436149296551993e-112, 1.3982237608000812e-116, 4.055255592386742e-121, 7.043963372909845e-126, 7.7285703833728e-131, 5.484870323438596e-136, 2.5498508711186128e-141, 7.823943046388026e-147, 1.5922673986981433e-152, 2.156411071215967e-158, 1.9480668893541587e-164, 1.1759661924965061e-170, 4.749886913155361e-177, 1.2850477125307139e-183, 2.3305570294247015e-190, 2.83525809058979e-197, 2.315012942342678e-204, 1.2692215881423082e-211, 4.674210950682355e-219}, {-1.4475604424989392e-59, -8.955041702305055e-59, -3.5898390263369354e-58, -9.571074658428612e-58, -1.7062250944815106e-57, -2.0384043063211282e-57, -1.633899625421633e-57, -8.792591918201701e-58, -3.177732170700876e-58, -7.714429639797713e-59, -1.2580649222960959e-59, -1.3781718337913418e-60, -1.0140546385305657e-61, -5.010768163924231e-63, -1.6623789841479942e-64, -3.701726910307479e-66, -5.530397656248428e-68, -5.540777607304392e-70, -3.7202898750709466e-72, -1.6727550870740342e-74, -5.031531372540724e-77, -1.0111432937563852e-79, -1.3552456095039644e-82, -1.2086304070568657e-85, -7.14827983708106e-89, -2.790182436593331e-92, -7.13365854144491e-96, -1.179644272907845e-99, -1.2321201687395326e-103, -7.707229426359873e-108, -2.436149296551993e-112, 0., 2.977724308537547e-121, 1.1515022123853404e-125, 2.250174280255361e-130, 2.6334614010729035e-135, 1.9468071025977612e-140, 9.309059273150385e-146, 2.9158926910879867e-151, 6.028389219994383e-157, 8.266313391865817e-163, 7.543084686463149e-169, 4.5913888953804026e-175, 1.8674929352692626e-181, 5.082441323122297e-188, 9.264763021880431e-195, 1.132144024532239e-201, 9.280305829697624e-209, 5.105657413523572e-216, 1.886101309414304e-223}, {-4.2882047841601065e-64, -2.6555285658660336e-63, -1.065714846147954e-62, -2.844745721412259e-62, -5.077774083662933e-62, -6.074681699179731e-62, -4.876424391458158e-62, -2.628381892063722e-62, -9.515759973056364e-63, -2.3144710877139548e-63, -3.782241206919912e-64, -4.152746790929106e-65, -3.063236534264537e-66, -1.5178476679357306e-67, -5.051221417684274e-69, -1.1286936903646539e-70, -1.6928865940105646e-72, -1.7036356709410575e-74, -1.1497521914937877e-76, -5.200405967307725e-79, -1.5751848575696766e-81, -3.1918918906065213e-84, -4.321338450923422e-87, -3.902013979623018e-90, -2.344424628584641e-93, -9.341619476186932e-97, -2.4566107393007664e-100, -4.231592697351241e-104, -4.714488553803491e-108, -3.317663452254257e-112, -1.3982237608000812e-116, -2.977724308537547e-121, 0., 1.6522568590622112e-130, 4.304945717745777e-135, 5.6680151581969455e-140, 4.469466551002008e-145, 2.22621616500092e-150, 7.172450010807162e-156, 1.5137429028554622e-161, 2.1086384730353024e-167, 1.9482033034553428e-173, 1.1978272166280788e-179, 4.9126201932818176e-186, 1.3463347317303969e-192, 2.4688369817632927e-199, 3.0323633410385426e-206, 2.4967574089940795e-213, 1.379003962900212e-220, 5.1119219612438994e-228}, {-8.550608996258112e-69, -5.3001686776038915e-68, -2.1292749831606372e-67, -5.690062077686345e-67, -1.0168657881416783e-66, -1.218058337060263e-66, -9.791341675965208e-67, -5.285329903155222e-67, -1.916560532429538e-67, -4.669662149067725e-68, -7.645478508559786e-69, -8.411803754636659e-70, -6.218993843653504e-71, -3.0892629591430377e-72, -1.0309267214532516e-73, -2.3107341126053994e-75, -3.477819989122699e-77, -3.513627707463504e-79, -2.381868407991606e-81, -1.08285978700665e-83, -3.299468064937115e-86, -6.732665362526838e-89, -9.190968165993258e-92, -8.382944797833013e-95, -5.099634990051725e-98, -2.0642600819596613e-101, -5.541577744495228e-105, -9.818279695557309e-109, -1.1394490048165988e-112, -8.55305687471345e-117, -4.055255592386742e-121, -1.1515022123853404e-125, -1.6522568590622112e-130, 0., 4.161864904660761e-140, 7.306174467735182e-145, 6.481376491401177e-150, 3.4435596766251046e-155, 1.1556772890833318e-160, 2.5087398309359347e-166, 3.567471184919439e-172, 3.348359248964022e-178, 2.084428396280954e-184, 8.635168145861373e-191, 2.386243637365976e-197, 4.406366357383838e-204, 5.444360182486499e-211, 4.505711896390502e-218, 2.499695367640329e-225, 9.302626218973316e-233}, {-1.1477016108820136e-73, -7.120555890478664e-73, -2.863387722164905e-72, -7.659802363657434e-72, -1.3703989379766147e-71, -1.6434942001410486e-71, -1.3228073325291506e-71, -7.150273225399934e-72, -2.59666545552387e-72, -6.336863437251856e-73, -1.0393173997925894e-73, -1.145656458988727e-74, -8.487575168701564e-76, -4.2257548327645844e-77, -1.4137229617933297e-78, -3.1775412134459967e-80, -4.7972329015356353e-82, -4.863453887152291e-84, -3.309837013771908e-86, -1.5114562126122252e-88, -4.6290165466516627e-91, -9.501873753061264e-94, -1.3062007937628144e-96, -1.201294287953954e-99, -7.381705309477987e-103, -3.0253599781810897e-106, -8.250599345763205e-110, -1.492252482285898e-113, -1.7812966865184766e-117, -1.3928087726071053e-121, -7.043963372909845e-126, -2.250174280255361e-130, -4.304945717745777e-135, -4.161864904660761e-140, 0., 4.759048860271041e-150, 5.629063023447873e-155, 3.3645655794334126e-160, 1.2044442047731303e-165, 2.723544650682567e-171, 3.983582399466068e-177, 3.816807187041452e-183, 2.4137627402854946e-189, 1.01244963623198e-195, 2.8260654707842574e-202, 5.262015977493974e-209, 6.547038026734203e-216, 5.450531525061878e-223, 3.0393728701843485e-230, 1.1361533890044124e-237}, {-1.0370426972160365e-78, -6.439483873849101e-78, -2.591887731149848e-77, -6.940294717211943e-77, -1.2429667660184528e-76, -1.4923252831334644e-76, -1.2025651790618762e-76, -6.508620785514939e-77, -2.3668922131200543e-77, -5.784685489296278e-78, -9.502743992410023e-79, -1.049324656702806e-79, -7.788626053329541e-81, -3.8857937659521776e-82, -1.302943774815376e-83, -2.935889131141136e-85, -4.444715460321849e-87, -4.520020978487749e-89, -3.086793743744617e-91, -1.4151300653474442e-93, -4.353354369970166e-96, -8.981854251991057e-99, -1.2420643990199137e-101, -1.1502971326483494e-104, -7.127241141352509e-108, -2.9505746868884405e-111, -8.147232024881933e-115, -1.4969466450048225e-118, -1.8241271777686363e-122, -1.4670496221244948e-126, -7.7285703833728e-131, -2.6334614010729035e-135, -5.6680151581969455e-140, -7.306174467735182e-145, -4.759048860271041e-150, 0., 2.4704620092984114e-160, 1.9688371835382571e-165, 7.929029141662822e-171, 1.912478453230877e-176, 2.9138327692657492e-182, 2.871610257528129e-188, 1.8538504486213777e-194, 7.899379353095092e-201, 2.2325273734020296e-207, 4.198861422187672e-214, 5.267788948242275e-221, 4.4162008185760783e-228, 2.477258706818778e-235, 9.30777355926056e-243}, {-6.308456922986608e-84, -3.9203627236549756e-83, -1.5793090223528073e-82, -4.232800758677488e-82, -7.588112360563729e-82, -9.119896041674673e-82, -7.357289292274944e-82, -3.986712218132528e-82, -1.4516392416778156e-82, -3.5526802322570326e-83, -5.844782041064924e-84, -6.46434604334719e-85, -4.8065139876743204e-86, -2.4025412567544874e-87, -8.072629360318806e-89, -1.8231185165341259e-90, -2.7669818489097572e-92, -2.82167829902567e-94, -1.932934541022121e-96, -8.892241488773221e-99, -2.7462413135013007e-101, -5.691348486439108e-104, -7.910696978099794e-107, -7.369840608847531e-110, -4.5982858507226514e-113, -1.9194873273094518e-116, -5.353693783175791e-120, -9.959666481407984e-124, -1.2329146489949144e-127, -1.0122261325651551e-131, -5.484870323438596e-136, -1.9468071025977612e-140, -4.469466551002008e-145, -6.481376491401177e-150, -5.629063023447873e-155, -2.4704620092984114e-160, 0., 5.821913639910216e-171, 3.126185228997827e-176, 8.482888645639153e-182, 1.3786072620444077e-187, 1.4152403481771747e-193, 9.397532980459451e-200, 4.0877749250921076e-206, 1.1736273505651566e-212, 2.234909814918882e-219, 2.8321850985643026e-226, 2.3941215993670687e-233, 1.3523690063183398e-240, 5.111484845936966e-248}, {-2.583626670886023e-89, -1.606802285740128e-88, -6.478252521075772e-88, -1.7377785451147605e-87, -3.118166792410573e-87, -3.7512827482931937e-87, -3.029422869750091e-87, -1.6433867135076196e-87, -5.991013440205835e-88, -1.468087747783865e-88, -2.418579481504927e-89, -2.6789188827589725e-90, -1.9950813321455368e-91, -9.989779155504333e-93, -3.3629607286468616e-94, -7.610617854018216e-96, -1.1577032082045409e-97, -1.1835470310273133e-99, -8.130174558930292e-102, -3.751772188165398e-104, -1.1627042567705137e-106, -2.41905381420435e-109, -3.3773774542905066e-112, -3.162601016136676e-115, -1.9849962895225057e-118, -8.344021944323533e-122, -2.3466474054070304e-125, -4.4096479008628935e-129, -5.526970705126353e-133, -4.609683626422736e-137, -2.5498508711186128e-141, -9.309059273150385e-146, -2.22621616500092e-150, -3.4435596766251046e-155, -3.3645655794334126e-160, -1.9688371835382571e-165, -5.821913639910216e-171, 0., 6.228541157800412e-182, 2.2534822132442486e-187, 4.1200591662504297e-193, 4.51150887671599e-199, 3.120572234366216e-205, 1.3961812880398248e-211, 4.092040302328074e-218, 7.916060556744036e-225, 1.015700743536213e-231, 8.672716441121725e-239, 4.93978760017177e-246, 1.880124456925618e-253}, {-7.124199075425269e-95, -4.433847139411345e-94, -1.7890038806305013e-93, -4.802888565744968e-93, -8.625479977549767e-93, -1.0386344261469728e-92, -8.395897660890842e-93, -4.559310426056608e-93, -1.663958546897972e-93, -4.0823565485240936e-94, -6.734007308606917e-95, -7.469111311150092e-96, -5.570740089980814e-97, -2.7938533516498585e-98, -9.421588969909234e-100, -2.1362103892681333e-101, -3.2562637535096747e-103, -3.336520299700653e-105, -2.2977100140251775e-107, -1.0632527327407324e-109, -3.3053069612332515e-112, -6.90070434136729e-115, -9.672244707054631e-118, -9.097594628830853e-121, -5.739358257324735e-124, -2.4269257853458347e-127, -6.873142572128883e-131, -1.302313524721795e-134, -1.6487833962954275e-138, -1.3923313255669832e-142, -7.823943046388026e-147, -2.9158926910879867e-151, -7.172450010807162e-156, -1.1556772890833318e-160, -1.2044442047731303e-165, -7.929029141662822e-171, -3.126185228997827e-176, -6.228541157800412e-182, 0., 3.0251233720473673e-193, 7.374475647682875e-199, 9.084520968886021e-205, 6.702598099855605e-211, 3.123773377073382e-217, 9.416989037939503e-224, 1.85967097552449e-230, 2.4239976810358622e-237, 2.0956396590026983e-244, 1.2056869008734452e-251, 4.627186348852857e-259}, {-1.3226959996920227e-100, -8.23759590900367e-100, -3.326199604024594e-99, -8.936650367735593e-99, -1.6062391200402165e-98, -1.9358223107723176e-98, -1.5662781811633503e-98, -8.513835357405433e-99, -3.110432221455907e-99, -7.639624097568423e-100, -1.2616861923286852e-100, -1.4012028086922108e-101, -1.046504530552295e-102, -5.2562346638183944e-104, -1.7753775377775127e-105, -4.0324150675743904e-107, -6.158323947700793e-109, -6.323171452585588e-111, -4.3643775825259566e-113, -2.0246534720792915e-115, -6.3114725020205995e-118, -1.321766694955258e-120, -1.859062602772069e-123, -1.7554687609806588e-126, -1.112408652992317e-129, -4.7280164575740124e-133, -1.3469617380349628e-136, -2.57005200854015e-140, -3.280908289118488e-144, -2.798581024581377e-148, -1.5922673986981433e-152, -6.028389219994383e-157, -1.5137429028554622e-161, -2.5087398309359347e-166, -2.723544650682567e-171, -1.912478453230877e-176, -8.482888645639153e-182, -2.2534822132442486e-187, -3.0251233720473673e-193, 0., 6.670201449678184e-205, 1.0955912950065825e-210, 9.093733920522467e-217, 4.52071685173015e-223, 1.4196085917015697e-229, 2.8835475914080857e-236, 3.836878556850204e-243, 3.369782623633424e-250, 1.9629753784411442e-257, 7.609604845537793e-265}, {-1.6535540947413274e-106, -1.0304801813206347e-105, -4.163784464970606e-105, -1.119520497834334e-104, -2.013736836764785e-104, -2.4289170160645563e-104, -1.966943723540346e-104, -1.0701564371651431e-104, -3.913515748998716e-105, -9.62211378413997e-106, -1.590862578899454e-106, -1.7688826611391705e-107, -1.3227977246568975e-108, -6.653087287759401e-110, -2.2505160748666463e-111, -5.119788906784601e-113, -7.832564778219565e-115, -8.057460260463825e-117, -5.572932227795412e-119, -2.591182851573649e-121, -8.097764609891757e-124, -1.7005678317923537e-126, -2.3992508510767353e-129, -2.2734222357629553e-132, -1.446275872702508e-135, -6.174478207778623e-139, -1.7680640829645453e-142, -3.3936111447828344e-146, -4.3625529464863935e-150, -3.75222289857598e-154, -2.156411071215967e-158, -8.266313391865817e-163, -2.1086384730353024e-167, -3.567471184919439e-172, -3.983582399466068e-177, -2.9138327692657492e-182, -1.3786072620444077e-187, -4.1200591662504297e-193, -7.374475647682875e-199, -6.670201449678184e-205, 0., 6.676927129232533e-217, 7.389397730911299e-223, 4.1326309995984004e-229, 1.3842567989760236e-235, 2.928895904469878e-242, 4.0085686245382655e-249, 3.5939166332673e-256, 2.1267693313601833e-263, 8.34762005516753e-271}, {-1.391959446230492e-112, -8.67990036964791e-112, -3.5095293514455204e-111, -9.442642533549312e-111, -1.6997363598144085e-110, -2.051760953550796e-110, -1.6628791524110492e-110, -9.055071255242751e-111, -3.314443912744236e-111, -8.15714908027221e-112, -1.3500589497543015e-112, -1.502802498999684e-113, -1.1251567568980739e-114, -5.666268048207682e-116, -1.9193410962068835e-117, -4.3728544399267776e-119, -6.700579882947272e-121, -6.904960599041744e-123, -4.784852379968363e-125, -2.2293644617346025e-127, -6.982871886755169e-130, -1.4701105057643397e-132, -2.0798709075041384e-135, -1.9768936843260072e-138, -1.2620010224065833e-141, -5.408895769588472e-145, -1.5557537340756534e-148, -3.001417342533122e-152, -3.8813467558566843e-156, -3.3616834587119065e-160, -1.9480668893541587e-164, -7.543084686463149e-169, -1.9482033034553428e-173, -3.348359248964022e-178, -3.816807187041452e-183, -2.871610257528129e-188, -1.4152403481771747e-193, -4.51150887671599e-199, -9.084520968886021e-205, -1.0955912950065825e-210, -6.676927129232533e-217, 0., 3.0343010966027144e-229, 2.2626375843830046e-235, 8.526240045671588e-242, 1.92430341489758e-248, 2.7433909627850154e-255, 2.529885325327011e-262, 1.528298084822389e-269, 6.093822193434591e-277}, {-7.890397586436123e-119, -4.923127663024993e-118, -1.9918043436231294e-117, -5.3626193420583395e-117, -9.659749138278682e-117, -1.1668859069957418e-116, -9.464497389292279e-117, -5.158024613999801e-117, -1.8896355995960157e-117, -4.65484015267201e-118, -7.711581050015037e-119, -8.592998944889588e-120, -6.440783487068625e-121, -3.2474277141933405e-122, -1.1014095563614968e-123, -2.512799564385524e-125, -3.856098679638648e-127, -3.98008532429309e-129, -2.762831253381059e-131, -1.2896998215221933e-133, -4.047994102118415e-136, -8.5416484083818e-139, -1.2114770341940423e-141, -1.1546937645073765e-144, -7.394106494337537e-148, -3.180094034089174e-151, -9.18273362575542e-155, -1.7794755360374902e-158, -2.312967540634425e-162, -2.015214754567421e-166, -1.1759661924965061e-170, -4.5913888953804026e-175, -1.1978272166280788e-179, -2.084428396280954e-184, -2.4137627402854946e-189, -1.8538504486213777e-194, -9.397532980459451e-200, -3.120572234366216e-205, -6.702598099855605e-211, -9.093733920522467e-217, -7.389397730911299e-223, -3.0343010966027144e-229, 0., 6.260188522469388e-242, 3.145348033471425e-248, 7.98614561706891e-255, 1.2144512925206228e-261, 1.1666000766898932e-268, 7.24875948486162e-276, 2.9505314076400993e-283}, {-3.011956063290101e-125, -1.8803250680821538e-124, -7.611966507497056e-124, -2.0506837109924753e-123, -3.6963508392770205e-123, -4.4682410527631936e-123, -3.626795817478866e-123, -1.9780815573337082e-123, -7.252596509967236e-124, -1.7881175931967915e-124, -2.9650615711618026e-125, -3.307191705770407e-126, -2.481449643752524e-127, -1.2525327110396455e-128, -4.253193426813347e-130, -9.715797229796249e-132, -1.4930174460935048e-133, -1.5433060153513998e-135, -1.0730240455617705e-137, -5.017626987900404e-140, -1.5778704882783218e-142, -3.3363484651463475e-145, -4.742756325197933e-148, -4.5317875549353914e-151, -2.9100009063340323e-154, -1.2554223989393353e-157, -3.6377031177034e-161, -7.07696540348657e-165, -9.239725915014144e-169, -8.091561600778533e-173, -4.749886913155361e-177, -1.8674929352692626e-181, -4.9126201932818176e-186, -8.635168145861373e-191, -1.01244963623198e-195, -7.899379353095092e-201, -4.0877749250921076e-206, -1.3961812880398248e-211, -3.123773377073382e-217, -4.52071685173015e-223, -4.1326309995984004e-229, -2.2626375843830046e-235, -6.260188522469388e-242, 0., 5.863609485282923e-255, 1.9850538506508253e-261, 3.3960000812908717e-268, 3.4796720502365545e-275, 2.252209422701992e-282, 9.42930708063725e-290}, {-7.742624763018906e-132, -4.836191335285496e-131, -1.958906029601903e-130, -5.280485406743974e-130, -9.524010586381095e-130, -1.1520435702528909e-129, -9.357423350359209e-130, -5.1073393712227545e-130, -1.8740417964345823e-130, -4.624198868482241e-131, -7.674498276835785e-132, -8.567904779190478e-133, -6.434948129650592e-134, -3.2514779665977127e-135, -1.1053242301413869e-136, -2.527957152280534e-138, -3.8896493290215107e-140, -4.026185354334814e-142, -2.803458251967876e-144, -1.3130414592048184e-146, -4.136243128669121e-149, -8.762496530896391e-152, -1.2482037919060257e-154, -1.1953914386130863e-157, -7.695216067867876e-161, -3.3290649506191716e-164, -9.676139827097814e-168, -1.8889797871772125e-171, -2.4759342742724834e-175, -2.1779447967135404e-179, -1.2850477125307139e-183, -5.082441323122297e-188, -1.3463347317303969e-192, -2.386243637365976e-197, -2.8260654707842574e-202, -2.2325273734020296e-207, -1.1736273505651566e-212, -4.092040302328074e-218, -9.416989037939503e-224, -1.4196085917015697e-229, -1.3842567989760236e-235, -8.526240045671588e-242, -3.145348033471425e-248, -5.863609485282923e-255, 0., 2.493409424919593e-268, 5.6875828041589545e-275, 6.556180138018288e-282, 4.526370062649284e-289, 1.9740122027095596e-296}, {-1.3403838512865485e-138, -8.376546900423437e-138, -3.394767436207917e-137, -9.156226742111968e-137, -1.65242209461443e-136, -2.0000531972913273e-136, -1.6256032063806185e-136, -8.878791297711392e-137, -3.2602864153592103e-137, -8.050970178288848e-138, -1.3372616148679147e-138, -1.4942279881954104e-139, -1.1232754587147482e-140, -5.68128215143923e-142, -1.9333362231282268e-143, -4.426599430932884e-145, -6.819109656999429e-147, -7.067491426987555e-149, -4.9278986554118606e-151, -2.3114741283919743e-153, -7.293098583304905e-156, -1.5477062029686956e-158, -2.2088585787240062e-161, -2.119779977252426e-164, -1.3676890694821648e-167, -5.93165552080582e-171, -1.728862641674738e-174, -3.385541587706172e-178, -4.452924267278278e-182, -3.9323561967053825e-186, -2.3305570294247015e-190, -9.264763021880431e-195, -2.4688369817632927e-199, -4.406366357383838e-204, -5.262015977493974e-209, -4.198861422187672e-214, -2.234909814918882e-219, -7.916060556744036e-225, -1.85967097552449e-230, -2.8835475914080857e-236, -2.928895904469878e-242, -1.92430341489758e-248, -7.98614561706891e-255, -1.9850538506508253e-261, -2.493409424919593e-268, 0., 4.8136553835262764e-282, 7.398384141598811e-289, 5.74630375595714e-296, 2.6731115256262722e-303}, {-1.5627242631291488e-145, -9.770776274740684e-145, -3.961853292263948e-144, -1.0691529636963255e-143, -1.9305922883110645e-143, -2.3381348366005446e-143, -1.901577681936394e-143, -1.0392953835743616e-143, -3.818930607666477e-144, -9.437383018565186e-145, -1.5687544659438974e-145, -1.7543253309493009e-146, -1.3199436401125358e-147, -6.682122913812317e-149, -2.2761444107971226e-150, -5.216927520555199e-152, -8.045537644824367e-154, -8.348518175420832e-156, -5.828545284555849e-158, -2.73768573575764e-160, -8.650666381532949e-163, -1.8387446843531428e-165, -2.628787354782164e-168, -2.527551893537697e-171, -1.6341612280162572e-174, -7.103450537107145e-178, -2.0755873956250546e-181, -4.0758049173622756e-185, -5.377408542769692e-189, -4.765252617455485e-193, -2.83525809058979e-197, -1.132144024532239e-201, -3.0323633410385426e-206, -5.444360182486499e-211, -6.547038026734203e-216, -5.267788948242275e-221, -2.8321850985643026e-226, -1.015700743536213e-231, -2.4239976810358622e-237, -3.836878556850204e-243, -4.0085686245382655e-249, -2.7433909627850154e-255, -1.2144512925206228e-261, -3.3960000812908717e-268, -5.6875828041589545e-275, -4.8136553835262764e-282, 0., 4.219014535055415e-296, 4.369195327920629e-303, 2.2865593684902e-310}, {-1.2270374557989243e-152, -7.6754940210584e-152, -3.113795695393657e-151, -8.407288511514243e-151, -1.5189434955255e-150, -1.840631594877167e-150, -1.4978551715146e-150, -8.191553437521014e-151, -3.011997892578802e-151, -7.448440281361186e-152, -1.2390421618078166e-152, -1.386680718703117e-153, -1.0441824782110088e-154, -5.290677913971e-156, -1.8038302276517076e-157, -4.1384239021653636e-159, -6.388919212691625e-161, -6.636888782561618e-163, -4.639081772203467e-165, -2.1817739223630857e-167, -6.90354032334074e-170, -1.469557744215786e-172, -2.104340967657085e-175, -2.026820894669611e-178, -1.3129008927846834e-181, -5.718796372368797e-185, -1.6747971376482217e-188, -3.2970206699072793e-192, -4.362003551487226e-196, -3.8774070758482167e-200, -2.315012942342678e-204, -9.280305829697624e-209, -2.4967574089940795e-213, -4.505711896390502e-218, -5.450531525061878e-223, -4.4162008185760783e-228, -2.3941215993670687e-233, -8.672716441121725e-239, -2.0956396590026983e-244, -3.369782623633424e-250, -3.5939166332673e-256, -2.529885325327011e-262, -1.1666000766898932e-268, -3.4796720502365545e-275, -6.556180138018288e-282, -7.398384141598811e-289, -4.219014535055415e-296, 0., 1.67881697224636e-310, 1.1714484e-317}, {-6.488809840381221e-160, -4.060755759877818e-159, -1.648146740911673e-158, -4.452216060197427e-158, -8.04796877495546e-158, -9.757677968324217e-158, -7.945032905082505e-158, -4.347609984275376e-158, -1.5995966697687409e-158, -3.9582825689988023e-159, -6.589134923937895e-160, -7.379656436748949e-161, -5.561235687555555e-162, -2.82007652878455e-163, -9.623234765259357e-165, -2.2098326128867907e-166, -3.414885325913514e-168, -3.55112060653204e-170, -2.484938975825709e-172, -1.1700654523192759e-174, -3.7070340607604044e-177, -7.902008913969287e-180, -1.1332086810508334e-182, -1.093212485544879e-185, -7.0937485920695716e-189, -3.0957810075673867e-192, -9.085023173121582e-196, -1.7925505525864217e-199, -2.3775127404473816e-203, -2.1192536396178573e-207, -1.2692215881423082e-211, -5.105657413523572e-216, -1.379003962900212e-220, -2.499695367640329e-225, -3.0393728701843485e-230, -2.477258706818778e-235, -1.3523690063183398e-240, -4.93978760017177e-246, -1.2056869008734452e-251, -1.9629753784411442e-257, -2.1267693313601833e-263, -1.528298084822389e-269, -7.24875948486162e-276, -2.252209422701992e-282, -4.526370062649284e-289, -5.74630375595714e-296, -4.369195327920629e-303, -1.67881697224636e-310, 0., 0.}, {-2.3110690275446552e-167, -1.4469051746828828e-166, -5.875240722389862e-166, -1.5878567227937894e-165, -2.8716789339747986e-165, -3.483537293048926e-165, -2.837949268524104e-165, -1.5538381261305658e-165, -5.720369981911968e-166, -1.4164196413827982e-166, -2.35938695171354e-167, -2.6442820587995058e-168, -1.994161313100448e-169, -1.0120107195095772e-170, -3.456208790413128e-172, -7.9435405726923945e-174, -1.2286547054254313e-175, -1.278920265788832e-177, -8.958719303083034e-180, -4.2230203629779647e-182, -1.339541908195639e-184, -2.859048645380551e-187, -4.1057270248325986e-190, -3.966684733278271e-193, -2.5780677249617564e-196, -1.1270505610494653e-199, -3.313759279475752e-203, -6.551859272718086e-207, -8.709674289323672e-211, -7.783036993560838e-215, -4.674210950682355e-219, -1.886101309414304e-223, -5.1119219612438994e-228, -9.302626218973316e-233, -1.1361533890044124e-237, -9.30777355926056e-243, -5.111484845936966e-248, -1.880124456925618e-253, -4.627186348852857e-259, -7.609604845537793e-265, -8.34762005516753e-271, -6.093822193434591e-277, -2.9505314076400993e-283, -9.42930708063725e-290, -1.9740122027095596e-296, -2.6731115256262722e-303, -2.2865593684902e-310, -1.1714484e-317, 0., 0.}}, {{0., 1.6282739404762043e-6, 0.000020119975034514338, 0.00012384448784566866, 0.00045334377202989773, 0.0010437787224550235, 0.0015499813167632061, 0.001504627002027581, 0.0009625408729568622, 0.00040790986201417936, 0.00011492525594953827, 0.000021581515090991214, 2.706348746558151e-6, 2.2695761372922566e-7, 1.2742375976844088e-8, 4.793867554591371e-10, 1.2093792503110964e-11, 2.0470779650391338e-13, 2.326015706332304e-15, 1.77490111025429e-17, 9.098476219291881e-20, 3.134180624247086e-22, 7.256886021690464e-25, 1.1296474706354183e-27, 1.1824565526307955e-30, 8.324347022248311e-34, 3.941870992615541e-37, 1.2557382244599895e-40, 2.691480888712245e-44, 3.8817236095377765e-48, 3.7673854149825274e-52, 2.4607903523381173e-56, 1.0818368473743093e-60, 3.2013407353856253e-65, 6.37694513286429e-70, 8.551245540919438e-75, 7.719783631420196e-80, 4.69203424468287e-85, 1.920069967944367e-90, 5.290427850604715e-96, 9.815197726569329e-102, 1.2261885317535194e-107, 1.031524858812811e-113, 5.8435895163991595e-120, 2.2293057943331694e-126, 5.727447040466372e-133, 9.909798079863628e-140, 1.1547578199970608e-146, 9.062517576561442e-154, 4.7901325506854285e-161}, {-1.6282739404762043e-6, 0., 0.00009530692487181937, 0.0007811707943685751, 0.003214876638579076, 0.007892277530131485, 0.012204913613320252, 0.012183996689195144, 0.007955611830819592, 0.0034246035210480567, 0.0009768286964219068, 0.00018527567755236932, 0.00002342600951025185, 1.9781705087265846e-6, 1.117192235755372e-7, 4.224434759015136e-9, 1.0704472188376573e-10, 1.8189646879944232e-12, 2.073942166942745e-14, 1.587415401876747e-16, 8.159823063724499e-19, 2.8178313978495652e-21, 6.539126688615311e-24, 1.0200085586130949e-26, 1.0696990031118426e-29, 7.543544911681008e-33, 3.5778147103230526e-36, 1.1414386528454213e-39, 2.4498323169091785e-43, 3.5376896548094705e-47, 3.437541340333299e-51, 2.2478204152194048e-55, 9.892303939583076e-60, 2.9301418658752668e-64, 5.842051014592623e-69, 7.840702941926645e-74, 7.08406751474881e-79, 4.308949323836612e-84, 1.764583328432896e-89, 4.8653540962657814e-95, 9.032461740768765e-101, 1.1291034869841068e-106, 9.504135748552006e-113, 5.38712430463464e-119, 2.0562696520924437e-125, 5.2855982379620896e-132, 9.149781634750772e-139, 1.066695679570765e-145, 8.375169545360636e-153, 4.428731495059397e-160}, {-0.000020119975034514338, -0.00009530692487181937, 0., 0.0024037107541908568, 0.013189695143688614, 0.03642697037240108, 0.06008731200372787, 0.06248355024038722, 0.0419646222032137, 0.018440571961960972, 0.005343447459340975, 0.0010261628144528313, 0.00013105715477887737, 0.000011159122895192118, 6.346298946474358e-7, 2.414006846276389e-8, 6.14832021493719e-10, 1.0494212984849104e-11, 1.2012182789577698e-13, 9.226163488054544e-16, 4.757225148338889e-18, 1.647375480281661e-20, 3.832519521681648e-23, 5.991758407608037e-26, 6.296660039574961e-29, 4.448830253215053e-32, 2.1136973048276577e-35, 6.754184331989725e-39, 1.4517758825398945e-42, 2.0993220269735873e-46, 2.042497472323219e-50, 1.337186205065694e-54, 5.8912915558861995e-59, 1.7468428614062207e-63, 3.4862203517425385e-68, 4.683208022687917e-73, 4.234937129850926e-78, 2.578043918267457e-83, 1.0565652172144715e-88, 2.9153179204796637e-94, 5.415997351518303e-100, 6.774724981980148e-106, 5.70613515659669e-112, 3.2362706609148655e-118, 1.2359877277628926e-124, 3.1787997599364247e-131, 5.50559323739955e-138, 6.421676661956211e-145, 5.0443682686815524e-152, 2.6686349097395127e-159}, {-0.00012384448784566866, -0.0007811707943685751, -0.0024037107541908568, 0., 0.02702606433676581, 0.09951987246225512, 0.18468092603752306, 0.20484892080680983, 0.1433111766676162, 0.06477472590848675, 0.019160532735103673, 0.0037380209546591203, 0.000483371704424313, 0.000041573381749263165, 2.3840202595876044e-6, 9.131757433420348e-8, 2.339643942578205e-9, 4.0138822197516056e-11, 4.614994437707754e-13, 3.5585263008327205e-15, 1.8412302205964955e-17, 6.395720457080953e-20, 1.4920588474064695e-22, 2.3385301080989554e-25, 2.4631158025649217e-28, 1.7438882455365585e-31, 8.3011327262988e-35, 2.6571869549295953e-38, 5.720634586943327e-42, 8.284505975644386e-46, 8.071332331954305e-50, 5.290904099075654e-54, 2.3338085571745703e-58, 6.927736627100809e-63, 1.3840268566611264e-67, 1.861047489958794e-72, 1.6844571127692852e-77, 1.0263113975911483e-82, 4.209590208174463e-88, 1.1624242633512565e-93, 2.1610983817213985e-99, 2.705133026809359e-105, 2.279946399663106e-111, 1.2938947113399984e-117, 4.9445490779925436e-124, 1.2723950568617812e-130, 2.2049455421640465e-137, 2.57315865144489e-144, 2.0222713718759173e-151, 1.0703531789354332e-158}, {-0.00045334377202989773, -0.003214876638579076, -0.013189695143688614, -0.02702606433676581, 0., 0.1365218893603565, 0.3377950328829348, 0.4215192553441227, 0.31455205252079166, 0.14809718801547056, 0.04505917800699193, 0.008973714724896595, 0.0011788299905278238, 0.00010265505432690608, 5.946202991621062e-6, 2.296615440931073e-7, 5.925297190337539e-9, 1.0225920589286777e-10, 1.1817631212094113e-12, 9.153009874193234e-15, 4.7544647319733986e-17, 1.6572512839489904e-19, 3.8781743606188705e-22, 6.0952152263665695e-25, 6.436029201446654e-28, 4.567070742382481e-31, 2.1784855173260736e-34, 6.986524404467181e-38, 1.5067386025123913e-41, 2.1855248589559317e-45, 2.1324422948068166e-49, 1.3997745624882958e-53, 6.182266691344959e-58, 1.8373444688234725e-62, 3.6747394597307325e-67, 4.946427471521471e-72, 4.481449129398256e-77, 2.732981231396623e-82, 1.1219491339476401e-87, 3.100649560324401e-93, 5.768963474186096e-99, 7.226520326443093e-105, 6.0948932163812345e-111, 3.461194682759942e-117, 1.3235041302822812e-123, 3.407838570213874e-130, 5.908825668901155e-137, 6.899296630593111e-144, 5.4250290861094757e-151, 2.8727925096648852e-158}, {-0.0010437787224550235, -0.007892277530131485, -0.03642697037240108, -0.09951987246225512, -0.1365218893603565, 0., 0.3109712733125159, 0.5173961201310999, 0.4343609708839968, 0.21813924610074786, 0.06913516874230057, 0.014161931125688485, 0.0018991367489214525, 0.00016800601205310963, 9.853244258220687e-6, 3.844081649575327e-7, 1.0000427951486325e-8, 1.7379501605994715e-10, 2.0204251133501047e-12, 1.572887698705668e-14, 8.206725645484982e-17, 2.8718148298341023e-19, 6.743739029085034e-22, 1.0631754949364316e-24, 1.1257413525724453e-27, 8.008394303997788e-31, 3.828673209434217e-34, 1.230419013559264e-37, 2.658590923402557e-41, 3.862993631046118e-45, 3.775208627477476e-49, 2.4817880508214766e-53, 1.0976161209529534e-57, 3.2662365031885696e-62, 6.540339679688605e-67, 8.813496061542816e-72, 7.993319912591339e-77, 4.879436786499499e-82, 2.0049576282777306e-87, 5.545753545724507e-93, 1.0326671007162734e-98, 1.2945743970809558e-104, 1.092650419843976e-110, 6.209291174575713e-117, 2.3758932574342238e-123, 6.121419702203218e-130, 1.0620201374543118e-136, 1.2407453629144197e-143, 9.761461786609124e-151, 5.171796535357789e-158}, {-0.0015499813167632061, -0.012204913613320252, -0.06008731200372787, -0.18468092603752306, -0.3377950328829348, -0.3109712733125159, 0., 0.32004728368321433, 0.35824530686263206, 0.20240258033310465, 0.06842424085390403, 0.014600314317963428, 0.0020138653124846815, 0.0001818669777157162, 0.000010835468652396986, 4.2801213928785674e-7, 1.1247263599087624e-8, 1.970923331525592e-10, 2.307287033025864e-12, 1.8068995348601326e-14, 9.476057017068138e-17, 3.3308009802648957e-19, 7.852225991426961e-22, 1.2422309569642105e-24, 1.3194061294404734e-27, 9.412175726631532e-31, 4.511074233945619e-34, 1.45301675112936e-37, 3.1460624273001057e-41, 4.57995868142207e-45, 4.483665071184566e-49, 2.952244508749799e-53, 1.3076184340111478e-57, 3.8964968951620165e-62, 7.812343158147586e-67, 1.0540129128723287e-71, 9.56990726384389e-77, 5.847932958002389e-82, 2.4052610078567205e-87, 6.6591157193044324e-93, 1.2410583116840004e-98, 1.5570893376444637e-104, 1.3152338787709455e-110, 7.479647429430246e-117, 2.8639596054888698e-123, 7.383762962086481e-130, 1.2818283124387178e-136, 1.498436007631165e-143, 1.179550847174151e-150, 6.252852491505073e-158}, {-0.001504627002027581, -0.012183996689195144, -0.06248355024038722, -0.20484892080680983, -0.4215192553441227, -0.5173961201310999, -0.32004728368321433, 0., 0.14901274469138936, 0.11225293004650698, 0.04269176903819673, 0.009716840916320883, 0.0013961178365005723, 0.0001296820777702703, 7.8873053260347e-6, 3.165020040848911e-7, 8.420973161997218e-9, 1.4905616579725407e-10, 1.7594866036177559e-12, 1.3875377255834272e-14, 7.32008091857943e-17, 2.586177687802444e-19, 6.124025167803496e-22, 9.726269728557932e-25, 1.0366396445405671e-27, 7.4179146347528915e-31, 3.5651391000433627e-34, 1.1512091217449312e-37, 2.498255487846055e-41, 3.644427414643277e-45, 3.574560548297067e-49, 2.3577429591889873e-53, 1.0459732915731098e-57, 3.1214531316908443e-62, 6.267003603094502e-67, 8.466011714165541e-72, 7.695863792172122e-77, 4.707982567774953e-82, 1.9384152887063407e-87, 5.37187007851897e-93, 1.002074730148232e-98, 1.2583379760930661e-104, 1.0637545504797679e-110, 6.054172676016368e-117, 2.3198393763016913e-123, 5.985075536883375e-130, 1.03969840003819e-136, 1.21615025542803e-143, 9.579087344435232e-151, 5.080797879248018e-158}, {-0.0009625408729568622, -0.007955611830819592, -0.0419646222032137, -0.1433111766676162, -0.31455205252079166, -0.4343609708839968, -0.35824530686263206, -0.14901274469138936, 0., 0.031412612620815676, 0.015929027448264656, 0.004078709029813572, 0.0006250984629491147, 0.000060483244864555095, 3.78371339071265e-6, 1.5499614109711863e-7, 4.189345023972162e-9, 7.508078824657861e-11, 8.952197355166109e-13, 7.118567500154643e-15, 3.7817267375040725e-17, 1.3440333513463188e-19, 3.1989695921557497e-22, 5.103333546096103e-25, 5.460535607195457e-28, 3.920979899041831e-31, 1.8903044288761415e-34, 6.120884659909298e-38, 1.3316310693143166e-41, 1.946983572659804e-45, 1.913611935528314e-49, 1.26458905700191e-53, 5.61989493798356e-58, 1.679808782637508e-62, 3.37758196224284e-67, 4.56899798286851e-72, 4.158663440773595e-77, 2.5471115063740941e-82, 1.0498874778218783e-87, 2.9125513062524387e-93, 5.4384171567420375e-99, 6.835474931473026e-105, 5.783472462137724e-111, 3.294251221888581e-117, 1.263266736974515e-123, 3.2615506845197895e-130, 5.669734647279585e-137, 6.636333755470488e-144, 5.23042087250876e-151, 2.775893840511443e-158}, {-0.00040790986201417936, -0.0034246035210480567, -0.018440571961960972, -0.06477472590848675, -0.14809718801547056, -0.21813924610074786, -0.20240258033310465, -0.11225293004650698, -0.031412612620815676, 0., 0.002999877640604028, 0.0010241787044276798, 0.00017658506537208133, 0.000018225075898918006, 1.18763028022462e-6, 5.004012342344135e-8, 1.3806972451559302e-9, 2.5137412801195275e-11, 3.03470467240192e-13, 2.4374976091691783e-15, 1.3057073814366994e-17, 4.672961634088967e-20, 1.118844431180116e-22, 1.794051917363346e-25, 1.9281943052099635e-28, 1.3899844867235662e-31, 6.724383041180261e-35, 2.184124427453173e-38, 4.764878168710298e-42, 6.984209598860104e-46, 6.880100165528903e-50, 4.5560506154932526e-54, 2.0285656489931e-58, 6.074007959287653e-63, 1.2232545319142668e-67, 1.6571996243987723e-72, 1.5104410611602259e-77, 9.263012865407114e-83, 3.8226433021024435e-88, 1.0616403619662462e-93, 1.984396758272892e-99, 2.4966002485025293e-105, 2.1143066265387856e-111, 1.2053463703861876e-117, 4.625992033645359e-124, 1.1952787115959427e-130, 2.0793382240976963e-137, 2.435518793678092e-144, 1.9208149537584718e-151, 1.0200542364666888e-158}, {-0.00011492525594953827, -0.0009768286964219068, -0.005343447459340975, -0.019160532735103673, -0.04505917800699193, -0.06913516874230057, -0.06842424085390403, -0.04269176903819673, -0.015929027448264656, -0.002999877640604028, 0., 0.00012983774138501617, 0.00002984818430757291, 3.46565889486296e-6, 2.4089426193798695e-7, 1.0572856370734155e-8, 3.0005915023433736e-10, 5.576784163208299e-12, 6.839417530585517e-14, 5.562139977211866e-16, 3.009597243538218e-18, 1.0860726090062399e-20, 2.618561659107332e-23, 4.2238212395686685e-26, 4.5629192046354307e-29, 3.3039725917005945e-32, 1.60464405628588e-35, 5.230088029182914e-39, 1.144526654542028e-42, 1.6822714551034673e-46, 1.6613482116764188e-50, 1.1026568009945448e-54, 4.919705636383951e-59, 1.4758667796547594e-63, 2.977441742951036e-68, 4.0401425913615154e-73, 3.6878103045006463e-78, 2.2647131737965697e-83, 9.357913249773955e-89, 2.6020124540010235e-94, 4.869039257133709e-100, 6.132194640550621e-106, 5.198274578774615e-112, 2.966211358458397e-118, 1.139386211765999e-124, 2.9463879827102953e-131, 5.129571883705255e-138, 6.012634700153965e-145, 4.7452568415753755e-152, 2.52164000561572e-159}, {-0.000021581515090991214, -0.00018527567755236932, -0.0010261628144528313, -0.0037380209546591203, -0.008973714724896595, -0.014161931125688485, -0.014600314317963428, -0.009716840916320883, -0.004078709029813572, -0.0010241787044276798, -0.00012983774138501617, 0., 2.547593468470047e-6, 3.943998680575435e-7, 3.0841104536604436e-8, 1.4438581351868898e-9, 4.268426757077057e-11, 8.159795065123442e-13, 1.0215729267363616e-14, 8.439789141324568e-17, 4.623736694480489e-19, 1.6854209205534489e-21, 4.097476283015162e-24, 6.655575711062652e-27, 7.23269747620672e-30, 5.2639943839527064e-33, 2.567983286827608e-36, 8.402765906212454e-40, 1.8452046154796772e-43, 2.720552960765633e-47, 2.694179196189858e-51, 1.7926407565450755e-55, 8.016373371775662e-60, 2.409817793637022e-64, 4.870819900784146e-69, 6.620794846697392e-74, 6.053094287907647e-79, 3.722759622787808e-84, 1.5403767410707671e-89, 4.2885611700340243e-95, 8.034562325130041e-101, 1.0130192468707554e-106, 8.596331125618169e-113, 4.909986937641612e-119, 1.8877661182928958e-125, 4.8858824261455563e-132, 8.513122220824747e-139, 9.986373391143272e-146, 7.887149195722541e-153, 4.1941531061935446e-160}, {-2.706348746558151e-6, -0.00002342600951025185, -0.00013105715477887737, -0.000483371704424313, -0.0011788299905278238, -0.0018991367489214525, -0.0020138653124846815, -0.0013961178365005723, -0.0006250984629491147, -0.00017658506537208133, -0.00002984818430757291, -2.547593468470047e-6, 0., 2.266698385825154e-8, 2.3633368917181114e-9, 1.2447231234536577e-10, 3.925046359850335e-12, 7.816007644674972e-14, 1.006490210965924e-15, 8.488415299360425e-18, 4.7241920252616174e-20, 1.743563865263438e-22, 4.281645760550916e-25, 7.012680250475256e-28, 7.6740595314589056e-31, 5.6184653123104035e-34, 2.7549640722565288e-37, 9.054834378757079e-41, 1.9961931619831176e-44, 2.9533884423931576e-48, 2.9338124854879147e-52, 1.9575093332438135e-56, 8.775575514729228e-61, 2.644038598033133e-65, 5.355301009934402e-70, 7.293125639921071e-75, 6.679372158238167e-80, 4.114514769640325e-85, 1.7049965565328353e-90, 4.753399453211009e-96, 8.916804142169321e-102, 1.125593068561326e-107, 9.562240596608513e-114, 5.467377010425398e-120, 2.104123348525203e-126, 5.450859711703032e-133, 9.505757069844075e-140, 1.1159900279636417e-146, 8.820796501499101e-154, 4.6940680110663145e-161}, {-2.2695761372922566e-7, -1.9781705087265846e-6, -0.000011159122895192118, -0.000041573381749263165, -0.00010265505432690608, -0.00016800601205310963, -0.0001818669777157162, -0.0001296820777702703, -0.000060483244864555095, -0.000018225075898918006, -3.46565889486296e-6, -3.943998680575435e-7, -2.266698385825154e-8, 0., 9.146865167119061e-11, 6.423298977827316e-12, 2.2786766004915006e-13, 4.8400695353451825e-15, 6.492395197649067e-17, 5.6319198863880615e-19, 3.199721899684717e-21, 1.199670489765778e-23, 2.982839470930385e-26, 4.9347822130031586e-29, 5.44519254894413e-32, 4.0145071543360543e-35, 1.980194704284577e-38, 6.541749746507701e-42, 1.4486066632234357e-45, 2.151633368175475e-49, 2.1447931172371256e-53, 1.4354873976415174e-57, 6.453210793981051e-62, 1.9491942888539452e-66, 3.956918807994517e-71, 5.3998933030287155e-76, 4.954831327580913e-81, 3.0575002217913643e-86, 1.2690151457897155e-91, 3.5431581222825657e-97, 6.655667212345453e-103, 8.4123645004711955e-109, 7.155056187539414e-115, 4.0955781911379475e-121, 1.5778276035600945e-127, 4.0914540845257657e-134, 7.141646879785075e-141, 8.391658950643558e-148, 6.638194681424799e-155, 3.5353042304168286e-162}, {-1.2742375976844088e-8, -1.117192235755372e-7, -6.346298946474358e-7, -2.3840202595876044e-6, -5.946202991621062e-6, -9.853244258220687e-6, -0.000010835468652396986, -7.8873053260347e-6, -3.78371339071265e-6, -1.18763028022462e-6, -2.4089426193798695e-7, -3.0841104536604436e-8, -2.3633368917181114e-9, -9.146865167119061e-11, 0., 1.6742875381839072e-13, 7.919419286826073e-15, 1.8924079670614405e-16, 2.7076768893770425e-18, 2.4466797394867578e-20, 1.4297738425038637e-22, 5.472325632485442e-25, 1.3822266503576056e-27, 2.3153273581886887e-30, 2.5806104985727467e-33, 1.9184283278791054e-36, 9.529008005692451e-40, 3.1667308010137773e-43, 7.048377537819422e-47, 1.0515779004815789e-50, 1.0523455572870142e-54, 7.067693439079242e-59, 3.1871071091397627e-63, 9.653407486287438e-68, 1.9645801124638668e-72, 2.687099176916017e-77, 2.470731902618137e-82, 1.527513280834409e-87, 6.350968253630295e-93, 1.776065991116711e-98, 3.341204717968902e-104, 4.2288834717988516e-110, 3.6014300614958456e-116, 2.0639247939079575e-122, 7.960145642461407e-129, 2.066290127189805e-135, 3.610242000818892e-142, 4.246046552698238e-149, 3.361729467885715e-156, 1.7918194226187878e-163}, {-4.793867554591371e-10, -4.224434759015136e-9, -2.414006846276389e-8, -9.131757433420348e-8, -2.296615440931073e-7, -3.844081649575327e-7, -4.2801213928785674e-7, -3.165020040848911e-7, -1.5499614109711863e-7, -5.004012342344135e-8, -1.0572856370734155e-8, -1.4438581351868898e-9, -1.2447231234536577e-10, -6.423298977827316e-12, -1.6742875381839072e-13, 0., 1.390334198674914e-16, 4.429751591891227e-18, 7.130401185838791e-20, 6.87263021049473e-22, 4.183521117747371e-24, 1.646952246133138e-26, 4.246617835528111e-29, 7.226295970850181e-32, 8.154941188767008e-35, 6.123627400982023e-38, 3.067008609452823e-41, 1.02637225619752e-44, 2.298054580483705e-48, 3.446149320669468e-52, 3.4640608518645467e-56, 2.335633142239807e-60, 1.0568879333084223e-64, 3.2111116573064834e-69, 6.5531364778018345e-74, 8.985665778880477e-79, 8.280910695206141e-84, 5.130216626489838e-89, 2.137038765849693e-94, 5.986682076637373e-100, 1.128042885643854e-105, 1.429852260091432e-111, 1.2193730222474547e-117, 6.996966037006936e-124, 2.7018026369279266e-130, 7.021125333940566e-137, 1.2280156288969257e-143, 1.4456949167172207e-150, 1.145654454525496e-157, 6.111685202465258e-165}, {-1.2093792503110964e-11, -1.0704472188376573e-10, -6.14832021493719e-10, -2.339643942578205e-9, -5.925297190337539e-9, -1.0000427951486325e-8, -1.1247263599087624e-8, -8.420973161997218e-9, -4.189345023972162e-9, -1.3806972451559302e-9, -3.0005915023433736e-10, -4.268426757077057e-11, -3.925046359850335e-12, -2.2786766004915006e-13, -7.919419286826073e-15, -1.390334198674914e-16, 0., 5.238207206440203e-20, 1.1242321561880687e-21, 1.2190388224605487e-23, 7.915261165395717e-26, 3.2458844645485944e-28, 8.608543657306502e-31, 1.495399030374946e-33, 1.7143583513818672e-36, 1.3034205491832348e-39, 6.5941011761794184e-43, 2.225100543117081e-46, 5.016854775118436e-50, 7.568027552205009e-54, 7.646374865624521e-58, 5.178562261119543e-62, 2.3525198536996274e-66, 7.17241020746108e-71, 1.4682547463872885e-75, 2.0188644599199497e-80, 1.8651857915816532e-85, 1.1581521406837063e-90, 4.8343772958041785e-96, 1.3568632697899476e-101, 2.5611212548472854e-107, 3.25155514131821e-113, 2.7770229100741255e-119, 1.5956909986373e-125, 6.16945713526703e-132, 1.60515422170674e-138, 2.8105851769543687e-145, 3.31223899626585e-152, 2.6273805645619595e-159, 1.4029083368632487e-166}, {-2.0470779650391338e-13, -1.8189646879944232e-12, -1.0494212984849104e-11, -4.0138822197516056e-11, -1.0225920589286777e-10, -1.7379501605994715e-10, -1.970923331525592e-10, -1.4905616579725407e-10, -7.508078824657861e-11, -2.5137412801195275e-11, -5.576784163208299e-12, -8.159795065123442e-13, -7.816007644674972e-14, -4.8400695353451825e-15, -1.8924079670614405e-16, -4.429751591891227e-18, -5.238207206440203e-20, 0., 8.954805952906428e-24, 1.2946621441852944e-25, 9.457071755049156e-28, 4.136692282368605e-30, 1.1428220521297054e-32, 2.0419282464489633e-35, 2.38968045881547e-38, 1.8457046780234677e-41, 9.454276241316939e-45, 3.222456966358747e-48, 7.326105026973407e-52, 1.1128862330800526e-55, 1.131100186588309e-59, 7.699741596533992e-64, 3.5134578311325453e-68, 1.0753908897918566e-72, 2.20906249069998e-77, 3.0468862345621087e-82, 2.8227724853639407e-87, 1.7571404924272168e-92, 7.35135384565567e-98, 2.067574193614485e-103, 3.9100013422053973e-109, 4.972703078878411e-115, 4.253792440537331e-121, 2.4478711325643947e-127, 9.47726131995961e-134, 2.4689197316380126e-140, 4.328163581522783e-147, 5.106359637946832e-154, 4.0547573554326276e-161, 2.1671826056385627e-168}, {-2.326015706332304e-15, -2.073942166942745e-14, -1.2012182789577698e-13, -4.614994437707754e-13, -1.1817631212094113e-12, -2.0204251133501047e-12, -2.307287033025864e-12, -1.7594866036177559e-12, -8.952197355166109e-13, -3.03470467240192e-13, -6.839417530585517e-14, -1.0215729267363616e-14, -1.006490210965924e-15, -6.492395197649067e-17, -2.7076768893770425e-18, -7.130401185838791e-20, -1.1242321561880687e-21, -8.954805952906428e-24, 0., 6.9465599418395065e-28, 6.765638033137604e-30, 3.3293374293995357e-32, 9.810969663249945e-35, 1.826007532106495e-37, 2.1980439726823035e-40, 1.7330600046671362e-43, 9.01818414421179e-47, 3.1122392076747083e-50, 7.147000114508619e-54, 1.0947262776091147e-57, 1.1204237382263925e-61, 7.672462967643139e-66, 3.5189642591452166e-70, 1.0818846605654618e-74, 2.231117263371594e-79, 3.0879907361673994e-84, 2.869710676637069e-89, 1.791321036320575e-94, 7.513137932493425e-100, 2.1178785440991196e-105, 4.0134243852723586e-111, 5.113902648961815e-117, 4.382186554076445e-123, 2.525797594350763e-129, 9.79345141994339e-136, 2.554794880435601e-142, 4.484427773929628e-149, 5.29701832815678e-156, 4.210830548659062e-163, 2.252944823387032e-170}, {-1.77490111025429e-17, -1.587415401876747e-16, -9.226163488054544e-16, -3.5585263008327205e-15, -9.153009874193234e-15, -1.572887698705668e-14, -1.8068995348601326e-14, -1.3875377255834272e-14, -7.118567500154643e-15, -2.4374976091691783e-15, -5.562139977211866e-16, -8.439789141324568e-17, -8.488415299360425e-18, -5.6319198863880615e-19, -2.4466797394867578e-20, -6.87263021049473e-22, -1.2190388224605487e-23, -1.2946621441852944e-25, -6.9465599418395065e-28, 0., 2.4453951009180055e-32, 1.6044893128639897e-34, 5.319165102889854e-37, 1.0559973445536015e-39, 1.3241140835677962e-42, 1.073833836957314e-45, 5.704235229623759e-49, 1.9998191446722682e-52, 4.6498246233717495e-56, 7.194210355864294e-60, 7.42444535580745e-64, 5.1196817968828165e-68, 2.36211178831973e-72, 7.299414305141728e-77, 1.5120423229208685e-81, 2.1009577774994083e-86, 1.9592272125800286e-91, 1.2267684681236036e-96, 5.159590587767299e-102, 1.458082259827489e-107, 2.769376314321014e-113, 3.536043309338446e-119, 3.0358319742312233e-125, 1.752831029850576e-131, 6.8072657989672e-138, 1.7784263952700232e-144, 3.125957297397164e-151, 3.6971049880617105e-158, 2.9424885573985325e-165, 1.5760877407078996e-172}, {-9.098476219291881e-20, -8.159823063724499e-19, -4.757225148338889e-18, -1.8412302205964955e-17, -4.7544647319733986e-17, -8.206725645484982e-17, -9.476057017068138e-17, -7.32008091857943e-17, -3.7817267375040725e-17, -1.3057073814366994e-17, -3.009597243538218e-18, -4.623736694480489e-19, -4.7241920252616174e-20, -3.199721899684717e-21, -1.4297738425038637e-22, -4.183521117747371e-24, -7.915261165395717e-26, -9.457071755049156e-28, -6.765638033137604e-30, -2.4453951009180055e-32, 0., 3.906751690679585e-37, 1.7268761337006036e-39, 3.856852811151428e-42, 5.158511078291881e-45, 4.357775113039506e-48, 2.381001190885009e-51, 8.521337183900028e-55, 2.0127647886273544e-58, 3.1530772964311944e-62, 3.2868531850667313e-66, 2.2854061092718763e-70, 1.06181123544817e-74, 3.3007475279012164e-79, 6.872420107528054e-84, 9.59174394714558e-89, 8.979762310432747e-94, 5.642193765283229e-99, 2.380362620033463e-104, 6.74550715128775e-110, 1.2844040021668819e-115, 1.6437023090188017e-121, 1.414104653047222e-127, 8.180232036665062e-134, 3.182386455000812e-140, 8.327440377596768e-147, 1.4658907369551357e-153, 1.736107015783124e-160, 1.3835147442744127e-167, 7.419354286866282e-175}, {-3.134180624247086e-22, -2.8178313978495652e-21, -1.647375480281661e-20, -6.395720457080953e-20, -1.6572512839489904e-19, -2.8718148298341023e-19, -3.3308009802648957e-19, -2.586177687802444e-19, -1.3440333513463188e-19, -4.672961634088967e-20, -1.0860726090062399e-20, -1.6854209205534489e-21, -1.743563865263438e-22, -1.199670489765778e-23, -5.472325632485442e-25, -1.646952246133138e-26, -3.2458844645485944e-28, -4.136692282368605e-30, -3.3293374293995357e-32, -1.6044893128639897e-34, -3.906751690679585e-37, 0., 2.8326243682691175e-42, 8.43528190933074e-45, 1.2692390524596671e-47, 1.1437012520572633e-50, 6.509328089179544e-54, 2.3961762318803346e-57, 5.777751706703843e-61, 9.194749252691762e-65, 9.704666386571835e-69, 6.815982929236023e-73, 3.193129637837006e-77, 9.995579913870836e-82, 2.0935474650571905e-86, 2.9369202150337985e-91, 2.7618107321145593e-96, 1.7421151326389796e-101, 7.375259968052309e-107, 2.096482813118123e-112, 4.002976593430081e-118, 5.135605572169741e-124, 4.428289043698056e-130, 2.5669550445553213e-136, 1.0005235303822244e-142, 2.6226513500775845e-149, 4.624087637970991e-156, 5.484586257802378e-163, 4.376705450722715e-170, 2.350086991587261e-177}, {-7.256886021690464e-25, -6.539126688615311e-24, -3.832519521681648e-23, -1.4920588474064695e-22, -3.8781743606188705e-22, -6.743739029085034e-22, -7.852225991426961e-22, -6.124025167803496e-22, -3.1989695921557497e-22, -1.118844431180116e-22, -2.618561659107332e-23, -4.097476283015162e-24, -4.281645760550916e-25, -2.982839470930385e-26, -1.3822266503576056e-27, -4.246617835528111e-29, -8.608543657306502e-31, -1.1428220521297054e-32, -9.810969663249945e-35, -5.319165102889854e-37, -1.7268761337006036e-39, -2.8326243682691175e-42, 0., 9.321482502338036e-48, 1.8701117118879377e-50, 1.8957856993186845e-53, 1.1509104456726562e-56, 4.4131927180137303e-60, 1.0945294913665443e-63, 1.7781292503182772e-67, 1.9065292425223835e-71, 1.355771144690393e-75, 6.415629100103768e-80, 2.0250456494580683e-84, 4.271064090407401e-89, 6.027300551642859e-94, 5.69699807186882e-99, 3.609636857836423e-104, 1.5341357041303853e-109, 4.3760583644431e-115, 8.381414860657993e-121, 1.0782777646255026e-126, 9.320990048774494e-133, 5.4153964974457215e-139, 2.1151322865638935e-145, 5.554852576771444e-152, 9.810986371560946e-159, 1.1655365975406789e-165, 9.31477323547549e-173, 5.008469741193066e-180}, {-1.1296474706354183e-27, -1.0200085586130949e-26, -5.991758407608037e-26, -2.3385301080989554e-25, -6.0952152263665695e-25, -1.0631754949364316e-24, -1.2422309569642105e-24, -9.726269728557932e-25, -5.103333546096103e-25, -1.794051917363346e-25, -4.2238212395686685e-26, -6.655575711062652e-27, -7.012680250475256e-28, -4.9347822130031586e-29, -2.3153273581886887e-30, -7.226295970850181e-32, -1.495399030374946e-33, -2.0419282464489633e-35, -1.826007532106495e-37, -1.0559973445536015e-39, -3.856852811151428e-42, -8.43528190933074e-45, -9.321482502338036e-48, 0., 1.3922530347145151e-53, 1.8818222649599512e-56, 1.2852375747019614e-59, 5.256824747207657e-63, 1.3580846501064712e-66, 2.2693273920941155e-70, 2.483888762848099e-74, 1.794380259460427e-78, 8.597305845097792e-83, 2.7410865671540517e-87, 5.8294575789980406e-92, 8.284024233156779e-97, 7.876658341601949e-102, 5.0162700425016316e-107, 2.141488135603629e-112, 6.132460869650679e-118, 1.1786215373193847e-123, 1.5210033569762638e-129, 1.3184579048924036e-135, 7.679299033898424e-142, 3.0061785199785364e-148, 7.911302688556447e-155, 1.3999414920773845e-161, 1.6660106243859676e-168, 1.3335815122217564e-175, 7.18117081040758e-183}, {-1.1824565526307955e-30, -1.0696990031118426e-29, -6.296660039574961e-29, -2.4631158025649217e-28, -6.436029201446654e-28, -1.1257413525724453e-27, -1.3194061294404734e-27, -1.0366396445405671e-27, -5.460535607195457e-28, -1.9281943052099635e-28, -4.5629192046354307e-29, -7.23269747620672e-30, -7.6740595314589056e-31, -5.44519254894413e-32, -2.5806104985727467e-33, -8.154941188767008e-35, -1.7143583513818672e-36, -2.38968045881547e-38, -2.1980439726823035e-40, -1.3241140835677962e-42, -5.158511078291881e-45, -1.2692390524596671e-47, -1.8701117118879377e-50, -1.3922530347145151e-53, 0., 9.438460718320268e-60, 8.594977034342356e-63, 3.9549165829964234e-66, 1.0898566871792389e-69, 1.8970049975950947e-73, 2.1356885476703778e-77, 1.5749802114155695e-81, 7.665887122124048e-86, 2.474673037321569e-90, 5.316037389830787e-95, 7.617375513012843e-100, 7.293440886835636e-105, 4.6724944083114795e-110, 2.0049567791960401e-115, 5.767115215520822e-121, 1.1127510168784197e-126, 1.4409839865066886e-132, 1.252961533836019e-138, 7.318090070888411e-145, 2.871957666363801e-151, 7.57525367342269e-158, 1.3432513820016147e-164, 1.6015736932646065e-171, 1.2842316380318756e-178, 6.926510283680408e-186}, {-8.324347022248311e-34, -7.543544911681008e-33, -4.448830253215053e-32, -1.7438882455365585e-31, -4.567070742382481e-31, -8.008394303997788e-31, -9.412175726631532e-31, -7.4179146347528915e-31, -3.920979899041831e-31, -1.3899844867235662e-31, -3.3039725917005945e-32, -5.2639943839527064e-33, -5.6184653123104035e-34, -4.0145071543360543e-35, -1.9184283278791054e-36, -6.123627400982023e-38, -1.3034205491832348e-39, -1.8457046780234677e-41, -1.7330600046671362e-43, -1.073833836957314e-45, -4.357775113039506e-48, -1.1437012520572633e-50, -1.8957856993186845e-53, -1.8818222649599512e-56, -9.438460718320268e-60, 0., 2.9043246354570633e-66, 1.7818719960552028e-69, 5.524094386253025e-73, 1.0256257022838521e-76, 1.202782516245392e-80, 9.123442634182896e-85, 4.533158527568138e-89, 1.4866055088846065e-93, 3.2334114363180476e-98, 4.679970484573599e-103, 4.518292477934868e-108, 2.914856088950615e-113, 1.258203141980095e-118, 3.637691273347799e-124, 7.050171960619088e-130, 9.16559471386125e-136, 7.997322105537548e-142, 4.685404479042321e-148, 1.8438775346642828e-154, 4.8757150391776774e-161, 8.665314780544465e-168, 1.0353142823624188e-174, 8.317453718271146e-182, 4.49382493968043e-189}, {-3.941870992615541e-37, -3.5778147103230526e-36, -2.1136973048276577e-35, -8.3011327262988e-35, -2.1784855173260736e-34, -3.828673209434217e-34, -4.511074233945619e-34, -3.5651391000433627e-34, -1.8903044288761415e-34, -6.724383041180261e-35, -1.60464405628588e-35, -2.567983286827608e-36, -2.7549640722565288e-37, -1.980194704284577e-38, -9.529008005692451e-40, -3.067008609452823e-41, -6.5941011761794184e-43, -9.454276241316939e-45, -9.01818414421179e-47, -5.704235229623759e-49, -2.381001190885009e-51, -6.509328089179544e-54, -1.1509104456726562e-56, -1.2852375747019614e-59, -8.594977034342356e-63, -2.9043246354570633e-66, 0., 4.0565801303027064e-73, 1.6768081788741094e-76, 3.5023836063055274e-80, 4.38117545348113e-84, 3.4617129430656307e-88, 1.7691622727900867e-92, 5.922667379592046e-97, 1.308645450996305e-101, 1.917781724853216e-106, 1.8702308103208324e-111, 1.2165840242955046e-116, 5.28813107557105e-122, 1.537994233351957e-127, 2.9960567744164045e-133, 3.912420071521357e-139, 3.427119135066988e-145, 2.0148237285860096e-151, 7.953614351117565e-158, 2.108994625101771e-164, 3.757583125996039e-171, 4.499687686509865e-178, 3.622419891697881e-185, 1.9608586877249027e-192}, {-1.2557382244599895e-40, -1.1414386528454213e-39, -6.754184331989725e-39, -2.6571869549295953e-38, -6.986524404467181e-38, -1.230419013559264e-37, -1.45301675112936e-37, -1.1512091217449312e-37, -6.120884659909298e-38, -2.184124427453173e-38, -5.230088029182914e-39, -8.402765906212454e-40, -9.054834378757079e-41, -6.541749746507701e-42, -3.1667308010137773e-43, -1.02637225619752e-44, -2.225100543117081e-46, -3.222456966358747e-48, -3.1122392076747083e-50, -1.9998191446722682e-52, -8.521337183900028e-55, -2.3961762318803346e-57, -4.4131927180137303e-60, -5.256824747207657e-63, -3.9549165829964234e-66, -1.7818719960552028e-69, -4.0565801303027064e-73, 0., 2.5719038948119262e-80, 7.162651162027686e-84, 1.0079831152984101e-87, 8.495371731279972e-92, 4.5225957638540705e-96, 1.557298630286588e-100, 3.5126218704152035e-105, 5.2293535085857803e-110, 5.163439168864271e-115, 3.39274150829334e-120, 1.4870137988926244e-125, 4.355058057555492e-131, 8.534276387692915e-137, 1.1201691376592635e-142, 9.856025680045543e-149, 5.817139334624075e-155, 2.304317371461911e-161, 6.129086141656559e-168, 1.09504899351718e-174, 1.314602398962023e-181, 1.0607102169416587e-188, 5.75363741208958e-196}, {-2.691480888712245e-44, -2.4498323169091785e-43, -1.4517758825398945e-42, -5.720634586943327e-42, -1.5067386025123913e-41, -2.658590923402557e-41, -3.1460624273001057e-41, -2.498255487846055e-41, -1.3316310693143166e-41, -4.764878168710298e-42, -1.144526654542028e-42, -1.8452046154796772e-43, -1.9961931619831176e-44, -1.4486066632234357e-45, -7.048377537819422e-47, -2.298054580483705e-48, -5.016854775118436e-50, -7.326105026973407e-52, -7.147000114508619e-54, -4.6498246233717495e-56, -2.0127647886273544e-58, -5.777751706703843e-61, -1.0945294913665443e-63, -1.3580846501064712e-66, -1.0898566871792389e-69, -5.524094386253025e-73, -1.6768081788741094e-76, -2.5719038948119262e-80, 0., 7.401796380892604e-88, 1.3888499488141133e-91, 1.3168520352132652e-95, 7.477752513673152e-100, 2.682155695536515e-104, 6.222686766132277e-109, 9.456912775405404e-114, 9.485929035307841e-119, 6.310831876182727e-124, 2.7939307809100837e-129, 8.250850479748078e-135, 1.6281631690493954e-140, 2.1497712401301024e-146, 1.901218063564998e-152, 1.1271301619023879e-158, 4.482359485171094e-165, 1.1963698793138015e-171, 2.144103685805135e-178, 2.5811387727517017e-185, 2.0878571534828923e-192, 1.135095579731293e-199}, {-3.8817236095377765e-48, -3.5376896548094705e-47, -2.0993220269735873e-46, -8.284505975644386e-46, -2.1855248589559317e-45, -3.862993631046118e-45, -4.57995868142207e-45, -3.644427414643277e-45, -1.946983572659804e-45, -6.984209598860104e-46, -1.6822714551034673e-46, -2.720552960765633e-47, -2.9533884423931576e-48, -2.151633368175475e-49, -1.0515779004815789e-50, -3.446149320669468e-52, -7.568027552205009e-54, -1.1128862330800526e-55, -1.0947262776091147e-57, -7.194210355864294e-60, -3.1530772964311944e-62, -9.194749252691762e-65, -1.7781292503182772e-67, -2.2693273920941155e-70, -1.8970049975950947e-73, -1.0256257022838521e-76, -3.5023836063055274e-80, -7.162651162027686e-84, -7.401796380892604e-88, 0., 9.66973116668785e-96, 1.2224603699572473e-99, 7.809467459028024e-104, 2.9878792357874865e-108, 7.220807428283099e-113, 1.12873414377004e-117, 1.1557848384056716e-122, 7.81129710734425e-128, 3.501444287127326e-133, 1.0444679080614408e-138, 2.0782530861857627e-144, 2.7632438429886764e-150, 2.4583081289161605e-156, 1.464872806518786e-162, 5.851497571479955e-169, 1.5679261391793006e-175, 2.8197543050319786e-182, 3.405017337047599e-189, 2.7619350147323153e-196, 1.505331681952546e-203}, {-3.7673854149825274e-52, -3.437541340333299e-51, -2.042497472323219e-50, -8.071332331954305e-50, -2.1324422948068166e-49, -3.775208627477476e-49, -4.483665071184566e-49, -3.574560548297067e-49, -1.913611935528314e-49, -6.880100165528903e-50, -1.6613482116764188e-50, -2.694179196189858e-51, -2.9338124854879147e-52, -2.1447931172371256e-53, -1.0523455572870142e-54, -3.4640608518645467e-56, -7.646374865624521e-58, -1.131100186588309e-59, -1.1204237382263925e-61, -7.42444535580745e-64, -3.2868531850667313e-66, -9.704666386571835e-69, -1.9065292425223835e-71, -2.483888762848099e-74, -2.1356885476703778e-77, -1.202782516245392e-80, -4.38117545348113e-84, -1.0079831152984101e-87, -1.3888499488141133e-91, -9.66973116668785e-96, 0., 5.734466117661765e-104, 4.884480254340898e-108, 2.1023862199174223e-112, 5.4195589887103435e-117, 8.824672851526502e-122, 9.294336697219832e-127, 6.412382312858751e-132, 2.9200002982494095e-137, 8.819131285172996e-143, 1.7725314380948057e-148, 2.3763961924741496e-154, 2.1289350335142023e-160, 1.2761550145381709e-166, 5.123798043161933e-173, 1.379066073595044e-179, 2.4898347696316588e-186, 3.0170599618116847e-193, 2.4548251147070793e-200, 1.3416647363360315e-207}, {-2.4607903523381173e-56, -2.2478204152194048e-55, -1.337186205065694e-54, -5.290904099075654e-54, -1.3997745624882958e-53, -2.4817880508214766e-53, -2.952244508749799e-53, -2.3577429591889873e-53, -1.26458905700191e-53, -4.5560506154932526e-54, -1.1026568009945448e-54, -1.7926407565450755e-55, -1.9575093332438135e-56, -1.4354873976415174e-57, -7.067693439079242e-59, -2.335633142239807e-60, -5.178562261119543e-62, -7.699741596533992e-64, -7.672462967643139e-66, -5.1196817968828165e-68, -2.2854061092718763e-70, -6.815982929236023e-73, -1.355771144690393e-75, -1.794380259460427e-78, -1.5749802114155695e-81, -9.123442634182896e-85, -3.4617129430656307e-88, -8.495371731279972e-92, -1.3168520352132652e-95, -1.2224603699572473e-99, -5.734466117661765e-104, 0., 1.5437563454040946e-112, 8.859549425900586e-117, 2.569304657546112e-121, 4.4625078620562676e-126, 4.895843742331929e-131, 3.474265558025695e-136, 1.615032781378728e-141, 4.9552284145371575e-147, 1.0083860968829757e-152, 1.3655781392562101e-158, 1.2335712554137866e-164, 7.446148928203849e-171, 3.0074451349022106e-177, 8.136024434896165e-184, 1.4754761603898413e-190, 1.794921236428727e-197, 1.4655052114276556e-204, 8.03439727483222e-212}, {-1.0818368473743093e-60, -9.892303939583076e-60, -5.8912915558861995e-59, -2.3338085571745703e-58, -6.182266691344959e-58, -1.0976161209529534e-57, -1.3076184340111478e-57, -1.0459732915731098e-57, -5.61989493798356e-58, -2.0285656489931e-58, -4.919705636383951e-59, -8.016373371775662e-60, -8.775575514729228e-61, -6.453210793981051e-62, -3.1871071091397627e-63, -1.0568879333084223e-64, -2.3525198536996274e-66, -3.5134578311325453e-68, -3.5189642591452166e-70, -2.36211178831973e-72, -1.06181123544817e-74, -3.193129637837006e-77, -6.415629100103768e-80, -8.597305845097792e-83, -7.665887122124048e-86, -4.533158527568138e-89, -1.7691622727900867e-92, -4.5225957638540705e-96, -7.477752513673152e-100, -7.809467459028024e-104, -4.884480254340898e-108, -1.5437563454040946e-112, 0., 1.8865877548690528e-121, 7.294906279370285e-126, 1.425396306941383e-130, 1.6680647577012502e-135, 1.2330399180671457e-140, 5.895625978747289e-146, 1.8465756439826774e-151, 3.817417836418019e-157, 5.234249700047639e-163, 4.77602869431073e-169, 2.9069564724126273e-175, 1.1823089537248229e-181, 3.2175324265705364e-188, 5.8649504200395405e-195, 7.1665814961647365e-202, 5.874268591091127e-209, 3.231655739692131e-216}, {-3.2013407353856253e-65, -2.9301418658752668e-64, -1.7468428614062207e-63, -6.927736627100809e-63, -1.8373444688234725e-62, -3.2662365031885696e-62, -3.8964968951620165e-62, -3.1214531316908443e-62, -1.679808782637508e-62, -6.074007959287653e-63, -1.4758667796547594e-63, -2.409817793637022e-64, -2.644038598033133e-65, -1.9491942888539452e-66, -9.653407486287438e-68, -3.2111116573064834e-69, -7.17241020746108e-71, -1.0753908897918566e-72, -1.0818846605654618e-74, -7.299414305141728e-77, -3.3007475279012164e-79, -9.995579913870836e-82, -2.0250456494580683e-84, -2.7410865671540517e-87, -2.474673037321569e-90, -1.4866055088846065e-93, -5.922667379592046e-97, -1.557298630286588e-100, -2.682155695536515e-104, -2.9878792357874865e-108, -2.1023862199174223e-112, -8.859549425900586e-117, -1.8865877548690528e-121, 0., 1.0466286168118733e-130, 2.7267621323877023e-135, 3.5898562159242657e-140, 2.830544633742644e-145, 1.4097807033807608e-150, 4.5417497119653603e-156, 9.58474659522165e-162, 1.3350723401435543e-167, 1.2334237900450677e-173, 7.583133952616262e-180, 3.109891960318499e-186, 8.522435246739108e-193, 1.562724948836082e-199, 1.919339072659912e-206, 1.580257864568617e-213, 8.727684441238163e-221}, {-6.37694513286429e-70, -5.842051014592623e-69, -3.4862203517425385e-68, -1.3840268566611264e-67, -3.6747394597307325e-67, -6.540339679688605e-67, -7.812343158147586e-67, -6.267003603094502e-67, -3.37758196224284e-67, -1.2232545319142668e-67, -2.977441742951036e-68, -4.870819900784146e-69, -5.355301009934402e-70, -3.956918807994517e-71, -1.9645801124638668e-72, -6.5531364778018345e-74, -1.4682547463872885e-75, -2.20906249069998e-77, -2.231117263371594e-79, -1.5120423229208685e-81, -6.872420107528054e-84, -2.0935474650571905e-86, -4.271064090407401e-89, -5.8294575789980406e-92, -5.316037389830787e-95, -3.2334114363180476e-98, -1.308645450996305e-101, -3.5126218704152035e-105, -6.222686766132277e-109, -7.220807428283099e-113, -5.4195589887103435e-117, -2.569304657546112e-121, -7.294906279370285e-126, -1.0466286168118733e-130, 0., 2.6359063010144495e-140, 4.6269894034870116e-145, 4.1043461474497413e-150, 2.1804907996641146e-155, 7.317364027469607e-161, 1.588351273196069e-166, 2.2585284267435103e-172, 2.1196907669008867e-178, 1.3194834486476722e-184, 5.465945866585616e-191, 1.510385678680124e-197, 2.788901328770652e-204, 3.4457179943046302e-211, 2.851526728670061e-218, 1.5819145538957885e-225}, {-8.551245540919438e-75, -7.840702941926645e-74, -4.683208022687917e-73, -1.861047489958794e-72, -4.946427471521471e-72, -8.813496061542816e-72, -1.0540129128723287e-71, -8.466011714165541e-72, -4.56899798286851e-72, -1.6571996243987723e-72, -4.0401425913615154e-73, -6.620794846697392e-74, -7.293125639921071e-75, -5.3998933030287155e-76, -2.687099176916017e-77, -8.985665778880477e-79, -2.0188644599199497e-80, -3.0468862345621087e-82, -3.0879907361673994e-84, -2.1009577774994083e-86, -9.59174394714558e-89, -2.9369202150337985e-91, -6.027300551642859e-94, -8.284024233156779e-97, -7.617375513012843e-100, -4.679970484573599e-103, -1.917781724853216e-106, -5.2293535085857803e-110, -9.456912775405404e-114, -1.12873414377004e-117, -8.824672851526502e-122, -4.4625078620562676e-126, -1.425396306941383e-130, -2.7267621323877023e-135, -2.6359063010144495e-140, 0., 3.013652428790637e-150, 3.564325643088145e-155, 2.130297096448227e-160, 7.625517138936208e-166, 1.7242092192937349e-171, 2.5217581029941265e-177, 2.4160460883048757e-183, 1.527833674414476e-189, 6.408147345941123e-196, 1.7886271855830844e-202, 3.33019175940853e-209, 4.143260867028956e-216, 3.4491923713889185e-223, 1.9232885750584237e-230}, {-7.719783631420196e-80, -7.08406751474881e-79, -4.234937129850926e-78, -1.6844571127692852e-77, -4.481449129398256e-77, -7.993319912591339e-77, -9.56990726384389e-77, -7.695863792172122e-77, -4.158663440773595e-77, -1.5104410611602259e-77, -3.6878103045006463e-78, -6.053094287907647e-79, -6.679372158238167e-80, -4.954831327580913e-81, -2.470731902618137e-82, -8.280910695206141e-84, -1.8651857915816532e-85, -2.8227724853639407e-87, -2.869710676637069e-89, -1.9592272125800286e-91, -8.979762310432747e-94, -2.7618107321145593e-96, -5.69699807186882e-99, -7.876658341601949e-102, -7.293440886835636e-105, -4.518292477934868e-108, -1.8702308103208324e-111, -5.163439168864271e-115, -9.485929035307841e-119, -1.1557848384056716e-122, -9.294336697219832e-127, -4.895843742331929e-131, -1.6680647577012502e-135, -3.5898562159242657e-140, -4.6269894034870116e-145, -3.013652428790637e-150, 0., 1.5641770891854882e-160, 1.2464861501022255e-165, 5.019599945242849e-171, 1.210649678100677e-176, 1.8444238097886787e-182, 1.817594358010033e-188, 1.1733367460178731e-194, 4.99940715802662e-201, 1.412865686494052e-207, 2.657144040575489e-214, 3.333437050391371e-221, 2.794433967001028e-228, 1.5674666499205776e-235}, {-4.69203424468287e-85, -4.308949323836612e-84, -2.578043918267457e-83, -1.0263113975911483e-82, -2.732981231396623e-82, -4.879436786499499e-82, -5.847932958002389e-82, -4.707982567774953e-82, -2.5471115063740941e-82, -9.263012865407114e-83, -2.2647131737965697e-83, -3.722759622787808e-84, -4.114514769640325e-85, -3.0575002217913643e-86, -1.527513280834409e-87, -5.130216626489838e-89, -1.1581521406837063e-90, -1.7571404924272168e-92, -1.791321036320575e-94, -1.2267684681236036e-96, -5.642193765283229e-99, -1.7421151326389796e-101, -3.609636857836423e-104, -5.0162700425016316e-107, -4.6724944083114795e-110, -2.914856088950615e-113, -1.2165840242955046e-116, -3.39274150829334e-120, -6.310831876182727e-124, -7.81129710734425e-128, -6.412382312858751e-132, -3.474265558025695e-136, -1.2330399180671457e-140, -2.830544633742644e-145, -4.1043461474497413e-150, -3.564325643088145e-155, -1.5641770891854882e-160, 0., 3.6856295255874002e-171, 1.9789374328581412e-176, 5.369501536440823e-182, 8.725793351810357e-188, 8.957151844906131e-194, 5.947440405140431e-200, 2.586906770159729e-206, 7.426814421080657e-213, 1.4142032265649203e-219, 1.7920651313369392e-226, 1.5148146877741792e-233, 8.556387011867756e-241}, {-1.920069967944367e-90, -1.764583328432896e-89, -1.0565652172144715e-88, -4.209590208174463e-88, -1.1219491339476401e-87, -2.0049576282777306e-87, -2.4052610078567205e-87, -1.9384152887063407e-87, -1.0498874778218783e-87, -3.8226433021024435e-88, -9.357913249773955e-89, -1.5403767410707671e-89, -1.7049965565328353e-90, -1.2690151457897155e-91, -6.350968253630295e-93, -2.137038765849693e-94, -4.8343772958041785e-96, -7.35135384565567e-98, -7.513137932493425e-100, -5.159590587767299e-102, -2.380362620033463e-104, -7.375259968052309e-107, -1.5341357041303853e-109, -2.141488135603629e-112, -2.0049567791960401e-115, -1.258203141980095e-118, -5.28813107557105e-122, -1.4870137988926244e-125, -2.7939307809100837e-129, -3.501444287127326e-133, -2.9200002982494095e-137, -1.615032781378728e-141, -5.895625978747289e-146, -1.4097807033807608e-150, -2.1804907996641146e-155, -2.130297096448227e-160, -1.2464861501022255e-165, -3.6856295255874002e-171, 0., 3.942517313146774e-182, 1.4263110710419086e-187, 2.6075805219446325e-193, 2.855166667823272e-199, 1.9747876121841714e-205, 8.834979152672619e-212, 2.5892987778856547e-218, 5.008767151695465e-225, 6.4264012801460805e-232, 5.487042999207563e-239, 3.1251682265927824e-246}, {-5.290427850604715e-96, -4.8653540962657814e-95, -2.9153179204796637e-94, -1.1624242633512565e-93, -3.100649560324401e-93, -5.545753545724507e-93, -6.6591157193044324e-93, -5.37187007851897e-93, -2.9125513062524387e-93, -1.0616403619662462e-93, -2.6020124540010235e-94, -4.2885611700340243e-95, -4.753399453211009e-96, -3.5431581222825657e-97, -1.776065991116711e-98, -5.986682076637373e-100, -1.3568632697899476e-101, -2.067574193614485e-103, -2.1178785440991196e-105, -1.458082259827489e-107, -6.74550715128775e-110, -2.096482813118123e-112, -4.3760583644431e-115, -6.132460869650679e-118, -5.767115215520822e-121, -3.637691273347799e-124, -1.537994233351957e-127, -4.355058057555492e-131, -8.250850479748078e-135, -1.0444679080614408e-138, -8.819131285172996e-143, -4.9552284145371575e-147, -1.8465756439826774e-151, -4.5417497119653603e-156, -7.317364027469607e-161, -7.625517138936208e-166, -5.019599945242849e-171, -1.9789374328581412e-176, -3.942517313146774e-182, 0., 1.9145849778098417e-193, 4.666989875355224e-199, 5.748878336229223e-205, 4.241317365801127e-211, 1.9765812554729757e-217, 5.958346647437125e-224, 1.1766011949421428e-230, 1.533577427146642e-237, 1.3257793872531338e-244, 7.627304846674844e-252}, {-9.815197726569329e-102, -9.032461740768765e-101, -5.415997351518303e-100, -2.1610983817213985e-99, -5.768963474186096e-99, -1.0326671007162734e-98, -1.2410583116840004e-98, -1.002074730148232e-98, -5.4384171567420375e-99, -1.984396758272892e-99, -4.869039257133709e-100, -8.034562325130041e-101, -8.916804142169321e-102, -6.655667212345453e-103, -3.341204717968902e-104, -1.128042885643854e-105, -2.5611212548472854e-107, -3.9100013422053973e-109, -4.0134243852723586e-111, -2.769376314321014e-113, -1.2844040021668819e-115, -4.002976593430081e-118, -8.381414860657993e-121, -1.1786215373193847e-123, -1.1127510168784197e-126, -7.050171960619088e-130, -2.9960567744164045e-133, -8.534276387692915e-137, -1.6281631690493954e-140, -2.0782530861857627e-144, -1.7725314380948057e-148, -1.0083860968829757e-152, -3.817417836418019e-157, -9.58474659522165e-162, -1.588351273196069e-166, -1.7242092192937349e-171, -1.210649678100677e-176, -5.369501536440823e-182, -1.4263110710419086e-187, -1.9145849778098417e-193, 0., 4.221020986681865e-205, 6.932701592874794e-211, 5.754037427881334e-217, 2.8603245120512317e-223, 8.981630171504404e-230, 1.824286918285471e-236, 2.4273053265068387e-243, 2.1317162136684536e-250, 1.24172167587854e-257}, {-1.2261885317535194e-107, -1.1291034869841068e-106, -6.774724981980148e-106, -2.705133026809359e-105, -7.226520326443093e-105, -1.2945743970809558e-104, -1.5570893376444637e-104, -1.2583379760930661e-104, -6.835474931473026e-105, -2.4966002485025293e-105, -6.132194640550621e-106, -1.0130192468707554e-106, -1.125593068561326e-107, -8.4123645004711955e-109, -4.2288834717988516e-110, -1.429852260091432e-111, -3.25155514131821e-113, -4.972703078878411e-115, -5.113902648961815e-117, -3.536043309338446e-119, -1.6437023090188017e-121, -5.135605572169741e-124, -1.0782777646255026e-126, -1.5210033569762638e-129, -1.4409839865066886e-132, -9.16559471386125e-136, -3.912420071521357e-139, -1.1201691376592635e-142, -2.1497712401301024e-146, -2.7632438429886764e-150, -2.3763961924741496e-154, -1.3655781392562101e-158, -5.234249700047639e-163, -1.3350723401435543e-167, -2.2585284267435103e-172, -2.5217581029941265e-177, -1.8444238097886787e-182, -8.725793351810357e-188, -2.6075805219446325e-193, -4.666989875355224e-199, -4.221020986681865e-205, 0., 4.224786117853267e-217, 4.675344740431499e-223, 2.614621254610744e-229, 8.757444054020842e-236, 1.85286643407889e-242, 2.5357698586298345e-249, 2.2733675545676644e-256, 1.3452529588512194e-263}, {-1.031524858812811e-113, -9.504135748552006e-113, -5.70613515659669e-112, -2.279946399663106e-111, -6.0948932163812345e-111, -1.092650419843976e-110, -1.3152338787709455e-110, -1.0637545504797679e-110, -5.783472462137724e-111, -2.1143066265387856e-111, -5.198274578774615e-112, -8.596331125618169e-113, -9.562240596608513e-114, -7.155056187539414e-115, -3.6014300614958456e-116, -1.2193730222474547e-117, -2.7770229100741255e-119, -4.253792440537331e-121, -4.382186554076445e-123, -3.0358319742312233e-125, -1.414104653047222e-127, -4.428289043698056e-130, -9.320990048774494e-133, -1.3184579048924036e-135, -1.252961533836019e-138, -7.997322105537548e-142, -3.427119135066988e-145, -9.856025680045543e-149, -1.901218063564998e-152, -2.4583081289161605e-156, -2.1289350335142023e-160, -1.2335712554137866e-164, -4.77602869431073e-169, -1.2334237900450677e-173, -2.1196907669008867e-178, -2.4160460883048757e-183, -1.817594358010033e-188, -8.957151844906131e-194, -2.855166667823272e-199, -5.748878336229223e-205, -6.932701592874794e-211, -4.224786117853267e-217, 0., 1.919723334206154e-229, 1.4314379541345128e-235, 5.39378504641258e-242, 1.2172761158452024e-248, 1.735336051154685e-255, 1.600213270993858e-262, 9.666450001154072e-270}, {-5.8435895163991595e-120, -5.38712430463464e-119, -3.2362706609148655e-118, -1.2938947113399984e-117, -3.461194682759942e-117, -6.209291174575713e-117, -7.479647429430246e-117, -6.054172676016368e-117, -3.294251221888581e-117, -1.2053463703861876e-117, -2.966211358458397e-118, -4.909986937641612e-119, -5.467377010425398e-120, -4.0955781911379475e-121, -2.0639247939079575e-122, -6.996966037006936e-124, -1.5956909986373e-125, -2.4478711325643947e-127, -2.525797594350763e-129, -1.752831029850576e-131, -8.180232036665062e-134, -2.5669550445553213e-136, -5.4153964974457215e-139, -7.679299033898424e-142, -7.318090070888411e-145, -4.685404479042321e-148, -2.0148237285860096e-151, -5.817139334624075e-155, -1.1271301619023879e-158, -1.464872806518786e-162, -1.2761550145381709e-166, -7.446148928203849e-171, -2.9069564724126273e-175, -7.583133952616262e-180, -1.3194834486476722e-184, -1.527833674414476e-189, -1.1733367460178731e-194, -5.947440405140431e-200, -1.9747876121841714e-205, -4.241317365801127e-211, -5.754037427881334e-217, -4.675344740431499e-223, -1.919723334206154e-229, 0., 3.960239479245786e-242, 1.9896711016286113e-248, 5.051603791686384e-255, 7.68161421981742e-262, 7.378626684096105e-269, 4.5845755681037965e-276}, {-2.2293057943331694e-126, -2.0562696520924437e-125, -1.2359877277628926e-124, -4.9445490779925436e-124, -1.3235041302822812e-123, -2.3758932574342238e-123, -2.8639596054888698e-123, -2.3198393763016913e-123, -1.263266736974515e-123, -4.625992033645359e-124, -1.139386211765999e-124, -1.8877661182928958e-125, -2.104123348525203e-126, -1.5778276035600945e-127, -7.960145642461407e-129, -2.7018026369279266e-130, -6.16945713526703e-132, -9.47726131995961e-134, -9.79345141994339e-136, -6.8072657989672e-138, -3.182386455000812e-140, -1.0005235303822244e-142, -2.1151322865638935e-145, -3.0061785199785364e-148, -2.871957666363801e-151, -1.8438775346642828e-154, -7.953614351117565e-158, -2.304317371461911e-161, -4.482359485171094e-165, -5.851497571479955e-169, -5.123798043161933e-173, -3.0074451349022106e-177, -1.1823089537248229e-181, -3.109891960318499e-186, -5.465945866585616e-191, -6.408147345941123e-196, -4.99940715802662e-201, -2.586906770159729e-206, -8.834979152672619e-212, -1.9765812554729757e-217, -2.8603245120512317e-223, -2.614621254610744e-229, -1.4314379541345128e-235, -3.960239479245786e-242, 0., 3.70898592569013e-255, 1.2555728331308218e-261, 2.147917739109983e-268, 2.200743429390565e-275, 1.424366590324181e-282}, {-5.727447040466372e-133, -5.2855982379620896e-132, -3.1787997599364247e-131, -1.2723950568617812e-130, -3.407838570213874e-130, -6.121419702203218e-130, -7.383762962086481e-130, -5.985075536883375e-130, -3.2615506845197895e-130, -1.1952787115959427e-130, -2.9463879827102953e-131, -4.8858824261455563e-132, -5.450859711703032e-133, -4.0914540845257657e-134, -2.066290127189805e-135, -7.021125333940566e-137, -1.60515422170674e-138, -2.4689197316380126e-140, -2.554794880435601e-142, -1.7784263952700232e-144, -8.327440377596768e-147, -2.6226513500775845e-149, -5.554852576771444e-152, -7.911302688556447e-155, -7.57525367342269e-158, -4.8757150391776774e-161, -2.108994625101771e-164, -6.129086141656559e-168, -1.1963698793138015e-171, -1.5679261391793006e-175, -1.379066073595044e-179, -8.136024434896165e-184, -3.2175324265705364e-188, -8.522435246739108e-193, -1.510385678680124e-197, -1.7886271855830844e-202, -1.412865686494052e-207, -7.426814421080657e-213, -2.5892987778856547e-218, -5.958346647437125e-224, -8.981630171504404e-230, -8.757444054020842e-236, -5.39378504641258e-242, -1.9896711016286113e-248, -3.70898592569013e-255, 0., 1.5770365625377082e-268, 3.597130827213256e-275, 4.14629812146301e-282, 2.862474411202054e-289}, {-9.909798079863628e-140, -9.149781634750772e-139, -5.50559323739955e-138, -2.2049455421640465e-137, -5.908825668901155e-137, -1.0620201374543118e-136, -1.2818283124387178e-136, -1.03969840003819e-136, -5.669734647279585e-137, -2.0793382240976963e-137, -5.129571883705255e-138, -8.513122220824747e-139, -9.505757069844075e-140, -7.141646879785075e-141, -3.610242000818892e-142, -1.2280156288969257e-143, -2.8105851769543687e-145, -4.328163581522783e-147, -4.484427773929628e-149, -3.125957297397164e-151, -1.4658907369551357e-153, -4.624087637970991e-156, -9.810986371560946e-159, -1.3999414920773845e-161, -1.3432513820016147e-164, -8.665314780544465e-168, -3.757583125996039e-171, -1.09504899351718e-174, -2.144103685805135e-178, -2.8197543050319786e-182, -2.4898347696316588e-186, -1.4754761603898413e-190, -5.8649504200395405e-195, -1.562724948836082e-199, -2.788901328770652e-204, -3.33019175940853e-209, -2.657144040575489e-214, -1.4142032265649203e-219, -5.008767151695465e-225, -1.1766011949421428e-230, -1.824286918285471e-236, -1.85286643407889e-242, -1.2172761158452024e-248, -5.051603791686384e-255, -1.2555728331308218e-261, -1.5770365625377082e-268, 0., 3.0442685914385e-282, 4.678708577557841e-289, 3.6337881616206534e-296}, {-1.1547578199970608e-146, -1.066695679570765e-145, -6.421676661956211e-145, -2.57315865144489e-144, -6.899296630593111e-144, -1.2407453629144197e-143, -1.498436007631165e-143, -1.21615025542803e-143, -6.636333755470488e-144, -2.435518793678092e-144, -6.012634700153965e-145, -9.986373391143272e-146, -1.1159900279636417e-146, -8.391658950643558e-148, -4.246046552698238e-149, -1.4456949167172207e-150, -3.31223899626585e-152, -5.106359637946832e-154, -5.29701832815678e-156, -3.6971049880617105e-158, -1.736107015783124e-160, -5.484586257802378e-163, -1.1655365975406789e-165, -1.6660106243859676e-168, -1.6015736932646065e-171, -1.0353142823624188e-174, -4.499687686509865e-178, -1.314602398962023e-181, -2.5811387727517017e-185, -3.405017337047599e-189, -3.0170599618116847e-193, -1.794921236428727e-197, -7.1665814961647365e-202, -1.919339072659912e-206, -3.4457179943046302e-211, -4.143260867028956e-216, -3.333437050391371e-221, -1.7920651313369392e-226, -6.4264012801460805e-232, -1.533577427146642e-237, -2.4273053265068387e-243, -2.5357698586298345e-249, -1.735336051154685e-255, -7.68161421981742e-262, -2.147917739109983e-268, -3.597130827213256e-275, -3.0442685914385e-282, 0., 2.6679671314655993e-296, 2.762821468703413e-303}, {-9.062517576561442e-154, -8.375169545360636e-153, -5.0443682686815524e-152, -2.0222713718759173e-151, -5.4250290861094757e-151, -9.761461786609124e-151, -1.179550847174151e-150, -9.579087344435232e-151, -5.23042087250876e-151, -1.9208149537584718e-151, -4.7452568415753755e-152, -7.887149195722541e-153, -8.820796501499101e-154, -6.638194681424799e-155, -3.361729467885715e-156, -1.145654454525496e-157, -2.6273805645619595e-159, -4.0547573554326276e-161, -4.210830548659062e-163, -2.9424885573985325e-165, -1.3835147442744127e-167, -4.376705450722715e-170, -9.31477323547549e-173, -1.3335815122217564e-175, -1.2842316380318756e-178, -8.317453718271146e-182, -3.622419891697881e-185, -1.0607102169416587e-188, -2.0878571534828923e-192, -2.7619350147323153e-196, -2.4548251147070793e-200, -1.4655052114276556e-204, -5.874268591091127e-209, -1.580257864568617e-213, -2.851526728670061e-218, -3.4491923713889185e-223, -2.794433967001028e-228, -1.5148146877741792e-233, -5.487042999207563e-239, -1.3257793872531338e-244, -2.1317162136684536e-250, -2.2733675545676644e-256, -1.600213270993858e-262, -7.378626684096105e-269, -2.200743429390565e-275, -4.14629812146301e-282, -4.678708577557841e-289, -2.6679671314655993e-296, 0., 1.061538766671e-310}, {-4.7901325506854285e-161, -4.428731495059397e-160, -2.6686349097395127e-159, -1.0703531789354332e-158, -2.8727925096648852e-158, -5.171796535357789e-158, -6.252852491505073e-158, -5.080797879248018e-158, -2.775893840511443e-158, -1.0200542364666888e-158, -2.52164000561572e-159, -4.1941531061935446e-160, -4.6940680110663145e-161, -3.5353042304168286e-162, -1.7918194226187878e-163, -6.111685202465258e-165, -1.4029083368632487e-166, -2.1671826056385627e-168, -2.252944823387032e-170, -1.5760877407078996e-172, -7.419354286866282e-175, -2.350086991587261e-177, -5.008469741193066e-180, -7.18117081040758e-183, -6.926510283680408e-186, -4.49382493968043e-189, -1.9608586877249027e-192, -5.75363741208958e-196, -1.135095579731293e-199, -1.505331681952546e-203, -1.3416647363360315e-207, -8.03439727483222e-212, -3.231655739692131e-216, -8.727684441238163e-221, -1.5819145538957885e-225, -1.9232885750584237e-230, -1.5674666499205776e-235, -8.556387011867756e-241, -3.1251682265927824e-246, -7.627304846674844e-252, -1.24172167587854e-257, -1.3452529588512194e-263, -9.666450001154072e-270, -4.5845755681037965e-276, -1.424366590324181e-282, -2.862474411202054e-289, -3.6337881616206534e-296, -2.762821468703413e-303, -1.061538766671e-310, 0.}}, {{0., 9.619630679166936e-9, 1.7602342332100117e-7, 1.6067732041552726e-6, 8.725684189897948e-6, 0.000029808337031566606, 0.00006568179003583159, 0.00009461384683174326, 0.00008981806281935077, 0.00005648523106300115, 0.000023616615844258387, 6.581417430346026e-6, 1.2247838960156434e-6, 1.524266409412512e-7, 1.2700145392056894e-8, 7.09067949821226e-10, 2.6546606657816358e-11, 6.668474488591633e-13, 1.1244784529196788e-14, 1.27338489493297e-16, 9.68727860655851e-19, 4.952280283929566e-21, 1.7016881598932682e-23, 3.9311665777657946e-26, 6.106788162818677e-29, 6.380096753993202e-32, 4.483623779728173e-35, 2.1197066218638074e-38, 6.742454447153967e-42, 1.4431171279762552e-45, 2.0785832905880606e-49, 2.0148955759198478e-53, 1.3145901476529497e-57, 5.773129457339151e-62, 1.7066441378801192e-66, 3.3963361225541636e-71, 4.550273468386672e-76, 4.1043530164522482e-81, 2.492595625255679e-86, 1.01924098325907e-91, 2.806315581479242e-97, 5.202907880665164e-103, 6.495611952036193e-109, 5.460992917553896e-115, 3.0918124591853584e-121, 1.178843656676073e-127, 3.0269943241126915e-134, 5.2346713988541747e-141, 6.096760323927331e-148, 4.782440482948144e-155}, {-9.619630679166936e-9, 0., 1.2321111277270885e-6, 0.000014986948723765203, 0.00009153358842083156, 0.00033347961770205625, 0.000765337783145184, 0.001133861680540057, 0.0010987425934386014, 0.000701915566550361, 0.00029712915689913543, 0.00008363684044334222, 0.000015693865055400444, 1.966743599772143e-6, 1.6484067365382208e-7, 9.250336866066373e-9, 3.478617557418667e-10, 8.772395285366731e-12, 1.4843730998902442e-13, 1.6861241211379986e-15, 1.2862702311935298e-17, 6.592027534438407e-20, 2.270263659704362e-22, 5.255486245033763e-25, 8.179433484974975e-28, 8.560313383402618e-31, 6.025381946257026e-34, 2.852803556270133e-37, 9.086742256692269e-41, 1.9473505706152733e-44, 2.8081797458073856e-48, 2.725154619517352e-52, 1.7798342273099045e-56, 7.823900480547505e-61, 2.3150084656917308e-65, 4.610996668284739e-70, 6.182655820987533e-75, 5.581055450647157e-80, 3.391873879999755e-85, 1.3879203731531953e-90, 3.8239200418373475e-96, 7.093964253915357e-102, 8.861769585611554e-108, 7.454480727758537e-114, 4.222727364358954e-120, 1.610867069131741e-126, 4.138365663105201e-133, 7.15997073525818e-140, 8.342897306313406e-147, 6.547194162576645e-154}, {-1.7602342332100117e-7, -1.2321111277270885e-6, 0., 0.000068436190211104, 0.0005573023720021863, 0.0022841875008412374, 0.005591702424754339, 0.008629379217487366, 0.008601016061274615, 0.005609102985459705, 0.0024120880477410886, 0.0006874489820866792, 0.00013029793207779936, 0.000016464912847828885, 1.3896405863824888e-6, 7.844640567983322e-8, 2.9651291793790472e-9, 7.510858895905529e-11, 1.2758929853817266e-12, 1.4543403454891302e-14, 1.1128873373184297e-16, 5.719297414237989e-19, 1.9746359895209963e-21, 4.5815196676972495e-24, 7.145260985249707e-27, 7.492146734394954e-30, 5.282698460999957e-33, 2.5051776356381454e-36, 7.991306415435127e-40, 1.7149436620656409e-43, 2.476195395416463e-47, 2.4058462002892027e-51, 1.5730375078778302e-55, 6.922054119304314e-60, 2.0501638616962612e-64, 4.0872365954200444e-69, 5.485116871569749e-74, 4.955435397644825e-79, 3.013980274506899e-84, 1.2341916608670519e-89, 3.4027317846353536e-95, 6.31674773727347e-101, 7.895806686592734e-107, 6.645870552487289e-113, 3.7668106492874015e-119, 1.4377235666547018e-125, 3.695463618090269e-132, 6.396845078249147e-139, 7.457216855599501e-146, 5.85479562318809e-153}, {-1.6067732041552726e-6, -0.000014986948723765203, -0.000068436190211104, 0., 0.0016946945433472726, 0.009261280208579007, 0.025505617722364354, 0.041985571791171426, 0.043591221892522604, 0.029239985577670647, 0.012836060022494598, 0.0037163660163903336, 0.0007131987310307592, 0.00009103266984375496, 7.747194470588517e-6, 4.4039407971699334e-7, 1.6745166262425586e-8, 4.263408123392281e-10, 7.27471618946332e-12, 8.324681797409596e-14, 6.392314671943552e-16, 3.2952784166214165e-18, 1.1408831916399716e-20, 2.6536936457443935e-23, 4.148061994899527e-26, 4.3584457792411646e-29, 3.07895218276632e-32, 1.462649568086873e-35, 4.673206502274932e-39, 1.0043612985233928e-42, 1.4521824123959064e-46, 1.4127275746233906e-50, 9.247968663104979e-55, 4.074038036957837e-59, 1.207899544594916e-63, 2.4104401059094334e-68, 3.237810569423115e-73, 2.92767739506231e-78, 1.7821180843165316e-83, 7.303212079428925e-89, 2.0150061374197685e-94, 3.743200162584734e-100, 4.682002601044325e-106, 3.943288393437884e-112, 2.2363454173279667e-118, 8.540567990019253e-125, 2.1964192334212955e-131, 3.8039650979894846e-138, 4.436719603454347e-145, 3.484995656693987e-152}, {-8.725684189897948e-6, -0.00009153358842083156, -0.0005573023720021863, -0.0016946945433472726, 0., 0.018854546554681436, 0.06923403617568688, 0.1282142803342964, 0.1419920709045469, 0.09921354587784234, 0.044798143141247485, 0.013240414970436138, 0.0025812680318088315, 0.0003335914054141534, 0.000028676545696234125, 1.643720511679339e-6, 6.29364759160493e-8, 1.61193412126363e-9, 2.7645719347804413e-11, 3.1777079604830515e-13, 2.4496513119350865e-15, 1.2671954171421516e-17, 4.400835644057765e-20, 1.0264775450899166e-22, 1.6085368068042041e-25, 1.6939606786473327e-28, 1.1991481796472937e-31, 5.707316342052231e-35, 1.8266749318924387e-38, 3.932164642115874e-42, 5.6938473535524055e-46, 5.546758000164538e-50, 3.635644800498317e-54, 1.6035292493119005e-58, 4.759545050650916e-63, 9.507867562799979e-68, 1.278387567378302e-72, 1.1569998584858e-77, 7.048917270134778e-83, 2.8910427887372926e-88, 7.98274421045685e-94, 1.4840079994938109e-99, 1.8574866611537237e-105, 1.5654464629571719e-111, 8.883622225327729e-118, 3.3946607908270565e-124, 8.735165472848333e-131, 1.513656625322085e-137, 1.766351814457657e-144, 1.3881359021585369e-151}, {-0.000029808337031566606, -0.00033347961770205625, -0.0022841875008412374, -0.009261280208579007, -0.018854546554681436, 0., 0.09458869910862588, 0.2335579945716214, 0.29098791604143326, 0.21687553132912082, 0.10200662170120117, 0.03101018838769983, 0.006171500286070404, 0.000810236732358888, 0.00007052107812715886, 4.083051775899387e-6, 1.5763892259343216e-7, 4.06569485187129e-9, 7.014436840436595e-11, 8.104017238246637e-13, 6.275164924238228e-15, 3.258849110701583e-17, 1.135693560638785e-19, 2.6571615233048243e-22, 4.17545882941032e-25, 4.408223683447014e-28, 3.127656601697286e-31, 1.4916824750104253e-34, 4.783298247100965e-38, 1.0314603174237228e-41, 1.4959672234290982e-45, 1.459480846325816e-49, 9.5793662229765e-54, 4.230449519848537e-58, 1.2571635558824338e-62, 2.5141563509641936e-67, 3.3839493302930893e-72, 3.065624384576522e-77, 1.869420642409672e-82, 7.673879754619808e-88, 2.1206419812693304e-93, 3.9453598103787255e-99, 4.941894033037738e-105, 4.167799391012111e-111, 2.3667059099241305e-117, 9.049448574673995e-124, 2.3299966697374314e-130, 4.039780779558694e-137, 4.716747038965679e-144, 3.7087003654740356e-151}, {-0.00006568179003583159, -0.000765337783145184, -0.005591702424754339, -0.025505617722364354, -0.06923403617568688, -0.09458869910862588, 0., 0.2144066763737159, 0.35616993576714157, 0.2986382158166795, 0.14982763158027518, 0.04744568501515259, 0.009712197975883578, 0.0013016479656981735, 0.00011509063427088981, 6.746848517039633e-6, 2.631142293325408e-7, 6.842578393517235e-9, 1.188787597780265e-10, 1.3816219857446608e-12, 1.0753144548951891e-14, 5.609305473924015e-17, 1.9624824759492016e-19, 4.607527480064936e-22, 7.262676046034786e-25, 7.688839432729777e-28, 5.468942127919749e-31, 2.614246673869721e-34, 8.400320735240311e-38, 1.8148581305412387e-41, 2.6367373678698686e-45, 2.576550288322314e-49, 1.6936354029805406e-53, 7.489723977822421e-58, 2.2285653763065324e-62, 4.462133793764643e-67, 6.012526106977708e-72, 5.452607293505908e-77, 3.3282553219477195e-82, 1.3674881617408424e-87, 3.7822635734918733e-93, 7.042481627116032e-99, 8.828110656857028e-105, 7.45072436229656e-111, 4.233863454990171e-117, 1.619945093793679e-123, 4.173544011577528e-130, 7.240456149476936e-137, 8.458570688352345e-144, 6.65443349342737e-151}, {-0.00009461384683174326, -0.001133861680540057, -0.008629379217487366, -0.041985571791171426, -0.1282142803342964, -0.2335579945716214, -0.2144066763737159, 0., 0.2198633047827029, 0.24579871748558604, 0.13873264523037093, 0.046861069652686736, 0.009992214994612874, 0.0013774385827645366, 0.00012432931068482377, 7.404128137777099e-6, 2.923562174590984e-7, 7.679847315748698e-9, 1.3453683109003987e-10, 1.5745360864173923e-12, 1.2327536292153011e-14, 6.46355364395313e-17, 2.27144671375927e-19, 5.353828862749565e-22, 8.468345691763902e-25, 8.993012250172953e-28, 6.414346584048081e-31, 3.073850592434303e-34, 9.899607397503611e-38, 2.1432015541117442e-41, 3.11967216266941e-45, 3.0537631184668122e-49, 2.0105370164118207e-53, 8.904322598521467e-58, 2.6531182134008665e-62, 5.31897698170106e-67, 7.17561629799529e-72, 6.5146227314418295e-77, 3.980648589960619e-82, 1.6371372987256202e-87, 4.532233768129207e-93, 8.446214073390475e-99, 1.0596411153790396e-104, 8.950035605970199e-111, 5.089562646208492e-117, 1.9486990514568597e-123, 5.023831939315496e-130, 8.72102540372893e-137, 1.0194291285117601e-143, 8.024489498858467e-151}, {-0.00008981806281935077, -0.0010987425934386014, -0.008601016061274615, -0.043591221892522604, -0.1419920709045469, -0.29098791604143326, -0.35616993576714157, -0.2198633047827029, 0., 0.1020795094853903, 0.07682036488823367, 0.029191903764026868, 0.006639581626832259, 0.000953410554193938, 0.00008851475952722692, 5.3810984384093554e-6, 2.1584836806321817e-7, 5.740953813270091e-9, 1.0158684357582078e-10, 1.198817337982752e-12, 9.451552285024832e-15, 4.985120170878458e-17, 1.7608740258616038e-19, 4.168931110855844e-22, 6.620009264861297e-25, 7.054570190889397e-28, 5.0473135408924665e-31, 2.425466704798383e-34, 7.831007323100374e-38, 1.6992159933324047e-41, 2.4785218969689428e-45, 2.4307533759564893e-49, 1.6031430038001806e-53, 7.111422872081449e-58, 2.1220477029246736e-62, 4.26012950290605e-67, 5.754508007127946e-72, 5.230641692414206e-77, 3.19964914319194e-82, 1.3173032893119128e-87, 3.650373460782014e-93, 6.809042816564011e-99, 8.549852677201838e-105, 7.227352952720281e-111, 4.113108810254284e-117, 1.575984198877768e-123, 4.065772273667337e-130, 7.062543323381007e-137, 8.260800441892142e-144, 6.506402662663954e-151}, {-0.00005648523106300115, -0.000701915566550361, -0.005609102985459705, -0.029239985577670647, -0.09921354587784234, -0.21687553132912082, -0.2986382158166795, -0.24579871748558604, -0.1020795094853903, 0., 0.021470553243257823, 0.010878475170821918, 0.0027835488227489504, 0.00042635053028008225, 0.00004123170680952632, 2.5782261706367414e-6, 1.0557320054389087e-7, 2.852518014096525e-9, 5.11065825652936e-11, 6.091962137087306e-13, 4.842966283496467e-15, 2.5722335046548436e-17, 9.139879483132569e-20, 2.174995489258863e-22, 3.4691792403987995e-25, 3.711406170508428e-28, 2.6646094613609827e-31, 1.2844319106158545e-34, 4.1585133558636695e-38, 9.045991040506507e-42, 1.3224712495873609e-45, 1.2996685435917097e-49, 8.587875181315394e-54, 3.816142667043837e-58, 1.1405613967244052e-62, 2.293133032722216e-67, 3.1017786102681427e-72, 2.8230064463350208e-77, 1.728924254455435e-82, 7.125940674507214e-88, 1.9767232895431277e-93, 3.690786885958863e-99, 4.6386384070340285e-105, 3.9245241169865995e-111, 2.2352834753610226e-117, 8.571355358302996e-124, 2.212880911775507e-130, 3.8465995791658734e-137, 4.5021878528741744e-144, 3.548247756870972e-151}, {-0.000023616615844258387, -0.00029712915689913543, -0.0024120880477410886, -0.012836060022494598, -0.044798143141247485, -0.10200662170120117, -0.14982763158027518, -0.13873264523037093, -0.07682036488823367, -0.021470553243257823, 0., 0.0020466605792461567, 0.00069825713089002, 0.00012031945786005927, 0.00001241163786166432, 8.08439569112931e-7, 3.404981006228469e-8, 9.3917007107069e-10, 1.7093544001571275e-11, 2.0630392962996963e-13, 1.6566339447071267e-15, 8.872165315939598e-18, 3.1745791422106213e-20, 7.599437940395506e-23, 1.2183478775028422e-25, 1.3092348508418003e-28, 9.436532118625537e-32, 4.5645219356336066e-35, 1.4823979315136605e-38, 3.233609365925276e-42, 4.739196714201606e-46, 4.668066315462827e-50, 3.090924265186946e-54, 1.3760968234043376e-58, 4.1200045626634093e-63, 8.296667903541e-68, 1.1239013065980974e-72, 1.0242958147332533e-77, 6.281216977430099e-83, 2.591950725610774e-88, 7.198023090892025e-94, 1.3453599029593985e-99, 1.6925221208060738e-105, 1.4332759731895644e-111, 8.170549694102154e-118, 3.1356157695093745e-124, 8.101521983890582e-131, 1.409298217812958e-137, 1.6506325195235154e-144, 1.3017462885134838e-151}, {-6.581417430346026e-6, -0.00008363684044334222, -0.0006874489820866792, -0.0037163660163903336, -0.013240414970436138, -0.03101018838769983, -0.04744568501515259, -0.046861069652686736, -0.029191903764026868, -0.010878475170821918, -0.0020466605792461567, 0., 0.00008844640349011172, 0.000020320734481747722, 2.358224531599123e-6, 1.6384467936272979e-7, 7.18833389187123e-9, 2.0393522601266157e-10, 3.789090351065659e-12, 4.645685135347694e-14, 3.7771467570978315e-16, 2.0432981143008067e-18, 7.372119926220174e-21, 1.777109384907579e-23, 2.8660345504172017e-26, 3.095630578123948e-29, 2.2411890541154715e-32, 1.0883313856370697e-35, 3.54679437052961e-39, 7.760706372002378e-43, 1.1405731268524422e-46, 1.1262699890396096e-50, 7.474459134247939e-55, 3.334560727670726e-59, 1.0002512094788716e-63, 2.017761046396535e-68, 2.737723795236995e-73, 2.498790095763165e-78, 1.5344202544430877e-83, 6.339887747542991e-89, 1.7627258467268086e-94, 3.2983203525490446e-100, 4.1537548647017413e-106, 3.5209564462969225e-112, 2.009005346342645e-118, 7.716644738299435e-125, 1.9953861447004236e-131, 3.473749308383685e-138, 4.071583243293673e-145, 3.2132175593023003e-152}, {-1.2247838960156434e-6, -0.000015693865055400444, -0.00013029793207779936, -0.0007131987310307592, -0.0025812680318088315, -0.006171500286070404, -0.009712197975883578, -0.009992214994612874, -0.006639581626832259, -0.0027835488227489504, -0.00069825713089002, -0.00008844640349011172, 0., 1.7332011351424607e-6, 2.681843636941128e-7, 2.0962021661687884e-8, 9.809746569831816e-10, 2.8990156625339274e-11, 5.540229185421944e-13, 6.934216292885435e-15, 5.727312708116972e-17, 3.1369948294825786e-19, 1.1432448813222068e-21, 2.7788503466387756e-24, 4.5129328816056654e-27, 4.903475432830128e-30, 3.568246336509905e-33, 1.740491831162304e-36, 5.694382434514397e-40, 1.2503086265806228e-43, 1.8432387771005463e-47, 1.8251798959058354e-51, 1.2143112874090006e-55, 5.429687115234326e-60, 1.6320876903418636e-64, 3.2985713845483034e-69, 4.4833270707989235e-74, 4.098604342306999e-79, 2.52053925542579e-84, 1.0428620423772133e-89, 2.9032495357477637e-95, 5.4388757434875494e-101, 6.857092105797446e-107, 5.818511910971417e-113, 3.323201614357939e-119, 1.2776240800151767e-125, 3.306567434812677e-132, 5.761075624135368e-139, 6.757773855178209e-146, 5.337007563462203e-153}, {-1.524266409412512e-7, -1.966743599772143e-6, -0.000016464912847828885, -0.00009103266984375496, -0.0003335914054141534, -0.000810236732358888, -0.0013016479656981735, -0.0013774385827645366, -0.000953410554193938, -0.00042635053028008225, -0.00012031945786005927, -0.000020320734481747722, -1.7332011351424607e-6, 0., 1.5403970743122996e-8, 1.6053551815155727e-9, 8.451781849490669e-11, 2.664218112310967e-12, 5.303660456243394e-14, 6.827784764871146e-16, 5.756893254711118e-18, 3.203247590761825e-20, 1.1819823807311017e-22, 2.902028687858112e-25, 4.752252867393352e-28, 5.199614249277433e-31, 3.8062680804011005e-34, 1.8661132377838245e-37, 6.132635252282617e-41, 1.3518157952978108e-44, 1.9998031232737064e-48, 1.9863410063120533e-52, 1.3252043871838705e-56, 5.940386915734088e-61, 1.7896550526411817e-65, 3.6245154860902746e-70, 4.935671478072521e-75, 4.519979411670899e-80, 2.7841290002503224e-85, 1.1536276909963829e-90, 3.2160243314414853e-96, 6.03251483002121e-102, 7.614580002711133e-108, 6.468457310764816e-114, 3.69826164502625e-120, 1.4232079294180955e-126, 3.6867325625110906e-133, 6.42900371282724e-140, 7.547418388267196e-147, 5.9652386450817104e-154}, {-1.2700145392056894e-8, -1.6484067365382208e-7, -1.3896405863824888e-6, -7.747194470588517e-6, -0.000028676545696234125, -0.00007052107812715886, -0.00011509063427088981, -0.00012432931068482377, -0.00008851475952722692, -0.00004123170680952632, -0.00001241163786166432, -2.358224531599123e-6, -2.681843636941128e-7, -1.5403970743122996e-8, 0., 6.210057637401865e-11, 4.359247351482955e-12, 1.5459147196735733e-13, 3.2826168316358773e-15, 4.4020307171312474e-17, 3.8176479753444263e-19, 2.1684681801543496e-21, 8.12854796689936e-24, 2.020685398726635e-26, 3.3424225202141856e-29, 3.687542691203009e-32, 2.718264787163972e-35, 1.3406265094468104e-38, 4.4283139626739276e-42, 9.804902640016114e-46, 1.4561724029649188e-49, 1.4513919739727584e-53, 9.713064253491449e-58, 4.366091477068907e-62, 1.3186651368271288e-66, 2.676708426466602e-71, 3.652545060176449e-76, 3.3512555287841384e-81, 2.0678311803106565e-86, 8.581966705129506e-92, 2.395981178675182e-97, 4.500477798376169e-103, 5.6880116856024e-109, 4.837622238517133e-115, 2.7689281521014787e-121, 1.0666810084196005e-127, 2.765872560358223e-134, 4.827621268617995e-141, 5.6723600655373974e-148, 4.486915170505413e-155}, {-7.09067949821226e-10, -9.250336866066373e-9, -7.844640567983322e-8, -4.4039407971699334e-7, -1.643720511679339e-6, -4.083051775899387e-6, -6.746848517039633e-6, -7.404128137777099e-6, -5.3810984384093554e-6, -2.5782261706367414e-6, -8.08439569112931e-7, -1.6384467936272979e-7, -2.0962021661687884e-8, -1.6053551815155727e-9, -6.210057637401865e-11, 0., 1.1357688936041822e-13, 5.370351681383025e-15, 1.282891444227832e-16, 1.8350652409781545e-18, 1.657765460992615e-20, 9.685336575171898e-23, 3.706205355313925e-25, 9.359542791932807e-28, 1.5675171879406902e-30, 1.7468387815245902e-33, 1.2984094022825546e-36, 6.448432378420452e-40, 2.1427039701734884e-43, 4.768573880040179e-47, 7.113650529817596e-51, 7.118102406443012e-55, 4.780145668138094e-59, 2.155361833342962e-63, 6.527796138157228e-68, 1.3283735527220827e-72, 1.816772927533433e-77, 1.670362923943121e-82, 1.0326190371204477e-87, 4.2930555859668534e-93, 1.2004899156743258e-98, 2.2582741369985226e-104, 2.858081877248478e-110, 2.4338871560113358e-116, 1.3947516485637672e-122, 5.3790127918231934e-129, 1.39621511320708e-135, 2.4393700298836662e-142, 2.868846205860774e-149, 2.2712617387125328e-156}, {-2.6546606657816358e-11, -3.478617557418667e-10, -2.9651291793790472e-9, -1.6745166262425586e-8, -6.29364759160493e-8, -1.5763892259343216e-7, -2.631142293325408e-7, -2.923562174590984e-7, -2.1584836806321817e-7, -1.0557320054389087e-7, -3.404981006228469e-8, -7.18833389187123e-9, -9.809746569831816e-10, -8.451781849490669e-11, -4.359247351482955e-12, -1.1357688936041822e-13, 0., 9.424506466173252e-17, 3.0018192299366263e-18, 4.8305730952598964e-20, 4.654777856931718e-22, 2.832822460404947e-24, 1.114983845967529e-26, 2.874409059100747e-29, 4.890414549298274e-32, 5.51799395336466e-35, 4.142903831850331e-38, 2.0746816930556195e-41, 6.942021489636775e-45, 1.554138495501304e-48, 2.3303179916077332e-52, 2.3421860709663504e-56, 1.5790579855136412e-60, 7.144675196700481e-65, 2.1705578882576043e-69, 4.4292450796085604e-74, 6.072915471905105e-79, 5.59620147029148e-84, 3.466736698014337e-89, 1.4440059797921556e-94, 4.0449730737698634e-100, 7.621302630713576e-106, 9.659844505504975e-112, 8.237436075191408e-118, 4.726534176620517e-124, 1.8250098212416235e-130, 4.742395624289809e-137, 8.294214926504189e-144, 9.764031934955396e-151, 7.737276078031176e-158}, {-6.668474488591633e-13, -8.772395285366731e-12, -7.510858895905529e-11, -4.263408123392281e-10, -1.61193412126363e-9, -4.06569485187129e-9, -6.842578393517235e-9, -7.679847315748698e-9, -5.740953813270091e-9, -2.852518014096525e-9, -9.3917007107069e-10, -2.0393522601266157e-10, -2.8990156625339274e-11, -2.664218112310967e-12, -1.5459147196735733e-13, -5.370351681383025e-15, -9.424506466173252e-17, 0., 3.5484386479236063e-20, 7.613601819366075e-22, 8.253591762111656e-24, 5.357869175310292e-26, 2.1966966628018267e-28, 5.824847294620728e-31, 1.0116644493966564e-33, 1.159608683389642e-36, 8.815158442895971e-40, 4.459041872377907e-43, 1.504458297220079e-46, 3.391644873726955e-50, 5.1157965634304104e-54, 5.1682192757175115e-58, 3.499871632360478e-62, 1.589777376535976e-66, 4.846526035664961e-71, 9.92045009055972e-76, 1.363966181814981e-80, 1.260047169663681e-85, 7.823484612667118e-91, 3.2654767615408024e-96, 9.164631144272305e-102, 1.72974945002269e-107, 2.195935386988003e-113, 1.8753589358600197e-119, 1.0775347784967928e-125, 4.1658919388206015e-132, 1.0838203107532268e-138, 1.8976565195302286e-145, 2.2362670649285578e-152, 1.7738091583209242e-159}, {-1.1244784529196788e-14, -1.4843730998902442e-13, -1.2758929853817266e-12, -7.27471618946332e-12, -2.7645719347804413e-11, -7.014436840436595e-11, -1.188787597780265e-10, -1.3453683109003987e-10, -1.0158684357582078e-10, -5.11065825652936e-11, -1.7093544001571275e-11, -3.789090351065659e-12, -5.540229185421944e-13, -5.303660456243394e-14, -3.2826168316358773e-15, -1.282891444227832e-16, -3.0018192299366263e-18, -3.5484386479236063e-20, 0., 6.062560525711414e-24, 8.762895810151748e-26, 6.399547862131309e-28, 2.7986977603140693e-30, 7.730351134387014e-33, 1.3809743820578083e-35, 1.6159035490651993e-38, 1.2478820084071887e-41, 6.391164311295992e-45, 2.1781279685535898e-48, 4.9512828264858844e-52, 7.520506355018102e-56, 7.642794301628119e-60, 5.20217329450368e-64, 2.3735780210344358e-68, 7.264362944173099e-73, 1.492119877081499e-77, 2.0578723394253375e-82, 1.9063662093048095e-87, 1.1866068652132992e-92, 4.964084143789347e-98, 1.3960653819488308e-103, 2.6399501032185783e-109, 3.357273429742813e-115, 2.8717523548966366e-121, 1.6524822496560258e-127, 6.397490596347255e-134, 1.6665304061861287e-140, 2.9213949420941525e-147, 3.446506894211693e-154, 2.736620219263987e-161}, {-1.27338489493297e-16, -1.6861241211379986e-15, -1.4543403454891302e-14, -8.324681797409596e-14, -3.1777079604830515e-13, -8.104017238246637e-13, -1.3816219857446608e-12, -1.5745360864173923e-12, -1.198817337982752e-12, -6.091962137087306e-13, -2.0630392962996963e-13, -4.645685135347694e-14, -6.934216292885435e-15, -6.827784764871146e-16, -4.4020307171312474e-17, -1.8350652409781545e-18, -4.8305730952598964e-20, -7.613601819366075e-22, -6.062560525711414e-24, 0., 4.700461675033239e-28, 4.5769998282441e-30, 2.251853470707277e-32, 6.634559173854954e-35, 1.2346027496118754e-37, 1.4859065902063712e-40, 1.1713978968232035e-43, 6.09467180812976e-47, 2.1030459645266903e-50, 4.828896680309554e-54, 7.395735749708708e-58, 7.5685542559531075e-62, 5.182305312519785e-66, 2.3766386313692892e-70, 7.306201986275665e-75, 1.5065988818368104e-79, 2.0850559328465347e-84, 1.937528499253257e-89, 1.2093536665047636e-94, 5.071923553483716e-100, 1.4296352098777382e-105, 2.709027583003879e-111, 3.4516453893883594e-117, 2.9576112029063515e-123, 1.7046150855094725e-129, 6.609096661365906e-136, 1.7240181687262777e-142, 3.0260295879246058e-149, 3.574199242493572e-156, 2.841168270675848e-163}, {-9.68727860655851e-19, -1.2862702311935298e-17, -1.1128873373184297e-16, -6.392314671943552e-16, -2.4496513119350865e-15, -6.275164924238228e-15, -1.0753144548951891e-14, -1.2327536292153011e-14, -9.451552285024832e-15, -4.842966283496467e-15, -1.6566339447071267e-15, -3.7771467570978315e-16, -5.727312708116972e-17, -5.756893254711118e-18, -3.8176479753444263e-19, -1.657765460992615e-20, -4.654777856931718e-22, -8.253591762111656e-24, -8.762895810151748e-26, -4.700461675033239e-28, 0., 1.6539122557163677e-32, 1.0849517713321259e-34, 3.596126001972277e-37, 7.1380369504888075e-40, 8.948944769550942e-43, 7.256366592884274e-46, 3.854073051894421e-49, 1.351007647159481e-52, 3.140884654039583e-56, 4.859037660832036e-60, 5.0140185066218733e-64, 3.4571836806282982e-68, 1.5949241485490116e-72, 4.928219196217281e-77, 1.0207760741034427e-81, 1.4182419784228368e-86, 1.322470766062908e-91, 8.280065927013152e-97, 3.4822333397212704e-102, 9.84005444843273e-108, 1.8688377830556536e-113, 2.3860667073488531e-119, 2.0484211053992853e-125, 1.1826578682627177e-131, 4.5927238103718656e-138, 1.1998114083896838e-144, 2.1088246426983075e-151, 2.494022440450653e-158, 1.9848846084481726e-165}, {-4.952280283929566e-21, -6.592027534438407e-20, -5.719297414237989e-19, -3.2952784166214165e-18, -1.2671954171421516e-17, -3.258849110701583e-17, -5.609305473924015e-17, -6.46355364395313e-17, -4.985120170878458e-17, -2.5722335046548436e-17, -8.872165315939598e-18, -2.0432981143008067e-18, -3.1369948294825786e-19, -3.203247590761825e-20, -2.1684681801543496e-21, -9.685336575171898e-23, -2.832822460404947e-24, -5.357869175310292e-26, -6.399547862131309e-28, -4.5769998282441e-30, -1.6539122557163677e-32, 0., 2.641136346997849e-37, 1.1672235077670932e-39, 2.606456250078585e-42, 3.4855570797020446e-45, 2.944071503454382e-48, 1.608361012426013e-51, 5.755409704347257e-55, 1.3592828880742788e-58, 2.12913480302042e-62, 2.219236730947746e-66, 1.5429230881139406e-70, 7.167840155013551e-75, 2.2280027220349844e-79, 4.63850087813608e-84, 6.473393340536857e-89, 6.059928865163925e-94, 3.807330653405429e-99, 1.6061539045722605e-104, 4.5512583765579983e-110, 8.66548133578645e-116, 1.108892840357326e-121, 9.539474931303563e-128, 5.518056008165474e-134, 2.146604061765074e-140, 5.616813867059441e-147, 9.886906706382963e-154, 1.1708910167868505e-160, 9.33051642953214e-168}, {-1.7016881598932682e-23, -2.270263659704362e-22, -1.9746359895209963e-21, -1.1408831916399716e-20, -4.400835644057765e-20, -1.135693560638785e-19, -1.9624824759492016e-19, -2.27144671375927e-19, -1.7608740258616038e-19, -9.139879483132569e-20, -3.1745791422106213e-20, -7.372119926220174e-21, -1.1432448813222068e-21, -1.1819823807311017e-22, -8.12854796689936e-24, -3.706205355313925e-25, -1.114983845967529e-26, -2.1966966628018267e-28, -2.7986977603140693e-30, -2.251853470707277e-32, -1.0849517713321259e-34, -2.641136346997849e-37, 0., 1.9142206727041437e-42, 5.699373945319724e-45, 8.574354491822771e-48, 7.725139182109166e-51, 4.396127332183542e-54, 1.618070452189484e-57, 3.901089146515844e-61, 6.207526878454048e-65, 6.551098259695062e-69, 4.600653916996083e-73, 2.1551014698940333e-77, 6.745615503110362e-82, 1.4127357388659962e-86, 1.9816946890418527e-91, 1.8634029330537622e-96, 1.175329478455352e-101, 4.975440605914757e-107, 1.414224535390673e-112, 2.700127478831417e-118, 3.4639231837664527e-124, 2.986682498902629e-130, 1.7312066879854955e-136, 6.747400876764362e-143, 1.768598439220917e-149, 3.1181361121099416e-156, 3.6982309600492584e-163, 2.951069155468156e-170}, {-3.9311665777657946e-26, -5.255486245033763e-25, -4.5815196676972495e-24, -2.6536936457443935e-23, -1.0264775450899166e-22, -2.6571615233048243e-22, -4.607527480064936e-22, -5.353828862749565e-22, -4.168931110855844e-22, -2.174995489258863e-22, -7.599437940395506e-23, -1.777109384907579e-23, -2.7788503466387756e-24, -2.902028687858112e-25, -2.020685398726635e-26, -9.359542791932807e-28, -2.874409059100747e-29, -5.824847294620728e-31, -7.730351134387014e-33, -6.634559173854954e-35, -3.596126001972277e-37, -1.1672235077670932e-39, -1.9142206727041437e-42, 0., 6.29695174209221e-48, 1.2631164281692747e-50, 1.2802676863473878e-53, 7.771296125767559e-57, 2.979541159694551e-60, 7.388772471068387e-64, 1.2002172649342127e-67, 1.2867518431097488e-71, 9.149456195645364e-76, 4.329205942914851e-80, 1.366363430774833e-84, 2.8815889736391687e-89, 4.066167549386373e-94, 3.843056410832069e-99, 2.434804598023894e-104, 1.0347509064242114e-109, 2.9513994486976095e-115, 5.6524454626033975e-121, 7.271517703162302e-127, 6.2854006489224406e-133, 3.6515625394333405e-139, 1.4261478976001306e-145, 3.745234710345691e-152, 6.614537912109105e-159, 7.857672044321332e-166, 6.27945827012072e-173}, {-6.106788162818677e-29, -8.179433484974975e-28, -7.145260985249707e-27, -4.148061994899527e-26, -1.6085368068042041e-25, -4.17545882941032e-25, -7.262676046034786e-25, -8.468345691763902e-25, -6.620009264861297e-25, -3.4691792403987995e-25, -1.2183478775028422e-25, -2.8660345504172017e-26, -4.5129328816056654e-27, -4.752252867393352e-28, -3.3424225202141856e-29, -1.5675171879406902e-30, -4.890414549298274e-32, -1.0116644493966564e-33, -1.3809743820578083e-35, -1.2346027496118754e-37, -7.1380369504888075e-40, -2.606456250078585e-42, -5.699373945319724e-45, -6.29695174209221e-48, 0., 9.401963111237813e-54, 1.2706170538313245e-56, 8.676805780311666e-60, 3.5484977247856627e-63, 9.166345062769442e-67, 1.531504351173368e-70, 1.6761311872569676e-74, 1.2107317034233857e-78, 5.800372840009325e-83, 1.849177923053045e-87, 3.9323179677492295e-92, 5.587638727519584e-97, 5.31247905624794e-102, 3.383031524720754e-107, 1.4441498079507227e-112, 4.135273211273982e-118, 7.947269707265984e-124, 1.0255317839667216e-129, 8.889180527857007e-136, 5.177195904545359e-142, 2.026592051020379e-148, 5.333091555173798e-155, 9.436724130585512e-162, 1.1229755137564033e-168, 8.988640150658347e-176}, {-6.380096753993202e-32, -8.560313383402618e-31, -7.492146734394954e-30, -4.3584457792411646e-29, -1.6939606786473327e-28, -4.408223683447014e-28, -7.688839432729777e-28, -8.993012250172953e-28, -7.054570190889397e-28, -3.711406170508428e-28, -1.3092348508418003e-28, -3.095630578123948e-29, -4.903475432830128e-30, -5.199614249277433e-31, -3.687542691203009e-32, -1.7468387815245902e-33, -5.51799395336466e-35, -1.159608683389642e-36, -1.6159035490651993e-38, -1.4859065902063712e-40, -8.948944769550942e-43, -3.4855570797020446e-45, -8.574354491822771e-48, -1.2631164281692747e-50, -9.401963111237813e-54, 0., 6.371881746679612e-60, 5.801651536612807e-63, 2.6692473329219316e-66, 7.354771965398911e-70, 1.2800295980571979e-73, 1.440934501851781e-77, 1.0625245923890567e-81, 5.171141370407016e-86, 1.6691840734959794e-90, 3.5854111562694216e-95, 5.137156315550474e-100, 4.918335468008601e-105, 3.1506806400597564e-110, 1.3518610224019133e-115, 3.888288737300554e-121, 7.501913222542913e-127, 9.71423407568343e-133, 8.446244582270816e-139, 4.932887683901566e-145, 1.935798097756291e-151, 5.1057397753581314e-158, 9.053137718340668e-165, 1.0793689084594763e-171, 8.654624908979454e-179}, {-4.483623779728173e-35, -6.025381946257026e-34, -5.282698460999957e-33, -3.07895218276632e-32, -1.1991481796472937e-31, -3.127656601697286e-31, -5.468942127919749e-31, -6.414346584048081e-31, -5.0473135408924665e-31, -2.6646094613609827e-31, -9.436532118625537e-32, -2.2411890541154715e-32, -3.568246336509905e-33, -3.8062680804011005e-34, -2.718264787163972e-35, -1.2984094022825546e-36, -4.142903831850331e-38, -8.815158442895971e-40, -1.2478820084071887e-41, -1.1713978968232035e-43, -7.256366592884274e-46, -2.944071503454382e-48, -7.725139182109166e-51, -1.2802676863473878e-53, -1.2706170538313245e-56, -6.371881746679612e-60, 0., 1.9601431359573866e-66, 1.2024407888640985e-69, 3.727319460725125e-73, 6.919522731402014e-77, 8.113890373412371e-81, 6.154012053037705e-85, 3.057458742054375e-89, 1.0025772630552991e-93, 2.1804574510811467e-98, 3.1557038313596347e-103, 3.0464617393353117e-108, 1.9652075300600453e-113, 8.482297579377745e-119, 2.4522312662911773e-124, 4.752361337408698e-130, 6.177969598320079e-136, 5.390216524214092e-142, 3.157812014743434e-148, 1.2426528079020392e-154, 3.2857575817588283e-161, 5.839314712299032e-168, 6.976392237411141e-175, 5.6044240241906315e-182}, {-2.1197066218638074e-38, -2.852803556270133e-37, -2.5051776356381454e-36, -1.462649568086873e-35, -5.707316342052231e-35, -1.4916824750104253e-34, -2.614246673869721e-34, -3.073850592434303e-34, -2.425466704798383e-34, -1.2844319106158545e-34, -4.5645219356336066e-35, -1.0883313856370697e-35, -1.740491831162304e-36, -1.8661132377838245e-37, -1.3406265094468104e-38, -6.448432378420452e-40, -2.0746816930556195e-41, -4.459041872377907e-43, -6.391164311295992e-45, -6.09467180812976e-47, -3.854073051894421e-49, -1.608361012426013e-51, -4.396127332183542e-54, -7.771296125767559e-57, -8.676805780311666e-60, -5.801651536612807e-63, -1.9601431359573866e-66, 0., 2.7370809470979985e-73, 1.1312518309070064e-76, 2.362606209785582e-80, 2.9551059749246592e-84, 2.3346997338766916e-88, 1.1930750206817491e-92, 3.9937404924242056e-97, 8.823665406168333e-102, 1.2929826100946315e-106, 1.2608312964189055e-111, 8.201131885493728e-117, 3.564555126740266e-122, 1.0366464849430311e-127, 2.0192968509978806e-133, 2.6367622998436436e-139, 2.3095704256432084e-145, 1.3577400425126316e-151, 5.359479906079988e-158, 1.4210621145337345e-164, 2.5317832403747244e-171, 3.031666616134193e-178, 2.4405053735118093e-185}, {-6.742454447153967e-42, -9.086742256692269e-41, -7.991306415435127e-40, -4.673206502274932e-39, -1.8266749318924387e-38, -4.783298247100965e-38, -8.400320735240311e-38, -9.899607397503611e-38, -7.831007323100374e-38, -4.1585133558636695e-38, -1.4823979315136605e-38, -3.54679437052961e-39, -5.694382434514397e-40, -6.132635252282617e-41, -4.4283139626739276e-42, -2.1427039701734884e-43, -6.942021489636775e-45, -1.504458297220079e-46, -2.1781279685535898e-48, -2.1030459645266903e-50, -1.351007647159481e-52, -5.755409704347257e-55, -1.618070452189484e-57, -2.979541159694551e-60, -3.5484977247856627e-63, -2.6692473329219316e-66, -1.2024407888640985e-69, -2.7370809470979985e-73, 0., 1.7349030780032647e-80, 4.83109969973736e-84, 6.797985618655863e-88, 5.7288432426488296e-92, 3.04952659392974e-96, 1.0499750277275062e-100, 2.3681161651935337e-105, 3.525218816137063e-110, 3.4805302117771133e-115, 2.286793920364074e-120, 1.0022191406825966e-125, 2.935043155217021e-131, 5.751238829196087e-137, 7.548378609693612e-143, 6.6412282131420505e-149, 3.919526506460325e-155, 1.5525478042781897e-161, 4.129313761813647e-168, 7.377276209823963e-175, 8.856009229037488e-182, 7.145330150910027e-189}, {-1.4431171279762552e-45, -1.9473505706152733e-44, -1.7149436620656409e-43, -1.0043612985233928e-42, -3.932164642115874e-42, -1.0314603174237228e-41, -1.8148581305412387e-41, -2.1432015541117442e-41, -1.6992159933324047e-41, -9.045991040506507e-42, -3.233609365925276e-42, -7.760706372002378e-43, -1.2503086265806228e-43, -1.3518157952978108e-44, -9.804902640016114e-46, -4.768573880040179e-47, -1.554138495501304e-48, -3.391644873726955e-50, -4.9512828264858844e-52, -4.828896680309554e-54, -3.140884654039583e-56, -1.3592828880742788e-58, -3.901089146515844e-61, -7.388772471068387e-64, -9.166345062769442e-67, -7.354771965398911e-70, -3.727319460725125e-73, -1.1312518309070064e-76, -1.7349030780032647e-80, 0., 4.9918055825282303e-88, 9.365492929901041e-92, 8.87911866576824e-96, 5.041549898537378e-100, 1.808170510056726e-104, 4.194670682464549e-109, 6.3743483067055365e-114, 6.393439256721222e-119, 4.253154863497032e-124, 1.882832410580447e-129, 5.559907781371567e-135, 1.097086710751747e-140, 1.4484738191016785e-146, 1.2809342518684996e-152, 7.593579430093197e-159, 3.019657597197401e-165, 8.05927467816246e-172, 1.4442973223346657e-178, 1.7386146055024476e-185, 1.4062892569340753e-192}, {-2.0785832905880606e-49, -2.8081797458073856e-48, -2.476195395416463e-47, -1.4521824123959064e-46, -5.6938473535524055e-46, -1.4959672234290982e-45, -2.6367373678698686e-45, -3.11967216266941e-45, -2.4785218969689428e-45, -1.3224712495873609e-45, -4.739196714201606e-46, -1.1405731268524422e-46, -1.8432387771005463e-47, -1.9998031232737064e-48, -1.4561724029649188e-49, -7.113650529817596e-51, -2.3303179916077332e-52, -5.1157965634304104e-54, -7.520506355018102e-56, -7.395735749708708e-58, -4.859037660832036e-60, -2.12913480302042e-62, -6.207526878454048e-65, -1.2002172649342127e-67, -1.531504351173368e-70, -1.2800295980571979e-73, -6.919522731402014e-77, -2.362606209785582e-80, -4.83109969973736e-84, -4.9918055825282303e-88, 0., 6.519907459846604e-96, 8.241749075976261e-100, 5.2646089808660066e-104, 2.014049572904743e-108, 4.8669559055605484e-113, 7.607286765384987e-118, 7.789030121313993e-123, 5.263800982313328e-128, 2.3593640728022457e-133, 7.037455959804932e-139, 1.4002100176633764e-144, 1.8616126890305418e-150, 1.6560862154739654e-156, 9.867885546979704e-163, 3.94157472039445e-169, 1.05610671984208e-175, 1.899213590219407e-182, 2.2933113199256715e-189, 1.8601118150071196e-196}, {-2.0148955759198478e-53, -2.725154619517352e-52, -2.4058462002892027e-51, -1.4127275746233906e-50, -5.546758000164538e-50, -1.459480846325816e-49, -2.576550288322314e-49, -3.0537631184668122e-49, -2.4307533759564893e-49, -1.2996685435917097e-49, -4.668066315462827e-50, -1.1262699890396096e-50, -1.8251798959058354e-51, -1.9863410063120533e-52, -1.4513919739727584e-53, -7.118102406443012e-55, -2.3421860709663504e-56, -5.1682192757175115e-58, -7.642794301628119e-60, -7.5685542559531075e-62, -5.0140185066218733e-64, -2.219236730947746e-66, -6.551098259695062e-69, -1.2867518431097488e-71, -1.6761311872569676e-74, -1.440934501851781e-77, -8.113890373412371e-81, -2.9551059749246592e-84, -6.797985618655863e-88, -9.365492929901041e-92, -6.519907459846604e-96, 0., 3.8657376286467975e-104, 3.2924398045180523e-108, 1.4170148499119938e-112, 3.652501314010032e-117, 5.946912164266961e-122, 6.262959105900398e-127, 4.32066401731552e-132, 1.9673671782973526e-137, 5.941569503433607e-143, 1.194107641559048e-148, 1.6008246087839053e-154, 1.4340484299013768e-160, 8.595722818270649e-167, 3.451036262845811e-173, 9.287996961699244e-180, 1.67682543461682e-186, 2.0318068179801498e-193, 1.6531068966649378e-200}, {-1.3145901476529497e-57, -1.7798342273099045e-56, -1.5730375078778302e-55, -9.247968663104979e-55, -3.635644800498317e-54, -9.5793662229765e-54, -1.6936354029805406e-53, -2.0105370164118207e-53, -1.6031430038001806e-53, -8.587875181315394e-54, -3.090924265186946e-54, -7.474459134247939e-55, -1.2143112874090006e-55, -1.3252043871838705e-56, -9.713064253491449e-58, -4.780145668138094e-59, -1.5790579855136412e-60, -3.499871632360478e-62, -5.20217329450368e-64, -5.182305312519785e-66, -3.4571836806282982e-68, -1.5429230881139406e-70, -4.600653916996083e-73, -9.149456195645364e-76, -1.2107317034233857e-78, -1.0625245923890567e-81, -6.154012053037705e-85, -2.3346997338766916e-88, -5.7288432426488296e-92, -8.87911866576824e-96, -8.241749075976261e-100, -3.8657376286467975e-104, 0., 1.0404849640777166e-112, 5.970780465740732e-117, 1.7314087382644675e-121, 3.0069726073021504e-126, 3.298726358580999e-131, 2.3407318645649175e-136, 1.0880314163379437e-141, 3.3380790732146556e-147, 6.79256726482765e-153, 9.198119076423503e-159, 8.308511364563682e-165, 5.014969050106753e-171, 2.025409302056094e-177, 5.479069408447222e-184, 9.935897212765866e-191, 1.2086524463028568e-197, 9.867913066155837e-205}, {-5.773129457339151e-62, -7.823900480547505e-61, -6.922054119304314e-60, -4.074038036957837e-59, -1.6035292493119005e-58, -4.230449519848537e-58, -7.489723977822421e-58, -8.904322598521467e-58, -7.111422872081449e-58, -3.816142667043837e-58, -1.3760968234043376e-58, -3.334560727670726e-59, -5.429687115234326e-60, -5.940386915734088e-61, -4.366091477068907e-62, -2.155361833342962e-63, -7.144675196700481e-65, -1.589777376535976e-66, -2.3735780210344358e-68, -2.3766386313692892e-70, -1.5949241485490116e-72, -7.167840155013551e-75, -2.1551014698940333e-77, -4.329205942914851e-80, -5.800372840009325e-83, -5.171141370407016e-86, -3.057458742054375e-89, -1.1930750206817491e-92, -3.04952659392974e-96, -5.041549898537378e-100, -5.2646089808660066e-104, -3.2924398045180523e-108, -1.0404849640777166e-112, 0., 1.271324981018245e-121, 4.915456070193597e-126, 9.603868576735209e-131, 1.1238070464711613e-135, 8.306649664873738e-141, 3.9714593264215353e-146, 1.2438274766253188e-151, 2.5712061518617095e-157, 3.525307542155043e-163, 3.2165181491161535e-169, 1.9576505438772654e-175, 7.96170656214444e-182, 2.1665942781463613e-188, 3.9491109905551e-195, 4.825342946695724e-202, 3.955048825172548e-209}, {-1.7066441378801192e-66, -2.3150084656917308e-65, -2.0501638616962612e-64, -1.207899544594916e-63, -4.759545050650916e-63, -1.2571635558824338e-62, -2.2285653763065324e-62, -2.6531182134008665e-62, -2.1220477029246736e-62, -1.1405613967244052e-62, -4.1200045626634093e-63, -1.0002512094788716e-63, -1.6320876903418636e-64, -1.7896550526411817e-65, -1.3186651368271288e-66, -6.527796138157228e-68, -2.1705578882576043e-69, -4.846526035664961e-71, -7.264362944173099e-73, -7.306201986275665e-75, -4.928219196217281e-77, -2.2280027220349844e-79, -6.745615503110362e-82, -1.366363430774833e-84, -1.849177923053045e-87, -1.6691840734959794e-90, -1.0025772630552991e-93, -3.9937404924242056e-97, -1.0499750277275062e-100, -1.808170510056726e-104, -2.014049572904743e-108, -1.4170148499119938e-112, -5.970780465740732e-117, -1.271324981018245e-121, 0., 7.051785969375736e-131, 1.8370469179674042e-135, 2.4183453120390105e-140, 1.9066947920287436e-145, 9.495857134474325e-151, 3.058994214890243e-156, 6.455208146001091e-162, 8.99103703673644e-168, 8.306036106211289e-174, 5.1063171281908105e-180, 2.094030028547151e-186, 5.738267430651854e-193, 1.0521555622606696e-199, 1.2922015586272374e-206, 1.063869662420611e-213}, {-3.3963361225541636e-71, -4.610996668284739e-70, -4.0872365954200444e-69, -2.4104401059094334e-68, -9.507867562799979e-68, -2.5141563509641936e-67, -4.462133793764643e-67, -5.31897698170106e-67, -4.26012950290605e-67, -2.293133032722216e-67, -8.296667903541e-68, -2.017761046396535e-68, -3.2985713845483034e-69, -3.6245154860902746e-70, -2.676708426466602e-71, -1.3283735527220827e-72, -4.4292450796085604e-74, -9.92045009055972e-76, -1.492119877081499e-77, -1.5065988818368104e-79, -1.0207760741034427e-81, -4.63850087813608e-84, -1.4127357388659962e-86, -2.8815889736391687e-89, -3.9323179677492295e-92, -3.5854111562694216e-95, -2.1804574510811467e-98, -8.823665406168333e-102, -2.3681161651935337e-105, -4.194670682464549e-109, -4.8669559055605484e-113, -3.652501314010032e-117, -1.7314087382644675e-121, -4.915456070193597e-126, -7.051785969375736e-131, 0., 1.7756914162342976e-140, 3.116766712254666e-145, 2.764519683033066e-150, 1.4685928237155637e-155, 4.928044856997095e-161, 1.0696475568868003e-166, 1.5208804676025405e-172, 1.4273107438516816e-178, 8.884388377862355e-185, 3.6801664579270384e-191, 1.016879439596576e-197, 1.8775654796934355e-204, 2.3196519146602463e-211, 1.9195633257602187e-218}, {-4.550273468386672e-76, -6.182655820987533e-75, -5.485116871569749e-74, -3.237810569423115e-73, -1.278387567378302e-72, -3.3839493302930893e-72, -6.012526106977708e-72, -7.17561629799529e-72, -5.754508007127946e-72, -3.1017786102681427e-72, -1.1239013065980974e-72, -2.737723795236995e-73, -4.4833270707989235e-74, -4.935671478072521e-75, -3.652545060176449e-76, -1.816772927533433e-77, -6.072915471905105e-79, -1.363966181814981e-80, -2.0578723394253375e-82, -2.0850559328465347e-84, -1.4182419784228368e-86, -6.473393340536857e-89, -1.9816946890418527e-91, -4.066167549386373e-94, -5.587638727519584e-97, -5.137156315550474e-100, -3.1557038313596347e-103, -1.2929826100946315e-106, -3.525218816137063e-110, -6.3743483067055365e-114, -7.607286765384987e-118, -5.946912164266961e-122, -3.0069726073021504e-126, -9.603868576735209e-131, -1.8370469179674042e-135, -1.7756914162342976e-140, 0., 2.0298569424951293e-150, 2.4005986499642737e-155, 1.4346758744550466e-160, 5.135181161462879e-166, 1.1610491040991638e-171, 1.6980067913126367e-177, 1.6267383983052068e-183, 1.0286464770740937e-189, 4.314208223740473e-196, 1.2041148470419988e-202, 2.2418041105738806e-209, 2.7890213818541864e-216, 2.321714911639111e-223}, {-4.1043530164522482e-81, -5.581055450647157e-80, -4.955435397644825e-79, -2.92767739506231e-78, -1.1569998584858e-77, -3.065624384576522e-77, -5.452607293505908e-77, -6.5146227314418295e-77, -5.230641692414206e-77, -2.8230064463350208e-77, -1.0242958147332533e-77, -2.498790095763165e-78, -4.098604342306999e-79, -4.519979411670899e-80, -3.3512555287841384e-81, -1.670362923943121e-82, -5.59620147029148e-84, -1.260047169663681e-85, -1.9063662093048095e-87, -1.937528499253257e-89, -1.322470766062908e-91, -6.059928865163925e-94, -1.8634029330537622e-96, -3.843056410832069e-99, -5.31247905624794e-102, -4.918335468008601e-105, -3.0464617393353117e-108, -1.2608312964189055e-111, -3.4805302117771133e-115, -6.393439256721222e-119, -7.789030121313993e-123, -6.262959105900398e-127, -3.298726358580999e-131, -1.1238070464711613e-135, -2.4183453120390105e-140, -3.116766712254666e-145, -2.0298569424951293e-150, 0., 1.053407407008732e-160, 8.394007291085038e-166, 3.3800555573276724e-171, 8.151684838627153e-177, 1.2418381078586942e-182, 1.223707817142596e-188, 7.89916166027576e-195, 3.3655448760361565e-201, 9.510803889720546e-208, 1.7885940508868056e-214, 2.243727385940529e-221, 1.880847526802465e-228}, {-2.492595625255679e-86, -3.391873879999755e-85, -3.013980274506899e-84, -1.7821180843165316e-83, -7.048917270134778e-83, -1.869420642409672e-82, -3.3282553219477195e-82, -3.980648589960619e-82, -3.19964914319194e-82, -1.728924254455435e-82, -6.281216977430099e-83, -1.5344202544430877e-83, -2.52053925542579e-84, -2.7841290002503224e-85, -2.0678311803106565e-86, -1.0326190371204477e-87, -3.466736698014337e-89, -7.823484612667118e-91, -1.1866068652132992e-92, -1.2093536665047636e-94, -8.280065927013152e-97, -3.807330653405429e-99, -1.175329478455352e-101, -2.434804598023894e-104, -3.383031524720754e-107, -3.1506806400597564e-110, -1.9652075300600453e-113, -8.201131885493728e-117, -2.286793920364074e-120, -4.253154863497032e-124, -5.263800982313328e-128, -4.32066401731552e-132, -2.3407318645649175e-136, -8.306649664873738e-141, -1.9066947920287436e-145, -2.764519683033066e-150, -2.4005986499642737e-155, -1.053407407008732e-160, 0., 2.481781123205603e-171, 1.3324677612914292e-176, 3.6152037137814586e-182, 5.874610811804877e-188, 6.030045911700773e-194, 4.0036706360621576e-200, 1.74135601063367e-206, 4.9990655881554433e-213, 9.518717148494245e-220, 1.2061505913891018e-226, 1.0195045303062497e-233}, {-1.01924098325907e-91, -1.3879203731531953e-90, -1.2341916608670519e-89, -7.303212079428925e-89, -2.8910427887372926e-88, -7.673879754619808e-88, -1.3674881617408424e-87, -1.6371372987256202e-87, -1.3173032893119128e-87, -7.125940674507214e-88, -2.591950725610774e-88, -6.339887747542991e-89, -1.0428620423772133e-89, -1.1536276909963829e-90, -8.581966705129506e-92, -4.2930555859668534e-93, -1.4440059797921556e-94, -3.2654767615408024e-96, -4.964084143789347e-98, -5.071923553483716e-100, -3.4822333397212704e-102, -1.6061539045722605e-104, -4.975440605914757e-107, -1.0347509064242114e-109, -1.4441498079507227e-112, -1.3518610224019133e-115, -8.482297579377745e-119, -3.564555126740266e-122, -1.0022191406825966e-125, -1.882832410580447e-129, -2.3593640728022457e-133, -1.9673671782973526e-137, -1.0880314163379437e-141, -3.9714593264215353e-146, -9.495857134474325e-151, -1.4685928237155637e-155, -1.4346758744550466e-160, -8.394007291085038e-166, -2.481781123205603e-171, 0., 2.6544203194793228e-182, 9.6025039411264e-188, 1.7554292975284862e-193, 1.9220008901256656e-199, 1.3292910339741836e-205, 5.9468058277418e-212, 1.7427691616201115e-218, 3.371078595449383e-225, 4.325009066679391e-232, 3.6926611177761923e-239}, {-2.806315581479242e-97, -3.8239200418373475e-96, -3.4027317846353536e-95, -2.0150061374197685e-94, -7.98274421045685e-94, -2.1206419812693304e-93, -3.7822635734918733e-93, -4.532233768129207e-93, -3.650373460782014e-93, -1.9767232895431277e-93, -7.198023090892025e-94, -1.7627258467268086e-94, -2.9032495357477637e-95, -3.2160243314414853e-96, -2.395981178675182e-97, -1.2004899156743258e-98, -4.0449730737698634e-100, -9.164631144272305e-102, -1.3960653819488308e-103, -1.4296352098777382e-105, -9.84005444843273e-108, -4.5512583765579983e-110, -1.414224535390673e-112, -2.9513994486976095e-115, -4.135273211273982e-118, -3.888288737300554e-121, -2.4522312662911773e-124, -1.0366464849430311e-127, -2.935043155217021e-131, -5.559907781371567e-135, -7.037455959804932e-139, -5.941569503433607e-143, -3.3380790732146556e-147, -1.2438274766253188e-151, -3.058994214890243e-156, -4.928044856997095e-161, -5.135181161462879e-166, -3.3800555573276724e-171, -1.3324677612914292e-176, -2.6544203194793228e-182, 0., 1.2888955848670964e-193, 3.1416320645847563e-199, 3.8697070210777915e-205, 2.8547843024231294e-211, 1.330349497456046e-217, 4.010110264620123e-224, 7.91844981576624e-231, 1.0320428689536762e-237, 8.921650386739546e-245}, {-5.202907880665164e-103, -7.093964253915357e-102, -6.31674773727347e-101, -3.743200162584734e-100, -1.4840079994938109e-99, -3.9453598103787255e-99, -7.042481627116032e-99, -8.446214073390475e-99, -6.809042816564011e-99, -3.690786885958863e-99, -1.3453599029593985e-99, -3.2983203525490446e-100, -5.4388757434875494e-101, -6.03251483002121e-102, -4.500477798376169e-103, -2.2582741369985226e-104, -7.621302630713576e-106, -1.72974945002269e-107, -2.6399501032185783e-109, -2.709027583003879e-111, -1.8688377830556536e-113, -8.66548133578645e-116, -2.700127478831417e-118, -5.6524454626033975e-121, -7.947269707265984e-124, -7.501913222542913e-127, -4.752361337408698e-130, -2.0192968509978806e-133, -5.751238829196087e-137, -1.097086710751747e-140, -1.4002100176633764e-144, -1.194107641559048e-148, -6.79256726482765e-153, -2.5712061518617095e-157, -6.455208146001091e-162, -1.0696475568868003e-166, -1.1610491040991638e-171, -8.151684838627153e-177, -3.6152037137814586e-182, -9.6025039411264e-188, -1.2888955848670964e-193, 0., 2.84125445962357e-205, 4.666288988247961e-211, 3.87274916211194e-217, 1.9250434753909693e-223, 6.044492925282633e-230, 1.227660221903073e-236, 1.6333926447776417e-243, 1.434423802797206e-250}, {-6.495611952036193e-109, -8.861769585611554e-108, -7.895806686592734e-107, -4.682002601044325e-106, -1.8574866611537237e-105, -4.941894033037738e-105, -8.828110656857028e-105, -1.0596411153790396e-104, -8.549852677201838e-105, -4.6386384070340285e-105, -1.6925221208060738e-105, -4.1537548647017413e-106, -6.857092105797446e-107, -7.614580002711133e-108, -5.6880116856024e-109, -2.858081877248478e-110, -9.659844505504975e-112, -2.195935386988003e-113, -3.357273429742813e-115, -3.4516453893883594e-117, -2.3860667073488531e-119, -1.108892840357326e-121, -3.4639231837664527e-124, -7.271517703162302e-127, -1.0255317839667216e-129, -9.71423407568343e-133, -6.177969598320079e-136, -2.6367622998436436e-139, -7.548378609693612e-143, -1.4484738191016785e-146, -1.8616126890305418e-150, -1.6008246087839053e-154, -9.198119076423503e-159, -3.525307542155043e-163, -8.99103703673644e-168, -1.5208804676025405e-172, -1.6980067913126367e-177, -1.2418381078586942e-182, -5.874610811804877e-188, -1.7554292975284862e-193, -3.1416320645847563e-199, -2.84125445962357e-205, 0., 2.843473761610058e-217, 3.1465576908464062e-223, 1.7595815302112577e-229, 5.893285076364577e-236, 1.24682220280591e-242, 1.7062843016719413e-249, 1.529653713898005e-256}, {-5.460992917553896e-115, -7.454480727758537e-114, -6.645870552487289e-113, -3.943288393437884e-112, -1.5654464629571719e-111, -4.167799391012111e-111, -7.45072436229656e-111, -8.950035605970199e-111, -7.227352952720281e-111, -3.9245241169865995e-111, -1.4332759731895644e-111, -3.5209564462969225e-112, -5.818511910971417e-113, -6.468457310764816e-114, -4.837622238517133e-115, -2.4338871560113358e-116, -8.237436075191408e-118, -1.8753589358600197e-119, -2.8717523548966366e-121, -2.9576112029063515e-123, -2.0484211053992853e-125, -9.539474931303563e-128, -2.986682498902629e-130, -6.2854006489224406e-133, -8.889180527857007e-136, -8.446244582270816e-139, -5.390216524214092e-142, -2.3095704256432084e-145, -6.6412282131420505e-149, -1.2809342518684996e-152, -1.6560862154739654e-156, -1.4340484299013768e-160, -8.308511364563682e-165, -3.2165181491161535e-169, -8.306036106211289e-174, -1.4273107438516816e-178, -1.6267383983052068e-183, -1.223707817142596e-188, -6.030045911700773e-194, -1.9220008901256656e-199, -3.8697070210777915e-205, -4.666288988247961e-211, -2.843473761610058e-217, 0., 1.2919247213103183e-229, 9.632735627906536e-236, 3.6295285648345413e-242, 8.190794309957156e-249, 1.1676203476402413e-255, 1.0766581727133896e-262}, {-3.0918124591853584e-121, -4.222727364358954e-120, -3.7668106492874015e-119, -2.2363454173279667e-118, -8.883622225327729e-118, -2.3667059099241305e-117, -4.233863454990171e-117, -5.089562646208492e-117, -4.113108810254284e-117, -2.2352834753610226e-117, -8.170549694102154e-118, -2.009005346342645e-118, -3.323201614357939e-119, -3.69826164502625e-120, -2.7689281521014787e-121, -1.3947516485637672e-122, -4.726534176620517e-124, -1.0775347784967928e-125, -1.6524822496560258e-127, -1.7046150855094725e-129, -1.1826578682627177e-131, -5.518056008165474e-134, -1.7312066879854955e-136, -3.6515625394333405e-139, -5.177195904545359e-142, -4.932887683901566e-145, -3.157812014743434e-148, -1.3577400425126316e-151, -3.919526506460325e-155, -7.593579430093197e-159, -9.867885546979704e-163, -8.595722818270649e-167, -5.014969050106753e-171, -1.9576505438772654e-175, -5.1063171281908105e-180, -8.884388377862355e-185, -1.0286464770740937e-189, -7.89916166027576e-195, -4.0036706360621576e-200, -1.3292910339741836e-205, -2.8547843024231294e-211, -3.87274916211194e-217, -3.1465576908464062e-223, -1.2919247213103183e-229, 0., 2.6648705874392447e-242, 1.3387991798407653e-248, 3.3989420587544856e-255, 5.168304817099263e-262, 4.96424347146326e-269}, {-1.178843656676073e-127, -1.610867069131741e-126, -1.4377235666547018e-125, -8.540567990019253e-125, -3.3946607908270565e-124, -9.049448574673995e-124, -1.619945093793679e-123, -1.9486990514568597e-123, -1.575984198877768e-123, -8.571355358302996e-124, -3.1356157695093745e-124, -7.716644738299435e-125, -1.2776240800151767e-125, -1.4232079294180955e-126, -1.0666810084196005e-127, -5.3790127918231934e-129, -1.8250098212416235e-130, -4.1658919388206015e-132, -6.397490596347255e-134, -6.609096661365906e-136, -4.5927238103718656e-138, -2.146604061765074e-140, -6.747400876764362e-143, -1.4261478976001306e-145, -2.026592051020379e-148, -1.935798097756291e-151, -1.2426528079020392e-154, -5.359479906079988e-158, -1.5525478042781897e-161, -3.019657597197401e-165, -3.94157472039445e-169, -3.451036262845811e-173, -2.025409302056094e-177, -7.96170656214444e-182, -2.094030028547151e-186, -3.6801664579270384e-191, -4.314208223740473e-196, -3.3655448760361565e-201, -1.74135601063367e-206, -5.9468058277418e-212, -1.330349497456046e-217, -1.9250434753909693e-223, -1.7595815302112577e-229, -9.632735627906536e-236, -2.6648705874392447e-242, 0., 2.4955592120693155e-255, 8.44763107490945e-262, 1.445079765282086e-268, 1.480558245055223e-275}, {-3.0269943241126915e-134, -4.138365663105201e-133, -3.695463618090269e-132, -2.1964192334212955e-131, -8.735165472848333e-131, -2.3299966697374314e-130, -4.173544011577528e-130, -5.023831939315496e-130, -4.065772273667337e-130, -2.212880911775507e-130, -8.101521983890582e-131, -1.9953861447004236e-131, -3.306567434812677e-132, -3.6867325625110906e-133, -2.765872560358223e-134, -1.39621511320708e-135, -4.742395624289809e-137, -1.0838203107532268e-138, -1.6665304061861287e-140, -1.7240181687262777e-142, -1.1998114083896838e-144, -5.616813867059441e-147, -1.768598439220917e-149, -3.745234710345691e-152, -5.333091555173798e-155, -5.1057397753581314e-158, -3.2857575817588283e-161, -1.4210621145337345e-164, -4.129313761813647e-168, -8.05927467816246e-172, -1.05610671984208e-175, -9.287996961699244e-180, -5.479069408447222e-184, -2.1665942781463613e-188, -5.738267430651854e-193, -1.016879439596576e-197, -1.2041148470419988e-202, -9.510803889720546e-208, -4.9990655881554433e-213, -1.7427691616201115e-218, -4.010110264620123e-224, -6.044492925282633e-230, -5.893285076364577e-236, -3.6295285648345413e-242, -1.3387991798407653e-248, -2.4955592120693155e-255, 0., 1.0609972589282423e-268, 2.419969427012248e-275, 2.789305473494601e-282}, {-5.2346713988541747e-141, -7.15997073525818e-140, -6.396845078249147e-139, -3.8039650979894846e-138, -1.513656625322085e-137, -4.039780779558694e-137, -7.240456149476936e-137, -8.72102540372893e-137, -7.062543323381007e-137, -3.8465995791658734e-137, -1.409298217812958e-137, -3.473749308383685e-138, -5.761075624135368e-139, -6.42900371282724e-140, -4.827621268617995e-141, -2.4393700298836662e-142, -8.294214926504189e-144, -1.8976565195302286e-145, -2.9213949420941525e-147, -3.0260295879246058e-149, -2.1088246426983075e-151, -9.886906706382963e-154, -3.1181361121099416e-156, -6.614537912109105e-159, -9.436724130585512e-162, -9.053137718340668e-165, -5.839314712299032e-168, -2.5317832403747244e-171, -7.377276209823963e-175, -1.4442973223346657e-178, -1.899213590219407e-182, -1.67682543461682e-186, -9.935897212765866e-191, -3.9491109905551e-195, -1.0521555622606696e-199, -1.8775654796934355e-204, -2.2418041105738806e-209, -1.7885940508868056e-214, -9.518717148494245e-220, -3.371078595449383e-225, -7.91844981576624e-231, -1.227660221903073e-236, -1.24682220280591e-242, -8.190794309957156e-249, -3.3989420587544856e-255, -8.44763107490945e-262, -1.0609972589282423e-268, 0., 2.047938677741106e-282, 3.1473271242973997e-289}, {-6.096760323927331e-148, -8.342897306313406e-147, -7.457216855599501e-146, -4.436719603454347e-145, -1.766351814457657e-144, -4.716747038965679e-144, -8.458570688352345e-144, -1.0194291285117601e-143, -8.260800441892142e-144, -4.5021878528741744e-144, -1.6506325195235154e-144, -4.071583243293673e-145, -6.757773855178209e-146, -7.547418388267196e-147, -5.6723600655373974e-148, -2.868846205860774e-149, -9.764031934955396e-151, -2.2362670649285578e-152, -3.446506894211693e-154, -3.574199242493572e-156, -2.494022440450653e-158, -1.1708910167868505e-160, -3.6982309600492584e-163, -7.857672044321332e-166, -1.1229755137564033e-168, -1.0793689084594763e-171, -6.976392237411141e-175, -3.031666616134193e-178, -8.856009229037488e-182, -1.7386146055024476e-185, -2.2933113199256715e-189, -2.0318068179801498e-193, -1.2086524463028568e-197, -4.825342946695724e-202, -1.2922015586272374e-206, -2.3196519146602463e-211, -2.7890213818541864e-216, -2.243727385940529e-221, -1.2061505913891018e-226, -4.325009066679391e-232, -1.0320428689536762e-237, -1.6333926447776417e-243, -1.7062843016719413e-249, -1.1676203476402413e-255, -5.168304817099263e-262, -1.445079765282086e-268, -2.419969427012248e-275, -2.047938677741106e-282, 0., 1.7946406914612964e-296}, {-4.782440482948144e-155, -6.547194162576645e-154, -5.85479562318809e-153, -3.484995656693987e-152, -1.3881359021585369e-151, -3.7087003654740356e-151, -6.65443349342737e-151, -8.024489498858467e-151, -6.506402662663954e-151, -3.548247756870972e-151, -1.3017462885134838e-151, -3.2132175593023003e-152, -5.337007563462203e-153, -5.9652386450817104e-154, -4.486915170505413e-155, -2.2712617387125328e-156, -7.737276078031176e-158, -1.7738091583209242e-159, -2.736620219263987e-161, -2.841168270675848e-163, -1.9848846084481726e-165, -9.33051642953214e-168, -2.951069155468156e-170, -6.27945827012072e-173, -8.988640150658347e-176, -8.654624908979454e-179, -5.6044240241906315e-182, -2.4405053735118093e-185, -7.145330150910027e-189, -1.4062892569340753e-192, -1.8601118150071196e-196, -1.6531068966649378e-200, -9.867913066155837e-205, -3.955048825172548e-209, -1.063869662420611e-213, -1.9195633257602187e-218, -2.321714911639111e-223, -1.880847526802465e-228, -1.0195045303062497e-233, -3.6926611177761923e-239, -8.921650386739546e-245, -1.434423802797206e-250, -1.529653713898005e-256, -1.0766581727133896e-262, -4.96424347146326e-269, -1.480558245055223e-275, -2.789305473494601e-282, -3.1473271242973997e-289, -1.7946406914612964e-296, 0.}}, {{0., 2.6955726360900592e-11, 7.312872445361847e-10, 9.903330386860102e-9, 7.980077210213063e-8, 4.045339274930749e-7, 1.3227754290645763e-6, 2.8276650581880487e-6, 3.9835859511530206e-6, 3.7178004203892003e-6, 2.3068102361681093e-6, 9.540220663618545e-7, 2.6347810472180906e-7, 4.866234399028864e-8, 6.017120474222162e-9, 4.985587789948431e-10, 2.7700431687489613e-11, 1.0326507084468013e-12, 2.5842104192613905e-14, 4.3429667719000925e-16, 4.903192359637748e-18, 3.719914018681401e-20, 1.8969609570897673e-22, 6.503554047459793e-25, 1.4993160674879973e-27, 2.3246563582891174e-30, 2.424442727627414e-33, 1.701021831727015e-36, 8.029779231945976e-40, 2.550578513305718e-43, 5.4520037915793325e-47, 7.843193440922351e-51, 7.594207852287751e-55, 4.949429910954678e-59, 2.171394229317953e-63, 6.4129556665615056e-68, 1.2750786654293088e-72, 1.7068530512158302e-77, 1.5383502701412834e-82, 9.335386249039463e-88, 3.814555688871636e-93, 1.0495560927362647e-98, 1.9446062629311973e-104, 2.426248806786311e-110, 2.0385858232446385e-116, 1.1535175943548262e-122, 4.395737938414113e-129, 1.1281368953314736e-135, 1.949951049841699e-142, 2.2700027584793413e-149}, {-2.6955726360900592e-11, 0., 7.581704509245442e-9, 1.3686126411066533e-7, 1.2405082402436152e-6, 6.70719100565484e-6, 0.00002284424964911675, 0.000050226886901610655, 0.00007223116597271621, 0.0000684803620412985, 0.00004302084843726853, 0.000017971480571798777, 5.004592283364296e-6, 9.307629525946019e-7, 1.1577326575144198e-7, 9.641708927479608e-9, 5.380909902283032e-10, 2.0138160551778235e-11, 5.057050076459778e-13, 8.525037432369948e-15, 9.651427395975962e-17, 7.340589182992323e-19, 3.751809533259198e-21, 1.2889318885871563e-23, 2.9770962112487487e-26, 4.623936805153321e-29, 4.8301363379874965e-32, 3.393901682897266e-35, 1.6043096002100473e-38, 5.102425803474302e-42, 1.0919683286535365e-45, 1.5726383858374176e-49, 1.5242979386620196e-53, 9.944116653773624e-58, 4.366646760993569e-62, 1.2907521920377886e-66, 2.5684772237790533e-71, 3.440880351939329e-76, 3.1034554482334747e-81, 1.8846163585557016e-86, 7.705836578578521e-92, 2.1215465922650853e-97, 3.9331147602823327e-103, 4.910052632820763e-109, 4.127759451885153e-115, 2.3368650218213874e-121, 8.909541881258331e-128, 2.287654033937172e-134, 3.9559298678741236e-141, 4.607225757400596e-148}, {-7.312872445361847e-10, -7.581704509245442e-9, 0., 9.274753620027308e-7, 0.000011208823501875708, 0.00006817944737530688, 0.00024769564191102914, 0.0005672917359700649, 0.0008391300038499168, 0.0008121298887362173, 0.0005182959625986819, 0.00021921876732293525, 0.00006166338625112132, 0.00001156383463328908, 1.4484300125140374e-6, 1.2134465855507033e-7, 6.806813040915121e-9, 2.558835668118178e-10, 6.4508899287637786e-12, 1.0912494133159646e-13, 1.2392580853667514e-15, 9.451610814887526e-18, 4.842869726086245e-20, 1.6675462300813725e-22, 3.859570809364249e-25, 6.005923283483218e-28, 6.284661873375564e-31, 4.423002759254393e-34, 2.0938668290843798e-37, 6.668585445091096e-41, 1.4289642494299153e-44, 2.0604254310031874e-48, 1.9993126247923413e-52, 1.3056573258517743e-56, 5.7389888701971994e-61, 1.69796672817782e-65, 3.3817217636574675e-70, 4.534050937759022e-75, 4.092583707507628e-80, 2.4870949299646874e-85, 1.0176303746966017e-90, 2.8035510354800974e-96, 5.200726663732862e-102, 6.496388504028107e-108, 5.464450421770428e-114, 3.0952852719620936e-120, 1.1807197012239042e-126, 3.0331668505059233e-133, 5.247589202302365e-140, 6.11430904151051e-147}, {-9.903330386860102e-9, -1.3686126411066533e-7, -9.274753620027308e-7, 0., 0.000050583997833871635, 0.00041024692328314657, 0.0016767284900313286, 0.004096184961466682, 0.006311478667272032, 0.006282924184406405, 0.0040932568143278985, 0.0017587670618505423, 0.0005009022637788438, 0.0000948838508022811, 0.000011983731470231537, 1.0109779239929407e-6, 5.704824038773414e-8, 2.1555707758397116e-9, 5.458508897988048e-11, 9.269967234148783e-13, 1.0563827282602528e-14, 8.081795357223844e-17, 4.1524987125128794e-19, 1.4334141865191648e-21, 3.325207424825058e-24, 5.185107201501617e-27, 5.436027256614224e-30, 3.832406410029724e-33, 1.8171836981769065e-36, 5.7959738656702784e-40, 1.2436844688367445e-43, 1.7955605274045728e-47, 1.7443778608643926e-51, 1.1404385395582925e-55, 5.017994864996857e-60, 1.486101008582749e-64, 2.962483975454203e-69, 3.9753958692798316e-74, 3.591254879759704e-79, 2.184118781436161e-84, 8.943166235665532e-90, 2.465531584882391e-95, 4.576692766913733e-101, 5.720463755592277e-107, 4.8146438938458536e-113, 2.7287555409873867e-119, 1.0414674557363282e-125, 2.6768225251331468e-132, 4.633376870673429e-139, 5.401202676359801e-146}, {-7.980077210213063e-8, -1.2405082402436152e-6, -0.000011208823501875708, -0.000050583997833871635, 0., 0.0012394898926898503, 0.006754592249127947, 0.018563868137107295, 0.03051046020146647, 0.03163794201784538, 0.021200683204992143, 0.009299166618468604, 0.002690469819535532, 0.0005160151637301639, 0.00006583048222039375, 5.599906349655383e-6, 3.1820558644726645e-7, 1.2094982834512476e-8, 3.078494995381764e-10, 5.2514245263814115e-12, 6.007862795284397e-14, 4.612240215884874e-16, 2.3771471340552066e-18, 8.22854325344752e-21, 1.9136261417888657e-23, 2.990763049902258e-26, 3.141985114181839e-29, 2.219298935736735e-32, 1.0541386034834576e-35, 3.367601791964675e-39, 7.23681461353047e-43, 1.0462450952645597e-46, 1.0177198663750472e-50, 6.661565173049987e-55, 2.934387244361258e-59, 8.699367888035024e-64, 1.7358800061788865e-68, 2.3315410040351145e-73, 2.1080686731890139e-78, 1.2831264269441633e-83, 5.257989722645662e-89, 1.4506289842144195e-94, 2.694625414458338e-100, 3.3702607815089566e-106, 2.8383631392475565e-112, 1.6096329348568174e-118, 6.146872301894435e-125, 1.5807493429074224e-131, 2.737571316395335e-138, 3.1928080442043677e-145}, {-4.045339274930749e-7, -6.70719100565484e-6, -0.00006817944737530688, -0.00041024692328314657, -0.0012394898926898503, 0., 0.013695293012093655, 0.05018563256888958, 0.09279235747654159, 0.10263616105974993, 0.07164251071469822, 0.03232208934798176, 0.009546372235290606, 0.0018599965061644166, 0.00024025461164643925, 0.00002064382960650095, 1.1828275347406152e-6, 4.5273632046868e-8, 1.1591935483278777e-9, 1.9875409786196575e-11, 2.283986166092181e-13, 1.7602938283510947e-15, 9.104050674152051e-18, 3.1611423079922294e-20, 7.371958594316358e-23, 1.1550343342428167e-25, 1.2161941885633523e-28, 8.608209668805957e-32, 4.0965333892455035e-35, 1.310974220928397e-38, 2.821735453651966e-42, 4.0854999137870256e-46, 3.979570216025273e-50, 2.6081856515382145e-54, 1.1502608966537381e-58, 3.413889381759626e-63, 6.8192027520910385e-68, 9.168140979992509e-73, 8.297016698249553e-78, 5.054550142011807e-83, 2.0729434910191934e-88, 5.723468726082527e-94, 1.0639438677741283e-99, 1.3316334106936314e-105, 1.1222116183237062e-111, 6.368031030892662e-118, 2.4332735992088832e-124, 6.261033558617789e-131, 1.0848842584554421e-137, 1.2659459347200739e-144}, {-1.3227754290645763e-6, -0.00002284424964911675, -0.00024769564191102914, -0.0016767284900313286, -0.006754592249127947, -0.013695293012093655, 0., 0.06837157099195194, 0.16855711968982554, 0.2097431639206309, 0.1561661617204176, 0.07339125806010359, 0.022295526209639895, 0.0044345170948082244, 0.0005818959870203991, 0.00005062428788136653, 2.929914132540955e-6, 1.130792522354398e-7, 2.9155466924627382e-9, 5.028721221367241e-11, 5.808398407501647e-13, 4.496582797623614e-15, 2.3347042808675688e-17, 8.134795047185371e-20, 1.9029524801911905e-22, 2.989817305968987e-25, 3.1560202182686354e-28, 2.2389046707932074e-31, 1.0676711207791777e-34, 3.4232364520381177e-38, 7.380974074603605e-42, 1.0703800803549217e-45, 1.0441716740184956e-49, 6.852836751517066e-54, 3.026094885392579e-58, 8.991918045062112e-63, 1.7981226686475422e-67, 2.420021087651051e-72, 2.1922200957181742e-77, 1.3367299661915253e-82, 5.486867691949208e-88, 1.516180859199101e-93, 2.8206269066891276e-99, 3.532880620796998e-105, 2.9793388668337844e-111, 1.69174903985606e-117, 6.468345818930731e-124, 1.6653547107175253e-130, 2.8872899186325476e-137, 3.370987091901932e-144}, {-2.8276650581880487e-6, -0.000050226886901610655, -0.0005672917359700649, -0.004096184961466682, -0.018563868137107295, -0.05018563256888958, -0.06837157099195194, 0., 0.1544170261299642, 0.2561973506533004, 0.21459830043999223, 0.10757525837586591, 0.034041960173803724, 0.0069643024278690764, 0.0009328922681907317, 0.00008244882735931269, 4.831427651304294e-6, 1.8835116956013775e-7, 4.896767889759227e-9, 8.504984616608796e-11, 9.8821124800676e-13, 7.68948846529479e-15, 4.010340373873142e-17, 1.4027999938742782e-19, 3.292929540755758e-22, 5.189692598827924e-25, 5.493403002347046e-28, 3.906828811147991e-31, 1.8672917917773586e-34, 5.99942766401817e-38, 1.2960100003844262e-41, 1.8827269091410636e-45, 1.839571391035188e-49, 1.2090883830353972e-53, 5.346460380031475e-58, 1.590707951140813e-62, 3.184741138193314e-67, 4.2909829584623244e-72, 3.891113944492641e-77, 2.374968210734588e-82, 9.757478190919108e-88, 2.6986089777383013e-93, 5.0244585351543294e-99, 6.2980748491037904e-105, 5.315157132792991e-111, 3.0201812480901194e-117, 1.1555158975165716e-123, 2.9768774957450584e-130, 5.164199832662265e-137, 6.03275936980796e-144}, {-3.9835859511530206e-6, -0.00007223116597271621, -0.0008391300038499168, -0.006311478667272032, -0.03051046020146647, -0.09279235747654159, -0.16855711968982554, -0.1544170261299642, 0., 0.15790147451551084, 0.17635044745305395, 0.09945238626953846, 0.03356959433427401, 0.007153818592895435, 0.0009856579993228521, 0.00008892709043671551, 5.293763131069592e-6, 2.089548123115633e-7, 5.487295904586618e-9, 9.610069276001063e-11, 1.1244217388498258e-12, 8.801451765864332e-15, 4.613808427607148e-17, 1.621095419104634e-19, 3.820278693088873e-22, 6.041706128458446e-25, 6.415077560695567e-28, 4.574983519287231e-31, 2.1921205628655346e-34, 7.059078022761198e-38, 1.5280752597017443e-41, 2.224054733919829e-45, 2.176854624023983e-49, 1.433066210136805e-53, 6.346254487198101e-58, 1.8907657709800299e-62, 3.790318612580043e-67, 5.11299160627461e-72, 4.6416784997203846e-77, 2.83603158483871e-82, 1.1663131561392714e-87, 3.228617009984421e-93, 6.016469037721827e-99, 7.547704835990352e-105, 6.374680631571732e-111, 3.624872045951248e-117, 1.3878306075257379e-123, 3.5777263988934022e-130, 6.210416410293509e-137, 7.25925606362134e-144}, {-3.7178004203892003e-6, -0.0000684803620412985, -0.0008121298887362173, -0.006282924184406405, -0.03163794201784538, -0.10263616105974993, -0.2097431639206309, -0.2561973506533004, -0.15790147451551084, 0., 0.07314691675575104, 0.055001356860220424, 0.02088607393196849, 0.004747635455721251, 0.0006813879660961437, 0.00006323197515062106, 3.842571987565631e-6, 1.540810784698598e-7, 4.0968526509516154e-9, 7.24741762265246e-11, 8.550472744248845e-13, 6.7397170082868485e-15, 3.554056511678103e-17, 1.2551476278567016e-19, 2.971089791481083e-22, 4.717154630906043e-25, 5.026061313043941e-28, 3.5954884048645545e-31, 1.7275773270098687e-34, 5.577096222303353e-38, 1.2100151632866806e-41, 1.764776736766251e-45, 1.730595122887613e-49, 1.1412661690468488e-53, 5.062133550533143e-58, 1.5104166688590873e-62, 3.0320119272982045e-67, 4.0952891208107266e-72, 3.722213277088635e-77, 2.276774814367965e-82, 9.372950954465929e-88, 2.597179841871683e-93, 4.844245710181293e-99, 6.082403610213261e-105, 5.141305725262134e-111, 2.925788389890018e-117, 1.1209959490735467e-123, 2.8918487159106403e-130, 5.023134313233205e-137, 5.87513303461884e-144}, {-2.3068102361681093e-6, -0.00004302084843726853, -0.0005182959625986819, -0.0040932568143278985, -0.021200683204992143, -0.07164251071469822, -0.1561661617204176, -0.21459830043999223, -0.17635044745305395, -0.07314691675575104, 0., 0.01535690835469712, 0.0077754572268173, 0.001988378289838696, 0.0003044001281910196, 0.000029424960367868084, 1.8392281591786567e-6, 7.528661088705433e-8, 2.033565692675241e-9, 3.6423877930839905e-11, 4.3406805616374903e-13, 3.4499554367201043e-15, 1.8319879280056702e-17, 6.508344170509792e-20, 1.548506164074674e-22, 2.469515600287578e-25, 2.641552388587259e-28, 1.89624606916817e-31, 9.139381043795757e-35, 2.958640020443744e-38, 6.435197769016311e-42, 9.406905233592997e-46, 9.243803501918e-50, 6.107506284662005e-54, 2.713721131056654e-58, 8.110055294434391e-63, 1.6304251801307867e-67, 2.205213716819143e-72, 2.006881234495022e-77, 1.2290150652880295e-82, 5.065196406791406e-88, 1.4049928808156778e-93, 2.623146743677361e-99, 3.2966333120903183e-105, 2.7889754227569937e-111, 1.5884327786310325e-117, 6.090671894451826e-124, 1.5723675836749933e-130, 2.733091460338342e-137, 3.1987677256126215e-144}, {-9.540220663618545e-7, -0.000017971480571798777, -0.00021921876732293525, -0.0017587670618505423, -0.009299166618468604, -0.03232208934798176, -0.07339125806010359, -0.10757525837586591, -0.09945238626953846, -0.055001356860220424, -0.01535690835469712, 0., 0.0014616497750396778, 0.0004983737239293111, 0.0000858328390048722, 8.850203494947506e-6, 5.762378011328258e-7, 2.4261538690232902e-8, 6.689807831759776e-10, 1.217253529478836e-11, 1.468749456970566e-13, 1.1791476321832e-15, 6.313663473856471e-18, 2.2586856246712007e-20, 5.405994981471588e-23, 8.66554603431808e-26, 9.31060468995044e-29, 6.709855042163315e-32, 3.245193398903575e-35, 1.0538005350451856e-38, 2.298438494916709e-42, 3.3682541452240367e-46, 3.3173760276499973e-50, 2.1963732738251776e-54, 9.777530825039173e-59, 2.9271328347235193e-63, 5.894064955923896e-68, 7.983763290057307e-73, 7.275700076239936e-78, 4.461332817749546e-83, 1.8408585390668472e-88, 5.111884911893048e-94, 9.55392186388231e-100, 1.201860506448949e-105, 1.0177171500432163e-111, 5.801323667390631e-118, 2.226271523787289e-124, 5.751779671007758e-131, 1.0005059500239209e-137, 1.1717880863152217e-144}, {-2.6347810472180906e-7, -5.004592283364296e-6, -0.00006166338625112132, -0.0005009022637788438, -0.002690469819535532, -0.009546372235290606, -0.022295526209639895, -0.034041960173803724, -0.03356959433427401, -0.02088607393196849, -0.0077754572268173, -0.0014616497750396778, 0., 0.00006308371912952071, 0.000014486196329887133, 1.6803767675968816e-6, 1.1670349973308565e-7, 5.118341313280988e-9, 1.4516402497371986e-10, 2.6963809112138614e-12, 3.305120858910887e-14, 2.686598952648297e-16, 1.4530511182099764e-18, 5.2415456840891954e-21, 1.2632976270392625e-23, 2.037058019631606e-26, 2.199919619031913e-29, 1.592489445755522e-32, 7.7322127247225e-36, 2.5195731954424058e-39, 5.5124408108402994e-43, 8.10066377255798e-47, 7.998297453807044e-51, 5.307560004569336e-55, 2.367642826725919e-59, 7.101517704636269e-64, 1.4324461324644668e-68, 1.9434190756706026e-73, 1.7736851102789699e-78, 1.0890868250122815e-83, 4.499586429128948e-89, 1.2509788269456774e-94, 2.340633380940669e-100, 2.9475279248542047e-106, 2.4983615069383235e-112, 1.4254574809978722e-118, 5.474962544496652e-125, 1.4156631698440918e-131, 2.464407948532974e-138, 2.888413419577068e-145}, {-4.866234399028864e-8, -9.307629525946019e-7, -0.00001156383463328908, -0.0000948838508022811, -0.0005160151637301639, -0.0018599965061644166, -0.0044345170948082244, -0.0069643024278690764, -0.007153818592895435, -0.004747635455721251, -0.001988378289838696, -0.0004983737239293111, -0.00006308371912952071, 0., 1.2348272024160147e-6, 1.9098410612734346e-7, 1.4921997411105818e-8, 6.980733317108996e-10, 2.0623367096937998e-11, 3.940181896222856e-13, 4.930343921276403e-15, 4.071290910375032e-17, 2.229488411955825e-19, 8.1235995552112875e-22, 1.9742354065907056e-24, 3.2057017144089667e-27, 3.48260281216433e-30, 2.5339331681532342e-33, 1.2358247452338202e-36, 4.0427776646821824e-40, 8.875690965745434e-44, 1.3083421341719844e-47, 1.295397258446518e-51, 8.617621805644688e-56, 3.852961042788976e-60, 1.1580513998017071e-64, 2.3403279020414844e-69, 3.1806765810095953e-74, 2.907535311569505e-79, 1.7879439706300438e-84, 7.397077144835925e-90, 2.0591681377926006e-95, 3.8573758269200395e-101, 4.862944422230281e-107, 4.12618610673614e-113, 2.3565253877957398e-119, 9.05936989257138e-126, 2.344512881101973e-132, 4.084698081576568e-139, 4.791174048370984e-146}, {-6.017120474222162e-9, -1.1577326575144198e-7, -1.4484300125140374e-6, -0.000011983731470231537, -0.00006583048222039375, -0.00024025461164643925, -0.0005818959870203991, -0.0009328922681907317, -0.0009856579993228521, -0.0006813879660961437, -0.0003044001281910196, -0.0000858328390048722, -0.000014486196329887133, -1.2348272024160147e-6, 0., 1.096413343817114e-8, 1.1422016494595598e-9, 6.011313700683291e-11, 1.89433437896196e-12, 3.7700065690325426e-14, 4.852186745057347e-16, 4.090225673549117e-18, 2.2754106092987665e-20, 8.394563107360799e-23, 2.0606931763868336e-25, 3.373973213417568e-28, 3.691041446229585e-31, 2.7015782715499726e-34, 1.324343807993038e-37, 4.351692662602854e-41, 9.591362728571526e-45, 1.418746573885833e-48, 1.409058290274214e-52, 9.399789275353888e-57, 4.213203153449933e-61, 1.2692042904232577e-65, 2.570269347685116e-70, 3.4997996813927574e-75, 3.2048175680700073e-80, 1.9739113647751135e-85, 8.178559424878113e-91, 2.2798413389662465e-96, 4.276210442642672e-102, 5.397381685271621e-108, 4.584747845016127e-114, 2.6211442378321786e-120, 1.0086514388392924e-126, 2.612731177743747e-133, 4.555939159521496e-140, 5.348285382939867e-147}, {-4.985587789948431e-10, -9.641708927479608e-9, -1.2134465855507033e-7, -1.0109779239929407e-6, -5.599906349655383e-6, -0.00002064382960650095, -0.00005062428788136653, -0.00008244882735931269, -0.00008892709043671551, -0.00006323197515062106, -0.000029424960367868084, -8.850203494947506e-6, -1.6803767675968816e-6, -1.9098410612734346e-7, -1.096413343817114e-8, 0., 4.416455205481433e-11, 3.099125587585025e-12, 1.0986995509305463e-13, 2.332346852327668e-15, 3.12692384021625e-17, 2.7111997970016245e-19, 1.5396743482991945e-21, 5.7704092911031985e-24, 1.4342236677829855e-26, 2.3719743466255306e-29, 2.616504003214258e-32, 1.9284860024844114e-35, 9.509925276645734e-39, 3.140913925324469e-42, 6.953646911367917e-46, 1.0326114339472273e-49, 1.0291209476938924e-53, 6.886492271204007e-58, 3.095259380377978e-62, 9.347667909871613e-67, 1.8973012527192614e-71, 2.5888034258683878e-76, 2.3750948038948693e-81, 1.4654126057680004e-86, 6.081413261840664e-92, 1.6977559085236345e-97, 3.1887894545474515e-103, 4.0299922137981296e-109, 3.4273088373968213e-115, 1.9616048366685165e-121, 7.556381402216849e-128, 1.9592588120826942e-134, 3.4195895499801415e-141, 4.017783105891935e-148}, {-2.7700431687489613e-11, -5.380909902283032e-10, -6.806813040915121e-9, -5.704824038773414e-8, -3.1820558644726645e-7, -1.1828275347406152e-6, -2.929914132540955e-6, -4.831427651304294e-6, -5.293763131069592e-6, -3.842571987565631e-6, -1.8392281591786567e-6, -5.762378011328258e-7, -1.1670349973308565e-7, -1.4921997411105818e-8, -1.1422016494595598e-9, -4.416455205481433e-11, 0., 8.071377409769101e-14, 3.8152777764279506e-15, 9.111562841001102e-17, 1.3030040497665356e-18, 1.1768436061746144e-20, 6.874174612189964e-23, 2.6299842420663124e-25, 6.6405314434201375e-28, 1.1119646271283542e-30, 1.2389882657526503e-33, 9.208023202657488e-37, 4.572497462599477e-40, 1.5191820716778631e-43, 3.380554065489405e-47, 5.042508986901214e-51, 5.045171740912217e-55, 3.387762493542562e-59, 1.5274057720440953e-63, 4.6255710390572735e-68, 9.412076952453011e-73, 1.2871648261204545e-77, 1.1833528721954842e-82, 7.315011147555152e-88, 3.040984627729581e-93, 8.503160686960738e-99, 1.599461916200045e-104, 2.0241766688045712e-110, 1.7236605786905524e-116, 9.877038388745735e-123, 3.8090081879522536e-129, 9.886486989097068e-136, 1.727223326356502e-142, 2.0312341338154142e-149}, {-1.0326507084468013e-12, -2.0138160551778235e-11, -2.558835668118178e-10, -2.1555707758397116e-9, -1.2094982834512476e-8, -4.5273632046868e-8, -1.130792522354398e-7, -1.8835116956013775e-7, -2.089548123115633e-7, -1.540810784698598e-7, -7.528661088705433e-8, -2.4261538690232902e-8, -5.118341313280988e-9, -6.980733317108996e-10, -6.011313700683291e-11, -3.099125587585025e-12, -8.071377409769101e-14, 0., 6.693164784054135e-17, 2.1312626099160777e-18, 3.4288017794902996e-20, 3.3032701230207597e-22, 2.0099009879880736e-24, 7.909366623858068e-27, 2.0386667541859538e-29, 3.467957765611373e-32, 3.9124162395118837e-35, 2.9370346486985023e-38, 1.4706193040965262e-41, 4.920203554993618e-45, 1.1013834667547557e-48, 1.6512727258844884e-52, 1.6595203451375967e-56, 1.1187147573085057e-60, 5.061347942523451e-65, 1.5375158782841783e-69, 3.137216025138239e-74, 4.3011066810391526e-79, 3.963202227363592e-84, 2.4549643354730356e-89, 1.0225067161409375e-94, 2.8640920340928783e-100, 5.396049372607929e-106, 6.839011732161456e-112, 5.831668546956486e-118, 3.34597063640557e-124, 1.2918854280639078e-130, 3.356888453233102e-137, 5.870776677476334e-144, 6.910848534975539e-151}, {-2.5842104192613905e-14, -5.057050076459778e-13, -6.4508899287637786e-12, -5.458508897988048e-11, -3.078494995381764e-10, -1.1591935483278777e-9, -2.9155466924627382e-9, -4.896767889759227e-9, -5.487295904586618e-9, -4.0968526509516154e-9, -2.033565692675241e-9, -6.689807831759776e-10, -1.4516402497371986e-10, -2.0623367096937998e-11, -1.89433437896196e-12, -1.0986995509305463e-13, -3.8152777764279506e-15, -6.693164784054135e-17, 0., 2.5185784465681605e-20, 5.402560416033616e-22, 5.855363550454421e-24, 3.800258708264688e-26, 1.5577902203895081e-28, 4.129980139824918e-31, 7.171836249798174e-34, 8.219417536496216e-37, 6.247411197247524e-40, 3.159774496771551e-43, 1.065965187767672e-46, 2.4028405851952353e-50, 3.623953667323304e-54, 3.660731446133883e-58, 2.47878669066785e-62, 1.1258635717459845e-66, 3.431978338039439e-71, 7.024442164486939e-76, 9.65722460124046e-81, 8.920833761963704e-86, 5.538476449961232e-91, 2.311583183021118e-96, 6.487122154230613e-102, 1.224322018310357e-107, 1.5542057868481856e-113, 1.3272444810692403e-119, 7.625641257685105e-126, 2.948034388685361e-132, 7.669413712128159e-139, 1.3427761948862753e-145, 1.5823101077731842e-152}, {-4.3429667719000925e-16, -8.525037432369948e-15, -1.0912494133159646e-13, -9.269967234148783e-13, -5.2514245263814115e-12, -1.9875409786196575e-11, -5.028721221367241e-11, -8.504984616608796e-11, -9.610069276001063e-11, -7.24741762265246e-11, -3.6423877930839905e-11, -1.217253529478836e-11, -2.6963809112138614e-12, -3.940181896222856e-13, -3.7700065690325426e-14, -2.332346852327668e-15, -9.111562841001102e-17, -2.1312626099160777e-18, -2.5185784465681605e-20, 0., 4.300758827848084e-24, 6.214956006202933e-26, 4.537847315646072e-28, 1.984149596148495e-30, 5.479515630056757e-33, 9.787212735542784e-36, 1.1450502569791554e-38, 8.84144036693552e-42, 4.5276625574059795e-45, 1.5428574057942417e-48, 3.5068068869786854e-52, 5.325936488084898e-56, 5.412010610905876e-60, 3.683421215082886e-64, 1.6804767053491392e-68, 5.142698362668446e-73, 1.056242675272283e-77, 1.4566214099729116e-82, 1.3492875236594972e-87, 8.398011542579305e-93, 3.513027852745797e-98, 9.879213556745713e-104, 1.8680466054770017e-109, 2.375500945334283e-115, 2.031856542619275e-121, 1.1691262375729027e-127, 4.525991468209115e-134, 1.1789561490536538e-140, 2.066597165650512e-147, 2.4379602263911855e-154}, {-4.903192359637748e-18, -9.651427395975962e-17, -1.2392580853667514e-15, -1.0563827282602528e-14, -6.007862795284397e-14, -2.283986166092181e-13, -5.808398407501647e-13, -9.8821124800676e-13, -1.1244217388498258e-12, -8.550472744248845e-13, -4.3406805616374903e-13, -1.468749456970566e-13, -3.305120858910887e-14, -4.930343921276403e-15, -4.852186745057347e-16, -3.12692384021625e-17, -1.3030040497665356e-18, -3.4288017794902996e-20, -5.402560416033616e-22, -4.300758827848084e-24, 0., 3.33289949259415e-28, 3.2446867418297814e-30, 1.5960622671264355e-32, 4.701606857998811e-35, 8.747660838265216e-38, 1.0526691925565197e-40, 8.297461180073176e-44, 4.316539142790354e-47, 1.4893009037573437e-50, 3.419269400684914e-54, 5.236264504825508e-58, 5.358098427579552e-62, 3.6684352327927805e-66, 1.682222461253826e-70, 5.171023157604262e-75, 1.06622515802438e-79, 1.4754933601932158e-84, 1.3710003412928474e-89, 8.556856062076855e-95, 3.5884462718640915e-100, 1.0114237365046665e-105, 1.9164465273082523e-111, 2.4416643149681996e-117, 2.09208068016397e-123, 1.2057082204035756e-129, 4.674524807260363e-136, 1.2193195548924728e-142, 2.140080042531026e-149, 2.527653351135875e-156}, {-3.719914018681401e-20, -7.340589182992323e-19, -9.451610814887526e-18, -8.081795357223844e-17, -4.612240215884874e-16, -1.7602938283510947e-15, -4.496582797623614e-15, -7.68948846529479e-15, -8.801451765864332e-15, -6.7397170082868485e-15, -3.4499554367201043e-15, -1.1791476321832e-15, -2.686598952648297e-16, -4.071290910375032e-17, -4.090225673549117e-18, -2.7111997970016245e-19, -1.1768436061746144e-20, -3.3032701230207597e-22, -5.855363550454421e-24, -6.214956006202933e-26, -3.33289949259415e-28, 0., 1.1722108912389317e-32, 7.688144635563132e-35, 2.5478305937302335e-37, 5.056440450924347e-40, 6.338312398947646e-43, 5.138796423892683e-46, 2.729019947661578e-49, 9.565174650799353e-53, 2.2235085451560825e-56, 3.4394726855695705e-60, 3.548829217411956e-64, 2.446705640994236e-68, 1.1286563197484114e-72, 3.487194997067244e-77, 7.222427245266429e-82, 1.0033935255570005e-86, 9.355714337204924e-92, 5.857281604595466e-97, 2.4631622898215824e-102, 6.959961162139635e-108, 1.321771226769531e-113, 1.6874999725833925e-119, 1.4486317410743137e-125, 8.363275984810158e-132, 3.247634177649627e-138, 8.483793642559644e-145, 1.4910723725698401e-151, 1.7633581138358258e-158}, {-1.8969609570897673e-22, -3.751809533259198e-21, -4.842869726086245e-20, -4.1524987125128794e-19, -2.3771471340552066e-18, -9.104050674152051e-18, -2.3347042808675688e-17, -4.010340373873142e-17, -4.613808427607148e-17, -3.554056511678103e-17, -1.8319879280056702e-17, -6.313663473856471e-18, -1.4530511182099764e-18, -2.229488411955825e-19, -2.2754106092987665e-20, -1.5396743482991945e-21, -6.874174612189964e-23, -2.0099009879880736e-24, -3.800258708264688e-26, -4.537847315646072e-28, -3.2446867418297814e-30, -1.1722108912389317e-32, 0., 1.8711651089173048e-37, 8.267988244944312e-40, 1.8459788535952864e-42, 2.4682218293277607e-45, 2.0844943797706233e-48, 1.1386243885124627e-51, 4.0740046334259456e-55, 9.620703751719022e-59, 1.5067976549992233e-62, 1.5704097255995888e-66, 1.091726176830406e-70, 5.071310160889354e-75, 1.5762028589940706e-79, 3.281259012867142e-84, 4.578920804046163e-89, 4.286161938714507e-94, 2.6927316934716985e-99, 1.1358801039954859e-104, 3.2184812456531646e-110, 6.127559765847722e-116, 7.84081035426082e-122, 6.744867195707547e-128, 3.901338056828847e-134, 1.5176055201589499e-140, 3.970793646908506e-147, 6.989222536065684e-154, 8.276882971456995e-161}, {-6.503554047459793e-25, -1.2889318885871563e-23, -1.6675462300813725e-22, -1.4334141865191648e-21, -8.22854325344752e-21, -3.1611423079922294e-20, -8.134795047185371e-20, -1.4027999938742782e-19, -1.621095419104634e-19, -1.2551476278567016e-19, -6.508344170509792e-20, -2.2586856246712007e-20, -5.2415456840891954e-21, -8.1235995552112875e-22, -8.394563107360799e-23, -5.7704092911031985e-24, -2.6299842420663124e-25, -7.909366623858068e-27, -1.5577902203895081e-28, -1.984149596148495e-30, -1.5960622671264355e-32, -7.688144635563132e-35, -1.8711651089173048e-37, 0., 1.3556752020339123e-42, 4.0357221630519715e-45, 6.070594855739835e-48, 5.468604464767239e-51, 3.1116091004790924e-54, 1.1451451185775492e-57, 2.7605822544579477e-61, 4.392261720421137e-65, 4.634909758119339e-69, 3.254669062706504e-73, 1.5244648286033926e-77, 4.771289867917898e-82, 9.9917515714705e-87, 1.4014761323002869e-91, 1.3177276200856505e-96, 8.310936048594792e-102, 3.517990853593109e-107, 9.99897964181654e-113, 1.9089605714398574e-118, 2.448823294353579e-124, 2.1113285192584222e-130, 1.2237542869903497e-136, 4.76937300339939e-143, 1.2500700453915956e-149, 2.2038464201500375e-156, 2.61373886506465e-163}, {-1.4993160674879973e-27, -2.9770962112487487e-26, -3.859570809364249e-25, -3.325207424825058e-24, -1.9136261417888657e-23, -7.371958594316358e-23, -1.9029524801911905e-22, -3.292929540755758e-22, -3.820278693088873e-22, -2.971089791481083e-22, -1.548506164074674e-22, -5.405994981471588e-23, -1.2632976270392625e-23, -1.9742354065907056e-24, -2.0606931763868336e-25, -1.4342236677829855e-26, -6.6405314434201375e-28, -2.0386667541859538e-29, -4.129980139824918e-31, -5.479515630056757e-33, -4.701606857998811e-35, -2.5478305937302335e-37, -8.267988244944312e-40, -1.3556752020339123e-42, 0., 4.4580918120157166e-48, 8.941239635113098e-51, 9.061404552597343e-54, 5.499621031413719e-57, 2.1083224061025778e-60, 5.2277119106822675e-64, 8.490905502561948e-68, 9.102202737245812e-72, 6.471531796168047e-76, 3.061839828286788e-80, 9.662844375340467e-85, 2.0376860174269332e-89, 2.8751384769135223e-94, 2.7171910145500937e-99, 1.7213887526579324e-104, 7.315154639958896e-110, 2.086362866884231e-115, 3.995522739044856e-121, 5.139712152982487e-127, 4.442467498243069e-133, 2.5807657368817472e-139, 1.0078917213928094e-145, 2.646724192079793e-152, 4.674232423499529e-159, 5.552474855187547e-166}, {-2.3246563582891174e-30, -4.623936805153321e-29, -6.005923283483218e-28, -5.185107201501617e-27, -2.990763049902258e-26, -1.1550343342428167e-25, -2.989817305968987e-25, -5.189692598827924e-25, -6.041706128458446e-25, -4.717154630906043e-25, -2.469515600287578e-25, -8.66554603431808e-26, -2.037058019631606e-26, -3.2057017144089667e-27, -3.373973213417568e-28, -2.3719743466255306e-29, -1.1119646271283542e-30, -3.467957765611373e-32, -7.171836249798174e-34, -9.787212735542784e-36, -8.747660838265216e-38, -5.056440450924347e-40, -1.8459788535952864e-42, -4.0357221630519715e-45, -4.4580918120157166e-48, 0., 6.654314932228508e-54, 8.991659931137975e-57, 6.139452443576861e-60, 2.5105138600755755e-63, 6.484343493048884e-67, 1.0832852505523874e-70, 1.1854689126923814e-74, 8.562294849093078e-79, 4.1016688040668364e-83, 1.3075187098039037e-87, 2.7802529908118167e-92, 3.9503199549165033e-97, 3.755528815055607e-102, 2.3913951812524475e-107, 1.020775881031332e-112, 2.9227826319602525e-118, 5.6167569979303135e-124, 7.247584934154573e-130, 6.281790907099095e-136, 3.6584312435508745e-142, 1.4320101758729655e-148, 3.768245107671495e-155, 6.667492104746811e-162, 7.934022827621316e-169}, {-2.424442727627414e-33, -4.8301363379874965e-32, -6.284661873375564e-31, -5.436027256614224e-30, -3.141985114181839e-29, -1.2161941885633523e-28, -3.1560202182686354e-28, -5.493403002347046e-28, -6.415077560695567e-28, -5.026061313043941e-28, -2.641552388587259e-28, -9.31060468995044e-29, -2.199919619031913e-29, -3.48260281216433e-30, -3.691041446229585e-31, -2.616504003214258e-32, -1.2389882657526503e-33, -3.9124162395118837e-35, -8.219417536496216e-37, -1.1450502569791554e-38, -1.0526691925565197e-40, -6.338312398947646e-43, -2.4682218293277607e-45, -6.070594855739835e-48, -8.941239635113098e-51, -6.654314932228508e-54, 0., 4.508464021818677e-60, 4.104470241314676e-63, 1.8881766271929163e-66, 5.2020524917383196e-70, 9.052745571795963e-74, 1.0189716723763462e-77, 7.513061825314661e-82, 3.656173510746694e-86, 1.180073756244396e-90, 2.5346054367198017e-95, 3.631302614606218e-100, 3.476383843952127e-105, 2.2268214553352427e-110, 9.554014745369512e-116, 2.7478088947229565e-121, 5.3012151078878075e-127, 6.864176790322201e-133, 5.96789414628929e-139, 3.485276461956025e-145, 1.36765178192016e-151, 3.607069319511292e-158, 6.395523300915309e-165, 7.624805514526302e-172}, {-1.701021831727015e-36, -3.393901682897266e-35, -4.423002759254393e-34, -3.832406410029724e-33, -2.219298935736735e-32, -8.608209668805957e-32, -2.2389046707932074e-31, -3.906828811147991e-31, -4.574983519287231e-31, -3.5954884048645545e-31, -1.89624606916817e-31, -6.709855042163315e-32, -1.592489445755522e-32, -2.5339331681532342e-33, -2.7015782715499726e-34, -1.9284860024844114e-35, -9.208023202657488e-37, -2.9370346486985023e-38, -6.247411197247524e-40, -8.84144036693552e-42, -8.297461180073176e-44, -5.138796423892683e-46, -2.0844943797706233e-48, -5.468604464767239e-51, -9.061404552597343e-54, -8.991659931137975e-57, -4.508464021818677e-60, 0., 1.3865439561866998e-66, 8.504678189793244e-70, 2.6359824842616306e-73, 4.893018166631568e-77, 5.7370335706885945e-81, 4.3508759351443383e-85, 2.1614310070685174e-89, 7.087011806375677e-94, 1.5412014114779025e-98, 2.23036675861199e-103, 2.1530082232732895e-108, 1.3887683722859446e-113, 5.993875948757177e-119, 1.7327257448355008e-124, 3.3577876693593936e-130, 4.36481708198163e-136, 3.808062381972655e-142, 2.2308104177886353e-148, 8.778203962287105e-155, 2.320981698800254e-161, 4.124575198651852e-168, 4.9275398136418177e-175}, {-8.029779231945976e-40, -1.6043096002100473e-38, -2.0938668290843798e-37, -1.8171836981769065e-36, -1.0541386034834576e-35, -4.0965333892455035e-35, -1.0676711207791777e-34, -1.8672917917773586e-34, -2.1921205628655346e-34, -1.7275773270098687e-34, -9.139381043795757e-35, -3.245193398903575e-35, -7.7322127247225e-36, -1.2358247452338202e-36, -1.324343807993038e-37, -9.509925276645734e-39, -4.572497462599477e-40, -1.4706193040965262e-41, -3.159774496771551e-43, -4.5276625574059795e-45, -4.316539142790354e-47, -2.729019947661578e-49, -1.1386243885124627e-51, -3.1116091004790924e-54, -5.499621031413719e-57, -6.139452443576861e-60, -4.104470241314676e-63, -1.3865439561866998e-66, 0., 1.935648059573683e-73, 7.999259179267127e-77, 1.6704619930944309e-80, 2.089180124348935e-84, 1.650418035298741e-88, 8.433213495043204e-93, 2.822732454284743e-97, 6.235989609932183e-102, 9.137287720688956e-107, 8.909462633115895e-112, 5.794817510090362e-117, 2.518512736121277e-122, 7.323921016832166e-128, 1.4265549788411281e-133, 1.8626696228064163e-139, 1.6314494534238657e-145, 9.590419129305008e-152, 3.785498504348653e-158, 1.0036766683615251e-164, 1.78808612919657e-171, 2.1410423767398228e-178}, {-2.550578513305718e-43, -5.102425803474302e-42, -6.668585445091096e-41, -5.7959738656702784e-40, -3.367601791964675e-39, -1.310974220928397e-38, -3.4232364520381177e-38, -5.99942766401817e-38, -7.059078022761198e-38, -5.577096222303353e-38, -2.958640020443744e-38, -1.0538005350451856e-38, -2.5195731954424058e-39, -4.0427776646821824e-40, -4.351692662602854e-41, -3.140913925324469e-42, -1.5191820716778631e-43, -4.920203554993618e-45, -1.065965187767672e-46, -1.5428574057942417e-48, -1.4893009037573437e-50, -9.565174650799353e-53, -4.0740046334259456e-55, -1.1451451185775492e-57, -2.1083224061025778e-60, -2.5105138600755755e-63, -1.8881766271929163e-66, -8.504678189793244e-70, -1.935648059573683e-73, 0., 1.2266312361188511e-80, 3.4153843725758773e-84, 4.80542049140078e-88, 4.049283603658539e-92, 2.1552918968401178e-96, 7.420226702863209e-101, 1.6734305110518255e-105, 2.4909156722694634e-110, 2.4591683869989134e-115, 1.6156278307526812e-120, 7.0802702967089e-126, 2.0733651428579665e-131, 4.062543998912848e-137, 5.3317141283221615e-143, 4.6907160749308386e-149, 2.76823462134183e-155, 1.0964623972756903e-161, 2.916130665305375e-168, 5.209622884570897e-175, 6.253601616771869e-182}, {-5.4520037915793325e-47, -1.0919683286535365e-45, -1.4289642494299153e-44, -1.2436844688367445e-43, -7.23681461353047e-43, -2.821735453651966e-42, -7.380974074603605e-42, -1.2960100003844262e-41, -1.5280752597017443e-41, -1.2100151632866806e-41, -6.435197769016311e-42, -2.298438494916709e-42, -5.5124408108402994e-43, -8.875690965745434e-44, -9.591362728571526e-45, -6.953646911367917e-46, -3.380554065489405e-47, -1.1013834667547557e-48, -2.4028405851952353e-50, -3.5068068869786854e-52, -3.419269400684914e-54, -2.2235085451560825e-56, -9.620703751719022e-59, -2.7605822544579477e-61, -5.2277119106822675e-64, -6.484343493048884e-67, -5.2020524917383196e-70, -2.6359824842616306e-73, -7.999259179267127e-77, -1.2266312361188511e-80, 0., 3.528604368176091e-88, 6.619626914433715e-92, 6.2752760391696925e-96, 3.56278372083726e-100, 1.2777012043319341e-104, 2.96383668733928e-109, 4.503606676566775e-114, 4.5167819051654014e-119, 3.0045346111231634e-124, 1.3299965935654612e-129, 3.9271781991916644e-135, 7.748708929509451e-141, 1.0229997992264057e-146, 9.04626485994337e-153, 5.362503003744672e-159, 2.1323484741966017e-165, 5.690845199954895e-172, 1.019808357870483e-178, 1.2275726182394625e-185}, {-7.843193440922351e-51, -1.5726383858374176e-49, -2.0604254310031874e-48, -1.7955605274045728e-47, -1.0462450952645597e-46, -4.0854999137870256e-46, -1.0703800803549217e-45, -1.8827269091410636e-45, -2.224054733919829e-45, -1.764776736766251e-45, -9.406905233592997e-46, -3.3682541452240367e-46, -8.10066377255798e-47, -1.3083421341719844e-47, -1.418746573885833e-48, -1.0326114339472273e-49, -5.042508986901214e-51, -1.6512727258844884e-52, -3.623953667323304e-54, -5.325936488084898e-56, -5.236264504825508e-58, -3.4394726855695705e-60, -1.5067976549992233e-62, -4.392261720421137e-65, -8.490905502561948e-68, -1.0832852505523874e-70, -9.052745571795963e-74, -4.893018166631568e-77, -1.6704619930944309e-80, -3.4153843725758773e-84, -3.528604368176091e-88, 0., 4.607858020022122e-96, 5.824211625762364e-100, 3.7200287313477593e-104, 1.4230326434223767e-108, 3.438496566428824e-113, 5.374143220340683e-118, 5.502154047654266e-123, 3.7180931012184984e-128, 1.6664358866539776e-133, 4.970310204408079e-139, 9.888635253895507e-145, 1.314646573180453e-150, 1.1694460387578318e-156, 6.967867708082356e-163, 2.783075752979186e-169, 7.456643928166988e-176, 1.3408819809550735e-182, 1.619055246500554e-189}, {-7.594207852287751e-55, -1.5242979386620196e-53, -1.9993126247923413e-52, -1.7443778608643926e-51, -1.0177198663750472e-50, -3.979570216025273e-50, -1.0441716740184956e-49, -1.839571391035188e-49, -2.176854624023983e-49, -1.730595122887613e-49, -9.243803501918e-50, -3.3173760276499973e-50, -7.998297453807044e-51, -1.295397258446518e-51, -1.409058290274214e-52, -1.0291209476938924e-53, -5.045171740912217e-55, -1.6595203451375967e-56, -3.660731446133883e-58, -5.412010610905876e-60, -5.358098427579552e-62, -3.548829217411956e-64, -1.5704097255995888e-66, -4.634909758119339e-69, -9.102202737245812e-72, -1.1854689126923814e-74, -1.0189716723763462e-77, -5.7370335706885945e-81, -2.089180124348935e-84, -4.80542049140078e-88, -6.619626914433715e-92, -4.607858020022122e-96, 0., 2.7315408593952558e-104, 2.326245709171123e-108, 1.0010981896419313e-112, 2.580234227628692e-117, 4.200766482473945e-122, 4.4237085448244335e-127, 3.0516088332295056e-132, 1.3894298891729717e-137, 4.195913765372308e-143, 8.432264539599635e-149, 1.1303709890005775e-154, 1.0125550194148316e-160, 6.0689807949501556e-167, 2.436477214209216e-173, 6.55715170326279e-180, 1.1837559254820538e-186, 1.4342954957548678e-193}, {-4.949429910954678e-59, -9.944116653773624e-58, -1.3056573258517743e-56, -1.1404385395582925e-55, -6.661565173049987e-55, -2.6081856515382145e-54, -6.852836751517066e-54, -1.2090883830353972e-53, -1.433066210136805e-53, -1.1412661690468488e-53, -6.107506284662005e-54, -2.1963732738251776e-54, -5.307560004569336e-55, -8.617621805644688e-56, -9.399789275353888e-57, -6.886492271204007e-58, -3.387762493542562e-59, -1.1187147573085057e-60, -2.47878669066785e-62, -3.683421215082886e-64, -3.6684352327927805e-66, -2.446705640994236e-68, -1.091726176830406e-70, -3.254669062706504e-73, -6.471531796168047e-76, -8.562294849093078e-79, -7.513061825314661e-82, -4.3508759351443383e-85, -1.650418035298741e-88, -4.049283603658539e-92, -6.2752760391696925e-96, -5.824211625762364e-100, -2.7315408593952558e-104, 0., 7.350783837556927e-113, 4.217872808657851e-117, 1.2230056341074765e-121, 2.1238634418011143e-126, 2.329771467186964e-131, 1.6530657814677833e-136, 7.683387778792796e-142, 2.3571221766324605e-147, 4.79617250083193e-153, 6.494360312866011e-159, 5.865946967832088e-165, 3.540476525991389e-171, 1.4298343729818132e-177, 3.8677649226256757e-184, 7.013608254875256e-191, 8.531349977881266e-198}, {-2.171394229317953e-63, -4.366646760993569e-62, -5.7389888701971994e-61, -5.017994864996857e-60, -2.934387244361258e-59, -1.1502608966537381e-58, -3.026094885392579e-58, -5.346460380031475e-58, -6.346254487198101e-58, -5.062133550533143e-58, -2.713721131056654e-58, -9.777530825039173e-59, -2.367642826725919e-59, -3.852961042788976e-60, -4.213203153449933e-61, -3.095259380377978e-62, -1.5274057720440953e-63, -5.061347942523451e-65, -1.1258635717459845e-66, -1.6804767053491392e-68, -1.682222461253826e-70, -1.1286563197484114e-72, -5.071310160889354e-75, -1.5244648286033926e-77, -3.061839828286788e-80, -4.1016688040668364e-83, -3.656173510746694e-86, -2.1614310070685174e-89, -8.433213495043204e-93, -2.1552918968401178e-96, -3.56278372083726e-100, -3.7200287313477593e-104, -2.326245709171123e-108, -7.350783837556927e-113, 0., 8.980104113418007e-122, 3.471803101961154e-126, 6.78274892176939e-131, 7.936357034897662e-136, 5.865793611034727e-141, 2.804295990380783e-146, 8.782295282547315e-152, 1.8153491258531982e-157, 2.4888388514650356e-163, 2.2707186939778283e-169, 1.3819459153351184e-175, 5.620067285523647e-182, 1.5293020658640615e-188, 2.787379935349259e-195, 3.4057041830476023e-202}, {-6.4129556665615056e-68, -1.2907521920377886e-66, -1.69796672817782e-65, -1.486101008582749e-64, -8.699367888035024e-64, -3.413889381759626e-63, -8.991918045062112e-63, -1.590707951140813e-62, -1.8907657709800299e-62, -1.5104166688590873e-62, -8.110055294434391e-63, -2.9271328347235193e-63, -7.101517704636269e-64, -1.1580513998017071e-64, -1.2692042904232577e-65, -9.347667909871613e-67, -4.6255710390572735e-68, -1.5375158782841783e-69, -3.431978338039439e-71, -5.142698362668446e-73, -5.171023157604262e-75, -3.487194997067244e-77, -1.5762028589940706e-79, -4.771289867917898e-82, -9.662844375340467e-85, -1.3075187098039037e-87, -1.180073756244396e-90, -7.087011806375677e-94, -2.822732454284743e-97, -7.420226702863209e-101, -1.2777012043319341e-104, -1.4230326434223767e-108, -1.0010981896419313e-112, -4.217872808657851e-117, -8.980104113418007e-122, 0., 4.98029333482714e-131, 1.2973116372032486e-135, 1.707702808148114e-140, 1.3463147288741488e-145, 6.704593271186493e-151, 2.1596883089587285e-156, 4.55719954476589e-162, 6.347081677098501e-168, 5.863213068418147e-174, 3.6043602647372035e-180, 1.4780284242079173e-186, 4.0500557443698284e-193, 7.425766997620637e-200, 9.11955257182306e-207}, {-1.2750786654293088e-72, -2.5684772237790533e-71, -3.3817217636574675e-70, -2.962483975454203e-69, -1.7358800061788865e-68, -6.8192027520910385e-68, -1.7981226686475422e-67, -3.184741138193314e-67, -3.790318612580043e-67, -3.0320119272982045e-67, -1.6304251801307867e-67, -5.894064955923896e-68, -1.4324461324644668e-68, -2.3403279020414844e-69, -2.570269347685116e-70, -1.8973012527192614e-71, -9.412076952453011e-73, -3.137216025138239e-74, -7.024442164486939e-76, -1.056242675272283e-77, -1.06622515802438e-79, -7.222427245266429e-82, -3.281259012867142e-84, -9.9917515714705e-87, -2.0376860174269332e-89, -2.7802529908118167e-92, -2.5346054367198017e-95, -1.5412014114779025e-98, -6.235989609932183e-102, -1.6734305110518255e-105, -2.96383668733928e-109, -3.438496566428824e-113, -2.580234227628692e-117, -1.2230056341074765e-121, -3.471803101961154e-126, -4.98029333482714e-131, 0., 1.25388595426268e-140, 2.2007198104001245e-145, 1.951873104512728e-150, 1.03682663017293e-155, 3.4789929658261036e-161, 7.55083491044553e-167, 1.073558857423068e-172, 1.0074578231214555e-178, 6.270676871163518e-185, 2.5973700016788263e-191, 7.176557342168326e-198, 1.3250215178853134e-204, 1.6369392691298278e-211}, {-1.7068530512158302e-77, -3.440880351939329e-76, -4.534050937759022e-75, -3.9753958692798316e-74, -2.3315410040351145e-73, -9.168140979992509e-73, -2.420021087651051e-72, -4.2909829584623244e-72, -5.11299160627461e-72, -4.0952891208107266e-72, -2.205213716819143e-72, -7.983763290057307e-73, -1.9434190756706026e-73, -3.1806765810095953e-74, -3.4997996813927574e-75, -2.5888034258683878e-76, -1.2871648261204545e-77, -4.3011066810391526e-79, -9.65722460124046e-81, -1.4566214099729116e-82, -1.4754933601932158e-84, -1.0033935255570005e-86, -4.578920804046163e-89, -1.4014761323002869e-91, -2.8751384769135223e-94, -3.9503199549165033e-97, -3.631302614606218e-100, -2.23036675861199e-103, -9.137287720688956e-107, -2.4909156722694634e-110, -4.503606676566775e-114, -5.374143220340683e-118, -4.200766482473945e-122, -2.1238634418011143e-126, -6.78274892176939e-131, -1.2973116372032486e-135, -1.25388595426268e-140, 0., 1.4331582641381217e-150, 1.6948049191673325e-155, 1.0128072504881814e-160, 3.624957613442342e-166, 8.195456021485476e-172, 1.1985011771020594e-177, 1.148138609817192e-183, 7.259743804168289e-190, 3.044638430394548e-196, 8.497337523497621e-203, 1.581953688136099e-209, 1.9680215791430328e-216}, {-1.5383502701412834e-82, -3.1034554482334747e-81, -4.092583707507628e-80, -3.591254879759704e-79, -2.1080686731890139e-78, -8.297016698249553e-78, -2.1922200957181742e-77, -3.891113944492641e-77, -4.6416784997203846e-77, -3.722213277088635e-77, -2.006881234495022e-77, -7.275700076239936e-78, -1.7736851102789699e-78, -2.907535311569505e-79, -3.2048175680700073e-80, -2.3750948038948693e-81, -1.1833528721954842e-82, -3.963202227363592e-84, -8.920833761963704e-86, -1.3492875236594972e-87, -1.3710003412928474e-89, -9.355714337204924e-92, -4.286161938714507e-94, -1.3177276200856505e-96, -2.7171910145500937e-99, -3.755528815055607e-102, -3.476383843952127e-105, -2.1530082232732895e-108, -8.909462633115895e-112, -2.4591683869989134e-115, -4.5167819051654014e-119, -5.502154047654266e-123, -4.4237085448244335e-127, -2.329771467186964e-131, -7.936357034897662e-136, -1.707702808148114e-140, -2.2007198104001245e-145, -1.4331582641381217e-150, 0., 7.436463315693555e-161, 5.925326176831556e-166, 2.3858378042605723e-171, 5.753602187003264e-177, 8.764637094352456e-183, 8.636231030832495e-189, 5.5745018953698464e-195, 2.3749798107400333e-201, 6.71122962341198e-208, 1.2620535996266236e-214, 1.5831352351631185e-221}, {-9.335386249039463e-88, -1.8846163585557016e-86, -2.4870949299646874e-85, -2.184118781436161e-84, -1.2831264269441633e-83, -5.054550142011807e-83, -1.3367299661915253e-82, -2.374968210734588e-82, -2.83603158483871e-82, -2.276774814367965e-82, -1.2290150652880295e-82, -4.461332817749546e-83, -1.0890868250122815e-83, -1.7879439706300438e-84, -1.9739113647751135e-85, -1.4654126057680004e-86, -7.315011147555152e-88, -2.4549643354730356e-89, -5.538476449961232e-91, -8.398011542579305e-93, -8.556856062076855e-95, -5.857281604595466e-97, -2.6927316934716985e-99, -8.310936048594792e-102, -1.7213887526579324e-104, -2.3913951812524475e-107, -2.2268214553352427e-110, -1.3887683722859446e-113, -5.794817510090362e-117, -1.6156278307526812e-120, -3.0045346111231634e-124, -3.7180931012184984e-128, -3.0516088332295056e-132, -1.6530657814677833e-136, -5.865793611034727e-141, -1.3463147288741488e-145, -1.951873104512728e-150, -1.6948049191673325e-155, -7.436463315693555e-161, 0., 1.7517730252569743e-171, 9.404706021605877e-177, 2.5515064002707918e-182, 4.145906403758746e-188, 4.255382209689977e-194, 2.8252367427908174e-200, 1.2287500344606781e-206, 3.52732229821431e-213, 6.716080254987489e-220, 8.509830260902711e-227}, {-3.814555688871636e-93, -7.705836578578521e-92, -1.0176303746966017e-90, -8.943166235665532e-90, -5.257989722645662e-89, -2.0729434910191934e-88, -5.486867691949208e-88, -9.757478190919108e-88, -1.1663131561392714e-87, -9.372950954465929e-88, -5.065196406791406e-88, -1.8408585390668472e-88, -4.499586429128948e-89, -7.397077144835925e-90, -8.178559424878113e-91, -6.081413261840664e-92, -3.040984627729581e-93, -1.0225067161409375e-94, -2.311583183021118e-96, -3.513027852745797e-98, -3.5884462718640915e-100, -2.4631622898215824e-102, -1.1358801039954859e-104, -3.517990853593109e-107, -7.315154639958896e-110, -1.020775881031332e-112, -9.554014745369512e-116, -5.993875948757177e-119, -2.518512736121277e-122, -7.0802702967089e-126, -1.3299965935654612e-129, -1.6664358866539776e-133, -1.3894298891729717e-137, -7.683387778792796e-142, -2.804295990380783e-146, -6.704593271186493e-151, -1.03682663017293e-155, -1.0128072504881814e-160, -5.925326176831556e-166, -1.7517730252569743e-171, 0., 1.8734023288202502e-182, 6.776746338532729e-188, 1.238786841507173e-193, 1.3562644783730889e-199, 9.379710330220927e-206, 4.19597198765609e-212, 1.2296146352037053e-218, 2.378368703938876e-225, 3.051260127177518e-232}, {-1.0495560927362647e-98, -2.1215465922650853e-97, -2.8035510354800974e-96, -2.465531584882391e-95, -1.4506289842144195e-94, -5.723468726082527e-94, -1.516180859199101e-93, -2.6986089777383013e-93, -3.228617009984421e-93, -2.597179841871683e-93, -1.4049928808156778e-93, -5.111884911893048e-94, -1.2509788269456774e-94, -2.0591681377926006e-95, -2.2798413389662465e-96, -1.6977559085236345e-97, -8.503160686960738e-99, -2.8640920340928783e-100, -6.487122154230613e-102, -9.879213556745713e-104, -1.0114237365046665e-105, -6.959961162139635e-108, -3.2184812456531646e-110, -9.99897964181654e-113, -2.086362866884231e-115, -2.9227826319602525e-118, -2.7478088947229565e-121, -1.7327257448355008e-124, -7.323921016832166e-128, -2.0733651428579665e-131, -3.9271781991916644e-135, -4.970310204408079e-139, -4.195913765372308e-143, -2.3571221766324605e-147, -8.782295282547315e-152, -2.1596883089587285e-156, -3.4789929658261036e-161, -3.624957613442342e-166, -2.3858378042605723e-171, -9.404706021605877e-177, -1.8734023288202502e-182, 0., 9.095542941064675e-194, 2.216882723928535e-199, 2.7305054342245104e-205, 2.0142659340380524e-211, 9.386176759640896e-218, 2.82917380535283e-224, 5.58630481244002e-231, 7.280548609338945e-238}, {-1.9446062629311973e-104, -3.9331147602823327e-103, -5.200726663732862e-102, -4.576692766913733e-101, -2.694625414458338e-100, -1.0639438677741283e-99, -2.8206269066891276e-99, -5.0244585351543294e-99, -6.016469037721827e-99, -4.844245710181293e-99, -2.623146743677361e-99, -9.55392186388231e-100, -2.340633380940669e-100, -3.8573758269200395e-101, -4.276210442642672e-102, -3.1887894545474515e-103, -1.599461916200045e-104, -5.396049372607929e-106, -1.224322018310357e-107, -1.8680466054770017e-109, -1.9164465273082523e-111, -1.321771226769531e-113, -6.127559765847722e-116, -1.9089605714398574e-118, -3.995522739044856e-121, -5.6167569979303135e-124, -5.3012151078878075e-127, -3.3577876693593936e-130, -1.4265549788411281e-133, -4.062543998912848e-137, -7.748708929509451e-141, -9.888635253895507e-145, -8.432264539599635e-149, -4.79617250083193e-153, -1.8153491258531982e-157, -4.55719954476589e-162, -7.55083491044553e-167, -8.195456021485476e-172, -5.753602187003264e-177, -2.5515064002707918e-182, -6.776746338532729e-188, -9.095542941064675e-194, 0., 2.004808530877595e-205, 3.2923952353180636e-211, 2.7323620806107597e-217, 1.3581223426528684e-223, 4.264209768582559e-230, 8.660401323130303e-237, 1.1522118494076436e-243}, {-2.426248806786311e-110, -4.910052632820763e-109, -6.496388504028107e-108, -5.720463755592277e-107, -3.3702607815089566e-106, -1.3316334106936314e-105, -3.532880620796998e-105, -6.2980748491037904e-105, -7.547704835990352e-105, -6.082403610213261e-105, -3.2966333120903183e-105, -1.201860506448949e-105, -2.9475279248542047e-106, -4.862944422230281e-107, -5.397381685271621e-108, -4.0299922137981296e-109, -2.0241766688045712e-110, -6.839011732161456e-112, -1.5542057868481856e-113, -2.375500945334283e-115, -2.4416643149681996e-117, -1.6874999725833925e-119, -7.84081035426082e-122, -2.448823294353579e-124, -5.139712152982487e-127, -7.247584934154573e-130, -6.864176790322201e-133, -4.36481708198163e-136, -1.8626696228064163e-139, -5.3317141283221615e-143, -1.0229997992264057e-146, -1.314646573180453e-150, -1.1303709890005775e-154, -6.494360312866011e-159, -2.4888388514650356e-163, -6.347081677098501e-168, -1.073558857423068e-172, -1.1985011771020594e-177, -8.764637094352456e-183, -4.145906403758746e-188, -1.238786841507173e-193, -2.216882723928535e-199, -2.004808530877595e-205, 0., 2.0061622942178302e-217, 2.2198881112329298e-223, 1.241321427119803e-229, 4.157312225748856e-236, 8.795101714441128e-243, 1.2035652563058965e-249}, {-2.0385858232446385e-116, -4.127759451885153e-115, -5.464450421770428e-114, -4.8146438938458536e-113, -2.8383631392475565e-112, -1.1222116183237062e-111, -2.9793388668337844e-111, -5.315157132792991e-111, -6.374680631571732e-111, -5.141305725262134e-111, -2.7889754227569937e-111, -1.0177171500432163e-111, -2.4983615069383235e-112, -4.12618610673614e-113, -4.584747845016127e-114, -3.4273088373968213e-115, -1.7236605786905524e-116, -5.831668546956486e-118, -1.3272444810692403e-119, -2.031856542619275e-121, -2.09208068016397e-123, -1.4486317410743137e-125, -6.744867195707547e-128, -2.1113285192584222e-130, -4.442467498243069e-133, -6.281790907099095e-136, -5.96789414628929e-139, -3.808062381972655e-142, -1.6314494534238657e-145, -4.6907160749308386e-149, -9.04626485994337e-153, -1.1694460387578318e-156, -1.0125550194148316e-160, -5.865946967832088e-165, -2.2707186939778283e-169, -5.863213068418147e-174, -1.0074578231214555e-178, -1.148138609817192e-183, -8.636231030832495e-189, -4.255382209689977e-194, -1.3562644783730889e-199, -2.7305054342245104e-205, -3.2923952353180636e-211, -2.0061622942178302e-217, 0., 9.114023768099124e-230, 6.795197129304628e-236, 2.5602535266410383e-242, 5.777499553254184e-249, 8.235642070519997e-256}, {-1.1535175943548262e-122, -2.3368650218213874e-121, -3.0952852719620936e-120, -2.7287555409873867e-119, -1.6096329348568174e-118, -6.368031030892662e-118, -1.69174903985606e-117, -3.0201812480901194e-117, -3.624872045951248e-117, -2.925788389890018e-117, -1.5884327786310325e-117, -5.801323667390631e-118, -1.4254574809978722e-118, -2.3565253877957398e-119, -2.6211442378321786e-120, -1.9616048366685165e-121, -9.877038388745735e-123, -3.34597063640557e-124, -7.625641257685105e-126, -1.1691262375729027e-127, -1.2057082204035756e-129, -8.363275984810158e-132, -3.901338056828847e-134, -1.2237542869903497e-136, -2.5807657368817472e-139, -3.6584312435508745e-142, -3.485276461956025e-145, -2.2308104177886353e-148, -9.590419129305008e-152, -2.76823462134183e-155, -5.362503003744672e-159, -6.967867708082356e-163, -6.0689807949501556e-167, -3.540476525991389e-171, -1.3819459153351184e-175, -3.6043602647372035e-180, -6.270676871163518e-185, -7.259743804168289e-190, -5.5745018953698464e-195, -2.8252367427908174e-200, -9.379710330220927e-206, -2.0142659340380524e-211, -2.7323620806107597e-217, -2.2198881112329298e-223, -9.114023768099124e-230, 0., 1.879780285511336e-242, 9.443364214871951e-249, 2.3973763129523394e-255, 3.64520935786903e-262}, {-4.395737938414113e-129, -8.909541881258331e-128, -1.1807197012239042e-126, -1.0414674557363282e-125, -6.146872301894435e-125, -2.4332735992088832e-124, -6.468345818930731e-124, -1.1555158975165716e-123, -1.3878306075257379e-123, -1.1209959490735467e-123, -6.090671894451826e-124, -2.226271523787289e-124, -5.474962544496652e-125, -9.05936989257138e-126, -1.0086514388392924e-126, -7.556381402216849e-128, -3.8090081879522536e-129, -1.2918854280639078e-130, -2.948034388685361e-132, -4.525991468209115e-134, -4.674524807260363e-136, -3.247634177649627e-138, -1.5176055201589499e-140, -4.76937300339939e-143, -1.0078917213928094e-145, -1.4320101758729655e-148, -1.36765178192016e-151, -8.778203962287105e-155, -3.785498504348653e-158, -1.0964623972756903e-161, -2.1323484741966017e-165, -2.783075752979186e-169, -2.436477214209216e-173, -1.4298343729818132e-177, -5.620067285523647e-182, -1.4780284242079173e-186, -2.5973700016788263e-191, -3.044638430394548e-196, -2.3749798107400333e-201, -1.2287500344606781e-206, -4.19597198765609e-212, -9.386176759640896e-218, -1.3581223426528684e-223, -1.241321427119803e-229, -6.795197129304628e-236, -1.879780285511336e-242, 0., 1.7601863632526912e-255, 5.958087248889677e-262, 1.019167691237222e-268}, {-1.1281368953314736e-135, -2.287654033937172e-134, -3.0331668505059233e-133, -2.6768225251331468e-132, -1.5807493429074224e-131, -6.261033558617789e-131, -1.6653547107175253e-130, -2.9768774957450584e-130, -3.5777263988934022e-130, -2.8918487159106403e-130, -1.5723675836749933e-130, -5.751779671007758e-131, -1.4156631698440918e-131, -2.344512881101973e-132, -2.612731177743747e-133, -1.9592588120826942e-134, -9.886486989097068e-136, -3.356888453233102e-137, -7.669413712128159e-139, -1.1789561490536538e-140, -1.2193195548924728e-142, -8.483793642559644e-145, -3.970793646908506e-147, -1.2500700453915956e-149, -2.646724192079793e-152, -3.768245107671495e-155, -3.607069319511292e-158, -2.320981698800254e-161, -1.0036766683615251e-164, -2.916130665305375e-168, -5.690845199954895e-172, -7.456643928166988e-176, -6.55715170326279e-180, -3.8677649226256757e-184, -1.5293020658640615e-188, -4.0500557443698284e-193, -7.176557342168326e-198, -8.497337523497621e-203, -6.71122962341198e-208, -3.52732229821431e-213, -1.2296146352037053e-218, -2.82917380535283e-224, -4.264209768582559e-230, -4.157312225748856e-236, -2.5602535266410383e-242, -9.443364214871951e-249, -1.7601863632526912e-255, 0., 7.482840993295216e-269, 1.706648338738382e-275}, {-1.949951049841699e-142, -3.9559298678741236e-141, -5.247589202302365e-140, -4.633376870673429e-139, -2.737571316395335e-138, -1.0848842584554421e-137, -2.8872899186325476e-137, -5.164199832662265e-137, -6.210416410293509e-137, -5.023134313233205e-137, -2.733091460338342e-137, -1.0005059500239209e-137, -2.464407948532974e-138, -4.084698081576568e-139, -4.555939159521496e-140, -3.4195895499801415e-141, -1.727223326356502e-142, -5.870776677476334e-144, -1.3427761948862753e-145, -2.066597165650512e-147, -2.140080042531026e-149, -1.4910723725698401e-151, -6.989222536065684e-154, -2.2038464201500375e-156, -4.674232423499529e-159, -6.667492104746811e-162, -6.395523300915309e-165, -4.124575198651852e-168, -1.78808612919657e-171, -5.209622884570897e-175, -1.019808357870483e-178, -1.3408819809550735e-182, -1.1837559254820538e-186, -7.013608254875256e-191, -2.787379935349259e-195, -7.425766997620637e-200, -1.3250215178853134e-204, -1.581953688136099e-209, -1.2620535996266236e-214, -6.716080254987489e-220, -2.378368703938876e-225, -5.58630481244002e-231, -8.660401323130303e-237, -8.795101714441128e-243, -5.777499553254184e-249, -2.3973763129523394e-255, -5.958087248889677e-262, -7.482840993295216e-269, 0., 1.444216350845024e-282}, {-2.2700027584793413e-149, -4.607225757400596e-148, -6.11430904151051e-147, -5.401202676359801e-146, -3.1928080442043677e-145, -1.2659459347200739e-144, -3.370987091901932e-144, -6.03275936980796e-144, -7.25925606362134e-144, -5.87513303461884e-144, -3.1987677256126215e-144, -1.1717880863152217e-144, -2.888413419577068e-145, -4.791174048370984e-146, -5.348285382939867e-147, -4.017783105891935e-148, -2.0312341338154142e-149, -6.910848534975539e-151, -1.5823101077731842e-152, -2.4379602263911855e-154, -2.527653351135875e-156, -1.7633581138358258e-158, -8.276882971456995e-161, -2.61373886506465e-163, -5.552474855187547e-166, -7.934022827621316e-169, -7.624805514526302e-172, -4.9275398136418177e-175, -2.1410423767398228e-178, -6.253601616771869e-182, -1.2275726182394625e-185, -1.619055246500554e-189, -1.4342954957548678e-193, -8.531349977881266e-198, -3.4057041830476023e-202, -9.11955257182306e-207, -1.6369392691298278e-211, -1.9680215791430328e-216, -1.5831352351631185e-221, -8.509830260902711e-227, -3.051260127177518e-232, -7.280548609338945e-238, -1.1522118494076436e-243, -1.2035652563058965e-249, -8.235642070519997e-256, -3.64520935786903e-262, -1.019167691237222e-268, -1.706648338738382e-275, -1.444216350845024e-282, 0.}}, {{0., 3.5540278339196867e-14, 1.4302634600932168e-12, 2.8740673804686744e-11, 3.4367100382980356e-10, 2.5853768755489773e-9, 1.2545692346110561e-8, 3.9799699657836855e-8, 8.320925924444965e-8, 1.1524728840009486e-7, 1.0612184099450583e-7, 6.513289386744738e-8, 2.6695381034710207e-8, 7.317027892949622e-9, 1.3427057312707262e-9, 1.6510462478650236e-10, 1.3613831606418344e-11, 7.531794152239072e-13, 2.797204282673435e-14, 6.976446505834777e-16, 1.168902420551675e-17, 1.3160848512406018e-19, 9.960041022670476e-22, 5.0676347806913596e-24, 1.7338025339028508e-26, 3.9894877959737254e-29, 6.174791501989365e-32, 6.429427309889768e-35, 4.504204314528205e-38, 2.1232702933240826e-41, 6.735578122140291e-45, 1.4380163546405535e-48, 2.066358043816054e-52, 1.998621222375895e-56, 1.301266464548992e-60, 5.703455505584824e-65, 1.682941731284336e-69, 3.3433398907435057e-74, 4.471898540877739e-79, 4.0273681154842707e-84, 2.4422231022358695e-89, 9.972392913620777e-95, 2.7420651587388835e-100, 5.077311383743186e-106, 6.331109823421824e-112, 5.316520135909183e-118, 3.0066815606565714e-124, 1.1451697119899252e-130, 2.937542617714927e-137, 5.075037730287332e-144}, {-3.5540278339196867e-14, 0., 2.1986661586637093e-11, 5.890133135746785e-10, 7.92312764080062e-9, 6.357555865168077e-8, 3.213504787848044e-7, 1.0485541732446444e-6, 2.237854284478636e-6, 3.1486602351236307e-6, 2.935562283090022e-6, 1.819905194777145e-6, 7.521183586873918e-7, 2.0759130473125759e-7, 3.832047972222223e-8, 4.736191496286326e-9, 3.9226859714730284e-10, 2.1787139106428618e-11, 8.119517969635306e-13, 2.0313365079884855e-14, 3.412948333209289e-16, 3.852313937456971e-18, 2.922026310787656e-20, 1.4897928826185403e-22, 5.106712214078032e-25, 1.1770990023206106e-27, 1.824790783651629e-30, 1.9028542922919435e-33, 1.3348948182772739e-36, 6.300690560318957e-40, 2.0011243808295448e-43, 4.2770615590646182e-47, 6.152322313366757e-51, 5.956457067811538e-55, 3.881704356788703e-59, 1.702824356400402e-63, 5.028694929940115e-68, 9.997737516693713e-73, 1.3382284633856966e-77, 1.2060360583704187e-82, 7.318291753100126e-88, 2.9901645423399912e-93, 8.226814794233813e-99, 1.5241715053065545e-104, 1.9015802575442798e-110, 1.597667850672679e-116, 9.039841803297324e-123, 3.4446760969903335e-129, 8.840141526715733e-136, 1.5279273911728875e-142}, {-1.4302634600932168e-12, -2.1986661586637093e-11, 0., 5.923778907677377e-9, 1.0624514135505442e-7, 9.590806164370045e-7, 5.170976826669477e-6, 0.0000175757259504774, 0.0000385823480371584, 0.000055416295137543934, 0.00005248587097803017, 0.00003294540898432712, 0.000013752990134021622, 3.827579525112979e-6, 7.114959864611292e-7, 8.846025615127679e-8, 7.364172281267052e-9, 4.1084225362522925e-10, 1.537109928689381e-11, 3.858885643577138e-13, 6.5035762389599324e-15, 7.361204693533581e-17, 5.597555903246032e-19, 2.8603957564331377e-21, 9.825164818866361e-24, 2.268993234926486e-26, 3.523610752276577e-29, 3.680237186324674e-32, 2.585593486560471e-35, 1.222073980597019e-38, 3.886312594970019e-42, 8.316217846517585e-46, 1.1975737095479153e-49, 1.1606555274302521e-53, 7.571154451044438e-58, 3.3243633712790615e-62, 9.825841951328109e-67, 1.9551085989606703e-71, 2.6189948904540252e-76, 2.3620116292577683e-81, 1.434274641666502e-86, 5.864126281389061e-92, 1.6144011785774215e-97, 2.992760858990673e-103, 3.735933226447947e-109, 3.140551255852238e-115, 1.7778888388774318e-121, 6.778079897720109e-128, 1.7402947173012293e-134, 3.0092824144772323e-141}, {-2.8740673804686744e-11, -5.890133135746785e-10, -5.923778907677377e-9, 0., 7.11565341454519e-7, 8.564451576523958e-6, 0.00005194808690698141, 0.0001883384373398549, 0.0004306685040244197, 0.0006362479579542611, 0.0006151572758140314, 0.00039226366732182503, 0.00016579649469595514, 0.00004660872696089376, 8.736140241805325e-6, 1.0937593782551458e-6, 9.15956734615183e-8, 5.136266896272485e-9, 1.9302426512694223e-10, 4.864841255561459e-12, 8.227433021341333e-14, 9.34121788112675e-16, 7.12291477979563e-18, 3.6489887925181133e-20, 1.2562386815118594e-22, 2.9071252906878926e-25, 4.523142021880468e-28, 4.732414166887428e-31, 3.3301409008506253e-34, 1.5763141890776862e-37, 5.019716226229531e-41, 1.0755276856496245e-44, 1.5506532723749235e-48, 1.5045222277111346e-52, 9.824478913387047e-57, 4.317976062486793e-61, 1.277439969425619e-65, 2.544002079666675e-70, 3.4106401337957943e-75, 3.078353652448518e-80, 1.8706224879617572e-85, 7.653463355274507e-91, 2.108394065427338e-96, 3.91096431543537e-102, 4.885054070996291e-108, 4.108870219209645e-114, 2.327319916701234e-120, 8.877333795427733e-127, 2.2804113161518763e-133, 3.9451055258483506e-140}, {-3.4367100382980356e-10, -7.92312764080062e-9, -1.0624514135505442e-7, -7.11565341454519e-7, 0., 0.000038401642870917254, 0.0003105693129178172, 0.0012667195345145911, 0.0030896788548853424, 0.004754724930993039, 0.004728458886966551, 0.003077984150646978, 0.0013216092322861789, 0.0003761750543592897, 0.00007122085022310057, 8.99111330922036e-6, 7.582162637365841e-7, 4.2770383212413964e-8, 1.6155817038266132e-9, 4.089970651882945e-11, 6.944095079129742e-13, 7.911524187275003e-15, 6.051414400601633e-17, 3.1086825592577527e-19, 1.0729095344646922e-21, 2.48851696099073e-24, 3.879853354691483e-27, 4.067050658951848e-30, 2.8669101628746014e-33, 1.3592197846135717e-36, 4.334799275194657e-40, 9.300527237105478e-44, 1.3426257596807215e-47, 1.304234227684657e-51, 8.52607851420223e-56, 3.7512169993101433e-60, 1.1108534825158254e-64, 2.2142809653433895e-69, 2.971166657636265e-74, 2.6838874352645714e-79, 1.6321766839818057e-84, 6.682767878944726e-90, 1.8422603987489483e-95, 3.419548052570483e-101, 4.273913730627065e-107, 3.596973450524247e-113, 2.0385302615101085e-119, 7.779981620704997e-126, 1.999556094234271e-132, 3.460935841302214e-139}, {-2.5853768755489773e-9, -6.357555865168077e-8, -9.590806164370045e-7, -8.564451576523958e-6, -0.000038401642870917254, 0., 0.0009345086412590431, 0.005082109110884219, 0.013945348760373543, 0.022891284360724178, 0.023713362878609413, 0.015877216454502314, 0.006959305359526851, 0.002012297770165625, 0.0003857486717628417, 0.000049189857187028904, 4.18272498830629e-6, 2.3759418712853105e-7, 9.028155253294651e-9, 2.2972684296376529e-10, 3.917795030320862e-12, 4.481114050354192e-14, 3.439442763757449e-16, 1.7723523147912706e-18, 6.133967717127298e-21, 1.4262842354880996e-23, 2.2287774289262068e-26, 2.3411497977687403e-29, 1.6534286340737826e-32, 7.852640154764089e-36, 2.5083632469464682e-39, 5.389791048259245e-43, 7.791399697194911e-47, 7.578275732816944e-51, 4.9599905242584876e-55, 2.1846734193334946e-59, 6.476245035639539e-64, 1.2921815659380087e-68, 1.7354688048663604e-73, 1.5690252976868658e-78, 9.549650756601022e-84, 3.9130187524262846e-89, 1.0795031651712137e-94, 2.00512973108649e-100, 2.50775522143456e-106, 2.111874677908843e-112, 1.1975854340810881e-118, 4.573136682635944e-125, 1.1759914037327195e-131, 2.0365190979504998e-138}, {-1.2545692346110561e-8, -3.213504787848044e-7, -5.170976826669477e-6, -0.00005194808690698141, -0.0003105693129178172, -0.0009345086412590431, 0., 0.01027525788444862, 0.03759385501176516, 0.0694240850542549, 0.0767117473691009, 0.05350222712581551, 0.024121140834208476, 0.007119984367872343, 0.0013865344291654523, 0.00017901804592589031, 0.00001537607068849298, 8.806959343249004e-7, 3.369889448206864e-8, 8.625927469451446e-10, 1.4786222217396298e-11, 1.698775602033129e-13, 1.3089947029866192e-15, 6.768699195265822e-18, 2.3498445396075072e-20, 5.479089927265776e-23, 8.583336582203113e-26, 9.03658957441778e-29, 6.395272295419507e-32, 3.0430636191591515e-35, 9.737341533280444e-39, 2.0956431426633832e-42, 3.033917793943232e-46, 2.954982252347829e-50, 1.936509453358642e-54, 8.539688100981347e-59, 2.5343207208442276e-63, 5.061905088877571e-68, 6.805054241504255e-73, 6.158057075996753e-78, 3.75125945439989e-83, 1.5383537478359807e-88, 4.2472070958019083e-94, 7.894767509841496e-100, 9.88058990173277e-106, 8.326289361422367e-112, 4.724560132697533e-118, 1.805208996909817e-124, 4.644764756020421e-131, 8.047908079853256e-138}, {-3.9799699657836855e-8, -1.0485541732446444e-6, -0.0000175757259504774, -0.0001883384373398549, -0.0012667195345145911, -0.005082109110884219, -0.01027525788444862, 0., 0.051111371429146554, 0.12584894335262006, 0.15644216102075434, 0.11638379525838233, 0.05465718568837704, 0.016594452113007117, 0.003298901730770743, 0.0004326881063100319, 0.00003762864190708755, 2.1770277955040572e-6, 8.399583669964836e-8, 2.1650820703741314e-9, 3.7333887383454634e-11, 4.3112525008980073e-13, 3.3368741933786323e-15, 1.7322355340348437e-17, 6.034568413906272e-20, 1.4114256327022323e-22, 2.2172283146605533e-25, 2.3401620192412297e-28, 1.6599168060766235e-31, 7.914738024857939e-35, 2.5373925766894085e-38, 5.470401862938907e-42, 7.932336650559203e-46, 7.737401411292519e-50, 5.0775711990386156e-54, 2.2419850389962658e-58, 6.661453264370476e-63, 1.3320000048690566e-67, 1.7925611279338477e-72, 1.6237172927441871e-77, 9.900173223633291e-83, 4.0634765171755733e-88, 1.1227928779810725e-93, 2.0886746199684224e-99, 2.6159634346727874e-105, 2.2059778987830983e-111, 1.2525545944326165e-117, 4.788883716178924e-124, 1.2329031356750313e-130, 2.1374428417508858e-137}, {-8.320925924444965e-8, -2.237854284478636e-6, -0.0000385823480371584, -0.0004306685040244197, -0.0030896788548853424, -0.013945348760373543, -0.03759385501176516, -0.051111371429146554, 0., 0.1151101749218074, 0.19079047245593134, 0.15967904068195693, 0.07998920658642848, 0.025297395361087566, 0.005172693255390101, 0.0006925914829706733, 0.00006118714052090573, 3.5842691929983916e-6, 1.3968803605661303e-7, 3.6306128352727145e-9, 6.304276357991199e-11, 7.323402635127177e-13, 5.6973217425368825e-15, 2.970792751858205e-17, 1.0389901075662162e-19, 2.4385325254952003e-22, 3.842584762145027e-25, 4.066901629744813e-28, 2.8919525237453204e-31, 1.3820612624835152e-34, 4.4399353442060794e-38, 9.590250731608866e-42, 1.393049364829495e-45, 1.3609931052857114e-49, 8.944575654982408e-54, 3.954873338434059e-58, 1.1765845866283976e-62, 2.3554565945909285e-67, 3.1734208539253357e-72, 2.8775061966040374e-77, 1.756195936773635e-82, 7.214843468556373e-88, 1.9952837147852583e-93, 3.714757508265507e-99, 4.656145916388496e-105, 3.929284006515782e-111, 2.2325941886067758e-117, 8.541478329100689e-124, 2.20038779715105e-130, 3.817009248826439e-137}, {-1.1524728840009486e-7, -3.1486602351236307e-6, -0.000055416295137543934, -0.0006362479579542611, -0.004754724930993039, -0.022891284360724178, -0.0694240850542549, -0.12584894335262006, -0.1151101749218074, 0., 0.11744343131944332, 0.13105654041026685, 0.07385751580598328, 0.024915398563935598, 0.005306858681638087, 0.0007308569826723152, 0.00006591287486776835, 3.922384288944418e-6, 1.5477605198862185e-7, 4.06339738875138e-9, 7.114571129012572e-11, 8.322481709491514e-13, 6.5131053978422665e-15, 3.413588572052321e-17, 1.1991809827635518e-19, 2.8255412867426124e-22, 4.467884279591968e-25, 4.743343930387144e-28, 3.3823364664713335e-31, 1.6204664317565092e-34, 5.21765432657118e-38, 1.1293455635882692e-41, 1.6435584159550263e-45, 1.6085301357050401e-49, 1.05883538415333e-53, 4.6886110472821934e-58, 1.3967894021708539e-62, 2.7998655873338057e-67, 3.776647561741983e-72, 3.4282925275208884e-77, 2.0945306849899188e-82, 8.613209193572713e-88, 2.3841947340032325e-93, 4.442663149469568e-99, 5.573065780747899e-105, 4.706696999576362e-111, 2.6762702170246763e-117, 1.0245993513655518e-123, 2.641227966567114e-130, 4.5845993715412325e-137}, {-1.0612184099450583e-7, -2.935562283090022e-6, -0.00005248587097803017, -0.0006151572758140314, -0.004728458886966551, -0.023713362878609413, -0.0767117473691009, -0.15644216102075434, -0.19079047245593134, -0.11744343131944332, 0., 0.05430523253113754, 0.04080528457371957, 0.015486100598850739, 0.0035183616941399536, 0.0005047358219943317, 0.00004682054219108874, 2.844272272764121e-6, 1.1401558397357468e-7, 3.0307127814392808e-9, 5.3600521411441205e-11, 6.32233148330201e-13, 4.982404393224043e-15, 2.6268753576325763e-17, 9.275439203755815e-20, 2.195259715614124e-22, 3.484864941367276e-25, 3.7125644848855937e-28, 2.6555145542004296e-31, 1.2757824341228957e-34, 4.118119816429961e-38, 8.933804366075978e-42, 1.3028456379977492e-45, 1.2774937086473912e-49, 8.423889339043299e-54, 3.736146017202473e-58, 1.1146884187915416e-62, 2.2374631400108982e-67, 3.0218956641749055e-72, 2.7464240227717533e-77, 1.6798065176259245e-82, 6.914960198473103e-88, 1.9159789649963563e-93, 3.573480217877421e-99, 4.486606857673669e-105, 3.79223077541833e-111, 2.1579615967118836e-117, 8.267708917886429e-124, 2.1327396873566773e-130, 3.70440942207713e-137}, {-6.513289386744738e-8, -1.819905194777145e-6, -0.00003294540898432712, -0.00039226366732182503, -0.003077984150646978, -0.015877216454502314, -0.05350222712581551, -0.11638379525838233, -0.15967904068195693, -0.13105654041026685, -0.05430523253113754, 0., 0.011383777207901546, 0.005760375431045889, 0.0014723183313626385, 0.00022529631468885098, 0.00002176983637554718, 1.3602675890078264e-6, 5.566372185735972e-8, 1.5031150747791808e-9, 2.6916060520816252e-11, 3.206893589765576e-13, 2.548299008372716e-15, 1.3529362477258217e-17, 4.8056238252776e-20, 1.1432011609260486e-22, 1.822876306337314e-25, 1.9495978595985557e-28, 1.3993458835968172e-31, 6.743657338440184e-35, 2.1828432785434839e-38, 4.747304742969104e-42, 6.938882756753605e-46, 6.81794646995704e-50, 4.5043198256753935e-54, 2.0012209765240682e-58, 5.980260771609943e-63, 1.2021687808593041e-67, 1.6258675777244976e-72, 1.4795430113047426e-77, 9.06016229867045e-83, 3.733784236919533e-88, 1.035624758705182e-93, 1.9334252809121435e-99, 2.4297019987154268e-105, 2.0554437837521155e-111, 1.1706019077188834e-117, 4.488341848527449e-124, 1.1586598296701966e-130, 2.0139001860703816e-137}, {-2.6695381034710207e-8, -7.521183586873918e-7, -0.000013752990134021622, -0.00016579649469595514, -0.0013216092322861789, -0.006959305359526851, -0.024121140834208476, -0.05465718568837704, -0.07998920658642848, -0.07385751580598328, -0.04080528457371957, -0.011383777207901546, 0., 0.001082095351403361, 0.0003687696727929404, 0.00006348338690717507, 6.543195394058331e-6, 4.258805849114514e-7, 1.792545504855022e-8, 4.94134322562411e-10, 8.988841266820321e-12, 1.084355774627159e-13, 8.703670427401737e-16, 4.659437699641231e-18, 1.66660393714019e-20, 3.9882530966317206e-23, 6.392028670668107e-26, 6.866905224638603e-29, 4.948127406408994e-32, 2.3928564660892032e-35, 7.769377035799054e-39, 1.6943980935884307e-42, 2.4828185873832776e-46, 2.445090502125588e-50, 1.6187090772080353e-54, 7.20537151618017e-59, 2.156930207156821e-63, 4.3428701457648485e-68, 5.882196008170251e-73, 5.360163848851106e-78, 3.2865538194436996e-83, 1.3560343744264768e-88, 3.7653618933103516e-94, 7.03693996901171e-100, 8.851844722726388e-106, 7.4952368963045445e-112, 4.272330463464914e-118, 1.6394425712337937e-124, 4.235468583496737e-131, 7.367171961735324e-138}, {-7.317027892949622e-9, -2.0759130473125759e-7, -3.827579525112979e-6, -0.00004660872696089376, -0.0003761750543592897, -0.002012297770165625, -0.007119984367872343, -0.016594452113007117, -0.025297395361087566, -0.024915398563935598, -0.015486100598850739, -0.005760375431045889, -0.001082095351403361, 0., 0.000046650855073763, 0.000010707873597697296, 1.2416110213281575e-6, 8.620098630112243e-8, 3.779404270004902e-9, 1.0715998336961659e-10, 1.9899683563354144e-12, 2.4386736195236888e-14, 1.9818891189127057e-16, 1.0717049341884538e-18, 3.8652558728981624e-21, 9.31440271309966e-24, 1.5017181752715806e-26, 1.6215570628649215e-29, 1.1736714924316971e-32, 5.6979956840634186e-36, 1.856508833582931e-39, 4.06133453793062e-43, 5.967645265207155e-47, 5.891692143461028e-51, 3.90930740516762e-55, 1.7437556561900969e-59, 5.2298242331337145e-64, 1.0548300247698749e-68, 1.4310030484628393e-73, 1.3059364850922628e-78, 8.018273900903959e-84, 3.312570563633962e-89, 9.20911449322261e-95, 1.72297038684296e-100, 2.1696011814100604e-106, 1.8388902426973246e-112, 1.0491419842525773e-118, 4.029410251424516e-125, 1.0418409281297147e-131, 1.8135769606391282e-138}, {-1.3427057312707262e-9, -3.832047972222223e-8, -7.114959864611292e-7, -8.736140241805325e-6, -0.00007122085022310057, -0.0003857486717628417, -0.0013865344291654523, -0.003298901730770743, -0.005172693255390101, -0.005306858681638087, -0.0035183616941399536, -0.0014723183313626385, -0.0003687696727929404, -0.000046650855073763, 0., 9.122899931623191e-7, 1.4104379048096736e-7, 1.1016234430542899e-8, 5.151966226245895e-10, 1.5216370085617034e-11, 2.906424540191814e-13, 3.63597931831951e-15, 3.001832821419543e-17, 1.643529147680181e-19, 5.987495975289856e-22, 1.454876473358094e-24, 2.3620332223769185e-27, 2.5657079728494892e-30, 1.866564507883634e-33, 9.102340201275478e-37, 2.977335338972387e-40, 6.535891765227337e-44, 9.6334439427934e-48, 9.537253404087617e-52, 6.344102542222447e-56, 2.8362330548051447e-60, 8.523964039196233e-65, 1.7224980873504303e-69, 2.3408385603562554e-74, 2.1396778307122917e-79, 1.3156796041349321e-84, 5.442902340601337e-90, 1.5150870174253154e-95, 2.838011998966572e-101, 3.577660618930924e-107, 3.035478735608757e-113, 1.733524469212059e-119, 6.664018296606538e-126, 1.7245347821565933e-132, 3.0044238749170557e-139}, {-1.6510462478650236e-10, -4.736191496286326e-9, -8.846025615127679e-8, -1.0937593782551458e-6, -8.99111330922036e-6, -0.000049189857187028904, -0.00017901804592589031, -0.0004326881063100319, -0.0006925914829706733, -0.0007308569826723152, -0.0005047358219943317, -0.00022529631468885098, -0.00006348338690717507, -0.000010707873597697296, -9.122899931623191e-7, 0., 8.093523033084223e-9, 8.42860190653444e-10, 4.434533116516733e-11, 1.3970587868963296e-12, 2.7796584639598064e-14, 3.576747204573162e-16, 3.014450706965722e-18, 1.6766349693473146e-20, 6.18445417258438e-23, 1.5179136541743395e-25, 2.4849123391075695e-28, 2.7180581843341956e-31, 1.9891702348520883e-34, 9.749974316664985e-38, 3.2034109842344053e-41, 7.059753618625842e-45, 1.0441709887418651e-48, 1.036945324816978e-52, 6.916835243990632e-57, 3.1000324999345456e-61, 9.337956673097222e-66, 1.890894179073198e-70, 2.574552124488524e-75, 2.357399851111207e-80, 1.4518790369879606e-85, 6.015251050581239e-91, 1.6767060885982736e-96, 3.1447627929149735e-102, 3.969076919203146e-108, 3.371323186930381e-114, 1.9273266361829013e-120, 7.416275438231021e-127, 1.9209701335589183e-133, 3.3495441683974286e-140}, {-1.3613831606418344e-11, -3.9226859714730284e-10, -7.364172281267052e-9, -9.15956734615183e-8, -7.582162637365841e-7, -4.18272498830629e-6, -0.00001537607068849298, -0.00003762864190708755, -0.00006118714052090573, -0.00006591287486776835, -0.00004682054219108874, -0.00002176983637554718, -6.543195394058331e-6, -1.2416110213281575e-6, -1.4104379048096736e-7, -8.093523033084223e-9, 0., 3.25774142614433e-11, 2.2853236158633453e-12, 8.099664099634362e-14, 1.718986589518092e-15, 2.3040827071906165e-17, 1.9973421223286823e-19, 1.1340641899195918e-21, 4.249520389325179e-24, 1.056040663116895e-26, 1.7462621930802655e-29, 1.9260220394722246e-32, 1.419387282914964e-35, 6.998578727816795e-39, 2.311215817703101e-42, 5.1162515022077895e-46, 7.596853439469541e-50, 7.570478636508746e-54, 5.065442610476033e-58, 2.2765695162612813e-62, 6.874697918175266e-67, 1.3952592259563555e-71, 1.903652168505571e-76, 1.7463886901272772e-81, 1.0774390997501343e-86, 4.471070134726071e-92, 1.248123583348032e-97, 2.344146173486941e-103, 2.962378949476091e-109, 2.5192321774078188e-115, 1.4418030784969545e-121, 5.553779468060602e-128, 1.439951004780057e-134, 2.5131117219818824e-141}, {-7.531794152239072e-13, -2.1787139106428618e-11, -4.1084225362522925e-10, -5.136266896272485e-9, -4.2770383212413964e-8, -2.3759418712853105e-7, -8.806959343249004e-7, -2.1770277955040572e-6, -3.5842691929983916e-6, -3.922384288944418e-6, -2.844272272764121e-6, -1.3602675890078264e-6, -4.258805849114514e-7, -8.620098630112243e-8, -1.1016234430542899e-8, -8.42860190653444e-10, -3.25774142614433e-11, 0., 5.949844989312928e-14, 2.8116657395220605e-15, 6.713077969797638e-17, 9.597894918816015e-19, 8.666807577411372e-21, 5.061494704318712e-23, 1.9361362209199044e-25, 4.887829611208971e-28, 8.18351533118875e-31, 9.117095556513016e-34, 6.7748594261643706e-37, 3.36384274953875e-40, 1.117490287261482e-43, 2.486432084246483e-47, 3.7084545754499946e-51, 3.710072008602612e-55, 2.4910460437959285e-59, 1.123020695750567e-63, 3.40067527799476e-68, 6.919162705155791e-73, 9.461764865345789e-78, 8.698085940360652e-83, 5.376470478918614e-88, 2.234964631807753e-93, 6.249023953139302e-99, 1.1753905984185261e-104, 1.4874222892774948e-110, 1.2665320015296425e-116, 7.257225719692461e-123, 2.7985697202018227e-129, 7.263523903859507e-136, 1.2689244737008472e-142}, {-2.797204282673435e-14, -8.119517969635306e-13, -1.537109928689381e-11, -1.9302426512694223e-10, -1.6155817038266132e-9, -9.028155253294651e-9, -3.369889448206864e-8, -8.399583669964836e-8, -1.3968803605661303e-7, -1.5477605198862185e-7, -1.1401558397357468e-7, -5.566372185735972e-8, -1.792545504855022e-8, -3.779404270004902e-9, -5.151966226245895e-10, -4.434533116516733e-11, -2.2853236158633453e-12, -5.949844989312928e-14, 0., 4.9309976406327023e-17, 1.5697537662535179e-18, 2.5248661247923053e-20, 2.4319253666787606e-22, 1.479444379076689e-24, 5.82090111399683e-27, 1.500117275617916e-29, 2.5514583265921625e-32, 2.8780618152431883e-35, 2.1602733326662582e-38, 1.0815540452946352e-41, 3.618118213124876e-45, 8.09828430135311e-49, 1.2140339778826495e-52, 1.2199856341280456e-56, 8.223447377163942e-61, 3.720191340113402e-65, 1.1300175013863932e-69, 2.3055696678277807e-74, 3.16070492756384e-79, 2.9122014223814794e-84, 1.8038200574689528e-89, 7.512566866884594e-95, 2.104187923806905e-100, 3.964149043910517e-106, 5.023946088581396e-112, 4.283738995907512e-118, 2.4577163910056336e-124, 9.488858610540347e-131, 2.4655171760324567e-137, 4.3117005436991156e-144}, {-6.976446505834777e-16, -2.0313365079884855e-14, -3.858885643577138e-13, -4.864841255561459e-12, -4.089970651882945e-11, -2.2972684296376529e-10, -8.625927469451446e-10, -2.1650820703741314e-9, -3.6306128352727145e-9, -4.06339738875138e-9, -3.0307127814392808e-9, -1.5031150747791808e-9, -4.94134322562411e-10, -1.0715998336961659e-10, -1.5216370085617034e-11, -1.3970587868963296e-12, -8.099664099634362e-14, -2.8116657395220605e-15, -4.9309976406327023e-17, 0., 1.854511710804423e-20, 3.9771790092625247e-22, 4.309625658429277e-24, 2.7965118967973425e-26, 1.146138279286264e-28, 3.038130782059582e-31, 5.2750256339746696e-34, 6.04471232569439e-37, 4.593875870324178e-40, 2.3231838660262915e-43, 7.836501723729927e-47, 1.7662775747750337e-50, 2.6636318574369985e-54, 2.6904166091091405e-58, 1.821600916651918e-62, 8.27302584046679e-67, 2.521677991894524e-71, 5.160897053957569e-76, 7.094725564158129e-81, 6.55330155307759e-86, 4.068345873796936e-91, 1.697896595170459e-96, 4.764629772804521e-102, 8.991854065288051e-108, 1.1414047437566234e-113, 9.746767976200634e-120, 5.599710059510029e-126, 2.1647216016717117e-132, 5.631353853437965e-139, 9.859075526125366e-146}, {-1.168902420551675e-17, -3.412948333209289e-16, -6.5035762389599324e-15, -8.227433021341333e-14, -6.944095079129742e-13, -3.917795030320862e-12, -1.4786222217396298e-11, -3.7333887383454634e-11, -6.304276357991199e-11, -7.114571129012572e-11, -5.3600521411441205e-11, -2.6916060520816252e-11, -8.988841266820321e-12, -1.9899683563354144e-12, -2.906424540191814e-13, -2.7796584639598064e-14, -1.718986589518092e-15, -6.713077969797638e-17, -1.5697537662535179e-18, -1.854511710804423e-20, 0., 3.1652781971587052e-24, 4.573145640087363e-26, 3.338448476072835e-28, 1.4594652130687999e-30, 4.029878590735548e-33, 7.196884420463073e-36, 8.41880467389078e-39, 6.49970247149261e-42, 3.32807293802885e-45, 1.133956230618866e-48, 2.577134812136894e-52, 3.9136216471178722e-56, 3.9765055721764186e-60, 2.7061804737358252e-64, 1.2345321390035838e-68, 3.777699709223551e-73, 7.758331918697946e-78, 1.0698459534511266e-82, 9.90947168995978e-88, 6.167303370813238e-93, 2.579732022607001e-98, 7.254220433517409e-104, 1.3716161418430306e-109, 1.744125169868896e-115, 1.4917430795112345e-121, 8.583054455375074e-128, 3.322572965909695e-134, 8.654452415944162e-141, 1.5169793888162502e-147}, {-1.3160848512406018e-19, -3.852313937456971e-18, -7.361204693533581e-17, -9.34121788112675e-16, -7.911524187275003e-15, -4.481114050354192e-14, -1.698775602033129e-13, -4.3112525008980073e-13, -7.323402635127177e-13, -8.322481709491514e-13, -6.32233148330201e-13, -3.206893589765576e-13, -1.084355774627159e-13, -2.4386736195236888e-14, -3.63597931831951e-15, -3.576747204573162e-16, -2.3040827071906165e-17, -9.597894918816015e-19, -2.5248661247923053e-20, -3.9771790092625247e-22, -3.1652781971587052e-24, 0., 2.451887839274748e-28, 2.38654145009092e-30, 1.1737364024884495e-32, 3.4569851347010735e-35, 6.431004965348899e-38, 7.737830403474894e-41, 6.098416654579044e-44, 3.172165781982228e-47, 1.0943452668452534e-50, 2.512233572946222e-54, 3.8468552018015865e-58, 3.93599965708628e-62, 2.6945586166441867e-66, 1.2355341109035742e-70, 3.7976441873033277e-75, 7.82987772288906e-80, 1.0834608609903522e-84, 1.0066649978030418e-89, 6.282528683665519e-95, 2.634516108821228e-100, 7.425110566373518e-106, 1.4068344515781717e-111, 1.792296293529948e-117, 1.535609632266051e-123, 8.849609176303736e-130, 3.43083375046976e-136, 8.948719393841445e-143, 1.5705626904463854e-149}, {-9.960041022670476e-22, -2.922026310787656e-20, -5.597555903246032e-19, -7.12291477979563e-18, -6.051414400601633e-17, -3.439442763757449e-16, -1.3089947029866192e-15, -3.3368741933786323e-15, -5.6973217425368825e-15, -6.5131053978422665e-15, -4.982404393224043e-15, -2.548299008372716e-15, -8.703670427401737e-16, -1.9818891189127057e-16, -3.001832821419543e-17, -3.014450706965722e-18, -1.9973421223286823e-19, -8.666807577411372e-21, -2.4319253666787606e-22, -4.309625658429277e-24, -4.573145640087363e-26, -2.451887839274748e-28, 0., 8.620096676784965e-33, 5.652654814006698e-35, 1.8729747646031755e-37, 3.71656713714013e-40, 4.658124706219992e-43, 3.77609971132919e-46, 2.0051048139247667e-49, 7.027081523816719e-53, 1.6333365293423e-56, 2.526308043714321e-60, 2.6063914455820568e-64, 1.7967956182605937e-68, 8.287875283745978e-73, 2.560496574224496e-77, 5.302728683185345e-82, 7.3664363264253845e-87, 6.868067188084696e-92, 4.299584957375947e-97, 1.807996620049075e-102, 5.108422117187824e-108, 9.700916345924519e-114, 1.238448073804529e-119, 1.0630913206044089e-125, 6.137174544582207e-132, 2.383084736241949e-138, 6.225061185384278e-145, 1.094042415462331e-151}, {-5.0676347806913596e-24, -1.4897928826185403e-22, -2.8603957564331377e-21, -3.6489887925181133e-20, -3.1086825592577527e-19, -1.7723523147912706e-18, -6.768699195265822e-18, -1.7322355340348437e-17, -2.970792751858205e-17, -3.413588572052321e-17, -2.6268753576325763e-17, -1.3529362477258217e-17, -4.659437699641231e-18, -1.0717049341884538e-18, -1.643529147680181e-19, -1.6766349693473146e-20, -1.1340641899195918e-21, -5.061494704318712e-23, -1.479444379076689e-24, -2.7965118967973425e-26, -3.338448476072835e-28, -2.38654145009092e-30, -8.620096676784965e-33, 0., 1.3755008284425956e-37, 6.076857512402822e-40, 1.3565681996266817e-42, 1.813591553906459e-45, 1.5314421430041683e-48, 8.364282190278818e-52, 2.9924123013468655e-55, 7.065803231804261e-59, 1.1065402113632447e-62, 1.1531487771857763e-66, 8.015830133683089e-71, 3.7232267594629185e-75, 1.1571186731703231e-79, 2.408654838340357e-84, 3.3609890849076206e-89, 3.1458932585013103e-94, 1.9762475177540102e-99, 8.335946233647194e-105, 2.3618307259711982e-110, 4.496367984694934e-116, 5.753244120538041e-122, 4.948844452116849e-128, 2.862354737243639e-134, 1.1133945840790513e-140, 2.9130549134543667e-147, 5.1272220925503795e-154}, {-1.7338025339028508e-26, -5.106712214078032e-25, -9.825164818866361e-24, -1.2562386815118594e-22, -1.0729095344646922e-21, -6.133967717127298e-21, -2.3498445396075072e-20, -6.034568413906272e-20, -1.0389901075662162e-19, -1.1991809827635518e-19, -9.275439203755815e-20, -4.8056238252776e-20, -1.66660393714019e-20, -3.8652558728981624e-21, -5.987495975289856e-22, -6.18445417258438e-23, -4.249520389325179e-24, -1.9361362209199044e-25, -5.82090111399683e-27, -1.146138279286264e-28, -1.4594652130687999e-30, -1.1737364024884495e-32, -5.652654814006698e-35, -1.3755008284425956e-37, 0., 9.962294844101513e-43, 2.9652458480346465e-45, 4.459755823609323e-48, 4.0169915148812166e-51, 2.2853765335332743e-54, 8.409786589378997e-58, 2.0271221792422907e-61, 3.224965043734324e-65, 3.402813801243025e-69, 2.3892750802083278e-73, 1.119028789163515e-77, 3.502080536211548e-82, 7.333312963324064e-87, 1.0285234833660842e-91, 9.669980369776633e-97, 6.098495841965131e-102, 2.581318859202945e-107, 7.336315595896947e-113, 1.4005408658899994e-118, 1.7965273638761928e-124, 1.5488549600575123e-130, 8.976946436512147e-137, 3.498452905702786e-143, 9.16917449857383e-150, 1.6164382695688697e-156}, {-3.9894877959737254e-29, -1.1770990023206106e-27, -2.268993234926486e-26, -2.9071252906878926e-25, -2.48851696099073e-24, -1.4262842354880996e-23, -5.479089927265776e-23, -1.4114256327022323e-22, -2.4385325254952003e-22, -2.8255412867426124e-22, -2.195259715614124e-22, -1.1432011609260486e-22, -3.9882530966317206e-23, -9.31440271309966e-24, -1.454876473358094e-24, -1.5179136541743395e-25, -1.056040663116895e-26, -4.887829611208971e-28, -1.500117275617916e-29, -3.038130782059582e-31, -4.029878590735548e-33, -3.4569851347010735e-35, -1.8729747646031755e-37, -6.076857512402822e-40, -9.962294844101513e-43, 0., 3.2750573709492005e-48, 6.567620103597193e-51, 6.655035540428354e-54, 4.038647529480681e-57, 1.5480747617104838e-60, 3.8381446406691724e-64, 6.2333464535286494e-68, 6.681498334215948e-72, 4.750035597259582e-76, 2.2471743856390675e-80, 7.091298545288828e-85, 1.4952930503172653e-89, 2.1096855584564616e-94, 1.9936575899160277e-99, 1.2629385206901729e-104, 5.36662089211201e-110, 1.5305327370931156e-115, 2.9309127554393898e-121, 3.770037266637204e-127, 3.2584394353031166e-133, 1.892838013031506e-139, 7.391950980428294e-146, 1.9410424506635607e-152, 3.427824340451841e-159}, {-6.174791501989365e-32, -1.824790783651629e-30, -3.523610752276577e-29, -4.523142021880468e-28, -3.879853354691483e-27, -2.2287774289262068e-26, -8.583336582203113e-26, -2.2172283146605533e-25, -3.842584762145027e-25, -4.467884279591968e-25, -3.484864941367276e-25, -1.822876306337314e-25, -6.392028670668107e-26, -1.5017181752715806e-26, -2.3620332223769185e-27, -2.4849123391075695e-28, -1.7462621930802655e-29, -8.18351533118875e-31, -2.5514583265921625e-32, -5.2750256339746696e-34, -7.196884420463073e-36, -6.431004965348899e-38, -3.71656713714013e-40, -1.3565681996266817e-42, -2.9652458480346465e-45, -3.2750573709492005e-48, 0., 4.8870788679756346e-54, 6.602834926955344e-57, 4.5078404395794743e-60, 1.8431184105445904e-63, 4.7600488634065384e-67, 7.951440182320898e-71, 8.70068082514913e-75, 6.28370317089707e-79, 3.0098898692474487e-83, 9.594103612054341e-88, 2.039900919867259e-92, 2.8981906003200953e-97, 2.7550989858820014e-102, 1.7542452379244705e-107, 7.487615131291663e-113, 2.143803642205789e-118, 4.119558050723356e-124, 5.3153989613070695e-130, 4.606855373141949e-136, 2.6828443058727265e-142, 1.050091182961125e-148, 2.763129236846047e-155, 4.888847298837683e-162}, {-6.429427309889768e-35, -1.9028542922919435e-33, -3.680237186324674e-32, -4.732414166887428e-31, -4.067050658951848e-30, -2.3411497977687403e-29, -9.03658957441778e-29, -2.3401620192412297e-28, -4.066901629744813e-28, -4.743343930387144e-28, -3.7125644848855937e-28, -1.9495978595985557e-28, -6.866905224638603e-29, -1.6215570628649215e-29, -2.5657079728494892e-30, -2.7180581843341956e-31, -1.9260220394722246e-32, -9.117095556513016e-34, -2.8780618152431883e-35, -6.04471232569439e-37, -8.41880467389078e-39, -7.737830403474894e-41, -4.658124706219992e-43, -1.813591553906459e-45, -4.459755823609323e-48, -6.567620103597193e-51, -4.8870788679756346e-54, 0., 3.3102405923989427e-60, 3.0132585113778737e-63, 1.3860331463706267e-66, 3.8182161798714526e-70, 6.6439088539826465e-74, 7.477657400417714e-78, 5.51293447280553e-82, 2.6826078956973876e-86, 8.657769705914245e-91, 1.859411464680793e-95, 2.663774753168452e-100, 2.5499649818349865e-105, 1.633295398933642e-110, 7.007117589314581e-116, 2.0151872028458943e-121, 3.887593113273674e-127, 5.033515371634184e-133, 4.376053251247241e-139, 2.5555135669754753e-145, 1.0027596004883217e-151, 2.644581331335733e-158, 4.688786230776131e-165}, {-4.504204314528205e-38, -1.3348948182772739e-36, -2.585593486560471e-35, -3.3301409008506253e-34, -2.8669101628746014e-33, -1.6534286340737826e-32, -6.395272295419507e-32, -1.6599168060766235e-31, -2.8919525237453204e-31, -3.3823364664713335e-31, -2.6555145542004296e-31, -1.3993458835968172e-31, -4.948127406408994e-32, -1.1736714924316971e-32, -1.866564507883634e-33, -1.9891702348520883e-34, -1.419387282914964e-35, -6.7748594261643706e-37, -2.1602733326662582e-38, -4.593875870324178e-40, -6.49970247149261e-42, -6.098416654579044e-44, -3.77609971132919e-46, -1.5314421430041683e-48, -4.0169915148812166e-51, -6.655035540428354e-54, -6.602834926955344e-57, -3.3102405923989427e-60, 0., 1.0177883905888752e-66, 6.242139265607756e-70, 1.9345184387389754e-73, 3.5905811727369234e-77, 4.20954749496197e-81, 3.1921782728726886e-85, 1.585682919091838e-89, 5.198817875834115e-94, 1.1304962089649121e-98, 1.6358968259060488e-103, 1.5790531632295752e-108, 1.0184828698244792e-113, 4.395475045207382e-119, 1.2705836710415395e-124, 2.4620857638932114e-130, 3.20032111557831e-136, 2.791965908198669e-142, 1.6354911242221204e-148, 6.435340494491928e-155, 1.7014481747682325e-161, 3.023487263070129e-168}, {-2.1232702933240826e-41, -6.300690560318957e-40, -1.222073980597019e-38, -1.5763141890776862e-37, -1.3592197846135717e-36, -7.852640154764089e-36, -3.0430636191591515e-35, -7.914738024857939e-35, -1.3820612624835152e-34, -1.6204664317565092e-34, -1.2757824341228957e-34, -6.743657338440184e-35, -2.3928564660892032e-35, -5.6979956840634186e-36, -9.102340201275478e-37, -9.749974316664985e-38, -6.998578727816795e-39, -3.36384274953875e-40, -1.0815540452946352e-41, -2.3231838660262915e-43, -3.32807293802885e-45, -3.172165781982228e-47, -2.0051048139247667e-49, -8.364282190278818e-52, -2.2853765335332743e-54, -4.038647529480681e-57, -4.5078404395794743e-60, -3.0132585113778737e-63, -1.0177883905888752e-66, 0., 1.420529622113322e-73, 5.869869564096356e-77, 1.2256680040553179e-80, 1.5327532200976478e-84, 1.2107451208451198e-88, 6.186092286642923e-93, 2.070424951626303e-97, 4.573655235635848e-102, 6.701086986161631e-107, 6.533575336083e-112, 4.249247272189718e-117, 1.8466753358234404e-122, 5.369890410218303e-128, 1.045891876777836e-133, 1.3655627756902246e-139, 1.1959912671390558e-145, 7.03026092794889e-152, 2.7748356842848998e-158, 7.356803680309802e-165, 1.3105864715131537e-171}, {-6.735578122140291e-45, -2.0011243808295448e-43, -3.886312594970019e-42, -5.019716226229531e-41, -4.334799275194657e-40, -2.5083632469464682e-39, -9.737341533280444e-39, -2.5373925766894085e-38, -4.4399353442060794e-38, -5.21765432657118e-38, -4.118119816429961e-38, -2.1828432785434839e-38, -7.769377035799054e-39, -1.856508833582931e-39, -2.977335338972387e-40, -3.2034109842344053e-41, -2.311215817703101e-42, -1.117490287261482e-43, -3.618118213124876e-45, -7.836501723729927e-47, -1.133956230618866e-48, -1.0943452668452534e-50, -7.027081523816719e-53, -2.9924123013468655e-55, -8.409786589378997e-58, -1.5480747617104838e-60, -1.8431184105445904e-63, -1.3860331463706267e-66, -6.242139265607756e-70, -1.420529622113322e-73, 0., 9.000039602741524e-81, 2.5056912436995435e-84, 3.525165133094084e-88, 2.970220422772795e-92, 1.580815239533951e-96, 5.442001643623882e-101, 1.2272059225664395e-105, 1.8265800014293096e-110, 1.8031812297405013e-115, 1.1845824236637031e-120, 5.1909632379861165e-126, 1.520019927895152e-131, 2.978160312938469e-137, 3.9083586663166685e-143, 3.4383117411873848e-149, 2.029030011558681e-155, 8.036364980485525e-162, 2.1372436545630645e-168, 3.817994085474685e-175}, {-1.4380163546405535e-48, -4.2770615590646182e-47, -8.316217846517585e-46, -1.0755276856496245e-44, -9.300527237105478e-44, -5.389791048259245e-43, -2.0956431426633832e-42, -5.470401862938907e-42, -9.590250731608866e-42, -1.1293455635882692e-41, -8.933804366075978e-42, -4.747304742969104e-42, -1.6943980935884307e-42, -4.06133453793062e-43, -6.535891765227337e-44, -7.059753618625842e-45, -5.1162515022077895e-46, -2.486432084246483e-47, -8.09828430135311e-49, -1.7662775747750337e-50, -2.577134812136894e-52, -2.512233572946222e-54, -1.6333365293423e-56, -7.065803231804261e-59, -2.0271221792422907e-61, -3.8381446406691724e-64, -4.7600488634065384e-67, -3.8182161798714526e-70, -1.9345184387389754e-73, -5.869869564096356e-77, -9.000039602741524e-81, 0., 2.5884854035168727e-88, 4.8555269342380344e-92, 4.602545642189867e-96, 2.612878778886819e-100, 9.369697786891656e-105, 2.1732956643014476e-109, 3.3021356669151695e-114, 3.311578208964731e-119, 2.2027030573407953e-124, 9.749973353301828e-130, 2.8787826825133217e-135, 5.679814163063869e-141, 7.49821499948493e-147, 6.630254326322735e-153, 3.93013897469177e-159, 1.5627117386142343e-165, 4.170408655699905e-172, 7.473126196410442e-179}, {-2.066358043816054e-52, -6.152322313366757e-51, -1.1975737095479153e-49, -1.5506532723749235e-48, -1.3426257596807215e-47, -7.791399697194911e-47, -3.033917793943232e-46, -7.932336650559203e-46, -1.393049364829495e-45, -1.6435584159550263e-45, -1.3028456379977492e-45, -6.938882756753605e-46, -2.4828185873832776e-46, -5.967645265207155e-47, -9.6334439427934e-48, -1.0441709887418651e-48, -7.596853439469541e-50, -3.7084545754499946e-51, -1.2140339778826495e-52, -2.6636318574369985e-54, -3.9136216471178722e-56, -3.8468552018015865e-58, -2.526308043714321e-60, -1.1065402113632447e-62, -3.224965043734324e-65, -6.2333464535286494e-68, -7.951440182320898e-71, -6.6439088539826465e-74, -3.5905811727369234e-77, -1.2256680040553179e-80, -2.5056912436995435e-84, -2.5884854035168727e-88, 0., 3.3795549407808936e-96, 4.271299099191253e-100, 2.7279327783919164e-104, 1.0434429507876322e-108, 2.521103682306538e-113, 3.9400457226449578e-118, 4.033631392960115e-123, 2.7255651737195554e-128, 1.2215157678421441e-133, 3.643085262288603e-139, 7.247674902306376e-145, 9.634937945689882e-151, 8.570351681357137e-157, 5.1062000280424045e-163, 2.039404109267447e-169, 5.463900898994429e-176, 9.824984447567098e-183}, {-1.998621222375895e-56, -5.956457067811538e-55, -1.1606555274302521e-53, -1.5045222277111346e-52, -1.304234227684657e-51, -7.578275732816944e-51, -2.954982252347829e-50, -7.737401411292519e-50, -1.3609931052857114e-49, -1.6085301357050401e-49, -1.2774937086473912e-49, -6.81794646995704e-50, -2.445090502125588e-50, -5.891692143461028e-51, -9.537253404087617e-52, -1.036945324816978e-52, -7.570478636508746e-54, -3.710072008602612e-55, -1.2199856341280456e-56, -2.6904166091091405e-58, -3.9765055721764186e-60, -3.93599965708628e-62, -2.6063914455820568e-64, -1.1531487771857763e-66, -3.402813801243025e-69, -6.681498334215948e-72, -8.70068082514913e-75, -7.477657400417714e-78, -4.20954749496197e-81, -1.5327532200976478e-84, -3.525165133094084e-88, -4.8555269342380344e-92, -3.3795549407808936e-96, 0., 2.003044694798353e-104, 1.7057015996402814e-108, 7.339908134608208e-113, 1.8916524415110603e-117, 3.079503252886711e-122, 3.242724630400687e-127, 2.2367903267450143e-132, 1.0183737740646206e-137, 3.07519384340762e-143, 6.179689736521847e-149, 8.283636109104615e-155, 7.41988524697459e-161, 4.44706822076416e-167, 1.78525689146837e-173, 4.804351141687935e-180, 8.672884932235808e-187}, {-1.301266464548992e-60, -3.881704356788703e-59, -7.571154451044438e-58, -9.824478913387047e-57, -8.52607851420223e-56, -4.9599905242584876e-55, -1.936509453358642e-54, -5.0775711990386156e-54, -8.944575654982408e-54, -1.05883538415333e-53, -8.423889339043299e-54, -4.5043198256753935e-54, -1.6187090772080353e-54, -3.90930740516762e-55, -6.344102542222447e-56, -6.916835243990632e-57, -5.065442610476033e-58, -2.4910460437959285e-59, -8.223447377163942e-61, -1.821600916651918e-62, -2.7061804737358252e-64, -2.6945586166441867e-66, -1.7967956182605937e-68, -8.015830133683089e-71, -2.3892750802083278e-73, -4.750035597259582e-76, -6.28370317089707e-79, -5.51293447280553e-82, -3.1921782728726886e-85, -1.2107451208451198e-88, -2.970220422772795e-92, -4.602545642189867e-96, -4.271299099191253e-100, -2.003044694798353e-104, 0., 5.389438723216304e-113, 3.0922161401775693e-117, 8.965470503131735e-122, 1.5568297838616875e-126, 1.7076517267629915e-131, 1.2115712624614032e-136, 5.631002717102583e-142, 1.7273902002348554e-147, 3.5146303730321025e-153, 4.758814813143735e-159, 4.298125628414874e-165, 2.5940728179482614e-171, 1.0475783447147206e-177, 2.833622522154542e-184, 5.138132957903699e-191}, {-5.703455505584824e-65, -1.702824356400402e-63, -3.3243633712790615e-62, -4.317976062486793e-61, -3.7512169993101433e-60, -2.1846734193334946e-59, -8.539688100981347e-59, -2.2419850389962658e-58, -3.954873338434059e-58, -4.6886110472821934e-58, -3.736146017202473e-58, -2.0012209765240682e-58, -7.20537151618017e-59, -1.7437556561900969e-59, -2.8362330548051447e-60, -3.1000324999345456e-61, -2.2765695162612813e-62, -1.123020695750567e-63, -3.720191340113402e-65, -8.27302584046679e-67, -1.2345321390035838e-68, -1.2355341109035742e-70, -8.287875283745978e-73, -3.7232267594629185e-75, -1.119028789163515e-77, -2.2471743856390675e-80, -3.0098898692474487e-83, -2.6826078956973876e-86, -1.585682919091838e-89, -6.186092286642923e-93, -1.580815239533951e-96, -2.612878778886819e-100, -2.7279327783919164e-104, -1.7057015996402814e-108, -5.389438723216304e-113, 0., 6.582975944609853e-122, 2.5448620656397035e-126, 4.971469919511412e-131, 5.81663362686243e-136, 4.298828690279287e-141, 2.0550451521019313e-146, 6.435479712386386e-152, 1.3301773744724566e-157, 1.823575443479922e-163, 1.6636763429739613e-169, 1.0124556846120606e-175, 4.117246101862945e-182, 1.1203139232734382e-188, 2.0418532978833183e-195}, {-1.682941731284336e-69, -5.028694929940115e-68, -9.825841951328109e-67, -1.277439969425619e-65, -1.1108534825158254e-64, -6.476245035639539e-64, -2.5343207208442276e-63, -6.661453264370476e-63, -1.1765845866283976e-62, -1.3967894021708539e-62, -1.1146884187915416e-62, -5.980260771609943e-63, -2.156930207156821e-63, -5.2298242331337145e-64, -8.523964039196233e-65, -9.337956673097222e-66, -6.874697918175266e-67, -3.40067527799476e-68, -1.1300175013863932e-69, -2.521677991894524e-71, -3.777699709223551e-73, -3.7976441873033277e-75, -2.560496574224496e-77, -1.1571186731703231e-79, -3.502080536211548e-82, -7.091298545288828e-85, -9.594103612054341e-88, -8.657769705914245e-91, -5.198817875834115e-94, -2.070424951626303e-97, -5.442001643623882e-101, -9.369697786891656e-105, -1.0434429507876322e-108, -7.339908134608208e-113, -3.0922161401775693e-117, -6.582975944609853e-122, 0., 3.6503168316943536e-131, 9.508015160155222e-136, 1.2514954691619834e-140, 9.86589375452224e-146, 4.912883105332397e-151, 1.5824516316674976e-156, 3.338980771604889e-162, 4.650155988203958e-168, 4.2954400203617315e-174, 2.640460326842203e-180, 1.0827160499619191e-186, 2.966702077489795e-193, 5.439214188952624e-200}, {-3.3433398907435057e-74, -9.997737516693713e-73, -1.9551085989606703e-71, -2.544002079666675e-70, -2.2142809653433895e-69, -1.2921815659380087e-68, -5.061905088877571e-68, -1.3320000048690566e-67, -2.3554565945909285e-67, -2.7998655873338057e-67, -2.2374631400108982e-67, -1.2021687808593041e-67, -4.3428701457648485e-68, -1.0548300247698749e-68, -1.7224980873504303e-69, -1.890894179073198e-70, -1.3952592259563555e-71, -6.919162705155791e-73, -2.3055696678277807e-74, -5.160897053957569e-76, -7.758331918697946e-78, -7.82987772288906e-80, -5.302728683185345e-82, -2.408654838340357e-84, -7.333312963324064e-87, -1.4952930503172653e-89, -2.039900919867259e-92, -1.859411464680793e-95, -1.1304962089649121e-98, -4.573655235635848e-102, -1.2272059225664395e-105, -2.1732956643014476e-109, -2.521103682306538e-113, -1.8916524415110603e-117, -8.965470503131735e-122, -2.5448620656397035e-126, -3.6503168316943536e-131, 0., 9.1890762263906e-141, 1.6126867096727384e-145, 1.430242509472857e-150, 7.596934853100751e-156, 2.548949215132759e-161, 5.531961038629751e-167, 7.864797748087704e-173, 7.38018283323316e-179, 4.593398669790387e-185, 1.9025403394448376e-191, 5.2565083562017976e-198, 9.704787696317928e-205}, {-4.471898540877739e-79, -1.3382284633856966e-77, -2.6189948904540252e-76, -3.4106401337957943e-75, -2.971166657636265e-74, -1.7354688048663604e-73, -6.805054241504255e-73, -1.7925611279338477e-72, -3.1734208539253357e-72, -3.776647561741983e-72, -3.0218956641749055e-72, -1.6258675777244976e-72, -5.882196008170251e-73, -1.4310030484628393e-73, -2.3408385603562554e-74, -2.574552124488524e-75, -1.903652168505571e-76, -9.461764865345789e-78, -3.16070492756384e-79, -7.094725564158129e-81, -1.0698459534511266e-82, -1.0834608609903522e-84, -7.3664363264253845e-87, -3.3609890849076206e-89, -1.0285234833660842e-91, -2.1096855584564616e-94, -2.8981906003200953e-97, -2.663774753168452e-100, -1.6358968259060488e-103, -6.701086986161631e-107, -1.8265800014293096e-110, -3.3021356669151695e-114, -3.9400457226449578e-118, -3.079503252886711e-122, -1.5568297838616875e-126, -4.971469919511412e-131, -9.508015160155222e-136, -9.1890762263906e-141, 0., 1.0501451237749117e-150, 1.2417887806973624e-155, 7.420428323525754e-161, 2.6557089586877043e-166, 6.003813258526739e-172, 8.779505960112529e-178, 8.410164351639492e-184, 5.317541974536166e-190, 2.2300042574204044e-196, 6.223489811063725e-203, 1.1585820272235733e-209}, {-4.0273681154842707e-84, -1.2060360583704187e-82, -2.3620116292577683e-81, -3.078353652448518e-80, -2.6838874352645714e-79, -1.5690252976868658e-78, -6.158057075996753e-78, -1.6237172927441871e-77, -2.8775061966040374e-77, -3.4282925275208884e-77, -2.7464240227717533e-77, -1.4795430113047426e-77, -5.360163848851106e-78, -1.3059364850922628e-78, -2.1396778307122917e-79, -2.357399851111207e-80, -1.7463886901272772e-81, -8.698085940360652e-83, -2.9122014223814794e-84, -6.55330155307759e-86, -9.90947168995978e-88, -1.0066649978030418e-89, -6.868067188084696e-92, -3.1458932585013103e-94, -9.669980369776633e-97, -1.9936575899160277e-99, -2.7550989858820014e-102, -2.5499649818349865e-105, -1.5790531632295752e-108, -6.533575336083e-112, -1.8031812297405013e-115, -3.311578208964731e-119, -4.033631392960115e-123, -3.242724630400687e-127, -1.7076517267629915e-131, -5.81663362686243e-136, -1.2514954691619834e-140, -1.6126867096727384e-145, -1.0501451237749117e-150, 0., 5.4483612212834045e-161, 4.340960883917426e-166, 1.7477926114057078e-171, 4.214686922098228e-177, 6.420028988107664e-183, 6.3256600750264106e-189, 4.0828848987582525e-195, 1.739407453833116e-201, 4.915012756960014e-208, 9.242346769027139e-215}, {-2.4422231022358695e-89, -7.318291753100126e-88, -1.434274641666502e-86, -1.8706224879617572e-85, -1.6321766839818057e-84, -9.549650756601022e-84, -3.75125945439989e-83, -9.900173223633291e-83, -1.756195936773635e-82, -2.0945306849899188e-82, -1.6798065176259245e-82, -9.06016229867045e-83, -3.2865538194436996e-83, -8.018273900903959e-84, -1.3156796041349321e-84, -1.4518790369879606e-85, -1.0774390997501343e-86, -5.376470478918614e-88, -1.8038200574689528e-89, -4.068345873796936e-91, -6.167303370813238e-93, -6.282528683665519e-95, -4.299584957375947e-97, -1.9762475177540102e-99, -6.098495841965131e-102, -1.2629385206901729e-104, -1.7542452379244705e-107, -1.633295398933642e-110, -1.0184828698244792e-113, -4.249247272189718e-117, -1.1845824236637031e-120, -2.2027030573407953e-124, -2.7255651737195554e-128, -2.2367903267450143e-132, -1.2115712624614032e-136, -4.298828690279287e-141, -9.86589375452224e-146, -1.430242509472857e-150, -1.2417887806973624e-155, -5.4483612212834045e-161, 0., 1.283288471529907e-171, 6.889172447669415e-177, 1.868938450335299e-182, 3.0366545684757097e-188, 3.116685785387976e-194, 2.069134696055076e-200, 8.998659022400562e-207, 2.5830959763553435e-213, 4.918052771341139e-220}, {-9.972392913620777e-95, -2.9901645423399912e-93, -5.864126281389061e-92, -7.653463355274507e-91, -6.682767878944726e-90, -3.9130187524262846e-89, -1.5383537478359807e-88, -4.0634765171755733e-88, -7.214843468556373e-88, -8.613209193572713e-88, -6.914960198473103e-88, -3.733784236919533e-88, -1.3560343744264768e-88, -3.312570563633962e-89, -5.442902340601337e-90, -6.015251050581239e-91, -4.471070134726071e-92, -2.234964631807753e-93, -7.512566866884594e-95, -1.697896595170459e-96, -2.579732022607001e-98, -2.634516108821228e-100, -1.807996620049075e-102, -8.335946233647194e-105, -2.581318859202945e-107, -5.36662089211201e-110, -7.487615131291663e-113, -7.007117589314581e-116, -4.395475045207382e-119, -1.8466753358234404e-122, -5.1909632379861165e-126, -9.749973353301828e-130, -1.2215157678421441e-133, -1.0183737740646206e-137, -5.631002717102583e-142, -2.0550451521019313e-146, -4.912883105332397e-151, -7.596934853100751e-156, -7.420428323525754e-161, -4.340960883917426e-166, -1.283288471529907e-171, 0., 1.37223042412605e-182, 4.963565114871798e-188, 9.072910755413176e-194, 9.932829731611447e-200, 6.86906301908129e-206, 3.0727058680657144e-212, 9.004064130641918e-219, 1.7415287389157877e-225}, {-2.7420651587388835e-100, -8.226814794233813e-99, -1.6144011785774215e-97, -2.108394065427338e-96, -1.8422603987489483e-95, -1.0795031651712137e-94, -4.2472070958019083e-94, -1.1227928779810725e-93, -1.9952837147852583e-93, -2.3841947340032325e-93, -1.9159789649963563e-93, -1.035624758705182e-93, -3.7653618933103516e-94, -9.20911449322261e-95, -1.5150870174253154e-95, -1.6767060885982736e-96, -1.248123583348032e-97, -6.249023953139302e-99, -2.104187923806905e-100, -4.764629772804521e-102, -7.254220433517409e-104, -7.425110566373518e-106, -5.108422117187824e-108, -2.3618307259711982e-110, -7.336315595896947e-113, -1.5305327370931156e-115, -2.143803642205789e-118, -2.0151872028458943e-121, -1.2705836710415395e-124, -5.369890410218303e-128, -1.520019927895152e-131, -2.8787826825133217e-135, -3.643085262288603e-139, -3.07519384340762e-143, -1.7273902002348554e-147, -6.435479712386386e-152, -1.5824516316674976e-156, -2.548949215132759e-161, -2.6557089586877043e-166, -1.7477926114057078e-171, -6.889172447669415e-177, -1.37223042412605e-182, 0., 6.661568460679294e-194, 1.623559269357396e-199, 1.999617927862404e-205, 1.475027968916243e-211, 6.873097604220525e-218, 2.0715935850533625e-224, 4.0902651906579e-231}, {-5.077311383743186e-106, -1.5241715053065545e-104, -2.992760858990673e-103, -3.91096431543537e-102, -3.419548052570483e-101, -2.00512973108649e-100, -7.894767509841496e-100, -2.0886746199684224e-99, -3.714757508265507e-99, -4.442663149469568e-99, -3.573480217877421e-99, -1.9334252809121435e-99, -7.03693996901171e-100, -1.72297038684296e-100, -2.838011998966572e-101, -3.1447627929149735e-102, -2.344146173486941e-103, -1.1753905984185261e-104, -3.964149043910517e-106, -8.991854065288051e-108, -1.3716161418430306e-109, -1.4068344515781717e-111, -9.700916345924519e-114, -4.496367984694934e-116, -1.4005408658899994e-118, -2.9309127554393898e-121, -4.119558050723356e-124, -3.887593113273674e-127, -2.4620857638932114e-130, -1.045891876777836e-133, -2.978160312938469e-137, -5.679814163063869e-141, -7.247674902306376e-145, -6.179689736521847e-149, -3.5146303730321025e-153, -1.3301773744724566e-157, -3.338980771604889e-162, -5.531961038629751e-167, -6.003813258526739e-172, -4.214686922098228e-177, -1.868938450335299e-182, -4.963565114871798e-188, -6.661568460679294e-194, 0., 1.4681648959287443e-205, 2.4109735545158825e-211, 2.000774771837902e-217, 9.944413678524939e-224, 3.1221947951124337e-230, 6.340760660468161e-237}, {-6.331109823421824e-112, -1.9015802575442798e-110, -3.735933226447947e-109, -4.885054070996291e-108, -4.273913730627065e-107, -2.50775522143456e-106, -9.88058990173277e-106, -2.6159634346727874e-105, -4.656145916388496e-105, -5.573065780747899e-105, -4.486606857673669e-105, -2.4297019987154268e-105, -8.851844722726388e-106, -2.1696011814100604e-106, -3.577660618930924e-107, -3.969076919203146e-108, -2.962378949476091e-109, -1.4874222892774948e-110, -5.023946088581396e-112, -1.1414047437566234e-113, -1.744125169868896e-115, -1.792296293529948e-117, -1.238448073804529e-119, -5.753244120538041e-122, -1.7965273638761928e-124, -3.770037266637204e-127, -5.3153989613070695e-130, -5.033515371634184e-133, -3.20032111557831e-136, -1.3655627756902246e-139, -3.9083586663166685e-143, -7.49821499948493e-147, -9.634937945689882e-151, -8.283636109104615e-155, -4.758814813143735e-159, -1.823575443479922e-163, -4.650155988203958e-168, -7.864797748087704e-173, -8.779505960112529e-178, -6.420028988107664e-183, -3.0366545684757097e-188, -9.072910755413176e-194, -1.623559269357396e-199, -1.4681648959287443e-205, 0., 1.46900781914754e-217, 1.6254312308418982e-223, 9.08870698097986e-230, 3.0437686441353803e-236, 6.43904960586292e-243}, {-5.316520135909183e-118, -1.597667850672679e-116, -3.140551255852238e-115, -4.108870219209645e-114, -3.596973450524247e-113, -2.111874677908843e-112, -8.326289361422367e-112, -2.2059778987830983e-111, -3.929284006515782e-111, -4.706696999576362e-111, -3.79223077541833e-111, -2.0554437837521155e-111, -7.4952368963045445e-112, -1.8388902426973246e-112, -3.035478735608757e-113, -3.371323186930381e-114, -2.5192321774078188e-115, -1.2665320015296425e-116, -4.283738995907512e-118, -9.746767976200634e-120, -1.4917430795112345e-121, -1.535609632266051e-123, -1.0630913206044089e-125, -4.948844452116849e-128, -1.5488549600575123e-130, -3.2584394353031166e-133, -4.606855373141949e-136, -4.376053251247241e-139, -2.791965908198669e-142, -1.1959912671390558e-145, -3.4383117411873848e-149, -6.630254326322735e-153, -8.570351681357137e-157, -7.41988524697459e-161, -4.298125628414874e-165, -1.6636763429739613e-169, -4.2954400203617315e-174, -7.38018283323316e-179, -8.410164351639492e-184, -6.3256600750264106e-189, -3.116685785387976e-194, -9.932829731611447e-200, -1.999617927862404e-205, -2.4109735545158825e-211, -1.46900781914754e-217, 0., 6.673078281450436e-230, 4.9750615517032115e-236, 1.8743924117681063e-242, 4.2296007373561045e-249}, {-3.0066815606565714e-124, -9.039841803297324e-123, -1.7778888388774318e-121, -2.327319916701234e-120, -2.0385302615101085e-119, -1.1975854340810881e-118, -4.724560132697533e-118, -1.2525545944326165e-117, -2.2325941886067758e-117, -2.6762702170246763e-117, -2.1579615967118836e-117, -1.1706019077188834e-117, -4.272330463464914e-118, -1.0491419842525773e-118, -1.733524469212059e-119, -1.9273266361829013e-120, -1.4418030784969545e-121, -7.257225719692461e-123, -2.4577163910056336e-124, -5.599710059510029e-126, -8.583054455375074e-128, -8.849609176303736e-130, -6.137174544582207e-132, -2.862354737243639e-134, -8.976946436512147e-137, -1.892838013031506e-139, -2.6828443058727265e-142, -2.5555135669754753e-145, -1.6354911242221204e-148, -7.03026092794889e-152, -2.029030011558681e-155, -3.93013897469177e-159, -5.1062000280424045e-163, -4.44706822076416e-167, -2.5940728179482614e-171, -1.0124556846120606e-175, -2.640460326842203e-180, -4.593398669790387e-185, -5.317541974536166e-190, -4.0828848987582525e-195, -2.069134696055076e-200, -6.86906301908129e-206, -1.475027968916243e-211, -2.000774771837902e-217, -1.6254312308418982e-223, -6.673078281450436e-230, 0., 1.3762044551593662e-242, 6.913273764848381e-249, 1.7549919687834e-255}, {-1.1451697119899252e-130, -3.4446760969903335e-129, -6.778079897720109e-128, -8.877333795427733e-127, -7.779981620704997e-126, -4.573136682635944e-125, -1.805208996909817e-124, -4.788883716178924e-124, -8.541478329100689e-124, -1.0245993513655518e-123, -8.267708917886429e-124, -4.488341848527449e-124, -1.6394425712337937e-124, -4.029410251424516e-125, -6.664018296606538e-126, -7.416275438231021e-127, -5.553779468060602e-128, -2.7985697202018227e-129, -9.488858610540347e-131, -2.1647216016717117e-132, -3.322572965909695e-134, -3.43083375046976e-136, -2.383084736241949e-138, -1.1133945840790513e-140, -3.498452905702786e-143, -7.391950980428294e-146, -1.050091182961125e-148, -1.0027596004883217e-151, -6.435340494491928e-155, -2.7748356842848998e-158, -8.036364980485525e-162, -1.5627117386142343e-165, -2.039404109267447e-169, -1.78525689146837e-173, -1.0475783447147206e-177, -4.117246101862945e-182, -1.0827160499619191e-186, -1.9025403394448376e-191, -2.2300042574204044e-196, -1.739407453833116e-201, -8.998659022400562e-207, -3.0727058680657144e-212, -6.873097604220525e-218, -9.944413678524939e-224, -9.08870698097986e-230, -4.9750615517032115e-236, -1.3762044551593662e-242, 0., 1.288534356007133e-255, 4.3614019893002247e-262}, {-2.937542617714927e-137, -8.840141526715733e-136, -1.7402947173012293e-134, -2.2804113161518763e-133, -1.999556094234271e-132, -1.1759914037327195e-131, -4.644764756020421e-131, -1.2329031356750313e-130, -2.20038779715105e-130, -2.641227966567114e-130, -2.1327396873566773e-130, -1.1586598296701966e-130, -4.235468583496737e-131, -1.0418409281297147e-131, -1.7245347821565933e-132, -1.9209701335589183e-133, -1.439951004780057e-134, -7.263523903859507e-136, -2.4655171760324567e-137, -5.631353853437965e-139, -8.654452415944162e-141, -8.948719393841445e-143, -6.225061185384278e-145, -2.9130549134543667e-147, -9.16917449857383e-150, -1.9410424506635607e-152, -2.763129236846047e-155, -2.644581331335733e-158, -1.7014481747682325e-161, -7.356803680309802e-165, -2.1372436545630645e-168, -4.170408655699905e-172, -5.463900898994429e-176, -4.804351141687935e-180, -2.833622522154542e-184, -1.1203139232734382e-188, -2.966702077489795e-193, -5.2565083562017976e-198, -6.223489811063725e-203, -4.915012756960014e-208, -2.5830959763553435e-213, -9.004064130641918e-219, -2.0715935850533625e-224, -3.1221947951124337e-230, -3.0437686441353803e-236, -1.8743924117681063e-242, -6.913273764848381e-249, -1.288534356007133e-255, 0., 5.477304959584511e-269}, {-5.075037730287332e-144, -1.5279273911728875e-142, -3.0092824144772323e-141, -3.9451055258483506e-140, -3.460935841302214e-139, -2.0365190979504998e-138, -8.047908079853256e-138, -2.1374428417508858e-137, -3.817009248826439e-137, -4.5845993715412325e-137, -3.70440942207713e-137, -2.0139001860703816e-137, -7.367171961735324e-138, -1.8135769606391282e-138, -3.0044238749170557e-139, -3.3495441683974286e-140, -2.5131117219818824e-141, -1.2689244737008472e-142, -4.3117005436991156e-144, -9.859075526125366e-146, -1.5169793888162502e-147, -1.5705626904463854e-149, -1.094042415462331e-151, -5.1272220925503795e-154, -1.6164382695688697e-156, -3.427824340451841e-159, -4.888847298837683e-162, -4.688786230776131e-165, -3.023487263070129e-168, -1.3105864715131537e-171, -3.817994085474685e-175, -7.473126196410442e-179, -9.824984447567098e-183, -8.672884932235808e-187, -5.138132957903699e-191, -2.0418532978833183e-195, -5.439214188952624e-200, -9.704787696317928e-205, -1.1585820272235733e-209, -9.242346769027139e-215, -4.918052771341139e-220, -1.7415287389157877e-225, -4.0902651906579e-231, -6.340760660468161e-237, -6.43904960586292e-243, -4.2296007373561045e-249, -1.7549919687834e-255, -4.3614019893002247e-262, -5.477304959584511e-269, 0.}}, {{0., 2.191094425607776e-17, 1.3083400614090818e-15, 3.901437670993466e-14, 6.923225557254142e-13, 7.729176117812627e-12, 5.5660957844002185e-11, 2.6205003330192e-10, 8.130654639837846e-10, 1.6712241757085586e-9, 2.2838069753860564e-9, 2.0802042385517707e-9, 1.2652984538287582e-9, 5.146867884421947e-10, 1.4016538392939751e-10, 2.557825511612296e-11, 3.1299968720149612e-12, 2.569886309645807e-13, 1.4164187433400921e-14, 5.242685690698676e-16, 1.3036167602153424e-17, 2.178250067751436e-19, 2.446454708034945e-21, 1.8472837121203765e-23, 9.379510961257388e-26, 3.2029488085785994e-28, 7.35711376771639e-31, 1.1368673713955708e-33, 1.1819740705555364e-36, 8.268895858465851e-40, 3.892866428117247e-43, 1.2334196112909043e-46, 2.630298336706634e-50, 3.7755684796245394e-54, 3.648131851972739e-58, 2.372983876477069e-62, 1.0391500386804039e-66, 3.063671278715251e-71, 6.08143459414784e-76, 8.12807862591517e-81, 7.314832396927862e-86, 4.4327262077546476e-91, 1.8088467886310542e-96, 4.970617023023071e-102, 9.19832704846564e-108, 1.1463281644925468e-113, 9.621027096592971e-120, 5.43821488410152e-126, 2.0702519293308856e-132, 5.3079987440867945e-139}, {-2.191094425607776e-17, 0., 2.98359621925268e-14, 1.186201206107504e-12, 2.368004152921414e-11, 2.819866613606201e-10, 2.115289976666261e-9, 1.0243170839017197e-8, 3.244351736478231e-8, 6.774457348894863e-8, 9.373301767992244e-8, 8.623878946959841e-8, 5.289232577080203e-8, 2.1665475283654762e-8, 5.9352988000421134e-9, 1.0886630730159703e-9, 1.3381363520518969e-10, 1.1029850382532132e-11, 6.100314856157773e-13, 2.2649387709733723e-14, 5.647508517127621e-16, 9.460224471445393e-18, 1.064918766277569e-19, 8.057695328340514e-22, 4.099009453717661e-24, 1.402177895015143e-26, 3.225936336412317e-29, 4.992301855010839e-32, 5.197505273313314e-35, 3.640731332543272e-38, 1.716038995346544e-41, 5.443160737635363e-45, 1.1619764517486636e-48, 1.6695477789135235e-52, 1.614677822566681e-56, 1.0512012479975449e-60, 4.607060261120697e-65, 1.35932380622072e-69, 2.7002504324825198e-74, 3.611492049875889e-79, 3.2522856191469024e-84, 1.9720895688365774e-89, 8.0522241922736e-95, 2.2139640519719636e-100, 4.0992459453586574e-106, 5.111265036045633e-112, 4.291956627534581e-118, 2.4271436161974785e-124, 9.243977724488342e-131, 2.371127885388e-137}, {-1.3083400614090818e-15, -2.98359621925268e-14, 0., 1.7704535497232446e-11, 4.712456601673169e-10, 6.313148251120547e-9, 5.0514499566994195e-8, 2.5480580905810824e-7, 8.301131546556335e-7, 1.7694517253053336e-6, 2.4871170725398937e-6, 2.316868114081996e-6, 1.4353444355835631e-6, 5.928376956422738e-7, 1.6354475914089623e-7, 3.0176228440025376e-8, 3.728149294291871e-9, 3.0867186600461495e-10, 1.7138762538590323e-11, 6.385413580545039e-13, 1.597099404788756e-14, 2.6827561288482444e-16, 3.027494272122372e-18, 2.2959562319783916e-20, 1.1703881431022202e-22, 4.0112142472056117e-25, 9.244494616997508e-28, 1.4329256136914767e-30, 1.4940346532023741e-33, 1.047974010743701e-36, 4.9458772574479425e-40, 1.5706667519739993e-43, 3.3567039208832295e-47, 4.827993933497161e-51, 4.673885476937363e-55, 3.045629277035151e-59, 1.3359521817481253e-63, 3.944978261012609e-68, 7.84261632131271e-73, 1.0496897064890998e-77, 9.459404916816914e-83, 5.73967628895368e-88, 2.345028582237719e-93, 6.451508577034176e-99, 1.1952010286502764e-104, 1.4910778811501782e-110, 1.252713145760527e-116, 7.087715951195488e-123, 2.7006917115530735e-129, 6.930550719148339e-136}, {-3.901437670993466e-14, -1.186201206107504e-12, -1.7704535497232446e-11, 0., 4.683878928781176e-9, 8.366484706951237e-8, 7.531224797933926e-7, 4.052169510209822e-6, 0.000013751318552116884, 0.000030149507457531927, 0.00004326060356531012, 0.00004093898611452077, 0.00002567952179938337, 0.000010713501086720263, 2.980137918117377e-6, 5.537211920296081e-7, 6.88171851701886e-8, 5.726933189445576e-9, 3.194030291853278e-10, 1.1946711759324296e-11, 2.9984489333278276e-13, 5.052291413764875e-15, 5.717355908097265e-17, 4.346729337935551e-19, 2.2208274662560912e-21, 7.62709220414504e-24, 1.761116397938895e-26, 2.734533017266439e-29, 2.8557200066575774e-32, 2.0060806503315237e-35, 9.480633535519531e-39, 3.014618616334519e-42, 6.450272638722789e-46, 9.287836663361026e-50, 9.000737063547793e-54, 5.870855209836015e-58, 2.577592319698014e-62, 7.618049314674247e-67, 1.515705425173734e-71, 2.0302522841972313e-76, 1.8309236574992275e-81, 1.1117181130948763e-86, 4.54507494485563e-92, 1.2511970341122332e-97, 2.3193367914386577e-103, 2.8951392376163833e-109, 2.4336364789403456e-115, 1.3776368773855334e-121, 5.251918600342586e-128, 1.3483915197873907e-134}, {-6.923225557254142e-13, -2.368004152921414e-11, -4.712456601673169e-10, -4.683878928781176e-9, 0., 5.567315801036118e-7, 6.6820109500080915e-6, 0.00004044657009399238, 0.00014640879316336748, 0.00033437346576058576, 0.0004934902945211627, 0.0004767360205029785, 0.0003037856399338466, 0.00012832366609470585, 0.00003605591400350645, 6.75515650580042e-6, 8.454104845528215e-7, 7.077343332185614e-8, 3.967424202627246e-9, 1.490570401080075e-10, 3.755783495376659e-12, 6.350349674612812e-14, 7.20853420131998e-16, 5.4956496031168784e-18, 2.8148700615968316e-20, 9.689211626230799e-23, 2.2418974177684085e-25, 3.487647604307588e-28, 3.6485448420320948e-31, 2.5671301108246196e-34, 1.2150097824010808e-37, 3.8687524433696393e-41, 8.288404469042844e-45, 1.1948795916975039e-48, 1.1592322824445263e-52, 7.569129163298215e-57, 3.326466074387717e-61, 9.840374652176008e-66, 1.9595597434357572e-70, 2.6269292873972873e-75, 2.3708487244577437e-80, 1.4406073962611315e-85, 5.893765734143386e-91, 1.623540598149703e-96, 3.0114300719154044e-102, 3.761290289382802e-108, 3.1635111719794532e-114, 1.791774575695969e-120, 6.834251867635011e-127, 1.7555108812209396e-133}, {-7.729176117812627e-12, -2.819866613606201e-10, -6.313148251120547e-9, -8.366484706951237e-8, -5.567315801036118e-7, 0., 0.000029839019792656456, 0.00024082291286442621, 0.0009806991285345118, 0.0023890715624660082, 0.003672863048731113, 0.003649543483178969, 0.002374010628450824, 0.001018735877531074, 0.00028981868652354744, 0.00005484664862585653, 6.921280237153362e-6, 5.834659591555057e-7, 3.290268352102038e-8, 1.242500679233823e-9, 3.1446997831358557e-11, 5.337969233900458e-13, 6.080380321656256e-15, 4.6499181051615204e-17, 2.388302440826145e-19, 8.2415046452157035e-22, 1.911259758572223e-24, 2.979441117369689e-27, 3.1227962399305167e-30, 2.201032619967267e-33, 1.0434071309169045e-36, 3.327268815564979e-40, 7.138123115710216e-44, 1.0303660539970226e-47, 1.0008167731632674e-51, 6.542034685412215e-56, 2.878075478560826e-60, 8.522265054752387e-65, 1.698638240548415e-69, 2.2791169988948966e-74, 2.0586226786381446e-79, 1.2518542902931572e-84, 5.125289036862994e-90, 1.4128286977377917e-95, 2.622314424132346e-101, 3.2773313516749116e-107, 2.7581082290729995e-113, 1.5630453181271504e-119, 5.965050495412531e-126, 1.5330314117223625e-132}, {-5.5660957844002185e-11, -2.115289976666261e-9, -5.0514499566994195e-8, -7.531224797933926e-7, -6.6820109500080915e-6, -0.000029839019792656456, 0., 0.0007226019675736107, 0.0039235199090085935, 0.010752804568168085, 0.01763299369863943, 0.01825108244008875, 0.012211448990854608, 0.005349349637770355, 0.0015459847007676054, 0.00029622651903356414, 0.00003775939950690442, 3.20965455204892e-6, 1.8226385189998668e-7, 6.923780349047001e-9, 1.7613566268378789e-10, 3.003161398803965e-12, 3.4342597226188845e-14, 2.6354394993200514e-16, 1.3578117325318788e-18, 4.698523933198089e-21, 1.0923498343255322e-23, 1.7067218604566568e-26, 1.7925439926406707e-29, 1.2658271420336368e-32, 6.011133370495617e-36, 1.9199321483032986e-39, 4.12500945559373e-43, 5.962502928353084e-47, 5.798904266600124e-51, 3.795079831404955e-55, 1.6714487720699922e-59, 4.954480040138884e-64, 9.884808628056573e-69, 1.3274952431356918e-73, 1.2001042006459786e-78, 7.303829996042982e-84, 2.992612386697331e-89, 8.255416054676129e-95, 1.5333280614006714e-100, 1.9175923948175758e-106, 1.6148001050706718e-112, 9.156667971518151e-119, 3.4964416872919176e-125, 8.990796401034221e-132}, {-2.6205003330192e-10, -1.0243170839017197e-8, -2.5480580905810824e-7, -4.052169510209822e-6, -0.00004044657009399238, -0.00024082291286442621, -0.0007226019675736107, 0., 0.007916425369656048, 0.028927689711458975, 0.053366727541660344, 0.05891988231104902, 0.04106475258330356, 0.018502799890638945, 0.005458791437956856, 0.0010625629524630997, 0.00013713580031124206, 0.000011774673258585439, 6.742100783972512e-7, 2.5790777361743626e-8, 6.600029416663284e-10, 1.1310940207849958e-11, 1.2992348750913015e-13, 1.000938441661335e-15, 5.174867449822839e-18, 1.7962368611314106e-20, 4.187632959415942e-23, 6.559288136020738e-26, 6.904777584736011e-29, 4.8859892299501083e-32, 2.324642722644431e-35, 7.437729346381482e-39, 1.600570713074946e-42, 2.316975524107207e-46, 2.256497874644827e-50, 1.478645977838704e-54, 6.52008219378919e-59, 1.9348214831849134e-63, 3.864232404791351e-68, 5.1946018860365614e-73, 4.700426170411877e-78, 2.863154511672656e-83, 1.1740842702975379e-88, 3.241328137069344e-94, 6.024714455266621e-100, 7.539777762770578e-106, 6.353406479278706e-112, 3.6049301827693705e-118, 1.3773493639670144e-124, 3.5437432970421116e-131}, {-8.130654639837846e-10, -3.244351736478231e-8, -8.301131546556335e-7, -0.000013751318552116884, -0.00014640879316336748, -0.0009806991285345118, -0.0039235199090085935, -0.007916425369656048, 0., 0.03926724932871512, 0.09658863726016254, 0.1199692266581194, 0.08918789682243186, 0.04186035731578179, 0.012702711577875041, 0.0025241168028454267, 0.0003309367885649834, 0.000028769883229443615, 1.6639845146437216e-6, 6.418338188895534e-8, 1.6539809005421898e-9, 2.851417091712072e-11, 3.292085997875275e-13, 2.5475655684561476e-15, 1.3222604764434325e-17, 4.6056056152858814e-20, 1.0770459666790185e-22, 1.691714374454745e-25, 1.7852832071217279e-28, 1.266181152099407e-31, 6.036674861012259e-35, 1.935101235394064e-38, 4.171505536047736e-42, 6.0483209965917306e-46, 5.899174430546125e-50, 3.870942001580247e-54, 1.7090699149183983e-58, 5.077668794139806e-63, 1.015241879029826e-67, 1.3661887652382106e-72, 1.2374281722808243e-77, 7.544431742676019e-83, 3.096398636886524e-88, 8.555300491291775e-94, 1.5914169158252676e-99, 1.993073880921888e-105, 1.680630947290129e-111, 9.542193059216768e-118, 3.6481020005474767e-124, 9.391685617591668e-131}, {-1.6712241757085586e-9, -6.774457348894863e-8, -1.7694517253053336e-6, -0.000030149507457531927, -0.00033437346576058576, -0.0023890715624660082, -0.010752804568168085, -0.028927689711458975, -0.03926724932871512, 0., 0.08823698821896568, 0.14612793029002152, 0.12221424213696383, 0.06118536440870152, 0.019340594705545954, 0.003952913319478154, 0.0005290634188321901, 0.000046724020907847456, 2.736191079240848e-6, 1.0660671091597429e-7, 2.7701071111619156e-9, 4.808983368243176e-11, 5.585230758655356e-13, 4.344269708435215e-15, 2.2648681574744602e-17, 7.919767643257824e-20, 1.8585116502216414e-22, 2.928198922697354e-25, 3.0987415682346373e-28, 2.2032368071449814e-31, 1.0528076497446536e-34, 3.3818408662036443e-38, 7.304055279735586e-42, 1.06086640812618e-45, 1.0363645079216028e-49, 6.810529540104242e-54, 3.01106544509256e-58, 8.957339510766949e-63, 1.793085094032266e-67, 2.4155993460318475e-72, 2.1902129761671377e-77, 1.3366484680133505e-82, 5.490937789012535e-88, 1.518450970897261e-93, 2.8268589966642755e-99, 3.543062450566491e-105, 2.9898205094632832e-111, 1.6987200839396967e-117, 6.498695991898859e-124, 1.6740726985102139e-130}, {-2.2838069753860564e-9, -9.373301767992244e-8, -2.4871170725398937e-6, -0.00004326060356531012, -0.0004934902945211627, -0.003672863048731113, -0.01763299369863943, -0.053366727541660344, -0.09658863726016254, -0.08823698821896568, 0., 0.08986049375528697, 0.1002065529891899, 0.056438358965163485, 0.0190294122287167, 0.004051367204466742, 0.0005577332130406624, 0.00005028214843108543, 2.9912965033237523e-6, 1.180028827530951e-7, 3.0972013516450468e-9, 5.421635012793125e-11, 6.340807635070203e-13, 4.9613248014036035e-15, 2.5998318845164363e-17, 9.131650466792522e-20, 2.151304631672486e-22, 3.4012813355817883e-25, 3.6105205841145813e-28, 2.5742477787659465e-31, 1.2331766587789298e-34, 3.9702270582360386e-38, 8.592597313818563e-42, 1.2503824093430334e-45, 1.2236277781962618e-49, 8.054027438019248e-54, 3.566114981020845e-58, 1.062307705236241e-62, 2.129249220000495e-67, 2.8718860868637967e-72, 2.6068225650655426e-77, 1.592555160104724e-82, 6.548594889452299e-88, 1.8125974285473017e-93, 3.377385093900984e-99, 4.2365263704831014e-105, 3.577762078240079e-111, 2.0342555616919605e-117, 7.787727987304489e-124, 2.007448870281163e-130}, {-2.0802042385517707e-9, -8.623878946959841e-8, -2.316868114081996e-6, -0.00004093898611452077, -0.0004767360205029785, -0.003649543483178969, -0.01825108244008875, -0.05891988231104902, -0.1199692266581194, -0.14612793029002152, -0.08986049375528697, 0., 0.041487635982855105, 0.031155568471574985, 0.011817869749464263, 0.0026837629723465433, 0.000384855611200653, 0.00003568778530772427, 2.167305224091725e-6, 8.68545663119315e-8, 2.3081525622554154e-9, 4.081221385100221e-11, 4.812919286366896e-13, 3.792172766472718e-15, 1.9990016094769503e-17, 7.057300623732762e-20, 1.670035681012673e-22, 2.6507341832083324e-25, 2.8235715873066897e-28, 2.0193974909105494e-31, 9.700664009691728e-35, 3.1309678439730033e-38, 6.791624006293395e-42, 9.903535475267832e-46, 9.709983308620158e-50, 6.402312955267421e-54, 2.8393214544630784e-58, 8.470566900437713e-63, 1.7001404141657474e-67, 2.296041875885327e-72, 2.0866075589733604e-77, 1.2761643430806299e-82, 5.25306049038082e-88, 1.4554254319732834e-93, 2.7143644993065867e-99, 3.4077941121231465e-105, 2.8802458637030945e-111, 1.638924133009839e-117, 6.2788695878205555e-124, 1.6196308621981887e-130}, {-1.2652984538287582e-9, -5.289232577080203e-8, -1.4353444355835631e-6, -0.00002567952179938337, -0.0003037856399338466, -0.002374010628450824, -0.012211448990854608, -0.04106475258330356, -0.08918789682243186, -0.12221424213696383, -0.1002065529891899, -0.041487635982855105, 0., 0.008685663722973727, 0.004392838802236385, 0.0011222839367176596, 0.00017166633560678076, 0.000016581952943841637, 1.0357873793625377e-6, 4.237386083445265e-8, 1.1439559866437653e-9, 2.0480001773100588e-11, 2.4395696411140576e-13, 1.9381923761588556e-15, 1.028841240466146e-17, 3.653854599529674e-20, 8.690801958962215e-23, 1.3855901326682921e-25, 1.481723576352304e-28, 1.063397305208197e-31, 5.124101144510714e-35, 1.6584391424444383e-38, 3.606464507627556e-42, 5.2708930277048464e-46, 5.178579585857813e-50, 3.4209822471938674e-54, 1.5197883949570894e-58, 4.541261016239932e-63, 9.128337773035928e-68, 1.234476606008455e-72, 1.1233061499691293e-77, 6.878293065148555e-83, 2.834453192585509e-88, 7.861383842848011e-94, 1.467579145972558e-99, 1.8441901491621614e-105, 1.5600472818403992e-111, 8.884269427402402e-118, 3.406273896367981e-124, 8.792887121958723e-131}, {-5.146867884421947e-10, -2.1665475283654762e-8, -5.928376956422738e-7, -0.000010713501086720263, -0.00012832366609470585, -0.001018735877531074, -0.005349349637770355, -0.018502799890638945, -0.04186035731578179, -0.06118536440870152, -0.056438358965163485, -0.031155568471574985, -0.008685663722973727, 0., 0.0008247119102196228, 0.00028093023545139507, 0.00004834297749097758, 4.980955488018526e-6, 3.2409800991732676e-7, 1.3637609216308081e-8, 3.758411807248064e-10, 6.835408321580651e-12, 8.244090013188867e-14, 6.615934412084552e-16, 3.541170183375696e-18, 1.2664153043779836e-20, 3.030136309787853e-23, 4.855774989414149e-26, 5.215854439825069e-29, 3.7579726240076404e-32, 1.8171095267153123e-35, 5.899367331580094e-39, 1.286448080054773e-42, 1.8848721546005725e-46, 1.8560696283141586e-50, 1.2286626619281305e-54, 5.468732915000452e-59, 1.6369472805504957e-63, 3.295682438574704e-68, 4.4635401267261575e-73, 4.0671563204565094e-78, 2.4936052564929827e-83, 1.0288049095596486e-88, 2.856574519847865e-94, 5.338266397343296e-100, 6.714732741896083e-106, 5.685383690314248e-112, 3.2405564311501753e-118, 1.2434608188409226e-124, 3.212323464322122e-131}, {-1.4016538392939751e-10, -5.9352988000421134e-9, -1.6354475914089623e-7, -2.980137918117377e-6, -0.00003605591400350645, -0.00028981868652354744, -0.0015459847007676054, -0.005458791437956856, -0.012702711577875041, -0.019340594705545954, -0.0190294122287167, -0.011817869749464263, -0.004392838802236385, -0.0008247119102196228, 0., 0.000035520637177908653, 8.149939721025695e-6, 9.446831830237251e-7, 6.556598823538093e-8, 2.8738841404772504e-9, 8.146476973804146e-11, 1.5124630586177324e-12, 1.8531153892272875e-14, 1.5057260384964082e-16, 8.140786662943509e-19, 2.9356200789014248e-21, 7.073141061788572e-24, 1.1402133738253327e-26, 1.2310466189347359e-29, 8.909168001759792e-33, 4.3247840506244686e-36, 1.4089452437536329e-39, 3.0819346630033132e-43, 4.52811829467881e-47, 4.470099861412177e-51, 2.9657977725441096e-55, 1.3227988799917392e-59, 3.967012301656006e-64, 8.000715933439802e-69, 1.0853213946633933e-73, 9.904047366563507e-79, 6.0805896749197875e-84, 2.5119172113338977e-89, 6.982879719623884e-95, 1.3063876429128347e-100, 1.6449500215188195e-106, 1.3941454249478194e-112, 7.95365724664404e-119, 3.054606264852956e-125, 7.89763527981024e-132}, {-2.557825511612296e-11, -1.0886630730159703e-9, -3.0176228440025376e-8, -5.537211920296081e-7, -6.75515650580042e-6, -0.00005484664862585653, -0.00029622651903356414, -0.0010625629524630997, -0.0025241168028454267, -0.003952913319478154, -0.004051367204466742, -0.0026837629723465433, -0.0011222839367176596, -0.00028093023545139507, -0.000035520637177908653, 0., 6.940497816178953e-7, 1.0726576789833373e-7, 8.375410378605944e-9, 3.915844736760511e-10, 1.1562581561262556e-11, 2.2080261235320295e-13, 2.7617015053544025e-15, 2.2796053063612392e-17, 1.2478865510952416e-19, 4.545413372630712e-22, 1.1043073926637602e-24, 1.7926282878304357e-27, 1.9469555536843082e-30, 1.4162507281851736e-33, 6.905608036592417e-37, 2.2585587790524885e-40, 4.957538147060714e-44, 7.30639065479634e-48, 7.232809914871878e-52, 4.810812786157749e-56, 2.150585203347815e-60, 6.46285798737743e-65, 1.3059052453019535e-69, 1.7745809628694884e-74, 1.621980357003084e-79, 9.972900876760463e-85, 4.125506497543416e-90, 1.1483144127247627e-95, 2.1508742878225782e-101, 2.7113057130458858e-107, 2.3003081300560385e-113, 1.3136181218198554e-119, 5.049594241649919e-126, 1.306694813752197e-132}, {-3.1299968720149612e-12, -1.3381363520518969e-10, -3.728149294291871e-9, -6.88171851701886e-8, -8.454104845528215e-7, -6.921280237153362e-6, -0.00003775939950690442, -0.00013713580031124206, -0.0003309367885649834, -0.0005290634188321901, -0.0005577332130406624, -0.000384855611200653, -0.00017166633560678076, -0.00004834297749097758, -8.149939721025695e-6, -6.940497816178953e-7, 0., 6.152828411568092e-9, 6.405580450092433e-10, 3.369227838064597e-11, 1.0611785173982202e-12, 2.1108949189998248e-14, 2.7156487750292764e-16, 2.2882915956477973e-18, 1.2725247415612894e-20, 4.69309718850023e-23, 1.151704192105552e-25, 1.8851475055113424e-28, 2.061757505934325e-31, 1.508686888613102e-34, 7.394049505617697e-38, 2.429105219894418e-41, 5.352797071127591e-45, 7.916313026255504e-49, 7.860851806728127e-53, 5.243070713927728e-57, 2.3496923753323416e-61, 7.07725559098685e-66, 1.4330131125455157e-70, 1.950994593155131e-75, 1.786325001600031e-80, 1.10009911797989e-85, 4.55754024707126e-91, 1.270311418520707e-96, 2.3824221305921497e-102, 3.006760841881522e-108, 2.5538137947867527e-114, 1.4599046768809232e-120, 5.6174106547267766e-127, 1.4549659958863115e-133}, {-2.569886309645807e-13, -1.1029850382532132e-11, -3.0867186600461495e-10, -5.726933189445576e-9, -7.077343332185614e-8, -5.834659591555057e-7, -3.20965455204892e-6, -0.000011774673258585439, -0.000028769883229443615, -0.000046724020907847456, -0.00005028214843108543, -0.00003568778530772427, -0.000016581952943841637, -4.980955488018526e-6, -9.446831830237251e-7, -1.0726576789833373e-7, -6.152828411568092e-9, 0., 2.4749647792267346e-11, 1.7357199288691645e-12, 6.1502141972038e-14, 1.3049597907019585e-15, 1.748770758901508e-17, 1.5156715700685958e-19, 8.604285585115642e-22, 3.2236475575281918e-24, 8.009842668846977e-27, 1.3243207419301178e-29, 1.4604596141536228e-32, 1.076161716646653e-35, 5.305645136476976e-39, 1.751957765693264e-42, 3.877864091886563e-46, 5.757507979973842e-50, 5.737022509517335e-54, 3.838355077637981e-58, 1.7249445605939337e-62, 5.2085412704926795e-67, 1.05702998412395e-71, 1.44208692490696e-76, 1.3228713156980389e-81, 8.161003762881665e-87, 3.386395683027778e-92, 9.45279662568993e-98, 1.77527229718984e-103, 2.243362457248429e-109, 1.907684277038697e-115, 1.0917534910612244e-121, 4.205217061376297e-128, 1.0902583224690993e-134}, {-1.4164187433400921e-14, -6.100314856157773e-13, -1.7138762538590323e-11, -3.194030291853278e-10, -3.967424202627246e-9, -3.290268352102038e-8, -1.8226385189998668e-7, -6.742100783972512e-7, -1.6639845146437216e-6, -2.736191079240848e-6, -2.9912965033237523e-6, -2.167305224091725e-6, -1.0357873793625377e-6, -3.2409800991732676e-7, -6.556598823538093e-8, -8.375410378605944e-9, -6.405580450092433e-10, -2.4749647792267346e-11, 0., 4.517553919712907e-14, 2.1342862821387274e-15, 5.094623377454237e-17, 7.282434051859364e-19, 6.574724343941978e-21, 3.8390318712660147e-23, 1.4682814018475656e-25, 3.706168442714716e-28, 6.204251311794469e-31, 6.9111537940555735e-34, 5.135026250936679e-37, 2.549351876868715e-40, 8.468229894468974e-44, 1.8840093398217986e-47, 2.8096971799103987e-51, 2.81067936817762e-55, 1.8870145756113433e-59, 8.50643790752934e-64, 2.575688895320689e-68, 5.240246280367085e-73, 7.165421520138888e-78, 6.586673483355514e-83, 4.0711196175996477e-88, 1.6922426070739197e-93, 4.731301951246354e-99, 8.898734519737133e-105, 1.1260531014290406e-110, 9.587827776987773e-117, 5.493574558325493e-123, 2.1183692773456692e-129, 5.497874432525165e-136}, {-5.242685690698676e-16, -2.2649387709733723e-14, -6.385413580545039e-13, -1.1946711759324296e-11, -1.490570401080075e-10, -1.242500679233823e-9, -6.923780349047001e-9, -2.5790777361743626e-8, -6.418338188895534e-8, -1.0660671091597429e-7, -1.180028827530951e-7, -8.68545663119315e-8, -4.237386083445265e-8, -1.3637609216308081e-8, -2.8738841404772504e-9, -3.915844736760511e-10, -3.369227838064597e-11, -1.7357199288691645e-12, -4.517553919712907e-14, 0., 3.741995911329381e-17, 1.1909717396857748e-18, 1.9152190599713773e-20, 1.844370500361917e-22, 1.1218146386111079e-24, 4.413093606881877e-27, 1.137139742308537e-29, 1.933826423350626e-32, 2.1810905604105045e-35, 1.6369319077747972e-38, 8.194488572580659e-42, 2.7410134380239053e-45, 6.134497578333563e-49, 9.195533342895132e-53, 9.239813671961217e-57, 6.227689441356105e-61, 2.817116347395693e-65, 8.556436684269495e-70, 1.7456450246262842e-74, 2.3929469787942864e-79, 2.204668922283247e-84, 1.365492562829126e-89, 5.6866938884816986e-95, 1.5926946817578508e-100, 3.0003750296665244e-106, 3.802323696910932e-112, 3.2419520597295366e-118, 1.8599260956547872e-124, 7.180572040551983e-131, 1.8656707762228997e-137}, {-1.3036167602153424e-17, -5.647508517127621e-16, -1.597099404788756e-14, -2.9984489333278276e-13, -3.755783495376659e-12, -3.1446997831358557e-11, -1.7613566268378789e-10, -6.600029416663284e-10, -1.6539809005421898e-9, -2.7701071111619156e-9, -3.0972013516450468e-9, -2.3081525622554154e-9, -1.1439559866437653e-9, -3.758411807248064e-10, -8.146476973804146e-11, -1.1562581561262556e-11, -1.0611785173982202e-12, -6.1502141972038e-14, -2.1342862821387274e-15, -3.741995911329381e-17, 0., 1.4066653611672788e-20, 3.0161054998891304e-22, 3.2675990658296964e-24, 2.119973451865083e-26, 8.687228120161428e-29, 2.3024297118214245e-31, 3.997098729371467e-34, 4.5797366804322294e-37, 3.4801058713238964e-40, 1.7597399812162187e-43, 5.935289901249739e-47, 1.3376306935402458e-50, 2.0170263539369165e-54, 2.037132711498668e-58, 1.3791692203965737e-62, 6.263184100788759e-67, 1.9089242269910734e-71, 3.9065570557849397e-76, 5.370021367114086e-81, 4.959905632363328e-86, 3.078968781711812e-91, 1.2849139032809901e-96, 3.605524547522704e-102, 6.804028248096666e-108, 8.636446347780887e-114, 7.374549664792954e-120, 4.236632107062433e-126, 1.6377153125415037e-132, 4.260210755936707e-139}, {-2.178250067751436e-19, -9.460224471445393e-18, -2.6827561288482444e-16, -5.052291413764875e-15, -6.350349674612812e-14, -5.337969233900458e-13, -3.003161398803965e-12, -1.1310940207849958e-11, -2.851417091712072e-11, -4.808983368243176e-11, -5.421635012793125e-11, -4.081221385100221e-11, -2.0480001773100588e-11, -6.835408321580651e-12, -1.5124630586177324e-12, -2.2080261235320295e-13, -2.1108949189998248e-14, -1.3049597907019585e-15, -5.094623377454237e-17, -1.1909717396857748e-18, -1.4066653611672788e-20, 0., 2.3998532463673e-24, 3.466615353804836e-26, 2.530229050769905e-28, 1.1059598601902517e-30, 3.0533267810925297e-33, 5.4521304446139965e-36, 6.377004350736976e-39, 4.9227534563248645e-42, 2.5203401778587525e-45, 8.586524297743219e-49, 1.9512630325741884e-52, 2.962904259976833e-56, 3.010251567552949e-60, 2.0484364017869348e-64, 9.344038216725061e-69, 2.859090504162281e-73, 5.871360407482662e-78, 8.095861501050073e-83, 7.49834072597469e-88, 4.666423370596084e-93, 1.9518156427612e-98, 5.488219259890039e-104, 1.0376499137820444e-109, 1.3193938775244046e-115, 1.1284188114441474e-121, 6.49229864338626e-128, 2.513114607526192e-134, 6.545747823388156e-141}, {-2.446454708034945e-21, -1.064918766277569e-19, -3.027494272122372e-18, -5.717355908097265e-17, -7.20853420131998e-16, -6.080380321656256e-15, -3.4342597226188845e-14, -1.2992348750913015e-13, -3.292085997875275e-13, -5.585230758655356e-13, -6.340807635070203e-13, -4.812919286366896e-13, -2.4395696411140576e-13, -8.244090013188867e-14, -1.8531153892272875e-14, -2.7617015053544025e-15, -2.7156487750292764e-16, -1.748770758901508e-17, -7.282434051859364e-19, -1.9152190599713773e-20, -3.0161054998891304e-22, -2.3998532463673e-24, 0., 1.858238271029604e-28, 1.808399250852775e-30, 8.892551070768909e-33, 2.61871969030929e-35, 4.87091702655904e-38, 5.859973653002867e-41, 4.617871869561608e-44, 2.4017753323674064e-47, 8.284869126256857e-51, 1.90173006017892e-54, 2.9117547810079886e-58, 2.978972023948849e-62, 2.0392174613326396e-66, 9.3496880799361e-71, 2.8735907648402204e-75, 5.924279515548664e-80, 8.197194234710438e-85, 7.615699771879422e-90, 4.752624292293459e-95, 1.992852863373358e-100, 5.616345381226001e-106, 1.0640730377539662e-111, 1.3555539239689503e-117, 1.1613611404096785e-123, 6.692538672901044e-130, 2.5944638155835682e-136, 6.7669153310676895e-143}, {-1.8472837121203765e-23, -8.057695328340514e-22, -2.2959562319783916e-20, -4.346729337935551e-19, -5.4956496031168784e-18, -4.6499181051615204e-17, -2.6354394993200514e-16, -1.000938441661335e-15, -2.5475655684561476e-15, -4.344269708435215e-15, -4.9613248014036035e-15, -3.792172766472718e-15, -1.9381923761588556e-15, -6.615934412084552e-16, -1.5057260384964082e-16, -2.2796053063612392e-17, -2.2882915956477973e-18, -1.5156715700685958e-19, -6.574724343941978e-21, -1.844370500361917e-22, -3.2675990658296964e-24, -3.466615353804836e-26, -1.858238271029604e-28, 0., 6.530633298416191e-33, 4.2817971089252497e-35, 1.4185389095373177e-37, 2.8144380539833403e-40, 3.5269994580470058e-43, 2.8588150812658278e-46, 1.5178589251562772e-49, 5.3189279267287305e-53, 1.236181831503437e-56, 1.9118467964724504e-60, 1.972281219981725e-64, 1.3595413171912898e-68, 6.2705179384155e-73, 1.9371028115207168e-77, 4.011416836097164e-82, 5.572207273175317e-87, 5.194900176421468e-92, 3.2519462839134393e-97, 1.3673818653862251e-102, 3.8632737548988066e-108, 7.335995028830348e-114, 9.364888671276651e-120, 8.038497113943854e-126, 4.640375210515294e-132, 1.8017944894546126e-138, 4.706426729944851e-145}, {-9.379510961257388e-26, -4.099009453717661e-24, -1.1703881431022202e-22, -2.2208274662560912e-21, -2.8148700615968316e-20, -2.388302440826145e-19, -1.3578117325318788e-18, -5.174867449822839e-18, -1.3222604764434325e-17, -2.2648681574744602e-17, -2.5998318845164363e-17, -1.9990016094769503e-17, -1.028841240466146e-17, -3.541170183375696e-18, -8.140786662943509e-19, -1.2478865510952416e-19, -1.2725247415612894e-20, -8.604285585115642e-22, -3.8390318712660147e-23, -1.1218146386111079e-24, -2.119973451865083e-26, -2.530229050769905e-28, -1.808399250852775e-30, -6.530633298416191e-33, 0., 1.0417392113813375e-37, 4.601642931203931e-40, 1.0271074519365143e-42, 1.372961320865775e-45, 1.1592250062616286e-48, 6.330638892792176e-52, 2.264618657761876e-55, 5.346785436174293e-59, 8.372564841518859e-63, 8.724470464826939e-67, 6.0641058335252874e-71, 2.816464171156086e-75, 8.752475638062446e-80, 1.821786552724424e-84, 2.541917562332272e-89, 2.3790917473400086e-94, 1.4944545170154622e-99, 6.303353194346349e-105, 1.785837801174676e-110, 3.399637818563108e-116, 4.3497285519297155e-122, 3.7413869535364074e-128, 2.1638772197524185e-134, 8.416652755166861e-141, 2.2020181036822425e-147}, {-3.2029488085785994e-28, -1.402177895015143e-26, -4.0112142472056117e-25, -7.62709220414504e-24, -9.689211626230799e-23, -8.2415046452157035e-22, -4.698523933198089e-21, -1.7962368611314106e-20, -4.6056056152858814e-20, -7.919767643257824e-20, -9.131650466792522e-20, -7.057300623732762e-20, -3.653854599529674e-20, -1.2664153043779836e-20, -2.9356200789014248e-21, -4.545413372630712e-22, -4.69309718850023e-23, -3.2236475575281918e-24, -1.4682814018475656e-25, -4.413093606881877e-27, -8.687228120161428e-29, -1.1059598601902517e-30, -8.892551070768909e-33, -4.2817971089252497e-35, -1.0417392113813375e-37, 0., 7.542645750724415e-43, 2.2447367237334226e-45, 3.3756728936466503e-48, 3.0401745457725575e-51, 1.7294463179768717e-54, 6.3633979247407146e-58, 1.5337041757252752e-61, 2.4397582078567e-65, 2.5740819944700807e-69, 1.8072360352794027e-73, 8.463625931455472e-78, 2.648558652773788e-82, 5.545664589764951e-87, 7.777482254808942e-92, 7.311782386857251e-97, 4.610993965698429e-102, 1.9515911919494853e-107, 5.546278919349331e-113, 1.0587588356189268e-118, 1.3580433924108693e-124, 1.1707658120547172e-130, 6.785287442741673e-137, 2.6442151839902353e-143, 6.929994800302856e-150}, {-7.35711376771639e-31, -3.225936336412317e-29, -9.244494616997508e-28, -1.761116397938895e-26, -2.2418974177684085e-25, -1.911259758572223e-24, -1.0923498343255322e-23, -4.187632959415942e-23, -1.0770459666790185e-22, -1.8585116502216414e-22, -2.151304631672486e-22, -1.670035681012673e-22, -8.690801958962215e-23, -3.030136309787853e-23, -7.073141061788572e-24, -1.1043073926637602e-24, -1.151704192105552e-25, -8.009842668846977e-27, -3.706168442714716e-28, -1.137139742308537e-29, -2.3024297118214245e-31, -3.0533267810925297e-33, -2.61871969030929e-35, -1.4185389095373177e-37, -4.601642931203931e-40, -7.542645750724415e-43, 0., 2.4789018125479252e-48, 4.970419064386358e-51, 5.035976454808945e-54, 3.0557722459010854e-57, 1.1712018372298553e-60, 2.9034792016266305e-64, 4.714968002464749e-68, 5.05351737631839e-72, 3.5923719450666916e-76, 1.699368971983336e-80, 5.362223888100938e-85, 1.130616715681504e-89, 1.5950645188976886e-94, 1.5072453167530568e-99, 9.547501588688644e-105, 4.0568020750272266e-110, 1.1569165439414634e-115, 2.215337305098371e-121, 2.8494507902010295e-127, 2.46266105222663e-133, 1.4305030009059563e-139, 5.586188013760306e-146, 1.4668084801257464e-152}, {-1.1368673713955708e-33, -4.992301855010839e-32, -1.4329256136914767e-30, -2.734533017266439e-29, -3.487647604307588e-28, -2.979441117369689e-27, -1.7067218604566568e-26, -6.559288136020738e-26, -1.691714374454745e-25, -2.928198922697354e-25, -3.4012813355817883e-25, -2.6507341832083324e-25, -1.3855901326682921e-25, -4.855774989414149e-26, -1.1402133738253327e-26, -1.7926282878304357e-27, -1.8851475055113424e-28, -1.3243207419301178e-29, -6.204251311794469e-31, -1.933826423350626e-32, -3.997098729371467e-34, -5.4521304446139965e-36, -4.87091702655904e-38, -2.8144380539833403e-40, -1.0271074519365143e-42, -2.2447367237334226e-45, -2.4789018125479252e-48, 0., 3.698066492484153e-54, 4.9957895684374766e-57, 3.410310721745448e-60, 1.3942268332999258e-63, 3.600386945269135e-67, 6.013726393408235e-71, 6.579812549769227e-75, 4.751606618275313e-79, 2.2758409039665998e-83, 7.253773037100261e-88, 1.5421923556602197e-92, 2.1909267265860787e-97, 2.0826244595489446e-102, 1.3259838082485375e-107, 5.6593532252863e-113, 1.620260325437715e-118, 3.113350255536689e-124, 4.016906937434312e-130, 3.481287992634861e-136, 2.027268064857091e-142, 7.934578615510733e-149, 2.0877570641956557e-155}, {-1.1819740705555364e-36, -5.197505273313314e-35, -1.4940346532023741e-33, -2.8557200066575774e-32, -3.6485448420320948e-31, -3.1227962399305167e-30, -1.7925439926406707e-29, -6.904777584736011e-29, -1.7852832071217279e-28, -3.0987415682346373e-28, -3.6105205841145813e-28, -2.8235715873066897e-28, -1.481723576352304e-28, -5.215854439825069e-29, -1.2310466189347359e-29, -1.9469555536843082e-30, -2.061757505934325e-31, -1.4604596141536228e-32, -6.9111537940555735e-34, -2.1810905604105045e-35, -4.5797366804322294e-37, -6.377004350736976e-39, -5.859973653002867e-41, -3.5269994580470058e-43, -1.372961320865775e-45, -3.3756728936466503e-48, -4.970419064386358e-51, -3.698066492484153e-54, 0., 2.504250832660204e-60, 2.2793256461446422e-63, 1.0483308975623747e-66, 2.8876386827987758e-70, 5.02419057814501e-74, 5.654190249877484e-78, 4.1682352044143295e-82, 2.0281172644589587e-86, 6.545007641861579e-91, 1.405560509005779e-95, 2.0134598694254046e-100, 1.9273143017111324e-105, 1.2344037238143442e-110, 5.295503547705477e-116, 1.5228592298271934e-121, 2.9376681116757547e-127, 3.803398861842626e-133, 3.306454433224187e-139, 1.9308052456581294e-145, 7.575970136832592e-152, 1.9979299693803415e-158}, {-8.268895858465851e-40, -3.640731332543272e-38, -1.047974010743701e-36, -2.0060806503315237e-35, -2.5671301108246196e-34, -2.201032619967267e-33, -1.2658271420336368e-32, -4.8859892299501083e-32, -1.266181152099407e-31, -2.2032368071449814e-31, -2.5742477787659465e-31, -2.0193974909105494e-31, -1.063397305208197e-31, -3.7579726240076404e-32, -8.909168001759792e-33, -1.4162507281851736e-33, -1.508686888613102e-34, -1.076161716646653e-35, -5.135026250936679e-37, -1.6369319077747972e-38, -3.4801058713238964e-40, -4.9227534563248645e-42, -4.617871869561608e-44, -2.8588150812658278e-46, -1.1592250062616286e-48, -3.0401745457725575e-51, -5.035976454808945e-54, -4.9957895684374766e-57, -2.504250832660204e-60, 0., 7.697962779484967e-67, 4.720701635982686e-70, 1.462862610596145e-73, 2.7149105005170487e-77, 3.1826479149878653e-81, 2.413264104594926e-85, 1.1986724964520098e-89, 3.9296788643481775e-94, 8.544594977771276e-99, 1.2363735865984647e-103, 1.1933378308945572e-108, 7.696522484266619e-114, 3.3214063028537805e-119, 9.600546644256813e-125, 1.8602590710664513e-130, 2.4179224018780272e-136, 2.1093001511959283e-142, 1.2355399706266936e-148, 4.861399196639388e-155, 1.2852582133811078e-161}, {-3.892866428117247e-43, -1.716038995346544e-41, -4.9458772574479425e-40, -9.480633535519531e-39, -1.2150097824010808e-37, -1.0434071309169045e-36, -6.011133370495617e-36, -2.324642722644431e-35, -6.036674861012259e-35, -1.0528076497446536e-34, -1.2331766587789298e-34, -9.700664009691728e-35, -5.124101144510714e-35, -1.8171095267153123e-35, -4.3247840506244686e-36, -6.905608036592417e-37, -7.394049505617697e-38, -5.305645136476976e-39, -2.549351876868715e-40, -8.194488572580659e-42, -1.7597399812162187e-43, -2.5203401778587525e-45, -2.4017753323674064e-47, -1.5178589251562772e-49, -6.330638892792176e-52, -1.7294463179768717e-54, -3.0557722459010854e-57, -3.410310721745448e-60, -2.2793256461446422e-63, -7.697962779484967e-67, 0., 1.074175175102388e-73, 4.438240533032531e-77, 9.266491574212177e-81, 1.158716358708294e-84, 9.152129605630619e-89, 4.675761013220258e-93, 1.5648174071321394e-97, 3.4565075803198714e-102, 5.0639660146194417e-107, 4.937069923083883e-112, 3.210735545686573e-117, 1.3952706337977492e-122, 4.057045077575153e-128, 7.901485766252217e-134, 1.0316020343872521e-139, 9.034580660324596e-146, 5.31045545833949e-152, 2.0959395055042454e-158, 5.55664366963065e-165}, {-1.2334196112909043e-46, -5.443160737635363e-45, -1.5706667519739993e-43, -3.014618616334519e-42, -3.8687524433696393e-41, -3.327268815564979e-40, -1.9199321483032986e-39, -7.437729346381482e-39, -1.935101235394064e-38, -3.3818408662036443e-38, -3.9702270582360386e-38, -3.1309678439730033e-38, -1.6584391424444383e-38, -5.899367331580094e-39, -1.4089452437536329e-39, -2.2585587790524885e-40, -2.429105219894418e-41, -1.751957765693264e-42, -8.468229894468974e-44, -2.7410134380239053e-45, -5.935289901249739e-47, -8.586524297743219e-49, -8.284869126256857e-51, -5.3189279267287305e-53, -2.264618657761876e-55, -6.3633979247407146e-58, -1.1712018372298553e-60, -1.3942268332999258e-63, -1.0483308975623747e-66, -4.720701635982686e-70, -1.074175175102388e-73, 0., 6.804270800388668e-81, 1.8941956111116243e-84, 2.6646437344297503e-88, 2.2449821824114686e-92, 1.1947356125721247e-96, 4.1126109625946135e-101, 9.273556377540376e-106, 1.380190423799611e-110, 1.3624247906522151e-115, 8.949784966971152e-121, 3.9216663591811725e-126, 1.1482817877280933e-131, 2.249701141139228e-137, 2.9522267866118487e-143, 2.597048294952346e-149, 1.532510933736475e-155, 6.069541842568524e-162, 1.6141065569721063e-168}, {-2.630298336706634e-50, -1.1619764517486636e-48, -3.3567039208832295e-47, -6.450272638722789e-46, -8.288404469042844e-45, -7.138123115710216e-44, -4.12500945559373e-43, -1.600570713074946e-42, -4.171505536047736e-42, -7.304055279735586e-42, -8.592597313818563e-42, -6.791624006293395e-42, -3.606464507627556e-42, -1.286448080054773e-42, -3.0819346630033132e-43, -4.957538147060714e-44, -5.352797071127591e-45, -3.877864091886563e-46, -1.8840093398217986e-47, -6.134497578333563e-49, -1.3376306935402458e-50, -1.9512630325741884e-52, -1.90173006017892e-54, -1.236181831503437e-56, -5.346785436174293e-59, -1.5337041757252752e-61, -2.9034792016266305e-64, -3.600386945269135e-67, -2.8876386827987758e-70, -1.462862610596145e-73, -4.438240533032531e-77, -6.804270800388668e-81, 0., 1.9565932851517e-88, 3.6698948496645434e-92, 3.4784029465787623e-96, 1.9745472227915263e-100, 7.080144333783646e-105, 1.6421213791677977e-109, 2.494897979011448e-114, 2.501875783075308e-119, 1.664028800455912e-124, 7.365185440451155e-130, 2.1745312050194386e-135, 4.290110226644123e-141, 5.663315563276266e-147, 5.007518136236519e-153, 2.9681140619605686e-159, 1.1801377410097621e-165, 3.149302271411641e-172}, {-3.7755684796245394e-54, -1.6695477789135235e-52, -4.827993933497161e-51, -9.287836663361026e-50, -1.1948795916975039e-48, -1.0303660539970226e-47, -5.962502928353084e-47, -2.316975524107207e-46, -6.0483209965917306e-46, -1.06086640812618e-45, -1.2503824093430334e-45, -9.903535475267832e-46, -5.2708930277048464e-46, -1.8848721546005725e-46, -4.52811829467881e-47, -7.30639065479634e-48, -7.916313026255504e-49, -5.757507979973842e-50, -2.8096971799103987e-51, -9.195533342895132e-53, -2.0170263539369165e-54, -2.962904259976833e-56, -2.9117547810079886e-58, -1.9118467964724504e-60, -8.372564841518859e-63, -2.4397582078567e-65, -4.714968002464749e-68, -6.013726393408235e-71, -5.02419057814501e-74, -2.7149105005170487e-77, -9.266491574212177e-81, -1.8941956111116243e-84, -1.9565932851517e-88, 0., 2.5540939365165534e-96, 3.227764732071351e-100, 2.061303918377289e-104, 7.883976823687708e-109, 1.9047467885626422e-113, 2.9765915349254733e-118, 3.047102315232575e-123, 2.0588350679901962e-128, 9.226552051673207e-134, 2.751605696433141e-139, 5.473853004102237e-145, 7.276489314748498e-151, 6.472187469157002e-157, 3.855942986461073e-163, 1.5399875739165737e-169, 4.125709531608434e-176}, {-3.648131851972739e-58, -1.614677822566681e-56, -4.673885476937363e-55, -9.000737063547793e-54, -1.1592322824445263e-52, -1.0008167731632674e-51, -5.798904266600124e-51, -2.256497874644827e-50, -5.899174430546125e-50, -1.0363645079216028e-49, -1.2236277781962618e-49, -9.709983308620158e-50, -5.178579585857813e-50, -1.8560696283141586e-50, -4.470099861412177e-51, -7.232809914871878e-52, -7.860851806728127e-53, -5.737022509517335e-54, -2.81067936817762e-55, -9.239813671961217e-57, -2.037132711498668e-58, -3.010251567552949e-60, -2.978972023948849e-62, -1.972281219981725e-64, -8.724470464826939e-67, -2.5740819944700807e-69, -5.05351737631839e-72, -6.579812549769227e-75, -5.654190249877484e-78, -3.1826479149878653e-81, -1.158716358708294e-84, -2.6646437344297503e-88, -3.6698948496645434e-92, -2.5540939365165534e-96, 0., 1.5135436240188117e-104, 1.2887653063540044e-108, 5.545359022688291e-113, 1.429059474405617e-117, 2.3262750504659093e-122, 2.449420307210708e-127, 1.689478527795478e-132, 7.69148115452836e-138, 2.3224788936087456e-143, 4.666846451948349e-149, 6.2554189529184185e-155, 5.6028893861374735e-161, 3.3579094990920454e-167, 1.3479601701137229e-173, 3.6273794760780603e-180}, {-2.372983876477069e-62, -1.0512012479975449e-60, -3.045629277035151e-59, -5.870855209836015e-58, -7.569129163298215e-57, -6.542034685412215e-56, -3.795079831404955e-55, -1.478645977838704e-54, -3.870942001580247e-54, -6.810529540104242e-54, -8.054027438019248e-54, -6.402312955267421e-54, -3.4209822471938674e-54, -1.2286626619281305e-54, -2.9657977725441096e-55, -4.810812786157749e-56, -5.243070713927728e-57, -3.838355077637981e-58, -1.8870145756113433e-59, -6.227689441356105e-61, -1.3791692203965737e-62, -2.0484364017869348e-64, -2.0392174613326396e-66, -1.3595413171912898e-68, -6.0641058335252874e-71, -1.8072360352794027e-73, -3.5923719450666916e-76, -4.751606618275313e-79, -4.1682352044143295e-82, -2.413264104594926e-85, -9.152129605630619e-89, -2.2449821824114686e-92, -3.4784029465787623e-96, -3.227764732071351e-100, -1.5135436240188117e-104, 0., 4.071728866636798e-113, 2.3360031287023253e-117, 6.772462005366678e-122, 1.1759424283716353e-126, 1.2897842767575605e-131, 9.150417234593464e-137, 4.252585397584892e-142, 1.3044705045830192e-147, 2.654000691791747e-153, 3.593343432583137e-159, 3.245327261603907e-165, 1.9585825961205974e-171, 7.909105827624491e-178, 2.139265948086723e-184}, {-1.0391500386804039e-66, -4.607060261120697e-65, -1.3359521817481253e-63, -2.577592319698014e-62, -3.326466074387717e-61, -2.878075478560826e-60, -1.6714487720699922e-59, -6.52008219378919e-59, -1.7090699149183983e-58, -3.01106544509256e-58, -3.566114981020845e-58, -2.8393214544630784e-58, -1.5197883949570894e-58, -5.468732915000452e-59, -1.3227988799917392e-59, -2.150585203347815e-60, -2.3496923753323416e-61, -1.7249445605939337e-62, -8.50643790752934e-64, -2.817116347395693e-65, -6.263184100788759e-67, -9.344038216725061e-69, -9.3496880799361e-71, -6.2705179384155e-73, -2.816464171156086e-75, -8.463625931455472e-78, -1.699368971983336e-80, -2.2758409039665998e-83, -2.0281172644589587e-86, -1.1986724964520098e-89, -4.675761013220258e-93, -1.1947356125721247e-96, -1.9745472227915263e-100, -2.061303918377289e-104, -1.2887653063540044e-108, -4.071728866636798e-113, 0., 4.972700720399829e-122, 1.922224976452294e-126, 3.754881375497621e-131, 4.392946994556863e-136, 3.246448732262539e-141, 1.5518693356652537e-146, 4.859495837917213e-152, 1.004378498935076e-157, 1.3768611120995142e-163, 1.2560725091366409e-169, 7.643675261479645e-176, 3.1082373738951794e-182, 8.45724657252083e-189}, {-3.063671278715251e-71, -1.35932380622072e-69, -3.944978261012609e-68, -7.618049314674247e-67, -9.840374652176008e-66, -8.522265054752387e-65, -4.954480040138884e-64, -1.9348214831849134e-63, -5.077668794139806e-63, -8.957339510766949e-63, -1.062307705236241e-62, -8.470566900437713e-63, -4.541261016239932e-63, -1.6369472805504957e-63, -3.967012301656006e-64, -6.46285798737743e-65, -7.07725559098685e-66, -5.2085412704926795e-67, -2.575688895320689e-68, -8.556436684269495e-70, -1.9089242269910734e-71, -2.859090504162281e-73, -2.8735907648402204e-75, -1.9371028115207168e-77, -8.752475638062446e-80, -2.648558652773788e-82, -5.362223888100938e-85, -7.253773037100261e-88, -6.545007641861579e-91, -3.9296788643481775e-94, -1.5648174071321394e-97, -4.1126109625946135e-101, -7.080144333783646e-105, -7.883976823687708e-109, -5.545359022688291e-113, -2.3360031287023253e-117, -4.972700720399829e-122, 0., 2.757012872256441e-131, 7.180745516513746e-136, 9.451087848327701e-141, 7.4501172785613805e-146, 3.709697344572109e-151, 1.1948379233386215e-156, 2.520983676302823e-162, 3.510768434954155e-168, 3.242812164798442e-174, 1.9933066529583156e-180, 8.173163573739524e-187, 2.239398896903849e-193}, {-6.08143459414784e-76, -2.7002504324825198e-74, -7.84261632131271e-73, -1.515705425173734e-71, -1.9595597434357572e-70, -1.698638240548415e-69, -9.884808628056573e-69, -3.864232404791351e-68, -1.015241879029826e-67, -1.793085094032266e-67, -2.129249220000495e-67, -1.7001404141657474e-67, -9.128337773035928e-68, -3.295682438574704e-68, -8.000715933439802e-69, -1.3059052453019535e-69, -1.4330131125455157e-70, -1.05702998412395e-71, -5.240246280367085e-73, -1.7456450246262842e-74, -3.9065570557849397e-76, -5.871360407482662e-78, -5.924279515548664e-80, -4.011416836097164e-82, -1.821786552724424e-84, -5.545664589764951e-87, -1.130616715681504e-89, -1.5421923556602197e-92, -1.405560509005779e-95, -8.544594977771276e-99, -3.4565075803198714e-102, -9.273556377540376e-106, -1.6421213791677977e-109, -1.9047467885626422e-113, -1.429059474405617e-117, -6.772462005366678e-122, -1.922224976452294e-126, -2.757012872256441e-131, 0., 6.939392272676689e-141, 1.217790099598001e-145, 1.0799565202768239e-150, 5.73601613430048e-156, 1.9244633752974147e-161, 4.1764293779361396e-167, 5.937342962807817e-173, 5.571231040662705e-179, 3.467356718748228e-185, 1.436082545430253e-191, 3.9675718213763725e-198}, {-8.12807862591517e-81, -3.611492049875889e-79, -1.0496897064890998e-77, -2.0302522841972313e-76, -2.6269292873972873e-75, -2.2791169988948966e-74, -1.3274952431356918e-73, -5.1946018860365614e-73, -1.3661887652382106e-72, -2.4155993460318475e-72, -2.8718860868637967e-72, -2.296041875885327e-72, -1.234476606008455e-72, -4.4635401267261575e-73, -1.0853213946633933e-73, -1.7745809628694884e-74, -1.950994593155131e-75, -1.44208692490696e-76, -7.165421520138888e-78, -2.3929469787942864e-79, -5.370021367114086e-81, -8.095861501050073e-83, -8.197194234710438e-85, -5.572207273175317e-87, -2.541917562332272e-89, -7.777482254808942e-92, -1.5950645188976886e-94, -2.1909267265860787e-97, -2.0134598694254046e-100, -1.2363735865984647e-103, -5.0639660146194417e-107, -1.380190423799611e-110, -2.494897979011448e-114, -2.9765915349254733e-118, -2.3262750504659093e-122, -1.1759424283716353e-126, -3.754881375497621e-131, -7.180745516513746e-136, -6.939392272676689e-141, 0., 7.929452275812405e-151, 9.375960263665964e-156, 5.602377561441823e-161, 2.0049353984411066e-166, 4.5323625484361026e-172, 6.627444396570456e-178, 6.348336931859155e-184, 4.0137169974960834e-190, 1.6831493720778107e-196, 4.697133008516056e-203}, {-7.314832396927862e-86, -3.2522856191469024e-84, -9.459404916816914e-83, -1.8309236574992275e-81, -2.3708487244577437e-80, -2.0586226786381446e-79, -1.2001042006459786e-78, -4.700426170411877e-78, -1.2374281722808243e-77, -2.1902129761671377e-77, -2.6068225650655426e-77, -2.0866075589733604e-77, -1.1233061499691293e-77, -4.0671563204565094e-78, -9.904047366563507e-79, -1.621980357003084e-79, -1.786325001600031e-80, -1.3228713156980389e-81, -6.586673483355514e-83, -2.204668922283247e-84, -4.959905632363328e-86, -7.49834072597469e-88, -7.615699771879422e-90, -5.194900176421468e-92, -2.3790917473400086e-94, -7.311782386857251e-97, -1.5072453167530568e-99, -2.0826244595489446e-102, -1.9273143017111324e-105, -1.1933378308945572e-108, -4.937069923083883e-112, -1.3624247906522151e-115, -2.501875783075308e-119, -3.047102315232575e-123, -2.449420307210708e-127, -1.2897842767575605e-131, -4.392946994556863e-136, -9.451087848327701e-141, -1.217790099598001e-145, -7.929452275812405e-151, 0., 4.113455161006664e-161, 3.2771937658945434e-166, 1.319418752364341e-171, 3.1815271553428192e-177, 4.8460272496039465e-183, 4.774569110511556e-189, 3.0815967388177943e-195, 1.3127775529223996e-201, 3.7093376945338005e-208}, {-4.4327262077546476e-91, -1.9720895688365774e-89, -5.73967628895368e-88, -1.1117181130948763e-86, -1.4406073962611315e-85, -1.2518542902931572e-84, -7.303829996042982e-84, -2.863154511672656e-83, -7.544431742676019e-83, -1.3366484680133505e-82, -1.592555160104724e-82, -1.2761643430806299e-82, -6.878293065148555e-83, -2.4936052564929827e-83, -6.0805896749197875e-84, -9.972900876760463e-85, -1.10009911797989e-85, -8.161003762881665e-87, -4.0711196175996477e-88, -1.365492562829126e-89, -3.078968781711812e-91, -4.666423370596084e-93, -4.752624292293459e-95, -3.2519462839134393e-97, -1.4944545170154622e-99, -4.610993965698429e-102, -9.547501588688644e-105, -1.3259838082485375e-107, -1.2344037238143442e-110, -7.696522484266619e-114, -3.210735545686573e-117, -8.949784966971152e-121, -1.664028800455912e-124, -2.0588350679901962e-128, -1.689478527795478e-132, -9.150417234593464e-137, -3.246448732262539e-141, -7.4501172785613805e-146, -1.0799565202768239e-150, -9.375960263665964e-156, -4.113455161006664e-161, 0., 9.687566510453891e-172, 5.200366668048054e-177, 1.4107156056632688e-182, 2.292020046202949e-188, 2.3523151778105642e-194, 1.561606431682467e-200, 6.791125682590415e-207, 1.9493347428045975e-213}, {-1.8088467886310542e-96, -8.0522241922736e-95, -2.345028582237719e-93, -4.54507494485563e-92, -5.893765734143386e-91, -5.125289036862994e-90, -2.992612386697331e-89, -1.1740842702975379e-88, -3.096398636886524e-88, -5.490937789012535e-88, -6.548594889452299e-88, -5.25306049038082e-88, -2.834453192585509e-88, -1.0288049095596486e-88, -2.5119172113338977e-89, -4.125506497543416e-90, -4.55754024707126e-91, -3.386395683027778e-92, -1.6922426070739197e-93, -5.6866938884816986e-95, -1.2849139032809901e-96, -1.9518156427612e-98, -1.992852863373358e-100, -1.3673818653862251e-102, -6.303353194346349e-105, -1.9515911919494853e-107, -4.0568020750272266e-110, -5.6593532252863e-113, -5.295503547705477e-116, -3.3214063028537805e-119, -1.3952706337977492e-122, -3.9216663591811725e-126, -7.365185440451155e-130, -9.226552051673207e-134, -7.69148115452836e-138, -4.252585397584892e-142, -1.5518693356652537e-146, -3.709697344572109e-151, -5.73601613430048e-156, -5.602377561441823e-161, -3.2771937658945434e-166, -9.687566510453891e-172, 0., 1.0357843077060619e-182, 3.746395027514534e-188, 6.847704830289864e-194, 7.4963672478718e-200, 5.183889072949664e-206, 2.3187842141667467e-212, 6.79453645368994e-219}, {-4.970617023023071e-102, -2.2139640519719636e-100, -6.451508577034176e-99, -1.2511970341122332e-97, -1.623540598149703e-96, -1.4128286977377917e-95, -8.255416054676129e-95, -3.241328137069344e-94, -8.555300491291775e-94, -1.518450970897261e-93, -1.8125974285473017e-93, -1.4554254319732834e-93, -7.861383842848011e-94, -2.856574519847865e-94, -6.982879719623884e-95, -1.1483144127247627e-95, -1.270311418520707e-96, -9.45279662568993e-98, -4.731301951246354e-99, -1.5926946817578508e-100, -3.605524547522704e-102, -5.488219259890039e-104, -5.616345381226001e-106, -3.8632737548988066e-108, -1.785837801174676e-110, -5.546278919349331e-113, -1.1569165439414634e-115, -1.620260325437715e-118, -1.5228592298271934e-121, -9.600546644256813e-125, -4.057045077575153e-128, -1.1482817877280933e-131, -2.1745312050194386e-135, -2.751605696433141e-139, -2.3224788936087456e-143, -1.3044705045830192e-147, -4.859495837917213e-152, -1.1948379233386215e-156, -1.9244633752974147e-161, -2.0049353984411066e-166, -1.319418752364341e-171, -5.200366668048054e-177, -1.0357843077060619e-182, 0., 5.0277404045184556e-194, 1.2253017278606052e-199, 1.5090422214861183e-205, 1.113101991784432e-211, 5.186428107244625e-218, 1.5631559805688242e-224}, {-9.19832704846564e-108, -4.0992459453586574e-106, -1.1952010286502764e-104, -2.3193367914386577e-103, -3.0114300719154044e-102, -2.622314424132346e-101, -1.5333280614006714e-100, -6.024714455266621e-100, -1.5914169158252676e-99, -2.8268589966642755e-99, -3.377385093900984e-99, -2.7143644993065867e-99, -1.467579145972558e-99, -5.338266397343296e-100, -1.3063876429128347e-100, -2.1508742878225782e-101, -2.3824221305921497e-102, -1.77527229718984e-103, -8.898734519737133e-105, -3.0003750296665244e-106, -6.804028248096666e-108, -1.0376499137820444e-109, -1.0640730377539662e-111, -7.335995028830348e-114, -3.399637818563108e-116, -1.0587588356189268e-118, -2.215337305098371e-121, -3.113350255536689e-124, -2.9376681116757547e-127, -1.8602590710664513e-130, -7.901485766252217e-134, -2.249701141139228e-137, -4.290110226644123e-141, -5.473853004102237e-145, -4.666846451948349e-149, -2.654000691791747e-153, -1.004378498935076e-157, -2.520983676302823e-162, -4.1764293779361396e-167, -4.5323625484361026e-172, -3.1815271553428192e-177, -1.4107156056632688e-182, -3.746395027514534e-188, -5.0277404045184556e-194, 0., 1.1079682001140713e-205, 1.8193840271004372e-211, 1.5097688785611759e-217, 7.503650451926677e-224, 2.355783176921868e-230}, {-1.1463281644925468e-113, -5.111265036045633e-112, -1.4910778811501782e-110, -2.8951392376163833e-109, -3.761290289382802e-108, -3.2773313516749116e-107, -1.9175923948175758e-106, -7.539777762770578e-106, -1.993073880921888e-105, -3.543062450566491e-105, -4.2365263704831014e-105, -3.4077941121231465e-105, -1.8441901491621614e-105, -6.714732741896083e-106, -1.6449500215188195e-106, -2.7113057130458858e-107, -3.006760841881522e-108, -2.243362457248429e-109, -1.1260531014290406e-110, -3.802323696910932e-112, -8.636446347780887e-114, -1.3193938775244046e-115, -1.3555539239689503e-117, -9.364888671276651e-120, -4.3497285519297155e-122, -1.3580433924108693e-124, -2.8494507902010295e-127, -4.016906937434312e-130, -3.803398861842626e-133, -2.4179224018780272e-136, -1.0316020343872521e-139, -2.9522267866118487e-143, -5.663315563276266e-147, -7.276489314748498e-151, -6.2554189529184185e-155, -3.593343432583137e-159, -1.3768611120995142e-163, -3.510768434954155e-168, -5.937342962807817e-173, -6.627444396570456e-178, -4.8460272496039465e-183, -2.292020046202949e-188, -6.847704830289864e-194, -1.2253017278606052e-199, -1.1079682001140713e-205, 0., 1.1084971640762687e-217, 1.2264770166658052e-223, 6.857630210788775e-230, 2.2964950175654717e-236}, {-9.621027096592971e-120, -4.291956627534581e-118, -1.252713145760527e-116, -2.4336364789403456e-115, -3.1635111719794532e-114, -2.7581082290729995e-113, -1.6148001050706718e-112, -6.353406479278706e-112, -1.680630947290129e-111, -2.9898205094632832e-111, -3.577762078240079e-111, -2.8802458637030945e-111, -1.5600472818403992e-111, -5.685383690314248e-112, -1.3941454249478194e-112, -2.3003081300560385e-113, -2.5538137947867527e-114, -1.907684277038697e-115, -9.587827776987773e-117, -3.2419520597295366e-118, -7.374549664792954e-120, -1.1284188114441474e-121, -1.1613611404096785e-123, -8.038497113943854e-126, -3.7413869535364074e-128, -1.1707658120547172e-130, -2.46266105222663e-133, -3.481287992634861e-136, -3.306454433224187e-139, -2.1093001511959283e-142, -9.034580660324596e-146, -2.597048294952346e-149, -5.007518136236519e-153, -6.472187469157002e-157, -5.6028893861374735e-161, -3.245327261603907e-165, -1.2560725091366409e-169, -3.242812164798442e-174, -5.571231040662705e-179, -6.348336931859155e-184, -4.774569110511556e-189, -2.3523151778105642e-194, -7.4963672478718e-200, -1.5090422214861183e-205, -1.8193840271004372e-211, -1.1084971640762687e-217, 0., 5.03496556466563e-230, 3.7536164148591877e-236, 1.4141447221288216e-242}, {-5.43821488410152e-126, -2.4271436161974785e-124, -7.087715951195488e-123, -1.3776368773855334e-121, -1.791774575695969e-120, -1.5630453181271504e-119, -9.156667971518151e-119, -3.6049301827693705e-118, -9.542193059216768e-118, -1.6987200839396967e-117, -2.0342555616919605e-117, -1.638924133009839e-117, -8.884269427402402e-118, -3.2405564311501753e-118, -7.95365724664404e-119, -1.3136181218198554e-119, -1.4599046768809232e-120, -1.0917534910612244e-121, -5.493574558325493e-123, -1.8599260956547872e-124, -4.236632107062433e-126, -6.49229864338626e-128, -6.692538672901044e-130, -4.640375210515294e-132, -2.1638772197524185e-134, -6.785287442741673e-137, -1.4305030009059563e-139, -2.027268064857091e-142, -1.9308052456581294e-145, -1.2355399706266936e-148, -5.31045545833949e-152, -1.532510933736475e-155, -2.9681140619605686e-159, -3.855942986461073e-163, -3.3579094990920454e-167, -1.9585825961205974e-171, -7.643675261479645e-176, -1.9933066529583156e-180, -3.467356718748228e-185, -4.0137169974960834e-190, -3.0815967388177943e-195, -1.561606431682467e-200, -5.183889072949664e-206, -1.113101991784432e-211, -1.5097688785611759e-217, -1.2264770166658052e-223, -5.03496556466563e-230, 0., 1.038280568367683e-242, 5.215517778299332e-249}, {-2.0702519293308856e-132, -9.243977724488342e-131, -2.7006917115530735e-129, -5.251918600342586e-128, -6.834251867635011e-127, -5.965050495412531e-126, -3.4964416872919176e-125, -1.3773493639670144e-124, -3.6481020005474767e-124, -6.498695991898859e-124, -7.787727987304489e-124, -6.2788695878205555e-124, -3.406273896367981e-124, -1.2434608188409226e-124, -3.054606264852956e-125, -5.049594241649919e-126, -5.6174106547267766e-127, -4.205217061376297e-128, -2.1183692773456692e-129, -7.180572040551983e-131, -1.6377153125415037e-132, -2.513114607526192e-134, -2.5944638155835682e-136, -1.8017944894546126e-138, -8.416652755166861e-141, -2.6442151839902353e-143, -5.586188013760306e-146, -7.934578615510733e-149, -7.575970136832592e-152, -4.861399196639388e-155, -2.0959395055042454e-158, -6.069541842568524e-162, -1.1801377410097621e-165, -1.5399875739165737e-169, -1.3479601701137229e-173, -7.909105827624491e-178, -3.1082373738951794e-182, -8.173163573739524e-187, -1.436082545430253e-191, -1.6831493720778107e-196, -1.3127775529223996e-201, -6.791125682590415e-207, -2.3187842141667467e-212, -5.186428107244625e-218, -7.503650451926677e-224, -6.857630210788775e-230, -3.7536164148591877e-236, -1.038280568367683e-242, 0., 9.720549670687965e-256}, {-5.3079987440867945e-139, -2.371127885388e-137, -6.930550719148339e-136, -1.3483915197873907e-134, -1.7555108812209396e-133, -1.5330314117223625e-132, -8.990796401034221e-132, -3.5437432970421116e-131, -9.391685617591668e-131, -1.6740726985102139e-130, -2.007448870281163e-130, -1.6196308621981887e-130, -8.792887121958723e-131, -3.212323464322122e-131, -7.89763527981024e-132, -1.306694813752197e-132, -1.4549659958863115e-133, -1.0902583224690993e-134, -5.497874432525165e-136, -1.8656707762228997e-137, -4.260210755936707e-139, -6.545747823388156e-141, -6.7669153310676895e-143, -4.706426729944851e-145, -2.2020181036822425e-147, -6.929994800302856e-150, -1.4668084801257464e-152, -2.0877570641956557e-155, -1.9979299693803415e-158, -1.2852582133811078e-161, -5.55664366963065e-165, -1.6141065569721063e-168, -3.149302271411641e-172, -4.125709531608434e-176, -3.6273794760780603e-180, -2.139265948086723e-184, -8.45724657252083e-189, -2.239398896903849e-193, -3.9675718213763725e-198, -4.697133008516056e-203, -3.7093376945338005e-208, -1.9493347428045975e-213, -6.79453645368994e-219, -1.5631559805688242e-224, -2.355783176921868e-230, -2.2964950175654717e-236, -1.4141447221288216e-242, -5.215517778299332e-249, -9.720549670687965e-256, 0.}}, {{0., 6.285848342801673e-21, 5.569753217272224e-19, 2.4647859386870983e-17, 6.490959829096495e-16, 1.0754301870362111e-14, 1.1493428835420673e-13, 8.030338169710138e-13, 3.697654136533316e-12, 1.1279424905249291e-11, 2.2875117890797527e-11, 3.092158754848797e-11, 2.7912630403443715e-11, 1.6850115544936332e-11, 6.8100889165006924e-12, 1.84431514856882e-12, 3.3493488011980664e-13, 4.081151143590491e-14, 3.338203132966632e-15, 1.8336957216433726e-16, 6.7666819422125474e-18, 1.6779768415313563e-19, 2.7968412866241057e-21, 3.134127598569967e-23, 2.3616509625115722e-25, 1.1968451653703888e-27, 4.079884888757064e-30, 9.356269336656376e-33, 1.443621513575672e-35, 1.498805951362327e-38, 1.0471764965685548e-41, 4.9239511533695063e-45, 1.5583334940450574e-48, 3.3196344273303814e-52, 4.760263049838948e-56, 4.5952350955041666e-60, 2.9863708061633616e-64, 1.3066526917689286e-68, 3.849254044066976e-73, 7.635033828017736e-78, 1.019717768753495e-82, 9.170627538185034e-88, 5.55370073071511e-93, 2.2648713488959394e-98, 6.220060785079234e-104, 1.1503958157911162e-109, 1.432888241574451e-115, 1.201987073921066e-121, 6.790772555939938e-128, 2.583921724614681e-134}, {-6.285848342801673e-21, 0., 1.88463741681502e-17, 1.1119843928746446e-15, 3.294392744929758e-14, 5.822024982876694e-13, 6.481387657737767e-12, 4.6578456212207095e-11, 2.1894306553600513e-10, 6.784695541768509e-10, 1.3931601349235843e-9, 1.902232862001649e-9, 1.731435354974728e-9, 1.0525298632289348e-9, 4.279188152664298e-10, 1.164836246144857e-10, 2.1248307464349223e-11, 2.599238812763589e-12, 2.1334447578650872e-13, 1.1755421513736889e-14, 4.3500197006684256e-16, 1.0814049664566308e-17, 1.8065749658505408e-19, 2.028630443917511e-21, 1.531523290345272e-23, 7.774999881967761e-26, 2.654640136231922e-28, 6.09681882781309e-31, 9.41998000309626e-34, 9.792560486538147e-37, 6.849949552580787e-40, 3.224511788337736e-43, 1.0215572861569125e-46, 2.178295729994389e-50, 3.126485778116576e-54, 3.020710005806232e-58, 1.964715396089328e-62, 8.60302663621211e-67, 2.5362086424643585e-71, 5.0340808487636966e-76, 6.727826620739688e-81, 6.054319519023361e-86, 3.6686573313577227e-91, 1.4969746454302089e-96, 4.11339527287121e-102, 7.6116263201827e-108, 9.485428872110193e-114, 7.960671648573476e-120, 4.499515123259978e-126, 1.712830519903266e-132}, {-5.569753217272224e-19, -1.88463741681502e-17, 0., 2.463073814139687e-14, 9.729551989710283e-13, 1.9343900806536185e-11, 2.2970302401383432e-10, 1.7195411439437026e-9, 8.313676709236891e-9, 2.629947893082859e-8, 5.486018189589134e-8, 7.584289749010361e-8, 6.973042672725213e-8, 4.274197565881172e-8, 1.749878933897108e-8, 4.791692271128818e-9, 8.785568012846795e-10, 1.0795087983201897e-10, 8.895312087948681e-12, 4.91839437254387e-13, 1.8256556030590345e-14, 4.551145199474885e-16, 7.62211356262087e-18, 8.578439227703313e-20, 6.489738189425029e-22, 3.3008494108404234e-24, 1.1289783549987693e-26, 2.597040227095285e-29, 4.0185399566271324e-32, 4.1832201600148593e-35, 2.9299224988948663e-38, 1.3808593290286027e-41, 4.379565367019232e-45, 9.348399894410023e-49, 1.3430779591556804e-52, 1.2988314111310653e-56, 8.455109711165025e-61, 3.7053184356722944e-65, 1.0931870565463837e-69, 2.1714360302870103e-74, 2.904039415965101e-79, 2.615042064156796e-84, 1.585594056992167e-89, 6.47377702616433e-95, 1.7798770594544788e-100, 3.295353159984968e-106, 4.108713514439711e-112, 3.4499525287986557e-118, 1.9508973359149703e-124, 7.429844755786216e-131}, {-2.4647859386870983e-17, -1.1119843928746446e-15, -2.463073814139687e-14, 0., 1.4351712613575395e-11, 3.8044657553865123e-10, 5.082400182351591e-9, 4.0582933892418146e-8, 2.0438676419226034e-7, 6.650299985637405e-7, 1.4161399613546426e-6, 1.9888557065161575e-6, 1.8514232541886879e-6, 1.1463118695024232e-6, 4.7321698460198845e-7, 1.3048713473327545e-7, 2.4067226413592922e-8, 2.9723766760837036e-9, 2.4602166194772677e-10, 1.365637054025397e-11, 5.086700323583098e-13, 1.2719805702540554e-14, 2.1361901205853797e-16, 2.4102376249785332e-18, 1.8275306632239862e-20, 9.314540563612939e-23, 3.1918545431238166e-25, 7.355137425352359e-28, 1.1399238321440992e-30, 1.1883960167271878e-33, 8.334945172870825e-37, 3.9332391530459345e-40, 1.2489603111567848e-43, 2.668933325877582e-47, 3.838431719039466e-51, 3.715606409828164e-55, 2.4210020207624275e-59, 1.0618845249715653e-63, 3.1354574129485053e-68, 6.232879033595724e-73, 8.341833475540694e-78, 7.51689615434382e-83, 4.560763022899089e-88, 1.8632655465311932e-93, 5.125844814224596e-99, 9.495627751633632e-105, 1.1845748873780825e-110, 9.951628697341358e-117, 5.6302798221457715e-123, 2.145263259770899e-129}, {-6.490959829096495e-16, -3.294392744929758e-14, -9.729551989710283e-13, -1.4351712613575395e-11, 0., 3.757068418692955e-9, 6.692109201486745e-8, 6.011600671496296e-7, 3.22944710271972e-6, 0.000010945747119901945, 0.00002397423779922649, 0.00003437136257302823, 0.00003250413492487564, 0.00002037655302905256, 8.496754280365993e-6, 2.362460491260866e-6, 4.3878256003274543e-7, 5.451356467094359e-8, 4.535190610852547e-9, 2.528669025249139e-10, 9.455677119463747e-12, 2.372697179470338e-13, 3.9970927569227884e-15, 4.5223991132288475e-17, 3.4376431631171493e-19, 1.756076667315541e-21, 6.030083929179549e-24, 1.3921717160652994e-26, 2.1613867600013552e-29, 2.2569049468249962e-32, 1.5852499621608688e-35, 7.491029489904279e-39, 2.381738579990922e-42, 5.095653492400531e-46, 7.336666882729886e-50, 7.109299969478375e-54, 4.636781282619288e-58, 2.035624807888989e-62, 6.015852776034814e-67, 1.196849829196015e-71, 1.6030523789699585e-76, 1.4455798910025226e-81, 8.776915491609472e-87, 3.588102075743254e-92, 9.877044458326997e-98, 1.8308116514106213e-103, 2.285224000621783e-109, 1.9208584532739615e-115, 1.087315458789726e-121, 4.1449633742583885e-128}, {-1.0754301870362111e-14, -5.822024982876694e-13, -1.9343900806536185e-11, -3.8044657553865123e-10, -3.757068418692955e-9, 0., 4.434993400069999e-7, 5.312009213481701e-6, 0.00003210327900041256, 0.00011606341683680963, 0.00026480337566233103, 0.00039048999754327443, 0.00037696985236114884, 0.00024007014292115204, 0.00010135741428834156, 0.000028466352538789873, 5.331148145631438e-6, 6.669640564177247e-7, 5.581755588792878e-8, 3.1281582812246676e-9, 1.1749621183155337e-10, 2.9598747214923708e-12, 5.0035771129143395e-14, 5.678684569260454e-16, 4.328569085510906e-18, 2.216736783739299e-20, 7.62921625066618e-23, 1.7650117682806986e-25, 2.7454215320476115e-28, 2.871735625554124e-31, 2.0203395544397075e-34, 9.56117010653917e-38, 3.044106053571465e-41, 6.521085221598613e-45, 9.400165463423913e-49, 9.118981916912808e-53, 5.953718278236344e-57, 2.6163372696075926e-61, 7.739130618473797e-66, 1.541027856117209e-70, 2.0657283553621456e-75, 1.864244323465417e-80, 1.1327132966622955e-85, 4.633868801967788e-91, 1.2764140579405886e-96, 2.367444227532628e-102, 2.9568091760658557e-108, 2.4867730515420334e-114, 1.4084171219657082e-120, 5.371812116929777e-127}, {-1.1493428835420673e-13, -6.481387657737767e-12, -2.2970302401383432e-10, -5.082400182351591e-9, -6.692109201486745e-8, -4.434993400069999e-7, 0., 0.00002365444395359869, 0.00019060840781041482, 0.0007752477861846615, 0.0018866764289282008, 0.0028980947980679723, 0.0028776882891506897, 0.0018708118993722195, 0.0008023926094707478, 0.00022816984770467237, 0.00004316303610835042, 5.4449988015561e-6, 4.5887313159492816e-7, 2.5869495299024786e-8, 9.766626083569758e-10, 2.4713173924209723e-11, 4.194069068016655e-13, 4.776481298384073e-15, 3.6521379802212367e-17, 1.8755197970618645e-19, 6.471046873267704e-22, 1.5004728406546059e-24, 2.338771537205023e-27, 2.4510093599672685e-30, 1.7273467181113106e-33, 8.187694412601956e-37, 2.610677835850417e-40, 5.600277254098856e-44, 8.083127908653555e-48, 7.850675330759663e-52, 5.131351452355908e-56, 2.2573004223004393e-60, 6.683625919866777e-65, 1.3320773125689362e-69, 1.7871787962617783e-74, 1.6141812283317593e-79, 9.815325238865429e-85, 4.0183316727259215e-90, 1.1076294333258776e-95, 2.0557404996599352e-101, 2.5691138563586594e-107, 2.1619947662068001e-113, 1.2251691438488705e-119, 4.67541873887591e-126}, {-8.030338169710138e-13, -4.6578456212207095e-11, -1.7195411439437026e-9, -4.0582933892418146e-8, -6.011600671496296e-7, -5.312009213481701e-6, -0.00002365444395359869, 0., 0.0005707526072304979, 0.003095174379048844, 0.00847411850700317, 0.013884761378573848, 0.014361451948323447, 0.00960327089873097, 0.004204659377268851, 0.0012146232112662156, 0.00023264318830463622, 0.000029644282919242707, 2.519068135379756e-6, 1.4300844874836945e-7, 5.431199100516517e-9, 1.3813417821455166e-10, 2.3547385871248685e-12, 2.692247541445511e-14, 2.0656628522710544e-16, 1.0640852004202043e-18, 3.681577923043931e-21, 8.558047367224113e-24, 1.3369656824936718e-26, 1.4040276501776683e-29, 9.913612961953913e-33, 4.707265610584523e-36, 1.5033350701407995e-39, 3.229646267907534e-43, 4.667894480582657e-47, 4.5394464447188756e-51, 2.97060118725624e-55, 1.3082320054862024e-59, 3.877570442179058e-64, 7.735730231382299e-69, 1.0388165789111748e-73, 9.390722589438485e-79, 5.714866432581012e-84, 2.34143660320529e-89, 6.458749804207725e-95, 1.1995631820541052e-100, 1.5001124424857287e-106, 1.2631840083909157e-112, 7.162530146416653e-119, 2.7348731911719686e-125}, {-3.697654136533316e-12, -2.1894306553600513e-10, -8.313676709236891e-9, -2.0438676419226034e-7, -3.22944710271972e-6, -0.00003210327900041256, -0.00019060840781041482, -0.0005707526072304979, 0., 0.006235258176469779, 0.022761589596513677, 0.04195647545746154, 0.04629005010788686, 0.03224313402043146, 0.014520559269209919, 0.004282022486721333, 0.0008331767322250563, 0.00010749364096450937, 9.226703051358478e-6, 5.281684428607247e-7, 2.0199142447981214e-8, 5.16791996779639e-10, 8.854800720108332e-12, 1.016917169282242e-13, 7.833030456783897e-16, 4.049040620276457e-18, 1.4052455401217613e-20, 3.275650859815084e-23, 5.130152499788392e-26, 5.399724335856317e-29, 3.8205520330405466e-32, 1.8175426600502003e-35, 5.814686925207592e-39, 1.2511832833534842e-42, 1.8110478638477894e-46, 1.7636318935745795e-50, 1.1555897956174108e-54, 5.095195207958667e-59, 1.511884349960966e-63, 3.0193422634426365e-68, 4.058581066048197e-73, 3.6722593777865266e-78, 2.2367439518407414e-83, 9.171645525003332e-89, 2.5319116817318527e-94, 4.705876976887013e-100, 5.889007633964447e-106, 4.962157549680666e-112, 2.8154117055503978e-118, 1.075650230971473e-124}, {-1.1279424905249291e-11, -6.784695541768509e-10, -2.629947893082859e-8, -6.650299985637405e-7, -0.000010945747119901945, -0.00011606341683680963, -0.0007752477861846615, -0.003095174379048844, -0.006235258176469779, 0., 0.03085885550633247, 0.07584290533001554, 0.09413608581267295, 0.06994142194428854, 0.03281023340217546, 0.009951977284160403, 0.001976753007228077, 0.0002590821383782401, 0.000022516261050132177, 1.3019280567246129e-6, 5.020553427388235e-8, 1.2934835061900459e-9, 2.229468447527294e-11, 2.573532034337602e-13, 1.9911698775830907e-15, 1.03330948759826e-17, 3.5986188785485943e-20, 8.414411205588202e-23, 1.321481545415746e-25, 1.3944068641450768e-28, 9.888489455945323e-32, 4.71396854155392e-35, 1.510950207808853e-38, 3.2568622353601605e-42, 4.721758938245805e-46, 4.604948206388134e-50, 3.0214586355832974e-54, 1.3339147747290393e-58, 3.962803489616351e-63, 7.922807956515755e-68, 1.0660882642204989e-72, 9.65554092728927e-78, 5.886518545073857e-83, 2.415824359487939e-88, 6.674539662902589e-94, 1.241505272328945e-99, 1.554774706522347e-105, 1.3109820964599248e-111, 7.443098214026395e-118, 2.845472753799787e-124}, {-2.2875117890797527e-11, -1.3931601349235843e-9, -5.486018189589134e-8, -1.4161399613546426e-6, -0.00002397423779922649, -0.00026480337566233103, -0.0018866764289282008, -0.00847411850700317, -0.022761589596513677, -0.03085885550633247, 0., 0.06921546133581422, 0.11454681804923444, 0.09574450830882573, 0.047909038960690875, 0.01513722555698945, 0.0030926001373925496, 0.00041377445779478656, 0.00003653102895866441, 2.1386890602914124e-6, 8.330614928214915e-8, 2.1641655855131647e-9, 3.7562749708519784e-11, 4.3617728762086517e-13, 3.3920577893699724e-15, 1.7681530141706505e-17, 6.181944013115022e-20, 1.4505018946446107e-22, 2.2850628989583564e-25, 2.417860662723305e-28, 1.718932441131722e-31, 8.212992877166773e-35, 2.6379292888029965e-38, 5.6968414803987173e-42, 8.273574777572036e-46, 8.08182724606307e-50, 5.310609758453798e-54, 2.3477506423801444e-58, 6.983621969155176e-63, 1.3978933038473538e-67, 1.8830891269850422e-72, 1.7072867776371965e-77, 1.0418680192886844e-82, 4.279751287202609e-88, 1.1834511695081319e-93, 2.2030901264786906e-99, 2.761127082861111e-105, 2.3298772487553437e-111, 1.3237040315871191e-117, 5.06380763771788e-124}, {-3.092158754848797e-11, -1.902232862001649e-9, -7.584289749010361e-8, -1.9888557065161575e-6, -0.00003437136257302823, -0.00039048999754327443, -0.0028980947980679723, -0.013884761378573848, -0.04195647545746154, -0.07584290533001554, -0.06921546133581422, 0., 0.0703814458979194, 0.07843822635229222, 0.04415540507005441, 0.014881318779204289, 0.0031669971714133023, 0.000435834935486491, 0.00003928032828465646, 2.336147587942584e-6, 9.213501701166263e-8, 2.4177030153964093e-9, 4.231301444468533e-11, 4.947731138985936e-13, 3.87064828420897e-15, 2.027971152821817e-17, 7.121992215379725e-20, 1.677623543734883e-22, 2.6520378984671022e-25, 2.814850438462949e-28, 2.0067236268039555e-31, 9.612078253259051e-35, 3.094317791838784e-38, 6.696288101415065e-42, 9.743498922288684e-46, 9.534237072520125e-50, 6.275035694254894e-54, 2.7782204422778523e-58, 8.27544975211017e-63, 1.658590634254883e-67, 2.2369319347901172e-72, 2.0303513026188487e-77, 1.2403080817276906e-82, 5.099877217765554e-88, 1.4115313124805838e-93, 2.629954818132111e-99, 3.2988083872225332e-105, 2.785729658081502e-111, 1.5838504405139366e-117, 6.063192261479362e-124}, {-2.7912630403443715e-11, -1.731435354974728e-9, -6.973042672725213e-8, -1.8514232541886879e-6, -0.00003250413492487564, -0.00037696985236114884, -0.0028776882891506897, -0.014361451948323447, -0.04629005010788686, -0.09413608581267295, -0.11454681804923444, -0.0703814458979194, 0., 0.0324524646252399, 0.02435805070541695, 0.00923533384902193, 0.0020964648172827343, 0.00030053199152315556, 0.000027859815444001056, 1.691446420256209e-6, 6.776760134813143e-8, 1.8005093360012073e-9, 3.1829601187426826e-11, 3.7529039294816455e-13, 2.9564566790342896e-15, 1.5582136543454047e-17, 5.500322919081003e-20, 1.3014146905634094e-22, 2.0653835004497e-25, 2.1997921945435565e-28, 1.573100192436085e-31, 7.555980337534004e-35, 2.438515561529711e-38, 5.2890863869300726e-42, 7.711870040632706e-46, 7.56053375950461e-50, 4.9846807615535704e-54, 2.2104631498658403e-58, 6.594032842207893e-63, 1.3234113577592407e-67, 1.7871570516725266e-72, 1.6240442105734843e-77, 9.932053504170886e-83, 4.088098505725244e-88, 1.1325997753825752e-93, 2.112191187688286e-99, 2.6516602529069853e-105, 2.2410648683531694e-111, 1.2751605326232831e-117, 4.8850541621216716e-124}, {-1.6850115544936332e-11, -1.0525298632289348e-9, -4.274197565881172e-8, -1.1463118695024232e-6, -0.00002037655302905256, -0.00024007014292115204, -0.0018708118993722195, -0.00960327089873097, -0.03224313402043146, -0.06994142194428854, -0.09574450830882573, -0.07843822635229222, -0.0324524646252399, 0., 0.006786597910702296, 0.0034308436342689705, 0.0008761700959306092, 0.00013397392495396464, 0.000012937089231224989, 8.078877819625125e-7, 3.304226055475973e-8, 8.918307440888451e-10, 1.5962955063734646e-11, 1.9011410809891405e-13, 1.5101585412859878e-15, 8.015017666536442e-18, 2.8460536885993895e-20, 6.768494275917314e-23, 1.078975452392758e-25, 1.1536984324224236e-28, 8.278895199476159e-32, 3.9888647207847947e-35, 1.290888468414396e-38, 2.806925887396429e-42, 4.102002311286804e-46, 4.0298314908012394e-50, 2.661910985040861e-54, 1.1824807974127954e-58, 3.533111562867124e-63, 7.101400818575739e-68, 9.603024490483952e-73, 8.73770676141547e-78, 5.35001966260676e-83, 2.2045527618881667e-88, 6.11403289792193e-94, 1.1413237360071594e-99, 1.4341430947796779e-105, 1.2131231340930479e-111, 6.908280936922718e-118, 2.6485595649794708e-124}, {-6.8100889165006924e-12, -4.279188152664298e-10, -1.749878933897108e-8, -4.7321698460198845e-7, -8.496754280365993e-6, -0.00010135741428834156, -0.0008023926094707478, -0.004204659377268851, -0.014520559269209919, -0.03281023340217546, -0.047909038960690875, -0.04415540507005441, -0.02435805070541695, -0.006786597910702296, 0., 0.0006437774770801616, 0.00021921083518824873, 0.0000377091196491244, 3.884109008221157e-6, 2.5265892468385777e-7, 1.0628887521338796e-8, 2.928568198751957e-10, 5.325073640146832e-12, 6.421281441222449e-14, 5.152223658181717e-16, 2.7572793761442302e-18, 9.859294323530369e-21, 2.358697419647934e-23, 3.7793158615118266e-26, 4.0590876398311604e-29, 2.924208233686676e-32, 1.4138084513379168e-35, 4.5895750370833993e-39, 1.0007357174107395e-42, 1.466126524938604e-46, 1.4436049068130857e-50, 9.555495726797987e-55, 4.252805691763938e-59, 1.2728974998729096e-63, 2.562568810197324e-68, 3.470423452744457e-73, 3.162045011525909e-78, 1.9385645245395134e-83, 7.997644394303674e-89, 2.220507178163336e-94, 4.1494010661723756e-100, 5.219073030287882e-106, 4.418804187736741e-112, 2.5185217895638546e-118, 9.663626529423474e-125}, {-1.84431514856882e-12, -1.164836246144857e-10, -4.791692271128818e-9, -1.3048713473327545e-7, -2.362460491260866e-6, -0.000028466352538789873, -0.00022816984770467237, -0.0012146232112662156, -0.004282022486721333, -0.009951977284160403, -0.01513722555698945, -0.014881318779204289, -0.00923533384902193, -0.0034308436342689705, -0.0006437774770801616, 0., 0.00002770453282941587, 6.3543911497524495e-6, 7.363282848602195e-7, 5.1090886762327986e-8, 2.2388519483402263e-9, 6.344937706269232e-11, 1.1777482868156316e-12, 1.4427397347499388e-14, 1.1720766852058994e-16, 6.335879331599932e-19, 2.284420668418824e-21, 5.503372835591637e-24, 8.870484002209397e-27, 9.575997302630277e-30, 6.929443885094363e-33, 3.3634149083561284e-36, 1.095639550764391e-39, 2.396387882300313e-43, 3.5205771545909036e-47, 3.4751844528960106e-51, 2.305518687099342e-55, 1.028227453968547e-59, 3.0833926863864706e-64, 6.218212781501466e-69, 8.434666982725275e-74, 7.696556144129618e-79, 4.725032542235834e-84, 1.9518252565206502e-89, 5.425599529676439e-95, 1.0149947251272491e-100, 1.2779795360763556e-106, 1.0830776787948846e-112, 6.178734665195206e-119, 2.372847460233384e-125}, {-3.3493488011980664e-13, -2.1248307464349223e-11, -8.785568012846795e-10, -2.4067226413592922e-8, -4.3878256003274543e-7, -5.331148145631438e-6, -0.00004316303610835042, -0.00023264318830463622, -0.0008331767322250563, -0.001976753007228077, -0.0030926001373925496, -0.0031669971714133023, -0.0020964648172827343, -0.0008761700959306092, -0.00021921083518824873, -0.00002770453282941587, 0., 5.409289081406477e-7, 8.357501571765452e-8, 6.523804627614133e-9, 3.04938040196388e-10, 9.002069447693007e-12, 1.7187073492181414e-13, 2.1492764914065397e-15, 1.7737799729183738e-17, 9.708355017390104e-20, 3.5357344344608717e-22, 8.588881629988536e-25, 1.3940599586349087e-27, 1.5138943709844297e-30, 1.101111760781846e-33, 5.3684382710448626e-37, 1.7556381315639245e-40, 3.853272948805152e-44, 5.678439631628047e-48, 5.620794512082704e-52, 3.738312389682695e-56, 1.6710215543924024e-60, 5.0213434263833404e-65, 1.0145615886968368e-69, 1.3785909271909922e-74, 1.25996750586507e-79, 7.746591058397873e-85, 3.2043718565466815e-90, 8.918750415868466e-96, 1.6704626548038543e-101, 2.1056185743692925e-107, 1.7863541510965892e-113, 1.0200743482620232e-119, 3.9210383103386586e-126}, {-4.081151143590491e-14, -2.599238812763589e-12, -1.0795087983201897e-10, -2.9723766760837036e-9, -5.451356467094359e-8, -6.669640564177247e-7, -5.4449988015561e-6, -0.000029644282919242707, -0.00010749364096450937, -0.0002590821383782401, -0.00041377445779478656, -0.000435834935486491, -0.00030053199152315556, -0.00013397392495396464, -0.0000377091196491244, -6.3543911497524495e-6, -5.409289081406477e-7, 0., 4.792251357265379e-9, 4.987728499601312e-10, 2.6228048977278668e-11, 8.258961922236959e-13, 1.6425318731733387e-14, 2.112703815260111e-16, 1.779921782485172e-18, 9.89660518025926e-21, 3.6493478816076775e-23, 8.954411531912035e-26, 1.4655006321091327e-28, 1.6026053406898546e-31, 1.172572853986295e-34, 5.746161899040006e-38, 1.8875540614488923e-41, 4.1590481918149895e-45, 6.15033181824724e-49, 6.1067442246375005e-53, 4.0727927709086325e-57, 1.825096661061016e-61, 5.496796473734331e-66, 1.1129262307344839e-70, 1.5151133611316746e-75, 1.3871508609872735e-80, 8.542213242845466e-86, 3.538715190474561e-91, 9.862859836593317e-97, 1.8496515559073734e-102, 2.3342618057437243e-108, 1.9825321652779087e-114, 1.1332785266161384e-120, 4.360439265644691e-127}, {-3.338203132966632e-15, -2.1334447578650872e-13, -8.895312087948681e-12, -2.4602166194772677e-10, -4.535190610852547e-9, -5.581755588792878e-8, -4.5887313159492816e-7, -2.519068135379756e-6, -9.226703051358478e-6, -0.000022516261050132177, -0.00003653102895866441, -0.00003928032828465646, -0.000027859815444001056, -0.000012937089231224989, -3.884109008221157e-6, -7.363282848602195e-7, -8.357501571765452e-8, -4.792251357265379e-9, 0., 1.926544696891978e-11, 1.3507687563196566e-12, 4.7851219130282165e-14, 1.0151029094678545e-15, 1.3600774820702998e-17, 1.1785836393815945e-19, 6.689606581508163e-22, 2.50593050398695e-24, 6.2256663115384895e-27, 1.0291995904848806e-29, 1.1348652673656807e-32, 8.361496440704673e-36, 4.1219190131058915e-39, 1.360950894971057e-42, 3.0121147226762945e-46, 4.471733242951764e-50, 4.455458742107545e-54, 2.9806947120697625e-58, 1.339416842462553e-62, 4.044144246925757e-67, 8.206713498488897e-72, 1.11955711073615e-76, 1.0269435460528966e-81, 6.335018996755028e-87, 2.6285639709249175e-92, 7.337003477461562e-98, 1.3778499815416547e-103, 1.7410685762540228e-109, 1.4804824555899224e-115, 8.472322921740619e-122, 3.2632341488788863e-128}, {-1.8336957216433726e-16, -1.1755421513736889e-14, -4.91839437254387e-13, -1.365637054025397e-11, -2.528669025249139e-10, -3.1281582812246676e-9, -2.5869495299024786e-8, -1.4300844874836945e-7, -5.281684428607247e-7, -1.3019280567246129e-6, -2.1386890602914124e-6, -2.336147587942584e-6, -1.691446420256209e-6, -8.078877819625125e-7, -2.5265892468385777e-7, -5.1090886762327986e-8, -6.523804627614133e-9, -4.987728499601312e-10, -1.926544696891978e-11, 0., 3.514667386995685e-14, 1.6601027478447935e-15, 3.9619095500164216e-17, 5.662221543286524e-19, 5.111076514516918e-21, 2.9839188524131396e-23, 1.1410647682410228e-25, 2.8798279162781736e-28, 4.820314056890207e-31, 5.368894127454235e-34, 3.988675162451676e-37, 1.980024521512813e-40, 6.576441975326984e-44, 1.4629904997935348e-47, 2.1816264236775804e-51, 2.182210837021714e-55, 1.4649646118882623e-59, 6.603404179783887e-64, 1.9993253079258942e-68, 4.067365434909824e-73, 5.561296973772249e-78, 5.111809198805003e-83, 3.15934996814233e-88, 1.3131762041752742e-93, 3.671289279340061e-99, 6.9046988112645264e-105, 8.736849013943632e-111, 7.438691007029867e-117, 4.261990370786252e-123, 1.643391432285425e-129}, {-6.7666819422125474e-18, -4.3500197006684256e-16, -1.8256556030590345e-14, -5.086700323583098e-13, -9.455677119463747e-12, -1.1749621183155337e-10, -9.766626083569758e-10, -5.431199100516517e-9, -2.0199142447981214e-8, -5.020553427388235e-8, -8.330614928214915e-8, -9.213501701166263e-8, -6.776760134813143e-8, -3.304226055475973e-8, -1.0628887521338796e-8, -2.2388519483402263e-9, -3.04938040196388e-10, -2.6228048977278668e-11, -1.3507687563196566e-12, -3.514667386995685e-14, 0., 2.9098921604138745e-17, 9.259450601137923e-19, 1.4887440642508132e-20, 1.4334227444826783e-22, 8.717213525107202e-25, 3.428746902673509e-27, 8.83377863427228e-30, 1.502085777183231e-32, 1.6939448665654044e-35, 1.2711824998590986e-38, 6.362882883868785e-42, 2.1281430058579845e-45, 4.762431524302382e-49, 7.138206105723547e-53, 7.171993814008823e-57, 4.833593421656394e-61, 2.1863325384570633e-65, 6.640094945274887e-70, 1.3545926681406287e-74, 1.8567725615575063e-79, 1.7105791366958238e-84, 1.0594110607189818e-89, 4.411756359400423e-95, 1.2355540848510718e-100, 2.327465871407163e-106, 2.9494180656182496e-112, 2.5146304699529095e-118, 1.4425949891342461e-124, 5.569159848437183e-131}, {-1.6779768415313563e-19, -1.0814049664566308e-17, -4.551145199474885e-16, -1.2719805702540554e-14, -2.372697179470338e-13, -2.9598747214923708e-12, -2.4713173924209723e-11, -1.3813417821455166e-10, -5.16791996779639e-10, -1.2934835061900459e-9, -2.1641655855131647e-9, -2.4177030153964093e-9, -1.8005093360012073e-9, -8.918307440888451e-10, -2.928568198751957e-10, -6.344937706269232e-11, -9.002069447693007e-12, -8.258961922236959e-13, -4.7851219130282165e-14, -1.6601027478447935e-15, -2.9098921604138745e-17, 0., 1.093392182952892e-20, 2.3439563783900436e-22, 2.538962554903038e-24, 1.6469803293620208e-26, 6.747997662421484e-29, 1.7882180063307587e-31, 3.1040129764462474e-34, 3.556046979438478e-37, 2.701911725634089e-40, 1.366098409457743e-43, 4.607156748546784e-47, 1.038215191374623e-50, 1.5653993216939793e-54, 1.580874608988724e-58, 1.0701930702620731e-62, 4.859683893944006e-67, 1.481055887168916e-71, 3.0307378025974486e-76, 4.1658445132262045e-81, 3.8474644255802285e-86, 2.3882613918813506e-91, 9.96614281695899e-97, 2.796398731078606e-102, 5.276856641992454e-108, 6.697669881213701e-114, 5.7187946031827384e-120, 3.2852686800182734e-126, 1.2699027335539602e-132}, {-2.7968412866241057e-21, -1.8065749658505408e-19, -7.62211356262087e-18, -2.1361901205853797e-16, -3.9970927569227884e-15, -5.0035771129143395e-14, -4.194069068016655e-13, -2.3547385871248685e-12, -8.854800720108332e-12, -2.229468447527294e-11, -3.7562749708519784e-11, -4.231301444468533e-11, -3.1829601187426826e-11, -1.5962955063734646e-11, -5.325073640146832e-12, -1.1777482868156316e-12, -1.7187073492181414e-13, -1.6425318731733387e-14, -1.0151029094678545e-15, -3.9619095500164216e-17, -9.259450601137923e-19, -1.093392182952892e-20, 0., 1.864652287822054e-24, 2.693043482857668e-26, 1.9652961553312947e-28, 8.589012591160627e-31, 2.3709235286761122e-33, 4.2330662693611723e-36, 4.9505547947280223e-39, 3.821175306385975e-42, 1.9561530182584413e-45, 6.6637490284177065e-49, 1.5141787511249033e-52, 2.299012666168351e-56, 2.335560220600735e-60, 1.5891951831996563e-64, 7.248658273739952e-69, 2.2177921248527028e-73, 4.554105751453314e-78, 6.279141779727252e-83, 5.815359226932174e-88, 3.6188525474404013e-93, 1.5135683903365587e-98, 4.255712393764116e-104, 8.045818269644531e-110, 1.0229945027077336e-115, 8.748820139776976e-122, 5.033369418455578e-128, 1.9482941199065716e-134}, {-3.134127598569967e-23, -2.028630443917511e-21, -8.578439227703313e-20, -2.4102376249785332e-18, -4.5223991132288475e-17, -5.678684569260454e-16, -4.776481298384073e-15, -2.692247541445511e-14, -1.016917169282242e-13, -2.573532034337602e-13, -4.3617728762086517e-13, -4.947731138985936e-13, -3.7529039294816455e-13, -1.9011410809891405e-13, -6.421281441222449e-14, -1.4427397347499388e-14, -2.1492764914065397e-15, -2.112703815260111e-16, -1.3600774820702998e-17, -5.662221543286524e-19, -1.4887440642508132e-20, -2.3439563783900436e-22, -1.864652287822054e-24, 0., 1.4433010742491136e-28, 1.40436601204196e-30, 6.904751730785444e-33, 2.0330642250274207e-35, 3.7810932332549404e-38, 4.5483161754722e-41, 3.583839735409855e-44, 1.8637766498063196e-47, 6.428426851045444e-51, 1.47546199344201e-54, 2.258896683935272e-58, 2.310854109965217e-62, 1.5817437295201494e-66, 7.251668914583282e-71, 2.2286182273674126e-75, 4.5942829342471046e-80, 6.356532478894037e-85, 5.905259896487763e-90, 3.6850048002501015e-95, 1.54509901255744e-100, 4.354240859424243e-106, 8.24913913152497e-112, 1.0508324102597375e-117, 9.002523964479906e-124, 5.187630459875441e-130, 2.010979615716428e-136}, {-2.3616509625115722e-25, -1.531523290345272e-23, -6.489738189425029e-22, -1.8275306632239862e-20, -3.4376431631171493e-19, -4.328569085510906e-18, -3.6521379802212367e-17, -2.0656628522710544e-16, -7.833030456783897e-16, -1.9911698775830907e-15, -3.3920577893699724e-15, -3.87064828420897e-15, -2.9564566790342896e-15, -1.5101585412859878e-15, -5.152223658181717e-16, -1.1720766852058994e-16, -1.7737799729183738e-17, -1.779921782485172e-18, -1.1785836393815945e-19, -5.111076514516918e-21, -1.4334227444826783e-22, -2.538962554903038e-24, -2.693043482857668e-26, -1.4433010742491136e-28, 0., 5.070675590533125e-33, 3.324086528228987e-35, 1.1011028162996447e-37, 2.18435330949299e-40, 2.737063748723171e-43, 2.2182847952215812e-46, 1.177653239671842e-49, 4.126365518785496e-53, 9.589281064449442e-57, 1.482925025961443e-60, 1.5296760923945233e-64, 1.0543614700025295e-68, 4.862602800598785e-73, 1.5020623711029255e-77, 3.110316078251692e-82, 4.320229751373689e-87, 4.027457295114792e-92, 2.5209978412830435e-97, 1.0599745353724595e-102, 2.9945989051782355e-108, 5.686181973333264e-114, 7.258448763642916e-120, 6.230119718046233e-126, 3.5962988684203733e-132, 1.3963356970384552e-138}, {-1.1968451653703888e-27, -7.774999881967761e-26, -3.3008494108404234e-24, -9.314540563612939e-23, -1.756076667315541e-21, -2.216736783739299e-20, -1.8755197970618645e-19, -1.0640852004202043e-18, -4.049040620276457e-18, -1.03330948759826e-17, -1.7681530141706505e-17, -2.027971152821817e-17, -1.5582136543454047e-17, -8.015017666536442e-18, -2.7572793761442302e-18, -6.335879331599932e-19, -9.708355017390104e-20, -9.89660518025926e-21, -6.689606581508163e-22, -2.9839188524131396e-23, -8.717213525107202e-25, -1.6469803293620208e-26, -1.9652961553312947e-28, -1.40436601204196e-30, -5.070675590533125e-33, 0., 8.086036629190524e-38, 3.5713301000610743e-40, 7.97035248104579e-43, 1.0652910525958717e-45, 8.993514436628644e-49, 4.910933137752589e-52, 1.7565848326211846e-55, 4.146931917887245e-59, 6.493144735429318e-63, 6.765504288366586e-67, 4.7021269020780175e-71, 2.1837356764112372e-75, 6.785731368215904e-80, 1.4123251137991733e-84, 1.970477587571533e-89, 1.844146357548398e-94, 1.1583565795073586e-99, 4.885485356412629e-105, 1.3840623232759687e-110, 2.634661558677022e-116, 3.370806395258902e-122, 2.899242996244423e-128, 1.6767400984953343e-134, 6.521604439074687e-141}, {-4.079884888757064e-30, -2.654640136231922e-28, -1.1289783549987693e-26, -3.1918545431238166e-25, -6.030083929179549e-24, -7.62921625066618e-23, -6.471046873267704e-22, -3.681577923043931e-21, -1.4052455401217613e-20, -3.5986188785485943e-20, -6.181944013115022e-20, -7.121992215379725e-20, -5.500322919081003e-20, -2.8460536885993895e-20, -9.859294323530369e-21, -2.284420668418824e-21, -3.5357344344608717e-22, -3.6493478816076775e-23, -2.50593050398695e-24, -1.1410647682410228e-25, -3.428746902673509e-27, -6.747997662421484e-29, -8.589012591160627e-31, -6.904751730785444e-33, -3.324086528228987e-35, -8.086036629190524e-38, 0., 5.8529726766761815e-43, 1.741657551967037e-45, 2.61882236401696e-48, 2.3582830056053364e-51, 1.3414030005122358e-54, 4.935132725601002e-58, 1.1893548740363375e-61, 1.8918167197530093e-65, 1.9958099403223008e-69, 1.4011291188963717e-73, 6.561271467451912e-78, 2.053104500046659e-82, 4.298594677637015e-87, 6.0281600485699327e-92, 5.666868824134716e-97, 3.573467439992185e-102, 1.5123789722217282e-107, 4.297847970000632e-113, 8.203986525476252e-119, 1.052255025014392e-124, 9.071053510166145e-131, 5.256989304876956e-137, 2.0485546117090794e-143}, {-9.356269336656376e-33, -6.09681882781309e-31, -2.597040227095285e-29, -7.355137425352359e-28, -1.3921717160652994e-26, -1.7650117682806986e-25, -1.5004728406546059e-24, -8.558047367224113e-24, -3.275650859815084e-23, -8.414411205588202e-23, -1.4505018946446107e-22, -1.677623543734883e-22, -1.3014146905634094e-22, -6.768494275917314e-23, -2.358697419647934e-23, -5.503372835591637e-24, -8.588881629988536e-25, -8.954411531912035e-26, -6.2256663115384895e-27, -2.8798279162781736e-28, -8.83377863427228e-30, -1.7882180063307587e-31, -2.3709235286761122e-33, -2.0330642250274207e-35, -1.1011028162996447e-37, -3.5713301000610743e-40, -5.8529726766761815e-43, 0., 1.9230787357814743e-48, 3.855485517492288e-51, 3.9059032264227907e-54, 2.3698101464183764e-57, 9.082008105959912e-61, 2.2512771386487214e-64, 3.655538873228522e-68, 3.917697983290908e-72, 2.7847419837862114e-76, 1.3172239414318878e-80, 4.1561076516922566e-85, 8.762513185976708e-90, 1.2361306790648393e-94, 1.1680037322750555e-99, 7.398188623994025e-105, 3.1433734874273836e-110, 8.963791771153576e-116, 1.7163590198938377e-121, 2.207541658108396e-127, 1.9077994705549516e-133, 1.1081485984713764e-139, 4.3271971769022445e-146}, {-1.443621513575672e-35, -9.41998000309626e-34, -4.0185399566271324e-32, -1.1399238321440992e-30, -2.1613867600013552e-29, -2.7454215320476115e-28, -2.338771537205023e-27, -1.3369656824936718e-26, -5.130152499788392e-26, -1.321481545415746e-25, -2.2850628989583564e-25, -2.6520378984671022e-25, -2.0653835004497e-25, -1.078975452392758e-25, -3.7793158615118266e-26, -8.870484002209397e-27, -1.3940599586349087e-27, -1.4655006321091327e-28, -1.0291995904848806e-29, -4.820314056890207e-31, -1.502085777183231e-32, -3.1040129764462474e-34, -4.2330662693611723e-36, -3.7810932332549404e-38, -2.18435330949299e-40, -7.97035248104579e-43, -1.741657551967037e-45, -1.9230787357814743e-48, 0., 2.868173080150657e-54, 3.874239768030064e-57, 2.6444240172296285e-60, 1.0810061060290888e-63, 2.7912837677361676e-67, 4.6618778696643065e-71, 5.100294819289633e-75, 3.682889722511403e-79, 1.763836802905173e-83, 5.621476220267096e-88, 1.1950784041985539e-92, 1.6976906381980157e-97, 1.6136740760649639e-102, 1.0273500617833237e-107, 4.384534958337714e-113, 1.2552178179536508e-118, 2.4117974289064506e-124, 3.1116023216021275e-130, 2.6965756224466048e-136, 1.5702361711815264e-142, 6.1455332663198e-149}, {-1.498805951362327e-38, -9.792560486538147e-37, -4.1832201600148593e-35, -1.1883960167271878e-33, -2.2569049468249962e-32, -2.871735625554124e-31, -2.4510093599672685e-30, -1.4040276501776683e-29, -5.399724335856317e-29, -1.3944068641450768e-28, -2.417860662723305e-28, -2.814850438462949e-28, -2.1997921945435565e-28, -1.1536984324224236e-28, -4.0590876398311604e-29, -9.575997302630277e-30, -1.5138943709844297e-30, -1.6026053406898546e-31, -1.1348652673656807e-32, -5.368894127454235e-34, -1.6939448665654044e-35, -3.556046979438478e-37, -4.9505547947280223e-39, -4.5483161754722e-41, -2.737063748723171e-43, -1.0652910525958717e-45, -2.61882236401696e-48, -3.855485517492288e-51, -2.868173080150657e-54, 0., 1.9418179608312643e-60, 1.7672250076289758e-63, 8.127208942167083e-67, 2.2384427515069763e-70, 3.894320228197475e-74, 4.382283867047172e-78, 3.2303440722506503e-82, 1.5716574382731651e-86, 5.071598935553651e-91, 1.0890698322634634e-95, 1.5599906939293743e-100, 1.4931578797929682e-105, 9.562815630278669e-111, 4.102157477242068e-116, 1.1796207044465407e-121, 2.275432222364257e-127, 2.9458628108290222e-133, 2.560846357334929e-139, 1.4953422262880277e-145, 5.867083775788905e-152}, {-1.0471764965685548e-41, -6.849949552580787e-40, -2.9299224988948663e-38, -8.334945172870825e-37, -1.5852499621608688e-35, -2.0203395544397075e-34, -1.7273467181113106e-33, -9.913612961953913e-33, -3.8205520330405466e-32, -9.888489455945323e-32, -1.718932441131722e-31, -2.0067236268039555e-31, -1.573100192436085e-31, -8.278895199476159e-32, -2.924208233686676e-32, -6.929443885094363e-33, -1.101111760781846e-33, -1.172572853986295e-34, -8.361496440704673e-36, -3.988675162451676e-37, -1.2711824998590986e-38, -2.701911725634089e-40, -3.821175306385975e-42, -3.583839735409855e-44, -2.2182847952215812e-46, -8.993514436628644e-49, -2.3582830056053364e-51, -3.9059032264227907e-54, -3.874239768030064e-57, -1.9418179608312643e-60, 0., 5.967782637487985e-67, 3.659327756373213e-70, 1.1338572957421693e-73, 2.104131079388565e-77, 2.4664391405932454e-81, 1.8700496477424575e-85, 9.287890551855269e-90, 3.044693102084931e-94, 6.6198687854042976e-99, 9.578124242229125e-104, 9.244178297187553e-109, 5.9617645487235546e-114, 2.572638643088018e-119, 7.435844633855125e-125, 1.440742355683208e-130, 1.8725556051663515e-136, 1.6334697000744641e-142, 9.567768203892137e-149, 3.764411041237585e-155}, {-4.9239511533695063e-45, -3.224511788337736e-43, -1.3808593290286027e-41, -3.9332391530459345e-40, -7.491029489904279e-39, -9.56117010653917e-38, -8.187694412601956e-37, -4.707265610584523e-36, -1.8175426600502003e-35, -4.71396854155392e-35, -8.212992877166773e-35, -9.612078253259051e-35, -7.555980337534004e-35, -3.9888647207847947e-35, -1.4138084513379168e-35, -3.3634149083561284e-36, -5.3684382710448626e-37, -5.746161899040006e-38, -4.1219190131058915e-39, -1.980024521512813e-40, -6.362882883868785e-42, -1.366098409457743e-43, -1.9561530182584413e-45, -1.8637766498063196e-47, -1.177653239671842e-49, -4.910933137752589e-52, -1.3414030005122358e-54, -2.3698101464183764e-57, -2.6444240172296285e-60, -1.7672250076289758e-63, -5.967782637487985e-67, 0., 8.325774676897631e-74, 3.439699306760858e-77, 7.181040791086173e-81, 8.97870555731266e-85, 7.091289729649982e-89, 3.6226271571526297e-93, 1.2122855132940686e-97, 2.6776277352843428e-102, 3.9226206898968816e-107, 3.824097593852311e-112, 2.4867927834210486e-117, 1.0806125862935541e-122, 3.141947779885248e-128, 6.118943451652846e-134, 7.988391452889029e-140, 6.995769365200887e-146, 4.111879703982744e-152, 1.6228160031729514e-158}, {-1.5583334940450574e-48, -1.0215572861569125e-46, -4.379565367019232e-45, -1.2489603111567848e-43, -2.381738579990922e-42, -3.044106053571465e-41, -2.610677835850417e-40, -1.5033350701407995e-39, -5.814686925207592e-39, -1.510950207808853e-38, -2.6379292888029965e-38, -3.094317791838784e-38, -2.438515561529711e-38, -1.290888468414396e-38, -4.5895750370833993e-39, -1.095639550764391e-39, -1.7556381315639245e-40, -1.8875540614488923e-41, -1.360950894971057e-42, -6.576441975326984e-44, -2.1281430058579845e-45, -4.607156748546784e-47, -6.6637490284177065e-49, -6.428426851045444e-51, -4.126365518785496e-53, -1.7565848326211846e-55, -4.935132725601002e-58, -9.082008105959912e-61, -1.0810061060290888e-63, -8.127208942167083e-67, -3.659327756373213e-70, -8.325774676897631e-74, 0., 5.272891085099046e-81, 1.467757986659904e-84, 2.0645875816453184e-88, 1.7392961448150412e-92, 9.255517579711429e-97, 3.185784855294336e-101, 7.183177008227548e-106, 1.0690108418787546e-110, 1.055187880195541e-115, 6.931148932601705e-121, 3.0369649403485756e-126, 8.891912368399078e-132, 1.7420077142431296e-137, 2.285885288123834e-143, 2.0107824094539396e-149, 1.1865055648194815e-155, 4.698984534431437e-162}, {-3.3196344273303814e-52, -2.178295729994389e-50, -9.348399894410023e-49, -2.668933325877582e-47, -5.095653492400531e-46, -6.521085221598613e-45, -5.600277254098856e-44, -3.229646267907534e-43, -1.2511832833534842e-42, -3.2568622353601605e-42, -5.6968414803987173e-42, -6.696288101415065e-42, -5.2890863869300726e-42, -2.806925887396429e-42, -1.0007357174107395e-42, -2.396387882300313e-43, -3.853272948805152e-44, -4.1590481918149895e-45, -3.0121147226762945e-46, -1.4629904997935348e-47, -4.762431524302382e-49, -1.038215191374623e-50, -1.5141787511249033e-52, -1.47546199344201e-54, -9.589281064449442e-57, -4.146931917887245e-59, -1.1893548740363375e-61, -2.2512771386487214e-64, -2.7912837677361676e-67, -2.2384427515069763e-70, -1.1338572957421693e-73, -3.439699306760858e-77, -5.272891085099046e-81, 0., 1.5159688813149645e-88, 2.8432030847683543e-92, 2.694639226863542e-96, 1.529524813636163e-100, 5.48404522076678e-105, 1.2718491638176084e-109, 1.9322174182732083e-114, 1.937506203921064e-119, 1.2885864795388056e-124, 5.703125428600046e-130, 1.683729972882295e-135, 3.321649452132556e-141, 4.384656533405826e-147, 3.8767490031698504e-153, 2.297771750504895e-159, 9.13568058811713e-166}, {-4.760263049838948e-56, -3.126485778116576e-54, -1.3430779591556804e-52, -3.838431719039466e-51, -7.336666882729886e-50, -9.400165463423913e-49, -8.083127908653555e-48, -4.667894480582657e-47, -1.8110478638477894e-46, -4.721758938245805e-46, -8.273574777572036e-46, -9.743498922288684e-46, -7.711870040632706e-46, -4.102002311286804e-46, -1.466126524938604e-46, -3.5205771545909036e-47, -5.678439631628047e-48, -6.15033181824724e-49, -4.471733242951764e-50, -2.1816264236775804e-51, -7.138206105723547e-53, -1.5653993216939793e-54, -2.299012666168351e-56, -2.258896683935272e-58, -1.482925025961443e-60, -6.493144735429318e-63, -1.8918167197530093e-65, -3.655538873228522e-68, -4.6618778696643065e-71, -3.894320228197475e-74, -2.104131079388565e-77, -7.181040791086173e-81, -1.467757986659904e-84, -1.5159688813149645e-88, 0., 1.978579667214215e-96, 2.5002591447241703e-100, 1.5965901519518183e-104, 6.106138770612077e-109, 1.4751290594131356e-113, 2.305073929920832e-118, 2.3595371013959433e-123, 1.5941776037479063e-128, 7.14382962353024e-134, 2.1303718441365963e-139, 4.237804252706054e-145, 5.6331216303886775e-151, 5.0102414580805764e-157, 2.984828055711935e-163, 1.1920317938230949e-169}, {-4.5952350955041666e-60, -3.020710005806232e-58, -1.2988314111310653e-56, -3.715606409828164e-55, -7.109299969478375e-54, -9.118981916912808e-53, -7.850675330759663e-52, -4.5394464447188756e-51, -1.7636318935745795e-50, -4.604948206388134e-50, -8.08182724606307e-50, -9.534237072520125e-50, -7.56053375950461e-50, -4.0298314908012394e-50, -1.4436049068130857e-50, -3.4751844528960106e-51, -5.620794512082704e-52, -6.1067442246375005e-53, -4.455458742107545e-54, -2.182210837021714e-55, -7.171993814008823e-57, -1.580874608988724e-58, -2.335560220600735e-60, -2.310854109965217e-62, -1.5296760923945233e-64, -6.765504288366586e-67, -1.9958099403223008e-69, -3.917697983290908e-72, -5.100294819289633e-75, -4.382283867047172e-78, -2.4664391405932454e-81, -8.97870555731266e-85, -2.0645875816453184e-88, -2.8432030847683543e-92, -1.978579667214215e-96, 0., 1.1723104281061928e-104, 9.981361537365783e-109, 4.294528931945036e-113, 1.1066431623627729e-117, 1.801321415891358e-122, 1.8965645143327724e-127, 1.3080741281852516e-132, 5.954786091816075e-138, 1.7979827575118066e-143, 3.612732506477955e-149, 4.8422606968780895e-155, 4.336947346030757e-161, 2.599095481852759e-167, 1.0433072255326582e-173}, {-2.9863708061633616e-64, -1.964715396089328e-62, -8.455109711165025e-61, -2.4210020207624275e-59, -4.636781282619288e-58, -5.953718278236344e-57, -5.131351452355908e-56, -2.97060118725624e-55, -1.1555897956174108e-54, -3.0214586355832974e-54, -5.310609758453798e-54, -6.275035694254894e-54, -4.9846807615535704e-54, -2.661910985040861e-54, -9.555495726797987e-55, -2.305518687099342e-55, -3.738312389682695e-56, -4.0727927709086325e-57, -2.9806947120697625e-58, -1.4649646118882623e-59, -4.833593421656394e-61, -1.0701930702620731e-62, -1.5891951831996563e-64, -1.5817437295201494e-66, -1.0543614700025295e-68, -4.7021269020780175e-71, -1.4011291188963717e-73, -2.7847419837862114e-76, -3.682889722511403e-79, -3.2303440722506503e-82, -1.8700496477424575e-85, -7.091289729649982e-89, -1.7392961448150412e-92, -2.694639226863542e-96, -2.5002591447241703e-100, -1.1723104281061928e-104, 0., 3.1532708632013586e-113, 1.808946658774357e-117, 5.244092642235582e-122, 9.105057364732837e-127, 9.985914915580865e-132, 7.08413866305797e-137, 3.29212036522752e-142, 1.0097979555774987e-147, 2.054375386747378e-153, 2.7813584914480284e-159, 2.5118695172180317e-165, 1.5158688024533707e-171, 6.121093575004189e-178}, {-1.3066526917689286e-68, -8.60302663621211e-67, -3.7053184356722944e-65, -1.0618845249715653e-63, -2.035624807888989e-62, -2.6163372696075926e-61, -2.2573004223004393e-60, -1.3082320054862024e-59, -5.095195207958667e-59, -1.3339147747290393e-58, -2.3477506423801444e-58, -2.7782204422778523e-58, -2.2104631498658403e-58, -1.1824807974127954e-58, -4.252805691763938e-59, -1.028227453968547e-59, -1.6710215543924024e-60, -1.825096661061016e-61, -1.339416842462553e-62, -6.603404179783887e-64, -2.1863325384570633e-65, -4.859683893944006e-67, -7.248658273739952e-69, -7.251668914583282e-71, -4.862602800598785e-73, -2.1837356764112372e-75, -6.561271467451912e-78, -1.3172239414318878e-80, -1.763836802905173e-83, -1.5716574382731651e-86, -9.287890551855269e-90, -3.6226271571526297e-93, -9.255517579711429e-97, -1.529524813636163e-100, -1.5965901519518183e-104, -9.981361537365783e-109, -3.1532708632013586e-113, 0., 3.850462763562729e-122, 1.4883197983134568e-126, 2.9071076396548e-131, 3.4009089969387292e-136, 2.5131763837729112e-141, 1.201285066847888e-146, 3.7614881918562868e-152, 7.773998337706791e-158, 1.0656550348064148e-163, 9.721237490802263e-170, 5.915483084202352e-176, 2.405382102189531e-182}, {-3.849254044066976e-73, -2.5362086424643585e-71, -1.0931870565463837e-69, -3.1354574129485053e-68, -6.015852776034814e-67, -7.739130618473797e-66, -6.683625919866777e-65, -3.877570442179058e-64, -1.511884349960966e-63, -3.962803489616351e-63, -6.983621969155176e-63, -8.27544975211017e-63, -6.594032842207893e-63, -3.533111562867124e-63, -1.2728974998729096e-63, -3.0833926863864706e-64, -5.0213434263833404e-65, -5.496796473734331e-66, -4.044144246925757e-67, -1.9993253079258942e-68, -6.640094945274887e-70, -1.481055887168916e-71, -2.2177921248527028e-73, -2.2286182273674126e-75, -1.5020623711029255e-77, -6.785731368215904e-80, -2.053104500046659e-82, -4.1561076516922566e-85, -5.621476220267096e-88, -5.071598935553651e-91, -3.044693102084931e-94, -1.2122855132940686e-97, -3.185784855294336e-101, -5.48404522076678e-105, -6.106138770612077e-109, -4.294528931945036e-113, -1.808946658774357e-117, -3.850462763562729e-122, 0., 2.134522566524386e-131, 5.5590981339631955e-136, 7.31628747620742e-141, 5.766966707986635e-146, 2.8714371814010836e-151, 9.247991043319646e-157, 1.9511334915945874e-162, 2.7170561028345784e-168, 2.509565583950002e-174, 1.54252431615493e-180, 6.324555406328157e-187}, {-7.635033828017736e-78, -5.0340808487636966e-76, -2.1714360302870103e-74, -6.232879033595724e-73, -1.196849829196015e-71, -1.541027856117209e-70, -1.3320773125689362e-69, -7.735730231382299e-69, -3.0193422634426365e-68, -7.922807956515755e-68, -1.3978933038473538e-67, -1.658590634254883e-67, -1.3234113577592407e-67, -7.101400818575739e-68, -2.562568810197324e-68, -6.218212781501466e-69, -1.0145615886968368e-69, -1.1129262307344839e-70, -8.206713498488897e-72, -4.067365434909824e-73, -1.3545926681406287e-74, -3.0307378025974486e-76, -4.554105751453314e-78, -4.5942829342471046e-80, -3.110316078251692e-82, -1.4123251137991733e-84, -4.298594677637015e-87, -8.762513185976708e-90, -1.1950784041985539e-92, -1.0890698322634634e-95, -6.6198687854042976e-99, -2.6776277352843428e-102, -7.183177008227548e-106, -1.2718491638176084e-109, -1.4751290594131356e-113, -1.1066431623627729e-117, -5.244092642235582e-122, -1.4883197983134568e-126, -2.134522566524386e-131, 0., 5.371897043025402e-141, 9.426551360731355e-146, 8.359148550532975e-151, 4.439587726581061e-156, 1.4894279174536069e-161, 3.2321650479884996e-167, 4.594729983612428e-173, 4.311211835631046e-179, 2.6830444261850042e-185, 1.1111959552031335e-191}, {-1.019717768753495e-82, -6.727826620739688e-81, -2.904039415965101e-79, -8.341833475540694e-78, -1.6030523789699585e-76, -2.0657283553621456e-75, -1.7871787962617783e-74, -1.0388165789111748e-73, -4.058581066048197e-73, -1.0660882642204989e-72, -1.8830891269850422e-72, -2.2369319347901172e-72, -1.7871570516725266e-72, -9.603024490483952e-73, -3.470423452744457e-73, -8.434666982725275e-74, -1.3785909271909922e-74, -1.5151133611316746e-75, -1.11955711073615e-76, -5.561296973772249e-78, -1.8567725615575063e-79, -4.1658445132262045e-81, -6.279141779727252e-83, -6.356532478894037e-85, -4.320229751373689e-87, -1.970477587571533e-89, -6.0281600485699327e-92, -1.2361306790648393e-94, -1.6976906381980157e-97, -1.5599906939293743e-100, -9.578124242229125e-104, -3.9226206898968816e-107, -1.0690108418787546e-110, -1.9322174182732083e-114, -2.305073929920832e-118, -1.801321415891358e-122, -9.105057364732837e-127, -2.9071076396548e-131, -5.5590981339631955e-136, -5.371897043025402e-141, 0., 6.137569696027762e-151, 7.2567870426179e-156, 4.335882453316415e-161, 1.5516117911221793e-166, 3.507404686322676e-172, 5.128457953591906e-178, 4.912256209101769e-184, 3.1056244399383004e-190, 1.3022871512635178e-196}, {-9.170627538185034e-88, -6.054319519023361e-86, -2.615042064156796e-84, -7.51689615434382e-83, -1.4455798910025226e-81, -1.864244323465417e-80, -1.6141812283317593e-79, -9.390722589438485e-79, -3.6722593777865266e-78, -9.65554092728927e-78, -1.7072867776371965e-77, -2.0303513026188487e-77, -1.6240442105734843e-77, -8.73770676141547e-78, -3.162045011525909e-78, -7.696556144129618e-79, -1.25996750586507e-79, -1.3871508609872735e-80, -1.0269435460528966e-81, -5.111809198805003e-83, -1.7105791366958238e-84, -3.8474644255802285e-86, -5.815359226932174e-88, -5.905259896487763e-90, -4.027457295114792e-92, -1.844146357548398e-94, -5.666868824134716e-97, -1.1680037322750555e-99, -1.6136740760649639e-102, -1.4931578797929682e-105, -9.244178297187553e-109, -3.824097593852311e-112, -1.055187880195541e-115, -1.937506203921064e-119, -2.3595371013959433e-123, -1.8965645143327724e-127, -9.985914915580865e-132, -3.4009089969387292e-136, -7.31628747620742e-141, -9.426551360731355e-146, -6.137569696027762e-151, 0., 3.1835343838143235e-161, 2.5361877633990103e-166, 1.021032336699358e-171, 2.461903506614485e-177, 3.749736197604244e-183, 3.694276375309554e-189, 2.3842519736302204e-195, 1.0156624471957327e-201}, {-5.55370073071511e-93, -3.6686573313577227e-91, -1.585594056992167e-89, -4.560763022899089e-88, -8.776915491609472e-87, -1.1327132966622955e-85, -9.815325238865429e-85, -5.714866432581012e-84, -2.2367439518407414e-83, -5.886518545073857e-83, -1.0418680192886844e-82, -1.2403080817276906e-82, -9.932053504170886e-83, -5.35001966260676e-83, -1.9385645245395134e-83, -4.725032542235834e-84, -7.746591058397873e-85, -8.542213242845466e-86, -6.335018996755028e-87, -3.15934996814233e-88, -1.0594110607189818e-89, -2.3882613918813506e-91, -3.6188525474404013e-93, -3.6850048002501015e-95, -2.5209978412830435e-97, -1.1583565795073586e-99, -3.573467439992185e-102, -7.398188623994025e-105, -1.0273500617833237e-107, -9.562815630278669e-111, -5.9617645487235546e-114, -2.4867927834210486e-117, -6.931148932601705e-121, -1.2885864795388056e-124, -1.5941776037479063e-128, -1.3080741281852516e-132, -7.08413866305797e-137, -2.5131763837729112e-141, -5.766966707986635e-146, -8.359148550532975e-151, -7.2567870426179e-156, -3.1835343838143235e-161, 0., 7.49668655941759e-172, 4.0240760854952925e-177, 1.091566594258278e-182, 1.7734079382997987e-188, 1.819977766711847e-194, 1.2081568125600832e-200, 5.253822477850654e-207}, {-2.2648713488959394e-98, -1.4969746454302089e-96, -6.47377702616433e-95, -1.8632655465311932e-93, -3.588102075743254e-92, -4.633868801967788e-91, -4.0183316727259215e-90, -2.34143660320529e-89, -9.171645525003332e-89, -2.415824359487939e-88, -4.279751287202609e-88, -5.099877217765554e-88, -4.088098505725244e-88, -2.2045527618881667e-88, -7.997644394303674e-89, -1.9518252565206502e-89, -3.2043718565466815e-90, -3.538715190474561e-91, -2.6285639709249175e-92, -1.3131762041752742e-93, -4.411756359400423e-95, -9.96614281695899e-97, -1.5135683903365587e-98, -1.54509901255744e-100, -1.0599745353724595e-102, -4.885485356412629e-105, -1.5123789722217282e-107, -3.1433734874273836e-110, -4.384534958337714e-113, -4.102157477242068e-116, -2.572638643088018e-119, -1.0806125862935541e-122, -3.0369649403485756e-126, -5.703125428600046e-130, -7.14382962353024e-134, -5.954786091816075e-138, -3.29212036522752e-142, -1.201285066847888e-146, -2.8714371814010836e-151, -4.439587726581061e-156, -4.335882453316415e-161, -2.5361877633990103e-166, -7.49668655941759e-172, 0., 8.014529840566498e-183, 2.8986837746207737e-188, 5.2979978033585854e-194, 5.799598540616306e-200, 4.0103652037660676e-206, 1.7937853260299933e-212}, {-6.220060785079234e-104, -4.11339527287121e-102, -1.7798770594544788e-100, -5.125844814224596e-99, -9.877044458326997e-98, -1.2764140579405886e-96, -1.1076294333258776e-95, -6.458749804207725e-95, -2.5319116817318527e-94, -6.674539662902589e-94, -1.1834511695081319e-93, -1.4115313124805838e-93, -1.1325997753825752e-93, -6.11403289792193e-94, -2.220507178163336e-94, -5.425599529676439e-95, -8.918750415868466e-96, -9.862859836593317e-97, -7.337003477461562e-98, -3.671289279340061e-99, -1.2355540848510718e-100, -2.796398731078606e-102, -4.255712393764116e-104, -4.354240859424243e-106, -2.9945989051782355e-108, -1.3840623232759687e-110, -4.297847970000632e-113, -8.963791771153576e-116, -1.2552178179536508e-118, -1.1796207044465407e-121, -7.435844633855125e-125, -3.141947779885248e-128, -8.891912368399078e-132, -1.683729972882295e-135, -2.1303718441365963e-139, -1.7979827575118066e-143, -1.0097979555774987e-147, -3.7614881918562868e-152, -9.247991043319646e-157, -1.4894279174536069e-161, -1.5516117911221793e-166, -1.021032336699358e-171, -4.0240760854952925e-177, -8.014529840566498e-183, 0., 3.889893209624496e-194, 9.479541880503435e-200, 1.16741704524028e-205, 8.610745338047711e-212, 4.0119550238285855e-218}, {-1.1503958157911162e-109, -7.6116263201827e-108, -3.295353159984968e-106, -9.495627751633632e-105, -1.8308116514106213e-103, -2.367444227532628e-102, -2.0557404996599352e-101, -1.1995631820541052e-100, -4.705876976887013e-100, -1.241505272328945e-99, -2.2030901264786906e-99, -2.629954818132111e-99, -2.112191187688286e-99, -1.1413237360071594e-99, -4.1494010661723756e-100, -1.0149947251272491e-100, -1.6704626548038543e-101, -1.8496515559073734e-102, -1.3778499815416547e-103, -6.9046988112645264e-105, -2.327465871407163e-106, -5.276856641992454e-108, -8.045818269644531e-110, -8.24913913152497e-112, -5.686181973333264e-114, -2.634661558677022e-116, -8.203986525476252e-119, -1.7163590198938377e-121, -2.4117974289064506e-124, -2.275432222364257e-127, -1.440742355683208e-130, -6.118943451652846e-134, -1.7420077142431296e-137, -3.321649452132556e-141, -4.237804252706054e-145, -3.612732506477955e-149, -2.054375386747378e-153, -7.773998337706791e-158, -1.9511334915945874e-162, -3.2321650479884996e-167, -3.507404686322676e-172, -2.461903506614485e-177, -1.091566594258278e-182, -2.8986837746207737e-188, -3.889893209624496e-194, 0., 8.571368123420431e-206, 1.4074324651898035e-211, 1.1678708059916329e-217, 5.804152789208761e-224}, {-1.432888241574451e-115, -9.485428872110193e-114, -4.108713514439711e-112, -1.1845748873780825e-110, -2.285224000621783e-109, -2.9568091760658557e-108, -2.5691138563586594e-107, -1.5001124424857287e-106, -5.889007633964447e-106, -1.554774706522347e-105, -2.761127082861111e-105, -3.2988083872225332e-105, -2.6516602529069853e-105, -1.4341430947796779e-105, -5.219073030287882e-106, -1.2779795360763556e-106, -2.1056185743692925e-107, -2.3342618057437243e-108, -1.7410685762540228e-109, -8.736849013943632e-111, -2.9494180656182496e-112, -6.697669881213701e-114, -1.0229945027077336e-115, -1.0508324102597375e-117, -7.258448763642916e-120, -3.370806395258902e-122, -1.052255025014392e-124, -2.207541658108396e-127, -3.1116023216021275e-130, -2.9458628108290222e-133, -1.8725556051663515e-136, -7.988391452889029e-140, -2.285885288123834e-143, -4.384656533405826e-147, -5.6331216303886775e-151, -4.8422606968780895e-155, -2.7813584914480284e-159, -1.0656550348064148e-163, -2.7170561028345784e-168, -4.594729983612428e-173, -5.128457953591906e-178, -3.749736197604244e-183, -1.7734079382997987e-188, -5.2979978033585854e-194, -9.479541880503435e-200, -8.571368123420431e-206, 0., 8.57466662885256e-218, 9.486875877057557e-224, 5.30419858089015e-230}, {-1.201987073921066e-121, -7.960671648573476e-120, -3.4499525287986557e-118, -9.951628697341358e-117, -1.9208584532739615e-115, -2.4867730515420334e-114, -2.1619947662068001e-113, -1.2631840083909157e-112, -4.962157549680666e-112, -1.3109820964599248e-111, -2.3298772487553437e-111, -2.785729658081502e-111, -2.2410648683531694e-111, -1.2131231340930479e-111, -4.418804187736741e-112, -1.0830776787948846e-112, -1.7863541510965892e-113, -1.9825321652779087e-114, -1.4804824555899224e-115, -7.438691007029867e-117, -2.5146304699529095e-118, -5.7187946031827384e-120, -8.748820139776976e-122, -9.002523964479906e-124, -6.230119718046233e-126, -2.899242996244423e-128, -9.071053510166145e-131, -1.9077994705549516e-133, -2.6965756224466048e-136, -2.560846357334929e-139, -1.6334697000744641e-142, -6.995769365200887e-146, -2.0107824094539396e-149, -3.8767490031698504e-153, -5.0102414580805764e-157, -4.336947346030757e-161, -2.5118695172180317e-165, -9.721237490802263e-170, -2.509565583950002e-174, -4.311211835631046e-179, -4.912256209101769e-184, -3.694276375309554e-189, -1.819977766711847e-194, -5.799598540616306e-200, -1.16741704524028e-205, -1.4074324651898035e-211, -8.57466662885256e-218, 0., 3.89440078594728e-230, 2.9031931958681018e-236}, {-6.790772555939938e-128, -4.499515123259978e-126, -1.9508973359149703e-124, -5.6302798221457715e-123, -1.087315458789726e-121, -1.4084171219657082e-120, -1.2251691438488705e-119, -7.162530146416653e-119, -2.8154117055503978e-118, -7.443098214026395e-118, -1.3237040315871191e-117, -1.5838504405139366e-117, -1.2751605326232831e-117, -6.908280936922718e-118, -2.5185217895638546e-118, -6.178734665195206e-119, -1.0200743482620232e-119, -1.1332785266161384e-120, -8.472322921740619e-122, -4.261990370786252e-123, -1.4425949891342461e-124, -3.2852686800182734e-126, -5.033369418455578e-128, -5.187630459875441e-130, -3.5962988684203733e-132, -1.6767400984953343e-134, -5.256989304876956e-137, -1.1081485984713764e-139, -1.5702361711815264e-142, -1.4953422262880277e-145, -9.567768203892137e-149, -4.111879703982744e-152, -1.1865055648194815e-155, -2.297771750504895e-159, -2.984828055711935e-163, -2.599095481852759e-167, -1.5158688024533707e-171, -5.915483084202352e-176, -1.54252431615493e-180, -2.6830444261850042e-185, -3.1056244399383004e-190, -2.3842519736302204e-195, -1.2081568125600832e-200, -4.0103652037660676e-206, -8.610745338047711e-212, -1.1678708059916329e-217, -9.486875877057557e-224, -3.89440078594728e-230, 0., 8.030117871767441e-243}, {-2.583921724614681e-134, -1.712830519903266e-132, -7.429844755786216e-131, -2.145263259770899e-129, -4.1449633742583885e-128, -5.371812116929777e-127, -4.67541873887591e-126, -2.7348731911719686e-125, -1.075650230971473e-124, -2.845472753799787e-124, -5.06380763771788e-124, -6.063192261479362e-124, -4.8850541621216716e-124, -2.6485595649794708e-124, -9.663626529423474e-125, -2.372847460233384e-125, -3.9210383103386586e-126, -4.360439265644691e-127, -3.2632341488788863e-128, -1.643391432285425e-129, -5.569159848437183e-131, -1.2699027335539602e-132, -1.9482941199065716e-134, -2.010979615716428e-136, -1.3963356970384552e-138, -6.521604439074687e-141, -2.0485546117090794e-143, -4.3271971769022445e-146, -6.1455332663198e-149, -5.867083775788905e-152, -3.764411041237585e-155, -1.6228160031729514e-158, -4.698984534431437e-162, -9.13568058811713e-166, -1.1920317938230949e-169, -1.0433072255326582e-173, -6.121093575004189e-178, -2.405382102189531e-182, -6.324555406328157e-187, -1.1111959552031335e-191, -1.3022871512635178e-196, -1.0156624471957327e-201, -5.253822477850654e-207, -1.7937853260299933e-212, -4.0119550238285855e-218, -5.804152789208761e-224, -5.30419858089015e-230, -2.9031931958681018e-236, -8.030117871767441e-243, 0.}}, {{0., 8.359402215769335e-25, 1.0992125193013074e-22, 7.218906916737023e-21, 2.8213093674519044e-19, 6.937049303014691e-18, 1.1002554920190981e-16, 1.1408524799213621e-15, 7.796036827458575e-15, 3.529284234907766e-14, 1.062221786314747e-13, 2.1309139125616647e-13, 2.854678474838515e-13, 2.55747663315766e-13, 1.5339597445445236e-13, 6.16522214290188e-14, 1.661599722370043e-14, 3.0047003526828998e-15, 3.647402736619567e-16, 2.973382038753893e-17, 1.6283647745101799e-18, 5.992587727506208e-20, 1.4823432164728663e-21, 2.4651885351772e-23, 2.7567774061223315e-25, 2.0733684568163923e-27, 1.0489117741094897e-29, 3.569819874399342e-32, 8.17427933234507e-35, 1.2594881394911808e-37, 1.3059336325606497e-40, 9.113128762977687e-44, 4.280226272445297e-47, 1.3531599577088638e-50, 2.8796677781228425e-54, 4.125453803968085e-58, 3.9788749023459215e-62, 2.583623837544059e-66, 1.129531256925265e-70, 3.32495068971461e-75, 6.590324453601002e-80, 8.795862491666609e-85, 7.905228318205092e-90, 4.784406273697283e-95, 1.9499869821346558e-100, 5.352256860294003e-106, 9.89360448157917e-112, 1.2316706579393061e-117, 1.0326818781450855e-123, 5.831486816730618e-130}, {-8.359402215769335e-25, 0., 5.519372642147009e-21, 4.832959817843347e-19, 2.1249193593964802e-17, 5.57306019105706e-16, 9.207468791211625e-15, 9.819964932179899e-14, 6.850284840809362e-13, 3.150361478852826e-12, 9.600274533056426e-12, 1.9453550779005163e-11, 2.6278106798014293e-11, 2.37069021948628e-11, 1.4303896295645436e-11, 5.778437703089895e-12, 1.5643088078456097e-12, 2.8398599382640914e-13, 3.4592721378618073e-14, 2.8287471039267202e-15, 1.5534587623975743e-16, 5.7312513359143574e-18, 1.4209201449126373e-19, 2.3679319179711124e-21, 2.6530318736398803e-23, 1.9988115130602442e-25, 1.012814001830059e-27, 3.4520725890425285e-30, 7.915515426200539e-33, 1.2211754664912045e-35, 1.267715411979306e-38, 8.856272180937624e-42, 4.163919273648502e-45, 1.3176771196389409e-48, 2.8067337141540353e-52, 4.024448527976431e-56, 3.884629292453903e-60, 2.5243745261770438e-64, 1.1044348159411494e-68, 3.253328262289172e-73, 6.452604995030651e-78, 8.617438953289393e-83, 7.74948096886665e-88, 4.692804923537791e-93, 1.9136878099053393e-98, 5.2553384966080623e-104, 9.719250955709383e-110, 1.2105371569221548e-115, 1.0154223504901693e-121, 5.736513032449699e-128}, {-1.0992125193013074e-22, -5.519372642147009e-21, 0., 1.588709537511988e-17, 9.313491186139331e-16, 2.7479973561600146e-14, 4.842744492802368e-13, 5.380095741372953e-12, 3.8603186403037354e-11, 1.8122985992594862e-10, 5.610382138736902e-10, 1.1510725720591877e-9, 1.570589542275798e-9, 1.428721434402835e-9, 8.680676258259652e-10, 3.527662799676098e-10, 9.598880397675921e-11, 1.7503685873580358e-11, 2.1405092224099938e-12, 1.7564340663843573e-13, 9.675645461025989e-15, 3.5795989552557323e-16, 8.896960972701532e-18, 1.4860284995791748e-19, 1.668394023911608e-21, 1.2593595785224772e-23, 6.392374977754309e-26, 2.182267039090301e-28, 5.0112964700735006e-31, 7.741856490506955e-34, 8.047168900288005e-37, 5.628452581066896e-40, 2.6492514162596483e-43, 8.392319966108183e-47, 1.7893634533066461e-50, 2.5680454937070706e-54, 2.4809714490639536e-58, 1.613543379191286e-62, 7.06483752544345e-67, 2.082607013084055e-71, 4.1334756412579885e-76, 5.523878840284171e-81, 4.970614286610612e-86, 3.011815615530488e-91, 1.228890645518513e-96, 3.3765857736430073e-102, 6.247902904001091e-108, 7.78563643443259e-114, 6.533832627162198e-120, 3.69288614519587e-126}, {-7.218906916737023e-21, -4.832959817843347e-19, -1.588709537511988e-17, 0., 2.038806376896795e-14, 8.02081542636754e-13, 1.5901800124588057e-11, 1.8844015910424737e-10, 1.4084303625435376e-9, 6.8010573365287955e-9, 2.1492848001012552e-8, 4.4796455727510605e-8, 6.188689330892502e-8, 5.6865432444424766e-8, 3.4838421549159064e-8, 1.4256680932955895e-8, 3.902378300641461e-9, 7.152531158799575e-10, 8.785810884248882e-11, 7.237630109995748e-12, 4.000827564475009e-13, 1.484727483867042e-14, 3.7004859688882604e-16, 6.196283936802793e-18, 6.972503011542983e-20, 5.273974984945682e-22, 2.682083585134484e-24, 9.172180596529822e-27, 2.109649117423594e-29, 3.2639851295164113e-32, 3.39736587826615e-35, 2.3792633568526337e-38, 1.1212265922064668e-41, 3.555781494350033e-45, 7.589335455317312e-49, 1.0902653819577774e-52, 1.054266144577473e-56, 6.862541588631504e-61, 3.007192248056573e-65, 8.871592278888318e-70, 1.7620855150392995e-74, 2.3564411868829756e-79, 2.121818103338917e-84, 1.2864650331241666e-89, 5.2522002460226215e-95, 1.4439497910042961e-100, 2.6732742916007365e-106, 3.3329419790081906e-112, 2.7984410216076168e-118, 1.5824112541692685e-124}, {-2.8213093674519044e-19, -2.1249193593964802e-17, -9.313491186139331e-16, -2.038806376896795e-14, 0., 1.1755105640031333e-11, 3.1073705169126676e-10, 4.142597465488483e-9, 3.302656264878025e-8, 1.661243136451953e-7, 5.399893409336862e-7, 1.1489198073033328e-6, 1.6124422488421906e-6, 1.5001298922987649e-6, 9.283330114383648e-7, 3.8306094764672393e-7, 1.055857407920152e-7, 1.946763004661537e-8, 2.4035692370035797e-9, 1.9888666707467057e-10, 1.1037199801752085e-11, 4.110183141678756e-13, 1.0275800770412439e-14, 1.7254124415488817e-16, 1.9464238655284876e-18, 1.4756137349025735e-20, 7.519780476163884e-23, 2.576482523902509e-25, 5.936349621237067e-28, 9.199258900694575e-31, 9.589366422076119e-34, 6.724906621976045e-37, 3.173156063884264e-40, 1.0075110500484379e-43, 2.1527882770463838e-47, 3.095864524353573e-51, 2.9965691787640526e-55, 1.9523515506718042e-59, 8.562687122777393e-64, 2.5281633275073995e-68, 5.025343669744097e-73, 6.725316722556046e-78, 6.0598957028223904e-83, 3.676551141906509e-88, 1.5019498083091743e-93, 4.131660879044951e-99, 7.653540173925681e-105, 9.547321380369642e-111, 8.020368646992216e-117, 4.5374521121483523e-123}, {-6.937049303014691e-18, -5.57306019105706e-16, -2.7479973561600146e-14, -8.02081542636754e-13, -1.1755105640031333e-11, 0., 3.0561564918474895e-9, 5.4324285086510465e-8, 4.872335466262374e-7, 2.614181459660112e-6, 8.851492072588875e-6, 0.000019371152970054563, 0.00002775266961080833, 0.000026229432013753834, 0.000016434588985482628, 6.849955295011011e-6, 1.903834769370182e-6, 3.5347892200090036e-7, 4.390201937839824e-8, 3.651362829459653e-9, 2.035366979232353e-10, 7.609301257960058e-12, 1.9089943162287115e-13, 3.2153212669095855e-15, 3.637253494643046e-17, 2.7643684868951953e-19, 1.4119337517120231e-21, 4.847687205276265e-24, 1.1190477250881714e-26, 1.7371471905434397e-29, 1.8137153066347534e-32, 1.2738209456014e-35, 6.018797178941935e-39, 1.9134732492385358e-42, 4.0934605244126464e-46, 5.893238970825806e-50, 5.710163811980661e-54, 3.7239736877466845e-58, 1.6347736983476406e-62, 4.8309055170199536e-67, 9.610452897861315e-72, 1.2871408156520257e-76, 1.160635421285723e-81, 7.046478719631338e-87, 2.8805311702013734e-92, 7.928907406897252e-98, 1.4696349653568385e-103, 1.8343192358336531e-109, 1.5417808718255823e-115, 8.726995677672399e-122}, {-1.1002554920190981e-16, -9.207468791211625e-15, -4.842744492802368e-13, -1.5901800124588057e-11, -3.1073705169126676e-10, -3.0561564918474895e-9, 0., 3.5900502938766274e-7, 4.293212963512276e-6, 0.000025913943191026167, 0.00009359291643754402, 0.0002133588851411078, 0.00031440864914986154, 0.0003033426301490509, 0.000193082464514279, 0.00008148295217382353, 0.000022875630743600264, 4.282639020978125e-6, 5.356226077816973e-7, 4.481328859906404e-8, 2.510822488671483e-9, 9.428716194964264e-11, 2.3747188816014534e-12, 4.013629666394486e-14, 4.554377053863146e-16, 3.471011459721697e-18, 1.777303228002838e-20, 6.116003314211655e-23, 1.414750845804171e-25, 2.200339632567615e-28, 2.3013191955879467e-31, 1.6188684351121724e-34, 7.660476794160211e-38, 2.4387351429737174e-41, 5.223807310013148e-45, 7.529520222208534e-49, 7.303728771184067e-53, 4.7682040032211066e-57, 2.0952226919074062e-61, 6.197265112580174e-66, 1.2339320252081022e-70, 1.6539718528040648e-75, 1.4925644936808555e-80, 9.068318829212709e-86, 3.70960849504275e-91, 1.0217731135494453e-96, 1.895056311167288e-102, 2.3667151751694093e-108, 1.990398321841839e-114, 1.1272417064385387e-120}, {-1.1408524799213621e-15, -9.819964932179899e-14, -5.380095741372953e-12, -1.8844015910424737e-10, -4.142597465488483e-9, -5.4324285086510465e-8, -3.5900502938766274e-7, 0., 0.00001907835262928201, 0.0001535432322025209, 0.0006238679557387686, 0.0015170124871634332, 0.0023286363574154716, 0.0023108677605446323, 0.001501548352649405, 0.000643728397691573, 0.0001829801681340061, 0.000034602479486725964, 4.363739069765876e-6, 3.6764879305811154e-7, 2.0721431846092988e-8, 7.821278950842812e-10, 1.978663384086856e-11, 3.357351363087365e-13, 3.822907891127813e-15, 2.922559670197335e-17, 1.500629812735693e-19, 5.176865101446246e-22, 1.2002314746823006e-24, 1.870565850278759e-27, 1.9601165228302586e-30, 1.3812466049486635e-33, 6.546526003750795e-37, 2.087193221944492e-40, 4.4769404421774444e-44, 6.461238508292077e-48, 6.274943438239138e-52, 4.101123278049741e-56, 1.803974273576164e-60, 5.341024239342496e-65, 1.0644240879452003e-69, 1.4279974189243255e-74, 1.2896952043247832e-79, 7.841804174319837e-85, 3.210218847259116e-90, 8.848341902672734e-96, 1.6421588699404943e-101, 2.0521569149058394e-107, 1.7268833350754281e-113, 9.785574300419778e-120}, {-7.796036827458575e-15, -6.850284840809362e-13, -3.8603186403037354e-11, -1.4084303625435376e-9, -3.302656264878025e-8, -4.872335466262374e-7, -4.293212963512276e-6, -0.00001907835262928201, 0., 0.00045904217280450974, 0.002486871376765943, 0.006803029006455056, 0.011138932302997612, 0.011514517688251054, 0.007695634551730396, 0.0033679266531881948, 0.0009725308877996425, 0.00018620941380670557, 0.000023720180663635205, 2.015099463202285e-6, 1.1436932531504964e-7, 4.342551681991778e-9, 1.1042326832829379e-10, 1.8820015409573318e-12, 2.1513783764104457e-14, 1.6504094697365363e-16, 8.500498166766947e-19, 2.940643363924798e-21, 6.83482841068838e-24, 1.067631844218634e-26, 1.1210594347599783e-29, 7.914795924923529e-33, 3.757803217838349e-36, 1.1999999282593864e-39, 2.5777619233435224e-43, 3.725404280295427e-47, 3.622611425808975e-51, 2.370453667075261e-55, 1.0438589142451478e-59, 3.093771027728399e-64, 6.171669146451181e-69, 8.287324584818034e-74, 7.491173595910302e-79, 4.558620509740756e-84, 1.8676148586831225e-89, 5.151478915566214e-95, 9.567226672991126e-101, 1.1963743263055286e-106, 1.0073746936372165e-112, 5.711797325815238e-119}, {-3.529284234907766e-14, -3.150361478852826e-12, -1.8122985992594862e-10, -6.8010573365287955e-9, -1.661243136451953e-7, -2.614181459660112e-6, -0.000025913943191026167, -0.0001535432322025209, -0.00045904217280450974, 0., 0.005003606399885301, 0.018250336436550156, 0.03361744005734332, 0.03706769232042864, 0.02580613715018625, 0.011616509354118666, 0.003424295757533351, 0.0006660532039283495, 0.00008590537009309427, 7.37163143632414e-6, 4.218721045699704e-7, 1.6130309511979422e-8, 4.12606176835782e-10, 7.068325854495335e-12, 8.116109296016145e-14, 6.250612547235566e-16, 3.2305807845149308e-18, 1.1210399061147035e-20, 2.6128292699396892e-23, 4.091589271458886e-26, 4.306109439401199e-29, 3.046452265116174e-32, 1.4491403178872877e-35, 4.6356673545059265e-39, 9.973997988554891e-43, 1.4435864742823677e-46, 1.405682689339808e-50, 9.209823677850527e-55, 4.060489191039003e-59, 1.2047794197713716e-63, 2.40588111370986e-68, 3.233777973970386e-73, 2.925800402707261e-78, 1.78198532843854e-83, 7.306555295310403e-89, 2.0169378432421135e-94, 3.7485559929314477e-100, 4.690788864668063e-106, 3.952350610872841e-112, 2.24237753910842e-118}, {-1.062221786314747e-13, -9.600274533056426e-12, -5.610382138736902e-10, -2.1492848001012552e-8, -5.399893409336862e-7, -8.851492072588875e-6, -0.00009359291643754402, -0.0006238679557387686, -0.002486871376765943, -0.005003606399885301, 0., 0.024717902836202794, 0.060707747850983956, 0.07530564877453384, 0.055922133194524604, 0.026221959479049754, 0.007950514237968645, 0.0015786567695581894, 0.00020684190657235346, 0.0000179711911831058, 1.0388644043326489e-6, 4.0052062152686146e-8, 1.0316784535344073e-9, 1.777880721592568e-11, 2.051896284090578e-13, 1.5873203983095052e-15, 8.23611512052835e-18, 2.8679279098355357e-20, 6.705029272585399e-23, 1.0528981872605269e-25, 1.110878357101041e-28, 7.877016097097725e-32, 3.754706771085388e-35, 1.2033711633682501e-38, 2.5936492893227683e-42, 3.759933869103759e-46, 3.666634512476031e-50, 2.4056242333536372e-54, 1.0619623838012997e-58, 3.1546779113705954e-63, 6.306733292027934e-68, 8.485797340650386e-73, 7.685134547344672e-78, 4.6850031626785024e-83, 1.922623691265043e-88, 5.311642041728248e-94, 9.879512625834119e-100, 1.2371853094755174e-105, 1.0431462346263851e-111, 5.92221393488313e-118}, {-2.1309139125616647e-13, -1.9453550779005163e-11, -1.1510725720591877e-9, -4.4796455727510605e-8, -1.1489198073033328e-6, -0.000019371152970054563, -0.0002133588851411078, -0.0015170124871634332, -0.006803029006455056, -0.018250336436550156, -0.024717902836202794, 0., 0.05535691329613324, 0.09155752310569622, 0.07648966041821145, 0.03825717246897867, 0.012082914809359316, 0.0024677358283247317, 0.00033006868667600207, 0.000029132790235704396, 1.7051363594781917e-6, 6.640334180497704e-8, 1.7246999050318117e-9, 2.99294167999718e-11, 3.4747891879076993e-13, 2.7018368073726368e-15, 1.4081581226147503e-17, 4.922628157959444e-20, 1.1548746124589138e-22, 1.819127009148841e-25, 1.924632657932367e-28, 1.3681388449229827e-31, 6.536275958894155e-35, 2.099192107674702e-38, 4.5329986011932255e-42, 6.5827775510300404e-46, 6.429719433898217e-50, 4.224692597391267e-54, 1.867551584072111e-58, 5.554855912555055e-63, 1.1118314340680534e-67, 1.497648708869611e-72, 1.357753499126372e-77, 8.285212786171936e-83, 3.403196706514876e-88, 9.41016876491825e-94, 1.7516962653833382e-99, 2.195296935093994e-105, 1.852341522556273e-111, 1.0523514924811878e-117}, {-2.854678474838515e-13, -2.6278106798014293e-11, -1.570589542275798e-9, -6.188689330892502e-8, -1.6124422488421906e-6, -0.00002775266961080833, -0.00031440864914986154, -0.0023286363574154716, -0.011138932302997612, -0.03361744005734332, -0.060707747850983956, -0.05535691329613324, 0., 0.05621685487836385, 0.06262013203745719, 0.03523519160073214, 0.011870368621680217, 0.0025253403950017137, 0.00034742417967279047, 0.000031303481399726785, 1.8612688022335822e-6, 7.338967269443063e-8, 1.9254106048911616e-9, 3.3690867885414675e-11, 3.93884472355675e-13, 3.0808952716872706e-15, 1.6139523423150464e-17, 5.667229669988815e-20, 1.3347760359054975e-22, 2.109803184520364e-25, 2.239078192583274e-28, 1.596085985620497e-31, 7.644403203206535e-35, 2.4606582691459345e-38, 5.3245503120806684e-42, 7.746905868382094e-46, 7.579939875623422e-50, 4.9884345633448303e-54, 2.208435376676063e-58, 6.577805631343285e-63, 1.3182612523912752e-67, 1.777825801610953e-72, 1.6135521145302076e-77, 9.856390182477027e-83, 4.0525240038261184e-88, 1.1215920965825945e-93, 2.0896434114594763e-99, 2.62096559385094e-105, 2.2132187662671993e-111, 1.2582920537721812e-117}, {-2.55747663315766e-13, -2.37069021948628e-11, -1.428721434402835e-9, -5.6865432444424766e-8, -1.5001298922987649e-6, -0.000026229432013753834, -0.0003033426301490509, -0.0023108677605446323, -0.011514517688251054, -0.03706769232042864, -0.07530564877453384, -0.09155752310569622, -0.05621685487836385, 0., 0.025892629504243495, 0.019425739123493903, 0.0073623700589479976, 0.0016707139021876643, 0.0002394258116996186, 0.00002218901502131996, 1.3468192798064373e-6, 5.3947907242863425e-8, 1.4330391084308343e-9, 2.5328629263179543e-11, 2.985880849119301e-13, 2.3518358334430843e-15, 1.239362059101153e-17, 4.3742113543033924e-20, 1.0348367682747805e-22, 1.6421210888380925e-25, 1.7487907609639463e-28, 1.2504529694121168e-31, 6.005640959463894e-35, 1.938001811619971e-38, 4.2031193548306884e-42, 6.127951190929846e-46, 6.007233716215103e-50, 3.960296358445414e-54, 1.7560768991540846e-58, 5.238208655510737e-63, 1.0512339874451805e-67, 1.4195196607736928e-72, 1.2898877364311818e-77, 7.888049405832867e-83, 3.246605239396172e-88, 8.994212673645015e-94, 1.6772560942596008e-99, 2.105544217749725e-105, 1.779434724707396e-111, 1.0124519109888808e-117}, {-1.5339597445445236e-13, -1.4303896295645436e-11, -8.680676258259652e-10, -3.4838421549159064e-8, -9.283330114383648e-7, -0.000016434588985482628, -0.000193082464514279, -0.001501548352649405, -0.007695634551730396, -0.02580613715018625, -0.055922133194524604, -0.07648966041821145, -0.06262013203745719, -0.025892629504243495, 0., 0.005409598026563371, 0.002733655746706091, 0.0006978800578014373, 0.00010667886685760344, 0.00001029850577007099, 6.42954105245435e-7, 2.62905755467092e-8, 7.094519043280801e-10, 1.2696138026557274e-11, 1.5118100452623479e-13, 1.2007037881344302e-15, 6.371673730869883e-18, 2.2622079211103602e-20, 5.37930372717758e-23, 8.57420560527066e-26, 9.166981396835752e-29, 6.57750545608369e-32, 3.1688064071701006e-35, 1.0254045082680507e-38, 2.229460910477183e-42, 3.2578369892290034e-46, 3.2002714135211625e-50, 2.113789417347796e-54, 9.389278075912819e-59, 2.80521978374193e-63, 5.638017453429434e-68, 7.623678677142198e-73, 6.936324233340484e-78, 4.246819509623333e-83, 1.7498728164215737e-88, 4.852799034558041e-94, 9.058428392062398e-100, 1.1381954042019264e-105, 9.627430065862328e-112, 5.482231700426251e-118}, {-6.16522214290188e-14, -5.778437703089895e-12, -3.527662799676098e-10, -1.4256680932955895e-8, -3.8306094764672393e-7, -6.849955295011011e-6, -0.00008148295217382353, -0.000643728397691573, -0.0033679266531881948, -0.011616509354118666, -0.026221959479049754, -0.03825717246897867, -0.03523519160073214, -0.019425739123493903, -0.005409598026563371, 0., 0.0005127258645191815, 0.00017452631890370917, 0.00003001311392339637, 3.090548782129817e-6, 2.0098799922371611e-7, 8.453269274284867e-9, 2.328640310633383e-10, 4.233411762376493e-12, 5.104005521118998e-14, 4.094629349158244e-16, 2.190969680213011e-18, 7.833246833913327e-21, 1.8737549026256346e-23, 3.001940426748928e-26, 3.223806939242871e-29, 2.322221692739406e-32, 1.1226477832703085e-35, 3.644060058290996e-39, 7.945017659285276e-43, 1.1638886960230027e-46, 1.1459213882557701e-50, 7.584517599855805e-55, 3.375360743671295e-59, 1.0102050273870356e-63, 2.0335950497417867e-68, 2.753883516385565e-73, 2.509033834795724e-78, 1.5381377697754585e-83, 6.345336047209326e-89, 1.7616647597244089e-94, 3.291819172850114e-100, 4.140228070172859e-106, 3.5052322176275775e-112, 1.997743188724563e-118}, {-1.661599722370043e-14, -1.5643088078456097e-12, -9.598880397675921e-11, -3.902378300641461e-9, -1.055857407920152e-7, -1.903834769370182e-6, -0.000022875630743600264, -0.0001829801681340061, -0.0009725308877996425, -0.003424295757533351, -0.007950514237968645, -0.012082914809359316, -0.011870368621680217, -0.0073623700589479976, -0.002733655746706091, -0.0005127258645191815, 0., 0.000022048536336704252, 5.055552553711602e-6, 5.856601819529193e-7, 4.062645663496118e-8, 1.779886417979624e-9, 5.0431798147738036e-11, 9.359386819150962e-13, 1.1463241573804797e-14, 9.311206023437107e-17, 5.032601168719742e-19, 1.814270682214615e-21, 4.3701818357745276e-24, 7.043138323060198e-27, 7.60246858234875e-30, 5.5007737904379774e-33, 2.669705868276871e-36, 8.695824656017407e-40, 1.9017901892353664e-43, 2.793726499128867e-47, 2.757492615459257e-51, 1.8292514545511084e-55, 8.157627523875845e-60, 2.446104189599456e-64, 4.932698156337946e-69, 6.690538265505251e-74, 6.104708530704756e-79, 3.7475704092781243e-84, 1.5479733952748483e-89, 4.3027770315446495e-95, 8.049045139939669e-101, 1.0134091301554057e-106, 8.588190414198264e-113, 4.8991813202948965e-119}, {-3.0047003526828998e-15, -2.8398599382640914e-13, -1.7503685873580358e-11, -7.152531158799575e-10, -1.946763004661537e-8, -3.5347892200090036e-7, -4.282639020978125e-6, -0.000034602479486725964, -0.00018620941380670557, -0.0006660532039283495, -0.0015786567695581894, -0.0024677358283247317, -0.0025253403950017137, -0.0016707139021876643, -0.0006978800578014373, -0.00017452631890370917, -0.000022048536336704252, 0., 4.302138034575997e-7, 6.645078963107106e-8, 5.1858018221272755e-9, 2.423416067671938e-10, 7.152681949149017e-12, 1.365357292222636e-13, 1.7071088142776038e-15, 1.4086370942088294e-17, 7.708692651771541e-20, 2.807082032908482e-22, 6.817994611978735e-25, 1.1064959240693097e-27, 1.2014775428034289e-30, 8.737883887421996e-34, 4.25971359028765e-37, 1.392924387836292e-40, 3.056924593513751e-44, 4.504519780211755e-48, 4.458447636828238e-52, 2.9650349501644767e-56, 1.325275570608539e-60, 3.9821306365840985e-65, 8.045385196080849e-70, 1.0931455695293684e-74, 9.990271732423397e-80, 6.141933245001769e-85, 2.5404750383492392e-90, 7.070572537629495e-96, 1.3242403387153587e-101, 1.6691296832126553e-107, 1.4159864170798095e-113, 8.085469785724128e-120}, {-3.647402736619567e-16, -3.4592721378618073e-14, -2.1405092224099938e-12, -8.785810884248882e-11, -2.4035692370035797e-9, -4.390201937839824e-8, -5.356226077816973e-7, -4.363739069765876e-6, -0.000023720180663635205, -0.00008590537009309427, -0.00020684190657235346, -0.00033006868667600207, -0.00034742417967279047, -0.0002394258116996186, -0.00010667886685760344, -0.00003001311392339637, -5.055552553711602e-6, -4.302138034575997e-7, 0., 3.809158282496337e-9, 3.9635425597018227e-10, 2.0837620073496353e-11, 6.560210426977011e-13, 1.3044394875043003e-14, 1.6775415436114874e-16, 1.4130776996627898e-18, 7.855739562996185e-21, 2.896386288619905e-23, 7.105961293222168e-26, 1.1628404394763611e-28, 1.2714884527735972e-31, 9.302088240436673e-35, 4.5580180965047625e-38, 1.4971237075234935e-41, 3.298486084195278e-45, 4.877348447881718e-49, 4.842408725858615e-53, 3.2293289894564886e-57, 1.4470240937550933e-61, 4.357837042629135e-66, 8.822680573944806e-71, 1.2010289122107437e-75, 1.099530809617643e-80, 6.770654014632591e-86, 2.8046804345688185e-91, 7.816623318626979e-97, 1.4658371208454097e-102, 1.84980390839997e-108, 1.5710048191326798e-114, 8.979989793649161e-121}, {-2.973382038753893e-17, -2.8287471039267202e-15, -1.7564340663843573e-13, -7.237630109995748e-12, -1.9888666707467057e-10, -3.651362829459653e-9, -4.481328859906404e-8, -3.6764879305811154e-7, -2.015099463202285e-6, -7.37163143632414e-6, -0.0000179711911831058, -0.000029132790235704396, -0.000031303481399726785, -0.00002218901502131996, -0.00001029850577007099, -3.090548782129817e-6, -5.856601819529193e-7, -6.645078963107106e-8, -3.809158282496337e-9, 0., 1.5305211659398824e-11, 1.072859042633793e-12, 3.7998359145649656e-14, 8.059344751280475e-16, 1.0796372187115682e-17, 9.354165785674216e-20, 5.308611454223321e-22, 1.988335974227535e-24, 4.939137955415232e-27, 8.164192780122417e-30, 9.001391877325175e-33, 6.631383714083614e-36, 3.268715868719175e-39, 1.0791461705558903e-42, 2.3882057644974036e-46, 3.5451992973542265e-50, 3.532024191215068e-54, 2.362745828419456e-58, 1.0616593218161739e-62, 3.205291241115669e-67, 6.504036644042109e-72, 8.872257067977226e-77, 8.137852371880975e-82, 5.019814449189804e-87, 2.0827438236930582e-92, 5.8131907977943044e-98, 1.0916345136054692e-103, 1.3793406516759564e-109, 1.1728435130356935e-115, 6.71152502138982e-122}, {-1.6283647745101799e-18, -1.5534587623975743e-16, -9.675645461025989e-15, -4.000827564475009e-13, -1.1037199801752085e-11, -2.035366979232353e-10, -2.510822488671483e-9, -2.0721431846092988e-8, -1.1436932531504964e-7, -4.218721045699704e-7, -1.0388644043326489e-6, -1.7051363594781917e-6, -1.8612688022335822e-6, -1.3468192798064373e-6, -6.42954105245435e-7, -2.0098799922371611e-7, -4.062645663496118e-8, -5.1858018221272755e-9, -3.9635425597018227e-10, -1.5305211659398824e-11, 0., 2.790854409739326e-14, 1.3179474528067848e-15, 3.144745527357892e-17, 4.493578631336932e-19, 4.055536623011374e-21, 2.3673292333098023e-23, 9.051537063213422e-26, 2.284142239738818e-28, 3.822788505335759e-31, 4.257370974755967e-34, 3.162569719513022e-37, 1.5697828355625353e-40, 5.213388642492902e-44, 1.1596662816008626e-47, 1.7291650217866226e-51, 1.7294947245934195e-55, 1.1609618058858653e-59, 5.232733205035434e-64, 1.584220442261573e-68, 3.222687475650669e-73, 4.406109049398955e-78, 4.0497588467715064e-83, 2.5028151175359055e-88, 1.0402353285150766e-93, 2.9080759784356737e-99, 5.4690431862945384e-105, 6.919931247573622e-111, 5.891482805068252e-117, 3.375378406499822e-123}, {-5.992587727506208e-20, -5.7312513359143574e-18, -3.5795989552557323e-16, -1.484727483867042e-14, -4.110183141678756e-13, -7.609301257960058e-12, -9.428716194964264e-11, -7.821278950842812e-10, -4.342551681991778e-9, -1.6130309511979422e-8, -4.0052062152686146e-8, -6.640334180497704e-8, -7.338967269443063e-8, -5.3947907242863425e-8, -2.62905755467092e-8, -8.453269274284867e-9, -1.779886417979624e-9, -2.423416067671938e-10, -2.0837620073496353e-11, -1.072859042633793e-12, -2.790854409739326e-14, 0., 2.3096247767204565e-17, 7.347973467883453e-19, 1.1812095225391613e-20, 1.1371339999883867e-22, 6.9143402243424335e-25, 2.7192483572949597e-27, 7.004941755177011e-30, 1.190970706158093e-32, 1.3429422424151225e-35, 1.0076756256290564e-38, 5.0434108174556285e-42, 1.6866746807962866e-45, 3.774171900308341e-49, 5.65648381644964e-53, 5.682819322511745e-57, 3.829678564447691e-61, 1.7321214471103727e-65, 5.26026771432842e-70, 1.0730380614585323e-74, 1.4707514082926174e-79, 1.3548746189239558e-84, 8.390675871123127e-90, 3.493988924125913e-95, 9.784763034904812e-101, 1.8431103754903335e-106, 2.335525932374694e-112, 1.9911486227488432e-118, 1.1422359680001217e-124}, {-1.4823432164728663e-21, -1.4209201449126373e-19, -8.896960972701532e-18, -3.7004859688882604e-16, -1.0275800770412439e-14, -1.9089943162287115e-13, -2.3747188816014534e-12, -1.978663384086856e-11, -1.1042326832829379e-10, -4.12606176835782e-10, -1.0316784535344073e-9, -1.7246999050318117e-9, -1.9254106048911616e-9, -1.4330391084308343e-9, -7.094519043280801e-10, -2.328640310633383e-10, -5.0431798147738036e-11, -7.152681949149017e-12, -6.560210426977011e-13, -3.7998359145649656e-14, -1.3179474528067848e-15, -2.3096247767204565e-17, 0., 8.67498039443893e-21, 1.8593733350724582e-22, 2.0137419927138e-24, 1.3060856280729829e-26, 5.350551479771664e-29, 1.417714094663383e-31, 2.460594509493366e-34, 2.8186148163580704e-37, 2.141382165040291e-40, 1.0825864289783238e-43, 3.6506792965486987e-47, 8.22603378285189e-51, 1.2402030175050014e-54, 1.2523667918828156e-58, 8.477435974897176e-63, 3.8492872268449516e-67, 1.1730463755192172e-71, 2.4002968173019943e-76, 3.2990872118436334e-81, 3.0467774051251177e-86, 1.8911434671203787e-91, 7.89127697468893e-97, 2.214103023155309e-102, 4.1778562713564904e-108, 5.302519479745374e-114, 4.5273511412183445e-120, 2.6007133233149428e-126}, {-2.4651885351772e-23, -2.3679319179711124e-21, -1.4860284995791748e-19, -6.196283936802793e-18, -1.7254124415488817e-16, -3.2153212669095855e-15, -4.013629666394486e-14, -3.357351363087365e-13, -1.8820015409573318e-12, -7.068325854495335e-12, -1.777880721592568e-11, -2.99294167999718e-11, -3.3690867885414675e-11, -2.5328629263179543e-11, -1.2696138026557274e-11, -4.233411762376493e-12, -9.359386819150962e-13, -1.365357292222636e-13, -1.3044394875043003e-14, -8.059344751280475e-16, -3.144745527357892e-17, -7.347973467883453e-19, -8.67498039443893e-21, 0., 1.4788793910068143e-24, 2.1355449714555793e-26, 1.5582210536853172e-28, 6.809021224258416e-31, 1.8793322436381116e-33, 3.3549759782656984e-36, 3.923195384071669e-39, 3.02787409778262e-42, 1.5498913055710608e-45, 5.279309845472244e-49, 1.1994940053089224e-52, 1.8210708028824737e-56, 1.8498776862305706e-60, 1.2586281740930949e-64, 5.740473929915077e-69, 1.756234066964674e-73, 3.6060979544768225e-78, 4.971745101008904e-83, 4.6042668430401145e-88, 2.8650442354317013e-93, 1.1982296302627677e-98, 3.368905459678703e-104, 6.368926593903075e-110, 8.097475817091827e-116, 6.924796166853624e-122, 3.983806357554856e-128}, {-2.7567774061223315e-25, -2.6530318736398803e-23, -1.668394023911608e-21, -6.972503011542983e-20, -1.9464238655284876e-18, -3.637253494643046e-17, -4.554377053863146e-16, -3.822907891127813e-15, -2.1513783764104457e-14, -8.116109296016145e-14, -2.051896284090578e-13, -3.4747891879076993e-13, -3.93884472355675e-13, -2.985880849119301e-13, -1.5118100452623479e-13, -5.104005521118998e-14, -1.1463241573804797e-14, -1.7071088142776038e-15, -1.6775415436114874e-16, -1.0796372187115682e-17, -4.493578631336932e-19, -1.1812095225391613e-20, -1.8593733350724582e-22, -1.4788793910068143e-24, 0., 1.1443182564187788e-28, 1.1132838521949486e-30, 5.472856389873446e-33, 1.6112452605899435e-35, 2.9962377387594365e-38, 3.6038047121442557e-41, 2.839317549126573e-44, 1.476443460161391e-47, 5.0919925793113706e-51, 1.1686204923091256e-54, 1.7889836499237746e-58, 1.8299912302320743e-62, 1.2525090329779256e-66, 5.741860361216509e-71, 1.764500454422483e-75, 3.6372795572299944e-80, 5.0321476065373146e-85, 4.674632676613167e-90, 2.9169100576012562e-95, 1.222978596960313e-100, 3.446303638349254e-106, 6.528737225815776e-112, 8.316380566475743e-118, 7.1243677378481656e-124, 4.1051873498702635e-130}, {-2.0733684568163923e-27, -1.9988115130602442e-25, -1.2593595785224772e-23, -5.273974984945682e-22, -1.4756137349025735e-20, -2.7643684868951953e-19, -3.471011459721697e-18, -2.922559670197335e-17, -1.6504094697365363e-16, -6.250612547235566e-16, -1.5873203983095052e-15, -2.7018368073726368e-15, -3.0808952716872706e-15, -2.3518358334430843e-15, -1.2007037881344302e-15, -4.094629349158244e-16, -9.311206023437107e-17, -1.4086370942088294e-17, -1.4130776996627898e-18, -9.354165785674216e-20, -4.055536623011374e-21, -1.1371339999883867e-22, -2.0137419927138e-24, -2.1355449714555793e-26, -1.1443182564187788e-28, 0., 4.019035877460991e-33, 2.634321413444441e-35, 8.725069303213975e-38, 1.7306618714693191e-40, 2.1683329615225664e-43, 1.7571674350019185e-46, 9.327619946189903e-50, 3.2679936845167405e-53, 7.593849329296921e-57, 1.1742475297184978e-60, 1.2111736575185607e-64, 8.347659565263696e-69, 3.849584988010646e-73, 1.1890620546166224e-77, 2.4620333251108722e-82, 3.419561366647361e-87, 3.1876444615401394e-92, 1.9952067758804098e-97, 8.388579617707798e-103, 2.3697918874511054e-108, 4.4995778680918204e-114, 5.743480734597169e-120, 4.929568338016713e-126, 2.8454449243805095e-132}, {-1.0489117741094897e-29, -1.012814001830059e-27, -6.392374977754309e-26, -2.682083585134484e-24, -7.519780476163884e-23, -1.4119337517120231e-21, -1.777303228002838e-20, -1.500629812735693e-19, -8.500498166766947e-19, -3.2305807845149308e-18, -8.23611512052835e-18, -1.4081581226147503e-17, -1.6139523423150464e-17, -1.239362059101153e-17, -6.371673730869883e-18, -2.190969680213011e-18, -5.032601168719742e-19, -7.708692651771541e-20, -7.855739562996185e-21, -5.308611454223321e-22, -2.3673292333098023e-23, -6.9143402243424335e-25, -1.3060856280729829e-26, -1.5582210536853172e-28, -1.1132838521949486e-30, -4.019035877460991e-33, 0., 6.407193703824362e-38, 2.8294805546343192e-40, 6.31397090901773e-43, 8.438107348911154e-46, 7.122967904024483e-49, 3.8891360887672234e-52, 1.3909718758024414e-55, 3.2835114947306553e-59, 5.140806438175441e-63, 5.356027754579852e-67, 3.72224757697803e-71, 1.7285458081256295e-75, 5.370922975343084e-80, 1.1177888961839534e-84, 1.5594475260122402e-89, 1.4593854918226155e-94, 9.166286233845736e-100, 3.865773658579523e-105, 1.0951230023794102e-110, 2.0845463701669357e-116, 2.666864006908273e-122, 2.2936799793406555e-128, 1.3264652152719332e-134}, {-3.569819874399342e-32, -3.4520725890425285e-30, -2.182267039090301e-28, -9.172180596529822e-27, -2.576482523902509e-25, -4.847687205276265e-24, -6.116003314211655e-23, -5.176865101446246e-22, -2.940643363924798e-21, -1.1210399061147035e-20, -2.8679279098355357e-20, -4.922628157959444e-20, -5.667229669988815e-20, -4.3742113543033924e-20, -2.2622079211103602e-20, -7.833246833913327e-21, -1.814270682214615e-21, -2.807082032908482e-22, -2.896386288619905e-23, -1.988335974227535e-24, -9.051537063213422e-26, -2.7192483572949597e-27, -5.350551479771664e-29, -6.809021224258416e-31, -5.472856389873446e-33, -2.634321413444441e-35, -6.407193703824362e-38, 0., 4.636535627735378e-43, 1.3795206343532745e-45, 2.0740689641674493e-48, 1.8675311640863837e-51, 1.0621571514923707e-54, 3.907405133591646e-58, 9.415935553191512e-62, 1.4975992468913602e-65, 1.5798003714793234e-69, 1.1089946577356705e-73, 5.192891107087085e-78, 1.6248141826084786e-82, 3.4016685212222733e-87, 4.7700664128077515e-92, 4.4839233938759384e-97, 2.8273616264681983e-102, 1.1965468893258204e-107, 3.4001547911582026e-113, 6.490109869996853e-119, 8.323930669117115e-125, 7.175403383550961e-131, 4.1582212533739323e-137}, {-8.17427933234507e-35, -7.915515426200539e-33, -5.0112964700735006e-31, -2.109649117423594e-29, -5.936349621237067e-28, -1.1190477250881714e-26, -1.414750845804171e-25, -1.2002314746823006e-24, -6.83482841068838e-24, -2.6128292699396892e-23, -6.705029272585399e-23, -1.1548746124589138e-22, -1.3347760359054975e-22, -1.0348367682747805e-22, -5.37930372717758e-23, -1.8737549026256346e-23, -4.3701818357745276e-24, -6.817994611978735e-25, -7.105961293222168e-26, -4.939137955415232e-27, -2.284142239738818e-28, -7.004941755177011e-30, -1.417714094663383e-31, -1.8793322436381116e-33, -1.6112452605899435e-35, -8.725069303213975e-38, -2.8294805546343192e-40, -4.636535627735378e-43, 0., 1.5230251300540325e-48, 3.0530983736709856e-51, 3.092701359334189e-54, 1.8762367083233896e-57, 7.189787601536557e-61, 1.7820732523246023e-64, 2.8934270022433837e-68, 3.1006914609029273e-72, 2.2038438885070073e-76, 1.0423783788997725e-80, 3.2886980776419446e-85, 6.93328015042633e-90, 9.780219601717303e-95, 9.24067774082161e-100, 5.852770567944759e-105, 2.4866212885496623e-110, 7.090616043545663e-116, 1.3576249702672263e-121, 1.74606707728505e-127, 1.5089188573786676e-133, 8.76421598644183e-140}, {-1.2594881394911808e-37, -1.2211754664912045e-35, -7.741856490506955e-34, -3.2639851295164113e-32, -9.199258900694575e-31, -1.7371471905434397e-29, -2.200339632567615e-28, -1.870565850278759e-27, -1.067631844218634e-26, -4.091589271458886e-26, -1.0528981872605269e-25, -1.819127009148841e-25, -2.109803184520364e-25, -1.6421210888380925e-25, -8.57420560527066e-26, -3.001940426748928e-26, -7.043138323060198e-27, -1.1064959240693097e-27, -1.1628404394763611e-28, -8.164192780122417e-30, -3.822788505335759e-31, -1.190970706158093e-32, -2.460594509493366e-34, -3.3549759782656984e-36, -2.9962377387594365e-38, -1.7306618714693191e-40, -6.31397090901773e-43, -1.3795206343532745e-45, -1.5230251300540325e-48, 0., 2.2709909635951206e-54, 3.0672652195836384e-57, 2.093406151065792e-60, 8.556785625548176e-64, 2.2092705819736483e-67, 3.689524039438233e-71, 4.0361863578754074e-75, 2.91429095935073e-79, 1.3956371072667407e-83, 4.447704476049357e-88, 9.454853238065169e-93, 1.343046668959595e-97, 1.2765086012404913e-102, 8.126487662932426e-108, 3.468051417585168e-113, 9.927951209529175e-119, 1.9074837083634594e-124, 2.4608459735866292e-130, 2.1325248236241617e-136, 1.2417334394180263e-142}, {-1.3059336325606497e-40, -1.267715411979306e-38, -8.047168900288005e-37, -3.39736587826615e-35, -9.589366422076119e-34, -1.8137153066347534e-32, -2.3013191955879467e-31, -1.9601165228302586e-30, -1.1210594347599783e-29, -4.306109439401199e-29, -1.110878357101041e-28, -1.924632657932367e-28, -2.239078192583274e-28, -1.7487907609639463e-28, -9.166981396835752e-29, -3.223806939242871e-29, -7.60246858234875e-30, -1.2014775428034289e-30, -1.2714884527735972e-31, -9.001391877325175e-33, -4.257370974755967e-34, -1.3429422424151225e-35, -2.8186148163580704e-37, -3.923195384071669e-39, -3.6038047121442557e-41, -2.1683329615225664e-43, -8.438107348911154e-46, -2.0740689641674493e-48, -3.0530983736709856e-51, -2.2709909635951206e-54, 0., 1.5371812107256814e-60, 1.3988333239178748e-63, 6.4324385793996e-67, 1.7715060080679302e-70, 3.0817175474612937e-74, 3.467593286702999e-78, 2.555904926063776e-82, 1.2434368060857046e-86, 4.012196230709053e-91, 8.615209437993653e-96, 1.2339747584798642e-100, 1.1810420814727525e-105, 7.563484651858382e-111, 3.244337581272737e-116, 9.328990343041527e-122, 1.7994327961503733e-127, 2.3295100096877393e-133, 2.0249613220796245e-139, 1.1823762970579741e-145}, {-9.113128762977687e-44, -8.856272180937624e-42, -5.628452581066896e-40, -2.3792633568526337e-38, -6.724906621976045e-37, -1.2738209456014e-35, -1.6188684351121724e-34, -1.3812466049486635e-33, -7.914795924923529e-33, -3.046452265116174e-32, -7.877016097097725e-32, -1.3681388449229827e-31, -1.596085985620497e-31, -1.2504529694121168e-31, -6.57750545608369e-32, -2.322221692739406e-32, -5.5007737904379774e-33, -8.737883887421996e-34, -9.302088240436673e-35, -6.631383714083614e-36, -3.162569719513022e-37, -1.0076756256290564e-38, -2.141382165040291e-40, -3.02787409778262e-42, -2.839317549126573e-44, -1.7571674350019185e-46, -7.122967904024483e-49, -1.8675311640863837e-51, -3.092701359334189e-54, -3.0672652195836384e-57, -1.5371812107256814e-60, 0., 4.723260540473039e-67, 2.8959450518855678e-70, 8.972424679249429e-74, 1.6649022741939589e-77, 1.9514293639622429e-81, 1.4794620642864217e-85, 7.347467940309931e-90, 2.408438557807487e-94, 5.236176502454814e-99, 7.575643326882587e-104, 7.311100258985645e-109, 4.7148268920875524e-114, 2.0344512244863316e-119, 5.880000302429231e-125, 1.1392337335648561e-130, 1.4806130417079474e-136, 1.2915138769608427e-142, 7.564505575589429e-149}, {-4.280226272445297e-47, -4.163919273648502e-45, -2.6492514162596483e-43, -1.1212265922064668e-41, -3.173156063884264e-40, -6.018797178941935e-39, -7.660476794160211e-38, -6.546526003750795e-37, -3.757803217838349e-36, -1.4491403178872877e-35, -3.754706771085388e-35, -6.536275958894155e-35, -7.644403203206535e-35, -6.005640959463894e-35, -3.1688064071701006e-35, -1.1226477832703085e-35, -2.669705868276871e-36, -4.25971359028765e-37, -4.5580180965047625e-38, -3.268715868719175e-39, -1.5697828355625353e-40, -5.0434108174556285e-42, -1.0825864289783238e-43, -1.5498913055710608e-45, -1.476443460161391e-47, -9.327619946189903e-50, -3.8891360887672234e-52, -1.0621571514923707e-54, -1.8762367083233896e-57, -2.093406151065792e-60, -1.3988333239178748e-63, -4.723260540473039e-67, 0., 6.5882675616692866e-74, 2.7216324161183605e-77, 5.68147260215432e-81, 7.103194872629451e-85, 5.6096206662669706e-89, 2.8655092645114227e-93, 9.588585192631387e-98, 2.1177401078003686e-102, 3.1022224431435256e-107, 3.0241335141748e-112, 1.9664734981177427e-117, 8.544685504690805e-123, 2.4842973255626587e-128, 4.837940464818754e-134, 6.315732882076117e-140, 5.530712011094401e-146, 3.250632479337667e-152}, {-1.3531599577088638e-50, -1.3176771196389409e-48, -8.392319966108183e-47, -3.555781494350033e-45, -1.0075110500484379e-43, -1.9134732492385358e-42, -2.4387351429737174e-41, -2.087193221944492e-40, -1.1999999282593864e-39, -4.6356673545059265e-39, -1.2033711633682501e-38, -2.099192107674702e-38, -2.4606582691459345e-38, -1.938001811619971e-38, -1.0254045082680507e-38, -3.644060058290996e-39, -8.695824656017407e-40, -1.392924387836292e-40, -1.4971237075234935e-41, -1.0791461705558903e-42, -5.213388642492902e-44, -1.6866746807962866e-45, -3.6506792965486987e-47, -5.279309845472244e-49, -5.0919925793113706e-51, -3.2679936845167405e-53, -1.3909718758024414e-55, -3.907405133591646e-58, -7.189787601536557e-61, -8.556785625548176e-64, -6.4324385793996e-67, -2.8959450518855678e-70, -6.5882675616692866e-74, 0., 4.171746329136424e-81, 1.1611493323765436e-84, 1.633177590012061e-88, 1.3757575363228969e-92, 7.320470418498075e-97, 2.519568445681299e-101, 5.680664412947185e-106, 8.453544285622385e-111, 8.343761656185135e-116, 5.480419864952636e-121, 2.4011867653631835e-126, 7.030073808998841e-132, 1.3771912522430186e-137, 1.807086533057421e-143, 1.5895373622887503e-149, 9.379017599610415e-156}, {-2.8796677781228425e-54, -2.8067337141540353e-52, -1.7893634533066461e-50, -7.589335455317312e-49, -2.1527882770463838e-47, -4.0934605244126464e-46, -5.223807310013148e-45, -4.4769404421774444e-44, -2.5777619233435224e-43, -9.973997988554891e-43, -2.5936492893227683e-42, -4.5329986011932255e-42, -5.3245503120806684e-42, -4.2031193548306884e-42, -2.229460910477183e-42, -7.945017659285276e-43, -1.9017901892353664e-43, -3.056924593513751e-44, -3.298486084195278e-45, -2.3882057644974036e-46, -1.1596662816008626e-47, -3.774171900308341e-49, -8.22603378285189e-51, -1.1994940053089224e-52, -1.1686204923091256e-54, -7.593849329296921e-57, -3.2835114947306553e-59, -9.415935553191512e-62, -1.7820732523246023e-64, -2.2092705819736483e-67, -1.7715060080679302e-70, -8.972424679249429e-74, -2.7216324161183605e-77, -4.171746329136424e-81, 0., 1.1991853827159535e-88, 2.2489013126483028e-92, 2.13123533948439e-96, 1.2096430149944792e-100, 4.336837600709173e-105, 1.0057281111556775e-109, 1.5278303401118995e-114, 1.531925383234512e-119, 1.018789795412725e-124, 4.508805495799073e-130, 1.3310659343735783e-135, 2.625792443365942e-141, 3.46595173778997e-147, 3.064331616710225e-153, 1.8161715664085847e-159}, {-4.125453803968085e-58, -4.024448527976431e-56, -2.5680454937070706e-54, -1.0902653819577774e-52, -3.095864524353573e-51, -5.893238970825806e-50, -7.529520222208534e-49, -6.461238508292077e-48, -3.725404280295427e-47, -1.4435864742823677e-46, -3.759933869103759e-46, -6.5827775510300404e-46, -7.746905868382094e-46, -6.127951190929846e-46, -3.2578369892290034e-46, -1.1638886960230027e-46, -2.793726499128867e-47, -4.504519780211755e-48, -4.877348447881718e-49, -3.5451992973542265e-50, -1.7291650217866226e-51, -5.65648381644964e-53, -1.2402030175050014e-54, -1.8210708028824737e-56, -1.7889836499237746e-58, -1.1742475297184978e-60, -5.140806438175441e-63, -1.4975992468913602e-65, -2.8934270022433837e-68, -3.689524039438233e-71, -3.0817175474612937e-74, -1.6649022741939589e-77, -5.68147260215432e-81, -1.1611493323765436e-84, -1.1991853827159535e-88, 0., 1.5648783817009228e-96, 1.9773353861394132e-100, 1.2625793269100307e-104, 4.8284010458817805e-109, 1.1663785705526494e-113, 1.8225041636625895e-118, 1.8654596255334252e-123, 1.2602951137842152e-128, 5.647343426933496e-134, 1.6840193302834424e-139, 3.349747116500503e-145, 4.4524658118973884e-151, 3.959964270233667e-157, 2.359032029283195e-163}, {-3.9788749023459215e-62, -3.884629292453903e-60, -2.4809714490639536e-58, -1.054266144577473e-56, -2.9965691787640526e-55, -5.710163811980661e-54, -7.303728771184067e-53, -6.274943438239138e-52, -3.622611425808975e-51, -1.405682689339808e-50, -3.666634512476031e-50, -6.429719433898217e-50, -7.579939875623422e-50, -6.007233716215103e-50, -3.2002714135211625e-50, -1.1459213882557701e-50, -2.757492615459257e-51, -4.458447636828238e-52, -4.842408725858615e-53, -3.532024191215068e-54, -1.7294947245934195e-55, -5.682819322511745e-57, -1.2523667918828156e-58, -1.8498776862305706e-60, -1.8299912302320743e-62, -1.2111736575185607e-64, -5.356027754579852e-67, -1.5798003714793234e-69, -3.1006914609029273e-72, -4.0361863578754074e-75, -3.467593286702999e-78, -1.9514293639622429e-81, -7.103194872629451e-85, -1.633177590012061e-88, -2.2489013126483028e-92, -1.5648783817009228e-96, 0., 9.270526912535277e-105, 7.892625406478794e-109, 3.3956168099348855e-113, 8.749507244392491e-118, 1.424102862188094e-122, 1.4993158788175602e-127, 1.0340329587459604e-132, 4.7070168461795175e-138, 1.4211622336656462e-143, 2.85544245888454e-149, 3.8270673813729465e-155, 3.4275455682317844e-161, 2.05401320013013e-167}, {-2.583623837544059e-66, -2.5243745261770438e-64, -1.613543379191286e-62, -6.862541588631504e-61, -1.9523515506718042e-59, -3.7239736877466845e-58, -4.7682040032211066e-57, -4.101123278049741e-56, -2.370453667075261e-55, -9.209823677850527e-55, -2.4056242333536372e-54, -4.224692597391267e-54, -4.9884345633448303e-54, -3.960296358445414e-54, -2.113789417347796e-54, -7.584517599855805e-55, -1.8292514545511084e-55, -2.9650349501644767e-56, -3.2293289894564886e-57, -2.362745828419456e-58, -1.1609618058858653e-59, -3.829678564447691e-61, -8.477435974897176e-63, -1.2586281740930949e-64, -1.2525090329779256e-66, -8.347659565263696e-69, -3.72224757697803e-71, -1.1089946577356705e-73, -2.2038438885070073e-76, -2.91429095935073e-79, -2.555904926063776e-82, -1.4794620642864217e-85, -5.6096206662669706e-89, -1.3757575363228969e-92, -2.13123533948439e-96, -1.9773353861394132e-100, -9.270526912535277e-105, 0., 2.493223704836788e-113, 1.430201297550909e-117, 4.145859788832836e-122, 7.197821928746191e-127, 7.893718709107948e-132, 5.599604371830137e-137, 2.602097452651569e-142, 7.981065726349067e-148, 1.623624792429646e-153, 2.198078384184763e-159, 1.9850179042704486e-165, 1.1978732754151896e-171}, {-1.129531256925265e-70, -1.1044348159411494e-68, -7.06483752544345e-67, -3.007192248056573e-65, -8.562687122777393e-64, -1.6347736983476406e-62, -2.0952226919074062e-61, -1.803974273576164e-60, -1.0438589142451478e-59, -4.060489191039003e-59, -1.0619623838012997e-58, -1.867551584072111e-58, -2.208435376676063e-58, -1.7560768991540846e-58, -9.389278075912819e-59, -3.375360743671295e-59, -8.157627523875845e-60, -1.325275570608539e-60, -1.4470240937550933e-61, -1.0616593218161739e-62, -5.232733205035434e-64, -1.7321214471103727e-65, -3.8492872268449516e-67, -5.740473929915077e-69, -5.741860361216509e-71, -3.849584988010646e-73, -1.7285458081256295e-75, -5.192891107087085e-78, -1.0423783788997725e-80, -1.3956371072667407e-83, -1.2434368060857046e-86, -7.347467940309931e-90, -2.8655092645114227e-93, -7.320470418498075e-97, -1.2096430149944792e-100, -1.2625793269100307e-104, -7.892625406478794e-109, -2.493223704836788e-113, 0., 3.0440672908693973e-122, 1.17655010730101e-126, 2.297996897672948e-131, 2.6881822542733616e-136, 1.98638384439151e-141, 9.494319544091133e-147, 2.972733771082187e-152, 6.143561757346908e-158, 8.421176335344708e-164, 7.68172613123771e-170, 4.6742226062819765e-176}, {-3.32495068971461e-75, -3.253328262289172e-73, -2.082607013084055e-71, -8.871592278888318e-70, -2.5281633275073995e-68, -4.8309055170199536e-67, -6.197265112580174e-66, -5.341024239342496e-65, -3.093771027728399e-64, -1.2047794197713716e-63, -3.1546779113705954e-63, -5.554855912555055e-63, -6.577805631343285e-63, -5.238208655510737e-63, -2.80521978374193e-63, -1.0102050273870356e-63, -2.446104189599456e-64, -3.9821306365840985e-65, -4.357837042629135e-66, -3.205291241115669e-67, -1.584220442261573e-68, -5.26026771432842e-70, -1.1730463755192172e-71, -1.756234066964674e-73, -1.764500454422483e-75, -1.1890620546166224e-77, -5.370922975343084e-80, -1.6248141826084786e-82, -3.2886980776419446e-85, -4.447704476049357e-88, -4.012196230709053e-91, -2.408438557807487e-94, -9.588585192631387e-98, -2.519568445681299e-101, -4.336837600709173e-105, -4.8284010458817805e-109, -3.3956168099348855e-113, -1.430201297550909e-117, -3.0440672908693973e-122, 0., 1.6872768845723364e-131, 4.394040987235255e-136, 5.782636563041734e-141, 4.55784011065124e-146, 2.2692822858513797e-151, 7.308279560933463e-157, 1.5418218855390007e-162, 2.146970927344655e-168, 1.9829294084426096e-174, 1.2187724568611163e-180}, {-6.590324453601002e-80, -6.452604995030651e-78, -4.1334756412579885e-76, -1.7620855150392995e-74, -5.025343669744097e-73, -9.610452897861315e-72, -1.2339320252081022e-70, -1.0644240879452003e-69, -6.171669146451181e-69, -2.40588111370986e-68, -6.306733292027934e-68, -1.1118314340680534e-67, -1.3182612523912752e-67, -1.0512339874451805e-67, -5.638017453429434e-68, -2.0335950497417867e-68, -4.932698156337946e-69, -8.045385196080849e-70, -8.822680573944806e-71, -6.504036644042109e-72, -3.222687475650669e-73, -1.0730380614585323e-74, -2.4002968173019943e-76, -3.6060979544768225e-78, -3.6372795572299944e-80, -2.4620333251108722e-82, -1.1177888961839534e-84, -3.4016685212222733e-87, -6.93328015042633e-90, -9.454853238065169e-93, -8.615209437993653e-96, -5.236176502454814e-99, -2.1177401078003686e-102, -5.680664412947185e-106, -1.0057281111556775e-109, -1.1663785705526494e-113, -8.749507244392491e-118, -4.145859788832836e-122, -1.17655010730101e-126, -1.6872768845723364e-131, 0., 4.245807419010896e-141, 7.4500780464967675e-146, 6.606121135198368e-151, 3.5083643846154026e-156, 1.1769556265769263e-161, 2.5539571118893123e-167, 3.630449501234259e-173, 3.406284473074418e-179, 2.1197826051298113e-185}, {-8.795862491666609e-85, -8.617438953289393e-83, -5.523878840284171e-81, -2.3564411868829756e-79, -6.725316722556046e-78, -1.2871408156520257e-76, -1.6539718528040648e-75, -1.4279974189243255e-74, -8.287324584818034e-74, -3.233777973970386e-73, -8.485797340650386e-73, -1.497648708869611e-72, -1.777825801610953e-72, -1.4195196607736928e-72, -7.623678677142198e-73, -2.753883516385565e-73, -6.690538265505251e-74, -1.0931455695293684e-74, -1.2010289122107437e-75, -8.872257067977226e-77, -4.406109049398955e-78, -1.4707514082926174e-79, -3.2990872118436334e-81, -4.971745101008904e-83, -5.0321476065373146e-85, -3.419561366647361e-87, -1.5594475260122402e-89, -4.7700664128077515e-92, -9.780219601717303e-95, -1.343046668959595e-97, -1.2339747584798642e-100, -7.575643326882587e-104, -3.1022224431435256e-107, -8.453544285622385e-111, -1.5278303401118995e-114, -1.8225041636625895e-118, -1.424102862188094e-122, -7.197821928746191e-127, -2.297996897672948e-131, -4.394040987235255e-136, -4.245807419010896e-141, 0., 4.8504114223531446e-151, 5.734598610758968e-156, 3.4262078689734084e-161, 1.2260207700639427e-166, 2.771278070376061e-172, 4.0519246611520674e-178, 3.880938128771468e-184, 2.453502770880978e-190}, {-7.905228318205092e-90, -7.74948096886665e-88, -4.970614286610612e-86, -2.121818103338917e-84, -6.0598957028223904e-83, -1.160635421285723e-81, -1.4925644936808555e-80, -1.2896952043247832e-79, -7.491173595910302e-79, -2.925800402707261e-78, -7.685134547344672e-78, -1.357753499126372e-77, -1.6135521145302076e-77, -1.2898877364311818e-77, -6.936324233340484e-78, -2.509033834795724e-78, -6.104708530704756e-79, -9.990271732423397e-80, -1.099530809617643e-80, -8.137852371880975e-82, -4.0497588467715064e-83, -1.3548746189239558e-84, -3.0467774051251177e-86, -4.6042668430401145e-88, -4.674632676613167e-90, -3.1876444615401394e-92, -1.4593854918226155e-94, -4.4839233938759384e-97, -9.24067774082161e-100, -1.2765086012404913e-102, -1.1810420814727525e-105, -7.311100258985645e-109, -3.0241335141748e-112, -8.343761656185135e-116, -1.531925383234512e-119, -1.8654596255334252e-123, -1.4993158788175602e-127, -7.893718709107948e-132, -2.6881822542733616e-136, -5.782636563041734e-141, -7.4500780464967675e-146, -4.8504114223531446e-151, 0., 2.5156114608607857e-161, 2.0039781607522597e-166, 8.06732635473339e-172, 1.9450941482085746e-177, 2.962447420183536e-183, 2.918505154403575e-189, 1.8834979028312116e-195}, {-4.784406273697283e-95, -4.692804923537791e-93, -3.011815615530488e-91, -1.2864650331241666e-89, -3.676551141906509e-88, -7.046478719631338e-87, -9.068318829212709e-86, -7.841804174319837e-85, -4.558620509740756e-84, -1.78198532843854e-83, -4.6850031626785024e-83, -8.285212786171936e-83, -9.856390182477027e-83, -7.888049405832867e-83, -4.246819509623333e-83, -1.5381377697754585e-83, -3.7475704092781243e-84, -6.141933245001769e-85, -6.770654014632591e-86, -5.019814449189804e-87, -2.5028151175359055e-88, -8.390675871123127e-90, -1.8911434671203787e-91, -2.8650442354317013e-93, -2.9169100576012562e-95, -1.9952067758804098e-97, -9.166286233845736e-100, -2.8273616264681983e-102, -5.852770567944759e-105, -8.126487662932426e-108, -7.563484651858382e-111, -4.7148268920875524e-114, -1.9664734981177427e-117, -5.480419864952636e-121, -1.018789795412725e-124, -1.2602951137842152e-128, -1.0340329587459604e-132, -5.599604371830137e-137, -1.98638384439151e-141, -4.55784011065124e-146, -6.606121135198368e-151, -5.734598610758968e-156, -2.5156114608607857e-161, 0., 5.923214226570675e-172, 3.1793095800210957e-177, 8.623753658844912e-183, 1.4009901743130204e-188, 1.4377178678429206e-194, 9.543612622072504e-201}, {-1.9499869821346558e-100, -1.9136878099053393e-98, -1.228890645518513e-96, -5.2522002460226215e-95, -1.5019498083091743e-93, -2.8805311702013734e-92, -3.70960849504275e-91, -3.210218847259116e-90, -1.8676148586831225e-89, -7.306555295310403e-89, -1.922623691265043e-88, -3.403196706514876e-88, -4.0525240038261184e-88, -3.246605239396172e-88, -1.7498728164215737e-88, -6.345336047209326e-89, -1.5479733952748483e-89, -2.5404750383492392e-90, -2.8046804345688185e-91, -2.0827438236930582e-92, -1.0402353285150766e-93, -3.493988924125913e-95, -7.89127697468893e-97, -1.1982296302627677e-98, -1.222978596960313e-100, -8.388579617707798e-103, -3.865773658579523e-105, -1.1965468893258204e-107, -2.4866212885496623e-110, -3.468051417585168e-113, -3.244337581272737e-116, -2.0344512244863316e-119, -8.544685504690805e-123, -2.4011867653631835e-126, -4.508805495799073e-130, -5.647343426933496e-134, -4.7070168461795175e-138, -2.602097452651569e-142, -9.494319544091133e-147, -2.2692822858513797e-151, -3.5083643846154026e-156, -3.4262078689734084e-161, -2.0039781607522597e-166, -5.923214226570675e-172, 0., 6.331727955370154e-183, 2.2899421293672474e-188, 4.185195761199415e-194, 4.581240391542262e-200, 3.167750592462435e-206}, {-5.352256860294003e-106, -5.2553384966080623e-104, -3.3765857736430073e-102, -1.4439497910042961e-100, -4.131660879044951e-99, -7.928907406897252e-98, -1.0217731135494453e-96, -8.848341902672734e-96, -5.151478915566214e-95, -2.0169378432421135e-94, -5.311642041728248e-94, -9.41016876491825e-94, -1.1215920965825945e-93, -8.994212673645015e-94, -4.852799034558041e-94, -1.7616647597244089e-94, -4.3027770315446495e-95, -7.070572537629495e-96, -7.816623318626979e-97, -5.8131907977943044e-98, -2.9080759784356737e-99, -9.784763034904812e-101, -2.214103023155309e-102, -3.368905459678703e-104, -3.446303638349254e-106, -2.3697918874511054e-108, -1.0951230023794102e-110, -3.4001547911582026e-113, -7.090616043545663e-116, -9.927951209529175e-119, -9.328990343041527e-122, -5.880000302429231e-125, -2.4842973255626587e-128, -7.030073808998841e-132, -1.3310659343735783e-135, -1.6840193302834424e-139, -1.4211622336656462e-143, -7.981065726349067e-148, -2.972733771082187e-152, -7.308279560933463e-157, -1.1769556265769263e-161, -1.2260207700639427e-166, -8.06732635473339e-172, -3.1793095800210957e-177, -6.331727955370154e-183, 0., 3.0728396235156526e-194, 7.488070085414132e-200, 9.221248532515058e-206, 6.801212598764447e-212}, {-9.89360448157917e-112, -9.719250955709383e-110, -6.247902904001091e-108, -2.6732742916007365e-106, -7.653540173925681e-105, -1.4696349653568385e-103, -1.895056311167288e-102, -1.6421588699404943e-101, -9.567226672991126e-101, -3.7485559929314477e-100, -9.879512625834119e-100, -1.7516962653833382e-99, -2.0896434114594763e-99, -1.6772560942596008e-99, -9.058428392062398e-100, -3.291819172850114e-100, -8.049045139939669e-101, -1.3242403387153587e-101, -1.4658371208454097e-102, -1.0916345136054692e-103, -5.4690431862945384e-105, -1.8431103754903335e-106, -4.1778562713564904e-108, -6.368926593903075e-110, -6.528737225815776e-112, -4.4995778680918204e-114, -2.0845463701669357e-116, -6.490109869996853e-119, -1.3576249702672263e-121, -1.9074837083634594e-124, -1.7994327961503733e-127, -1.1392337335648561e-130, -4.837940464818754e-134, -1.3771912522430186e-137, -2.625792443365942e-141, -3.349747116500503e-145, -2.85544245888454e-149, -1.623624792429646e-153, -6.143561757346908e-158, -1.5418218855390007e-162, -2.5539571118893123e-167, -2.771278070376061e-172, -1.9450941482085746e-177, -8.623753658844912e-183, -2.2899421293672474e-188, -3.0728396235156526e-194, 0., 6.770366350666275e-206, 1.111656809895148e-211, 9.224012408503458e-218}, {-1.2316706579393061e-117, -1.2105371569221548e-115, -7.78563643443259e-114, -3.3329419790081906e-112, -9.547321380369642e-111, -1.8343192358336531e-109, -2.3667151751694093e-108, -2.0521569149058394e-107, -1.1963743263055286e-106, -4.690788864668063e-106, -1.2371853094755174e-105, -2.195296935093994e-105, -2.62096559385094e-105, -2.105544217749725e-105, -1.1381954042019264e-105, -4.140228070172859e-106, -1.0134091301554057e-106, -1.6691296832126553e-107, -1.84980390839997e-108, -1.3793406516759564e-109, -6.919931247573622e-111, -2.335525932374694e-112, -5.302519479745374e-114, -8.097475817091827e-116, -8.316380566475743e-118, -5.743480734597169e-120, -2.666864006908273e-122, -8.323930669117115e-125, -1.74606707728505e-127, -2.4608459735866292e-130, -2.3295100096877393e-133, -1.4806130417079474e-136, -6.315732882076117e-140, -1.807086533057421e-143, -3.46595173778997e-147, -4.4524658118973884e-151, -3.8270673813729465e-155, -2.198078384184763e-159, -8.421176335344708e-164, -2.146970927344655e-168, -3.630449501234259e-173, -4.0519246611520674e-178, -2.962447420183536e-183, -1.4009901743130204e-188, -4.185195761199415e-194, -7.488070085414132e-200, -6.770366350666275e-206, 0., 6.772371099129346e-218, 7.492532407161564e-224}, {-1.0326818781450855e-123, -1.0154223504901693e-121, -6.533832627162198e-120, -2.7984410216076168e-118, -8.020368646992216e-117, -1.5417808718255823e-115, -1.990398321841839e-114, -1.7268833350754281e-113, -1.0073746936372165e-112, -3.952350610872841e-112, -1.0431462346263851e-111, -1.852341522556273e-111, -2.2132187662671993e-111, -1.779434724707396e-111, -9.627430065862328e-112, -3.5052322176275775e-112, -8.588190414198264e-113, -1.4159864170798095e-113, -1.5710048191326798e-114, -1.1728435130356935e-115, -5.891482805068252e-117, -1.9911486227488432e-118, -4.5273511412183445e-120, -6.924796166853624e-122, -7.1243677378481656e-124, -4.929568338016713e-126, -2.2936799793406555e-128, -7.175403383550961e-131, -1.5089188573786676e-133, -2.1325248236241617e-136, -2.0249613220796245e-139, -1.2915138769608427e-142, -5.530712011094401e-146, -1.5895373622887503e-149, -3.064331616710225e-153, -3.959964270233667e-157, -3.4275455682317844e-161, -1.9850179042704486e-165, -7.68172613123771e-1