# NumCosmo

NumCosmo is a powerful numerical cosmology library designed to facilitate calculations of cosmological observables and analysis of statistical models. It provides a comprehensive set of tools that empower researchers and developers in the field of cosmology and astrophysics.

[![Build Status](https://github.com/NumCosmo/NumCosmo/workflows/Build%20and%20Check/badge.svg)](https://github.com/NumCosmo/NumCosmo/actions) [![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0) [![Coverage Status](https://coveralls.io/repos/github/NumCosmo/NumCosmo/badge.svg?branch=master)](https://coveralls.io/github/NumCosmo/NumCosmo?branch=master)

Visit [NumCosmo's website](https://numcosmo.github.io) for more information.

## Features

- **Cosmological calculations made easy:** NumCosmo provides a wide range of efficient tools to perform cosmological calculations, enabling users to compute various observables.

- **Statistical modeling and analysis:** With NumCosmo, you can analyze statistical models in cosmology with ease. The library offers robust functionality to investigate and interpret data.

- **Comprehensive API documentation:** Access the detailed API documentation on [NumCosmo's website](https://numcosmo.github.io/manual/).

## Get Started

To get started with NumCosmo, follow these steps:

1. **Installation:** Clone the repository and install the necessary dependencies as outlined in the [installation guide](https://numcosmo.github.io/download/).

2. **Examples and Tutorials:** Explore the provided examples and tutorials in the [examples](https://numcosmo.github.io/examples/) and [tutorials](https://numcosmo.github.io/tutorials/) to understand how to use NumCosmo for your cosmological calculations and statistical analysis.

3. **Contribute:** NumCosmo is an open-source project, and we welcome contributions from the community.

## Citation

If you find NumCosmo useful for your research or project, please consider citing it:
```
@Misc{Vitenti2012c,
  author        = {S. D. P. Vitenti and M. Penna-Lima},
  title         = {Numerical Cosmology -- {NumCosmo}},
  year          = {2014},
  howpublished  = {Astrophysics Source Code Library},
  eprint        = {1408.013},
  url           = {https://github.com/NumCosmo/NumCosmo},
  adsurl        = {http://adsabs.harvard.edu/abs/2014ascl.soft08013D},
  archiveprefix = {ascl},
  primaryclass  = {ascl}
}
```

## License

NumCosmo is released under the GNU General Public License v3.0. See the [license file](https://github.com/NumCosmo/NumCosmo/blob/master/COPYING) for more details.

