/*
    Copyright (C) 2005,2006  Ivano Primi  <ivprimi@libero.it>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

/*
    Test:  strtox  xprxpr  xprint

    Input file:  data/str2x.dat
*/
#include<stdio.h>
#include<stdlib.h>
#include"number.h"

extern void out_char(int ch);
extern int bc_a2num (bc_num *num, const char *str, char **endptr, int scale);
extern void bc_print_num (bc_num num, void (* out_char)(int), int prec);

int decd = 6;

int
getline (char *buffer, int size, FILE * fp)
{
  if ((fgets (buffer, size, fp)))
    {
      int i;

      for (i = 0; buffer[i] != '\0'; i++);
      if (i > 0 && buffer[i - 1] == '\n')
	buffer[--i] = '\0';
      return i;
    }
  else
    return -1;
}

int
main (int na, char **av)
{
  double x;
  bc_num f;
  FILE *fp;
  char num[256];
  char *endptr, *endptr2;

  if (na != 2)
    {
      printf ("para: input_file\n");
      exit (-1);
    }
  fp = fopen (*++av, "r");
  bc_init_numbers();
  bc_init_num (&f);
  while (getline (num, 256, fp) != -1)
    {
      printf ("*string in : \"%s\"\n", num);

      /* convert ascii string to extended precision */
      bc_a2num (&f, num, &endptr, 50);
      printf (" endptr                : \"%s\"\n", endptr);
      x = strtod (num, &endptr2);
      printf (" endptr (from strtod()): \"%s\"\n", endptr2);
      printf (" f =       ");
      bc_print_num (f, out_char, decd);
      putchar ('\n');
    }
  bc_end();
  return 0;
}

/*  Test output

*/
