#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2009    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -z 1:3- -z 2:3- -f 0    test17.3.1 test17.3.2 > ./output/res3
$NUMDIFF -z 1:3- -z 2:3- -f 0 -H test17.3.1 test17.3.2 > ./output/res3H
$NUMDIFF -z 1:3- -z 2:3- -f 0 -m test17.3.1 test17.3.2 > ./output/res3m
$NUMDIFF -z 1:3- -z 2:3- -f 0    test17.10.1 test17.10.2 > ./output/res10
$NUMDIFF -z 1:3- -z 2:3- -f 0 -H test17.10.1 test17.10.2 > ./output/res10H
$NUMDIFF -z 1:3- -z 2:3- -f 0 -m test17.10.1 test17.10.2 > ./output/res10m
$NUMDIFF -z 1:3- -z 2:3- -f 0    test17.25.1 test17.25.2 > ./output/res25
$NUMDIFF -z 1:3- -z 2:3- -f 0 -H test17.25.1 test17.25.2 > ./output/res25H
$NUMDIFF -z 1:3- -z 2:3- -f 0 -m test17.25.1 test17.25.2 > ./output/res25m

LIST="res10 res10H res10m res25 res25H res25m res3 res3H res3m"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"
