#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2007    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF pp1 pp2 > ./output/res1
$NUMDIFF -#11 pp1 pp2 > ./output/res2
$NUMDIFF -#7 pp1 pp2 > ./output/res3
$NUMDIFF -#3 pp1 pp2 > ./output/res4

LIST="res1 res2 res3 res4"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

