#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2011    Ivano Primi  <ivprimi@libero.it>    
#
#  Copying and distribution of this file, with or without modification,
#  are permitted in any medium without royalty provided the copyright
#  notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -X 1:1 many_fields1 many_fields2 > ./output/basic_comparison
$NUMDIFF -X 1:1 -V many_fields1 many_fields2 > ./output/verbose_comparison
$NUMDIFF -X 1:1 -O many_fields1 many_fields2 > ./output/overview
$NUMDIFF -X 1:1 -a 1.5e-4:1 many_fields1 many_fields2 > ./output/a_1_comparison
$NUMDIFF -X 1:1 -a 1.5e-4:2:1 many_fields1 many_fields2 > ./output/a_2_1_comparison  
$NUMDIFF -X 1:1 -a 1.5e-4:2-6 many_fields1 many_fields2 > ./output/a_2to6_comparison
$NUMDIFF -X 1:1 -a 1.5e-4:2-6:1-5 many_fields1 many_fields2 > ./output/a_2to6_1to5_comparison
$NUMDIFF -X 1:1 -a 2.0e-3:2-6:1-5 many_fields1 many_fields2 > ./output/aBigger_2to6_1to5_comparison 
$NUMDIFF -X 1:1 -r 8.2e-6:4  many_fields1 many_fields2 > ./output/r_4_comparison
$NUMDIFF -X 1:1 -r 8.2e-6:6:5 many_fields1 many_fields2 > ./output/r_6_5_comparison  
$NUMDIFF -X 1:1 -r 8.2e-6:3-7 many_fields1 many_fields2 > ./output/r_3to7_comparison 
$NUMDIFF -X 1:1 -r 8.2e-6:3-7:2-6 many_fields1 many_fields2 > ./output/r_3to7_2to6_comparison
$NUMDIFF -X 1:1 -r 10:3-7:2-6 many_fields1 many_fields2 > ./output/rBigger_3to7_2to6_comparison
$NUMDIFF -X 1:1 -a 1.5e-4:1 -r 8.2e-6:4 many_fields1 many_fields2 > ./output/a_1_r_4_comparison
$NUMDIFF -X 1:1 -a 1.5e-4:2:1 -r 8.2e-6:6:5 many_fields1 many_fields2 > ./output/a_2_1_r_6_5_comparison
$NUMDIFF -X 1:1 -a 1.5e-4:2-6 -r 8.2e-6:3-7 many_fields1 many_fields2 > ./output/a_2to6_r_3to7_comparison
$NUMDIFF -X 1:1 -a 1.5e-4:2-6:1-5 -r 8.2e-6:3-7:2-6 many_fields1 many_fields2 > ./output/a_2to6_1to5_r_3to7_2to6_comparison
$NUMDIFF -2 -X 1:1 -a 1.5e-4:1 -r 8.2e-6:4 many_fields1 many_fields2 > ./output/2_a_1_r_4_comparison
$NUMDIFF -2 -X 1:1 -a 1.5e-4:2:1 -r 8.2e-6:6:5 many_fields1 many_fields2 > ./output/2_a_2_1_r_6_5_comparison
$NUMDIFF -2 -X 1:1 -a 1.5e-4:2-6 -r 8.2e-6:3-7 many_fields1 many_fields2 > ./output/2_a_2to6_r_3to7_comparison
$NUMDIFF -2 -X 1:1 -a 1.5e-4:2-6:1-5 -r 8.2e-6:3-7:2-6 many_fields1 many_fields2 > ./output/2_a_2to6_1to5_r_3to7_2to6_comparison

$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- many_fields3 many_fields4 > ./output/basic_cmp 
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -V many_fields3 many_fields4 > ./output/basic_cmp_verbose 
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -a 8.95e-1:2:4 -a 0.0002:3-7:5-9 -a 3.5:4:6 -a 0.001:5-7:7-9 -a 0.8:7:9 many_fields3 many_fields4 > ./output/a_2to7_4to9_cmp 
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 many_fields3 many_fields4 > ./output/r_2to7_4to9_cmp 
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 1 -r 0 many_fields3 many_fields4 > ./output/basic_cmp_1 
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 2 -r 0.000 many_fields3 many_fields4 > ./output/basic_cmp_2
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 1 -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 many_fields3 many_fields4 > ./output/F1_r_2to7_4to9_cmp 
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 2 -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 many_fields3 many_fields4 > ./output/F2_r_2to7_4to9_cmp 
$NUMDIFF -F 2 -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 1 -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 many_fields3 many_fields4 > ./output/F21_r_2to7_4to9_cmp 
$NUMDIFF -F 1 -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 2 -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 many_fields3 many_fields4 > ./output/F12_r_2to7_4to9_cmp 
$NUMDIFF -F 0 -F 2 -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 1 -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 many_fields3 many_fields4 > ./output/F021_r_2to7_4to9_cmp 
$NUMDIFF -F 0 -F 1 -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 2 -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 many_fields3 many_fields4 > ./output/F012_r_2to7_4to9_cmp 
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 1 -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 -F 0 many_fields3 many_fields4 > ./output/F10_r_2to7_4to9_cmp 
$NUMDIFF -s "1:| \t\n" -X 2:1-2 -z 1:2- -z 2:4- -F 2 -r 0.0024:2-7:4-9 -r 8.999:2:4 -r 5e-2:3-5:5-7 -r 18.48e-3:4-5:6-7 -r 1e-6:5:7 -F 0 many_fields3 many_fields4 > ./output/F20_r_2to7_4to9_cmp 

LIST="2_a_1_r_4_comparison 2_a_2_1_r_6_5_comparison 2_a_2to6_1to5_r_3to7_2to6_comparison 2_a_2to6_r_3to7_comparison a_1_comparison a_1_r_4_comparison a_2_1_comparison a_2_1_r_6_5_comparison a_2to6_1to5_comparison a_2to6_1to5_r_3to7_2to6_comparison a_2to6_comparison a_2to6_r_3to7_comparison a_2to7_4to9_cmp aBigger_2to6_1to5_comparison basic_cmp basic_cmp_1 basic_cmp_2 basic_cmp_verbose basic_comparison F012_r_2to7_4to9_cmp F021_r_2to7_4to9_cmp F10_r_2to7_4to9_cmp F12_r_2to7_4to9_cmp F1_r_2to7_4to9_cmp F20_r_2to7_4to9_cmp F21_r_2to7_4to9_cmp F2_r_2to7_4to9_cmp overview r_2to7_4to9_cmp r_3to7_2to6_comparison r_3to7_comparison r_4_comparison r_6_5_comparison rBigger_3to7_2to6_comparison verbose_comparison"

for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"
