#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2013    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF -#5 -i ij -e ed -z 1:@ -z 2:@ -X 1:2 -X 1:6 -X 1:8- -X 2:3-4 -X 2:8- -f0 test15.1 test15.2 > ./output/prec5_f0
$NUMDIFF -#5 -i ij -e ed -z 1:@ -z 2:@ -X 1:2 -X 1:6 -X 1:8- -X 2:3-4 -X 2:8- test15.1 test15.2 > ./output/prec5
$NUMDIFF -#5 -i ij -e ed -z 1:@ -z 2:@ -X 1:2 -X 1:6 -X 1:8- -X 2:3-4 -X 2:8- -V test15.1 test15.2 > ./output/prec5_V
$NUMDIFF -#20 -i ij -e ed -z 1:@ -z 2:@ -X 1:2 -X 1:6 -X 1:8- -X 2:3-4 -X 2:8- -f0 test15.1 test15.2 > ./output/prec20_f0
$NUMDIFF -#20 -i ij -e ed -z 1:@ -z 2:@ -X 1:2 -X 1:6 -X 1:8- -X 2:3-4 -X 2:8- -V test15.1 test15.2 > ./output/prec20_V

LIST="prec5_f0 prec5 prec5_V prec20_f0 prec20_V"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"	
    fi
done

echo "Removing output files..."
rm ./output/*
echo "Done !"

