#!/bin/bash
#  This script is part of Numdiff
#  Copyright (C)  2005-2016    Ivano Primi  <ivprimi@libero.it>    
#
#   Copying and distribution of this file, with or without modification,
#   are permitted in any medium without royalty provided the copyright
#   notice and this notice are preserved.

LESS=$1
DIFF=$2
NUMDIFF=$3

$NUMDIFF --raw -Z 2- file1 file2 > ./output/file1VSfile2
$NUMDIFF --raw -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2
$NUMDIFF --raw -P -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.P
$NUMDIFF --raw -N -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.N
$NUMDIFF --raw -a 0.5 -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.a0.5
$NUMDIFF --raw -r 0.1 -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.r0.1
$NUMDIFF --raw -U -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.U
$NUMDIFF --raw -E -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.E
$NUMDIFF -V --raw -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.V
$NUMDIFF -b --raw -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.b
$NUMDIFF -b -V --raw -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.bV
$NUMDIFF -O --raw -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.O
$NUMDIFF -q --raw -X 1:2 -X 2:3 -Z 2- list1 list2 > ./output/list1VSlist2.q
$NUMDIFF -Z 2- -O --raw input1 input2 > ./output/input1VSinput2
$NUMDIFF -Z 2- -O -I --raw input1 input2 > ./output/input1VSinput2.I

LIST="file1VSfile2 list1VSlist2 list1VSlist2.P list1VSlist2.N list1VSlist2.a0.5 list1VSlist2.r0.1 list1VSlist2.U list1VSlist2.E list1VSlist2.V list1VSlist2.b list1VSlist2.bV list1VSlist2.O list1VSlist2.q input1VSinput2 input1VSinput2.I"
for NAME in $LIST; do
    $DIFF $NAME ./output/$NAME > ./output/comparison
    if [ $? -ne 0 ]; then
	$LESS ./output/comparison
	echo -e "$NAME and ./output/$NAME \t differ \t\t [ ERR ]"
    else
    	echo -e "$NAME and ./output/$NAME \t are equal \t\t [ OK ]"
    fi
done
