;; auto-generated by ffi-help.scm

(define-module (cairo)
  #:use-module (system ffi-help-rt)
  #:use-module ((system foreign) #:prefix ffi:)
  #:use-module (bytestructures guile)
  )
(dynamic-link "libcairo")
(define void intptr_t)
(define echo-decls #f)

;; int cairo_version(void);
(if echo-decls (display "cairo_version\n"))
(define cairo_version
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "cairo_version" (dynamic-link))
              (list))))
    (lambda () (let () (~f)))))
(export cairo_version)

;; const char *cairo_version_string(void);
(if echo-decls (display "cairo_version_string\n"))
(define cairo_version_string
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_version_string"
                (dynamic-link))
              (list))))
    (lambda () (let () (~f)))))
(export cairo_version_string)

;; typedef int cairo_bool_t;
(if echo-decls (display "cairo_bool_t\n"))
(define cairo_bool_t-desc int)
(define unwrap-cairo_bool_t unwrap~fixed)
(define wrap-cairo_bool_t identity)

;; typedef struct _cairo cairo_t;
(if echo-decls (display "cairo_t\n"))
(define cairo_t-desc void)
(define cairo_t*-desc (bs:pointer cairo_t-desc))
(define-fh-pointer-type cairo_t* cairo_t*-desc)

;; typedef struct _cairo_surface cairo_surface_t;
(if echo-decls (display "cairo_surface_t\n"))
(define cairo_surface_t-desc void)
(define cairo_surface_t*-desc (bs:pointer cairo_surface_t-desc))
(define-fh-pointer-type cairo_surface_t* cairo_surface_t*-desc)

;; typedef struct _cairo_device cairo_device_t;
(if echo-decls (display "cairo_device_t\n"))
(define cairo_device_t-desc void)
(define cairo_device_t*-desc (bs:pointer cairo_device_t-desc))
(define-fh-pointer-type cairo_device_t* cairo_device_t*-desc)

;; typedef struct _cairo_matrix {
;;   double xx;
;;   double yx;
;;   double xy;
;;   double yy;
;;   double x0;
;;   double y0;
;; } cairo_matrix_t;
(if echo-decls (display "cairo_matrix_t\n"))
(define cairo_matrix_t-desc
  (bs:struct
    (list `(xx ,double)
          `(yx ,double)
          `(xy ,double)
          `(yy ,double)
          `(x0 ,double)
          `(y0 ,double))))
(export cairo_matrix_t-desc)
(define-fh-compound-type/p cairo_matrix_t cairo_matrix_t-desc)
(define struct-_cairo_matrix cairo_matrix_t)

;; typedef struct _cairo_pattern cairo_pattern_t;
(if echo-decls (display "cairo_pattern_t\n"))
(define cairo_pattern_t-desc void)
(define cairo_pattern_t*-desc (bs:pointer cairo_pattern_t-desc))
(define-fh-pointer-type cairo_pattern_t* cairo_pattern_t*-desc)

;; typedef void (*cairo_destroy_func_t)(void *data);
(if echo-decls (display "cairo_destroy_func_t\n"))
(define-fh-function/p cairo_destroy_func_t
  ffi:void (list (quote *)))

;; typedef struct _cairo_user_data_key {
;;   int unused;
;; } cairo_user_data_key_t;
(if echo-decls (display "cairo_user_data_key_t\n"))
(define cairo_user_data_key_t-desc
  (bs:struct (list `(unused ,int))))
(export cairo_user_data_key_t-desc)
(define-fh-compound-type/p cairo_user_data_key_t cairo_user_data_key_t-desc)
(define struct-_cairo_user_data_key cairo_user_data_key_t)

;; typedef enum _cairo_status {
;;   CAIRO_STATUS_SUCCESS = 0,
;;   CAIRO_STATUS_NO_MEMORY,
;;   CAIRO_STATUS_INVALID_RESTORE,
;;   CAIRO_STATUS_INVALID_POP_GROUP,
;;   CAIRO_STATUS_NO_CURRENT_POINT,
;;   CAIRO_STATUS_INVALID_MATRIX,
;;   CAIRO_STATUS_INVALID_STATUS,
;;   CAIRO_STATUS_NULL_POINTER,
;;   CAIRO_STATUS_INVALID_STRING,
;;   CAIRO_STATUS_INVALID_PATH_DATA,
;;   CAIRO_STATUS_READ_ERROR,
;;   CAIRO_STATUS_WRITE_ERROR,
;;   CAIRO_STATUS_SURFACE_FINISHED,
;;   CAIRO_STATUS_SURFACE_TYPE_MISMATCH,
;;   CAIRO_STATUS_PATTERN_TYPE_MISMATCH,
;;   CAIRO_STATUS_INVALID_CONTENT,
;;   CAIRO_STATUS_INVALID_FORMAT,
;;   CAIRO_STATUS_INVALID_VISUAL,
;;   CAIRO_STATUS_FILE_NOT_FOUND,
;;   CAIRO_STATUS_INVALID_DASH,
;;   CAIRO_STATUS_INVALID_DSC_COMMENT,
;;   CAIRO_STATUS_INVALID_INDEX,
;;   CAIRO_STATUS_CLIP_NOT_REPRESENTABLE,
;;   CAIRO_STATUS_TEMP_FILE_ERROR,
;;   CAIRO_STATUS_INVALID_STRIDE,
;;   CAIRO_STATUS_FONT_TYPE_MISMATCH,
;;   CAIRO_STATUS_USER_FONT_IMMUTABLE,
;;   CAIRO_STATUS_USER_FONT_ERROR,
;;   CAIRO_STATUS_NEGATIVE_COUNT,
;;   CAIRO_STATUS_INVALID_CLUSTERS,
;;   CAIRO_STATUS_INVALID_SLANT,
;;   CAIRO_STATUS_INVALID_WEIGHT,
;;   CAIRO_STATUS_INVALID_SIZE,
;;   CAIRO_STATUS_USER_FONT_NOT_IMPLEMENTED,
;;   CAIRO_STATUS_DEVICE_TYPE_MISMATCH,
;;   CAIRO_STATUS_DEVICE_ERROR,
;;   CAIRO_STATUS_INVALID_MESH_CONSTRUCTION,
;;   CAIRO_STATUS_DEVICE_FINISHED,
;;   CAIRO_STATUS_JBIG2_GLOBAL_MISSING,
;;   CAIRO_STATUS_LAST_STATUS,
;; } cairo_status_t;
(if echo-decls (display "cairo_status_t\n"))
(define-fh-enum cairo_status_t
  '((CAIRO_STATUS_SUCCESS . 0)
    (CAIRO_STATUS_NO_MEMORY . 1)
    (CAIRO_STATUS_INVALID_RESTORE . 2)
    (CAIRO_STATUS_INVALID_POP_GROUP . 3)
    (CAIRO_STATUS_NO_CURRENT_POINT . 4)
    (CAIRO_STATUS_INVALID_MATRIX . 5)
    (CAIRO_STATUS_INVALID_STATUS . 6)
    (CAIRO_STATUS_NULL_POINTER . 7)
    (CAIRO_STATUS_INVALID_STRING . 8)
    (CAIRO_STATUS_INVALID_PATH_DATA . 9)
    (CAIRO_STATUS_READ_ERROR . 10)
    (CAIRO_STATUS_WRITE_ERROR . 11)
    (CAIRO_STATUS_SURFACE_FINISHED . 12)
    (CAIRO_STATUS_SURFACE_TYPE_MISMATCH . 13)
    (CAIRO_STATUS_PATTERN_TYPE_MISMATCH . 14)
    (CAIRO_STATUS_INVALID_CONTENT . 15)
    (CAIRO_STATUS_INVALID_FORMAT . 16)
    (CAIRO_STATUS_INVALID_VISUAL . 17)
    (CAIRO_STATUS_FILE_NOT_FOUND . 18)
    (CAIRO_STATUS_INVALID_DASH . 19)
    (CAIRO_STATUS_INVALID_DSC_COMMENT . 20)
    (CAIRO_STATUS_INVALID_INDEX . 21)
    (CAIRO_STATUS_CLIP_NOT_REPRESENTABLE . 22)
    (CAIRO_STATUS_TEMP_FILE_ERROR . 23)
    (CAIRO_STATUS_INVALID_STRIDE . 24)
    (CAIRO_STATUS_FONT_TYPE_MISMATCH . 25)
    (CAIRO_STATUS_USER_FONT_IMMUTABLE . 26)
    (CAIRO_STATUS_USER_FONT_ERROR . 27)
    (CAIRO_STATUS_NEGATIVE_COUNT . 28)
    (CAIRO_STATUS_INVALID_CLUSTERS . 29)
    (CAIRO_STATUS_INVALID_SLANT . 30)
    (CAIRO_STATUS_INVALID_WEIGHT . 31)
    (CAIRO_STATUS_INVALID_SIZE . 32)
    (CAIRO_STATUS_USER_FONT_NOT_IMPLEMENTED . 33)
    (CAIRO_STATUS_DEVICE_TYPE_MISMATCH . 34)
    (CAIRO_STATUS_DEVICE_ERROR . 35)
    (CAIRO_STATUS_INVALID_MESH_CONSTRUCTION . 36)
    (CAIRO_STATUS_DEVICE_FINISHED . 37)
    (CAIRO_STATUS_JBIG2_GLOBAL_MISSING . 38)
    (CAIRO_STATUS_LAST_STATUS . 39))
  )
(define unwrap-enum-_cairo_status unwrap-cairo_status_t)
(define wrap-enum-_cairo_status wrap-cairo_status_t)

;; typedef enum _cairo_content {
;;   CAIRO_CONTENT_COLOR = 0x1000,
;;   CAIRO_CONTENT_ALPHA = 0x2000,
;;   CAIRO_CONTENT_COLOR_ALPHA = 0x3000,
;; } cairo_content_t;
(if echo-decls (display "cairo_content_t\n"))
(define-fh-enum cairo_content_t
  '((CAIRO_CONTENT_COLOR . 4096)
    (CAIRO_CONTENT_ALPHA . 8192)
    (CAIRO_CONTENT_COLOR_ALPHA . 12288))
  )
(define unwrap-enum-_cairo_content unwrap-cairo_content_t)
(define wrap-enum-_cairo_content wrap-cairo_content_t)

;; typedef enum _cairo_format {
;;   CAIRO_FORMAT_INVALID = -1,
;;   CAIRO_FORMAT_ARGB32 = 0,
;;   CAIRO_FORMAT_RGB24 = 1,
;;   CAIRO_FORMAT_A8 = 2,
;;   CAIRO_FORMAT_A1 = 3,
;;   CAIRO_FORMAT_RGB16_565 = 4,
;;   CAIRO_FORMAT_RGB30 = 5,
;; } cairo_format_t;
(if echo-decls (display "cairo_format_t\n"))
(define-fh-enum cairo_format_t
  '((CAIRO_FORMAT_INVALID . -1)
    (CAIRO_FORMAT_ARGB32 . 0)
    (CAIRO_FORMAT_RGB24 . 1)
    (CAIRO_FORMAT_A8 . 2)
    (CAIRO_FORMAT_A1 . 3)
    (CAIRO_FORMAT_RGB16_565 . 4)
    (CAIRO_FORMAT_RGB30 . 5))
  )
(define unwrap-enum-_cairo_format unwrap-cairo_format_t)
(define wrap-enum-_cairo_format wrap-cairo_format_t)

;; typedef cairo_status_t (*cairo_write_func_t)(void *closure, const 
;;     unsigned char *data, unsigned int length);
(if echo-decls (display "cairo_write_func_t\n"))
(define-fh-function/p cairo_write_func_t
  ffi:int (list (quote *) (quote *) ffi:unsigned-int))

;; typedef cairo_status_t (*cairo_read_func_t)(void *closure, unsigned char *
;;     data, unsigned int length);
(if echo-decls (display "cairo_read_func_t\n"))
(define-fh-function/p cairo_read_func_t
  ffi:int (list (quote *) (quote *) ffi:unsigned-int))

;; typedef struct _cairo_rectangle_int {
;;   int x, y;
;;   int width, height;
;; } cairo_rectangle_int_t;
(if echo-decls (display "cairo_rectangle_int_t\n"))
(define cairo_rectangle_int_t-desc
  (bs:struct
    (list `(y ,int)
          `(x ,int)
          `(height ,int)
          `(width ,int))))
(export cairo_rectangle_int_t-desc)
(define-fh-compound-type/p cairo_rectangle_int_t cairo_rectangle_int_t-desc)
(define struct-_cairo_rectangle_int cairo_rectangle_int_t)

;; cairo_t *cairo_create(cairo_surface_t *target);
(if echo-decls (display "cairo_create\n"))
(define cairo_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "cairo_create" (dynamic-link))
              (list '*))))
    (lambda (target)
      (let ((~target (unwrap-cairo_surface_t* target)))
        (wrap-cairo_t* (~f ~target))))))
(export cairo_create)

;; cairo_t *cairo_reference(cairo_t *cr);
(if echo-decls (display "cairo_reference\n"))
(define cairo_reference
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "cairo_reference" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_t* (~f ~cr))))))
(export cairo_reference)

;; void cairo_destroy(cairo_t *cr);
(if echo-decls (display "cairo_destroy\n"))
(define cairo_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_destroy" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_destroy)

;; unsigned int cairo_get_reference_count(cairo_t *cr);
(if echo-decls (display "cairo_get_reference_count\n"))
(define cairo_get_reference_count
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-int
              (dynamic-func
                "cairo_get_reference_count"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_reference_count)

;; void *cairo_get_user_data(cairo_t *cr, const cairo_user_data_key_t *key);
(if echo-decls (display "cairo_get_user_data\n"))
(define cairo_get_user_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_get_user_data"
                (dynamic-link))
              (list '* '*))))
    (lambda (cr key)
      (let ((~cr (unwrap-cairo_t* cr))
            (~key (unwrap-cairo_user_data_key_t* key)))
        (~f ~cr ~key)))))
(export cairo_get_user_data)

;; cairo_status_t cairo_set_user_data(cairo_t *cr, const cairo_user_data_key_t 
;;     *key, void *user_data, cairo_destroy_func_t destroy);
(if echo-decls (display "cairo_set_user_data\n"))
(define cairo_set_user_data
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_set_user_data"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (cr key user_data destroy)
      (let ((~cr (unwrap-cairo_t* cr))
            (~key (unwrap-cairo_user_data_key_t* key))
            (~user_data (unwrap~pointer user_data))
            (~destroy
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               destroy)))
        (~f ~cr ~key ~user_data ~destroy)))))
(export cairo_set_user_data)

;; void cairo_save(cairo_t *cr);
(if echo-decls (display "cairo_save\n"))
(define cairo_save
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_save" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_save)

;; void cairo_restore(cairo_t *cr);
(if echo-decls (display "cairo_restore\n"))
(define cairo_restore
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_restore" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_restore)

;; void cairo_push_group(cairo_t *cr);
(if echo-decls (display "cairo_push_group\n"))
(define cairo_push_group
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_push_group" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_push_group)

;; void cairo_push_group_with_content(cairo_t *cr, cairo_content_t content);
(if echo-decls (display "cairo_push_group_with_content\n"))
(define cairo_push_group_with_content
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_push_group_with_content"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (cr content)
      (let ((~cr (unwrap-cairo_t* cr))
            (~content (unwrap~fixed content)))
        (~f ~cr ~content)))))
(export cairo_push_group_with_content)

;; cairo_pattern_t *cairo_pop_group(cairo_t *cr);
(if echo-decls (display "cairo_pop_group\n"))
(define cairo_pop_group
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "cairo_pop_group" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_pattern_t* (~f ~cr))))))
(export cairo_pop_group)

;; void cairo_pop_group_to_source(cairo_t *cr);
(if echo-decls (display "cairo_pop_group_to_source\n"))
(define cairo_pop_group_to_source
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pop_group_to_source"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_pop_group_to_source)

;; typedef enum _cairo_operator {
;;   CAIRO_OPERATOR_CLEAR,
;;   CAIRO_OPERATOR_SOURCE,
;;   CAIRO_OPERATOR_OVER,
;;   CAIRO_OPERATOR_IN,
;;   CAIRO_OPERATOR_OUT,
;;   CAIRO_OPERATOR_ATOP,
;;   CAIRO_OPERATOR_DEST,
;;   CAIRO_OPERATOR_DEST_OVER,
;;   CAIRO_OPERATOR_DEST_IN,
;;   CAIRO_OPERATOR_DEST_OUT,
;;   CAIRO_OPERATOR_DEST_ATOP,
;;   CAIRO_OPERATOR_XOR,
;;   CAIRO_OPERATOR_ADD,
;;   CAIRO_OPERATOR_SATURATE,
;;   CAIRO_OPERATOR_MULTIPLY,
;;   CAIRO_OPERATOR_SCREEN,
;;   CAIRO_OPERATOR_OVERLAY,
;;   CAIRO_OPERATOR_DARKEN,
;;   CAIRO_OPERATOR_LIGHTEN,
;;   CAIRO_OPERATOR_COLOR_DODGE,
;;   CAIRO_OPERATOR_COLOR_BURN,
;;   CAIRO_OPERATOR_HARD_LIGHT,
;;   CAIRO_OPERATOR_SOFT_LIGHT,
;;   CAIRO_OPERATOR_DIFFERENCE,
;;   CAIRO_OPERATOR_EXCLUSION,
;;   CAIRO_OPERATOR_HSL_HUE,
;;   CAIRO_OPERATOR_HSL_SATURATION,
;;   CAIRO_OPERATOR_HSL_COLOR,
;;   CAIRO_OPERATOR_HSL_LUMINOSITY,
;; } cairo_operator_t;
(if echo-decls (display "cairo_operator_t\n"))
(define-fh-enum cairo_operator_t
  '((CAIRO_OPERATOR_CLEAR . 0)
    (CAIRO_OPERATOR_SOURCE . 1)
    (CAIRO_OPERATOR_OVER . 2)
    (CAIRO_OPERATOR_IN . 3)
    (CAIRO_OPERATOR_OUT . 4)
    (CAIRO_OPERATOR_ATOP . 5)
    (CAIRO_OPERATOR_DEST . 6)
    (CAIRO_OPERATOR_DEST_OVER . 7)
    (CAIRO_OPERATOR_DEST_IN . 8)
    (CAIRO_OPERATOR_DEST_OUT . 9)
    (CAIRO_OPERATOR_DEST_ATOP . 10)
    (CAIRO_OPERATOR_XOR . 11)
    (CAIRO_OPERATOR_ADD . 12)
    (CAIRO_OPERATOR_SATURATE . 13)
    (CAIRO_OPERATOR_MULTIPLY . 14)
    (CAIRO_OPERATOR_SCREEN . 15)
    (CAIRO_OPERATOR_OVERLAY . 16)
    (CAIRO_OPERATOR_DARKEN . 17)
    (CAIRO_OPERATOR_LIGHTEN . 18)
    (CAIRO_OPERATOR_COLOR_DODGE . 19)
    (CAIRO_OPERATOR_COLOR_BURN . 20)
    (CAIRO_OPERATOR_HARD_LIGHT . 21)
    (CAIRO_OPERATOR_SOFT_LIGHT . 22)
    (CAIRO_OPERATOR_DIFFERENCE . 23)
    (CAIRO_OPERATOR_EXCLUSION . 24)
    (CAIRO_OPERATOR_HSL_HUE . 25)
    (CAIRO_OPERATOR_HSL_SATURATION . 26)
    (CAIRO_OPERATOR_HSL_COLOR . 27)
    (CAIRO_OPERATOR_HSL_LUMINOSITY . 28))
  )
(define unwrap-enum-_cairo_operator unwrap-cairo_operator_t)
(define wrap-enum-_cairo_operator wrap-cairo_operator_t)

;; void cairo_set_operator(cairo_t *cr, cairo_operator_t op);
(if echo-decls (display "cairo_set_operator\n"))
(define cairo_set_operator
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_operator"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (cr op)
      (let ((~cr (unwrap-cairo_t* cr))
            (~op (unwrap~fixed op)))
        (~f ~cr ~op)))))
(export cairo_set_operator)

;; void cairo_set_source(cairo_t *cr, cairo_pattern_t *source);
(if echo-decls (display "cairo_set_source\n"))
(define cairo_set_source
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_set_source" (dynamic-link))
              (list '* '*))))
    (lambda (cr source)
      (let ((~cr (unwrap-cairo_t* cr))
            (~source (unwrap-cairo_pattern_t* source)))
        (~f ~cr ~source)))))
(export cairo_set_source)

;; void cairo_set_source_rgb(cairo_t *cr, double red, double green, double blue
;;     );
(if echo-decls (display "cairo_set_source_rgb\n"))
(define cairo_set_source_rgb
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_source_rgb"
                (dynamic-link))
              (list '* ffi:double ffi:double ffi:double))))
    (lambda (cr red green blue)
      (let ((~cr (unwrap-cairo_t* cr))
            (~red (unwrap~float red))
            (~green (unwrap~float green))
            (~blue (unwrap~float blue)))
        (~f ~cr ~red ~green ~blue)))))
(export cairo_set_source_rgb)

;; void cairo_set_source_rgba(cairo_t *cr, double red, double green, double 
;;     blue, double alpha);
(if echo-decls (display "cairo_set_source_rgba\n"))
(define cairo_set_source_rgba
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_source_rgba"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (cr red green blue alpha)
      (let ((~cr (unwrap-cairo_t* cr))
            (~red (unwrap~float red))
            (~green (unwrap~float green))
            (~blue (unwrap~float blue))
            (~alpha (unwrap~float alpha)))
        (~f ~cr ~red ~green ~blue ~alpha)))))
(export cairo_set_source_rgba)

;; void cairo_set_source_surface(cairo_t *cr, cairo_surface_t *surface, double 
;;     x, double y);
(if echo-decls (display "cairo_set_source_surface\n"))
(define cairo_set_source_surface
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_source_surface"
                (dynamic-link))
              (list '* '* ffi:double ffi:double))))
    (lambda (cr surface x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~surface (unwrap-cairo_surface_t* surface))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (~f ~cr ~surface ~x ~y)))))
(export cairo_set_source_surface)

;; void cairo_set_tolerance(cairo_t *cr, double tolerance);
(if echo-decls (display "cairo_set_tolerance\n"))
(define cairo_set_tolerance
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_tolerance"
                (dynamic-link))
              (list '* ffi:double))))
    (lambda (cr tolerance)
      (let ((~cr (unwrap-cairo_t* cr))
            (~tolerance (unwrap~float tolerance)))
        (~f ~cr ~tolerance)))))
(export cairo_set_tolerance)

;; typedef enum _cairo_antialias {
;;   CAIRO_ANTIALIAS_DEFAULT,
;;   CAIRO_ANTIALIAS_NONE,
;;   CAIRO_ANTIALIAS_GRAY,
;;   CAIRO_ANTIALIAS_SUBPIXEL,
;;   CAIRO_ANTIALIAS_FAST,
;;   CAIRO_ANTIALIAS_GOOD,
;;   CAIRO_ANTIALIAS_BEST,
;; } cairo_antialias_t;
(if echo-decls (display "cairo_antialias_t\n"))
(define-fh-enum cairo_antialias_t
  '((CAIRO_ANTIALIAS_DEFAULT . 0)
    (CAIRO_ANTIALIAS_NONE . 1)
    (CAIRO_ANTIALIAS_GRAY . 2)
    (CAIRO_ANTIALIAS_SUBPIXEL . 3)
    (CAIRO_ANTIALIAS_FAST . 4)
    (CAIRO_ANTIALIAS_GOOD . 5)
    (CAIRO_ANTIALIAS_BEST . 6))
  )
(define unwrap-enum-_cairo_antialias unwrap-cairo_antialias_t)
(define wrap-enum-_cairo_antialias wrap-cairo_antialias_t)

;; void cairo_set_antialias(cairo_t *cr, cairo_antialias_t antialias);
(if echo-decls (display "cairo_set_antialias\n"))
(define cairo_set_antialias
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_antialias"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (cr antialias)
      (let ((~cr (unwrap-cairo_t* cr))
            (~antialias (unwrap~fixed antialias)))
        (~f ~cr ~antialias)))))
(export cairo_set_antialias)

;; typedef enum _cairo_fill_rule {
;;   CAIRO_FILL_RULE_WINDING,
;;   CAIRO_FILL_RULE_EVEN_ODD,
;; } cairo_fill_rule_t;
(if echo-decls (display "cairo_fill_rule_t\n"))
(define-fh-enum cairo_fill_rule_t
  '((CAIRO_FILL_RULE_WINDING . 0)
    (CAIRO_FILL_RULE_EVEN_ODD . 1))
  )
(define unwrap-enum-_cairo_fill_rule unwrap-cairo_fill_rule_t)
(define wrap-enum-_cairo_fill_rule wrap-cairo_fill_rule_t)

;; void cairo_set_fill_rule(cairo_t *cr, cairo_fill_rule_t fill_rule);
(if echo-decls (display "cairo_set_fill_rule\n"))
(define cairo_set_fill_rule
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_fill_rule"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (cr fill_rule)
      (let ((~cr (unwrap-cairo_t* cr))
            (~fill_rule (unwrap~fixed fill_rule)))
        (~f ~cr ~fill_rule)))))
(export cairo_set_fill_rule)

;; void cairo_set_line_width(cairo_t *cr, double width);
(if echo-decls (display "cairo_set_line_width\n"))
(define cairo_set_line_width
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_line_width"
                (dynamic-link))
              (list '* ffi:double))))
    (lambda (cr width)
      (let ((~cr (unwrap-cairo_t* cr))
            (~width (unwrap~float width)))
        (~f ~cr ~width)))))
(export cairo_set_line_width)

;; typedef enum _cairo_line_cap {
;;   CAIRO_LINE_CAP_BUTT,
;;   CAIRO_LINE_CAP_ROUND,
;;   CAIRO_LINE_CAP_SQUARE,
;; } cairo_line_cap_t;
(if echo-decls (display "cairo_line_cap_t\n"))
(define-fh-enum cairo_line_cap_t
  '((CAIRO_LINE_CAP_BUTT . 0)
    (CAIRO_LINE_CAP_ROUND . 1)
    (CAIRO_LINE_CAP_SQUARE . 2))
  )
(define unwrap-enum-_cairo_line_cap unwrap-cairo_line_cap_t)
(define wrap-enum-_cairo_line_cap wrap-cairo_line_cap_t)

;; void cairo_set_line_cap(cairo_t *cr, cairo_line_cap_t line_cap);
(if echo-decls (display "cairo_set_line_cap\n"))
(define cairo_set_line_cap
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_line_cap"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (cr line_cap)
      (let ((~cr (unwrap-cairo_t* cr))
            (~line_cap (unwrap~fixed line_cap)))
        (~f ~cr ~line_cap)))))
(export cairo_set_line_cap)

;; typedef enum _cairo_line_join {
;;   CAIRO_LINE_JOIN_MITER,
;;   CAIRO_LINE_JOIN_ROUND,
;;   CAIRO_LINE_JOIN_BEVEL,
;; } cairo_line_join_t;
(if echo-decls (display "cairo_line_join_t\n"))
(define-fh-enum cairo_line_join_t
  '((CAIRO_LINE_JOIN_MITER . 0)
    (CAIRO_LINE_JOIN_ROUND . 1)
    (CAIRO_LINE_JOIN_BEVEL . 2))
  )
(define unwrap-enum-_cairo_line_join unwrap-cairo_line_join_t)
(define wrap-enum-_cairo_line_join wrap-cairo_line_join_t)

;; void cairo_set_line_join(cairo_t *cr, cairo_line_join_t line_join);
(if echo-decls (display "cairo_set_line_join\n"))
(define cairo_set_line_join
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_line_join"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (cr line_join)
      (let ((~cr (unwrap-cairo_t* cr))
            (~line_join (unwrap~fixed line_join)))
        (~f ~cr ~line_join)))))
(export cairo_set_line_join)

;; void cairo_set_dash(cairo_t *cr, const double *dashes, int num_dashes, 
;;     double offset);
(if echo-decls (display "cairo_set_dash\n"))
(define cairo_set_dash
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_set_dash" (dynamic-link))
              (list '* '* ffi:int ffi:double))))
    (lambda (cr dashes num_dashes offset)
      (let ((~cr (unwrap-cairo_t* cr))
            (~dashes (unwrap~pointer dashes))
            (~num_dashes (unwrap~fixed num_dashes))
            (~offset (unwrap~float offset)))
        (~f ~cr ~dashes ~num_dashes ~offset)))))
(export cairo_set_dash)

;; void cairo_set_miter_limit(cairo_t *cr, double limit);
(if echo-decls (display "cairo_set_miter_limit\n"))
(define cairo_set_miter_limit
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_miter_limit"
                (dynamic-link))
              (list '* ffi:double))))
    (lambda (cr limit)
      (let ((~cr (unwrap-cairo_t* cr))
            (~limit (unwrap~float limit)))
        (~f ~cr ~limit)))))
(export cairo_set_miter_limit)

;; void cairo_translate(cairo_t *cr, double tx, double ty);
(if echo-decls (display "cairo_translate\n"))
(define cairo_translate
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_translate" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr tx ty)
      (let ((~cr (unwrap-cairo_t* cr))
            (~tx (unwrap~float tx))
            (~ty (unwrap~float ty)))
        (~f ~cr ~tx ~ty)))))
(export cairo_translate)

;; void cairo_scale(cairo_t *cr, double sx, double sy);
(if echo-decls (display "cairo_scale\n"))
(define cairo_scale
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_scale" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr sx sy)
      (let ((~cr (unwrap-cairo_t* cr))
            (~sx (unwrap~float sx))
            (~sy (unwrap~float sy)))
        (~f ~cr ~sx ~sy)))))
(export cairo_scale)

;; void cairo_rotate(cairo_t *cr, double angle);
(if echo-decls (display "cairo_rotate\n"))
(define cairo_rotate
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_rotate" (dynamic-link))
              (list '* ffi:double))))
    (lambda (cr angle)
      (let ((~cr (unwrap-cairo_t* cr))
            (~angle (unwrap~float angle)))
        (~f ~cr ~angle)))))
(export cairo_rotate)

;; void cairo_transform(cairo_t *cr, const cairo_matrix_t *matrix);
(if echo-decls (display "cairo_transform\n"))
(define cairo_transform
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_transform" (dynamic-link))
              (list '* '*))))
    (lambda (cr matrix)
      (let ((~cr (unwrap-cairo_t* cr))
            (~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~cr ~matrix)))))
(export cairo_transform)

;; void cairo_set_matrix(cairo_t *cr, const cairo_matrix_t *matrix);
(if echo-decls (display "cairo_set_matrix\n"))
(define cairo_set_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_set_matrix" (dynamic-link))
              (list '* '*))))
    (lambda (cr matrix)
      (let ((~cr (unwrap-cairo_t* cr))
            (~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~cr ~matrix)))))
(export cairo_set_matrix)

;; void cairo_identity_matrix(cairo_t *cr);
(if echo-decls (display "cairo_identity_matrix\n"))
(define cairo_identity_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_identity_matrix"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_identity_matrix)

;; void cairo_user_to_device(cairo_t *cr, double *x, double *y);
(if echo-decls (display "cairo_user_to_device\n"))
(define cairo_user_to_device
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_user_to_device"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (cr x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~pointer x))
            (~y (unwrap~pointer y)))
        (~f ~cr ~x ~y)))))
(export cairo_user_to_device)

;; void cairo_user_to_device_distance(cairo_t *cr, double *dx, double *dy);
(if echo-decls (display "cairo_user_to_device_distance\n"))
(define cairo_user_to_device_distance
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_user_to_device_distance"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (cr dx dy)
      (let ((~cr (unwrap-cairo_t* cr))
            (~dx (unwrap~pointer dx))
            (~dy (unwrap~pointer dy)))
        (~f ~cr ~dx ~dy)))))
(export cairo_user_to_device_distance)

;; void cairo_device_to_user(cairo_t *cr, double *x, double *y);
(if echo-decls (display "cairo_device_to_user\n"))
(define cairo_device_to_user
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_device_to_user"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (cr x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~pointer x))
            (~y (unwrap~pointer y)))
        (~f ~cr ~x ~y)))))
(export cairo_device_to_user)

;; void cairo_device_to_user_distance(cairo_t *cr, double *dx, double *dy);
(if echo-decls (display "cairo_device_to_user_distance\n"))
(define cairo_device_to_user_distance
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_device_to_user_distance"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (cr dx dy)
      (let ((~cr (unwrap-cairo_t* cr))
            (~dx (unwrap~pointer dx))
            (~dy (unwrap~pointer dy)))
        (~f ~cr ~dx ~dy)))))
(export cairo_device_to_user_distance)

;; void cairo_new_path(cairo_t *cr);
(if echo-decls (display "cairo_new_path\n"))
(define cairo_new_path
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_new_path" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_new_path)

;; void cairo_move_to(cairo_t *cr, double x, double y);
(if echo-decls (display "cairo_move_to\n"))
(define cairo_move_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_move_to" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (~f ~cr ~x ~y)))))
(export cairo_move_to)

;; void cairo_new_sub_path(cairo_t *cr);
(if echo-decls (display "cairo_new_sub_path\n"))
(define cairo_new_sub_path
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_new_sub_path"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_new_sub_path)

;; void cairo_line_to(cairo_t *cr, double x, double y);
(if echo-decls (display "cairo_line_to\n"))
(define cairo_line_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_line_to" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (~f ~cr ~x ~y)))))
(export cairo_line_to)

;; void cairo_curve_to(cairo_t *cr, double x1, double y1, double x2, double y2
;;     , double x3, double y3);
(if echo-decls (display "cairo_curve_to\n"))
(define cairo_curve_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_curve_to" (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (cr x1 y1 x2 y2 x3 y3)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x1 (unwrap~float x1))
            (~y1 (unwrap~float y1))
            (~x2 (unwrap~float x2))
            (~y2 (unwrap~float y2))
            (~x3 (unwrap~float x3))
            (~y3 (unwrap~float y3)))
        (~f ~cr ~x1 ~y1 ~x2 ~y2 ~x3 ~y3)))))
(export cairo_curve_to)

;; void cairo_arc(cairo_t *cr, double xc, double yc, double radius, double 
;;     angle1, double angle2);
(if echo-decls (display "cairo_arc\n"))
(define cairo_arc
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_arc" (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (cr xc yc radius angle1 angle2)
      (let ((~cr (unwrap-cairo_t* cr))
            (~xc (unwrap~float xc))
            (~yc (unwrap~float yc))
            (~radius (unwrap~float radius))
            (~angle1 (unwrap~float angle1))
            (~angle2 (unwrap~float angle2)))
        (~f ~cr ~xc ~yc ~radius ~angle1 ~angle2)))))
(export cairo_arc)

;; void cairo_arc_negative(cairo_t *cr, double xc, double yc, double radius, 
;;     double angle1, double angle2);
(if echo-decls (display "cairo_arc_negative\n"))
(define cairo_arc_negative
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_arc_negative"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (cr xc yc radius angle1 angle2)
      (let ((~cr (unwrap-cairo_t* cr))
            (~xc (unwrap~float xc))
            (~yc (unwrap~float yc))
            (~radius (unwrap~float radius))
            (~angle1 (unwrap~float angle1))
            (~angle2 (unwrap~float angle2)))
        (~f ~cr ~xc ~yc ~radius ~angle1 ~angle2)))))
(export cairo_arc_negative)

;; void cairo_rel_move_to(cairo_t *cr, double dx, double dy);
(if echo-decls (display "cairo_rel_move_to\n"))
(define cairo_rel_move_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_rel_move_to" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr dx dy)
      (let ((~cr (unwrap-cairo_t* cr))
            (~dx (unwrap~float dx))
            (~dy (unwrap~float dy)))
        (~f ~cr ~dx ~dy)))))
(export cairo_rel_move_to)

;; void cairo_rel_line_to(cairo_t *cr, double dx, double dy);
(if echo-decls (display "cairo_rel_line_to\n"))
(define cairo_rel_line_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_rel_line_to" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr dx dy)
      (let ((~cr (unwrap-cairo_t* cr))
            (~dx (unwrap~float dx))
            (~dy (unwrap~float dy)))
        (~f ~cr ~dx ~dy)))))
(export cairo_rel_line_to)

;; void cairo_rel_curve_to(cairo_t *cr, double dx1, double dy1, double dx2, 
;;     double dy2, double dx3, double dy3);
(if echo-decls (display "cairo_rel_curve_to\n"))
(define cairo_rel_curve_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_rel_curve_to"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (cr dx1 dy1 dx2 dy2 dx3 dy3)
      (let ((~cr (unwrap-cairo_t* cr))
            (~dx1 (unwrap~float dx1))
            (~dy1 (unwrap~float dy1))
            (~dx2 (unwrap~float dx2))
            (~dy2 (unwrap~float dy2))
            (~dx3 (unwrap~float dx3))
            (~dy3 (unwrap~float dy3)))
        (~f ~cr ~dx1 ~dy1 ~dx2 ~dy2 ~dx3 ~dy3)))))
(export cairo_rel_curve_to)

;; void cairo_rectangle(cairo_t *cr, double x, double y, double width, double 
;;     height);
(if echo-decls (display "cairo_rectangle\n"))
(define cairo_rectangle
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_rectangle" (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (cr x y width height)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~float x))
            (~y (unwrap~float y))
            (~width (unwrap~float width))
            (~height (unwrap~float height)))
        (~f ~cr ~x ~y ~width ~height)))))
(export cairo_rectangle)

;; void cairo_close_path(cairo_t *cr);
(if echo-decls (display "cairo_close_path\n"))
(define cairo_close_path
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_close_path" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_close_path)

;; void cairo_path_extents(cairo_t *cr, double *x1, double *y1, double *x2, 
;;     double *y2);
(if echo-decls (display "cairo_path_extents\n"))
(define cairo_path_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_path_extents"
                (dynamic-link))
              (list '* '* '* '* '*))))
    (lambda (cr x1 y1 x2 y2)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x1 (unwrap~pointer x1))
            (~y1 (unwrap~pointer y1))
            (~x2 (unwrap~pointer x2))
            (~y2 (unwrap~pointer y2)))
        (~f ~cr ~x1 ~y1 ~x2 ~y2)))))
(export cairo_path_extents)

;; void cairo_paint(cairo_t *cr);
(if echo-decls (display "cairo_paint\n"))
(define cairo_paint
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_paint" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_paint)

;; void cairo_paint_with_alpha(cairo_t *cr, double alpha);
(if echo-decls (display "cairo_paint_with_alpha\n"))
(define cairo_paint_with_alpha
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_paint_with_alpha"
                (dynamic-link))
              (list '* ffi:double))))
    (lambda (cr alpha)
      (let ((~cr (unwrap-cairo_t* cr))
            (~alpha (unwrap~float alpha)))
        (~f ~cr ~alpha)))))
(export cairo_paint_with_alpha)

;; void cairo_mask(cairo_t *cr, cairo_pattern_t *pattern);
(if echo-decls (display "cairo_mask\n"))
(define cairo_mask
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_mask" (dynamic-link))
              (list '* '*))))
    (lambda (cr pattern)
      (let ((~cr (unwrap-cairo_t* cr))
            (~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~cr ~pattern)))))
(export cairo_mask)

;; void cairo_mask_surface(cairo_t *cr, cairo_surface_t *surface, double 
;;     surface_x, double surface_y);
(if echo-decls (display "cairo_mask_surface\n"))
(define cairo_mask_surface
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mask_surface"
                (dynamic-link))
              (list '* '* ffi:double ffi:double))))
    (lambda (cr surface surface_x surface_y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~surface (unwrap-cairo_surface_t* surface))
            (~surface_x (unwrap~float surface_x))
            (~surface_y (unwrap~float surface_y)))
        (~f ~cr ~surface ~surface_x ~surface_y)))))
(export cairo_mask_surface)

;; void cairo_stroke(cairo_t *cr);
(if echo-decls (display "cairo_stroke\n"))
(define cairo_stroke
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_stroke" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_stroke)

;; void cairo_stroke_preserve(cairo_t *cr);
(if echo-decls (display "cairo_stroke_preserve\n"))
(define cairo_stroke_preserve
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_stroke_preserve"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_stroke_preserve)

;; void cairo_fill(cairo_t *cr);
(if echo-decls (display "cairo_fill\n"))
(define cairo_fill
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_fill" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_fill)

;; void cairo_fill_preserve(cairo_t *cr);
(if echo-decls (display "cairo_fill_preserve\n"))
(define cairo_fill_preserve
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_fill_preserve"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_fill_preserve)

;; void cairo_copy_page(cairo_t *cr);
(if echo-decls (display "cairo_copy_page\n"))
(define cairo_copy_page
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_copy_page" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_copy_page)

;; void cairo_show_page(cairo_t *cr);
(if echo-decls (display "cairo_show_page\n"))
(define cairo_show_page
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_show_page" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_show_page)

;; cairo_bool_t cairo_in_stroke(cairo_t *cr, double x, double y);
(if echo-decls (display "cairo_in_stroke\n"))
(define cairo_in_stroke
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "cairo_in_stroke" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (wrap-cairo_bool_t (~f ~cr ~x ~y))))))
(export cairo_in_stroke)

;; cairo_bool_t cairo_in_fill(cairo_t *cr, double x, double y);
(if echo-decls (display "cairo_in_fill\n"))
(define cairo_in_fill
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "cairo_in_fill" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (wrap-cairo_bool_t (~f ~cr ~x ~y))))))
(export cairo_in_fill)

;; cairo_bool_t cairo_in_clip(cairo_t *cr, double x, double y);
(if echo-decls (display "cairo_in_clip\n"))
(define cairo_in_clip
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "cairo_in_clip" (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (cr x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (wrap-cairo_bool_t (~f ~cr ~x ~y))))))
(export cairo_in_clip)

;; void cairo_stroke_extents(cairo_t *cr, double *x1, double *y1, double *x2, 
;;     double *y2);
(if echo-decls (display "cairo_stroke_extents\n"))
(define cairo_stroke_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_stroke_extents"
                (dynamic-link))
              (list '* '* '* '* '*))))
    (lambda (cr x1 y1 x2 y2)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x1 (unwrap~pointer x1))
            (~y1 (unwrap~pointer y1))
            (~x2 (unwrap~pointer x2))
            (~y2 (unwrap~pointer y2)))
        (~f ~cr ~x1 ~y1 ~x2 ~y2)))))
(export cairo_stroke_extents)

;; void cairo_fill_extents(cairo_t *cr, double *x1, double *y1, double *x2, 
;;     double *y2);
(if echo-decls (display "cairo_fill_extents\n"))
(define cairo_fill_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_fill_extents"
                (dynamic-link))
              (list '* '* '* '* '*))))
    (lambda (cr x1 y1 x2 y2)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x1 (unwrap~pointer x1))
            (~y1 (unwrap~pointer y1))
            (~x2 (unwrap~pointer x2))
            (~y2 (unwrap~pointer y2)))
        (~f ~cr ~x1 ~y1 ~x2 ~y2)))))
(export cairo_fill_extents)

;; void cairo_reset_clip(cairo_t *cr);
(if echo-decls (display "cairo_reset_clip\n"))
(define cairo_reset_clip
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_reset_clip" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_reset_clip)

;; void cairo_clip(cairo_t *cr);
(if echo-decls (display "cairo_clip\n"))
(define cairo_clip
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_clip" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_clip)

;; void cairo_clip_preserve(cairo_t *cr);
(if echo-decls (display "cairo_clip_preserve\n"))
(define cairo_clip_preserve
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_clip_preserve"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_clip_preserve)

;; void cairo_clip_extents(cairo_t *cr, double *x1, double *y1, double *x2, 
;;     double *y2);
(if echo-decls (display "cairo_clip_extents\n"))
(define cairo_clip_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_clip_extents"
                (dynamic-link))
              (list '* '* '* '* '*))))
    (lambda (cr x1 y1 x2 y2)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x1 (unwrap~pointer x1))
            (~y1 (unwrap~pointer y1))
            (~x2 (unwrap~pointer x2))
            (~y2 (unwrap~pointer y2)))
        (~f ~cr ~x1 ~y1 ~x2 ~y2)))))
(export cairo_clip_extents)

;; typedef struct _cairo_rectangle {
;;   double x, y, width, height;
;; } cairo_rectangle_t;
(if echo-decls (display "cairo_rectangle_t\n"))
(define cairo_rectangle_t-desc
  (bs:struct
    (list `(height ,double)
          `(width ,double)
          `(y ,double)
          `(x ,double))))
(export cairo_rectangle_t-desc)
(define-fh-compound-type/p cairo_rectangle_t cairo_rectangle_t-desc)
(define struct-_cairo_rectangle cairo_rectangle_t)

;; typedef struct _cairo_rectangle_list {
;;   cairo_status_t status;
;;   cairo_rectangle_t *rectangles;
;;   int num_rectangles;
;; } cairo_rectangle_list_t;
(if echo-decls (display "cairo_rectangle_list_t\n"))
(define cairo_rectangle_list_t-desc
  (bs:struct
    (list `(status ,int)
          `(rectangles
             ,(bs:pointer cairo_rectangle_t*-desc))
          `(num_rectangles ,int))))
(export cairo_rectangle_list_t-desc)
(define-fh-compound-type/p cairo_rectangle_list_t cairo_rectangle_list_t-desc)
(define struct-_cairo_rectangle_list cairo_rectangle_list_t)

;; cairo_rectangle_list_t *cairo_copy_clip_rectangle_list(cairo_t *cr);
(if echo-decls (display "cairo_copy_clip_rectangle_list\n"))
(define cairo_copy_clip_rectangle_list
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_copy_clip_rectangle_list"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_rectangle_list_t* (~f ~cr))))))
(export cairo_copy_clip_rectangle_list)

;; void cairo_rectangle_list_destroy(cairo_rectangle_list_t *rectangle_list);
(if echo-decls (display "cairo_rectangle_list_destroy\n"))
(define cairo_rectangle_list_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_rectangle_list_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (rectangle_list)
      (let ((~rectangle_list
              (unwrap-cairo_rectangle_list_t* rectangle_list)))
        (~f ~rectangle_list)))))
(export cairo_rectangle_list_destroy)

;; typedef struct _cairo_scaled_font cairo_scaled_font_t;
(if echo-decls (display "cairo_scaled_font_t\n"))
(define cairo_scaled_font_t-desc void)
(define cairo_scaled_font_t*-desc (bs:pointer cairo_scaled_font_t-desc))
(define-fh-pointer-type cairo_scaled_font_t* cairo_scaled_font_t*-desc)

;; typedef struct _cairo_font_face cairo_font_face_t;
(if echo-decls (display "cairo_font_face_t\n"))
(define cairo_font_face_t-desc void)
(define cairo_font_face_t*-desc (bs:pointer cairo_font_face_t-desc))
(define-fh-pointer-type cairo_font_face_t* cairo_font_face_t*-desc)

;; typedef struct {
;;   unsigned long index;
;;   double x;
;;   double y;
;; } cairo_glyph_t;
(if echo-decls (display "cairo_glyph_t\n"))
(define cairo_glyph_t-desc
  (bs:struct
    (list `(index ,unsigned-long)
          `(x ,double)
          `(y ,double))))
(export cairo_glyph_t-desc)
(define-fh-compound-type/p cairo_glyph_t cairo_glyph_t-desc)

;; cairo_glyph_t *cairo_glyph_allocate(int num_glyphs);
(if echo-decls (display "cairo_glyph_allocate\n"))
(define cairo_glyph_allocate
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_glyph_allocate"
                (dynamic-link))
              (list ffi:int))))
    (lambda (num_glyphs)
      (let ((~num_glyphs (unwrap~fixed num_glyphs)))
        (wrap-cairo_glyph_t* (~f ~num_glyphs))))))
(export cairo_glyph_allocate)

;; void cairo_glyph_free(cairo_glyph_t *glyphs);
(if echo-decls (display "cairo_glyph_free\n"))
(define cairo_glyph_free
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_glyph_free" (dynamic-link))
              (list '*))))
    (lambda (glyphs)
      (let ((~glyphs (unwrap-cairo_glyph_t* glyphs)))
        (~f ~glyphs)))))
(export cairo_glyph_free)

;; typedef struct {
;;   int num_bytes;
;;   int num_glyphs;
;; } cairo_text_cluster_t;
(if echo-decls (display "cairo_text_cluster_t\n"))
(define cairo_text_cluster_t-desc
  (bs:struct
    (list `(num_bytes ,int) `(num_glyphs ,int))))
(export cairo_text_cluster_t-desc)
(define-fh-compound-type/p cairo_text_cluster_t cairo_text_cluster_t-desc)

;; cairo_text_cluster_t *cairo_text_cluster_allocate(int num_clusters);
(if echo-decls (display "cairo_text_cluster_allocate\n"))
(define cairo_text_cluster_allocate
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_text_cluster_allocate"
                (dynamic-link))
              (list ffi:int))))
    (lambda (num_clusters)
      (let ((~num_clusters (unwrap~fixed num_clusters)))
        (wrap-cairo_text_cluster_t* (~f ~num_clusters))))))
(export cairo_text_cluster_allocate)

;; void cairo_text_cluster_free(cairo_text_cluster_t *clusters);
(if echo-decls (display "cairo_text_cluster_free\n"))
(define cairo_text_cluster_free
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_text_cluster_free"
                (dynamic-link))
              (list '*))))
    (lambda (clusters)
      (let ((~clusters
              (unwrap-cairo_text_cluster_t* clusters)))
        (~f ~clusters)))))
(export cairo_text_cluster_free)

;; typedef enum _cairo_text_cluster_flags {
;;   CAIRO_TEXT_CLUSTER_FLAG_BACKWARD = 0x00000001,
;; } cairo_text_cluster_flags_t;
(if echo-decls (display "cairo_text_cluster_flags_t\n"))
(define-fh-enum cairo_text_cluster_flags_t
  '((CAIRO_TEXT_CLUSTER_FLAG_BACKWARD . 1))
  )
(define unwrap-enum-_cairo_text_cluster_flags unwrap-cairo_text_cluster_flags_t)
(define wrap-enum-_cairo_text_cluster_flags wrap-cairo_text_cluster_flags_t)

;; typedef struct {
;;   double x_bearing;
;;   double y_bearing;
;;   double width;
;;   double height;
;;   double x_advance;
;;   double y_advance;
;; } cairo_text_extents_t;
(if echo-decls (display "cairo_text_extents_t\n"))
(define cairo_text_extents_t-desc
  (bs:struct
    (list `(x_bearing ,double)
          `(y_bearing ,double)
          `(width ,double)
          `(height ,double)
          `(x_advance ,double)
          `(y_advance ,double))))
(export cairo_text_extents_t-desc)
(define-fh-compound-type/p cairo_text_extents_t cairo_text_extents_t-desc)

;; typedef struct {
;;   double ascent;
;;   double descent;
;;   double height;
;;   double max_x_advance;
;;   double max_y_advance;
;; } cairo_font_extents_t;
(if echo-decls (display "cairo_font_extents_t\n"))
(define cairo_font_extents_t-desc
  (bs:struct
    (list `(ascent ,double)
          `(descent ,double)
          `(height ,double)
          `(max_x_advance ,double)
          `(max_y_advance ,double))))
(export cairo_font_extents_t-desc)
(define-fh-compound-type/p cairo_font_extents_t cairo_font_extents_t-desc)

;; typedef enum _cairo_font_slant {
;;   CAIRO_FONT_SLANT_NORMAL,
;;   CAIRO_FONT_SLANT_ITALIC,
;;   CAIRO_FONT_SLANT_OBLIQUE,
;; } cairo_font_slant_t;
(if echo-decls (display "cairo_font_slant_t\n"))
(define-fh-enum cairo_font_slant_t
  '((CAIRO_FONT_SLANT_NORMAL . 0)
    (CAIRO_FONT_SLANT_ITALIC . 1)
    (CAIRO_FONT_SLANT_OBLIQUE . 2))
  )
(define unwrap-enum-_cairo_font_slant unwrap-cairo_font_slant_t)
(define wrap-enum-_cairo_font_slant wrap-cairo_font_slant_t)

;; typedef enum _cairo_font_weight {
;;   CAIRO_FONT_WEIGHT_NORMAL,
;;   CAIRO_FONT_WEIGHT_BOLD,
;; } cairo_font_weight_t;
(if echo-decls (display "cairo_font_weight_t\n"))
(define-fh-enum cairo_font_weight_t
  '((CAIRO_FONT_WEIGHT_NORMAL . 0)
    (CAIRO_FONT_WEIGHT_BOLD . 1))
  )
(define unwrap-enum-_cairo_font_weight unwrap-cairo_font_weight_t)
(define wrap-enum-_cairo_font_weight wrap-cairo_font_weight_t)

;; typedef enum _cairo_subpixel_order {
;;   CAIRO_SUBPIXEL_ORDER_DEFAULT,
;;   CAIRO_SUBPIXEL_ORDER_RGB,
;;   CAIRO_SUBPIXEL_ORDER_BGR,
;;   CAIRO_SUBPIXEL_ORDER_VRGB,
;;   CAIRO_SUBPIXEL_ORDER_VBGR,
;; } cairo_subpixel_order_t;
(if echo-decls (display "cairo_subpixel_order_t\n"))
(define-fh-enum cairo_subpixel_order_t
  '((CAIRO_SUBPIXEL_ORDER_DEFAULT . 0)
    (CAIRO_SUBPIXEL_ORDER_RGB . 1)
    (CAIRO_SUBPIXEL_ORDER_BGR . 2)
    (CAIRO_SUBPIXEL_ORDER_VRGB . 3)
    (CAIRO_SUBPIXEL_ORDER_VBGR . 4))
  )
(define unwrap-enum-_cairo_subpixel_order unwrap-cairo_subpixel_order_t)
(define wrap-enum-_cairo_subpixel_order wrap-cairo_subpixel_order_t)

;; typedef enum _cairo_hint_style {
;;   CAIRO_HINT_STYLE_DEFAULT,
;;   CAIRO_HINT_STYLE_NONE,
;;   CAIRO_HINT_STYLE_SLIGHT,
;;   CAIRO_HINT_STYLE_MEDIUM,
;;   CAIRO_HINT_STYLE_FULL,
;; } cairo_hint_style_t;
(if echo-decls (display "cairo_hint_style_t\n"))
(define-fh-enum cairo_hint_style_t
  '((CAIRO_HINT_STYLE_DEFAULT . 0)
    (CAIRO_HINT_STYLE_NONE . 1)
    (CAIRO_HINT_STYLE_SLIGHT . 2)
    (CAIRO_HINT_STYLE_MEDIUM . 3)
    (CAIRO_HINT_STYLE_FULL . 4))
  )
(define unwrap-enum-_cairo_hint_style unwrap-cairo_hint_style_t)
(define wrap-enum-_cairo_hint_style wrap-cairo_hint_style_t)

;; typedef enum _cairo_hint_metrics {
;;   CAIRO_HINT_METRICS_DEFAULT,
;;   CAIRO_HINT_METRICS_OFF,
;;   CAIRO_HINT_METRICS_ON,
;; } cairo_hint_metrics_t;
(if echo-decls (display "cairo_hint_metrics_t\n"))
(define-fh-enum cairo_hint_metrics_t
  '((CAIRO_HINT_METRICS_DEFAULT . 0)
    (CAIRO_HINT_METRICS_OFF . 1)
    (CAIRO_HINT_METRICS_ON . 2))
  )
(define unwrap-enum-_cairo_hint_metrics unwrap-cairo_hint_metrics_t)
(define wrap-enum-_cairo_hint_metrics wrap-cairo_hint_metrics_t)

;; typedef struct _cairo_font_options cairo_font_options_t;
(if echo-decls (display "cairo_font_options_t\n"))
(define cairo_font_options_t-desc void)
(define cairo_font_options_t*-desc (bs:pointer cairo_font_options_t-desc))
(define-fh-pointer-type cairo_font_options_t* cairo_font_options_t*-desc)

;; cairo_font_options_t *cairo_font_options_create(void);
(if echo-decls (display "cairo_font_options_create\n"))
(define cairo_font_options_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_font_options_create"
                (dynamic-link))
              (list))))
    (lambda ()
      (let () (wrap-cairo_font_options_t* (~f))))))
(export cairo_font_options_create)

;; cairo_font_options_t *cairo_font_options_copy(const cairo_font_options_t *
;;     original);
(if echo-decls (display "cairo_font_options_copy\n"))
(define cairo_font_options_copy
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_font_options_copy"
                (dynamic-link))
              (list '*))))
    (lambda (original)
      (let ((~original
              (unwrap-cairo_font_options_t* original)))
        (wrap-cairo_font_options_t* (~f ~original))))))
(export cairo_font_options_copy)

;; void cairo_font_options_destroy(cairo_font_options_t *options);
(if echo-decls (display "cairo_font_options_destroy\n"))
(define cairo_font_options_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_font_options_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (options)
      (let ((~options (unwrap-cairo_font_options_t* options)))
        (~f ~options)))))
(export cairo_font_options_destroy)

;; cairo_status_t cairo_font_options_status(cairo_font_options_t *options);
(if echo-decls (display "cairo_font_options_status\n"))
(define cairo_font_options_status
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_options_status"
                (dynamic-link))
              (list '*))))
    (lambda (options)
      (let ((~options (unwrap-cairo_font_options_t* options)))
        (~f ~options)))))
(export cairo_font_options_status)

;; void cairo_font_options_merge(cairo_font_options_t *options, const 
;;     cairo_font_options_t *other);
(if echo-decls (display "cairo_font_options_merge\n"))
(define cairo_font_options_merge
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_font_options_merge"
                (dynamic-link))
              (list '* '*))))
    (lambda (options other)
      (let ((~options (unwrap-cairo_font_options_t* options))
            (~other (unwrap-cairo_font_options_t* other)))
        (~f ~options ~other)))))
(export cairo_font_options_merge)

;; cairo_bool_t cairo_font_options_equal(const cairo_font_options_t *options, 
;;     const cairo_font_options_t *other);
(if echo-decls (display "cairo_font_options_equal\n"))
(define cairo_font_options_equal
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_options_equal"
                (dynamic-link))
              (list '* '*))))
    (lambda (options other)
      (let ((~options (unwrap-cairo_font_options_t* options))
            (~other (unwrap-cairo_font_options_t* other)))
        (wrap-cairo_bool_t (~f ~options ~other))))))
(export cairo_font_options_equal)

;; unsigned long cairo_font_options_hash(const cairo_font_options_t *options);
(if echo-decls (display "cairo_font_options_hash\n"))
(define cairo_font_options_hash
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-long
              (dynamic-func
                "cairo_font_options_hash"
                (dynamic-link))
              (list '*))))
    (lambda (options)
      (let ((~options (unwrap-cairo_font_options_t* options)))
        (~f ~options)))))
(export cairo_font_options_hash)

;; void cairo_font_options_set_antialias(cairo_font_options_t *options, 
;;     cairo_antialias_t antialias);
(if echo-decls (display "cairo_font_options_set_antialias\n"))
(define cairo_font_options_set_antialias
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_font_options_set_antialias"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (options antialias)
      (let ((~options (unwrap-cairo_font_options_t* options))
            (~antialias (unwrap~fixed antialias)))
        (~f ~options ~antialias)))))
(export cairo_font_options_set_antialias)

;; cairo_antialias_t cairo_font_options_get_antialias(const 
;;     cairo_font_options_t *options);
(if echo-decls (display "cairo_font_options_get_antialias\n"))
(define cairo_font_options_get_antialias
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_options_get_antialias"
                (dynamic-link))
              (list '*))))
    (lambda (options)
      (let ((~options (unwrap-cairo_font_options_t* options)))
        (~f ~options)))))
(export cairo_font_options_get_antialias)

;; void cairo_font_options_set_subpixel_order(cairo_font_options_t *options, 
;;     cairo_subpixel_order_t subpixel_order);
(if echo-decls (display "cairo_font_options_set_subpixel_order\n"))
(define cairo_font_options_set_subpixel_order
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_font_options_set_subpixel_order"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (options subpixel_order)
      (let ((~options (unwrap-cairo_font_options_t* options))
            (~subpixel_order (unwrap~fixed subpixel_order)))
        (~f ~options ~subpixel_order)))))
(export cairo_font_options_set_subpixel_order)

;; cairo_subpixel_order_t cairo_font_options_get_subpixel_order(const 
;;     cairo_font_options_t *options);
(if echo-decls (display "cairo_font_options_get_subpixel_order\n"))
(define cairo_font_options_get_subpixel_order
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_options_get_subpixel_order"
                (dynamic-link))
              (list '*))))
    (lambda (options)
      (let ((~options (unwrap-cairo_font_options_t* options)))
        (~f ~options)))))
(export cairo_font_options_get_subpixel_order)

;; void cairo_font_options_set_hint_style(cairo_font_options_t *options, 
;;     cairo_hint_style_t hint_style);
(if echo-decls (display "cairo_font_options_set_hint_style\n"))
(define cairo_font_options_set_hint_style
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_font_options_set_hint_style"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (options hint_style)
      (let ((~options (unwrap-cairo_font_options_t* options))
            (~hint_style (unwrap~fixed hint_style)))
        (~f ~options ~hint_style)))))
(export cairo_font_options_set_hint_style)

;; cairo_hint_style_t cairo_font_options_get_hint_style(const 
;;     cairo_font_options_t *options);
(if echo-decls (display "cairo_font_options_get_hint_style\n"))
(define cairo_font_options_get_hint_style
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_options_get_hint_style"
                (dynamic-link))
              (list '*))))
    (lambda (options)
      (let ((~options (unwrap-cairo_font_options_t* options)))
        (~f ~options)))))
(export cairo_font_options_get_hint_style)

;; void cairo_font_options_set_hint_metrics(cairo_font_options_t *options, 
;;     cairo_hint_metrics_t hint_metrics);
(if echo-decls (display "cairo_font_options_set_hint_metrics\n"))
(define cairo_font_options_set_hint_metrics
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_font_options_set_hint_metrics"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (options hint_metrics)
      (let ((~options (unwrap-cairo_font_options_t* options))
            (~hint_metrics (unwrap~fixed hint_metrics)))
        (~f ~options ~hint_metrics)))))
(export cairo_font_options_set_hint_metrics)

;; cairo_hint_metrics_t cairo_font_options_get_hint_metrics(const 
;;     cairo_font_options_t *options);
(if echo-decls (display "cairo_font_options_get_hint_metrics\n"))
(define cairo_font_options_get_hint_metrics
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_options_get_hint_metrics"
                (dynamic-link))
              (list '*))))
    (lambda (options)
      (let ((~options (unwrap-cairo_font_options_t* options)))
        (~f ~options)))))
(export cairo_font_options_get_hint_metrics)

;; void cairo_select_font_face(cairo_t *cr, const char *family, 
;;     cairo_font_slant_t slant, cairo_font_weight_t weight);
(if echo-decls (display "cairo_select_font_face\n"))
(define cairo_select_font_face
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_select_font_face"
                (dynamic-link))
              (list '* '* ffi:int ffi:int))))
    (lambda (cr family slant weight)
      (let ((~cr (unwrap-cairo_t* cr))
            (~family (unwrap~pointer family))
            (~slant (unwrap~fixed slant))
            (~weight (unwrap~fixed weight)))
        (~f ~cr ~family ~slant ~weight)))))
(export cairo_select_font_face)

;; void cairo_set_font_size(cairo_t *cr, double size);
(if echo-decls (display "cairo_set_font_size\n"))
(define cairo_set_font_size
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_font_size"
                (dynamic-link))
              (list '* ffi:double))))
    (lambda (cr size)
      (let ((~cr (unwrap-cairo_t* cr))
            (~size (unwrap~float size)))
        (~f ~cr ~size)))))
(export cairo_set_font_size)

;; void cairo_set_font_matrix(cairo_t *cr, const cairo_matrix_t *matrix);
(if echo-decls (display "cairo_set_font_matrix\n"))
(define cairo_set_font_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_font_matrix"
                (dynamic-link))
              (list '* '*))))
    (lambda (cr matrix)
      (let ((~cr (unwrap-cairo_t* cr))
            (~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~cr ~matrix)))))
(export cairo_set_font_matrix)

;; void cairo_get_font_matrix(cairo_t *cr, cairo_matrix_t *matrix);
(if echo-decls (display "cairo_get_font_matrix\n"))
(define cairo_get_font_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_get_font_matrix"
                (dynamic-link))
              (list '* '*))))
    (lambda (cr matrix)
      (let ((~cr (unwrap-cairo_t* cr))
            (~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~cr ~matrix)))))
(export cairo_get_font_matrix)

;; void cairo_set_font_options(cairo_t *cr, const cairo_font_options_t *options
;;     );
(if echo-decls (display "cairo_set_font_options\n"))
(define cairo_set_font_options
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_font_options"
                (dynamic-link))
              (list '* '*))))
    (lambda (cr options)
      (let ((~cr (unwrap-cairo_t* cr))
            (~options (unwrap-cairo_font_options_t* options)))
        (~f ~cr ~options)))))
(export cairo_set_font_options)

;; void cairo_get_font_options(cairo_t *cr, cairo_font_options_t *options);
(if echo-decls (display "cairo_get_font_options\n"))
(define cairo_get_font_options
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_get_font_options"
                (dynamic-link))
              (list '* '*))))
    (lambda (cr options)
      (let ((~cr (unwrap-cairo_t* cr))
            (~options (unwrap-cairo_font_options_t* options)))
        (~f ~cr ~options)))))
(export cairo_get_font_options)

;; void cairo_set_font_face(cairo_t *cr, cairo_font_face_t *font_face);
(if echo-decls (display "cairo_set_font_face\n"))
(define cairo_set_font_face
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_font_face"
                (dynamic-link))
              (list '* '*))))
    (lambda (cr font_face)
      (let ((~cr (unwrap-cairo_t* cr))
            (~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~cr ~font_face)))))
(export cairo_set_font_face)

;; cairo_font_face_t *cairo_get_font_face(cairo_t *cr);
(if echo-decls (display "cairo_get_font_face\n"))
(define cairo_get_font_face
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_get_font_face"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_font_face_t* (~f ~cr))))))
(export cairo_get_font_face)

;; void cairo_set_scaled_font(cairo_t *cr, const cairo_scaled_font_t *
;;     scaled_font);
(if echo-decls (display "cairo_set_scaled_font\n"))
(define cairo_set_scaled_font
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_set_scaled_font"
                (dynamic-link))
              (list '* '*))))
    (lambda (cr scaled_font)
      (let ((~cr (unwrap-cairo_t* cr))
            (~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font)))
        (~f ~cr ~scaled_font)))))
(export cairo_set_scaled_font)

;; cairo_scaled_font_t *cairo_get_scaled_font(cairo_t *cr);
(if echo-decls (display "cairo_get_scaled_font\n"))
(define cairo_get_scaled_font
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_get_scaled_font"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_scaled_font_t* (~f ~cr))))))
(export cairo_get_scaled_font)

;; void cairo_show_text(cairo_t *cr, const char *utf8);
(if echo-decls (display "cairo_show_text\n"))
(define cairo_show_text
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_show_text" (dynamic-link))
              (list '* '*))))
    (lambda (cr utf8)
      (let ((~cr (unwrap-cairo_t* cr))
            (~utf8 (unwrap~pointer utf8)))
        (~f ~cr ~utf8)))))
(export cairo_show_text)

;; void cairo_show_glyphs(cairo_t *cr, const cairo_glyph_t *glyphs, int 
;;     num_glyphs);
(if echo-decls (display "cairo_show_glyphs\n"))
(define cairo_show_glyphs
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_show_glyphs" (dynamic-link))
              (list '* '* ffi:int))))
    (lambda (cr glyphs num_glyphs)
      (let ((~cr (unwrap-cairo_t* cr))
            (~glyphs (unwrap-cairo_glyph_t* glyphs))
            (~num_glyphs (unwrap~fixed num_glyphs)))
        (~f ~cr ~glyphs ~num_glyphs)))))
(export cairo_show_glyphs)

;; void cairo_show_text_glyphs(cairo_t *cr, const char *utf8, int utf8_len, 
;;     const cairo_glyph_t *glyphs, int num_glyphs, const cairo_text_cluster_t 
;;     *clusters, int num_clusters, cairo_text_cluster_flags_t cluster_flags);
(if echo-decls (display "cairo_show_text_glyphs\n"))
(define cairo_show_text_glyphs
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_show_text_glyphs"
                (dynamic-link))
              (list '*
                    '*
                    ffi:int
                    '*
                    ffi:int
                    '*
                    ffi:int
                    ffi:int))))
    (lambda (cr
             utf8
             utf8_len
             glyphs
             num_glyphs
             clusters
             num_clusters
             cluster_flags)
      (let ((~cr (unwrap-cairo_t* cr))
            (~utf8 (unwrap~pointer utf8))
            (~utf8_len (unwrap~fixed utf8_len))
            (~glyphs (unwrap-cairo_glyph_t* glyphs))
            (~num_glyphs (unwrap~fixed num_glyphs))
            (~clusters
              (unwrap-cairo_text_cluster_t* clusters))
            (~num_clusters (unwrap~fixed num_clusters))
            (~cluster_flags (unwrap~fixed cluster_flags)))
        (~f ~cr
            ~utf8
            ~utf8_len
            ~glyphs
            ~num_glyphs
            ~clusters
            ~num_clusters
            ~cluster_flags)))))
(export cairo_show_text_glyphs)

;; void cairo_text_path(cairo_t *cr, const char *utf8);
(if echo-decls (display "cairo_text_path\n"))
(define cairo_text_path
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_text_path" (dynamic-link))
              (list '* '*))))
    (lambda (cr utf8)
      (let ((~cr (unwrap-cairo_t* cr))
            (~utf8 (unwrap~pointer utf8)))
        (~f ~cr ~utf8)))))
(export cairo_text_path)

;; void cairo_glyph_path(cairo_t *cr, const cairo_glyph_t *glyphs, int 
;;     num_glyphs);
(if echo-decls (display "cairo_glyph_path\n"))
(define cairo_glyph_path
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_glyph_path" (dynamic-link))
              (list '* '* ffi:int))))
    (lambda (cr glyphs num_glyphs)
      (let ((~cr (unwrap-cairo_t* cr))
            (~glyphs (unwrap-cairo_glyph_t* glyphs))
            (~num_glyphs (unwrap~fixed num_glyphs)))
        (~f ~cr ~glyphs ~num_glyphs)))))
(export cairo_glyph_path)

;; void cairo_text_extents(cairo_t *cr, const char *utf8, cairo_text_extents_t 
;;     *extents);
(if echo-decls (display "cairo_text_extents\n"))
(define cairo_text_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_text_extents"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (cr utf8 extents)
      (let ((~cr (unwrap-cairo_t* cr))
            (~utf8 (unwrap~pointer utf8))
            (~extents (unwrap-cairo_text_extents_t* extents)))
        (~f ~cr ~utf8 ~extents)))))
(export cairo_text_extents)

;; void cairo_glyph_extents(cairo_t *cr, const cairo_glyph_t *glyphs, int 
;;     num_glyphs, cairo_text_extents_t *extents);
(if echo-decls (display "cairo_glyph_extents\n"))
(define cairo_glyph_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_glyph_extents"
                (dynamic-link))
              (list '* '* ffi:int '*))))
    (lambda (cr glyphs num_glyphs extents)
      (let ((~cr (unwrap-cairo_t* cr))
            (~glyphs (unwrap-cairo_glyph_t* glyphs))
            (~num_glyphs (unwrap~fixed num_glyphs))
            (~extents (unwrap-cairo_text_extents_t* extents)))
        (~f ~cr ~glyphs ~num_glyphs ~extents)))))
(export cairo_glyph_extents)

;; void cairo_font_extents(cairo_t *cr, cairo_font_extents_t *extents);
(if echo-decls (display "cairo_font_extents\n"))
(define cairo_font_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_font_extents"
                (dynamic-link))
              (list '* '*))))
    (lambda (cr extents)
      (let ((~cr (unwrap-cairo_t* cr))
            (~extents (unwrap-cairo_font_extents_t* extents)))
        (~f ~cr ~extents)))))
(export cairo_font_extents)

;; cairo_font_face_t *cairo_font_face_reference(cairo_font_face_t *font_face);
(if echo-decls (display "cairo_font_face_reference\n"))
(define cairo_font_face_reference
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_font_face_reference"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (wrap-cairo_font_face_t* (~f ~font_face))))))
(export cairo_font_face_reference)

;; void cairo_font_face_destroy(cairo_font_face_t *font_face);
(if echo-decls (display "cairo_font_face_destroy\n"))
(define cairo_font_face_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_font_face_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_font_face_destroy)

;; unsigned int cairo_font_face_get_reference_count(cairo_font_face_t *
;;     font_face);
(if echo-decls (display "cairo_font_face_get_reference_count\n"))
(define cairo_font_face_get_reference_count
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-int
              (dynamic-func
                "cairo_font_face_get_reference_count"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_font_face_get_reference_count)

;; cairo_status_t cairo_font_face_status(cairo_font_face_t *font_face);
(if echo-decls (display "cairo_font_face_status\n"))
(define cairo_font_face_status
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_face_status"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_font_face_status)

;; typedef enum _cairo_font_type {
;;   CAIRO_FONT_TYPE_TOY,
;;   CAIRO_FONT_TYPE_FT,
;;   CAIRO_FONT_TYPE_WIN32,
;;   CAIRO_FONT_TYPE_QUARTZ,
;;   CAIRO_FONT_TYPE_USER,
;; } cairo_font_type_t;
(if echo-decls (display "cairo_font_type_t\n"))
(define-fh-enum cairo_font_type_t
  '((CAIRO_FONT_TYPE_TOY . 0)
    (CAIRO_FONT_TYPE_FT . 1)
    (CAIRO_FONT_TYPE_WIN32 . 2)
    (CAIRO_FONT_TYPE_QUARTZ . 3)
    (CAIRO_FONT_TYPE_USER . 4))
  )
(define unwrap-enum-_cairo_font_type unwrap-cairo_font_type_t)
(define wrap-enum-_cairo_font_type wrap-cairo_font_type_t)

;; cairo_font_type_t cairo_font_face_get_type(cairo_font_face_t *font_face);
(if echo-decls (display "cairo_font_face_get_type\n"))
(define cairo_font_face_get_type
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_face_get_type"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_font_face_get_type)

;; void *cairo_font_face_get_user_data(cairo_font_face_t *font_face, const 
;;     cairo_user_data_key_t *key);
(if echo-decls (display "cairo_font_face_get_user_data\n"))
(define cairo_font_face_get_user_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_font_face_get_user_data"
                (dynamic-link))
              (list '* '*))))
    (lambda (font_face key)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face))
            (~key (unwrap-cairo_user_data_key_t* key)))
        (~f ~font_face ~key)))))
(export cairo_font_face_get_user_data)

;; cairo_status_t cairo_font_face_set_user_data(cairo_font_face_t *font_face, 
;;     const cairo_user_data_key_t *key, void *user_data, cairo_destroy_func_t 
;;     destroy);
(if echo-decls (display "cairo_font_face_set_user_data\n"))
(define cairo_font_face_set_user_data
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_font_face_set_user_data"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (font_face key user_data destroy)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face))
            (~key (unwrap-cairo_user_data_key_t* key))
            (~user_data (unwrap~pointer user_data))
            (~destroy
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               destroy)))
        (~f ~font_face ~key ~user_data ~destroy)))))
(export cairo_font_face_set_user_data)

;; cairo_scaled_font_t *cairo_scaled_font_create(cairo_font_face_t *font_face, 
;;     const cairo_matrix_t *font_matrix, const cairo_matrix_t *ctm, const 
;;     cairo_font_options_t *options);
(if echo-decls (display "cairo_scaled_font_create\n"))
(define cairo_scaled_font_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_scaled_font_create"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (font_face font_matrix ctm options)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face))
            (~font_matrix
              (unwrap-cairo_matrix_t* font_matrix))
            (~ctm (unwrap-cairo_matrix_t* ctm))
            (~options (unwrap-cairo_font_options_t* options)))
        (wrap-cairo_scaled_font_t*
          (~f ~font_face ~font_matrix ~ctm ~options))))))
(export cairo_scaled_font_create)

;; cairo_scaled_font_t *cairo_scaled_font_reference(cairo_scaled_font_t *
;;     scaled_font);
(if echo-decls (display "cairo_scaled_font_reference\n"))
(define cairo_scaled_font_reference
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_scaled_font_reference"
                (dynamic-link))
              (list '*))))
    (lambda (scaled_font)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font)))
        (wrap-cairo_scaled_font_t* (~f ~scaled_font))))))
(export cairo_scaled_font_reference)

;; void cairo_scaled_font_destroy(cairo_scaled_font_t *scaled_font);
(if echo-decls (display "cairo_scaled_font_destroy\n"))
(define cairo_scaled_font_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_scaled_font_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (scaled_font)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font)))
        (~f ~scaled_font)))))
(export cairo_scaled_font_destroy)

;; unsigned int cairo_scaled_font_get_reference_count(cairo_scaled_font_t *
;;     scaled_font);
(if echo-decls (display "cairo_scaled_font_get_reference_count\n"))
(define cairo_scaled_font_get_reference_count
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-int
              (dynamic-func
                "cairo_scaled_font_get_reference_count"
                (dynamic-link))
              (list '*))))
    (lambda (scaled_font)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font)))
        (~f ~scaled_font)))))
(export cairo_scaled_font_get_reference_count)

;; cairo_status_t cairo_scaled_font_status(cairo_scaled_font_t *scaled_font);
(if echo-decls (display "cairo_scaled_font_status\n"))
(define cairo_scaled_font_status
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_scaled_font_status"
                (dynamic-link))
              (list '*))))
    (lambda (scaled_font)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font)))
        (~f ~scaled_font)))))
(export cairo_scaled_font_status)

;; cairo_font_type_t cairo_scaled_font_get_type(cairo_scaled_font_t *
;;     scaled_font);
(if echo-decls (display "cairo_scaled_font_get_type\n"))
(define cairo_scaled_font_get_type
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_scaled_font_get_type"
                (dynamic-link))
              (list '*))))
    (lambda (scaled_font)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font)))
        (~f ~scaled_font)))))
(export cairo_scaled_font_get_type)

;; void *cairo_scaled_font_get_user_data(cairo_scaled_font_t *scaled_font, 
;;     const cairo_user_data_key_t *key);
(if echo-decls (display "cairo_scaled_font_get_user_data\n"))
(define cairo_scaled_font_get_user_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_scaled_font_get_user_data"
                (dynamic-link))
              (list '* '*))))
    (lambda (scaled_font key)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~key (unwrap-cairo_user_data_key_t* key)))
        (~f ~scaled_font ~key)))))
(export cairo_scaled_font_get_user_data)

;; cairo_status_t cairo_scaled_font_set_user_data(cairo_scaled_font_t *
;;     scaled_font, const cairo_user_data_key_t *key, void *user_data, 
;;     cairo_destroy_func_t destroy);
(if echo-decls (display "cairo_scaled_font_set_user_data\n"))
(define cairo_scaled_font_set_user_data
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_scaled_font_set_user_data"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (scaled_font key user_data destroy)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~key (unwrap-cairo_user_data_key_t* key))
            (~user_data (unwrap~pointer user_data))
            (~destroy
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               destroy)))
        (~f ~scaled_font ~key ~user_data ~destroy)))))
(export cairo_scaled_font_set_user_data)

;; void cairo_scaled_font_extents(cairo_scaled_font_t *scaled_font, 
;;     cairo_font_extents_t *extents);
(if echo-decls (display "cairo_scaled_font_extents\n"))
(define cairo_scaled_font_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_scaled_font_extents"
                (dynamic-link))
              (list '* '*))))
    (lambda (scaled_font extents)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~extents (unwrap-cairo_font_extents_t* extents)))
        (~f ~scaled_font ~extents)))))
(export cairo_scaled_font_extents)

;; void cairo_scaled_font_text_extents(cairo_scaled_font_t *scaled_font, const 
;;     char *utf8, cairo_text_extents_t *extents);
(if echo-decls (display "cairo_scaled_font_text_extents\n"))
(define cairo_scaled_font_text_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_scaled_font_text_extents"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (scaled_font utf8 extents)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~utf8 (unwrap~pointer utf8))
            (~extents (unwrap-cairo_text_extents_t* extents)))
        (~f ~scaled_font ~utf8 ~extents)))))
(export cairo_scaled_font_text_extents)

;; void cairo_scaled_font_glyph_extents(cairo_scaled_font_t *scaled_font, const
;;      cairo_glyph_t *glyphs, int num_glyphs, cairo_text_extents_t *extents);
(if echo-decls (display "cairo_scaled_font_glyph_extents\n"))
(define cairo_scaled_font_glyph_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_scaled_font_glyph_extents"
                (dynamic-link))
              (list '* '* ffi:int '*))))
    (lambda (scaled_font glyphs num_glyphs extents)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~glyphs (unwrap-cairo_glyph_t* glyphs))
            (~num_glyphs (unwrap~fixed num_glyphs))
            (~extents (unwrap-cairo_text_extents_t* extents)))
        (~f ~scaled_font ~glyphs ~num_glyphs ~extents)))))
(export cairo_scaled_font_glyph_extents)

;; cairo_status_t cairo_scaled_font_text_to_glyphs(cairo_scaled_font_t *
;;     scaled_font, double x, double y, const char *utf8, int utf8_len, 
;;     cairo_glyph_t **glyphs, int *num_glyphs, cairo_text_cluster_t **clusters
;;     , int *num_clusters, cairo_text_cluster_flags_t *cluster_flags);
(if echo-decls (display "cairo_scaled_font_text_to_glyphs\n"))
(define cairo_scaled_font_text_to_glyphs
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_scaled_font_text_to_glyphs"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    '*
                    ffi:int
                    '*
                    '*
                    '*
                    '*
                    '*))))
    (lambda (scaled_font
             x
             y
             utf8
             utf8_len
             glyphs
             num_glyphs
             clusters
             num_clusters
             cluster_flags)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~x (unwrap~float x))
            (~y (unwrap~float y))
            (~utf8 (unwrap~pointer utf8))
            (~utf8_len (unwrap~fixed utf8_len))
            (~glyphs (unwrap~pointer glyphs))
            (~num_glyphs (unwrap~pointer num_glyphs))
            (~clusters (unwrap~pointer clusters))
            (~num_clusters (unwrap~pointer num_clusters))
            (~cluster_flags (unwrap~pointer cluster_flags)))
        (~f ~scaled_font
            ~x
            ~y
            ~utf8
            ~utf8_len
            ~glyphs
            ~num_glyphs
            ~clusters
            ~num_clusters
            ~cluster_flags)))))
(export cairo_scaled_font_text_to_glyphs)

;; cairo_font_face_t *cairo_scaled_font_get_font_face(cairo_scaled_font_t *
;;     scaled_font);
(if echo-decls (display "cairo_scaled_font_get_font_face\n"))
(define cairo_scaled_font_get_font_face
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_scaled_font_get_font_face"
                (dynamic-link))
              (list '*))))
    (lambda (scaled_font)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font)))
        (wrap-cairo_font_face_t* (~f ~scaled_font))))))
(export cairo_scaled_font_get_font_face)

;; void cairo_scaled_font_get_font_matrix(cairo_scaled_font_t *scaled_font, 
;;     cairo_matrix_t *font_matrix);
(if echo-decls (display "cairo_scaled_font_get_font_matrix\n"))
(define cairo_scaled_font_get_font_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_scaled_font_get_font_matrix"
                (dynamic-link))
              (list '* '*))))
    (lambda (scaled_font font_matrix)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~font_matrix
              (unwrap-cairo_matrix_t* font_matrix)))
        (~f ~scaled_font ~font_matrix)))))
(export cairo_scaled_font_get_font_matrix)

;; void cairo_scaled_font_get_ctm(cairo_scaled_font_t *scaled_font, 
;;     cairo_matrix_t *ctm);
(if echo-decls (display "cairo_scaled_font_get_ctm\n"))
(define cairo_scaled_font_get_ctm
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_scaled_font_get_ctm"
                (dynamic-link))
              (list '* '*))))
    (lambda (scaled_font ctm)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~ctm (unwrap-cairo_matrix_t* ctm)))
        (~f ~scaled_font ~ctm)))))
(export cairo_scaled_font_get_ctm)

;; void cairo_scaled_font_get_scale_matrix(cairo_scaled_font_t *scaled_font, 
;;     cairo_matrix_t *scale_matrix);
(if echo-decls (display "cairo_scaled_font_get_scale_matrix\n"))
(define cairo_scaled_font_get_scale_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_scaled_font_get_scale_matrix"
                (dynamic-link))
              (list '* '*))))
    (lambda (scaled_font scale_matrix)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~scale_matrix
              (unwrap-cairo_matrix_t* scale_matrix)))
        (~f ~scaled_font ~scale_matrix)))))
(export cairo_scaled_font_get_scale_matrix)

;; void cairo_scaled_font_get_font_options(cairo_scaled_font_t *scaled_font, 
;;     cairo_font_options_t *options);
(if echo-decls (display "cairo_scaled_font_get_font_options\n"))
(define cairo_scaled_font_get_font_options
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_scaled_font_get_font_options"
                (dynamic-link))
              (list '* '*))))
    (lambda (scaled_font options)
      (let ((~scaled_font
              (unwrap-cairo_scaled_font_t* scaled_font))
            (~options (unwrap-cairo_font_options_t* options)))
        (~f ~scaled_font ~options)))))
(export cairo_scaled_font_get_font_options)

;; cairo_font_face_t *cairo_toy_font_face_create(const char *family, 
;;     cairo_font_slant_t slant, cairo_font_weight_t weight);
(if echo-decls (display "cairo_toy_font_face_create\n"))
(define cairo_toy_font_face_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_toy_font_face_create"
                (dynamic-link))
              (list '* ffi:int ffi:int))))
    (lambda (family slant weight)
      (let ((~family (unwrap~pointer family))
            (~slant (unwrap~fixed slant))
            (~weight (unwrap~fixed weight)))
        (wrap-cairo_font_face_t*
          (~f ~family ~slant ~weight))))))
(export cairo_toy_font_face_create)

;; const char *cairo_toy_font_face_get_family(cairo_font_face_t *font_face);
(if echo-decls (display "cairo_toy_font_face_get_family\n"))
(define cairo_toy_font_face_get_family
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_toy_font_face_get_family"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_toy_font_face_get_family)

;; cairo_font_slant_t cairo_toy_font_face_get_slant(cairo_font_face_t *
;;     font_face);
(if echo-decls (display "cairo_toy_font_face_get_slant\n"))
(define cairo_toy_font_face_get_slant
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_toy_font_face_get_slant"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_toy_font_face_get_slant)

;; cairo_font_weight_t cairo_toy_font_face_get_weight(cairo_font_face_t *
;;     font_face);
(if echo-decls (display "cairo_toy_font_face_get_weight\n"))
(define cairo_toy_font_face_get_weight
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_toy_font_face_get_weight"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_toy_font_face_get_weight)

;; cairo_font_face_t *cairo_user_font_face_create(void);
(if echo-decls (display "cairo_user_font_face_create\n"))
(define cairo_user_font_face_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_user_font_face_create"
                (dynamic-link))
              (list))))
    (lambda ()
      (let () (wrap-cairo_font_face_t* (~f))))))
(export cairo_user_font_face_create)

;; typedef cairo_status_t (*cairo_user_scaled_font_init_func_t)(
;;     cairo_scaled_font_t *scaled_font, cairo_t *cr, cairo_font_extents_t *
;;     extents);
(if echo-decls (display "cairo_user_scaled_font_init_func_t\n"))
(define-fh-function/p cairo_user_scaled_font_init_func_t
  ffi:int (list (quote *) (quote *) (quote *)))

;; typedef cairo_status_t (*cairo_user_scaled_font_render_glyph_func_t)(
;;     cairo_scaled_font_t *scaled_font, unsigned long glyph, cairo_t *cr, 
;;     cairo_text_extents_t *extents);
(if echo-decls (display "cairo_user_scaled_font_render_glyph_func_t\n"))
(define-fh-function/p cairo_user_scaled_font_render_glyph_func_t
  ffi:int (list (quote *) ffi:unsigned-long (quote *) (quote *)))

;; typedef cairo_status_t (*cairo_user_scaled_font_text_to_glyphs_func_t)(
;;     cairo_scaled_font_t *scaled_font, const char *utf8, int utf8_len, 
;;     cairo_glyph_t **glyphs, int *num_glyphs, cairo_text_cluster_t **clusters
;;     , int *num_clusters, cairo_text_cluster_flags_t *cluster_flags);
(if echo-decls (display "cairo_user_scaled_font_text_to_glyphs_func_t\n"))
(define-fh-function/p cairo_user_scaled_font_text_to_glyphs_func_t
  ffi:int (list (quote *) (quote *) ffi:int (quote *) (quote *) (quote *) (quote *) (quote *)))

;; typedef cairo_status_t (*cairo_user_scaled_font_unicode_to_glyph_func_t)(
;;     cairo_scaled_font_t *scaled_font, unsigned long unicode, unsigned long *
;;     glyph_index);
(if echo-decls (display "cairo_user_scaled_font_unicode_to_glyph_func_t\n"))
(define-fh-function/p cairo_user_scaled_font_unicode_to_glyph_func_t
  ffi:int (list (quote *) ffi:unsigned-long (quote *)))

;; void cairo_user_font_face_set_init_func(cairo_font_face_t *font_face, 
;;     cairo_user_scaled_font_init_func_t init_func);
(if echo-decls (display "cairo_user_font_face_set_init_func\n"))
(define cairo_user_font_face_set_init_func
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_user_font_face_set_init_func"
                (dynamic-link))
              (list '* '*))))
    (lambda (font_face init_func)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face))
            (~init_func
              ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
               init_func)))
        (~f ~font_face ~init_func)))))
(export cairo_user_font_face_set_init_func)

;; void cairo_user_font_face_set_render_glyph_func(cairo_font_face_t *font_face
;;     , cairo_user_scaled_font_render_glyph_func_t render_glyph_func);
(if echo-decls (display "cairo_user_font_face_set_render_glyph_func\n"))
(define cairo_user_font_face_set_render_glyph_func
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_user_font_face_set_render_glyph_func"
                (dynamic-link))
              (list '* '*))))
    (lambda (font_face render_glyph_func)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face))
            (~render_glyph_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* ffi:unsigned-long '* '*))
               render_glyph_func)))
        (~f ~font_face ~render_glyph_func)))))
(export cairo_user_font_face_set_render_glyph_func)

;; void cairo_user_font_face_set_text_to_glyphs_func(cairo_font_face_t *
;;     font_face, cairo_user_scaled_font_text_to_glyphs_func_t 
;;     text_to_glyphs_func);
(if echo-decls (display "cairo_user_font_face_set_text_to_glyphs_func\n"))
(define cairo_user_font_face_set_text_to_glyphs_func
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_user_font_face_set_text_to_glyphs_func"
                (dynamic-link))
              (list '* '*))))
    (lambda (font_face text_to_glyphs_func)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face))
            (~text_to_glyphs_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* '* ffi:int '* '* '* '* '*))
               text_to_glyphs_func)))
        (~f ~font_face ~text_to_glyphs_func)))))
(export cairo_user_font_face_set_text_to_glyphs_func)

;; void cairo_user_font_face_set_unicode_to_glyph_func(cairo_font_face_t *
;;     font_face, cairo_user_scaled_font_unicode_to_glyph_func_t 
;;     unicode_to_glyph_func);
(if echo-decls (display "cairo_user_font_face_set_unicode_to_glyph_func\n"))
(define cairo_user_font_face_set_unicode_to_glyph_func
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_user_font_face_set_unicode_to_glyph_func"
                (dynamic-link))
              (list '* '*))))
    (lambda (font_face unicode_to_glyph_func)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face))
            (~unicode_to_glyph_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* ffi:unsigned-long '*))
               unicode_to_glyph_func)))
        (~f ~font_face ~unicode_to_glyph_func)))))
(export cairo_user_font_face_set_unicode_to_glyph_func)

;; cairo_user_scaled_font_init_func_t cairo_user_font_face_get_init_func(
;;     cairo_font_face_t *font_face);
(if echo-decls (display "cairo_user_font_face_get_init_func\n"))
(define cairo_user_font_face_get_init_func
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_user_font_face_get_init_func"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_user_font_face_get_init_func)

;; cairo_user_scaled_font_render_glyph_func_t 
;;     cairo_user_font_face_get_render_glyph_func(cairo_font_face_t *font_face)
;;     ;
(if echo-decls (display "cairo_user_font_face_get_render_glyph_func\n"))
(define cairo_user_font_face_get_render_glyph_func
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_user_font_face_get_render_glyph_func"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_user_font_face_get_render_glyph_func)

;; cairo_user_scaled_font_text_to_glyphs_func_t 
;;     cairo_user_font_face_get_text_to_glyphs_func(cairo_font_face_t *
;;     font_face);
(if echo-decls (display "cairo_user_font_face_get_text_to_glyphs_func\n"))
(define cairo_user_font_face_get_text_to_glyphs_func
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_user_font_face_get_text_to_glyphs_func"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_user_font_face_get_text_to_glyphs_func)

;; cairo_user_scaled_font_unicode_to_glyph_func_t 
;;     cairo_user_font_face_get_unicode_to_glyph_func(cairo_font_face_t *
;;     font_face);
(if echo-decls (display "cairo_user_font_face_get_unicode_to_glyph_func\n"))
(define cairo_user_font_face_get_unicode_to_glyph_func
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_user_font_face_get_unicode_to_glyph_func"
                (dynamic-link))
              (list '*))))
    (lambda (font_face)
      (let ((~font_face
              (unwrap-cairo_font_face_t* font_face)))
        (~f ~font_face)))))
(export cairo_user_font_face_get_unicode_to_glyph_func)

;; cairo_operator_t cairo_get_operator(cairo_t *cr);
(if echo-decls (display "cairo_get_operator\n"))
(define cairo_get_operator
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_get_operator"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_operator)

;; cairo_pattern_t *cairo_get_source(cairo_t *cr);
(if echo-decls (display "cairo_get_source\n"))
(define cairo_get_source
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "cairo_get_source" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_pattern_t* (~f ~cr))))))
(export cairo_get_source)

;; double cairo_get_tolerance(cairo_t *cr);
(if echo-decls (display "cairo_get_tolerance\n"))
(define cairo_get_tolerance
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_get_tolerance"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_tolerance)

;; cairo_antialias_t cairo_get_antialias(cairo_t *cr);
(if echo-decls (display "cairo_get_antialias\n"))
(define cairo_get_antialias
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_get_antialias"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_antialias)

;; cairo_bool_t cairo_has_current_point(cairo_t *cr);
(if echo-decls (display "cairo_has_current_point\n"))
(define cairo_has_current_point
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_has_current_point"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_bool_t (~f ~cr))))))
(export cairo_has_current_point)

;; void cairo_get_current_point(cairo_t *cr, double *x, double *y);
(if echo-decls (display "cairo_get_current_point\n"))
(define cairo_get_current_point
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_get_current_point"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (cr x y)
      (let ((~cr (unwrap-cairo_t* cr))
            (~x (unwrap~pointer x))
            (~y (unwrap~pointer y)))
        (~f ~cr ~x ~y)))))
(export cairo_get_current_point)

;; cairo_fill_rule_t cairo_get_fill_rule(cairo_t *cr);
(if echo-decls (display "cairo_get_fill_rule\n"))
(define cairo_get_fill_rule
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_get_fill_rule"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_fill_rule)

;; double cairo_get_line_width(cairo_t *cr);
(if echo-decls (display "cairo_get_line_width\n"))
(define cairo_get_line_width
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_get_line_width"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_line_width)

;; cairo_line_cap_t cairo_get_line_cap(cairo_t *cr);
(if echo-decls (display "cairo_get_line_cap\n"))
(define cairo_get_line_cap
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_get_line_cap"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_line_cap)

;; cairo_line_join_t cairo_get_line_join(cairo_t *cr);
(if echo-decls (display "cairo_get_line_join\n"))
(define cairo_get_line_join
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_get_line_join"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_line_join)

;; double cairo_get_miter_limit(cairo_t *cr);
(if echo-decls (display "cairo_get_miter_limit\n"))
(define cairo_get_miter_limit
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_get_miter_limit"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_miter_limit)

;; int cairo_get_dash_count(cairo_t *cr);
(if echo-decls (display "cairo_get_dash_count\n"))
(define cairo_get_dash_count
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_get_dash_count"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_get_dash_count)

;; void cairo_get_dash(cairo_t *cr, double *dashes, double *offset);
(if echo-decls (display "cairo_get_dash\n"))
(define cairo_get_dash
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_get_dash" (dynamic-link))
              (list '* '* '*))))
    (lambda (cr dashes offset)
      (let ((~cr (unwrap-cairo_t* cr))
            (~dashes (unwrap~pointer dashes))
            (~offset (unwrap~pointer offset)))
        (~f ~cr ~dashes ~offset)))))
(export cairo_get_dash)

;; void cairo_get_matrix(cairo_t *cr, cairo_matrix_t *matrix);
(if echo-decls (display "cairo_get_matrix\n"))
(define cairo_get_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_get_matrix" (dynamic-link))
              (list '* '*))))
    (lambda (cr matrix)
      (let ((~cr (unwrap-cairo_t* cr))
            (~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~cr ~matrix)))))
(export cairo_get_matrix)

;; cairo_surface_t *cairo_get_target(cairo_t *cr);
(if echo-decls (display "cairo_get_target\n"))
(define cairo_get_target
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "cairo_get_target" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_surface_t* (~f ~cr))))))
(export cairo_get_target)

;; cairo_surface_t *cairo_get_group_target(cairo_t *cr);
(if echo-decls (display "cairo_get_group_target\n"))
(define cairo_get_group_target
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_get_group_target"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_surface_t* (~f ~cr))))))
(export cairo_get_group_target)

;; typedef enum _cairo_path_data_type {
;;   CAIRO_PATH_MOVE_TO,
;;   CAIRO_PATH_LINE_TO,
;;   CAIRO_PATH_CURVE_TO,
;;   CAIRO_PATH_CLOSE_PATH,
;; } cairo_path_data_type_t;
(if echo-decls (display "cairo_path_data_type_t\n"))
(define-fh-enum cairo_path_data_type_t
  '((CAIRO_PATH_MOVE_TO . 0)
    (CAIRO_PATH_LINE_TO . 1)
    (CAIRO_PATH_CURVE_TO . 2)
    (CAIRO_PATH_CLOSE_PATH . 3))
  )
(define unwrap-enum-_cairo_path_data_type unwrap-cairo_path_data_type_t)
(define wrap-enum-_cairo_path_data_type wrap-cairo_path_data_type_t)

;; typedef union _cairo_path_data_t cairo_path_data_t;
(if echo-decls (display "cairo_path_data_t\n"))
;; union _cairo_path_data_t {
;;   struct {
;;     cairo_path_data_type_t type;
;;     int length;
;;   } header;
;;   struct {
;;     double x, y;
;;   } point;
;; };
(define cairo_path_data_t-desc
  (bs:union
    (list `(header
             ,(bs:struct (list `(type ,int) `(length ,int))))
          `(point ,(bs:struct (list `(y ,double) `(x ,double)))))))
(export cairo_path_data_t-desc)
(define-fh-compound-type/p cairo_path_data_t cairo_path_data_t-desc)
(define union-_cairo_path_data_t cairo_path_data_t)

;; typedef struct cairo_path {
;;   cairo_status_t status;
;;   cairo_path_data_t *data;
;;   int num_data;
;; } cairo_path_t;
(if echo-decls (display "cairo_path_t\n"))
(define cairo_path_t-desc
  (bs:struct
    (list `(status ,int)
          `(data ,(bs:pointer cairo_path_data_t*-desc))
          `(num_data ,int))))
(export cairo_path_t-desc)
(define-fh-compound-type/p cairo_path_t cairo_path_t-desc)
(define struct-cairo_path cairo_path_t)

;; cairo_path_t *cairo_copy_path(cairo_t *cr);
(if echo-decls (display "cairo_copy_path\n"))
(define cairo_copy_path
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "cairo_copy_path" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_path_t* (~f ~cr))))))
(export cairo_copy_path)

;; cairo_path_t *cairo_copy_path_flat(cairo_t *cr);
(if echo-decls (display "cairo_copy_path_flat\n"))
(define cairo_copy_path_flat
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_copy_path_flat"
                (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr)))
        (wrap-cairo_path_t* (~f ~cr))))))
(export cairo_copy_path_flat)

;; void cairo_append_path(cairo_t *cr, const cairo_path_t *path);
(if echo-decls (display "cairo_append_path\n"))
(define cairo_append_path
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_append_path" (dynamic-link))
              (list '* '*))))
    (lambda (cr path)
      (let ((~cr (unwrap-cairo_t* cr))
            (~path (unwrap-cairo_path_t* path)))
        (~f ~cr ~path)))))
(export cairo_append_path)

;; void cairo_path_destroy(cairo_path_t *path);
(if echo-decls (display "cairo_path_destroy\n"))
(define cairo_path_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_path_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (path)
      (let ((~path (unwrap-cairo_path_t* path)))
        (~f ~path)))))
(export cairo_path_destroy)

;; cairo_status_t cairo_status(cairo_t *cr);
(if echo-decls (display "cairo_status\n"))
(define cairo_status
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "cairo_status" (dynamic-link))
              (list '*))))
    (lambda (cr)
      (let ((~cr (unwrap-cairo_t* cr))) (~f ~cr)))))
(export cairo_status)

;; const char *cairo_status_to_string(cairo_status_t status);
(if echo-decls (display "cairo_status_to_string\n"))
(define cairo_status_to_string
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_status_to_string"
                (dynamic-link))
              (list ffi:int))))
    (lambda (status)
      (let ((~status (unwrap~fixed status)))
        (~f ~status)))))
(export cairo_status_to_string)

;; cairo_device_t *cairo_device_reference(cairo_device_t *device);
(if echo-decls (display "cairo_device_reference\n"))
(define cairo_device_reference
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_device_reference"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (wrap-cairo_device_t* (~f ~device))))))
(export cairo_device_reference)

;; typedef enum _cairo_device_type {
;;   CAIRO_DEVICE_TYPE_DRM,
;;   CAIRO_DEVICE_TYPE_GL,
;;   CAIRO_DEVICE_TYPE_SCRIPT,
;;   CAIRO_DEVICE_TYPE_XCB,
;;   CAIRO_DEVICE_TYPE_XLIB,
;;   CAIRO_DEVICE_TYPE_XML,
;;   CAIRO_DEVICE_TYPE_COGL,
;;   CAIRO_DEVICE_TYPE_WIN32,
;;   CAIRO_DEVICE_TYPE_INVALID = -1,
;; } cairo_device_type_t;
(if echo-decls (display "cairo_device_type_t\n"))
(define-fh-enum cairo_device_type_t
  '((CAIRO_DEVICE_TYPE_DRM . 0)
    (CAIRO_DEVICE_TYPE_GL . 1)
    (CAIRO_DEVICE_TYPE_SCRIPT . 2)
    (CAIRO_DEVICE_TYPE_XCB . 3)
    (CAIRO_DEVICE_TYPE_XLIB . 4)
    (CAIRO_DEVICE_TYPE_XML . 5)
    (CAIRO_DEVICE_TYPE_COGL . 6)
    (CAIRO_DEVICE_TYPE_WIN32 . 7)
    (CAIRO_DEVICE_TYPE_INVALID . -1))
  )
(define unwrap-enum-_cairo_device_type unwrap-cairo_device_type_t)
(define wrap-enum-_cairo_device_type wrap-cairo_device_type_t)

;; cairo_device_type_t cairo_device_get_type(cairo_device_t *device);
(if echo-decls (display "cairo_device_get_type\n"))
(define cairo_device_get_type
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_device_get_type"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_get_type)

;; cairo_status_t cairo_device_status(cairo_device_t *device);
(if echo-decls (display "cairo_device_status\n"))
(define cairo_device_status
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_device_status"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_status)

;; cairo_status_t cairo_device_acquire(cairo_device_t *device);
(if echo-decls (display "cairo_device_acquire\n"))
(define cairo_device_acquire
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_device_acquire"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_acquire)

;; void cairo_device_release(cairo_device_t *device);
(if echo-decls (display "cairo_device_release\n"))
(define cairo_device_release
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_device_release"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_release)

;; void cairo_device_flush(cairo_device_t *device);
(if echo-decls (display "cairo_device_flush\n"))
(define cairo_device_flush
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_device_flush"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_flush)

;; void cairo_device_finish(cairo_device_t *device);
(if echo-decls (display "cairo_device_finish\n"))
(define cairo_device_finish
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_device_finish"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_finish)

;; void cairo_device_destroy(cairo_device_t *device);
(if echo-decls (display "cairo_device_destroy\n"))
(define cairo_device_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_device_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_destroy)

;; unsigned int cairo_device_get_reference_count(cairo_device_t *device);
(if echo-decls (display "cairo_device_get_reference_count\n"))
(define cairo_device_get_reference_count
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-int
              (dynamic-func
                "cairo_device_get_reference_count"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_get_reference_count)

;; void *cairo_device_get_user_data(cairo_device_t *device, const 
;;     cairo_user_data_key_t *key);
(if echo-decls (display "cairo_device_get_user_data\n"))
(define cairo_device_get_user_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_device_get_user_data"
                (dynamic-link))
              (list '* '*))))
    (lambda (device key)
      (let ((~device (unwrap-cairo_device_t* device))
            (~key (unwrap-cairo_user_data_key_t* key)))
        (~f ~device ~key)))))
(export cairo_device_get_user_data)

;; cairo_status_t cairo_device_set_user_data(cairo_device_t *device, const 
;;     cairo_user_data_key_t *key, void *user_data, cairo_destroy_func_t 
;;     destroy);
(if echo-decls (display "cairo_device_set_user_data\n"))
(define cairo_device_set_user_data
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_device_set_user_data"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (device key user_data destroy)
      (let ((~device (unwrap-cairo_device_t* device))
            (~key (unwrap-cairo_user_data_key_t* key))
            (~user_data (unwrap~pointer user_data))
            (~destroy
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               destroy)))
        (~f ~device ~key ~user_data ~destroy)))))
(export cairo_device_set_user_data)

;; cairo_surface_t *cairo_surface_create_similar(cairo_surface_t *other, 
;;     cairo_content_t content, int width, int height);
(if echo-decls (display "cairo_surface_create_similar\n"))
(define cairo_surface_create_similar
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_surface_create_similar"
                (dynamic-link))
              (list '* ffi:int ffi:int ffi:int))))
    (lambda (other content width height)
      (let ((~other (unwrap-cairo_surface_t* other))
            (~content (unwrap~fixed content))
            (~width (unwrap~fixed width))
            (~height (unwrap~fixed height)))
        (wrap-cairo_surface_t*
          (~f ~other ~content ~width ~height))))))
(export cairo_surface_create_similar)

;; cairo_surface_t *cairo_surface_create_similar_image(cairo_surface_t *other, 
;;     cairo_format_t format, int width, int height);
(if echo-decls (display "cairo_surface_create_similar_image\n"))
(define cairo_surface_create_similar_image
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_surface_create_similar_image"
                (dynamic-link))
              (list '* ffi:int ffi:int ffi:int))))
    (lambda (other format width height)
      (let ((~other (unwrap-cairo_surface_t* other))
            (~format (unwrap~fixed format))
            (~width (unwrap~fixed width))
            (~height (unwrap~fixed height)))
        (wrap-cairo_surface_t*
          (~f ~other ~format ~width ~height))))))
(export cairo_surface_create_similar_image)

;; cairo_surface_t *cairo_surface_map_to_image(cairo_surface_t *surface, const 
;;     cairo_rectangle_int_t *extents);
(if echo-decls (display "cairo_surface_map_to_image\n"))
(define cairo_surface_map_to_image
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_surface_map_to_image"
                (dynamic-link))
              (list '* '*))))
    (lambda (surface extents)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~extents
              (unwrap-cairo_rectangle_int_t* extents)))
        (wrap-cairo_surface_t* (~f ~surface ~extents))))))
(export cairo_surface_map_to_image)

;; void cairo_surface_unmap_image(cairo_surface_t *surface, cairo_surface_t *
;;     image);
(if echo-decls (display "cairo_surface_unmap_image\n"))
(define cairo_surface_unmap_image
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_unmap_image"
                (dynamic-link))
              (list '* '*))))
    (lambda (surface image)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~image (unwrap-cairo_surface_t* image)))
        (~f ~surface ~image)))))
(export cairo_surface_unmap_image)

;; cairo_surface_t *cairo_surface_create_for_rectangle(cairo_surface_t *target
;;     , double x, double y, double width, double height);
(if echo-decls (display "cairo_surface_create_for_rectangle\n"))
(define cairo_surface_create_for_rectangle
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_surface_create_for_rectangle"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (target x y width height)
      (let ((~target (unwrap-cairo_surface_t* target))
            (~x (unwrap~float x))
            (~y (unwrap~float y))
            (~width (unwrap~float width))
            (~height (unwrap~float height)))
        (wrap-cairo_surface_t*
          (~f ~target ~x ~y ~width ~height))))))
(export cairo_surface_create_for_rectangle)

;; typedef enum {
;;   CAIRO_SURFACE_OBSERVER_NORMAL = 0,
;;   CAIRO_SURFACE_OBSERVER_RECORD_OPERATIONS = 0x1,
;; } cairo_surface_observer_mode_t;
(if echo-decls (display "cairo_surface_observer_mode_t\n"))
(define-fh-enum cairo_surface_observer_mode_t
  '((CAIRO_SURFACE_OBSERVER_NORMAL . 0)
    (CAIRO_SURFACE_OBSERVER_RECORD_OPERATIONS . 1))
  )

;; cairo_surface_t *cairo_surface_create_observer(cairo_surface_t *target, 
;;     cairo_surface_observer_mode_t mode);
(if echo-decls (display "cairo_surface_create_observer\n"))
(define cairo_surface_create_observer
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_surface_create_observer"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (target mode)
      (let ((~target (unwrap-cairo_surface_t* target))
            (~mode (unwrap~fixed mode)))
        (wrap-cairo_surface_t* (~f ~target ~mode))))))
(export cairo_surface_create_observer)

;; typedef void (*cairo_surface_observer_callback_t)(cairo_surface_t *observer
;;     , cairo_surface_t *target, void *data);
(if echo-decls (display "cairo_surface_observer_callback_t\n"))
(define-fh-function/p cairo_surface_observer_callback_t
  ffi:void (list (quote *) (quote *) (quote *)))

;; cairo_status_t cairo_surface_observer_add_paint_callback(cairo_surface_t *
;;     abstract_surface, cairo_surface_observer_callback_t func, void *data);
(if echo-decls (display "cairo_surface_observer_add_paint_callback\n"))
(define cairo_surface_observer_add_paint_callback
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_observer_add_paint_callback"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (abstract_surface func data)
      (let ((~abstract_surface
              (unwrap-cairo_surface_t* abstract_surface))
            (~func ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
                    func))
            (~data (unwrap~pointer data)))
        (~f ~abstract_surface ~func ~data)))))
(export cairo_surface_observer_add_paint_callback)

;; cairo_status_t cairo_surface_observer_add_mask_callback(cairo_surface_t *
;;     abstract_surface, cairo_surface_observer_callback_t func, void *data);
(if echo-decls (display "cairo_surface_observer_add_mask_callback\n"))
(define cairo_surface_observer_add_mask_callback
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_observer_add_mask_callback"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (abstract_surface func data)
      (let ((~abstract_surface
              (unwrap-cairo_surface_t* abstract_surface))
            (~func ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
                    func))
            (~data (unwrap~pointer data)))
        (~f ~abstract_surface ~func ~data)))))
(export cairo_surface_observer_add_mask_callback)

;; cairo_status_t cairo_surface_observer_add_fill_callback(cairo_surface_t *
;;     abstract_surface, cairo_surface_observer_callback_t func, void *data);
(if echo-decls (display "cairo_surface_observer_add_fill_callback\n"))
(define cairo_surface_observer_add_fill_callback
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_observer_add_fill_callback"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (abstract_surface func data)
      (let ((~abstract_surface
              (unwrap-cairo_surface_t* abstract_surface))
            (~func ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
                    func))
            (~data (unwrap~pointer data)))
        (~f ~abstract_surface ~func ~data)))))
(export cairo_surface_observer_add_fill_callback)

;; cairo_status_t cairo_surface_observer_add_stroke_callback(cairo_surface_t *
;;     abstract_surface, cairo_surface_observer_callback_t func, void *data);
(if echo-decls (display "cairo_surface_observer_add_stroke_callback\n"))
(define cairo_surface_observer_add_stroke_callback
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_observer_add_stroke_callback"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (abstract_surface func data)
      (let ((~abstract_surface
              (unwrap-cairo_surface_t* abstract_surface))
            (~func ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
                    func))
            (~data (unwrap~pointer data)))
        (~f ~abstract_surface ~func ~data)))))
(export cairo_surface_observer_add_stroke_callback)

;; cairo_status_t cairo_surface_observer_add_glyphs_callback(cairo_surface_t *
;;     abstract_surface, cairo_surface_observer_callback_t func, void *data);
(if echo-decls (display "cairo_surface_observer_add_glyphs_callback\n"))
(define cairo_surface_observer_add_glyphs_callback
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_observer_add_glyphs_callback"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (abstract_surface func data)
      (let ((~abstract_surface
              (unwrap-cairo_surface_t* abstract_surface))
            (~func ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
                    func))
            (~data (unwrap~pointer data)))
        (~f ~abstract_surface ~func ~data)))))
(export cairo_surface_observer_add_glyphs_callback)

;; cairo_status_t cairo_surface_observer_add_flush_callback(cairo_surface_t *
;;     abstract_surface, cairo_surface_observer_callback_t func, void *data);
(if echo-decls (display "cairo_surface_observer_add_flush_callback\n"))
(define cairo_surface_observer_add_flush_callback
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_observer_add_flush_callback"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (abstract_surface func data)
      (let ((~abstract_surface
              (unwrap-cairo_surface_t* abstract_surface))
            (~func ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
                    func))
            (~data (unwrap~pointer data)))
        (~f ~abstract_surface ~func ~data)))))
(export cairo_surface_observer_add_flush_callback)

;; cairo_status_t cairo_surface_observer_add_finish_callback(cairo_surface_t *
;;     abstract_surface, cairo_surface_observer_callback_t func, void *data);
(if echo-decls (display "cairo_surface_observer_add_finish_callback\n"))
(define cairo_surface_observer_add_finish_callback
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_observer_add_finish_callback"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (abstract_surface func data)
      (let ((~abstract_surface
              (unwrap-cairo_surface_t* abstract_surface))
            (~func ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
                    func))
            (~data (unwrap~pointer data)))
        (~f ~abstract_surface ~func ~data)))))
(export cairo_surface_observer_add_finish_callback)

;; cairo_status_t cairo_surface_observer_print(cairo_surface_t *surface, 
;;     cairo_write_func_t write_func, void *closure);
(if echo-decls (display "cairo_surface_observer_print\n"))
(define cairo_surface_observer_print
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_observer_print"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (surface write_func closure)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~write_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* '* ffi:unsigned-int))
               write_func))
            (~closure (unwrap~pointer closure)))
        (~f ~surface ~write_func ~closure)))))
(export cairo_surface_observer_print)

;; double cairo_surface_observer_elapsed(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_observer_elapsed\n"))
(define cairo_surface_observer_elapsed
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_surface_observer_elapsed"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_observer_elapsed)

;; cairo_status_t cairo_device_observer_print(cairo_device_t *device, 
;;     cairo_write_func_t write_func, void *closure);
(if echo-decls (display "cairo_device_observer_print\n"))
(define cairo_device_observer_print
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_device_observer_print"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (device write_func closure)
      (let ((~device (unwrap-cairo_device_t* device))
            (~write_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* '* ffi:unsigned-int))
               write_func))
            (~closure (unwrap~pointer closure)))
        (~f ~device ~write_func ~closure)))))
(export cairo_device_observer_print)

;; double cairo_device_observer_elapsed(cairo_device_t *device);
(if echo-decls (display "cairo_device_observer_elapsed\n"))
(define cairo_device_observer_elapsed
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_device_observer_elapsed"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_observer_elapsed)

;; double cairo_device_observer_paint_elapsed(cairo_device_t *device);
(if echo-decls (display "cairo_device_observer_paint_elapsed\n"))
(define cairo_device_observer_paint_elapsed
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_device_observer_paint_elapsed"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_observer_paint_elapsed)

;; double cairo_device_observer_mask_elapsed(cairo_device_t *device);
(if echo-decls (display "cairo_device_observer_mask_elapsed\n"))
(define cairo_device_observer_mask_elapsed
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_device_observer_mask_elapsed"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_observer_mask_elapsed)

;; double cairo_device_observer_fill_elapsed(cairo_device_t *device);
(if echo-decls (display "cairo_device_observer_fill_elapsed\n"))
(define cairo_device_observer_fill_elapsed
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_device_observer_fill_elapsed"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_observer_fill_elapsed)

;; double cairo_device_observer_stroke_elapsed(cairo_device_t *device);
(if echo-decls (display "cairo_device_observer_stroke_elapsed\n"))
(define cairo_device_observer_stroke_elapsed
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_device_observer_stroke_elapsed"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_observer_stroke_elapsed)

;; double cairo_device_observer_glyphs_elapsed(cairo_device_t *device);
(if echo-decls (display "cairo_device_observer_glyphs_elapsed\n"))
(define cairo_device_observer_glyphs_elapsed
  (let ((~f (ffi:pointer->procedure
              ffi:double
              (dynamic-func
                "cairo_device_observer_glyphs_elapsed"
                (dynamic-link))
              (list '*))))
    (lambda (device)
      (let ((~device (unwrap-cairo_device_t* device)))
        (~f ~device)))))
(export cairo_device_observer_glyphs_elapsed)

;; cairo_surface_t *cairo_surface_reference(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_reference\n"))
(define cairo_surface_reference
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_surface_reference"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (wrap-cairo_surface_t* (~f ~surface))))))
(export cairo_surface_reference)

;; void cairo_surface_finish(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_finish\n"))
(define cairo_surface_finish
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_finish"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_finish)

;; void cairo_surface_destroy(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_destroy\n"))
(define cairo_surface_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_destroy)

;; cairo_device_t *cairo_surface_get_device(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_get_device\n"))
(define cairo_surface_get_device
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_surface_get_device"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (wrap-cairo_device_t* (~f ~surface))))))
(export cairo_surface_get_device)

;; unsigned int cairo_surface_get_reference_count(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_get_reference_count\n"))
(define cairo_surface_get_reference_count
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-int
              (dynamic-func
                "cairo_surface_get_reference_count"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_get_reference_count)

;; cairo_status_t cairo_surface_status(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_status\n"))
(define cairo_surface_status
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_status"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_status)

;; typedef enum _cairo_surface_type {
;;   CAIRO_SURFACE_TYPE_IMAGE,
;;   CAIRO_SURFACE_TYPE_PDF,
;;   CAIRO_SURFACE_TYPE_PS,
;;   CAIRO_SURFACE_TYPE_XLIB,
;;   CAIRO_SURFACE_TYPE_XCB,
;;   CAIRO_SURFACE_TYPE_GLITZ,
;;   CAIRO_SURFACE_TYPE_QUARTZ,
;;   CAIRO_SURFACE_TYPE_WIN32,
;;   CAIRO_SURFACE_TYPE_BEOS,
;;   CAIRO_SURFACE_TYPE_DIRECTFB,
;;   CAIRO_SURFACE_TYPE_SVG,
;;   CAIRO_SURFACE_TYPE_OS2,
;;   CAIRO_SURFACE_TYPE_WIN32_PRINTING,
;;   CAIRO_SURFACE_TYPE_QUARTZ_IMAGE,
;;   CAIRO_SURFACE_TYPE_SCRIPT,
;;   CAIRO_SURFACE_TYPE_QT,
;;   CAIRO_SURFACE_TYPE_RECORDING,
;;   CAIRO_SURFACE_TYPE_VG,
;;   CAIRO_SURFACE_TYPE_GL,
;;   CAIRO_SURFACE_TYPE_DRM,
;;   CAIRO_SURFACE_TYPE_TEE,
;;   CAIRO_SURFACE_TYPE_XML,
;;   CAIRO_SURFACE_TYPE_SKIA,
;;   CAIRO_SURFACE_TYPE_SUBSURFACE,
;;   CAIRO_SURFACE_TYPE_COGL,
;; } cairo_surface_type_t;
(if echo-decls (display "cairo_surface_type_t\n"))
(define-fh-enum cairo_surface_type_t
  '((CAIRO_SURFACE_TYPE_IMAGE . 0)
    (CAIRO_SURFACE_TYPE_PDF . 1)
    (CAIRO_SURFACE_TYPE_PS . 2)
    (CAIRO_SURFACE_TYPE_XLIB . 3)
    (CAIRO_SURFACE_TYPE_XCB . 4)
    (CAIRO_SURFACE_TYPE_GLITZ . 5)
    (CAIRO_SURFACE_TYPE_QUARTZ . 6)
    (CAIRO_SURFACE_TYPE_WIN32 . 7)
    (CAIRO_SURFACE_TYPE_BEOS . 8)
    (CAIRO_SURFACE_TYPE_DIRECTFB . 9)
    (CAIRO_SURFACE_TYPE_SVG . 10)
    (CAIRO_SURFACE_TYPE_OS2 . 11)
    (CAIRO_SURFACE_TYPE_WIN32_PRINTING . 12)
    (CAIRO_SURFACE_TYPE_QUARTZ_IMAGE . 13)
    (CAIRO_SURFACE_TYPE_SCRIPT . 14)
    (CAIRO_SURFACE_TYPE_QT . 15)
    (CAIRO_SURFACE_TYPE_RECORDING . 16)
    (CAIRO_SURFACE_TYPE_VG . 17)
    (CAIRO_SURFACE_TYPE_GL . 18)
    (CAIRO_SURFACE_TYPE_DRM . 19)
    (CAIRO_SURFACE_TYPE_TEE . 20)
    (CAIRO_SURFACE_TYPE_XML . 21)
    (CAIRO_SURFACE_TYPE_SKIA . 22)
    (CAIRO_SURFACE_TYPE_SUBSURFACE . 23)
    (CAIRO_SURFACE_TYPE_COGL . 24))
  )
(define unwrap-enum-_cairo_surface_type unwrap-cairo_surface_type_t)
(define wrap-enum-_cairo_surface_type wrap-cairo_surface_type_t)

;; cairo_surface_type_t cairo_surface_get_type(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_get_type\n"))
(define cairo_surface_get_type
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_get_type"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_get_type)

;; cairo_content_t cairo_surface_get_content(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_get_content\n"))
(define cairo_surface_get_content
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_get_content"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_get_content)

;; cairo_status_t cairo_surface_write_to_png(cairo_surface_t *surface, const 
;;     char *filename);
(if echo-decls (display "cairo_surface_write_to_png\n"))
(define cairo_surface_write_to_png
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_write_to_png"
                (dynamic-link))
              (list '* '*))))
    (lambda (surface filename)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~filename (unwrap~pointer filename)))
        (~f ~surface ~filename)))))
(export cairo_surface_write_to_png)

;; cairo_status_t cairo_surface_write_to_png_stream(cairo_surface_t *surface, 
;;     cairo_write_func_t write_func, void *closure);
(if echo-decls (display "cairo_surface_write_to_png_stream\n"))
(define cairo_surface_write_to_png_stream
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_write_to_png_stream"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (surface write_func closure)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~write_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* '* ffi:unsigned-int))
               write_func))
            (~closure (unwrap~pointer closure)))
        (~f ~surface ~write_func ~closure)))))
(export cairo_surface_write_to_png_stream)

;; void *cairo_surface_get_user_data(cairo_surface_t *surface, const 
;;     cairo_user_data_key_t *key);
(if echo-decls (display "cairo_surface_get_user_data\n"))
(define cairo_surface_get_user_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_surface_get_user_data"
                (dynamic-link))
              (list '* '*))))
    (lambda (surface key)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~key (unwrap-cairo_user_data_key_t* key)))
        (~f ~surface ~key)))))
(export cairo_surface_get_user_data)

;; cairo_status_t cairo_surface_set_user_data(cairo_surface_t *surface, const 
;;     cairo_user_data_key_t *key, void *user_data, cairo_destroy_func_t 
;;     destroy);
(if echo-decls (display "cairo_surface_set_user_data\n"))
(define cairo_surface_set_user_data
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_set_user_data"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (surface key user_data destroy)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~key (unwrap-cairo_user_data_key_t* key))
            (~user_data (unwrap~pointer user_data))
            (~destroy
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               destroy)))
        (~f ~surface ~key ~user_data ~destroy)))))
(export cairo_surface_set_user_data)

;; void cairo_surface_get_mime_data(cairo_surface_t *surface, const char *
;;     mime_type, const unsigned char **data, unsigned long *length);
(if echo-decls (display "cairo_surface_get_mime_data\n"))
(define cairo_surface_get_mime_data
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_get_mime_data"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (surface mime_type data length)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~mime_type (unwrap~pointer mime_type))
            (~data (unwrap~pointer data))
            (~length (unwrap~pointer length)))
        (~f ~surface ~mime_type ~data ~length)))))
(export cairo_surface_get_mime_data)

;; cairo_status_t cairo_surface_set_mime_data(cairo_surface_t *surface, const 
;;     char *mime_type, const unsigned char *data, unsigned long length, 
;;     cairo_destroy_func_t destroy, void *closure);
(if echo-decls (display "cairo_surface_set_mime_data\n"))
(define cairo_surface_set_mime_data
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_set_mime_data"
                (dynamic-link))
              (list '* '* '* ffi:unsigned-long '* '*))))
    (lambda (surface mime_type data length destroy closure)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~mime_type (unwrap~pointer mime_type))
            (~data (unwrap~pointer data))
            (~length (unwrap~fixed length))
            (~destroy
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               destroy))
            (~closure (unwrap~pointer closure)))
        (~f ~surface
            ~mime_type
            ~data
            ~length
            ~destroy
            ~closure)))))
(export cairo_surface_set_mime_data)

;; cairo_bool_t cairo_surface_supports_mime_type(cairo_surface_t *surface, 
;;     const char *mime_type);
(if echo-decls (display "cairo_surface_supports_mime_type\n"))
(define cairo_surface_supports_mime_type
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_supports_mime_type"
                (dynamic-link))
              (list '* '*))))
    (lambda (surface mime_type)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~mime_type (unwrap~pointer mime_type)))
        (wrap-cairo_bool_t (~f ~surface ~mime_type))))))
(export cairo_surface_supports_mime_type)

;; void cairo_surface_get_font_options(cairo_surface_t *surface, 
;;     cairo_font_options_t *options);
(if echo-decls (display "cairo_surface_get_font_options\n"))
(define cairo_surface_get_font_options
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_get_font_options"
                (dynamic-link))
              (list '* '*))))
    (lambda (surface options)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~options (unwrap-cairo_font_options_t* options)))
        (~f ~surface ~options)))))
(export cairo_surface_get_font_options)

;; void cairo_surface_flush(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_flush\n"))
(define cairo_surface_flush
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_flush"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_flush)

;; void cairo_surface_mark_dirty(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_mark_dirty\n"))
(define cairo_surface_mark_dirty
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_mark_dirty"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_mark_dirty)

;; void cairo_surface_mark_dirty_rectangle(cairo_surface_t *surface, int x, int
;;      y, int width, int height);
(if echo-decls (display "cairo_surface_mark_dirty_rectangle\n"))
(define cairo_surface_mark_dirty_rectangle
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_mark_dirty_rectangle"
                (dynamic-link))
              (list '* ffi:int ffi:int ffi:int ffi:int))))
    (lambda (surface x y width height)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~x (unwrap~fixed x))
            (~y (unwrap~fixed y))
            (~width (unwrap~fixed width))
            (~height (unwrap~fixed height)))
        (~f ~surface ~x ~y ~width ~height)))))
(export cairo_surface_mark_dirty_rectangle)

;; void cairo_surface_set_device_scale(cairo_surface_t *surface, double x_scale
;;     , double y_scale);
(if echo-decls (display "cairo_surface_set_device_scale\n"))
(define cairo_surface_set_device_scale
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_set_device_scale"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (surface x_scale y_scale)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~x_scale (unwrap~float x_scale))
            (~y_scale (unwrap~float y_scale)))
        (~f ~surface ~x_scale ~y_scale)))))
(export cairo_surface_set_device_scale)

;; void cairo_surface_get_device_scale(cairo_surface_t *surface, double *
;;     x_scale, double *y_scale);
(if echo-decls (display "cairo_surface_get_device_scale\n"))
(define cairo_surface_get_device_scale
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_get_device_scale"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (surface x_scale y_scale)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~x_scale (unwrap~pointer x_scale))
            (~y_scale (unwrap~pointer y_scale)))
        (~f ~surface ~x_scale ~y_scale)))))
(export cairo_surface_get_device_scale)

;; void cairo_surface_set_device_offset(cairo_surface_t *surface, double 
;;     x_offset, double y_offset);
(if echo-decls (display "cairo_surface_set_device_offset\n"))
(define cairo_surface_set_device_offset
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_set_device_offset"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (surface x_offset y_offset)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~x_offset (unwrap~float x_offset))
            (~y_offset (unwrap~float y_offset)))
        (~f ~surface ~x_offset ~y_offset)))))
(export cairo_surface_set_device_offset)

;; void cairo_surface_get_device_offset(cairo_surface_t *surface, double *
;;     x_offset, double *y_offset);
(if echo-decls (display "cairo_surface_get_device_offset\n"))
(define cairo_surface_get_device_offset
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_get_device_offset"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (surface x_offset y_offset)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~x_offset (unwrap~pointer x_offset))
            (~y_offset (unwrap~pointer y_offset)))
        (~f ~surface ~x_offset ~y_offset)))))
(export cairo_surface_get_device_offset)

;; void cairo_surface_set_fallback_resolution(cairo_surface_t *surface, double 
;;     x_pixels_per_inch, double y_pixels_per_inch);
(if echo-decls (display "cairo_surface_set_fallback_resolution\n"))
(define cairo_surface_set_fallback_resolution
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_set_fallback_resolution"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (surface x_pixels_per_inch y_pixels_per_inch)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~x_pixels_per_inch
              (unwrap~float x_pixels_per_inch))
            (~y_pixels_per_inch
              (unwrap~float y_pixels_per_inch)))
        (~f ~surface
            ~x_pixels_per_inch
            ~y_pixels_per_inch)))))
(export cairo_surface_set_fallback_resolution)

;; void cairo_surface_get_fallback_resolution(cairo_surface_t *surface, double 
;;     *x_pixels_per_inch, double *y_pixels_per_inch);
(if echo-decls (display "cairo_surface_get_fallback_resolution\n"))
(define cairo_surface_get_fallback_resolution
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_get_fallback_resolution"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (surface x_pixels_per_inch y_pixels_per_inch)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~x_pixels_per_inch
              (unwrap~pointer x_pixels_per_inch))
            (~y_pixels_per_inch
              (unwrap~pointer y_pixels_per_inch)))
        (~f ~surface
            ~x_pixels_per_inch
            ~y_pixels_per_inch)))))
(export cairo_surface_get_fallback_resolution)

;; void cairo_surface_copy_page(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_copy_page\n"))
(define cairo_surface_copy_page
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_copy_page"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_copy_page)

;; void cairo_surface_show_page(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_show_page\n"))
(define cairo_surface_show_page
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_surface_show_page"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_surface_show_page)

;; cairo_bool_t cairo_surface_has_show_text_glyphs(cairo_surface_t *surface);
(if echo-decls (display "cairo_surface_has_show_text_glyphs\n"))
(define cairo_surface_has_show_text_glyphs
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_surface_has_show_text_glyphs"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (wrap-cairo_bool_t (~f ~surface))))))
(export cairo_surface_has_show_text_glyphs)

;; cairo_surface_t *cairo_image_surface_create(cairo_format_t format, int width
;;     , int height);
(if echo-decls (display "cairo_image_surface_create\n"))
(define cairo_image_surface_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_image_surface_create"
                (dynamic-link))
              (list ffi:int ffi:int ffi:int))))
    (lambda (format width height)
      (let ((~format (unwrap~fixed format))
            (~width (unwrap~fixed width))
            (~height (unwrap~fixed height)))
        (wrap-cairo_surface_t*
          (~f ~format ~width ~height))))))
(export cairo_image_surface_create)

;; int cairo_format_stride_for_width(cairo_format_t format, int width);
(if echo-decls (display "cairo_format_stride_for_width\n"))
(define cairo_format_stride_for_width
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_format_stride_for_width"
                (dynamic-link))
              (list ffi:int ffi:int))))
    (lambda (format width)
      (let ((~format (unwrap~fixed format))
            (~width (unwrap~fixed width)))
        (~f ~format ~width)))))
(export cairo_format_stride_for_width)

;; cairo_surface_t *cairo_image_surface_create_for_data(unsigned char *data, 
;;     cairo_format_t format, int width, int height, int stride);
(if echo-decls (display "cairo_image_surface_create_for_data\n"))
(define cairo_image_surface_create_for_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_image_surface_create_for_data"
                (dynamic-link))
              (list '* ffi:int ffi:int ffi:int ffi:int))))
    (lambda (data format width height stride)
      (let ((~data (unwrap~pointer data))
            (~format (unwrap~fixed format))
            (~width (unwrap~fixed width))
            (~height (unwrap~fixed height))
            (~stride (unwrap~fixed stride)))
        (wrap-cairo_surface_t*
          (~f ~data ~format ~width ~height ~stride))))))
(export cairo_image_surface_create_for_data)

;; unsigned char *cairo_image_surface_get_data(cairo_surface_t *surface);
(if echo-decls (display "cairo_image_surface_get_data\n"))
(define cairo_image_surface_get_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_image_surface_get_data"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_image_surface_get_data)

;; cairo_format_t cairo_image_surface_get_format(cairo_surface_t *surface);
(if echo-decls (display "cairo_image_surface_get_format\n"))
(define cairo_image_surface_get_format
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_image_surface_get_format"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_image_surface_get_format)

;; int cairo_image_surface_get_width(cairo_surface_t *surface);
(if echo-decls (display "cairo_image_surface_get_width\n"))
(define cairo_image_surface_get_width
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_image_surface_get_width"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_image_surface_get_width)

;; int cairo_image_surface_get_height(cairo_surface_t *surface);
(if echo-decls (display "cairo_image_surface_get_height\n"))
(define cairo_image_surface_get_height
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_image_surface_get_height"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_image_surface_get_height)

;; int cairo_image_surface_get_stride(cairo_surface_t *surface);
(if echo-decls (display "cairo_image_surface_get_stride\n"))
(define cairo_image_surface_get_stride
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_image_surface_get_stride"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (~f ~surface)))))
(export cairo_image_surface_get_stride)

;; cairo_surface_t *cairo_image_surface_create_from_png(const char *filename);
(if echo-decls (display "cairo_image_surface_create_from_png\n"))
(define cairo_image_surface_create_from_png
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_image_surface_create_from_png"
                (dynamic-link))
              (list '*))))
    (lambda (filename)
      (let ((~filename (unwrap~pointer filename)))
        (wrap-cairo_surface_t* (~f ~filename))))))
(export cairo_image_surface_create_from_png)

;; cairo_surface_t *cairo_image_surface_create_from_png_stream(
;;     cairo_read_func_t read_func, void *closure);
(if echo-decls (display "cairo_image_surface_create_from_png_stream\n"))
(define cairo_image_surface_create_from_png_stream
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_image_surface_create_from_png_stream"
                (dynamic-link))
              (list '* '*))))
    (lambda (read_func closure)
      (let ((~read_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* '* ffi:unsigned-int))
               read_func))
            (~closure (unwrap~pointer closure)))
        (wrap-cairo_surface_t* (~f ~read_func ~closure))))))
(export cairo_image_surface_create_from_png_stream)

;; cairo_surface_t *cairo_recording_surface_create(cairo_content_t content, 
;;     const cairo_rectangle_t *extents);
(if echo-decls (display "cairo_recording_surface_create\n"))
(define cairo_recording_surface_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_recording_surface_create"
                (dynamic-link))
              (list ffi:int '*))))
    (lambda (content extents)
      (let ((~content (unwrap~fixed content))
            (~extents (unwrap-cairo_rectangle_t* extents)))
        (wrap-cairo_surface_t* (~f ~content ~extents))))))
(export cairo_recording_surface_create)

;; void cairo_recording_surface_ink_extents(cairo_surface_t *surface, double *
;;     x0, double *y0, double *width, double *height);
(if echo-decls (display "cairo_recording_surface_ink_extents\n"))
(define cairo_recording_surface_ink_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_recording_surface_ink_extents"
                (dynamic-link))
              (list '* '* '* '* '*))))
    (lambda (surface x0 y0 width height)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~x0 (unwrap~pointer x0))
            (~y0 (unwrap~pointer y0))
            (~width (unwrap~pointer width))
            (~height (unwrap~pointer height)))
        (~f ~surface ~x0 ~y0 ~width ~height)))))
(export cairo_recording_surface_ink_extents)

;; cairo_bool_t cairo_recording_surface_get_extents(cairo_surface_t *surface, 
;;     cairo_rectangle_t *extents);
(if echo-decls (display "cairo_recording_surface_get_extents\n"))
(define cairo_recording_surface_get_extents
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_recording_surface_get_extents"
                (dynamic-link))
              (list '* '*))))
    (lambda (surface extents)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~extents (unwrap-cairo_rectangle_t* extents)))
        (wrap-cairo_bool_t (~f ~surface ~extents))))))
(export cairo_recording_surface_get_extents)

;; typedef cairo_surface_t *(*cairo_raster_source_acquire_func_t)(
;;     cairo_pattern_t *pattern, void *callback_data, cairo_surface_t *target, 
;;     const cairo_rectangle_int_t *extents);
(if echo-decls (display "cairo_raster_source_acquire_func_t\n"))
(define-fh-function/p
  cairo_raster_source_acquire_func_t
  '*
  (list '* '* '* '*))

;; typedef void (*cairo_raster_source_release_func_t)(cairo_pattern_t *pattern
;;     , void *callback_data, cairo_surface_t *surface);
(if echo-decls (display "cairo_raster_source_release_func_t\n"))
(define-fh-function/p cairo_raster_source_release_func_t
  ffi:void (list (quote *) (quote *) (quote *)))

;; typedef cairo_status_t (*cairo_raster_source_snapshot_func_t)(
;;     cairo_pattern_t *pattern, void *callback_data);
(if echo-decls (display "cairo_raster_source_snapshot_func_t\n"))
(define-fh-function/p cairo_raster_source_snapshot_func_t
  ffi:int (list (quote *) (quote *)))

;; typedef cairo_status_t (*cairo_raster_source_copy_func_t)(cairo_pattern_t *
;;     pattern, void *callback_data, const cairo_pattern_t *other);
(if echo-decls (display "cairo_raster_source_copy_func_t\n"))
(define-fh-function/p cairo_raster_source_copy_func_t
  ffi:int (list (quote *) (quote *) (quote *)))

;; typedef void (*cairo_raster_source_finish_func_t)(cairo_pattern_t *pattern, 
;;     void *callback_data);
(if echo-decls (display "cairo_raster_source_finish_func_t\n"))
(define-fh-function/p cairo_raster_source_finish_func_t
  ffi:void (list (quote *) (quote *)))

;; cairo_pattern_t *cairo_pattern_create_raster_source(void *user_data, 
;;     cairo_content_t content, int width, int height);
(if echo-decls (display "cairo_pattern_create_raster_source\n"))
(define cairo_pattern_create_raster_source
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_create_raster_source"
                (dynamic-link))
              (list '* ffi:int ffi:int ffi:int))))
    (lambda (user_data content width height)
      (let ((~user_data (unwrap~pointer user_data))
            (~content (unwrap~fixed content))
            (~width (unwrap~fixed width))
            (~height (unwrap~fixed height)))
        (wrap-cairo_pattern_t*
          (~f ~user_data ~content ~width ~height))))))
(export cairo_pattern_create_raster_source)

;; void cairo_raster_source_pattern_set_callback_data(cairo_pattern_t *pattern
;;     , void *data);
(if echo-decls (display "cairo_raster_source_pattern_set_callback_data\n"))
(define cairo_raster_source_pattern_set_callback_data
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_raster_source_pattern_set_callback_data"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern data)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~data (unwrap~pointer data)))
        (~f ~pattern ~data)))))
(export cairo_raster_source_pattern_set_callback_data)

;; void *cairo_raster_source_pattern_get_callback_data(cairo_pattern_t *pattern
;;     );
(if echo-decls (display "cairo_raster_source_pattern_get_callback_data\n"))
(define cairo_raster_source_pattern_get_callback_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_raster_source_pattern_get_callback_data"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_raster_source_pattern_get_callback_data)

;; void cairo_raster_source_pattern_set_acquire(cairo_pattern_t *pattern, 
;;     cairo_raster_source_acquire_func_t acquire, 
;;     cairo_raster_source_release_func_t release);
(if echo-decls (display "cairo_raster_source_pattern_set_acquire\n"))
(define cairo_raster_source_pattern_set_acquire
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_raster_source_pattern_set_acquire"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (pattern acquire release)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~acquire
              ((make-ftn-arg-unwrapper '* (list '* '* '* '*))
               acquire))
            (~release
              ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
               release)))
        (~f ~pattern ~acquire ~release)))))
(export cairo_raster_source_pattern_set_acquire)

;; void cairo_raster_source_pattern_get_acquire(cairo_pattern_t *pattern, 
;;     cairo_raster_source_acquire_func_t *acquire, 
;;     cairo_raster_source_release_func_t *release);
(if echo-decls (display "cairo_raster_source_pattern_get_acquire\n"))
(define cairo_raster_source_pattern_get_acquire
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_raster_source_pattern_get_acquire"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (pattern acquire release)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~acquire (unwrap~pointer acquire))
            (~release (unwrap~pointer release)))
        (~f ~pattern ~acquire ~release)))))
(export cairo_raster_source_pattern_get_acquire)

;; void cairo_raster_source_pattern_set_snapshot(cairo_pattern_t *pattern, 
;;     cairo_raster_source_snapshot_func_t snapshot);
(if echo-decls (display "cairo_raster_source_pattern_set_snapshot\n"))
(define cairo_raster_source_pattern_set_snapshot
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_raster_source_pattern_set_snapshot"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern snapshot)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~snapshot
              ((make-ftn-arg-unwrapper ffi:void (list '* '*))
               snapshot)))
        (~f ~pattern ~snapshot)))))
(export cairo_raster_source_pattern_set_snapshot)

;; cairo_raster_source_snapshot_func_t cairo_raster_source_pattern_get_snapshot
;;     (cairo_pattern_t *pattern);
(if echo-decls (display "cairo_raster_source_pattern_get_snapshot\n"))
(define cairo_raster_source_pattern_get_snapshot
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_raster_source_pattern_get_snapshot"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_raster_source_pattern_get_snapshot)

;; void cairo_raster_source_pattern_set_copy(cairo_pattern_t *pattern, 
;;     cairo_raster_source_copy_func_t copy);
(if echo-decls (display "cairo_raster_source_pattern_set_copy\n"))
(define cairo_raster_source_pattern_set_copy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_raster_source_pattern_set_copy"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern copy)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~copy ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
                    copy)))
        (~f ~pattern ~copy)))))
(export cairo_raster_source_pattern_set_copy)

;; cairo_raster_source_copy_func_t cairo_raster_source_pattern_get_copy(
;;     cairo_pattern_t *pattern);
(if echo-decls (display "cairo_raster_source_pattern_get_copy\n"))
(define cairo_raster_source_pattern_get_copy
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_raster_source_pattern_get_copy"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_raster_source_pattern_get_copy)

;; void cairo_raster_source_pattern_set_finish(cairo_pattern_t *pattern, 
;;     cairo_raster_source_finish_func_t finish);
(if echo-decls (display "cairo_raster_source_pattern_set_finish\n"))
(define cairo_raster_source_pattern_set_finish
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_raster_source_pattern_set_finish"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern finish)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~finish
              ((make-ftn-arg-unwrapper ffi:void (list '* '*))
               finish)))
        (~f ~pattern ~finish)))))
(export cairo_raster_source_pattern_set_finish)

;; cairo_raster_source_finish_func_t cairo_raster_source_pattern_get_finish(
;;     cairo_pattern_t *pattern);
(if echo-decls (display "cairo_raster_source_pattern_get_finish\n"))
(define cairo_raster_source_pattern_get_finish
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_raster_source_pattern_get_finish"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_raster_source_pattern_get_finish)

;; cairo_pattern_t *cairo_pattern_create_rgb(double red, double green, double 
;;     blue);
(if echo-decls (display "cairo_pattern_create_rgb\n"))
(define cairo_pattern_create_rgb
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_create_rgb"
                (dynamic-link))
              (list ffi:double ffi:double ffi:double))))
    (lambda (red green blue)
      (let ((~red (unwrap~float red))
            (~green (unwrap~float green))
            (~blue (unwrap~float blue)))
        (wrap-cairo_pattern_t* (~f ~red ~green ~blue))))))
(export cairo_pattern_create_rgb)

;; cairo_pattern_t *cairo_pattern_create_rgba(double red, double green, double 
;;     blue, double alpha);
(if echo-decls (display "cairo_pattern_create_rgba\n"))
(define cairo_pattern_create_rgba
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_create_rgba"
                (dynamic-link))
              (list ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (red green blue alpha)
      (let ((~red (unwrap~float red))
            (~green (unwrap~float green))
            (~blue (unwrap~float blue))
            (~alpha (unwrap~float alpha)))
        (wrap-cairo_pattern_t*
          (~f ~red ~green ~blue ~alpha))))))
(export cairo_pattern_create_rgba)

;; cairo_pattern_t *cairo_pattern_create_for_surface(cairo_surface_t *surface)
;;     ;
(if echo-decls (display "cairo_pattern_create_for_surface\n"))
(define cairo_pattern_create_for_surface
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_create_for_surface"
                (dynamic-link))
              (list '*))))
    (lambda (surface)
      (let ((~surface (unwrap-cairo_surface_t* surface)))
        (wrap-cairo_pattern_t* (~f ~surface))))))
(export cairo_pattern_create_for_surface)

;; cairo_pattern_t *cairo_pattern_create_linear(double x0, double y0, double x1
;;     , double y1);
(if echo-decls (display "cairo_pattern_create_linear\n"))
(define cairo_pattern_create_linear
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_create_linear"
                (dynamic-link))
              (list ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (x0 y0 x1 y1)
      (let ((~x0 (unwrap~float x0))
            (~y0 (unwrap~float y0))
            (~x1 (unwrap~float x1))
            (~y1 (unwrap~float y1)))
        (wrap-cairo_pattern_t* (~f ~x0 ~y0 ~x1 ~y1))))))
(export cairo_pattern_create_linear)

;; cairo_pattern_t *cairo_pattern_create_radial(double cx0, double cy0, double 
;;     radius0, double cx1, double cy1, double radius1);
(if echo-decls (display "cairo_pattern_create_radial\n"))
(define cairo_pattern_create_radial
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_create_radial"
                (dynamic-link))
              (list ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (cx0 cy0 radius0 cx1 cy1 radius1)
      (let ((~cx0 (unwrap~float cx0))
            (~cy0 (unwrap~float cy0))
            (~radius0 (unwrap~float radius0))
            (~cx1 (unwrap~float cx1))
            (~cy1 (unwrap~float cy1))
            (~radius1 (unwrap~float radius1)))
        (wrap-cairo_pattern_t*
          (~f ~cx0 ~cy0 ~radius0 ~cx1 ~cy1 ~radius1))))))
(export cairo_pattern_create_radial)

;; cairo_pattern_t *cairo_pattern_create_mesh(void);
(if echo-decls (display "cairo_pattern_create_mesh\n"))
(define cairo_pattern_create_mesh
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_create_mesh"
                (dynamic-link))
              (list))))
    (lambda () (let () (wrap-cairo_pattern_t* (~f))))))
(export cairo_pattern_create_mesh)

;; cairo_pattern_t *cairo_pattern_reference(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_pattern_reference\n"))
(define cairo_pattern_reference
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_reference"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (wrap-cairo_pattern_t* (~f ~pattern))))))
(export cairo_pattern_reference)

;; void cairo_pattern_destroy(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_pattern_destroy\n"))
(define cairo_pattern_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pattern_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_pattern_destroy)

;; unsigned int cairo_pattern_get_reference_count(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_pattern_get_reference_count\n"))
(define cairo_pattern_get_reference_count
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-int
              (dynamic-func
                "cairo_pattern_get_reference_count"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_pattern_get_reference_count)

;; cairo_status_t cairo_pattern_status(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_pattern_status\n"))
(define cairo_pattern_status
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_status"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_pattern_status)

;; void *cairo_pattern_get_user_data(cairo_pattern_t *pattern, const 
;;     cairo_user_data_key_t *key);
(if echo-decls (display "cairo_pattern_get_user_data\n"))
(define cairo_pattern_get_user_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pattern_get_user_data"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern key)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~key (unwrap-cairo_user_data_key_t* key)))
        (~f ~pattern ~key)))))
(export cairo_pattern_get_user_data)

;; cairo_status_t cairo_pattern_set_user_data(cairo_pattern_t *pattern, const 
;;     cairo_user_data_key_t *key, void *user_data, cairo_destroy_func_t 
;;     destroy);
(if echo-decls (display "cairo_pattern_set_user_data\n"))
(define cairo_pattern_set_user_data
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_set_user_data"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (pattern key user_data destroy)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~key (unwrap-cairo_user_data_key_t* key))
            (~user_data (unwrap~pointer user_data))
            (~destroy
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               destroy)))
        (~f ~pattern ~key ~user_data ~destroy)))))
(export cairo_pattern_set_user_data)

;; typedef enum _cairo_pattern_type {
;;   CAIRO_PATTERN_TYPE_SOLID,
;;   CAIRO_PATTERN_TYPE_SURFACE,
;;   CAIRO_PATTERN_TYPE_LINEAR,
;;   CAIRO_PATTERN_TYPE_RADIAL,
;;   CAIRO_PATTERN_TYPE_MESH,
;;   CAIRO_PATTERN_TYPE_RASTER_SOURCE,
;; } cairo_pattern_type_t;
(if echo-decls (display "cairo_pattern_type_t\n"))
(define-fh-enum cairo_pattern_type_t
  '((CAIRO_PATTERN_TYPE_SOLID . 0)
    (CAIRO_PATTERN_TYPE_SURFACE . 1)
    (CAIRO_PATTERN_TYPE_LINEAR . 2)
    (CAIRO_PATTERN_TYPE_RADIAL . 3)
    (CAIRO_PATTERN_TYPE_MESH . 4)
    (CAIRO_PATTERN_TYPE_RASTER_SOURCE . 5))
  )
(define unwrap-enum-_cairo_pattern_type unwrap-cairo_pattern_type_t)
(define wrap-enum-_cairo_pattern_type wrap-cairo_pattern_type_t)

;; cairo_pattern_type_t cairo_pattern_get_type(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_pattern_get_type\n"))
(define cairo_pattern_get_type
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_type"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_pattern_get_type)

;; void cairo_pattern_add_color_stop_rgb(cairo_pattern_t *pattern, double 
;;     offset, double red, double green, double blue);
(if echo-decls (display "cairo_pattern_add_color_stop_rgb\n"))
(define cairo_pattern_add_color_stop_rgb
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pattern_add_color_stop_rgb"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (pattern offset red green blue)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~offset (unwrap~float offset))
            (~red (unwrap~float red))
            (~green (unwrap~float green))
            (~blue (unwrap~float blue)))
        (~f ~pattern ~offset ~red ~green ~blue)))))
(export cairo_pattern_add_color_stop_rgb)

;; void cairo_pattern_add_color_stop_rgba(cairo_pattern_t *pattern, double 
;;     offset, double red, double green, double blue, double alpha);
(if echo-decls (display "cairo_pattern_add_color_stop_rgba\n"))
(define cairo_pattern_add_color_stop_rgba
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pattern_add_color_stop_rgba"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (pattern offset red green blue alpha)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~offset (unwrap~float offset))
            (~red (unwrap~float red))
            (~green (unwrap~float green))
            (~blue (unwrap~float blue))
            (~alpha (unwrap~float alpha)))
        (~f ~pattern ~offset ~red ~green ~blue ~alpha)))))
(export cairo_pattern_add_color_stop_rgba)

;; void cairo_mesh_pattern_begin_patch(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_mesh_pattern_begin_patch\n"))
(define cairo_mesh_pattern_begin_patch
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mesh_pattern_begin_patch"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_mesh_pattern_begin_patch)

;; void cairo_mesh_pattern_end_patch(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_mesh_pattern_end_patch\n"))
(define cairo_mesh_pattern_end_patch
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mesh_pattern_end_patch"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_mesh_pattern_end_patch)

;; void cairo_mesh_pattern_curve_to(cairo_pattern_t *pattern, double x1, double
;;      y1, double x2, double y2, double x3, double y3);
(if echo-decls (display "cairo_mesh_pattern_curve_to\n"))
(define cairo_mesh_pattern_curve_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mesh_pattern_curve_to"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (pattern x1 y1 x2 y2 x3 y3)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~x1 (unwrap~float x1))
            (~y1 (unwrap~float y1))
            (~x2 (unwrap~float x2))
            (~y2 (unwrap~float y2))
            (~x3 (unwrap~float x3))
            (~y3 (unwrap~float y3)))
        (~f ~pattern ~x1 ~y1 ~x2 ~y2 ~x3 ~y3)))))
(export cairo_mesh_pattern_curve_to)

;; void cairo_mesh_pattern_line_to(cairo_pattern_t *pattern, double x, double y
;;     );
(if echo-decls (display "cairo_mesh_pattern_line_to\n"))
(define cairo_mesh_pattern_line_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mesh_pattern_line_to"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (pattern x y)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (~f ~pattern ~x ~y)))))
(export cairo_mesh_pattern_line_to)

;; void cairo_mesh_pattern_move_to(cairo_pattern_t *pattern, double x, double y
;;     );
(if echo-decls (display "cairo_mesh_pattern_move_to\n"))
(define cairo_mesh_pattern_move_to
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mesh_pattern_move_to"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (pattern x y)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (~f ~pattern ~x ~y)))))
(export cairo_mesh_pattern_move_to)

;; void cairo_mesh_pattern_set_control_point(cairo_pattern_t *pattern, 
;;     unsigned int point_num, double x, double y);
(if echo-decls (display "cairo_mesh_pattern_set_control_point\n"))
(define cairo_mesh_pattern_set_control_point
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mesh_pattern_set_control_point"
                (dynamic-link))
              (list '* ffi:unsigned-int ffi:double ffi:double))))
    (lambda (pattern point_num x y)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~point_num (unwrap~fixed point_num))
            (~x (unwrap~float x))
            (~y (unwrap~float y)))
        (~f ~pattern ~point_num ~x ~y)))))
(export cairo_mesh_pattern_set_control_point)

;; void cairo_mesh_pattern_set_corner_color_rgb(cairo_pattern_t *pattern, 
;;     unsigned int corner_num, double red, double green, double blue);
(if echo-decls (display "cairo_mesh_pattern_set_corner_color_rgb\n"))
(define cairo_mesh_pattern_set_corner_color_rgb
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mesh_pattern_set_corner_color_rgb"
                (dynamic-link))
              (list '*
                    ffi:unsigned-int
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (pattern corner_num red green blue)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~corner_num (unwrap~fixed corner_num))
            (~red (unwrap~float red))
            (~green (unwrap~float green))
            (~blue (unwrap~float blue)))
        (~f ~pattern ~corner_num ~red ~green ~blue)))))
(export cairo_mesh_pattern_set_corner_color_rgb)

;; void cairo_mesh_pattern_set_corner_color_rgba(cairo_pattern_t *pattern, 
;;     unsigned int corner_num, double red, double green, double blue, double 
;;     alpha);
(if echo-decls (display "cairo_mesh_pattern_set_corner_color_rgba\n"))
(define cairo_mesh_pattern_set_corner_color_rgba
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_mesh_pattern_set_corner_color_rgba"
                (dynamic-link))
              (list '*
                    ffi:unsigned-int
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (pattern corner_num red green blue alpha)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~corner_num (unwrap~fixed corner_num))
            (~red (unwrap~float red))
            (~green (unwrap~float green))
            (~blue (unwrap~float blue))
            (~alpha (unwrap~float alpha)))
        (~f ~pattern
            ~corner_num
            ~red
            ~green
            ~blue
            ~alpha)))))
(export cairo_mesh_pattern_set_corner_color_rgba)

;; void cairo_pattern_set_matrix(cairo_pattern_t *pattern, const cairo_matrix_t
;;      *matrix);
(if echo-decls (display "cairo_pattern_set_matrix\n"))
(define cairo_pattern_set_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pattern_set_matrix"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern matrix)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~pattern ~matrix)))))
(export cairo_pattern_set_matrix)

;; void cairo_pattern_get_matrix(cairo_pattern_t *pattern, cairo_matrix_t *
;;     matrix);
(if echo-decls (display "cairo_pattern_get_matrix\n"))
(define cairo_pattern_get_matrix
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pattern_get_matrix"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern matrix)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~pattern ~matrix)))))
(export cairo_pattern_get_matrix)

;; typedef enum _cairo_extend {
;;   CAIRO_EXTEND_NONE,
;;   CAIRO_EXTEND_REPEAT,
;;   CAIRO_EXTEND_REFLECT,
;;   CAIRO_EXTEND_PAD,
;; } cairo_extend_t;
(if echo-decls (display "cairo_extend_t\n"))
(define-fh-enum cairo_extend_t
  '((CAIRO_EXTEND_NONE . 0)
    (CAIRO_EXTEND_REPEAT . 1)
    (CAIRO_EXTEND_REFLECT . 2)
    (CAIRO_EXTEND_PAD . 3))
  )
(define unwrap-enum-_cairo_extend unwrap-cairo_extend_t)
(define wrap-enum-_cairo_extend wrap-cairo_extend_t)

;; void cairo_pattern_set_extend(cairo_pattern_t *pattern, cairo_extend_t 
;;     extend);
(if echo-decls (display "cairo_pattern_set_extend\n"))
(define cairo_pattern_set_extend
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pattern_set_extend"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (pattern extend)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~extend (unwrap~fixed extend)))
        (~f ~pattern ~extend)))))
(export cairo_pattern_set_extend)

;; cairo_extend_t cairo_pattern_get_extend(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_pattern_get_extend\n"))
(define cairo_pattern_get_extend
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_extend"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_pattern_get_extend)

;; typedef enum _cairo_filter {
;;   CAIRO_FILTER_FAST,
;;   CAIRO_FILTER_GOOD,
;;   CAIRO_FILTER_BEST,
;;   CAIRO_FILTER_NEAREST,
;;   CAIRO_FILTER_BILINEAR,
;;   CAIRO_FILTER_GAUSSIAN,
;; } cairo_filter_t;
(if echo-decls (display "cairo_filter_t\n"))
(define-fh-enum cairo_filter_t
  '((CAIRO_FILTER_FAST . 0)
    (CAIRO_FILTER_GOOD . 1)
    (CAIRO_FILTER_BEST . 2)
    (CAIRO_FILTER_NEAREST . 3)
    (CAIRO_FILTER_BILINEAR . 4)
    (CAIRO_FILTER_GAUSSIAN . 5))
  )
(define unwrap-enum-_cairo_filter unwrap-cairo_filter_t)
(define wrap-enum-_cairo_filter wrap-cairo_filter_t)

;; void cairo_pattern_set_filter(cairo_pattern_t *pattern, cairo_filter_t 
;;     filter);
(if echo-decls (display "cairo_pattern_set_filter\n"))
(define cairo_pattern_set_filter
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pattern_set_filter"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (pattern filter)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~filter (unwrap~fixed filter)))
        (~f ~pattern ~filter)))))
(export cairo_pattern_set_filter)

;; cairo_filter_t cairo_pattern_get_filter(cairo_pattern_t *pattern);
(if echo-decls (display "cairo_pattern_get_filter\n"))
(define cairo_pattern_get_filter
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_filter"
                (dynamic-link))
              (list '*))))
    (lambda (pattern)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern)))
        (~f ~pattern)))))
(export cairo_pattern_get_filter)

;; cairo_status_t cairo_pattern_get_rgba(cairo_pattern_t *pattern, double *red
;;     , double *green, double *blue, double *alpha);
(if echo-decls (display "cairo_pattern_get_rgba\n"))
(define cairo_pattern_get_rgba
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_rgba"
                (dynamic-link))
              (list '* '* '* '* '*))))
    (lambda (pattern red green blue alpha)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~red (unwrap~pointer red))
            (~green (unwrap~pointer green))
            (~blue (unwrap~pointer blue))
            (~alpha (unwrap~pointer alpha)))
        (~f ~pattern ~red ~green ~blue ~alpha)))))
(export cairo_pattern_get_rgba)

;; cairo_status_t cairo_pattern_get_surface(cairo_pattern_t *pattern, 
;;     cairo_surface_t **surface);
(if echo-decls (display "cairo_pattern_get_surface\n"))
(define cairo_pattern_get_surface
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_surface"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern surface)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~surface (unwrap~pointer surface)))
        (~f ~pattern ~surface)))))
(export cairo_pattern_get_surface)

;; cairo_status_t cairo_pattern_get_color_stop_rgba(cairo_pattern_t *pattern, 
;;     int index, double *offset, double *red, double *green, double *blue, 
;;     double *alpha);
(if echo-decls (display "cairo_pattern_get_color_stop_rgba\n"))
(define cairo_pattern_get_color_stop_rgba
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_color_stop_rgba"
                (dynamic-link))
              (list '* ffi:int '* '* '* '* '*))))
    (lambda (pattern index offset red green blue alpha)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~index (unwrap~fixed index))
            (~offset (unwrap~pointer offset))
            (~red (unwrap~pointer red))
            (~green (unwrap~pointer green))
            (~blue (unwrap~pointer blue))
            (~alpha (unwrap~pointer alpha)))
        (~f ~pattern
            ~index
            ~offset
            ~red
            ~green
            ~blue
            ~alpha)))))
(export cairo_pattern_get_color_stop_rgba)

;; cairo_status_t cairo_pattern_get_color_stop_count(cairo_pattern_t *pattern, 
;;     int *count);
(if echo-decls (display "cairo_pattern_get_color_stop_count\n"))
(define cairo_pattern_get_color_stop_count
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_color_stop_count"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern count)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~count (unwrap~pointer count)))
        (~f ~pattern ~count)))))
(export cairo_pattern_get_color_stop_count)

;; cairo_status_t cairo_pattern_get_linear_points(cairo_pattern_t *pattern, 
;;     double *x0, double *y0, double *x1, double *y1);
(if echo-decls (display "cairo_pattern_get_linear_points\n"))
(define cairo_pattern_get_linear_points
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_linear_points"
                (dynamic-link))
              (list '* '* '* '* '*))))
    (lambda (pattern x0 y0 x1 y1)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~x0 (unwrap~pointer x0))
            (~y0 (unwrap~pointer y0))
            (~x1 (unwrap~pointer x1))
            (~y1 (unwrap~pointer y1)))
        (~f ~pattern ~x0 ~y0 ~x1 ~y1)))))
(export cairo_pattern_get_linear_points)

;; cairo_status_t cairo_pattern_get_radial_circles(cairo_pattern_t *pattern, 
;;     double *x0, double *y0, double *r0, double *x1, double *y1, double *r1)
;;     ;
(if echo-decls (display "cairo_pattern_get_radial_circles\n"))
(define cairo_pattern_get_radial_circles
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_pattern_get_radial_circles"
                (dynamic-link))
              (list '* '* '* '* '* '* '*))))
    (lambda (pattern x0 y0 r0 x1 y1 r1)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~x0 (unwrap~pointer x0))
            (~y0 (unwrap~pointer y0))
            (~r0 (unwrap~pointer r0))
            (~x1 (unwrap~pointer x1))
            (~y1 (unwrap~pointer y1))
            (~r1 (unwrap~pointer r1)))
        (~f ~pattern ~x0 ~y0 ~r0 ~x1 ~y1 ~r1)))))
(export cairo_pattern_get_radial_circles)

;; cairo_status_t cairo_mesh_pattern_get_patch_count(cairo_pattern_t *pattern, 
;;     unsigned int *count);
(if echo-decls (display "cairo_mesh_pattern_get_patch_count\n"))
(define cairo_mesh_pattern_get_patch_count
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_mesh_pattern_get_patch_count"
                (dynamic-link))
              (list '* '*))))
    (lambda (pattern count)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~count (unwrap~pointer count)))
        (~f ~pattern ~count)))))
(export cairo_mesh_pattern_get_patch_count)

;; cairo_path_t *cairo_mesh_pattern_get_path(cairo_pattern_t *pattern, 
;;     unsigned int patch_num);
(if echo-decls (display "cairo_mesh_pattern_get_path\n"))
(define cairo_mesh_pattern_get_path
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_mesh_pattern_get_path"
                (dynamic-link))
              (list '* ffi:unsigned-int))))
    (lambda (pattern patch_num)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~patch_num (unwrap~fixed patch_num)))
        (wrap-cairo_path_t* (~f ~pattern ~patch_num))))))
(export cairo_mesh_pattern_get_path)

;; cairo_status_t cairo_mesh_pattern_get_corner_color_rgba(cairo_pattern_t *
;;     pattern, unsigned int patch_num, unsigned int corner_num, double *red, 
;;     double *green, double *blue, double *alpha);
(if echo-decls (display "cairo_mesh_pattern_get_corner_color_rgba\n"))
(define cairo_mesh_pattern_get_corner_color_rgba
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_mesh_pattern_get_corner_color_rgba"
                (dynamic-link))
              (list '*
                    ffi:unsigned-int
                    ffi:unsigned-int
                    '*
                    '*
                    '*
                    '*))))
    (lambda (pattern
             patch_num
             corner_num
             red
             green
             blue
             alpha)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~patch_num (unwrap~fixed patch_num))
            (~corner_num (unwrap~fixed corner_num))
            (~red (unwrap~pointer red))
            (~green (unwrap~pointer green))
            (~blue (unwrap~pointer blue))
            (~alpha (unwrap~pointer alpha)))
        (~f ~pattern
            ~patch_num
            ~corner_num
            ~red
            ~green
            ~blue
            ~alpha)))))
(export cairo_mesh_pattern_get_corner_color_rgba)

;; cairo_status_t cairo_mesh_pattern_get_control_point(cairo_pattern_t *pattern
;;     , unsigned int patch_num, unsigned int point_num, double *x, double *y)
;;     ;
(if echo-decls (display "cairo_mesh_pattern_get_control_point\n"))
(define cairo_mesh_pattern_get_control_point
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_mesh_pattern_get_control_point"
                (dynamic-link))
              (list '* ffi:unsigned-int ffi:unsigned-int '* '*))))
    (lambda (pattern patch_num point_num x y)
      (let ((~pattern (unwrap-cairo_pattern_t* pattern))
            (~patch_num (unwrap~fixed patch_num))
            (~point_num (unwrap~fixed point_num))
            (~x (unwrap~pointer x))
            (~y (unwrap~pointer y)))
        (~f ~pattern ~patch_num ~point_num ~x ~y)))))
(export cairo_mesh_pattern_get_control_point)

;; void cairo_matrix_init(cairo_matrix_t *matrix, double xx, double yx, double 
;;     xy, double yy, double x0, double y0);
(if echo-decls (display "cairo_matrix_init\n"))
(define cairo_matrix_init
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "cairo_matrix_init" (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double
                    ffi:double))))
    (lambda (matrix xx yx xy yy x0 y0)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~xx (unwrap~float xx))
            (~yx (unwrap~float yx))
            (~xy (unwrap~float xy))
            (~yy (unwrap~float yy))
            (~x0 (unwrap~float x0))
            (~y0 (unwrap~float y0)))
        (~f ~matrix ~xx ~yx ~xy ~yy ~x0 ~y0)))))
(export cairo_matrix_init)

;; void cairo_matrix_init_identity(cairo_matrix_t *matrix);
(if echo-decls (display "cairo_matrix_init_identity\n"))
(define cairo_matrix_init_identity
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_init_identity"
                (dynamic-link))
              (list '*))))
    (lambda (matrix)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~matrix)))))
(export cairo_matrix_init_identity)

;; void cairo_matrix_init_translate(cairo_matrix_t *matrix, double tx, double 
;;     ty);
(if echo-decls (display "cairo_matrix_init_translate\n"))
(define cairo_matrix_init_translate
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_init_translate"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (matrix tx ty)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~tx (unwrap~float tx))
            (~ty (unwrap~float ty)))
        (~f ~matrix ~tx ~ty)))))
(export cairo_matrix_init_translate)

;; void cairo_matrix_init_scale(cairo_matrix_t *matrix, double sx, double sy);
(if echo-decls (display "cairo_matrix_init_scale\n"))
(define cairo_matrix_init_scale
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_init_scale"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (matrix sx sy)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~sx (unwrap~float sx))
            (~sy (unwrap~float sy)))
        (~f ~matrix ~sx ~sy)))))
(export cairo_matrix_init_scale)

;; void cairo_matrix_init_rotate(cairo_matrix_t *matrix, double radians);
(if echo-decls (display "cairo_matrix_init_rotate\n"))
(define cairo_matrix_init_rotate
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_init_rotate"
                (dynamic-link))
              (list '* ffi:double))))
    (lambda (matrix radians)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~radians (unwrap~float radians)))
        (~f ~matrix ~radians)))))
(export cairo_matrix_init_rotate)

;; void cairo_matrix_translate(cairo_matrix_t *matrix, double tx, double ty);
(if echo-decls (display "cairo_matrix_translate\n"))
(define cairo_matrix_translate
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_translate"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (matrix tx ty)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~tx (unwrap~float tx))
            (~ty (unwrap~float ty)))
        (~f ~matrix ~tx ~ty)))))
(export cairo_matrix_translate)

;; void cairo_matrix_scale(cairo_matrix_t *matrix, double sx, double sy);
(if echo-decls (display "cairo_matrix_scale\n"))
(define cairo_matrix_scale
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_scale"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (matrix sx sy)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~sx (unwrap~float sx))
            (~sy (unwrap~float sy)))
        (~f ~matrix ~sx ~sy)))))
(export cairo_matrix_scale)

;; void cairo_matrix_rotate(cairo_matrix_t *matrix, double radians);
(if echo-decls (display "cairo_matrix_rotate\n"))
(define cairo_matrix_rotate
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_rotate"
                (dynamic-link))
              (list '* ffi:double))))
    (lambda (matrix radians)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~radians (unwrap~float radians)))
        (~f ~matrix ~radians)))))
(export cairo_matrix_rotate)

;; cairo_status_t cairo_matrix_invert(cairo_matrix_t *matrix);
(if echo-decls (display "cairo_matrix_invert\n"))
(define cairo_matrix_invert
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_matrix_invert"
                (dynamic-link))
              (list '*))))
    (lambda (matrix)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix)))
        (~f ~matrix)))))
(export cairo_matrix_invert)

;; void cairo_matrix_multiply(cairo_matrix_t *result, const cairo_matrix_t *a, 
;;     const cairo_matrix_t *b);
(if echo-decls (display "cairo_matrix_multiply\n"))
(define cairo_matrix_multiply
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_multiply"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (result a b)
      (let ((~result (unwrap-cairo_matrix_t* result))
            (~a (unwrap-cairo_matrix_t* a))
            (~b (unwrap-cairo_matrix_t* b)))
        (~f ~result ~a ~b)))))
(export cairo_matrix_multiply)

;; void cairo_matrix_transform_distance(const cairo_matrix_t *matrix, double *
;;     dx, double *dy);
(if echo-decls (display "cairo_matrix_transform_distance\n"))
(define cairo_matrix_transform_distance
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_transform_distance"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (matrix dx dy)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~dx (unwrap~pointer dx))
            (~dy (unwrap~pointer dy)))
        (~f ~matrix ~dx ~dy)))))
(export cairo_matrix_transform_distance)

;; void cairo_matrix_transform_point(const cairo_matrix_t *matrix, double *x, 
;;     double *y);
(if echo-decls (display "cairo_matrix_transform_point\n"))
(define cairo_matrix_transform_point
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_matrix_transform_point"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (matrix x y)
      (let ((~matrix (unwrap-cairo_matrix_t* matrix))
            (~x (unwrap~pointer x))
            (~y (unwrap~pointer y)))
        (~f ~matrix ~x ~y)))))
(export cairo_matrix_transform_point)

;; typedef struct _cairo_region cairo_region_t;
(if echo-decls (display "cairo_region_t\n"))
(define cairo_region_t-desc void)
(define cairo_region_t*-desc (bs:pointer cairo_region_t-desc))
(define-fh-pointer-type cairo_region_t* cairo_region_t*-desc)

;; typedef enum _cairo_region_overlap {
;;   CAIRO_REGION_OVERLAP_IN,
;;   CAIRO_REGION_OVERLAP_OUT,
;;   CAIRO_REGION_OVERLAP_PART,
;; } cairo_region_overlap_t;
(if echo-decls (display "cairo_region_overlap_t\n"))
(define-fh-enum cairo_region_overlap_t
  '((CAIRO_REGION_OVERLAP_IN . 0)
    (CAIRO_REGION_OVERLAP_OUT . 1)
    (CAIRO_REGION_OVERLAP_PART . 2))
  )
(define unwrap-enum-_cairo_region_overlap unwrap-cairo_region_overlap_t)
(define wrap-enum-_cairo_region_overlap wrap-cairo_region_overlap_t)

;; cairo_region_t *cairo_region_create(void);
(if echo-decls (display "cairo_region_create\n"))
(define cairo_region_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_region_create"
                (dynamic-link))
              (list))))
    (lambda () (let () (wrap-cairo_region_t* (~f))))))
(export cairo_region_create)

;; cairo_region_t *cairo_region_create_rectangle(const cairo_rectangle_int_t *
;;     rectangle);
(if echo-decls (display "cairo_region_create_rectangle\n"))
(define cairo_region_create_rectangle
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_region_create_rectangle"
                (dynamic-link))
              (list '*))))
    (lambda (rectangle)
      (let ((~rectangle
              (unwrap-cairo_rectangle_int_t* rectangle)))
        (wrap-cairo_region_t* (~f ~rectangle))))))
(export cairo_region_create_rectangle)

;; cairo_region_t *cairo_region_create_rectangles(const cairo_rectangle_int_t *
;;     rects, int count);
(if echo-decls (display "cairo_region_create_rectangles\n"))
(define cairo_region_create_rectangles
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_region_create_rectangles"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (rects count)
      (let ((~rects (unwrap-cairo_rectangle_int_t* rects))
            (~count (unwrap~fixed count)))
        (wrap-cairo_region_t* (~f ~rects ~count))))))
(export cairo_region_create_rectangles)

;; cairo_region_t *cairo_region_copy(const cairo_region_t *original);
(if echo-decls (display "cairo_region_copy\n"))
(define cairo_region_copy
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "cairo_region_copy" (dynamic-link))
              (list '*))))
    (lambda (original)
      (let ((~original (unwrap-cairo_region_t* original)))
        (wrap-cairo_region_t* (~f ~original))))))
(export cairo_region_copy)

;; cairo_region_t *cairo_region_reference(cairo_region_t *region);
(if echo-decls (display "cairo_region_reference\n"))
(define cairo_region_reference
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_region_reference"
                (dynamic-link))
              (list '*))))
    (lambda (region)
      (let ((~region (unwrap-cairo_region_t* region)))
        (wrap-cairo_region_t* (~f ~region))))))
(export cairo_region_reference)

;; void cairo_region_destroy(cairo_region_t *region);
(if echo-decls (display "cairo_region_destroy\n"))
(define cairo_region_destroy
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_region_destroy"
                (dynamic-link))
              (list '*))))
    (lambda (region)
      (let ((~region (unwrap-cairo_region_t* region)))
        (~f ~region)))))
(export cairo_region_destroy)

;; cairo_bool_t cairo_region_equal(const cairo_region_t *a, const 
;;     cairo_region_t *b);
(if echo-decls (display "cairo_region_equal\n"))
(define cairo_region_equal
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_equal"
                (dynamic-link))
              (list '* '*))))
    (lambda (a b)
      (let ((~a (unwrap-cairo_region_t* a))
            (~b (unwrap-cairo_region_t* b)))
        (wrap-cairo_bool_t (~f ~a ~b))))))
(export cairo_region_equal)

;; cairo_status_t cairo_region_status(const cairo_region_t *region);
(if echo-decls (display "cairo_region_status\n"))
(define cairo_region_status
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_status"
                (dynamic-link))
              (list '*))))
    (lambda (region)
      (let ((~region (unwrap-cairo_region_t* region)))
        (~f ~region)))))
(export cairo_region_status)

;; void cairo_region_get_extents(const cairo_region_t *region, 
;;     cairo_rectangle_int_t *extents);
(if echo-decls (display "cairo_region_get_extents\n"))
(define cairo_region_get_extents
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_region_get_extents"
                (dynamic-link))
              (list '* '*))))
    (lambda (region extents)
      (let ((~region (unwrap-cairo_region_t* region))
            (~extents
              (unwrap-cairo_rectangle_int_t* extents)))
        (~f ~region ~extents)))))
(export cairo_region_get_extents)

;; int cairo_region_num_rectangles(const cairo_region_t *region);
(if echo-decls (display "cairo_region_num_rectangles\n"))
(define cairo_region_num_rectangles
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_num_rectangles"
                (dynamic-link))
              (list '*))))
    (lambda (region)
      (let ((~region (unwrap-cairo_region_t* region)))
        (~f ~region)))))
(export cairo_region_num_rectangles)

;; void cairo_region_get_rectangle(const cairo_region_t *region, int nth, 
;;     cairo_rectangle_int_t *rectangle);
(if echo-decls (display "cairo_region_get_rectangle\n"))
(define cairo_region_get_rectangle
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_region_get_rectangle"
                (dynamic-link))
              (list '* ffi:int '*))))
    (lambda (region nth rectangle)
      (let ((~region (unwrap-cairo_region_t* region))
            (~nth (unwrap~fixed nth))
            (~rectangle
              (unwrap-cairo_rectangle_int_t* rectangle)))
        (~f ~region ~nth ~rectangle)))))
(export cairo_region_get_rectangle)

;; cairo_bool_t cairo_region_is_empty(const cairo_region_t *region);
(if echo-decls (display "cairo_region_is_empty\n"))
(define cairo_region_is_empty
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_is_empty"
                (dynamic-link))
              (list '*))))
    (lambda (region)
      (let ((~region (unwrap-cairo_region_t* region)))
        (wrap-cairo_bool_t (~f ~region))))))
(export cairo_region_is_empty)

;; cairo_region_overlap_t cairo_region_contains_rectangle(const cairo_region_t 
;;     *region, const cairo_rectangle_int_t *rectangle);
(if echo-decls (display "cairo_region_contains_rectangle\n"))
(define cairo_region_contains_rectangle
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_contains_rectangle"
                (dynamic-link))
              (list '* '*))))
    (lambda (region rectangle)
      (let ((~region (unwrap-cairo_region_t* region))
            (~rectangle
              (unwrap-cairo_rectangle_int_t* rectangle)))
        (~f ~region ~rectangle)))))
(export cairo_region_contains_rectangle)

;; cairo_bool_t cairo_region_contains_point(const cairo_region_t *region, int x
;;     , int y);
(if echo-decls (display "cairo_region_contains_point\n"))
(define cairo_region_contains_point
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_contains_point"
                (dynamic-link))
              (list '* ffi:int ffi:int))))
    (lambda (region x y)
      (let ((~region (unwrap-cairo_region_t* region))
            (~x (unwrap~fixed x))
            (~y (unwrap~fixed y)))
        (wrap-cairo_bool_t (~f ~region ~x ~y))))))
(export cairo_region_contains_point)

;; void cairo_region_translate(cairo_region_t *region, int dx, int dy);
(if echo-decls (display "cairo_region_translate\n"))
(define cairo_region_translate
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_region_translate"
                (dynamic-link))
              (list '* ffi:int ffi:int))))
    (lambda (region dx dy)
      (let ((~region (unwrap-cairo_region_t* region))
            (~dx (unwrap~fixed dx))
            (~dy (unwrap~fixed dy)))
        (~f ~region ~dx ~dy)))))
(export cairo_region_translate)

;; cairo_status_t cairo_region_subtract(cairo_region_t *dst, const 
;;     cairo_region_t *other);
(if echo-decls (display "cairo_region_subtract\n"))
(define cairo_region_subtract
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_subtract"
                (dynamic-link))
              (list '* '*))))
    (lambda (dst other)
      (let ((~dst (unwrap-cairo_region_t* dst))
            (~other (unwrap-cairo_region_t* other)))
        (~f ~dst ~other)))))
(export cairo_region_subtract)

;; cairo_status_t cairo_region_subtract_rectangle(cairo_region_t *dst, const 
;;     cairo_rectangle_int_t *rectangle);
(if echo-decls (display "cairo_region_subtract_rectangle\n"))
(define cairo_region_subtract_rectangle
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_subtract_rectangle"
                (dynamic-link))
              (list '* '*))))
    (lambda (dst rectangle)
      (let ((~dst (unwrap-cairo_region_t* dst))
            (~rectangle
              (unwrap-cairo_rectangle_int_t* rectangle)))
        (~f ~dst ~rectangle)))))
(export cairo_region_subtract_rectangle)

;; cairo_status_t cairo_region_intersect(cairo_region_t *dst, const 
;;     cairo_region_t *other);
(if echo-decls (display "cairo_region_intersect\n"))
(define cairo_region_intersect
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_intersect"
                (dynamic-link))
              (list '* '*))))
    (lambda (dst other)
      (let ((~dst (unwrap-cairo_region_t* dst))
            (~other (unwrap-cairo_region_t* other)))
        (~f ~dst ~other)))))
(export cairo_region_intersect)

;; cairo_status_t cairo_region_intersect_rectangle(cairo_region_t *dst, const 
;;     cairo_rectangle_int_t *rectangle);
(if echo-decls (display "cairo_region_intersect_rectangle\n"))
(define cairo_region_intersect_rectangle
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_intersect_rectangle"
                (dynamic-link))
              (list '* '*))))
    (lambda (dst rectangle)
      (let ((~dst (unwrap-cairo_region_t* dst))
            (~rectangle
              (unwrap-cairo_rectangle_int_t* rectangle)))
        (~f ~dst ~rectangle)))))
(export cairo_region_intersect_rectangle)

;; cairo_status_t cairo_region_union(cairo_region_t *dst, const cairo_region_t 
;;     *other);
(if echo-decls (display "cairo_region_union\n"))
(define cairo_region_union
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_union"
                (dynamic-link))
              (list '* '*))))
    (lambda (dst other)
      (let ((~dst (unwrap-cairo_region_t* dst))
            (~other (unwrap-cairo_region_t* other)))
        (~f ~dst ~other)))))
(export cairo_region_union)

;; cairo_status_t cairo_region_union_rectangle(cairo_region_t *dst, const 
;;     cairo_rectangle_int_t *rectangle);
(if echo-decls (display "cairo_region_union_rectangle\n"))
(define cairo_region_union_rectangle
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_union_rectangle"
                (dynamic-link))
              (list '* '*))))
    (lambda (dst rectangle)
      (let ((~dst (unwrap-cairo_region_t* dst))
            (~rectangle
              (unwrap-cairo_rectangle_int_t* rectangle)))
        (~f ~dst ~rectangle)))))
(export cairo_region_union_rectangle)

;; cairo_status_t cairo_region_xor(cairo_region_t *dst, const cairo_region_t *
;;     other);
(if echo-decls (display "cairo_region_xor\n"))
(define cairo_region_xor
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "cairo_region_xor" (dynamic-link))
              (list '* '*))))
    (lambda (dst other)
      (let ((~dst (unwrap-cairo_region_t* dst))
            (~other (unwrap-cairo_region_t* other)))
        (~f ~dst ~other)))))
(export cairo_region_xor)

;; cairo_status_t cairo_region_xor_rectangle(cairo_region_t *dst, const 
;;     cairo_rectangle_int_t *rectangle);
(if echo-decls (display "cairo_region_xor_rectangle\n"))
(define cairo_region_xor_rectangle
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "cairo_region_xor_rectangle"
                (dynamic-link))
              (list '* '*))))
    (lambda (dst rectangle)
      (let ((~dst (unwrap-cairo_region_t* dst))
            (~rectangle
              (unwrap-cairo_rectangle_int_t* rectangle)))
        (~f ~dst ~rectangle)))))
(export cairo_region_xor_rectangle)

;; void cairo_debug_reset_static_data(void);
(if echo-decls (display "cairo_debug_reset_static_data\n"))
(define cairo_debug_reset_static_data
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_debug_reset_static_data"
                (dynamic-link))
              (list))))
    (lambda () (let () (~f)))))
(export cairo_debug_reset_static_data)

;; typedef enum _cairo_pdf_version {
;;   CAIRO_PDF_VERSION_1_4,
;;   CAIRO_PDF_VERSION_1_5,
;; } cairo_pdf_version_t;
(if echo-decls (display "cairo_pdf_version_t\n"))
(define-fh-enum cairo_pdf_version_t
  '((CAIRO_PDF_VERSION_1_4 . 0)
    (CAIRO_PDF_VERSION_1_5 . 1))
  )
(define unwrap-enum-_cairo_pdf_version unwrap-cairo_pdf_version_t)
(define wrap-enum-_cairo_pdf_version wrap-cairo_pdf_version_t)

;; cairo_surface_t *cairo_pdf_surface_create(const char *filename, double 
;;     width_in_points, double height_in_points);
(if echo-decls (display "cairo_pdf_surface_create\n"))
(define cairo_pdf_surface_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pdf_surface_create"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (filename width_in_points height_in_points)
      (let ((~filename (unwrap~pointer filename))
            (~width_in_points (unwrap~float width_in_points))
            (~height_in_points
              (unwrap~float height_in_points)))
        (wrap-cairo_surface_t*
          (~f ~filename ~width_in_points ~height_in_points))))))
(export cairo_pdf_surface_create)

;; cairo_surface_t *cairo_pdf_surface_create_for_stream(cairo_write_func_t 
;;     write_func, void *closure, double width_in_points, double 
;;     height_in_points);
(if echo-decls (display "cairo_pdf_surface_create_for_stream\n"))
(define cairo_pdf_surface_create_for_stream
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pdf_surface_create_for_stream"
                (dynamic-link))
              (list '* '* ffi:double ffi:double))))
    (lambda (write_func
             closure
             width_in_points
             height_in_points)
      (let ((~write_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* '* ffi:unsigned-int))
               write_func))
            (~closure (unwrap~pointer closure))
            (~width_in_points (unwrap~float width_in_points))
            (~height_in_points
              (unwrap~float height_in_points)))
        (wrap-cairo_surface_t*
          (~f ~write_func
              ~closure
              ~width_in_points
              ~height_in_points))))))
(export cairo_pdf_surface_create_for_stream)

;; void cairo_pdf_surface_restrict_to_version(cairo_surface_t *surface, 
;;     cairo_pdf_version_t version);
(if echo-decls (display "cairo_pdf_surface_restrict_to_version\n"))
(define cairo_pdf_surface_restrict_to_version
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pdf_surface_restrict_to_version"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (surface version)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~version (unwrap~fixed version)))
        (~f ~surface ~version)))))
(export cairo_pdf_surface_restrict_to_version)

;; void cairo_pdf_get_versions(cairo_pdf_version_t const **versions, int *
;;     num_versions);
(if echo-decls (display "cairo_pdf_get_versions\n"))
(define cairo_pdf_get_versions
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pdf_get_versions"
                (dynamic-link))
              (list '* '*))))
    (lambda (versions num_versions)
      (let ((~versions (unwrap~pointer versions))
            (~num_versions (unwrap~pointer num_versions)))
        (~f ~versions ~num_versions)))))
(export cairo_pdf_get_versions)

;; const char *cairo_pdf_version_to_string(cairo_pdf_version_t version);
(if echo-decls (display "cairo_pdf_version_to_string\n"))
(define cairo_pdf_version_to_string
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_pdf_version_to_string"
                (dynamic-link))
              (list ffi:int))))
    (lambda (version)
      (let ((~version (unwrap~fixed version)))
        (~f ~version)))))
(export cairo_pdf_version_to_string)

;; void cairo_pdf_surface_set_size(cairo_surface_t *surface, double 
;;     width_in_points, double height_in_points);
(if echo-decls (display "cairo_pdf_surface_set_size\n"))
(define cairo_pdf_surface_set_size
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_pdf_surface_set_size"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (surface width_in_points height_in_points)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~width_in_points (unwrap~float width_in_points))
            (~height_in_points
              (unwrap~float height_in_points)))
        (~f ~surface ~width_in_points ~height_in_points)))))
(export cairo_pdf_surface_set_size)

;; typedef enum _cairo_svg_version {
;;   CAIRO_SVG_VERSION_1_1,
;;   CAIRO_SVG_VERSION_1_2,
;; } cairo_svg_version_t;
(if echo-decls (display "cairo_svg_version_t\n"))
(define-fh-enum cairo_svg_version_t
  '((CAIRO_SVG_VERSION_1_1 . 0)
    (CAIRO_SVG_VERSION_1_2 . 1))
  )
(define unwrap-enum-_cairo_svg_version unwrap-cairo_svg_version_t)
(define wrap-enum-_cairo_svg_version wrap-cairo_svg_version_t)

;; cairo_surface_t *cairo_svg_surface_create(const char *filename, double 
;;     width_in_points, double height_in_points);
(if echo-decls (display "cairo_svg_surface_create\n"))
(define cairo_svg_surface_create
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_svg_surface_create"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (filename width_in_points height_in_points)
      (let ((~filename (unwrap~pointer filename))
            (~width_in_points (unwrap~float width_in_points))
            (~height_in_points
              (unwrap~float height_in_points)))
        (wrap-cairo_surface_t*
          (~f ~filename ~width_in_points ~height_in_points))))))
(export cairo_svg_surface_create)

;; cairo_surface_t *cairo_svg_surface_create_for_stream(cairo_write_func_t 
;;     write_func, void *closure, double width_in_points, double 
;;     height_in_points);
(if echo-decls (display "cairo_svg_surface_create_for_stream\n"))
(define cairo_svg_surface_create_for_stream
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_svg_surface_create_for_stream"
                (dynamic-link))
              (list '* '* ffi:double ffi:double))))
    (lambda (write_func
             closure
             width_in_points
             height_in_points)
      (let ((~write_func
              ((make-ftn-arg-unwrapper
                 ffi:void
                 (list '* '* ffi:unsigned-int))
               write_func))
            (~closure (unwrap~pointer closure))
            (~width_in_points (unwrap~float width_in_points))
            (~height_in_points
              (unwrap~float height_in_points)))
        (wrap-cairo_surface_t*
          (~f ~write_func
              ~closure
              ~width_in_points
              ~height_in_points))))))
(export cairo_svg_surface_create_for_stream)

;; void cairo_svg_surface_restrict_to_version(cairo_surface_t *surface, 
;;     cairo_svg_version_t version);
(if echo-decls (display "cairo_svg_surface_restrict_to_version\n"))
(define cairo_svg_surface_restrict_to_version
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_svg_surface_restrict_to_version"
                (dynamic-link))
              (list '* ffi:int))))
    (lambda (surface version)
      (let ((~surface (unwrap-cairo_surface_t* surface))
            (~version (unwrap~fixed version)))
        (~f ~surface ~version)))))
(export cairo_svg_surface_restrict_to_version)

;; void cairo_svg_get_versions(cairo_svg_version_t const **versions, int *
;;     num_versions);
(if echo-decls (display "cairo_svg_get_versions\n"))
(define cairo_svg_get_versions
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "cairo_svg_get_versions"
                (dynamic-link))
              (list '* '*))))
    (lambda (versions num_versions)
      (let ((~versions (unwrap~pointer versions))
            (~num_versions (unwrap~pointer num_versions)))
        (~f ~versions ~num_versions)))))
(export cairo_svg_get_versions)

;; const char *cairo_svg_version_to_string(cairo_svg_version_t version);
(if echo-decls (display "cairo_svg_version_to_string\n"))
(define cairo_svg_version_to_string
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "cairo_svg_version_to_string"
                (dynamic-link))
              (list ffi:int))))
    (lambda (version)
      (let ((~version (unwrap~fixed version)))
        (~f ~version)))))
(export cairo_svg_version_to_string)

;; access to enum symbols and #define'd constants:
(define cairo-symbol-val
  (let ((sym-tab
          '((CAIRO_STATUS_SUCCESS . 0)
            (CAIRO_STATUS_NO_MEMORY . 1)
            (CAIRO_STATUS_INVALID_RESTORE . 2)
            (CAIRO_STATUS_INVALID_POP_GROUP . 3)
            (CAIRO_STATUS_NO_CURRENT_POINT . 4)
            (CAIRO_STATUS_INVALID_MATRIX . 5)
            (CAIRO_STATUS_INVALID_STATUS . 6)
            (CAIRO_STATUS_NULL_POINTER . 7)
            (CAIRO_STATUS_INVALID_STRING . 8)
            (CAIRO_STATUS_INVALID_PATH_DATA . 9)
            (CAIRO_STATUS_READ_ERROR . 10)
            (CAIRO_STATUS_WRITE_ERROR . 11)
            (CAIRO_STATUS_SURFACE_FINISHED . 12)
            (CAIRO_STATUS_SURFACE_TYPE_MISMATCH . 13)
            (CAIRO_STATUS_PATTERN_TYPE_MISMATCH . 14)
            (CAIRO_STATUS_INVALID_CONTENT . 15)
            (CAIRO_STATUS_INVALID_FORMAT . 16)
            (CAIRO_STATUS_INVALID_VISUAL . 17)
            (CAIRO_STATUS_FILE_NOT_FOUND . 18)
            (CAIRO_STATUS_INVALID_DASH . 19)
            (CAIRO_STATUS_INVALID_DSC_COMMENT . 20)
            (CAIRO_STATUS_INVALID_INDEX . 21)
            (CAIRO_STATUS_CLIP_NOT_REPRESENTABLE . 22)
            (CAIRO_STATUS_TEMP_FILE_ERROR . 23)
            (CAIRO_STATUS_INVALID_STRIDE . 24)
            (CAIRO_STATUS_FONT_TYPE_MISMATCH . 25)
            (CAIRO_STATUS_USER_FONT_IMMUTABLE . 26)
            (CAIRO_STATUS_USER_FONT_ERROR . 27)
            (CAIRO_STATUS_NEGATIVE_COUNT . 28)
            (CAIRO_STATUS_INVALID_CLUSTERS . 29)
            (CAIRO_STATUS_INVALID_SLANT . 30)
            (CAIRO_STATUS_INVALID_WEIGHT . 31)
            (CAIRO_STATUS_INVALID_SIZE . 32)
            (CAIRO_STATUS_USER_FONT_NOT_IMPLEMENTED . 33)
            (CAIRO_STATUS_DEVICE_TYPE_MISMATCH . 34)
            (CAIRO_STATUS_DEVICE_ERROR . 35)
            (CAIRO_STATUS_INVALID_MESH_CONSTRUCTION . 36)
            (CAIRO_STATUS_DEVICE_FINISHED . 37)
            (CAIRO_STATUS_JBIG2_GLOBAL_MISSING . 38)
            (CAIRO_STATUS_LAST_STATUS . 39)
            (CAIRO_CONTENT_COLOR . 4096)
            (CAIRO_CONTENT_ALPHA . 8192)
            (CAIRO_CONTENT_COLOR_ALPHA . 12288)
            (CAIRO_FORMAT_INVALID . -1)
            (CAIRO_FORMAT_ARGB32 . 0)
            (CAIRO_FORMAT_RGB24 . 1)
            (CAIRO_FORMAT_A8 . 2)
            (CAIRO_FORMAT_A1 . 3)
            (CAIRO_FORMAT_RGB16_565 . 4)
            (CAIRO_FORMAT_RGB30 . 5)
            (CAIRO_OPERATOR_CLEAR . 0)
            (CAIRO_OPERATOR_SOURCE . 1)
            (CAIRO_OPERATOR_OVER . 2)
            (CAIRO_OPERATOR_IN . 3)
            (CAIRO_OPERATOR_OUT . 4)
            (CAIRO_OPERATOR_ATOP . 5)
            (CAIRO_OPERATOR_DEST . 6)
            (CAIRO_OPERATOR_DEST_OVER . 7)
            (CAIRO_OPERATOR_DEST_IN . 8)
            (CAIRO_OPERATOR_DEST_OUT . 9)
            (CAIRO_OPERATOR_DEST_ATOP . 10)
            (CAIRO_OPERATOR_XOR . 11)
            (CAIRO_OPERATOR_ADD . 12)
            (CAIRO_OPERATOR_SATURATE . 13)
            (CAIRO_OPERATOR_MULTIPLY . 14)
            (CAIRO_OPERATOR_SCREEN . 15)
            (CAIRO_OPERATOR_OVERLAY . 16)
            (CAIRO_OPERATOR_DARKEN . 17)
            (CAIRO_OPERATOR_LIGHTEN . 18)
            (CAIRO_OPERATOR_COLOR_DODGE . 19)
            (CAIRO_OPERATOR_COLOR_BURN . 20)
            (CAIRO_OPERATOR_HARD_LIGHT . 21)
            (CAIRO_OPERATOR_SOFT_LIGHT . 22)
            (CAIRO_OPERATOR_DIFFERENCE . 23)
            (CAIRO_OPERATOR_EXCLUSION . 24)
            (CAIRO_OPERATOR_HSL_HUE . 25)
            (CAIRO_OPERATOR_HSL_SATURATION . 26)
            (CAIRO_OPERATOR_HSL_COLOR . 27)
            (CAIRO_OPERATOR_HSL_LUMINOSITY . 28)
            (CAIRO_ANTIALIAS_DEFAULT . 0)
            (CAIRO_ANTIALIAS_NONE . 1)
            (CAIRO_ANTIALIAS_GRAY . 2)
            (CAIRO_ANTIALIAS_SUBPIXEL . 3)
            (CAIRO_ANTIALIAS_FAST . 4)
            (CAIRO_ANTIALIAS_GOOD . 5)
            (CAIRO_ANTIALIAS_BEST . 6)
            (CAIRO_FILL_RULE_WINDING . 0)
            (CAIRO_FILL_RULE_EVEN_ODD . 1)
            (CAIRO_LINE_CAP_BUTT . 0)
            (CAIRO_LINE_CAP_ROUND . 1)
            (CAIRO_LINE_CAP_SQUARE . 2)
            (CAIRO_LINE_JOIN_MITER . 0)
            (CAIRO_LINE_JOIN_ROUND . 1)
            (CAIRO_LINE_JOIN_BEVEL . 2)
            (CAIRO_TEXT_CLUSTER_FLAG_BACKWARD . 1)
            (CAIRO_FONT_SLANT_NORMAL . 0)
            (CAIRO_FONT_SLANT_ITALIC . 1)
            (CAIRO_FONT_SLANT_OBLIQUE . 2)
            (CAIRO_FONT_WEIGHT_NORMAL . 0)
            (CAIRO_FONT_WEIGHT_BOLD . 1)
            (CAIRO_SUBPIXEL_ORDER_DEFAULT . 0)
            (CAIRO_SUBPIXEL_ORDER_RGB . 1)
            (CAIRO_SUBPIXEL_ORDER_BGR . 2)
            (CAIRO_SUBPIXEL_ORDER_VRGB . 3)
            (CAIRO_SUBPIXEL_ORDER_VBGR . 4)
            (CAIRO_HINT_STYLE_DEFAULT . 0)
            (CAIRO_HINT_STYLE_NONE . 1)
            (CAIRO_HINT_STYLE_SLIGHT . 2)
            (CAIRO_HINT_STYLE_MEDIUM . 3)
            (CAIRO_HINT_STYLE_FULL . 4)
            (CAIRO_HINT_METRICS_DEFAULT . 0)
            (CAIRO_HINT_METRICS_OFF . 1)
            (CAIRO_HINT_METRICS_ON . 2)
            (CAIRO_FONT_TYPE_TOY . 0)
            (CAIRO_FONT_TYPE_FT . 1)
            (CAIRO_FONT_TYPE_WIN32 . 2)
            (CAIRO_FONT_TYPE_QUARTZ . 3)
            (CAIRO_FONT_TYPE_USER . 4)
            (CAIRO_PATH_MOVE_TO . 0)
            (CAIRO_PATH_LINE_TO . 1)
            (CAIRO_PATH_CURVE_TO . 2)
            (CAIRO_PATH_CLOSE_PATH . 3)
            (CAIRO_DEVICE_TYPE_DRM . 0)
            (CAIRO_DEVICE_TYPE_GL . 1)
            (CAIRO_DEVICE_TYPE_SCRIPT . 2)
            (CAIRO_DEVICE_TYPE_XCB . 3)
            (CAIRO_DEVICE_TYPE_XLIB . 4)
            (CAIRO_DEVICE_TYPE_XML . 5)
            (CAIRO_DEVICE_TYPE_COGL . 6)
            (CAIRO_DEVICE_TYPE_WIN32 . 7)
            (CAIRO_DEVICE_TYPE_INVALID . -1)
            (CAIRO_SURFACE_OBSERVER_NORMAL . 0)
            (CAIRO_SURFACE_OBSERVER_RECORD_OPERATIONS . 1)
            (CAIRO_SURFACE_TYPE_IMAGE . 0)
            (CAIRO_SURFACE_TYPE_PDF . 1)
            (CAIRO_SURFACE_TYPE_PS . 2)
            (CAIRO_SURFACE_TYPE_XLIB . 3)
            (CAIRO_SURFACE_TYPE_XCB . 4)
            (CAIRO_SURFACE_TYPE_GLITZ . 5)
            (CAIRO_SURFACE_TYPE_QUARTZ . 6)
            (CAIRO_SURFACE_TYPE_WIN32 . 7)
            (CAIRO_SURFACE_TYPE_BEOS . 8)
            (CAIRO_SURFACE_TYPE_DIRECTFB . 9)
            (CAIRO_SURFACE_TYPE_SVG . 10)
            (CAIRO_SURFACE_TYPE_OS2 . 11)
            (CAIRO_SURFACE_TYPE_WIN32_PRINTING . 12)
            (CAIRO_SURFACE_TYPE_QUARTZ_IMAGE . 13)
            (CAIRO_SURFACE_TYPE_SCRIPT . 14)
            (CAIRO_SURFACE_TYPE_QT . 15)
            (CAIRO_SURFACE_TYPE_RECORDING . 16)
            (CAIRO_SURFACE_TYPE_VG . 17)
            (CAIRO_SURFACE_TYPE_GL . 18)
            (CAIRO_SURFACE_TYPE_DRM . 19)
            (CAIRO_SURFACE_TYPE_TEE . 20)
            (CAIRO_SURFACE_TYPE_XML . 21)
            (CAIRO_SURFACE_TYPE_SKIA . 22)
            (CAIRO_SURFACE_TYPE_SUBSURFACE . 23)
            (CAIRO_SURFACE_TYPE_COGL . 24)
            (CAIRO_PATTERN_TYPE_SOLID . 0)
            (CAIRO_PATTERN_TYPE_SURFACE . 1)
            (CAIRO_PATTERN_TYPE_LINEAR . 2)
            (CAIRO_PATTERN_TYPE_RADIAL . 3)
            (CAIRO_PATTERN_TYPE_MESH . 4)
            (CAIRO_PATTERN_TYPE_RASTER_SOURCE . 5)
            (CAIRO_EXTEND_NONE . 0)
            (CAIRO_EXTEND_REPEAT . 1)
            (CAIRO_EXTEND_REFLECT . 2)
            (CAIRO_EXTEND_PAD . 3)
            (CAIRO_FILTER_FAST . 0)
            (CAIRO_FILTER_GOOD . 1)
            (CAIRO_FILTER_BEST . 2)
            (CAIRO_FILTER_NEAREST . 3)
            (CAIRO_FILTER_BILINEAR . 4)
            (CAIRO_FILTER_GAUSSIAN . 5)
            (CAIRO_REGION_OVERLAP_IN . 0)
            (CAIRO_REGION_OVERLAP_OUT . 1)
            (CAIRO_REGION_OVERLAP_PART . 2)
            (CAIRO_PDF_VERSION_1_4 . 0)
            (CAIRO_PDF_VERSION_1_5 . 1)
            (CAIRO_SVG_VERSION_1_1 . 0)
            (CAIRO_SVG_VERSION_1_2 . 1)
            (CAIRO_VERSION_STRING . "1.14.10")
            (CAIRO_MIME_TYPE_JPEG . "image/jpeg")
            (CAIRO_MIME_TYPE_PNG . "image/png")
            (CAIRO_MIME_TYPE_JP2 . "image/jp2")
            (CAIRO_MIME_TYPE_URI . "text/x-uri")
            (CAIRO_MIME_TYPE_UNIQUE_ID
              .
              "application/x-cairo.uuid")
            (CAIRO_MIME_TYPE_JBIG2
              .
              "application/x-cairo.jbig2")
            (CAIRO_MIME_TYPE_JBIG2_GLOBAL
              .
              "application/x-cairo.jbig2-global")
            (CAIRO_MIME_TYPE_JBIG2_GLOBAL_ID
              .
              "application/x-cairo.jbig2-global-id"))))
    (lambda (k) (assq-ref sym-tab k))))
(export cairo-symbol-val)

(define (unwrap-enum obj)
  (cond ((number? obj) obj)
        ((symbol? obj) (cairo-symbol-val obj))
        ((fh-object? obj) (struct-ref obj 0))
        (else (error "type mismatch"))))

(define cairo-types
  '("cairo_svg_version_t" "cairo_pdf_version_t" "cairo_region_overlap_t" 
    "cairo_region_t" "cairo_filter_t" "cairo_extend_t" "cairo_pattern_type_t" 
    "cairo_raster_source_finish_func_t" "cairo_raster_source_copy_func_t" 
    "cairo_raster_source_snapshot_func_t" "cairo_raster_source_release_func_t"
    "cairo_raster_source_acquire_func_t" "cairo_surface_type_t" 
    "cairo_surface_observer_callback_t" "cairo_surface_observer_mode_t" 
    "cairo_device_type_t" (struct . "cairo_path") "cairo_path_t" 
    "cairo_path_data_t" "cairo_path_data_type_t" 
    "cairo_user_scaled_font_unicode_to_glyph_func_t" 
    "cairo_user_scaled_font_text_to_glyphs_func_t" 
    "cairo_user_scaled_font_render_glyph_func_t" 
    "cairo_user_scaled_font_init_func_t" "cairo_font_type_t" 
    "cairo_font_options_t" "cairo_hint_metrics_t" "cairo_hint_style_t" 
    "cairo_subpixel_order_t" "cairo_font_weight_t" "cairo_font_slant_t" 
    "cairo_font_extents_t" "cairo_text_extents_t" "cairo_text_cluster_flags_t"
    "cairo_text_cluster_t" "cairo_glyph_t" "cairo_font_face_t" 
    "cairo_scaled_font_t" (struct . "_cairo_rectangle_list") 
    "cairo_rectangle_list_t" (struct . "_cairo_rectangle") "cairo_rectangle_t"
    "cairo_line_join_t" "cairo_line_cap_t" "cairo_fill_rule_t" 
    "cairo_antialias_t" "cairo_operator_t" (struct . "_cairo_rectangle_int") 
    "cairo_rectangle_int_t" "cairo_read_func_t" "cairo_write_func_t" 
    "cairo_format_t" "cairo_content_t" "cairo_status_t" (struct . 
    "_cairo_user_data_key") "cairo_user_data_key_t" "cairo_destroy_func_t" 
    "cairo_pattern_t" (struct . "_cairo_matrix") "cairo_matrix_t" 
    "cairo_device_t" "cairo_surface_t" "cairo_t" "cairo_bool_t"))
;;(export cairo-types)

(define (make-cairo-unit-matrix)
  (make-cairo_matrix_t #(1.0 0.0 0.0 1.0 0.0 0.0)))

;; --- last line ---
