;; auto-generated by ffi-help.scm

(define-module (gdbm)
  #:use-module (system ffi-help-rt)
  #:use-module ((system foreign) #:prefix ffi:)
  #:use-module (bytestructures guile)
  )
(dynamic-link "libgdbm")
(define void intptr_t)
(define echo-decls #f)

;; typedef unsigned long long int gdbm_count_t;
(if echo-decls (display "gdbm_count_t\n"))
(define gdbm_count_t-desc unsigned-long-long)
(define unwrap-gdbm_count_t unwrap~fixed)
(define wrap-gdbm_count_t identity)

;; typedef struct {
;;   char *dptr;
;;   int dsize;
;; } datum;
(if echo-decls (display "datum\n"))
(define datum-desc
  (bs:struct
    (list `(dptr ,(bs:pointer int)) `(dsize ,int))))
(export datum-desc)
(define-fh-compound-type/p datum datum-desc)

;; typedef struct gdbm_file_info *GDBM_FILE;
(if echo-decls (display "GDBM_FILE\n"))
(define-fh-pointer-type GDBM_FILE)

;; extern const char *gdbm_version;
(if echo-decls (display "gdbm_version\n"))
(define gdbm_version (dynamic-pointer "gdbm_version" (dynamic-link)))

;; extern int const gdbm_version_number[3];
(if echo-decls (display "gdbm_version_number\n"))
(define gdbm_version_number
  (let* ((addr (dynamic-pointer
                 "gdbm_version_number"
                 (dynamic-link)))
         (bs* (make-bytestructure
                (ffi:pointer->bytevector addr (sizeof '*))
                0
                (bs:pointer (bs:vector 3 int)))))
    (case-lambda (() (bytestructure-ref bs* '*)))))
(export gdbm_version_number)

;; extern GDBM_FILE gdbm_fd_open(int fd, const char *file_name, int block_size
;;     , int flags, void (*fatal_func)(const char *));
(if echo-decls (display "gdbm_fd_open\n"))
(define gdbm_fd_open
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "gdbm_fd_open" (dynamic-link))
              (list ffi:int '* ffi:int ffi:int '*))))
    (lambda (fd file_name block_size flags fatal_func)
      (let ((~fd (unwrap~fixed fd))
            (~file_name (unwrap~pointer file_name))
            (~block_size (unwrap~fixed block_size))
            (~flags (unwrap~fixed flags))
            (~fatal_func
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               fatal_func)))
        (~f ~fd
            ~file_name
            ~block_size
            ~flags
            ~fatal_func)))))
(export gdbm_fd_open)

;; extern GDBM_FILE gdbm_open(const char *, int, int, int, void (*)(const char 
;;     *));
(if echo-decls (display "gdbm_open\n"))
(define gdbm_open
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "gdbm_open" (dynamic-link))
              (list '* ffi:int ffi:int ffi:int '*))))
    (lambda (@12356 arg-1 arg-2 arg-3 @12355)
      (let ((~@12356 (unwrap~pointer @12356))
            (~arg-1 (unwrap~fixed arg-1))
            (~arg-2 (unwrap~fixed arg-2))
            (~arg-3 (unwrap~fixed arg-3))
            (~@12355
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               @12355)))
        (~f ~@12356 ~arg-1 ~arg-2 ~arg-3 ~@12355)))))
(export gdbm_open)

;; extern void gdbm_close(GDBM_FILE);
(if echo-decls (display "gdbm_close\n"))
(define gdbm_close
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "gdbm_close" (dynamic-link))
              (list '*))))
    (lambda (arg-0)
      (let ((~arg-0 (unwrap~pointer arg-0)))
        (~f ~arg-0)))))
(export gdbm_close)

;; extern int gdbm_store(GDBM_FILE, datum, datum, int);
(if echo-decls (display "gdbm_store\n"))
(define gdbm_store
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_store" (dynamic-link))
              (list '*
                    (list '* ffi:int)
                    (list '* ffi:int)
                    ffi:int))))
    (lambda (arg-0 arg-1 arg-2 arg-3)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~arg-1 (unwrap-datum arg-1))
            (~arg-2 (unwrap-datum arg-2))
            (~arg-3 (unwrap~fixed arg-3)))
        (~f ~arg-0 ~arg-1 ~arg-2 ~arg-3)))))
(export gdbm_store)

;; extern datum gdbm_fetch(GDBM_FILE, datum);
(if echo-decls (display "gdbm_fetch\n"))
(define gdbm_fetch
  (let ((~f (ffi:pointer->procedure
              (list '* ffi:int)
              (dynamic-func "gdbm_fetch" (dynamic-link))
              (list '* (list '* ffi:int)))))
    (lambda (arg-0 arg-1)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~arg-1 (unwrap-datum arg-1)))
        (wrap-datum (~f ~arg-0 ~arg-1))))))
(export gdbm_fetch)

;; extern int gdbm_delete(GDBM_FILE, datum);
(if echo-decls (display "gdbm_delete\n"))
(define gdbm_delete
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_delete" (dynamic-link))
              (list '* (list '* ffi:int)))))
    (lambda (arg-0 arg-1)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~arg-1 (unwrap-datum arg-1)))
        (~f ~arg-0 ~arg-1)))))
(export gdbm_delete)

;; extern datum gdbm_firstkey(GDBM_FILE);
(if echo-decls (display "gdbm_firstkey\n"))
(define gdbm_firstkey
  (let ((~f (ffi:pointer->procedure
              (list '* ffi:int)
              (dynamic-func "gdbm_firstkey" (dynamic-link))
              (list '*))))
    (lambda (arg-0)
      (let ((~arg-0 (unwrap~pointer arg-0)))
        (wrap-datum (~f ~arg-0))))))
(export gdbm_firstkey)

;; extern datum gdbm_nextkey(GDBM_FILE, datum);
(if echo-decls (display "gdbm_nextkey\n"))
(define gdbm_nextkey
  (let ((~f (ffi:pointer->procedure
              (list '* ffi:int)
              (dynamic-func "gdbm_nextkey" (dynamic-link))
              (list '* (list '* ffi:int)))))
    (lambda (arg-0 arg-1)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~arg-1 (unwrap-datum arg-1)))
        (wrap-datum (~f ~arg-0 ~arg-1))))))
(export gdbm_nextkey)

;; extern int gdbm_reorganize(GDBM_FILE);
(if echo-decls (display "gdbm_reorganize\n"))
(define gdbm_reorganize
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_reorganize" (dynamic-link))
              (list '*))))
    (lambda (arg-0)
      (let ((~arg-0 (unwrap~pointer arg-0)))
        (~f ~arg-0)))))
(export gdbm_reorganize)

;; extern void gdbm_sync(GDBM_FILE);
(if echo-decls (display "gdbm_sync\n"))
(define gdbm_sync
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "gdbm_sync" (dynamic-link))
              (list '*))))
    (lambda (arg-0)
      (let ((~arg-0 (unwrap~pointer arg-0)))
        (~f ~arg-0)))))
(export gdbm_sync)

;; extern int gdbm_exists(GDBM_FILE, datum);
(if echo-decls (display "gdbm_exists\n"))
(define gdbm_exists
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_exists" (dynamic-link))
              (list '* (list '* ffi:int)))))
    (lambda (arg-0 arg-1)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~arg-1 (unwrap-datum arg-1)))
        (~f ~arg-0 ~arg-1)))))
(export gdbm_exists)

;; extern int gdbm_setopt(GDBM_FILE, int, void *, int);
(if echo-decls (display "gdbm_setopt\n"))
(define gdbm_setopt
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_setopt" (dynamic-link))
              (list '* ffi:int '* ffi:int))))
    (lambda (arg-0 arg-1 @12357 arg-3)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~arg-1 (unwrap~fixed arg-1))
            (~@12357 (unwrap~pointer @12357))
            (~arg-3 (unwrap~fixed arg-3)))
        (~f ~arg-0 ~arg-1 ~@12357 ~arg-3)))))
(export gdbm_setopt)

;; extern int gdbm_fdesc(GDBM_FILE);
(if echo-decls (display "gdbm_fdesc\n"))
(define gdbm_fdesc
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_fdesc" (dynamic-link))
              (list '*))))
    (lambda (arg-0)
      (let ((~arg-0 (unwrap~pointer arg-0)))
        (~f ~arg-0)))))
(export gdbm_fdesc)

;; extern int gdbm_export(GDBM_FILE, const char *, int, int);
(if echo-decls (display "gdbm_export\n"))
(define gdbm_export
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_export" (dynamic-link))
              (list '* '* ffi:int ffi:int))))
    (lambda (arg-0 @12358 arg-2 arg-3)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~@12358 (unwrap~pointer @12358))
            (~arg-2 (unwrap~fixed arg-2))
            (~arg-3 (unwrap~fixed arg-3)))
        (~f ~arg-0 ~@12358 ~arg-2 ~arg-3)))))
(export gdbm_export)

;; extern int gdbm_export_to_file(GDBM_FILE dbf, FILE *fp);
(if echo-decls (display "gdbm_export_to_file\n"))
(define gdbm_export_to_file
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "gdbm_export_to_file"
                (dynamic-link))
              (list '* '*))))
    (lambda (dbf fp)
      (let ((~dbf (unwrap~pointer dbf))
            (~fp (unwrap~pointer fp)))
        (~f ~dbf ~fp)))))
(export gdbm_export_to_file)

;; extern int gdbm_import(GDBM_FILE, const char *, int);
(if echo-decls (display "gdbm_import\n"))
(define gdbm_import
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_import" (dynamic-link))
              (list '* '* ffi:int))))
    (lambda (arg-0 @12359 arg-2)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~@12359 (unwrap~pointer @12359))
            (~arg-2 (unwrap~fixed arg-2)))
        (~f ~arg-0 ~@12359 ~arg-2)))))
(export gdbm_import)

;; extern int gdbm_import_from_file(GDBM_FILE dbf, FILE *fp, int flag);
(if echo-decls (display "gdbm_import_from_file\n"))
(define gdbm_import_from_file
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "gdbm_import_from_file"
                (dynamic-link))
              (list '* '* ffi:int))))
    (lambda (dbf fp flag)
      (let ((~dbf (unwrap~pointer dbf))
            (~fp (unwrap~pointer fp))
            (~flag (unwrap~fixed flag)))
        (~f ~dbf ~fp ~flag)))))
(export gdbm_import_from_file)

;; extern int gdbm_count(GDBM_FILE dbf, gdbm_count_t *pcount);
(if echo-decls (display "gdbm_count\n"))
(define gdbm_count
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_count" (dynamic-link))
              (list '* '*))))
    (lambda (dbf pcount)
      (let ((~dbf (unwrap~pointer dbf))
            (~pcount (unwrap-gdbm_count_t* pcount)))
        (~f ~dbf ~pcount)))))
(export gdbm_count)

;; typedef struct gdbm_recovery_s {
;;   /* Input members.
;;      These are initialized before call to gdbm_recover.  The flags argument
;;      specifies which of them are initialized. */
;;   void (*errfun)(void *data, char const *fmt, ...);
;;   void *data;
;;   size_t max_failed_keys;
;;   size_t max_failed_buckets;
;;   size_t max_failures;
;;   /* Output members.
;;      The gdbm_recover function fills these before returning. */
;;   size_t recovered_keys;
;;   size_t recovered_buckets;
;;   size_t failed_keys;
;;   size_t failed_buckets;
;;   char *backup_name;
;; } gdbm_recovery;
(if echo-decls (display "gdbm_recovery\n"))
(define gdbm_recovery-desc
  (bs:struct
    (list `(errfun ,(bs:pointer void))
          `(data ,(bs:pointer void))
          `(max_failed_keys ,size_t)
          `(max_failed_buckets ,size_t)
          `(max_failures ,size_t)
          `(recovered_keys ,size_t)
          `(recovered_buckets ,size_t)
          `(failed_keys ,size_t)
          `(failed_buckets ,size_t)
          `(backup_name ,(bs:pointer int)))))
(export gdbm_recovery-desc)
(define-fh-compound-type/p gdbm_recovery gdbm_recovery-desc)
(define struct-gdbm_recovery_s gdbm_recovery)

;; extern int gdbm_recover(GDBM_FILE dbf, gdbm_recovery *rcvr, int flags);
(if echo-decls (display "gdbm_recover\n"))
(define gdbm_recover
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_recover" (dynamic-link))
              (list '* '* ffi:int))))
    (lambda (dbf rcvr flags)
      (let ((~dbf (unwrap~pointer dbf))
            (~rcvr (unwrap-gdbm_recovery* rcvr))
            (~flags (unwrap~fixed flags)))
        (~f ~dbf ~rcvr ~flags)))))
(export gdbm_recover)

;; extern int gdbm_dump(GDBM_FILE, const char *, int fmt, int open_flags, int 
;;     mode);
(if echo-decls (display "gdbm_dump\n"))
(define gdbm_dump
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_dump" (dynamic-link))
              (list '* '* ffi:int ffi:int ffi:int))))
    (lambda (arg-0 @12360 fmt open_flags mode)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~@12360 (unwrap~pointer @12360))
            (~fmt (unwrap~fixed fmt))
            (~open_flags (unwrap~fixed open_flags))
            (~mode (unwrap~fixed mode)))
        (~f ~arg-0 ~@12360 ~fmt ~open_flags ~mode)))))
(export gdbm_dump)

;; extern int gdbm_dump_to_file(GDBM_FILE, FILE *, int fmt);
(if echo-decls (display "gdbm_dump_to_file\n"))
(define gdbm_dump_to_file
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_dump_to_file" (dynamic-link))
              (list '* '* ffi:int))))
    (lambda (arg-0 @12361 fmt)
      (let ((~arg-0 (unwrap~pointer arg-0))
            (~@12361 (unwrap~pointer @12361))
            (~fmt (unwrap~fixed fmt)))
        (~f ~arg-0 ~@12361 ~fmt)))))
(export gdbm_dump_to_file)

;; extern int gdbm_load(GDBM_FILE *, const char *, int replace, int meta_flags
;;     , unsigned long *line);
(if echo-decls (display "gdbm_load\n"))
(define gdbm_load
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_load" (dynamic-link))
              (list '* '* ffi:int ffi:int '*))))
    (lambda (@12363 @12362 replace meta_flags line)
      (let ((~@12363 (unwrap~pointer @12363))
            (~@12362 (unwrap~pointer @12362))
            (~replace (unwrap~fixed replace))
            (~meta_flags (unwrap~fixed meta_flags))
            (~line (unwrap~pointer line)))
        (~f ~@12363 ~@12362 ~replace ~meta_flags ~line)))))
(export gdbm_load)

;; extern int gdbm_load_from_file(GDBM_FILE *, FILE *, int replace, int 
;;     meta_flags, unsigned long *line);
(if echo-decls (display "gdbm_load_from_file\n"))
(define gdbm_load_from_file
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "gdbm_load_from_file"
                (dynamic-link))
              (list '* '* ffi:int ffi:int '*))))
    (lambda (@12365 @12364 replace meta_flags line)
      (let ((~@12365 (unwrap~pointer @12365))
            (~@12364 (unwrap~pointer @12364))
            (~replace (unwrap~fixed replace))
            (~meta_flags (unwrap~fixed meta_flags))
            (~line (unwrap~pointer line)))
        (~f ~@12365 ~@12364 ~replace ~meta_flags ~line)))))
(export gdbm_load_from_file)

;; extern int gdbm_copy_meta(GDBM_FILE dst, GDBM_FILE src);
(if echo-decls (display "gdbm_copy_meta\n"))
(define gdbm_copy_meta
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_copy_meta" (dynamic-link))
              (list '* '*))))
    (lambda (dst src)
      (let ((~dst (unwrap~pointer dst))
            (~src (unwrap~pointer src)))
        (~f ~dst ~src)))))
(export gdbm_copy_meta)

;; typedef int gdbm_error;
(if echo-decls (display "gdbm_error\n"))
(define gdbm_error-desc int)
(define unwrap-gdbm_error unwrap~fixed)
(define wrap-gdbm_error identity)

;; extern gdbm_error gdbm_errno;
(if echo-decls (display "gdbm_errno\n"))
(define gdbm_errno
  (let* ((addr (dynamic-pointer "gdbm_errno" (dynamic-link)))
         (bs* (make-bytestructure
                (ffi:pointer->bytevector addr (sizeof '*))
                0
                (bs:pointer gdbm_error-desc))))
    (case-lambda (() (bytestructure-ref bs* '*)))))
(export gdbm_errno)

;; extern const char *constgdbm_errlist[];
(if echo-decls (display "gdbm_errlist\n"))
(define gdbm_errlist
  (let* ((addr (dynamic-pointer "gdbm_errlist" (dynamic-link)))
         (bs* (make-bytestructure
                (ffi:pointer->bytevector addr (sizeof '*))
                0
                (bs:pointer (bs:pointer (bs:pointer int))))))
    (case-lambda (() (bytestructure-ref bs* '*)))))
(export gdbm_errlist)

;; extern int const gdbm_syserr[];
(if echo-decls (display "gdbm_syserr\n"))
(define gdbm_syserr
  (let* ((addr (dynamic-pointer "gdbm_syserr" (dynamic-link)))
         (bs* (make-bytestructure
                (ffi:pointer->bytevector addr (sizeof '*))
                0
                (bs:pointer (bs:pointer int)))))
    (case-lambda (() (bytestructure-ref bs* '*)))))
(export gdbm_syserr)

;; extern gdbm_error gdbm_last_errno(GDBM_FILE dbf);
(if echo-decls (display "gdbm_last_errno\n"))
(define gdbm_last_errno
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_last_errno" (dynamic-link))
              (list '*))))
    (lambda (dbf)
      (let ((~dbf (unwrap~pointer dbf)))
        (wrap-gdbm_error (~f ~dbf))))))
(export gdbm_last_errno)

;; extern int gdbm_last_syserr(GDBM_FILE dbf);
(if echo-decls (display "gdbm_last_syserr\n"))
(define gdbm_last_syserr
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_last_syserr" (dynamic-link))
              (list '*))))
    (lambda (dbf)
      (let ((~dbf (unwrap~pointer dbf))) (~f ~dbf)))))
(export gdbm_last_syserr)

;; extern void gdbm_set_errno(GDBM_FILE dbf, gdbm_error ec, int fatal);
(if echo-decls (display "gdbm_set_errno\n"))
(define gdbm_set_errno
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "gdbm_set_errno" (dynamic-link))
              (list '* ffi:int ffi:int))))
    (lambda (dbf ec fatal)
      (let ((~dbf (unwrap~pointer dbf))
            (~ec (unwrap-gdbm_error ec))
            (~fatal (unwrap~fixed fatal)))
        (~f ~dbf ~ec ~fatal)))))
(export gdbm_set_errno)

;; extern void gdbm_clear_error(GDBM_FILE dbf);
(if echo-decls (display "gdbm_clear_error\n"))
(define gdbm_clear_error
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "gdbm_clear_error" (dynamic-link))
              (list '*))))
    (lambda (dbf)
      (let ((~dbf (unwrap~pointer dbf))) (~f ~dbf)))))
(export gdbm_clear_error)

;; extern int gdbm_needs_recovery(GDBM_FILE dbf);
(if echo-decls (display "gdbm_needs_recovery\n"))
(define gdbm_needs_recovery
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "gdbm_needs_recovery"
                (dynamic-link))
              (list '*))))
    (lambda (dbf)
      (let ((~dbf (unwrap~pointer dbf))) (~f ~dbf)))))
(export gdbm_needs_recovery)

;; extern int gdbm_check_syserr(gdbm_error n);
(if echo-decls (display "gdbm_check_syserr\n"))
(define gdbm_check_syserr
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_check_syserr" (dynamic-link))
              (list ffi:int))))
    (lambda (n)
      (let ((~n (unwrap-gdbm_error n))) (~f ~n)))))
(export gdbm_check_syserr)

;; extern const char *gdbm_strerror(gdbm_error);
(if echo-decls (display "gdbm_strerror\n"))
(define gdbm_strerror
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "gdbm_strerror" (dynamic-link))
              (list ffi:int))))
    (lambda (arg-0)
      (let ((~arg-0 (unwrap-gdbm_error arg-0)))
        (~f ~arg-0)))))
(export gdbm_strerror)

;; extern const char *gdbm_db_strerror(GDBM_FILE dbf);
(if echo-decls (display "gdbm_db_strerror\n"))
(define gdbm_db_strerror
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "gdbm_db_strerror" (dynamic-link))
              (list '*))))
    (lambda (dbf)
      (let ((~dbf (unwrap~pointer dbf))) (~f ~dbf)))))
(export gdbm_db_strerror)

;; extern int gdbm_version_cmp(int const a[], int const b[]);
(if echo-decls (display "gdbm_version_cmp\n"))
(define gdbm_version_cmp
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "gdbm_version_cmp" (dynamic-link))
              (list '* '*))))
    (lambda (a b)
      (let ((~a (unwrap~array a)) (~b (unwrap~array b)))
        (~f ~a ~b)))))
(export gdbm_version_cmp)

;; access to enum symbols and #define'd constants:
(define gdbm-symbol-val
  (let ((sym-tab
          '((GDBM_READER . 0)
            (GDBM_WRITER . 1)
            (GDBM_WRCREAT . 2)
            (GDBM_NEWDB . 3)
            (GDBM_OPENMASK . 7)
            (GDBM_FAST . 16)
            (GDBM_SYNC . 32)
            (GDBM_NOLOCK . 64)
            (GDBM_NOMMAP . 128)
            (GDBM_CLOEXEC . 256)
            (GDBM_BSEXACT . 512)
            (GDBM_CLOERROR . 1024)
            (GDBM_INSERT . 0)
            (GDBM_REPLACE . 1)
            (GDBM_SETCACHESIZE . 1)
            (GDBM_FASTMODE . 2)
            (GDBM_SETSYNCMODE . 3)
            (GDBM_SETCENTFREE . 4)
            (GDBM_SETCOALESCEBLKS . 5)
            (GDBM_SETMAXMAPSIZE . 6)
            (GDBM_SETMMAP . 7)
            (GDBM_CACHESIZE . 1)
            (GDBM_SYNCMODE . 3)
            (GDBM_CENTFREE . 4)
            (GDBM_COALESCEBLKS . 5)
            (GDBM_GETFLAGS . 8)
            (GDBM_GETMMAP . 9)
            (GDBM_GETCACHESIZE . 10)
            (GDBM_GETSYNCMODE . 11)
            (GDBM_GETCENTFREE . 12)
            (GDBM_GETCOALESCEBLKS . 13)
            (GDBM_GETMAXMAPSIZE . 14)
            (GDBM_GETDBNAME . 15)
            (GDBM_GETBLOCKSIZE . 16)
            (GDBM_VERSION_MAJOR . 1)
            (GDBM_VERSION_MINOR . 13)
            (GDBM_VERSION_PATCH . 0)
            (GDBM_RCVR_DEFAULT . 0)
            (GDBM_RCVR_ERRFUN . 1)
            (GDBM_RCVR_MAX_FAILED_KEYS . 2)
            (GDBM_RCVR_MAX_FAILED_BUCKETS . 4)
            (GDBM_RCVR_MAX_FAILURES . 8)
            (GDBM_RCVR_BACKUP . 16)
            (GDBM_RCVR_FORCE . 32)
            (GDBM_DUMP_FMT_BINARY . 0)
            (GDBM_DUMP_FMT_ASCII . 1)
            (GDBM_META_MASK_MODE . 1)
            (GDBM_META_MASK_OWNER . 2)
            (GDBM_NO_ERROR . 0)
            (GDBM_MALLOC_ERROR . 1)
            (GDBM_BLOCK_SIZE_ERROR . 2)
            (GDBM_FILE_OPEN_ERROR . 3)
            (GDBM_FILE_WRITE_ERROR . 4)
            (GDBM_FILE_SEEK_ERROR . 5)
            (GDBM_FILE_READ_ERROR . 6)
            (GDBM_BAD_MAGIC_NUMBER . 7)
            (GDBM_EMPTY_DATABASE . 8)
            (GDBM_CANT_BE_READER . 9)
            (GDBM_CANT_BE_WRITER . 10)
            (GDBM_READER_CANT_DELETE . 11)
            (GDBM_READER_CANT_STORE . 12)
            (GDBM_READER_CANT_REORGANIZE . 13)
            (GDBM_UNKNOWN_ERROR . 14)
            (GDBM_ITEM_NOT_FOUND . 15)
            (GDBM_REORGANIZE_FAILED . 16)
            (GDBM_CANNOT_REPLACE . 17)
            (GDBM_ILLEGAL_DATA . 18)
            (GDBM_OPT_ALREADY_SET . 19)
            (GDBM_OPT_ILLEGAL . 20)
            (GDBM_BYTE_SWAPPED . 21)
            (GDBM_BAD_FILE_OFFSET . 22)
            (GDBM_BAD_OPEN_FLAGS . 23)
            (GDBM_FILE_STAT_ERROR . 24)
            (GDBM_FILE_EOF . 25)
            (GDBM_NO_DBNAME . 26)
            (GDBM_ERR_FILE_OWNER . 27)
            (GDBM_ERR_FILE_MODE . 28)
            (GDBM_NEED_RECOVERY . 29)
            (GDBM_BACKUP_FAILED . 30)
            (GDBM_DIR_OVERFLOW . 31)
            (_GDBM_MIN_ERRNO . 0)
            (_GDBM_MAX_ERRNO . 31)
            (GDBM_UNKNOWN_UPDATE . 14))))
    (lambda (k) (assq-ref sym-tab k))))
(export gdbm-symbol-val)

(define (unwrap-enum obj)
  (cond ((number? obj) obj)
        ((symbol? obj) (gdbm-symbol-val obj))
        ((fh-object? obj) (struct-ref obj 0))
        (else (error "type mismatch"))))

(define gdbm-types
  '("gdbm_error" (struct . "gdbm_recovery_s") "gdbm_recovery" "GDBM_FILE" 
    "datum" "gdbm_count_t"))
;;(export gdbm-types)

(define unwrap-GDBM_FILE* unwrap-GDBM_FILE)

(define-fh-pointer-type
  gdbm_count_t*
  (bs:pointer gdbm_count_t-desc))

;; --- last line ---
