;; auto-generated by ffi-help.scm

(define-module (librsvg)
  #:use-module (system ffi-help-rt)
  #:use-module ((system foreign) #:prefix ffi:)
  #:use-module (bytestructures guile)
  )
(dynamic-link "libm")
(dynamic-link "libgio-2.0")
(dynamic-link "libgdk_pixbuf-2.0")
(dynamic-link "libgobject-2.0")
(dynamic-link "libglib-2.0")
(dynamic-link "libintl")
(dynamic-link "libcairo")
(dynamic-link "librsvg-2")
(define void intptr_t)
(define echo-decls #f)

;; GType rsvg_handle_get_type(void);
(if echo-decls (display "rsvg_handle_get_type\n"))
(define rsvg_handle_get_type
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-long
              (dynamic-func
                "rsvg_handle_get_type"
                (dynamic-link))
              (list))))
    (lambda () (let () (~f)))))
(export rsvg_handle_get_type)

;; typedef enum {
;;   RSVG_ERROR_FAILED,
;; } RsvgError;
(if echo-decls (display "RsvgError\n"))
(define-fh-enum RsvgError
  '((RSVG_ERROR_FAILED . 0))
  )

;; GQuark rsvg_error_quark(void);
(if echo-decls (display "rsvg_error_quark\n"))
(define rsvg_error_quark
  (let ((~f (ffi:pointer->procedure
              ffi:unsigned-int
              (dynamic-func "rsvg_error_quark" (dynamic-link))
              (list))))
    (lambda () (let () (~f)))))
(export rsvg_error_quark)

;; typedef struct _RsvgHandle RsvgHandle;
(if echo-decls (display "RsvgHandle\n"))
(define RsvgHandle-desc void)
(define RsvgHandle*-desc (bs:pointer (delay RsvgHandle-desc)))
(define-fh-pointer-type RsvgHandle* RsvgHandle*-desc)

;; typedef struct RsvgHandlePrivate RsvgHandlePrivate;
(if echo-decls (display "RsvgHandlePrivate\n"))
(define RsvgHandlePrivate-desc void)
(define RsvgHandlePrivate*-desc (bs:pointer RsvgHandlePrivate-desc))
(define-fh-pointer-type RsvgHandlePrivate* RsvgHandlePrivate*-desc)

;; typedef struct _RsvgHandleClass RsvgHandleClass;
(if echo-decls (display "RsvgHandleClass\n"))
(define RsvgHandleClass-desc void)
(define RsvgHandleClass*-desc (bs:pointer (delay RsvgHandleClass-desc)))
(define-fh-pointer-type RsvgHandleClass* RsvgHandleClass*-desc)

;; typedef struct _RsvgDimensionData RsvgDimensionData;
(if echo-decls (display "RsvgDimensionData\n"))
(define RsvgDimensionData-desc void)
(define RsvgDimensionData*-desc (bs:pointer (delay RsvgDimensionData-desc)))
(define-fh-pointer-type RsvgDimensionData* RsvgDimensionData*-desc)

;; typedef struct _RsvgPositionData RsvgPositionData;
(if echo-decls (display "RsvgPositionData\n"))
(define RsvgPositionData-desc void)
(define RsvgPositionData*-desc (bs:pointer (delay RsvgPositionData-desc)))
(define-fh-pointer-type RsvgPositionData* RsvgPositionData*-desc)

;; struct _RsvgHandleClass {
;;   GObjectClass parent;
;;   /*< private >*/
;;   gpointer _abi_padding[15];
;; };
(if echo-decls (display "(struct . _RsvgHandleClass)\n"))
(define struct-_RsvgHandleClass-desc
  (bs:struct
    (list `(parent
             ,(bs:struct
                (list `(g_type_class
                         ,(bs:struct (list `(g_type ,unsigned-long))))
                      `(construct_properties ,(bs:pointer void))
                      `(constructor ,(bs:pointer void))
                      `(set_property ,(bs:pointer void))
                      `(get_property ,(bs:pointer void))
                      `(dispose ,(bs:pointer void))
                      `(finalize ,(bs:pointer void))
                      `(dispatch_properties_changed ,(bs:pointer void))
                      `(notify ,(bs:pointer void))
                      `(constructed ,(bs:pointer void))
                      `(flags ,unsigned-long)
                      `(pdummy ,(bs:vector 6 void)))))
          `(_abi_padding ,(bs:vector 15 void)))))
(export struct-_RsvgHandleClass-desc)
(define-fh-compound-type/p struct-_RsvgHandleClass struct-_RsvgHandleClass-desc)
(set! RsvgHandleClass-desc struct-_RsvgHandleClass-desc)
(define-fh-compound-type RsvgHandleClass RsvgHandleClass-desc)

;; struct _RsvgHandle {
;;   GObject parent;
;;   /*< private >*/
;;   RsvgHandlePrivate *priv;
;;   gpointer _abi_padding[15];
;; };
(if echo-decls (display "(struct . _RsvgHandle)\n"))
(define struct-_RsvgHandle-desc
  (bs:struct
    (list `(parent
             ,(bs:struct
                (list `(g_type_instance
                         ,(bs:struct (list `(g_class ,(bs:pointer void)))))
                      `(ref_count ,unsigned-int)
                      `(qdata ,(bs:pointer void)))))
          `(priv ,(bs:pointer RsvgHandlePrivate*-desc))
          `(_abi_padding ,(bs:vector 15 void)))))
(export struct-_RsvgHandle-desc)
(define-fh-compound-type/p struct-_RsvgHandle struct-_RsvgHandle-desc)
(set! RsvgHandle-desc struct-_RsvgHandle-desc)
(define-fh-compound-type RsvgHandle RsvgHandle-desc)

;; struct _RsvgDimensionData {
;;   int width;
;;   int height;
;;   gdouble em;
;;   gdouble ex;
;; };
(if echo-decls (display "(struct . _RsvgDimensionData)\n"))
(define struct-_RsvgDimensionData-desc
  (bs:struct
    (list `(width ,int)
          `(height ,int)
          `(em ,double)
          `(ex ,double))))
(export struct-_RsvgDimensionData-desc)
(define-fh-compound-type/p struct-_RsvgDimensionData struct-_RsvgDimensionData-desc)
(set! RsvgDimensionData-desc struct-_RsvgDimensionData-desc)
(define-fh-compound-type RsvgDimensionData RsvgDimensionData-desc)

;; struct _RsvgPositionData {
;;   int x;
;;   int y;
;; };
(if echo-decls (display "(struct . _RsvgPositionData)\n"))
(define struct-_RsvgPositionData-desc
  (bs:struct (list `(x ,int) `(y ,int))))
(export struct-_RsvgPositionData-desc)
(define-fh-compound-type/p struct-_RsvgPositionData struct-_RsvgPositionData-desc)
(set! RsvgPositionData-desc struct-_RsvgPositionData-desc)
(define-fh-compound-type RsvgPositionData RsvgPositionData-desc)

;; void rsvg_cleanup(void);
(if echo-decls (display "rsvg_cleanup\n"))
(define rsvg_cleanup
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "rsvg_cleanup" (dynamic-link))
              (list))))
    (lambda () (let () (~f)))))
(export rsvg_cleanup)

;; void rsvg_set_default_dpi(double dpi);
(if echo-decls (display "rsvg_set_default_dpi\n"))
(define rsvg_set_default_dpi
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "rsvg_set_default_dpi"
                (dynamic-link))
              (list ffi:double))))
    (lambda (dpi)
      (let ((~dpi (unwrap~float dpi))) (~f ~dpi)))))
(export rsvg_set_default_dpi)

;; void rsvg_set_default_dpi_x_y(double dpi_x, double dpi_y);
(if echo-decls (display "rsvg_set_default_dpi_x_y\n"))
(define rsvg_set_default_dpi_x_y
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "rsvg_set_default_dpi_x_y"
                (dynamic-link))
              (list ffi:double ffi:double))))
    (lambda (dpi_x dpi_y)
      (let ((~dpi_x (unwrap~float dpi_x))
            (~dpi_y (unwrap~float dpi_y)))
        (~f ~dpi_x ~dpi_y)))))
(export rsvg_set_default_dpi_x_y)

;; void rsvg_handle_set_dpi(RsvgHandle *handle, double dpi);
(if echo-decls (display "rsvg_handle_set_dpi\n"))
(define rsvg_handle_set_dpi
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "rsvg_handle_set_dpi"
                (dynamic-link))
              (list '* ffi:double))))
    (lambda (handle dpi)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~dpi (unwrap~float dpi)))
        (~f ~handle ~dpi)))))
(export rsvg_handle_set_dpi)

;; void rsvg_handle_set_dpi_x_y(RsvgHandle *handle, double dpi_x, double dpi_y)
;;     ;
(if echo-decls (display "rsvg_handle_set_dpi_x_y\n"))
(define rsvg_handle_set_dpi_x_y
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "rsvg_handle_set_dpi_x_y"
                (dynamic-link))
              (list '* ffi:double ffi:double))))
    (lambda (handle dpi_x dpi_y)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~dpi_x (unwrap~float dpi_x))
            (~dpi_y (unwrap~float dpi_y)))
        (~f ~handle ~dpi_x ~dpi_y)))))
(export rsvg_handle_set_dpi_x_y)

;; RsvgHandle *rsvg_handle_new(void);
(if echo-decls (display "rsvg_handle_new\n"))
(define rsvg_handle_new
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func "rsvg_handle_new" (dynamic-link))
              (list))))
    (lambda () (let () (wrap-RsvgHandle* (~f))))))
(export rsvg_handle_new)

;; gboolean rsvg_handle_write(RsvgHandle *handle, const guchar *buf, gsize 
;;     count, GError **error);
(if echo-decls (display "rsvg_handle_write\n"))
(define rsvg_handle_write
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "rsvg_handle_write" (dynamic-link))
              (list '* '* ffi:unsigned-long '*))))
    (lambda (handle buf count error)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~buf (unwrap~pointer buf))
            (~count (unwrap~fixed count))
            (~error (unwrap~pointer error)))
        (~f ~handle ~buf ~count ~error)))))
(export rsvg_handle_write)

;; gboolean rsvg_handle_close(RsvgHandle *handle, GError **error);
(if echo-decls (display "rsvg_handle_close\n"))
(define rsvg_handle_close
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func "rsvg_handle_close" (dynamic-link))
              (list '* '*))))
    (lambda (handle error)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~error (unwrap~pointer error)))
        (~f ~handle ~error)))))
(export rsvg_handle_close)

;; GdkPixbuf *rsvg_handle_get_pixbuf(RsvgHandle *handle);
(if echo-decls (display "rsvg_handle_get_pixbuf\n"))
(define rsvg_handle_get_pixbuf
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_get_pixbuf"
                (dynamic-link))
              (list '*))))
    (lambda (handle)
      (let ((~handle (unwrap-RsvgHandle* handle)))
        (~f ~handle)))))
(export rsvg_handle_get_pixbuf)

;; GdkPixbuf *rsvg_handle_get_pixbuf_sub(RsvgHandle *handle, const char *id);
(if echo-decls (display "rsvg_handle_get_pixbuf_sub\n"))
(define rsvg_handle_get_pixbuf_sub
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_get_pixbuf_sub"
                (dynamic-link))
              (list '* '*))))
    (lambda (handle id)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~id (unwrap~pointer id)))
        (~f ~handle ~id)))))
(export rsvg_handle_get_pixbuf_sub)

;; const char *rsvg_handle_get_base_uri(RsvgHandle *handle);
(if echo-decls (display "rsvg_handle_get_base_uri\n"))
(define rsvg_handle_get_base_uri
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_get_base_uri"
                (dynamic-link))
              (list '*))))
    (lambda (handle)
      (let ((~handle (unwrap-RsvgHandle* handle)))
        (~f ~handle)))))
(export rsvg_handle_get_base_uri)

;; void rsvg_handle_set_base_uri(RsvgHandle *handle, const char *base_uri);
(if echo-decls (display "rsvg_handle_set_base_uri\n"))
(define rsvg_handle_set_base_uri
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "rsvg_handle_set_base_uri"
                (dynamic-link))
              (list '* '*))))
    (lambda (handle base_uri)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~base_uri (unwrap~pointer base_uri)))
        (~f ~handle ~base_uri)))))
(export rsvg_handle_set_base_uri)

;; void rsvg_handle_get_dimensions(RsvgHandle *handle, RsvgDimensionData *
;;     dimension_data);
(if echo-decls (display "rsvg_handle_get_dimensions\n"))
(define rsvg_handle_get_dimensions
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "rsvg_handle_get_dimensions"
                (dynamic-link))
              (list '* '*))))
    (lambda (handle dimension_data)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~dimension_data
              (unwrap-RsvgDimensionData* dimension_data)))
        (~f ~handle ~dimension_data)))))
(export rsvg_handle_get_dimensions)

;; gboolean rsvg_handle_get_dimensions_sub(RsvgHandle *handle, 
;;     RsvgDimensionData *dimension_data, const char *id);
(if echo-decls (display "rsvg_handle_get_dimensions_sub\n"))
(define rsvg_handle_get_dimensions_sub
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "rsvg_handle_get_dimensions_sub"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (handle dimension_data id)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~dimension_data
              (unwrap-RsvgDimensionData* dimension_data))
            (~id (unwrap~pointer id)))
        (~f ~handle ~dimension_data ~id)))))
(export rsvg_handle_get_dimensions_sub)

;; gboolean rsvg_handle_get_position_sub(RsvgHandle *handle, RsvgPositionData *
;;     position_data, const char *id);
(if echo-decls (display "rsvg_handle_get_position_sub\n"))
(define rsvg_handle_get_position_sub
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "rsvg_handle_get_position_sub"
                (dynamic-link))
              (list '* '* '*))))
    (lambda (handle position_data id)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~position_data
              (unwrap-RsvgPositionData* position_data))
            (~id (unwrap~pointer id)))
        (~f ~handle ~position_data ~id)))))
(export rsvg_handle_get_position_sub)

;; gboolean rsvg_handle_has_sub(RsvgHandle *handle, const char *id);
(if echo-decls (display "rsvg_handle_has_sub\n"))
(define rsvg_handle_has_sub
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "rsvg_handle_has_sub"
                (dynamic-link))
              (list '* '*))))
    (lambda (handle id)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~id (unwrap~pointer id)))
        (~f ~handle ~id)))))
(export rsvg_handle_has_sub)

;; typedef enum {
;;   RSVG_HANDLE_FLAGS_NONE = 0,
;;   RSVG_HANDLE_FLAG_UNLIMITED = 1<<0,
;;   RSVG_HANDLE_FLAG_KEEP_IMAGE_DATA = 1<<1,
;; } RsvgHandleFlags;
(if echo-decls (display "RsvgHandleFlags\n"))
(define-fh-enum RsvgHandleFlags
  '((RSVG_HANDLE_FLAGS_NONE . 0)
    (RSVG_HANDLE_FLAG_UNLIMITED . 1)
    (RSVG_HANDLE_FLAG_KEEP_IMAGE_DATA . 2))
  )

;; RsvgHandle *rsvg_handle_new_with_flags(RsvgHandleFlags flags);
(if echo-decls (display "rsvg_handle_new_with_flags\n"))
(define rsvg_handle_new_with_flags
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_new_with_flags"
                (dynamic-link))
              (list ffi:int))))
    (lambda (flags)
      (let ((~flags (unwrap~fixed flags)))
        (wrap-RsvgHandle* (~f ~flags))))))
(export rsvg_handle_new_with_flags)

;; void rsvg_handle_set_base_gfile(RsvgHandle *handle, GFile *base_file);
(if echo-decls (display "rsvg_handle_set_base_gfile\n"))
(define rsvg_handle_set_base_gfile
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "rsvg_handle_set_base_gfile"
                (dynamic-link))
              (list '* '*))))
    (lambda (handle base_file)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~base_file (unwrap~pointer base_file)))
        (~f ~handle ~base_file)))))
(export rsvg_handle_set_base_gfile)

;; gboolean rsvg_handle_read_stream_sync(RsvgHandle *handle, GInputStream *
;;     stream, GCancellable *cancellable, GError **error);
(if echo-decls (display "rsvg_handle_read_stream_sync\n"))
(define rsvg_handle_read_stream_sync
  (let ((~f (ffi:pointer->procedure
              ffi:int
              (dynamic-func
                "rsvg_handle_read_stream_sync"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (handle stream cancellable error)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~stream (unwrap~pointer stream))
            (~cancellable (unwrap~pointer cancellable))
            (~error (unwrap~pointer error)))
        (~f ~handle ~stream ~cancellable ~error)))))
(export rsvg_handle_read_stream_sync)

;; RsvgHandle *rsvg_handle_new_from_gfile_sync(GFile *file, RsvgHandleFlags 
;;     flags, GCancellable *cancellable, GError **error);
(if echo-decls (display "rsvg_handle_new_from_gfile_sync\n"))
(define rsvg_handle_new_from_gfile_sync
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_new_from_gfile_sync"
                (dynamic-link))
              (list '* ffi:int '* '*))))
    (lambda (file flags cancellable error)
      (let ((~file (unwrap~pointer file))
            (~flags (unwrap~fixed flags))
            (~cancellable (unwrap~pointer cancellable))
            (~error (unwrap~pointer error)))
        (wrap-RsvgHandle*
          (~f ~file ~flags ~cancellable ~error))))))
(export rsvg_handle_new_from_gfile_sync)

;; RsvgHandle *rsvg_handle_new_from_stream_sync(GInputStream *input_stream, 
;;     GFile *base_file, RsvgHandleFlags flags, GCancellable *cancellable, 
;;     GError **error);
(if echo-decls (display "rsvg_handle_new_from_stream_sync\n"))
(define rsvg_handle_new_from_stream_sync
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_new_from_stream_sync"
                (dynamic-link))
              (list '* '* ffi:int '* '*))))
    (lambda (input_stream base_file flags cancellable error)
      (let ((~input_stream (unwrap~pointer input_stream))
            (~base_file (unwrap~pointer base_file))
            (~flags (unwrap~fixed flags))
            (~cancellable (unwrap~pointer cancellable))
            (~error (unwrap~pointer error)))
        (wrap-RsvgHandle*
          (~f ~input_stream
              ~base_file
              ~flags
              ~cancellable
              ~error))))))
(export rsvg_handle_new_from_stream_sync)

;; RsvgHandle *rsvg_handle_new_from_data(const guint8 *data, gsize data_len, 
;;     GError **error);
(if echo-decls (display "rsvg_handle_new_from_data\n"))
(define rsvg_handle_new_from_data
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_new_from_data"
                (dynamic-link))
              (list '* ffi:unsigned-long '*))))
    (lambda (data data_len error)
      (let ((~data (unwrap~pointer data))
            (~data_len (unwrap~fixed data_len))
            (~error (unwrap~pointer error)))
        (wrap-RsvgHandle* (~f ~data ~data_len ~error))))))
(export rsvg_handle_new_from_data)

;; RsvgHandle *rsvg_handle_new_from_file(const gchar *file_name, GError **error
;;     );
(if echo-decls (display "rsvg_handle_new_from_file\n"))
(define rsvg_handle_new_from_file
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_new_from_file"
                (dynamic-link))
              (list '* '*))))
    (lambda (file_name error)
      (let ((~file_name (unwrap~pointer file_name))
            (~error (unwrap~pointer error)))
        (wrap-RsvgHandle* (~f ~file_name ~error))))))
(export rsvg_handle_new_from_file)

;; void rsvg_init(void);
(if echo-decls (display "rsvg_init\n"))
(define rsvg_init
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "rsvg_init" (dynamic-link))
              (list))))
    (lambda () (let () (~f)))))
(export rsvg_init)

;; void rsvg_term(void);
(if echo-decls (display "rsvg_term\n"))
(define rsvg_term
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "rsvg_term" (dynamic-link))
              (list))))
    (lambda () (let () (~f)))))
(export rsvg_term)

;; void rsvg_handle_free(RsvgHandle *handle);
(if echo-decls (display "rsvg_handle_free\n"))
(define rsvg_handle_free
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func "rsvg_handle_free" (dynamic-link))
              (list '*))))
    (lambda (handle)
      (let ((~handle (unwrap-RsvgHandle* handle)))
        (~f ~handle)))))
(export rsvg_handle_free)

;; typedef void (*RsvgSizeFunc)(gint *width, gint *height, gpointer user_data)
;;     ;
(if echo-decls (display "RsvgSizeFunc\n"))
(define-fh-function/p RsvgSizeFunc
  ffi:void (list (quote *) (quote *) (quote *)))

;; void rsvg_handle_set_size_callback(RsvgHandle *handle, RsvgSizeFunc 
;;     size_func, gpointer user_data, GDestroyNotify user_data_destroy);
(if echo-decls (display "rsvg_handle_set_size_callback\n"))
(define rsvg_handle_set_size_callback
  (let ((~f (ffi:pointer->procedure
              ffi:void
              (dynamic-func
                "rsvg_handle_set_size_callback"
                (dynamic-link))
              (list '* '* '* '*))))
    (lambda (handle size_func user_data user_data_destroy)
      (let ((~handle (unwrap-RsvgHandle* handle))
            (~size_func
              ((make-ftn-arg-unwrapper ffi:void (list '* '* '*))
               size_func))
            (~user_data (unwrap~pointer user_data))
            (~user_data_destroy
              ((make-ftn-arg-unwrapper ffi:void (list '*))
               user_data_destroy)))
        (~f ~handle
            ~size_func
            ~user_data
            ~user_data_destroy)))))
(export rsvg_handle_set_size_callback)

;; GdkPixbuf *rsvg_pixbuf_from_file(const gchar *file_name, GError **error);
(if echo-decls (display "rsvg_pixbuf_from_file\n"))
(define rsvg_pixbuf_from_file
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_pixbuf_from_file"
                (dynamic-link))
              (list '* '*))))
    (lambda (file_name error)
      (let ((~file_name (unwrap~pointer file_name))
            (~error (unwrap~pointer error)))
        (~f ~file_name ~error)))))
(export rsvg_pixbuf_from_file)

;; GdkPixbuf *rsvg_pixbuf_from_file_at_zoom(const gchar *file_name, double 
;;     x_zoom, double y_zoom, GError **error);
(if echo-decls (display "rsvg_pixbuf_from_file_at_zoom\n"))
(define rsvg_pixbuf_from_file_at_zoom
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_pixbuf_from_file_at_zoom"
                (dynamic-link))
              (list '* ffi:double ffi:double '*))))
    (lambda (file_name x_zoom y_zoom error)
      (let ((~file_name (unwrap~pointer file_name))
            (~x_zoom (unwrap~float x_zoom))
            (~y_zoom (unwrap~float y_zoom))
            (~error (unwrap~pointer error)))
        (~f ~file_name ~x_zoom ~y_zoom ~error)))))
(export rsvg_pixbuf_from_file_at_zoom)

;; GdkPixbuf *rsvg_pixbuf_from_file_at_size(const gchar *file_name, gint width
;;     , gint height, GError **error);
(if echo-decls (display "rsvg_pixbuf_from_file_at_size\n"))
(define rsvg_pixbuf_from_file_at_size
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_pixbuf_from_file_at_size"
                (dynamic-link))
              (list '* ffi:int ffi:int '*))))
    (lambda (file_name width height error)
      (let ((~file_name (unwrap~pointer file_name))
            (~width (unwrap~fixed width))
            (~height (unwrap~fixed height))
            (~error (unwrap~pointer error)))
        (~f ~file_name ~width ~height ~error)))))
(export rsvg_pixbuf_from_file_at_size)

;; GdkPixbuf *rsvg_pixbuf_from_file_at_max_size(const gchar *file_name, gint 
;;     max_width, gint max_height, GError **error);
(if echo-decls (display "rsvg_pixbuf_from_file_at_max_size\n"))
(define rsvg_pixbuf_from_file_at_max_size
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_pixbuf_from_file_at_max_size"
                (dynamic-link))
              (list '* ffi:int ffi:int '*))))
    (lambda (file_name max_width max_height error)
      (let ((~file_name (unwrap~pointer file_name))
            (~max_width (unwrap~fixed max_width))
            (~max_height (unwrap~fixed max_height))
            (~error (unwrap~pointer error)))
        (~f ~file_name ~max_width ~max_height ~error)))))
(export rsvg_pixbuf_from_file_at_max_size)

;; GdkPixbuf *rsvg_pixbuf_from_file_at_zoom_with_max(const gchar *file_name, 
;;     double x_zoom, double y_zoom, gint max_width, gint max_height, GError **
;;     error);
(if echo-decls (display "rsvg_pixbuf_from_file_at_zoom_with_max\n"))
(define rsvg_pixbuf_from_file_at_zoom_with_max
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_pixbuf_from_file_at_zoom_with_max"
                (dynamic-link))
              (list '*
                    ffi:double
                    ffi:double
                    ffi:int
                    ffi:int
                    '*))))
    (lambda (file_name
             x_zoom
             y_zoom
             max_width
             max_height
             error)
      (let ((~file_name (unwrap~pointer file_name))
            (~x_zoom (unwrap~float x_zoom))
            (~y_zoom (unwrap~float y_zoom))
            (~max_width (unwrap~fixed max_width))
            (~max_height (unwrap~fixed max_height))
            (~error (unwrap~pointer error)))
        (~f ~file_name
            ~x_zoom
            ~y_zoom
            ~max_width
            ~max_height
            ~error)))))
(export rsvg_pixbuf_from_file_at_zoom_with_max)

;; const char *rsvg_handle_get_title(RsvgHandle *handle);
(if echo-decls (display "rsvg_handle_get_title\n"))
(define rsvg_handle_get_title
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_get_title"
                (dynamic-link))
              (list '*))))
    (lambda (handle)
      (let ((~handle (unwrap-RsvgHandle* handle)))
        (~f ~handle)))))
(export rsvg_handle_get_title)

;; const char *rsvg_handle_get_desc(RsvgHandle *handle);
(if echo-decls (display "rsvg_handle_get_desc\n"))
(define rsvg_handle_get_desc
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_get_desc"
                (dynamic-link))
              (list '*))))
    (lambda (handle)
      (let ((~handle (unwrap-RsvgHandle* handle)))
        (~f ~handle)))))
(export rsvg_handle_get_desc)

;; const char *rsvg_handle_get_metadata(RsvgHandle *handle);
(if echo-decls (display "rsvg_handle_get_metadata\n"))
(define rsvg_handle_get_metadata
  (let ((~f (ffi:pointer->procedure
              '*
              (dynamic-func
                "rsvg_handle_get_metadata"
                (dynamic-link))
              (list '*))))
    (lambda (handle)
      (let ((~handle (unwrap-RsvgHandle* handle)))
        (~f ~handle)))))
(export rsvg_handle_get_metadata)

;; access to enum symbols and #define'd constants:
(define librsvg-symbol-val
  (let ((sym-tab
          '((_CLOCK_REALTIME . 0)
            (_CLOCK_MONOTONIC . 6)
            (_CLOCK_MONOTONIC_RAW . 4)
            (_CLOCK_MONOTONIC_RAW_APPROX . 5)
            (_CLOCK_UPTIME_RAW . 8)
            (_CLOCK_UPTIME_RAW_APPROX . 9)
            (_CLOCK_PROCESS_CPUTIME_ID . 12)
            (_CLOCK_THREAD_CPUTIME_ID . 16)
            (G_USER_DIRECTORY_DESKTOP . 0)
            (G_USER_DIRECTORY_DOCUMENTS . 1)
            (G_USER_DIRECTORY_DOWNLOAD . 2)
            (G_USER_DIRECTORY_MUSIC . 3)
            (G_USER_DIRECTORY_PICTURES . 4)
            (G_USER_DIRECTORY_PUBLIC_SHARE . 5)
            (G_USER_DIRECTORY_TEMPLATES . 6)
            (G_USER_DIRECTORY_VIDEOS . 7)
            (G_USER_N_DIRECTORIES . 8)
            (G_FORMAT_SIZE_DEFAULT . 0)
            (G_FORMAT_SIZE_LONG_FORMAT . 1)
            (G_FORMAT_SIZE_IEC_UNITS . 2)
            (G_THREAD_ERROR_AGAIN . 0)
            (G_ONCE_STATUS_NOTCALLED . 0)
            (G_ONCE_STATUS_PROGRESS . 1)
            (G_ONCE_STATUS_READY . 2)
            (G_BOOKMARK_FILE_ERROR_INVALID_URI . 0)
            (G_BOOKMARK_FILE_ERROR_INVALID_VALUE . 1)
            (G_BOOKMARK_FILE_ERROR_APP_NOT_REGISTERED . 2)
            (G_BOOKMARK_FILE_ERROR_URI_NOT_FOUND . 3)
            (G_BOOKMARK_FILE_ERROR_READ . 4)
            (G_BOOKMARK_FILE_ERROR_UNKNOWN_ENCODING . 5)
            (G_BOOKMARK_FILE_ERROR_WRITE . 6)
            (G_BOOKMARK_FILE_ERROR_FILE_NOT_FOUND . 7)
            (G_CHECKSUM_MD5 . 0)
            (G_CHECKSUM_SHA1 . 1)
            (G_CHECKSUM_SHA256 . 2)
            (G_CHECKSUM_SHA512 . 3)
            (G_CHECKSUM_SHA384 . 4)
            (G_CONVERT_ERROR_NO_CONVERSION . 0)
            (G_CONVERT_ERROR_ILLEGAL_SEQUENCE . 1)
            (G_CONVERT_ERROR_FAILED . 2)
            (G_CONVERT_ERROR_PARTIAL_INPUT . 3)
            (G_CONVERT_ERROR_BAD_URI . 4)
            (G_CONVERT_ERROR_NOT_ABSOLUTE_PATH . 5)
            (G_CONVERT_ERROR_NO_MEMORY . 6)
            (G_DATE_DAY . 0)
            (G_DATE_MONTH . 1)
            (G_DATE_YEAR . 2)
            (G_DATE_BAD_WEEKDAY . 0)
            (G_DATE_MONDAY . 1)
            (G_DATE_TUESDAY . 2)
            (G_DATE_WEDNESDAY . 3)
            (G_DATE_THURSDAY . 4)
            (G_DATE_FRIDAY . 5)
            (G_DATE_SATURDAY . 6)
            (G_DATE_SUNDAY . 7)
            (G_DATE_BAD_MONTH . 0)
            (G_DATE_JANUARY . 1)
            (G_DATE_FEBRUARY . 2)
            (G_DATE_MARCH . 3)
            (G_DATE_APRIL . 4)
            (G_DATE_MAY . 5)
            (G_DATE_JUNE . 6)
            (G_DATE_JULY . 7)
            (G_DATE_AUGUST . 8)
            (G_DATE_SEPTEMBER . 9)
            (G_DATE_OCTOBER . 10)
            (G_DATE_NOVEMBER . 11)
            (G_DATE_DECEMBER . 12)
            (G_TIME_TYPE_STANDARD . 0)
            (G_TIME_TYPE_DAYLIGHT . 1)
            (G_TIME_TYPE_UNIVERSAL . 2)
            (G_FILE_ERROR_EXIST . 0)
            (G_FILE_ERROR_ISDIR . 1)
            (G_FILE_ERROR_ACCES . 2)
            (G_FILE_ERROR_NAMETOOLONG . 3)
            (G_FILE_ERROR_NOENT . 4)
            (G_FILE_ERROR_NOTDIR . 5)
            (G_FILE_ERROR_NXIO . 6)
            (G_FILE_ERROR_NODEV . 7)
            (G_FILE_ERROR_ROFS . 8)
            (G_FILE_ERROR_TXTBSY . 9)
            (G_FILE_ERROR_FAULT . 10)
            (G_FILE_ERROR_LOOP . 11)
            (G_FILE_ERROR_NOSPC . 12)
            (G_FILE_ERROR_NOMEM . 13)
            (G_FILE_ERROR_MFILE . 14)
            (G_FILE_ERROR_NFILE . 15)
            (G_FILE_ERROR_BADF . 16)
            (G_FILE_ERROR_INVAL . 17)
            (G_FILE_ERROR_PIPE . 18)
            (G_FILE_ERROR_AGAIN . 19)
            (G_FILE_ERROR_INTR . 20)
            (G_FILE_ERROR_IO . 21)
            (G_FILE_ERROR_PERM . 22)
            (G_FILE_ERROR_NOSYS . 23)
            (G_FILE_ERROR_FAILED . 24)
            (G_FILE_TEST_IS_REGULAR . 1)
            (G_FILE_TEST_IS_SYMLINK . 2)
            (G_FILE_TEST_IS_DIR . 4)
            (G_FILE_TEST_IS_EXECUTABLE . 8)
            (G_FILE_TEST_EXISTS . 16)
            (G_TRAVERSE_LEAVES . 1)
            (G_TRAVERSE_NON_LEAVES . 2)
            (G_TRAVERSE_ALL . 3)
            (G_TRAVERSE_MASK . 3)
            (G_TRAVERSE_LEAFS . 1)
            (G_TRAVERSE_NON_LEAFS . 2)
            (G_IN_ORDER . 0)
            (G_PRE_ORDER . 1)
            (G_POST_ORDER . 2)
            (G_LEVEL_ORDER . 3)
            (G_HOOK_FLAG_ACTIVE . 1)
            (G_HOOK_FLAG_IN_CALL . 2)
            (G_HOOK_FLAG_MASK . 15)
            (G_IO_IN . 1)
            (G_IO_OUT . 4)
            (G_IO_PRI . 2)
            (G_IO_ERR . 8)
            (G_IO_HUP . 16)
            (G_IO_NVAL . 32)
            (G_UNICODE_CONTROL . 0)
            (G_UNICODE_FORMAT . 1)
            (G_UNICODE_UNASSIGNED . 2)
            (G_UNICODE_PRIVATE_USE . 3)
            (G_UNICODE_SURROGATE . 4)
            (G_UNICODE_LOWERCASE_LETTER . 5)
            (G_UNICODE_MODIFIER_LETTER . 6)
            (G_UNICODE_OTHER_LETTER . 7)
            (G_UNICODE_TITLECASE_LETTER . 8)
            (G_UNICODE_UPPERCASE_LETTER . 9)
            (G_UNICODE_SPACING_MARK . 10)
            (G_UNICODE_ENCLOSING_MARK . 11)
            (G_UNICODE_NON_SPACING_MARK . 12)
            (G_UNICODE_DECIMAL_NUMBER . 13)
            (G_UNICODE_LETTER_NUMBER . 14)
            (G_UNICODE_OTHER_NUMBER . 15)
            (G_UNICODE_CONNECT_PUNCTUATION . 16)
            (G_UNICODE_DASH_PUNCTUATION . 17)
            (G_UNICODE_CLOSE_PUNCTUATION . 18)
            (G_UNICODE_FINAL_PUNCTUATION . 19)
            (G_UNICODE_INITIAL_PUNCTUATION . 20)
            (G_UNICODE_OTHER_PUNCTUATION . 21)
            (G_UNICODE_OPEN_PUNCTUATION . 22)
            (G_UNICODE_CURRENCY_SYMBOL . 23)
            (G_UNICODE_MODIFIER_SYMBOL . 24)
            (G_UNICODE_MATH_SYMBOL . 25)
            (G_UNICODE_OTHER_SYMBOL . 26)
            (G_UNICODE_LINE_SEPARATOR . 27)
            (G_UNICODE_PARAGRAPH_SEPARATOR . 28)
            (G_UNICODE_SPACE_SEPARATOR . 29)
            (G_UNICODE_BREAK_MANDATORY . 0)
            (G_UNICODE_BREAK_CARRIAGE_RETURN . 1)
            (G_UNICODE_BREAK_LINE_FEED . 2)
            (G_UNICODE_BREAK_COMBINING_MARK . 3)
            (G_UNICODE_BREAK_SURROGATE . 4)
            (G_UNICODE_BREAK_ZERO_WIDTH_SPACE . 5)
            (G_UNICODE_BREAK_INSEPARABLE . 6)
            (G_UNICODE_BREAK_NON_BREAKING_GLUE . 7)
            (G_UNICODE_BREAK_CONTINGENT . 8)
            (G_UNICODE_BREAK_SPACE . 9)
            (G_UNICODE_BREAK_AFTER . 10)
            (G_UNICODE_BREAK_BEFORE . 11)
            (G_UNICODE_BREAK_BEFORE_AND_AFTER . 12)
            (G_UNICODE_BREAK_HYPHEN . 13)
            (G_UNICODE_BREAK_NON_STARTER . 14)
            (G_UNICODE_BREAK_OPEN_PUNCTUATION . 15)
            (G_UNICODE_BREAK_CLOSE_PUNCTUATION . 16)
            (G_UNICODE_BREAK_QUOTATION . 17)
            (G_UNICODE_BREAK_EXCLAMATION . 18)
            (G_UNICODE_BREAK_IDEOGRAPHIC . 19)
            (G_UNICODE_BREAK_NUMERIC . 20)
            (G_UNICODE_BREAK_INFIX_SEPARATOR . 21)
            (G_UNICODE_BREAK_SYMBOL . 22)
            (G_UNICODE_BREAK_ALPHABETIC . 23)
            (G_UNICODE_BREAK_PREFIX . 24)
            (G_UNICODE_BREAK_POSTFIX . 25)
            (G_UNICODE_BREAK_COMPLEX_CONTEXT . 26)
            (G_UNICODE_BREAK_AMBIGUOUS . 27)
            (G_UNICODE_BREAK_UNKNOWN . 28)
            (G_UNICODE_BREAK_NEXT_LINE . 29)
            (G_UNICODE_BREAK_WORD_JOINER . 30)
            (G_UNICODE_BREAK_HANGUL_L_JAMO . 31)
            (G_UNICODE_BREAK_HANGUL_V_JAMO . 32)
            (G_UNICODE_BREAK_HANGUL_T_JAMO . 33)
            (G_UNICODE_BREAK_HANGUL_LV_SYLLABLE . 34)
            (G_UNICODE_BREAK_HANGUL_LVT_SYLLABLE . 35)
            (G_UNICODE_BREAK_CLOSE_PARANTHESIS . 36)
            (G_UNICODE_BREAK_CONDITIONAL_JAPANESE_STARTER
              .
              37)
            (G_UNICODE_BREAK_HEBREW_LETTER . 38)
            (G_UNICODE_BREAK_REGIONAL_INDICATOR . 39)
            (G_UNICODE_BREAK_EMOJI_BASE . 40)
            (G_UNICODE_BREAK_EMOJI_MODIFIER . 41)
            (G_UNICODE_BREAK_ZERO_WIDTH_JOINER . 42)
            (G_UNICODE_SCRIPT_INVALID_CODE . -1)
            (G_UNICODE_SCRIPT_COMMON . 0)
            (G_UNICODE_SCRIPT_INHERITED . 1)
            (G_UNICODE_SCRIPT_ARABIC . 2)
            (G_UNICODE_SCRIPT_ARMENIAN . 3)
            (G_UNICODE_SCRIPT_BENGALI . 4)
            (G_UNICODE_SCRIPT_BOPOMOFO . 5)
            (G_UNICODE_SCRIPT_CHEROKEE . 6)
            (G_UNICODE_SCRIPT_COPTIC . 7)
            (G_UNICODE_SCRIPT_CYRILLIC . 8)
            (G_UNICODE_SCRIPT_DESERET . 9)
            (G_UNICODE_SCRIPT_DEVANAGARI . 10)
            (G_UNICODE_SCRIPT_ETHIOPIC . 11)
            (G_UNICODE_SCRIPT_GEORGIAN . 12)
            (G_UNICODE_SCRIPT_GOTHIC . 13)
            (G_UNICODE_SCRIPT_GREEK . 14)
            (G_UNICODE_SCRIPT_GUJARATI . 15)
            (G_UNICODE_SCRIPT_GURMUKHI . 16)
            (G_UNICODE_SCRIPT_HAN . 17)
            (G_UNICODE_SCRIPT_HANGUL . 18)
            (G_UNICODE_SCRIPT_HEBREW . 19)
            (G_UNICODE_SCRIPT_HIRAGANA . 20)
            (G_UNICODE_SCRIPT_KANNADA . 21)
            (G_UNICODE_SCRIPT_KATAKANA . 22)
            (G_UNICODE_SCRIPT_KHMER . 23)
            (G_UNICODE_SCRIPT_LAO . 24)
            (G_UNICODE_SCRIPT_LATIN . 25)
            (G_UNICODE_SCRIPT_MALAYALAM . 26)
            (G_UNICODE_SCRIPT_MONGOLIAN . 27)
            (G_UNICODE_SCRIPT_MYANMAR . 28)
            (G_UNICODE_SCRIPT_OGHAM . 29)
            (G_UNICODE_SCRIPT_OLD_ITALIC . 30)
            (G_UNICODE_SCRIPT_ORIYA . 31)
            (G_UNICODE_SCRIPT_RUNIC . 32)
            (G_UNICODE_SCRIPT_SINHALA . 33)
            (G_UNICODE_SCRIPT_SYRIAC . 34)
            (G_UNICODE_SCRIPT_TAMIL . 35)
            (G_UNICODE_SCRIPT_TELUGU . 36)
            (G_UNICODE_SCRIPT_THAANA . 37)
            (G_UNICODE_SCRIPT_THAI . 38)
            (G_UNICODE_SCRIPT_TIBETAN . 39)
            (G_UNICODE_SCRIPT_CANADIAN_ABORIGINAL . 40)
            (G_UNICODE_SCRIPT_YI . 41)
            (G_UNICODE_SCRIPT_TAGALOG . 42)
            (G_UNICODE_SCRIPT_HANUNOO . 43)
            (G_UNICODE_SCRIPT_BUHID . 44)
            (G_UNICODE_SCRIPT_TAGBANWA . 45)
            (G_UNICODE_SCRIPT_BRAILLE . 46)
            (G_UNICODE_SCRIPT_CYPRIOT . 47)
            (G_UNICODE_SCRIPT_LIMBU . 48)
            (G_UNICODE_SCRIPT_OSMANYA . 49)
            (G_UNICODE_SCRIPT_SHAVIAN . 50)
            (G_UNICODE_SCRIPT_LINEAR_B . 51)
            (G_UNICODE_SCRIPT_TAI_LE . 52)
            (G_UNICODE_SCRIPT_UGARITIC . 53)
            (G_UNICODE_SCRIPT_NEW_TAI_LUE . 54)
            (G_UNICODE_SCRIPT_BUGINESE . 55)
            (G_UNICODE_SCRIPT_GLAGOLITIC . 56)
            (G_UNICODE_SCRIPT_TIFINAGH . 57)
            (G_UNICODE_SCRIPT_SYLOTI_NAGRI . 58)
            (G_UNICODE_SCRIPT_OLD_PERSIAN . 59)
            (G_UNICODE_SCRIPT_KHAROSHTHI . 60)
            (G_UNICODE_SCRIPT_UNKNOWN . 61)
            (G_UNICODE_SCRIPT_BALINESE . 62)
            (G_UNICODE_SCRIPT_CUNEIFORM . 63)
            (G_UNICODE_SCRIPT_PHOENICIAN . 64)
            (G_UNICODE_SCRIPT_PHAGS_PA . 65)
            (G_UNICODE_SCRIPT_NKO . 66)
            (G_UNICODE_SCRIPT_KAYAH_LI . 67)
            (G_UNICODE_SCRIPT_LEPCHA . 68)
            (G_UNICODE_SCRIPT_REJANG . 69)
            (G_UNICODE_SCRIPT_SUNDANESE . 70)
            (G_UNICODE_SCRIPT_SAURASHTRA . 71)
            (G_UNICODE_SCRIPT_CHAM . 72)
            (G_UNICODE_SCRIPT_OL_CHIKI . 73)
            (G_UNICODE_SCRIPT_VAI . 74)
            (G_UNICODE_SCRIPT_CARIAN . 75)
            (G_UNICODE_SCRIPT_LYCIAN . 76)
            (G_UNICODE_SCRIPT_LYDIAN . 77)
            (G_UNICODE_SCRIPT_AVESTAN . 78)
            (G_UNICODE_SCRIPT_BAMUM . 79)
            (G_UNICODE_SCRIPT_EGYPTIAN_HIEROGLYPHS . 80)
            (G_UNICODE_SCRIPT_IMPERIAL_ARAMAIC . 81)
            (G_UNICODE_SCRIPT_INSCRIPTIONAL_PAHLAVI . 82)
            (G_UNICODE_SCRIPT_INSCRIPTIONAL_PARTHIAN . 83)
            (G_UNICODE_SCRIPT_JAVANESE . 84)
            (G_UNICODE_SCRIPT_KAITHI . 85)
            (G_UNICODE_SCRIPT_LISU . 86)
            (G_UNICODE_SCRIPT_MEETEI_MAYEK . 87)
            (G_UNICODE_SCRIPT_OLD_SOUTH_ARABIAN . 88)
            (G_UNICODE_SCRIPT_OLD_TURKIC . 89)
            (G_UNICODE_SCRIPT_SAMARITAN . 90)
            (G_UNICODE_SCRIPT_TAI_THAM . 91)
            (G_UNICODE_SCRIPT_TAI_VIET . 92)
            (G_UNICODE_SCRIPT_BATAK . 93)
            (G_UNICODE_SCRIPT_BRAHMI . 94)
            (G_UNICODE_SCRIPT_MANDAIC . 95)
            (G_UNICODE_SCRIPT_CHAKMA . 96)
            (G_UNICODE_SCRIPT_MEROITIC_CURSIVE . 97)
            (G_UNICODE_SCRIPT_MEROITIC_HIEROGLYPHS . 98)
            (G_UNICODE_SCRIPT_MIAO . 99)
            (G_UNICODE_SCRIPT_SHARADA . 100)
            (G_UNICODE_SCRIPT_SORA_SOMPENG . 101)
            (G_UNICODE_SCRIPT_TAKRI . 102)
            (G_UNICODE_SCRIPT_BASSA_VAH . 103)
            (G_UNICODE_SCRIPT_CAUCASIAN_ALBANIAN . 104)
            (G_UNICODE_SCRIPT_DUPLOYAN . 105)
            (G_UNICODE_SCRIPT_ELBASAN . 106)
            (G_UNICODE_SCRIPT_GRANTHA . 107)
            (G_UNICODE_SCRIPT_KHOJKI . 108)
            (G_UNICODE_SCRIPT_KHUDAWADI . 109)
            (G_UNICODE_SCRIPT_LINEAR_A . 110)
            (G_UNICODE_SCRIPT_MAHAJANI . 111)
            (G_UNICODE_SCRIPT_MANICHAEAN . 112)
            (G_UNICODE_SCRIPT_MENDE_KIKAKUI . 113)
            (G_UNICODE_SCRIPT_MODI . 114)
            (G_UNICODE_SCRIPT_MRO . 115)
            (G_UNICODE_SCRIPT_NABATAEAN . 116)
            (G_UNICODE_SCRIPT_OLD_NORTH_ARABIAN . 117)
            (G_UNICODE_SCRIPT_OLD_PERMIC . 118)
            (G_UNICODE_SCRIPT_PAHAWH_HMONG . 119)
            (G_UNICODE_SCRIPT_PALMYRENE . 120)
            (G_UNICODE_SCRIPT_PAU_CIN_HAU . 121)
            (G_UNICODE_SCRIPT_PSALTER_PAHLAVI . 122)
            (G_UNICODE_SCRIPT_SIDDHAM . 123)
            (G_UNICODE_SCRIPT_TIRHUTA . 124)
            (G_UNICODE_SCRIPT_WARANG_CITI . 125)
            (G_UNICODE_SCRIPT_AHOM . 126)
            (G_UNICODE_SCRIPT_ANATOLIAN_HIEROGLYPHS . 127)
            (G_UNICODE_SCRIPT_HATRAN . 128)
            (G_UNICODE_SCRIPT_MULTANI . 129)
            (G_UNICODE_SCRIPT_OLD_HUNGARIAN . 130)
            (G_UNICODE_SCRIPT_SIGNWRITING . 131)
            (G_UNICODE_SCRIPT_ADLAM . 132)
            (G_UNICODE_SCRIPT_BHAIKSUKI . 133)
            (G_UNICODE_SCRIPT_MARCHEN . 134)
            (G_UNICODE_SCRIPT_NEWA . 135)
            (G_UNICODE_SCRIPT_OSAGE . 136)
            (G_UNICODE_SCRIPT_TANGUT . 137)
            (G_NORMALIZE_DEFAULT . 0)
            (G_NORMALIZE_NFD . 0)
            (G_NORMALIZE_DEFAULT_COMPOSE . 1)
            (G_NORMALIZE_NFC . 1)
            (G_NORMALIZE_ALL . 2)
            (G_NORMALIZE_NFKD . 2)
            (G_NORMALIZE_ALL_COMPOSE . 3)
            (G_NORMALIZE_NFKC . 3)
            (G_IO_ERROR_NONE . 0)
            (G_IO_ERROR_AGAIN . 1)
            (G_IO_ERROR_INVAL . 2)
            (G_IO_ERROR_UNKNOWN . 3)
            (G_IO_CHANNEL_ERROR_FBIG . 0)
            (G_IO_CHANNEL_ERROR_INVAL . 1)
            (G_IO_CHANNEL_ERROR_IO . 2)
            (G_IO_CHANNEL_ERROR_ISDIR . 3)
            (G_IO_CHANNEL_ERROR_NOSPC . 4)
            (G_IO_CHANNEL_ERROR_NXIO . 5)
            (G_IO_CHANNEL_ERROR_OVERFLOW . 6)
            (G_IO_CHANNEL_ERROR_PIPE . 7)
            (G_IO_CHANNEL_ERROR_FAILED . 8)
            (G_IO_STATUS_ERROR . 0)
            (G_IO_STATUS_NORMAL . 1)
            (G_IO_STATUS_EOF . 2)
            (G_IO_STATUS_AGAIN . 3)
            (G_SEEK_CUR . 0)
            (G_SEEK_SET . 1)
            (G_SEEK_END . 2)
            (G_IO_FLAG_APPEND . 1)
            (G_IO_FLAG_NONBLOCK . 2)
            (G_IO_FLAG_IS_READABLE . 4)
            (G_IO_FLAG_IS_WRITABLE . 8)
            (G_IO_FLAG_IS_WRITEABLE . 8)
            (G_IO_FLAG_IS_SEEKABLE . 16)
            (G_IO_FLAG_MASK . 31)
            (G_IO_FLAG_GET_MASK . 31)
            (G_IO_FLAG_SET_MASK . 3)
            (G_KEY_FILE_ERROR_UNKNOWN_ENCODING . 0)
            (G_KEY_FILE_ERROR_PARSE . 1)
            (G_KEY_FILE_ERROR_NOT_FOUND . 2)
            (G_KEY_FILE_ERROR_KEY_NOT_FOUND . 3)
            (G_KEY_FILE_ERROR_GROUP_NOT_FOUND . 4)
            (G_KEY_FILE_ERROR_INVALID_VALUE . 5)
            (G_KEY_FILE_NONE . 0)
            (G_KEY_FILE_KEEP_COMMENTS . 1)
            (G_KEY_FILE_KEEP_TRANSLATIONS . 2)
            (G_MARKUP_ERROR_BAD_UTF8 . 0)
            (G_MARKUP_ERROR_EMPTY . 1)
            (G_MARKUP_ERROR_PARSE . 2)
            (G_MARKUP_ERROR_UNKNOWN_ELEMENT . 3)
            (G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE . 4)
            (G_MARKUP_ERROR_INVALID_CONTENT . 5)
            (G_MARKUP_ERROR_MISSING_ATTRIBUTE . 6)
            (G_MARKUP_DO_NOT_USE_THIS_UNSUPPORTED_FLAG . 1)
            (G_MARKUP_TREAT_CDATA_AS_TEXT . 2)
            (G_MARKUP_PREFIX_ERROR_POSITION . 4)
            (G_MARKUP_IGNORE_QUALIFIED . 8)
            (G_MARKUP_COLLECT_INVALID . 0)
            (G_MARKUP_COLLECT_STRING . 1)
            (G_MARKUP_COLLECT_STRDUP . 2)
            (G_MARKUP_COLLECT_BOOLEAN . 3)
            (G_MARKUP_COLLECT_TRISTATE . 4)
            (G_MARKUP_COLLECT_OPTIONAL . 65536)
            (G_VARIANT_CLASS_BOOLEAN . 98)
            (G_VARIANT_CLASS_BYTE . 121)
            (G_VARIANT_CLASS_INT16 . 110)
            (G_VARIANT_CLASS_UINT16 . 113)
            (G_VARIANT_CLASS_INT32 . 105)
            (G_VARIANT_CLASS_UINT32 . 117)
            (G_VARIANT_CLASS_INT64 . 120)
            (G_VARIANT_CLASS_UINT64 . 116)
            (G_VARIANT_CLASS_HANDLE . 104)
            (G_VARIANT_CLASS_DOUBLE . 100)
            (G_VARIANT_CLASS_STRING . 115)
            (G_VARIANT_CLASS_OBJECT_PATH . 111)
            (G_VARIANT_CLASS_SIGNATURE . 103)
            (G_VARIANT_CLASS_VARIANT . 118)
            (G_VARIANT_CLASS_MAYBE . 109)
            (G_VARIANT_CLASS_ARRAY . 97)
            (G_VARIANT_CLASS_TUPLE . 40)
            (G_VARIANT_CLASS_DICT_ENTRY . 123)
            (G_VARIANT_PARSE_ERROR_FAILED . 0)
            (G_VARIANT_PARSE_ERROR_BASIC_TYPE_EXPECTED . 1)
            (G_VARIANT_PARSE_ERROR_CANNOT_INFER_TYPE . 2)
            (G_VARIANT_PARSE_ERROR_DEFINITE_TYPE_EXPECTED
              .
              3)
            (G_VARIANT_PARSE_ERROR_INPUT_NOT_AT_END . 4)
            (G_VARIANT_PARSE_ERROR_INVALID_CHARACTER . 5)
            (G_VARIANT_PARSE_ERROR_INVALID_FORMAT_STRING . 6)
            (G_VARIANT_PARSE_ERROR_INVALID_OBJECT_PATH . 7)
            (G_VARIANT_PARSE_ERROR_INVALID_SIGNATURE . 8)
            (G_VARIANT_PARSE_ERROR_INVALID_TYPE_STRING . 9)
            (G_VARIANT_PARSE_ERROR_NO_COMMON_TYPE . 10)
            (G_VARIANT_PARSE_ERROR_NUMBER_OUT_OF_RANGE . 11)
            (G_VARIANT_PARSE_ERROR_NUMBER_TOO_BIG . 12)
            (G_VARIANT_PARSE_ERROR_TYPE_ERROR . 13)
            (G_VARIANT_PARSE_ERROR_UNEXPECTED_TOKEN . 14)
            (G_VARIANT_PARSE_ERROR_UNKNOWN_KEYWORD . 15)
            (G_VARIANT_PARSE_ERROR_UNTERMINATED_STRING_CONSTANT
              .
              16)
            (G_VARIANT_PARSE_ERROR_VALUE_EXPECTED . 17)
            (G_LOG_FLAG_RECURSION . 1)
            (G_LOG_FLAG_FATAL . 2)
            (G_LOG_LEVEL_ERROR . 4)
            (G_LOG_LEVEL_CRITICAL . 8)
            (G_LOG_LEVEL_WARNING . 16)
            (G_LOG_LEVEL_MESSAGE . 32)
            (G_LOG_LEVEL_INFO . 64)
            (G_LOG_LEVEL_DEBUG . 128)
            (G_LOG_LEVEL_MASK . -4)
            (G_LOG_WRITER_HANDLED . 1)
            (G_LOG_WRITER_UNHANDLED . 0)
            (G_OPTION_FLAG_NONE . 0)
            (G_OPTION_FLAG_HIDDEN . 1)
            (G_OPTION_FLAG_IN_MAIN . 2)
            (G_OPTION_FLAG_REVERSE . 4)
            (G_OPTION_FLAG_NO_ARG . 8)
            (G_OPTION_FLAG_FILENAME . 16)
            (G_OPTION_FLAG_OPTIONAL_ARG . 32)
            (G_OPTION_FLAG_NOALIAS . 64)
            (G_OPTION_ARG_NONE . 0)
            (G_OPTION_ARG_STRING . 1)
            (G_OPTION_ARG_INT . 2)
            (G_OPTION_ARG_CALLBACK . 3)
            (G_OPTION_ARG_FILENAME . 4)
            (G_OPTION_ARG_STRING_ARRAY . 5)
            (G_OPTION_ARG_FILENAME_ARRAY . 6)
            (G_OPTION_ARG_DOUBLE . 7)
            (G_OPTION_ARG_INT64 . 8)
            (G_OPTION_ERROR_UNKNOWN_OPTION . 0)
            (G_OPTION_ERROR_BAD_VALUE . 1)
            (G_OPTION_ERROR_FAILED . 2)
            (G_REGEX_ERROR_COMPILE . 0)
            (G_REGEX_ERROR_OPTIMIZE . 1)
            (G_REGEX_ERROR_REPLACE . 2)
            (G_REGEX_ERROR_MATCH . 3)
            (G_REGEX_ERROR_INTERNAL . 4)
            (G_REGEX_ERROR_STRAY_BACKSLASH . 101)
            (G_REGEX_ERROR_MISSING_CONTROL_CHAR . 102)
            (G_REGEX_ERROR_UNRECOGNIZED_ESCAPE . 103)
            (G_REGEX_ERROR_QUANTIFIERS_OUT_OF_ORDER . 104)
            (G_REGEX_ERROR_QUANTIFIER_TOO_BIG . 105)
            (G_REGEX_ERROR_UNTERMINATED_CHARACTER_CLASS
              .
              106)
            (G_REGEX_ERROR_INVALID_ESCAPE_IN_CHARACTER_CLASS
              .
              107)
            (G_REGEX_ERROR_RANGE_OUT_OF_ORDER . 108)
            (G_REGEX_ERROR_NOTHING_TO_REPEAT . 109)
            (G_REGEX_ERROR_UNRECOGNIZED_CHARACTER . 112)
            (G_REGEX_ERROR_POSIX_NAMED_CLASS_OUTSIDE_CLASS
              .
              113)
            (G_REGEX_ERROR_UNMATCHED_PARENTHESIS . 114)
            (G_REGEX_ERROR_INEXISTENT_SUBPATTERN_REFERENCE
              .
              115)
            (G_REGEX_ERROR_UNTERMINATED_COMMENT . 118)
            (G_REGEX_ERROR_EXPRESSION_TOO_LARGE . 120)
            (G_REGEX_ERROR_MEMORY_ERROR . 121)
            (G_REGEX_ERROR_VARIABLE_LENGTH_LOOKBEHIND . 125)
            (G_REGEX_ERROR_MALFORMED_CONDITION . 126)
            (G_REGEX_ERROR_TOO_MANY_CONDITIONAL_BRANCHES
              .
              127)
            (G_REGEX_ERROR_ASSERTION_EXPECTED . 128)
            (G_REGEX_ERROR_UNKNOWN_POSIX_CLASS_NAME . 130)
            (G_REGEX_ERROR_POSIX_COLLATING_ELEMENTS_NOT_SUPPORTED
              .
              131)
            (G_REGEX_ERROR_HEX_CODE_TOO_LARGE . 134)
            (G_REGEX_ERROR_INVALID_CONDITION . 135)
            (G_REGEX_ERROR_SINGLE_BYTE_MATCH_IN_LOOKBEHIND
              .
              136)
            (G_REGEX_ERROR_INFINITE_LOOP . 140)
            (G_REGEX_ERROR_MISSING_SUBPATTERN_NAME_TERMINATOR
              .
              142)
            (G_REGEX_ERROR_DUPLICATE_SUBPATTERN_NAME . 143)
            (G_REGEX_ERROR_MALFORMED_PROPERTY . 146)
            (G_REGEX_ERROR_UNKNOWN_PROPERTY . 147)
            (G_REGEX_ERROR_SUBPATTERN_NAME_TOO_LONG . 148)
            (G_REGEX_ERROR_TOO_MANY_SUBPATTERNS . 149)
            (G_REGEX_ERROR_INVALID_OCTAL_VALUE . 151)
            (G_REGEX_ERROR_TOO_MANY_BRANCHES_IN_DEFINE . 154)
            (G_REGEX_ERROR_DEFINE_REPETION . 155)
            (G_REGEX_ERROR_INCONSISTENT_NEWLINE_OPTIONS
              .
              156)
            (G_REGEX_ERROR_MISSING_BACK_REFERENCE . 157)
            (G_REGEX_ERROR_INVALID_RELATIVE_REFERENCE . 158)
            (G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_FORBIDDEN
              .
              159)
            (G_REGEX_ERROR_UNKNOWN_BACKTRACKING_CONTROL_VERB
              .
              160)
            (G_REGEX_ERROR_NUMBER_TOO_BIG . 161)
            (G_REGEX_ERROR_MISSING_SUBPATTERN_NAME . 162)
            (G_REGEX_ERROR_MISSING_DIGIT . 163)
            (G_REGEX_ERROR_INVALID_DATA_CHARACTER . 164)
            (G_REGEX_ERROR_EXTRA_SUBPATTERN_NAME . 165)
            (G_REGEX_ERROR_BACKTRACKING_CONTROL_VERB_ARGUMENT_REQUIRED
              .
              166)
            (G_REGEX_ERROR_INVALID_CONTROL_CHAR . 168)
            (G_REGEX_ERROR_MISSING_NAME . 169)
            (G_REGEX_ERROR_NOT_SUPPORTED_IN_CLASS . 171)
            (G_REGEX_ERROR_TOO_MANY_FORWARD_REFERENCES . 172)
            (G_REGEX_ERROR_NAME_TOO_LONG . 175)
            (G_REGEX_ERROR_CHARACTER_VALUE_TOO_LARGE . 176)
            (G_REGEX_CASELESS . 1)
            (G_REGEX_MULTILINE . 2)
            (G_REGEX_DOTALL . 4)
            (G_REGEX_EXTENDED . 8)
            (G_REGEX_ANCHORED . 16)
            (G_REGEX_DOLLAR_ENDONLY . 32)
            (G_REGEX_UNGREEDY . 512)
            (G_REGEX_RAW . 2048)
            (G_REGEX_NO_AUTO_CAPTURE . 4096)
            (G_REGEX_OPTIMIZE . 8192)
            (G_REGEX_FIRSTLINE . 262144)
            (G_REGEX_DUPNAMES . 524288)
            (G_REGEX_NEWLINE_CR . 1048576)
            (G_REGEX_NEWLINE_LF . 2097152)
            (G_REGEX_NEWLINE_CRLF . 3145728)
            (G_REGEX_NEWLINE_ANYCRLF . 5242880)
            (G_REGEX_BSR_ANYCRLF . 8388608)
            (G_REGEX_JAVASCRIPT_COMPAT . 33554432)
            (G_REGEX_MATCH_ANCHORED . 16)
            (G_REGEX_MATCH_NOTBOL . 128)
            (G_REGEX_MATCH_NOTEOL . 256)
            (G_REGEX_MATCH_NOTEMPTY . 1024)
            (G_REGEX_MATCH_PARTIAL . 32768)
            (G_REGEX_MATCH_NEWLINE_CR . 1048576)
            (G_REGEX_MATCH_NEWLINE_LF . 2097152)
            (G_REGEX_MATCH_NEWLINE_CRLF . 3145728)
            (G_REGEX_MATCH_NEWLINE_ANY . 4194304)
            (G_REGEX_MATCH_NEWLINE_ANYCRLF . 5242880)
            (G_REGEX_MATCH_BSR_ANYCRLF . 8388608)
            (G_REGEX_MATCH_BSR_ANY . 16777216)
            (G_REGEX_MATCH_PARTIAL_SOFT . 32768)
            (G_REGEX_MATCH_PARTIAL_HARD . 134217728)
            (G_REGEX_MATCH_NOTEMPTY_ATSTART . 268435456)
            (G_ERR_UNKNOWN . 0)
            (G_ERR_UNEXP_EOF . 1)
            (G_ERR_UNEXP_EOF_IN_STRING . 2)
            (G_ERR_UNEXP_EOF_IN_COMMENT . 3)
            (G_ERR_NON_DIGIT_IN_CONST . 4)
            (G_ERR_DIGIT_RADIX . 5)
            (G_ERR_FLOAT_RADIX . 6)
            (G_ERR_FLOAT_MALFORMED . 7)
            (G_TOKEN_EOF . 0)
            (G_TOKEN_LEFT_PAREN . 40)
            (G_TOKEN_RIGHT_PAREN . 41)
            (G_TOKEN_LEFT_CURLY . 123)
            (G_TOKEN_RIGHT_CURLY . 125)
            (G_TOKEN_LEFT_BRACE . 91)
            (G_TOKEN_RIGHT_BRACE . 93)
            (G_TOKEN_EQUAL_SIGN . 61)
            (G_TOKEN_COMMA . 44)
            (G_TOKEN_NONE . 256)
            (G_TOKEN_ERROR . 257)
            (G_TOKEN_CHAR . 258)
            (G_TOKEN_BINARY . 259)
            (G_TOKEN_OCTAL . 260)
            (G_TOKEN_INT . 261)
            (G_TOKEN_HEX . 262)
            (G_TOKEN_FLOAT . 263)
            (G_TOKEN_STRING . 264)
            (G_TOKEN_SYMBOL . 265)
            (G_TOKEN_IDENTIFIER . 266)
            (G_TOKEN_IDENTIFIER_NULL . 267)
            (G_TOKEN_COMMENT_SINGLE . 268)
            (G_TOKEN_COMMENT_MULTI . 269)
            (G_TOKEN_LAST . 270)
            (G_SHELL_ERROR_BAD_QUOTING . 0)
            (G_SHELL_ERROR_EMPTY_STRING . 1)
            (G_SHELL_ERROR_FAILED . 2)
            (G_SLICE_CONFIG_ALWAYS_MALLOC . 1)
            (G_SLICE_CONFIG_BYPASS_MAGAZINES . 2)
            (G_SLICE_CONFIG_WORKING_SET_MSECS . 3)
            (G_SLICE_CONFIG_COLOR_INCREMENT . 4)
            (G_SLICE_CONFIG_CHUNK_SIZES . 5)
            (G_SLICE_CONFIG_CONTENTION_COUNTER . 6)
            (G_SPAWN_ERROR_FORK . 0)
            (G_SPAWN_ERROR_READ . 1)
            (G_SPAWN_ERROR_CHDIR . 2)
            (G_SPAWN_ERROR_ACCES . 3)
            (G_SPAWN_ERROR_PERM . 4)
            (G_SPAWN_ERROR_TOO_BIG . 5)
            (G_SPAWN_ERROR_2BIG . 5)
            (G_SPAWN_ERROR_NOEXEC . 6)
            (G_SPAWN_ERROR_NAMETOOLONG . 7)
            (G_SPAWN_ERROR_NOENT . 8)
            (G_SPAWN_ERROR_NOMEM . 9)
            (G_SPAWN_ERROR_NOTDIR . 10)
            (G_SPAWN_ERROR_LOOP . 11)
            (G_SPAWN_ERROR_TXTBUSY . 12)
            (G_SPAWN_ERROR_IO . 13)
            (G_SPAWN_ERROR_NFILE . 14)
            (G_SPAWN_ERROR_MFILE . 15)
            (G_SPAWN_ERROR_INVAL . 16)
            (G_SPAWN_ERROR_ISDIR . 17)
            (G_SPAWN_ERROR_LIBBAD . 18)
            (G_SPAWN_ERROR_FAILED . 19)
            (G_SPAWN_DEFAULT . 0)
            (G_SPAWN_LEAVE_DESCRIPTORS_OPEN . 1)
            (G_SPAWN_DO_NOT_REAP_CHILD . 2)
            (G_SPAWN_SEARCH_PATH . 4)
            (G_SPAWN_STDOUT_TO_DEV_NULL . 8)
            (G_SPAWN_STDERR_TO_DEV_NULL . 16)
            (G_SPAWN_CHILD_INHERITS_STDIN . 32)
            (G_SPAWN_FILE_AND_ARGV_ZERO . 64)
            (G_SPAWN_SEARCH_PATH_FROM_ENVP . 128)
            (G_SPAWN_CLOEXEC_PIPES . 256)
            (G_ASCII_ALNUM . 1)
            (G_ASCII_ALPHA . 2)
            (G_ASCII_CNTRL . 4)
            (G_ASCII_DIGIT . 8)
            (G_ASCII_GRAPH . 16)
            (G_ASCII_LOWER . 32)
            (G_ASCII_PRINT . 64)
            (G_ASCII_PUNCT . 128)
            (G_ASCII_SPACE . 256)
            (G_ASCII_UPPER . 512)
            (G_ASCII_XDIGIT . 1024)
            (G_TEST_TRAP_SILENCE_STDOUT . 128)
            (G_TEST_TRAP_SILENCE_STDERR . 256)
            (G_TEST_TRAP_INHERIT_STDIN . 512)
            (G_TEST_SUBPROCESS_INHERIT_STDIN . 1)
            (G_TEST_SUBPROCESS_INHERIT_STDOUT . 2)
            (G_TEST_SUBPROCESS_INHERIT_STDERR . 4)
            (G_TEST_LOG_NONE . 0)
            (G_TEST_LOG_ERROR . 1)
            (G_TEST_LOG_START_BINARY . 2)
            (G_TEST_LOG_LIST_CASE . 3)
            (G_TEST_LOG_SKIP_CASE . 4)
            (G_TEST_LOG_START_CASE . 5)
            (G_TEST_LOG_STOP_CASE . 6)
            (G_TEST_LOG_MIN_RESULT . 7)
            (G_TEST_LOG_MAX_RESULT . 8)
            (G_TEST_LOG_MESSAGE . 9)
            (G_TEST_LOG_START_SUITE . 10)
            (G_TEST_LOG_STOP_SUITE . 11)
            (G_TEST_DIST . 0)
            (G_TEST_BUILT . 1)
            (G_THREAD_PRIORITY_LOW . 0)
            (G_THREAD_PRIORITY_NORMAL . 1)
            (G_THREAD_PRIORITY_HIGH . 2)
            (G_THREAD_PRIORITY_URGENT . 3)
            (QOS_CLASS_USER_INTERACTIVE . 33)
            (QOS_CLASS_USER_INITIATED . 25)
            (QOS_CLASS_DEFAULT . 21)
            (QOS_CLASS_UTILITY . 17)
            (QOS_CLASS_BACKGROUND . 9)
            (QOS_CLASS_UNSPECIFIED . 0)
            (G_TYPE_DEBUG_NONE . 0)
            (G_TYPE_DEBUG_OBJECTS . 1)
            (G_TYPE_DEBUG_SIGNALS . 2)
            (G_TYPE_DEBUG_INSTANCE_COUNT . 4)
            (G_TYPE_DEBUG_MASK . 7)
            (G_TYPE_FLAG_CLASSED . 1)
            (G_TYPE_FLAG_INSTANTIATABLE . 2)
            (G_TYPE_FLAG_DERIVABLE . 4)
            (G_TYPE_FLAG_DEEP_DERIVABLE . 8)
            (G_TYPE_FLAG_ABSTRACT . 16)
            (G_TYPE_FLAG_VALUE_ABSTRACT . 32)
            (G_PARAM_READABLE . 1)
            (G_PARAM_WRITABLE . 2)
            (G_PARAM_READWRITE . 3)
            (G_PARAM_CONSTRUCT . 4)
            (G_PARAM_CONSTRUCT_ONLY . 8)
            (G_PARAM_LAX_VALIDATION . 16)
            (G_PARAM_STATIC_NAME . 32)
            (G_PARAM_PRIVATE . 32)
            (G_PARAM_STATIC_NICK . 64)
            (G_PARAM_STATIC_BLURB . 128)
            (G_PARAM_EXPLICIT_NOTIFY . 1073741824)
            (G_PARAM_DEPRECATED . 2147483648)
            (G_SIGNAL_RUN_FIRST . 1)
            (G_SIGNAL_RUN_LAST . 2)
            (G_SIGNAL_RUN_CLEANUP . 4)
            (G_SIGNAL_NO_RECURSE . 8)
            (G_SIGNAL_DETAILED . 16)
            (G_SIGNAL_ACTION . 32)
            (G_SIGNAL_NO_HOOKS . 64)
            (G_SIGNAL_MUST_COLLECT . 128)
            (G_SIGNAL_DEPRECATED . 256)
            (G_CONNECT_AFTER . 1)
            (G_CONNECT_SWAPPED . 2)
            (G_SIGNAL_MATCH_ID . 1)
            (G_SIGNAL_MATCH_DETAIL . 2)
            (G_SIGNAL_MATCH_CLOSURE . 4)
            (G_SIGNAL_MATCH_FUNC . 8)
            (G_SIGNAL_MATCH_DATA . 16)
            (G_SIGNAL_MATCH_UNBLOCKED . 32)
            (G_BINDING_DEFAULT . 0)
            (G_BINDING_BIDIRECTIONAL . 1)
            (G_BINDING_SYNC_CREATE . 2)
            (G_BINDING_INVERT_BOOLEAN . 4)
            (G_APP_INFO_CREATE_NONE . 0)
            (G_APP_INFO_CREATE_NEEDS_TERMINAL . 1)
            (G_APP_INFO_CREATE_SUPPORTS_URIS . 2)
            (G_APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION
              .
              4)
            (G_CONVERTER_NO_FLAGS . 0)
            (G_CONVERTER_INPUT_AT_END . 1)
            (G_CONVERTER_FLUSH . 2)
            (G_CONVERTER_ERROR . 0)
            (G_CONVERTER_CONVERTED . 1)
            (G_CONVERTER_FINISHED . 2)
            (G_CONVERTER_FLUSHED . 3)
            (G_DATA_STREAM_BYTE_ORDER_BIG_ENDIAN . 0)
            (G_DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN . 1)
            (G_DATA_STREAM_BYTE_ORDER_HOST_ENDIAN . 2)
            (G_DATA_STREAM_NEWLINE_TYPE_LF . 0)
            (G_DATA_STREAM_NEWLINE_TYPE_CR . 1)
            (G_DATA_STREAM_NEWLINE_TYPE_CR_LF . 2)
            (G_DATA_STREAM_NEWLINE_TYPE_ANY . 3)
            (G_FILE_ATTRIBUTE_TYPE_INVALID . 0)
            (G_FILE_ATTRIBUTE_TYPE_STRING . 1)
            (G_FILE_ATTRIBUTE_TYPE_BYTE_STRING . 2)
            (G_FILE_ATTRIBUTE_TYPE_BOOLEAN . 3)
            (G_FILE_ATTRIBUTE_TYPE_UINT32 . 4)
            (G_FILE_ATTRIBUTE_TYPE_INT32 . 5)
            (G_FILE_ATTRIBUTE_TYPE_UINT64 . 6)
            (G_FILE_ATTRIBUTE_TYPE_INT64 . 7)
            (G_FILE_ATTRIBUTE_TYPE_OBJECT . 8)
            (G_FILE_ATTRIBUTE_TYPE_STRINGV . 9)
            (G_FILE_ATTRIBUTE_INFO_NONE . 0)
            (G_FILE_ATTRIBUTE_INFO_COPY_WITH_FILE . 1)
            (G_FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED . 2)
            (G_FILE_ATTRIBUTE_STATUS_UNSET . 0)
            (G_FILE_ATTRIBUTE_STATUS_SET . 1)
            (G_FILE_ATTRIBUTE_STATUS_ERROR_SETTING . 2)
            (G_FILE_QUERY_INFO_NONE . 0)
            (G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS . 1)
            (G_FILE_CREATE_NONE . 0)
            (G_FILE_CREATE_PRIVATE . 1)
            (G_FILE_CREATE_REPLACE_DESTINATION . 2)
            (G_FILE_MEASURE_NONE . 0)
            (G_FILE_MEASURE_REPORT_ANY_ERROR . 2)
            (G_FILE_MEASURE_APPARENT_SIZE . 4)
            (G_FILE_MEASURE_NO_XDEV . 8)
            (G_MOUNT_MOUNT_NONE . 0)
            (G_MOUNT_UNMOUNT_NONE . 0)
            (G_MOUNT_UNMOUNT_FORCE . 1)
            (G_DRIVE_START_NONE . 0)
            (G_DRIVE_START_STOP_TYPE_UNKNOWN . 0)
            (G_DRIVE_START_STOP_TYPE_SHUTDOWN . 1)
            (G_DRIVE_START_STOP_TYPE_NETWORK . 2)
            (G_DRIVE_START_STOP_TYPE_MULTIDISK . 3)
            (G_DRIVE_START_STOP_TYPE_PASSWORD . 4)
            (G_FILE_COPY_NONE . 0)
            (G_FILE_COPY_OVERWRITE . 1)
            (G_FILE_COPY_BACKUP . 2)
            (G_FILE_COPY_NOFOLLOW_SYMLINKS . 4)
            (G_FILE_COPY_ALL_METADATA . 8)
            (G_FILE_COPY_NO_FALLBACK_FOR_MOVE . 16)
            (G_FILE_COPY_TARGET_DEFAULT_PERMS . 32)
            (G_FILE_MONITOR_NONE . 0)
            (G_FILE_MONITOR_WATCH_MOUNTS . 1)
            (G_FILE_MONITOR_SEND_MOVED . 2)
            (G_FILE_MONITOR_WATCH_HARD_LINKS . 4)
            (G_FILE_MONITOR_WATCH_MOVES . 8)
            (G_FILE_TYPE_UNKNOWN . 0)
            (G_FILE_TYPE_REGULAR . 1)
            (G_FILE_TYPE_DIRECTORY . 2)
            (G_FILE_TYPE_SYMBOLIC_LINK . 3)
            (G_FILE_TYPE_SPECIAL . 4)
            (G_FILE_TYPE_SHORTCUT . 5)
            (G_FILE_TYPE_MOUNTABLE . 6)
            (G_FILESYSTEM_PREVIEW_TYPE_IF_ALWAYS . 0)
            (G_FILESYSTEM_PREVIEW_TYPE_IF_LOCAL . 1)
            (G_FILESYSTEM_PREVIEW_TYPE_NEVER . 2)
            (G_FILE_MONITOR_EVENT_CHANGED . 0)
            (G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT . 1)
            (G_FILE_MONITOR_EVENT_DELETED . 2)
            (G_FILE_MONITOR_EVENT_CREATED . 3)
            (G_FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED . 4)
            (G_FILE_MONITOR_EVENT_PRE_UNMOUNT . 5)
            (G_FILE_MONITOR_EVENT_UNMOUNTED . 6)
            (G_FILE_MONITOR_EVENT_MOVED . 7)
            (G_FILE_MONITOR_EVENT_RENAMED . 8)
            (G_FILE_MONITOR_EVENT_MOVED_IN . 9)
            (G_FILE_MONITOR_EVENT_MOVED_OUT . 10)
            (G_IO_ERROR_FAILED . 0)
            (G_IO_ERROR_NOT_FOUND . 1)
            (G_IO_ERROR_EXISTS . 2)
            (G_IO_ERROR_IS_DIRECTORY . 3)
            (G_IO_ERROR_NOT_DIRECTORY . 4)
            (G_IO_ERROR_NOT_EMPTY . 5)
            (G_IO_ERROR_NOT_REGULAR_FILE . 6)
            (G_IO_ERROR_NOT_SYMBOLIC_LINK . 7)
            (G_IO_ERROR_NOT_MOUNTABLE_FILE . 8)
            (G_IO_ERROR_FILENAME_TOO_LONG . 9)
            (G_IO_ERROR_INVALID_FILENAME . 10)
            (G_IO_ERROR_TOO_MANY_LINKS . 11)
            (G_IO_ERROR_NO_SPACE . 12)
            (G_IO_ERROR_INVALID_ARGUMENT . 13)
            (G_IO_ERROR_PERMISSION_DENIED . 14)
            (G_IO_ERROR_NOT_SUPPORTED . 15)
            (G_IO_ERROR_NOT_MOUNTED . 16)
            (G_IO_ERROR_ALREADY_MOUNTED . 17)
            (G_IO_ERROR_CLOSED . 18)
            (G_IO_ERROR_CANCELLED . 19)
            (G_IO_ERROR_PENDING . 20)
            (G_IO_ERROR_READ_ONLY . 21)
            (G_IO_ERROR_CANT_CREATE_BACKUP . 22)
            (G_IO_ERROR_WRONG_ETAG . 23)
            (G_IO_ERROR_TIMED_OUT . 24)
            (G_IO_ERROR_WOULD_RECURSE . 25)
            (G_IO_ERROR_BUSY . 26)
            (G_IO_ERROR_WOULD_BLOCK . 27)
            (G_IO_ERROR_HOST_NOT_FOUND . 28)
            (G_IO_ERROR_WOULD_MERGE . 29)
            (G_IO_ERROR_FAILED_HANDLED . 30)
            (G_IO_ERROR_TOO_MANY_OPEN_FILES . 31)
            (G_IO_ERROR_NOT_INITIALIZED . 32)
            (G_IO_ERROR_ADDRESS_IN_USE . 33)
            (G_IO_ERROR_PARTIAL_INPUT . 34)
            (G_IO_ERROR_INVALID_DATA . 35)
            (G_IO_ERROR_DBUS_ERROR . 36)
            (G_IO_ERROR_HOST_UNREACHABLE . 37)
            (G_IO_ERROR_NETWORK_UNREACHABLE . 38)
            (G_IO_ERROR_CONNECTION_REFUSED . 39)
            (G_IO_ERROR_PROXY_FAILED . 40)
            (G_IO_ERROR_PROXY_AUTH_FAILED . 41)
            (G_IO_ERROR_PROXY_NEED_AUTH . 42)
            (G_IO_ERROR_PROXY_NOT_ALLOWED . 43)
            (G_IO_ERROR_BROKEN_PIPE . 44)
            (G_IO_ERROR_CONNECTION_CLOSED . 44)
            (G_IO_ERROR_NOT_CONNECTED . 45)
            (G_IO_ERROR_MESSAGE_TOO_LARGE . 46)
            (G_ASK_PASSWORD_NEED_PASSWORD . 1)
            (G_ASK_PASSWORD_NEED_USERNAME . 2)
            (G_ASK_PASSWORD_NEED_DOMAIN . 4)
            (G_ASK_PASSWORD_SAVING_SUPPORTED . 8)
            (G_ASK_PASSWORD_ANONYMOUS_SUPPORTED . 16)
            (G_PASSWORD_SAVE_NEVER . 0)
            (G_PASSWORD_SAVE_FOR_SESSION . 1)
            (G_PASSWORD_SAVE_PERMANENTLY . 2)
            (G_MOUNT_OPERATION_HANDLED . 0)
            (G_MOUNT_OPERATION_ABORTED . 1)
            (G_MOUNT_OPERATION_UNHANDLED . 2)
            (G_OUTPUT_STREAM_SPLICE_NONE . 0)
            (G_OUTPUT_STREAM_SPLICE_CLOSE_SOURCE . 1)
            (G_OUTPUT_STREAM_SPLICE_CLOSE_TARGET . 2)
            (G_IO_STREAM_SPLICE_NONE . 0)
            (G_IO_STREAM_SPLICE_CLOSE_STREAM1 . 1)
            (G_IO_STREAM_SPLICE_CLOSE_STREAM2 . 2)
            (G_IO_STREAM_SPLICE_WAIT_FOR_BOTH . 4)
            (G_EMBLEM_ORIGIN_UNKNOWN . 0)
            (G_EMBLEM_ORIGIN_DEVICE . 1)
            (G_EMBLEM_ORIGIN_LIVEMETADATA . 2)
            (G_EMBLEM_ORIGIN_TAG . 3)
            (G_RESOLVER_ERROR_NOT_FOUND . 0)
            (G_RESOLVER_ERROR_TEMPORARY_FAILURE . 1)
            (G_RESOLVER_ERROR_INTERNAL . 2)
            (G_RESOLVER_RECORD_SRV . 1)
            (G_RESOLVER_RECORD_MX . 2)
            (G_RESOLVER_RECORD_TXT . 3)
            (G_RESOLVER_RECORD_SOA . 4)
            (G_RESOLVER_RECORD_NS . 5)
            (G_RESOURCE_ERROR_NOT_FOUND . 0)
            (G_RESOURCE_ERROR_INTERNAL . 1)
            (G_RESOURCE_FLAGS_NONE . 0)
            (G_RESOURCE_FLAGS_COMPRESSED . 1)
            (G_RESOURCE_LOOKUP_FLAGS_NONE . 0)
            (G_SOCKET_FAMILY_INVALID . 0)
            (G_SOCKET_FAMILY_UNIX . 1)
            (G_SOCKET_FAMILY_IPV4 . 2)
            (G_SOCKET_FAMILY_IPV6 . 30)
            (G_SOCKET_TYPE_INVALID . 0)
            (G_SOCKET_TYPE_STREAM . 1)
            (G_SOCKET_TYPE_DATAGRAM . 2)
            (G_SOCKET_TYPE_SEQPACKET . 3)
            (G_SOCKET_MSG_NONE . 0)
            (G_SOCKET_MSG_OOB . 1)
            (G_SOCKET_MSG_PEEK . 2)
            (G_SOCKET_MSG_DONTROUTE . 4)
            (G_SOCKET_PROTOCOL_UNKNOWN . -1)
            (G_SOCKET_PROTOCOL_DEFAULT . 0)
            (G_SOCKET_PROTOCOL_TCP . 6)
            (G_SOCKET_PROTOCOL_UDP . 17)
            (G_SOCKET_PROTOCOL_SCTP . 132)
            (G_ZLIB_COMPRESSOR_FORMAT_ZLIB . 0)
            (G_ZLIB_COMPRESSOR_FORMAT_GZIP . 1)
            (G_ZLIB_COMPRESSOR_FORMAT_RAW . 2)
            (G_UNIX_SOCKET_ADDRESS_INVALID . 0)
            (G_UNIX_SOCKET_ADDRESS_ANONYMOUS . 1)
            (G_UNIX_SOCKET_ADDRESS_PATH . 2)
            (G_UNIX_SOCKET_ADDRESS_ABSTRACT . 3)
            (G_UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED . 4)
            (G_BUS_TYPE_STARTER . -1)
            (G_BUS_TYPE_NONE . 0)
            (G_BUS_TYPE_SYSTEM . 1)
            (G_BUS_TYPE_SESSION . 2)
            (G_BUS_NAME_OWNER_FLAGS_NONE . 0)
            (G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT . 1)
            (G_BUS_NAME_OWNER_FLAGS_REPLACE . 2)
            (G_BUS_NAME_WATCHER_FLAGS_NONE . 0)
            (G_BUS_NAME_WATCHER_FLAGS_AUTO_START . 1)
            (G_DBUS_PROXY_FLAGS_NONE . 0)
            (G_DBUS_PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES . 1)
            (G_DBUS_PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS . 2)
            (G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START . 4)
            (G_DBUS_PROXY_FLAGS_GET_INVALIDATED_PROPERTIES
              .
              8)
            (G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START_AT_CONSTRUCTION
              .
              16)
            (G_DBUS_ERROR_FAILED . 0)
            (G_DBUS_ERROR_NO_MEMORY . 1)
            (G_DBUS_ERROR_SERVICE_UNKNOWN . 2)
            (G_DBUS_ERROR_NAME_HAS_NO_OWNER . 3)
            (G_DBUS_ERROR_NO_REPLY . 4)
            (G_DBUS_ERROR_IO_ERROR . 5)
            (G_DBUS_ERROR_BAD_ADDRESS . 6)
            (G_DBUS_ERROR_NOT_SUPPORTED . 7)
            (G_DBUS_ERROR_LIMITS_EXCEEDED . 8)
            (G_DBUS_ERROR_ACCESS_DENIED . 9)
            (G_DBUS_ERROR_AUTH_FAILED . 10)
            (G_DBUS_ERROR_NO_SERVER . 11)
            (G_DBUS_ERROR_TIMEOUT . 12)
            (G_DBUS_ERROR_NO_NETWORK . 13)
            (G_DBUS_ERROR_ADDRESS_IN_USE . 14)
            (G_DBUS_ERROR_DISCONNECTED . 15)
            (G_DBUS_ERROR_INVALID_ARGS . 16)
            (G_DBUS_ERROR_FILE_NOT_FOUND . 17)
            (G_DBUS_ERROR_FILE_EXISTS . 18)
            (G_DBUS_ERROR_UNKNOWN_METHOD . 19)
            (G_DBUS_ERROR_TIMED_OUT . 20)
            (G_DBUS_ERROR_MATCH_RULE_NOT_FOUND . 21)
            (G_DBUS_ERROR_MATCH_RULE_INVALID . 22)
            (G_DBUS_ERROR_SPAWN_EXEC_FAILED . 23)
            (G_DBUS_ERROR_SPAWN_FORK_FAILED . 24)
            (G_DBUS_ERROR_SPAWN_CHILD_EXITED . 25)
            (G_DBUS_ERROR_SPAWN_CHILD_SIGNALED . 26)
            (G_DBUS_ERROR_SPAWN_FAILED . 27)
            (G_DBUS_ERROR_SPAWN_SETUP_FAILED . 28)
            (G_DBUS_ERROR_SPAWN_CONFIG_INVALID . 29)
            (G_DBUS_ERROR_SPAWN_SERVICE_INVALID . 30)
            (G_DBUS_ERROR_SPAWN_SERVICE_NOT_FOUND . 31)
            (G_DBUS_ERROR_SPAWN_PERMISSIONS_INVALID . 32)
            (G_DBUS_ERROR_SPAWN_FILE_INVALID . 33)
            (G_DBUS_ERROR_SPAWN_NO_MEMORY . 34)
            (G_DBUS_ERROR_UNIX_PROCESS_ID_UNKNOWN . 35)
            (G_DBUS_ERROR_INVALID_SIGNATURE . 36)
            (G_DBUS_ERROR_INVALID_FILE_CONTENT . 37)
            (G_DBUS_ERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN
              .
              38)
            (G_DBUS_ERROR_ADT_AUDIT_DATA_UNKNOWN . 39)
            (G_DBUS_ERROR_OBJECT_PATH_IN_USE . 40)
            (G_DBUS_ERROR_UNKNOWN_OBJECT . 41)
            (G_DBUS_ERROR_UNKNOWN_INTERFACE . 42)
            (G_DBUS_ERROR_UNKNOWN_PROPERTY . 43)
            (G_DBUS_ERROR_PROPERTY_READ_ONLY . 44)
            (G_DBUS_CONNECTION_FLAGS_NONE . 0)
            (G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT
              .
              1)
            (G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_SERVER
              .
              2)
            (G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS
              .
              4)
            (G_DBUS_CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION
              .
              8)
            (G_DBUS_CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING
              .
              16)
            (G_DBUS_CAPABILITY_FLAGS_NONE . 0)
            (G_DBUS_CAPABILITY_FLAGS_UNIX_FD_PASSING . 1)
            (G_DBUS_CALL_FLAGS_NONE . 0)
            (G_DBUS_CALL_FLAGS_NO_AUTO_START . 1)
            (G_DBUS_CALL_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION
              .
              2)
            (G_DBUS_MESSAGE_TYPE_INVALID . 0)
            (G_DBUS_MESSAGE_TYPE_METHOD_CALL . 1)
            (G_DBUS_MESSAGE_TYPE_METHOD_RETURN . 2)
            (G_DBUS_MESSAGE_TYPE_ERROR . 3)
            (G_DBUS_MESSAGE_TYPE_SIGNAL . 4)
            (G_DBUS_MESSAGE_FLAGS_NONE . 0)
            (G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED . 1)
            (G_DBUS_MESSAGE_FLAGS_NO_AUTO_START . 2)
            (G_DBUS_MESSAGE_FLAGS_ALLOW_INTERACTIVE_AUTHORIZATION
              .
              4)
            (G_DBUS_MESSAGE_HEADER_FIELD_INVALID . 0)
            (G_DBUS_MESSAGE_HEADER_FIELD_PATH . 1)
            (G_DBUS_MESSAGE_HEADER_FIELD_INTERFACE . 2)
            (G_DBUS_MESSAGE_HEADER_FIELD_MEMBER . 3)
            (G_DBUS_MESSAGE_HEADER_FIELD_ERROR_NAME . 4)
            (G_DBUS_MESSAGE_HEADER_FIELD_REPLY_SERIAL . 5)
            (G_DBUS_MESSAGE_HEADER_FIELD_DESTINATION . 6)
            (G_DBUS_MESSAGE_HEADER_FIELD_SENDER . 7)
            (G_DBUS_MESSAGE_HEADER_FIELD_SIGNATURE . 8)
            (G_DBUS_MESSAGE_HEADER_FIELD_NUM_UNIX_FDS . 9)
            (G_DBUS_PROPERTY_INFO_FLAGS_NONE . 0)
            (G_DBUS_PROPERTY_INFO_FLAGS_READABLE . 1)
            (G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE . 2)
            (G_DBUS_SUBTREE_FLAGS_NONE . 0)
            (G_DBUS_SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES
              .
              1)
            (G_DBUS_SERVER_FLAGS_NONE . 0)
            (G_DBUS_SERVER_FLAGS_RUN_IN_THREAD . 1)
            (G_DBUS_SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS
              .
              2)
            (G_DBUS_SIGNAL_FLAGS_NONE . 0)
            (G_DBUS_SIGNAL_FLAGS_NO_MATCH_RULE . 1)
            (G_DBUS_SIGNAL_FLAGS_MATCH_ARG0_NAMESPACE . 2)
            (G_DBUS_SIGNAL_FLAGS_MATCH_ARG0_PATH . 4)
            (G_DBUS_SEND_MESSAGE_FLAGS_NONE . 0)
            (G_DBUS_SEND_MESSAGE_FLAGS_PRESERVE_SERIAL . 1)
            (G_CREDENTIALS_TYPE_INVALID . 0)
            (G_CREDENTIALS_TYPE_LINUX_UCRED . 1)
            (G_CREDENTIALS_TYPE_FREEBSD_CMSGCRED . 2)
            (G_CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED . 3)
            (G_CREDENTIALS_TYPE_SOLARIS_UCRED . 4)
            (G_CREDENTIALS_TYPE_NETBSD_UNPCBID . 5)
            (G_DBUS_MESSAGE_BYTE_ORDER_BIG_ENDIAN . 66)
            (G_DBUS_MESSAGE_BYTE_ORDER_LITTLE_ENDIAN . 108)
            (G_APPLICATION_FLAGS_NONE . 0)
            (G_APPLICATION_IS_SERVICE . 1)
            (G_APPLICATION_IS_LAUNCHER . 2)
            (G_APPLICATION_HANDLES_OPEN . 4)
            (G_APPLICATION_HANDLES_COMMAND_LINE . 8)
            (G_APPLICATION_SEND_ENVIRONMENT . 16)
            (G_APPLICATION_NON_UNIQUE . 32)
            (G_APPLICATION_CAN_OVERRIDE_APP_ID . 64)
            (G_TLS_ERROR_UNAVAILABLE . 0)
            (G_TLS_ERROR_MISC . 1)
            (G_TLS_ERROR_BAD_CERTIFICATE . 2)
            (G_TLS_ERROR_NOT_TLS . 3)
            (G_TLS_ERROR_HANDSHAKE . 4)
            (G_TLS_ERROR_CERTIFICATE_REQUIRED . 5)
            (G_TLS_ERROR_EOF . 6)
            (G_TLS_CERTIFICATE_UNKNOWN_CA . 1)
            (G_TLS_CERTIFICATE_BAD_IDENTITY . 2)
            (G_TLS_CERTIFICATE_NOT_ACTIVATED . 4)
            (G_TLS_CERTIFICATE_EXPIRED . 8)
            (G_TLS_CERTIFICATE_REVOKED . 16)
            (G_TLS_CERTIFICATE_INSECURE . 32)
            (G_TLS_CERTIFICATE_GENERIC_ERROR . 64)
            (G_TLS_CERTIFICATE_VALIDATE_ALL . 127)
            (G_TLS_AUTHENTICATION_NONE . 0)
            (G_TLS_AUTHENTICATION_REQUESTED . 1)
            (G_TLS_AUTHENTICATION_REQUIRED . 2)
            (G_TLS_REHANDSHAKE_NEVER . 0)
            (G_TLS_REHANDSHAKE_SAFELY . 1)
            (G_TLS_REHANDSHAKE_UNSAFELY . 2)
            (G_TLS_PASSWORD_NONE . 0)
            (G_TLS_PASSWORD_RETRY . 2)
            (G_TLS_PASSWORD_MANY_TRIES . 4)
            (G_TLS_PASSWORD_FINAL_TRY . 8)
            (G_TLS_INTERACTION_UNHANDLED . 0)
            (G_TLS_INTERACTION_HANDLED . 1)
            (G_TLS_INTERACTION_FAILED . 2)
            (G_DBUS_INTERFACE_SKELETON_FLAGS_NONE . 0)
            (G_DBUS_INTERFACE_SKELETON_FLAGS_HANDLE_METHOD_INVOCATIONS_IN_THREAD
              .
              1)
            (G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_NONE . 0)
            (G_DBUS_OBJECT_MANAGER_CLIENT_FLAGS_DO_NOT_AUTO_START
              .
              1)
            (G_TLS_DATABASE_VERIFY_NONE . 0)
            (G_TLS_DATABASE_LOOKUP_NONE . 0)
            (G_TLS_DATABASE_LOOKUP_KEYPAIR . 1)
            (G_TLS_CERTIFICATE_REQUEST_NONE . 0)
            (G_IO_MODULE_SCOPE_NONE . 0)
            (G_IO_MODULE_SCOPE_BLOCK_DUPLICATES . 1)
            (G_SOCKET_CLIENT_RESOLVING . 0)
            (G_SOCKET_CLIENT_RESOLVED . 1)
            (G_SOCKET_CLIENT_CONNECTING . 2)
            (G_SOCKET_CLIENT_CONNECTED . 3)
            (G_SOCKET_CLIENT_PROXY_NEGOTIATING . 4)
            (G_SOCKET_CLIENT_PROXY_NEGOTIATED . 5)
            (G_SOCKET_CLIENT_TLS_HANDSHAKING . 6)
            (G_SOCKET_CLIENT_TLS_HANDSHAKED . 7)
            (G_SOCKET_CLIENT_COMPLETE . 8)
            (G_SOCKET_LISTENER_BINDING . 0)
            (G_SOCKET_LISTENER_BOUND . 1)
            (G_SOCKET_LISTENER_LISTENING . 2)
            (G_SOCKET_LISTENER_LISTENED . 3)
            (G_TEST_DBUS_NONE . 0)
            (G_SUBPROCESS_FLAGS_NONE . 0)
            (G_SUBPROCESS_FLAGS_STDIN_PIPE . 1)
            (G_SUBPROCESS_FLAGS_STDIN_INHERIT . 2)
            (G_SUBPROCESS_FLAGS_STDOUT_PIPE . 4)
            (G_SUBPROCESS_FLAGS_STDOUT_SILENCE . 8)
            (G_SUBPROCESS_FLAGS_STDERR_PIPE . 16)
            (G_SUBPROCESS_FLAGS_STDERR_SILENCE . 32)
            (G_SUBPROCESS_FLAGS_STDERR_MERGE . 64)
            (G_SUBPROCESS_FLAGS_INHERIT_FDS . 128)
            (G_NOTIFICATION_PRIORITY_NORMAL . 0)
            (G_NOTIFICATION_PRIORITY_LOW . 1)
            (G_NOTIFICATION_PRIORITY_HIGH . 2)
            (G_NOTIFICATION_PRIORITY_URGENT . 3)
            (G_NETWORK_CONNECTIVITY_LOCAL . 1)
            (G_NETWORK_CONNECTIVITY_LIMITED . 2)
            (G_NETWORK_CONNECTIVITY_PORTAL . 3)
            (G_NETWORK_CONNECTIVITY_FULL . 4)
            (G_MODULE_BIND_LAZY . 1)
            (G_MODULE_BIND_LOCAL . 2)
            (G_MODULE_BIND_MASK . 3)
            (G_SETTINGS_BIND_DEFAULT . 0)
            (G_SETTINGS_BIND_GET . 1)
            (G_SETTINGS_BIND_SET . 2)
            (G_SETTINGS_BIND_NO_SENSITIVITY . 4)
            (G_SETTINGS_BIND_GET_NO_CHANGES . 8)
            (G_SETTINGS_BIND_INVERT_BOOLEAN . 16)
            (GDK_PIXBUF_ALPHA_BILEVEL . 0)
            (GDK_PIXBUF_ALPHA_FULL . 1)
            (GDK_COLORSPACE_RGB . 0)
            (GDK_PIXBUF_ERROR_CORRUPT_IMAGE . 0)
            (GDK_PIXBUF_ERROR_INSUFFICIENT_MEMORY . 1)
            (GDK_PIXBUF_ERROR_BAD_OPTION . 2)
            (GDK_PIXBUF_ERROR_UNKNOWN_TYPE . 3)
            (GDK_PIXBUF_ERROR_UNSUPPORTED_OPERATION . 4)
            (GDK_PIXBUF_ERROR_FAILED . 5)
            (GDK_PIXBUF_ERROR_INCOMPLETE_ANIMATION . 6)
            (GDK_INTERP_NEAREST . 0)
            (GDK_INTERP_TILES . 1)
            (GDK_INTERP_BILINEAR . 2)
            (GDK_INTERP_HYPER . 3)
            (GDK_PIXBUF_ROTATE_NONE . 0)
            (GDK_PIXBUF_ROTATE_COUNTERCLOCKWISE . 90)
            (GDK_PIXBUF_ROTATE_UPSIDEDOWN . 180)
            (GDK_PIXBUF_ROTATE_CLOCKWISE . 270)
            (RSVG_ERROR_FAILED . 0)
            (RSVG_HANDLE_FLAGS_NONE . 0)
            (RSVG_HANDLE_FLAG_UNLIMITED . 1)
            (RSVG_HANDLE_FLAG_KEEP_IMAGE_DATA . 2)
            (CAIRO_STATUS_SUCCESS . 0)
            (CAIRO_STATUS_NO_MEMORY . 1)
            (CAIRO_STATUS_INVALID_RESTORE . 2)
            (CAIRO_STATUS_INVALID_POP_GROUP . 3)
            (CAIRO_STATUS_NO_CURRENT_POINT . 4)
            (CAIRO_STATUS_INVALID_MATRIX . 5)
            (CAIRO_STATUS_INVALID_STATUS . 6)
            (CAIRO_STATUS_NULL_POINTER . 7)
            (CAIRO_STATUS_INVALID_STRING . 8)
            (CAIRO_STATUS_INVALID_PATH_DATA . 9)
            (CAIRO_STATUS_READ_ERROR . 10)
            (CAIRO_STATUS_WRITE_ERROR . 11)
            (CAIRO_STATUS_SURFACE_FINISHED . 12)
            (CAIRO_STATUS_SURFACE_TYPE_MISMATCH . 13)
            (CAIRO_STATUS_PATTERN_TYPE_MISMATCH . 14)
            (CAIRO_STATUS_INVALID_CONTENT . 15)
            (CAIRO_STATUS_INVALID_FORMAT . 16)
            (CAIRO_STATUS_INVALID_VISUAL . 17)
            (CAIRO_STATUS_FILE_NOT_FOUND . 18)
            (CAIRO_STATUS_INVALID_DASH . 19)
            (CAIRO_STATUS_INVALID_DSC_COMMENT . 20)
            (CAIRO_STATUS_INVALID_INDEX . 21)
            (CAIRO_STATUS_CLIP_NOT_REPRESENTABLE . 22)
            (CAIRO_STATUS_TEMP_FILE_ERROR . 23)
            (CAIRO_STATUS_INVALID_STRIDE . 24)
            (CAIRO_STATUS_FONT_TYPE_MISMATCH . 25)
            (CAIRO_STATUS_USER_FONT_IMMUTABLE . 26)
            (CAIRO_STATUS_USER_FONT_ERROR . 27)
            (CAIRO_STATUS_NEGATIVE_COUNT . 28)
            (CAIRO_STATUS_INVALID_CLUSTERS . 29)
            (CAIRO_STATUS_INVALID_SLANT . 30)
            (CAIRO_STATUS_INVALID_WEIGHT . 31)
            (CAIRO_STATUS_INVALID_SIZE . 32)
            (CAIRO_STATUS_USER_FONT_NOT_IMPLEMENTED . 33)
            (CAIRO_STATUS_DEVICE_TYPE_MISMATCH . 34)
            (CAIRO_STATUS_DEVICE_ERROR . 35)
            (CAIRO_STATUS_INVALID_MESH_CONSTRUCTION . 36)
            (CAIRO_STATUS_DEVICE_FINISHED . 37)
            (CAIRO_STATUS_JBIG2_GLOBAL_MISSING . 38)
            (CAIRO_STATUS_LAST_STATUS . 39)
            (CAIRO_CONTENT_COLOR . 4096)
            (CAIRO_CONTENT_ALPHA . 8192)
            (CAIRO_CONTENT_COLOR_ALPHA . 12288)
            (CAIRO_FORMAT_INVALID . -1)
            (CAIRO_FORMAT_ARGB32 . 0)
            (CAIRO_FORMAT_RGB24 . 1)
            (CAIRO_FORMAT_A8 . 2)
            (CAIRO_FORMAT_A1 . 3)
            (CAIRO_FORMAT_RGB16_565 . 4)
            (CAIRO_FORMAT_RGB30 . 5)
            (CAIRO_OPERATOR_CLEAR . 0)
            (CAIRO_OPERATOR_SOURCE . 1)
            (CAIRO_OPERATOR_OVER . 2)
            (CAIRO_OPERATOR_IN . 3)
            (CAIRO_OPERATOR_OUT . 4)
            (CAIRO_OPERATOR_ATOP . 5)
            (CAIRO_OPERATOR_DEST . 6)
            (CAIRO_OPERATOR_DEST_OVER . 7)
            (CAIRO_OPERATOR_DEST_IN . 8)
            (CAIRO_OPERATOR_DEST_OUT . 9)
            (CAIRO_OPERATOR_DEST_ATOP . 10)
            (CAIRO_OPERATOR_XOR . 11)
            (CAIRO_OPERATOR_ADD . 12)
            (CAIRO_OPERATOR_SATURATE . 13)
            (CAIRO_OPERATOR_MULTIPLY . 14)
            (CAIRO_OPERATOR_SCREEN . 15)
            (CAIRO_OPERATOR_OVERLAY . 16)
            (CAIRO_OPERATOR_DARKEN . 17)
            (CAIRO_OPERATOR_LIGHTEN . 18)
            (CAIRO_OPERATOR_COLOR_DODGE . 19)
            (CAIRO_OPERATOR_COLOR_BURN . 20)
            (CAIRO_OPERATOR_HARD_LIGHT . 21)
            (CAIRO_OPERATOR_SOFT_LIGHT . 22)
            (CAIRO_OPERATOR_DIFFERENCE . 23)
            (CAIRO_OPERATOR_EXCLUSION . 24)
            (CAIRO_OPERATOR_HSL_HUE . 25)
            (CAIRO_OPERATOR_HSL_SATURATION . 26)
            (CAIRO_OPERATOR_HSL_COLOR . 27)
            (CAIRO_OPERATOR_HSL_LUMINOSITY . 28)
            (CAIRO_ANTIALIAS_DEFAULT . 0)
            (CAIRO_ANTIALIAS_NONE . 1)
            (CAIRO_ANTIALIAS_GRAY . 2)
            (CAIRO_ANTIALIAS_SUBPIXEL . 3)
            (CAIRO_ANTIALIAS_FAST . 4)
            (CAIRO_ANTIALIAS_GOOD . 5)
            (CAIRO_ANTIALIAS_BEST . 6)
            (CAIRO_FILL_RULE_WINDING . 0)
            (CAIRO_FILL_RULE_EVEN_ODD . 1)
            (CAIRO_LINE_CAP_BUTT . 0)
            (CAIRO_LINE_CAP_ROUND . 1)
            (CAIRO_LINE_CAP_SQUARE . 2)
            (CAIRO_LINE_JOIN_MITER . 0)
            (CAIRO_LINE_JOIN_ROUND . 1)
            (CAIRO_LINE_JOIN_BEVEL . 2)
            (CAIRO_TEXT_CLUSTER_FLAG_BACKWARD . 1)
            (CAIRO_FONT_SLANT_NORMAL . 0)
            (CAIRO_FONT_SLANT_ITALIC . 1)
            (CAIRO_FONT_SLANT_OBLIQUE . 2)
            (CAIRO_FONT_WEIGHT_NORMAL . 0)
            (CAIRO_FONT_WEIGHT_BOLD . 1)
            (CAIRO_SUBPIXEL_ORDER_DEFAULT . 0)
            (CAIRO_SUBPIXEL_ORDER_RGB . 1)
            (CAIRO_SUBPIXEL_ORDER_BGR . 2)
            (CAIRO_SUBPIXEL_ORDER_VRGB . 3)
            (CAIRO_SUBPIXEL_ORDER_VBGR . 4)
            (CAIRO_HINT_STYLE_DEFAULT . 0)
            (CAIRO_HINT_STYLE_NONE . 1)
            (CAIRO_HINT_STYLE_SLIGHT . 2)
            (CAIRO_HINT_STYLE_MEDIUM . 3)
            (CAIRO_HINT_STYLE_FULL . 4)
            (CAIRO_HINT_METRICS_DEFAULT . 0)
            (CAIRO_HINT_METRICS_OFF . 1)
            (CAIRO_HINT_METRICS_ON . 2)
            (CAIRO_FONT_TYPE_TOY . 0)
            (CAIRO_FONT_TYPE_FT . 1)
            (CAIRO_FONT_TYPE_WIN32 . 2)
            (CAIRO_FONT_TYPE_QUARTZ . 3)
            (CAIRO_FONT_TYPE_USER . 4)
            (CAIRO_PATH_MOVE_TO . 0)
            (CAIRO_PATH_LINE_TO . 1)
            (CAIRO_PATH_CURVE_TO . 2)
            (CAIRO_PATH_CLOSE_PATH . 3)
            (CAIRO_DEVICE_TYPE_DRM . 0)
            (CAIRO_DEVICE_TYPE_GL . 1)
            (CAIRO_DEVICE_TYPE_SCRIPT . 2)
            (CAIRO_DEVICE_TYPE_XCB . 3)
            (CAIRO_DEVICE_TYPE_XLIB . 4)
            (CAIRO_DEVICE_TYPE_XML . 5)
            (CAIRO_DEVICE_TYPE_COGL . 6)
            (CAIRO_DEVICE_TYPE_WIN32 . 7)
            (CAIRO_DEVICE_TYPE_INVALID . -1)
            (CAIRO_SURFACE_OBSERVER_NORMAL . 0)
            (CAIRO_SURFACE_OBSERVER_RECORD_OPERATIONS . 1)
            (CAIRO_SURFACE_TYPE_IMAGE . 0)
            (CAIRO_SURFACE_TYPE_PDF . 1)
            (CAIRO_SURFACE_TYPE_PS . 2)
            (CAIRO_SURFACE_TYPE_XLIB . 3)
            (CAIRO_SURFACE_TYPE_XCB . 4)
            (CAIRO_SURFACE_TYPE_GLITZ . 5)
            (CAIRO_SURFACE_TYPE_QUARTZ . 6)
            (CAIRO_SURFACE_TYPE_WIN32 . 7)
            (CAIRO_SURFACE_TYPE_BEOS . 8)
            (CAIRO_SURFACE_TYPE_DIRECTFB . 9)
            (CAIRO_SURFACE_TYPE_SVG . 10)
            (CAIRO_SURFACE_TYPE_OS2 . 11)
            (CAIRO_SURFACE_TYPE_WIN32_PRINTING . 12)
            (CAIRO_SURFACE_TYPE_QUARTZ_IMAGE . 13)
            (CAIRO_SURFACE_TYPE_SCRIPT . 14)
            (CAIRO_SURFACE_TYPE_QT . 15)
            (CAIRO_SURFACE_TYPE_RECORDING . 16)
            (CAIRO_SURFACE_TYPE_VG . 17)
            (CAIRO_SURFACE_TYPE_GL . 18)
            (CAIRO_SURFACE_TYPE_DRM . 19)
            (CAIRO_SURFACE_TYPE_TEE . 20)
            (CAIRO_SURFACE_TYPE_XML . 21)
            (CAIRO_SURFACE_TYPE_SKIA . 22)
            (CAIRO_SURFACE_TYPE_SUBSURFACE . 23)
            (CAIRO_SURFACE_TYPE_COGL . 24)
            (CAIRO_PATTERN_TYPE_SOLID . 0)
            (CAIRO_PATTERN_TYPE_SURFACE . 1)
            (CAIRO_PATTERN_TYPE_LINEAR . 2)
            (CAIRO_PATTERN_TYPE_RADIAL . 3)
            (CAIRO_PATTERN_TYPE_MESH . 4)
            (CAIRO_PATTERN_TYPE_RASTER_SOURCE . 5)
            (CAIRO_EXTEND_NONE . 0)
            (CAIRO_EXTEND_REPEAT . 1)
            (CAIRO_EXTEND_REFLECT . 2)
            (CAIRO_EXTEND_PAD . 3)
            (CAIRO_FILTER_FAST . 0)
            (CAIRO_FILTER_GOOD . 1)
            (CAIRO_FILTER_BEST . 2)
            (CAIRO_FILTER_NEAREST . 3)
            (CAIRO_FILTER_BILINEAR . 4)
            (CAIRO_FILTER_GAUSSIAN . 5)
            (CAIRO_REGION_OVERLAP_IN . 0)
            (CAIRO_REGION_OVERLAP_OUT . 1)
            (CAIRO_REGION_OVERLAP_PART . 2))))
    (lambda (k) (assq-ref sym-tab k))))
(export librsvg-symbol-val)

(define (unwrap-enum obj)
  (cond ((number? obj) obj)
        ((symbol? obj) (librsvg-symbol-val obj))
        ((fh-object? obj) (struct-ref obj 0))
        (else (error "type mismatch"))))

(define librsvg-types
  '("RsvgSizeFunc" "RsvgHandleFlags" (struct . "_RsvgPositionData") (struct 
    . "_RsvgDimensionData") (struct . "_RsvgHandle") (struct . 
    "_RsvgHandleClass") "RsvgPositionData" "RsvgDimensionData" 
    "RsvgHandleClass" "RsvgHandlePrivate" "RsvgHandle" "RsvgError"))
;;(export librsvg-types)

;; --- last line ---
