#!/usr/bin/python

#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


from qt import *
from OBBFuncts import *

NO_BORDER_FLAGS = Qt.WStyle_Customize \
                  + Qt.WStyle_NoBorder \
                  + Qt.WRepaintNoErase \
                  + Qt.NoBackground \
                  + Qt.WPaintUnclipped \
                  + Qt.WType_TopLevel


MIN_MOVE_REDRAW_MAGNITUDE = 4

class Floater(QWidget):
    def __init__(self, parent=None, name="Floater"):
        QWidget.__init__(self, parent, name, NO_BORDER_FLAGS)
        self.subWidgets = []
        self.revChildList = []
        self.setDrag(0)
        self.mouseReleaseAction = None

    def addSubWidget(self, widget):
        # stacking order for repaints
        self.subWidgets.append(widget)
        self.updateMask()

        # inverse order for events
        self.revChildList = list(self.subWidgets)
        self.revChildList.reverse()

    def updateMask(self):
        # set size and mask of the 1st(lower) widget
        size = self.subWidgets[0].size()
        self.setMinimumSize(size)
        self.setMaximumSize(size)
        self.region = self.subWidgets[0].opaqueRegion()
        self.setMask(self.region)
        
        # add the rest on top of it
        for widget in self.subWidgets[1:]:
            opaqueRegion = self.region
            widgetRegion = widget.opaqueRegion()
            newRegion = opaqueRegion.unite(widgetRegion)
            self.setMask(newRegion)
            self.region = newRegion
            
            size = newRegion.boundingRect().size()
            self.setMinimumSize(size)
            self.setMaximumSize(size)

    def repaintWidget(self, widget, region):
        self.update(region.boundingRect())

    def paintEvent(self, event):
        selfRect = self.rect()
        for widget in self.subWidgets:
            if widget.intersects(event.rect()):
                
                # get the subRect the widget is in
                
                #print "-"*60
                #printRect(event.rect())
                #printPoint(widget.topLeft())
                #printRect(widget.opaqueRegion().boundingRect())
                
                widgetPos  = widget.topLeft()
                widgetRect = widget.opaqueRegion().boundingRect()
                invalidRect = widgetRect.intersect(event.rect())
                mappedTopLeft = pointOffset( invalidRect.topLeft(), 
                                                   widgetPos)
                mappedInvRect = QRect( mappedTopLeft, invalidRect.size() )

                pixmap = widget.curPixmap(mappedInvRect)
                
                bitBlt( self,
                        invalidRect.topLeft(),
                        pixmap )


    def reCenter(self):
        desktop = QApplication.desktop()
        point = QPoint( (desktop.width() - self.width())/2,
                        (desktop.height() - self.height())/2 )
        self.move(point)

    def setDrag(self, isDraged=1):
        self.draged = isDraged

    def isDraged(self):
        return self.draged

    def drag(self, event):
        mappedPoint = addOffset( event.pos(),
                                 pointOffset( self.geometry().topLeft(),
                                              self.frameGeometry().topLeft()))
        if self.isDraged():
            offset = pointOffset( mappedPoint,
                                  self.clickPos )
            if MIN_MOVE_REDRAW_MAGNITUDE <= getMagnitude(offset):
                self.move( pointOffset( event.globalPos(), self.lastMovePos ))
                self.moved = 1

    def startDrag(self, event):
        self.setDrag(1)
        self.dragOrigin = QPoint( event.globalPos() )
        mappedPoint = addOffset( event.pos(),
                                 pointOffset( self.geometry().topLeft(),
                                              self.frameGeometry().topLeft()))
        self.lastMovePos = mappedPoint
        self.clickPos = mappedPoint
        self.grabMouse()

    def captureMouse(self, func):
        """captureMouse : like QWidget.grabMouse() but call func when the
        mouse is released"""
        self.mouseReleaseAction = func
        self.grabMouse()
    
    # events
    def mouseMoveEvent(self, e):
        for widget in self.revChildList:
            if widget.containsPoint(e.pos()):
                return widget.mouseMoveEvent(e)

    def mouseReleaseEvent(self, e):
        self.setDrag(0)
        self.releaseMouse()

        
        for widget in self.revChildList:
            if widget.containsPoint(e.pos()):
                widget.mouseReleaseEvent(e)
                if self.mouseReleaseAction:
                    self.mouseReleaseAction()
                    self.mouseReleaseAction = None
                return None # should I use continue ?


    def mousePressEvent(self, e):
        # TODO handle the right click
        self.moved = 0
        for widget in self.revChildList:
            if widget.containsPoint(e.pos()):
                return widget.mousePressEvent(e)

    def mouseDoubleClickEvent(self, e):
        for widget in self.revChildList:
            if widget.containsPoint(e.pos()):
                return widget.mouseDoubleClickEvent(e)

    def keyPressEvent(self, e):
        pass

    def keyReleaseEvent(self, e):
        pass

    def wheelEvent(self, e):
        for widget in self.revChildList:
            if widget.containsPoint(e.pos()):
                return widget.wheelEvent(e)
        
