#!/usr/bin/python

#   Copyright (C) 2002 Yannick Gingras <ygingras@ygingras.net>
#   Copyright (C) 2002 Vincent Barbin <vbarbin@openbeatbox.org>

#   This file is part of Open Beat Box.

#   Open Beat Box is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.

#   Open Beat Box is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.

#   You should have received a copy of the GNU General Public License
#   along with Open Beat Box; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

from qt import *
from StretchFrame import StretchFrame
from PixmapSet import *

class OBBLabel(StretchFrame):
    def __init__( self,
                  pixmapSet,
                  parent=None,
                  x=0,
                  y=0,
                  stretchPoint=30,
                  stretchSize=50,
                  wantedSize=100,
                  borderX = 5,
                  borderY = 7,
                  fontSize = 12 ):
        StretchFrame.__init__( self,
                               pixmapSet,
                               parent,
                               x,
                               y,
                               "x",
                               stretchPoint,
                               stretchSize,
                               wantedSize )
        self.borderX = borderX
        self.borderY = borderY
        self.fontSize = fontSize
        self.font = QFont()
        self.font.setPointSize(self.fontSize)
        self.font.setWeight(75)
        self.fontMetrics = QFontMetrics(self.font)
        self.scrollOffset = 0
        self.curText = """Welcome to OBB !"""
        self.curText += " " * 75

    def paintCurPixmapXY( self,
                          x,
                          y,
                          width,
                          height,
                          globalX,
                          globalY,
                          paintDev ):
        statePix = self.pixmapSet.getState(self.curState)

        globalPosX = globalX + self.pos.x()
        globalPosY = globalY + self.pos.y()
        
        paintDev.drawPixmap( x+globalPosX,
                             y+globalPosY,
                             statePix,
                             x,
                             y,
                             width,
                             height )

        oldRegion = None
        if paintDev.hasClipping():
            oldRegion = paintDev.clipRegion()

        paintDev.setClipRect( globalPosX+self.borderX,
                              globalPosY+self.borderY/2,
                              self.width()-(self.borderX*2),
                              self.height()-(self.borderY) )
        
        paintDev.setFont(self.font)
        paintDev.drawText( globalPosX+self.borderX-self.scrollOffset,
                           globalPosY+self.height()-self.borderY,
                           self.curText )

        if oldRegion:
            paintDev.setClipRegion(oldRegion)
        else:
            paintDev.setClipping(0)

        for widget in self.subWidgets:
            if widget.intersectsXY(x, y, width, height):
                self.paintChildPixmapXY( x,
                                         y,
                                         width,
                                         height,
                                         globalPosX,
                                         globalPosY,
                                         paintDev,
                                         widget )


    def scroll(self):
        charWidth = self.fontMetrics.charWidth(self.curText, 0)
        self.scrollOffset = self.scrollOffset + 1 # self.charWidth/5
        if self.scrollOffset >= charWidth:
            self.scrollOffset = 0
            self.curText = self.curText[1:] + self.curText[:1]   
        self.parent().repaintWidget(self, self.region)

    def setText(self, text):
        self.curText = text
        self.parent().repaintWidget(self, self.region)        
