#!/usr/bin/python
import unittest
import os
from testsPath import *
from config import VERSION

class obbStartUpTest(unittest.TestCase):
    """obbStartUpTest : test if OBB can start."""
    def runTest(self):
        # should print version and exit
        cmd = "python " + os.path.join(os.pardir, "OBB.py") + " -V"
        pipe = os.popen(cmd)
        versionStr = pipe.read()
        self.failUnless( versionStr.find("version " + VERSION) != -1 )
        retVal = pipe.close()
        self.failUnless( retVal == None )

class obbBadStartUpTest(unittest.TestCase):
    """obbBadStartUpTest : test if OBB can fail start."""
    def runTest(self):
        # bad options should exit with usage msg and exitCode != None
        cmd = "python " + os.path.join(os.pardir, "OBB.py") + " --asdasd"
        pipe = os.popen(cmd)
        versionStr = pipe.read()
        self.failUnless( versionStr.find("Usage : ") != -1 )
        retVal = pipe.close()
        self.failUnless( retVal != None )

class obbDemoStartUpTest(unittest.TestCase):
    """obbBadStartUpTest : test if OBB can load the demos.
    The demos are use to test the gui and the skins, they load a full
    gui with no working backend."""
    def runTest(self):
        cmd = "python " + os.path.join(os.pardir, "OBB.py")
        cmd += " --demo-pat-editor 1"
        pipe = os.popen(cmd)
        retVal = pipe.close()
        self.failUnless( retVal == None )

def suite():
    testSuite = unittest.TestSuite()
    testSuite.addTest(obbStartUpTest())
    testSuite.addTest(obbBadStartUpTest())
    testSuite.addTest(obbDemoStartUpTest())
    return testSuite
