#ifdef __cplusplus
extern "C" {
#endif
/*
ANSI C code generated by:
--------------------------------------------------------------------
 Fine - Release 0.11x18 [alpha] (Sunday 01-Mar-2004)
  Copyright (C) 2001-2003 QRW Software - http://www.qrwsoftware.com
  J. Scott Edwards - sedwards@qrwsoftware.com
  http://fine.sourceforge.net
 Based upon SmallEiffel Release -0.76
  Copyright (C), 1994-2000 - LORIA - UHP - CRIN - INRIA - FRANCE
  Dominique COLNET and Suzanne COLLIN - colnet@loria.fr
  http://SmallEiffel.loria.fr
--------------------------------------------------------------------
*/


/*
  This file (fine/lib/runtime/base.h) contains all basic Fine
  type definitions.
  This file is automatically included in the header for ALL modes of 
  compilation : -no_check, -system_check, -require_check, -ensure_check, ...
  This file is also included in the header of any cecil file (when the
  -cecil option is used).
  This file is also included in the header file of C++ wrappers (when
  using the external "C++" clause).
*/
#include <stdio.h>
#include <string.h>
#include <math.h>
#include <stdlib.h>
#include <errno.h>
#include <signal.h>
#include <stddef.h>
#include <stdarg.h>
#include <limits.h>
#include <float.h>
#include <setjmp.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#ifdef WIN32
#include <windows.h>
#else
#ifndef O_RDONLY
#include <sys/file.h>
#endif
#ifndef O_RDONLY
#define O_RDONLY 0000
#endif
#endif

/*
  Because ANSI C EXIT_FAILURE is not always defined :
 */
#ifndef EXIT_FAILURE
#define EXIT_FAILURE 1
#endif

/* 
   On Linux glibc systems, we need to use sig.* versions of jmp_buf,
   setjmp and longjmp to preserve the signal handling context.
   Currently, the way I figured to detect this is if _SIGSET_H_types has
   been defined in /usr/include/setjmp.h.
*/
#ifdef _SIGSET_H_types
#define JMP_BUF    sigjmp_buf
#define SETJMP(x)  sigsetjmp( (x), 1)
#define LONGJMP    siglongjmp
#else
#define JMP_BUF    jmp_buf
#define SETJMP(x)  setjmp( (x) )
#define LONGJMP    longjmp
#endif

/* 
   Type to store reference objects Id :
 */
typedef int Tid;

typedef struct S0 T0;

struct S0{
  Tid id;
};

/* 
   The default channel used to print runtime error messages :
*/
#define SE_ERR stderr

/* 
   Fine type INTEGER is #2 :
*/
typedef int T2;
#define EIF_INTEGER T2
#define M2 (0)
#define EIF_INTEGER_BITS (CHAR_BIT*sizeof(T2))
#define EIF_MINIMUM_INTEGER (INT_MIN)
#define EIF_MAXIMUM_INTEGER (INT_MAX)

/*
  Fine type CHARACTER is #3 :
*/
typedef unsigned char T3;
#define EIF_CHARACTER T3
#define M3 (0)
#define EIF_CHARACTER_BITS (CHAR_BIT*sizeof(T3))
#define EIF_MINIMUM_CHARACTER_CODE (0)
#define EIF_MAXIMUM_CHARACTER_CODE (255)
#define T3code(x) ((T2)(x))
#define T3to_integer(x) ((T2)((char)(x)))
#define T3to_bit(x) (x)

/*
  Fine type FLOAT is #4 :
*/
typedef float T4;
#define EIF_FLOAT T4
#define M4 (0.0)
#define EIF_FLOAT_BITS (CHAR_BIT*sizeof(T4))
#define EIF_MINIMUM_FLOAT (-(FLT_MAX))
#define EIF_MAXIMUM_FLOAT (FLT_MAX)
#define T2toT4(x) ((T4)(x))

/*
  Fine type DOUBLE is #5 :
*/
typedef double T5;
#define EIF_DOUBLE T5
#define M5 (0.0)
#define EIF_DOUBLE_BITS (CHAR_BIT*sizeof(T5))
#define EIF_MINIMUM_DOUBLE (-(DBL_MAX))
#define EIF_MAXIMUM_DOUBLE (DBL_MAX)
#define T2toT5(x) ((T5)(x))
#define T4toT5(x) ((T5)(x))

/*
  Fine type BOOLEAN is #6 :
*/
typedef int T6;
#define EIF_BOOLEAN T6
#define M6 (0)
#define EIF_BOOLEAN_BITS (CHAR_BIT*sizeof(T6))

/* 
   Fine type POINTER is #8 :
*/
typedef void* T8;
#define EIF_POINTER T8
#define M8 (NULL)
#define EIF_POINTER_BITS (CHAR_BIT*sizeof(T8))

/*
  To use type STRING on the C side :
*/
#define EIF_STRING T7*

/* 
   Fine type UNSIGNED is #17 :
*/
typedef unsigned T17;
#define EIF_UNSIGNED T17
#define M17 (0)
#define EIF_UNSIGNED_BITS (CHAR_BIT*sizeof(T17))
#define EIF_MINIMUM_UNSIGNED (0)
#define EIF_MAXIMUM_UNSIGNED (UINT_MAX)

/*
  Some Other EIF_* defined in ETL :
*/
#define eif_access(x) ((char*)(x))
#define EIF_REFERENCE T0*
#define EIF_OBJ T0*
#define EIF_OBJECT EIF_OBJ

/* 
   Wrappers for `malloc', `calloc' and `realloc' :
*/
void* se_malloc(size_t size);
void* se_calloc(size_t nmemb, size_t size);
void* se_realloc(void *ptr, size_t size);

/*
   And so we can catch the exits :
*/
void  se_exit(int exit_code);

/*
   find out if the machine we're running on is little endian :
*/
int   machine_is_little_endian();

/* $Revision: 1.3 $ */


/* --- Mangling Table Start ---
A 1  T52   R STRING_POOL 52
A 1  T40   R FIXED_ARRAY[CLASS_DEFINITION] 40
A 1  T8    E POINTER 8
A 1  T6    E BOOLEAN 6
D 1  T47   R ARRAYED_COLLECTION[FEATURE_DEFINITION] 43
A 1  T44   R FIXED_ARRAY[SPELLING] 44
A 1  T25   R NAME 25
A 1  T3    E CHARACTER 3
A 1  T46   E NATIVE_ARRAY[SPELLING] 46
D    T28   R INTEGER_REF
D 1  T59   R ARRAYED_COLLECTION[CIRCULAR_QUEUE[STRING]] 57
A 1  T32   R STD_FILE_WRITE 32
D    T34   R POINTER_REF
A 1  T64   R FIXED_ARRAY[NAME] 64
D 1  T65   R ARRAYED_COLLECTION[NAME] 64
A 1  T57   R FIXED_ARRAY[CIRCULAR_QUEUE[STRING]] 57
D    T21   R BOOLEAN_REF
A 1  T42   E NATIVE_ARRAY[CLASS_DEFINITION] 42
A 1  T67   R FIXED_ARRAY[STRING] 67
A 1  T61   E NATIVE_ARRAY[STRING] 61
D 1  T54   R ARRAYED_COLLECTION[INTEGER] 53
A 1  T48   E NATIVE_ARRAY[FEATURE_DEFINITION] 48
A 1  T7    R STRING 7
A 1  T62   R STD_FILE_READ 62
A 1  T9    E NATIVE_ARRAY[CHARACTER] 9
D 2  T68   R ARRAYED_COLLECTION[STRING] 67,58
A 1  T17   E UNSIGNED 17
A 1  T58   R CIRCULAR_QUEUE[STRING] 58
A 1  T24   R SPELLING 24
A 1  T22   R CLASS_DEFINITION 22
A 1  T53   R FIXED_ARRAY[INTEGER] 53
A 1  T60   E NATIVE_ARRAY[CIRCULAR_QUEUE[STRING]] 60
A 1  T2    E INTEGER 2
D 3  T33   R OUTPUT_STREAM 51,32,50
A 1  T18   R CONVERT_CSV_TO_C_STRUCTS 18
A 1  T66   E NATIVE_ARRAY[NAME] 66
A 1  T26   R FEATURE_DEFINITION 26
D    T35   R CHARACTER_REF
A 1  T55   E NATIVE_ARRAY[INTEGER] 55
D    T49   R UNSIGNED_REF
A 1  T43   R FIXED_ARRAY[FEATURE_DEFINITION] 43
A 1  T51   R STD_OUTPUT 51
A 1  T50   R STD_ERROR 50
D 1  T45   R ARRAYED_COLLECTION[SPELLING] 44
 --- Mangling Table End --- */

/*C Header Pass 1 :*/
typedef struct S52 T52;
typedef struct S40 T40;
typedef struct S44 T44;
typedef struct S25 T25;
typedef struct S24 T24;
typedef struct S32 T32;
typedef struct S64 T64;
typedef struct S57 T57;
typedef struct S22 T22;
typedef struct S67 T67;
typedef struct S7 T7;
typedef struct S26 T26;
typedef struct S62 T62;
typedef struct S58 T58;
typedef struct S53 T53;
typedef struct S18 T18;
typedef struct S43 T43;
typedef struct S51 T51;
typedef struct S50 T50;

/*C Header Pass 2 :*/
typedef T0**T46;
typedef T0**T42;
typedef T0**T61;
typedef T0**T48;
typedef T3*T9;
typedef T0**T60;
typedef T0**T66;
typedef T2*T55;

/*C Header Pass 3 :*/

/*C Header Pass 4 :*/
struct S52{Tid id;T6 _check_for_capacity_changes;T0* _available;T0* _on_loan;T0* _num_alloc;};
extern T52 M52;
void se_prinT52(T52**o);
struct S40{Tid id;T42 _storage;T2 _capacity;T2 _upper;};
extern T40 M40;
void se_prinT40(T40**o);
void se_prinT8(T8*o);
void se_prinT6(T6*o);
struct S44{Tid id;T46 _storage;T2 _capacity;T2 _upper;};
extern T44 M44;
void se_prinT44(T44**o);
struct S25{Tid id;T17 _reference;T0* _spellings;T0* _name_string;};
extern T25 M25;
void se_prinT25(T25**o);
void se_prinT3(T3*o);
void se_prinT46(T46*o);
struct S32{Tid id;T0* _path;T8 _output_stream;};
extern T32 M32;
void se_prinT32(T32**o);
struct S64{Tid id;T66 _storage;T2 _capacity;T2 _upper;};
extern T64 M64;
void se_prinT64(T64**o);
struct S57{Tid id;T60 _storage;T2 _capacity;T2 _upper;};
extern T57 M57;
void se_prinT57(T57**o);
void se_prinT42(T42*o);
struct S67{Tid id;T61 _storage;T2 _capacity;T2 _upper;};
extern T67 M67;
void se_prinT67(T67**o);
void se_prinT61(T61*o);
void se_prinT48(T48*o);
struct S7{Tid id;T9 _storage;T2 _count;T2 _capacity;T2 _key;};
extern T7 M7;
void se_prinT7(T7**o);
struct S62{Tid id;T6 _push_back_flag;T0* _path;T8 _input_stream;T2 _memory;};
extern T62 M62;
void se_prinT62(T62**o);
void se_prinT9(T9*o);
void se_prinT17(T17*o);
struct S58{Tid id;T61 _storage;T2 _capacity;T2 _upper;T2 _head;};
extern T58 M58;
void se_prinT58(T58**o);
struct S24{Tid id;T17 _reference;T0* _spelling;};
extern T24 M24;
void se_prinT24(T24**o);
struct S22{Tid id;T17 _reference;T0* _name;T0* _features;};
extern T22 M22;
void se_prinT22(T22**o);
struct S53{Tid id;T55 _storage;T2 _capacity;T2 _upper;};
extern T53 M53;
void se_prinT53(T53**o);
void se_prinT60(T60*o);
void se_prinT2(T2*o);
struct S18{Tid id;T0* _out_file;};
extern T18 M18;
void se_prinT18(T18**o);
void se_prinT66(T66*o);
struct S26{Tid id;T17 _reference;T17 _type;T0* _name;T2 _number;};
extern T26 M26;
void se_prinT26(T26**o);
void se_prinT55(T55*o);
struct S43{Tid id;T48 _storage;T2 _capacity;T2 _upper;};
extern T43 M43;
void se_prinT43(T43**o);
struct S51{Tid id;};
extern T51 M51;
void se_prinT51(T51**o);
struct S50{Tid id;};
extern T50 M50;
void se_prinT50(T50**o);

/*
  This file (fine/lib/runtime/check.h) is automatically included 
  when `system_check' is true (ie. all modes except mode -no_check).
*/
#define SE_CHECK 1

void se_prinT0(T0**o);

/* Special routines to assist in printing characters and strings. */
/* They are called by the se_prinTn routines, which are generated */
/* by the TYPE_CHARACTER and TYPE_STRING classes in the compiler. */

int  se_counTchar(unsigned char c);
void se_puTchar(unsigned char c, FILE* stream);
int  se_longesTline(char* storage, int count);
void se_puTshortlines(FILE* stream, char *ptr, int cnt, char *nlstr);
void se_puTlonglines(FILE* streadm, char *ptr, int cnt, char* nlstr, int max);


/* 
   This type is used to store a position in some Eiffel source file.
   It must be compatible with the implementation of class POSITION.
*/
typedef unsigned int se_position;

EIF_INTEGER se_position2line(se_position position);
EIF_INTEGER se_position2column(se_position position);
EIF_INTEGER se_position2path_id(se_position position);

/*
  To be able to print a stack frame in a human readable format :
*/
typedef struct _se_frame_descriptor se_frame_descriptor;
struct _se_frame_descriptor {
  char* name;
  int use_current;
  int local_count; /* Number of C variable to print. */
  char* local_format; /* Format information. */
  int assertion_flag; /* 1 when assertions can be checked. */ 
};

/*
  To keep the track of execution in order to be able to print a 
  dump when things goes wrong :
*/
typedef struct _se_dump_stack se_dump_stack;
struct _se_dump_stack {
  se_frame_descriptor* fd;
  void** current; /* NULL when not used. */
  se_position p; /* The current position. */
  se_dump_stack* caller; /* Back to the caller. */
  void*** locals;
};
extern se_dump_stack* se_dst;
void se_print_run_time_stack(void);
void se_print_one_frame(se_dump_stack*ds);
void se_core_dump(char *msg);

extern int se_rspf;
extern int se_require_uppermost_flag;
extern int se_require_last_result;
int se_rci(void*C);
void error0(char*m,char*vv);
void error1(char*m,se_position position);
void error2(T0*o,se_position position);
T0* vc(void*o,se_position position);
T0* ci(int id,void*o,se_position position);
void ac_req(int v,char*vv);
void ac_ens(int v,char*vv);
void ac_inv(int v,char*vv);
void ac_liv(int v,char*vv);
void ac_insp(int v);
int ac_lvc(int lc,int lv1,int lv2);
void ac_civ(int v,char*vv);
void se_evobt(void*o,se_position position);
void sigrsp(int sig);
void se_gc_check_id(void*o,int id);

/* $Revision: 1.3 $ */


/*
  This file (sys/runtime/trace.h) is automatically included when 
  `system_check' is true (ie. all modes except -no_check).
  This file comes after no_check.[hc] to implements the -trace flag.
*/
#ifdef SE_WEDIT
se_position se_trace(se_position p);
#elif SE_TRACE
void se_trace(se_dump_stack*ds,se_position p);
#endif
/* $Revision: 1.3 $ */


/*
  This file (fine/lib/runtime/exception.h) is automatically included 
  when exception handling is used somewhere in the live code.
*/

#define SE_EXCEPTIONS 1

/*
  Constants from Eiffel class EXCEPTIONS :
*/
#define Check_instruction 	  1
#define Class_invariant 	  2
#define Developer_exception 	  3
#define Incorrect_inspect_value   4
#define Loop_invariant 		  5
#define Loop_variant 		  6
#define No_more_memory  	  7
#define Postcondition 		  8
#define Precondition  		  9
#define Routine_failure  	  10
#define	Os_signal		  11
#define Void_attached_to_expanded 12
#define Void_call_target 	  13

/* 
   This will be the structure of rescue contexts.  A rescue context 
   will be declared for every routine that has a rescue clause.

   The `next' pointer is the address of the next rescue context if there
   is one higher up the call chain, or NULL if there is no other
   context.
*/
struct rescue_context {
  JMP_BUF jb;
#ifdef SE_CHECK
  /* To keep track of dump stack to unwind it safely
     before the LONGJMP :
  */
  struct _se_dump_stack * top_of_ds ;
#endif
  struct rescue_context *next;
};

extern struct rescue_context *rescue_context_top;
extern int internal_exception_number;
extern int original_internal_exception_number;
extern int signal_exception_number;
extern char *additional_error_message;

void setup_signal_handler(void);
void signal_exception_handler(int);
void internal_exception_handler(int);
void print_exception(void);
/* $Revision: 1.3 $ */

T6 r6_ix_not(se_dump_stack*caller,T6 C);
extern se_frame_descriptor f6_ix_not;
T6 r6_px_or(se_dump_stack*caller,T6 C,T6 a1);
extern se_frame_descriptor f6_px_or;
T6 r6_px_and(se_dump_stack*caller,T6 C,T6 a1);
extern se_frame_descriptor f6_px_and;
T6 r6_px_xor(se_dump_stack*caller,T6 C,T6 a1);
extern se_frame_descriptor f6_px_xor;
T6 r3_px_6061(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3_px_6061;
T6 r3is_equal(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3is_equal;
T6 r3is_digit(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3is_digit;
T6 r3in_range(se_dump_stack*caller,T3 C,T3 a1,T3 a2);
extern se_frame_descriptor f3in_range;
T6 r3is_hexadecimal_digit(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3is_hexadecimal_digit;
T6 r3_px_6261(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3_px_6261;
T2 r3value(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3value;
T6 r3_px_60(se_dump_stack*caller,T3 C,T3 a1);
extern se_frame_descriptor f3_px_60;
T2 r3decimal_value(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3decimal_value;
T3 r3to_upper(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3to_upper;
T2 r3hexadecimal_value(se_dump_stack*caller,T3 C);
extern se_frame_descriptor f3hexadecimal_value;
T6 r17is_equal(se_dump_stack*caller,T17 C,T17 a1);
extern se_frame_descriptor f17is_equal;
T6 r17divisible(se_dump_stack*caller,T17 a1);
extern se_frame_descriptor f17divisible;
T6 r17in_range(se_dump_stack*caller,T17 C,T17 a1,T17 a2);
extern se_frame_descriptor f17in_range;
void r17append_in_hexadecimal(se_dump_stack*caller,T17 C,T0* a1);
extern se_frame_descriptor f17append_in_hexadecimal;
T3 r17hexadecimal_digit(se_dump_stack*caller,T17 C);
extern se_frame_descriptor f17hexadecimal_digit;
T6 r2is_equal(se_dump_stack*caller,T2 C,T2 a1);
extern se_frame_descriptor f2is_equal;
T6 r2divisible(se_dump_stack*caller,T2 a1);
extern se_frame_descriptor f2divisible;
T6 r2in_range(se_dump_stack*caller,T2 C,T2 a1,T2 a2);
extern se_frame_descriptor f2in_range;
void r2store(se_dump_stack*caller,T2 C,T0* a1);
extern se_frame_descriptor f2store;
T3 r2digit(se_dump_stack*caller,T2 C);
extern se_frame_descriptor f2digit;
T2 r2_px_94(se_dump_stack*caller,T2 C,T2 a1);
extern se_frame_descriptor f2_px_94;
T3 r2hexadecimal_digit(se_dump_stack*caller,T2 C);
extern se_frame_descriptor f2hexadecimal_digit;
T46 r46realloc(se_dump_stack*caller,T46 C,T2 a1,T2 a2);
extern se_frame_descriptor f46realloc;
T6 r46is_not_null(se_dump_stack*caller,T46 C);
extern se_frame_descriptor f46is_not_null;
void r46clear(se_dump_stack*caller,T46 C,T2 a1,T2 a2);
extern se_frame_descriptor f46clear;
void r46copy_from(se_dump_stack*caller,T46 C,T46 a1,T2 a2);
extern se_frame_descriptor f46copy_from;
T42 r42realloc(se_dump_stack*caller,T42 C,T2 a1,T2 a2);
extern se_frame_descriptor f42realloc;
T6 r42is_not_null(se_dump_stack*caller,T42 C);
extern se_frame_descriptor f42is_not_null;
void r42clear(se_dump_stack*caller,T42 C,T2 a1,T2 a2);
extern se_frame_descriptor f42clear;
void r42copy_from(se_dump_stack*caller,T42 C,T42 a1,T2 a2);
extern se_frame_descriptor f42copy_from;
T61 r61realloc(se_dump_stack*caller,T61 C,T2 a1,T2 a2);
extern se_frame_descriptor f61realloc;
void r61remove(se_dump_stack*caller,T61 C,T2 a1,T2 a2);
extern se_frame_descriptor f61remove;
void r61clear(se_dump_stack*caller,T61 C,T2 a1,T2 a2);
extern se_frame_descriptor f61clear;
T6 r61is_not_null(se_dump_stack*caller,T61 C);
extern se_frame_descriptor f61is_not_null;
T6 r61all_default(se_dump_stack*caller,T61 C,T2 a1);
extern se_frame_descriptor f61all_default;
void r61copy_from(se_dump_stack*caller,T61 C,T61 a1,T2 a2);
extern se_frame_descriptor f61copy_from;
T48 r48realloc(se_dump_stack*caller,T48 C,T2 a1,T2 a2);
extern se_frame_descriptor f48realloc;
T6 r48is_not_null(se_dump_stack*caller,T48 C);
extern se_frame_descriptor f48is_not_null;
void r48clear(se_dump_stack*caller,T48 C,T2 a1,T2 a2);
extern se_frame_descriptor f48clear;
void r48copy_from(se_dump_stack*caller,T48 C,T48 a1,T2 a2);
extern se_frame_descriptor f48copy_from;
T9 r9realloc(se_dump_stack*caller,T9 C,T2 a1,T2 a2);
extern se_frame_descriptor f9realloc;
T6 r9fast_memcmp(se_dump_stack*caller,T9 C,T9 a1,T2 a2);
extern se_frame_descriptor f9fast_memcmp;
T6 r9fast_has(se_dump_stack*caller,T9 C,T3 a1,T2 a2);
extern se_frame_descriptor f9fast_has;
void r9copy_at(se_dump_stack*caller,T9 C,T2 a1,T9 a2,T2 a3);
extern se_frame_descriptor f9copy_at;
T6 r9is_not_null(se_dump_stack*caller,T9 C);
extern se_frame_descriptor f9is_not_null;
void r9copy_from(se_dump_stack*caller,T9 C,T9 a1,T2 a2);
extern se_frame_descriptor f9copy_from;
T6 r60is_not_null(se_dump_stack*caller,T60 C);
extern se_frame_descriptor f60is_not_null;
void r60clear(se_dump_stack*caller,T60 C,T2 a1,T2 a2);
extern se_frame_descriptor f60clear;
T6 r60all_default(se_dump_stack*caller,T60 C,T2 a1);
extern se_frame_descriptor f60all_default;
T66 r66realloc(se_dump_stack*caller,T66 C,T2 a1,T2 a2);
extern se_frame_descriptor f66realloc;
T6 r66is_not_null(se_dump_stack*caller,T66 C);
extern se_frame_descriptor f66is_not_null;
void r66clear(se_dump_stack*caller,T66 C,T2 a1,T2 a2);
extern se_frame_descriptor f66clear;
void r66copy_from(se_dump_stack*caller,T66 C,T66 a1,T2 a2);
extern se_frame_descriptor f66copy_from;
T6 r55is_not_null(se_dump_stack*caller,T55 C);
extern se_frame_descriptor f55is_not_null;
void r55clear(se_dump_stack*caller,T55 C,T2 a1,T2 a2);
extern se_frame_descriptor f55clear;
T6 r55all_default(se_dump_stack*caller,T55 C,T2 a1);
extern se_frame_descriptor f55all_default;
void r7copy(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7copy;
T3 r7last(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7last;
void r7remove_first(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7remove_first;
void r7put(se_dump_stack*caller,T7* C,T3 a1,T2 a2);
extern se_frame_descriptor f7put;
T2 r7upper(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7upper;
void r7remove_between(se_dump_stack*caller,T7* C,T2 a1,T2 a2);
extern se_frame_descriptor f7remove_between;
T6 r7is_equal(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7is_equal;
T3 r7item(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7item;
T6 r7valid_index(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7valid_index;
void r7append(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7append;
void r7make(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7make;
T6 r7has_prefix(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7has_prefix;
T6 r7is_empty(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7is_empty;
T6 r7is_mutable(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7is_mutable;
void r7extend(se_dump_stack*caller,T7* C,T3 a1);
extern se_frame_descriptor f7extend;
void r7remove_last(se_dump_stack*caller,T7* C,T2 a1);
extern se_frame_descriptor f7remove_last;
T6 r7_px_60(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7_px_60;
T6 r7standard_is_equal(se_dump_stack*caller,T7* C,T0* a1);
extern se_frame_descriptor f7standard_is_equal;
T6 r7has(se_dump_stack*caller,T7* C,T3 a1);
extern se_frame_descriptor f7has;
T3 r7first(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7first;
void r7clear(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7clear;
T8 r7to_external(se_dump_stack*caller,T7* C);
extern se_frame_descriptor f7to_external;
void r7swap(se_dump_stack*caller,T7* C,T2 a1,T2 a2);
extern se_frame_descriptor f7swap;
extern se_frame_descriptor se_ifd7;
T7*se_i7(se_dump_stack*caller,T7*C);
T0* r40last(se_dump_stack*caller,T40* C);
extern se_frame_descriptor f40last;
T2 r40count(se_dump_stack*caller,T40* C);
extern se_frame_descriptor f40count;
void r40put(se_dump_stack*caller,T40* C,T0* a1,T2 a2);
extern se_frame_descriptor f40put;
T0* r40item(se_dump_stack*caller,T40* C,T2 a1);
extern se_frame_descriptor f40item;
T6 r40valid_index(se_dump_stack*caller,T40* C,T2 a1);
extern se_frame_descriptor f40valid_index;
T6 r40is_empty(se_dump_stack*caller,T40* C);
extern se_frame_descriptor f40is_empty;
void r40increase_capacity(se_dump_stack*caller,T40* C,T2 a1);
extern se_frame_descriptor f40increase_capacity;
void r40increment_upper(se_dump_stack*caller,T40* C);
extern se_frame_descriptor f40increment_upper;
void r40add_last(se_dump_stack*caller,T40* C,T0* a1);
extern se_frame_descriptor f40add_last;
void r40with_capacity(se_dump_stack*caller,T40* C,T2 a1);
extern se_frame_descriptor f40with_capacity;
extern se_frame_descriptor se_ifd40;
T40*se_i40(se_dump_stack*caller,T40*C);
T0* r44last(se_dump_stack*caller,T44* C);
extern se_frame_descriptor f44last;
T2 r44count(se_dump_stack*caller,T44* C);
extern se_frame_descriptor f44count;
void r44put(se_dump_stack*caller,T44* C,T0* a1,T2 a2);
extern se_frame_descriptor f44put;
T0* r44item(se_dump_stack*caller,T44* C,T2 a1);
extern se_frame_descriptor f44item;
T6 r44valid_index(se_dump_stack*caller,T44* C,T2 a1);
extern se_frame_descriptor f44valid_index;
T6 r44is_empty(se_dump_stack*caller,T44* C);
extern se_frame_descriptor f44is_empty;
void r44increase_capacity(se_dump_stack*caller,T44* C,T2 a1);
extern se_frame_descriptor f44increase_capacity;
void r44increment_upper(se_dump_stack*caller,T44* C);
extern se_frame_descriptor f44increment_upper;
void r44add_last(se_dump_stack*caller,T44* C,T0* a1);
extern se_frame_descriptor f44add_last;
void r44with_capacity(se_dump_stack*caller,T44* C,T2 a1);
extern se_frame_descriptor f44with_capacity;
extern se_frame_descriptor se_ifd44;
T44*se_i44(se_dump_stack*caller,T44*C);
T0* r64last(se_dump_stack*caller,T64* C);
extern se_frame_descriptor f64last;
T2 r64count(se_dump_stack*caller,T64* C);
extern se_frame_descriptor f64count;
void r64put(se_dump_stack*caller,T64* C,T0* a1,T2 a2);
extern se_frame_descriptor f64put;
T0* r64item(se_dump_stack*caller,T64* C,T2 a1);
extern se_frame_descriptor f64item;
T6 r64valid_index(se_dump_stack*caller,T64* C,T2 a1);
extern se_frame_descriptor f64valid_index;
T6 r64is_empty(se_dump_stack*caller,T64* C);
extern se_frame_descriptor f64is_empty;
void r64increase_capacity(se_dump_stack*caller,T64* C,T2 a1);
extern se_frame_descriptor f64increase_capacity;
void r64increment_upper(se_dump_stack*caller,T64* C);
extern se_frame_descriptor f64increment_upper;
void r64add_last(se_dump_stack*caller,T64* C,T0* a1);
extern se_frame_descriptor f64add_last;
void r64with_capacity(se_dump_stack*caller,T64* C,T2 a1);
extern se_frame_descriptor f64with_capacity;
extern se_frame_descriptor se_ifd64;
T64*se_i64(se_dump_stack*caller,T64*C);
T2 r57count(se_dump_stack*caller,T57* C);
extern se_frame_descriptor f57count;
void r57put(se_dump_stack*caller,T57* C,T0* a1,T2 a2);
extern se_frame_descriptor f57put;
T0* r57item(se_dump_stack*caller,T57* C,T2 a1);
extern se_frame_descriptor f57item;
T6 r57valid_index(se_dump_stack*caller,T57* C,T2 a1);
extern se_frame_descriptor f57valid_index;
void r57make(se_dump_stack*caller,T57* C,T2 a1);
extern se_frame_descriptor f57make;
T6 r57all_default(se_dump_stack*caller,T57* C);
extern se_frame_descriptor f57all_default;
extern se_frame_descriptor se_ifd57;
T57*se_i57(se_dump_stack*caller,T57*C);
T2 r67count(se_dump_stack*caller,T67* C);
extern se_frame_descriptor f67count;
void r67put(se_dump_stack*caller,T67* C,T0* a1,T2 a2);
extern se_frame_descriptor f67put;
T0* r67item(se_dump_stack*caller,T67* C,T2 a1);
extern se_frame_descriptor f67item;
T6 r67valid_index(se_dump_stack*caller,T67* C,T2 a1);
extern se_frame_descriptor f67valid_index;
void r67make(se_dump_stack*caller,T67* C,T2 a1);
extern se_frame_descriptor f67make;
T6 r67is_empty(se_dump_stack*caller,T67* C);
extern se_frame_descriptor f67is_empty;
T6 r67all_default(se_dump_stack*caller,T67* C);
extern se_frame_descriptor f67all_default;
extern se_frame_descriptor se_ifd67;
T67*se_i67(se_dump_stack*caller,T67*C);
T2 r53count(se_dump_stack*caller,T53* C);
extern se_frame_descriptor f53count;
void r53put(se_dump_stack*caller,T53* C,T2 a1,T2 a2);
extern se_frame_descriptor f53put;
T2 r53item(se_dump_stack*caller,T53* C,T2 a1);
extern se_frame_descriptor f53item;
T6 r53valid_index(se_dump_stack*caller,T53* C,T2 a1);
extern se_frame_descriptor f53valid_index;
void r53make(se_dump_stack*caller,T53* C,T2 a1);
extern se_frame_descriptor f53make;
T6 r53all_default(se_dump_stack*caller,T53* C);
extern se_frame_descriptor f53all_default;
extern se_frame_descriptor se_ifd53;
T53*se_i53(se_dump_stack*caller,T53*C);
T0* r43last(se_dump_stack*caller,T43* C);
extern se_frame_descriptor f43last;
T2 r43count(se_dump_stack*caller,T43* C);
extern se_frame_descriptor f43count;
void r43put(se_dump_stack*caller,T43* C,T0* a1,T2 a2);
extern se_frame_descriptor f43put;
T0* r43item(se_dump_stack*caller,T43* C,T2 a1);
extern se_frame_descriptor f43item;
T6 r43valid_index(se_dump_stack*caller,T43* C,T2 a1);
extern se_frame_descriptor f43valid_index;
T6 r43is_empty(se_dump_stack*caller,T43* C);
extern se_frame_descriptor f43is_empty;
void r43increase_capacity(se_dump_stack*caller,T43* C,T2 a1);
extern se_frame_descriptor f43increase_capacity;
void r43increment_upper(se_dump_stack*caller,T43* C);
extern se_frame_descriptor f43increment_upper;
void r43add_last(se_dump_stack*caller,T43* C,T0* a1);
extern se_frame_descriptor f43add_last;
void r43with_capacity(se_dump_stack*caller,T43* C,T2 a1);
extern se_frame_descriptor f43with_capacity;
extern se_frame_descriptor se_ifd43;
T43*se_i43(se_dump_stack*caller,T43*C);
T0* r58last(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58last;
void r58remove_first(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58remove_first;
T2 r58count(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58count;
void r58put(se_dump_stack*caller,T58* C,T0* a1,T2 a2);
extern se_frame_descriptor f58put;
T0* r58item(se_dump_stack*caller,T58* C,T2 a1);
extern se_frame_descriptor f58item;
T6 r58valid_index(se_dump_stack*caller,T58* C,T2 a1);
extern se_frame_descriptor f58valid_index;
void r58make(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58make;
void r58remove(se_dump_stack*caller,T58* C,T2 a1);
extern se_frame_descriptor f58remove;
T6 r58is_empty(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58is_empty;
void r58increase_capacity(se_dump_stack*caller,T58* C,T2 a1);
extern se_frame_descriptor f58increase_capacity;
T2 r58rotate(se_dump_stack*caller,T58* C,T2 a1);
extern se_frame_descriptor f58rotate;
void r58remove_last(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58remove_last;
void r58increment_upper(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58increment_upper;
T6 r58fast_has(se_dump_stack*caller,T58* C,T0* a1);
extern se_frame_descriptor f58fast_has;
void r58add_last(se_dump_stack*caller,T58* C,T0* a1);
extern se_frame_descriptor f58add_last;
T0* r58first(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58first;
T2 r58fast_index_of(se_dump_stack*caller,T58* C,T0* a1);
extern se_frame_descriptor f58fast_index_of;
T2 r58tail(se_dump_stack*caller,T58* C);
extern se_frame_descriptor f58tail;
extern se_frame_descriptor se_ifd58;
T58*se_i58(se_dump_stack*caller,T58*C);
extern T0*oBC52singleton_memory;
extern int fBC52singleton_memory;
T0* r52singleton_memory(se_dump_stack*caller,T52* C);
extern se_frame_descriptor f52singleton_memory;
void r52put(se_dump_stack*caller,T52* C,T0* a1);
extern se_frame_descriptor f52put;
T2 r52index_of_at_least(se_dump_stack*caller,T52* C,T2 a1);
extern se_frame_descriptor f52index_of_at_least;
T0* r52item(se_dump_stack*caller,T52* C,T2 a1);
extern se_frame_descriptor f52item;
T2 r52index_of_at_most(se_dump_stack*caller,T52* C,T2 a1);
extern se_frame_descriptor f52index_of_at_most;
T6 r52is_exact_size(se_dump_stack*caller,T52* C,T2 a1);
extern se_frame_descriptor f52is_exact_size;
void r52make(se_dump_stack*caller,T52* C);
extern se_frame_descriptor f52make;
extern T2 oBC52num_different_sizes;
extern int fBC52num_different_sizes;
T2 r52num_different_sizes(se_dump_stack*caller,T52* C);
extern se_frame_descriptor f52num_different_sizes;
T6 r52is_in_range(se_dump_stack*caller,T52* C,T2 a1);
extern se_frame_descriptor f52is_in_range;
extern se_frame_descriptor se_ifd52;
T52*se_i52(se_dump_stack*caller,T52*C);
T0* r25name(se_dump_stack*caller,T25* C);
extern se_frame_descriptor f25name;
T0* r25find_spelling_from_reference(se_dump_stack*caller,T25* C,T17 a1);
extern se_frame_descriptor f25find_spelling_from_reference;
void r25skip_time(se_dump_stack*caller,T25* C,T0* a1);
extern se_frame_descriptor f25skip_time;
void r25make_from_csv(se_dump_stack*caller,T25* C,T0* a1);
extern se_frame_descriptor f25make_from_csv;
T0* r25name_capitalized(se_dump_stack*caller,T25* C);
extern se_frame_descriptor f25name_capitalized;
T17 r25scan_reference(se_dump_stack*caller,T25* C,T0* a1);
extern se_frame_descriptor f25scan_reference;
extern T0*oBC19all_spellings;
extern int fBC19all_spellings;
T0* r25all_spellings(se_dump_stack*caller);
extern se_frame_descriptor f25all_spellings;
void r25check_comma(se_dump_stack*caller,T25* C,T0* a1);
extern se_frame_descriptor f25check_comma;
extern T0*oBC1std_error;
void r32put_new_line(se_dump_stack*caller,T32* C);
extern se_frame_descriptor f32put_new_line;
void r32disconnect(se_dump_stack*caller,T32* C);
extern se_frame_descriptor f32disconnect;
T6 r32is_connected(se_dump_stack*caller,T32* C);
extern se_frame_descriptor f32is_connected;
void r32make(se_dump_stack*caller,T32* C);
extern se_frame_descriptor f32make;
void r32connect_to(se_dump_stack*caller,T32* C,T0* a1);
extern se_frame_descriptor f32connect_to;
void r32put_integer(se_dump_stack*caller,T32* C,T2 a1);
extern se_frame_descriptor f32put_integer;
void r32put_character(se_dump_stack*caller,T32* C,T3 a1);
extern se_frame_descriptor f32put_character;
void r32put_string(se_dump_stack*caller,T32* C,T0* a1);
extern se_frame_descriptor f32put_string;
void r32fclose(se_dump_stack*caller,T8 a1);
extern se_frame_descriptor f32fclose;
void r62disconnect(se_dump_stack*caller,T62* C);
extern se_frame_descriptor f62disconnect;
T6 r62is_connected(se_dump_stack*caller,T62* C);
extern se_frame_descriptor f62is_connected;
void r62read_character(se_dump_stack*caller,T62* C);
extern se_frame_descriptor f62read_character;
void r62make(se_dump_stack*caller,T62* C);
extern se_frame_descriptor f62make;
void r62read_line_in(se_dump_stack*caller,T62* C,T0* a1);
extern se_frame_descriptor f62read_line_in;
T6 r62end_of_input(se_dump_stack*caller,T62* C);
extern se_frame_descriptor f62end_of_input;
void r62connect_to(se_dump_stack*caller,T62* C,T0* a1);
extern se_frame_descriptor f62connect_to;
void r62fclose(se_dump_stack*caller,T8 a1);
extern se_frame_descriptor f62fclose;
void r24skip_time(se_dump_stack*caller,T24* C,T0* a1);
extern se_frame_descriptor f24skip_time;
void r24make_from_csv(se_dump_stack*caller,T24* C,T0* a1);
extern se_frame_descriptor f24make_from_csv;
T17 r24scan_reference(se_dump_stack*caller,T24* C,T0* a1);
extern se_frame_descriptor f24scan_reference;
void r24check_comma(se_dump_stack*caller,T24* C,T0* a1);
extern se_frame_descriptor f24check_comma;
extern T0*oBC19all_names;
extern int fBC19all_names;
T0* r22all_names(se_dump_stack*caller);
extern se_frame_descriptor f22all_names;
extern T0*oBC19all_features;
extern int fBC19all_features;
T0* r22all_features(se_dump_stack*caller);
extern se_frame_descriptor f22all_features;
T0* r22find_feature_from_reference(se_dump_stack*caller,T22* C,T17 a1);
extern se_frame_descriptor f22find_feature_from_reference;
void r22skip_time(se_dump_stack*caller,T22* C,T0* a1);
extern se_frame_descriptor f22skip_time;
void r22make_from_csv(se_dump_stack*caller,T22* C,T0* a1);
extern se_frame_descriptor f22make_from_csv;
T17 r22scan_reference(se_dump_stack*caller,T22* C,T0* a1);
extern se_frame_descriptor f22scan_reference;
void r22check_comma(se_dump_stack*caller,T22* C,T0* a1);
extern se_frame_descriptor f22check_comma;
T0* r22find_name_from_reference(se_dump_stack*caller,T22* C,T17 a1);
extern se_frame_descriptor f22find_name_from_reference;
T0* r26all_names(se_dump_stack*caller);
extern se_frame_descriptor f26all_names;
void r26skip_time(se_dump_stack*caller,T26* C,T0* a1);
extern se_frame_descriptor f26skip_time;
void r26make_from_csv(se_dump_stack*caller,T26* C,T0* a1);
extern se_frame_descriptor f26make_from_csv;
T17 r26scan_reference(se_dump_stack*caller,T26* C,T0* a1);
extern se_frame_descriptor f26scan_reference;
void r26check_comma(se_dump_stack*caller,T26* C,T0* a1);
extern se_frame_descriptor f26check_comma;
T0* r26find_name_from_reference(se_dump_stack*caller,T26* C,T17 a1);
extern se_frame_descriptor f26find_name_from_reference;
void r51put_new_line(se_dump_stack*caller,T51* C);
extern se_frame_descriptor f51put_new_line;
void r51make(se_dump_stack*caller,T51* C);
extern se_frame_descriptor f51make;
void r51put_integer(se_dump_stack*caller,T51* C,T2 a1);
extern se_frame_descriptor f51put_integer;
void r51put_unsigned_in_hexadecimal(se_dump_stack*caller,T51* C,T17 a1);
extern se_frame_descriptor f51put_unsigned_in_hexadecimal;
extern T0*oBC1string_pool;
extern int fBC1string_pool;
T0* r51string_pool(se_dump_stack*caller);
extern se_frame_descriptor f51string_pool;
void r51put_character(se_dump_stack*caller,T51* C,T3 a1);
extern se_frame_descriptor f51put_character;
void r51put_string(se_dump_stack*caller,T51* C,T0* a1);
extern se_frame_descriptor f51put_string;
void r50put_new_line(se_dump_stack*caller,T50* C);
extern se_frame_descriptor f50put_new_line;
void r50make(se_dump_stack*caller,T50* C);
extern se_frame_descriptor f50make;
void r50put_character(se_dump_stack*caller,T50* C,T3 a1);
extern se_frame_descriptor f50put_character;
void r50put_string(se_dump_stack*caller,T50* C,T0* a1);
extern se_frame_descriptor f50put_string;
extern T0*oBC19all_classes;
extern int fBC19all_classes;
T0* r18all_classes(se_dump_stack*caller);
extern se_frame_descriptor f18all_classes;
T0* r18all_names(se_dump_stack*caller);
extern se_frame_descriptor f18all_names;
extern T0*oBC1command_arguments;
extern int fBC1command_arguments;
T0* r18command_arguments(se_dump_stack*caller);
extern se_frame_descriptor f18command_arguments;
T2 r18argument_count(se_dump_stack*caller,T18* C);
extern se_frame_descriptor f18argument_count;
T0* r18all_features(se_dump_stack*caller);
extern se_frame_descriptor f18all_features;
void r18make(se_dump_stack*caller,T18* C);
extern se_frame_descriptor f18make;
T0* r18find_class_from_reference(se_dump_stack*caller,T18* C,T17 a1);
extern se_frame_descriptor f18find_class_from_reference;
extern T0*oBC1std_output;
T0* r18all_spellings(se_dump_stack*caller);
extern se_frame_descriptor f18all_spellings;
T0* r18argument(se_dump_stack*caller,T18* C,T2 a1);
extern se_frame_descriptor f18argument;
extern T0*oBC18csv_file;
extern int fBC18csv_file;
T0* r18csv_file(se_dump_stack*caller);
extern se_frame_descriptor f18csv_file;
extern T18*eiffel_root_object;
extern int se_argc;
extern char**se_argv;
#define SE_MAXID 69
extern T7* g[];
extern T7* t[];
extern char* p[];
extern void(*se_prinT[69])(void**);
void initialize_eiffel_runtime(int argc,char*argv[]);
extern T7*ms18_1436505586;
extern T7*ms19_495303630;
extern T7*ms26_1859534213;
extern T7*ms18_78448212;
extern T7*ms19_433290798;
extern T7*ms19_683379699;
extern T7*ms18_15956;
extern T7*ms18_930068410;
extern T7*ms18_1420068785;
extern T7*ms19_1061971043;
extern T7*ms19_683379699a;
extern T7*ms24_1807165412;
extern T7*ms18_36564660;
extern T7*ms18_585664352;
extern T7*ms24_1416753280;
extern T7*ms18_305;
extern T7*ms18_343;
extern T7*ms18_32a;
extern T7*ms18_391620192;
extern T7*ms18_32aaaa;
extern T7*ms18_10522043;
extern T7*ms19_360;
extern T7*ms18_1208554584;
extern T7*ms18_8021535;
extern T7*ms18_1211759081;
extern T7*ms18_32aaa;
extern T7*ms18_992129236;
extern T7*ms18_2037755417;
extern T7*ms18_15677902;
extern T7*ms18_1319045275;
extern T7*ms19_1538229628;
extern T7*ms18_1535;
extern T7*ms19_1773176095;
extern T7*ms18_278058207;
extern T7*ms25_2270;
extern T7*ms26_164777188a;
extern T7*ms17_1949511993;
extern T7*ms25_2478;
extern T7*ms3_736411847;
extern T7*ms25_2795;
extern T7*ms18_32aa;
extern T7*ms18_48745269;
extern T7*ms18_1631001923;
extern T7*ms18_73249748;
extern T7*ms2_117797837;
extern T7*ms18_1101464864;
extern T7*ms18_1632845627;
extern T7*ms18_2083738964;
extern T7*ms2_1949511993;
extern T7*ms18_1471027379;
extern T7*ms18_1112394744;
extern T7*ms18_32;
extern T7*ms18_928730390;
extern T7*ms18_1720878936;
extern T7*ms18_23340076;
extern T7*ms26_164777188;
extern T7*ms18_583186920;
extern T7*ms18_951510288;
extern T7*ms18_741426632;
T7*se_ms(int c,char*e);
T7*se_string(char*e);
void se_msi1(void);
void se_msi2(void);
void X33put_character(se_dump_stack*caller,se_position position,T0*C,T3 a1);

#ifdef __cplusplus
}
#endif
