/*             This file is part of the New World OS project
--                Copyright (C) 2005, 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: big_bang.c,v $
-- Revision 1.27  2006/11/11 12:01:01  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.26  2006/10/26 01:07:50  jsedwards
-- Replaced main truck version (1.25) with the latest version from the
-- alpha_05_branch.
--
-- Revision 1.16.2.11  2006/10/25 12:22:26  jsedwards
-- Changed C_struct_class_definition to C_struct_Class_Definition so the case
-- is consistent with all the other C_struct objects.
--
-- Revision 1.16.2.10  2006/10/03 12:53:07  jsedwards
-- Changed so that instead of calling a separate routine after initialize to
-- change the already opened storage, you call it now with a type of storage
-- parameter and a path to the storage.  The problem with the other way was
-- if you tried reading a compressed file on another machine it tried to open
-- the default file which didn't exist.
--
-- Revision 1.16.2.9  2006/09/29 04:21:57  jsedwards
-- Changed to use magic number and version string definitions instead of
-- hard coding the values.
--
-- Revision 1.16.2.8  2006/09/26 13:26:49  jsedwards
-- Commented out code to creat the file, because using a whole disk drive or
-- partition now.
--
-- Revision 1.16.2.7  2006/09/22 02:30:10  jsedwards
-- Add code to make sure open succeeded.
--
-- Revision 1.16.2.6  2006/09/03 13:57:24  jsedwards
-- Added code to create the one file.
--
-- Revision 1.16.2.5  2006/09/03 11:02:15  jsedwards
-- Moved the setting of spelling class and name class references to just after
-- they are generated so that if we are debugging they are known as early as
-- possible.  Also changed so that when rewriting the 4 initial classes,
-- instead of removing and then writing the object, there is a routine that
-- allows an object to be overwritten.
--
-- Revision 1.16.2.4  2006/09/02 15:09:41  jsedwards
-- Add call to terminate objectify so reference list cache gets flushed back
-- to disk, etc.
--
-- Revision 1.16.2.3  2006/09/02 01:13:30  jsedwards
-- Added reference in calls to fill_in_common_header because it puts it in
-- the header now.
--
-- Revision 1.16.2.2  2006/08/19 14:32:59  jsedwards
-- Moved creation of MD5sum class to file_setup routine (in file.c) and
-- replaced it with a call to the file_setup routine.
--
-- Revision 1.16.2.1  2006/08/18 12:53:48  jsedwards
-- Changed hard coded 512 for block size to FILE_BLOCK_SIZE.
--
-- Revision 1.16  2006/01/12 03:00:23  jsedwards
-- Added code to ask if he/she wants to upgrade objects from 0004.
-- Added call to upgrade spelling objects from 0004 to 0005.
--
-- Revision 1.15  2006/01/09 03:21:00  jsedwards
-- Added more print statements to describe what was happening.
-- Added a call to upgrade persons from 0004 to 0005 version.
--
-- Revision 1.14  2006/01/06 14:15:58  jsedwards
-- Changed to handle upgrading from alpha_04 (0004) to alpha_05 (0005).
--
-- Revision 1.13  2006/01/04 15:13:57  jsedwards
-- Added call to setup address classes.
--
-- Revision 1.12  2006/01/03 03:24:44  jsedwards
-- Updated copyright year in version information printed on start up.
--
-- Revision 1.11  2006/01/01 21:49:01  jsedwards
-- Moved date, phone, us_state, and word class creations out of "big bang"
-- and into the respective files.
--
-- Revision 1.10  2005/12/31 17:53:43  jsedwards
-- Moved class creation routine to a separate file: "class_definition.c".
-- Moved creation of "person" related classes to "person.c".
--
-- Revision 1.9  2005/12/31 15:40:58  jsedwards
-- Added creation of "social security number" class.
--
-- Revision 1.8  2005/12/31 03:07:16  jsedwards
-- Changed wording in disclaimer.
--
-- Revision 1.7  2005/12/30 17:11:46  jsedwards
-- Added disclaimers about no warranty and security issues.
--
-- Revision 1.6  2005/12/29 18:15:18  jsedwards
-- Added code to read back objects after they are written to verify that the
-- write worked correctly.
--
-- Revision 1.5  2005/12/29 18:06:57  jsedwards
-- Added print statements to print the object ID's of class defintions and
-- reference lists.
--
-- Revision 1.4  2005/12/29 18:02:37  jsedwards
-- Changed to call create_reference_list for class_definition_class object
-- instead of rolling our own.  Rolling our own was is bad when regular
-- objects are encrypted and reference lists are not because if we call the
-- write object to disk routine it encrypts the reference list.  Also changed
-- it so that the dummy object has a whole CommonHeader.
--
-- Revision 1.3  2005/12/28 13:06:29  jsedwards
-- Changed to use the new variable length key from password stuff and call the
-- new initialize_objectify routine with the blowfish key and seeds for the
-- sequence generator.
--
-- Revision 1.2  2005/12/27 19:49:36  jsedwards
-- Added code to create the root class and the root object.
--
-- Revision 1.1  2005/12/27 18:45:31  jsedwards
-- Renamed file from create_class_def.c to big_bang.c.  Changed all of the
-- class definitions from hardcoded file names to random ids.  Had to modify
-- to deal with chicken and egg problems.
--
-- Revision 1.20  2005/12/24 16:18:26  jsedwards
-- Removed "host" id from object references (ObjRef).  Host redirection will
-- be done using a "redirection" object in the future.
--
-- Revision 1.19  2005/12/21 17:10:31  jsedwards
-- Add 'nwos' to 'create_all_area_codes' routine name.
--
-- Revision 1.18  2005/12/21 17:06:48  jsedwards
-- Add call to create the US area codes.
--
-- Revision 1.17  2005/12/21 03:55:48  jsedwards
-- Added creation of abbreviation and US states classes.
--
-- Revision 1.16  2005/12/21 03:52:27  jsedwards
-- Moved US state objects creation from 'create_class_def.c' into 'date.c'.
--
-- Revision 1.15  2005/12/11 17:07:59  jsedwards
-- Added creation of "Area Code" class and the "Home", "Work", and "Mobile"
-- phone classes.
--
-- Revision 1.14  2005/12/11 17:01:37  jsedwards
-- Moved create english language function to the language.c file.  Rearranged
-- the order of the class definitions so that spelling and word classes are
-- defined before the english language definitions, otherwise when the create
-- english language function tries to create the word "English" it fails.
-- Also added code when the create english language function is not called
-- because it already exists to search for the english language object so
-- that other words we create will be able to access it.
--
-- Revision 1.13  2005/12/10 15:03:36  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.12  2005/12/08 18:05:04  jsedwards
-- Added creation of Phone Number class definition.
--
-- Revision 1.11  2005/12/05 19:04:51  jsedwards
-- Changed month structure member to the correct one for computing the data
-- checksum.
--
-- Revision 1.10  2005/12/05 05:28:02  jsedwards
-- Moved calculation of headers down to just before object is written to make
-- sure no changes occur after the checksums have been calculated.
--
-- Revision 1.9  2005/12/04 14:11:27  jsedwards
-- Added creation of the Person class.
--
-- Revision 1.8  2005/12/04 04:13:01  jsedwards
-- Added 'nwos' prefix to create_xxxx function names and eliminated the
-- 'referring' object parameter from all of them.
--
-- Revision 1.7  2005/12/03 22:09:37  jsedwards
-- Updated for new style of words and added spelling and language classes.
--
-- Revision 1.6  2005/12/03 02:02:28  jsedwards
-- Added routine to create the month objects (all 12).
--
-- Revision 1.5  2005/12/02 20:31:49  jsedwards
-- Added new parameter to the calls to create_reference_list.
--
-- Revision 1.4  2005/11/30 14:00:53  jsedwards
-- Added creation of date related classes.
--
-- Revision 1.3  2005/11/30 13:49:49  jsedwards
-- Added 'Name' class and made create class definition routine generic.
--
-- Revision 1.2  2005/11/26 15:21:12  jsedwards
-- Modified to use newer data layout and routines.
--
-- Revision 1.1  2005/11/25 13:33:48  jsedwards
-- Copied from 'lab'.
--
-- Revision 1.2  2005/11/24 16:10:13  jsedwards
-- This is broken, needs to be fixed.
--
-- Revision 1.1  2005/11/13 00:10:11  jsedwards
-- Program to create initial class definitions.
--
*/

#include <assert.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>   /* define memset */
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "objectify.h"
#include "objectify_private.h"
#include "time_stamp.h"
#include "crc32.h"


#define NOT_ENDIAN_SENSITIVE false
#define ENDIAN_SENSITIVE     true


C_struct_Class_Definition class_def_class_obj;


void goodbye()
{
    fprintf(stderr, "\n");
    fprintf(stderr, "I'm sorry you don't wish to use this software.  If you have any comments,\n");
    fprintf(stderr, "questions, or concerns please e-mail me at `crossrip@gmail.com'.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "-------->   Program terminated without creating database!   <--------\n");
    fprintf(stderr, "\n");
    exit(1);
}


void agree_no_warranty()
{
    char buffer[16];

                  /*          1         2         3         4         5         6         7         8 */
                  /* 12345678901234567890123456789012345678901234567890123456789012345678901234567890 */
    fprintf(stderr, "\n");
    fprintf(stderr, "Objectify version %s\n", RELEASE_VERSION);
    fprintf(stderr, "Copyright (C) 2005, 2006  J. Scott Edwards - QRW Software\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "This software comes with ABSOLUTELY NO WARRANTY; THE ENTIRE RISK AS TO THE\n");
    fprintf(stderr, "QUALITY AND PERFORMANCE OF THIS PROGRAM IS WITH YOU.  For details read the\n");
    fprintf(stderr, "`GNU General Public License' described in the file `LICENSE', which should\n");
    fprintf(stderr, "have been distributed with this software.  If it is not included, it can be\n");
    fprintf(stderr, "read online at `http://www.gnu.org/copyleft/gpl.html'.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "This is free software, and you are welcome to redistribute it under certain\n");
    fprintf(stderr, "conditions; also see the `LICENSE' file for details.  If you have any comments\n");
    fprintf(stderr, "or questions you can e-mail me at `crossrip@gmail.com'\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "If you wish to use this program, enter \"I agree\" at the prompt.  By doing so\n");
    fprintf(stderr, "you agree to the terms specified in the GNU General Public License.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "Do you agree with the license terms of this software? ");
    fflush(stderr);

    fgets(buffer, sizeof(buffer), stdin);

    if (strcmp(buffer, "I agree\n") != 0) goodbye();
}


void understand_security()
{
    char buffer[16];

    fprintf(stderr, "\n");
    fprintf(stderr, "*******************************************************************************\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "In addition to the above there are two things you should be aware of before\n");
    fprintf(stderr, "using this software:\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "1) This software attempts to make your data secure by encrypting the data\n");
    fprintf(stderr, "when it is written to the disk.  To the best of my knowledge this should make\n");
    fprintf(stderr, "it extremely difficult for anyone to read your information, even if they\n");
    fprintf(stderr, "have access to the files.  However, I am NOT a security expert and I CANNOT\n");
    fprintf(stderr, "guarantee that the methods used in this program actually provide any security.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "Because the source code is included with this software, you can examine it\n");
    fprintf(stderr, "yourself and determine if you are comfortable with the security it provides.\n");
    fprintf(stderr, "If the source code was not included with this package you can download it from\n");
    fprintf(stderr, "SourceForge from the 'http://sourceforge.net/projects/nwos' web page.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "NOTE: in this version the reference lists that connect the data objects\n");
    fprintf(stderr, "together are not encrypted, this could give a potential cracker some clues\n");
    fprintf(stderr, "about which data objects are related to other objects.  I still feel that\n");
    fprintf(stderr, "it would be difficult to decrypt those objects, but it is something to be\n");
    fprintf(stderr, "aware of.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "2) This version of Objectify uses a long pass phrase (a minimum of 34\n");
    fprintf(stderr, "characters) to encrypt the objects.  Be aware that if you forget or lose\n");
    fprintf(stderr, "the pass phrase, there is NO KNOWN WAY of recovering your data.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "If you still wish to use this program, enter \"I understand\" at the prompt.\n");
    fprintf(stderr, "By doing so you acknowledge that you understand that the security methods in\n");
    fprintf(stderr, "this program are not guaranteed.  You also acknowledge that if you forget or\n");
    fprintf(stderr, "otherwise lose the pass phrase, YOUR DATA WILL BE LOST FOREVER.\n");
    fprintf(stderr, "\n");
    fprintf(stderr, "Do you understand this? ");
    fflush(stderr);

    fgets(buffer, sizeof(buffer), stdin);

    if (strcmp(buffer, "I understand\n") != 0) goodbye();

    fprintf(stderr, "\n");
}



/***************************************************************************/
/* There is a chicken and egg problem here.  To define the name of the     */
/* class, name and spelling objects must be created.  But since we haven't */
/* created any class objects yet, that can't be done.  To get around the   */
/* problem we create empty "class definition", "reference list", "name",   */
/* "spelling" class objects and their reference lists.  Then we can create */
/* the name objects for those classes and go back, fill in the names and   */
/* rewrite the class defintion objects with names included.                */
/***************************************************************************/

void create_class_def_and_ref_list_and_spelling_and_name_class_objects()
{
    ObjRef spelling_class_ref;
    ObjRef name_class_ref;
    C_struct_Class_Definition ref_list_class_def_obj;
    C_struct_Class_Definition spelling_class_def_obj;
    C_struct_Class_Definition name_class_def_obj;
#ifdef READ_BACK_TO_VERIFY
    uint8 buffer[FILE_BLOCK_SIZE];
#endif

    /*-------------------------------------------------*/
    /* first generate the empty class definition class */
    /*-------------------------------------------------*/

    nwos_generate_new_id(&nwos_class_definition_class_ref);    /* id for class definition class itself */
    nwos_generate_new_id(&nwos_reference_list_class_ref);      /* id for reference list class object */

    printf("nwos_class_definition_class_ref -> %02x%02x%02x%02x\n", nwos_class_definition_class_ref.id[0], 
      nwos_class_definition_class_ref.id[1], nwos_class_definition_class_ref.id[2], nwos_class_definition_class_ref.id[3]);
    
    printf("nwos_reference_list_class_ref -> %02x%02x%02x%02x\n", nwos_reference_list_class_ref.id[0], 
      nwos_reference_list_class_ref.id[1], nwos_reference_list_class_ref.id[2], nwos_reference_list_class_ref.id[3]);
    
    memset(&class_def_class_obj, 0, sizeof(class_def_class_obj));
    nwos_fill_in_common_header(&class_def_class_obj.header.common, &nwos_class_definition_class_ref, &nwos_class_definition_class_ref);

    /* the only thing create_reference_list needs is the nwos_reference_list_class_ref variable set, which we did above */

    nwos_create_reference_list(&nwos_class_definition_class_ref, &class_def_class_obj.header.object.references);

    printf("class_definition_references -> %02x%02x%02x%02x\n", class_def_class_obj.header.object.references.id[0], 
	   class_def_class_obj.header.object.references.id[1], class_def_class_obj.header.object.references.id[2], 
	   class_def_class_obj.header.object.references.id[3]);
    
    nwos_crc32_calculate((uint8*) &class_def_class_obj.header.object, sizeof(class_def_class_obj.header.object), class_def_class_obj.header.common.header_chksum);
    nwos_crc32_calculate((uint8*) &class_def_class_obj.name, sizeof(class_def_class_obj) - sizeof(EveryObject), class_def_class_obj.header.common.data_chksum);

    nwos_write_object_to_disk(&nwos_class_definition_class_ref, &class_def_class_obj, sizeof(class_def_class_obj));

#ifdef READ_BACK_TO_VERIFY
    nwos_read_object_from_disk(&nwos_class_definition_class_ref, buffer, sizeof(class_def_class_obj));
    assert(memcmp(&class_def_class_obj, buffer, sizeof(class_def_class_obj)) == 0);
#endif

    /*----------------------------------------*/
    /* next generate the reference list class */
    /*----------------------------------------*/

    memset(&ref_list_class_def_obj, 0, sizeof(ref_list_class_def_obj));
    nwos_fill_in_common_header(&ref_list_class_def_obj.header.common, &nwos_reference_list_class_ref, &nwos_class_definition_class_ref);

    /* the reference list class doesn't have a reference list, at least for now */

    nwos_crc32_calculate((uint8*) &ref_list_class_def_obj.header.object, sizeof(ref_list_class_def_obj.header.object), ref_list_class_def_obj.header.common.header_chksum);
    nwos_crc32_calculate((uint8*) &ref_list_class_def_obj.name, sizeof(ref_list_class_def_obj) - sizeof(EveryObject), ref_list_class_def_obj.header.common.data_chksum);

    nwos_write_object_to_disk(&nwos_reference_list_class_ref, &ref_list_class_def_obj, sizeof(ref_list_class_def_obj));

    /* add a reference for the reference list class to the class definition class */
    nwos_add_to_reference_list(&nwos_reference_list_class_ref, &class_def_class_obj.header.object.references);

#ifdef READ_BACK_TO_VERIFY
    nwos_read_object_from_disk(&nwos_reference_list_class_ref, buffer, sizeof(ref_list_class_def_obj));
    assert(memcmp(&ref_list_class_def_obj, buffer, sizeof(ref_list_class_def_obj)) == 0);
#endif

    /*----------------------------------*/
    /* next generate the spelling class */
    /*----------------------------------*/

    nwos_generate_new_id(&spelling_class_ref);      /* id for reference list class object */
    nwos_set_spelling_class_ref(&spelling_class_ref);

    printf("spelling_class_ref -> %02x%02x%02x%02x\n", spelling_class_ref.id[0], 
      spelling_class_ref.id[1], spelling_class_ref.id[2], spelling_class_ref.id[3]);
    
    memset(&spelling_class_def_obj, 0, sizeof(spelling_class_def_obj));
    nwos_fill_in_common_header(&spelling_class_def_obj.header.common, &spelling_class_ref, &nwos_class_definition_class_ref);

    nwos_create_reference_list(&spelling_class_ref, &spelling_class_def_obj.header.object.references);

    printf("spelling_class_references -> %02x%02x%02x%02x\n", spelling_class_def_obj.header.object.references.id[0], 
	   spelling_class_def_obj.header.object.references.id[1], spelling_class_def_obj.header.object.references.id[2], 
	   spelling_class_def_obj.header.object.references.id[3]);
    
    nwos_crc32_calculate((uint8*) &spelling_class_def_obj.header.object, sizeof(spelling_class_def_obj.header.object), spelling_class_def_obj.header.common.header_chksum);
    nwos_crc32_calculate((uint8*) &spelling_class_def_obj.name, sizeof(spelling_class_def_obj) - sizeof(EveryObject), spelling_class_def_obj.header.common.data_chksum);

    nwos_write_object_to_disk(&spelling_class_ref, &spelling_class_def_obj, sizeof(spelling_class_def_obj));

    /* add a reference for the spelling class to the class definition class */
    nwos_add_to_reference_list(&spelling_class_ref, &class_def_class_obj.header.object.references);

#ifdef READ_BACK_TO_VERIFY
    nwos_read_object_from_disk(&spelling_class_ref, buffer, sizeof(spelling_class_def_obj));
    assert(memcmp(&spelling_class_def_obj, buffer, sizeof(spelling_class_def_obj)) == 0);
#endif

    /*---------------------------------*/
    /* finally generate the name class */
    /*---------------------------------*/

    nwos_generate_new_id(&name_class_ref);      /* id for reference list class object */
    nwos_set_name_class_ref(&name_class_ref);

    printf("name_class_ref -> %02x%02x%02x%02x\n", name_class_ref.id[0], 
      name_class_ref.id[1], name_class_ref.id[2], name_class_ref.id[3]);
    
    memset(&name_class_def_obj, 0, sizeof(name_class_def_obj));
    nwos_fill_in_common_header(&name_class_def_obj.header.common, &name_class_ref, &nwos_class_definition_class_ref);

    nwos_create_reference_list(&name_class_ref, &name_class_def_obj.header.object.references);

    printf("name_class_references -> %02x%02x%02x%02x\n", name_class_def_obj.header.object.references.id[0], 
	   name_class_def_obj.header.object.references.id[1], name_class_def_obj.header.object.references.id[2], 
	   name_class_def_obj.header.object.references.id[3]);
    
    nwos_crc32_calculate((uint8*) &name_class_def_obj.header.object, sizeof(name_class_def_obj.header.object), name_class_def_obj.header.common.header_chksum);
    nwos_crc32_calculate((uint8*) &name_class_def_obj.name, sizeof(name_class_def_obj) - sizeof(EveryObject), name_class_def_obj.header.common.data_chksum);

    nwos_write_object_to_disk(&name_class_ref, &name_class_def_obj, sizeof(name_class_def_obj));

    /* add a reference for the name class to the class definition class */
    nwos_add_to_reference_list(&name_class_ref, &class_def_class_obj.header.object.references);

#ifdef READ_BACK_TO_VERIFY
    nwos_read_object_from_disk(&name_class_ref, buffer, sizeof(name_class_def_obj));
    assert(memcmp(&name_class_def_obj, buffer, sizeof(name_class_def_obj)) == 0);
#endif

    /*------------------------------------------------------------------*/
    /* finally we can create the names for the classes and rewrite them */
    /*------------------------------------------------------------------*/

    nwos_create_name("CLASS DEFINITION", &class_def_class_obj.name);
    nwos_crc32_calculate((uint8*) &class_def_class_obj.name, sizeof(class_def_class_obj) - sizeof(EveryObject), class_def_class_obj.header.common.data_chksum);                                     /* recompute the data checksum */
    nwos_overwrite_object_to_disk(&nwos_class_definition_class_ref, &class_def_class_obj, sizeof(class_def_class_obj));

    nwos_create_name("REFERENCE LIST", &ref_list_class_def_obj.name);
    nwos_crc32_calculate((uint8*) &ref_list_class_def_obj.name, sizeof(ref_list_class_def_obj) - sizeof(EveryObject), ref_list_class_def_obj.header.common.data_chksum);
    nwos_overwrite_object_to_disk(&nwos_reference_list_class_ref, &ref_list_class_def_obj, sizeof(ref_list_class_def_obj));

    nwos_create_name("SPELLING", &spelling_class_def_obj.name);
    nwos_crc32_calculate((uint8*) &spelling_class_def_obj.name, sizeof(spelling_class_def_obj) - sizeof(EveryObject), spelling_class_def_obj.header.common.data_chksum);
    nwos_overwrite_object_to_disk(&spelling_class_ref, &spelling_class_def_obj, sizeof(spelling_class_def_obj));

    nwos_create_name("NAME", &name_class_def_obj.name);
    nwos_crc32_calculate((uint8*) &name_class_def_obj.name, sizeof(name_class_def_obj) - sizeof(EveryObject), name_class_def_obj.header.common.data_chksum);
    nwos_overwrite_object_to_disk(&name_class_ref, &name_class_def_obj, sizeof(name_class_def_obj));

#ifdef READ_BACK_TO_VERIFY
    nwos_read_object_from_disk(&nwos_class_definition_class_ref, buffer, sizeof(class_def_class_obj));
    assert(memcmp(&class_def_class_obj, buffer, sizeof(class_def_class_obj)) == 0);
    nwos_read_object_from_disk(&nwos_reference_list_class_ref, buffer, sizeof(ref_list_class_def_obj));
    assert(memcmp(&ref_list_class_def_obj, buffer, sizeof(ref_list_class_def_obj)) == 0);
    nwos_read_object_from_disk(&spelling_class_ref, buffer, sizeof(spelling_class_def_obj));
    assert(memcmp(&spelling_class_def_obj, buffer, sizeof(spelling_class_def_obj)) == 0);
    nwos_read_object_from_disk(&name_class_ref, buffer, sizeof(name_class_def_obj));
    assert(memcmp(&name_class_def_obj, buffer, sizeof(name_class_def_obj)) == 0);
#endif
}



/*****************************************************************************/
/* The big bang main routine.                                                */
/*                                                                           */
/* 1) First double check to make sure this program wasn't run before.  Since */
/*    it no longer has fixed filenames for the classes, it could easily run  */
/*    a second time and create a whole new set of objects.  This is done by  */
/*    creating a dummy object (filename: 12345678) that always has the same  */
/*    name and making sure it doesn't exist before doing anything else.      */
/*                                                                           */
/* 2) Create the four critical class definition objects (class definitions,  */
/*    reference list, spelling, and name).  This has to be done a special    */
/*    way because class definitions have names and to create the names, the  */
/*    spelling and name classes must exist.  A chicken and egg problem.      */
/*                                                                           */
/* 3) Create the root class and the root object.                             */
/*                                                                           */
/* 4) Create the "word" and "language" classes since they are intertwined    */
/*    as well.                                                               */
/*                                                                           */
/* 5) Create date classes, "year", "month" and "date".                       */
/*                                                                           */
/* 6) Create US states classes.                                              */
/*                                                                           */
/* 7) Create the classes for people.                                         */
/*                                                                           */
/* 8) Create Phone classes, area code, phone number, and phones.             */
/*****************************************************************************/

int main(int argc, char* argv[])
{
    ObjRef root_object_reference;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    bool upgrade = false;
//    struct stat stat_struct;
//    int obj_fd;

    agree_no_warranty();   /* make sure he or she agrees with the licensing */

#if 0
    if (stat(DEFAULT_FILE, &stat_struct) == 0)
    {
	fprintf(stderr, "Error file: %s already exists\n", DEFAULT_FILE);
	exit(1);
    }

    need to come up with a whole new strategy for this....

    upgrade = nwos_object_exists(&reference);

    if (upgrade)   /* see if the objects have already been upgraded */
    {
	printf("Objects already exist, checking version...\n\n");

	nwos_read_reference_list_from_disk(&reference, &dummy, sizeof(dummy));

	if (memcmp(&dummy.version, HEADER_VERSION, sizeof(dummy.version)) == 0)
	{
	    fprintf(stderr, "It appears this program has been run before, objects already exist and are the\n");
	    fprintf(stderr, "correct version (0005).  There is no need to run \"%s\" again.\n\n", argv[0]);
	    exit(1);
	}

	memcpy(version, dummy.version, 4);
	version[4] = '\0';
	printf("Objects are old version: %s.\n", version);

	if (!nwos_ask_yes_or_no(NULL, "Would you like to upgrade your objects"))
	{
	    printf("Ok, exiting without upgrade!\n");
	    exit(1);
	}
    }
#endif

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_reference.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];


#if 0
    obj_fd = open(DEFAULT_FILE, O_WRONLY);    /* don't need large file to create it (I think) */

    if (obj_fd < 0)
    {
	perror(DEFAULT_FILE);
	exit(1);
    }

    if (fchmod(obj_fd, 0600) != 0)
    {
	perror(DEFAULT_FILE);
	exit(1);
    }

    if (write(obj_fd, MAGIC_NUMBER VERSION_STRING, 8) != 8)     /* used version string 0010 in eiffel version */
    {
	perror(DEFAULT_FILE);
	exit(1);
    }

    if (close(obj_fd) != 0)
    {
	perror(DEFAULT_FILE);
	exit(1);
    }
#endif
    nwos_initialize_objectify(bf_key, linear, serial, DEFAULT_TYPE, DEFAULT_FILE);

    if (upgrade)
    {
	printf("Upgrading...\n");

	nwos_set_root_object(&root_object_reference);

	/* do spellings first because it is fewer to do if other upgrades create new names */

	printf("  Changing all spelling objects to lower case.\n");
	nwos_upgrade_spellings_from_0004_to_0005();
#if 0
	printf("  Removing 'count' from month objects because it wasn't used.\n");
	nwos_upgrade_months_from_0004_to_0005();

	/* and we need to add capital cities to states and add additional cities */
	/* although this is really useless in this (alpha_05) version. */
	printf("  Adding capital cities to states.\n");
	nwos_upgrade_states_from_0004_to_0005();

	/* we need to change size of month objects because they no longer have a "count" */
	printf("  Adding gender to all person objects.\n");
	nwos_upgrade_persons_from_0004_to_0005();

	nwos_remove_object(&reference);   /* delete the old alpha_04 dummy object so the alpha_05 can be created below */
#endif
    }
    else
    {
	understand_security();   /* make sure he or she understands the risks */

	{
	  int i;
	  for (i = 0; i < sizeof(ObjRef); i++) printf("%02x", root_object_reference.id[i]);
	  printf("\n");
	}
    }

    if (!upgrade)
    {
	/*------------------------------------------------------------------------*/
	/* There is a chicken and egg problem here.  We can't put names in the    */
	/* class definitions because there are no class definitions to create     */
	/* the names.  To get around that, call a routine that creates the four   */
	/* critical class definition objects without names and then goes back and */
	/* fills in the blank names after the class defintions exist.             */
	/*------------------------------------------------------------------------*/

	printf ("Creating Class Definition, Reference List, Spelling, and Name class definitions.\n");
	create_class_def_and_ref_list_and_spelling_and_name_class_objects();

	/*---------------------------*/
	/* The root class and object */
	/*---------------------------*/

	printf ("Creating Root class definition.\n");
	nwos_create_class_definition("ROOT");
	printf ("Creating Root object: %02x%02x%02x%02x\n",
		root_object_reference.id[0],
		root_object_reference.id[1],
		root_object_reference.id[2],
		root_object_reference.id[3]);
	assert(nwos_create_root(&root_object_reference));

	nwos_setup_word();

	nwos_setup_date();

	nwos_setup_us_states();

	nwos_setup_person();       /* all things people */

	nwos_setup_phone();

	nwos_setup_address();

	nwos_setup_file();
    }

    nwos_terminate_objectify();

    return 0;
}

