/*             This file is part of the New World OS project
--                   Copyright (C) 2005  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: class_definition.c,v $
-- Revision 1.5  2006/11/29 18:29:03  jsedwards
-- Fixed bug where memory following class_ref was overwritten if pointers were
-- not the same size as an ObjRef.
--
-- Revision 1.4  2006/11/11 14:19:07  jsedwards
-- Moved find_class_defintion function from objectify.c.
--
-- Revision 1.3  2006/11/11 12:01:01  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.2  2006/10/26 01:51:23  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.1.2.2  2006/10/25 12:22:27  jsedwards
-- Changed C_struct_class_definition to C_struct_Class_Definition so the case
-- is consistent with all the other C_struct objects.
--
-- Revision 1.1.2.1  2006/09/01 13:27:20  jsedwards
-- Changed "nwos_object_size" to "nwos_reference_list_size" and added the
-- object reference to "nwos_fill_in_common_header" so it can put the "id"
-- in the header now.
--
-- Revision 1.1  2005/12/31 17:54:54  jsedwards
-- Extracted "create_class_definition" routine from "big_bang.c" and created
-- this file.
--
*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include "crc32.h"
#include "objectify.h"
#include "objectify_private.h"


/*****************************************************************************/
/* This routine creates a class definition with the given name.              */
/*****************************************************************************/

void nwos_create_class_definition(char* name_of_class)
{
    ObjRef class_ref;
    C_struct_Class_Definition class_def_obj;

    memset(&class_def_obj, 0, sizeof(class_def_obj));  /* zero it out */

    nwos_generate_new_id(&class_ref);

    printf("create_class_definition(%s) -> %02x%02x%02x%02x\n", name_of_class,
	   class_ref.id[0], class_ref.id[1], class_ref.id[2], class_ref.id[3]);
    
    nwos_fill_in_common_header(&class_def_obj.header.common, &class_ref, &nwos_class_definition_class_ref);

    nwos_create_reference_list(&class_ref, &class_def_obj.header.object.references);

    nwos_create_name(name_of_class, &class_def_obj.name);

    nwos_crc32_calculate((uint8*) &class_def_obj.header.object, sizeof(ObjectHeader), class_def_obj.header.common.header_chksum);
    nwos_crc32_calculate((uint8*) &class_def_obj.name, sizeof(class_def_obj) - sizeof(EveryObject), class_def_obj.header.common.data_chksum);

    nwos_write_object_to_disk(&class_ref, &class_def_obj, sizeof(class_def_obj));

    nwos_add_to_references(&class_ref, &nwos_class_definition_class_ref);
}


/*****************************************************************************/
/* This routine finds the class definition with the given name.              */
/*****************************************************************************/

bool nwos_find_class_definition(char* name, ObjRef* class_ref)
{
    C_struct_Class_Definition class_def_obj;
    ReferenceList* ref_list;
    size_t ref_list_size;
    int num_classes;
    ObjRef object_class;
    char buffer[128];
    int i;
    bool result = false;

    memset(class_ref, 0, sizeof(ObjRef));

    nwos_read_object_from_disk(&nwos_class_definition_class_ref, &class_def_obj, sizeof(class_def_obj));

    ref_list_size = nwos_reference_list_size(&class_def_obj.header.object.references);

    ref_list = nwos_malloc(ref_list_size);

    if (ref_list == NULL) 
    {
	perror("find class definition, reading class definition class reference list");
	exit(1);
    }

    nwos_read_reference_list_from_disk(&class_def_obj.header.object.references, ref_list, ref_list_size);

    num_classes = (ref_list_size - sizeof(CommonHeader)) / sizeof(ObjRef);

    /* printf("num_classes (in find_class_definition): %d\n", num_classes); */

    for (i = 0; i < num_classes; i++)
    {
	nwos_get_object_class(&ref_list->references[i], &object_class);   /* find out what kind of object it is */

	if (is_same_object(&object_class, &nwos_class_definition_class_ref))   /* it is a class definition object */
	{
	    nwos_read_object_from_disk(&ref_list->references[i], &class_def_obj, sizeof(class_def_obj));

	    nwos_name_to_string(&class_def_obj.name, buffer, sizeof(buffer));   /* get it's name */

	    if (strcasecmp(name, buffer) == 0)
	    {
		memcpy(class_ref, &ref_list->references[i], sizeof(ObjRef));
		result = true;
		break;
	    }
	}
    }

    nwos_free(ref_list);
    ref_list = NULL;

    return result;
}


