/*             This file is part of the New World OS project
--                   Copyright (C) 2005  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: count_objs.c,v $
-- Revision 1.3  2006/11/11 12:01:02  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.2  2006/10/26 01:51:26  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.1.2.1  2006/10/25 12:22:27  jsedwards
-- Changed C_struct_class_definition to C_struct_Class_Definition so the case
-- is consistent with all the other C_struct objects.
--
-- Revision 1.1  2005/12/29 16:57:54  jsedwards
-- App to count up how many objects of each type there are.
--
*/

/* This app counts up the different classes for all the objects given as */
/* parameters and then outputs how many objects of each class there is.  */
/*                                                                       */
/* NOTE: it only works on unencrypted objects!                           */
/*                                                                       */
/* To use:                                                               */
/*    gcc -Wall -o count_objs count_objs.c libobjectify.a -lrt -lcrypto  */
/*    cd /obj                                                            */
/*    /path/to/count_objs * > count.out                                  */
/*    tail -20 count.out                                                 */


#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "objectify.h"
#include "crc32.h"



bool get_object_class(char* filename, ObjRef* class_ref)
{
    FILE *fp;
    size_t bytes_read;
    CommonHeader common;
    char path[5+13+1];
    int i;

    printf("%s: ", filename);

    sprintf(path, "/obj/%s", filename);

    fp = fopen(path, "r");

    if (fp == NULL)
    {
	perror(path);
	exit(1);
    }

    bytes_read = fread(&common, 1, sizeof(CommonHeader), fp);

    if (bytes_read != sizeof(CommonHeader))
    {
	perror(path);
	exit(1);
    }

    fclose(fp);

    /*--------------*/
    /* Magic Number */
    /*--------------*/

    if (memcmp(common.magic_number, "nwos", 4) != 0
	&& memcmp(common.magic_number, MAGIC_NUMBER, strlen(MAGIC_NUMBER)) != 0)
    {
	printf(" - not a NewWorld OS object\n");
	return false;
    }

    /*---------*/
    /* Version */
    /*---------*/

    if (!isdigit(common.version[0]) || !isdigit(common.version[1]) || !isdigit(common.version[2]))
    {
	printf(" - invalid version number\n");
	return false;
    }

    if (!isdigit(common.version[3]) && common.version[3] != 'n' && common.version[3] != 'l' && common.version[3] != 'b' )
    {
	printf(" - invalid version number\n");
	return false;
    }

    if (memcmp(common.version, HEADER_VERSION, 4) != 0)
    {
	printf(" - wrong version.\n");
	return false;
    }

    memcpy(class_ref, &common.class_definition, sizeof(*class_ref));

    for (i = 0; i < 4; i++) printf("%02x", class_ref->id[i]);

    printf("\n");

    return true;
}


int main(int argc, char* argv[])
{
    ObjRef class_ref;
    struct {
      ObjRef class_ref;
      int count;
    } info[100];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    int i;
    int j;
    int failures = 0;
    C_struct_Class_Definition class_def_obj;
    char class_name[64];

    for (j = 0; j < 100; j++) info[j].count = 0;

    nwos_initialize_objectify(bf_key, linear, serial);   /* for now not passing in real values */

    /* scan all objects and count up each type */

    for (i = 1; i < argc; i++)
    {
	if (get_object_class(argv[i], &class_ref))
	{
	    for (j = 0; j < 100; j++)  /* find it */
	    {
		if (info[j].count == 0)   /* it's not in here */
		{
		    memcpy(&info[j].class_ref, &class_ref, sizeof(info[j].class_ref));
		    info[j].count = 1;
		    break;
		}
		if (is_same_object(&class_ref, &info[j].class_ref))
		{
		    info[j].count++;
		    break;
		}
	    }
	    if (j == 100)  /* buffer is full */
	    {
		fprintf(stderr, "info buffer is full, probably a bug of some sort\n");
		exit(1);
	    }
	}
	else
	{
	    failures++;
	}
    }

    printf("total number: %d  failed: %d\n", argc-1, failures);

    nwos_initialize_objectify(bf_key, linear, serial);

    for (j = 0; j < 100; j++)  /* give results */
    {
	if (info[j].count == 0) break;  /* we're done */

	for (i = 0; i < 4; i++) printf("%02x", info[j].class_ref.id[i]);

	nwos_read_object_from_disk(&info[j].class_ref, &class_def_obj, sizeof(class_def_obj));

	nwos_name_to_string(&class_def_obj.name, class_name, sizeof(class_name));

	printf(" - %s: %d\n", class_name, info[j].count);
    }

    return 0;
}


