/*             This file is part of the New World OS project
--                   Copyright (C) 2005  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: dump_obj.c,v $
-- Revision 1.7  2006/11/11 12:01:03  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.6  2006/10/26 01:51:26  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.5.2.1  2006/10/25 12:22:28  jsedwards
-- Changed C_struct_class_definition to C_struct_Class_Definition so the case
-- is consistent with all the other C_struct objects.
--
-- Revision 1.5  2005/12/29 14:33:14  jsedwards
-- Updated to work with version Alpha_04 (0004) WITHOUT encryption turned on!
--
-- Revision 1.4  2005/12/24 16:18:26  jsedwards
-- Removed "host" id from object references (ObjRef).  Host redirection will
-- be done using a "redirection" object in the future.
--
-- Revision 1.3  2005/12/10 15:03:36  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.2  2005/12/02 14:12:09  jsedwards
-- Modified for new header layouts.
--
-- Revision 1.1.1.1  2005/11/25 12:44:27  jsedwards
-- Copied from 'lab'.
--
*/

#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "objectify.h"
#include "crc32.h"


void print_reference(char* name, ObjRef* ref)
{
  int i;
  char id[14];

  printf("%s ", name);

  for (i = 0; i < 4; i++) printf("%02x", ref->id[i]);
}


int main(int argc, char* argv[])
{
    FILE *fp;
    size_t bytes_read;
    CommonHeader common;
    uint8 crc32[4];
    char path[5+13+1];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    C_struct_Class_Definition class_def_obj;
    char class_name[64];

    if (argc != 2)
    {
	fprintf(stderr, "usage: %s filename", argv[0]);
	exit(1);
    }

    sprintf(path, "/obj/%s", argv[1]);

    fp = fopen(path, "r");

    if (fp == NULL)
    {
	perror(path);
	exit(1);
    }

    bytes_read = fread(&common, 1, sizeof(CommonHeader), fp);

    if (bytes_read != sizeof(CommonHeader))
    {
	perror(path);
	exit(1);
    }

    /*--------------*/
    /* Magic Number */
    /*--------------*/

    printf("Magic number:    %02x%02x%02x%02x  ", 
	 common.magic_number[0], common.magic_number[1], common.magic_number[2], common.magic_number[3]);

    if (memcmp(common.magic_number, "nwos", 4) != 0
	&& memcmp(common.magic_number, MAGIC_NUMBER, strlen(MAGIC_NUMBER)) != 0)
    {
	printf(" - not a NewWorld OS object\n");
	fclose(fp);
	exit(1);
    }

    printf("(%c%c%c%c)\n", 
	 common.magic_number[0], common.magic_number[1], common.magic_number[2], common.magic_number[3]);

    /*---------*/
    /* Version */
    /*---------*/

    printf("Version:         %02x%02x%02x%02x  ", common.version[0], common.version[1], common.version[2], common.version[3]);

    if (!isdigit(common.version[0]) || !isdigit(common.version[1]) || !isdigit(common.version[2]))
    {
	printf(" - invalid version number\n");
	fclose(fp);
	exit(1);
    }

    if (!isdigit(common.version[3]) && common.version[3] != 'n' && common.version[3] != 'l' && common.version[3] != 'b' )
    {
	printf(" - invalid version number\n");
	fclose(fp);
	exit(1);
    }

    printf("(%c%c%c%c)\n",  common.version[0], common.version[1], common.version[2], common.version[3]);


    if (memcmp(common.version, HEADER_VERSION, 4) != 0)
    {
	printf(" - sorry this version of %s can only dump version %s objects.\n", argv[0], HEADER_VERSION);
	fclose(fp);
	exit(1);
    }


    printf("Header Checksum: %02x%02x%02x%02x ", 
	   common.header_chksum[0], common.header_chksum[1], common.header_chksum[2], common.header_chksum[3]);
    printf(" - not checked\n");

    printf("Data Checksum:   %02x%02x%02x%02x ", 
	   common.data_chksum[0], common.data_chksum[1], common.data_chksum[2], common.data_chksum[3]);
    printf(" - not checked\n");

    print_reference("Class Def:      ", &common.class_definition);

    fclose(fp);

    nwos_initialize_objectify(bf_key, linear, serial);   /* for now not passing in real values */

    nwos_read_object_from_disk(&common.class_definition, &class_def_obj, sizeof(class_def_obj));

    nwos_name_to_string(&class_def_obj.name, class_name, sizeof(class_name));

    printf(" - %s\n", class_name);

    exit(0);
}


