--
--                This file is part of the New World OS project
--                       Copyright (C) 2006 QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--
--  This program is free software; you can redistribute it and/or modify it 
--  under the terms of the GNU General Public License as published by the 
--  Free Software Foundation; either version 2 of the License, or (at your 
--  option) any later version.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
--  for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to:
--
--      Free Software Foundation, Inc.
--      51 Franklin Street, Fifth Floor
--      Boston, MA   02110-1301
--      USA
--
--  On the internet: http://www.fsf.org/licenses/gpl.html
--
-- $Log: encode_word.e,v $
-- Revision 1.1  2006/04/09 03:36:22  jsedwards
-- Initial version.
--


-- App to convert a text word into the 12 hex digits

class ENCODE_WORD

creation make

feature

   make is
      local
         i: INTEGER
         word: INTEGER
         bits: INTEGER
         byte: BIT 32
         output: INTEGER
      do
         if argument_count /= 1 then
            std_error.put_string("usage: ")
            std_error.put_string(argument(0))
            std_error.put_string(" <word>%N")
            die_with_code(exit_failure_code)
         end

         from
            i := 1
         until
            i > argument(1).count
         loop
            if argument(1).item(i) /= '_' and then not argument(1).item(i).is_letter then
               std_error.put_string("invalid character: ")
               std_error.put_character(argument(1).item(i))
               std_error.put_new_line
               die_with_code(exit_failure_code)
            end

            i := i + 1
         end

         from
            i := 1
         until
            i > 19
         loop
            word := word * 32
            bits := bits + 5

            if i <= argument(1).count and then argument(1).item(i) /= '_' then
               word := word + argument(1).item(i).to_lower.code - ('a').code + 1
            end

            check
               bits < 15
               word < 32768
            end

            if bits >= 8 then
               bits := bits - 8
               if bits = 0 then
                  byte := word.to_bit
               else
                  byte := word.to_bit @>> bits
               end

               if output \\ 4 = 0 then
                  std_output.put_character(' ')
               end

               std_output.put_string("0x")
               std_output.put_string(byte.to_integer.to_character.to_hexadecimal)
               std_output.put_string(",")

               output := output + 1

               if bits = 0 then
                  word := 0
               else
                  word := word \\ (2 ^ bits)
               end
            end

            i := i + 1
         end

         std_output.put_string("0x")
         std_output.put_string((byte @<< 1).to_integer.to_character.to_hexadecimal)
         std_output.put_new_line
      end

end

