/*             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: import_file.c,v $
-- Revision 1.3  2006/11/11 12:01:03  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.2  2006/10/26 01:51:27  jsedwards
-- Merged alpha_05_branch back into main trunk.
--
-- Revision 1.1.2.4  2006/10/13 12:58:52  jsedwards
-- Added printing of time to import each file.
--
-- Revision 1.1.2.3  2006/10/13 11:48:27  jsedwards
-- Add call to flush block maps after each file is read.
--
-- Revision 1.1.2.2  2006/10/03 12:53:07  jsedwards
-- Changed so that instead of calling a separate routine after initialize to
-- change the already opened storage, you call it now with a type of storage
-- parameter and a path to the storage.  The problem with the other way was
-- if you tried reading a compressed file on another machine it tried to open
-- the default file which didn't exist.
--
-- Revision 1.1.2.1  2006/09/18 01:45:37  jsedwards
-- Program to store a file into objectify.
--
*/


#include <stdio.h>
#include <string.h>
#include <time.h>
#include "objectify.h"

extern void nwos_setup_file();

int main(int argc, char* argv[])
{
    ObjRef root_object_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    ObjRef ref;
    ObjCreateResult result;
    int i;
    time_t start_time;

    printf("\n");

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, DEFAULT_TYPE, DEFAULT_FILE);

    nwos_set_root_object(&root_object_ref);

    nwos_setup_file();

    for (i = 1; i < argc; i++)
    {
	start_time = time(NULL);

	result = nwos_create_file(argv[i], &ref);

	if (result == CREATED_NEW)
	{
	    printf("result: %02x%02x%02x%02x   time: %d seconds\n", 
		   ref.id[0], ref.id[1], ref.id[2], ref.id[3], 
		   (int) (time(NULL) - start_time));
	}
	else
	{
	    printf("result: %d\n", result);
	}

	nwos_flush_bit_maps();
    }

    nwos_terminate_objectify();

    return 0;
}


