/*             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: list_discs.c,v $
-- Revision 1.6  2006/11/27 13:50:44  jsedwards
-- Changed to use variable sized counts for disc lists (so number of files can
-- be larger than 127).
--
-- Revision 1.5  2006/11/19 15:28:20  jsedwards
-- Made get_disc_list_object_size a global function.
--
-- Revision 1.4  2006/11/18 15:09:10  jsedwards
-- Added "max_size" parameter to read_variable_sized_object_from_disk because
-- objects are no longer limited to one file block.
--
-- Revision 1.3  2006/11/18 14:37:02  jsedwards
-- Change size of kludge buffer for reading disc list to max size of disc
-- list instead of file block size, because now disc list objects can be
-- larger than one file block.
--
-- Revision 1.2  2006/11/11 12:01:04  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.1  2006/11/07 14:04:46  jsedwards
-- Program to list all of the discs logged in the system.
--
*/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include "objectify.h"


static size_t get_path_object_size(void* file_path_obj)
{
    assert(((C_struct_File_Path*)file_path_obj)->count > 0);

    return sizeof(C_struct_File_Path) + ((C_struct_File_Path*)file_path_obj)->count;
}


int main(int argc, char* argv[])
{
    ObjRef root_object_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    C_struct_Class_Definition class_def_obj;
    C_struct_Disc_Copy disc_obj;
    C_struct_Storage_Location location_obj;
    C_struct_File file_obj;
    uint8 kludge[MAX_SIZE_DISC_LIST];
    uint8 cludge[FILE_BLOCK_SIZE];
    C_struct_Disc_List* ptr_disc_obj = (C_struct_Disc_List*)kludge;
    C_struct_File_Path* ptr_path_obj = (C_struct_File_Path*)cludge;
    ObjRef disc_class_ref;
    ObjRef path_class_ref;
    ObjRef object_class;
    ReferenceList* ref_list;
    size_t ref_list_size;
    char name_str[128];
    char id_str[13];
    uint32 file_size;
    int num_refs;
    int i;
    int j;
    int count;


    printf("\n");

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, DEFAULT_TYPE, DEFAULT_FILE);

    nwos_set_root_object(&root_object_ref);

    assert(nwos_find_class_definition("FILE PATH", &path_class_ref));

    assert(nwos_find_class_definition("DISC COPY", &disc_class_ref));

    nwos_read_class_definition(&disc_class_ref, &class_def_obj);

    ref_list_size = nwos_reference_list_size(&class_def_obj.header.object.references);

    ref_list = malloc(ref_list_size);

    if (ref_list == NULL) 
    {
	perror("reading reference list");
	exit(1);
    }

    nwos_read_reference_list_from_disk(&class_def_obj.header.object.references, ref_list, ref_list_size);

    num_refs = (ref_list_size - sizeof(CommonHeader)) / sizeof(ObjRef);

    /* printf("num_refs: %d\n", num_refs); */

    for (i = 0; i < num_refs; i++)
    {
	nwos_get_object_class(&ref_list->references[i], &object_class);

	if (is_same_object(&object_class, &disc_class_ref))
	{
	    nwos_read_object_from_disk(&ref_list->references[i], &disc_obj, sizeof(disc_obj));

	    nwos_read_object_from_disk(&disc_obj.location, &location_obj, sizeof(location_obj));

	    assert(nwos_name_to_string(&location_obj.name, name_str, sizeof(name_str)));

	    nwos_read_variable_sized_object_from_disk(&disc_obj.disc_list, kludge, sizeof(kludge), &nwos_get_disc_list_object_size);

	    memcpy(id_str, ptr_disc_obj->id, 12);
	    id_str[12] = '\0';

	    count = nwos_decode_variable_sized_count(ptr_disc_obj->count);

	    printf("disc: %s  files: %u  copy number: %d  location: %s\n",
		   id_str, count, disc_obj.copy_number, name_str);

            for (j = 0; j < count; j++)
	    {
		nwos_read_variable_sized_object_from_disk(&ptr_disc_obj->files[j], cludge, sizeof(cludge), &get_path_object_size);

		memcpy(name_str, ptr_path_obj->storage, ptr_path_obj->count);
		name_str[ptr_path_obj->count] = '\0';

		nwos_read_object_from_disk(&ptr_path_obj->file, &file_obj, sizeof(file_obj));

		file_size = (file_obj.size[0] << 24) | (file_obj.size[1] << 16) | (file_obj.size[2] << 8) | (file_obj.size[3]);

		printf("   %s %u\n", name_str, file_size);
	    }
	}
    }

    free(ref_list);
    ref_list = NULL;

    nwos_terminate_objectify();

    return 0;
}


