--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_letter.e,v $
-- Revision 1.16  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.15  2006/02/20 05:00:12  jsedwards
-- Reversed upper and lower case, so that lower case is the default when the
-- letter is printed via the symbol class.
--
-- Revision 1.14  2006/02/19 15:33:24  jsedwards
-- Added inheritance from NWOS_LETTER_OR_SPELLING_INDEX to allow the spelling
-- indexes to point back to either the first letter object or the previous
-- spelling index.  Also added "Current" to creation call for spelling index
-- so that it points back to this letter.
--
-- Revision 1.13  2006/02/19 14:54:20  jsedwards
-- Removed loading of upper and lower case character objects and spelling
-- index.  This is done automatically now.
--
-- Revision 1.12  2006/02/19 03:38:31  jsedwards
-- Changed attributes to routines that make sure the object is loaded before
-- returning object.
--
-- Revision 1.11  2006/02/13 04:39:03  jsedwards
-- Changed to inherit from new NWOS_SYMBOL class, and redefine it's
-- character attribute to upper_case.
--
-- Revision 1.10  2006/02/11 18:53:29  jsedwards
-- Filled in "read_body_from_stream" routine and commented out the class
-- invariant because it fails when the object is created with make_unresolved.
--
-- Revision 1.9  2006/02/09 05:41:05  jsedwards
-- Added reference parameter to initialize_header call and removed
-- next_identifier feature that is now in nwos_header.
--
-- Revision 1.8  2006/02/08 14:14:40  jsedwards
-- Add dummy read_body_from_stream routine.
--
-- Revision 1.7  2006/02/07 04:14:24  jsedwards
-- Removed "class ref" feature that isn't used anymore.
--
-- Revision 1.6  2006/02/05 16:54:49  jsedwards
-- Enabled "spelling index" feature and added "index" feature.
--
-- Revision 1.5  2006/02/05 14:01:02  jsedwards
-- Changed to use "next english ref" as the base for identifiers.
--
-- Revision 1.4  2006/02/05 05:05:39  jsedwards
-- Changed to have actual objects instead of just references.  This required
-- commenting out the sounds and stuff for the time being.
--
-- Revision 1.3  2006/02/02 02:05:44  jsedwards
-- Removed passing class reference to "initialize header".
--
-- Revision 1.2  2006/01/30 05:00:35  jsedwards
-- Moved sounds out of "vowel" and "consonant" classes and into "letter" to
-- avoid grief from multiple repeated inheritence.
--
-- Revision 1.1  2006/01/29 19:57:47  jsedwards
-- Initial version, untested!
--


deferred class NWOS_LETTER

inherit NWOS_LETTER_OR_SPELLING_INDEX  -- so the previous index in spelling indexes can point back to first letter
        NWOS_SYMBOL
           rename
              character as lower_case,
              character_obj as lower_case_obj,
              set_character as set_lower_case,
              to_codes as to_lower_case_codes
           redefine
              lower_case,
              lower_case_obj,
              set_lower_case,
              to_lower_case_codes,
              write_body_to_stream,
              read_body_from_stream
           end

feature

   alphabet: NWOS_ALPHABET is
      do
         load_if_not_already
         Result := alphabet_obj
      ensure
         Result /= Void
      end

--   speak: NWOS_REFERENCE   -- audio

   upper_case: NWOS_UPPER_CASE_CHARACTER is
      do
         load_if_not_already
         Result := upper_case_obj
      ensure
         Result /= Void
      end

   lower_case: NWOS_LOWER_CASE_CHARACTER is
      do
         load_if_not_already
         Result := lower_case_obj
      ensure
         Result /= Void
      end

--   sound_1: NWOS_REFERENCE
--   sound_2: NWOS_REFERENCE

   spelling_index: NWOS_SPELLING_INDEX is
      do
         load_if_not_already
         Result := spelling_index_obj
      ensure
         Result /= Void
      end


feature

   index: INTEGER is
      -- return the index of this letter within the alphabet
      do
         Result := alphabet.index_of(Current)
      end

   to_upper_case_codes(char_set_ref: NWOS_REFERENCE): ARRAY[CHARACTER] is
      do
         Result := upper_case.to_binary_codes(char_set_ref)
      end

   to_lower_case_codes(char_set_ref: NWOS_REFERENCE): ARRAY[CHARACTER] is
      do
         Result := lower_case.to_binary_codes(char_set_ref)
      end


feature

   set_upper_case(upper: like upper_case) is
      do
         check
            upper_case_obj = Void
         end

         upper_case_obj := upper
      end

   set_lower_case(lower: like lower_case) is
      do
         check
            lower_case_obj = Void
         end

         lower_case_obj := lower
      end


feature {NONE}

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      do
         alphabet_obj.class_definition.identifier.write_to_stream(stream)
         alphabet_obj.identifier.write_to_stream(stream)

         upper_case_obj.class_definition.identifier.write_to_stream(stream)
         upper_case_obj.identifier.write_to_stream(stream)

         lower_case_obj.class_definition.identifier.write_to_stream(stream)
         lower_case_obj.identifier.write_to_stream(stream)

         spelling_index_obj.class_definition.identifier.write_to_stream(stream)
         spelling_index_obj.identifier.write_to_stream(stream)

--         speak.write_to_stream(stream)
--         sound_1.write_to_stream(stream)
--         sound_2.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         alphabet_obj ?= object_ref.get_object(class_ref)

         if alphabet_obj = Void then
            std_error.put_string("NWOS_ALPHABET.read_body_from_stream: alphabet failed to load%N")
            die_with_code(exit_failure_code)
         end

         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         upper_case_obj ?= object_ref.get_object(class_ref)

         if upper_case_obj = Void then
            std_error.put_string("NWOS_ALPHABET.read_body_from_stream: upper_case failed to load%N")
            die_with_code(exit_failure_code)
         end

         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         lower_case_obj ?= object_ref.get_object(class_ref)

         if lower_case_obj = Void then
            std_error.put_string("NWOS_ALPHABET.read_body_from_stream: lower_case failed to load%N")
            die_with_code(exit_failure_code)
         end

         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         spelling_index_obj ?= object_ref.get_object(class_ref)

         if spelling_index_obj = Void then
            std_error.put_string("NWOS_ALPHABET.read_body_from_stream: spelling_index failed to load%N")
            die_with_code(exit_failure_code)
         end
      end


feature {NONE}

   make_with_alphabet(alpha: NWOS_ALPHABET) is
      do
         initialize_header(next_english_identifier)

         alphabet_obj := alpha
--         speak := Void_reference
--         sound_1 := Void_reference
--         sound_2 := Void_reference

         !!spelling_index_obj.make(alpha, Current)
      end

feature {NONE}

   alphabet_obj: like alphabet

   upper_case_obj: like upper_case

   lower_case_obj: like lower_case

   spelling_index_obj: like spelling_index


--invariant

--   alphabet /= Void

end

