--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_predefined_references.e,v $
-- Revision 1.25  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.24  2006/02/25 04:47:54  jsedwards
-- Moved all of the class definition references to nwos_classes.e.
--
-- Revision 1.23  2006/02/20 14:36:29  jsedwards
-- Changed so classes all have 'C' in the upper nibble.
--
-- Revision 1.22  2006/02/20 05:36:34  jsedwards
-- Added "proper noun" class.
--
-- Revision 1.21  2006/02/15 14:23:29  jsedwards
-- Added class references for "procurement" and "source file" classes.
--
-- Revision 1.20  2006/02/13 14:16:45  jsedwards
-- Added kludgy references for the apostrophe and hyphen objects.
--
-- Revision 1.19  2006/02/13 04:44:02  jsedwards
-- Added class references for character and punctuation mark classes and made
-- room for 2 more symbols (hyphen and apostrophe).
--
-- Revision 1.18  2006/02/11 12:47:38  jsedwards
-- Fix a comment, NO code changes.
--
-- Revision 1.17  2006/02/09 05:44:18  jsedwards
-- Added Big_Bang reference and changed the name of next_nwos_identifier
-- to next_nwos_ref.
--
-- Revision 1.16  2006/02/08 14:27:41  jsedwards
-- Added class defintion references back in again.
--
-- Revision 1.15  2006/02/06 13:42:12  jsedwards
-- Added "next latin ref".
--
-- Revision 1.14  2006/02/06 13:15:23  jsedwards
-- Added "class string ref" for expanded strings inside objects.
--
-- Revision 1.13  2006/02/05 14:03:31  jsedwards
-- Removed English_alphabet_ref and English_letters_ref and replaced them
-- with next_english_ref.
--
-- Revision 1.12  2006/02/05 05:06:21  jsedwards
-- Get rid of some more references that aren't used anymore.
--
-- Revision 1.11  2006/02/04 15:42:28  jsedwards
-- Moved some of the references back here from inside the classes themselves.
--
-- Revision 1.10  2006/02/04 15:07:30  jsedwards
-- Removed all of the predefined class definitions, they are all generated
-- automatically.
--
-- Revision 1.9  2006/02/04 03:47:14  jsedwards
-- Added upper and lower case character class references.
--
-- Revision 1.8  2006/02/03 14:26:44  jsedwards
-- Added ascii character class and bumped big_bang app version to 03.
--
-- Revision 1.7  2006/02/03 03:12:30  jsedwards
-- Used to create 256 binary codes (Big_Bang_02).
--
-- Revision 1.6  2006/01/31 19:32:21  jsedwards
-- Removed the class definition references as they are now in the class
-- definitions themselves.
--
-- Revision 1.5  2006/01/30 05:01:37  jsedwards
-- Added "spelling index" class reference.
--
-- Revision 1.4  2006/01/29 19:54:46  jsedwards
-- Changed the "letter" class reference to "vowel", "consonant", and "vowel
-- or consonant" class references.
--
-- Revision 1.3  2006/01/29 18:10:14  jsedwards
-- Added the upper and lower case character references which are based upon
-- the character references.  Also added the english language reference.
--
-- Revision 1.2  2006/01/27 14:19:59  jsedwards
-- Added inherit from domains class.
--
-- Revision 1.1  2006/01/27 04:27:07  jsedwards
-- Initial version, incomplete.
--


class NWOS_PREDEFINED_REFERENCES

inherit NWOS_DOMAINS
        NWOS_CLASSES  -- references for all the predefined classes (moved out of this file)

   -- These are the base classes that have to be created from scratch before any other objects can be created.

   -- these all should be mostly the same as they were in the c_structs.h file.

feature

   Void_reference: NWOS_REFERENCE is
      once
         !!Result.make(0x00000000, 0x00000000, 0x00000000, 0x00000000)   -- all zeros is void reference
      end

   Root_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x00000001)   -- one is the root (entry) object
      end

   J_scott_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x00000003)   -- two is me
      end

   Suezq_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x00000004)   -- three is suezq
      end

   J_jason_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x00000005)   -- four is jason
      end

   Big_bang_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x00000007)
      end

   next_nwos_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x00000020)
      end

   Characters_ref: NWOS_REFERENCE is
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x0000004A)  -- leave room below ascii for 54 characters
      end

   Ascii_chars_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x00000080)   -- the 128 ascii characters
      end

   Binary_codes_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Computer_domain, Nwos_domain, 0x00000000, 0x00000100)   -- the 256 binary codes
      end

   English_language_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Language_domain, Latin_domain, English_domain, 0x00000005)   -- English language
      end

   next_latin_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Language_domain, Latin_domain, Latin_domain, 0x00000010)
      end

   next_english_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Language_domain, Latin_domain, English_domain, 0x00000005)
      end

-- WARNING! any changes could make these incorrect:

   Apostrophe_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Language_domain, Latin_domain, English_domain, 0x00000021)
      end

   Hyphen_ref: NWOS_REFERENCE is  
      once
         !!Result.make(Language_domain, Latin_domain, English_domain, 0x00000022)
      end

end


