/*
--                This file is part of the New World OS project
--                       Copyright (C) 2006 QRW Software
--              J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                         http://www.qrwsoftware.com
--                         http://nwos.sourceforge.com
--
--  This program is free software; you can redistribute it and/or modify it 
--  under the terms of the GNU General Public License as published by the 
--  Free Software Foundation; either version 2 of the License, or (at your 
--  option) any later version.
--
--  This program is distributed in the hope that it will be useful, but
--  WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
--  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License 
--  for more details.
--
--  You should have received a copy of the GNU General Public License
--  along with this program; if not, write to:
--
--      Free Software Foundation, Inc.
--      51 Franklin Street, Fifth Floor
--      Boston, MA   02110-1301
--      USA
--
--  On the internet: http://www.fsf.org/licenses/gpl.html
--
-- $Log: predefined_references.c,v $
-- Revision 1.14  2006/05/01 12:42:06  jsedwards
-- Removed binary_bits and number_of_bits attribute definitions.  This
-- information is encoded into the reference itself, it is generally a
-- bad idea to duplicate information in two places.
--
-- Revision 1.13  2006/04/16 13:54:45  jsedwards
-- Changed "list" attributes to plain attributes for now, not going to
-- implement lists right now.
--
-- Revision 1.12  2006/04/13 13:06:39  jsedwards
-- Moved two bytes of the references, which have name embedded, from the left
-- to the right end so that the name is an even 20 digits (100 bits), and the
-- three least significant nibbles are the version number 0 to 4095.
--
-- Revision 1.11  2006/04/12 12:48:27  jsedwards
-- Added definitions for attributes for list of character codes, definitions,
-- and heirs.  Also moved text descriptions of things and binary_codes to
-- big_bang.c file.
--
-- Revision 1.10  2006/04/12 11:54:05  jsedwards
-- Added references for description objects for definitions.
--
-- Revision 1.9  2006/04/11 13:04:58  jsedwards
-- Added "inherit" and "implementation" attributes, "base" definition, and
-- "deferred" and "effective" values.
--
-- Revision 1.8  2006/04/09 14:49:05  jsedwards
-- Added "attribute" and "description" attributes and moved layout of
-- "definition definition" to the attribute.c file.
--
-- Revision 1.7  2006/04/09 14:11:39  jsedwards
-- Changed specific values (mutable, immutable, etc.) to "values" instead of
-- "definitions".
--
-- Revision 1.6  2006/04/09 03:27:38  jsedwards
-- Changed attributes and definitions so bytes 4 through 15 are converted
-- into a name, five bits at a time.
--
-- Revision 1.5  2006/04/08 14:03:53  jsedwards
-- Added references and routines enough to make a binary code object.
--
-- Revision 1.4  2006/03/25 15:56:38  jsedwards
-- Added routine to write every object header and changed binary code.
--
-- Revision 1.3  2006/03/25 14:10:16  jsedwards
-- Moved the defintions from predefined_references.h to .c file.
--
-- Revision 1.2  2006/03/11 15:03:15  jsedwards
-- Changed ordinal numbers to new "ordinal numbers" domain and added "thing"
-- and "attribute".
--
-- Revision 1.1  2006/03/10 14:27:33  jsedwards
-- Initial version.
--
*/

#include <string.h>   /* define "memcpy" */

#include "predefined_references.h"
#include "time_stamp.h"


const reference Ref_void                  = { DOMAIN_NWOS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0 };
const reference Ref_binary_bits           = { DOMAIN_NWOS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,1 };

const reference Ref_attr_attribute        = { DOMAIN_ATTRIBUTES,0, 0x0D,0x29,0x24,0x8A,0xB4,0x28 };
const reference Ref_attr_char_code_ref    = { DOMAIN_ATTRIBUTES,0, 0x1A,0x03,0x20,0x0D,0xE4,0x28,0x24,0x53 };
const reference Ref_attr_creation         = { DOMAIN_ATTRIBUTES,0, 0x1C,0x8A,0x1A,0x25,0xEE };
const reference Ref_attr_definition       = { DOMAIN_ATTRIBUTES,0, 0x21,0x4C,0x97,0x26,0x89,0x7B,0x80 };
const reference Ref_attr_definition_ref   = { DOMAIN_ATTRIBUTES,0, 0x21,0x4C,0x97,0x26,0x89,0x7B,0x81,0x22,0x98 };
const reference Ref_attr_description      = { DOMAIN_ATTRIBUTES,0, 0x21,0x66,0x39,0x26,0x14,0x4B,0xDC };
const reference Ref_attr_heir_ref         = { DOMAIN_ATTRIBUTES,0, 0x41,0x53,0x20,0x48, 0xA6 };
const reference Ref_attr_implementation   = { DOMAIN_ATTRIBUTES,0, 0x4B,0x60,0xC2,0xB4,0xAE,0xA0,0x68,0x97,0xB8 };
const reference Ref_attr_inherit          = { DOMAIN_ATTRIBUTES,0, 0x4B,0x90,0x59,0x26,0x80 };
const reference Ref_attr_multiplicity     = { DOMAIN_ATTRIBUTES,0, 0x6D,0x59,0x44,0xC1,0x89,0x1A,0x69,0x90 };
const reference Ref_attr_mutability       = { DOMAIN_ATTRIBUTES,0, 0x6D,0x68,0x11,0x25,0x89,0xA6,0x40 };
const reference Ref_attr_presence         = { DOMAIN_ATTRIBUTES,0, 0x84,0x8B,0x32,0xB8,0x65 };
const reference Ref_attr_type             = { DOMAIN_ATTRIBUTES,0, 0xA6,0x60,0x50 };

const reference Ref_the_big_bang          = { DOMAIN_LOGS,0,0,0, 0x80,0,0,0, 0,0,0,0, 0,0,0,0 };

const reference Ref_cardinal_8            = { DOMAIN_CARDINAL_NUMBERS,0,0,0, 0x00,0,0,0, 0,0,0,0, 0,0,0,8 };

const reference Ref_def_attribute         = { DOMAIN_DEFINITIONS,0, 0x0D,0x29,0x24,0x8A,0xB4,0x28 };
const reference Ref_def_base              = { DOMAIN_DEFINITIONS,0, 0x10,0x66,0x50 };
const reference Ref_def_binary_code       = { DOMAIN_DEFINITIONS,0, 0x12,0x5C,0x19,0x64,0x03,0x79,0x0A };
const reference Ref_def_cardinal_number   = { DOMAIN_DEFINITIONS,0, 0x18,0x64,0x44,0xB8,0x2C,0x03,0xAA,0xD1,0x16,0x40 };
const reference Ref_def_creation_info     = { DOMAIN_DEFINITIONS,0, 0x1C,0x8A,0x1A,0x25,0xEE,0x02,0x5C,0x67,0x80 };
const reference Ref_def_definition        = { DOMAIN_DEFINITIONS,0, 0x21,0x4C,0x97,0x26,0x89,0x7B,0x80 };

const reference Ref_desc_attribute        = { DOMAIN_DESCRIPTIONS,0, 0x0D,0x29,0x24,0x8A,0xB4,0x28 };
const reference Ref_desc_base             = { DOMAIN_DESCRIPTIONS,0, 0x10,0x66,0x50 };
const reference Ref_desc_binary_code      = { DOMAIN_DESCRIPTIONS,0, 0x12,0x5C,0x19,0x64,0x03,0x79,0x0A };
const reference Ref_desc_cardinal_number  = { DOMAIN_DESCRIPTIONS,0, 0x18,0x64,0x44,0xB8,0x2C,0x03,0xAA,0xD1,0x16,0x40 };
const reference Ref_desc_creation_info    = { DOMAIN_DESCRIPTIONS,0, 0x1C,0x8A,0x1A,0x25,0xEE,0x02,0x5C,0x67,0x80 };
const reference Ref_desc_definition       = { DOMAIN_DESCRIPTIONS,0, 0x21,0x4C,0x97,0x26,0x89,0x7B,0x80 };

const reference Ref_val_deferred          = { DOMAIN_VALUES,0, 0x21,0x4C,0x59,0x48,0xA4 };
const reference Ref_val_effective         = { DOMAIN_VALUES,0, 0x29,0x8C,0x51,0xD1,0x36,0x28 };
const reference Ref_val_immutable         = { DOMAIN_VALUES,0, 0x4B,0x5B,0x5A,0x04,0x4C,0x28 };
const reference Ref_val_multiple          = { DOMAIN_VALUES,0, 0x6D,0x59,0x44,0xC1,0x85 };
const reference Ref_val_mutable           = { DOMAIN_VALUES,0, 0x6D,0x68,0x11,0x30,0xA0 };
const reference Ref_val_optional          = { DOMAIN_VALUES,0, 0x7C,0x28,0x97,0xB8,0x2C };
const reference Ref_val_required          = { DOMAIN_VALUES,0, 0x91,0x63,0x54,0xC8,0xA4 };
const reference Ref_val_single            = { DOMAIN_VALUES,0, 0x9A,0x5C,0x76,0x14 };

#if 0
const reference Ref_thing           = { DOMAIN_THINGS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,1 };
const reference Ref_attribute       = { DOMAIN_THINGS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,2 };

const reference Ref_definition_attr = { DOMAIN_THINGS,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,0 };
const reference Ref_creation_attr   = { DOMAIN_THINGS,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,1 };
const reference Ref_name_attr       = { DOMAIN_THINGS,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,2 };
const reference Ref_presence_attr   = { DOMAIN_THINGS,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,3 };
const reference Ref_plurality_attr  = { DOMAIN_THINGS,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,4 };
const reference Ref_mutability_attr = { DOMAIN_THINGS,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,5 };
const reference Ref_type_of_attr    = { DOMAIN_THINGS,1,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,6 };

const reference Ref_first    = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,1 };
const reference Ref_second   = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,2 };
const reference Ref_third    = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,3 };
const reference Ref_fourth   = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,4 };
const reference Ref_fifth    = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,5 };
const reference Ref_sixth    = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,6 };
const reference Ref_seventh  = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,7 };
const reference Ref_eighth   = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,8 };
const reference Ref_ninth    = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,9 };
const reference Ref_tenth    = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,10 };
const reference Ref_eleventh = { DOMAIN_ORDINAL_NUMBERS,0,0,0, 0,0,0,0, 0,0,0,0, 0,0,0,11 };
#endif


void write_pair(const reference a, const reference b, FILE* fp)
{
    fwrite(a, 1, sizeof(reference), fp);
    fwrite(b, 1, sizeof(reference), fp);
}    

void write_file_header(const reference id, FILE* fp)
{
    reference header;  /* NWOS, version, timestamp */
    TimeStamp time_stamp;

    nwos_get_time_stamp(time_stamp);

    memcpy(&header[0], "NWOS", 4);
    memcpy(&header[4], "0011", 4);
    memcpy(&header[8], time_stamp, 8);

    write_pair(header, id, fp);
}


