/*             This file is part of the New World OS project
--                Copyright (C) 2005, 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- This program is a run once, never again.  It creates the 128 ascii codes
-- objects (0x100-0x17F) and the 128 reference lists (0x180-0x1FF) for them.
-- No one should ever have to run this program again, since those objects
-- now exist in the global/public database.
--
-- $Log: create_ascii_char_set.c,v $
-- Revision 1.3  2006/11/11 12:01:02  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.2  2006/01/22 18:16:32  jsedwards
-- Added code to set character set name.
--
-- Revision 1.1  2006/01/22 17:14:03  jsedwards
-- Run once app to create the ascii character set object to translate ascii
-- characters to binary codes.
--
*/

#include <assert.h>
#include <stdio.h>
#include <string.h>   /* define memset */
#include <stdlib.h>

#include "objectify.h"
#include "c_structs.h"
#include "objectify_private.h"



int main()
{
    C_struct_Ascii_Char_Set ascii_char_set_object;
    ObjRef binary_code_ref;
    ObjRef ascii_chars_ref;
    uint8 base_char_ref;
    int i;

    printf("Creating ASCII character set object...\n");

    memset(&ascii_char_set_object, 0, sizeof(ascii_char_set_object));

    nwos_fill_in_any(&ascii_char_set_object.any, Char_Set_Class_Ref, User_Ref, Create_Ascii_Char_Set_Ref);

    nwos_copy_reference(ascii_char_set_object.name, Ascii_Name_Ref);

    nwos_copy_reference(binary_code_ref, Binary_Codes_Ref);
    nwos_copy_reference(ascii_chars_ref, Ascii_Chars_Ref);

    base_char_ref = ascii_chars_ref[sizeof(ObjRef)-1];   /* save this value */

    for (i = 0; i < 128; i++)
    {
	ascii_chars_ref[sizeof(ObjRef)-1] = base_char_ref | i;
	binary_code_ref[sizeof(ObjRef)-1] = i;

	nwos_copy_reference(ascii_char_set_object.pair[i].character, ascii_chars_ref);
	nwos_copy_reference(ascii_char_set_object.pair[i].binary_code, binary_code_ref);
    }

    nwos_write_public_object_to_disk(Ascii_Char_Set_Ref, &ascii_char_set_object, sizeof(ascii_char_set_object));

    printf("Done!\n");

    return 0;
}

