/*             This file is part of the New World OS project
--                   Copyright (C) 2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: verify_file.c,v $
-- Revision 1.4  2007/03/18 19:55:53  jsedwards
-- Enabled verification for removal based on file having a backup copy on a disc.
--
-- Revision 1.3  2007/02/28 14:02:49  jsedwards
-- Added test to make sure file is stored in system before trying to compare it.
--
-- Revision 1.2  2007/02/11 16:58:26  jsedwards
-- Changed so DEFAULT_TYPE has to specify RO (Read-Only) or RW (Read-Write).
--
-- Revision 1.1  2007/01/27 17:37:00  jsedwards
-- Program to verify file if a file is stored in the system and if desired
-- delete it.
--
*/

#include <assert.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>

#include "objectify.h"


int main(int argc, char* argv[])
{
    ObjRef root_object_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;
    ObjRef ref;
    int i;
    bool do_remove = false;

    printf("\n");

    for (i = 1; i < argc; i++)
    {
	if (argv[i][0] == '-')
	{
	    if (strcmp(argv[i], "--remove") != 0)
	    {
		fprintf(stderr, "Unknown option: %s\n", argv[i]);
		exit(1);
	    }
	}
    }

    nwos_log_arguments(argc, argv);

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(root_object_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, DEFAULT_TYPE_RO, DEFAULT_FILE);

    nwos_set_root_object(&root_object_ref);

    nwos_set_encryption_level(Encryption_Low);


    for (i = 1; i < argc; i++)
    {
	if (strcmp(argv[i], "--remove") == 0)
	{
	    do_remove = true;
	}
	else
	{
	    printf("%s: ", argv[i]);
	    fflush(stdout);

	    if (nwos_find_matching_path_and_file_association(argv[i], &ref))
	    {
		if (do_remove)
		{
		    if (nwos_file_is_stored(&ref))
		    {
			assert(nwos_file_is_identical(&ref, argv[i]));

			if (unlink(argv[i]) != 0)
			{
			    perror(argv[i]);
			    exit(1);
			}

			printf("removed\n");
		    }
		    else if (nwos_file_has_backup(&ref))
		    {
			if (unlink(argv[i]) != 0)
			{
			    perror(argv[i]);
			    exit(1);
			}

			printf("removed\n");
		    }
		    else
		    {
			printf("no known backup, not removed\n");
		    }
		}
		else
		{
		    printf("found: %02x%02x%02x%02x\n", ref.id[0], ref.id[1], ref.id[2], ref.id[3]);
		}
	    }
	    else
	    {
		printf("NOT found\n");
	    }
	}
    }

    nwos_terminate_objectify();

    return 0;
}


