/*             This file is part of the New World OS project
--                   Copyright (C) 2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- This is a one time use program to add a bunch of features to the PERSON class
--
-- $Log: add_to_person.c,v $
-- Revision 1.9  2007/03/31 11:33:14  jsedwards
-- Added more info.
--
-- Revision 1.8  2007/03/30 14:21:38  jsedwards
-- Removed private information that should be in a separate list.
--
-- Revision 1.7  2007/03/24 12:11:31  jsedwards
-- Add print statement to show what drive is being modified.
--
-- Revision 1.6  2007/03/24 02:21:45  jsedwards
-- Added print statement.
--
-- Revision 1.5  2007/03/24 02:16:34  jsedwards
-- Added code to recalculate the checksums and rewrite the class object.
--
-- Revision 1.4  2007/03/23 14:30:51  jsedwards
-- Fixed add_feature function, untested.
--
-- Revision 1.3  2007/03/23 11:42:06  jsedwards
-- Added a couple more features.
--
-- Revision 1.2  2007/03/22 14:28:11  jsedwards
-- Made changes and added to list of features to be added.
--
-- Revision 1.1  2007/03/22 13:18:26  jsedwards
-- Initial version... doesn't do anything yet.
--
*/


#include <assert.h>
#include <ctype.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

#include "../crc32.h"
#include "../objectify_private.h"


#if 0
static size_t get_spelling_object_size(void* spelling_obj)
{
    assert(((C_struct_Spelling*)spelling_obj)->count > 0);
    return sizeof(C_struct_Spelling) + ((C_struct_Spelling*)spelling_obj)->count;
}

static size_t get_name_object_size(void* name_obj)
{
    assert(((C_struct_Name*)name_obj)->count > 0);
    return sizeof(C_struct_Name) + (((C_struct_Name*)name_obj)->count * sizeof(ObjRef));
}
#endif

static size_t get_class_object_size(void* class_obj)
{
    return sizeof(C_struct_Class_Definition) + (((C_struct_Class_Definition*)class_obj)->count * sizeof(ObjRef));
}

void add_feature(C_struct_Class_Definition* person_class_obj_ptr, ObjRef* type, char* name)
{
    int count;
    ObjRef feature_ref;

    assert(get_class_object_size(person_class_obj_ptr) < FILE_BLOCK_SIZE);

    count = person_class_obj_ptr->count;

    nwos_find_or_create_public_feature_definition(type, name, 1, &feature_ref);

    copy_reference(&person_class_obj_ptr->feature[count], &feature_ref);

    nwos_add_to_references(&person_class_obj_ptr->header.common.id, &feature_ref);

    person_class_obj_ptr->count = count + 1;

    printf("feature: %d - %s  new size: %d\n", count, name, (int)get_class_object_size(person_class_obj_ptr));
}



int main(int argc, char* argv[])
{
    ObjRef root_ref;
    ObjRef person_class_ref;
    ObjRef objref_class_ref;
    uint8 kludge[FILE_BLOCK_SIZE];
    C_struct_Class_Definition* person_class_obj_ptr = (C_struct_Class_Definition*)kludge;

    nwos_log_arguments(argc, argv);

    nwos_initialize_objectify(NULL, 0, 0, DEFAULT_TYPE_RW, DEFAULT_FILE);

    nwos_set_encryption_level(Encryption_None);

    printf("Updating person class on: %s\n", DEFAULT_FILE);

    printf("next_reference: %02x%02x%02x%02x\n", 
	   nwos_next_public_ref.id[0],
	   nwos_next_public_ref.id[1],
	   nwos_next_public_ref.id[2],
	   nwos_next_public_ref.id[3]);

    root_ref.id[0] = 0;
    root_ref.id[1] = 0;
    root_ref.id[2] = 0;
    root_ref.id[3] = 1;

    nwos_set_root_object(&root_ref);

    if (!nwos_find_public_class_definition("PERSON", &person_class_ref))
    {
	fprintf(stderr, "Could not locate PERSON class definition\n");
	nwos_terminate_objectify();
	exit(1);
    }

    printf("person_class_ref: %02x%02x%02x%02x\n",
	   person_class_ref.id[0],
	   person_class_ref.id[1],
	   person_class_ref.id[2],
	   person_class_ref.id[3]);

    if (!nwos_find_public_class_definition("OBJECT REFERENCE", &objref_class_ref))
    {
	fprintf(stderr, "Could not locate OBJECT REFERENCE class definition\n");
	nwos_terminate_objectify();
	exit(1);
    }

    printf("objref_class_ref: %02x%02x%02x%02x\n",
	   objref_class_ref.id[0],
	   objref_class_ref.id[1],
	   objref_class_ref.id[2],
	   objref_class_ref.id[3]);

    nwos_read_variable_sized_object_from_disk(&person_class_ref, kludge, sizeof(kludge), &get_class_object_size);

    printf("  number of features: %d\n", person_class_obj_ptr->count);

    if (person_class_obj_ptr->count != 15)
    {
	fprintf(stderr, "PERSON class has already been changed, has more than 15 features!\n");
	nwos_terminate_objectify();
	exit(1);
    }

    add_feature(person_class_obj_ptr, &objref_class_ref, "birth certificate");
    add_feature(person_class_obj_ptr, &objref_class_ref, "death certificate");
    add_feature(person_class_obj_ptr, &objref_class_ref, "cause of death");
    add_feature(person_class_obj_ptr, &objref_class_ref, "interred");
    add_feature(person_class_obj_ptr, &objref_class_ref, "father");

    add_feature(person_class_obj_ptr, &objref_class_ref, "mother");
    add_feature(person_class_obj_ptr, &objref_class_ref, "private info");
    add_feature(person_class_obj_ptr, &objref_class_ref, "weight list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "hair color");
    add_feature(person_class_obj_ptr, &objref_class_ref, "eye color");

    add_feature(person_class_obj_ptr, &objref_class_ref, "language list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "school list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "military service list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "volunteer list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "membership list");

    add_feature(person_class_obj_ptr, &objref_class_ref, "employment list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "business list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "board list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "award list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "media list");

    add_feature(person_class_obj_ptr, &objref_class_ref, "residence list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "email list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "mobile phone list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "instant message list");
    add_feature(person_class_obj_ptr, &objref_class_ref, "vehicle list");

    add_feature(person_class_obj_ptr, &objref_class_ref, "possesions");
    add_feature(person_class_obj_ptr, &objref_class_ref, "accomplishments");

    nwos_crc32_calculate((uint8*) &person_class_obj_ptr->header.object,
			 sizeof(ObjectHeader),
			 person_class_obj_ptr->header.common.header_chksum);

    nwos_crc32_calculate((uint8*) &person_class_obj_ptr->name,
			 get_class_object_size(person_class_obj_ptr) - sizeof(EveryObject),
			 person_class_obj_ptr->header.common.data_chksum);

    nwos_overwrite_object_to_disk(&person_class_ref, person_class_obj_ptr, get_class_object_size(person_class_obj_ptr));


    nwos_terminate_objectify();

    return 0;
}

