--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: feature_definition.e,v $
-- Revision 1.15  2006/11/04 14:14:02  jsedwards
-- Fixed bug where second digit of number of elements was the same as the
-- first digit.
--
-- Revision 1.14  2006/11/02 13:50:57  jsedwards
-- Added "make_from_csv" feature to create object from cvs line.
--
-- Revision 1.13  2006/10/31 23:24:38  jsedwards
-- Add code to add reference to objects that these objects reference.
--
-- Revision 1.12  2006/10/31 23:12:51  jsedwards
-- Add code to add each object to the class definition reference list.
--
-- Revision 1.11  2006/10/31 14:07:00  jsedwards
-- Added reference_lists.
--
-- Revision 1.10  2006/10/31 13:31:14  jsedwards
-- Added "find_feature" feature and changed feature creation calls to have
-- the separate element count instead of [N] in the name.
--
-- Revision 1.9  2006/10/30 13:36:37  jsedwards
-- Change to only create a new name if there isn't one already in all_names.
--
-- Revision 1.8  2006/10/30 13:28:29  jsedwards
-- Change "name" feature to be a name class instead of a string.
--
-- Revision 1.7  2006/10/30 13:12:15  jsedwards
-- Change to add feature itself to the all_features array.
--
-- Revision 1.6  2006/10/29 16:54:30  jsedwards
-- Add reference.
--
-- Revision 1.5  2006/10/29 14:37:20  jsedwards
-- Changed so type is the class reference (unsigned).
--
-- Revision 1.4  2006/10/28 14:57:29  jsedwards
-- Added GPL header (oops!).
--


class FEATURE_DEFINITION

inherit GLOBALS
        REFERENCE_COUNTER

creation make, make_from_csv


feature

   reference: UNSIGNED

   reference_list: REFERENCE_LIST

   type: UNSIGNED

   name: NAME

   number: INTEGER   -- number of elements, 0 = variable, > 1 array of number


   make(type_ref: UNSIGNED; fname: STRING; num_elem: INTEGER) is
      require
         not fname.has('[')
         find_feature(type_ref, fname, num_elem) = Void
      do
         reference := next_reference

         !!reference_list.make

         type := type_ref
         number := num_elem

         name := find_name(fname)

         if name = Void then
            !!name.make(fname)
         end

         name.reference_list.add_reference(reference)

         all_features.add_last(Current)

         feat_def_class_def.reference_list.add_reference(reference)
      end


   make_from_csv(line: STRING) is
      local
         dummy: UNSIGNED
      do
         reference := scan_reference(line)

         check_comma(line)

         skip_time(line)

         check_comma(line)

         dummy := scan_reference(line)   -- ignore class for now

         check_comma(line)

         dummy := scan_reference(line)   -- ignore refernce list for now

         check_comma(line)

         type := scan_reference(line)    -- read type reference

         check_comma(line)

         dummy := scan_reference(line)   -- read name reference

         name := find_name_from_reference(dummy)

         check_comma(line)

         if line.count > 2 then
            std_error.put_string("read feature definition line too long: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end            

         if not line.item(1).is_digit then
            std_error.put_string("read feature definition - invalid digit: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         if line.count = 2 and then not line.item(2).is_digit then
            std_error.put_string("read feature definition - invalid digit: ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         number := line.item(1).decimal_value

         if line.count = 2 then
           number := number * 10 + line.item(2).decimal_value
         end
      end


end

