--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_spelling.e,v $
-- Revision 1.1  2007/04/14 02:24:20  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.16  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.15  2006/02/20 14:24:52  jsedwards
-- Changed make to look up the binary code to get the letter (symbol) instead
-- of assuming ascii and using the programming language to find it.
--
-- Revision 1.14  2006/02/20 05:03:53  jsedwards
-- Added "count", "lower", "upper" and "item" features.
--
-- Revision 1.13  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.12  2006/02/19 02:50:29  jsedwards
-- Changed attributes to routines that make sure the object is loaded before
-- returning values.
--
-- Revision 1.11  2006/02/16 03:02:20  jsedwards
-- Added source file attribute to keep information about where the spelling
-- came from (aspell).  Also added "add_reference" feature.
--
-- Revision 1.10  2006/02/13 14:14:39  jsedwards
-- Changed to deal with hyphens and apostophes in words.
--
-- Revision 1.9  2006/02/11 21:09:06  jsedwards
-- Changed fixed arrays to just arrays, to be consistent with other objects.
-- Added void references after letters and references when written to stream
-- so we can tell when we are at the end.  Filled in read_body_from_stream
-- routine.
--
-- Revision 1.8  2006/02/11 18:45:05  jsedwards
-- Changed index in debug print statements to index from 1 instead of 0
-- (the arrays were changed from fixed arrays to just arrays).  Commented
-- out the class invariant because it fails when the object is created
-- with make_unresolved.
--
-- Revision 1.7  2006/02/10 13:55:34  jsedwards
-- Changed "load" in creation clause to "make_unresolved".
--
-- Revision 1.6  2006/02/09 13:06:49  jsedwards
-- Added reference parameter to "initialize header" call and removed "next
-- identifier" feature that is now in nwos_header.  Changed to the new
-- method of doing the class defintion stuff, with the "class reference"
-- and "class revision".
--
-- Revision 1.5  2006/02/08 14:24:04  jsedwards
-- Added "load" to creation clause, a dummy read_body_from_stream routine,
-- and class reference to class definition "make" call.
--
-- Revision 1.4  2006/02/06 13:43:43  jsedwards
-- Changed domain from English to Latin, because spellings in all latin based
-- languages should be allocated from a common place.
--
-- Revision 1.3  2006/02/05 16:57:33  jsedwards
-- Changed make to actually make a spelling from a word, including all of
-- the spelling indexes.
--
-- Revision 1.2  2006/02/05 14:41:38  jsedwards
-- Fix Id so it gets filled in correctly.
--
-- Revision 1.1  2006/02/05 14:19:45  jsedwards
-- Initial version, untested.
--


class NWOS_SPELLING

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   alphabet: NWOS_ALPHABET is
      do
         load_if_not_already
         Result := alphabet_obj
      ensure
         Result /= Void
      end

   source: NWOS_SOURCE_FILE is
      do
         load_if_not_already
         Result := source_obj
      ensure
         Result /= Void
      end

   letters: ARRAY[NWOS_SYMBOL] is
      do
         load_if_not_already
         Result := letters_obj
      ensure
         Result /= Void
      end

   references: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := references_obj
      ensure
         Result /= Void
      end


feature

   add_reference(obj: NWOS_OBJECT) is
      do
         references.add_last(obj)
      end


feature

   count: INTEGER is
        -- number of characters in this word
      do
         Result := letters.count
      end

   lower: INTEGER is 1

   upper: INTEGER is
      do
         Result := letters.upper
      end

   item(index: INTEGER): NWOS_SYMBOL is
      do
         Result := letters.item(index)
      end


feature {NONE}

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      require
         letters_obj.count > 0
      local
         i: INTEGER
      do
         alphabet_obj.class_definition.identifier.write_to_stream(stream)
         alphabet_obj.identifier.write_to_stream(stream)

         if source_obj /= Void then
            source_obj.class_definition.identifier.write_to_stream(stream)
            source_obj.identifier.write_to_stream(stream)
         end

         from
            i := letters_obj.lower
         variant
            letters_obj.upper - i
         until
            i > letters_obj.upper
         loop
            letters_obj.item(i).class_definition.identifier.write_to_stream(stream)
            letters_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         from
            i := references_obj.lower
         variant
            references_obj.upper - i
         until
            i > references_obj.upper
         loop
            references_obj.item(i).class_definition.identifier.write_to_stream(stream)
            references_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         ltr: NWOS_LETTER
         obj: NWOS_OBJECT
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         alphabet_obj ?= object_ref.get_object(class_ref)

         if alphabet_obj = Void then
            std_error.put_string("NWOS_SPELLING.read_body_from_stream: alphabet failed to load%N")
            die_with_code(exit_failure_code)
         end

         !!class_ref.make_from_stream(stream)
         if class_ref.is_equal(Class_source_file_ref) then
            !!object_ref.make_from_stream(stream)

            source_obj ?= object_ref.get_object(class_ref)

            if source_obj = Void then
               std_error.put_string("NWOS_SPELLING.read_body_from_stream: source failed to load%N")
               die_with_code(exit_failure_code)
            end

            !!class_ref.make_from_stream(stream)
         end

         !!letters_obj.with_capacity(9, lower)

         from
            -- uses class_ref read above
         until
            not class_ref.is_equal(Class_consonant_ref) -- need some sort of feature to tell if this class inherits from letter
               and then
            not class_ref.is_equal(Class_vowel_ref)
               and then
            not class_ref.is_equal(Class_sometimes_vowel_ref)
         loop
            !!object_ref.make_from_stream(stream)
debug
std_output.put_string("NWOS_SPELLING.read_body_from_stream")
std_output.put_string("%N  letter class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  letter object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line
end
            ltr ?= object_ref.get_object(class_ref)

            if ltr = Void then
               std_error.put_string("NWOS_SPELLING.read_body_from_stream: letter failed to load%N")
               die_with_code(exit_failure_code)
            end

            letters_obj.add_last(ltr)

            !!class_ref.make_from_stream(stream)
         end

         !!references_obj.with_capacity(4, 1)

         from
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)
debug
std_output.put_string("NWOS_SPELLING.read_body_from_stream")
std_output.put_string("%N  ref class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  ref object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line
end
            obj := object_ref.get_object(class_ref)

            references_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      ensure
         letters /= Void and then letters.count > 0
      end


feature {NONE}

   make(alpha: like alphabet; spell: STRING; source_file: NWOS_SOURCE_FILE) is
      local
         letter: NWOS_LETTER
         symbol: NWOS_SYMBOL
         index: NWOS_SPELLING_INDEX
         next_index: NWOS_SPELLING_INDEX
         binary_code_ref: NWOS_REFERENCE
         binary_code_obj: NWOS_BINARY_CODE
         ascii_char_obj: NWOS_ASCII_CHARACTER
         i: INTEGER
      do
         initialize_header(next_latin_identifier)

         alphabet_obj := alpha

         source_obj := source_file

         !!letters_obj.with_capacity(spell.count, lower)
         !!references_obj.with_capacity(4, 1)

         from
            i := spell.lower
         until
            i > spell.upper
         loop
            !!binary_code_ref.make_binary_code(spell.item(i))
            binary_code_obj ?= binary_code_ref.object
            check
               binary_code_obj /= Void
            end

            ascii_char_obj ?= binary_code_obj.find_reference(Class_ascii_character_ref)
            check
               ascii_char_obj /= Void and then ascii_char_obj.binary_code = binary_code_obj
            end

            symbol := ascii_char_obj.character.symbol

            letters_obj.add_last(symbol)
            i := i + 1
         end

         check
            spell.count = letters_obj.count
         end
         

         -- do the first letter differently

         from
            i := letters_obj.lower
std_output.put_string("get index for: ")
std_output.put_character(letters_obj.item(i).character.character_set_list.item(1).binary_code.codes.item(1))
std_output.put_new_line
            letter ?= letters_obj.item(i)
            if letter = Void then  -- not good
               std_error.put_string("NWOS_SPELLING.make first character of spelling is not a letter: ")
               std_error.put_string(letters_obj.item(i).identifier.to_string)
               std_error.put_new_line
            end
            index := letter.spelling_index  -- get the first level index
         until
            i = letters_obj.upper
         loop
            i := i + 1

            symbol := letters_obj.item(i)  -- next letter or apostrophe or hyphen

            next_index := index.item(symbol)

            if next_index = Void then  -- haven't created it yet
std_output.put_string("making new index for: ")
std_output.put_character(symbol.character.character_set_list.item(1).binary_code.codes.item(1))
std_output.put_new_line
               !!next_index.make(alphabet_obj, index)
               index.put(next_index, symbol)
            end

            index := next_index
         end

         index.put_spelling(Current)

         references_obj.add_last(index)
      end


feature {NONE}  -- actual storage

   alphabet_obj: like alphabet

   source_obj: like source

   letters_obj: like letters

   references_obj: like references


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.1 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_spelling_ref
      end


--invariant

--   alphabet /= Void
--   letters /= Void
--   references /= Void

end

