--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: reference_counter.e,v $
-- Revision 1.2  2006/12/05 04:25:38  jsedwards
-- Change so it starts at 2 instead of 1, because now the root object is 1
-- instead of the class reference class.
--
-- Revision 1.1  2006/10/28 15:09:14  jsedwards
-- Initial version.
--


class REFERENCE_COUNTER

feature

   next_reference: UNSIGNED is
      do
         counter.increment
         Result := counter.value.to_unsigned
      end

feature {NONE}

   counter: COUNTER is
      once
         !!Result
         Result.increment  -- start at 2
      end

end

