--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: spelling.e,v $
-- Revision 1.6  2006/11/02 13:50:57  jsedwards
-- Added "make_from_csv" feature to create object from cvs line.
--
-- Revision 1.5  2006/10/31 23:12:51  jsedwards
-- Add code to add each object to the class definition reference list.
--
-- Revision 1.4  2006/10/31 14:07:01  jsedwards
-- Added reference_lists.
--
-- Revision 1.3  2006/10/30 13:52:21  jsedwards
-- Change to verify that spelling doesn't already exist in all_spellings.
--
-- Revision 1.2  2006/10/30 13:19:52  jsedwards
-- Change to add itself to the "all_spellings" array.
--
-- Revision 1.1  2006/10/30 13:18:41  jsedwards
-- Initial version.
--


class SPELLING

inherit GLOBALS
        REFERENCE_COUNTER
        ANY
           redefine
              is_equal
           end

creation make, make_from_csv


feature

   reference: UNSIGNED

   reference_list: REFERENCE_LIST

   spelling: STRING

   make(letters: STRING) is
      do
         reference := next_reference

         !!reference_list.make

         !!spelling.copy(letters)
         spelling.to_lower

         check
            not all_spellings.has(Current)
         end

         all_spellings.add_last(Current)

         spelling_class_def.reference_list.add_reference(reference)
      end

   make_from_csv(line: STRING) is
      local
         dummy: UNSIGNED
      do
         reference := scan_reference(line)

         check_comma(line)

         skip_time(line)

         check_comma(line)

         dummy := scan_reference(line)   -- ignore class for now

         check_comma(line)

         dummy := scan_reference(line)   -- ignore refernce list for now

         check_comma(line)

         if line.first /= '"' then
            std_error.put_string("reading spelling - missing beginning %": ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         if line.last /= '"' then
            std_error.put_string("reading spelling - missing ending %": ")
            std_error.put_string(line)
            std_error.put_new_line
            die_with_code(exit_failure_code)
         end

         line.remove_first(1)
         line.remove_last(1)

         !!spelling.copy(line);
      end

   is_equal(other: like Current): BOOLEAN is
      do
         Result := spelling.is_equal(other.spelling)
      end

end



