/*             This file is part of the New World OS project
--                 Copyright (C) 2004-2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: crc32.h,v $
-- Revision 1.5  2006/12/01 14:39:22  jsedwards
-- Fix the year in the copyright.
--
-- Revision 1.4  2006/11/11 12:01:02  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.3  2005/12/10 15:03:35  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.2  2005/11/25 13:27:25  jsedwards
-- Changed names to include "nwos" prefix.
--
-- Revision 1.1.1.1  2005/11/25 12:44:27  jsedwards
-- Copied from 'lab'.
--
-- Revision 1.1  2005/11/23 20:26:43  jsedwards
-- Include file for crc32.c.
--
--
*/

#ifndef CRC32_H
#define CRC32_H

#include "types.h"

/* this should only be called once by main routine */
extern void nwos_crc32_initialize();
extern void nwos_crc32_calculate(uint8 *data, size_t length, uint8 crc32[4]);


#endif /* CRC32_H */
