--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_language.e,v $
-- Revision 1.1  2007/04/14 02:24:14  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.10  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.9  2006/02/20 05:37:35  jsedwards
-- Changed from "noun" to "proper noun" for reference.
--
-- Revision 1.8  2006/02/19 18:38:06  jsedwards
-- Changed atttributes to routines that make sure the current object is loaded
-- before returning any values.
--
-- Revision 1.7  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.6  2006/02/11 18:33:18  jsedwards
-- Changed the "name" attribute to "names", because it is an array and there
-- can be multiple.  Changed the two arrays from fixed arrays to just arrays.
-- Added a void reference after the names so it is easy to know when we are
-- at the end.  Filled in the "read body from stream" routine.
--
-- Revision 1.5  2006/02/10 13:52:26  jsedwards
-- Removed "load" from creation list.
--
-- Revision 1.4  2006/02/09 13:06:49  jsedwards
-- Added reference parameter to "initialize header" call and removed "next
-- identifier" feature that is now in nwos_header.  Changed to the new
-- method of doing the class defintion stuff, with the "class reference"
-- and "class revision".
--
-- Revision 1.3  2006/02/08 14:24:04  jsedwards
-- Added "load" to creation clause, a dummy read_body_from_stream routine,
-- and class reference to class definition "make" call.
--
-- Revision 1.2  2006/02/05 05:07:54  jsedwards
-- Changed so that name is an array instead of just one name, so that it can
-- accomidate names in multiple languages.
--
-- Revision 1.1  2006/02/05 04:40:27  jsedwards
-- Initial version.
--

class NWOS_LANGUAGE

inherit NWOS_OBJECT

creation make, make_unresolved


feature

   names: ARRAY[NWOS_WORD] is
      do
         load_if_not_already
         Result := names_obj
      ensure
         Result /= Void
      end

   references: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := references_obj
      ensure
         Result /= Void
      end


feature

   add_reference(ref: NWOS_OBJECT) is
      do
         references.add_last(ref)
      end

   add_name(ref: NWOS_WORD) is
      do
         names.add_last(ref)
      end


feature {NONE}

   make is
      do
         initialize_header(next_english_identifier)

         !!names_obj.with_capacity(16, 1)
         !!references_obj.with_capacity(32, 1)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         from
            i := names_obj.lower
         until
            i > names_obj.upper
         loop
            names_obj.item(i).class_definition.identifier.write_to_stream(stream)
            names_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         from
            i := references_obj.lower
         until
            i > references_obj.upper
         loop
            references_obj.item(i).class_definition.identifier.write_to_stream(stream)
            references_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end
         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
         word: NWOS_WORD
         obj: NWOS_OBJECT
      do
         !!names_obj.with_capacity(16, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            not class_ref.is_equal(Class_proper_noun_ref)
         loop
            !!object_ref.make_from_stream(stream)

std_output.put_string("NWOS_LANGUAGE.read_body_from_stream")
std_output.put_string("%N  name class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  name object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line

            word ?= object_ref.get_object(class_ref)

            if word = Void then
               std_error.put_string("Name of language is void%N")
               die_with_code(exit_failure_code)
            end

            names_obj.add_last(word)

            !!class_ref.make_from_stream(stream)
         end

         !!references_obj.with_capacity(16, 1)

         from
            -- class_ref already loaded from above loop
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)

std_output.put_string("NWOS_LANGUAGE.read_body_from_stream")
std_output.put_string("%N  object class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line

            obj := object_ref.get_object(class_ref)

            references_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      end


feature {NONE}  -- actual storage

   names_obj: like names

   references_obj: like references


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.1 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_language_ref
      end


end

