/*             This file is part of the New World OS project
--                 Copyright (C) 2004-2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: crc32.c,v $
-- Revision 1.1  2006/12/22 14:01:04  jsedwards
-- Copy of 0014 version from root directory.
--
-- Revision 1.6  2006/12/01 14:37:23  jsedwards
-- Fix the year in the copyright.
--
-- Revision 1.5  2006/11/11 12:01:02  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.4  2005/12/10 15:03:35  jsedwards
-- Fixed header to say the GPL is in the LICENSE file instead of COPYING.
--
-- Revision 1.3  2005/11/26 15:00:21  jsedwards
-- Removed "types" includes and just include crc32.h.
--
-- Revision 1.2  2005/11/25 13:27:25  jsedwards
-- Changed names to include "nwos" prefix.
--
-- Revision 1.1.1.1  2005/11/25 12:44:27  jsedwards
-- Copied from 'lab'.
--
-- Revision 1.4  2005/11/23 20:25:04  jsedwards
-- Changed add routine to static (not global) and 'length' parameter to
-- size_t type.
--
-- Revision 1.3  2004/11/03 14:27:17  jsedwards
-- Changed to always be non-partisan for endianess.  The result is always
--   big endian.
--
-- Revision 1.2  2004/11/03 13:27:05  jsedwards
-- Add 'crc32_add' routine.
--
-- Revision 1.1  2004/11/02 14:15:19  jsedwards
-- Initial version with table generation.
--
--
*/

#include "crc32.h"


#define POLYNOMIAL 0xEDB88320;
static uint8 table[256][4];


void nwos_crc32_initialize()
{
    int i, j;
    uint32 crc;

    for (i = 0; i < 256; i++) {
	crc = i;
      
	for(j = 0; j < 8; j++) {

            if ((crc & 1) != 0) {
                  crc = (crc >> 1) ^ POLYNOMIAL;
	    }
            else {
                  crc = (crc >> 1);
	    }
	}
      
	table[i][0] = (uint8) ((crc >> 24) & 0xFF);
	table[i][1] = (uint8) ((crc >> 16) & 0xFF);
	table[i][2] = (uint8) ((crc >>  8) & 0xFF);
	table[i][3] = (uint8) ((crc      ) & 0xFF);
    }
}


static void crc32_add(uint8 byte, uint8 crc32[4])
{
    int index = (int) (byte ^ crc32[3]);
    crc32[3] = crc32[2] ^ table[index][3];
    crc32[2] = crc32[1] ^ table[index][2];
    crc32[1] = crc32[0] ^ table[index][1];
    crc32[0] =            table[index][0];
}


void nwos_crc32_calculate(uint8 *data, size_t length, uint8 crc32[4])
{
    int i;

    crc32[0] = 0xFF;
    crc32[1] = 0xFF;
    crc32[2] = 0xFF;
    crc32[3] = 0xFF;

    for (i = 0; i < length; i++) {
	crc32_add(data[i], crc32);
    }
}

