/*             This file is part of the New World OS project
--                Copyright (C) 2005, 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file LICENSE.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- This program is a run once, never again.  It creates the 26 upper case
-- character objects, 26 lower case character objects, and 26 english letter
-- objects.
--
-- No one should ever have to run this program again, since those objects
-- now exist in the global/public database.
--
-- $Log: create_english_letters.c,v $
-- Revision 1.1  2007/06/03 12:28:19  jsedwards
-- Moved from root directory.
--
-- Revision 1.2  2006/11/11 12:01:03  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.1  2006/01/22 20:49:18  jsedwards
-- Run once app to create the english letters and associated ascii letters.
--
*/

#include <assert.h>
#include <stdio.h>
#include <string.h>   /* define memset */
#include <stdlib.h>

#include "objectify.h"
#include "c_structs.h"
#include "objectify_private.h"


#define LAST_BYTE_OBJ_REF (sizeof(ObjRef)-1)

int main()
{
    C_struct_Character char_object;
    C_struct_Letter letter_object;
    ObjRef lower_ref;
    ObjRef upper_ref;
    ObjRef letter_ref;     /* the reference for the english letter objects */
    int i;

    printf("Creating 52 (upper and lower case) ASCII letter objects...\n");

    nwos_copy_reference(lower_ref, Ascii_Chars_Ref);
    nwos_copy_reference(upper_ref, Ascii_Chars_Ref);
    nwos_copy_reference(letter_ref, English_Letters_Ref);

    for (i = 0; i < 26; i++)
    {
	upper_ref[LAST_BYTE_OBJ_REF] = Ascii_Chars_Ref[LAST_BYTE_OBJ_REF] + 'A' + i;
	lower_ref[LAST_BYTE_OBJ_REF] = Ascii_Chars_Ref[LAST_BYTE_OBJ_REF] + 'a' + i;
	letter_ref[LAST_BYTE_OBJ_REF] = English_Letters_Ref[LAST_BYTE_OBJ_REF] + i;

	memset(&char_object, 0, sizeof(char_object));

	nwos_fill_in_any(&char_object.any, Upper_Char_Class_Ref, User_Ref, Create_English_Letters_Ref);

	nwos_copy_reference(char_object.character, letter_ref);

	nwos_copy_reference(char_object.character_sets[0], Ascii_Char_Set_Ref);

	nwos_write_public_object_to_disk(upper_ref, &char_object, sizeof(char_object));

      /* same thing for lower case letters */

	memset(&char_object, 0, sizeof(char_object));

	nwos_fill_in_any(&char_object.any, Lower_Char_Class_Ref, User_Ref, Create_English_Letters_Ref);

	nwos_copy_reference(char_object.character, letter_ref);

	nwos_copy_reference(char_object.character_sets[0], Ascii_Char_Set_Ref);

	nwos_write_public_object_to_disk(lower_ref, &char_object, sizeof(char_object));

      /* finally do the english letters */

	memset(&letter_object, 0, sizeof(letter_object));

	nwos_fill_in_any(&letter_object.any, Letter_Class_Ref, User_Ref, Create_English_Letters_Ref);

	nwos_copy_reference(letter_object.alphabet, English_Alphabet_Ref);

	nwos_copy_reference(letter_object.lower_case, lower_ref);
	nwos_copy_reference(letter_object.upper_case, upper_ref);

	nwos_write_public_object_to_disk(letter_ref, &letter_object, sizeof(letter_object));
    }

    printf("Done!\n");

    return 0;
}

