--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_binary_code.e,v $
-- Revision 1.1  2007/04/14 02:24:10  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.22  2006/11/11 12:29:18  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.21  2006/02/20 14:21:10  jsedwards
-- Added "find_reference" feature.
--
-- Revision 1.20  2006/02/19 19:07:06  jsedwards
-- Wrapped debug print statement when object read in, in "debug" so they only
-- print when debug is passed to compiler.
--
-- Revision 1.19  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.18  2006/02/18 20:58:18  jsedwards
-- Changed attributes to routines that make sure the object is loaded before
-- returning the value.
--
-- Revision 1.17  2006/02/11 18:28:50  jsedwards
-- Changed "reference_list" attribute to "references".  Added a void reference
-- after the codes to mark the end (be consistent with other classes).  Filled
-- in the "read body from stream" routine.  Commented out the class invariant
-- because it fails when the object is made unresolved.
--
-- Revision 1.16  2006/02/10 13:55:34  jsedwards
-- Changed "load" in creation clause to "make_unresolved".
--
-- Revision 1.15  2006/02/09 13:02:23  jsedwards
-- Changed to the new method of doing the class defintion stuff, with the
-- "class reference" and "class revision".  Also added reference parameter
-- to initialize_header call.
--
-- Revision 1.14  2006/02/08 14:24:04  jsedwards
-- Added "load" to creation clause, a dummy read_body_from_stream routine,
-- and class reference to class definition "make" call.
--
-- Revision 1.13  2006/02/04 15:39:45  jsedwards
-- Moved reference back into predefined references.
--
-- Revision 1.12  2006/02/04 14:56:09  jsedwards
-- Changed from the class_ref to the deferred class_definition.
--
-- Revision 1.11  2006/02/04 03:43:26  jsedwards
-- Added "class ref" back in.
--
-- Revision 1.10  2006/02/03 14:24:45  jsedwards
-- Added "add reference" feature.
--
-- Revision 1.9  2006/02/03 03:10:30  jsedwards
-- Changed again to create the 256 single byte codes (Big_Bang_02).
--
-- Revision 1.8  2006/02/02 02:08:50  jsedwards
-- Removed maximum references calculation, next reference list, and code that
-- referenced them.
--
-- Revision 1.7  2006/01/31 19:31:08  jsedwards
-- Added new kludgy class definition stuff.
--
-- Revision 1.6  2006/01/29 18:05:40  jsedwards
-- Changed so that instead of redefining write_to_stream, there is a deferred
-- feature that writes the body of the object to stream.
--
-- Revision 1.5  2006/01/29 01:12:27  jsedwards
-- Changed bug so references are written to the stream instead of directly to
-- the output file.
--
-- Revision 1.4  2006/01/29 00:34:41  jsedwards
-- First working version.
--
-- Revision 1.3  2006/01/27 04:25:45  jsedwards
-- Added some initialization code, still incomplete.
--
-- Revision 1.2  2006/01/25 15:32:42  jsedwards
-- Still a work in progress.
--
-- Revision 1.1  2006/01/25 13:44:14  jsedwards
-- Incomplete version, saving in CVS as back up.
--


class NWOS_BINARY_CODE

inherit NWOS_OBJECT

creation make_1_byte, make_unresolved


feature

   Maximum_codes: INTEGER is 4;  -- The maximum length of a UTF8 character is 4 bytes

   codes: ARRAY[CHARACTER] is
      do
         load_if_not_already
         Result := codes_obj
      ensure
         Result /= Void
      end

   references: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := references_obj
      ensure
         Result /= Void
      end


feature

   add_reference(ref: NWOS_OBJECT) is
      do
         references.add_last(ref)
      ensure
         references_obj.fast_has(ref)
      end

   find_reference(class_ref: NWOS_REFERENCE): NWOS_OBJECT is
      local
         i: INTEGER
      do
         from
            i := references.lower
         until
            i > references.upper
               or else
            references.item(i).class_definition.identifier.is_equal(class_ref)
         loop
            i := i + 1
         end

         if i <= references.upper then
            Result := references.item(i)
         end
      end


feature {NONE}

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      require
         codes_obj.count /= 0
      local
         i: INTEGER
      do
         from
            i := codes_obj.lower
         variant
            codes_obj.upper - i
         until
            i > codes_obj.upper
         loop
            Class_uint8_ref.write_to_stream(stream)
            stream.put_character(codes_obj.item(i))
            i := i + 1
         end

         Void_reference.write_to_stream(stream)

         from
            i := references_obj.lower
         variant
            references_obj.upper - i
         until
            i > references_obj.upper
         loop
            references_obj.item(i).class_definition.identifier.write_to_stream(stream)
            references_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         obj: NWOS_OBJECT
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!codes_obj.with_capacity(Maximum_codes, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            class_ref.is_void
         loop
            if not class_ref.is_equal(Class_uint8_ref) then
               std_error.put_string("NWOS_BINARY_CODE.read_body_from_stream: not uint8 code%N")
               die_with_code(exit_failure_code)
            end
            stream.read_byte
            codes_obj.add_last(stream.last_byte)

            class_ref.read_from_stream(stream)
         end

         !!references_obj.with_capacity(4, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)
debug
std_output.put_string("NWOS_BINARY_CODE.read_body_from_stream")
std_output.put_string("%N  class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line
end
            obj := object_ref.get_object(class_ref)
            references_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      end

feature {NONE}

   make_1_byte(byte_1: CHARACTER) is
      do
         initialize_header(next_identifier)

         !!codes_obj.make(1,1)
         codes_obj.put(byte_1, 1)

         !!references_obj.with_capacity(1, 1)
      end

   make_2_byte(byte_1, byte_2: CHARACTER) is
      do
         initialize_header(next_identifier)

         !!codes_obj.make(1,2)
         codes_obj.put(byte_1, 1)
         codes_obj.put(byte_2, 2)

         !!references_obj.with_capacity(1, 1)
      end


feature {NONE}  -- actual values stored

   codes_obj: ARRAY[CHARACTER]

   references_obj: ARRAY[NWOS_OBJECT]


feature {NONE}

   next_identifier: NWOS_REFERENCE is
      do
         !!Result.copy(Binary_codes_ref)
         Binary_codes_ref.increment
      end

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.1 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_binary_code_ref
      end


--invariant

--   codes_obj /= Void and then codes.count <= Maximum_codes
--   references_obj /= Void

end

