--             This file is part of the New World OS project
--                   Copyright (C) 2006  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
-- NWOS is free software;  you can redistribute it and/or modify it under the
-- terms of the GNU General Public License  as published by the Free Software
-- Foundation; either version 2, or (at your option) any later version.  This
-- software is distributed with the hope that it will be useful,  but WITHOUT
-- ANY WARRANTY;  without  even the  implied warranty  of MERCHANTABILITY  or
-- FITNESS FOR A PARTICULAR PURPOSE.   See the GNU General Public License for
-- more  details.  You should have received a copy  of the GNU General Public
-- License along with this package;  see the file COPYING.  If not, write to:
--
--      Free Software Foundation, Inc.
--      59 Temple Place - Suite 330
--      Boston, MA 02111-1307, USA.
--
-- $Log: nwos_symbol.e,v $
-- Revision 1.1  2007/04/14 02:24:21  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.5  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.4  2006/02/20 05:01:39  jsedwards
-- Added feature to obtain the binary codes for this symbol.
--
-- Revision 1.3  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.2  2006/02/19 03:37:33  jsedwards
-- Fixed so that name and character objects get read instead of two character
-- objects.  Also changed attributes to routines that make sure the object is
-- loaded before returning object.
--
-- Revision 1.1  2006/02/13 04:41:54  jsedwards
-- Initial version.
--


class NWOS_SYMBOL

inherit NWOS_OBJECT

feature

   name: NWOS_NOUN is
      do
         load_if_not_already
         Result := name_obj
      ensure
         Result /= Void
      end

   character: NWOS_CHARACTER is
      do
         load_if_not_already
         Result := character_obj
      ensure
         Result /= Void
      end


feature

   to_codes(char_set_ref: NWOS_REFERENCE): ARRAY[CHARACTER] is
      do
         Result := character.to_binary_codes(char_set_ref)
      end


feature

   set_name(nm: like name) is
      require
         nm /= Void
--         name = Void
      do
         name_obj := nm
      end

   set_character(char: like character) is
      require
         char /= Void
--         character = Void
      do
         character_obj := char
      end


feature {NONE}

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      do
         name_obj.class_definition.identifier.write_to_stream(stream)
         name_obj.identifier.write_to_stream(stream)

         character_obj.class_definition.identifier.write_to_stream(stream)
         character_obj.identifier.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         name_obj ?= object_ref.get_object(class_ref)

         if name_obj = Void then
            std_error.put_string("NWOS_SYMBOL.read_body_from_stream: character name to load%N")
            die_with_code(exit_failure_code)
         end

         !!class_ref.make_from_stream(stream)
         !!object_ref.make_from_stream(stream)

         character_obj ?= object_ref.get_object(class_ref)

         if character_obj = Void then
            std_error.put_string("NWOS_SYMBOL.read_body_from_stream: character failed to load%N")
            die_with_code(exit_failure_code)
         end
      ensure
--         name_obj /= Void   -- letters don't have names
         character_obj /= Void
      end


feature {NONE}  -- actual storage

   name_obj: NWOS_NOUN

   character_obj: NWOS_CHARACTER


feature {NONE}

   make is
      do
         initialize_header(next_english_identifier)
      end

   make_with_name(nm: NWOS_NOUN) is
      do
         make
         set_name(nm)
      end


--invariant

--   alphabet /= Void

end

