/*
--             This file is part of the New World OS project
--                   Copyright (C) 2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: add_password.c,v $
-- Revision 1.6  2007/09/02 19:47:25  jsedwards
-- Added call to set the block estimate.
--
-- Revision 1.5  2007/08/13 00:34:51  jsedwards
-- Add call to allocate the chunk for the new password.
--
-- Revision 1.4  2007/08/12 20:45:00  jsedwards
-- Change all of the "Encryption Level" stuff to "Security Level" because it
-- doesn't really change the encryption at all, all it does is change the
-- randomization of where objects are stored.
--
-- Revision 1.3  2007/07/01 19:44:11  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.2  2007/02/11 16:58:26  jsedwards
-- Changed so DEFAULT_TYPE has to specify RO (Read-Only) or RW (Read-Write).
--
-- Revision 1.1  2007/01/17 13:57:11  jsedwards
-- Temporary kludge to add a pass phrase to existing system.
--
*/


#include <stdio.h>
#include <string.h>

#include "objectify_private.h"


static void set_public_root_object(ObjRef* ref)
{
    C_struct_Root root_obj;
    ObjRef verify_ref;

    nwos_read_object_from_disk(ref, &root_obj, sizeof(root_obj));
    copy_reference(&nwos_public_class_definition_class_ref, &root_obj.class_definition_class);
    copy_reference(&nwos_reference_list_class_ref, &root_obj.reference_list_class);

    assert(nwos_find_public_class_definition("REFERENCE LIST", &verify_ref));
    assert(is_same_object(&verify_ref, &nwos_reference_list_class_ref));
}


int main(int argc, char* argv[])
{
    ObjRef root_obj_ref;
    ObjRef private_root_obj_ref;
    ObjRef public_root_class_ref;
    uint8 big_key[16 + 8 + 4];
    uint8 bf_key[16];
    uint32 linear;
    uint32 serial;

    printf("\n");

    nwos_log_arguments(argc, argv);

    nwos_get_key_from_password(big_key, sizeof(big_key));

    memcpy(bf_key, big_key, 16);
    linear = ((uint32)big_key[16] << 24) | ((uint32)big_key[17] << 16) | ((uint32)big_key[18] << 8) | (uint32)big_key[19];
    memcpy(private_root_obj_ref.id, big_key+20, 4);
    serial = ((uint32)big_key[24] << 24) | ((uint32)big_key[25] << 16) | ((uint32)big_key[26] << 8) | (uint32)big_key[27];

    nwos_initialize_objectify(bf_key, linear, serial, DEFAULT_TYPE_RW, DEFAULT_FILE);

    nwos_allocate_new_chunk(nwos_ref_to_word(&private_root_obj_ref));

    root_obj_ref.id[0] = 0;
    root_obj_ref.id[1] = 0;
    root_obj_ref.id[2] = 0;
    root_obj_ref.id[3] = 1;

    set_public_root_object(&root_obj_ref);

    assert(nwos_find_public_class_definition("ROOT", &public_root_class_ref));


    /* create the private root object */

    nwos_set_security_level(Security_Extreme);
    nwos_set_block_estimate(3);

    printf("private root object id: %02x%02x%02x%02x\n", 
	   private_root_obj_ref.id[0],
	   private_root_obj_ref.id[1],
	   private_root_obj_ref.id[2],
	   private_root_obj_ref.id[3]);

    nwos_clone_class_definition(&nwos_public_class_definition_class_ref, &nwos_private_class_definition_class_ref);

    assert(nwos_create_root(&private_root_obj_ref));

    nwos_terminate_objectify();

    return 0;
}

