--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: nwos_class_definition.e,v $
-- Revision 1.2  2007/07/01 19:44:13  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.1  2007/04/14 02:24:12  jsedwards
-- Move Fine (Eiffel) files to next_gen directory.
--
-- Revision 1.22  2006/11/11 12:29:19  jsedwards
-- Update e-mail address to something that works.
--
-- Revision 1.21  2006/02/25 04:48:37  jsedwards
-- Added the "is_a" feature.
--
-- Revision 1.20  2006/02/19 19:07:06  jsedwards
-- Wrapped debug print statement when object read in, in "debug" so they only
-- print when debug is passed to compiler.
--
-- Revision 1.19  2006/02/19 18:09:40  jsedwards
-- Removed "load_all" feature that was no longer used.
--
-- Revision 1.18  2006/02/19 15:55:18  jsedwards
-- Changed the name of NWOS_HEADER to NWOS_OBJECT.
--
-- Revision 1.17  2006/02/18 15:44:39  jsedwards
-- Changed so attributes are routines that verify the objects have been loaded
-- before returning the actual object.
--
-- Revision 1.16  2006/02/11 18:39:52  jsedwards
-- Added "get_reference" feature to get the object from references list, and
-- make sure it is resolved (loaded).  Changed the call to reference "load"
-- to "get_object".
--
-- Revision 1.15  2006/02/11 04:52:08  jsedwards
-- Removed "once" class_ref and object_ref features and use a local variable
-- so that we don't have problems with recursion.
--
-- Revision 1.14  2006/02/10 20:17:10  jsedwards
-- Changed read_body_from_stream to read the new data format.
--
-- Revision 1.13  2006/02/10 13:52:26  jsedwards
-- Removed "load" from creation list.
--
-- Revision 1.12  2006/02/10 04:59:41  jsedwards
-- Added print statements for debugging.
--
-- Revision 1.11  2006/02/09 05:50:42  jsedwards
-- Changed so the revision of the class is passed in instead of searching
-- the source file.
--
-- Revision 1.10  2006/02/09 03:24:12  jsedwards
-- Added code to read the current class revision from the source file.
--
-- Revision 1.9  2006/02/08 14:30:11  jsedwards
-- Added read_body_from_stream routine, incomplete, kludged just to compile.
--
-- Revision 1.8  2006/02/05 03:23:45  jsedwards
-- Added print statement when class defintion object is created.
--
-- Revision 1.7  2006/02/04 14:52:43  jsedwards
-- Changed to use the CVS Id instead of the Name and Revision, because the
-- Name only gets filled in if the file is checked out explicitly by name.
--
-- Revision 1.6  2006/02/04 14:36:40  jsedwards
-- Fixed store_all routine to recursively call the other class definitions
-- correctly.
--
-- Revision 1.5  2006/02/04 14:27:30  jsedwards
-- Back to the plan where class defintions at this early stage are simply a
-- reference to the Eiffel file that defines the class.  Now having CVS insert
-- the Name and Release of the file.  This version is also the first version
-- that generates the class objects automatically when an object of that type
-- is created.  Finally added the store_all routine that goes down through the
-- class hierarchy to save all of the objects created during this session.
--
-- Revision 1.4  2006/02/03 13:28:52  jsedwards
-- Changed references to just an array (Big_Bang_02).
--
-- Revision 1.3  2006/02/02 06:07:10  jsedwards
-- Kludged version just used to create the class definition class object.
--
-- Revision 1.2  2006/01/31 19:29:36  jsedwards
-- Moved the kludgy class stuff to the end of the file instead of the
-- beginning, to be consistent with the other classes.
--
-- Revision 1.1  2006/01/31 14:12:25  jsedwards
-- Initial version.
--


class NWOS_CLASS_DEFINITION

inherit NWOS_OBJECT

creation make, make_unresolved


feature -- data variables

   name: STRING is
      do
         load_if_not_already
         Result := name_obj.to_string
      ensure
         Result /= Void
      end

   revision: STRING is
      do
         load_if_not_already
         Result := revision_obj.to_string
      ensure
         Result /= Void
      end

   references: ARRAY[NWOS_OBJECT] is
      do
         load_if_not_already
         Result := references_obj
      ensure
         Result /= Void
      end

   is_a: CLASS_DEFINITION is  -- parent class
      do
         if is_a_obj /= Void then
            load_if_not_already
            Result := is_a_obj
         end
      ensure
         is_a_obj /= Void implies Result /= Void
      end

feature

   add_reference(ref: NWOS_OBJECT) is
      do
         references.add_last(ref)
      end


feature {NWOS_BIG_BANG, NWOS_CLASS_DEFINITION}

   store_all(level: INTEGER) is  -- one time use feature to save all of the objects
      require
         level < 3
      local
         i: INTEGER
         class_def: NWOS_CLASS_DEFINITION
      do
std_output.put_string("store_all: ")
std_output.put_string(name)
std_output.put_new_line
std_output.flush
         from
            i := references_obj.lower
         until
            i > references_obj.upper
         loop
            references_obj.item(i).store

            class_def ?= references_obj.item(i)  -- is it a class definition object?
            if class_def /= Void then  -- this is a class defintion object
               if class_def /= Current then  -- don't call on the class definition object itself
                  class_def.store_all(level+1)  -- so have that class store all of it's objects as well
               end
            end
            i := i + 1
         end
      end


feature {NONE}

   make(ref: NWOS_REFERENCE; class_name, rev: STRING) is
      require
         class_name /= Void
         rev /= Void
      do
         std_output.put_string("NWOS_CLASS_DEFINITION.make(")
         std_output.put_string(ref.to_string)
         std_output.put_string(", ")

         !!name_obj.copy_from_string(class_name)

         std_output.put_string(name_obj.to_string)
         std_output.put_string(", ")

         !!revision_obj.copy_from_string(rev)

         std_output.put_string(revision_obj.to_string)
         std_output.put_string(")%N")
         std_output.flush

         !!references_obj.with_capacity(32, 1)

         initialize_header(ref)  -- do this after creating all of the objects in case we get called recursively

      ensure
         name_obj /= Void and then name_obj.to_string.is_equal(class_name)
         revision_obj /= Void and then revision_obj.to_string.is_equal(rev)
         references_obj /= Void
      end

   source_file: TEXT_FILE_READ is
      once
         !!Result.make(Void)
      end

   write_body_to_stream(stream: BINARY_OUTPUT_STREAM) is
      local
         i: INTEGER
      do
         name_obj.write_to_stream(stream)
         revision_obj.write_to_stream(stream)

         from
            i := references_obj.lower
         until
            i > references_obj.upper
         loop
            references_obj.item(i).class_definition.identifier.write_to_stream(stream)
            references_obj.item(i).identifier.write_to_stream(stream)
            i := i + 1
         end

         Void_reference.write_to_stream(stream)
      end

   read_body_from_stream(stream: BINARY_INPUT_STREAM) is
      local
         obj: NWOS_OBJECT
         class_ref: NWOS_REFERENCE
         object_ref: NWOS_REFERENCE
      do
debug
         std_output.put_string("CLASS_DEFINITION.read_body_from_stream%N")
end
         !!name_obj.read_from_stream(stream)

         !!revision_obj.read_from_stream(stream)
debug
std_output.put_string("NWOS_CLASS_DEFINITION.read_body_from_stream")
std_output.put_string("%N  name: ")
std_output.put_string(name)
std_output.put_string("%N  revision: ")
std_output.put_string(revision)
std_output.put_new_line
end
         !!references_obj.with_capacity(64, 1)

         from
            !!class_ref.make_from_stream(stream)
         until
            class_ref.is_void
         loop
            !!object_ref.make_from_stream(stream)
debug
std_output.put_string("NWOS_CLASS_DEFINITION.read_body_from_stream")
std_output.put_string("%N  class: ")
std_output.put_string(class_ref.to_string)
std_output.put_string("%N  object: ")
std_output.put_string(object_ref.to_string)
std_output.put_new_line
end
            obj := object_ref.get_object(class_ref)
            references_obj.add_last(obj)

            !!class_ref.make_from_stream(stream)
         end
      ensure
         name_obj /= Void
         revision_obj /= Void
         references_obj /= Void
      end


feature {NONE}  -- actual storage

   name_obj: NWOS_STRING

   revision_obj: NWOS_STRING

   references_obj: like references

   is_a_obj: like is_a


feature {NONE}  -- once again the kludgy class definition stuff

   class_revision: STRING is
      once
         !!Result.copy("$Revision: 1.2 $")
         Result.remove_prefix("$Revision: ")
         Result.remove_suffix(" $")
      end

   class_reference: NWOS_REFERENCE is
      do
         Result := Class_class_definition_ref
      end

end

