--
--             This file is part of the New World OS project
--                 Copyright (C) 2006-2007  QRW Software
--           J. Scott Edwards - j.scott.sedwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: reference_counter.e,v $
-- Revision 1.3  2007/07/01 19:44:13  jsedwards
-- Upgrade to GPLv3.
--
-- Revision 1.2  2006/12/05 04:25:38  jsedwards
-- Change so it starts at 2 instead of 1, because now the root object is 1
-- instead of the class reference class.
--
-- Revision 1.1  2006/10/28 15:09:14  jsedwards
-- Initial version.
--


class REFERENCE_COUNTER

feature

   next_reference: UNSIGNED is
      do
         counter.increment
         Result := counter.value.to_unsigned
      end

feature {NONE}

   counter: COUNTER is
      once
         !!Result
         Result.increment  -- start at 2
      end

end

