/*
--             This file is part of the New World OS project
--                 Copyright (C) 2004-2009  QRW Software
--           J. Scott Edwards - j.scott.edwards.nwos@gmail.com 
--                      http://www.qrwsoftware.com
--                      http://nwos.sourceforge.com
--
--   This program is free software: you can redistribute it and/or modify
--   it under the terms of the GNU General Public License as published by
--   the Free Software Foundation, either version 3 of the License, or
--   (at your option) any later version.
--
--   This program is distributed in the hope that it will be useful,
--   but WITHOUT ANY WARRANTY; without even the implied warranty of
--   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--   GNU General Public License for more details.
--
--   You should have received a copy of the GNU General Public License
--   along with this program, in the file LICENSE.  If not, see 
--   <http://www.gnu.org/licenses/>.
--
--   You can also contact me via paper mail at:
--
--      QRW Software
--      P.O. Box 27511
--      Salt Lake City, UT 84127-0511, USA.
--
--
-- $Log: class_definition.h,v $
-- Revision 1.2  2009/03/10 10:17:22  jsedwards
-- Moved MAX_CLASS_DEFINITION_SIZE and MAX_FEATURE_NAME_SIZE defines from
-- class_definition.c file and renamed with _OBJ_SIZE suffix instead of _SIZE.
--
-- Revision 1.1  2009/03/08 02:01:09  jsedwards
-- Initial version created by moving class definition related declarations
-- from the disk_io.h file.
--
*/

#ifndef CLASS_DEFINITION_H
#define CLASS_DEFINITION_H

#include "objectify.h"


#define MAX_CLASS_DEFINITION_OBJ_SIZE (sizeof(C_struct_Class_Definition) + sizeof(ObjRef) * 100)    /* for now assume 100 features max */
#define MAX_FEATURE_NAME_OBJ_SIZE     (sizeof(C_struct_Name) + sizeof(ObjRef) * 24)                 /* for now assume 24 words in a name max */


extern ObjRef nwos_public_class_definition_class_ref;
extern ObjRef nwos_private_class_definition_class_ref;
extern ObjRef nwos_reference_list_class_ref;

extern void nwos_create_class_definition(char* name_of_class);
extern void nwos_clone_class_definition(ObjRef* class_to_clone_ref, ObjRef* clone_ref);

#define NUM_FILE_CLASS_DEFINITIONS  3

extern ObjRef* nwos_get_file_001_reference();
extern ObjRef* nwos_get_file_002_reference();
extern ObjRef* nwos_get_file_class_reference();


#endif

